// Generated by gmmproc 2.39.93 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gstreamermm/buffer.h>
#include <gstreamermm/private/buffer_p.h>


/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdexcept>
#include <gst/gst.h>


namespace Gst
{

Glib::RefPtr<Gst::Buffer> Buffer::copy() const
{
  return Glib::wrap(gst_buffer_copy(gobj()), true);
}

Glib::RefPtr<Gst::Buffer> Buffer::create_writable()
{
  /*
   * This function is generally used in the following pattern:
   * RefPtr<Buffer> p = (...);
   * p = p->create_writable();
   *
   * There are two cases:
   * 1. object is not writable, therefore:
   *   - somebody else may have another reference to the object (but it this might change in the meantime)
   *   - gst_buffer_make_writable may return a new copy of object
   *   - we have to make additional ref, that will be unreffed in gst_buffer_make_writable
   * 2. object is_writable, then:
   *   - our caller has the only one reference to object (therefore nobody can increase refcount in the meantime)
   *   - gst_buffer_make_writable will return the same object and will not do any reffing/unreffing
   *   - we cannot make any additional refs before calling gst_buffer_make_writable, since it would enforce unnecessary
   *     copying of the object
   *   - we are supposed to create a new RefPtr with is own reference to the object, therefore we need to "take copy"
   *   - however when caller release the pointer (implicitly, during assignment) the refcount will be 1 again
   */
  if(is_writable())
  {
    return Glib::wrap(gst_buffer_make_writable(gobj()), true); // take copy so original object is left to the current owner (and hopefully will be released soon)
  }
  else
  {
    reference(); // gst_buffer_make_writable(buf) will unref the old buffer, but our caller is still holding RefPtr to it
    return Glib::wrap(gst_buffer_make_writable(gobj()));
  }
}

Glib::RefPtr<Gst::Buffer> Buffer::create(guint size)
{
  return Glib::wrap(gst_buffer_new_allocate(NULL, size, NULL));
}

} // namespace Gst

namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gst::BufferFlags>::value_type()
{
  return gst_buffer_flags_get_type();
}

// static
GType Glib::Value<Gst::BufferCopyFlags>::value_type()
{
  return gst_buffer_copy_flags_get_type();
}


/* Why reinterpret_cast<Buffer*>(gobject) is needed:
 *
 * A Buffer instance is in fact always a GstBuffer instance.
 * Unfortunately, GstBuffer cannot be a member of Buffer,
 * because it is an opaque struct.  Also, the C interface does not provide
 * any hooks to install a destroy notification handler, thus we cannot
 * wrap it dynamically either.
 *
 * The cast works because Buffer does not have any member data, and
 * it is impossible to derive from it.  This is ensured by not implementing
 * the (protected) default constructor.  The ctor is protected rather than
 * private just to avoid a compile warning.
 */

namespace Glib
{

Glib::RefPtr<Gst::Buffer> wrap(GstBuffer* object, bool take_copy)
{
  if(take_copy && object)
    gst_buffer_ref(object);

  // See the comment at the top of this file, if you want to know why the cast works.
  return Glib::RefPtr<Gst::Buffer>(reinterpret_cast<Gst::Buffer*>(object));
}

} // namespace Glib


namespace Gst
{


// static
Glib::RefPtr<Buffer> Buffer::create()
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return Glib::RefPtr<Buffer>(reinterpret_cast<Buffer*>(gst_buffer_new()));
}

void Buffer::reference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gst_buffer_ref(reinterpret_cast<GstBuffer*>(const_cast<Buffer*>(this)));
}

void Buffer::unreference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gst_buffer_unref(reinterpret_cast<GstBuffer*>(const_cast<Buffer*>(this)));
}

GstBuffer* Buffer::gobj()
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<GstBuffer*>(this);
}

const GstBuffer* Buffer::gobj() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<const GstBuffer*>(this);
}

GstBuffer* Buffer::gobj_copy() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  GstBuffer *const gobject = reinterpret_cast<GstBuffer*>(const_cast<Buffer*>(this));
  gst_buffer_ref(gobject);
  return gobject;
}


void Buffer::copy_into(Glib::RefPtr<Gst::Buffer> source_buffer, BufferCopyFlags flags, gsize offset, gsize size)
{
  gst_buffer_copy_into(gobj(), Glib::unwrap(source_buffer), ((GstBufferCopyFlags)(flags)), offset, size);
}

Glib::RefPtr<Gst::Memory> Buffer::get_memory(guint idx) const
{
  return Glib::wrap(gst_buffer_get_memory(const_cast<GstBuffer*>(gobj()), idx));
}

gsize Buffer::get_size() const
{
  return gst_buffer_get_size(const_cast<GstBuffer*>(gobj()));
}

Glib::RefPtr<Gst::Memory> Buffer::get_all_memory() const
{
  return Glib::wrap(gst_buffer_get_all_memory(const_cast<GstBuffer*>(gobj())));
}

gsize Buffer::fill(gsize offset, gconstpointer src, gsize size)
{
  return gst_buffer_fill(gobj(), offset, src, size);
}

Glib::RefPtr<Gst::Buffer> Buffer::append(const Glib::RefPtr<Gst::Buffer>& buf) const
{
  return Glib::wrap(gst_buffer_append(const_cast<GstBuffer*>(gobj()), Glib::unwrap(buf)));
}

Glib::RefPtr<Gst::Buffer> Buffer::append_region(const Glib::RefPtr<Gst::Buffer>& buf, gssize offset, gssize size) const
{
  return Glib::wrap(gst_buffer_append_region(const_cast<GstBuffer*>(gobj()), Glib::unwrap(buf), offset, size));
}

void Buffer::replace_memory_range(guint idx, gint length, Glib::RefPtr<Gst::Memory> mem)
{
  gst_buffer_replace_memory_range(gobj(), idx, length, Glib::unwrap(mem));
}

void Buffer::remove_memory(guint idx)
{
  gst_buffer_remove_memory(gobj(), idx);
}

void Buffer::remove_all_memory()
{
  gst_buffer_remove_all_memory(gobj());
}

gsize Buffer::memset(gsize offset, guint8 val, gsize size)
{
  return gst_buffer_memset(gobj(), offset, val, size);
}

void Buffer::replace_memory(guint idx, Glib::RefPtr<Gst::Memory> mem)
{
  gst_buffer_replace_memory(gobj(), idx, Glib::unwrap(mem));
}

gsize Buffer::extract(gsize offset, gpointer dest, gsize size)
{
  return gst_buffer_extract(gobj(), offset, dest, size);
}

int Buffer::memcmp(gsize offset, gconstpointer mem, gsize size)
{
  return gst_buffer_memcmp(gobj(), offset, mem, size);
}

 ClockTime Buffer::get_pts() const
{
  return ((ClockTime)(gobj()->pts));
}
 
 void Buffer::set_pts(const ClockTime& value)
{
  gobj()->pts = ((GstClockTime)(value));
}
 
 ClockTime Buffer::get_dts() const
{
  return ((ClockTime)(gobj()->dts));
}
 
 void Buffer::set_dts(const ClockTime& value)
{
  gobj()->dts = ((GstClockTime)(value));
}
 
 ClockTime Buffer::get_duration() const
{
  return ((ClockTime)(gobj()->duration));
}
 
 void Buffer::set_duration(const ClockTime& value)
{
  gobj()->duration = ((GstClockTime)(value));
}
 
bool Buffer::map(const Glib::RefPtr<Gst::MapInfo>& info, MapFlags flags)
{
  return gst_buffer_map(gobj(), info->gobj(), ((GstMapFlags)(flags)));
}

void Buffer::unmap(const Glib::RefPtr<Gst::MapInfo>& info)
{
  gst_buffer_unmap(gobj(), info->gobj());
}

 guint64 Buffer::get_offset() const
{
  return gobj()->offset;
}
 
 guint64 Buffer::get_offset_end() const
{
  return gobj()->offset_end;
}
 

} // namespace Gst


