// Generated by gmmproc 2.50.0 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_ALLOCATOR_H
#define _GSTREAMERMM_ALLOCATOR_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2014-2016 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Last reviewed on 2016-04-22 (1.8.0)
 */

#include <gstreamermm/object.h>
#include <gstreamermm/memory.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef struct _GstAllocationParams GstAllocationParams; }
#endif

#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GstAllocator = struct _GstAllocator;
using GstAllocatorClass = struct _GstAllocatorClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gst
{ class Allocator_Class; } // namespace Gst
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gst
{

/** Parameters to control the allocation of memory.
 */
class AllocationParams
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = AllocationParams;
  using BaseObjectType = GstAllocationParams;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type() G_GNUC_CONST;


  explicit AllocationParams(GstAllocationParams* gobject, bool make_a_copy = true);

  AllocationParams(const AllocationParams& other);
  AllocationParams& operator=(const AllocationParams& other);

  AllocationParams(AllocationParams&& other) noexcept;
  AllocationParams& operator=(AllocationParams&& other) noexcept;

  ~AllocationParams() noexcept;

  void swap(AllocationParams& other) noexcept;

  ///Provides access to the underlying C instance.
  GstAllocationParams*       gobj()       { return gobject_; }

  ///Provides access to the underlying C instance.
  const GstAllocationParams* gobj() const { return gobject_; }

  ///Provides access to the underlying C instance. The caller is responsible for freeing it. Use when directly setting fields in structs.
  GstAllocationParams* gobj_copy() const;

protected:
  GstAllocationParams* gobject_;

private:

  
public:
  

  AllocationParams();

  
  /** Initialize @a params to its default values
   */
  void init();

  MemoryFlags get_flags() const;
  void set_flags(const MemoryFlags& value);

  gsize get_align() const;
  void set_align(const gsize& value);

  gsize get_prefix() const;
  void set_prefix(const gsize& value);

  gsize get_padding() const;
  void set_padding(const gsize& value);


};

/** Allocate memory blocks.
 *
 * Memory is usually created by allocators with a alloc()
 * method call. When nullptr is used as the allocator, the default allocator will
 * be used.
 *
 * New allocators can be registered with register_allocator().
 * Allocators are identified by name and can be retrieved with
 * find(). set_default() can be used to change the
 * default allocator.
 */


class Allocator : public Gst::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = Allocator;
  using CppClassType = Allocator_Class;
  using BaseObjectType = GstAllocator;
  using BaseClassType = GstAllocatorClass;

  // noncopyable
  Allocator(const Allocator&) = delete;
  Allocator& operator=(const Allocator&) = delete;

private:  friend class Allocator_Class;
  static CppClassType allocator_class_;

protected:
  explicit Allocator(const Glib::ConstructParams& construct_params);
  explicit Allocator(GstAllocator* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  Allocator(Allocator&& src) noexcept;
  Allocator& operator=(Allocator&& src) noexcept;

  ~Allocator() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstAllocator*       gobj()       { return reinterpret_cast<GstAllocator*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstAllocator* gobj() const { return reinterpret_cast<GstAllocator*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstAllocator* gobj_copy();

private:


public:
  
  /** Find a previously registered allocator with @a name. When @a name is <tt>nullptr</tt>, the
   * default allocator will be returned.
   * 
   * @param name The name of the allocator.
   * @return A Gst::Allocator or <tt>nullptr</tt> when
   * the allocator with @a name was not registered. Use Gst::Object::unref()
   * to release the allocator after usage.
   */
  static Glib::RefPtr<Gst::Allocator> find(const Glib::ustring& name);
  
  /** Registers the memory @a allocator with @a name. This function takes ownership of
   *  @a allocator.
   * 
   * @param name The name of the allocator.
   * @param allocator Gst::Allocator.
   */
  static void register_allocator(const Glib::ustring& name, Glib::RefPtr<Gst::Allocator>&& allocator);
  
  /** Free @a memory that was previously allocated with alloc().
   * 
   * @param memory The memory to free.
   */
  void free(Glib::RefPtr<Gst::Memory>&& memory);
  
  /** Use @a allocator to allocate a new memory block with memory that is at least
   *  @a size big.
   * 
   * The optional @a params can specify the prefix and padding for the memory. If
   * <tt>nullptr</tt> is passed, no flags, no extra prefix/padding and a default alignment is
   * used.
   * 
   * The prefix/padding will be filled with 0 if flags contains
   * Gst::MEMORY_FLAG_ZERO_PREFIXED and Gst::MEMORY_FLAG_ZERO_PADDED respectively.
   * 
   * When @a allocator is <tt>nullptr</tt>, the default allocator will be used.
   * 
   * The alignment in @a params is given as a bitmask so that @a align + 1 equals
   * the amount of bytes to align to. For example, to align to 8 bytes,
   * use an alignment of 7.
   * 
   * @param size Size of the visible memory area.
   * @param params Optional parameters.
   * @return A new Gst::Memory.
   */
  Glib::RefPtr<Gst::Memory> alloc(gsize size, const Gst::AllocationParams& params);

  /// A alloc() convenience overload.
  Glib::RefPtr<Gst::Memory> alloc(gsize size);

  
  /** Set the default allocator. This function takes ownership of @a allocator.
   */

  void set_default();

  /**
   * Find default allocator.
   *
   * @return: default allocator.
   */
  static Glib::RefPtr<Gst::Allocator> get_default_allocator();

    virtual Glib::RefPtr<Gst::Memory> alloc_vfunc(gsize size, const Gst::AllocationParams& params);


  // This vfunc is hand-coded because it takes reference to a memory.
  // In generally, arguments are passed to a function by copy, so
  // custom wrapper is necessary.
  virtual void free_vfunc(Glib::RefPtr<Gst::Memory>&& memory);

protected:

  
public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};
}


namespace Gst
{

/** @relates Gst::AllocationParams
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 */
inline void swap(AllocationParams& lhs, AllocationParams& rhs) noexcept
  { lhs.swap(rhs); }

} // namespace Gst

namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gst::AllocationParams
 */
Gst::AllocationParams wrap(GstAllocationParams* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gst::AllocationParams> : public Glib::Value_Boxed<Gst::AllocationParams>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::Allocator
   */
  Glib::RefPtr<Gst::Allocator> wrap(GstAllocator* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_ALLOCATOR_H */

