// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_PRINTSETTINGS_H
#define _GTKMM_PRINTSETTINGS_H


#include <glibmm.h>

/* Copyright (C) 2006 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <gtkmm/enums.h>
#include <gtkmm/papersize.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkPrintSettings GtkPrintSettings;
typedef struct _GtkPrintSettingsClass GtkPrintSettingsClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class PrintSettings_Class; } // namespace Gtk
namespace Gtk
{

/** @addtogroup gtkmmEnums Enums and Flags */

/**
 * @ingroup gtkmmEnums
 */
enum PrintDuplex
{
  PRINT_DUPLEX_SIMPLEX,
  PRINT_DUPLEX_HORIZONTAL,
  PRINT_DUPLEX_VERTICAL
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::PrintDuplex> : public Glib::Value_Enum<Gtk::PrintDuplex>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum PrintQuality
{
  PRINT_QUALITY_LOW,
  PRINT_QUALITY_NORMAL,
  PRINT_QUALITY_HIGH,
  PRINT_QUALITY_DRAFT
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::PrintQuality> : public Glib::Value_Enum<Gtk::PrintQuality>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum PrintPages
{
  PRINT_PAGES_ALL,
  PRINT_PAGES_CURRENT,
  PRINT_PAGES_RANGES
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::PrintPages> : public Glib::Value_Enum<Gtk::PrintPages>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum PageSet
{
  PAGE_SET_ALL,
  PAGE_SET_EVEN,
  PAGE_SET_ODD
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::PageSet> : public Glib::Value_Enum<Gtk::PageSet>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


class PrintSettings : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef PrintSettings CppObjectType;
  typedef PrintSettings_Class CppClassType;
  typedef GtkPrintSettings BaseObjectType;
  typedef GtkPrintSettingsClass BaseClassType;

private:  friend class PrintSettings_Class;
  static CppClassType printsettings_class_;

private:
  // noncopyable
  PrintSettings(const PrintSettings&);
  PrintSettings& operator=(const PrintSettings&);

protected:
  explicit PrintSettings(const Glib::ConstructParams& construct_params);
  explicit PrintSettings(GtkPrintSettings* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~PrintSettings();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkPrintSettings*       gobj()       { return reinterpret_cast<GtkPrintSettings*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkPrintSettings* gobj() const { return reinterpret_cast<GtkPrintSettings*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkPrintSettings* gobj_copy();

private:

protected:
  PrintSettings();

public:
  
  static Glib::RefPtr<PrintSettings> create();


  /** Print settings keys.
   */
  class Keys
  {
  public:
    static const Glib::ustring PRINTER;
    static const Glib::ustring ORIENTATION;
    static const Glib::ustring PAPER_FORMAT;
    static const Glib::ustring PAPER_WIDTH;
    static const Glib::ustring PAPER_HEIGHT;
    static const Glib::ustring NUM_COPIES;
    static const Glib::ustring DEFAULT_SOURCE;
    static const Glib::ustring QUALITY;
    static const Glib::ustring RESOLUTION;
    static const Glib::ustring USE_COLOR;
    static const Glib::ustring DUPLEX;
    static const Glib::ustring COLLATE;
    static const Glib::ustring REVERSE;
    static const Glib::ustring MEDIA_TYPE;
    static const Glib::ustring DITHER;
    static const Glib::ustring SCALE;
    static const Glib::ustring PRINT_PAGES;
    static const Glib::ustring PAGE_RANGES;
    static const Glib::ustring PAGE_SET;
    static const Glib::ustring FINISHINGS;
    static const Glib::ustring NUMBER_UP;
    static const Glib::ustring OUTPUT_BIN;

    static const Glib::ustring OUTPUT_FILE_FORMAT;
    static const Glib::ustring OUTPUT_URI;

    static const Glib::ustring WIN32_DRIVER_VERSION;
    static const Glib::ustring WIN32_DRIVER_EXTRA;
  };

  
  //TODO: add a @see link?
  
  bool has_key(const Glib::ustring& key) const;

  
  Glib::ustring get(const Glib::ustring& key) const;

  
  void set(const Glib::ustring& key, const Glib::ustring& value);
  
  void unset(const Glib::ustring& key);

  /** For example, 
   * void on_foreach_setting(const Glib::ustring& key, const Glib::ustring& value);
   */
  typedef sigc::slot<void, Glib::ustring&, Glib::ustring&> SlotForeach;

  /** Calls a function for each print setting.
  * @param slot The callback to call for each print setting.
  */
  void setting_foreach(const SlotForeach& slot);

 
  bool get_bool(const Glib::ustring& key) const;
  
  void set_bool(const Glib::ustring& key, bool value = true);

  
  double get_double(const Glib::ustring& key) const;
  
  double get_double_with_default(const Glib::ustring& key, double def) const;
  
  void set_double(const Glib::ustring& key, double value);

  
  double get_length(const Glib::ustring& key, Unit unit) const;
  
  void set_length(const Glib::ustring& key, double value, Unit unit);

  
  int get_int(const Glib::ustring& key) const;
  
  int get_int_with_default(const Glib::ustring& key, int def) const;
  
  void set_int(const Glib::ustring& key, int value);

  // helpers:

  
  Glib::ustring get_printer() const;
  
  void set_printer(const Glib::ustring& name);

  
  PageOrientation get_orientation() const;
  
  void set_orientation(PageOrientation orientation);

  
  PaperSize get_paper_size();
  
  const PaperSize get_paper_size() const;
  
  void set_paper_size(const PaperSize& paper_size);

  
  double get_paper_width(Unit unit) const;
  
  void set_paper_width(double width, Unit unit);
  
  double get_paper_height(Unit unit) const;
  
  void set_paper_height(double height, Unit unit);

  
  bool get_use_color() const;
  
  void set_use_color(bool use_color = true);

  
  bool get_collate() const;
  
  void set_collate(bool collate = true);

  
  bool get_reverse() const;
  
  void set_reverse(bool reverse = true);

  
  PrintDuplex get_duplex() const;
  
  void set_duplex(PrintDuplex duplex);

  
  PrintQuality get_quality() const;
  
  void set_quality(PrintQuality quality);

  
  int get_n_copies() const;
  
  void set_n_copies(int num_copies);

  
  int get_number_up() const;
  
  void set_number_up(int number_up);

  
  int get_resolution() const;
  
  void set_resolution(int resolution);

  
  double get_scale() const;
  
  void set_scale(double scale);

  
  PrintPages get_print_pages() const;
  
  void set_print_pages(PrintPages print_pages);

  //TODO: What part of the C API does this correspond to?
  class PageRange
  {
  public:
    PageRange();
    PageRange(int start, int end);

    int start;
    int end;
  };

  Glib::ArrayHandle<PageRange> get_page_ranges() const;
  void set_page_ranges(const Glib::ArrayHandle<PageRange>& page_ranges);

  
  PageSet get_page_set() const;
  
  void set_page_set(PageSet page_set);

  
  Glib::ustring get_default_source() const;
  
  void set_default_source(const Glib::ustring& default_source);

  
  Glib::ustring get_media_type() const;
  
  void set_media_type(const Glib::ustring& media_type);

  
  Glib::ustring get_dither() const;
  
  void set_dither(const Glib::ustring& dither);

  
  Glib::ustring get_finishings() const;
  
  void set_finishings(const Glib::ustring& finishings);

  
  Glib::ustring get_output_bin() const;
  
  void set_output_bin(const Glib::ustring& output_bin);

  //TODO: Properties.


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::PrintSettings
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gtk::PrintSettings> wrap(GtkPrintSettings* object, bool take_copy = false);
}


#endif /* _GTKMM_PRINTSETTINGS_H */

