// Generated by gmmproc 2.51.2 -- DO NOT MODIFY!
#ifndef _GTKMM_CHECKBUTTON_H
#define _GTKMM_CHECKBUTTON_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gtkmm/togglebutton.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkCheckButton = struct _GtkCheckButton;
using GtkCheckButtonClass = struct _GtkCheckButtonClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class CheckButton_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{

/** Create widgets with a discrete toggle button.
 *
 * A Gtk::CheckButton places a discrete Gtk::ToggleButton next to a widget,
 * (usually a Gtk::Label).  See Gtk::ToggleButton widgets for more
 * information about toggle/check buttons.  The important signal,
 * signal_toggled() is also inherited from Gtk::ToggleButton.
 *
 * The CheckButton widget looks like this:
 * @image html checkbutton1.png
 *
 * @ingroup Widgets
 */

class CheckButton : public ToggleButton
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef CheckButton CppObjectType;
  typedef CheckButton_Class CppClassType;
  typedef GtkCheckButton BaseObjectType;
  typedef GtkCheckButtonClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  CheckButton(CheckButton&& src) noexcept;
  CheckButton& operator=(CheckButton&& src) noexcept;

  // noncopyable
  CheckButton(const CheckButton&) = delete;
  CheckButton& operator=(const CheckButton&) = delete;

  ~CheckButton() noexcept override;

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class CheckButton_Class;
  static CppClassType checkbutton_class_;

protected:
  explicit CheckButton(const Glib::ConstructParams& construct_params);
  explicit CheckButton(GtkCheckButton* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkCheckButton*       gobj()       { return reinterpret_cast<GtkCheckButton*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkCheckButton* gobj() const { return reinterpret_cast<GtkCheckButton*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:

public:

  /** Create an empty check button.
   * With an empty button, you can Gtk::Button::add() a widget such as a
   * Gtk::Image or Gtk::Box.
   *
   * If you just wish to add a Gtk::Label, you may want to use the
   * Gtk::CheckButton(const Glib::ustring& label) constructor directly
   * instead.
   */
  CheckButton();

  /** Create a check button with a label.
   * You won't be able to add a widget to this button since it already
   * contains a Gtk::Label
   */
  explicit CheckButton(const Glib::ustring& label, bool mnemonic = false);

  
  /** Sets whether the indicator part of the button is drawn. This is important for
   * cases where the check button should have the functinality of a check button,
   * but the visuals of a regular button, like in a Gtk::StackSwitcher.
   * 
   * @param draw_indicator Whether or not to draw the indicator part of the button.
   */
  void set_draw_indicator(bool draw_indicator =  true);
  
  /** Returns Whether or not the indicator part of the button gets drawn.
   * 
   * @return The value of the GtkCheckButton:draw-indicator property.
   */
  bool get_draw_indicator() const;
  
  /** If the user has selected a range of elements (such as some text or
   * spreadsheet cells) that are affected by a check button, and the
   * current values in that range are inconsistent, you may want to
   * display the toggle in an "in between" state. Normally you would
   * turn off the inconsistent state again if the user checks the
   * check button. This has to be done manually,
   * gtk_check_button_set_inconsistent only affects visual appearance,
   * not the semantics of the button.
   * 
   * @param inconsistent <tt>true</tt> if state is inconsistent.
   */
  void set_inconsistent(bool inconsistent =  true);
  
  /** @return <tt>true</tt> if @a check_button is currently in an 'in between' state,
   * <tt>false</tt> otherwise.
   */
  bool get_inconsistent() const;

  /** If the check button is in an “in between” state.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_inconsistent() ;

/** If the check button is in an “in between” state.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_inconsistent() const;

  /** If the indicator part of the button is displayed.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_draw_indicator() ;

/** If the indicator part of the button is displayed.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_draw_indicator() const;


};

} //namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::CheckButton
   */
  Gtk::CheckButton* wrap(GtkCheckButton* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_CHECKBUTTON_H */

