// Generated by gmmproc 2.51.2 -- DO NOT MODIFY!
#ifndef _GTKMM_ENUMS_H
#define _GTKMM_ENUMS_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * Copyright (C) 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glibmm/value.h>
#include <gtk/gtk.h>


namespace Gtk
{


/** @addtogroup gtkmmEnums gtkmm Enums and Flags */

/** 
 *  @var AccelFlags ACCEL_VISIBLE
 * Accelerator is visible.
 * 
 *  @var AccelFlags ACCEL_LOCKED
 * Accelerator not removable.
 * 
 *  @var AccelFlags ACCEL_MASK
 * Mask.
 * 
 *  @enum AccelFlags
 * 
 * Accelerator flags used with Gtk::AccelGroup::connect().
 *
 * @ingroup gtkmmEnums
 * @par Bitwise operators:
 * <tt>%AccelFlags operator|(AccelFlags, AccelFlags)</tt><br>
 * <tt>%AccelFlags operator&(AccelFlags, AccelFlags)</tt><br>
 * <tt>%AccelFlags operator^(AccelFlags, AccelFlags)</tt><br>
 * <tt>%AccelFlags operator~(AccelFlags)</tt><br>
 * <tt>%AccelFlags& operator|=(AccelFlags&, AccelFlags)</tt><br>
 * <tt>%AccelFlags& operator&=(AccelFlags&, AccelFlags)</tt><br>
 * <tt>%AccelFlags& operator^=(AccelFlags&, AccelFlags)</tt><br>
 */
enum AccelFlags
{
  ACCEL_VISIBLE = 1 << 0,
  ACCEL_LOCKED = 1 << 1,
  ACCEL_MASK = 0x07
};

/** @ingroup gtkmmEnums */
inline AccelFlags operator|(AccelFlags lhs, AccelFlags rhs)
  { return static_cast<AccelFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline AccelFlags operator&(AccelFlags lhs, AccelFlags rhs)
  { return static_cast<AccelFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline AccelFlags operator^(AccelFlags lhs, AccelFlags rhs)
  { return static_cast<AccelFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline AccelFlags operator~(AccelFlags flags)
  { return static_cast<AccelFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gtkmmEnums */
inline AccelFlags& operator|=(AccelFlags& lhs, AccelFlags rhs)
  { return (lhs = static_cast<AccelFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline AccelFlags& operator&=(AccelFlags& lhs, AccelFlags rhs)
  { return (lhs = static_cast<AccelFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline AccelFlags& operator^=(AccelFlags& lhs, AccelFlags rhs)
  { return (lhs = static_cast<AccelFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::AccelFlags> : public Glib::Value_Flags<Gtk::AccelFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var Align ALIGN_FILL
 * Stretch to fill all space if possible, center if
 * no meaningful way to stretch.
 * 
 *  @var Align ALIGN_START
 * Snap to left or top side, leaving space on right
 * or bottom.
 * 
 *  @var Align ALIGN_END
 * Snap to right or bottom side, leaving space on left
 * or top.
 * 
 *  @var Align ALIGN_CENTER
 * Center natural width of widget inside the
 * allocation.
 * 
 *  @var Align ALIGN_BASELINE
 * Align the widget according to the baseline. @newin{3,10}
 * 
 *  @enum Align
 * 
 * Controls how a widget deals with extra space in a single (x or y)
 * dimension.
 * 
 * Alignment only matters if the widget receives a “too large” allocation,
 * for example if you packed the widget with the Gtk::Widget::property_expand()
 * flag inside a Gtk::Box, then the widget might get extra space.  If
 * you have for example a 16x16 icon inside a 32x32 space, the icon
 * could be scaled and stretched, it could be centered, or it could be
 * positioned to one side of the space.
 * 
 * Note that in horizontal context @a GTK_ALIGN_START and @a GTK_ALIGN_END
 * are interpreted relative to text direction.
 * 
 * GTK_ALIGN_BASELINE support for it is optional for containers and widgets, and
 * it is only supported for vertical alignment.  When its not supported by
 * a child or a container it is treated as @a GTK_ALIGN_FILL.
 *
 * @ingroup gtkmmEnums
 */
enum Align
{
  ALIGN_FILL,
  ALIGN_START,
  ALIGN_END,
  ALIGN_CENTER,
  ALIGN_BASELINE
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::Align> : public Glib::Value_Enum<Gtk::Align>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var ArrowType ARROW_UP
 * Represents an upward pointing arrow.
 * 
 *  @var ArrowType ARROW_DOWN
 * Represents a downward pointing arrow.
 * 
 *  @var ArrowType ARROW_LEFT
 * Represents a left pointing arrow.
 * 
 *  @var ArrowType ARROW_RIGHT
 * Represents a right pointing arrow.
 * 
 *  @var ArrowType ARROW_NONE
 * No arrow. @newin{2,10}
 * 
 *  @enum ArrowType
 * 
 * Used to indicate the direction in which an arrow should point.
 *
 * @ingroup gtkmmEnums
 */
enum ArrowType
{
  ARROW_UP,
  ARROW_DOWN,
  ARROW_LEFT,
  ARROW_RIGHT,
  ARROW_NONE
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ArrowType> : public Glib::Value_Enum<Gtk::ArrowType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var ButtonBoxStyle BUTTONBOX_SPREAD
 * Buttons are evenly spread across the box.
 * 
 *  @var ButtonBoxStyle BUTTONBOX_EDGE
 * Buttons are placed at the edges of the box.
 * 
 *  @var ButtonBoxStyle BUTTONBOX_START
 * Buttons are grouped towards the start of the box,
 * (on the left for a HBox, or the top for a VBox).
 * 
 *  @var ButtonBoxStyle BUTTONBOX_END
 * Buttons are grouped towards the end of the box,
 * (on the right for a HBox, or the bottom for a VBox).
 * 
 *  @var ButtonBoxStyle BUTTONBOX_CENTER
 * Buttons are centered in the box. @newin{2,12}
 * 
 *  @var ButtonBoxStyle BUTTONBOX_EXPAND
 * Buttons expand to fill the box. This entails giving
 * buttons a "linked" appearance, making button sizes homogeneous, and
 * setting spacing to 0 (same as calling Gtk::Box::set_homogeneous() and
 * Gtk::Box::set_spacing() manually). @newin{3,12}
 * 
 *  @enum ButtonBoxStyle
 * 
 * Used to dictate the style that a Gtk::ButtonBox uses to layout the buttons it
 * contains.
 *
 * @ingroup gtkmmEnums
 */
enum ButtonBoxStyle
{
  BUTTONBOX_SPREAD = 1,
  BUTTONBOX_EDGE,
  BUTTONBOX_START,
  BUTTONBOX_END,
  BUTTONBOX_CENTER,
  BUTTONBOX_EXPAND
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ButtonBoxStyle> : public Glib::Value_Enum<Gtk::ButtonBoxStyle>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var DeleteType DELETE_CHARS
 * Delete characters.
 * 
 *  @var DeleteType DELETE_WORD_ENDS
 * Delete only the portion of the word to the
 * left/right of cursor if we’re in the middle of a word.
 * 
 *  @var DeleteType DELETE_WORDS
 * Delete words.
 * 
 *  @var DeleteType DELETE_DISPLAY_LINES
 * Delete display-lines. Display-lines
 * refers to the visible lines, with respect to to the current line
 * breaks. As opposed to paragraphs, which are defined by line
 * breaks in the input.
 * 
 *  @var DeleteType DELETE_DISPLAY_LINE_ENDS
 * Delete only the portion of the
 * display-line to the left/right of cursor.
 * 
 *  @var DeleteType DELETE_PARAGRAPH_ENDS
 * Delete to the end of the
 * paragraph. Like C-k in Emacs (or its reverse).
 * 
 *  @var DeleteType DELETE_PARAGRAPHS
 * Delete entire line. Like C-k in pico.
 * 
 *  @var DeleteType DELETE_WHITESPACE
 * Delete only whitespace. Like M-\\ in Emacs.
 * 
 *  @enum DeleteType
 * 
 * See also: Gtk::Entry::signal_delete_from_cursor().
 *
 * @ingroup gtkmmEnums
 */
enum DeleteType
{
  DELETE_CHARS,
  DELETE_WORD_ENDS,
  DELETE_WORDS,
  DELETE_DISPLAY_LINES,
  DELETE_DISPLAY_LINE_ENDS,
  DELETE_PARAGRAPH_ENDS,
  DELETE_PARAGRAPHS,
  DELETE_WHITESPACE
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::DeleteType> : public Glib::Value_Enum<Gtk::DeleteType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var DirectionType DIR_TAB_FORWARD
 * Move forward.
 * 
 *  @var DirectionType DIR_TAB_BACKWARD
 * Move backward.
 * 
 *  @var DirectionType DIR_UP
 * Move up.
 * 
 *  @var DirectionType DIR_DOWN
 * Move down.
 * 
 *  @var DirectionType DIR_LEFT
 * Move left.
 * 
 *  @var DirectionType DIR_RIGHT
 * Move right.
 * 
 *  @enum DirectionType
 * 
 * Focus movement types.
 *
 * @ingroup gtkmmEnums
 */
enum DirectionType
{
  DIR_TAB_FORWARD,
  DIR_TAB_BACKWARD,
  DIR_UP,
  DIR_DOWN,
  DIR_LEFT,
  DIR_RIGHT
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::DirectionType> : public Glib::Value_Enum<Gtk::DirectionType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var BuiltinIconSize ICON_SIZE_INVALID
 * Invalid size.
 * 
 *  @var BuiltinIconSize ICON_SIZE_MENU
 * Size appropriate for menus (16px).
 * 
 *  @var BuiltinIconSize ICON_SIZE_SMALL_TOOLBAR
 * Size appropriate for small toolbars (16px).
 * 
 *  @var BuiltinIconSize ICON_SIZE_LARGE_TOOLBAR
 * Size appropriate for large toolbars (24px).
 * 
 *  @var BuiltinIconSize ICON_SIZE_BUTTON
 * Size appropriate for buttons (16px).
 * 
 *  @var BuiltinIconSize ICON_SIZE_DND
 * Size appropriate for drag and drop (32px).
 * 
 *  @var BuiltinIconSize ICON_SIZE_DIALOG
 * Size appropriate for dialogs (48px).
 * 
 *  @enum BuiltinIconSize
 * 
 * Built-in stock icon sizes.
 *
 * @ingroup gtkmmEnums
 */
enum BuiltinIconSize
{
  ICON_SIZE_INVALID,
  ICON_SIZE_MENU,
  ICON_SIZE_SMALL_TOOLBAR,
  ICON_SIZE_LARGE_TOOLBAR,
  ICON_SIZE_BUTTON,
  ICON_SIZE_DND,
  ICON_SIZE_DIALOG
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::BuiltinIconSize> : public Glib::Value_Enum<Gtk::BuiltinIconSize>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var TextDirection TEXT_DIR_NONE
 * No direction.
 * 
 *  @var TextDirection TEXT_DIR_LTR
 * Left to right text direction.
 * 
 *  @var TextDirection TEXT_DIR_RTL
 * Right to left text direction.
 * 
 *  @enum TextDirection
 * 
 * Reading directions for text.
 *
 * @ingroup gtkmmEnums
 */
enum TextDirection
{
  TEXT_DIR_NONE,
  TEXT_DIR_LTR,
  TEXT_DIR_RTL
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::TextDirection> : public Glib::Value_Enum<Gtk::TextDirection>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var Justification JUSTIFY_LEFT
 * The text is placed at the left edge of the label.
 * 
 *  @var Justification JUSTIFY_RIGHT
 * The text is placed at the right edge of the label.
 * 
 *  @var Justification JUSTIFY_CENTER
 * The text is placed in the center of the label.
 * 
 *  @var Justification JUSTIFY_FILL
 * The text is placed is distributed across the label.
 * 
 *  @enum Justification
 * 
 * Used for justifying the text inside a Gtk::Label widget. (See also
 * Gtk::Alignment).
 *
 * @ingroup gtkmmEnums
 */
enum Justification
{
  JUSTIFY_LEFT,
  JUSTIFY_RIGHT,
  JUSTIFY_CENTER,
  JUSTIFY_FILL
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::Justification> : public Glib::Value_Enum<Gtk::Justification>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var MenuDirectionType MENU_DIR_PARENT
 * To the parent menu shell.
 * 
 *  @var MenuDirectionType MENU_DIR_CHILD
 * To the submenu, if any, associated with the item.
 * 
 *  @var MenuDirectionType MENU_DIR_NEXT
 * To the next menu item.
 * 
 *  @var MenuDirectionType MENU_DIR_PREV
 * To the previous menu item.
 * 
 *  @enum MenuDirectionType
 * 
 * An enumeration representing directional movements within a menu.
 *
 * @ingroup gtkmmEnums
 */
enum MenuDirectionType
{
  MENU_DIR_PARENT,
  MENU_DIR_CHILD,
  MENU_DIR_NEXT,
  MENU_DIR_PREV
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::MenuDirectionType> : public Glib::Value_Enum<Gtk::MenuDirectionType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var MessageType MESSAGE_INFO
 * Informational message.
 * 
 *  @var MessageType MESSAGE_WARNING
 * Non-fatal warning message.
 * 
 *  @var MessageType MESSAGE_QUESTION
 * Question requiring a choice.
 * 
 *  @var MessageType MESSAGE_ERROR
 * Fatal error message.
 * 
 *  @var MessageType MESSAGE_OTHER
 * None of the above.
 * 
 *  @enum MessageType
 * 
 * The type of message being displayed in the dialog.
 *
 * @ingroup gtkmmEnums
 */
enum MessageType
{
  MESSAGE_INFO,
  MESSAGE_WARNING,
  MESSAGE_QUESTION,
  MESSAGE_ERROR,
  MESSAGE_OTHER
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::MessageType> : public Glib::Value_Enum<Gtk::MessageType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var MovementStep MOVEMENT_LOGICAL_POSITIONS
 * Move forward or back by graphemes.
 * 
 *  @var MovementStep MOVEMENT_VISUAL_POSITIONS
 * Move left or right by graphemes.
 * 
 *  @var MovementStep MOVEMENT_WORDS
 * Move forward or back by words.
 * 
 *  @var MovementStep MOVEMENT_DISPLAY_LINES
 * Move up or down lines (wrapped lines).
 * 
 *  @var MovementStep MOVEMENT_DISPLAY_LINE_ENDS
 * Move to either end of a line.
 * 
 *  @var MovementStep MOVEMENT_PARAGRAPHS
 * Move up or down paragraphs (newline-ended lines).
 * 
 *  @var MovementStep MOVEMENT_PARAGRAPH_ENDS
 * Move to either end of a paragraph.
 * 
 *  @var MovementStep MOVEMENT_PAGES
 * Move by pages.
 * 
 *  @var MovementStep MOVEMENT_BUFFER_ENDS
 * Move to ends of the buffer.
 * 
 *  @var MovementStep MOVEMENT_HORIZONTAL_PAGES
 * Move horizontally by pages.
 * 
 *  @enum MovementStep
 *
 * @ingroup gtkmmEnums
 */
enum MovementStep
{
  MOVEMENT_LOGICAL_POSITIONS,
  MOVEMENT_VISUAL_POSITIONS,
  MOVEMENT_WORDS,
  MOVEMENT_DISPLAY_LINES,
  MOVEMENT_DISPLAY_LINE_ENDS,
  MOVEMENT_PARAGRAPHS,
  MOVEMENT_PARAGRAPH_ENDS,
  MOVEMENT_PAGES,
  MOVEMENT_BUFFER_ENDS,
  MOVEMENT_HORIZONTAL_PAGES
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::MovementStep> : public Glib::Value_Enum<Gtk::MovementStep>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var Orientation ORIENTATION_HORIZONTAL
 * The element is in horizontal orientation.
 * 
 *  @var Orientation ORIENTATION_VERTICAL
 * The element is in vertical orientation.
 * 
 *  @enum Orientation
 * 
 * Represents the orientation of widgets and other objects which can be switched
 * between horizontal and vertical orientation on the fly, like Gtk::Toolbar or
 * Gtk::GesturePan.
 *
 * @ingroup gtkmmEnums
 */
enum Orientation
{
  ORIENTATION_HORIZONTAL,
  ORIENTATION_VERTICAL
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::Orientation> : public Glib::Value_Enum<Gtk::Orientation>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var CornerType CORNER_TOP_LEFT
 * Place the scrollbars on the right and bottom of the
 * widget (default behaviour).
 * 
 *  @var CornerType CORNER_BOTTOM_LEFT
 * Place the scrollbars on the top and right of the
 * widget.
 * 
 *  @var CornerType CORNER_TOP_RIGHT
 * Place the scrollbars on the left and bottom of the
 * widget.
 * 
 *  @var CornerType CORNER_BOTTOM_RIGHT
 * Place the scrollbars on the top and left of the
 * widget.
 * 
 *  @enum CornerType
 * 
 * Specifies which corner a child widget should be placed in when packed into
 * a Gtk::ScrolledWindow. This is effectively the opposite of where the scroll
 * bars are placed.
 *
 * @ingroup gtkmmEnums
 */
enum CornerType
{
  CORNER_TOP_LEFT,
  CORNER_BOTTOM_LEFT,
  CORNER_TOP_RIGHT,
  CORNER_BOTTOM_RIGHT
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::CornerType> : public Glib::Value_Enum<Gtk::CornerType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var PackType PACK_START
 * The child is packed into the start of the box.
 * 
 *  @var PackType PACK_END
 * The child is packed into the end of the box.
 * 
 *  @enum PackType
 * 
 * Represents the packing location Gtk::Box children. (See: Gtk::VBox,
 * Gtk::HBox, and Gtk::ButtonBox).
 *
 * @ingroup gtkmmEnums
 */
enum PackType
{
  PACK_START,
  PACK_END
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::PackType> : public Glib::Value_Enum<Gtk::PackType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var PlacesOpenFlags PLACES_OPEN_NORMAL
 * This is the default mode that Gtk::PlacesSidebar uses if no other flags
 * are specified.  It indicates that the calling application should open the selected location
 * in the normal way, for example, in the folder view beside the sidebar.
 * 
 *  @var PlacesOpenFlags PLACES_OPEN_NEW_TAB
 * When passed to Gtk::PlacesSidebar::set_open_flags(), this indicates
 * that the application can open folders selected from the sidebar in new tabs.  This value
 * will be passed to the Gtk::PlacesSidebar::signal_open_location() signal when the user selects
 * that a location be opened in a new tab instead of in the standard fashion.
 * 
 *  @var PlacesOpenFlags PLACES_OPEN_NEW_WINDOW
 * Similar to @a GTK_PLACES_OPEN_NEW_TAB, but indicates that the application
 * can open folders in new windows.
 * 
 *  @enum PlacesOpenFlags
 * 
 * These flags serve two purposes.  First, the application can call Gtk::PlacesSidebar::set_open_flags()
 * using these flags as a bitmask.  This tells the sidebar that the application is able to open
 * folders selected from the sidebar in various ways, for example, in new tabs or in new windows in
 * addition to the normal mode.
 * 
 * Second, when one of these values gets passed back to the application in the
 * Gtk::PlacesSidebar::signal_open_location() signal, it means that the application should
 * open the selected location in the normal way, in a new tab, or in a new
 * window.  The sidebar takes care of determining the desired way to open the location,
 * based on the modifier keys that the user is pressing at the time the selection is made.
 * 
 * If the application never calls Gtk::PlacesSidebar::set_open_flags(), then the sidebar will only
 * use Gtk::PLACES_OPEN_NORMAL in the Gtk::PlacesSidebar::signal_open_location() signal.  This is the
 * default mode of operation.
 *
 * @ingroup gtkmmEnums
 * @par Bitwise operators:
 * <tt>%PlacesOpenFlags operator|(PlacesOpenFlags, PlacesOpenFlags)</tt><br>
 * <tt>%PlacesOpenFlags operator&(PlacesOpenFlags, PlacesOpenFlags)</tt><br>
 * <tt>%PlacesOpenFlags operator^(PlacesOpenFlags, PlacesOpenFlags)</tt><br>
 * <tt>%PlacesOpenFlags operator~(PlacesOpenFlags)</tt><br>
 * <tt>%PlacesOpenFlags& operator|=(PlacesOpenFlags&, PlacesOpenFlags)</tt><br>
 * <tt>%PlacesOpenFlags& operator&=(PlacesOpenFlags&, PlacesOpenFlags)</tt><br>
 * <tt>%PlacesOpenFlags& operator^=(PlacesOpenFlags&, PlacesOpenFlags)</tt><br>
 */
enum PlacesOpenFlags
{
  PLACES_OPEN_NORMAL = 1 << 0,
  PLACES_OPEN_NEW_TAB = 1 << 1,
  PLACES_OPEN_NEW_WINDOW = 1 << 2
};

/** @ingroup gtkmmEnums */
inline PlacesOpenFlags operator|(PlacesOpenFlags lhs, PlacesOpenFlags rhs)
  { return static_cast<PlacesOpenFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline PlacesOpenFlags operator&(PlacesOpenFlags lhs, PlacesOpenFlags rhs)
  { return static_cast<PlacesOpenFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline PlacesOpenFlags operator^(PlacesOpenFlags lhs, PlacesOpenFlags rhs)
  { return static_cast<PlacesOpenFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline PlacesOpenFlags operator~(PlacesOpenFlags flags)
  { return static_cast<PlacesOpenFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gtkmmEnums */
inline PlacesOpenFlags& operator|=(PlacesOpenFlags& lhs, PlacesOpenFlags rhs)
  { return (lhs = static_cast<PlacesOpenFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline PlacesOpenFlags& operator&=(PlacesOpenFlags& lhs, PlacesOpenFlags rhs)
  { return (lhs = static_cast<PlacesOpenFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline PlacesOpenFlags& operator^=(PlacesOpenFlags& lhs, PlacesOpenFlags rhs)
  { return (lhs = static_cast<PlacesOpenFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::PlacesOpenFlags> : public Glib::Value_Flags<Gtk::PlacesOpenFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var PolicyType POLICY_ALWAYS
 * The scrollbar is always visible. The view size is
 * independent of the content.
 * 
 *  @var PolicyType POLICY_AUTOMATIC
 * The scrollbar will appear and disappear as necessary.
 * For example, when all of a Gtk::TreeView can not be seen.
 * 
 *  @var PolicyType POLICY_NEVER
 * The scrollbar should never appear. In this mode the
 * content determines the size.
 * 
 *  @var PolicyType POLICY_EXTERNAL
 * Don't show a scrollbar, but don't force the
 * size to follow the content. This can be used e.g. to make multiple
 * scrolled windows share a scrollbar. @newin{3,16}
 * 
 *  @enum PolicyType
 * 
 * Determines how the size should be computed to achieve the one of the
 * visibility mode for the scrollbars.
 *
 * @ingroup gtkmmEnums
 */
enum PolicyType
{
  POLICY_ALWAYS,
  POLICY_AUTOMATIC,
  POLICY_NEVER,
  POLICY_EXTERNAL
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::PolicyType> : public Glib::Value_Enum<Gtk::PolicyType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var PositionType POS_LEFT
 * The feature is at the left edge.
 * 
 *  @var PositionType POS_RIGHT
 * The feature is at the right edge.
 * 
 *  @var PositionType POS_TOP
 * The feature is at the top edge.
 * 
 *  @var PositionType POS_BOTTOM
 * The feature is at the bottom edge.
 * 
 *  @enum PositionType
 * 
 * Describes which edge of a widget a certain feature is positioned at, e.g. the
 * tabs of a Gtk::Notebook, the handle of a Gtk::HandleBox or the label of a
 * Gtk::Scale.
 *
 * @ingroup gtkmmEnums
 */
enum PositionType
{
  POS_LEFT,
  POS_RIGHT,
  POS_TOP,
  POS_BOTTOM
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::PositionType> : public Glib::Value_Enum<Gtk::PositionType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var ReliefStyle RELIEF_NORMAL
 * Draw a normal relief.
 * 
 *  @var ReliefStyle RELIEF_NONE
 * No relief.
 * 
 *  @enum ReliefStyle
 * 
 * Indicated the relief to be drawn around a Gtk::Button.
 *
 * @ingroup gtkmmEnums
 */
enum ReliefStyle
{
  RELIEF_NORMAL,
  RELIEF_NONE
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ReliefStyle> : public Glib::Value_Enum<Gtk::ReliefStyle>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var RevealerTransitionType REVEALER_TRANSITION_TYPE_NONE
 * No transition.
 * 
 *  @var RevealerTransitionType REVEALER_TRANSITION_TYPE_CROSSFADE
 * Fade in.
 * 
 *  @var RevealerTransitionType REVEALER_TRANSITION_TYPE_SLIDE_RIGHT
 * Slide in from the left.
 * 
 *  @var RevealerTransitionType REVEALER_TRANSITION_TYPE_SLIDE_LEFT
 * Slide in from the right.
 * 
 *  @var RevealerTransitionType REVEALER_TRANSITION_TYPE_SLIDE_UP
 * Slide in from the bottom.
 * 
 *  @var RevealerTransitionType REVEALER_TRANSITION_TYPE_SLIDE_DOWN
 * Slide in from the top.
 * 
 *  @enum RevealerTransitionType
 * 
 * These enumeration values describe the possible transitions
 * when the child of a Gtk::Revealer widget is shown or hidden.
 *
 * @ingroup gtkmmEnums
 */
enum RevealerTransitionType
{
  REVEALER_TRANSITION_TYPE_NONE,
  REVEALER_TRANSITION_TYPE_CROSSFADE,
  REVEALER_TRANSITION_TYPE_SLIDE_RIGHT,
  REVEALER_TRANSITION_TYPE_SLIDE_LEFT,
  REVEALER_TRANSITION_TYPE_SLIDE_UP,
  REVEALER_TRANSITION_TYPE_SLIDE_DOWN
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::RevealerTransitionType> : public Glib::Value_Enum<Gtk::RevealerTransitionType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var ScrollType SCROLL_NONE
 * No scrolling.
 * 
 *  @var ScrollType SCROLL_JUMP
 * Jump to new location.
 * 
 *  @var ScrollType SCROLL_STEP_BACKWARD
 * Step backward.
 * 
 *  @var ScrollType SCROLL_STEP_FORWARD
 * Step forward.
 * 
 *  @var ScrollType SCROLL_PAGE_BACKWARD
 * Page backward.
 * 
 *  @var ScrollType SCROLL_PAGE_FORWARD
 * Page forward.
 * 
 *  @var ScrollType SCROLL_STEP_UP
 * Step up.
 * 
 *  @var ScrollType SCROLL_STEP_DOWN
 * Step down.
 * 
 *  @var ScrollType SCROLL_PAGE_UP
 * Page up.
 * 
 *  @var ScrollType SCROLL_PAGE_DOWN
 * Page down.
 * 
 *  @var ScrollType SCROLL_STEP_LEFT
 * Step to the left.
 * 
 *  @var ScrollType SCROLL_STEP_RIGHT
 * Step to the right.
 * 
 *  @var ScrollType SCROLL_PAGE_LEFT
 * Page to the left.
 * 
 *  @var ScrollType SCROLL_PAGE_RIGHT
 * Page to the right.
 * 
 *  @var ScrollType SCROLL_START
 * Scroll to start.
 * 
 *  @var ScrollType SCROLL_END
 * Scroll to end.
 * 
 *  @enum ScrollType
 * 
 * Scrolling types.
 *
 * @ingroup gtkmmEnums
 */
enum ScrollType
{
  SCROLL_NONE,
  SCROLL_JUMP,
  SCROLL_STEP_BACKWARD,
  SCROLL_STEP_FORWARD,
  SCROLL_PAGE_BACKWARD,
  SCROLL_PAGE_FORWARD,
  SCROLL_STEP_UP,
  SCROLL_STEP_DOWN,
  SCROLL_PAGE_UP,
  SCROLL_PAGE_DOWN,
  SCROLL_STEP_LEFT,
  SCROLL_STEP_RIGHT,
  SCROLL_PAGE_LEFT,
  SCROLL_PAGE_RIGHT,
  SCROLL_START,
  SCROLL_END
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ScrollType> : public Glib::Value_Enum<Gtk::ScrollType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var SelectionMode SELECTION_NONE
 * No selection is possible.
 * 
 *  @var SelectionMode SELECTION_SINGLE
 * Zero or one element may be selected.
 * 
 *  @var SelectionMode SELECTION_BROWSE
 * Exactly one element is selected.
 * In some circumstances, such as initially or during a search
 * operation, it’s possible for no element to be selected with
 * Gtk::SELECTION_BROWSE. What is really enforced is that the user
 * can’t deselect a currently selected element except by selecting
 * another element.
 * 
 *  @var SelectionMode SELECTION_MULTIPLE
 * Any number of elements may be selected.
 * The Ctrl key may be used to enlarge the selection, and Shift
 * key to select between the focus and the child pointed to.
 * Some widgets may also allow Click-drag to select a range of elements.
 * 
 *  @enum SelectionMode
 * 
 * Used to control what selections users are allowed to make.
 *
 * @ingroup gtkmmEnums
 */
enum SelectionMode
{
  SELECTION_NONE,
  SELECTION_SINGLE,
  SELECTION_BROWSE,
  SELECTION_MULTIPLE
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::SelectionMode> : public Glib::Value_Enum<Gtk::SelectionMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var ShadowType SHADOW_NONE
 * No outline.
 * 
 *  @var ShadowType SHADOW_IN
 * The outline is bevelled inwards.
 * 
 *  @var ShadowType SHADOW_OUT
 * The outline is bevelled outwards like a button.
 * 
 *  @var ShadowType SHADOW_ETCHED_IN
 * The outline has a sunken 3d appearance.
 * 
 *  @var ShadowType SHADOW_ETCHED_OUT
 * The outline has a raised 3d appearance.
 * 
 *  @enum ShadowType
 * 
 * Used to change the appearance of an outline typically provided by a Gtk::Frame.
 * 
 * Note that many themes do not differentiate the appearance of the
 * various shadow types: Either their is no visible shadow ( @a GTK_SHADOW_NONE),
 * or there is (any other value).
 *
 * @ingroup gtkmmEnums
 */
enum ShadowType
{
  SHADOW_NONE,
  SHADOW_IN,
  SHADOW_OUT,
  SHADOW_ETCHED_IN,
  SHADOW_ETCHED_OUT
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ShadowType> : public Glib::Value_Enum<Gtk::ShadowType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var StackTransitionType STACK_TRANSITION_TYPE_NONE
 * No transition.
 * 
 *  @var StackTransitionType STACK_TRANSITION_TYPE_CROSSFADE
 * A cross-fade.
 * 
 *  @var StackTransitionType STACK_TRANSITION_TYPE_SLIDE_RIGHT
 * Slide from left to right.
 * 
 *  @var StackTransitionType STACK_TRANSITION_TYPE_SLIDE_LEFT
 * Slide from right to left.
 * 
 *  @var StackTransitionType STACK_TRANSITION_TYPE_SLIDE_UP
 * Slide from bottom up.
 * 
 *  @var StackTransitionType STACK_TRANSITION_TYPE_SLIDE_DOWN
 * Slide from top down.
 * 
 *  @var StackTransitionType STACK_TRANSITION_TYPE_SLIDE_LEFT_RIGHT
 * Slide from left or right according to the children order.
 * 
 *  @var StackTransitionType STACK_TRANSITION_TYPE_SLIDE_UP_DOWN
 * Slide from top down or bottom up according to the order.
 * 
 *  @var StackTransitionType STACK_TRANSITION_TYPE_OVER_UP
 * Cover the old page by sliding up. @newin{3,12}
 * 
 *  @var StackTransitionType STACK_TRANSITION_TYPE_OVER_DOWN
 * Cover the old page by sliding down. @newin{3,12}
 * 
 *  @var StackTransitionType STACK_TRANSITION_TYPE_OVER_LEFT
 * Cover the old page by sliding to the left. @newin{3,12}
 * 
 *  @var StackTransitionType STACK_TRANSITION_TYPE_OVER_RIGHT
 * Cover the old page by sliding to the right. @newin{3,12}
 * 
 *  @var StackTransitionType STACK_TRANSITION_TYPE_UNDER_UP
 * Uncover the new page by sliding up. @newin{3,12}
 * 
 *  @var StackTransitionType STACK_TRANSITION_TYPE_UNDER_DOWN
 * Uncover the new page by sliding down. @newin{3,12}
 * 
 *  @var StackTransitionType STACK_TRANSITION_TYPE_UNDER_LEFT
 * Uncover the new page by sliding to the left. @newin{3,12}
 * 
 *  @var StackTransitionType STACK_TRANSITION_TYPE_UNDER_RIGHT
 * Uncover the new page by sliding to the right. @newin{3,12}
 * 
 *  @var StackTransitionType STACK_TRANSITION_TYPE_OVER_UP_DOWN
 * Cover the old page sliding up or uncover the new page sliding down, according to order. @newin{3,12}
 * 
 *  @var StackTransitionType STACK_TRANSITION_TYPE_OVER_DOWN_UP
 * Cover the old page sliding down or uncover the new page sliding up, according to order. @newin{3,14}
 * 
 *  @var StackTransitionType STACK_TRANSITION_TYPE_OVER_LEFT_RIGHT
 * Cover the old page sliding left or uncover the new page sliding right, according to order. @newin{3,14}
 * 
 *  @var StackTransitionType STACK_TRANSITION_TYPE_OVER_RIGHT_LEFT
 * Cover the old page sliding right or uncover the new page sliding left, according to order. @newin{3,14}
 * 
 *  @enum StackTransitionType
 * 
 * These enumeration values describe the possible transitions
 * between pages in a Gtk::Stack widget.
 * 
 * New values may be added to this enumeration over time.
 *
 * @ingroup gtkmmEnums
 */
enum StackTransitionType
{
  STACK_TRANSITION_TYPE_NONE,
  STACK_TRANSITION_TYPE_CROSSFADE,
  STACK_TRANSITION_TYPE_SLIDE_RIGHT,
  STACK_TRANSITION_TYPE_SLIDE_LEFT,
  STACK_TRANSITION_TYPE_SLIDE_UP,
  STACK_TRANSITION_TYPE_SLIDE_DOWN,
  STACK_TRANSITION_TYPE_SLIDE_LEFT_RIGHT,
  STACK_TRANSITION_TYPE_SLIDE_UP_DOWN,
  STACK_TRANSITION_TYPE_OVER_UP,
  STACK_TRANSITION_TYPE_OVER_DOWN,
  STACK_TRANSITION_TYPE_OVER_LEFT,
  STACK_TRANSITION_TYPE_OVER_RIGHT,
  STACK_TRANSITION_TYPE_UNDER_UP,
  STACK_TRANSITION_TYPE_UNDER_DOWN,
  STACK_TRANSITION_TYPE_UNDER_LEFT,
  STACK_TRANSITION_TYPE_UNDER_RIGHT,
  STACK_TRANSITION_TYPE_OVER_UP_DOWN,
  STACK_TRANSITION_TYPE_OVER_DOWN_UP,
  STACK_TRANSITION_TYPE_OVER_LEFT_RIGHT,
  STACK_TRANSITION_TYPE_OVER_RIGHT_LEFT
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::StackTransitionType> : public Glib::Value_Enum<Gtk::StackTransitionType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var TargetFlags TARGET_SAME_APP
 * If this is set, the target will only be selected
 * for drags within a single application.
 * 
 *  @var TargetFlags TARGET_SAME_WIDGET
 * If this is set, the target will only be selected
 * for drags within a single widget.
 * 
 *  @var TargetFlags TARGET_OTHER_APP
 * If this is set, the target will not be selected
 * for drags within a single application.
 * 
 *  @var TargetFlags TARGET_OTHER_WIDGET
 * If this is set, the target will not be selected
 * for drags withing a single widget.
 * 
 *  @enum TargetFlags
 * 
 * The Gtk::TargetFlags enumeration is used to specify
 * constraints on a Gtk::TargetEntry.
 *
 * @ingroup gtkmmEnums
 * @par Bitwise operators:
 * <tt>%TargetFlags operator|(TargetFlags, TargetFlags)</tt><br>
 * <tt>%TargetFlags operator&(TargetFlags, TargetFlags)</tt><br>
 * <tt>%TargetFlags operator^(TargetFlags, TargetFlags)</tt><br>
 * <tt>%TargetFlags operator~(TargetFlags)</tt><br>
 * <tt>%TargetFlags& operator|=(TargetFlags&, TargetFlags)</tt><br>
 * <tt>%TargetFlags& operator&=(TargetFlags&, TargetFlags)</tt><br>
 * <tt>%TargetFlags& operator^=(TargetFlags&, TargetFlags)</tt><br>
 */
enum TargetFlags
{
  TARGET_SAME_APP = 1 << 0,
  TARGET_SAME_WIDGET = 1 << 1,
  TARGET_OTHER_APP = 1 << 2,
  TARGET_OTHER_WIDGET = 1 << 3
};

/** @ingroup gtkmmEnums */
inline TargetFlags operator|(TargetFlags lhs, TargetFlags rhs)
  { return static_cast<TargetFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline TargetFlags operator&(TargetFlags lhs, TargetFlags rhs)
  { return static_cast<TargetFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline TargetFlags operator^(TargetFlags lhs, TargetFlags rhs)
  { return static_cast<TargetFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline TargetFlags operator~(TargetFlags flags)
  { return static_cast<TargetFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gtkmmEnums */
inline TargetFlags& operator|=(TargetFlags& lhs, TargetFlags rhs)
  { return (lhs = static_cast<TargetFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline TargetFlags& operator&=(TargetFlags& lhs, TargetFlags rhs)
  { return (lhs = static_cast<TargetFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline TargetFlags& operator^=(TargetFlags& lhs, TargetFlags rhs)
  { return (lhs = static_cast<TargetFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::TargetFlags> : public Glib::Value_Flags<Gtk::TargetFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var ToolbarStyle TOOLBAR_ICONS
 * Buttons display only icons in the toolbar.
 * 
 *  @var ToolbarStyle TOOLBAR_TEXT
 * Buttons display only text labels in the toolbar.
 * 
 *  @var ToolbarStyle TOOLBAR_BOTH
 * Buttons display text and icons in the toolbar.
 * 
 *  @var ToolbarStyle TOOLBAR_BOTH_HORIZ
 * Buttons display icons and text alongside each
 * other, rather than vertically stacked.
 * 
 *  @enum ToolbarStyle
 * 
 * Used to customize the appearance of a Gtk::Toolbar. Note that
 * setting the toolbar style overrides the user’s preferences
 * for the default toolbar style.  Note that if the button has only
 * a label set and GTK_TOOLBAR_ICONS is used, the label will be
 * visible, and vice versa.
 *
 * @ingroup gtkmmEnums
 */
enum ToolbarStyle
{
  TOOLBAR_ICONS,
  TOOLBAR_TEXT,
  TOOLBAR_BOTH,
  TOOLBAR_BOTH_HORIZ
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ToolbarStyle> : public Glib::Value_Enum<Gtk::ToolbarStyle>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var WindowPosition WIN_POS_NONE
 * No influence is made on placement.
 * 
 *  @var WindowPosition WIN_POS_CENTER
 * Windows should be placed in the center of the screen.
 * 
 *  @var WindowPosition WIN_POS_MOUSE
 * Windows should be placed at the current mouse position.
 * 
 *  @var WindowPosition WIN_POS_CENTER_ALWAYS
 * Keep window centered as it changes size, etc.
 * 
 *  @var WindowPosition WIN_POS_CENTER_ON_PARENT
 * Center the window on its transient
 * parent (see Gtk::Window::set_transient_for()).
 * 
 *  @enum WindowPosition
 * 
 * Window placement can be influenced using this enumeration. Note that
 * using Gtk::WIN_POS_CENTER_ALWAYS is almost always a bad idea.
 * It won’t necessarily work well with all window managers or on all windowing systems.
 *
 * @ingroup gtkmmEnums
 */
enum WindowPosition
{
  WIN_POS_NONE,
  WIN_POS_CENTER,
  WIN_POS_MOUSE,
  WIN_POS_CENTER_ALWAYS,
  WIN_POS_CENTER_ON_PARENT
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::WindowPosition> : public Glib::Value_Enum<Gtk::WindowPosition>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var WindowType WINDOW_TOPLEVEL
 * A regular window, such as a dialog.
 * 
 *  @var WindowType WINDOW_POPUP
 * A special window such as a tooltip.
 * 
 *  @enum WindowType
 * 
 * A Gtk::Window can be one of these types. Most things you’d consider a
 * “window” should have type Gtk::WINDOW_TOPLEVEL; windows with this type
 * are managed by the window manager and have a frame by default (call
 * Gtk::Window::set_decorated() to toggle the frame).  Windows with type
 * Gtk::WINDOW_POPUP are ignored by the window manager; window manager
 * keybindings won’t work on them, the window manager won’t decorate the
 * window with a frame, many GTK+ features that rely on the window
 * manager will not work (e.g. resize grips and
 * maximization/minimization). Gtk::WINDOW_POPUP is used to implement
 * widgets such as Gtk::Menu or tooltips that you normally don’t think of
 * as windows per se. Nearly all windows should be Gtk::WINDOW_TOPLEVEL.
 * In particular, do not use Gtk::WINDOW_POPUP just to turn off
 * the window borders; use Gtk::Window::set_decorated() for that.
 *
 * @ingroup gtkmmEnums
 */
enum WindowType
{
  WINDOW_TOPLEVEL,
  WINDOW_POPUP
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::WindowType> : public Glib::Value_Enum<Gtk::WindowType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var WrapMode WRAP_NONE
 * Do not wrap lines; just make the text area wider.
 * 
 *  @var WrapMode WRAP_CHAR
 * Wrap text, breaking lines anywhere the cursor can
 * appear (between characters, usually - if you want to be technical,
 * between graphemes, see pango_get_log_attrs()).
 * 
 *  @var WrapMode WRAP_WORD
 * Wrap text, breaking lines in between words.
 * 
 *  @var WrapMode WRAP_WORD_CHAR
 * Wrap text, breaking lines in between words, or if
 * that is not enough, also between graphemes.
 * 
 *  @enum WrapMode
 * 
 * Describes a type of line wrapping.
 *
 * @ingroup gtkmmEnums
 */
enum WrapMode
{
  WRAP_NONE,
  WRAP_CHAR,
  WRAP_WORD,
  WRAP_WORD_CHAR
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::WrapMode> : public Glib::Value_Enum<Gtk::WrapMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var SortType SORT_ASCENDING
 * Sorting is in ascending order.
 * 
 *  @var SortType SORT_DESCENDING
 * Sorting is in descending order.
 * 
 *  @enum SortType
 * 
 * Determines the direction of a sort.
 *
 * @ingroup gtkmmEnums
 */
enum SortType
{
  SORT_ASCENDING,
  SORT_DESCENDING
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::SortType> : public Glib::Value_Enum<Gtk::SortType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var PageOrientation PAGE_ORIENTATION_PORTRAIT
 * Portrait mode.
 * 
 *  @var PageOrientation PAGE_ORIENTATION_LANDSCAPE
 * Landscape mode.
 * 
 *  @var PageOrientation PAGE_ORIENTATION_REVERSE_PORTRAIT
 * Reverse portrait mode.
 * 
 *  @var PageOrientation PAGE_ORIENTATION_REVERSE_LANDSCAPE
 * Reverse landscape mode.
 * 
 *  @enum PageOrientation
 * 
 * See also Gtk::PrintSettings::set_orientation().
 *
 * @ingroup gtkmmEnums
 */
enum PageOrientation
{
  PAGE_ORIENTATION_PORTRAIT,
  PAGE_ORIENTATION_LANDSCAPE,
  PAGE_ORIENTATION_REVERSE_PORTRAIT,
  PAGE_ORIENTATION_REVERSE_LANDSCAPE
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::PageOrientation> : public Glib::Value_Enum<Gtk::PageOrientation>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var SensitivityType SENSITIVITY_AUTO
 * The arrow is made insensitive if the
 * thumb is at the end.
 * 
 *  @var SensitivityType SENSITIVITY_ON
 * The arrow is always sensitive.
 * 
 *  @var SensitivityType SENSITIVITY_OFF
 * The arrow is always insensitive.
 * 
 *  @enum SensitivityType
 * 
 * Determines how GTK+ handles the sensitivity of stepper arrows
 * at the end of range widgets.
 *
 * @ingroup gtkmmEnums
 */
enum SensitivityType
{
  SENSITIVITY_AUTO,
  SENSITIVITY_ON,
  SENSITIVITY_OFF
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::SensitivityType> : public Glib::Value_Enum<Gtk::SensitivityType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var SizeRequestMode SIZE_REQUEST_HEIGHT_FOR_WIDTH
 * Prefer height-for-width geometry management.
 * 
 *  @var SizeRequestMode SIZE_REQUEST_WIDTH_FOR_HEIGHT
 * Prefer width-for-height geometry management.
 * 
 *  @var SizeRequestMode SIZE_REQUEST_CONSTANT_SIZE
 * Don’t trade height-for-width or width-for-height.
 * 
 *  @enum SizeRequestMode
 * 
 * Specifies a preference for height-for-width or
 * width-for-height geometry management.
 *
 * @ingroup gtkmmEnums
 */
enum SizeRequestMode
{
  SIZE_REQUEST_HEIGHT_FOR_WIDTH,
  SIZE_REQUEST_WIDTH_FOR_HEIGHT,
  SIZE_REQUEST_CONSTANT_SIZE
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::SizeRequestMode> : public Glib::Value_Enum<Gtk::SizeRequestMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var StateFlags STATE_FLAG_NORMAL
 * State during normal operation.
 * 
 *  @var StateFlags STATE_FLAG_ACTIVE
 * Widget is active.
 * 
 *  @var StateFlags STATE_FLAG_PRELIGHT
 * Widget has a mouse pointer over it.
 * 
 *  @var StateFlags STATE_FLAG_SELECTED
 * Widget is selected.
 * 
 *  @var StateFlags STATE_FLAG_INSENSITIVE
 * Widget is insensitive.
 * 
 *  @var StateFlags STATE_FLAG_INCONSISTENT
 * Widget is inconsistent.
 * 
 *  @var StateFlags STATE_FLAG_FOCUSED
 * Widget has the keyboard focus.
 * 
 *  @var StateFlags STATE_FLAG_BACKDROP
 * Widget is in a background toplevel window.
 * 
 *  @var StateFlags STATE_FLAG_DIR_LTR
 * Widget is in left-to-right text direction. @newin{3,8}
 * 
 *  @var StateFlags STATE_FLAG_DIR_RTL
 * Widget is in right-to-left text direction. @newin{3,8}
 * 
 *  @var StateFlags STATE_FLAG_LINK
 * Widget is a link. @newin{3,12}
 * 
 *  @var StateFlags STATE_FLAG_VISITED
 * The location the widget points to has already been visited. @newin{3,12}
 * 
 *  @var StateFlags STATE_FLAG_CHECKED
 * Widget is checked. @newin{3,14}
 * 
 *  @var StateFlags STATE_FLAG_DROP_ACTIVE
 * Widget is highlighted as a drop target for DND. @newin{3,20}
 * 
 *  @enum StateFlags
 * 
 * Describes a widget state. Widget states are used to match the widget
 * against CSS pseudo-classes. Note that GTK extends the regular CSS
 * classes and sometimes uses different names.
 *
 * @ingroup gtkmmEnums
 * @par Bitwise operators:
 * <tt>%StateFlags operator|(StateFlags, StateFlags)</tt><br>
 * <tt>%StateFlags operator&(StateFlags, StateFlags)</tt><br>
 * <tt>%StateFlags operator^(StateFlags, StateFlags)</tt><br>
 * <tt>%StateFlags operator~(StateFlags)</tt><br>
 * <tt>%StateFlags& operator|=(StateFlags&, StateFlags)</tt><br>
 * <tt>%StateFlags& operator&=(StateFlags&, StateFlags)</tt><br>
 * <tt>%StateFlags& operator^=(StateFlags&, StateFlags)</tt><br>
 */
enum StateFlags
{
  STATE_FLAG_NORMAL = 0x0,
  STATE_FLAG_ACTIVE = 1 << 0,
  STATE_FLAG_PRELIGHT = 1 << 1,
  STATE_FLAG_SELECTED = 1 << 2,
  STATE_FLAG_INSENSITIVE = 1 << 3,
  STATE_FLAG_INCONSISTENT = 1 << 4,
  STATE_FLAG_FOCUSED = 1 << 5,
  STATE_FLAG_BACKDROP = 1 << 6,
  STATE_FLAG_DIR_LTR = 1 << 7,
  STATE_FLAG_DIR_RTL = 1 << 8,
  STATE_FLAG_LINK = 1 << 9,
  STATE_FLAG_VISITED = 1 << 10,
  STATE_FLAG_CHECKED = 1 << 11,
  STATE_FLAG_DROP_ACTIVE = 1 << 12
};

/** @ingroup gtkmmEnums */
inline StateFlags operator|(StateFlags lhs, StateFlags rhs)
  { return static_cast<StateFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline StateFlags operator&(StateFlags lhs, StateFlags rhs)
  { return static_cast<StateFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline StateFlags operator^(StateFlags lhs, StateFlags rhs)
  { return static_cast<StateFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline StateFlags operator~(StateFlags flags)
  { return static_cast<StateFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gtkmmEnums */
inline StateFlags& operator|=(StateFlags& lhs, StateFlags rhs)
  { return (lhs = static_cast<StateFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline StateFlags& operator&=(StateFlags& lhs, StateFlags rhs)
  { return (lhs = static_cast<StateFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline StateFlags& operator^=(StateFlags& lhs, StateFlags rhs)
  { return (lhs = static_cast<StateFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::StateFlags> : public Glib::Value_Flags<Gtk::StateFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var InputPurpose INPUT_PURPOSE_FREE_FORM
 * Allow any character.
 * 
 *  @var InputPurpose INPUT_PURPOSE_ALPHA
 * Allow only alphabetic characters.
 * 
 *  @var InputPurpose INPUT_PURPOSE_DIGITS
 * Allow only digits.
 * 
 *  @var InputPurpose INPUT_PURPOSE_NUMBER
 * Edited field expects numbers.
 * 
 *  @var InputPurpose INPUT_PURPOSE_PHONE
 * Edited field expects phone number.
 * 
 *  @var InputPurpose INPUT_PURPOSE_URL
 * Edited field expects URL.
 * 
 *  @var InputPurpose INPUT_PURPOSE_EMAIL
 * Edited field expects email address.
 * 
 *  @var InputPurpose INPUT_PURPOSE_NAME
 * Edited field expects the name of a person.
 * 
 *  @var InputPurpose INPUT_PURPOSE_PASSWORD
 * Like @a GTK_INPUT_PURPOSE_FREE_FORM, but characters are hidden.
 * 
 *  @var InputPurpose INPUT_PURPOSE_PIN
 * Like @a GTK_INPUT_PURPOSE_DIGITS, but characters are hidden.
 * 
 *  @enum InputPurpose
 * 
 * Describes primary purpose of the input widget. This information is
 * useful for on-screen keyboards and similar input methods to decide
 * which keys should be presented to the user.
 * 
 * Note that the purpose is not meant to impose a totally strict rule
 * about allowed characters, and does not replace input validation.
 * It is fine for an on-screen keyboard to let the user override the
 * character set restriction that is expressed by the purpose. The
 * application is expected to validate the entry contents, even if
 * it specified a purpose.
 * 
 * The difference between @a GTK_INPUT_PURPOSE_DIGITS and
 *  @a GTK_INPUT_PURPOSE_NUMBER is that the former accepts only digits
 * while the latter also some punctuation (like commas or points, plus,
 * minus) and “e” or “E” as in 3.14E+000.
 * 
 * This enumeration may be extended in the future; input methods should
 * interpret unknown values as “free form”.
 * 
 * @newin{3,6}
 *
 * @ingroup gtkmmEnums
 */
enum InputPurpose
{
  INPUT_PURPOSE_FREE_FORM,
  INPUT_PURPOSE_ALPHA,
  INPUT_PURPOSE_DIGITS,
  INPUT_PURPOSE_NUMBER,
  INPUT_PURPOSE_PHONE,
  INPUT_PURPOSE_URL,
  INPUT_PURPOSE_EMAIL,
  INPUT_PURPOSE_NAME,
  INPUT_PURPOSE_PASSWORD,
  INPUT_PURPOSE_PIN
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::InputPurpose> : public Glib::Value_Enum<Gtk::InputPurpose>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var InputHints INPUT_HINT_NONE
 * No special behaviour suggested.
 * 
 *  @var InputHints INPUT_HINT_SPELLCHECK
 * Suggest checking for typos.
 * 
 *  @var InputHints INPUT_HINT_NO_SPELLCHECK
 * Suggest not checking for typos.
 * 
 *  @var InputHints INPUT_HINT_WORD_COMPLETION
 * Suggest word completion.
 * 
 *  @var InputHints INPUT_HINT_LOWERCASE
 * Suggest to convert all text to lowercase.
 * 
 *  @var InputHints INPUT_HINT_UPPERCASE_CHARS
 * Suggest to capitalize all text.
 * 
 *  @var InputHints INPUT_HINT_UPPERCASE_WORDS
 * Suggest to capitalize the first
 * character of each word.
 * 
 *  @var InputHints INPUT_HINT_UPPERCASE_SENTENCES
 * Suggest to capitalize the
 * first word of each sentence.
 * 
 *  @var InputHints INPUT_HINT_INHIBIT_OSK
 * Suggest to not show an onscreen keyboard
 * (e.g for a calculator that already has all the keys).
 * 
 *  @var InputHints INPUT_HINT_VERTICAL_WRITING
 * The text is vertical. @newin{3,18}
 * 
 *  @enum InputHints
 * 
 * Describes hints that might be taken into account by input methods
 * or applications. Note that input methods may already tailor their
 * behaviour according to the Gtk::InputPurpose of the entry.
 * 
 * Some common sense is expected when using these flags - mixing
 *  @a GTK_INPUT_HINT_LOWERCASE with any of the uppercase hints makes no sense.
 * 
 * This enumeration may be extended in the future; input methods should
 * ignore unknown values.
 * 
 * @newin{3,6}
 *
 * @ingroup gtkmmEnums
 * @par Bitwise operators:
 * <tt>%InputHints operator|(InputHints, InputHints)</tt><br>
 * <tt>%InputHints operator&(InputHints, InputHints)</tt><br>
 * <tt>%InputHints operator^(InputHints, InputHints)</tt><br>
 * <tt>%InputHints operator~(InputHints)</tt><br>
 * <tt>%InputHints& operator|=(InputHints&, InputHints)</tt><br>
 * <tt>%InputHints& operator&=(InputHints&, InputHints)</tt><br>
 * <tt>%InputHints& operator^=(InputHints&, InputHints)</tt><br>
 */
enum InputHints
{
  INPUT_HINT_NONE = 0x0,
  INPUT_HINT_SPELLCHECK = 1 << 0,
  INPUT_HINT_NO_SPELLCHECK = 1 << 1,
  INPUT_HINT_WORD_COMPLETION = 1 << 2,
  INPUT_HINT_LOWERCASE = 1 << 3,
  INPUT_HINT_UPPERCASE_CHARS = 1 << 4,
  INPUT_HINT_UPPERCASE_WORDS = 1 << 5,
  INPUT_HINT_UPPERCASE_SENTENCES = 1 << 6,
  INPUT_HINT_INHIBIT_OSK = 1 << 7,
  INPUT_HINT_VERTICAL_WRITING = 1 << 8
};

/** @ingroup gtkmmEnums */
inline InputHints operator|(InputHints lhs, InputHints rhs)
  { return static_cast<InputHints>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline InputHints operator&(InputHints lhs, InputHints rhs)
  { return static_cast<InputHints>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline InputHints operator^(InputHints lhs, InputHints rhs)
  { return static_cast<InputHints>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline InputHints operator~(InputHints flags)
  { return static_cast<InputHints>(~static_cast<unsigned>(flags)); }

/** @ingroup gtkmmEnums */
inline InputHints& operator|=(InputHints& lhs, InputHints rhs)
  { return (lhs = static_cast<InputHints>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline InputHints& operator&=(InputHints& lhs, InputHints rhs)
  { return (lhs = static_cast<InputHints>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline InputHints& operator^=(InputHints& lhs, InputHints rhs)
  { return (lhs = static_cast<InputHints>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::InputHints> : public Glib::Value_Flags<Gtk::InputHints>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var BaselinePosition BASELINE_POSITION_TOP
 * Align the baseline at the top.
 * 
 *  @var BaselinePosition BASELINE_POSITION_CENTER
 * Center the baseline.
 * 
 *  @var BaselinePosition BASELINE_POSITION_BOTTOM
 * Align the baseline at the bottom.
 * 
 *  @enum BaselinePosition
 * 
 * Whenever a container has some form of natural row it may align
 * children in that row along a common typographical baseline. If
 * the amount of verical space in the row is taller than the total
 * requested height of the baseline-aligned children then it can use a
 * Gtk::BaselinePosition to select where to put the baseline inside the
 * extra availible space.
 * 
 * @newin{3,10}
 *
 * @ingroup gtkmmEnums
 */
enum BaselinePosition
{
  BASELINE_POSITION_TOP,
  BASELINE_POSITION_CENTER,
  BASELINE_POSITION_BOTTOM
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::BaselinePosition> : public Glib::Value_Enum<Gtk::BaselinePosition>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{


/* We use a class to implement the GtkIconSize enum, because you can register
 * new "enum" values.  The strict type rules of C++ don't allow using an enum
 * like that.  Gtk::BuiltinIconSize is the actual GtkIconSize wrapper enum.
 */

#ifndef DOXYGEN_SHOULD_SKIP_THIS
class Settings;
#endif //DOXYGEN_SHOULD_SKIP_THIS

/**
 * Represents registered icon sizes.
 * You can also use a Gtk::BuiltinIconSize instead of an IconSize.
 */
class IconSize
{
private:
  int size_;

public:
  IconSize()                     : size_ (0)    {}
  IconSize(BuiltinIconSize size) : size_ (size) {}

  // Behave like an ordinary enum.
  explicit IconSize(int size) : size_ (size) {}
  operator int() const { return size_; }

  /** Obtains the pixel size of a semantic icon size, possibly modified by user preferences for the default Gtk::Settings.
   * Normally size would be Gtk::ICON_SIZE_MENU, Gtk::ICON_SIZE_BUTTON, etc.
   * This function isn't normally needed because Gtk::Widget::render_icon() is the usual way to get an icon for
   * rendering - then just look at the size of the rendered pixbuf. The rendered pixbuf may not even correspond
   * to the width/height returned by IconSize::lookup(), because themes are free to render the pixbuf however they
   * like, including changing the usual size.
   *
   * @param size An icon size.
   * @param width Location to store icon width.
   * @param height Location to store icon height.
   * @result true if size was a valid size.
   */
  static bool lookup(IconSize size, int& width, int& height);
};


#ifndef DOXYGEN_SHOULD_SKIP_THIS
struct IconSizeTraits
{
  typedef Gtk::IconSize CppType;
  typedef GtkIconSize   CType;
  typedef GtkIconSize   CTypeNonConst;

  static CType   to_c_type      (CType c_obj)            { return c_obj; }
  static void    release_c_type (CType)                  {}
  static CType   to_c_type      (const CppType& cpp_obj) { int value (cpp_obj); return static_cast<CType> (value); }
  static CppType to_cpp_type    (CType c_obj)            { return CppType (c_obj); }
};
#endif //DOXYGEN_SHOULD_SKIP_THIS

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::IconSize> : public Glib::Value_Enum<Gtk::IconSize>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

#ifndef DOXYGEN_SHOULD_SKIP_THIS
//We need this because we can't just use floats for enum value.
float _gtkmm_align_float_from_enum(Align value);
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} //namespace Gtk


#endif /* _GTKMM_ENUMS_H */

