// Generated by gmmproc 2.51.2 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gtkmm/textiter.h>
#include <gtkmm/private/textiter_p.h>

#include <gtk/gtk.h>
#include <cstring> // std::memset()

/* Copyright 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glibmm/vectorutils.h>
#include <gdkmm/pixbuf.h>
#include <gtkmm/textbuffer.h>
#include <gtkmm/textmark.h>
#include <gtkmm/textchildanchor.h>

/**** Gtk::TextIterBase *******************************************************/

namespace
{
gboolean TextIterBase_find_char_callback(gunichar ch, void* user_data)
{
  try
  {
    auto slot = static_cast<Gtk::TextIterBase::SlotFindChar*>(user_data);
    return (*slot)(ch);
  }
  catch (...)
  {
    Glib::exception_handlers_invoke();
    return false;
  }
}

} // anonymous namespace

namespace Gtk
{
bool TextIterBase::forward_find_char(const SlotFindChar& slot, const TextIterBase& limit)
{
  // Use the original slot (not a copy).
  auto slot_copy = const_cast<SlotFindChar*>(&slot);

  return gtk_text_iter_forward_find_char(gobj(), &TextIterBase_find_char_callback, slot_copy, limit.gobj());
}

bool TextIterBase::forward_find_char(const SlotFindChar& slot)
{
  // Use the original slot (not a copy).
  auto slot_copy = const_cast<SlotFindChar*>(&slot);

  return gtk_text_iter_forward_find_char(gobj(), &TextIterBase_find_char_callback, slot_copy, nullptr);
}

bool TextIterBase::backward_find_char(const SlotFindChar& slot, const TextIterBase& limit)
{
  // Use the original slot (not a copy).
  auto slot_copy = const_cast<SlotFindChar*>(&slot);

  return gtk_text_iter_backward_find_char(gobj(), &TextIterBase_find_char_callback, slot_copy, limit.gobj());
}

bool TextIterBase::backward_find_char(const SlotFindChar& slot)
{
  // Use the original slot (not a copy).
  auto slot_copy = const_cast<SlotFindChar*>(&slot);

  return gtk_text_iter_backward_find_char(gobj(), &TextIterBase_find_char_callback, slot_copy, nullptr);
}

} // namespace Gtk

/**** Gtk::TextIter and Gtk::TextConstIter ************************************/

namespace Glib
{
// Can't have overloaded functions that differ only in return type.
// These can't be called Glib::wrap().

Gtk::TextIter& wrap_iter(GtkTextIter* object)
{
  return *reinterpret_cast<Gtk::TextIter*>(object);
}

const Gtk::TextIter& wrap_iter(const GtkTextIter* object)
{
  return *reinterpret_cast<const Gtk::TextIter*>(object);
}

Gtk::TextConstIter& wrap_const_iter(GtkTextIter* object)
{
  return *reinterpret_cast<Gtk::TextConstIter*>(object);
}

const Gtk::TextConstIter& wrap_const_iter(const GtkTextIter* object)
{
  return *reinterpret_cast<const Gtk::TextConstIter*>(object);
}

} // namespace Glib

namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gtk::TextSearchFlags>::value_type()
{
  return gtk_text_search_flags_get_type();
}


namespace Glib
{

Gtk::TextIterBase& wrap(GtkTextIter* object)
{
  return *reinterpret_cast<Gtk::TextIterBase*>(object);
}

const Gtk::TextIterBase& wrap(const GtkTextIter* object)
{
  return *reinterpret_cast<const Gtk::TextIterBase*>(object);
}

} // namespace Glib


namespace Gtk
{


TextIterBase::TextIterBase(const TextIterBase& other) noexcept
:
  gobject_(other.gobject_)
{
}

TextIterBase& TextIterBase::operator=(const TextIterBase& other) noexcept
{
  gobject_ = other.gobject_;
  return *this;
}

TextIterBase::TextIterBase(TextIterBase&& other) noexcept
:
  gobject_(std::move(other.gobject_))
{
  //We could wipe other.gobject_ via memset,
  //but that is not really necessary:
  //other.gobject_ = nullptr;
}

TextIterBase& TextIterBase::operator=(TextIterBase&& other) noexcept
{
  gobject_ = std::move(other.gobject_);
  return *this;
}

// static
GType TextIterBase::get_type()
{
  return gtk_text_iter_get_type();
}

TextIterBase::TextIterBase()
{
  std::memset(&gobject_, 0, sizeof(GtkTextIter));
}

TextIterBase::TextIterBase(const GtkTextIter* gobject)
{
  if(gobject)
    gobject_ = *gobject;
  else
    std::memset(&gobject_, 0, sizeof(GtkTextIter));
}


int TextIterBase::get_offset() const
{
  return gtk_text_iter_get_offset(const_cast<GtkTextIter*>(gobj()));
}

int TextIterBase::get_line() const
{
  return gtk_text_iter_get_line(const_cast<GtkTextIter*>(gobj()));
}

int TextIterBase::get_line_offset() const
{
  return gtk_text_iter_get_line_offset(const_cast<GtkTextIter*>(gobj()));
}

int TextIterBase::get_line_index() const
{
  return gtk_text_iter_get_line_index(const_cast<GtkTextIter*>(gobj()));
}

int TextIterBase::get_visible_line_offset() const
{
  return gtk_text_iter_get_visible_line_offset(const_cast<GtkTextIter*>(gobj()));
}

int TextIterBase::get_visible_line_index() const
{
  return gtk_text_iter_get_visible_line_index(const_cast<GtkTextIter*>(gobj()));
}

gunichar TextIterBase::get_char() const
{
  return gtk_text_iter_get_char(const_cast<GtkTextIter*>(gobj()));
}

Glib::ustring TextIterBase::get_slice(const TextIterBase& end) const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gtk_text_iter_get_slice(const_cast<GtkTextIter*>(gobj()), (end).gobj()));
}

Glib::ustring TextIterBase::get_text(const TextIterBase& end) const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gtk_text_iter_get_text(const_cast<GtkTextIter*>(gobj()), (end).gobj()));
}

Glib::ustring TextIterBase::get_visible_slice(const TextIterBase& end) const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gtk_text_iter_get_visible_slice(const_cast<GtkTextIter*>(gobj()), (end).gobj()));
}

Glib::ustring TextIterBase::get_visible_text(const TextIterBase& end) const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gtk_text_iter_get_visible_text(const_cast<GtkTextIter*>(gobj()), (end).gobj()));
}

bool TextIterBase::starts_tag(const Glib::RefPtr<const TextTag>& tag) const
{
  return gtk_text_iter_starts_tag(const_cast<GtkTextIter*>(gobj()), const_cast<GtkTextTag*>(Glib::unwrap<TextTag>(tag)));
}

bool TextIterBase::ends_tag(const Glib::RefPtr<const TextTag>& tag) const
{
  return gtk_text_iter_ends_tag(const_cast<GtkTextIter*>(gobj()), const_cast<GtkTextTag*>(Glib::unwrap<TextTag>(tag)));
}

bool TextIterBase::toggles_tag(const Glib::RefPtr<const TextTag>& tag) const
{
  return gtk_text_iter_toggles_tag(const_cast<GtkTextIter*>(gobj()), const_cast<GtkTextTag*>(Glib::unwrap<TextTag>(tag)));
}

bool TextIterBase::has_tag(const Glib::RefPtr<const TextTag>& tag) const
{
  return gtk_text_iter_has_tag(const_cast<GtkTextIter*>(gobj()), const_cast<GtkTextTag*>(Glib::unwrap<TextTag>(tag)));
}

bool TextIterBase::editable(bool default_setting) const
{
  return gtk_text_iter_editable(const_cast<GtkTextIter*>(gobj()), static_cast<int>(default_setting));
}

bool TextIterBase::can_insert(bool default_editability) const
{
  return gtk_text_iter_can_insert(const_cast<GtkTextIter*>(gobj()), static_cast<int>(default_editability));
}

bool TextIterBase::starts_word() const
{
  return gtk_text_iter_starts_word(const_cast<GtkTextIter*>(gobj()));
}

bool TextIterBase::ends_word() const
{
  return gtk_text_iter_ends_word(const_cast<GtkTextIter*>(gobj()));
}

bool TextIterBase::inside_word() const
{
  return gtk_text_iter_inside_word(const_cast<GtkTextIter*>(gobj()));
}

bool TextIterBase::starts_sentence() const
{
  return gtk_text_iter_starts_sentence(const_cast<GtkTextIter*>(gobj()));
}

bool TextIterBase::ends_sentence() const
{
  return gtk_text_iter_ends_sentence(const_cast<GtkTextIter*>(gobj()));
}

bool TextIterBase::inside_sentence() const
{
  return gtk_text_iter_inside_sentence(const_cast<GtkTextIter*>(gobj()));
}

bool TextIterBase::starts_line() const
{
  return gtk_text_iter_starts_line(const_cast<GtkTextIter*>(gobj()));
}

bool TextIterBase::ends_line() const
{
  return gtk_text_iter_ends_line(const_cast<GtkTextIter*>(gobj()));
}

bool TextIterBase::is_cursor_position() const
{
  return gtk_text_iter_is_cursor_position(const_cast<GtkTextIter*>(gobj()));
}

int TextIterBase::get_chars_in_line() const
{
  return gtk_text_iter_get_chars_in_line(const_cast<GtkTextIter*>(gobj()));
}

int TextIterBase::get_bytes_in_line() const
{
  return gtk_text_iter_get_bytes_in_line(const_cast<GtkTextIter*>(gobj()));
}

Pango::Language TextIterBase::get_language() const
{
  return Pango::Language(gtk_text_iter_get_language(const_cast<GtkTextIter*>(gobj())));
}

bool TextIterBase::is_end() const
{
  return gtk_text_iter_is_end(const_cast<GtkTextIter*>(gobj()));
}

bool TextIterBase::is_start() const
{
  return gtk_text_iter_is_start(const_cast<GtkTextIter*>(gobj()));
}

bool TextIterBase::forward_char()
{
  return gtk_text_iter_forward_char(gobj());
}

bool TextIterBase::backward_char()
{
  return gtk_text_iter_backward_char(gobj());
}

bool TextIterBase::forward_chars(int count)
{
  return gtk_text_iter_forward_chars(gobj(), count);
}

bool TextIterBase::backward_chars(int count)
{
  return gtk_text_iter_backward_chars(gobj(), count);
}

bool TextIterBase::forward_line()
{
  return gtk_text_iter_forward_line(gobj());
}

bool TextIterBase::backward_line()
{
  return gtk_text_iter_backward_line(gobj());
}

bool TextIterBase::forward_lines(int count)
{
  return gtk_text_iter_forward_lines(gobj(), count);
}

bool TextIterBase::backward_lines(int count)
{
  return gtk_text_iter_backward_lines(gobj(), count);
}

bool TextIterBase::forward_word_end()
{
  return gtk_text_iter_forward_word_end(gobj());
}

bool TextIterBase::backward_word_start()
{
  return gtk_text_iter_backward_word_start(gobj());
}

bool TextIterBase::forward_word_ends(int count)
{
  return gtk_text_iter_forward_word_ends(gobj(), count);
}

bool TextIterBase::backward_word_starts(int count)
{
  return gtk_text_iter_backward_word_starts(gobj(), count);
}

bool TextIterBase::forward_visible_line()
{
  return gtk_text_iter_forward_visible_line(gobj());
}

bool TextIterBase::backward_visible_line()
{
  return gtk_text_iter_backward_visible_line(gobj());
}

bool TextIterBase::forward_visible_lines(int count)
{
  return gtk_text_iter_forward_visible_lines(gobj(), count);
}

bool TextIterBase::backward_visible_lines(int count)
{
  return gtk_text_iter_backward_visible_lines(gobj(), count);
}

bool TextIterBase::forward_visible_word_end()
{
  return gtk_text_iter_forward_visible_word_end(gobj());
}

bool TextIterBase::backward_visible_word_start()
{
  return gtk_text_iter_backward_visible_word_start(gobj());
}

bool TextIterBase::forward_visible_word_ends(int count)
{
  return gtk_text_iter_forward_visible_word_ends(gobj(), count);
}

bool TextIterBase::backward_visible_word_starts(int count)
{
  return gtk_text_iter_backward_visible_word_starts(gobj(), count);
}

bool TextIterBase::forward_sentence_end()
{
  return gtk_text_iter_forward_sentence_end(gobj());
}

bool TextIterBase::backward_sentence_start()
{
  return gtk_text_iter_backward_sentence_start(gobj());
}

bool TextIterBase::forward_sentence_ends(int count)
{
  return gtk_text_iter_forward_sentence_ends(gobj(), count);
}

bool TextIterBase::backward_sentence_starts(int count)
{
  return gtk_text_iter_backward_sentence_starts(gobj(), count);
}

bool TextIterBase::forward_cursor_position()
{
  return gtk_text_iter_forward_cursor_position(gobj());
}

bool TextIterBase::backward_cursor_position()
{
  return gtk_text_iter_backward_cursor_position(gobj());
}

bool TextIterBase::forward_cursor_positions(int count)
{
  return gtk_text_iter_forward_cursor_positions(gobj(), count);
}

bool TextIterBase::backward_cursor_positions(int count)
{
  return gtk_text_iter_backward_cursor_positions(gobj(), count);
}

bool TextIterBase::forward_visible_cursor_position()
{
  return gtk_text_iter_forward_visible_cursor_position(gobj());
}

bool TextIterBase::backward_visible_cursor_position()
{
  return gtk_text_iter_backward_visible_cursor_position(gobj());
}

bool TextIterBase::forward_visible_cursor_positions(int count)
{
  return gtk_text_iter_forward_visible_cursor_positions(gobj(), count);
}

bool TextIterBase::backward_visible_cursor_positions(int count)
{
  return gtk_text_iter_backward_visible_cursor_positions(gobj(), count);
}

void TextIterBase::set_offset(int char_offset)
{
  gtk_text_iter_set_offset(gobj(), char_offset);
}

void TextIterBase::set_line(int line_number)
{
  gtk_text_iter_set_line(gobj(), line_number);
}

void TextIterBase::set_line_offset(int char_on_line)
{
  gtk_text_iter_set_line_offset(gobj(), char_on_line);
}

void TextIterBase::set_line_index(int byte_on_line)
{
  gtk_text_iter_set_line_index(gobj(), byte_on_line);
}

void TextIterBase::forward_to_end()
{
  gtk_text_iter_forward_to_end(gobj());
}

bool TextIterBase::forward_to_line_end()
{
  return gtk_text_iter_forward_to_line_end(gobj());
}

void TextIterBase::set_visible_line_offset(int char_on_line)
{
  gtk_text_iter_set_visible_line_offset(gobj(), char_on_line);
}

void TextIterBase::set_visible_line_index(int byte_on_line)
{
  gtk_text_iter_set_visible_line_index(gobj(), byte_on_line);
}

bool TextIterBase::forward_to_tag_toggle(const Glib::RefPtr<const TextTag>& tag)
{
  return gtk_text_iter_forward_to_tag_toggle(gobj(), const_cast<GtkTextTag*>(Glib::unwrap<TextTag>(tag)));
}

bool TextIterBase::backward_to_tag_toggle(const Glib::RefPtr<const TextTag>& tag)
{
  return gtk_text_iter_backward_to_tag_toggle(gobj(), const_cast<GtkTextTag*>(Glib::unwrap<TextTag>(tag)));
}

int TextIterBase::compare(const TextIterBase& rhs) const
{
  return gtk_text_iter_compare(const_cast<GtkTextIter*>(gobj()), (rhs).gobj());
}

bool TextIterBase::in_range(const TextIterBase& start, const TextIterBase& end) const
{
  return gtk_text_iter_in_range(const_cast<GtkTextIter*>(gobj()), (start).gobj(), (end).gobj());
}


bool operator==(const TextIterBase& lhs, const TextIterBase& rhs)
{
  return (gtk_text_iter_equal(lhs.gobj(), rhs.gobj()) != 0);
}

bool operator!=(const TextIterBase& lhs, const TextIterBase& rhs)
{
  return (gtk_text_iter_equal(lhs.gobj(), rhs.gobj()) == 0);
}

bool operator<(const TextIterBase& lhs, const TextIterBase& rhs)
{
  return (gtk_text_iter_compare(lhs.gobj(), rhs.gobj()) < 0);
}

bool operator>(const TextIterBase& lhs, const TextIterBase& rhs)
{
  return (gtk_text_iter_compare(lhs.gobj(), rhs.gobj()) > 0);
}

bool operator<=(const TextIterBase& lhs, const TextIterBase& rhs)
{
  return (gtk_text_iter_compare(lhs.gobj(), rhs.gobj()) <= 0);
}

bool operator>=(const TextIterBase& lhs, const TextIterBase& rhs)
{
  return (gtk_text_iter_compare(lhs.gobj(), rhs.gobj()) >= 0);
}


} // namespace Gtk


namespace Gtk
{


Glib::RefPtr<TextBuffer> TextIter::get_buffer() const
{
  Glib::RefPtr<TextBuffer> retvalue = Glib::wrap(gtk_text_iter_get_buffer(const_cast<GtkTextIter*>(gobj())));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<Gdk::Pixbuf> TextIter::get_pixbuf() const
{
  Glib::RefPtr<Gdk::Pixbuf> retvalue = Glib::wrap(gtk_text_iter_get_pixbuf(const_cast<GtkTextIter*>(gobj())));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

std::vector<Glib::RefPtr<TextMark>> TextIter::get_marks() const
{
  return Glib::SListHandler<Glib::RefPtr<TextMark> >::slist_to_vector(gtk_text_iter_get_marks(const_cast<GtkTextIter*>(gobj())), Glib::OWNERSHIP_SHALLOW);
}

Glib::RefPtr<TextChildAnchor> TextIter::get_child_anchor() const
{
  Glib::RefPtr<TextChildAnchor> retvalue = Glib::wrap(gtk_text_iter_get_child_anchor(const_cast<GtkTextIter*>(gobj())));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

std::vector<Glib::RefPtr<TextTag>> TextIter::get_toggled_tags(bool toggled_on) const
{
  return Glib::SListHandler<Glib::RefPtr<TextTag> >::slist_to_vector(gtk_text_iter_get_toggled_tags(const_cast<GtkTextIter*>(gobj()), static_cast<int>(toggled_on)), Glib::OWNERSHIP_SHALLOW);
}

std::vector<Glib::RefPtr<TextTag>> TextIter::get_tags() const
{
  return Glib::SListHandler<Glib::RefPtr<TextTag> >::slist_to_vector(gtk_text_iter_get_tags(const_cast<GtkTextIter*>(gobj())), Glib::OWNERSHIP_SHALLOW);
}

bool TextIter::forward_search(const Glib::ustring& str, TextSearchFlags flags, TextIter& match_start, TextIter& match_end, const TextIterBase& limit) const
{
  return gtk_text_iter_forward_search(const_cast<GtkTextIter*>(gobj()), str.c_str(), ((GtkTextSearchFlags)(flags)), (match_start).gobj(), (match_end).gobj(), (limit).gobj());
}

bool TextIter::forward_search(const Glib::ustring& str, TextSearchFlags flags, TextIter& match_start, TextIter& match_end) const
{
  return gtk_text_iter_forward_search(const_cast<GtkTextIter*>(gobj()), str.c_str(), ((GtkTextSearchFlags)(flags)), (match_start).gobj(), (match_end).gobj(), nullptr);
}

bool TextIter::backward_search(const Glib::ustring& str, TextSearchFlags flags, TextIter& match_start, TextIter& match_end, const TextIterBase& limit) const
{
  return gtk_text_iter_backward_search(const_cast<GtkTextIter*>(gobj()), str.c_str(), ((GtkTextSearchFlags)(flags)), (match_start).gobj(), (match_end).gobj(), (limit).gobj());
}

bool TextIter::backward_search(const Glib::ustring& str, TextSearchFlags flags, TextIter& match_start, TextIter& match_end) const
{
  return gtk_text_iter_backward_search(const_cast<GtkTextIter*>(gobj()), str.c_str(), ((GtkTextSearchFlags)(flags)), (match_start).gobj(), (match_end).gobj(), nullptr);
}

void TextIter::order(TextIter& second)
{
  gtk_text_iter_order(gobj(), (second).gobj());
}


} // namespace Gtk


namespace Gtk
{


Glib::RefPtr<const TextBuffer> TextConstIter::get_buffer() const
{
  Glib::RefPtr<const TextBuffer> retvalue = Glib::wrap(gtk_text_iter_get_buffer(const_cast<GtkTextIter*>(gobj())));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Gdk::Pixbuf> TextConstIter::get_pixbuf() const
{
  Glib::RefPtr<const Gdk::Pixbuf> retvalue = Glib::wrap(gtk_text_iter_get_pixbuf(const_cast<GtkTextIter*>(gobj())));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

std::vector<Glib::RefPtr<const TextMark>> TextConstIter::get_marks() const
{
  return Glib::SListHandler<Glib::RefPtr<const TextMark> >::slist_to_vector(gtk_text_iter_get_marks(const_cast<GtkTextIter*>(gobj())), Glib::OWNERSHIP_SHALLOW);
}

Glib::RefPtr<const TextChildAnchor> TextConstIter::get_child_anchor() const
{
  Glib::RefPtr<const TextChildAnchor> retvalue = Glib::wrap(gtk_text_iter_get_child_anchor(const_cast<GtkTextIter*>(gobj())));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

std::vector<Glib::RefPtr<const TextTag>> TextConstIter::get_toggled_tags(bool toggled_on) const
{
  return Glib::SListHandler<Glib::RefPtr<const TextTag> >::slist_to_vector(gtk_text_iter_get_toggled_tags(const_cast<GtkTextIter*>(gobj()), static_cast<int>(toggled_on)), Glib::OWNERSHIP_SHALLOW);
}

std::vector<Glib::RefPtr<const TextTag>> TextConstIter::get_tags() const
{
  return Glib::SListHandler<Glib::RefPtr<const TextTag> >::slist_to_vector(gtk_text_iter_get_tags(const_cast<GtkTextIter*>(gobj())), Glib::OWNERSHIP_SHALLOW);
}

bool TextConstIter::forward_search(const Glib::ustring& str, TextSearchFlags flags, TextConstIter& match_start, TextConstIter& match_end, const TextIterBase& limit) const
{
  return gtk_text_iter_forward_search(const_cast<GtkTextIter*>(gobj()), str.c_str(), ((GtkTextSearchFlags)(flags)), (match_start).gobj(), (match_end).gobj(), (limit).gobj());
}

bool TextConstIter::forward_search(const Glib::ustring& str, TextSearchFlags flags, TextConstIter& match_start, TextConstIter& match_end) const
{
  return gtk_text_iter_forward_search(const_cast<GtkTextIter*>(gobj()), str.c_str(), ((GtkTextSearchFlags)(flags)), (match_start).gobj(), (match_end).gobj(), nullptr);
}

bool TextConstIter::backward_search(const Glib::ustring& str, TextSearchFlags flags, TextConstIter& match_start, TextConstIter& match_end, const TextIterBase& limit) const
{
  return gtk_text_iter_backward_search(const_cast<GtkTextIter*>(gobj()), str.c_str(), ((GtkTextSearchFlags)(flags)), (match_start).gobj(), (match_end).gobj(), (limit).gobj());
}

bool TextConstIter::backward_search(const Glib::ustring& str, TextSearchFlags flags, TextConstIter& match_start, TextConstIter& match_end) const
{
  return gtk_text_iter_backward_search(const_cast<GtkTextIter*>(gobj()), str.c_str(), ((GtkTextSearchFlags)(flags)), (match_start).gobj(), (match_end).gobj(), nullptr);
}

void TextConstIter::order(TextConstIter& second)
{
  gtk_text_iter_order(gobj(), (second).gobj());
}


} // namespace Gtk


