// Generated by gmmproc 2.51.5 -- DO NOT MODIFY!
#ifndef _GTKMM_BOX_H
#define _GTKMM_BOX_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <gtkmm/container.h>
#include <gtkmm/orientable.h>
#include <gtk/gtk.h>  /* For _GtkBoxChild */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkBox = struct _GtkBox;
using GtkBoxClass = struct _GtkBoxClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class Box_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{

/** Packing options for adding child widgets to a Box with pack_start() and pack_end().
 * @ingroup gtkmmEnums
 */
enum PackOptions
{
  PACK_SHRINK, /**< Space is contracted to the child widget size. */
  PACK_EXPAND_PADDING, /**< Space is expanded, with extra space filled with padding. */
  PACK_EXPAND_WIDGET /**< Space is expanded, with extra space filled by increasing the child widget size. */
};

/** The Box widget organizes child widgets into a rectangular area.
 *
 * The rectangular area of a Box is organized into either a single row
 * or a single column of child widgets depending upon the orientation.
 * Thus, all children of a Box are allocated one dimension in common,
 * which is the height of a row, or the width of a column.
 *
 * Gtk::Box uses a notion of packing. Packing refers to adding widgets with
 * reference to a particular position in a Gtk::Container. There are two
 * reference positions: the start and the end of the box. For a vertical Box, the start
 * is defined as the top of the box and the end is defined as the bottom.  For
 * a horizontal Box the start is defined as the left side and the end is defined as the
 * right side.  Use repeated calls to pack_start() to pack widgets into a
 * Gtk::Box from start to end. Use pack_end() to add widgets from end to start.
 * You may intersperse these calls and add widgets from both ends of the same
 * Gtk::Box. The last widget added with pack_start() will be placed just before
 * the last widget added with pack_end()
 *
 * Because Gtk::Box is a Gtk::Container, you may also use Gtk::Container::add()
 * to insert widgets, and they will be packed as if with pack_start(). Use
 * Gtk::Container::remove() to remove widgets.
 *
 * Use set_homogeneous() to specify whether or not all children of the Gtk::Box
 * occupy the same amount of space.
 *
 * Use set_spacing() to determine the minimum
 * space placed between all children in the Gtk::Box.  Note that
 * spacing is added between the children, while
 * padding added by gtk_box_pack_start() or gtk_box_pack_end() is added
 * on either side of the widget it belongs to.
 *
 * Use reorder_child() to
 * move a child widget to a different place in the box.
 *
 * Use
 * set_child_packing() to reset the pack options and padding attributes of any
 * Gtk::Box child. Use query_child_packing() to query these fields.
 */

class Box
  : public Container,
    public Orientable
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Box CppObjectType;
  typedef Box_Class CppClassType;
  typedef GtkBox BaseObjectType;
  typedef GtkBoxClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  Box(Box&& src) noexcept;
  Box& operator=(Box&& src) noexcept;

  // noncopyable
  Box(const Box&) = delete;
  Box& operator=(const Box&) = delete;

  ~Box() noexcept override;

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Box_Class;
  static CppClassType box_class_;

protected:
  explicit Box(const Glib::ConstructParams& construct_params);
  explicit Box(GtkBox* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkBox*       gobj()       { return reinterpret_cast<GtkBox*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkBox* gobj() const { return reinterpret_cast<GtkBox*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:

  
public:

  //Note that we try to use the same defaul parameter value as the default property value.
  /** Creates a new horizontal box.
   * @param orientation The box's orientation.
   * @param spacing Determines the space in pixels between child widgets.
   */
    explicit Box(Orientation orientation =  ORIENTATION_HORIZONTAL, int spacing =  0);


  /** Left side insert a widget to a box.
   * The expand argument to pack_start() or pack_end()
   * controls whether the widgets are laid out in the box to fill in all
   * the extra space in the box so the box is expanded to fill the area
   * allocated to it (<tt>true</tt>). Or the box is shrunk to just fit the widgets
   * (<tt>false</tt>).  Setting @a expand to <tt>false</tt> will allow you to do right and left
   * justifying of your widgets.  Otherwise, they will all expand to fit in
   * the box, and the same effect could be achieved by using only one of
   * pack_start() or pack_end() functions.
   * 
   * The @a fill argument to the pack_start()/pack_end() functions control whether the
   * extra space is allocated to the objects themselves (<tt>true</tt>), or as extra
   * padding in the box around these objects (<tt>false</tt>). It only has an effect
   * if the @a expand argument is also <tt>true</tt>.
   * 
   * The difference between spacing (set when the box is created)
   * and padding (set when elements are packed) is, that spacing is added between
   * objects, and padding is added on either side of an object.
   * 
   * @param child The Gtk::Widget to be added to @a box.
   * @param expand <tt>true</tt> if the new child is to be given extra space allocated
   * to @a box. The extra space will be divided evenly between all children
   * that use this option.
   * @param fill <tt>true</tt> if space given to @a child by the @a expand option is
   * actually allocated to @a child, rather than just padding it.  This
   * parameter has no effect if @a expand is set to <tt>false</tt>.  A child is
   * always allocated the full height of a horizontal Gtk::Box and the full width
   * of a vertical Gtk::Box. This option affects the other dimension.
   */
  void pack_start(Widget& child, bool expand, bool fill);

  /** Left side insert a widget to a box.
   * @param child A Widget to be added to box.
   * @param options Controls how the widget expands to fill space, and how the space around them is used.
   */
  void pack_start(Widget& child, PackOptions options = PACK_EXPAND_WIDGET);

  
  /** Adds @a child to @a box, packed with reference to the end of @a box.
   * The @a child is packed after (away from end of) any other child
   * packed with reference to the end of @a box.
   * 
   * @param child The Gtk::Widget to be added to @a box.
   * @param expand <tt>true</tt> if the new child is to be given extra space allocated
   * to @a box. The extra space will be divided evenly between all children
   * of @a box that use this option.
   * @param fill <tt>true</tt> if space given to @a child by the @a expand option is
   * actually allocated to @a child, rather than just padding it.  This
   * parameter has no effect if @a expand is set to <tt>false</tt>.  A child is
   * always allocated the full height of a horizontal Gtk::Box and the full width
   * of a vertical Gtk::Box.  This option affects the other dimension.
   */
  void pack_end(Widget& child, bool expand, bool fill);

  /** Right side insert a widget to a box.
   * @param child A Widget to be added to box.
   * @param options Controls how the widget expands to fill space, and how the space around them is used.
   */
  void pack_end(Widget& child, PackOptions options = PACK_EXPAND_WIDGET);

  
  /** Sets the Gtk::Box::property_homogeneous() property of @a box, controlling
   * whether or not all children of @a box are given equal space
   * in the box.
   * 
   * @param homogeneous A boolean value, <tt>true</tt> to create equal allotments,
   * <tt>false</tt> for variable allotments.
   */
  void set_homogeneous(bool homogeneous =  true);
  
  /** Returns whether the box is homogeneous (all children are the
   * same size). See set_homogeneous().
   * 
   * @return <tt>true</tt> if the box is homogeneous.
   */
  bool get_homogeneous() const;

  
  /** Sets the Gtk::Box::property_spacing() property of @a box, which is the
   * number of pixels to place between children of @a box.
   * 
   * @param spacing The number of pixels to put between children.
   */
  void set_spacing(int spacing);
  
  /** Gets the value set by set_spacing().
   * 
   * @return Spacing between children.
   */
  int get_spacing() const;

  
  /** Sets the baseline position of a box. This affects
   * only horizontal boxes with at least one baseline aligned
   * child. If there is more vertical space available than requested,
   * and the baseline is not allocated by the parent then
   *  @a position is used to allocate the baseline wrt the
   * extra space available.
   * 
   * @newin{3,10}
   * 
   * @param position A Gtk::BaselinePosition.
   */
  void set_baseline_position(BaselinePosition position);
  
  /** Gets the value set by set_baseline_position().
   * 
   * @newin{3,10}
   * 
   * @return The baseline position.
   */
  BaselinePosition get_baseline_position() const;

  
  /** Moves @a child to a new @a position in the list of @a box children.
   * The list contains widgets packed Gtk::PACK_START
   * as well as widgets packed Gtk::PACK_END, in the order that these
   * widgets were added to @a box.
   * 
   * A widget’s position in the @a box children list determines where
   * the widget is packed into @a box.  A child widget at some position
   * in the list will be packed just after all other widgets of the
   * same packing type that appear earlier in the list.
   * 
   * @param child The Gtk::Widget to move.
   * @param position The new position for @a child in the list of children
   * of @a box, starting from 0. If negative, indicates the end of
   * the list.
   */
  void reorder_child(Widget& child, int position);

  
  /** Sets a center widget; that is a child widget that will be
   * centered with respect to the full width of the box, even
   * if the children at either side take up different amounts
   * of space.
   * 
   * @newin{3,12}
   * 
   * @param widget The widget to center.
   */
  void set_center_widget(Widget& widget);

  /** Unset the center_widget.
   * See set_center_widget().
   */
  void unset_center_widget();
  
  /** Retrieves the center widget of the box.
   * 
   * @newin{3,12}
   * 
   * @return The center widget
   * or <tt>nullptr</tt> in case no center widget is set.
   */
  Widget* get_center_widget(); //transfer none
  
  /** Retrieves the center widget of the box.
   * 
   * @newin{3,12}
   * 
   * @return The center widget
   * or <tt>nullptr</tt> in case no center widget is set.
   */
  const Widget* get_center_widget() const; //transfer none

  /** The amount of space between children.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_spacing() ;

/** The amount of space between children.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_spacing() const;

  /** Whether the children should all be the same size.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_homogeneous() ;

/** Whether the children should all be the same size.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_homogeneous() const;

  /** The position of the baseline aligned widgets if extra space is available.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< BaselinePosition > property_baseline_position() ;

/** The position of the baseline aligned widgets if extra space is available.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< BaselinePosition > property_baseline_position() const;


  /** Whether the child should receive extra space when the parent grows.
   * 
   * Note that the Gtk::Widget::property_halign(), Gtk::Widget::property_valign(), Gtk::Widget::property_hexpand()
   * and Gtk::Widget::property_vexpand() properties are the preferred way to influence
   * child size allocation in containers.
   * 
   * In contrast to Gtk::Widget::property_hexpand(), the expand child property does
   * not cause the box to expand itself.
   *
   * @return A ChildPropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Gtk::ChildPropertyProxy< bool > child_property_expand(Gtk::Widget& child) ;

/** Whether the child should receive extra space when the parent grows.
   * 
   * Note that the Gtk::Widget::property_halign(), Gtk::Widget::property_valign(), Gtk::Widget::property_hexpand()
   * and Gtk::Widget::property_vexpand() properties are the preferred way to influence
   * child size allocation in containers.
   * 
   * In contrast to Gtk::Widget::property_hexpand(), the expand child property does
   * not cause the box to expand itself.
   *
   * @return A ChildPropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Gtk::ChildPropertyProxy_ReadOnly< bool > child_property_expand(const Gtk::Widget& child) const;

  /** Whether the child should receive extra space when the parent grows.
   * 
   * Note that the Gtk::Widget::property_halign(), Gtk::Widget::property_valign(), Gtk::Widget::property_hexpand()
   * and Gtk::Widget::property_vexpand() properties are the preferred way to influence
   * child size allocation in containers.
   *
   * @return A ChildPropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Gtk::ChildPropertyProxy< bool > child_property_fill(Gtk::Widget& child) ;

/** Whether the child should receive extra space when the parent grows.
   * 
   * Note that the Gtk::Widget::property_halign(), Gtk::Widget::property_valign(), Gtk::Widget::property_hexpand()
   * and Gtk::Widget::property_vexpand() properties are the preferred way to influence
   * child size allocation in containers.
   *
   * @return A ChildPropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Gtk::ChildPropertyProxy_ReadOnly< bool > child_property_fill(const Gtk::Widget& child) const;

  /** A GtkPackType indicating whether the child is packed with reference to the start or end of the parent.
   *
   * @return A ChildPropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Gtk::ChildPropertyProxy< PackType > child_property_pack_type(Gtk::Widget& child) ;

/** A GtkPackType indicating whether the child is packed with reference to the start or end of the parent.
   *
   * @return A ChildPropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Gtk::ChildPropertyProxy_ReadOnly< PackType > child_property_pack_type(const Gtk::Widget& child) const;

  /** The index of the child in the parent.
   *
   * @return A ChildPropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Gtk::ChildPropertyProxy< int > child_property_position(Gtk::Widget& child) ;

/** The index of the child in the parent.
   *
   * @return A ChildPropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Gtk::ChildPropertyProxy_ReadOnly< int > child_property_position(const Gtk::Widget& child) const;


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::Box
   */
  Gtk::Box* wrap(GtkBox* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_BOX_H */

