#include <global.h>
#include <gtop-page.h>

#include <gtop-fsusage.h>
#include <gtop-memusage.h>
#include <gtop-procview.h>

#include <session.h>

#include <string.h>

static GnomeUIInfo addChildMenu [];
static GnomeUIInfo addMemChildMenu [];
static GnomeUIInfo addFsChildMenu [];
static GnomeUIInfo addProcChildMenu [];

static void	add_fs_child_cb		(GtkWidget *, gpointer);
static void	add_mem_child_cb	(GtkWidget *, gpointer);
static void	add_proc_child_cb	(GtkWidget *, gpointer);

static void	reap_viewless_childs	(void);

static void	add_view_cb		(void);
static void	remove_view_cb		(void);
static void	remove_child_cb		(void);

GnomeUIInfo mdiMenu [] = {
	{ GNOME_APP_UI_ITEM, N_("Add view"), NULL, add_view_cb,
	  NULL, NULL, GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Remove view"), NULL, remove_view_cb,
	  NULL, NULL, GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_SUBTREE (N_("Add Child"), addChildMenu),
	{ GNOME_APP_UI_ITEM, N_("Remove child"), NULL, remove_child_cb,
	  NULL, NULL, GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL },
	GNOMEUIINFO_END
};

static GnomeUIInfo addChildMenu [] = {
	GNOMEUIINFO_SUBTREE (N_("Processes"), addProcChildMenu),
	GNOMEUIINFO_SUBTREE (N_("Memory Usage"), addMemChildMenu),
	GNOMEUIINFO_SUBTREE (N_("Filesystems"), addFsChildMenu),
	GNOMEUIINFO_END
};

GnomeUIInfo addProcChildMenu [] = {
	{ GNOME_APP_UI_ITEM, N_("All"), NULL, add_proc_child_cb,
	  (gpointer) GTOP_PROCVIEW_ALL, NULL, GNOME_APP_PIXMAP_NONE,
	  NULL, 0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("User"), NULL, add_proc_child_cb,
	  (gpointer) GTOP_PROCVIEW_USER, NULL, GNOME_APP_PIXMAP_NONE,
	  NULL, 0, 0, NULL },
	{ GNOME_APP_UI_ENDOFINFO }
};

GnomeUIInfo addMemChildMenu [] = {
	{ GNOME_APP_UI_ITEM, N_("Resident"), NULL, add_mem_child_cb,
	  (gpointer) GTOP_MEMUSAGE_RESIDENT, NULL, GNOME_APP_PIXMAP_NONE,
	  NULL, 0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Shared"), NULL, add_mem_child_cb,
	  (gpointer) GTOP_MEMUSAGE_SHARED, NULL, GNOME_APP_PIXMAP_NONE,
	  NULL, 0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Size"), NULL, add_mem_child_cb,
	  (gpointer) GTOP_MEMUSAGE_SIZE, NULL, GNOME_APP_PIXMAP_NONE,
	  NULL, 0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Virtual"), NULL, add_mem_child_cb,
	  (gpointer) GTOP_MEMUSAGE_VIRTUAL, NULL, GNOME_APP_PIXMAP_NONE,
	  NULL, 0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Swap"), NULL, add_mem_child_cb,
	  (gpointer) GTOP_MEMUSAGE_SWAP, NULL, GNOME_APP_PIXMAP_NONE,
	  NULL, 0, 0, NULL },
	{ GNOME_APP_UI_ENDOFINFO }
};

GnomeUIInfo addFsChildMenu [] = {
	{ GNOME_APP_UI_ITEM, N_("Total"), NULL, add_fs_child_cb,
	  (gpointer) GTOP_FSUSAGE_TOTAL, NULL, GNOME_APP_PIXMAP_NONE,
	  NULL, 0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Used"), NULL, add_fs_child_cb,
	  (gpointer) GTOP_FSUSAGE_USED, NULL, GNOME_APP_PIXMAP_NONE,
	  NULL, 0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Free"), NULL, add_fs_child_cb,
	  (gpointer) GTOP_FSUSAGE_FREE, NULL, GNOME_APP_PIXMAP_NONE,
	  NULL, 0, 0, NULL },
	{ GNOME_APP_UI_ENDOFINFO }
};

static void
add_fs_child_cb (GtkWidget *obj, gpointer type)
{
	GTopPage *page;
	gpointer uidata;

	uidata = gtk_object_get_data
		(GTK_OBJECT (obj), GNOMEUIINFO_KEY_UIDATA);

	page = gtop_page_new (GTOP_PAGE_FSUSAGE, GPOINTER_TO_INT (uidata));

	gnome_mdi_add_child (mdi, GNOME_MDI_CHILD (page));
	gnome_mdi_add_view (mdi, GNOME_MDI_CHILD (page));
}

static void
add_mem_child_cb (GtkWidget *obj, gpointer type)
{
	GTopPage *page;
	gpointer uidata;

	uidata = gtk_object_get_data
		(GTK_OBJECT (obj), GNOMEUIINFO_KEY_UIDATA);

	page = gtop_page_new (GTOP_PAGE_MEMUSAGE, GPOINTER_TO_INT (uidata));

	gnome_mdi_add_child (mdi, GNOME_MDI_CHILD (page));
	gnome_mdi_add_view (mdi, GNOME_MDI_CHILD (page));
}

static void
add_proc_child_cb (GtkWidget *obj, gpointer type)
{
	GTopPage *page;
	gpointer uidata;

	uidata = gtk_object_get_data
		(GTK_OBJECT (obj), GNOMEUIINFO_KEY_UIDATA);

	page = gtop_page_new (GTOP_PAGE_PROCVIEW, GPOINTER_TO_INT (uidata));

	gnome_mdi_add_child (mdi, GNOME_MDI_CHILD (page));
	gnome_mdi_add_view (mdi, GNOME_MDI_CHILD (page));
}

static void
add_view_cb (void)
{
	GnomeMDIChild *child = gnome_mdi_get_active_child (mdi);
	if (child) gnome_mdi_add_view (mdi, child);
}

static void
reap_viewless_childs (void)
{
	gint removed;

	do {
		GList *c;

		removed = 0;

		for (c = mdi->children; c; c = c->next) {
			GnomeMDIChild *child = c->data;
			
			if (child->views == NULL) {
				gnome_mdi_remove_child (mdi, child, FALSE);
				removed = TRUE;
				break;
			}
		}

	} while (removed);
}

static void
remove_view_cb (void)
{
	GtkWidget *active_view = gnome_mdi_get_active_view (mdi);

	if (active_view)
		gnome_mdi_remove_view (mdi, active_view, FALSE);
	
	reap_viewless_childs ();
}

static void
remove_child_cb (void)
{
	GnomeMDIChild *child = gnome_mdi_get_active_child (mdi);
	if (child) gnome_mdi_remove_child (mdi, child, FALSE);
}

static void
view_changed_cb (GnomeMDI *mdi, GtkWidget *old_view)
{
	gchar *path, *label;

	if (mdi->active_view == NULL)
		return;

  /* note that you can't use item numbers to determine menu number,
     because the first item could be the tear off one */

	if (IS_GTOP_FSUSAGE (mdi->active_view))
    label = gtop_fsusage_type_labels[GTOP_FSUSAGE (mdi->active_view)->data.ftype];
	else if (IS_GTOP_MEMUSAGE (mdi->active_view))
    label = gtop_memusage_type_labels[GTOP_MEMUSAGE (mdi->active_view)->data.ftype];
	else if (IS_GTOP_PROCVIEW (mdi->active_view))
    label = gtop_procview_type_labels[GTOP_PROCVIEW (mdi->active_view)->data.ftype];
  else
    label = NULL;

  if(label) {
    GtkWidget *submenu, *item = NULL; 
    gint pos;

    label = (label [0] == '\0' ? "" : _(label));

    path = g_strconcat(_("View"), "/", label, NULL);

    submenu = gnome_app_find_menu_pos
      (GNOME_APP (mdi->active_window)->menubar, path, &pos);

    if(submenu)
      item = g_list_nth_data (GTK_MENU_SHELL (submenu)->children, pos - 1);

    if(item)
      gtk_menu_shell_activate_item
        (GTK_MENU_SHELL (submenu), item, TRUE);

    g_free(path);
  }
}

void
gtop_mdi_start (gboolean init)
{
	GTopPage *page;
	GtkWidget *view;
	GtkWidget *window;

	gtk_signal_connect(GTK_OBJECT (mdi), "view_changed",
			   GTK_SIGNAL_FUNC (view_changed_cb), NULL);

	if (!init) return;

	page = gtop_page_new (GTOP_PAGE_PROCVIEW, GTOP_PROCVIEW_ALL);

	gnome_mdi_add_child (mdi, GNOME_MDI_CHILD (page));
	gnome_mdi_add_view (mdi, GNOME_MDI_CHILD (page));

	view = gnome_mdi_get_active_view (mdi);

	page = gtop_page_new (GTOP_PAGE_MEMUSAGE, GTOP_MEMUSAGE_RESIDENT);

	gnome_mdi_add_child (mdi, GNOME_MDI_CHILD (page));
	gnome_mdi_add_view (mdi, GNOME_MDI_CHILD (page));

	page = gtop_page_new (GTOP_PAGE_FSUSAGE, GTOP_FSUSAGE_FREE);

	gnome_mdi_add_child (mdi, GNOME_MDI_CHILD (page));
	gnome_mdi_add_view (mdi, GNOME_MDI_CHILD (page));

	gnome_mdi_set_active_view (mdi, view);

	if (initial_geometry) {
		window = GTK_WIDGET (mdi->active_window);

		gtk_widget_set_usize (window,
				      initial_geometry->width,
				      initial_geometry->height);

		gtk_widget_set_uposition (window,
					  initial_geometry->x,
					  initial_geometry->y);
	}
}
