/* External functions from turing_table_editor.h */
extern void turing_table_editor_set_model (GtkTreeView * treeview_editor, turing * tm);
extern GtkWidget * turing_table_editor_new (GtkTreeView ** tree);

/* Internal functions and callbacks */

turing *tm;

void power_do (void);
void power_callback (GtkWidget * power_button, gpointer data);
void state_clist_load_states (void);
void state_clist_select_state (turing * t);
void save_call (GtkWidget * w, gpointer data);

void set_save_sens (gboolean saves);
void set_toolbar_sens (gboolean powers, gboolean stops, gboolean plays, gboolean steps);
void set_tape (char *str);
void view_comment (void);

void set_states_fname (char *str);
void states_fname_examples_callback (GtkWidget * ok_button, gpointer data);
void states_fname_callback (GtkWidget * ok_button, gpointer data);
void tape_string_callback (GtkWidget * ok_button, gpointer data);
void speed_callback (GtkWidget * ok_button, gpointer data);
void cancel_callback (GtkWidget * widget, gpointer data);
void states_view_edit_set_clicked_callback (GtkWidget * widget, gpointer data);
void states_view_entry_grab_focus_callback (GtkWidget * widget, gpointer data);
void states_view_edit_callback (GtkWidget * widget, gpointer data);
void states_view_close_callback (GtkWidget * w, gpointer data);
int next_state (turing * t);
gint do_play (gpointer data);
void play_callback (GtkWidget * play_button, gpointer data);
void step_callback (GtkWidget * step_buttton, gpointer data);
void stop_callback (GtkWidget * stop_button, gpointer data);
void prompt (char *title, char *msg, GtkSignalFunc callback, char *def);
void open_call (GtkWidget * w, gpointer data);
void tape_call (GtkWidget * w, gpointer data);
void state_clist_select_row_callback (GtkCList * clist, gint row, gint column,
				 GdkEventButton * event,
				 gpointer user_data);
void view_states_call (GtkWidget * widget, gpointer data);
void view_comment_call (GtkWidget * w, gpointer data);
void exit_call (GtkWidget * w, gpointer data);
void playspeed_call (GtkWidget * w, gpointer data);

void viewstates_call (GtkWidget * w, gpointer data);
void operation_call (GtkWidget * w, gpointer data);

void about_call (GtkWidget * w, gpointer data);

void create_machine (void);
void init_interface (int argc, char *argv[]);
void init_globals (void);
void parse_args (int argc, char *argv[]);