/* SerializableObjectModel.c generated by valac 0.34.6, the Vala compiler
 * generated from SerializableObjectModel.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; c-basic-offset: 0; tab-width: 2 -*- */
/* ObjectModel.vala
 *
 * Copyright (C) 2013-2015  Daniel Espinosa <esodan@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      Daniel Espinosa <esodan@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define GXML_TYPE_SERIALIZABLE (gxml_serializable_get_type ())
#define GXML_SERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE, GXmlSerializable))
#define GXML_IS_SERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE))
#define GXML_SERIALIZABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_SERIALIZABLE, GXmlSerializableIface))

typedef struct _GXmlSerializable GXmlSerializable;
typedef struct _GXmlSerializableIface GXmlSerializableIface;

#define GXML_TYPE_NODE (gxml_node_get_type ())
#define GXML_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NODE, GXmlNode))
#define GXML_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NODE))
#define GXML_NODE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NODE, GXmlNodeIface))

typedef struct _GXmlNode GXmlNode;
typedef struct _GXmlNodeIface GXmlNodeIface;

#define GXML_TYPE_ELEMENT_LIST (gxml_element_list_get_type ())
#define GXML_ELEMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ELEMENT_LIST, GXmlElementList))
#define GXML_ELEMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_ELEMENT_LIST, GXmlElementListClass))
#define GXML_IS_ELEMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ELEMENT_LIST))
#define GXML_IS_ELEMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_ELEMENT_LIST))
#define GXML_ELEMENT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_ELEMENT_LIST, GXmlElementListClass))

typedef struct _GXmlElementList GXmlElementList;
typedef struct _GXmlElementListClass GXmlElementListClass;

#define GXML_TYPE_NAMESPACE (gxml_namespace_get_type ())
#define GXML_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NAMESPACE, GXmlNamespace))
#define GXML_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NAMESPACE))
#define GXML_NAMESPACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NAMESPACE, GXmlNamespaceIface))

typedef struct _GXmlNamespace GXmlNamespace;
typedef struct _GXmlNamespaceIface GXmlNamespaceIface;

#define GXML_TYPE_NODE_TYPE (gxml_node_type_get_type ())

#define GXML_TYPE_DOCUMENT (gxml_document_get_type ())
#define GXML_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOCUMENT, GXmlDocument))
#define GXML_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOCUMENT))
#define GXML_DOCUMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOCUMENT, GXmlDocumentIface))

typedef struct _GXmlDocument GXmlDocument;
typedef struct _GXmlDocumentIface GXmlDocumentIface;

#define GXML_TYPE_ATTRIBUTE (gxml_attribute_get_type ())
#define GXML_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ATTRIBUTE, GXmlAttribute))
#define GXML_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ATTRIBUTE))
#define GXML_ATTRIBUTE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_ATTRIBUTE, GXmlAttributeIface))

typedef struct _GXmlAttribute GXmlAttribute;
typedef struct _GXmlAttributeIface GXmlAttributeIface;

#define GXML_TYPE_SERIALIZABLE_OBJECT_MODEL (gxml_serializable_object_model_get_type ())
#define GXML_SERIALIZABLE_OBJECT_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE_OBJECT_MODEL, GXmlSerializableObjectModel))
#define GXML_SERIALIZABLE_OBJECT_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_SERIALIZABLE_OBJECT_MODEL, GXmlSerializableObjectModelClass))
#define GXML_IS_SERIALIZABLE_OBJECT_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE_OBJECT_MODEL))
#define GXML_IS_SERIALIZABLE_OBJECT_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_SERIALIZABLE_OBJECT_MODEL))
#define GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_SERIALIZABLE_OBJECT_MODEL, GXmlSerializableObjectModelClass))

typedef struct _GXmlSerializableObjectModel GXmlSerializableObjectModel;
typedef struct _GXmlSerializableObjectModelClass GXmlSerializableObjectModelClass;
typedef struct _GXmlSerializableObjectModelPrivate GXmlSerializableObjectModelPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GXML_TYPE_ELEMENT (gxml_element_get_type ())
#define GXML_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ELEMENT, GXmlElement))
#define GXML_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ELEMENT))
#define GXML_ELEMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_ELEMENT, GXmlElementIface))

typedef struct _GXmlElement GXmlElement;
typedef struct _GXmlElementIface GXmlElementIface;
#define _g_param_spec_unref0(var) ((var == NULL) ? NULL : (var = (g_param_spec_unref (var), NULL)))

#define GXML_TYPE_TEXT (gxml_text_get_type ())
#define GXML_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_TEXT, GXmlText))
#define GXML_IS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_TEXT))
#define GXML_TEXT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_TEXT, GXmlTextIface))

typedef struct _GXmlText GXmlText;
typedef struct _GXmlTextIface GXmlTextIface;

#define GXML_TYPE_SERIALIZABLE_PROPERTY (gxml_serializable_property_get_type ())
#define GXML_SERIALIZABLE_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE_PROPERTY, GXmlSerializableProperty))
#define GXML_IS_SERIALIZABLE_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE_PROPERTY))
#define GXML_SERIALIZABLE_PROPERTY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_SERIALIZABLE_PROPERTY, GXmlSerializablePropertyIface))

typedef struct _GXmlSerializableProperty GXmlSerializableProperty;
typedef struct _GXmlSerializablePropertyIface GXmlSerializablePropertyIface;

#define GXML_TYPE_SERIALIZABLE_COLLECTION (gxml_serializable_collection_get_type ())
#define GXML_SERIALIZABLE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE_COLLECTION, GXmlSerializableCollection))
#define GXML_IS_SERIALIZABLE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE_COLLECTION))
#define GXML_SERIALIZABLE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_SERIALIZABLE_COLLECTION, GXmlSerializableCollectionIface))

typedef struct _GXmlSerializableCollection GXmlSerializableCollection;
typedef struct _GXmlSerializableCollectionIface GXmlSerializableCollectionIface;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define GXML_TYPE_SERIALIZABLE_CONTAINER (gxml_serializable_container_get_type ())
#define GXML_SERIALIZABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE_CONTAINER, GXmlSerializableContainer))
#define GXML_SERIALIZABLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_SERIALIZABLE_CONTAINER, GXmlSerializableContainerClass))
#define GXML_IS_SERIALIZABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE_CONTAINER))
#define GXML_IS_SERIALIZABLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_SERIALIZABLE_CONTAINER))
#define GXML_SERIALIZABLE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_SERIALIZABLE_CONTAINER, GXmlSerializableContainerClass))

typedef struct _GXmlSerializableContainer GXmlSerializableContainer;
typedef struct _GXmlSerializableContainerClass GXmlSerializableContainerClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GXmlNamespaceIface {
	GTypeInterface parent_iface;
	gchar* (*get_uri) (GXmlNamespace* self);
	gchar* (*get_prefix) (GXmlNamespace* self);
};

typedef enum  {
	GXML_NODE_TYPE_INVALID = 0,
	GXML_NODE_TYPE_ELEMENT = 1,
	GXML_NODE_TYPE_ATTRIBUTE,
	GXML_NODE_TYPE_TEXT,
	GXML_NODE_TYPE_CDATA_SECTION,
	GXML_NODE_TYPE_ENTITY_REFERENCE,
	GXML_NODE_TYPE_ENTITY,
	GXML_NODE_TYPE_PROCESSING_INSTRUCTION,
	GXML_NODE_TYPE_COMMENT,
	GXML_NODE_TYPE_DOCUMENT,
	GXML_NODE_TYPE_DOCUMENT_TYPE,
	GXML_NODE_TYPE_DOCUMENT_FRAGMENT,
	GXML_NODE_TYPE_NOTATION
} GXmlNodeType;

struct _GXmlDocumentIface {
	GTypeInterface parent_iface;
	GXmlNode* (*create_element) (GXmlDocument* self, const gchar* name, GError** error);
	GXmlNode* (*create_text) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_comment) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_cdata) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_pi) (GXmlDocument* self, const gchar* target, const gchar* data);
	gboolean (*save) (GXmlDocument* self, GCancellable* cancellable, GError** error);
	gboolean (*save_as) (GXmlDocument* self, GFile* f, GCancellable* cancellable, GError** error);
	gboolean (*get_indent) (GXmlDocument* self);
	void (*set_indent) (GXmlDocument* self, gboolean value);
	gboolean (*get_ns_top) (GXmlDocument* self);
	void (*set_ns_top) (GXmlDocument* self, gboolean value);
	gboolean (*get_prefix_default_ns) (GXmlDocument* self);
	void (*set_prefix_default_ns) (GXmlDocument* self, gboolean value);
	gboolean (*get_backup) (GXmlDocument* self);
	void (*set_backup) (GXmlDocument* self, gboolean value);
	GXmlNode* (*get_root) (GXmlDocument* self);
	GFile* (*get_file) (GXmlDocument* self);
	void (*set_file) (GXmlDocument* self, GFile* value);
};

struct _GXmlNodeIface {
	GTypeInterface parent_iface;
	GXmlNode* (*get) (GXmlNode* self, const gchar* key);
	GXmlElementList* (*get_elements_by_property_value) (GXmlNode* self, const gchar* property, const gchar* value);
	GXmlElementList* (*get_elements_by_name) (GXmlNode* self, const gchar* name);
	GXmlElementList* (*get_elements_by_name_ns) (GXmlNode* self, const gchar* name, const gchar* ns);
	gchar* (*to_string) (GXmlNode* self);
	gboolean (*set_namespace) (GXmlNode* self, const gchar* uri, const gchar* prefix);
	gchar* (*ns_prefix) (GXmlNode* self);
	gchar* (*ns_uri) (GXmlNode* self);
	GeeList* (*get_namespaces) (GXmlNode* self);
	GeeBidirList* (*get_children_nodes) (GXmlNode* self);
	GeeMap* (*get_attrs) (GXmlNode* self);
	gchar* (*get_name) (GXmlNode* self);
	gchar* (*get_value) (GXmlNode* self);
	void (*set_value) (GXmlNode* self, const gchar* value);
	GXmlNodeType (*get_type_node) (GXmlNode* self);
	GXmlDocument* (*get_document) (GXmlNode* self);
	GXmlNode* (*get_parent) (GXmlNode* self);
};

struct _GXmlAttributeIface {
	GTypeInterface parent_iface;
	GXmlNamespace* (*get_namespace) (GXmlAttribute* self);
	void (*set_namespace) (GXmlAttribute* self, GXmlNamespace* value);
	gchar* (*get_prefix) (GXmlAttribute* self);
};

struct _GXmlSerializableIface {
	GTypeInterface parent_iface;
	gboolean (*get_enable_unknown_serializable_property) (GXmlSerializable* self);
	gboolean (*set_default_namespace) (GXmlSerializable* self, GXmlNode* node);
	gboolean (*serialize_use_xml_node_value) (GXmlSerializable* self);
	gchar* (*node_name) (GXmlSerializable* self);
	gboolean (*property_use_nick) (GXmlSerializable* self);
	GXmlNode* (*serialize) (GXmlSerializable* self, GXmlNode* node, GError** error);
	GXmlNode* (*serialize_property) (GXmlSerializable* self, GXmlNode* element, GParamSpec* prop, GError** error);
	gboolean (*deserialize) (GXmlSerializable* self, GXmlNode* node, GError** error);
	gboolean (*deserialize_property) (GXmlSerializable* self, GXmlNode* property_node, GError** error);
	GParamSpec* (*find_property_spec) (GXmlSerializable* self, const gchar* property_name);
	GParamSpec* (*default_find_property_spec) (GXmlSerializable* self, const gchar* property_name);
	GParamSpec** (*list_serializable_properties) (GXmlSerializable* self, int* result_length1);
	GParamSpec** (*default_list_serializable_properties) (GXmlSerializable* self, int* result_length1);
	GeeMap* (*get_unknown_serializable_properties) (GXmlSerializable* self);
	GeeCollection* (*get_unknown_serializable_nodes) (GXmlSerializable* self);
	gchar* (*get_serialized_xml_node_value) (GXmlSerializable* self);
	void (*set_serialized_xml_node_value) (GXmlSerializable* self, const gchar* value);
};

struct _GXmlSerializableObjectModel {
	GObject parent_instance;
	GXmlSerializableObjectModelPrivate * priv;
	GXmlNode* _node;
};

struct _GXmlSerializableObjectModelClass {
	GObjectClass parent_class;
	gboolean (*get_enable_unknown_serializable_property) (GXmlSerializableObjectModel* self);
	gboolean (*serialize_use_xml_node_value) (GXmlSerializableObjectModel* self);
	gboolean (*property_use_nick) (GXmlSerializableObjectModel* self);
	gboolean (*set_default_namespace) (GXmlSerializableObjectModel* self, GXmlNode* node);
	gchar* (*node_name) (GXmlSerializableObjectModel* self);
	GParamSpec* (*find_property_spec) (GXmlSerializableObjectModel* self, const gchar* property_name);
	GParamSpec** (*list_serializable_properties) (GXmlSerializableObjectModel* self, int* result_length1);
	GXmlNode* (*serialize) (GXmlSerializableObjectModel* self, GXmlNode* node, GError** error);
	GXmlNode* (*serialize_property) (GXmlSerializableObjectModel* self, GXmlNode* element, GParamSpec* prop, GError** error);
	gboolean (*deserialize) (GXmlSerializableObjectModel* self, GXmlNode* node, GError** error);
	gboolean (*deserialize_property) (GXmlSerializableObjectModel* self, GXmlNode* property_node, GError** error);
	gchar* (*to_string) (GXmlSerializableObjectModel* self);
};

struct _GXmlSerializableObjectModelPrivate {
	GParamSpec** _properties;
	gint _properties_length1;
	gint __properties_size_;
	GHashTable* _ignored_serializable_properties;
	gchar* _serialized_xml_node_value;
};

struct _GXmlElementIface {
	GTypeInterface parent_iface;
	void (*normalize) (GXmlElement* self);
	void (*set_attr) (GXmlElement* self, const gchar* name, const gchar* value);
	GXmlNode* (*get_attr) (GXmlElement* self, const gchar* name);
	void (*remove_attr) (GXmlElement* self, const gchar* name);
	void (*remove_ns_attr) (GXmlElement* self, const gchar* name, const gchar* uri);
	void (*set_ns_attr) (GXmlElement* self, const gchar* ns, const gchar* name, const gchar* value);
	GXmlNode* (*get_ns_attr) (GXmlElement* self, const gchar* name, const gchar* uri);
	gchar* (*get_tag_name) (GXmlElement* self);
	gchar* (*get_content) (GXmlElement* self);
	void (*set_content) (GXmlElement* self, const gchar* value);
};

struct _GXmlTextIface {
	GTypeInterface parent_iface;
	gchar* (*get_str) (GXmlText* self);
	void (*set_str) (GXmlText* self, const gchar* value);
};

struct _GXmlSerializablePropertyIface {
	GTypeInterface parent_iface;
	gchar* (*get_serializable_property_value) (GXmlSerializableProperty* self);
	void (*set_serializable_property_value) (GXmlSerializableProperty* self, const gchar* val);
	gboolean (*deserialize_property) (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error);
	GXmlNode* (*serialize_property) (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error);
};

struct _GXmlSerializableCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*deserialize_proceed) (GXmlSerializableCollection* self);
	gboolean (*deserialized) (GXmlSerializableCollection* self);
	gboolean (*deserialize_node) (GXmlSerializableCollection* self, GXmlNode* node, GError** error);
	gboolean (*deserialize_children) (GXmlSerializableCollection* self, GError** error);
	gboolean (*is_collection) (GXmlSerializableCollection* self);
};

typedef enum  {
	GXML_ENUMERATION_ERROR_INVALID_VALUE,
	GXML_ENUMERATION_ERROR_INVALID_TEXT
} GXmlEnumerationError;
#define GXML_ENUMERATION_ERROR gxml_enumeration_error_quark ()
typedef enum  {
	GXML_SERIALIZABLE_ERROR_UNSUPPORTED_TYPE_ERROR,
	GXML_SERIALIZABLE_ERROR_STR_TO_VALUE_ERROR
} GXmlSerializableError;
#define GXML_SERIALIZABLE_ERROR gxml_serializable_error_quark ()

static gpointer gxml_serializable_object_model_parent_class = NULL;
static GXmlSerializableIface* gxml_serializable_object_model_gxml_serializable_parent_iface = NULL;

GType gxml_element_list_get_type (void) G_GNUC_CONST;
GType gxml_namespace_get_type (void) G_GNUC_CONST;
GType gxml_node_type_get_type (void) G_GNUC_CONST;
GType gxml_document_get_type (void) G_GNUC_CONST;
GType gxml_node_get_type (void) G_GNUC_CONST;
GType gxml_attribute_get_type (void) G_GNUC_CONST;
GType gxml_serializable_get_type (void) G_GNUC_CONST;
GType gxml_serializable_object_model_get_type (void) G_GNUC_CONST;
#define GXML_SERIALIZABLE_OBJECT_MODEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GXML_TYPE_SERIALIZABLE_OBJECT_MODEL, GXmlSerializableObjectModelPrivate))
enum  {
	GXML_SERIALIZABLE_OBJECT_MODEL_DUMMY_PROPERTY,
	GXML_SERIALIZABLE_OBJECT_MODEL_IGNORED_SERIALIZABLE_PROPERTIES,
	GXML_SERIALIZABLE_OBJECT_MODEL_SERIALIZED_XML_NODE_VALUE,
	GXML_SERIALIZABLE_OBJECT_MODEL_UNKNOWN_SERIALIZABLE_PROPERTIES,
	GXML_SERIALIZABLE_OBJECT_MODEL_UNKNOWN_SERIALIZABLE_NODES
};
gboolean gxml_serializable_object_model_get_enable_unknown_serializable_property (GXmlSerializableObjectModel* self);
static gboolean gxml_serializable_object_model_real_get_enable_unknown_serializable_property (GXmlSerializableObjectModel* self);
gboolean gxml_serializable_object_model_serialize_use_xml_node_value (GXmlSerializableObjectModel* self);
static gboolean gxml_serializable_object_model_real_serialize_use_xml_node_value (GXmlSerializableObjectModel* self);
gboolean gxml_serializable_object_model_property_use_nick (GXmlSerializableObjectModel* self);
static gboolean gxml_serializable_object_model_real_property_use_nick (GXmlSerializableObjectModel* self);
gboolean gxml_serializable_object_model_set_default_namespace (GXmlSerializableObjectModel* self, GXmlNode* node);
static gboolean gxml_serializable_object_model_real_set_default_namespace (GXmlSerializableObjectModel* self, GXmlNode* node);
gchar* gxml_serializable_object_model_node_name (GXmlSerializableObjectModel* self);
static gchar* gxml_serializable_object_model_real_node_name (GXmlSerializableObjectModel* self);
gchar* gxml_serializable_object_model_default_node_name (GXmlSerializableObjectModel* self);
GParamSpec* gxml_serializable_object_model_find_property_spec (GXmlSerializableObjectModel* self, const gchar* property_name);
static GParamSpec* gxml_serializable_object_model_real_find_property_spec (GXmlSerializableObjectModel* self, const gchar* property_name);
GParamSpec* gxml_serializable_default_find_property_spec (GXmlSerializable* self, const gchar* property_name);
GParamSpec** gxml_serializable_object_model_list_serializable_properties (GXmlSerializableObjectModel* self, int* result_length1);
static GParamSpec** gxml_serializable_object_model_real_list_serializable_properties (GXmlSerializableObjectModel* self, int* result_length1);
GParamSpec** gxml_serializable_default_list_serializable_properties (GXmlSerializable* self, int* result_length1);
GXmlNode* gxml_serializable_object_model_serialize (GXmlSerializableObjectModel* self, GXmlNode* node, GError** error);
static GXmlNode* gxml_serializable_object_model_real_serialize (GXmlSerializableObjectModel* self, GXmlNode* node, GError** error);
GType gxml_element_get_type (void) G_GNUC_CONST;
GXmlNode* gxml_serializable_object_model_default_serialize (GXmlSerializableObjectModel* self, GXmlNode* node, GError** error);
gchar* gxml_node_get_name (GXmlNode* self);
GXmlDocument* gxml_node_get_document (GXmlNode* self);
GXmlNode* gxml_document_create_element (GXmlDocument* self, const gchar* name, GError** error);
GeeBidirList* gxml_node_get_children_nodes (GXmlNode* self);
GXmlNode* gxml_serializable_object_model_serialize_property (GXmlSerializableObjectModel* self, GXmlNode* element, GParamSpec* prop, GError** error);
GeeMap* gxml_serializable_get_unknown_serializable_properties (GXmlSerializable* self);
void gxml_element_set_attr (GXmlElement* self, const gchar* name, const gchar* value);
gchar* gxml_node_get_value (GXmlNode* self);
GeeCollection* gxml_serializable_get_unknown_serializable_nodes (GXmlSerializable* self);
gboolean gxml_node_copy (GXmlDocument* doc, GXmlNode* node, GXmlNode* source, gboolean deep);
GType gxml_text_get_type (void) G_GNUC_CONST;
GXmlNode* gxml_document_create_text (GXmlDocument* self, const gchar* text);
gchar* gxml_serializable_get_serialized_xml_node_value (GXmlSerializable* self);
static GXmlNode* gxml_serializable_object_model_real_serialize_property (GXmlSerializableObjectModel* self, GXmlNode* element, GParamSpec* prop, GError** error);
GXmlNode* gxml_serializable_object_model_default_serialize_property (GXmlSerializableObjectModel* self, GXmlElement* element, GParamSpec* prop, GError** error);
GType gxml_serializable_property_get_type (void) G_GNUC_CONST;
GXmlNode* gxml_serializable_property_serialize_property (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error);
GType gxml_serializable_collection_get_type (void) G_GNUC_CONST;
gboolean gxml_serializable_collection_deserialized (GXmlSerializableCollection* self);
gboolean gxml_serializable_collection_deserialize_children (GXmlSerializableCollection* self, GError** error);
GXmlNode* gxml_serializable_serialize (GXmlSerializable* self, GXmlNode* node, GError** error);
gchar* gxml_enumeration_get_nick_camelcase (GType enumeration, gint val, GError** error);
GQuark gxml_enumeration_error_quark (void);
GXmlNode* gxml_element_get_attr (GXmlElement* self, const gchar* name);
void gxml_node_set_value (GXmlNode* self, const gchar* value);
gboolean gxml_serializable_object_model_deserialize (GXmlSerializableObjectModel* self, GXmlNode* node, GError** error);
static gboolean gxml_serializable_object_model_real_deserialize (GXmlSerializableObjectModel* self, GXmlNode* node, GError** error);
gboolean gxml_serializable_object_model_default_deserialize (GXmlSerializableObjectModel* self, GXmlNode* node, GError** error);
GXmlNode* gxml_document_get_root (GXmlDocument* self);
GeeMap* gxml_node_get_attrs (GXmlNode* self);
gboolean gxml_serializable_object_model_deserialize_property (GXmlSerializableObjectModel* self, GXmlNode* property_node, GError** error);
GType gxml_serializable_container_get_type (void) G_GNUC_CONST;
void gxml_serializable_container_init_containers (GXmlSerializableContainer* self);
gchar* gxml_serializable_node_name (GXmlSerializable* self);
gboolean gxml_serializable_deserialize (GXmlSerializable* self, GXmlNode* node, GError** error);
static gboolean gxml_serializable_object_model_real_deserialize_property (GXmlSerializableObjectModel* self, GXmlNode* property_node, GError** error);
gboolean gxml_serializable_object_model_default_deserialize_property (GXmlSerializableObjectModel* self, GXmlNode* property_node, GError** error);
void gxml_serializable_set_serialized_xml_node_value (GXmlSerializable* self, const gchar* value);
GXmlNode* gxml_node_get_parent (GXmlNode* self);
gboolean gxml_serializable_property_deserialize_property (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error);
GEnumValue* gxml_enumeration_parse (GType enumeration, const gchar* val, GError** error);
GQuark gxml_serializable_error_quark (void);
gboolean gxml_serializable_string_to_gvalue (const gchar* str, GValue* dest, GError** error);
gchar* gxml_serializable_object_model_to_string (GXmlSerializableObjectModel* self);
static gchar* gxml_serializable_object_model_real_to_string (GXmlSerializableObjectModel* self);
GXmlSerializableObjectModel* gxml_serializable_object_model_construct (GType object_type);
GParamSpec** gxml_serializable_object_model_get_properties (GXmlSerializableObjectModel* self, int* result_length1);
void gxml_serializable_object_model_set_properties (GXmlSerializableObjectModel* self, GParamSpec** value, int value_length1);
static GParamSpec** _vala_array_dup3 (GParamSpec** self, int length);
GHashTable* gxml_serializable_object_model_get_ignored_serializable_properties (GXmlSerializableObjectModel* self);
void gxml_serializable_object_model_set_ignored_serializable_properties (GXmlSerializableObjectModel* self, GHashTable* value);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value);
static GObject * gxml_serializable_object_model_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void gxml_init_init (void);
static void gxml_serializable_object_model_finalize (GObject* obj);
static void _vala_gxml_serializable_object_model_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gxml_serializable_object_model_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gboolean gxml_serializable_object_model_real_get_enable_unknown_serializable_property (GXmlSerializableObjectModel* self) {
	gboolean result = FALSE;
	result = FALSE;
	return result;
}


gboolean gxml_serializable_object_model_get_enable_unknown_serializable_property (GXmlSerializableObjectModel* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->get_enable_unknown_serializable_property (self);
}


static gboolean gxml_serializable_object_model_real_serialize_use_xml_node_value (GXmlSerializableObjectModel* self) {
	gboolean result = FALSE;
	result = FALSE;
	return result;
}


gboolean gxml_serializable_object_model_serialize_use_xml_node_value (GXmlSerializableObjectModel* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->serialize_use_xml_node_value (self);
}


static gboolean gxml_serializable_object_model_real_property_use_nick (GXmlSerializableObjectModel* self) {
	gboolean result = FALSE;
	result = FALSE;
	return result;
}


gboolean gxml_serializable_object_model_property_use_nick (GXmlSerializableObjectModel* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->property_use_nick (self);
}


static gboolean gxml_serializable_object_model_real_set_default_namespace (GXmlSerializableObjectModel* self, GXmlNode* node) {
	gboolean result = FALSE;
	g_return_val_if_fail (node != NULL, FALSE);
	result = TRUE;
	return result;
}


gboolean gxml_serializable_object_model_set_default_namespace (GXmlSerializableObjectModel* self, GXmlNode* node) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->set_default_namespace (self, node);
}


static gchar* gxml_serializable_object_model_real_node_name (GXmlSerializableObjectModel* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	_tmp0_ = gxml_serializable_object_model_default_node_name (self);
	result = _tmp0_;
	return result;
}


gchar* gxml_serializable_object_model_node_name (GXmlSerializableObjectModel* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->node_name (self);
}


gchar* gxml_serializable_object_model_default_node_name (GXmlSerializableObjectModel* self) {
	gchar* result = NULL;
	GType _tmp0_ = 0UL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
	_tmp1_ = g_type_name (_tmp0_);
	_tmp2_ = g_utf8_strdown (_tmp1_, (gssize) -1);
	result = _tmp2_;
	return result;
}


static GParamSpec* gxml_serializable_object_model_real_find_property_spec (GXmlSerializableObjectModel* self, const gchar* property_name) {
	GParamSpec* result = NULL;
	const gchar* _tmp0_ = NULL;
	GParamSpec* _tmp1_ = NULL;
	g_return_val_if_fail (property_name != NULL, NULL);
	_tmp0_ = property_name;
	_tmp1_ = gxml_serializable_default_find_property_spec ((GXmlSerializable*) self, _tmp0_);
	result = _tmp1_;
	return result;
}


GParamSpec* gxml_serializable_object_model_find_property_spec (GXmlSerializableObjectModel* self, const gchar* property_name) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->find_property_spec (self, property_name);
}


static GParamSpec** gxml_serializable_object_model_real_list_serializable_properties (GXmlSerializableObjectModel* self, int* result_length1) {
	GParamSpec** result = NULL;
	gint _tmp0_ = 0;
	GParamSpec** _tmp1_ = NULL;
	GParamSpec** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	_tmp1_ = gxml_serializable_default_list_serializable_properties ((GXmlSerializable*) self, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}


GParamSpec** gxml_serializable_object_model_list_serializable_properties (GXmlSerializableObjectModel* self, int* result_length1) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->list_serializable_properties (self, result_length1);
}


static GXmlNode* gxml_serializable_object_model_real_serialize (GXmlSerializableObjectModel* self, GXmlNode* node, GError** error) {
	GXmlNode* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GXmlNode* _tmp2_ = NULL;
	GXmlNode* _tmp3_ = NULL;
	GXmlNode* _tmp4_ = NULL;
	GXmlNode* _tmp5_ = NULL;
	GXmlNode* _tmp6_ = NULL;
	GXmlNode* _tmp7_ = NULL;
	GXmlNode* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = gxml_serializable_object_model_node_name (self);
	_tmp1_ = _tmp0_;
	_vala_return_val_if_fail (_tmp1_ != NULL, "node_name () != null", NULL);
	_tmp2_ = node;
	_tmp3_ = node;
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GXML_TYPE_DOCUMENT) || G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GXML_TYPE_ELEMENT), "node is GXml.Document || node is GXml.Element", NULL);
	_tmp5_ = node;
	_tmp6_ = gxml_serializable_object_model_default_serialize (self, _tmp5_, &_inner_error_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp1_);
	_tmp4_ = _tmp7_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp8_ = _tmp4_;
	_tmp4_ = NULL;
	result = _tmp8_;
	_g_object_unref0 (_tmp4_);
	return result;
}


GXmlNode* gxml_serializable_object_model_serialize (GXmlSerializableObjectModel* self, GXmlNode* node, GError** error) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GXmlNode* _tmp2_ = NULL;
	GXmlNode* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gxml_serializable_object_model_node_name (self);
	_tmp1_ = _tmp0_;
	_vala_return_val_if_fail (_tmp1_ != NULL, "node_name () != null", NULL);
	_tmp2_ = node;
	_tmp3_ = node;
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GXML_TYPE_DOCUMENT) || G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GXML_TYPE_ELEMENT), "node is GXml.Document || node is GXml.Element", NULL);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->serialize (self, node, error);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _g_param_spec_ref0 (gpointer self) {
	return self ? g_param_spec_ref (self) : NULL;
}


GXmlNode* gxml_serializable_object_model_default_serialize (GXmlSerializableObjectModel* self, GXmlNode* node, GError** error) {
	GXmlNode* result = NULL;
	GXmlNode* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GXmlDocument* doc = NULL;
	GXmlNode* _tmp4_ = NULL;
	GXmlNode* _tmp11_ = NULL;
	GXmlDocument* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	GXmlNode* _tmp15_ = NULL;
	GXmlNode* _tmp16_ = NULL;
	GXmlElement* element = NULL;
	GXmlNode* _tmp17_ = NULL;
	GXmlNode* _tmp18_ = NULL;
	GeeBidirList* _tmp19_ = NULL;
	GeeBidirList* _tmp20_ = NULL;
	GeeBidirList* _tmp21_ = NULL;
	GXmlElement* _tmp22_ = NULL;
	GXmlElement* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	GParamSpec** _tmp25_ = NULL;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp101_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = node;
	_tmp1_ = gxml_node_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_vala_assert (_tmp3_ != NULL, "node.name != null");
	_g_free0 (_tmp3_);
	_tmp4_ = node;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, GXML_TYPE_DOCUMENT)) {
		GXmlNode* _tmp5_ = NULL;
		GXmlDocument* _tmp6_ = NULL;
		_tmp5_ = node;
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GXML_TYPE_DOCUMENT, GXmlDocument));
		_g_object_unref0 (doc);
		doc = _tmp6_;
	} else {
		GXmlNode* _tmp7_ = NULL;
		GXmlDocument* _tmp8_ = NULL;
		GXmlDocument* _tmp9_ = NULL;
		GXmlDocument* _tmp10_ = NULL;
		_tmp7_ = node;
		_tmp8_ = gxml_node_get_document (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _g_object_ref0 (_tmp9_);
		_g_object_unref0 (doc);
		doc = _tmp10_;
	}
	_tmp12_ = doc;
	_tmp13_ = gxml_serializable_object_model_node_name (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = gxml_document_create_element (_tmp12_, _tmp14_, &_inner_error_);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	_tmp11_ = _tmp16_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (doc);
		return NULL;
	}
	_tmp17_ = _tmp11_;
	_tmp11_ = NULL;
	element = G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GXML_TYPE_ELEMENT, GXmlElement);
	_tmp18_ = node;
	_tmp19_ = gxml_node_get_children_nodes (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = _tmp20_;
	_tmp22_ = element;
	gee_collection_add ((GeeCollection*) _tmp21_, (GXmlNode*) _tmp22_);
	_g_object_unref0 (_tmp21_);
	_tmp23_ = element;
	gxml_serializable_object_model_set_default_namespace (self, (GXmlNode*) _tmp23_);
	_tmp25_ = gxml_serializable_object_model_list_serializable_properties (self, &_tmp24_);
	{
		GParamSpec** spec_collection = NULL;
		gint spec_collection_length1 = 0;
		gint _spec_collection_size_ = 0;
		gint spec_it = 0;
		spec_collection = _tmp25_;
		spec_collection_length1 = _tmp24_;
		for (spec_it = 0; spec_it < _tmp24_; spec_it = spec_it + 1) {
			GParamSpec* _tmp26_ = NULL;
			GParamSpec* spec = NULL;
			_tmp26_ = _g_param_spec_ref0 (spec_collection[spec_it]);
			spec = _tmp26_;
			{
				GXmlElement* _tmp27_ = NULL;
				GParamSpec* _tmp28_ = NULL;
				GXmlNode* _tmp29_ = NULL;
				GXmlNode* _tmp30_ = NULL;
				_tmp27_ = element;
				_tmp28_ = spec;
				_tmp29_ = gxml_serializable_object_model_serialize_property (self, (GXmlNode*) _tmp27_, _tmp28_, &_inner_error_);
				_tmp30_ = _tmp29_;
				_g_object_unref0 (_tmp30_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_param_spec_unref0 (spec);
					spec_collection = (_vala_array_free (spec_collection, spec_collection_length1, (GDestroyNotify) g_param_spec_unref), NULL);
					_g_object_unref0 (element);
					_g_object_unref0 (_tmp11_);
					_g_object_unref0 (doc);
					return NULL;
				}
				_g_param_spec_unref0 (spec);
			}
		}
		spec_collection = (_vala_array_free (spec_collection, spec_collection_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	}
	_tmp31_ = gxml_serializable_object_model_get_enable_unknown_serializable_property (self);
	if (_tmp31_) {
		{
			GeeIterator* _attr_it = NULL;
			GeeMap* _tmp32_ = NULL;
			GeeMap* _tmp33_ = NULL;
			GeeMap* _tmp34_ = NULL;
			GeeCollection* _tmp35_ = NULL;
			GeeCollection* _tmp36_ = NULL;
			GeeCollection* _tmp37_ = NULL;
			GeeIterator* _tmp38_ = NULL;
			GeeIterator* _tmp39_ = NULL;
			_tmp32_ = gxml_serializable_get_unknown_serializable_properties ((GXmlSerializable*) self);
			_tmp33_ = _tmp32_;
			_tmp34_ = _tmp33_;
			_tmp35_ = gee_map_get_values (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = _tmp36_;
			_tmp38_ = gee_iterable_iterator ((GeeIterable*) _tmp37_);
			_tmp39_ = _tmp38_;
			_g_object_unref0 (_tmp37_);
			_g_object_unref0 (_tmp34_);
			_attr_it = _tmp39_;
			while (TRUE) {
				GeeIterator* _tmp40_ = NULL;
				gboolean _tmp41_ = FALSE;
				GXmlAttribute* attr = NULL;
				GeeIterator* _tmp42_ = NULL;
				gpointer _tmp43_ = NULL;
				GXmlElement* _tmp44_ = NULL;
				GXmlAttribute* _tmp45_ = NULL;
				gchar* _tmp46_ = NULL;
				gchar* _tmp47_ = NULL;
				gchar* _tmp48_ = NULL;
				GXmlAttribute* _tmp49_ = NULL;
				gchar* _tmp50_ = NULL;
				gchar* _tmp51_ = NULL;
				gchar* _tmp52_ = NULL;
				_tmp40_ = _attr_it;
				_tmp41_ = gee_iterator_next (_tmp40_);
				if (!_tmp41_) {
					break;
				}
				_tmp42_ = _attr_it;
				_tmp43_ = gee_iterator_get (_tmp42_);
				attr = (GXmlAttribute*) _tmp43_;
				_tmp44_ = element;
				_tmp45_ = attr;
				_tmp46_ = gxml_node_get_name ((GXmlNode*) _tmp45_);
				_tmp47_ = _tmp46_;
				_tmp48_ = _tmp47_;
				_tmp49_ = attr;
				_tmp50_ = gxml_node_get_value ((GXmlNode*) _tmp49_);
				_tmp51_ = _tmp50_;
				_tmp52_ = _tmp51_;
				gxml_element_set_attr (_tmp44_, _tmp48_, _tmp52_);
				_g_free0 (_tmp52_);
				_g_free0 (_tmp48_);
				_g_object_unref0 (attr);
			}
			_g_object_unref0 (_attr_it);
		}
		{
			GeeIterator* _n_it = NULL;
			GeeCollection* _tmp53_ = NULL;
			GeeCollection* _tmp54_ = NULL;
			GeeCollection* _tmp55_ = NULL;
			GeeIterator* _tmp56_ = NULL;
			GeeIterator* _tmp57_ = NULL;
			_tmp53_ = gxml_serializable_get_unknown_serializable_nodes ((GXmlSerializable*) self);
			_tmp54_ = _tmp53_;
			_tmp55_ = _tmp54_;
			_tmp56_ = gee_iterable_iterator ((GeeIterable*) _tmp55_);
			_tmp57_ = _tmp56_;
			_g_object_unref0 (_tmp55_);
			_n_it = _tmp57_;
			while (TRUE) {
				GeeIterator* _tmp58_ = NULL;
				gboolean _tmp59_ = FALSE;
				GXmlNode* n = NULL;
				GeeIterator* _tmp60_ = NULL;
				gpointer _tmp61_ = NULL;
				GXmlNode* _tmp62_ = NULL;
				gboolean _tmp80_ = FALSE;
				GXmlNode* _tmp81_ = NULL;
				_tmp58_ = _n_it;
				_tmp59_ = gee_iterator_next (_tmp58_);
				if (!_tmp59_) {
					break;
				}
				_tmp60_ = _n_it;
				_tmp61_ = gee_iterator_get (_tmp60_);
				n = (GXmlNode*) _tmp61_;
				_tmp62_ = n;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp62_, GXML_TYPE_ELEMENT)) {
					GXmlNode* e = NULL;
					GXmlDocument* _tmp63_ = NULL;
					GXmlNode* _tmp64_ = NULL;
					gchar* _tmp65_ = NULL;
					gchar* _tmp66_ = NULL;
					gchar* _tmp67_ = NULL;
					GXmlNode* _tmp68_ = NULL;
					GXmlNode* _tmp69_ = NULL;
					GXmlNode* _tmp70_ = NULL;
					GXmlDocument* _tmp71_ = NULL;
					GXmlDocument* _tmp72_ = NULL;
					GXmlNode* _tmp73_ = NULL;
					GXmlNode* _tmp74_ = NULL;
					GXmlElement* _tmp75_ = NULL;
					GeeBidirList* _tmp76_ = NULL;
					GeeBidirList* _tmp77_ = NULL;
					GeeBidirList* _tmp78_ = NULL;
					GXmlNode* _tmp79_ = NULL;
					_tmp63_ = doc;
					_tmp64_ = n;
					_tmp65_ = gxml_node_get_name (_tmp64_);
					_tmp66_ = _tmp65_;
					_tmp67_ = _tmp66_;
					_tmp68_ = gxml_document_create_element (_tmp63_, _tmp67_, &_inner_error_);
					_tmp69_ = _tmp68_;
					_g_free0 (_tmp67_);
					e = _tmp69_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (n);
						_g_object_unref0 (_n_it);
						_g_object_unref0 (element);
						_g_object_unref0 (_tmp11_);
						_g_object_unref0 (doc);
						return NULL;
					}
					_tmp70_ = node;
					_tmp71_ = gxml_node_get_document (_tmp70_);
					_tmp72_ = _tmp71_;
					_tmp73_ = e;
					_tmp74_ = n;
					gxml_node_copy (_tmp72_, _tmp73_, _tmp74_, TRUE);
					_tmp75_ = element;
					_tmp76_ = gxml_node_get_children_nodes ((GXmlNode*) _tmp75_);
					_tmp77_ = _tmp76_;
					_tmp78_ = _tmp77_;
					_tmp79_ = e;
					gee_collection_add ((GeeCollection*) _tmp78_, _tmp79_);
					_g_object_unref0 (_tmp78_);
					_g_object_unref0 (e);
				}
				_tmp81_ = n;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp81_, GXML_TYPE_TEXT)) {
					gboolean _tmp82_ = FALSE;
					_tmp82_ = gxml_serializable_object_model_serialize_use_xml_node_value (self);
					_tmp80_ = !_tmp82_;
				} else {
					_tmp80_ = FALSE;
				}
				if (_tmp80_) {
					GXmlNode* _tmp83_ = NULL;
					gchar* _tmp84_ = NULL;
					gchar* _tmp85_ = NULL;
					gchar* _tmp86_ = NULL;
					gboolean _tmp87_ = FALSE;
					GXmlNode* t = NULL;
					GXmlDocument* _tmp88_ = NULL;
					GXmlNode* _tmp89_ = NULL;
					gchar* _tmp90_ = NULL;
					gchar* _tmp91_ = NULL;
					gchar* _tmp92_ = NULL;
					const gchar* _tmp93_ = NULL;
					GXmlNode* _tmp94_ = NULL;
					GXmlNode* _tmp95_ = NULL;
					GXmlElement* _tmp96_ = NULL;
					GeeBidirList* _tmp97_ = NULL;
					GeeBidirList* _tmp98_ = NULL;
					GeeBidirList* _tmp99_ = NULL;
					GXmlNode* _tmp100_ = NULL;
					_tmp83_ = n;
					_tmp84_ = gxml_node_get_value (_tmp83_);
					_tmp85_ = _tmp84_;
					_tmp86_ = _tmp85_;
					_tmp87_ = g_strcmp0 (_tmp86_, "") == 0;
					_g_free0 (_tmp86_);
					if (_tmp87_) {
						_g_object_unref0 (n);
						continue;
					}
					_tmp88_ = doc;
					_tmp89_ = n;
					_tmp90_ = gxml_node_get_value (_tmp89_);
					_tmp91_ = _tmp90_;
					_tmp92_ = _tmp91_;
					_tmp93_ = g_strstrip (_tmp92_);
					_tmp94_ = gxml_document_create_text (_tmp88_, _tmp93_);
					_tmp95_ = _tmp94_;
					_g_free0 (_tmp92_);
					t = _tmp95_;
					_tmp96_ = element;
					_tmp97_ = gxml_node_get_children_nodes ((GXmlNode*) _tmp96_);
					_tmp98_ = _tmp97_;
					_tmp99_ = _tmp98_;
					_tmp100_ = t;
					gee_collection_add ((GeeCollection*) _tmp99_, _tmp100_);
					_g_object_unref0 (_tmp99_);
					_g_object_unref0 (t);
				}
				_g_object_unref0 (n);
			}
			_g_object_unref0 (_n_it);
		}
	}
	_tmp101_ = gxml_serializable_object_model_serialize_use_xml_node_value (self);
	if (_tmp101_) {
		gchar* txt = NULL;
		gchar* _tmp102_ = NULL;
		gchar* _tmp103_ = NULL;
		gchar* _tmp104_ = NULL;
		gchar* _tmp105_ = NULL;
		gboolean _tmp106_ = FALSE;
		GXmlNode* t = NULL;
		GXmlDocument* _tmp109_ = NULL;
		const gchar* _tmp110_ = NULL;
		GXmlNode* _tmp111_ = NULL;
		GXmlElement* _tmp112_ = NULL;
		GeeBidirList* _tmp113_ = NULL;
		GeeBidirList* _tmp114_ = NULL;
		GeeBidirList* _tmp115_ = NULL;
		GXmlNode* _tmp116_ = NULL;
		_tmp102_ = g_strdup ("");
		txt = _tmp102_;
		_tmp103_ = gxml_serializable_get_serialized_xml_node_value ((GXmlSerializable*) self);
		_tmp104_ = _tmp103_;
		_tmp105_ = _tmp104_;
		_tmp106_ = _tmp105_ != NULL;
		_g_free0 (_tmp105_);
		if (_tmp106_) {
			gchar* _tmp107_ = NULL;
			gchar* _tmp108_ = NULL;
			_tmp107_ = gxml_serializable_get_serialized_xml_node_value ((GXmlSerializable*) self);
			_tmp108_ = _tmp107_;
			_g_free0 (txt);
			txt = _tmp108_;
		}
		_tmp109_ = doc;
		_tmp110_ = txt;
		_tmp111_ = gxml_document_create_text (_tmp109_, _tmp110_);
		t = _tmp111_;
		_tmp112_ = element;
		_tmp113_ = gxml_node_get_children_nodes ((GXmlNode*) _tmp112_);
		_tmp114_ = _tmp113_;
		_tmp115_ = _tmp114_;
		_tmp116_ = t;
		gee_collection_add ((GeeCollection*) _tmp115_, _tmp116_);
		_g_object_unref0 (_tmp115_);
		_g_object_unref0 (t);
		_g_free0 (txt);
	}
	result = (GXmlNode*) element;
	_g_object_unref0 (_tmp11_);
	_g_object_unref0 (doc);
	return result;
}


static GXmlNode* gxml_serializable_object_model_real_serialize_property (GXmlSerializableObjectModel* self, GXmlNode* element, GParamSpec* prop, GError** error) {
	GXmlNode* result = NULL;
	GXmlNode* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (element != NULL, NULL);
	g_return_val_if_fail (prop != NULL, NULL);
	_tmp0_ = element;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GXML_TYPE_ELEMENT)) {
		GXmlNode* _tmp1_ = NULL;
		GXmlNode* _tmp2_ = NULL;
		GParamSpec* _tmp3_ = NULL;
		GXmlNode* _tmp4_ = NULL;
		GXmlNode* _tmp5_ = NULL;
		_tmp2_ = element;
		_tmp3_ = prop;
		_tmp4_ = gxml_serializable_object_model_default_serialize_property (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GXML_TYPE_ELEMENT, GXmlElement), _tmp3_, &_inner_error_);
		_tmp1_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
		_tmp5_ = _tmp1_;
		_tmp1_ = NULL;
		result = _tmp5_;
		_g_object_unref0 (_tmp1_);
		return result;
	}
	result = NULL;
	return result;
}


GXmlNode* gxml_serializable_object_model_serialize_property (GXmlSerializableObjectModel* self, GXmlNode* element, GParamSpec* prop, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->serialize_property (self, element, prop, error);
}


GXmlNode* gxml_serializable_object_model_default_serialize_property (GXmlSerializableObjectModel* self, GXmlElement* element, GParamSpec* prop, GError** error) {
	GXmlNode* result = NULL;
	gboolean _tmp0_ = FALSE;
	GParamSpec* _tmp1_ = NULL;
	GType _tmp2_ = 0UL;
	gboolean _tmp3_ = FALSE;
	GValue oval = {0};
	GParamSpec* _tmp31_ = NULL;
	GType _tmp32_ = 0UL;
	gboolean _tmp33_ = FALSE;
	GParamSpec* _tmp40_ = NULL;
	const gchar* _tmp41_ = NULL;
	gchar* val = NULL;
	gchar* _tmp42_ = NULL;
	GParamSpec* _tmp43_ = NULL;
	GType _tmp44_ = 0UL;
	gboolean _tmp45_ = FALSE;
	gchar* attr_name = NULL;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	GXmlNode* attr = NULL;
	GXmlElement* _tmp73_ = NULL;
	const gchar* _tmp74_ = NULL;
	GXmlNode* _tmp75_ = NULL;
	GXmlNode* _tmp76_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (element != NULL, NULL);
	g_return_val_if_fail (prop != NULL, NULL);
	_tmp1_ = prop;
	_tmp2_ = _tmp1_->value_type;
	_tmp3_ = g_type_is_a (_tmp2_, GXML_TYPE_SERIALIZABLE);
	if (_tmp3_) {
		_tmp0_ = TRUE;
	} else {
		GParamSpec* _tmp4_ = NULL;
		GType _tmp5_ = 0UL;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = prop;
		_tmp5_ = _tmp4_->value_type;
		_tmp6_ = g_type_is_a (_tmp5_, GXML_TYPE_SERIALIZABLE_PROPERTY);
		_tmp0_ = _tmp6_;
	}
	if (_tmp0_) {
		GValue v = {0};
		GValue _tmp7_ = {0};
		GParamSpec* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		GObject* obj = NULL;
		GObject* _tmp10_ = NULL;
		GObject* _tmp11_ = NULL;
		GObject* _tmp12_ = NULL;
		g_value_init (&_tmp7_, G_TYPE_OBJECT);
		v = _tmp7_;
		_tmp8_ = prop;
		_tmp9_ = _tmp8_->name;
		g_object_get_property ((GObject*) self, _tmp9_, &v);
		_tmp10_ = g_value_get_object (&v);
		_tmp11_ = _g_object_ref0 (_tmp10_);
		obj = _tmp11_;
		_tmp12_ = obj;
		if (_tmp12_ != NULL) {
			GObject* _tmp13_ = NULL;
			GObject* _tmp21_ = NULL;
			GObject* _tmp25_ = NULL;
			_tmp13_ = obj;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, GXML_TYPE_SERIALIZABLE_PROPERTY)) {
				GXmlNode* _tmp14_ = NULL;
				GObject* _tmp15_ = NULL;
				GXmlElement* _tmp16_ = NULL;
				GParamSpec* _tmp17_ = NULL;
				gboolean _tmp18_ = FALSE;
				GXmlNode* _tmp19_ = NULL;
				GXmlNode* _tmp20_ = NULL;
				_tmp15_ = obj;
				_tmp16_ = element;
				_tmp17_ = prop;
				_tmp18_ = gxml_serializable_object_model_property_use_nick (self);
				_tmp19_ = gxml_serializable_property_serialize_property (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GXML_TYPE_SERIALIZABLE_PROPERTY, GXmlSerializableProperty), (GXmlNode*) _tmp16_, _tmp17_, _tmp18_, &_inner_error_);
				_tmp14_ = _tmp19_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (obj);
					G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
					return NULL;
				}
				_tmp20_ = _tmp14_;
				_tmp14_ = NULL;
				result = _tmp20_;
				_g_object_unref0 (_tmp14_);
				_g_object_unref0 (obj);
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
				return result;
			}
			_tmp21_ = obj;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, GXML_TYPE_SERIALIZABLE_COLLECTION)) {
				GObject* _tmp22_ = NULL;
				gboolean _tmp23_ = FALSE;
				_tmp22_ = obj;
				_tmp23_ = gxml_serializable_collection_deserialized (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, GXML_TYPE_SERIALIZABLE_COLLECTION) ? ((GXmlSerializableCollection*) _tmp22_) : NULL);
				if (!_tmp23_) {
					GObject* _tmp24_ = NULL;
					_tmp24_ = obj;
					gxml_serializable_collection_deserialize_children (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, GXML_TYPE_SERIALIZABLE_COLLECTION) ? ((GXmlSerializableCollection*) _tmp24_) : NULL, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (obj);
						G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
						return NULL;
					}
				}
			}
			_tmp25_ = obj;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, GXML_TYPE_SERIALIZABLE)) {
				GXmlNode* _tmp26_ = NULL;
				GObject* _tmp27_ = NULL;
				GXmlElement* _tmp28_ = NULL;
				GXmlNode* _tmp29_ = NULL;
				GXmlNode* _tmp30_ = NULL;
				_tmp27_ = obj;
				_tmp28_ = element;
				_tmp29_ = gxml_serializable_serialize (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GXML_TYPE_SERIALIZABLE, GXmlSerializable), (GXmlNode*) _tmp28_, &_inner_error_);
				_tmp26_ = _tmp29_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (obj);
					G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
					return NULL;
				}
				_tmp30_ = _tmp26_;
				_tmp26_ = NULL;
				result = _tmp30_;
				_g_object_unref0 (_tmp26_);
				_g_object_unref0 (obj);
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
				return result;
			}
		}
		_g_object_unref0 (obj);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	}
	_tmp31_ = prop;
	_tmp32_ = _tmp31_->value_type;
	_tmp33_ = g_type_is_a (_tmp32_, G_TYPE_ENUM);
	if (_tmp33_) {
		GValue _tmp34_ = {0};
		GValue _tmp35_ = {0};
		g_value_init (&_tmp34_, G_TYPE_INT);
		G_IS_VALUE (&oval) ? (g_value_unset (&oval), NULL) : NULL;
		oval = _tmp34_;
		_tmp35_ = oval;
	} else {
		GParamSpec* _tmp36_ = NULL;
		GType _tmp37_ = 0UL;
		GValue _tmp38_ = {0};
		GValue _tmp39_ = {0};
		_tmp36_ = prop;
		_tmp37_ = _tmp36_->value_type;
		g_value_init (&_tmp38_, _tmp37_);
		G_IS_VALUE (&oval) ? (g_value_unset (&oval), NULL) : NULL;
		oval = _tmp38_;
		_tmp39_ = oval;
	}
	_tmp40_ = prop;
	_tmp41_ = _tmp40_->name;
	g_object_get_property ((GObject*) self, _tmp41_, &oval);
	_tmp42_ = g_strdup ("");
	val = _tmp42_;
	_tmp43_ = prop;
	_tmp44_ = _tmp43_->value_type;
	_tmp45_ = g_type_is_a (_tmp44_, G_TYPE_ENUM);
	if (_tmp45_) {
		{
			gchar* _tmp46_ = NULL;
			GParamSpec* _tmp47_ = NULL;
			GType _tmp48_ = 0UL;
			gint _tmp49_ = 0;
			gchar* _tmp50_ = NULL;
			gchar* _tmp51_ = NULL;
			_tmp47_ = prop;
			_tmp48_ = _tmp47_->value_type;
			_tmp49_ = g_value_get_int (&oval);
			_tmp50_ = gxml_enumeration_get_nick_camelcase (_tmp48_, _tmp49_, &_inner_error_);
			_tmp46_ = _tmp50_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == GXML_ENUMERATION_ERROR) {
					goto __catch1_gxml_enumeration_error;
				}
				goto __finally1;
			}
			_tmp51_ = _tmp46_;
			_tmp46_ = NULL;
			_g_free0 (val);
			val = _tmp51_;
			_g_free0 (_tmp46_);
		}
		goto __finally1;
		__catch1_gxml_enumeration_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_free0 (val);
			val = NULL;
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (val);
			G_IS_VALUE (&oval) ? (g_value_unset (&oval), NULL) : NULL;
			return NULL;
		}
	} else {
		GParamSpec* _tmp52_ = NULL;
		GType _tmp53_ = 0UL;
		gboolean _tmp54_ = FALSE;
		_tmp52_ = prop;
		_tmp53_ = _tmp52_->value_type;
		_tmp54_ = g_value_type_transformable (_tmp53_, G_TYPE_STRING);
		if (_tmp54_) {
			GValue rval = {0};
			GValue _tmp55_ = {0};
			gchar* _tmp56_ = NULL;
			g_value_init (&_tmp55_, G_TYPE_STRING);
			rval = _tmp55_;
			g_value_transform (&oval, &rval);
			_tmp56_ = g_value_dup_string (&rval);
			_g_free0 (val);
			val = _tmp56_;
			G_IS_VALUE (&rval) ? (g_value_unset (&rval), NULL) : NULL;
		} else {
			GXmlNode* node = NULL;
			GXmlElement* _tmp57_ = NULL;
			GParamSpec* _tmp58_ = NULL;
			GXmlNode* _tmp59_ = NULL;
			node = NULL;
			_tmp57_ = element;
			_tmp58_ = prop;
			g_signal_emit_by_name ((GXmlSerializable*) self, "serialize-unknown-property", (GXmlNode*) _tmp57_, _tmp58_, &_tmp59_);
			_g_object_unref0 (node);
			node = _tmp59_;
			result = node;
			_g_free0 (val);
			G_IS_VALUE (&oval) ? (g_value_unset (&oval), NULL) : NULL;
			return result;
		}
	}
	_tmp62_ = gxml_serializable_object_model_property_use_nick (self);
	if (_tmp62_) {
		GParamSpec* _tmp63_ = NULL;
		const gchar* _tmp64_ = NULL;
		_tmp63_ = prop;
		_tmp64_ = g_param_spec_get_nick (_tmp63_);
		_tmp61_ = _tmp64_ != NULL;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		GParamSpec* _tmp65_ = NULL;
		const gchar* _tmp66_ = NULL;
		_tmp65_ = prop;
		_tmp66_ = g_param_spec_get_nick (_tmp65_);
		_tmp60_ = g_strcmp0 (_tmp66_, "") != 0;
	} else {
		_tmp60_ = FALSE;
	}
	if (_tmp60_) {
		GParamSpec* _tmp67_ = NULL;
		const gchar* _tmp68_ = NULL;
		gchar* _tmp69_ = NULL;
		_tmp67_ = prop;
		_tmp68_ = g_param_spec_get_nick (_tmp67_);
		_tmp69_ = g_strdup (_tmp68_);
		_g_free0 (attr_name);
		attr_name = _tmp69_;
	} else {
		GParamSpec* _tmp70_ = NULL;
		const gchar* _tmp71_ = NULL;
		gchar* _tmp72_ = NULL;
		_tmp70_ = prop;
		_tmp71_ = g_param_spec_get_name (_tmp70_);
		_tmp72_ = g_strdup (_tmp71_);
		_g_free0 (attr_name);
		attr_name = _tmp72_;
	}
	_tmp73_ = element;
	_tmp74_ = attr_name;
	_tmp75_ = gxml_element_get_attr (_tmp73_, _tmp74_);
	attr = _tmp75_;
	_tmp76_ = attr;
	if (_tmp76_ == NULL) {
		const gchar* _tmp77_ = NULL;
		_tmp77_ = val;
		if (_tmp77_ != NULL) {
			GXmlElement* _tmp78_ = NULL;
			const gchar* _tmp79_ = NULL;
			const gchar* _tmp80_ = NULL;
			_tmp78_ = element;
			_tmp79_ = attr_name;
			_tmp80_ = val;
			gxml_element_set_attr (_tmp78_, _tmp79_, _tmp80_);
		}
	} else {
		GXmlNode* _tmp81_ = NULL;
		const gchar* _tmp82_ = NULL;
		_tmp81_ = attr;
		_tmp82_ = val;
		gxml_node_set_value (_tmp81_, _tmp82_);
	}
	result = attr;
	_g_free0 (attr_name);
	_g_free0 (val);
	G_IS_VALUE (&oval) ? (g_value_unset (&oval), NULL) : NULL;
	return result;
}


static gboolean gxml_serializable_object_model_real_deserialize (GXmlSerializableObjectModel* self, GXmlNode* node, GError** error) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GXmlNode* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = gxml_serializable_object_model_node_name (self);
	_tmp1_ = _tmp0_;
	_vala_return_val_if_fail (_tmp1_ != NULL, "node_name () != null", FALSE);
	_tmp3_ = node;
	_tmp4_ = gxml_serializable_object_model_default_deserialize (self, _tmp3_, &_inner_error_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp1_);
	_tmp2_ = _tmp5_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp6_ = FALSE;
		g_propagate_error (error, _inner_error_);
		return _tmp6_;
	}
	result = _tmp2_;
	return result;
}


gboolean gxml_serializable_object_model_deserialize (GXmlSerializableObjectModel* self, GXmlNode* node, GError** error) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gxml_serializable_object_model_node_name (self);
	_tmp1_ = _tmp0_;
	_vala_return_val_if_fail (_tmp1_ != NULL, "node_name () != null", FALSE);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->deserialize (self, node, error);
}


gboolean gxml_serializable_object_model_default_deserialize (GXmlSerializableObjectModel* self, GXmlNode* node, GError** error) {
	gboolean result = FALSE;
	GXmlDocument* doc = NULL;
	GXmlNode* _tmp0_ = NULL;
	GXmlElement* element = NULL;
	GXmlNode* _tmp11_ = NULL;
	GXmlElement* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	GXmlElement* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	gboolean _tmp36_ = FALSE;
	GType _tmp65_ = 0UL;
	gboolean _tmp66_ = FALSE;
	GeeHashMap* cnodes = NULL;
	GeeHashMap* _tmp67_ = NULL;
	GeeHashMap* cns = NULL;
	GeeHashMap* _tmp68_ = NULL;
	gint _tmp69_ = 0;
	GParamSpec** _tmp70_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = node;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GXML_TYPE_DOCUMENT)) {
		GXmlNode* _tmp1_ = NULL;
		GXmlDocument* _tmp2_ = NULL;
		GXmlDocument* _tmp3_ = NULL;
		GXmlNode* _tmp4_ = NULL;
		GXmlNode* _tmp5_ = NULL;
		GXmlNode* _tmp6_ = NULL;
		_tmp1_ = node;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GXML_TYPE_DOCUMENT, GXmlDocument));
		_g_object_unref0 (doc);
		doc = _tmp2_;
		_tmp3_ = doc;
		_tmp4_ = gxml_document_get_root (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_;
		g_return_val_if_fail (_tmp6_ != NULL, FALSE);
		_g_object_unref0 (_tmp6_);
	} else {
		GXmlNode* _tmp7_ = NULL;
		GXmlDocument* _tmp8_ = NULL;
		GXmlDocument* _tmp9_ = NULL;
		GXmlDocument* _tmp10_ = NULL;
		_tmp7_ = node;
		_tmp8_ = gxml_node_get_document (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _g_object_ref0 (_tmp9_);
		_g_object_unref0 (doc);
		doc = _tmp10_;
	}
	_tmp11_ = node;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, GXML_TYPE_ELEMENT)) {
		GXmlNode* _tmp12_ = NULL;
		GXmlElement* _tmp13_ = NULL;
		_tmp12_ = node;
		_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GXML_TYPE_ELEMENT, GXmlElement));
		_g_object_unref0 (element);
		element = _tmp13_;
	} else {
		GXmlDocument* _tmp14_ = NULL;
		GXmlNode* _tmp15_ = NULL;
		GXmlNode* _tmp16_ = NULL;
		_tmp14_ = doc;
		_tmp15_ = gxml_document_get_root (_tmp14_);
		_tmp16_ = _tmp15_;
		_g_object_unref0 (element);
		element = G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GXML_TYPE_ELEMENT, GXmlElement);
	}
	_tmp17_ = element;
	g_return_val_if_fail (_tmp17_ != NULL, FALSE);
	_tmp18_ = gxml_serializable_object_model_node_name (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = _tmp19_ == NULL;
	_g_free0 (_tmp19_);
	if (_tmp20_) {
		const gchar* _tmp21_ = NULL;
		GType _tmp22_ = 0UL;
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		_tmp21_ = _ ("WARNING: Object type '%s' has no Node Name defined");
		_tmp22_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
		_tmp23_ = g_type_name (_tmp22_);
		_tmp24_ = g_strdup_printf (_tmp21_, _tmp23_);
		_tmp25_ = _tmp24_;
		g_warning ("SerializableObjectModel.vala:321: %s", _tmp25_);
		_g_free0 (_tmp25_);
		result = FALSE;
		_g_object_unref0 (element);
		_g_object_unref0 (doc);
		return result;
	}
	_tmp26_ = element;
	_tmp27_ = gxml_node_get_name ((GXmlNode*) _tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = _tmp28_;
	_tmp30_ = g_utf8_strdown (_tmp29_, (gssize) -1);
	_tmp31_ = _tmp30_;
	_tmp32_ = gxml_serializable_object_model_node_name (self);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_utf8_strdown (_tmp33_, (gssize) -1);
	_tmp35_ = _tmp34_;
	_tmp36_ = g_strcmp0 (_tmp31_, _tmp35_) != 0;
	_g_free0 (_tmp35_);
	_g_free0 (_tmp33_);
	_g_free0 (_tmp31_);
	_g_free0 (_tmp29_);
	if (_tmp36_) {
		const gchar* _tmp37_ = NULL;
		GXmlElement* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
		gchar* _tmp42_ = NULL;
		gchar* _tmp43_ = NULL;
		gchar* _tmp44_ = NULL;
		gchar* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		gchar* _tmp47_ = NULL;
		gchar* _tmp48_ = NULL;
		gchar* _tmp49_ = NULL;
		_tmp37_ = _ ("Actual node's name is '%s' expected '%s'");
		_tmp38_ = element;
		_tmp39_ = gxml_node_get_name ((GXmlNode*) _tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = _tmp40_;
		_tmp42_ = g_utf8_strdown (_tmp41_, (gssize) -1);
		_tmp43_ = _tmp42_;
		_tmp44_ = gxml_serializable_object_model_node_name (self);
		_tmp45_ = _tmp44_;
		_tmp46_ = g_utf8_strdown (_tmp45_, (gssize) -1);
		_tmp47_ = _tmp46_;
		_tmp48_ = g_strdup_printf (_tmp37_, _tmp43_, _tmp47_);
		_tmp49_ = _tmp48_;
		g_warning ("SerializableObjectModel.vala:325: %s", _tmp49_);
		_g_free0 (_tmp49_);
		_g_free0 (_tmp47_);
		_g_free0 (_tmp45_);
		_g_free0 (_tmp43_);
		_g_free0 (_tmp41_);
	}
	{
		GeeIterator* _attr_it = NULL;
		GXmlElement* _tmp50_ = NULL;
		GeeMap* _tmp51_ = NULL;
		GeeMap* _tmp52_ = NULL;
		GeeMap* _tmp53_ = NULL;
		GeeCollection* _tmp54_ = NULL;
		GeeCollection* _tmp55_ = NULL;
		GeeCollection* _tmp56_ = NULL;
		GeeIterator* _tmp57_ = NULL;
		GeeIterator* _tmp58_ = NULL;
		_tmp50_ = element;
		_tmp51_ = gxml_node_get_attrs ((GXmlNode*) _tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = _tmp52_;
		_tmp54_ = gee_map_get_values (_tmp53_);
		_tmp55_ = _tmp54_;
		_tmp56_ = _tmp55_;
		_tmp57_ = gee_iterable_iterator ((GeeIterable*) _tmp56_);
		_tmp58_ = _tmp57_;
		_g_object_unref0 (_tmp56_);
		_g_object_unref0 (_tmp53_);
		_attr_it = _tmp58_;
		while (TRUE) {
			GeeIterator* _tmp59_ = NULL;
			gboolean _tmp60_ = FALSE;
			GXmlNode* attr = NULL;
			GeeIterator* _tmp61_ = NULL;
			gpointer _tmp62_ = NULL;
			GXmlNode* _tmp63_ = NULL;
			_tmp59_ = _attr_it;
			_tmp60_ = gee_iterator_next (_tmp59_);
			if (!_tmp60_) {
				break;
			}
			_tmp61_ = _attr_it;
			_tmp62_ = gee_iterator_get (_tmp61_);
			attr = (GXmlNode*) _tmp62_;
			_tmp63_ = attr;
			gxml_serializable_object_model_deserialize_property (self, _tmp63_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gboolean _tmp64_ = FALSE;
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (attr);
				_g_object_unref0 (_attr_it);
				_g_object_unref0 (element);
				_g_object_unref0 (doc);
				return _tmp64_;
			}
			_g_object_unref0 (attr);
		}
		_g_object_unref0 (_attr_it);
	}
	_tmp65_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
	_tmp66_ = g_type_is_a (_tmp65_, GXML_TYPE_SERIALIZABLE_CONTAINER);
	if (_tmp66_) {
		gxml_serializable_container_init_containers (G_TYPE_CHECK_INSTANCE_CAST (self, GXML_TYPE_SERIALIZABLE_CONTAINER, GXmlSerializableContainer));
	}
	_tmp67_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_PARAM, (GBoxedCopyFunc) g_param_spec_ref, (GDestroyNotify) g_param_spec_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	cnodes = _tmp67_;
	_tmp68_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GXML_TYPE_SERIALIZABLE_COLLECTION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	cns = _tmp68_;
	_tmp70_ = gxml_serializable_object_model_list_serializable_properties (self, &_tmp69_);
	{
		GParamSpec** spec_collection = NULL;
		gint spec_collection_length1 = 0;
		gint _spec_collection_size_ = 0;
		gint spec_it = 0;
		spec_collection = _tmp70_;
		spec_collection_length1 = _tmp69_;
		for (spec_it = 0; spec_it < _tmp69_; spec_it = spec_it + 1) {
			GParamSpec* _tmp71_ = NULL;
			GParamSpec* spec = NULL;
			_tmp71_ = _g_param_spec_ref0 (spec_collection[spec_it]);
			spec = _tmp71_;
			{
				GParamSpec* _tmp72_ = NULL;
				GType _tmp73_ = 0UL;
				gboolean _tmp74_ = FALSE;
				_tmp72_ = spec;
				_tmp73_ = _tmp72_->value_type;
				_tmp74_ = g_type_is_a (_tmp73_, GXML_TYPE_SERIALIZABLE);
				if (_tmp74_) {
					GParamSpec* _tmp75_ = NULL;
					GType _tmp76_ = 0UL;
					gboolean _tmp77_ = FALSE;
					_tmp75_ = spec;
					_tmp76_ = _tmp75_->value_type;
					_tmp77_ = g_type_is_a (_tmp76_, GXML_TYPE_SERIALIZABLE_COLLECTION);
					if (_tmp77_) {
						GValue vo = {0};
						GParamSpec* _tmp78_ = NULL;
						GType _tmp79_ = 0UL;
						GValue _tmp80_ = {0};
						GParamSpec* _tmp81_ = NULL;
						const gchar* _tmp82_ = NULL;
						GObject* objv = NULL;
						GObject* _tmp83_ = NULL;
						GObject* _tmp84_ = NULL;
						GObject* _tmp85_ = NULL;
						_tmp78_ = spec;
						_tmp79_ = _tmp78_->value_type;
						g_value_init (&_tmp80_, _tmp79_);
						vo = _tmp80_;
						_tmp81_ = spec;
						_tmp82_ = _tmp81_->name;
						g_object_get_property ((GObject*) self, _tmp82_, &vo);
						_tmp83_ = g_value_get_object (&vo);
						_tmp84_ = _g_object_ref0 (_tmp83_);
						objv = _tmp84_;
						_tmp85_ = objv;
						if (_tmp85_ != NULL) {
							gchar* nname = NULL;
							GObject* _tmp86_ = NULL;
							gchar* _tmp87_ = NULL;
							GObject* _tmp88_ = NULL;
							GXmlElement* _tmp89_ = NULL;
							GeeHashMap* _tmp91_ = NULL;
							const gchar* _tmp92_ = NULL;
							GParamSpec* _tmp93_ = NULL;
							GeeHashMap* _tmp94_ = NULL;
							const gchar* _tmp95_ = NULL;
							gchar* _tmp96_ = NULL;
							gchar* _tmp97_ = NULL;
							GObject* _tmp98_ = NULL;
							_tmp86_ = objv;
							_tmp87_ = gxml_serializable_node_name (G_TYPE_CHECK_INSTANCE_TYPE (_tmp86_, GXML_TYPE_SERIALIZABLE) ? ((GXmlSerializable*) _tmp86_) : NULL);
							nname = _tmp87_;
							_tmp88_ = objv;
							_tmp89_ = element;
							gxml_serializable_deserialize (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, GXML_TYPE_SERIALIZABLE, GXmlSerializable), (GXmlNode*) _tmp89_, &_inner_error_);
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								gboolean _tmp90_ = FALSE;
								g_propagate_error (error, _inner_error_);
								_g_free0 (nname);
								_g_object_unref0 (objv);
								G_IS_VALUE (&vo) ? (g_value_unset (&vo), NULL) : NULL;
								_g_param_spec_unref0 (spec);
								spec_collection = (_vala_array_free (spec_collection, spec_collection_length1, (GDestroyNotify) g_param_spec_unref), NULL);
								_g_object_unref0 (cns);
								_g_object_unref0 (cnodes);
								_g_object_unref0 (element);
								_g_object_unref0 (doc);
								return _tmp90_;
							}
							_tmp91_ = cnodes;
							_tmp92_ = nname;
							_tmp93_ = spec;
							gee_abstract_map_set ((GeeAbstractMap*) _tmp91_, _tmp92_, _tmp93_);
							_tmp94_ = cns;
							_tmp95_ = nname;
							_tmp96_ = g_utf8_strdown (_tmp95_, (gssize) -1);
							_tmp97_ = _tmp96_;
							_tmp98_ = objv;
							gee_abstract_map_set ((GeeAbstractMap*) _tmp94_, _tmp97_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp98_, GXML_TYPE_SERIALIZABLE_COLLECTION) ? ((GXmlSerializableCollection*) _tmp98_) : NULL);
							_g_free0 (_tmp97_);
							_g_free0 (nname);
						}
						_g_object_unref0 (objv);
						G_IS_VALUE (&vo) ? (g_value_unset (&vo), NULL) : NULL;
					}
				}
				_g_param_spec_unref0 (spec);
			}
		}
		spec_collection = (_vala_array_free (spec_collection, spec_collection_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	}
	{
		GeeBidirList* _n_list = NULL;
		GXmlElement* _tmp99_ = NULL;
		GeeBidirList* _tmp100_ = NULL;
		GeeBidirList* _tmp101_ = NULL;
		gint _n_size = 0;
		GeeBidirList* _tmp102_ = NULL;
		gint _tmp103_ = 0;
		gint _tmp104_ = 0;
		gint _n_index = 0;
		_tmp99_ = element;
		_tmp100_ = gxml_node_get_children_nodes ((GXmlNode*) _tmp99_);
		_tmp101_ = _tmp100_;
		_n_list = _tmp101_;
		_tmp102_ = _n_list;
		_tmp103_ = gee_collection_get_size ((GeeCollection*) _tmp102_);
		_tmp104_ = _tmp103_;
		_n_size = _tmp104_;
		_n_index = -1;
		while (TRUE) {
			gint _tmp105_ = 0;
			gint _tmp106_ = 0;
			gint _tmp107_ = 0;
			GXmlNode* n = NULL;
			GeeBidirList* _tmp108_ = NULL;
			gint _tmp109_ = 0;
			gpointer _tmp110_ = NULL;
			GXmlNode* _tmp111_ = NULL;
			gchar* _tmp112_ = NULL;
			gchar* _tmp113_ = NULL;
			gchar* _tmp114_ = NULL;
			gboolean _tmp115_ = FALSE;
			GeeHashMap* _tmp116_ = NULL;
			GXmlNode* _tmp117_ = NULL;
			gchar* _tmp118_ = NULL;
			gchar* _tmp119_ = NULL;
			gchar* _tmp120_ = NULL;
			gboolean _tmp121_ = FALSE;
			gboolean _tmp122_ = FALSE;
			GXmlNode* _tmp123_ = NULL;
			_tmp105_ = _n_index;
			_n_index = _tmp105_ + 1;
			_tmp106_ = _n_index;
			_tmp107_ = _n_size;
			if (!(_tmp106_ < _tmp107_)) {
				break;
			}
			_tmp108_ = _n_list;
			_tmp109_ = _n_index;
			_tmp110_ = gee_list_get ((GeeList*) _tmp108_, _tmp109_);
			n = (GXmlNode*) _tmp110_;
			_tmp111_ = n;
			_tmp112_ = gxml_node_get_name (_tmp111_);
			_tmp113_ = _tmp112_;
			_tmp114_ = _tmp113_;
			_tmp115_ = _tmp114_ == NULL;
			_g_free0 (_tmp114_);
			if (_tmp115_) {
				g_warning ("SerializableObjectModel.vala:374: Child node name is null");
				_g_object_unref0 (n);
				continue;
			}
			_tmp116_ = cnodes;
			_tmp117_ = n;
			_tmp118_ = gxml_node_get_name (_tmp117_);
			_tmp119_ = _tmp118_;
			_tmp120_ = _tmp119_;
			_tmp121_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp116_, _tmp120_);
			_tmp122_ = _tmp121_;
			_g_free0 (_tmp120_);
			if (_tmp122_) {
				_g_object_unref0 (n);
				continue;
			}
			_tmp123_ = n;
			gxml_serializable_object_model_deserialize_property (self, _tmp123_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gboolean _tmp124_ = FALSE;
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (n);
				_g_object_unref0 (_n_list);
				_g_object_unref0 (cns);
				_g_object_unref0 (cnodes);
				_g_object_unref0 (element);
				_g_object_unref0 (doc);
				return _tmp124_;
			}
			_g_object_unref0 (n);
		}
		_g_object_unref0 (_n_list);
	}
	result = TRUE;
	_g_object_unref0 (cns);
	_g_object_unref0 (cnodes);
	_g_object_unref0 (element);
	_g_object_unref0 (doc);
	return result;
}


static gboolean gxml_serializable_object_model_real_deserialize_property (GXmlSerializableObjectModel* self, GXmlNode* property_node, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GXmlNode* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (property_node != NULL, FALSE);
	_tmp1_ = property_node;
	_tmp2_ = gxml_serializable_object_model_default_deserialize_property (self, _tmp1_, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp3_ = FALSE;
		g_propagate_error (error, _inner_error_);
		return _tmp3_;
	}
	result = _tmp0_;
	return result;
}


gboolean gxml_serializable_object_model_deserialize_property (GXmlSerializableObjectModel* self, GXmlNode* property_node, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->deserialize_property (self, property_node, error);
}


gboolean gxml_serializable_object_model_default_deserialize_property (GXmlSerializableObjectModel* self, GXmlNode* property_node, GError** error) {
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GParamSpec* prop = NULL;
	GXmlNode* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GParamSpec* _tmp4_ = NULL;
	GParamSpec* _tmp5_ = NULL;
	GParamSpec* _tmp6_ = NULL;
	gboolean _tmp19_ = FALSE;
	GParamSpec* _tmp20_ = NULL;
	GType _tmp21_ = 0UL;
	gboolean _tmp22_ = FALSE;
	GXmlNode* _tmp117_ = NULL;
	GParamSpec* _tmp118_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (property_node != NULL, FALSE);
	ret = FALSE;
	_tmp0_ = property_node;
	_tmp1_ = gxml_node_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = gxml_serializable_object_model_find_property_spec (self, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	prop = _tmp5_;
	_tmp6_ = prop;
	if (_tmp6_ == NULL) {
		gboolean _tmp7_ = FALSE;
		GXmlNode* _tmp8_ = NULL;
		gboolean _tmp14_ = FALSE;
		_tmp8_ = property_node;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, GXML_TYPE_TEXT)) {
			gboolean _tmp9_ = FALSE;
			_tmp9_ = gxml_serializable_object_model_serialize_use_xml_node_value (self);
			_tmp7_ = _tmp9_;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			GXmlNode* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			_tmp10_ = property_node;
			_tmp11_ = gxml_node_get_value (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = _tmp12_;
			gxml_serializable_set_serialized_xml_node_value ((GXmlSerializable*) self, _tmp13_);
			_g_free0 (_tmp13_);
		}
		_tmp14_ = gxml_serializable_object_model_get_enable_unknown_serializable_property (self);
		if (_tmp14_) {
			GXmlNode* _tmp15_ = NULL;
			_tmp15_ = self->_node;
			if (_tmp15_ == NULL) {
				GXmlNode* _tmp16_ = NULL;
				GXmlNode* _tmp17_ = NULL;
				GXmlNode* _tmp18_ = NULL;
				_tmp16_ = property_node;
				_tmp17_ = gxml_node_get_parent (_tmp16_);
				_tmp18_ = _tmp17_;
				_g_object_unref0 (self->_node);
				self->_node = _tmp18_;
			}
		}
		result = TRUE;
		_g_param_spec_unref0 (prop);
		return result;
	}
	_tmp20_ = prop;
	_tmp21_ = _tmp20_->value_type;
	_tmp22_ = g_type_is_a (_tmp21_, GXML_TYPE_SERIALIZABLE);
	if (_tmp22_) {
		_tmp19_ = TRUE;
	} else {
		GParamSpec* _tmp23_ = NULL;
		GType _tmp24_ = 0UL;
		gboolean _tmp25_ = FALSE;
		_tmp23_ = prop;
		_tmp24_ = _tmp23_->value_type;
		_tmp25_ = g_type_is_a (_tmp24_, GXML_TYPE_SERIALIZABLE_PROPERTY);
		_tmp19_ = _tmp25_;
	}
	if (_tmp19_) {
		GValue vobj = {0};
		GValue _tmp26_ = {0};
		GParamSpec* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		GObject* object = NULL;
		GObject* _tmp29_ = NULL;
		GObject* _tmp30_ = NULL;
		GObject* _tmp31_ = NULL;
		g_value_init (&_tmp26_, G_TYPE_OBJECT);
		vobj = _tmp26_;
		_tmp27_ = prop;
		_tmp28_ = _tmp27_->name;
		g_object_get_property ((GObject*) self, _tmp28_, &vobj);
		object = NULL;
		_tmp29_ = g_value_get_object (&vobj);
		_tmp30_ = _g_object_ref0 (_tmp29_);
		_g_object_unref0 (object);
		object = _tmp30_;
		_tmp31_ = object;
		if (_tmp31_ == NULL) {
			GParamSpec* _tmp32_ = NULL;
			GType _tmp33_ = 0UL;
			gboolean _tmp34_ = FALSE;
			_tmp32_ = prop;
			_tmp33_ = _tmp32_->value_type;
			_tmp34_ = g_type_is_a (_tmp33_, GXML_TYPE_SERIALIZABLE_PROPERTY);
			if (_tmp34_) {
				GObject* obj = NULL;
				GParamSpec* _tmp35_ = NULL;
				GType _tmp36_ = 0UL;
				GObject* _tmp37_ = NULL;
				GObject* _tmp38_ = NULL;
				GObject* _tmp39_ = NULL;
				GXmlNode* _tmp40_ = NULL;
				GParamSpec* _tmp41_ = NULL;
				gboolean _tmp42_ = FALSE;
				GParamSpec* _tmp44_ = NULL;
				const gchar* _tmp45_ = NULL;
				GObject* _tmp46_ = NULL;
				GValue _tmp47_ = {0};
				_tmp35_ = prop;
				_tmp36_ = _tmp35_->value_type;
				_tmp37_ = g_object_new (_tmp36_, NULL);
				_tmp38_ = G_IS_INITIALLY_UNOWNED (_tmp37_) ? g_object_ref_sink (_tmp37_) : _tmp37_;
				obj = _tmp38_;
				_tmp39_ = obj;
				_tmp40_ = property_node;
				_tmp41_ = prop;
				_tmp42_ = gxml_serializable_object_model_property_use_nick (self);
				gxml_serializable_property_deserialize_property (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, GXML_TYPE_SERIALIZABLE_PROPERTY, GXmlSerializableProperty), _tmp40_, _tmp41_, _tmp42_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					gboolean _tmp43_ = FALSE;
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (obj);
					_g_object_unref0 (object);
					G_IS_VALUE (&vobj) ? (g_value_unset (&vobj), NULL) : NULL;
					_g_param_spec_unref0 (prop);
					return _tmp43_;
				}
				_tmp44_ = prop;
				_tmp45_ = _tmp44_->name;
				_tmp46_ = obj;
				g_value_init (&_tmp47_, G_TYPE_OBJECT);
				g_value_set_object (&_tmp47_, _tmp46_);
				g_object_set_property ((GObject*) self, _tmp45_, &_tmp47_);
				G_IS_VALUE (&_tmp47_) ? (g_value_unset (&_tmp47_), NULL) : NULL;
				_g_object_unref0 (obj);
			} else {
				GParamSpec* _tmp48_ = NULL;
				GType _tmp49_ = 0UL;
				gboolean _tmp50_ = FALSE;
				_tmp48_ = prop;
				_tmp49_ = _tmp48_->value_type;
				_tmp50_ = g_type_is_a (_tmp49_, GXML_TYPE_SERIALIZABLE);
				if (_tmp50_) {
					GObject* obj = NULL;
					GParamSpec* _tmp51_ = NULL;
					GType _tmp52_ = 0UL;
					GObject* _tmp53_ = NULL;
					GObject* _tmp54_ = NULL;
					GObject* _tmp55_ = NULL;
					GXmlNode* _tmp56_ = NULL;
					GParamSpec* _tmp58_ = NULL;
					const gchar* _tmp59_ = NULL;
					GObject* _tmp60_ = NULL;
					GValue _tmp61_ = {0};
					_tmp51_ = prop;
					_tmp52_ = _tmp51_->value_type;
					_tmp53_ = g_object_new (_tmp52_, NULL);
					_tmp54_ = G_IS_INITIALLY_UNOWNED (_tmp53_) ? g_object_ref_sink (_tmp53_) : _tmp53_;
					obj = _tmp54_;
					_tmp55_ = obj;
					_tmp56_ = property_node;
					gxml_serializable_deserialize (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, GXML_TYPE_SERIALIZABLE, GXmlSerializable), _tmp56_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						gboolean _tmp57_ = FALSE;
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (obj);
						_g_object_unref0 (object);
						G_IS_VALUE (&vobj) ? (g_value_unset (&vobj), NULL) : NULL;
						_g_param_spec_unref0 (prop);
						return _tmp57_;
					}
					_tmp58_ = prop;
					_tmp59_ = _tmp58_->name;
					_tmp60_ = obj;
					g_value_init (&_tmp61_, G_TYPE_OBJECT);
					g_value_set_object (&_tmp61_, _tmp60_);
					g_object_set_property ((GObject*) self, _tmp59_, &_tmp61_);
					G_IS_VALUE (&_tmp61_) ? (g_value_unset (&_tmp61_), NULL) : NULL;
					_g_object_unref0 (obj);
				}
			}
		} else {
			GObject* _tmp62_ = NULL;
			_tmp62_ = object;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp62_, GXML_TYPE_SERIALIZABLE_PROPERTY)) {
				GObject* _tmp63_ = NULL;
				GXmlNode* _tmp64_ = NULL;
				GParamSpec* _tmp65_ = NULL;
				gboolean _tmp66_ = FALSE;
				_tmp63_ = object;
				_tmp64_ = property_node;
				_tmp65_ = prop;
				_tmp66_ = gxml_serializable_object_model_property_use_nick (self);
				gxml_serializable_property_deserialize_property (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, GXML_TYPE_SERIALIZABLE_PROPERTY, GXmlSerializableProperty), _tmp64_, _tmp65_, _tmp66_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					gboolean _tmp67_ = FALSE;
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (object);
					G_IS_VALUE (&vobj) ? (g_value_unset (&vobj), NULL) : NULL;
					_g_param_spec_unref0 (prop);
					return _tmp67_;
				}
			} else {
				GObject* _tmp68_ = NULL;
				GXmlNode* _tmp69_ = NULL;
				_tmp68_ = object;
				_tmp69_ = property_node;
				gxml_serializable_deserialize (G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, GXML_TYPE_SERIALIZABLE, GXmlSerializable), _tmp69_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					gboolean _tmp70_ = FALSE;
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (object);
					G_IS_VALUE (&vobj) ? (g_value_unset (&vobj), NULL) : NULL;
					_g_param_spec_unref0 (prop);
					return _tmp70_;
				}
			}
		}
		result = TRUE;
		_g_object_unref0 (object);
		G_IS_VALUE (&vobj) ? (g_value_unset (&vobj), NULL) : NULL;
		_g_param_spec_unref0 (prop);
		return result;
	} else {
		GValue val = {0};
		GParamSpec* _tmp71_ = NULL;
		GType _tmp72_ = 0UL;
		GXmlNode* _tmp79_ = NULL;
		_tmp71_ = prop;
		_tmp72_ = _tmp71_->value_type;
		if (_tmp72_ == G_TYPE_ENUM) {
			GValue _tmp73_ = {0};
			GValue _tmp74_ = {0};
			g_value_init (&_tmp73_, G_TYPE_INT);
			G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
			val = _tmp73_;
			_tmp74_ = val;
		} else {
			GParamSpec* _tmp75_ = NULL;
			GType _tmp76_ = 0UL;
			GValue _tmp77_ = {0};
			GValue _tmp78_ = {0};
			_tmp75_ = prop;
			_tmp76_ = _tmp75_->value_type;
			g_value_init (&_tmp77_, _tmp76_);
			G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
			val = _tmp77_;
			_tmp78_ = val;
		}
		_tmp79_ = property_node;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp79_, GXML_TYPE_ATTRIBUTE)) {
			GParamSpec* _tmp80_ = NULL;
			GType _tmp81_ = 0UL;
			gboolean _tmp82_ = FALSE;
			GParamSpec* _tmp114_ = NULL;
			const gchar* _tmp115_ = NULL;
			GValue _tmp116_ = {0};
			_tmp80_ = prop;
			_tmp81_ = _tmp80_->value_type;
			_tmp82_ = g_type_is_a (_tmp81_, G_TYPE_ENUM);
			if (_tmp82_) {
				GEnumValue env = {0};
				{
					GEnumValue* _tmp83_ = NULL;
					GParamSpec* _tmp84_ = NULL;
					GType _tmp85_ = 0UL;
					GXmlNode* _tmp86_ = NULL;
					gchar* _tmp87_ = NULL;
					gchar* _tmp88_ = NULL;
					gchar* _tmp89_ = NULL;
					GEnumValue* _tmp90_ = NULL;
					GEnumValue* _tmp91_ = NULL;
					GEnumValue* _tmp92_ = NULL;
					GEnumValue* _tmp93_ = NULL;
					GEnumValue _tmp94_ = {0};
					gint _tmp95_ = 0;
					_tmp84_ = prop;
					_tmp85_ = _tmp84_->value_type;
					_tmp86_ = property_node;
					_tmp87_ = gxml_node_get_value (_tmp86_);
					_tmp88_ = _tmp87_;
					_tmp89_ = _tmp88_;
					_tmp90_ = gxml_enumeration_parse (_tmp85_, _tmp89_, &_inner_error_);
					_tmp91_ = _tmp90_;
					_g_free0 (_tmp89_);
					_tmp83_ = _tmp91_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == GXML_ENUMERATION_ERROR) {
							goto __catch2_gxml_enumeration_error;
						}
						goto __finally2;
					}
					_tmp92_ = _tmp83_;
					_tmp83_ = NULL;
					_tmp93_ = _tmp92_;
					env = *_tmp93_;
					_g_free0 (_tmp93_);
					_tmp94_ = env;
					_tmp95_ = _tmp94_.value;
					g_value_set_enum (&val, _tmp95_);
					_g_free0 (_tmp83_);
				}
				goto __finally2;
				__catch2_gxml_enumeration_error:
				{
					GError* e = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (e);
				}
				__finally2:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					gboolean _tmp96_ = FALSE;
					g_propagate_error (error, _inner_error_);
					G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
					_g_param_spec_unref0 (prop);
					return _tmp96_;
				}
			} else {
				GValue ptmp = {0};
				GValue _tmp97_ = {0};
				GXmlNode* _tmp98_ = NULL;
				gchar* _tmp99_ = NULL;
				gchar* _tmp100_ = NULL;
				gchar* _tmp101_ = NULL;
				GParamSpec* _tmp102_ = NULL;
				GType _tmp103_ = 0UL;
				gboolean _tmp104_ = FALSE;
				g_value_init (&_tmp97_, G_TYPE_STRING);
				ptmp = _tmp97_;
				_tmp98_ = property_node;
				_tmp99_ = gxml_node_get_value (_tmp98_);
				_tmp100_ = _tmp99_;
				_tmp101_ = _tmp100_;
				g_value_set_string (&ptmp, _tmp101_);
				_g_free0 (_tmp101_);
				_tmp102_ = prop;
				_tmp103_ = _tmp102_->value_type;
				_tmp104_ = g_value_type_transformable (G_TYPE_STRING, _tmp103_);
				if (_tmp104_) {
					gboolean _tmp105_ = FALSE;
					_tmp105_ = g_value_transform (&ptmp, &val);
					ret = _tmp105_;
				} else {
					gboolean _tmp106_ = FALSE;
					GXmlNode* _tmp107_ = NULL;
					gchar* _tmp108_ = NULL;
					gchar* _tmp109_ = NULL;
					gchar* _tmp110_ = NULL;
					gboolean _tmp111_ = FALSE;
					gboolean _tmp112_ = FALSE;
					_tmp107_ = property_node;
					_tmp108_ = gxml_node_get_value (_tmp107_);
					_tmp109_ = _tmp108_;
					_tmp110_ = _tmp109_;
					_tmp111_ = gxml_serializable_string_to_gvalue (_tmp110_, &val, &_inner_error_);
					_tmp112_ = _tmp111_;
					_g_free0 (_tmp110_);
					_tmp106_ = _tmp112_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						gboolean _tmp113_ = FALSE;
						g_propagate_error (error, _inner_error_);
						G_IS_VALUE (&ptmp) ? (g_value_unset (&ptmp), NULL) : NULL;
						G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
						_g_param_spec_unref0 (prop);
						return _tmp113_;
					}
					ret = _tmp106_;
				}
				G_IS_VALUE (&ptmp) ? (g_value_unset (&ptmp), NULL) : NULL;
			}
			_tmp114_ = prop;
			_tmp115_ = _tmp114_->name;
			_tmp116_ = val;
			g_object_set_property ((GObject*) self, _tmp115_, &_tmp116_);
			result = ret;
			G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
			_g_param_spec_unref0 (prop);
			return result;
		}
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	}
	_tmp117_ = property_node;
	_tmp118_ = prop;
	g_signal_emit_by_name ((GXmlSerializable*) self, "deserialize-unknown-property", _tmp117_, _tmp118_);
	result = TRUE;
	_g_param_spec_unref0 (prop);
	return result;
}


static gchar* gxml_serializable_object_model_real_to_string (GXmlSerializableObjectModel* self) {
	g_critical ("Type `%s' does not implement abstract method `gxml_serializable_object_model_to_string'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gchar* gxml_serializable_object_model_to_string (GXmlSerializableObjectModel* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->to_string (self);
}


GXmlSerializableObjectModel* gxml_serializable_object_model_construct (GType object_type) {
	GXmlSerializableObjectModel * self = NULL;
	self = (GXmlSerializableObjectModel*) g_object_new (object_type, NULL);
	return self;
}


GParamSpec** gxml_serializable_object_model_get_properties (GXmlSerializableObjectModel* self, int* result_length1) {
	GParamSpec** result;
	GParamSpec** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GParamSpec** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_properties;
	_tmp0__length1 = self->priv->_properties_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static GParamSpec** _vala_array_dup3 (GParamSpec** self, int length) {
	GParamSpec** result;
	int i;
	result = g_new0 (GParamSpec*, length + 1);
	for (i = 0; i < length; i++) {
		GParamSpec* _tmp0_ = NULL;
		_tmp0_ = _g_param_spec_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void gxml_serializable_object_model_set_properties (GXmlSerializableObjectModel* self, GParamSpec** value, int value_length1) {
	GParamSpec** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GParamSpec** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp0__length1 = value_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup3 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->_properties = (_vala_array_free (self->priv->_properties, self->priv->_properties_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	self->priv->_properties = _tmp1_;
	self->priv->_properties_length1 = _tmp1__length1;
	self->priv->__properties_size_ = self->priv->_properties_length1;
}


GHashTable* gxml_serializable_object_model_get_ignored_serializable_properties (GXmlSerializableObjectModel* self) {
	GHashTable* result;
	GHashTable* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ignored_serializable_properties;
	result = _tmp0_;
	return result;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


void gxml_serializable_object_model_set_ignored_serializable_properties (GXmlSerializableObjectModel* self, GHashTable* value) {
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_hash_table_ref0 (_tmp0_);
	_g_hash_table_unref0 (self->priv->_ignored_serializable_properties);
	self->priv->_ignored_serializable_properties = _tmp1_;
	g_object_notify ((GObject *) self, "ignored-serializable-properties");
}


static gchar* gxml_serializable_object_model_real_get_serialized_xml_node_value (GXmlSerializable* base) {
	gchar* result;
	GXmlSerializableObjectModel* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (GXmlSerializableObjectModel*) base;
	_tmp0_ = self->priv->_serialized_xml_node_value;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void gxml_serializable_object_model_real_set_serialized_xml_node_value (GXmlSerializable* base, const gchar* value) {
	GXmlSerializableObjectModel* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (GXmlSerializableObjectModel*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_serialized_xml_node_value);
	self->priv->_serialized_xml_node_value = _tmp1_;
	g_object_notify ((GObject *) self, "serialized-xml-node-value");
}


static GeeMap* gxml_serializable_object_model_real_get_unknown_serializable_properties (GXmlSerializable* base) {
	GeeMap* result;
	GXmlSerializableObjectModel* self;
	GeeHashMap* m = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GXmlNode* _tmp1_ = NULL;
	GParamSpec** props = NULL;
	gint _tmp2_ = 0;
	GParamSpec** _tmp3_ = NULL;
	gint props_length1 = 0;
	gint _props_size_ = 0;
	gboolean found = FALSE;
	self = (GXmlSerializableObjectModel*) base;
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GXML_TYPE_ATTRIBUTE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	m = _tmp0_;
	_tmp1_ = self->_node;
	if (_tmp1_ == NULL) {
		result = (GeeMap*) m;
		return result;
	}
	_tmp3_ = gxml_serializable_object_model_list_serializable_properties (self, &_tmp2_);
	props = _tmp3_;
	props_length1 = _tmp2_;
	_props_size_ = props_length1;
	found = FALSE;
	{
		GeeIterator* _a_it = NULL;
		GXmlNode* _tmp4_ = NULL;
		GeeMap* _tmp5_ = NULL;
		GeeMap* _tmp6_ = NULL;
		GeeMap* _tmp7_ = NULL;
		GeeCollection* _tmp8_ = NULL;
		GeeCollection* _tmp9_ = NULL;
		GeeCollection* _tmp10_ = NULL;
		GeeIterator* _tmp11_ = NULL;
		GeeIterator* _tmp12_ = NULL;
		_tmp4_ = self->_node;
		_tmp5_ = gxml_node_get_attrs (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = gee_map_get_values (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_;
		_tmp11_ = gee_iterable_iterator ((GeeIterable*) _tmp10_);
		_tmp12_ = _tmp11_;
		_g_object_unref0 (_tmp10_);
		_g_object_unref0 (_tmp7_);
		_a_it = _tmp12_;
		while (TRUE) {
			GeeIterator* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			GXmlNode* a = NULL;
			GeeIterator* _tmp15_ = NULL;
			gpointer _tmp16_ = NULL;
			gboolean _tmp47_ = FALSE;
			_tmp13_ = _a_it;
			_tmp14_ = gee_iterator_next (_tmp13_);
			if (!_tmp14_) {
				break;
			}
			_tmp15_ = _a_it;
			_tmp16_ = gee_iterator_get (_tmp15_);
			a = (GXmlNode*) _tmp16_;
			found = FALSE;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp17_ = FALSE;
					_tmp17_ = TRUE;
					while (TRUE) {
						gint _tmp19_ = 0;
						GParamSpec** _tmp20_ = NULL;
						gint _tmp20__length1 = 0;
						GParamSpec* p = NULL;
						GParamSpec** _tmp21_ = NULL;
						gint _tmp21__length1 = 0;
						gint _tmp22_ = 0;
						GParamSpec* _tmp23_ = NULL;
						GParamSpec* _tmp24_ = NULL;
						gboolean _tmp25_ = FALSE;
						GXmlNode* _tmp26_ = NULL;
						gchar* _tmp27_ = NULL;
						gchar* _tmp28_ = NULL;
						gchar* _tmp29_ = NULL;
						gchar* _tmp30_ = NULL;
						gchar* _tmp31_ = NULL;
						GParamSpec* _tmp32_ = NULL;
						const gchar* _tmp33_ = NULL;
						gchar* _tmp34_ = NULL;
						gchar* _tmp35_ = NULL;
						gboolean _tmp36_ = FALSE;
						if (!_tmp17_) {
							gint _tmp18_ = 0;
							_tmp18_ = i;
							i = _tmp18_ + 1;
						}
						_tmp17_ = FALSE;
						_tmp19_ = i;
						_tmp20_ = props;
						_tmp20__length1 = props_length1;
						if (!(_tmp19_ < _tmp20__length1)) {
							break;
						}
						_tmp21_ = props;
						_tmp21__length1 = props_length1;
						_tmp22_ = i;
						_tmp23_ = _tmp21_[_tmp22_];
						_tmp24_ = _g_param_spec_ref0 (_tmp23_);
						p = _tmp24_;
						_tmp26_ = a;
						_tmp27_ = gxml_node_get_name (_tmp26_);
						_tmp28_ = _tmp27_;
						_tmp29_ = _tmp28_;
						_tmp30_ = g_utf8_strdown (_tmp29_, (gssize) -1);
						_tmp31_ = _tmp30_;
						_tmp32_ = p;
						_tmp33_ = g_param_spec_get_name (_tmp32_);
						_tmp34_ = g_utf8_strdown (_tmp33_, (gssize) -1);
						_tmp35_ = _tmp34_;
						_tmp36_ = g_strcmp0 (_tmp31_, _tmp35_) == 0;
						_g_free0 (_tmp35_);
						_g_free0 (_tmp31_);
						_g_free0 (_tmp29_);
						if (_tmp36_) {
							_tmp25_ = TRUE;
						} else {
							GXmlNode* _tmp37_ = NULL;
							gchar* _tmp38_ = NULL;
							gchar* _tmp39_ = NULL;
							gchar* _tmp40_ = NULL;
							gchar* _tmp41_ = NULL;
							gchar* _tmp42_ = NULL;
							GParamSpec* _tmp43_ = NULL;
							const gchar* _tmp44_ = NULL;
							gchar* _tmp45_ = NULL;
							gchar* _tmp46_ = NULL;
							_tmp37_ = a;
							_tmp38_ = gxml_node_get_name (_tmp37_);
							_tmp39_ = _tmp38_;
							_tmp40_ = _tmp39_;
							_tmp41_ = g_utf8_strdown (_tmp40_, (gssize) -1);
							_tmp42_ = _tmp41_;
							_tmp43_ = p;
							_tmp44_ = g_param_spec_get_nick (_tmp43_);
							_tmp45_ = g_utf8_strdown (_tmp44_, (gssize) -1);
							_tmp46_ = _tmp45_;
							_tmp25_ = g_strcmp0 (_tmp42_, _tmp46_) == 0;
							_g_free0 (_tmp46_);
							_g_free0 (_tmp42_);
							_g_free0 (_tmp40_);
						}
						if (_tmp25_) {
							found = TRUE;
						}
						_g_param_spec_unref0 (p);
					}
				}
			}
			_tmp47_ = found;
			if (!_tmp47_) {
				GeeHashMap* _tmp48_ = NULL;
				GXmlNode* _tmp49_ = NULL;
				gchar* _tmp50_ = NULL;
				gchar* _tmp51_ = NULL;
				gchar* _tmp52_ = NULL;
				GXmlNode* _tmp53_ = NULL;
				_tmp48_ = m;
				_tmp49_ = a;
				_tmp50_ = gxml_node_get_name (_tmp49_);
				_tmp51_ = _tmp50_;
				_tmp52_ = _tmp51_;
				_tmp53_ = a;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp48_, _tmp52_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp53_, GXML_TYPE_ATTRIBUTE) ? ((GXmlAttribute*) _tmp53_) : NULL);
				_g_free0 (_tmp52_);
			}
			_g_object_unref0 (a);
		}
		_g_object_unref0 (_a_it);
	}
	result = (GeeMap*) m;
	props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	return result;
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static GeeCollection* gxml_serializable_object_model_real_get_unknown_serializable_nodes (GXmlSerializable* base) {
	GeeCollection* result;
	GXmlSerializableObjectModel* self;
	GeeArrayList* l = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GXmlNode* _tmp1_ = NULL;
	GParamSpec** oprops = NULL;
	gint _tmp2_ = 0;
	GParamSpec** _tmp3_ = NULL;
	gint oprops_length1 = 0;
	gint _oprops_size_ = 0;
	gchar** props = NULL;
	gchar** _tmp4_ = NULL;
	gint props_length1 = 0;
	gint _props_size_ = 0;
	GParamSpec** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gboolean found = FALSE;
	self = (GXmlSerializableObjectModel*) base;
	_tmp0_ = gee_array_list_new (GXML_TYPE_NODE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	l = _tmp0_;
	_tmp1_ = self->_node;
	if (_tmp1_ == NULL) {
		result = (GeeCollection*) l;
		return result;
	}
	_tmp3_ = gxml_serializable_object_model_list_serializable_properties (self, &_tmp2_);
	oprops = _tmp3_;
	oprops_length1 = _tmp2_;
	_oprops_size_ = oprops_length1;
	_tmp4_ = g_new0 (gchar*, 0 + 1);
	props = _tmp4_;
	props_length1 = 0;
	_props_size_ = props_length1;
	_tmp5_ = oprops;
	_tmp5__length1 = oprops_length1;
	{
		GParamSpec** op_collection = NULL;
		gint op_collection_length1 = 0;
		gint _op_collection_size_ = 0;
		gint op_it = 0;
		op_collection = _tmp5_;
		op_collection_length1 = _tmp5__length1;
		for (op_it = 0; op_it < _tmp5__length1; op_it = op_it + 1) {
			GParamSpec* _tmp6_ = NULL;
			GParamSpec* op = NULL;
			_tmp6_ = _g_param_spec_ref0 (op_collection[op_it]);
			op = _tmp6_;
			{
				GParamSpec* _tmp7_ = NULL;
				GType _tmp8_ = 0UL;
				gboolean _tmp9_ = FALSE;
				gboolean _tmp21_ = FALSE;
				_tmp7_ = op;
				_tmp8_ = _tmp7_->value_type;
				_tmp9_ = g_type_is_a (_tmp8_, GXML_TYPE_SERIALIZABLE_COLLECTION);
				if (_tmp9_) {
					GValue v = {0};
					GParamSpec* _tmp10_ = NULL;
					GType _tmp11_ = 0UL;
					GValue _tmp12_ = {0};
					GParamSpec* _tmp13_ = NULL;
					const gchar* _tmp14_ = NULL;
					GObject* obj = NULL;
					GObject* _tmp15_ = NULL;
					GObject* _tmp16_ = NULL;
					GObject* _tmp17_ = NULL;
					_tmp10_ = op;
					_tmp11_ = _tmp10_->value_type;
					g_value_init (&_tmp12_, _tmp11_);
					v = _tmp12_;
					_tmp13_ = op;
					_tmp14_ = g_param_spec_get_name (_tmp13_);
					g_object_get_property ((GObject*) self, _tmp14_, &v);
					_tmp15_ = g_value_get_object (&v);
					_tmp16_ = _g_object_ref0 (_tmp15_);
					obj = _tmp16_;
					_tmp17_ = obj;
					if (_tmp17_ != NULL) {
						gchar** _tmp18_ = NULL;
						gint _tmp18__length1 = 0;
						GObject* _tmp19_ = NULL;
						gchar* _tmp20_ = NULL;
						_tmp18_ = props;
						_tmp18__length1 = props_length1;
						_tmp19_ = obj;
						_tmp20_ = gxml_serializable_node_name (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, GXML_TYPE_SERIALIZABLE) ? ((GXmlSerializable*) _tmp19_) : NULL);
						_vala_array_add3 (&props, &props_length1, &_props_size_, _tmp20_);
						_g_object_unref0 (obj);
						G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
						_g_param_spec_unref0 (op);
						continue;
					}
					_g_object_unref0 (obj);
					G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
				}
				_tmp21_ = gxml_serializable_object_model_property_use_nick (self);
				if (_tmp21_) {
					gchar** _tmp22_ = NULL;
					gint _tmp22__length1 = 0;
					GParamSpec* _tmp23_ = NULL;
					const gchar* _tmp24_ = NULL;
					gchar* _tmp25_ = NULL;
					_tmp22_ = props;
					_tmp22__length1 = props_length1;
					_tmp23_ = op;
					_tmp24_ = g_param_spec_get_nick (_tmp23_);
					_tmp25_ = g_utf8_strdown (_tmp24_, (gssize) -1);
					_vala_array_add4 (&props, &props_length1, &_props_size_, _tmp25_);
				} else {
					gchar** _tmp26_ = NULL;
					gint _tmp26__length1 = 0;
					GParamSpec* _tmp27_ = NULL;
					const gchar* _tmp28_ = NULL;
					gchar* _tmp29_ = NULL;
					_tmp26_ = props;
					_tmp26__length1 = props_length1;
					_tmp27_ = op;
					_tmp28_ = g_param_spec_get_name (_tmp27_);
					_tmp29_ = g_utf8_strdown (_tmp28_, (gssize) -1);
					_vala_array_add5 (&props, &props_length1, &_props_size_, _tmp29_);
				}
				_g_param_spec_unref0 (op);
			}
		}
	}
	found = FALSE;
	{
		GeeBidirList* _n_list = NULL;
		GXmlNode* _tmp30_ = NULL;
		GeeBidirList* _tmp31_ = NULL;
		GeeBidirList* _tmp32_ = NULL;
		gint _n_size = 0;
		GeeBidirList* _tmp33_ = NULL;
		gint _tmp34_ = 0;
		gint _tmp35_ = 0;
		gint _n_index = 0;
		_tmp30_ = self->_node;
		_tmp31_ = gxml_node_get_children_nodes (_tmp30_);
		_tmp32_ = _tmp31_;
		_n_list = _tmp32_;
		_tmp33_ = _n_list;
		_tmp34_ = gee_collection_get_size ((GeeCollection*) _tmp33_);
		_tmp35_ = _tmp34_;
		_n_size = _tmp35_;
		_n_index = -1;
		while (TRUE) {
			gint _tmp36_ = 0;
			gint _tmp37_ = 0;
			gint _tmp38_ = 0;
			GXmlNode* n = NULL;
			GeeBidirList* _tmp39_ = NULL;
			gint _tmp40_ = 0;
			gpointer _tmp41_ = NULL;
			GXmlNode* _tmp42_ = NULL;
			gchar** _tmp44_ = NULL;
			gint _tmp44__length1 = 0;
			gboolean _tmp54_ = FALSE;
			_tmp36_ = _n_index;
			_n_index = _tmp36_ + 1;
			_tmp37_ = _n_index;
			_tmp38_ = _n_size;
			if (!(_tmp37_ < _tmp38_)) {
				break;
			}
			_tmp39_ = _n_list;
			_tmp40_ = _n_index;
			_tmp41_ = gee_list_get ((GeeList*) _tmp39_, _tmp40_);
			n = (GXmlNode*) _tmp41_;
			_tmp42_ = n;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp42_, GXML_TYPE_TEXT)) {
				gboolean _tmp43_ = FALSE;
				_tmp43_ = gxml_serializable_object_model_serialize_use_xml_node_value (self);
				if (_tmp43_) {
					_g_object_unref0 (n);
					continue;
				}
			}
			found = FALSE;
			_tmp44_ = props;
			_tmp44__length1 = props_length1;
			{
				gchar** p_collection = NULL;
				gint p_collection_length1 = 0;
				gint _p_collection_size_ = 0;
				gint p_it = 0;
				p_collection = _tmp44_;
				p_collection_length1 = _tmp44__length1;
				for (p_it = 0; p_it < _tmp44__length1; p_it = p_it + 1) {
					gchar* _tmp45_ = NULL;
					gchar* p = NULL;
					_tmp45_ = g_strdup (p_collection[p_it]);
					p = _tmp45_;
					{
						GXmlNode* _tmp46_ = NULL;
						gchar* _tmp47_ = NULL;
						gchar* _tmp48_ = NULL;
						gchar* _tmp49_ = NULL;
						gchar* _tmp50_ = NULL;
						gchar* _tmp51_ = NULL;
						const gchar* _tmp52_ = NULL;
						gboolean _tmp53_ = FALSE;
						_tmp46_ = n;
						_tmp47_ = gxml_node_get_name (_tmp46_);
						_tmp48_ = _tmp47_;
						_tmp49_ = _tmp48_;
						_tmp50_ = g_utf8_strdown (_tmp49_, (gssize) -1);
						_tmp51_ = _tmp50_;
						_tmp52_ = p;
						_tmp53_ = g_strcmp0 (_tmp51_, _tmp52_) == 0;
						_g_free0 (_tmp51_);
						_g_free0 (_tmp49_);
						if (_tmp53_) {
							found = TRUE;
						}
						_g_free0 (p);
					}
				}
			}
			_tmp54_ = found;
			if (!_tmp54_) {
				GeeArrayList* _tmp55_ = NULL;
				GXmlNode* _tmp56_ = NULL;
				_tmp55_ = l;
				_tmp56_ = n;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp55_, _tmp56_);
			}
			_g_object_unref0 (n);
		}
		_g_object_unref0 (_n_list);
	}
	result = (GeeCollection*) l;
	props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
	oprops = (_vala_array_free (oprops, oprops_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	return result;
}


static GObject * gxml_serializable_object_model_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GXmlSerializableObjectModel * self;
	parent_class = G_OBJECT_CLASS (gxml_serializable_object_model_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GXML_TYPE_SERIALIZABLE_OBJECT_MODEL, GXmlSerializableObjectModel);
	gxml_init_init ();
	return obj;
}


static void gxml_serializable_object_model_class_init (GXmlSerializableObjectModelClass * klass) {
	gxml_serializable_object_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GXmlSerializableObjectModelPrivate));
	((GXmlSerializableObjectModelClass *) klass)->get_enable_unknown_serializable_property = (gboolean (*)(GXmlSerializableObjectModel*)) gxml_serializable_object_model_real_get_enable_unknown_serializable_property;
	((GXmlSerializableObjectModelClass *) klass)->serialize_use_xml_node_value = (gboolean (*)(GXmlSerializableObjectModel*)) gxml_serializable_object_model_real_serialize_use_xml_node_value;
	((GXmlSerializableObjectModelClass *) klass)->property_use_nick = (gboolean (*)(GXmlSerializableObjectModel*)) gxml_serializable_object_model_real_property_use_nick;
	((GXmlSerializableObjectModelClass *) klass)->set_default_namespace = (gboolean (*)(GXmlSerializableObjectModel*, GXmlNode*)) gxml_serializable_object_model_real_set_default_namespace;
	((GXmlSerializableObjectModelClass *) klass)->node_name = (gchar* (*)(GXmlSerializableObjectModel*)) gxml_serializable_object_model_real_node_name;
	((GXmlSerializableObjectModelClass *) klass)->find_property_spec = (GParamSpec* (*)(GXmlSerializableObjectModel*, const gchar*)) gxml_serializable_object_model_real_find_property_spec;
	((GXmlSerializableObjectModelClass *) klass)->list_serializable_properties = (GParamSpec** (*)(GXmlSerializableObjectModel*, int*)) gxml_serializable_object_model_real_list_serializable_properties;
	((GXmlSerializableObjectModelClass *) klass)->serialize = (GXmlNode* (*)(GXmlSerializableObjectModel*, GXmlNode*, GError**)) gxml_serializable_object_model_real_serialize;
	((GXmlSerializableObjectModelClass *) klass)->serialize_property = (GXmlNode* (*)(GXmlSerializableObjectModel*, GXmlNode*, GParamSpec*, GError**)) gxml_serializable_object_model_real_serialize_property;
	((GXmlSerializableObjectModelClass *) klass)->deserialize = (gboolean (*)(GXmlSerializableObjectModel*, GXmlNode*, GError**)) gxml_serializable_object_model_real_deserialize;
	((GXmlSerializableObjectModelClass *) klass)->deserialize_property = (gboolean (*)(GXmlSerializableObjectModel*, GXmlNode*, GError**)) gxml_serializable_object_model_real_deserialize_property;
	((GXmlSerializableObjectModelClass *) klass)->to_string = (gchar* (*)(GXmlSerializableObjectModel*)) gxml_serializable_object_model_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = _vala_gxml_serializable_object_model_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gxml_serializable_object_model_set_property;
	G_OBJECT_CLASS (klass)->constructor = gxml_serializable_object_model_constructor;
	G_OBJECT_CLASS (klass)->finalize = gxml_serializable_object_model_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_SERIALIZABLE_OBJECT_MODEL_IGNORED_SERIALIZABLE_PROPERTIES, g_param_spec_boxed ("ignored-serializable-properties", "ignored-serializable-properties", "ignored-serializable-properties", G_TYPE_HASH_TABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_SERIALIZABLE_OBJECT_MODEL_SERIALIZED_XML_NODE_VALUE, g_param_spec_string ("serialized-xml-node-value", "serialized-xml-node-value", "serialized-xml-node-value", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * All unknown nodes, will be stored in a per-object {@link GXml.Document}
	   * in its {@link GXml.Element} root. Then, all unknown properties will be
	   * stored as properties in document's root and all unknown childs {@link GXml.Node}
	   * as root's childs.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_SERIALIZABLE_OBJECT_MODEL_UNKNOWN_SERIALIZABLE_PROPERTIES, g_param_spec_object ("unknown-serializable-properties", "unknown-serializable-properties", "unknown-serializable-properties", GEE_TYPE_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_SERIALIZABLE_OBJECT_MODEL_UNKNOWN_SERIALIZABLE_NODES, g_param_spec_object ("unknown-serializable-nodes", "unknown-serializable-nodes", "unknown-serializable-nodes", GEE_TYPE_COLLECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gxml_serializable_object_model_gxml_serializable_interface_init (GXmlSerializableIface * iface) {
	gxml_serializable_object_model_gxml_serializable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_enable_unknown_serializable_property = (gboolean (*)(GXmlSerializable*)) gxml_serializable_object_model_get_enable_unknown_serializable_property;
	iface->serialize_use_xml_node_value = (gboolean (*)(GXmlSerializable*)) gxml_serializable_object_model_serialize_use_xml_node_value;
	iface->property_use_nick = (gboolean (*)(GXmlSerializable*)) gxml_serializable_object_model_property_use_nick;
	iface->set_default_namespace = (gboolean (*)(GXmlSerializable*, GXmlNode*)) gxml_serializable_object_model_set_default_namespace;
	iface->node_name = (gchar* (*)(GXmlSerializable*)) gxml_serializable_object_model_node_name;
	iface->find_property_spec = (GParamSpec* (*)(GXmlSerializable*, const gchar*)) gxml_serializable_object_model_find_property_spec;
	iface->list_serializable_properties = (GParamSpec** (*)(GXmlSerializable*, int*)) gxml_serializable_object_model_list_serializable_properties;
	iface->serialize = (GXmlNode* (*)(GXmlSerializable*, GXmlNode*, GError**)) gxml_serializable_object_model_serialize;
	iface->serialize_property = (GXmlNode* (*)(GXmlSerializable*, GXmlNode*, GParamSpec*, GError**)) gxml_serializable_object_model_serialize_property;
	iface->deserialize = (gboolean (*)(GXmlSerializable*, GXmlNode*, GError**)) gxml_serializable_object_model_deserialize;
	iface->deserialize_property = (gboolean (*)(GXmlSerializable*, GXmlNode*, GError**)) gxml_serializable_object_model_deserialize_property;
	iface->get_serialized_xml_node_value = gxml_serializable_object_model_real_get_serialized_xml_node_value;
	iface->set_serialized_xml_node_value = gxml_serializable_object_model_real_set_serialized_xml_node_value;
	iface->get_unknown_serializable_properties = gxml_serializable_object_model_real_get_unknown_serializable_properties;
	iface->get_unknown_serializable_nodes = gxml_serializable_object_model_real_get_unknown_serializable_nodes;
}


static void gxml_serializable_object_model_instance_init (GXmlSerializableObjectModel * self) {
	self->priv = GXML_SERIALIZABLE_OBJECT_MODEL_GET_PRIVATE (self);
	self->_node = NULL;
	self->priv->_serialized_xml_node_value = NULL;
}


static void gxml_serializable_object_model_finalize (GObject* obj) {
	GXmlSerializableObjectModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GXML_TYPE_SERIALIZABLE_OBJECT_MODEL, GXmlSerializableObjectModel);
	_g_object_unref0 (self->_node);
	self->priv->_properties = (_vala_array_free (self->priv->_properties, self->priv->_properties_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	_g_hash_table_unref0 (self->priv->_ignored_serializable_properties);
	_g_free0 (self->priv->_serialized_xml_node_value);
	G_OBJECT_CLASS (gxml_serializable_object_model_parent_class)->finalize (obj);
}


/**
 * Object Model is an {@link Serializable} implementation using {@link Element}
 * to represent {@link GLib.Object} class objects.
 * 
 * This implementation consider each object as a XML node, represented in GXml 
 * as a {@link GXml.Element} and its properties is represented by {@link GXml.Attribute}.
 * Each property, if it is a {@link Serializable} object, is represented as child
 * {@link Element}.
 * 
 * If a object's value property must be represented as a XML node content, 
 * then it requires to override {@link Serializable.serialize_use_xml_node_value}
 * and set value at {@link Serializable.serialized_xml_node_value}.
 */
GType gxml_serializable_object_model_get_type (void) {
	static volatile gsize gxml_serializable_object_model_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_serializable_object_model_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlSerializableObjectModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gxml_serializable_object_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GXmlSerializableObjectModel), 0, (GInstanceInitFunc) gxml_serializable_object_model_instance_init, NULL };
		static const GInterfaceInfo gxml_serializable_info = { (GInterfaceInitFunc) gxml_serializable_object_model_gxml_serializable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gxml_serializable_object_model_type_id;
		gxml_serializable_object_model_type_id = g_type_register_static (G_TYPE_OBJECT, "GXmlSerializableObjectModel", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (gxml_serializable_object_model_type_id, GXML_TYPE_SERIALIZABLE, &gxml_serializable_info);
		g_once_init_leave (&gxml_serializable_object_model_type_id__volatile, gxml_serializable_object_model_type_id);
	}
	return gxml_serializable_object_model_type_id__volatile;
}


static void _vala_gxml_serializable_object_model_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GXmlSerializableObjectModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GXML_TYPE_SERIALIZABLE_OBJECT_MODEL, GXmlSerializableObjectModel);
	switch (property_id) {
		case GXML_SERIALIZABLE_OBJECT_MODEL_IGNORED_SERIALIZABLE_PROPERTIES:
		g_value_set_boxed (value, gxml_serializable_object_model_get_ignored_serializable_properties (self));
		break;
		case GXML_SERIALIZABLE_OBJECT_MODEL_SERIALIZED_XML_NODE_VALUE:
		g_value_take_string (value, gxml_serializable_get_serialized_xml_node_value ((GXmlSerializable*) self));
		break;
		case GXML_SERIALIZABLE_OBJECT_MODEL_UNKNOWN_SERIALIZABLE_PROPERTIES:
		g_value_take_object (value, gxml_serializable_get_unknown_serializable_properties ((GXmlSerializable*) self));
		break;
		case GXML_SERIALIZABLE_OBJECT_MODEL_UNKNOWN_SERIALIZABLE_NODES:
		g_value_take_object (value, gxml_serializable_get_unknown_serializable_nodes ((GXmlSerializable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gxml_serializable_object_model_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GXmlSerializableObjectModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GXML_TYPE_SERIALIZABLE_OBJECT_MODEL, GXmlSerializableObjectModel);
	switch (property_id) {
		case GXML_SERIALIZABLE_OBJECT_MODEL_IGNORED_SERIALIZABLE_PROPERTIES:
		gxml_serializable_object_model_set_ignored_serializable_properties (self, g_value_get_boxed (value));
		break;
		case GXML_SERIALIZABLE_OBJECT_MODEL_SERIALIZED_XML_NODE_VALUE:
		gxml_serializable_set_serialized_xml_node_value ((GXmlSerializable*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



