/* DomEvents.c generated by valac 0.34.7, the Vala compiler
 * generated from DomEvents.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 2 -*- */
/*
 *
 * Copyright (C) 2016  Daniel Espinosa <esodan@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      Daniel Espinosa <esodan@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define GXML_TYPE_DOM_EVENT_TARGET (gxml_dom_event_target_get_type ())
#define GXML_DOM_EVENT_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_EVENT_TARGET, GXmlDomEventTarget))
#define GXML_IS_DOM_EVENT_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_EVENT_TARGET))
#define GXML_DOM_EVENT_TARGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOM_EVENT_TARGET, GXmlDomEventTargetIface))

typedef struct _GXmlDomEventTarget GXmlDomEventTarget;
typedef struct _GXmlDomEventTargetIface GXmlDomEventTargetIface;

#define GXML_TYPE_DOM_EVENT_LISTENER (gxml_dom_event_listener_get_type ())
#define GXML_DOM_EVENT_LISTENER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_EVENT_LISTENER, GXmlDomEventListener))
#define GXML_IS_DOM_EVENT_LISTENER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_EVENT_LISTENER))
#define GXML_DOM_EVENT_LISTENER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOM_EVENT_LISTENER, GXmlDomEventListenerIface))

typedef struct _GXmlDomEventListener GXmlDomEventListener;
typedef struct _GXmlDomEventListenerIface GXmlDomEventListenerIface;

#define GXML_TYPE_DOM_EVENT (gxml_dom_event_get_type ())
#define GXML_DOM_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_EVENT, GXmlDomEvent))
#define GXML_IS_DOM_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_EVENT))
#define GXML_DOM_EVENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOM_EVENT, GXmlDomEventIface))

typedef struct _GXmlDomEvent GXmlDomEvent;
typedef struct _GXmlDomEventIface GXmlDomEventIface;

#define GXML_TYPE_DOM_TIME_STAMP (gxml_dom_time_stamp_get_type ())
#define GXML_DOM_TIME_STAMP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_TIME_STAMP, GXmlDomTimeStamp))
#define GXML_DOM_TIME_STAMP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_DOM_TIME_STAMP, GXmlDomTimeStampClass))
#define GXML_IS_DOM_TIME_STAMP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_TIME_STAMP))
#define GXML_IS_DOM_TIME_STAMP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_DOM_TIME_STAMP))
#define GXML_DOM_TIME_STAMP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_DOM_TIME_STAMP, GXmlDomTimeStampClass))

typedef struct _GXmlDomTimeStamp GXmlDomTimeStamp;
typedef struct _GXmlDomTimeStampClass GXmlDomTimeStampClass;

#define GXML_DOM_EVENT_TYPE_PHASE (gxml_dom_event_phase_get_type ())

#define GXML_DOM_EVENT_TYPE_FLAGS (gxml_dom_event_flags_get_type ())

#define GXML_TYPE_DOM_EVENT_INIT (gxml_dom_event_init_get_type ())
#define GXML_DOM_EVENT_INIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_EVENT_INIT, GXmlDomEventInit))
#define GXML_DOM_EVENT_INIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_DOM_EVENT_INIT, GXmlDomEventInitClass))
#define GXML_IS_DOM_EVENT_INIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_EVENT_INIT))
#define GXML_IS_DOM_EVENT_INIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_DOM_EVENT_INIT))
#define GXML_DOM_EVENT_INIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_DOM_EVENT_INIT, GXmlDomEventInitClass))

typedef struct _GXmlDomEventInit GXmlDomEventInit;
typedef struct _GXmlDomEventInitClass GXmlDomEventInitClass;
typedef struct _GXmlDomEventInitPrivate GXmlDomEventInitPrivate;

#define GXML_TYPE_DOM_CUSTOM_EVENT (gxml_dom_custom_event_get_type ())
#define GXML_DOM_CUSTOM_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_CUSTOM_EVENT, GXmlDomCustomEvent))
#define GXML_IS_DOM_CUSTOM_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_CUSTOM_EVENT))
#define GXML_DOM_CUSTOM_EVENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOM_CUSTOM_EVENT, GXmlDomCustomEventIface))

typedef struct _GXmlDomCustomEvent GXmlDomCustomEvent;
typedef struct _GXmlDomCustomEventIface GXmlDomCustomEventIface;

#define GXML_TYPE_DOM_CUSTOM_EVENT_INIT (gxml_dom_custom_event_init_get_type ())
#define GXML_DOM_CUSTOM_EVENT_INIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOM_CUSTOM_EVENT_INIT, GXmlDomCustomEventInit))
#define GXML_DOM_CUSTOM_EVENT_INIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_DOM_CUSTOM_EVENT_INIT, GXmlDomCustomEventInitClass))
#define GXML_IS_DOM_CUSTOM_EVENT_INIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOM_CUSTOM_EVENT_INIT))
#define GXML_IS_DOM_CUSTOM_EVENT_INIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_DOM_CUSTOM_EVENT_INIT))
#define GXML_DOM_CUSTOM_EVENT_INIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_DOM_CUSTOM_EVENT_INIT, GXmlDomCustomEventInitClass))

typedef struct _GXmlDomCustomEventInit GXmlDomCustomEventInit;
typedef struct _GXmlDomCustomEventInitClass GXmlDomCustomEventInitClass;
typedef struct _GXmlDomCustomEventInitPrivate GXmlDomCustomEventInitPrivate;
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
typedef struct _GXmlDomTimeStampPrivate GXmlDomTimeStampPrivate;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

typedef enum  {
	GXML_DOM_EVENT_PHASE_NONE = 0,
	GXML_DOM_EVENT_PHASE_CAPTURING_PHASE,
	GXML_DOM_EVENT_PHASE_AT_TARGET,
	GXML_DOM_EVENT_PHASE_BUBBLING_PHASE
} GXmlDomEventPhase;

struct _GXmlDomEventIface {
	GTypeInterface parent_iface;
	void (*stop_propagation) (GXmlDomEvent* self);
	void (*stop_immediate_propagation) (GXmlDomEvent* self);
	void (*prevent_default) (GXmlDomEvent* self);
	void (*init_event) (GXmlDomEvent* self, const gchar* type, gboolean bubbles, gboolean cancelable);
	const gchar* (*get_etype) (GXmlDomEvent* self);
	GXmlDomEventTarget* (*get_event_target) (GXmlDomEvent* self);
	GXmlDomEventTarget* (*get_current_target) (GXmlDomEvent* self);
	gboolean (*get_bubbles) (GXmlDomEvent* self);
	gboolean (*get_cancelable) (GXmlDomEvent* self);
	gboolean (*get_is_trusted) (GXmlDomEvent* self);
	GXmlDomTimeStamp* (*get_time_stamp) (GXmlDomEvent* self);
	gboolean (*get_default_prevented) (GXmlDomEvent* self);
	GXmlDomEventPhase (*get_event_phase) (GXmlDomEvent* self);
};

struct _GXmlDomEventListenerIface {
	GTypeInterface parent_iface;
	void (*handle_event) (GXmlDomEventListener* self, GXmlDomEvent* event);
};

struct _GXmlDomEventTargetIface {
	GTypeInterface parent_iface;
	void (*add_event_listener) (GXmlDomEventTarget* self, const gchar* type, GXmlDomEventListener* callback, gboolean capture);
	void (*remove_event_listener) (GXmlDomEventTarget* self, const gchar* type, GXmlDomEventListener* callback, gboolean capture);
	gboolean (*dispatch_event) (GXmlDomEventTarget* self, GXmlDomEvent* event, GError** error);
};

typedef enum  {
	GXML_DOM_EVENT_FLAGS_STOP_PROPAGATION_FLAG = 1 << 0,
	GXML_DOM_EVENT_FLAGS_STOP_IMMEDIATE_PROPAGATION_FLAG = 1 << 1,
	GXML_DOM_EVENT_FLAGS_CANCELED_FLAG = 1 << 2,
	GXML_DOM_EVENT_FLAGS_INITIALIZED_FLAG = 1 << 3,
	GXML_DOM_EVENT_FLAGS_DISPATCH_FLAG = 1 << 4
} GXmlDomEventFlags;

struct _GXmlDomEventInit {
	GObject parent_instance;
	GXmlDomEventInitPrivate * priv;
};

struct _GXmlDomEventInitClass {
	GObjectClass parent_class;
};

struct _GXmlDomEventInitPrivate {
	gboolean _bubbles;
	gboolean _cancelable;
};

struct _GXmlDomCustomEventIface {
	GTypeInterface parent_iface;
	void (*init_custom_event) (GXmlDomCustomEvent* self, const gchar* type, gboolean bubbles, gboolean cancelable, GValue* detail);
	GValue* (*get_detail) (GXmlDomCustomEvent* self);
};

struct _GXmlDomCustomEventInit {
	GXmlDomEventInit parent_instance;
	GXmlDomCustomEventInitPrivate * priv;
};

struct _GXmlDomCustomEventInitClass {
	GXmlDomEventInitClass parent_class;
};

struct _GXmlDomCustomEventInitPrivate {
	GValue* _detail;
};

struct _GXmlDomTimeStamp {
	GObject parent_instance;
	GXmlDomTimeStampPrivate * priv;
};

struct _GXmlDomTimeStampClass {
	GObjectClass parent_class;
};

struct _GXmlDomTimeStampPrivate {
	GDateTime* _time;
};


static gpointer gxml_dom_event_init_parent_class = NULL;
static gpointer gxml_dom_custom_event_init_parent_class = NULL;
static gpointer gxml_dom_time_stamp_parent_class = NULL;

GType gxml_dom_time_stamp_get_type (void) G_GNUC_CONST;
GType gxml_dom_event_phase_get_type (void) G_GNUC_CONST;
GType gxml_dom_event_get_type (void) G_GNUC_CONST;
GType gxml_dom_event_listener_get_type (void) G_GNUC_CONST;
GType gxml_dom_event_target_get_type (void) G_GNUC_CONST;
void gxml_dom_event_target_add_event_listener (GXmlDomEventTarget* self, const gchar* type, GXmlDomEventListener* callback, gboolean capture);
void gxml_dom_event_target_remove_event_listener (GXmlDomEventTarget* self, const gchar* type, GXmlDomEventListener* callback, gboolean capture);
gboolean gxml_dom_event_target_dispatch_event (GXmlDomEventTarget* self, GXmlDomEvent* event, GError** error);
void gxml_dom_event_listener_handle_event (GXmlDomEventListener* self, GXmlDomEvent* event);
GType gxml_dom_event_flags_get_type (void) G_GNUC_CONST;
void gxml_dom_event_stop_propagation (GXmlDomEvent* self);
void gxml_dom_event_stop_immediate_propagation (GXmlDomEvent* self);
void gxml_dom_event_prevent_default (GXmlDomEvent* self);
void gxml_dom_event_init_event (GXmlDomEvent* self, const gchar* type, gboolean bubbles, gboolean cancelable);
const gchar* gxml_dom_event_get_etype (GXmlDomEvent* self);
GXmlDomEventTarget* gxml_dom_event_get_event_target (GXmlDomEvent* self);
GXmlDomEventTarget* gxml_dom_event_get_current_target (GXmlDomEvent* self);
gboolean gxml_dom_event_get_bubbles (GXmlDomEvent* self);
gboolean gxml_dom_event_get_cancelable (GXmlDomEvent* self);
gboolean gxml_dom_event_get_is_trusted (GXmlDomEvent* self);
GXmlDomTimeStamp* gxml_dom_event_get_time_stamp (GXmlDomEvent* self);
gboolean gxml_dom_event_get_default_prevented (GXmlDomEvent* self);
GXmlDomEventPhase gxml_dom_event_get_event_phase (GXmlDomEvent* self);
GType gxml_dom_event_init_get_type (void) G_GNUC_CONST;
#define GXML_DOM_EVENT_INIT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GXML_TYPE_DOM_EVENT_INIT, GXmlDomEventInitPrivate))
enum  {
	GXML_DOM_EVENT_INIT_DUMMY_PROPERTY,
	GXML_DOM_EVENT_INIT_BUBBLES,
	GXML_DOM_EVENT_INIT_CANCELABLE
};
GXmlDomEventInit* gxml_dom_event_init_new (void);
GXmlDomEventInit* gxml_dom_event_init_construct (GType object_type);
gboolean gxml_dom_event_init_get_bubbles (GXmlDomEventInit* self);
void gxml_dom_event_init_set_bubbles (GXmlDomEventInit* self, gboolean value);
gboolean gxml_dom_event_init_get_cancelable (GXmlDomEventInit* self);
void gxml_dom_event_init_set_cancelable (GXmlDomEventInit* self, gboolean value);
static void gxml_dom_event_init_finalize (GObject* obj);
static void _vala_gxml_dom_event_init_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gxml_dom_event_init_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType gxml_dom_custom_event_get_type (void) G_GNUC_CONST;
void gxml_dom_custom_event_init_custom_event (GXmlDomCustomEvent* self, const gchar* type, gboolean bubbles, gboolean cancelable, GValue* detail);
GValue* gxml_dom_custom_event_get_detail (GXmlDomCustomEvent* self);
GType gxml_dom_custom_event_init_get_type (void) G_GNUC_CONST;
#define GXML_DOM_CUSTOM_EVENT_INIT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GXML_TYPE_DOM_CUSTOM_EVENT_INIT, GXmlDomCustomEventInitPrivate))
enum  {
	GXML_DOM_CUSTOM_EVENT_INIT_DUMMY_PROPERTY
};
static void _vala_GValue_free (GValue* self);
GXmlDomCustomEventInit* gxml_dom_custom_event_init_new (void);
GXmlDomCustomEventInit* gxml_dom_custom_event_init_construct (GType object_type);
GValue* gxml_dom_custom_event_init_get_detail (GXmlDomCustomEventInit* self);
void gxml_dom_custom_event_init_set_detail (GXmlDomCustomEventInit* self, GValue* value);
static GValue* _g_value_dup (GValue* self);
static void gxml_dom_custom_event_init_finalize (GObject* obj);
static void _vala_gxml_dom_custom_event_init_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gxml_dom_custom_event_init_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define GXML_DOM_TIME_STAMP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GXML_TYPE_DOM_TIME_STAMP, GXmlDomTimeStampPrivate))
enum  {
	GXML_DOM_TIME_STAMP_DUMMY_PROPERTY,
	GXML_DOM_TIME_STAMP_TIME
};
gchar* gxml_dom_time_stamp_to_string (GXmlDomTimeStamp* self);
GDateTime* gxml_dom_time_stamp_get_time (GXmlDomTimeStamp* self);
GXmlDomTimeStamp* gxml_dom_time_stamp_new (void);
GXmlDomTimeStamp* gxml_dom_time_stamp_construct (GType object_type);
void gxml_dom_time_stamp_set_time (GXmlDomTimeStamp* self, GDateTime* value);
static void gxml_dom_time_stamp_finalize (GObject* obj);
static void _vala_gxml_dom_time_stamp_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gxml_dom_time_stamp_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


void gxml_dom_event_target_add_event_listener (GXmlDomEventTarget* self, const gchar* type, GXmlDomEventListener* callback, gboolean capture) {
	g_return_if_fail (self != NULL);
	GXML_DOM_EVENT_TARGET_GET_INTERFACE (self)->add_event_listener (self, type, callback, capture);
}


void gxml_dom_event_target_remove_event_listener (GXmlDomEventTarget* self, const gchar* type, GXmlDomEventListener* callback, gboolean capture) {
	g_return_if_fail (self != NULL);
	GXML_DOM_EVENT_TARGET_GET_INTERFACE (self)->remove_event_listener (self, type, callback, capture);
}


gboolean gxml_dom_event_target_dispatch_event (GXmlDomEventTarget* self, GXmlDomEvent* event, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_DOM_EVENT_TARGET_GET_INTERFACE (self)->dispatch_event (self, event, error);
}


static void gxml_dom_event_target_base_init (GXmlDomEventTargetIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType gxml_dom_event_target_get_type (void) {
	static volatile gsize gxml_dom_event_target_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_dom_event_target_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlDomEventTargetIface), (GBaseInitFunc) gxml_dom_event_target_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gxml_dom_event_target_type_id;
		gxml_dom_event_target_type_id = g_type_register_static (G_TYPE_INTERFACE, "GXmlDomEventTarget", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gxml_dom_event_target_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&gxml_dom_event_target_type_id__volatile, gxml_dom_event_target_type_id);
	}
	return gxml_dom_event_target_type_id__volatile;
}


void gxml_dom_event_listener_handle_event (GXmlDomEventListener* self, GXmlDomEvent* event) {
	g_return_if_fail (self != NULL);
	GXML_DOM_EVENT_LISTENER_GET_INTERFACE (self)->handle_event (self, event);
}


static void gxml_dom_event_listener_base_init (GXmlDomEventListenerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType gxml_dom_event_listener_get_type (void) {
	static volatile gsize gxml_dom_event_listener_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_dom_event_listener_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlDomEventListenerIface), (GBaseInitFunc) gxml_dom_event_listener_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gxml_dom_event_listener_type_id;
		gxml_dom_event_listener_type_id = g_type_register_static (G_TYPE_INTERFACE, "GXmlDomEventListener", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gxml_dom_event_listener_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&gxml_dom_event_listener_type_id__volatile, gxml_dom_event_listener_type_id);
	}
	return gxml_dom_event_listener_type_id__volatile;
}


GType gxml_dom_event_phase_get_type (void) {
	static volatile gsize gxml_dom_event_phase_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_dom_event_phase_type_id__volatile)) {
		static const GEnumValue values[] = {{GXML_DOM_EVENT_PHASE_NONE, "GXML_DOM_EVENT_PHASE_NONE", "none"}, {GXML_DOM_EVENT_PHASE_CAPTURING_PHASE, "GXML_DOM_EVENT_PHASE_CAPTURING_PHASE", "capturing-phase"}, {GXML_DOM_EVENT_PHASE_AT_TARGET, "GXML_DOM_EVENT_PHASE_AT_TARGET", "at-target"}, {GXML_DOM_EVENT_PHASE_BUBBLING_PHASE, "GXML_DOM_EVENT_PHASE_BUBBLING_PHASE", "bubbling-phase"}, {0, NULL, NULL}};
		GType gxml_dom_event_phase_type_id;
		gxml_dom_event_phase_type_id = g_enum_register_static ("GXmlDomEventPhase", values);
		g_once_init_leave (&gxml_dom_event_phase_type_id__volatile, gxml_dom_event_phase_type_id);
	}
	return gxml_dom_event_phase_type_id__volatile;
}


GType gxml_dom_event_flags_get_type (void) {
	static volatile gsize gxml_dom_event_flags_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_dom_event_flags_type_id__volatile)) {
		static const GFlagsValue values[] = {{GXML_DOM_EVENT_FLAGS_STOP_PROPAGATION_FLAG, "GXML_DOM_EVENT_FLAGS_STOP_PROPAGATION_FLAG", "stop-propagation-flag"}, {GXML_DOM_EVENT_FLAGS_STOP_IMMEDIATE_PROPAGATION_FLAG, "GXML_DOM_EVENT_FLAGS_STOP_IMMEDIATE_PROPAGATION_FLAG", "stop-immediate-propagation-flag"}, {GXML_DOM_EVENT_FLAGS_CANCELED_FLAG, "GXML_DOM_EVENT_FLAGS_CANCELED_FLAG", "canceled-flag"}, {GXML_DOM_EVENT_FLAGS_INITIALIZED_FLAG, "GXML_DOM_EVENT_FLAGS_INITIALIZED_FLAG", "initialized-flag"}, {GXML_DOM_EVENT_FLAGS_DISPATCH_FLAG, "GXML_DOM_EVENT_FLAGS_DISPATCH_FLAG", "dispatch-flag"}, {0, NULL, NULL}};
		GType gxml_dom_event_flags_type_id;
		gxml_dom_event_flags_type_id = g_flags_register_static ("GXmlDomEventFlags", values);
		g_once_init_leave (&gxml_dom_event_flags_type_id__volatile, gxml_dom_event_flags_type_id);
	}
	return gxml_dom_event_flags_type_id__volatile;
}


void gxml_dom_event_stop_propagation (GXmlDomEvent* self) {
	g_return_if_fail (self != NULL);
	GXML_DOM_EVENT_GET_INTERFACE (self)->stop_propagation (self);
}


void gxml_dom_event_stop_immediate_propagation (GXmlDomEvent* self) {
	g_return_if_fail (self != NULL);
	GXML_DOM_EVENT_GET_INTERFACE (self)->stop_immediate_propagation (self);
}


void gxml_dom_event_prevent_default (GXmlDomEvent* self) {
	g_return_if_fail (self != NULL);
	GXML_DOM_EVENT_GET_INTERFACE (self)->prevent_default (self);
}


void gxml_dom_event_init_event (GXmlDomEvent* self, const gchar* type, gboolean bubbles, gboolean cancelable) {
	g_return_if_fail (self != NULL);
	GXML_DOM_EVENT_GET_INTERFACE (self)->init_event (self, type, bubbles, cancelable);
}


const gchar* gxml_dom_event_get_etype (GXmlDomEvent* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_DOM_EVENT_GET_INTERFACE (self)->get_etype (self);
}


GXmlDomEventTarget* gxml_dom_event_get_event_target (GXmlDomEvent* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_DOM_EVENT_GET_INTERFACE (self)->get_event_target (self);
}


GXmlDomEventTarget* gxml_dom_event_get_current_target (GXmlDomEvent* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_DOM_EVENT_GET_INTERFACE (self)->get_current_target (self);
}


gboolean gxml_dom_event_get_bubbles (GXmlDomEvent* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_DOM_EVENT_GET_INTERFACE (self)->get_bubbles (self);
}


gboolean gxml_dom_event_get_cancelable (GXmlDomEvent* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_DOM_EVENT_GET_INTERFACE (self)->get_cancelable (self);
}


gboolean gxml_dom_event_get_is_trusted (GXmlDomEvent* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_DOM_EVENT_GET_INTERFACE (self)->get_is_trusted (self);
}


GXmlDomTimeStamp* gxml_dom_event_get_time_stamp (GXmlDomEvent* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_DOM_EVENT_GET_INTERFACE (self)->get_time_stamp (self);
}


gboolean gxml_dom_event_get_default_prevented (GXmlDomEvent* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_DOM_EVENT_GET_INTERFACE (self)->get_default_prevented (self);
}


GXmlDomEventPhase gxml_dom_event_get_event_phase (GXmlDomEvent* self) {
	g_return_val_if_fail (self != NULL, 0);
	return GXML_DOM_EVENT_GET_INTERFACE (self)->get_event_phase (self);
}


static void gxml_dom_event_base_init (GXmlDomEventIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_string ("etype", "etype", "etype", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_object ("event-target", "event-target", "event-target", GXML_TYPE_DOM_EVENT_TARGET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_object ("current-target", "current-target", "current-target", GXML_TYPE_DOM_EVENT_TARGET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_boolean ("bubbles", "bubbles", "bubbles", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_boolean ("cancelable", "cancelable", "cancelable", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_boolean ("is-trusted", "is-trusted", "is-trusted", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_object ("time-stamp", "time-stamp", "time-stamp", GXML_TYPE_DOM_TIME_STAMP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_boolean ("default-prevented", "default-prevented", "default-prevented", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_enum ("event-phase", "event-phase", "event-phase", GXML_DOM_EVENT_TYPE_PHASE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	}
}


GType gxml_dom_event_get_type (void) {
	static volatile gsize gxml_dom_event_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_dom_event_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlDomEventIface), (GBaseInitFunc) gxml_dom_event_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gxml_dom_event_type_id;
		gxml_dom_event_type_id = g_type_register_static (G_TYPE_INTERFACE, "GXmlDomEvent", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gxml_dom_event_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&gxml_dom_event_type_id__volatile, gxml_dom_event_type_id);
	}
	return gxml_dom_event_type_id__volatile;
}


GXmlDomEventInit* gxml_dom_event_init_construct (GType object_type) {
	GXmlDomEventInit * self = NULL;
	self = (GXmlDomEventInit*) g_object_new (object_type, NULL);
	return self;
}


GXmlDomEventInit* gxml_dom_event_init_new (void) {
	return gxml_dom_event_init_construct (GXML_TYPE_DOM_EVENT_INIT);
}


gboolean gxml_dom_event_init_get_bubbles (GXmlDomEventInit* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_bubbles;
	result = _tmp0_;
	return result;
}


void gxml_dom_event_init_set_bubbles (GXmlDomEventInit* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_bubbles = _tmp0_;
	g_object_notify ((GObject *) self, "bubbles");
}


gboolean gxml_dom_event_init_get_cancelable (GXmlDomEventInit* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_cancelable;
	result = _tmp0_;
	return result;
}


void gxml_dom_event_init_set_cancelable (GXmlDomEventInit* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_cancelable = _tmp0_;
	g_object_notify ((GObject *) self, "cancelable");
}


static void gxml_dom_event_init_class_init (GXmlDomEventInitClass * klass) {
	gxml_dom_event_init_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GXmlDomEventInitPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gxml_dom_event_init_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gxml_dom_event_init_set_property;
	G_OBJECT_CLASS (klass)->finalize = gxml_dom_event_init_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_DOM_EVENT_INIT_BUBBLES, g_param_spec_boolean ("bubbles", "bubbles", "bubbles", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_DOM_EVENT_INIT_CANCELABLE, g_param_spec_boolean ("cancelable", "cancelable", "cancelable", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gxml_dom_event_init_instance_init (GXmlDomEventInit * self) {
	self->priv = GXML_DOM_EVENT_INIT_GET_PRIVATE (self);
	self->priv->_bubbles = FALSE;
	self->priv->_cancelable = FALSE;
}


static void gxml_dom_event_init_finalize (GObject* obj) {
	GXmlDomEventInit * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GXML_TYPE_DOM_EVENT_INIT, GXmlDomEventInit);
	G_OBJECT_CLASS (gxml_dom_event_init_parent_class)->finalize (obj);
}


GType gxml_dom_event_init_get_type (void) {
	static volatile gsize gxml_dom_event_init_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_dom_event_init_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlDomEventInitClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gxml_dom_event_init_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GXmlDomEventInit), 0, (GInstanceInitFunc) gxml_dom_event_init_instance_init, NULL };
		GType gxml_dom_event_init_type_id;
		gxml_dom_event_init_type_id = g_type_register_static (G_TYPE_OBJECT, "GXmlDomEventInit", &g_define_type_info, 0);
		g_once_init_leave (&gxml_dom_event_init_type_id__volatile, gxml_dom_event_init_type_id);
	}
	return gxml_dom_event_init_type_id__volatile;
}


static void _vala_gxml_dom_event_init_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GXmlDomEventInit * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GXML_TYPE_DOM_EVENT_INIT, GXmlDomEventInit);
	switch (property_id) {
		case GXML_DOM_EVENT_INIT_BUBBLES:
		g_value_set_boolean (value, gxml_dom_event_init_get_bubbles (self));
		break;
		case GXML_DOM_EVENT_INIT_CANCELABLE:
		g_value_set_boolean (value, gxml_dom_event_init_get_cancelable (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gxml_dom_event_init_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GXmlDomEventInit * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GXML_TYPE_DOM_EVENT_INIT, GXmlDomEventInit);
	switch (property_id) {
		case GXML_DOM_EVENT_INIT_BUBBLES:
		gxml_dom_event_init_set_bubbles (self, g_value_get_boolean (value));
		break;
		case GXML_DOM_EVENT_INIT_CANCELABLE:
		gxml_dom_event_init_set_cancelable (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


void gxml_dom_custom_event_init_custom_event (GXmlDomCustomEvent* self, const gchar* type, gboolean bubbles, gboolean cancelable, GValue* detail) {
	g_return_if_fail (self != NULL);
	GXML_DOM_CUSTOM_EVENT_GET_INTERFACE (self)->init_custom_event (self, type, bubbles, cancelable, detail);
}


GValue* gxml_dom_custom_event_get_detail (GXmlDomCustomEvent* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_DOM_CUSTOM_EVENT_GET_INTERFACE (self)->get_detail (self);
}


static void gxml_dom_custom_event_base_init (GXmlDomCustomEventIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType gxml_dom_custom_event_get_type (void) {
	static volatile gsize gxml_dom_custom_event_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_dom_custom_event_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlDomCustomEventIface), (GBaseInitFunc) gxml_dom_custom_event_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gxml_dom_custom_event_type_id;
		gxml_dom_custom_event_type_id = g_type_register_static (G_TYPE_INTERFACE, "GXmlDomCustomEvent", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gxml_dom_custom_event_type_id, G_TYPE_OBJECT);
		g_type_interface_add_prerequisite (gxml_dom_custom_event_type_id, GXML_TYPE_DOM_EVENT);
		g_once_init_leave (&gxml_dom_custom_event_type_id__volatile, gxml_dom_custom_event_type_id);
	}
	return gxml_dom_custom_event_type_id__volatile;
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


GXmlDomCustomEventInit* gxml_dom_custom_event_init_construct (GType object_type) {
	GXmlDomCustomEventInit * self = NULL;
	self = (GXmlDomCustomEventInit*) gxml_dom_event_init_construct (object_type);
	return self;
}


GXmlDomCustomEventInit* gxml_dom_custom_event_init_new (void) {
	return gxml_dom_custom_event_init_construct (GXML_TYPE_DOM_CUSTOM_EVENT_INIT);
}


GValue* gxml_dom_custom_event_init_get_detail (GXmlDomCustomEventInit* self) {
	GValue* result;
	GValue* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_detail;
	result = _tmp0_;
	return result;
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


void gxml_dom_custom_event_init_set_detail (GXmlDomCustomEventInit* self, GValue* value) {
	GValue* _tmp0_ = NULL;
	GValue* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = __g_value_dup0 (_tmp0_);
	__vala_GValue_free0 (self->priv->_detail);
	self->priv->_detail = _tmp1_;
}


static void gxml_dom_custom_event_init_class_init (GXmlDomCustomEventInitClass * klass) {
	gxml_dom_custom_event_init_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GXmlDomCustomEventInitPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gxml_dom_custom_event_init_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gxml_dom_custom_event_init_set_property;
	G_OBJECT_CLASS (klass)->finalize = gxml_dom_custom_event_init_finalize;
}


static void gxml_dom_custom_event_init_instance_init (GXmlDomCustomEventInit * self) {
	self->priv = GXML_DOM_CUSTOM_EVENT_INIT_GET_PRIVATE (self);
	self->priv->_detail = NULL;
}


static void gxml_dom_custom_event_init_finalize (GObject* obj) {
	GXmlDomCustomEventInit * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GXML_TYPE_DOM_CUSTOM_EVENT_INIT, GXmlDomCustomEventInit);
	__vala_GValue_free0 (self->priv->_detail);
	G_OBJECT_CLASS (gxml_dom_custom_event_init_parent_class)->finalize (obj);
}


GType gxml_dom_custom_event_init_get_type (void) {
	static volatile gsize gxml_dom_custom_event_init_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_dom_custom_event_init_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlDomCustomEventInitClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gxml_dom_custom_event_init_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GXmlDomCustomEventInit), 0, (GInstanceInitFunc) gxml_dom_custom_event_init_instance_init, NULL };
		GType gxml_dom_custom_event_init_type_id;
		gxml_dom_custom_event_init_type_id = g_type_register_static (GXML_TYPE_DOM_EVENT_INIT, "GXmlDomCustomEventInit", &g_define_type_info, 0);
		g_once_init_leave (&gxml_dom_custom_event_init_type_id__volatile, gxml_dom_custom_event_init_type_id);
	}
	return gxml_dom_custom_event_init_type_id__volatile;
}


static void _vala_gxml_dom_custom_event_init_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GXmlDomCustomEventInit * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GXML_TYPE_DOM_CUSTOM_EVENT_INIT, GXmlDomCustomEventInit);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gxml_dom_custom_event_init_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GXmlDomCustomEventInit * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GXML_TYPE_DOM_CUSTOM_EVENT_INIT, GXmlDomCustomEventInit);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


gchar* gxml_dom_time_stamp_to_string (GXmlDomTimeStamp* self) {
	gchar* result = NULL;
	GDateTime* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_time;
	_tmp1_ = g_date_time_format (_tmp0_, "%y-%m-%dT%T");
	result = _tmp1_;
	return result;
}


GXmlDomTimeStamp* gxml_dom_time_stamp_construct (GType object_type) {
	GXmlDomTimeStamp * self = NULL;
	self = (GXmlDomTimeStamp*) g_object_new (object_type, NULL);
	return self;
}


GXmlDomTimeStamp* gxml_dom_time_stamp_new (void) {
	return gxml_dom_time_stamp_construct (GXML_TYPE_DOM_TIME_STAMP);
}


GDateTime* gxml_dom_time_stamp_get_time (GXmlDomTimeStamp* self) {
	GDateTime* result;
	GDateTime* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_time;
	result = _tmp0_;
	return result;
}


static gpointer _g_date_time_ref0 (gpointer self) {
	return self ? g_date_time_ref (self) : NULL;
}


void gxml_dom_time_stamp_set_time (GXmlDomTimeStamp* self, GDateTime* value) {
	GDateTime* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_date_time_ref0 (_tmp0_);
	_g_date_time_unref0 (self->priv->_time);
	self->priv->_time = _tmp1_;
	g_object_notify ((GObject *) self, "time");
}


static void gxml_dom_time_stamp_class_init (GXmlDomTimeStampClass * klass) {
	gxml_dom_time_stamp_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GXmlDomTimeStampPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gxml_dom_time_stamp_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gxml_dom_time_stamp_set_property;
	G_OBJECT_CLASS (klass)->finalize = gxml_dom_time_stamp_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_DOM_TIME_STAMP_TIME, g_param_spec_boxed ("time", "time", "time", G_TYPE_DATE_TIME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gxml_dom_time_stamp_instance_init (GXmlDomTimeStamp * self) {
	self->priv = GXML_DOM_TIME_STAMP_GET_PRIVATE (self);
}


static void gxml_dom_time_stamp_finalize (GObject* obj) {
	GXmlDomTimeStamp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GXML_TYPE_DOM_TIME_STAMP, GXmlDomTimeStamp);
	_g_date_time_unref0 (self->priv->_time);
	G_OBJECT_CLASS (gxml_dom_time_stamp_parent_class)->finalize (obj);
}


GType gxml_dom_time_stamp_get_type (void) {
	static volatile gsize gxml_dom_time_stamp_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_dom_time_stamp_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlDomTimeStampClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gxml_dom_time_stamp_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GXmlDomTimeStamp), 0, (GInstanceInitFunc) gxml_dom_time_stamp_instance_init, NULL };
		GType gxml_dom_time_stamp_type_id;
		gxml_dom_time_stamp_type_id = g_type_register_static (G_TYPE_OBJECT, "GXmlDomTimeStamp", &g_define_type_info, 0);
		g_once_init_leave (&gxml_dom_time_stamp_type_id__volatile, gxml_dom_time_stamp_type_id);
	}
	return gxml_dom_time_stamp_type_id__volatile;
}


static void _vala_gxml_dom_time_stamp_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GXmlDomTimeStamp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GXML_TYPE_DOM_TIME_STAMP, GXmlDomTimeStamp);
	switch (property_id) {
		case GXML_DOM_TIME_STAMP_TIME:
		g_value_set_boxed (value, gxml_dom_time_stamp_get_time (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gxml_dom_time_stamp_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GXmlDomTimeStamp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GXML_TYPE_DOM_TIME_STAMP, GXmlDomTimeStamp);
	switch (property_id) {
		case GXML_DOM_TIME_STAMP_TIME:
		gxml_dom_time_stamp_set_time (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



