/* Node.c generated by valac 0.34.7, the Vala compiler
 * generated from Node.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; c-basic-offset: 0; tab-width: 2 -*- */
/* ObjectModel.vala
 *
 * Copyright (C) 2015  Daniel Espinosa <esodan@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      Daniel Espinosa <esodan@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define GXML_TYPE_NODE (gxml_node_get_type ())
#define GXML_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NODE, GXmlNode))
#define GXML_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NODE))
#define GXML_NODE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NODE, GXmlNodeIface))

typedef struct _GXmlNode GXmlNode;
typedef struct _GXmlNodeIface GXmlNodeIface;

#define GXML_TYPE_ELEMENT_LIST (gxml_element_list_get_type ())
#define GXML_ELEMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ELEMENT_LIST, GXmlElementList))
#define GXML_ELEMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_ELEMENT_LIST, GXmlElementListClass))
#define GXML_IS_ELEMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ELEMENT_LIST))
#define GXML_IS_ELEMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_ELEMENT_LIST))
#define GXML_ELEMENT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_ELEMENT_LIST, GXmlElementListClass))

typedef struct _GXmlElementList GXmlElementList;
typedef struct _GXmlElementListClass GXmlElementListClass;

#define GXML_TYPE_NAMESPACE (gxml_namespace_get_type ())
#define GXML_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NAMESPACE, GXmlNamespace))
#define GXML_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NAMESPACE))
#define GXML_NAMESPACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NAMESPACE, GXmlNamespaceIface))

typedef struct _GXmlNamespace GXmlNamespace;
typedef struct _GXmlNamespaceIface GXmlNamespaceIface;

#define GXML_TYPE_NODE_TYPE (gxml_node_type_get_type ())

#define GXML_TYPE_DOCUMENT (gxml_document_get_type ())
#define GXML_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOCUMENT, GXmlDocument))
#define GXML_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOCUMENT))
#define GXML_DOCUMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOCUMENT, GXmlDocumentIface))

typedef struct _GXmlDocument GXmlDocument;
typedef struct _GXmlDocumentIface GXmlDocumentIface;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GXML_TYPE_ELEMENT (gxml_element_get_type ())
#define GXML_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ELEMENT, GXmlElement))
#define GXML_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ELEMENT))
#define GXML_ELEMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_ELEMENT, GXmlElementIface))

typedef struct _GXmlElement GXmlElement;
typedef struct _GXmlElementIface GXmlElementIface;

#define GXML_TYPE_TEXT (gxml_text_get_type ())
#define GXML_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_TEXT, GXmlText))
#define GXML_IS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_TEXT))
#define GXML_TEXT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_TEXT, GXmlTextIface))

typedef struct _GXmlText GXmlText;
typedef struct _GXmlTextIface GXmlTextIface;

#define GXML_TYPE_NODE_LIST (gxml_node_list_get_type ())
#define GXML_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NODE_LIST, GXmlNodeList))
#define GXML_NODE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_NODE_LIST, GXmlNodeListClass))
#define GXML_IS_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NODE_LIST))
#define GXML_IS_NODE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_NODE_LIST))
#define GXML_NODE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_NODE_LIST, GXmlNodeListClass))

typedef struct _GXmlNodeList GXmlNodeList;
typedef struct _GXmlNodeListClass GXmlNodeListClass;
typedef struct _GXmlNodeListPrivate GXmlNodeListPrivate;

struct _GXmlNamespaceIface {
	GTypeInterface parent_iface;
	gchar* (*get_uri) (GXmlNamespace* self);
	gchar* (*get_prefix) (GXmlNamespace* self);
};

typedef enum  {
	GXML_NODE_TYPE_INVALID = 0,
	GXML_NODE_TYPE_ELEMENT = 1,
	GXML_NODE_TYPE_ATTRIBUTE,
	GXML_NODE_TYPE_TEXT,
	GXML_NODE_TYPE_CDATA_SECTION,
	GXML_NODE_TYPE_ENTITY_REFERENCE,
	GXML_NODE_TYPE_ENTITY,
	GXML_NODE_TYPE_PROCESSING_INSTRUCTION,
	GXML_NODE_TYPE_COMMENT,
	GXML_NODE_TYPE_DOCUMENT,
	GXML_NODE_TYPE_DOCUMENT_TYPE,
	GXML_NODE_TYPE_DOCUMENT_FRAGMENT,
	GXML_NODE_TYPE_NOTATION
} GXmlNodeType;

struct _GXmlDocumentIface {
	GTypeInterface parent_iface;
	GXmlNode* (*create_element) (GXmlDocument* self, const gchar* name, GError** error);
	GXmlNode* (*create_text) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_comment) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_cdata) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_pi) (GXmlDocument* self, const gchar* target, const gchar* data);
	gboolean (*save) (GXmlDocument* self, GCancellable* cancellable, GError** error);
	gboolean (*save_as) (GXmlDocument* self, GFile* f, GCancellable* cancellable, GError** error);
	gboolean (*get_indent) (GXmlDocument* self);
	void (*set_indent) (GXmlDocument* self, gboolean value);
	gboolean (*get_ns_top) (GXmlDocument* self);
	void (*set_ns_top) (GXmlDocument* self, gboolean value);
	gboolean (*get_prefix_default_ns) (GXmlDocument* self);
	void (*set_prefix_default_ns) (GXmlDocument* self, gboolean value);
	gboolean (*get_backup) (GXmlDocument* self);
	void (*set_backup) (GXmlDocument* self, gboolean value);
	GXmlNode* (*get_root) (GXmlDocument* self);
	GFile* (*get_file) (GXmlDocument* self);
	void (*set_file) (GXmlDocument* self, GFile* value);
};

struct _GXmlNodeIface {
	GTypeInterface parent_iface;
	GXmlNode* (*get) (GXmlNode* self, const gchar* key);
	GXmlElementList* (*get_elements_by_property_value) (GXmlNode* self, const gchar* property, const gchar* value);
	GXmlElementList* (*get_elements_by_name) (GXmlNode* self, const gchar* name);
	GXmlElementList* (*get_elements_by_name_ns) (GXmlNode* self, const gchar* name, const gchar* ns);
	gchar* (*to_string) (GXmlNode* self);
	gboolean (*set_namespace) (GXmlNode* self, const gchar* uri, const gchar* prefix);
	gchar* (*ns_prefix) (GXmlNode* self);
	gchar* (*ns_uri) (GXmlNode* self);
	GeeList* (*get_namespaces) (GXmlNode* self);
	GeeBidirList* (*get_children_nodes) (GXmlNode* self);
	GeeMap* (*get_attrs) (GXmlNode* self);
	gchar* (*get_name) (GXmlNode* self);
	gchar* (*get_value) (GXmlNode* self);
	void (*set_value) (GXmlNode* self, const gchar* value);
	GXmlNodeType (*get_type_node) (GXmlNode* self);
	GXmlDocument* (*get_document) (GXmlNode* self);
	GXmlNode* (*get_parent) (GXmlNode* self);
};

struct _GXmlElementIface {
	GTypeInterface parent_iface;
	void (*normalize) (GXmlElement* self);
	void (*set_attr) (GXmlElement* self, const gchar* name, const gchar* value);
	GXmlNode* (*get_attr) (GXmlElement* self, const gchar* name);
	void (*remove_attr) (GXmlElement* self, const gchar* name);
	void (*remove_ns_attr) (GXmlElement* self, const gchar* name, const gchar* uri);
	void (*set_ns_attr) (GXmlElement* self, const gchar* ns, const gchar* name, const gchar* value);
	GXmlNode* (*get_ns_attr) (GXmlElement* self, const gchar* name, const gchar* uri);
	gchar* (*get_tag_name) (GXmlElement* self);
	gchar* (*get_content) (GXmlElement* self);
	void (*set_content) (GXmlElement* self, const gchar* value);
};

struct _GXmlTextIface {
	GTypeInterface parent_iface;
	gchar* (*get_str) (GXmlText* self);
	void (*set_str) (GXmlText* self, const gchar* value);
};

struct _GXmlNodeList {
	GeeArrayList parent_instance;
	GXmlNodeListPrivate * priv;
};

struct _GXmlNodeListClass {
	GeeArrayListClass parent_class;
};


static gpointer gxml_node_list_parent_class = NULL;

GType gxml_element_list_get_type (void) G_GNUC_CONST;
GType gxml_namespace_get_type (void) G_GNUC_CONST;
GType gxml_node_type_get_type (void) G_GNUC_CONST;
GType gxml_document_get_type (void) G_GNUC_CONST;
GType gxml_node_get_type (void) G_GNUC_CONST;
GXmlNode* gxml_node_get (GXmlNode* self, const gchar* key);
static GXmlNode* gxml_node_real_get (GXmlNode* self, const gchar* key);
GeeBidirList* gxml_node_get_children_nodes (GXmlNode* self);
gchar* gxml_node_get_name (GXmlNode* self);
GXmlElementList* gxml_node_get_elements_by_property_value (GXmlNode* self, const gchar* property, const gchar* value);
static GXmlElementList* gxml_node_real_get_elements_by_property_value (GXmlNode* self, const gchar* property, const gchar* value);
GXmlElementList* gxml_element_list_new (void);
GXmlElementList* gxml_element_list_construct (GType object_type);
GType gxml_element_get_type (void) G_GNUC_CONST;
GeeMap* gxml_node_get_attrs (GXmlNode* self);
gchar* gxml_node_get_value (GXmlNode* self);
GXmlElementList* gxml_node_get_elements_by_name (GXmlNode* self, const gchar* name);
static GXmlElementList* gxml_node_real_get_elements_by_name (GXmlNode* self, const gchar* name);
GXmlElementList* gxml_node_get_elements_by_name_ns (GXmlNode* self, const gchar* name, const gchar* ns);
static GXmlElementList* gxml_node_real_get_elements_by_name_ns (GXmlNode* self, const gchar* name, const gchar* ns);
GeeList* gxml_node_get_namespaces (GXmlNode* self);
gchar* gxml_namespace_get_uri (GXmlNamespace* self);
gchar* gxml_node_to_string (GXmlNode* self);
gboolean gxml_node_set_namespace (GXmlNode* self, const gchar* uri, const gchar* prefix);
gchar* gxml_node_ns_prefix (GXmlNode* self);
static gchar* gxml_node_real_ns_prefix (GXmlNode* self);
gchar* gxml_namespace_get_prefix (GXmlNamespace* self);
gchar* gxml_node_ns_uri (GXmlNode* self);
static gchar* gxml_node_real_ns_uri (GXmlNode* self);
gboolean gxml_node_copy (GXmlDocument* doc, GXmlNode* node, GXmlNode* source, gboolean deep);
void gxml_element_set_attr (GXmlElement* self, const gchar* name, const gchar* value);
GXmlNode* gxml_document_create_element (GXmlDocument* self, const gchar* name, GError** error);
GType gxml_text_get_type (void) G_GNUC_CONST;
GXmlNode* gxml_document_create_text (GXmlDocument* self, const gchar* text);
void gxml_node_set_value (GXmlNode* self, const gchar* value);
GXmlNodeType gxml_node_get_type_node (GXmlNode* self);
GXmlDocument* gxml_node_get_document (GXmlNode* self);
GXmlNode* gxml_node_get_parent (GXmlNode* self);
GType gxml_node_list_get_type (void) G_GNUC_CONST;
enum  {
	GXML_NODE_LIST_DUMMY_PROPERTY
};
GXmlNode* gxml_node_list_get (GXmlNodeList* self, gint index);
GXmlNode** gxml_node_list_to_array (GXmlNodeList* self, int* result_length1);
GXmlNodeList* gxml_node_list_new (void);
GXmlNodeList* gxml_node_list_construct (GType object_type);


/**
   * Get first child with given name, or null. 
   */
static GXmlNode* gxml_node_real_get (GXmlNode* self, const gchar* key) {
	GXmlNode* result = NULL;
	g_return_val_if_fail (key != NULL, NULL);
	{
		GeeBidirList* _child_list = NULL;
		GeeBidirList* _tmp0_ = NULL;
		GeeBidirList* _tmp1_ = NULL;
		gint _child_size = 0;
		GeeBidirList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _child_index = 0;
		_tmp0_ = gxml_node_get_children_nodes (self);
		_tmp1_ = _tmp0_;
		_child_list = _tmp1_;
		_tmp2_ = _child_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_child_size = _tmp4_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			GXmlNode* child = NULL;
			GeeBidirList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			GXmlNode* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			gboolean _tmp16_ = FALSE;
			_tmp5_ = _child_index;
			_child_index = _tmp5_ + 1;
			_tmp6_ = _child_index;
			_tmp7_ = _child_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _child_list;
			_tmp9_ = _child_index;
			_tmp10_ = gee_list_get ((GeeList*) _tmp8_, _tmp9_);
			child = (GXmlNode*) _tmp10_;
			_tmp11_ = child;
			_tmp12_ = gxml_node_get_name (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = _tmp13_;
			_tmp15_ = key;
			_tmp16_ = g_strcmp0 (_tmp14_, _tmp15_) == 0;
			_g_free0 (_tmp14_);
			if (_tmp16_) {
				result = child;
				_g_object_unref0 (_child_list);
				return result;
			}
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_list);
	}
	result = NULL;
	return result;
}


GXmlNode* gxml_node_get (GXmlNode* self, const gchar* key) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->get (self, key);
}


/**
   * Search all child {@link GXml.Element} with a given property's name and with
   * value contained in text.
   */
static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static GXmlElementList* gxml_node_real_get_elements_by_property_value (GXmlNode* self, const gchar* property, const gchar* value) {
	GXmlElementList* result = NULL;
	GXmlElementList* list = NULL;
	GXmlElementList* _tmp0_ = NULL;
	g_return_val_if_fail (property != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	_tmp0_ = gxml_element_list_new ();
	list = _tmp0_;
	{
		GeeBidirList* _child_list = NULL;
		GeeBidirList* _tmp1_ = NULL;
		GeeBidirList* _tmp2_ = NULL;
		gint _child_size = 0;
		GeeBidirList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _child_index = 0;
		_tmp1_ = gxml_node_get_children_nodes (self);
		_tmp2_ = _tmp1_;
		_child_list = _tmp2_;
		_tmp3_ = _child_list;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_child_size = _tmp5_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			GXmlNode* child = NULL;
			GeeBidirList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			GXmlNode* _tmp12_ = NULL;
			_tmp6_ = _child_index;
			_child_index = _tmp6_ + 1;
			_tmp7_ = _child_index;
			_tmp8_ = _child_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _child_list;
			_tmp10_ = _child_index;
			_tmp11_ = gee_list_get ((GeeList*) _tmp9_, _tmp10_);
			child = (GXmlNode*) _tmp11_;
			_tmp12_ = child;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, GXML_TYPE_ELEMENT)) {
				GXmlElementList* _tmp13_ = NULL;
				GXmlNode* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				GXmlElementList* _tmp17_ = NULL;
				GeeCollection* _tmp18_ = NULL;
				GeeCollection* _tmp19_ = NULL;
				GXmlNode* _tmp20_ = NULL;
				GeeMap* _tmp21_ = NULL;
				GeeMap* _tmp22_ = NULL;
				GeeMap* _tmp23_ = NULL;
				gboolean _tmp24_ = FALSE;
				GXmlNode* cls = NULL;
				GXmlNode* _tmp25_ = NULL;
				GeeMap* _tmp26_ = NULL;
				GeeMap* _tmp27_ = NULL;
				GeeMap* _tmp28_ = NULL;
				const gchar* _tmp29_ = NULL;
				gpointer _tmp30_ = NULL;
				GXmlNode* _tmp31_ = NULL;
				GXmlNode* _tmp32_ = NULL;
				GXmlNode* _tmp33_ = NULL;
				gchar* _tmp34_ = NULL;
				gchar* _tmp35_ = NULL;
				gchar* _tmp36_ = NULL;
				const gchar* _tmp37_ = NULL;
				gboolean _tmp38_ = FALSE;
				gboolean _tmp39_ = FALSE;
				_tmp13_ = list;
				_tmp14_ = child;
				_tmp15_ = property;
				_tmp16_ = value;
				_tmp17_ = gxml_node_get_elements_by_property_value (_tmp14_, _tmp15_, _tmp16_);
				_tmp18_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, GEE_TYPE_COLLECTION) ? ((GeeCollection*) _tmp17_) : NULL;
				if (_tmp18_ == NULL) {
					_g_object_unref0 (_tmp17_);
				}
				_tmp19_ = _tmp18_;
				gee_collection_add_all (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, GEE_TYPE_COLLECTION) ? ((GeeCollection*) _tmp13_) : NULL, _tmp19_);
				_g_object_unref0 (_tmp19_);
				_tmp20_ = child;
				_tmp21_ = gxml_node_get_attrs (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = _tmp22_;
				_tmp24_ = _tmp23_ == NULL;
				_g_object_unref0 (_tmp23_);
				if (_tmp24_) {
					_g_object_unref0 (child);
					continue;
				}
				_tmp25_ = child;
				_tmp26_ = gxml_node_get_attrs (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = _tmp27_;
				_tmp29_ = property;
				_tmp30_ = gee_map_get (_tmp28_, _tmp29_);
				_tmp31_ = (GXmlNode*) _tmp30_;
				_g_object_unref0 (_tmp28_);
				cls = _tmp31_;
				_tmp32_ = cls;
				if (_tmp32_ == NULL) {
					_g_object_unref0 (cls);
					_g_object_unref0 (child);
					continue;
				}
				_tmp33_ = cls;
				_tmp34_ = gxml_node_get_value (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = _tmp35_;
				_tmp37_ = value;
				_tmp38_ = string_contains (_tmp36_, _tmp37_);
				_tmp39_ = _tmp38_;
				_g_free0 (_tmp36_);
				if (_tmp39_) {
					GXmlElementList* _tmp40_ = NULL;
					GXmlNode* _tmp41_ = NULL;
					_tmp40_ = list;
					_tmp41_ = child;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp40_, G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, GXML_TYPE_ELEMENT, GXmlElement));
				}
				_g_object_unref0 (cls);
			}
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_list);
	}
	result = list;
	return result;
}


GXmlElementList* gxml_node_get_elements_by_property_value (GXmlNode* self, const gchar* property, const gchar* value) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->get_elements_by_property_value (self, property, value);
}


/**
   * Search all child {@link GXml.Element} with a given name.
   */
static GXmlElementList* gxml_node_real_get_elements_by_name (GXmlNode* self, const gchar* name) {
	GXmlElementList* result = NULL;
	GXmlElementList* list = NULL;
	GXmlElementList* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = gxml_element_list_new ();
	list = _tmp0_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (self, GXML_TYPE_ELEMENT)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (self, GXML_TYPE_DOCUMENT);
	}
	if (!_tmp1_) {
		result = list;
		return result;
	}
	{
		GeeBidirList* _child_list = NULL;
		GeeBidirList* _tmp2_ = NULL;
		GeeBidirList* _tmp3_ = NULL;
		gint _child_size = 0;
		GeeBidirList* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _child_index = 0;
		_tmp2_ = gxml_node_get_children_nodes (self);
		_tmp3_ = _tmp2_;
		_child_list = _tmp3_;
		_tmp4_ = _child_list;
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_child_size = _tmp6_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			GXmlNode* child = NULL;
			GeeBidirList* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			gpointer _tmp12_ = NULL;
			GXmlNode* _tmp13_ = NULL;
			_tmp7_ = _child_index;
			_child_index = _tmp7_ + 1;
			_tmp8_ = _child_index;
			_tmp9_ = _child_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _child_list;
			_tmp11_ = _child_index;
			_tmp12_ = gee_list_get ((GeeList*) _tmp10_, _tmp11_);
			child = (GXmlNode*) _tmp12_;
			_tmp13_ = child;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, GXML_TYPE_ELEMENT)) {
				GXmlElementList* _tmp14_ = NULL;
				GXmlNode* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				GXmlElementList* _tmp17_ = NULL;
				GeeCollection* _tmp18_ = NULL;
				GeeCollection* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				GXmlNode* _tmp21_ = NULL;
				gchar* _tmp22_ = NULL;
				gchar* _tmp23_ = NULL;
				gchar* _tmp24_ = NULL;
				gboolean _tmp25_ = FALSE;
				_tmp14_ = list;
				_tmp15_ = child;
				_tmp16_ = name;
				_tmp17_ = gxml_node_get_elements_by_name (_tmp15_, _tmp16_);
				_tmp18_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, GEE_TYPE_COLLECTION) ? ((GeeCollection*) _tmp17_) : NULL;
				if (_tmp18_ == NULL) {
					_g_object_unref0 (_tmp17_);
				}
				_tmp19_ = _tmp18_;
				gee_collection_add_all (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, GEE_TYPE_COLLECTION) ? ((GeeCollection*) _tmp14_) : NULL, _tmp19_);
				_g_object_unref0 (_tmp19_);
				_tmp20_ = name;
				_tmp21_ = child;
				_tmp22_ = gxml_node_get_name (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = _tmp23_;
				_tmp25_ = g_strcmp0 (_tmp20_, _tmp24_) == 0;
				_g_free0 (_tmp24_);
				if (_tmp25_) {
					GXmlElementList* _tmp26_ = NULL;
					GXmlNode* _tmp27_ = NULL;
					_tmp26_ = list;
					_tmp27_ = child;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp26_, G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GXML_TYPE_ELEMENT, GXmlElement));
				}
			}
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_list);
	}
	result = list;
	return result;
}


GXmlElementList* gxml_node_get_elements_by_name (GXmlNode* self, const gchar* name) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->get_elements_by_name (self, name);
}


/**
   * Search all child {@link GXml.Element} with a given name and namespace URI.
   */
static GXmlElementList* gxml_node_real_get_elements_by_name_ns (GXmlNode* self, const gchar* name, const gchar* ns) {
	GXmlElementList* result = NULL;
	GXmlElementList* list = NULL;
	GXmlElementList* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = gxml_element_list_new ();
	list = _tmp0_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (self, GXML_TYPE_ELEMENT)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (self, GXML_TYPE_DOCUMENT);
	}
	if (!_tmp1_) {
		result = list;
		return result;
	}
	{
		GeeBidirList* _child_list = NULL;
		GeeBidirList* _tmp2_ = NULL;
		GeeBidirList* _tmp3_ = NULL;
		gint _child_size = 0;
		GeeBidirList* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _child_index = 0;
		_tmp2_ = gxml_node_get_children_nodes (self);
		_tmp3_ = _tmp2_;
		_child_list = _tmp3_;
		_tmp4_ = _child_list;
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_child_size = _tmp6_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			GXmlNode* child = NULL;
			GeeBidirList* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			gpointer _tmp12_ = NULL;
			GXmlNode* _tmp13_ = NULL;
			_tmp7_ = _child_index;
			_child_index = _tmp7_ + 1;
			_tmp8_ = _child_index;
			_tmp9_ = _child_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _child_list;
			_tmp11_ = _child_index;
			_tmp12_ = gee_list_get ((GeeList*) _tmp10_, _tmp11_);
			child = (GXmlNode*) _tmp12_;
			_tmp13_ = child;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, GXML_TYPE_ELEMENT)) {
				GXmlElementList* _tmp14_ = NULL;
				GXmlNode* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				GXmlElementList* _tmp17_ = NULL;
				GeeCollection* _tmp18_ = NULL;
				GeeCollection* _tmp19_ = NULL;
				gboolean _tmp20_ = FALSE;
				gboolean _tmp21_ = FALSE;
				GXmlNode* _tmp22_ = NULL;
				GeeList* _tmp23_ = NULL;
				GeeList* _tmp24_ = NULL;
				GeeList* _tmp25_ = NULL;
				gboolean _tmp26_ = FALSE;
				gboolean _tmp34_ = FALSE;
				const gchar* _tmp35_ = NULL;
				GXmlNode* _tmp36_ = NULL;
				gchar* _tmp37_ = NULL;
				gchar* _tmp38_ = NULL;
				gchar* _tmp39_ = NULL;
				gboolean _tmp40_ = FALSE;
				_tmp14_ = list;
				_tmp15_ = child;
				_tmp16_ = name;
				_tmp17_ = gxml_node_get_elements_by_name (_tmp15_, _tmp16_);
				_tmp18_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, GEE_TYPE_COLLECTION) ? ((GeeCollection*) _tmp17_) : NULL;
				if (_tmp18_ == NULL) {
					_g_object_unref0 (_tmp17_);
				}
				_tmp19_ = _tmp18_;
				gee_collection_add_all (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, GEE_TYPE_COLLECTION) ? ((GeeCollection*) _tmp14_) : NULL, _tmp19_);
				_g_object_unref0 (_tmp19_);
				_tmp22_ = child;
				_tmp23_ = gxml_node_get_namespaces (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = _tmp24_;
				_tmp26_ = _tmp25_ == NULL;
				_g_object_unref0 (_tmp25_);
				if (_tmp26_) {
					GXmlNode* _tmp27_ = NULL;
					GeeList* _tmp28_ = NULL;
					GeeList* _tmp29_ = NULL;
					GeeList* _tmp30_ = NULL;
					gint _tmp31_ = 0;
					gint _tmp32_ = 0;
					_tmp27_ = child;
					_tmp28_ = gxml_node_get_namespaces (_tmp27_);
					_tmp29_ = _tmp28_;
					_tmp30_ = _tmp29_;
					_tmp31_ = gee_collection_get_size ((GeeCollection*) _tmp30_);
					_tmp32_ = _tmp31_;
					_tmp21_ = _tmp32_ != 0;
					_g_object_unref0 (_tmp30_);
				} else {
					_tmp21_ = FALSE;
				}
				if (_tmp21_) {
					const gchar* _tmp33_ = NULL;
					_tmp33_ = ns;
					_tmp20_ = _tmp33_ == NULL;
				} else {
					_tmp20_ = FALSE;
				}
				if (!_tmp20_) {
					_g_object_unref0 (child);
					continue;
				}
				_tmp35_ = name;
				_tmp36_ = child;
				_tmp37_ = gxml_node_get_name (_tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = _tmp38_;
				_tmp40_ = g_strcmp0 (_tmp35_, _tmp39_) == 0;
				_g_free0 (_tmp39_);
				if (_tmp40_) {
					GXmlNode* _tmp41_ = NULL;
					GeeList* _tmp42_ = NULL;
					GeeList* _tmp43_ = NULL;
					GeeList* _tmp44_ = NULL;
					gpointer _tmp45_ = NULL;
					GXmlNamespace* _tmp46_ = NULL;
					gchar* _tmp47_ = NULL;
					gchar* _tmp48_ = NULL;
					gchar* _tmp49_ = NULL;
					const gchar* _tmp50_ = NULL;
					_tmp41_ = child;
					_tmp42_ = gxml_node_get_namespaces (_tmp41_);
					_tmp43_ = _tmp42_;
					_tmp44_ = _tmp43_;
					_tmp45_ = gee_list_get (_tmp44_, 0);
					_tmp46_ = (GXmlNamespace*) _tmp45_;
					_tmp47_ = gxml_namespace_get_uri (_tmp46_);
					_tmp48_ = _tmp47_;
					_tmp49_ = _tmp48_;
					_tmp50_ = ns;
					_tmp34_ = g_strcmp0 (_tmp49_, _tmp50_) == 0;
					_g_free0 (_tmp49_);
					_g_object_unref0 (_tmp46_);
					_g_object_unref0 (_tmp44_);
				} else {
					_tmp34_ = FALSE;
				}
				if (_tmp34_) {
					GXmlElementList* _tmp51_ = NULL;
					GXmlNode* _tmp52_ = NULL;
					_tmp51_ = list;
					_tmp52_ = child;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp51_, G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, GXML_TYPE_ELEMENT, GXmlElement));
				}
			}
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_list);
	}
	result = list;
	return result;
}


GXmlElementList* gxml_node_get_elements_by_name_ns (GXmlNode* self, const gchar* name, const gchar* ns) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->get_elements_by_name_ns (self, name, ns);
}


/**
   * Node's string representation.
   */
gchar* gxml_node_to_string (GXmlNode* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->to_string (self);
}


/**
   * Set a namespace to this node.
   *
   * Search for existing document's namespaces and applies it if found or creates
   * a new one, appending to document's namespaces collection.
   */
gboolean gxml_node_set_namespace (GXmlNode* self, const gchar* uri, const gchar* prefix) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_NODE_GET_INTERFACE (self)->set_namespace (self, uri, prefix);
}


/**
   * Node's defaults namespace's prefix.
   *
   * This allways returns first {@link GXml.Namespace}'s prefix in {@link GXml.Node}'s
    * namespaces collection.
   */
static gchar* gxml_node_real_ns_prefix (GXmlNode* self) {
	gchar* result = NULL;
	GeeList* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
	GeeList* _tmp2_ = NULL;
	gpointer _tmp3_ = NULL;
	GXmlNamespace* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	_tmp0_ = gxml_node_get_namespaces (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_list_first (_tmp2_);
	_tmp4_ = (GXmlNamespace*) _tmp3_;
	_tmp5_ = gxml_namespace_get_prefix (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	result = _tmp7_;
	return result;
}


gchar* gxml_node_ns_prefix (GXmlNode* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->ns_prefix (self);
}


/**
   * Node's defaults namespace's URI.
   *
   * This allways returns first {@link GXml.Namespace}'s URI in {@link GXml.Node}'s
   * namespaces collection.
   */
static gchar* gxml_node_real_ns_uri (GXmlNode* self) {
	gchar* result = NULL;
	GeeList* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
	GeeList* _tmp2_ = NULL;
	gpointer _tmp3_ = NULL;
	GXmlNamespace* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	_tmp0_ = gxml_node_get_namespaces (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_list_first (_tmp2_);
	_tmp4_ = (GXmlNamespace*) _tmp3_;
	_tmp5_ = gxml_namespace_get_uri (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	result = _tmp7_;
	return result;
}


gchar* gxml_node_ns_uri (GXmlNode* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->ns_uri (self);
}


/**
   * Copy a {@link GXml.Node} relaying on {@link GXml.Document} to other {@link GXml.Node}.
   *
   * {@link node} could belongs from different {@link GXml.Document}, while source is a node
   * belonging to given document.
   *
   * Only {@link GXml.Element} objects are supported. For attributes, use
   * {@link GXml.Element.set_attr} method, passing source's name and value as arguments.
   *
   * @param doc a {@link GXml.Document} owning destiny node
   * @param node a {@link GXml.Element} to copy nodes to
   * @param source a {@link GXml.Element} to copy nodes from, it could be holded by different {@link GXml.Document}
   */
gboolean gxml_node_copy (GXmlDocument* doc, GXmlNode* node, GXmlNode* source, gboolean deep) {
	gboolean result = FALSE;
	GXmlNode* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GXmlNode* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (doc != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = node;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GXML_TYPE_DOCUMENT)) {
		result = FALSE;
		return result;
	}
	_tmp2_ = source;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GXML_TYPE_ELEMENT)) {
		GXmlNode* _tmp3_ = NULL;
		_tmp3_ = node;
		_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GXML_TYPE_ELEMENT);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp26_ = FALSE;
		{
			GeeIterator* _p_it = NULL;
			GXmlNode* _tmp4_ = NULL;
			GeeMap* _tmp5_ = NULL;
			GeeMap* _tmp6_ = NULL;
			GeeMap* _tmp7_ = NULL;
			GeeCollection* _tmp8_ = NULL;
			GeeCollection* _tmp9_ = NULL;
			GeeCollection* _tmp10_ = NULL;
			GeeIterator* _tmp11_ = NULL;
			GeeIterator* _tmp12_ = NULL;
			_tmp4_ = source;
			_tmp5_ = gxml_node_get_attrs (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = _tmp6_;
			_tmp8_ = gee_map_get_values (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = _tmp9_;
			_tmp11_ = gee_iterable_iterator ((GeeIterable*) _tmp10_);
			_tmp12_ = _tmp11_;
			_g_object_unref0 (_tmp10_);
			_g_object_unref0 (_tmp7_);
			_p_it = _tmp12_;
			while (TRUE) {
				GeeIterator* _tmp13_ = NULL;
				gboolean _tmp14_ = FALSE;
				GXmlNode* p = NULL;
				GeeIterator* _tmp15_ = NULL;
				gpointer _tmp16_ = NULL;
				GXmlNode* _tmp17_ = NULL;
				GXmlNode* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				GXmlNode* _tmp22_ = NULL;
				gchar* _tmp23_ = NULL;
				gchar* _tmp24_ = NULL;
				gchar* _tmp25_ = NULL;
				_tmp13_ = _p_it;
				_tmp14_ = gee_iterator_next (_tmp13_);
				if (!_tmp14_) {
					break;
				}
				_tmp15_ = _p_it;
				_tmp16_ = gee_iterator_get (_tmp15_);
				p = (GXmlNode*) _tmp16_;
				_tmp17_ = node;
				_tmp18_ = p;
				_tmp19_ = gxml_node_get_name (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = _tmp20_;
				_tmp22_ = p;
				_tmp23_ = gxml_node_get_value (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = _tmp24_;
				gxml_element_set_attr (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GXML_TYPE_ELEMENT, GXmlElement), _tmp21_, _tmp25_);
				_g_free0 (_tmp25_);
				_g_free0 (_tmp21_);
				_g_object_unref0 (p);
			}
			_g_object_unref0 (_p_it);
		}
		_tmp26_ = deep;
		if (!_tmp26_) {
			result = TRUE;
			return result;
		}
		{
			GeeBidirList* _c_list = NULL;
			GXmlNode* _tmp27_ = NULL;
			GeeBidirList* _tmp28_ = NULL;
			GeeBidirList* _tmp29_ = NULL;
			gint _c_size = 0;
			GeeBidirList* _tmp30_ = NULL;
			gint _tmp31_ = 0;
			gint _tmp32_ = 0;
			gint _c_index = 0;
			_tmp27_ = source;
			_tmp28_ = gxml_node_get_children_nodes (_tmp27_);
			_tmp29_ = _tmp28_;
			_c_list = _tmp29_;
			_tmp30_ = _c_list;
			_tmp31_ = gee_collection_get_size ((GeeCollection*) _tmp30_);
			_tmp32_ = _tmp31_;
			_c_size = _tmp32_;
			_c_index = -1;
			while (TRUE) {
				gint _tmp33_ = 0;
				gint _tmp34_ = 0;
				gint _tmp35_ = 0;
				GXmlNode* c = NULL;
				GeeBidirList* _tmp36_ = NULL;
				gint _tmp37_ = 0;
				gpointer _tmp38_ = NULL;
				GXmlNode* _tmp39_ = NULL;
				GXmlNode* _tmp62_ = NULL;
				_tmp33_ = _c_index;
				_c_index = _tmp33_ + 1;
				_tmp34_ = _c_index;
				_tmp35_ = _c_size;
				if (!(_tmp34_ < _tmp35_)) {
					break;
				}
				_tmp36_ = _c_list;
				_tmp37_ = _c_index;
				_tmp38_ = gee_list_get ((GeeList*) _tmp36_, _tmp37_);
				c = (GXmlNode*) _tmp38_;
				_tmp39_ = c;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, GXML_TYPE_ELEMENT)) {
					GXmlNode* _tmp40_ = NULL;
					gchar* _tmp41_ = NULL;
					gchar* _tmp42_ = NULL;
					gchar* _tmp43_ = NULL;
					gboolean _tmp44_ = FALSE;
					_tmp40_ = c;
					_tmp41_ = gxml_node_get_name (_tmp40_);
					_tmp42_ = _tmp41_;
					_tmp43_ = _tmp42_;
					_tmp44_ = _tmp43_ == NULL;
					_g_free0 (_tmp43_);
					if (_tmp44_) {
						_g_object_unref0 (c);
						continue;
					}
					{
						GXmlNode* e = NULL;
						GXmlDocument* _tmp45_ = NULL;
						GXmlNode* _tmp46_ = NULL;
						gchar* _tmp47_ = NULL;
						gchar* _tmp48_ = NULL;
						gchar* _tmp49_ = NULL;
						GXmlNode* _tmp50_ = NULL;
						GXmlNode* _tmp51_ = NULL;
						GXmlNode* _tmp52_ = NULL;
						GeeBidirList* _tmp53_ = NULL;
						GeeBidirList* _tmp54_ = NULL;
						GeeBidirList* _tmp55_ = NULL;
						GXmlNode* _tmp56_ = NULL;
						GXmlDocument* _tmp57_ = NULL;
						GXmlNode* _tmp58_ = NULL;
						GXmlNode* _tmp59_ = NULL;
						gboolean _tmp60_ = FALSE;
						_tmp45_ = doc;
						_tmp46_ = c;
						_tmp47_ = gxml_node_get_name (_tmp46_);
						_tmp48_ = _tmp47_;
						_tmp49_ = _tmp48_;
						_tmp50_ = gxml_document_create_element (_tmp45_, _tmp49_, &_inner_error_);
						_tmp51_ = _tmp50_;
						_g_free0 (_tmp49_);
						e = _tmp51_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							goto __catch0_g_error;
						}
						_tmp52_ = node;
						_tmp53_ = gxml_node_get_children_nodes (_tmp52_);
						_tmp54_ = _tmp53_;
						_tmp55_ = _tmp54_;
						_tmp56_ = e;
						gee_collection_add ((GeeCollection*) _tmp55_, _tmp56_);
						_g_object_unref0 (_tmp55_);
						_tmp57_ = doc;
						_tmp58_ = e;
						_tmp59_ = c;
						_tmp60_ = deep;
						gxml_node_copy (_tmp57_, _tmp58_, _tmp59_, _tmp60_);
						_g_object_unref0 (e);
					}
					goto __finally0;
					__catch0_g_error:
					{
						g_clear_error (&_inner_error_);
						_inner_error_ = NULL;
					}
					__finally0:
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						gboolean _tmp61_ = FALSE;
						_g_object_unref0 (c);
						_g_object_unref0 (_c_list);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return _tmp61_;
					}
				}
				_tmp62_ = c;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp62_, GXML_TYPE_TEXT)) {
					GXmlNode* _tmp63_ = NULL;
					gchar* _tmp64_ = NULL;
					gchar* _tmp65_ = NULL;
					gchar* _tmp66_ = NULL;
					gboolean _tmp67_ = FALSE;
					GXmlNode* t = NULL;
					GXmlDocument* _tmp69_ = NULL;
					GXmlNode* _tmp70_ = NULL;
					gchar* _tmp71_ = NULL;
					gchar* _tmp72_ = NULL;
					gchar* _tmp73_ = NULL;
					GXmlNode* _tmp74_ = NULL;
					GXmlNode* _tmp75_ = NULL;
					GXmlNode* _tmp76_ = NULL;
					GeeBidirList* _tmp77_ = NULL;
					GeeBidirList* _tmp78_ = NULL;
					GeeBidirList* _tmp79_ = NULL;
					GXmlNode* _tmp80_ = NULL;
					_tmp63_ = c;
					_tmp64_ = gxml_node_get_value (_tmp63_);
					_tmp65_ = _tmp64_;
					_tmp66_ = _tmp65_;
					_tmp67_ = _tmp66_ == NULL;
					_g_free0 (_tmp66_);
					if (_tmp67_) {
						const gchar* _tmp68_ = NULL;
						_tmp68_ = _ ("Text node with NULL string");
						g_warning ("Node.vala:202: %s", _tmp68_);
						_g_object_unref0 (c);
						continue;
					}
					_tmp69_ = doc;
					_tmp70_ = c;
					_tmp71_ = gxml_node_get_value (_tmp70_);
					_tmp72_ = _tmp71_;
					_tmp73_ = _tmp72_;
					_tmp74_ = gxml_document_create_text (_tmp69_, _tmp73_);
					_tmp75_ = _tmp74_;
					_g_free0 (_tmp73_);
					t = _tmp75_;
					_tmp76_ = node;
					_tmp77_ = gxml_node_get_children_nodes (_tmp76_);
					_tmp78_ = _tmp77_;
					_tmp79_ = _tmp78_;
					_tmp80_ = t;
					gee_collection_add ((GeeCollection*) _tmp79_, _tmp80_);
					_g_object_unref0 (_tmp79_);
					_g_object_unref0 (t);
				}
				_g_object_unref0 (c);
			}
			_g_object_unref0 (_c_list);
		}
	}
	result = FALSE;
	return result;
}


GeeList* gxml_node_get_namespaces (GXmlNode* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->get_namespaces (self);
}


GeeBidirList* gxml_node_get_children_nodes (GXmlNode* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->get_children_nodes (self);
}


GeeMap* gxml_node_get_attrs (GXmlNode* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->get_attrs (self);
}


gchar* gxml_node_get_name (GXmlNode* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->get_name (self);
}


gchar* gxml_node_get_value (GXmlNode* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->get_value (self);
}


void gxml_node_set_value (GXmlNode* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	GXML_NODE_GET_INTERFACE (self)->set_value (self, value);
}


GXmlNodeType gxml_node_get_type_node (GXmlNode* self) {
	g_return_val_if_fail (self != NULL, 0);
	return GXML_NODE_GET_INTERFACE (self)->get_type_node (self);
}


GXmlDocument* gxml_node_get_document (GXmlNode* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->get_document (self);
}


GXmlNode* gxml_node_get_parent (GXmlNode* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->get_parent (self);
}


static void gxml_node_base_init (GXmlNodeIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		   * Collection of Namespaces applied to this {@link GXml.Node}.
		   */
		g_object_interface_install_property (iface, g_param_spec_object ("namespaces", "namespaces", "namespaces", GEE_TYPE_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		/**
		   * Collection of {@link GXml.Node} as children.
		   *
		   * Depends on {@link GXml.Node} type, this children could be different, like,
		   * elements, element's contents or properties.
		   */
		g_object_interface_install_property (iface, g_param_spec_object ("children-nodes", "children-nodes", "children-nodes", GEE_TYPE_BIDIR_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		/**
		   * Attributes in this {@link GXml.Node}.
		   */
		g_object_interface_install_property (iface, g_param_spec_object ("attrs", "attrs", "attrs", GEE_TYPE_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		/**
		   * Node's name. The meaning differs, depending on node's type.
		   */
		g_object_interface_install_property (iface, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		/**
		   * Node's value. The meaning differs, depending on node's type.
		   */
		g_object_interface_install_property (iface, g_param_spec_string ("value", "value", "value", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		/**
		   * Node's type as a enumeration.
		   */
		g_object_interface_install_property (iface, g_param_spec_enum ("type-node", "type-node", "type-node", GXML_TYPE_NODE_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		/**
		   * Node's XML document holding this node.
		   */
		g_object_interface_install_property (iface, g_param_spec_object ("document", "document", "document", GXML_TYPE_DOCUMENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		/**
		   * Node's XML document holding this node.
		   */
		g_object_interface_install_property (iface, g_param_spec_object ("parent", "parent", "parent", GXML_TYPE_NODE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		iface->get = gxml_node_real_get;
		iface->get_elements_by_property_value = gxml_node_real_get_elements_by_property_value;
		iface->get_elements_by_name = gxml_node_real_get_elements_by_name;
		iface->get_elements_by_name_ns = gxml_node_real_get_elements_by_name_ns;
		iface->ns_prefix = gxml_node_real_ns_prefix;
		iface->ns_uri = gxml_node_real_ns_uri;
	}
}


/**
 * Base interface providing basic functionalities to all GXml interfaces.
 */
GType gxml_node_get_type (void) {
	static volatile gsize gxml_node_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlNodeIface), (GBaseInitFunc) gxml_node_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gxml_node_type_id;
		gxml_node_type_id = g_type_register_static (G_TYPE_INTERFACE, "GXmlNode", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gxml_node_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&gxml_node_type_id__volatile, gxml_node_type_id);
	}
	return gxml_node_type_id__volatile;
}


GXmlNode* gxml_node_list_get (GXmlNodeList* self, gint index) {
	GXmlNode* result = NULL;
	gint _tmp0_ = 0;
	gpointer _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = index;
	_tmp1_ = GEE_ABSTRACT_LIST_CLASS (gxml_node_list_parent_class)->get ((GeeAbstractList*) G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_ARRAY_LIST, GeeArrayList), _tmp0_);
	result = (GXmlNode*) _tmp1_;
	return result;
}


GXmlNode** gxml_node_list_to_array (GXmlNodeList* self, int* result_length1) {
	GXmlNode** result = NULL;
	gint _tmp0_ = 0;
	gpointer* _tmp1_ = NULL;
	GXmlNode** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = gee_collection_to_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp0_);
	_tmp2_ = (GXmlNode**) _tmp1_;
	_tmp2__length1 = (_tmp0_ * sizeof (GXmlNode*)) / sizeof (GXmlNode*);
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}


GXmlNodeList* gxml_node_list_construct (GType object_type) {
	GXmlNodeList * self = NULL;
	self = (GXmlNodeList*) gee_array_list_construct (object_type, GXML_TYPE_NODE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	return self;
}


GXmlNodeList* gxml_node_list_new (void) {
	return gxml_node_list_construct (GXML_TYPE_NODE_LIST);
}


static void gxml_node_list_class_init (GXmlNodeListClass * klass) {
	gxml_node_list_parent_class = g_type_class_peek_parent (klass);
}


static void gxml_node_list_instance_init (GXmlNodeList * self) {
}


/**
 * Convenient class for a list of {@link GXml.Node} objects based on
 * {@link Gee.ArrayList}, with good support for bindings.
 */
GType gxml_node_list_get_type (void) {
	static volatile gsize gxml_node_list_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_node_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlNodeListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gxml_node_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GXmlNodeList), 0, (GInstanceInitFunc) gxml_node_list_instance_init, NULL };
		GType gxml_node_list_type_id;
		gxml_node_list_type_id = g_type_register_static (GEE_TYPE_ARRAY_LIST, "GXmlNodeList", &g_define_type_info, 0);
		g_once_init_leave (&gxml_node_list_type_id__volatile, gxml_node_list_type_id);
	}
	return gxml_node_list_type_id__volatile;
}



