/* SerializableJson.c generated by valac 0.22.1, the Vala compiler
 * generated from SerializableJson.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */
/* Serialization.vala
 *
 * Copyright (C) 2012-2013  Richard Schwarting <aquarichy@gmail.com>
 * Copyright (C) 2013  Daniel Espinosa <esodan@gmail.com>
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Richard Schwarting <aquarichy@gmail.com>
 *       Daniel Espinosa <esodan@gmail.com>
 */
/*
  Version 3: json-glib version

  PLAN:
  * add support for GObject Introspection to allow us to serialise non-property members

  json-glib
  * has functions to convert XML structures into Objects and vice versa
  * can convert simple objects automatically
  * richer objects need to implement interface

  json_serializable_real_serialize -> json_serialize_pspec
  * how do these get used with GInterfaces?  are these default methods like with superclasses?
  * TODO: I don't think vala does multiple inheritance, so do we want GXml.Serializable to be an interface or a superclass?

  json_serializable_default_{de,}serialize_property -> json_serializable_real_{de,}serialize

  json_serializable_{de,}serialize_property -> iface->{de,}serialize_property
    these all get init'd to -> json_serializable_real_{de,}serialize_property
      these all call -> json_{de,}serialize_pspec

  json_serializable_{find,list,get,set}_propert{y,ies} -> iface->{find,list,get,set}_propert{y,ies}
    these all get init'd to -> json_serializable_real_{find,list,get,set}_propert{y,ies}
    these all call -> g_object_{class,}_{find,list,get,set}_propert{y,ies}
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define GXML_TYPE_SERIALIZABLE (gxml_serializable_get_type ())
#define GXML_SERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE, GXmlSerializable))
#define GXML_IS_SERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE))
#define GXML_SERIALIZABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_SERIALIZABLE, GXmlSerializableIface))

typedef struct _GXmlSerializable GXmlSerializable;
typedef struct _GXmlSerializableIface GXmlSerializableIface;

#define GXML_TYPE_NODE (gxml_node_get_type ())
#define GXML_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NODE, GXmlNode))
#define GXML_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_NODE, GXmlNodeClass))
#define GXML_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NODE))
#define GXML_IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_NODE))
#define GXML_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_NODE, GXmlNodeClass))

typedef struct _GXmlNode GXmlNode;
typedef struct _GXmlNodeClass GXmlNodeClass;

#define GXML_TYPE_BACKED_NODE (gxml_backed_node_get_type ())
#define GXML_BACKED_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_BACKED_NODE, GXmlBackedNode))
#define GXML_BACKED_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_BACKED_NODE, GXmlBackedNodeClass))
#define GXML_IS_BACKED_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_BACKED_NODE))
#define GXML_IS_BACKED_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_BACKED_NODE))
#define GXML_BACKED_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_BACKED_NODE, GXmlBackedNodeClass))

typedef struct _GXmlBackedNode GXmlBackedNode;
typedef struct _GXmlBackedNodeClass GXmlBackedNodeClass;

#define GXML_TYPE_ELEMENT (gxml_element_get_type ())
#define GXML_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ELEMENT, GXmlElement))
#define GXML_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_ELEMENT, GXmlElementClass))
#define GXML_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ELEMENT))
#define GXML_IS_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_ELEMENT))
#define GXML_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_ELEMENT, GXmlElementClass))

typedef struct _GXmlElement GXmlElement;
typedef struct _GXmlElementClass GXmlElementClass;

#define GXML_TYPE_SERIALIZABLE_JSON (gxml_serializable_json_get_type ())
#define GXML_SERIALIZABLE_JSON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE_JSON, GXmlSerializableJson))
#define GXML_SERIALIZABLE_JSON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_SERIALIZABLE_JSON, GXmlSerializableJsonClass))
#define GXML_IS_SERIALIZABLE_JSON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE_JSON))
#define GXML_IS_SERIALIZABLE_JSON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_SERIALIZABLE_JSON))
#define GXML_SERIALIZABLE_JSON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_SERIALIZABLE_JSON, GXmlSerializableJsonClass))

typedef struct _GXmlSerializableJson GXmlSerializableJson;
typedef struct _GXmlSerializableJsonClass GXmlSerializableJsonClass;
typedef struct _GXmlSerializableJsonPrivate GXmlSerializableJsonPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GXML_TYPE_DOCUMENT (gxml_document_get_type ())
#define GXML_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOCUMENT, GXmlDocument))
#define GXML_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_DOCUMENT, GXmlDocumentClass))
#define GXML_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOCUMENT))
#define GXML_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_DOCUMENT))
#define GXML_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_DOCUMENT, GXmlDocumentClass))

typedef struct _GXmlDocument GXmlDocument;
typedef struct _GXmlDocumentClass GXmlDocumentClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_param_spec_unref0(var) ((var == NULL) ? NULL : (var = (g_param_spec_unref (var), NULL)))

#define GXML_TYPE_CHARACTER_DATA (gxml_character_data_get_type ())
#define GXML_CHARACTER_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_CHARACTER_DATA, GXmlCharacterData))
#define GXML_CHARACTER_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_CHARACTER_DATA, GXmlCharacterDataClass))
#define GXML_IS_CHARACTER_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_CHARACTER_DATA))
#define GXML_IS_CHARACTER_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_CHARACTER_DATA))
#define GXML_CHARACTER_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_CHARACTER_DATA, GXmlCharacterDataClass))

typedef struct _GXmlCharacterData GXmlCharacterData;
typedef struct _GXmlCharacterDataClass GXmlCharacterDataClass;

#define GXML_TYPE_TEXT (gxml_text_get_type ())
#define GXML_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_TEXT, GXmlText))
#define GXML_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_TEXT, GXmlTextClass))
#define GXML_IS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_TEXT))
#define GXML_IS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_TEXT))
#define GXML_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_TEXT, GXmlTextClass))

typedef struct _GXmlText GXmlText;
typedef struct _GXmlTextClass GXmlTextClass;

#define GXML_TYPE_NODE_LIST (gxml_node_list_get_type ())
#define GXML_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NODE_LIST, GXmlNodeList))
#define GXML_IS_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NODE_LIST))
#define GXML_NODE_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NODE_LIST, GXmlNodeListIface))

typedef struct _GXmlNodeList GXmlNodeList;
typedef struct _GXmlNodeListIface GXmlNodeListIface;

struct _GXmlSerializableIface {
	GTypeInterface parent_iface;
	gboolean (*get_enable_unknown_serializable_property) (GXmlSerializable* self);
	gboolean (*serialize_use_xml_node_value) (GXmlSerializable* self);
	gchar* (*node_name) (GXmlSerializable* self);
	gboolean (*property_use_nick) (GXmlSerializable* self);
	GXmlNode* (*serialize) (GXmlSerializable* self, GXmlNode* node, GError** error);
	GXmlNode* (*serialize_property) (GXmlSerializable* self, GXmlElement* element, GParamSpec* prop, GError** error);
	GXmlNode* (*deserialize) (GXmlSerializable* self, GXmlNode* node, GError** error);
	gboolean (*deserialize_property) (GXmlSerializable* self, GXmlNode* property_node, GError** error);
	GParamSpec* (*find_property_spec) (GXmlSerializable* self, const gchar* property_name);
	GParamSpec* (*default_find_property_spec) (GXmlSerializable* self, const gchar* property_name);
	void (*init_properties) (GXmlSerializable* self);
	void (*default_init_properties) (GXmlSerializable* self);
	GParamSpec** (*list_serializable_properties) (GXmlSerializable* self, int* result_length1);
	GParamSpec** (*default_list_serializable_properties) (GXmlSerializable* self, int* result_length1);
	void (*get_property_value) (GXmlSerializable* self, GParamSpec* spec, GValue* val);
	void (*default_get_property_value) (GXmlSerializable* self, GParamSpec* spec, GValue* val);
	void (*set_property_value) (GXmlSerializable* self, GParamSpec* spec, GValue* val);
	void (*default_set_property_value) (GXmlSerializable* self, GParamSpec* spec, GValue* val);
	gboolean (*transform_from_string) (GXmlSerializable* self, const gchar* str, GValue* dest, GError** error);
	gboolean (*transform_to_string) (GXmlSerializable* self, GValue* val, gchar** str, GError** error);
	GParamSpec** (*get_properties) (GXmlSerializable* self, int* result_length1);
	void (*set_properties) (GXmlSerializable* self, GParamSpec** value, int value_length1);
	GHashTable* (*get_ignored_serializable_properties) (GXmlSerializable* self);
	void (*set_ignored_serializable_properties) (GXmlSerializable* self, GHashTable* value);
	GHashTable* (*get_unknown_serializable_property) (GXmlSerializable* self);
	void (*set_unknown_serializable_property) (GXmlSerializable* self, GHashTable* value);
	const gchar* (*get_serialized_xml_node_value) (GXmlSerializable* self);
	void (*set_serialized_xml_node_value) (GXmlSerializable* self, const gchar* value);
};

struct _GXmlSerializableJson {
	GObject parent_instance;
	GXmlSerializableJsonPrivate * priv;
};

struct _GXmlSerializableJsonClass {
	GObjectClass parent_class;
	gboolean (*get_enable_unknown_serializable_property) (GXmlSerializableJson* self);
	gboolean (*serialize_use_xml_node_value) (GXmlSerializableJson* self);
	gchar* (*node_name) (GXmlSerializableJson* self);
	gboolean (*property_use_nick) (GXmlSerializableJson* self);
	GParamSpec* (*find_property_spec) (GXmlSerializableJson* self, const gchar* property_name);
	void (*init_properties) (GXmlSerializableJson* self);
	GParamSpec** (*list_serializable_properties) (GXmlSerializableJson* self, int* result_length1);
	void (*get_property_value) (GXmlSerializableJson* self, GParamSpec* spec, GValue* val);
	void (*set_property_value) (GXmlSerializableJson* self, GParamSpec* spec, GValue* val);
	gboolean (*transform_from_string) (GXmlSerializableJson* self, const gchar* str, GValue* dest, GError** error);
	gboolean (*transform_to_string) (GXmlSerializableJson* self, GValue* val, gchar** str, GError** error);
	GXmlNode* (*serialize_property) (GXmlSerializableJson* self, GXmlElement* element, GParamSpec* prop, GError** error);
	gboolean (*deserialize_property) (GXmlSerializableJson* self, GXmlNode* property_node, GError** error);
};

struct _GXmlSerializableJsonPrivate {
	GParamSpec** _properties;
	gint _properties_length1;
	gint __properties_size_;
	GHashTable* _ignored_serializable_properties;
	GHashTable* _unknown_serializable_property;
	gchar* _serialized_xml_node_value;
};

struct _GXmlNodeListIface {
	GTypeInterface parent_iface;
	GXmlNode* (*item) (GXmlNodeList* self, gulong idx);
	GXmlNode* (*insert_before) (GXmlNodeList* self, GXmlNode* new_child, GXmlNode* ref_child);
	GXmlNode* (*replace_child) (GXmlNodeList* self, GXmlNode* new_child, GXmlNode* old_child);
	GXmlNode* (*remove_child) (GXmlNodeList* self, GXmlNode* old_child);
	GXmlNode* (*append_child) (GXmlNodeList* self, GXmlNode* new_child);
	gchar* (*to_string) (GXmlNodeList* self, gboolean in_line);
	GXmlNode* (*first) (GXmlNodeList* self);
	GXmlNode* (*last) (GXmlNodeList* self);
	GXmlNode* (*get) (GXmlNodeList* self, gint n);
	gulong (*get_length) (GXmlNodeList* self);
	void (*set_length) (GXmlNodeList* self, gulong value);
};

typedef enum  {
	GXML_SERIALIZABLE_ERROR_UNSUPPORTED_TYPE_ERROR,
	GXML_SERIALIZABLE_ERROR_STR_TO_VALUE_ERROR
} GXmlSerializableError;
#define GXML_SERIALIZABLE_ERROR gxml_serializable_error_quark ()

static gpointer gxml_serializable_json_parent_class = NULL;
static GXmlSerializableIface* gxml_serializable_json_gxml_serializable_parent_iface = NULL;

GType gxml_node_get_type (void) G_GNUC_CONST;
GType gxml_backed_node_get_type (void) G_GNUC_CONST;
GType gxml_element_get_type (void) G_GNUC_CONST;
GType gxml_serializable_get_type (void) G_GNUC_CONST;
GType gxml_serializable_json_get_type (void) G_GNUC_CONST;
#define GXML_SERIALIZABLE_JSON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GXML_TYPE_SERIALIZABLE_JSON, GXmlSerializableJsonPrivate))
enum  {
	GXML_SERIALIZABLE_JSON_DUMMY_PROPERTY,
	GXML_SERIALIZABLE_JSON_IGNORED_SERIALIZABLE_PROPERTIES,
	GXML_SERIALIZABLE_JSON_UNKNOWN_SERIALIZABLE_PROPERTY,
	GXML_SERIALIZABLE_JSON_SERIALIZED_XML_NODE_VALUE
};
gboolean gxml_serializable_json_get_enable_unknown_serializable_property (GXmlSerializableJson* self);
static gboolean gxml_serializable_json_real_get_enable_unknown_serializable_property (GXmlSerializableJson* self);
gboolean gxml_serializable_json_serialize_use_xml_node_value (GXmlSerializableJson* self);
static gboolean gxml_serializable_json_real_serialize_use_xml_node_value (GXmlSerializableJson* self);
gchar* gxml_serializable_json_node_name (GXmlSerializableJson* self);
static gchar* gxml_serializable_json_real_node_name (GXmlSerializableJson* self);
gboolean gxml_serializable_json_property_use_nick (GXmlSerializableJson* self);
static gboolean gxml_serializable_json_real_property_use_nick (GXmlSerializableJson* self);
GParamSpec* gxml_serializable_json_find_property_spec (GXmlSerializableJson* self, const gchar* property_name);
static GParamSpec* gxml_serializable_json_real_find_property_spec (GXmlSerializableJson* self, const gchar* property_name);
GParamSpec* gxml_serializable_default_find_property_spec (GXmlSerializable* self, const gchar* property_name);
void gxml_serializable_json_init_properties (GXmlSerializableJson* self);
static void gxml_serializable_json_real_init_properties (GXmlSerializableJson* self);
void gxml_serializable_default_init_properties (GXmlSerializable* self);
GParamSpec** gxml_serializable_json_list_serializable_properties (GXmlSerializableJson* self, int* result_length1);
static GParamSpec** gxml_serializable_json_real_list_serializable_properties (GXmlSerializableJson* self, int* result_length1);
GParamSpec** gxml_serializable_default_list_serializable_properties (GXmlSerializable* self, int* result_length1);
void gxml_serializable_json_get_property_value (GXmlSerializableJson* self, GParamSpec* spec, GValue* val);
static void gxml_serializable_json_real_get_property_value (GXmlSerializableJson* self, GParamSpec* spec, GValue* val);
void gxml_serializable_default_get_property_value (GXmlSerializable* self, GParamSpec* spec, GValue* val);
void gxml_serializable_json_set_property_value (GXmlSerializableJson* self, GParamSpec* spec, GValue* val);
static void gxml_serializable_json_real_set_property_value (GXmlSerializableJson* self, GParamSpec* spec, GValue* val);
void gxml_serializable_default_set_property_value (GXmlSerializable* self, GParamSpec* spec, GValue* val);
gboolean gxml_serializable_json_transform_from_string (GXmlSerializableJson* self, const gchar* str, GValue* dest, GError** error);
static gboolean gxml_serializable_json_real_transform_from_string (GXmlSerializableJson* self, const gchar* str, GValue* dest, GError** error);
gboolean gxml_serializable_json_transform_to_string (GXmlSerializableJson* self, GValue* val, gchar** str, GError** error);
static gboolean gxml_serializable_json_real_transform_to_string (GXmlSerializableJson* self, GValue* val, gchar** str, GError** error);
static GXmlNode* gxml_serializable_json_real_serialize (GXmlSerializable* base, GXmlNode* node, GError** error);
GType gxml_document_get_type (void) G_GNUC_CONST;
GXmlDocument* gxml_node_get_owner_document (GXmlNode* self);
GXmlElement* gxml_document_create_element (GXmlDocument* self, const gchar* tag_name);
GXmlNode* gxml_node_append_child (GXmlNode* self, GXmlNode* new_child);
void gxml_element_set_attribute (GXmlElement* self, const gchar* name, const gchar* value);
GXmlNode* gxml_serializable_json_serialize_property (GXmlSerializableJson* self, GXmlElement* element, GParamSpec* prop, GError** error);
static GXmlNode* gxml_serializable_json_real_serialize_property (GXmlSerializableJson* self, GXmlElement* element, GParamSpec* prop, GError** error);
GXmlNode* gxml_serializable_serialize (GXmlSerializable* self, GXmlNode* node, GError** error);
GType gxml_character_data_get_type (void) G_GNUC_CONST;
GType gxml_text_get_type (void) G_GNUC_CONST;
GXmlText* gxml_document_create_text_node (GXmlDocument* self, const gchar* text_data);
GXmlDocument* gxml_serialization_serialize_object (GObject* object, GError** error);
GXmlElement* gxml_document_get_document_element (GXmlDocument* self);
gboolean gxml_node_copy (GXmlNode* self, GXmlNode** node, gboolean deep);
static GXmlNode* gxml_serializable_json_real_deserialize (GXmlSerializable* base, GXmlNode* node, GError** error);
GType gxml_node_list_get_type (void) G_GNUC_CONST;
GXmlNodeList* gxml_node_get_child_nodes (GXmlNode* self);
GXmlNode* gxml_node_list_get (GXmlNodeList* self, gint n);
gboolean gxml_serializable_json_deserialize_property (GXmlSerializableJson* self, GXmlNode* property_node, GError** error);
static gboolean gxml_serializable_json_real_deserialize_property (GXmlSerializableJson* self, GXmlNode* property_node, GError** error);
const gchar* gxml_node_get_node_name (GXmlNode* self);
gchar* gxml_element_get_attribute (GXmlElement* self, const gchar* name);
gchar* gxml_node_to_string (GXmlNode* self, gboolean format, gint level);
GHashTable* gxml_serializable_get_unknown_serializable_property (GXmlSerializable* self);
GXmlNode* gxml_serializable_deserialize (GXmlSerializable* self, GXmlNode* node, GError** error);
gchar* gxml_element_get_content (GXmlElement* self);
GQuark gxml_serializable_error_quark (void);
gboolean gxml_serializable_string_to_gvalue (const gchar* str, GValue* dest, GError** error);
GXmlNode* gxml_node_get_first_child (GXmlNode* self);
GObject* gxml_serialization_deserialize_object_from_node (GXmlNode* obj_node, GError** error);
GXmlSerializableJson* gxml_serializable_json_new (void);
GXmlSerializableJson* gxml_serializable_json_construct (GType object_type);
static GParamSpec** _vala_array_dup3 (GParamSpec** self, int length);
static void gxml_serializable_json_finalize (GObject* obj);
GHashTable* gxml_serializable_get_ignored_serializable_properties (GXmlSerializable* self);
const gchar* gxml_serializable_get_serialized_xml_node_value (GXmlSerializable* self);
static void _vala_gxml_serializable_json_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void gxml_serializable_set_ignored_serializable_properties (GXmlSerializable* self, GHashTable* value);
void gxml_serializable_set_unknown_serializable_property (GXmlSerializable* self, GHashTable* value);
void gxml_serializable_set_serialized_xml_node_value (GXmlSerializable* self, const gchar* value);
static void _vala_gxml_serializable_json_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gboolean gxml_serializable_json_real_get_enable_unknown_serializable_property (GXmlSerializableJson* self) {
	gboolean result = FALSE;
	result = FALSE;
	return result;
}


gboolean gxml_serializable_json_get_enable_unknown_serializable_property (GXmlSerializableJson* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_JSON_GET_CLASS (self)->get_enable_unknown_serializable_property (self);
}


static gboolean gxml_serializable_json_real_serialize_use_xml_node_value (GXmlSerializableJson* self) {
	gboolean result = FALSE;
	result = FALSE;
	return result;
}


gboolean gxml_serializable_json_serialize_use_xml_node_value (GXmlSerializableJson* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_JSON_GET_CLASS (self)->serialize_use_xml_node_value (self);
}


static gchar* gxml_serializable_json_real_node_name (GXmlSerializableJson* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	_tmp0_ = g_strdup ("Object");
	result = _tmp0_;
	return result;
}


gchar* gxml_serializable_json_node_name (GXmlSerializableJson* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_JSON_GET_CLASS (self)->node_name (self);
}


static gboolean gxml_serializable_json_real_property_use_nick (GXmlSerializableJson* self) {
	gboolean result = FALSE;
	result = FALSE;
	return result;
}


gboolean gxml_serializable_json_property_use_nick (GXmlSerializableJson* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_JSON_GET_CLASS (self)->property_use_nick (self);
}


static GParamSpec* gxml_serializable_json_real_find_property_spec (GXmlSerializableJson* self, const gchar* property_name) {
	GParamSpec* result = NULL;
	const gchar* _tmp0_ = NULL;
	GParamSpec* _tmp1_ = NULL;
	g_return_val_if_fail (property_name != NULL, NULL);
	_tmp0_ = property_name;
	_tmp1_ = gxml_serializable_default_find_property_spec ((GXmlSerializable*) self, _tmp0_);
	result = _tmp1_;
	return result;
}


GParamSpec* gxml_serializable_json_find_property_spec (GXmlSerializableJson* self, const gchar* property_name) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_JSON_GET_CLASS (self)->find_property_spec (self, property_name);
}


static void gxml_serializable_json_real_init_properties (GXmlSerializableJson* self) {
	gxml_serializable_default_init_properties ((GXmlSerializable*) self);
}


void gxml_serializable_json_init_properties (GXmlSerializableJson* self) {
	g_return_if_fail (self != NULL);
	GXML_SERIALIZABLE_JSON_GET_CLASS (self)->init_properties (self);
}


static GParamSpec** gxml_serializable_json_real_list_serializable_properties (GXmlSerializableJson* self, int* result_length1) {
	GParamSpec** result = NULL;
	gint _tmp0_ = 0;
	GParamSpec** _tmp1_ = NULL;
	GParamSpec** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	_tmp1_ = gxml_serializable_default_list_serializable_properties ((GXmlSerializable*) self, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}


GParamSpec** gxml_serializable_json_list_serializable_properties (GXmlSerializableJson* self, int* result_length1) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_JSON_GET_CLASS (self)->list_serializable_properties (self, result_length1);
}


static void gxml_serializable_json_real_get_property_value (GXmlSerializableJson* self, GParamSpec* spec, GValue* val) {
	GParamSpec* _tmp0_ = NULL;
	g_return_if_fail (spec != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = spec;
	gxml_serializable_default_get_property_value ((GXmlSerializable*) self, _tmp0_, val);
}


void gxml_serializable_json_get_property_value (GXmlSerializableJson* self, GParamSpec* spec, GValue* val) {
	g_return_if_fail (self != NULL);
	GXML_SERIALIZABLE_JSON_GET_CLASS (self)->get_property_value (self, spec, val);
}


static void gxml_serializable_json_real_set_property_value (GXmlSerializableJson* self, GParamSpec* spec, GValue* val) {
	GParamSpec* _tmp0_ = NULL;
	GValue _tmp1_ = {0};
	g_return_if_fail (spec != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = spec;
	_tmp1_ = *val;
	gxml_serializable_default_set_property_value ((GXmlSerializable*) self, _tmp0_, &_tmp1_);
}


void gxml_serializable_json_set_property_value (GXmlSerializableJson* self, GParamSpec* spec, GValue* val) {
	g_return_if_fail (self != NULL);
	GXML_SERIALIZABLE_JSON_GET_CLASS (self)->set_property_value (self, spec, val);
}


static gboolean gxml_serializable_json_real_transform_from_string (GXmlSerializableJson* self, const gchar* str, GValue* dest, GError** error) {
	gboolean result = FALSE;
	g_return_val_if_fail (str != NULL, FALSE);
	g_return_val_if_fail (dest != NULL, FALSE);
	result = FALSE;
	return result;
}


gboolean gxml_serializable_json_transform_from_string (GXmlSerializableJson* self, const gchar* str, GValue* dest, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_JSON_GET_CLASS (self)->transform_from_string (self, str, dest, error);
}


static gboolean gxml_serializable_json_real_transform_to_string (GXmlSerializableJson* self, GValue* val, gchar** str, GError** error) {
	gboolean result = FALSE;
	g_return_val_if_fail (val != NULL, FALSE);
	g_return_val_if_fail (*str != NULL, FALSE);
	result = FALSE;
	return result;
}


gboolean gxml_serializable_json_transform_to_string (GXmlSerializableJson* self, GValue* val, gchar** str, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_JSON_GET_CLASS (self)->transform_to_string (self, val, str, error);
}


/**
   * If @node is a Document serialize just add an <Object> element.
   *
   * If @node is an Element serialize add to it an <Object> element.
   *
   * Is up to you to add convenient Element node to a Document, in order to be
   * used by serialize and add new <Object> tags per object to serialize.
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _g_param_spec_ref0 (gpointer self) {
	return self ? g_param_spec_ref (self) : NULL;
}


static GXmlNode* gxml_serializable_json_real_serialize (GXmlSerializable* base, GXmlNode* node, GError** error) {
	GXmlSerializableJson * self;
	GXmlNode* result = NULL;
	GXmlDocument* doc = NULL;
	GXmlElement* root = NULL;
	GParamSpec** props = NULL;
	gint props_length1 = 0;
	gint _props_size_ = 0;
	gchar* oid = NULL;
	gchar* _tmp0_ = NULL;
	GXmlNode* _tmp1_ = NULL;
	GXmlDocument* _tmp8_ = NULL;
	GXmlElement* _tmp9_ = NULL;
	GXmlElement* _tmp10_ = NULL;
	GXmlDocument* _tmp11_ = NULL;
	GXmlElement* _tmp12_ = NULL;
	GXmlElement* _tmp13_ = NULL;
	GType _tmp14_ = 0UL;
	const gchar* _tmp15_ = NULL;
	GXmlElement* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	GParamSpec** _tmp19_ = NULL;
	GParamSpec** _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	GError * _inner_error_ = NULL;
	self = (GXmlSerializableJson*) base;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%p", self);
	oid = _tmp0_;
	_tmp1_ = node;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, GXML_TYPE_DOCUMENT)) {
		GXmlNode* _tmp2_ = NULL;
		GXmlDocument* _tmp3_ = NULL;
		_tmp2_ = node;
		_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GXML_TYPE_DOCUMENT, GXmlDocument));
		_g_object_unref0 (doc);
		doc = _tmp3_;
	} else {
		GXmlNode* _tmp4_ = NULL;
		GXmlDocument* _tmp5_ = NULL;
		GXmlDocument* _tmp6_ = NULL;
		GXmlDocument* _tmp7_ = NULL;
		_tmp4_ = node;
		_tmp5_ = gxml_node_get_owner_document (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_g_object_unref0 (doc);
		doc = _tmp7_;
	}
	_tmp8_ = doc;
	_tmp9_ = gxml_document_create_element (_tmp8_, "Object");
	_tmp10_ = _g_object_ref0 (_tmp9_);
	_g_object_unref0 (root);
	root = _tmp10_;
	_tmp11_ = doc;
	_tmp12_ = root;
	gxml_node_append_child ((GXmlNode*) _tmp11_, (GXmlNode*) _tmp12_);
	_tmp13_ = root;
	_tmp14_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
	_tmp15_ = g_type_name (_tmp14_);
	gxml_element_set_attribute (_tmp13_, "otype", _tmp15_);
	_tmp16_ = root;
	_tmp17_ = oid;
	gxml_element_set_attribute (_tmp16_, "oid", _tmp17_);
	_tmp19_ = gxml_serializable_json_list_serializable_properties (self, &_tmp18_);
	props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	props = _tmp19_;
	props_length1 = _tmp18_;
	_props_size_ = props_length1;
	_tmp20_ = props;
	_tmp20__length1 = props_length1;
	{
		GParamSpec** prop_spec_collection = NULL;
		gint prop_spec_collection_length1 = 0;
		gint _prop_spec_collection_size_ = 0;
		gint prop_spec_it = 0;
		prop_spec_collection = _tmp20_;
		prop_spec_collection_length1 = _tmp20__length1;
		for (prop_spec_it = 0; prop_spec_it < _tmp20__length1; prop_spec_it = prop_spec_it + 1) {
			GParamSpec* _tmp21_ = NULL;
			GParamSpec* prop_spec = NULL;
			_tmp21_ = _g_param_spec_ref0 (prop_spec_collection[prop_spec_it]);
			prop_spec = _tmp21_;
			{
				GXmlElement* _tmp22_ = NULL;
				GParamSpec* _tmp23_ = NULL;
				GXmlNode* _tmp24_ = NULL;
				GXmlNode* _tmp25_ = NULL;
				_tmp22_ = root;
				_tmp23_ = prop_spec;
				_tmp24_ = gxml_serializable_json_serialize_property (self, _tmp22_, _tmp23_, &_inner_error_);
				_tmp25_ = _tmp24_;
				_g_object_unref0 (_tmp25_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_param_spec_unref0 (prop_spec);
					_g_free0 (oid);
					props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_param_spec_unref), NULL);
					_g_object_unref0 (root);
					_g_object_unref0 (doc);
					return NULL;
				}
				_g_param_spec_unref0 (prop_spec);
			}
		}
	}
	result = (GXmlNode*) root;
	_g_free0 (oid);
	props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	_g_object_unref0 (doc);
	return result;
}


static GXmlNode* gxml_serializable_json_real_serialize_property (GXmlSerializableJson* self, GXmlElement* element, GParamSpec* prop, GError** error) {
	GXmlNode* result = NULL;
	GType type = 0UL;
	GValue val = {0};
	GXmlNode* value_node = NULL;
	GXmlElement* prop_node = NULL;
	GParamSpec* _tmp0_ = NULL;
	GType _tmp1_ = 0UL;
	GType _tmp2_ = 0UL;
	gboolean _tmp3_ = FALSE;
	GXmlDocument* doc = NULL;
	GXmlElement* _tmp12_ = NULL;
	GXmlDocument* _tmp13_ = NULL;
	GXmlDocument* _tmp14_ = NULL;
	GXmlDocument* _tmp15_ = NULL;
	GXmlDocument* _tmp16_ = NULL;
	GXmlElement* _tmp17_ = NULL;
	GXmlElement* _tmp18_ = NULL;
	GXmlElement* _tmp19_ = NULL;
	GParamSpec* _tmp20_ = NULL;
	GType _tmp21_ = 0UL;
	const gchar* _tmp22_ = NULL;
	GXmlElement* _tmp23_ = NULL;
	GParamSpec* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	GXmlElement* _tmp26_ = NULL;
	GXmlElement* _tmp27_ = NULL;
	GType _tmp28_ = 0UL;
	gboolean _tmp29_ = FALSE;
	GXmlElement* _tmp83_ = NULL;
	GParamSpec* _tmp84_ = NULL;
	GXmlNode* _tmp85_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (element != NULL, NULL);
	g_return_val_if_fail (prop != NULL, NULL);
	value_node = NULL;
	_tmp0_ = prop;
	_tmp1_ = _tmp0_->value_type;
	type = _tmp1_;
	_tmp2_ = type;
	_tmp3_ = g_type_is_a (_tmp2_, GXML_TYPE_SERIALIZABLE);
	if (_tmp3_) {
		GType _tmp4_ = 0UL;
		GValue _tmp5_ = {0};
		GValue _tmp6_ = {0};
		GParamSpec* _tmp7_ = NULL;
		GXmlNode* _tmp8_ = NULL;
		GObject* _tmp9_ = NULL;
		GXmlElement* _tmp10_ = NULL;
		GXmlNode* _tmp11_ = NULL;
		_tmp4_ = type;
		g_value_init (&_tmp5_, _tmp4_);
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
		val = _tmp5_;
		_tmp6_ = val;
		_tmp7_ = prop;
		gxml_serializable_json_get_property_value (self, _tmp7_, &val);
		_tmp9_ = g_value_get_object (&val);
		_tmp10_ = element;
		_tmp11_ = gxml_serializable_serialize (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GXML_TYPE_SERIALIZABLE, GXmlSerializable), (GXmlNode*) _tmp10_, &_inner_error_);
		_tmp8_ = _tmp11_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (prop_node);
			_g_object_unref0 (value_node);
			G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
			return NULL;
		}
		result = _tmp8_;
		_g_object_unref0 (prop_node);
		_g_object_unref0 (value_node);
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
		return result;
	}
	_tmp12_ = element;
	_tmp13_ = gxml_node_get_owner_document ((GXmlNode*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _g_object_ref0 (_tmp14_);
	doc = _tmp15_;
	_tmp16_ = doc;
	_tmp17_ = gxml_document_create_element (_tmp16_, "Property");
	_tmp18_ = _g_object_ref0 (_tmp17_);
	_g_object_unref0 (prop_node);
	prop_node = _tmp18_;
	_tmp19_ = prop_node;
	_tmp20_ = prop;
	_tmp21_ = _tmp20_->value_type;
	_tmp22_ = g_type_name (_tmp21_);
	gxml_element_set_attribute (_tmp19_, "ptype", _tmp22_);
	_tmp23_ = prop_node;
	_tmp24_ = prop;
	_tmp25_ = _tmp24_->name;
	gxml_element_set_attribute (_tmp23_, "pname", _tmp25_);
	_tmp26_ = element;
	_tmp27_ = prop_node;
	gxml_node_append_child ((GXmlNode*) _tmp26_, (GXmlNode*) _tmp27_);
	_tmp28_ = type;
	_tmp29_ = G_TYPE_IS_ENUM (_tmp28_);
	if (_tmp29_) {
		GValue _tmp30_ = {0};
		GValue _tmp31_ = {0};
		GParamSpec* _tmp32_ = NULL;
		GXmlDocument* _tmp33_ = NULL;
		gint _tmp34_ = 0;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		GXmlText* _tmp37_ = NULL;
		GXmlNode* _tmp38_ = NULL;
		GXmlElement* _tmp39_ = NULL;
		GXmlNode* _tmp40_ = NULL;
		g_value_init (&_tmp30_, G_TYPE_INT);
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
		val = _tmp30_;
		_tmp31_ = val;
		_tmp32_ = prop;
		gxml_serializable_json_get_property_value (self, _tmp32_, &val);
		_tmp33_ = doc;
		_tmp34_ = g_value_get_int (&val);
		_tmp35_ = g_strdup_printf ("%d", _tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = gxml_document_create_text_node (_tmp33_, _tmp36_);
		_tmp38_ = _g_object_ref0 ((GXmlNode*) _tmp37_);
		_g_object_unref0 (value_node);
		value_node = _tmp38_;
		_g_free0 (_tmp36_);
		_tmp39_ = prop_node;
		_tmp40_ = value_node;
		gxml_node_append_child ((GXmlNode*) _tmp39_, _tmp40_);
		result = (GXmlNode*) prop_node;
		_g_object_unref0 (doc);
		_g_object_unref0 (value_node);
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
		return result;
	} else {
		GType _tmp41_ = 0UL;
		gboolean _tmp42_ = FALSE;
		_tmp41_ = type;
		_tmp42_ = g_value_type_transformable (_tmp41_, G_TYPE_STRING);
		if (_tmp42_) {
			GType _tmp43_ = 0UL;
			GValue _tmp44_ = {0};
			GValue _tmp45_ = {0};
			GValue t = {0};
			GValue _tmp46_ = {0};
			GParamSpec* _tmp47_ = NULL;
			GXmlDocument* _tmp48_ = NULL;
			const gchar* _tmp49_ = NULL;
			GXmlText* _tmp50_ = NULL;
			GXmlNode* _tmp51_ = NULL;
			GXmlElement* _tmp52_ = NULL;
			GXmlNode* _tmp53_ = NULL;
			_tmp43_ = type;
			g_value_init (&_tmp44_, _tmp43_);
			G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
			val = _tmp44_;
			_tmp45_ = val;
			g_value_init (&_tmp46_, G_TYPE_STRING);
			t = _tmp46_;
			_tmp47_ = prop;
			gxml_serializable_json_get_property_value (self, _tmp47_, &val);
			g_value_transform (&val, &t);
			_tmp48_ = doc;
			_tmp49_ = g_value_get_string (&t);
			_tmp50_ = gxml_document_create_text_node (_tmp48_, _tmp49_);
			_tmp51_ = _g_object_ref0 ((GXmlNode*) _tmp50_);
			_g_object_unref0 (value_node);
			value_node = _tmp51_;
			_tmp52_ = prop_node;
			_tmp53_ = value_node;
			gxml_node_append_child ((GXmlNode*) _tmp52_, _tmp53_);
			result = (GXmlNode*) prop_node;
			G_IS_VALUE (&t) ? (g_value_unset (&t), NULL) : NULL;
			_g_object_unref0 (doc);
			_g_object_unref0 (value_node);
			G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
			return result;
		} else {
			GType _tmp54_ = 0UL;
			_tmp54_ = type;
			if (_tmp54_ == G_TYPE_GTYPE) {
				GXmlDocument* _tmp55_ = NULL;
				GType _tmp56_ = 0UL;
				const gchar* _tmp57_ = NULL;
				GXmlText* _tmp58_ = NULL;
				GXmlNode* _tmp59_ = NULL;
				GXmlElement* _tmp60_ = NULL;
				GXmlNode* _tmp61_ = NULL;
				_tmp55_ = doc;
				_tmp56_ = type;
				_tmp57_ = g_type_name (_tmp56_);
				_tmp58_ = gxml_document_create_text_node (_tmp55_, _tmp57_);
				_tmp59_ = _g_object_ref0 ((GXmlNode*) _tmp58_);
				_g_object_unref0 (value_node);
				value_node = _tmp59_;
				_tmp60_ = prop_node;
				_tmp61_ = value_node;
				gxml_node_append_child ((GXmlNode*) _tmp60_, _tmp61_);
				result = (GXmlNode*) prop_node;
				_g_object_unref0 (doc);
				_g_object_unref0 (value_node);
				G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
				return result;
			} else {
				gboolean _tmp62_ = FALSE;
				GType _tmp63_ = 0UL;
				gboolean _tmp64_ = FALSE;
				gboolean _tmp67_ = FALSE;
				_tmp63_ = type;
				_tmp64_ = g_type_is_a (_tmp63_, G_TYPE_OBJECT);
				if (_tmp64_) {
					GType _tmp65_ = 0UL;
					gboolean _tmp66_ = FALSE;
					_tmp65_ = type;
					_tmp66_ = g_type_is_a (_tmp65_, GEE_TYPE_COLLECTION);
					_tmp62_ = !_tmp66_;
				} else {
					_tmp62_ = FALSE;
				}
				_tmp67_ = _tmp62_;
				if (_tmp67_) {
					GObject* child_object = NULL;
					GValue _tmp68_ = {0};
					GValue _tmp69_ = {0};
					GParamSpec* _tmp70_ = NULL;
					GObject* _tmp71_ = NULL;
					GObject* _tmp72_ = NULL;
					GXmlDocument* value_doc = NULL;
					GObject* _tmp73_ = NULL;
					GXmlDocument* _tmp74_ = NULL;
					GXmlDocument* _tmp75_ = NULL;
					GXmlElement* _tmp76_ = NULL;
					GXmlNode* _tmp77_ = NULL;
					GXmlDocument* _tmp78_ = NULL;
					GXmlElement* _tmp79_ = NULL;
					GXmlElement* _tmp80_ = NULL;
					GXmlElement* _tmp81_ = NULL;
					GXmlNode* _tmp82_ = NULL;
					g_value_init (&_tmp68_, G_TYPE_OBJECT);
					G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
					val = _tmp68_;
					_tmp69_ = val;
					_tmp70_ = prop;
					gxml_serializable_json_get_property_value (self, _tmp70_, &val);
					_tmp71_ = g_value_get_object (&val);
					_tmp72_ = _g_object_ref0 (_tmp71_);
					_g_object_unref0 (child_object);
					child_object = _tmp72_;
					_tmp73_ = child_object;
					_tmp74_ = gxml_serialization_serialize_object (_tmp73_, &_inner_error_);
					value_doc = _tmp74_;
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (child_object);
						_g_object_unref0 (doc);
						_g_object_unref0 (prop_node);
						_g_object_unref0 (value_node);
						G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
						return NULL;
					}
					_tmp75_ = doc;
					_tmp76_ = gxml_document_create_element (_tmp75_, "fake");
					_tmp77_ = _g_object_ref0 ((GXmlNode*) _tmp76_);
					_g_object_unref0 (value_node);
					value_node = _tmp77_;
					_tmp78_ = value_doc;
					_tmp79_ = gxml_document_get_document_element (_tmp78_);
					_tmp80_ = _tmp79_;
					gxml_node_copy ((GXmlNode*) _tmp80_, &value_node, TRUE);
					_tmp81_ = prop_node;
					_tmp82_ = value_node;
					gxml_node_append_child ((GXmlNode*) _tmp81_, _tmp82_);
					result = (GXmlNode*) prop_node;
					_g_object_unref0 (value_doc);
					_g_object_unref0 (child_object);
					_g_object_unref0 (doc);
					_g_object_unref0 (value_node);
					G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
					return result;
				}
			}
		}
	}
	_tmp83_ = prop_node;
	_tmp84_ = prop;
	g_signal_emit_by_name ((GXmlSerializable*) self, "serialize-unknown-property-type", (GXmlNode*) _tmp83_, _tmp84_, &_tmp85_);
	_g_object_unref0 (value_node);
	value_node = _tmp85_;
	result = (GXmlNode*) prop_node;
	_g_object_unref0 (doc);
	_g_object_unref0 (value_node);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	return result;
}


GXmlNode* gxml_serializable_json_serialize_property (GXmlSerializableJson* self, GXmlElement* element, GParamSpec* prop, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_JSON_GET_CLASS (self)->serialize_property (self, element, prop, error);
}


static GXmlNode* gxml_serializable_json_real_deserialize (GXmlSerializable* base, GXmlNode* node, GError** error) {
	GXmlSerializableJson * self;
	GXmlNode* result = NULL;
	GXmlElement* obj_elem = NULL;
	GParamSpec** specs = NULL;
	gint specs_length1 = 0;
	gint _specs_size_ = 0;
	GXmlNode* _tmp0_ = NULL;
	gint _tmp9_ = 0;
	GParamSpec** _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
	self = (GXmlSerializableJson*) base;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = node;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GXML_TYPE_DOCUMENT)) {
		GXmlNode* _tmp1_ = NULL;
		GXmlDocument* _tmp2_ = NULL;
		GXmlDocument* _tmp3_ = NULL;
		GXmlElement* _tmp4_ = NULL;
		GXmlElement* _tmp5_ = NULL;
		GXmlElement* _tmp6_ = NULL;
		_tmp1_ = node;
		_tmp2_ = gxml_node_get_owner_document (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = gxml_document_get_document_element (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_g_object_unref0 (obj_elem);
		obj_elem = _tmp6_;
	} else {
		GXmlNode* _tmp7_ = NULL;
		GXmlElement* _tmp8_ = NULL;
		_tmp7_ = node;
		_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GXML_TYPE_ELEMENT, GXmlElement));
		_g_object_unref0 (obj_elem);
		obj_elem = _tmp8_;
	}
	_tmp10_ = gxml_serializable_json_list_serializable_properties (self, &_tmp9_);
	specs = (_vala_array_free (specs, specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	specs = _tmp10_;
	specs_length1 = _tmp9_;
	_specs_size_ = specs_length1;
	{
		GXmlNodeList* _child_node_list = NULL;
		GXmlElement* _tmp11_ = NULL;
		GXmlNodeList* _tmp12_ = NULL;
		GXmlNodeList* _tmp13_ = NULL;
		gint _child_node_size = 0;
		GXmlNodeList* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gint _child_node_index = 0;
		_tmp11_ = obj_elem;
		_tmp12_ = gxml_node_get_child_nodes ((GXmlNode*) _tmp11_);
		_tmp13_ = _tmp12_;
		_child_node_list = _tmp13_;
		_tmp14_ = _child_node_list;
		_tmp15_ = gee_collection_get_size ((GeeCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_child_node_size = _tmp16_;
		_child_node_index = -1;
		while (TRUE) {
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			GXmlNode* child_node = NULL;
			GXmlNodeList* _tmp20_ = NULL;
			gint _tmp21_ = 0;
			GXmlNode* _tmp22_ = NULL;
			GXmlNode* _tmp23_ = NULL;
			_tmp17_ = _child_node_index;
			_child_node_index = _tmp17_ + 1;
			_tmp18_ = _child_node_index;
			_tmp19_ = _child_node_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _child_node_list;
			_tmp21_ = _child_node_index;
			_tmp22_ = gxml_node_list_get (_tmp20_, _tmp21_);
			child_node = _tmp22_;
			_tmp23_ = child_node;
			gxml_serializable_json_deserialize_property (self, _tmp23_, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (child_node);
				_g_object_unref0 (_child_node_list);
				specs = (_vala_array_free (specs, specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
				_g_object_unref0 (obj_elem);
				return NULL;
			}
			_g_object_unref0 (child_node);
		}
		_g_object_unref0 (_child_node_list);
	}
	result = (GXmlNode*) obj_elem;
	specs = (_vala_array_free (specs, specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	return result;
}


static gboolean gxml_serializable_json_real_deserialize_property (GXmlSerializableJson* self, GXmlNode* property_node, GError** error) {
	gboolean result = FALSE;
	GXmlNode* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (property_node != NULL, FALSE);
	_tmp0_ = property_node;
	_tmp1_ = gxml_node_get_node_name (_tmp0_);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, "Property") == 0) {
		GXmlElement* prop_elem = NULL;
		gchar* pname = NULL;
		gchar* ptype = NULL;
		GType type = 0UL;
		GValue val = {0};
		GParamSpec* spec = NULL;
		GXmlNode* _tmp3_ = NULL;
		GXmlElement* _tmp4_ = NULL;
		GXmlElement* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		GXmlElement* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		GType _tmp10_ = 0UL;
		const gchar* _tmp11_ = NULL;
		GParamSpec* _tmp12_ = NULL;
		GParamSpec* _tmp13_ = NULL;
		_tmp3_ = property_node;
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GXML_TYPE_ELEMENT, GXmlElement));
		_g_object_unref0 (prop_elem);
		prop_elem = _tmp4_;
		_tmp5_ = prop_elem;
		_tmp6_ = gxml_element_get_attribute (_tmp5_, "pname");
		_g_free0 (pname);
		pname = _tmp6_;
		_tmp7_ = prop_elem;
		_tmp8_ = gxml_element_get_attribute (_tmp7_, "ptype");
		_g_free0 (ptype);
		ptype = _tmp8_;
		_tmp9_ = ptype;
		_tmp10_ = g_type_from_name (_tmp9_);
		type = _tmp10_;
		_tmp11_ = pname;
		_tmp12_ = gxml_serializable_json_find_property_spec (self, _tmp11_);
		_g_param_spec_unref0 (spec);
		spec = _tmp12_;
		_tmp13_ = spec;
		if (_tmp13_ == NULL) {
			const gchar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			GXmlNode* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			GHashTable* _tmp19_ = NULL;
			GHashTable* _tmp20_ = NULL;
			GXmlNode* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			GXmlNode* _tmp25_ = NULL;
			GXmlNode* _tmp26_ = NULL;
			_tmp14_ = ptype;
			_tmp15_ = pname;
			_tmp16_ = property_node;
			_tmp17_ = gxml_node_to_string (_tmp16_, FALSE, 0);
			_tmp18_ = _tmp17_;
			g_message ("SerializableJson.vala:251: Deserializing object of type '%s' claimed u" \
"nknown property named '%s'\n" \
"XML [%s]", _tmp14_, _tmp15_, _tmp18_);
			_g_free0 (_tmp18_);
			_tmp19_ = gxml_serializable_get_unknown_serializable_property ((GXmlSerializable*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = property_node;
			_tmp22_ = gxml_node_get_node_name (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = g_strdup (_tmp23_);
			_tmp25_ = property_node;
			_tmp26_ = _g_object_ref0 (_tmp25_);
			g_hash_table_insert (_tmp20_, _tmp24_, _tmp26_);
		} else {
			GParamSpec* _tmp27_ = NULL;
			GType _tmp28_ = 0UL;
			gboolean _tmp29_ = FALSE;
			_tmp27_ = spec;
			_tmp28_ = _tmp27_->value_type;
			_tmp29_ = g_type_is_a (_tmp28_, GXML_TYPE_SERIALIZABLE);
			if (_tmp29_) {
				GValue vobj = {0};
				GParamSpec* _tmp30_ = NULL;
				GType _tmp31_ = 0UL;
				GValue _tmp32_ = {0};
				const gchar* _tmp33_ = NULL;
				GValue _tmp34_ = {0};
				GXmlNode* _tmp35_ = NULL;
				GXmlNode* _tmp36_ = NULL;
				GXmlNode* _tmp37_ = NULL;
				_tmp30_ = spec;
				_tmp31_ = _tmp30_->value_type;
				g_value_init (&_tmp32_, _tmp31_);
				vobj = _tmp32_;
				_tmp33_ = pname;
				g_object_get_property ((GObject*) self, _tmp33_, &vobj);
				_tmp34_ = vobj;
				_tmp35_ = property_node;
				_tmp36_ = gxml_serializable_deserialize (g_value_get_object (&_tmp34_), _tmp35_, &_inner_error_);
				_tmp37_ = _tmp36_;
				_g_object_unref0 (_tmp37_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					G_IS_VALUE (&vobj) ? (g_value_unset (&vobj), NULL) : NULL;
					_g_param_spec_unref0 (spec);
					G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
					_g_free0 (ptype);
					_g_free0 (pname);
					_g_object_unref0 (prop_elem);
					return FALSE;
				}
				G_IS_VALUE (&vobj) ? (g_value_unset (&vobj), NULL) : NULL;
			} else {
				GType _tmp38_ = 0UL;
				GValue _tmp39_ = {0};
				GValue _tmp40_ = {0};
				gboolean _tmp41_ = FALSE;
				GXmlElement* _tmp42_ = NULL;
				gchar* _tmp43_ = NULL;
				gchar* _tmp44_ = NULL;
				gchar* _tmp45_ = NULL;
				gboolean _tmp46_ = FALSE;
				gboolean _tmp47_ = FALSE;
				_tmp38_ = type;
				g_value_init (&_tmp39_, _tmp38_);
				G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
				val = _tmp39_;
				_tmp40_ = val;
				_tmp42_ = prop_elem;
				_tmp43_ = gxml_element_get_content (_tmp42_);
				_tmp44_ = _tmp43_;
				_tmp45_ = _tmp44_;
				_tmp46_ = gxml_serializable_json_transform_from_string (self, _tmp45_, &val, &_inner_error_);
				_tmp47_ = _tmp46_;
				_g_free0 (_tmp45_);
				_tmp41_ = _tmp47_;
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_param_spec_unref0 (spec);
					G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
					_g_free0 (ptype);
					_g_free0 (pname);
					_g_object_unref0 (prop_elem);
					return FALSE;
				}
				if (_tmp41_) {
					GParamSpec* _tmp48_ = NULL;
					GValue _tmp49_ = {0};
					_tmp48_ = spec;
					_tmp49_ = val;
					gxml_serializable_json_set_property_value (self, _tmp48_, &_tmp49_);
					result = TRUE;
					_g_param_spec_unref0 (spec);
					G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
					_g_free0 (ptype);
					_g_free0 (pname);
					_g_object_unref0 (prop_elem);
					return result;
				} else {
					GType _tmp50_ = 0UL;
					gboolean _tmp51_ = FALSE;
					_tmp50_ = type;
					_tmp51_ = g_value_type_transformable (_tmp50_, G_TYPE_STRING);
					if (_tmp51_) {
						GXmlElement* _tmp52_ = NULL;
						gchar* _tmp53_ = NULL;
						gchar* _tmp54_ = NULL;
						gchar* _tmp55_ = NULL;
						GParamSpec* _tmp56_ = NULL;
						GValue _tmp57_ = {0};
						_tmp52_ = prop_elem;
						_tmp53_ = gxml_element_get_content (_tmp52_);
						_tmp54_ = _tmp53_;
						_tmp55_ = _tmp54_;
						gxml_serializable_string_to_gvalue (_tmp55_, &val, &_inner_error_);
						_g_free0 (_tmp55_);
						if (_inner_error_ != NULL) {
							g_propagate_error (error, _inner_error_);
							_g_param_spec_unref0 (spec);
							G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
							_g_free0 (ptype);
							_g_free0 (pname);
							_g_object_unref0 (prop_elem);
							return FALSE;
						}
						_tmp56_ = spec;
						_tmp57_ = val;
						gxml_serializable_json_set_property_value (self, _tmp56_, &_tmp57_);
					} else {
						GType _tmp58_ = 0UL;
						gboolean _tmp59_ = FALSE;
						_tmp58_ = type;
						_tmp59_ = g_type_is_a (_tmp58_, G_TYPE_OBJECT);
						if (_tmp59_) {
							GXmlNode* prop_elem_child = NULL;
							GObject* property_object = NULL;
							GXmlElement* _tmp60_ = NULL;
							GXmlNode* _tmp61_ = NULL;
							GXmlNode* _tmp62_ = NULL;
							GXmlNode* _tmp63_ = NULL;
							GObject* _tmp64_ = NULL;
							GXmlNode* _tmp65_ = NULL;
							GObject* _tmp66_ = NULL;
							GObject* _tmp67_ = NULL;
							_tmp60_ = prop_elem;
							_tmp61_ = gxml_node_get_first_child ((GXmlNode*) _tmp60_);
							_tmp62_ = _tmp61_;
							_tmp63_ = _g_object_ref0 (_tmp62_);
							_g_object_unref0 (prop_elem_child);
							prop_elem_child = _tmp63_;
							_tmp65_ = prop_elem_child;
							_tmp66_ = gxml_serialization_deserialize_object_from_node (_tmp65_, &_inner_error_);
							_tmp64_ = _tmp66_;
							if (_inner_error_ != NULL) {
								g_propagate_error (error, _inner_error_);
								_g_object_unref0 (property_object);
								_g_object_unref0 (prop_elem_child);
								_g_param_spec_unref0 (spec);
								G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
								_g_free0 (ptype);
								_g_free0 (pname);
								_g_object_unref0 (prop_elem);
								return FALSE;
							}
							_g_object_unref0 (property_object);
							property_object = _tmp64_;
							_tmp67_ = property_object;
							g_value_set_object (&val, _tmp67_);
							result = TRUE;
							_g_object_unref0 (property_object);
							_g_object_unref0 (prop_elem_child);
							_g_param_spec_unref0 (spec);
							G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
							_g_free0 (ptype);
							_g_free0 (pname);
							_g_object_unref0 (prop_elem);
							return result;
						} else {
							GXmlElement* _tmp68_ = NULL;
							GParamSpec* _tmp69_ = NULL;
							_tmp68_ = prop_elem;
							_tmp69_ = spec;
							g_signal_emit_by_name ((GXmlSerializable*) self, "deserialize-unknown-property-type", (GXmlNode*) _tmp68_, _tmp69_);
							result = FALSE;
							_g_param_spec_unref0 (spec);
							G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
							_g_free0 (ptype);
							_g_free0 (pname);
							_g_object_unref0 (prop_elem);
							return result;
						}
					}
				}
			}
		}
		result = TRUE;
		_g_param_spec_unref0 (spec);
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
		_g_free0 (ptype);
		_g_free0 (pname);
		_g_object_unref0 (prop_elem);
		return result;
	}
	result = FALSE;
	return result;
}


gboolean gxml_serializable_json_deserialize_property (GXmlSerializableJson* self, GXmlNode* property_node, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_JSON_GET_CLASS (self)->deserialize_property (self, property_node, error);
}


GXmlSerializableJson* gxml_serializable_json_construct (GType object_type) {
	GXmlSerializableJson * self = NULL;
	self = (GXmlSerializableJson*) g_object_new (object_type, NULL);
	return self;
}


GXmlSerializableJson* gxml_serializable_json_new (void) {
	return gxml_serializable_json_construct (GXML_TYPE_SERIALIZABLE_JSON);
}


static GParamSpec** gxml_serializable_json_real_get_properties (GXmlSerializable* base, int* result_length1) {
	GParamSpec** result;
	GXmlSerializableJson* self;
	GParamSpec** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GParamSpec** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	self = (GXmlSerializableJson*) base;
	_tmp0_ = self->priv->_properties;
	_tmp0__length1 = self->priv->_properties_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static GParamSpec** _vala_array_dup3 (GParamSpec** self, int length) {
	GParamSpec** result;
	int i;
	result = g_new0 (GParamSpec*, length + 1);
	for (i = 0; i < length; i++) {
		GParamSpec* _tmp0_ = NULL;
		_tmp0_ = _g_param_spec_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void gxml_serializable_json_real_set_properties (GXmlSerializable* base, GParamSpec** value, int value_length1) {
	GXmlSerializableJson* self;
	GParamSpec** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GParamSpec** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	self = (GXmlSerializableJson*) base;
	_tmp0_ = value;
	_tmp0__length1 = value_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup3 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->_properties = (_vala_array_free (self->priv->_properties, self->priv->_properties_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	self->priv->_properties = _tmp1_;
	self->priv->_properties_length1 = _tmp1__length1;
	self->priv->__properties_size_ = self->priv->_properties_length1;
}


static GHashTable* gxml_serializable_json_real_get_ignored_serializable_properties (GXmlSerializable* base) {
	GHashTable* result;
	GXmlSerializableJson* self;
	GHashTable* _tmp0_ = NULL;
	self = (GXmlSerializableJson*) base;
	_tmp0_ = self->priv->_ignored_serializable_properties;
	result = _tmp0_;
	return result;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void gxml_serializable_json_real_set_ignored_serializable_properties (GXmlSerializable* base, GHashTable* value) {
	GXmlSerializableJson* self;
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	self = (GXmlSerializableJson*) base;
	_tmp0_ = value;
	_tmp1_ = _g_hash_table_ref0 (_tmp0_);
	_g_hash_table_unref0 (self->priv->_ignored_serializable_properties);
	self->priv->_ignored_serializable_properties = _tmp1_;
	g_object_notify ((GObject *) self, "ignored-serializable-properties");
}


static GHashTable* gxml_serializable_json_real_get_unknown_serializable_property (GXmlSerializable* base) {
	GHashTable* result;
	GXmlSerializableJson* self;
	GHashTable* _tmp0_ = NULL;
	self = (GXmlSerializableJson*) base;
	_tmp0_ = self->priv->_unknown_serializable_property;
	result = _tmp0_;
	return result;
}


static void gxml_serializable_json_real_set_unknown_serializable_property (GXmlSerializable* base, GHashTable* value) {
	GXmlSerializableJson* self;
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	self = (GXmlSerializableJson*) base;
	_tmp0_ = value;
	_tmp1_ = _g_hash_table_ref0 (_tmp0_);
	_g_hash_table_unref0 (self->priv->_unknown_serializable_property);
	self->priv->_unknown_serializable_property = _tmp1_;
	g_object_notify ((GObject *) self, "unknown-serializable-property");
}


static const gchar* gxml_serializable_json_real_get_serialized_xml_node_value (GXmlSerializable* base) {
	const gchar* result;
	GXmlSerializableJson* self;
	const gchar* _tmp0_ = NULL;
	self = (GXmlSerializableJson*) base;
	_tmp0_ = self->priv->_serialized_xml_node_value;
	result = _tmp0_;
	return result;
}


static void gxml_serializable_json_real_set_serialized_xml_node_value (GXmlSerializable* base, const gchar* value) {
	GXmlSerializableJson* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (GXmlSerializableJson*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_serialized_xml_node_value);
	self->priv->_serialized_xml_node_value = _tmp1_;
	g_object_notify ((GObject *) self, "serialized-xml-node-value");
}


static void gxml_serializable_json_class_init (GXmlSerializableJsonClass * klass) {
	gxml_serializable_json_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GXmlSerializableJsonPrivate));
	GXML_SERIALIZABLE_JSON_CLASS (klass)->get_enable_unknown_serializable_property = gxml_serializable_json_real_get_enable_unknown_serializable_property;
	GXML_SERIALIZABLE_JSON_CLASS (klass)->serialize_use_xml_node_value = gxml_serializable_json_real_serialize_use_xml_node_value;
	GXML_SERIALIZABLE_JSON_CLASS (klass)->node_name = gxml_serializable_json_real_node_name;
	GXML_SERIALIZABLE_JSON_CLASS (klass)->property_use_nick = gxml_serializable_json_real_property_use_nick;
	GXML_SERIALIZABLE_JSON_CLASS (klass)->find_property_spec = gxml_serializable_json_real_find_property_spec;
	GXML_SERIALIZABLE_JSON_CLASS (klass)->init_properties = gxml_serializable_json_real_init_properties;
	GXML_SERIALIZABLE_JSON_CLASS (klass)->list_serializable_properties = gxml_serializable_json_real_list_serializable_properties;
	GXML_SERIALIZABLE_JSON_CLASS (klass)->get_property_value = gxml_serializable_json_real_get_property_value;
	GXML_SERIALIZABLE_JSON_CLASS (klass)->set_property_value = gxml_serializable_json_real_set_property_value;
	GXML_SERIALIZABLE_JSON_CLASS (klass)->transform_from_string = gxml_serializable_json_real_transform_from_string;
	GXML_SERIALIZABLE_JSON_CLASS (klass)->transform_to_string = gxml_serializable_json_real_transform_to_string;
	GXML_SERIALIZABLE_JSON_CLASS (klass)->serialize_property = gxml_serializable_json_real_serialize_property;
	GXML_SERIALIZABLE_JSON_CLASS (klass)->deserialize_property = gxml_serializable_json_real_deserialize_property;
	G_OBJECT_CLASS (klass)->get_property = _vala_gxml_serializable_json_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gxml_serializable_json_set_property;
	G_OBJECT_CLASS (klass)->finalize = gxml_serializable_json_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_SERIALIZABLE_JSON_IGNORED_SERIALIZABLE_PROPERTIES, g_param_spec_boxed ("ignored-serializable-properties", "ignored-serializable-properties", "ignored-serializable-properties", G_TYPE_HASH_TABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_SERIALIZABLE_JSON_UNKNOWN_SERIALIZABLE_PROPERTY, g_param_spec_boxed ("unknown-serializable-property", "unknown-serializable-property", "unknown-serializable-property", G_TYPE_HASH_TABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_SERIALIZABLE_JSON_SERIALIZED_XML_NODE_VALUE, g_param_spec_string ("serialized-xml-node-value", "serialized-xml-node-value", "serialized-xml-node-value", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gxml_serializable_json_gxml_serializable_interface_init (GXmlSerializableIface * iface) {
	gxml_serializable_json_gxml_serializable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_enable_unknown_serializable_property = (gboolean (*)(GXmlSerializable*)) gxml_serializable_json_get_enable_unknown_serializable_property;
	iface->serialize_use_xml_node_value = (gboolean (*)(GXmlSerializable*)) gxml_serializable_json_serialize_use_xml_node_value;
	iface->node_name = (gchar* (*)(GXmlSerializable*)) gxml_serializable_json_node_name;
	iface->property_use_nick = (gboolean (*)(GXmlSerializable*)) gxml_serializable_json_property_use_nick;
	iface->find_property_spec = (GParamSpec* (*)(GXmlSerializable*, const gchar*)) gxml_serializable_json_find_property_spec;
	iface->init_properties = (void (*)(GXmlSerializable*)) gxml_serializable_json_init_properties;
	iface->list_serializable_properties = (GParamSpec** (*)(GXmlSerializable*, int*)) gxml_serializable_json_list_serializable_properties;
	iface->get_property_value = (void (*)(GXmlSerializable*, GParamSpec*, GValue*)) gxml_serializable_json_get_property_value;
	iface->set_property_value = (void (*)(GXmlSerializable*, GParamSpec*, GValue*)) gxml_serializable_json_set_property_value;
	iface->transform_from_string = (gboolean (*)(GXmlSerializable*, const gchar*, GValue*, GError**)) gxml_serializable_json_transform_from_string;
	iface->transform_to_string = (gboolean (*)(GXmlSerializable*, GValue*, gchar**, GError**)) gxml_serializable_json_transform_to_string;
	iface->serialize = (GXmlNode* (*)(GXmlSerializable*, GXmlNode*, GError**)) gxml_serializable_json_real_serialize;
	iface->serialize_property = (GXmlNode* (*)(GXmlSerializable*, GXmlElement*, GParamSpec*, GError**)) gxml_serializable_json_serialize_property;
	iface->deserialize = (GXmlNode* (*)(GXmlSerializable*, GXmlNode*, GError**)) gxml_serializable_json_real_deserialize;
	iface->deserialize_property = (gboolean (*)(GXmlSerializable*, GXmlNode*, GError**)) gxml_serializable_json_deserialize_property;
	iface->get_properties = gxml_serializable_json_real_get_properties;
	iface->set_properties = gxml_serializable_json_real_set_properties;
	iface->get_ignored_serializable_properties = gxml_serializable_json_real_get_ignored_serializable_properties;
	iface->set_ignored_serializable_properties = gxml_serializable_json_real_set_ignored_serializable_properties;
	iface->get_unknown_serializable_property = gxml_serializable_json_real_get_unknown_serializable_property;
	iface->set_unknown_serializable_property = gxml_serializable_json_real_set_unknown_serializable_property;
	iface->get_serialized_xml_node_value = gxml_serializable_json_real_get_serialized_xml_node_value;
	iface->set_serialized_xml_node_value = gxml_serializable_json_real_set_serialized_xml_node_value;
}


static void gxml_serializable_json_instance_init (GXmlSerializableJson * self) {
	self->priv = GXML_SERIALIZABLE_JSON_GET_PRIVATE (self);
	self->priv->_serialized_xml_node_value = NULL;
}


static void gxml_serializable_json_finalize (GObject* obj) {
	GXmlSerializableJson * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GXML_TYPE_SERIALIZABLE_JSON, GXmlSerializableJson);
	self->priv->_properties = (_vala_array_free (self->priv->_properties, self->priv->_properties_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	_g_hash_table_unref0 (self->priv->_ignored_serializable_properties);
	_g_hash_table_unref0 (self->priv->_unknown_serializable_property);
	_g_free0 (self->priv->_serialized_xml_node_value);
	G_OBJECT_CLASS (gxml_serializable_json_parent_class)->finalize (obj);
}


/**
 * Serializes and deserializes {@link GLib.Object}s to and from
 * {@link GXml.Node}.
 *
 * Serialization can automatically serialize a variety of public
 * properties.  {@link GLib.Object}s can also implement the
 * {@link GXml.Serializable} to partially or completely manage
 * serialization themselves, including non-public properties or
 * data types not automatically supported by {@link GXml.Serialization}.
 */
GType gxml_serializable_json_get_type (void) {
	static volatile gsize gxml_serializable_json_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_serializable_json_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlSerializableJsonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gxml_serializable_json_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GXmlSerializableJson), 0, (GInstanceInitFunc) gxml_serializable_json_instance_init, NULL };
		static const GInterfaceInfo gxml_serializable_info = { (GInterfaceInitFunc) gxml_serializable_json_gxml_serializable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gxml_serializable_json_type_id;
		gxml_serializable_json_type_id = g_type_register_static (G_TYPE_OBJECT, "GXmlSerializableJson", &g_define_type_info, 0);
		g_type_add_interface_static (gxml_serializable_json_type_id, GXML_TYPE_SERIALIZABLE, &gxml_serializable_info);
		g_once_init_leave (&gxml_serializable_json_type_id__volatile, gxml_serializable_json_type_id);
	}
	return gxml_serializable_json_type_id__volatile;
}


static void _vala_gxml_serializable_json_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GXmlSerializableJson * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GXML_TYPE_SERIALIZABLE_JSON, GXmlSerializableJson);
	switch (property_id) {
		case GXML_SERIALIZABLE_JSON_IGNORED_SERIALIZABLE_PROPERTIES:
		g_value_set_boxed (value, gxml_serializable_get_ignored_serializable_properties ((GXmlSerializable*) self));
		break;
		case GXML_SERIALIZABLE_JSON_UNKNOWN_SERIALIZABLE_PROPERTY:
		g_value_set_boxed (value, gxml_serializable_get_unknown_serializable_property ((GXmlSerializable*) self));
		break;
		case GXML_SERIALIZABLE_JSON_SERIALIZED_XML_NODE_VALUE:
		g_value_set_string (value, gxml_serializable_get_serialized_xml_node_value ((GXmlSerializable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gxml_serializable_json_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GXmlSerializableJson * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GXML_TYPE_SERIALIZABLE_JSON, GXmlSerializableJson);
	switch (property_id) {
		case GXML_SERIALIZABLE_JSON_IGNORED_SERIALIZABLE_PROPERTIES:
		gxml_serializable_set_ignored_serializable_properties ((GXmlSerializable*) self, g_value_get_boxed (value));
		break;
		case GXML_SERIALIZABLE_JSON_UNKNOWN_SERIALIZABLE_PROPERTY:
		gxml_serializable_set_unknown_serializable_property ((GXmlSerializable*) self, g_value_get_boxed (value));
		break;
		case GXML_SERIALIZABLE_JSON_SERIALIZED_XML_NODE_VALUE:
		gxml_serializable_set_serialized_xml_node_value ((GXmlSerializable*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



