/* Serializable.c generated by valac 0.22.1, the Vala compiler
 * generated from Serializable.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; c-basic-offset: 3; tab-width: 3 -*- */
/* Serializable.vala
 *
 * Copyright (C) 2013  Daniel Espinosa <esodan@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      Daniel Espinosa <esodan@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>


#define GXML_TYPE_SERIALIZABLE (gxml_serializable_get_type ())
#define GXML_SERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE, GXmlSerializable))
#define GXML_IS_SERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE))
#define GXML_SERIALIZABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_SERIALIZABLE, GXmlSerializableIface))

typedef struct _GXmlSerializable GXmlSerializable;
typedef struct _GXmlSerializableIface GXmlSerializableIface;

#define GXML_TYPE_NODE (gxml_node_get_type ())
#define GXML_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NODE, GXmlNode))
#define GXML_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_NODE, GXmlNodeClass))
#define GXML_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NODE))
#define GXML_IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_NODE))
#define GXML_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_NODE, GXmlNodeClass))

typedef struct _GXmlNode GXmlNode;
typedef struct _GXmlNodeClass GXmlNodeClass;

#define GXML_TYPE_BACKED_NODE (gxml_backed_node_get_type ())
#define GXML_BACKED_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_BACKED_NODE, GXmlBackedNode))
#define GXML_BACKED_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_BACKED_NODE, GXmlBackedNodeClass))
#define GXML_IS_BACKED_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_BACKED_NODE))
#define GXML_IS_BACKED_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_BACKED_NODE))
#define GXML_BACKED_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_BACKED_NODE, GXmlBackedNodeClass))

typedef struct _GXmlBackedNode GXmlBackedNode;
typedef struct _GXmlBackedNodeClass GXmlBackedNodeClass;

#define GXML_TYPE_ELEMENT (gxml_element_get_type ())
#define GXML_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ELEMENT, GXmlElement))
#define GXML_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_ELEMENT, GXmlElementClass))
#define GXML_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ELEMENT))
#define GXML_IS_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_ELEMENT))
#define GXML_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_ELEMENT, GXmlElementClass))

typedef struct _GXmlElement GXmlElement;
typedef struct _GXmlElementClass GXmlElementClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_param_spec_unref0(var) ((var == NULL) ? NULL : (var = (g_param_spec_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

struct _GXmlSerializableIface {
	GTypeInterface parent_iface;
	gboolean (*get_enable_unknown_serializable_property) (GXmlSerializable* self);
	gboolean (*serialize_use_xml_node_value) (GXmlSerializable* self);
	gchar* (*node_name) (GXmlSerializable* self);
	gboolean (*property_use_nick) (GXmlSerializable* self);
	GXmlNode* (*serialize) (GXmlSerializable* self, GXmlNode* node, GError** error);
	GXmlNode* (*serialize_property) (GXmlSerializable* self, GXmlElement* element, GParamSpec* prop, GError** error);
	GXmlNode* (*deserialize) (GXmlSerializable* self, GXmlNode* node, GError** error);
	gboolean (*deserialize_property) (GXmlSerializable* self, GXmlNode* property_node, GError** error);
	GParamSpec* (*find_property_spec) (GXmlSerializable* self, const gchar* property_name);
	GParamSpec* (*default_find_property_spec) (GXmlSerializable* self, const gchar* property_name);
	void (*init_properties) (GXmlSerializable* self);
	void (*default_init_properties) (GXmlSerializable* self);
	GParamSpec** (*list_serializable_properties) (GXmlSerializable* self, int* result_length1);
	GParamSpec** (*default_list_serializable_properties) (GXmlSerializable* self, int* result_length1);
	void (*get_property_value) (GXmlSerializable* self, GParamSpec* spec, GValue* val);
	void (*default_get_property_value) (GXmlSerializable* self, GParamSpec* spec, GValue* val);
	void (*set_property_value) (GXmlSerializable* self, GParamSpec* spec, GValue* val);
	void (*default_set_property_value) (GXmlSerializable* self, GParamSpec* spec, GValue* val);
	gboolean (*transform_from_string) (GXmlSerializable* self, const gchar* str, GValue* dest, GError** error);
	gboolean (*transform_to_string) (GXmlSerializable* self, GValue* val, gchar** str, GError** error);
	GParamSpec** (*get_properties) (GXmlSerializable* self, int* result_length1);
	void (*set_properties) (GXmlSerializable* self, GParamSpec** value, int value_length1);
	GHashTable* (*get_ignored_serializable_properties) (GXmlSerializable* self);
	void (*set_ignored_serializable_properties) (GXmlSerializable* self, GHashTable* value);
	GHashTable* (*get_unknown_serializable_property) (GXmlSerializable* self);
	void (*set_unknown_serializable_property) (GXmlSerializable* self, GHashTable* value);
	const gchar* (*get_serialized_xml_node_value) (GXmlSerializable* self);
	void (*set_serialized_xml_node_value) (GXmlSerializable* self, const gchar* value);
};

typedef enum  {
	GXML_SERIALIZABLE_ERROR_UNSUPPORTED_TYPE_ERROR,
	GXML_SERIALIZABLE_ERROR_STR_TO_VALUE_ERROR
} GXmlSerializableError;
#define GXML_SERIALIZABLE_ERROR gxml_serializable_error_quark ()
/**
   * Errors from {@link Serialization}.
   */


GType gxml_node_get_type (void) G_GNUC_CONST;
GType gxml_backed_node_get_type (void) G_GNUC_CONST;
GType gxml_element_get_type (void) G_GNUC_CONST;
GType gxml_serializable_get_type (void) G_GNUC_CONST;
gboolean gxml_serializable_get_enable_unknown_serializable_property (GXmlSerializable* self);
gboolean gxml_serializable_serialize_use_xml_node_value (GXmlSerializable* self);
gchar* gxml_serializable_node_name (GXmlSerializable* self);
gboolean gxml_serializable_property_use_nick (GXmlSerializable* self);
GXmlNode* gxml_serializable_serialize (GXmlSerializable* self, GXmlNode* node, GError** error);
GXmlNode* gxml_serializable_serialize_property (GXmlSerializable* self, GXmlElement* element, GParamSpec* prop, GError** error);
GXmlNode* gxml_serializable_deserialize (GXmlSerializable* self, GXmlNode* node, GError** error);
gboolean gxml_serializable_deserialize_property (GXmlSerializable* self, GXmlNode* property_node, GError** error);
GParamSpec* gxml_serializable_find_property_spec (GXmlSerializable* self, const gchar* property_name);
GParamSpec* gxml_serializable_default_find_property_spec (GXmlSerializable* self, const gchar* property_name);
static GParamSpec* gxml_serializable_real_default_find_property_spec (GXmlSerializable* self, const gchar* property_name);
void gxml_serializable_init_properties (GXmlSerializable* self);
GParamSpec** gxml_serializable_list_serializable_properties (GXmlSerializable* self, int* result_length1);
void gxml_serializable_default_init_properties (GXmlSerializable* self);
static void gxml_serializable_real_default_init_properties (GXmlSerializable* self);
GHashTable* gxml_serializable_get_ignored_serializable_properties (GXmlSerializable* self);
static void _g_free0_ (gpointer var);
static void _g_param_spec_unref0_ (gpointer var);
void gxml_serializable_set_ignored_serializable_properties (GXmlSerializable* self, GHashTable* value);
GHashTable* gxml_serializable_get_unknown_serializable_property (GXmlSerializable* self);
static void _g_object_unref0_ (gpointer var);
void gxml_serializable_set_unknown_serializable_property (GXmlSerializable* self, GHashTable* value);
GParamSpec** gxml_serializable_default_list_serializable_properties (GXmlSerializable* self, int* result_length1);
static GParamSpec** gxml_serializable_real_default_list_serializable_properties (GXmlSerializable* self, int* result_length1);
GParamSpec** gxml_serializable_get_properties (GXmlSerializable* self, int* result_length1);
static void _vala_array_add1 (GParamSpec*** array, int* length, int* size, GParamSpec* value);
void gxml_serializable_set_properties (GXmlSerializable* self, GParamSpec** value, int value_length1);
static GParamSpec** _vala_array_dup1 (GParamSpec** self, int length);
void gxml_serializable_get_property_value (GXmlSerializable* self, GParamSpec* spec, GValue* val);
void gxml_serializable_default_get_property_value (GXmlSerializable* self, GParamSpec* spec, GValue* val);
static void gxml_serializable_real_default_get_property_value (GXmlSerializable* self, GParamSpec* spec, GValue* val);
void gxml_serializable_set_property_value (GXmlSerializable* self, GParamSpec* spec, GValue* val);
void gxml_serializable_default_set_property_value (GXmlSerializable* self, GParamSpec* spec, GValue* val);
static void gxml_serializable_real_default_set_property_value (GXmlSerializable* self, GParamSpec* spec, GValue* val);
gboolean gxml_serializable_transform_from_string (GXmlSerializable* self, const gchar* str, GValue* dest, GError** error);
GQuark gxml_serializable_error_quark (void);
gboolean gxml_serializable_string_to_gvalue (const gchar* str, GValue* dest, GError** error);
gboolean gxml_serializable_transform_to_string (GXmlSerializable* self, GValue* val, gchar** str, GError** error);
gchar* gxml_serializable_gvalue_to_string (GValue* val, GError** error);
const gchar* gxml_serializable_get_serialized_xml_node_value (GXmlSerializable* self);
void gxml_serializable_set_serialized_xml_node_value (GXmlSerializable* self, const gchar* value);
static void g_cclosure_user_marshal_VOID__OBJECT_G_PARAM_SPEC_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__OBJECT_G_PARAM_SPEC (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
      * Return {@link false} if you want to ignore unknown properties and {@link GXml.Node}'s
      * not in your class definition.
      *
      * Take care, disabling this feature you can lost data on serialization, because any unknown
      * property or element will be discarted.
      */
gboolean gxml_serializable_get_enable_unknown_serializable_property (GXmlSerializable* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->get_enable_unknown_serializable_property (self);
}


/**
     * Used to check {@link GXml.Element}'s contents must be deseralized.
     *
     * By default no contents is serialized/deseralized. Implementors must implement
     * this function returning {@link true} in order to use {@link serialized_xml_node_value}
     * property's value in serialization to set {@link GXml.Element}'s contents.
     *
     */
gboolean gxml_serializable_serialize_use_xml_node_value (GXmlSerializable* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->serialize_use_xml_node_value (self);
}


/**
     * Defines the way to set Node name.
     */
gchar* gxml_serializable_node_name (GXmlSerializable* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->node_name (self);
}


/**
     * Defines the way to set Node's property name, by using
     * it's nick instead of default name.
     */
gboolean gxml_serializable_property_use_nick (GXmlSerializable* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->property_use_nick (self);
}


/**
     * Serialize this object.
     *
     * @doc an {@link GXml.Document} object to serialize to 
     *
     * This method must call serialize_property() recursivally on all properties
     * to serialize.
     */
GXmlNode* gxml_serializable_serialize (GXmlSerializable* self, GXmlNode* node, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->serialize (self, node, error);
}


/**
     * Serialize a property @prop on a {@link GXml.Element}.
     *
     * This method is called recursivally by serialize() method over all properties
     * to be serialized.
     */
GXmlNode* gxml_serializable_serialize_property (GXmlSerializable* self, GXmlElement* element, GParamSpec* prop, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->serialize_property (self, element, prop, error);
}


/**
     * Deserialize this object.
     *
     * @node {@link GXml.Node} used to deserialize from.
     */
GXmlNode* gxml_serializable_deserialize (GXmlSerializable* self, GXmlNode* node, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->deserialize (self, node, error);
}


/**
     * Handles deserializing individual properties.
     *
     * Interface method to handle deserialization of an
     * individual property.  The implementing class
     * receives a description of the property and the
     * {@link GXml.Node} that contains the content.  The
     * implementing {@link GXml.Serializable} object can extract
     * the data from the {@link GXml.Node} and store it in its
     * property itself. Note that the {@link GXml.Node} may be
     * as simple as a {@link GXml.Text} that stores the data as a
     * string.
     *
     * Implementors:
     * Use Serializable.get_property_value in order to allow derived classes to
     * override the properties to serialize.
     *
     * @param property_name the name of the property as a string
     * @param spec the {@link GLib.ParamSpec} describing the property.
     * @param property_node the {@link GXml.Node} encapsulating data to deserialize
     * @return `true` if the property was handled, `false` if {@link GXml.Serialization} should handle it.
     */
gboolean gxml_serializable_deserialize_property (GXmlSerializable* self, GXmlNode* property_node, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->deserialize_property (self, property_node, error);
}


/**
     * Handles finding the {@link GLib.ParamSpec} for a given property.
     *
     * @param property_name the name of a property to obtain a {@link GLib.ParamSpec} for
     * @return a {@link GLib.ParamSpec} describing the named property
     *
     * {@link GXml.Serialization} uses {@link
     * GLib.ObjectClass.find_property} (as well as {@link
     * GLib.ObjectClass.list_properties}, {@link
     * GLib.Object.get_property}, and {@link
     * GLib.Object.set_property}) to manage serialization
     * of properties.  {@link GXml.Serializable} gives the
     * implementing class an opportunity to override
     * {@link GLib.ObjectClass.find_property} to control
     * what properties exist for {@link GXml.Serialization}'s
     * purposes.
     *
     * For instance, if an object has private data fields
     * that are not installed public properties, but that
     * should be serialized, find_property can be defined
     * to return a {@link GLib.ParamSpec} for non-installed
     * properties.  Other {@link GXml.Serializable} functions
     * should be consistent with it.
     *
     * An implementing class might wish to maintain such
     * {@link GLib.ParamSpec} s separately, rather than creating new
     * ones for each call.
     */
GParamSpec* gxml_serializable_find_property_spec (GXmlSerializable* self, const gchar* property_name) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->find_property_spec (self, property_name);
}


/**
     * Default implementation for find_property_spec ().
     *
     */
static gpointer _g_param_spec_ref0 (gpointer self) {
	return self ? g_param_spec_ref (self) : NULL;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_ = 0L;
	gboolean _tmp17_ = FALSE;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static GParamSpec* gxml_serializable_real_default_find_property_spec (GXmlSerializable* self, const gchar* property_name) {
	GParamSpec* result = NULL;
	GParamSpec** props = NULL;
	gint _tmp0_ = 0;
	GParamSpec** _tmp1_ = NULL;
	gint props_length1 = 0;
	gint _props_size_ = 0;
	GParamSpec** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	g_return_val_if_fail (property_name != NULL, NULL);
	gxml_serializable_init_properties (self);
	_tmp1_ = gxml_serializable_list_serializable_properties (self, &_tmp0_);
	props = _tmp1_;
	props_length1 = _tmp0_;
	_props_size_ = props_length1;
	_tmp2_ = props;
	_tmp2__length1 = props_length1;
	{
		GParamSpec** spec_collection = NULL;
		gint spec_collection_length1 = 0;
		gint _spec_collection_size_ = 0;
		gint spec_it = 0;
		spec_collection = _tmp2_;
		spec_collection_length1 = _tmp2__length1;
		for (spec_it = 0; spec_it < _tmp2__length1; spec_it = spec_it + 1) {
			GParamSpec* _tmp3_ = NULL;
			GParamSpec* spec = NULL;
			_tmp3_ = _g_param_spec_ref0 (spec_collection[spec_it]);
			spec = _tmp3_;
			{
				GParamSpec* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_ = NULL;
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				GParamSpec* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				gboolean _tmp23_ = FALSE;
				_tmp4_ = spec;
				_tmp5_ = _tmp4_->name;
				_tmp6_ = g_utf8_strdown (_tmp5_, (gssize) (-1));
				_tmp7_ = _tmp6_;
				_tmp8_ = property_name;
				_tmp9_ = g_utf8_strdown (_tmp8_, (gssize) (-1));
				_tmp10_ = _tmp9_;
				_tmp11_ = g_strcmp0 (_tmp7_, _tmp10_) == 0;
				_g_free0 (_tmp10_);
				_g_free0 (_tmp7_);
				if (_tmp11_) {
					result = spec;
					props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_param_spec_unref), NULL);
					return result;
				}
				_tmp12_ = gxml_serializable_property_use_nick (self);
				if (_tmp12_) {
					GParamSpec* _tmp13_ = NULL;
					const gchar* _tmp14_ = NULL;
					gchar* _tmp15_ = NULL;
					gchar* _tmp16_ = NULL;
					const gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					gboolean _tmp20_ = FALSE;
					_tmp13_ = spec;
					_tmp14_ = g_param_spec_get_nick (_tmp13_);
					_tmp15_ = g_utf8_strdown (_tmp14_, (gssize) (-1));
					_tmp16_ = _tmp15_;
					_tmp17_ = property_name;
					_tmp18_ = g_utf8_strdown (_tmp17_, (gssize) (-1));
					_tmp19_ = _tmp18_;
					_tmp20_ = g_strcmp0 (_tmp16_, _tmp19_) == 0;
					_g_free0 (_tmp19_);
					_g_free0 (_tmp16_);
					if (_tmp20_) {
						result = spec;
						props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_param_spec_unref), NULL);
						return result;
					}
				}
				_tmp21_ = spec;
				_tmp22_ = _tmp21_->name;
				_tmp23_ = string_contains (_tmp22_, "-");
				if (_tmp23_) {
					gchar** sp = NULL;
					GParamSpec* _tmp24_ = NULL;
					const gchar* _tmp25_ = NULL;
					gchar** _tmp26_ = NULL;
					gchar** _tmp27_ = NULL;
					gint sp_length1 = 0;
					gint _sp_size_ = 0;
					gchar* n = NULL;
					gchar* _tmp28_ = NULL;
					gchar** _tmp29_ = NULL;
					gint _tmp29__length1 = 0;
					const gchar* _tmp48_ = NULL;
					gchar* _tmp49_ = NULL;
					gchar* _tmp50_ = NULL;
					const gchar* _tmp51_ = NULL;
					gchar* _tmp52_ = NULL;
					gchar* _tmp53_ = NULL;
					gboolean _tmp54_ = FALSE;
					_tmp24_ = spec;
					_tmp25_ = _tmp24_->name;
					_tmp27_ = _tmp26_ = g_strsplit (_tmp25_, "-", 0);
					sp = _tmp27_;
					sp_length1 = _vala_array_length (_tmp26_);
					_sp_size_ = sp_length1;
					_tmp28_ = g_strdup ("");
					n = _tmp28_;
					_tmp29_ = sp;
					_tmp29__length1 = sp_length1;
					{
						gchar** s_collection = NULL;
						gint s_collection_length1 = 0;
						gint _s_collection_size_ = 0;
						gint s_it = 0;
						s_collection = _tmp29_;
						s_collection_length1 = _tmp29__length1;
						for (s_it = 0; s_it < _tmp29__length1; s_it = s_it + 1) {
							gchar* _tmp30_ = NULL;
							gchar* s = NULL;
							_tmp30_ = g_strdup (s_collection[s_it]);
							s = _tmp30_;
							{
								const gchar* _tmp31_ = NULL;
								const gchar* _tmp32_ = NULL;
								gchar _tmp33_ = '\0';
								gchar* _tmp34_ = NULL;
								gchar* _tmp35_ = NULL;
								gchar* _tmp36_ = NULL;
								gchar* _tmp37_ = NULL;
								const gchar* _tmp38_ = NULL;
								const gchar* _tmp39_ = NULL;
								gint _tmp40_ = 0;
								gint _tmp41_ = 0;
								gchar* _tmp42_ = NULL;
								gchar* _tmp43_ = NULL;
								const gchar* _tmp44_ = NULL;
								gchar* _tmp45_ = NULL;
								gchar* _tmp46_ = NULL;
								gchar* _tmp47_ = NULL;
								_tmp31_ = n;
								_tmp32_ = s;
								_tmp33_ = string_get (_tmp32_, (glong) 0);
								_tmp34_ = g_strdup_printf ("%c", _tmp33_);
								_tmp35_ = _tmp34_;
								_tmp36_ = g_utf8_strup (_tmp35_, (gssize) (-1));
								_tmp37_ = _tmp36_;
								_tmp38_ = s;
								_tmp39_ = s;
								_tmp40_ = strlen (_tmp39_);
								_tmp41_ = _tmp40_;
								_tmp42_ = string_slice (_tmp38_, (glong) 1, (glong) _tmp41_);
								_tmp43_ = _tmp42_;
								_tmp44_ = string_to_string (_tmp43_);
								_tmp45_ = g_strconcat (_tmp37_, _tmp44_, NULL);
								_tmp46_ = _tmp45_;
								_tmp47_ = g_strconcat (_tmp31_, _tmp46_, NULL);
								_g_free0 (n);
								n = _tmp47_;
								_g_free0 (_tmp46_);
								_g_free0 (_tmp43_);
								_g_free0 (_tmp37_);
								_g_free0 (_tmp35_);
								_g_free0 (s);
							}
						}
					}
					_tmp48_ = n;
					_tmp49_ = g_utf8_strdown (_tmp48_, (gssize) (-1));
					_tmp50_ = _tmp49_;
					_tmp51_ = property_name;
					_tmp52_ = g_utf8_strdown (_tmp51_, (gssize) (-1));
					_tmp53_ = _tmp52_;
					_tmp54_ = g_strcmp0 (_tmp50_, _tmp53_) == 0;
					_g_free0 (_tmp53_);
					_g_free0 (_tmp50_);
					if (_tmp54_) {
						result = spec;
						_g_free0 (n);
						sp = (_vala_array_free (sp, sp_length1, (GDestroyNotify) g_free), NULL);
						props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_param_spec_unref), NULL);
						return result;
					}
					_g_free0 (n);
					sp = (_vala_array_free (sp, sp_length1, (GDestroyNotify) g_free), NULL);
				}
				_g_param_spec_unref0 (spec);
			}
		}
	}
	result = NULL;
	props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	return result;
}


GParamSpec* gxml_serializable_default_find_property_spec (GXmlSerializable* self, const gchar* property_name) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->default_find_property_spec (self, property_name);
}


/**
     * Used internally to initialize {@link ignored_serializable_properties} property
     * and default not to be serialized properties. Unless you override any function 
     * is not required to be called at class implementor's construction time.
     *
     */
void gxml_serializable_init_properties (GXmlSerializable* self) {
	g_return_if_fail (self != NULL);
	GXML_SERIALIZABLE_GET_INTERFACE (self)->init_properties (self);
}


/**
     * Default implementation for init_properties ().
     *
     */
static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_param_spec_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_param_spec_unref (var), NULL));
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void gxml_serializable_real_default_init_properties (GXmlSerializable* self) {
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	GHashTable* _tmp24_ = NULL;
	GHashTable* _tmp25_ = NULL;
	_tmp0_ = gxml_serializable_get_ignored_serializable_properties (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		GHashFunc _tmp2_ = NULL;
		GEqualFunc _tmp3_ = NULL;
		GHashTable* _tmp4_ = NULL;
		GHashTable* _tmp5_ = NULL;
		GHashTable* _tmp6_ = NULL;
		GHashTable* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		GObjectClass* _tmp9_ = NULL;
		GParamSpec* _tmp10_ = NULL;
		GParamSpec* _tmp11_ = NULL;
		GHashTable* _tmp12_ = NULL;
		GHashTable* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		GObjectClass* _tmp15_ = NULL;
		GParamSpec* _tmp16_ = NULL;
		GParamSpec* _tmp17_ = NULL;
		GHashTable* _tmp18_ = NULL;
		GHashTable* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		GObjectClass* _tmp21_ = NULL;
		GParamSpec* _tmp22_ = NULL;
		GParamSpec* _tmp23_ = NULL;
		_tmp2_ = g_str_hash;
		_tmp3_ = g_str_equal;
		_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, _g_free0_, _g_param_spec_unref0_);
		_tmp5_ = _tmp4_;
		gxml_serializable_set_ignored_serializable_properties (self, _tmp5_);
		_g_hash_table_unref0 (_tmp5_);
		_tmp6_ = gxml_serializable_get_ignored_serializable_properties (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup ("ignored-serializable-properties");
		_tmp9_ = G_OBJECT_GET_CLASS ((GObject*) self);
		_tmp10_ = g_object_class_find_property (_tmp9_, "ignored-serializable-properties");
		_tmp11_ = _g_param_spec_ref0 (_tmp10_);
		g_hash_table_insert (_tmp7_, _tmp8_, _tmp11_);
		_tmp12_ = gxml_serializable_get_ignored_serializable_properties (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strdup ("unknown-serializable-property");
		_tmp15_ = G_OBJECT_GET_CLASS ((GObject*) self);
		_tmp16_ = g_object_class_find_property (_tmp15_, "unknown-serializable-property");
		_tmp17_ = _g_param_spec_ref0 (_tmp16_);
		g_hash_table_insert (_tmp13_, _tmp14_, _tmp17_);
		_tmp18_ = gxml_serializable_get_ignored_serializable_properties (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strdup ("serialized-xml-node-value");
		_tmp21_ = G_OBJECT_GET_CLASS ((GObject*) self);
		_tmp22_ = g_object_class_find_property (_tmp21_, "serialized-xml-node-value");
		_tmp23_ = _g_param_spec_ref0 (_tmp22_);
		g_hash_table_insert (_tmp19_, _tmp20_, _tmp23_);
	}
	_tmp24_ = gxml_serializable_get_unknown_serializable_property (self);
	_tmp25_ = _tmp24_;
	if (_tmp25_ == NULL) {
		GHashFunc _tmp26_ = NULL;
		GEqualFunc _tmp27_ = NULL;
		GHashTable* _tmp28_ = NULL;
		GHashTable* _tmp29_ = NULL;
		_tmp26_ = g_str_hash;
		_tmp27_ = g_str_equal;
		_tmp28_ = g_hash_table_new_full (_tmp26_, _tmp27_, _g_free0_, _g_object_unref0_);
		_tmp29_ = _tmp28_;
		gxml_serializable_set_unknown_serializable_property (self, _tmp29_);
		_g_hash_table_unref0 (_tmp29_);
	}
}


void gxml_serializable_default_init_properties (GXmlSerializable* self) {
	g_return_if_fail (self != NULL);
	GXML_SERIALIZABLE_GET_INTERFACE (self)->default_init_properties (self);
}


/**
     * List the known properties for an object's class
     *
     * @return an array of {@link GLib.ParamSpec} of
     * "properties" for the object.
     *
     * {@link GXml.Serialization} uses
     * {@link GLib.ObjectClass.list_properties} (as well as
     * {@link GLib.ObjectClass.find_property},
     * {@link GLib.Object.get_property}, and {@link GLib.Object.set_property})
     * to manage serialization of an object's properties.
     * {@link GXml.Serializable} gives an implementing class an
     * opportunity to override
     * {@link GLib.ObjectClass.list_properties} to control which
     * properties exist for {@link GXml.Serialization}'s purposes.
     *
     * For instance, if an object has private data fields
     * that are not installed public properties, but that
     * should be serialized, list_properties can be
     * defined to return a list of {@link GLib.ParamSpec} s covering
     * all the "properties" to serialize.  Other
     * {@link GXml.Serializable} functions should be consistent
     * with it.
     *
     * An implementing class might wish to maintain such
     * {@link GLib.ParamSpec} s separately, rather than creating new
     * ones for each call.
     */
GParamSpec** gxml_serializable_list_serializable_properties (GXmlSerializable* self, int* result_length1) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->list_serializable_properties (self, result_length1);
}


/**
     * Default implementation for list_serializable_properties ().
     *
     */
static void _vala_array_add1 (GParamSpec*** array, int* length, int* size, GParamSpec* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GParamSpec*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static GParamSpec** _vala_array_dup1 (GParamSpec** self, int length) {
	GParamSpec** result;
	int i;
	result = g_new0 (GParamSpec*, length + 1);
	for (i = 0; i < length; i++) {
		GParamSpec* _tmp0_ = NULL;
		_tmp0_ = _g_param_spec_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static GParamSpec** gxml_serializable_real_default_list_serializable_properties (GXmlSerializable* self, int* result_length1) {
	GParamSpec** result = NULL;
	GParamSpec** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GParamSpec** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	GParamSpec** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	GParamSpec** _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	GParamSpec** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	GParamSpec** _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	gxml_serializable_init_properties (self);
	_tmp0_ = gxml_serializable_get_properties (self, &_tmp0__length1);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (_tmp1_ == NULL) {
		GParamSpec** props = NULL;
		GParamSpec** _tmp2_ = NULL;
		gint props_length1 = 0;
		gint _props_size_ = 0;
		GObjectClass* _tmp3_ = NULL;
		guint _tmp4_;
		GParamSpec** _tmp5_ = NULL;
		GParamSpec** _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
		_tmp2_ = g_new0 (GParamSpec*, 0 + 1);
		props = _tmp2_;
		props_length1 = 0;
		_props_size_ = props_length1;
		_tmp3_ = G_OBJECT_GET_CLASS ((GObject*) self);
		_tmp5_ = g_object_class_list_properties (_tmp3_, &_tmp4_);
		{
			GParamSpec** spec_collection = NULL;
			gint spec_collection_length1 = 0;
			gint _spec_collection_size_ = 0;
			gint spec_it = 0;
			spec_collection = _tmp5_;
			spec_collection_length1 = _tmp4_;
			for (spec_it = 0; spec_it < _tmp4_; spec_it = spec_it + 1) {
				GParamSpec* _tmp6_ = NULL;
				GParamSpec* spec = NULL;
				_tmp6_ = _g_param_spec_ref0 (spec_collection[spec_it]);
				spec = _tmp6_;
				{
					GHashTable* _tmp7_ = NULL;
					GHashTable* _tmp8_ = NULL;
					GParamSpec* _tmp9_ = NULL;
					const gchar* _tmp10_ = NULL;
					gboolean _tmp11_ = FALSE;
					_tmp7_ = gxml_serializable_get_ignored_serializable_properties (self);
					_tmp8_ = _tmp7_;
					_tmp9_ = spec;
					_tmp10_ = _tmp9_->name;
					_tmp11_ = g_hash_table_contains (_tmp8_, _tmp10_);
					if (!_tmp11_) {
						GParamSpec** _tmp12_ = NULL;
						gint _tmp12__length1 = 0;
						GParamSpec* _tmp13_ = NULL;
						GParamSpec* _tmp14_ = NULL;
						_tmp12_ = props;
						_tmp12__length1 = props_length1;
						_tmp13_ = spec;
						_tmp14_ = _g_param_spec_ref0 (_tmp13_);
						_vala_array_add1 (&props, &props_length1, &_props_size_, _tmp14_);
					}
					_g_param_spec_unref0 (spec);
				}
			}
		}
		_tmp15_ = props;
		_tmp15__length1 = props_length1;
		gxml_serializable_set_properties (self, _tmp15_, _tmp15__length1);
		props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	}
	_tmp16_ = gxml_serializable_get_properties (self, &_tmp16__length1);
	_tmp17_ = _tmp16_;
	_tmp17__length1 = _tmp16__length1;
	_tmp18_ = (_tmp17_ != NULL) ? _vala_array_dup1 (_tmp17_, _tmp17__length1) : ((gpointer) _tmp17_);
	_tmp18__length1 = _tmp17__length1;
	_tmp19_ = _tmp18_;
	_tmp19__length1 = _tmp18__length1;
	if (result_length1) {
		*result_length1 = _tmp19__length1;
	}
	result = _tmp19_;
	return result;
}


GParamSpec** gxml_serializable_default_list_serializable_properties (GXmlSerializable* self, int* result_length1) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->default_list_serializable_properties (self, result_length1);
}


/**
     * Get a string version of the specified property
     *
     * @param spec The property we're retrieving as a string
     *
     * {@link GXml.Serialization} uses {@link GLib.Object.get_property} (as
     * well as {@link GLib.ObjectClass.find_property},
     * {@link GLib.ObjectClass.list_properties}, and
     * {@link GLib.Object.set_property}) to manage serialization of
     * an object's properties.  {@link GXml.Serializable} gives an
     * implementing class an opportunity to override
     * {@link GLib.Object.get_property} to control what value is
     * returned for a given parameter.
     *
     * For instance, if an object has private data fields
     * that are not installed public properties, but that
     * should be serialized,
     * {@link GXml.Serializable.get_property} can be used to
     * handle this case as a virtual property, supported
     * by the other {@link GXml.Serializable} functions.
     *
     * `spec` is usually obtained from list_properties or find_property.
     */
void gxml_serializable_get_property_value (GXmlSerializable* self, GParamSpec* spec, GValue* val) {
	g_return_if_fail (self != NULL);
	GXML_SERIALIZABLE_GET_INTERFACE (self)->get_property_value (self, spec, val);
}


/**
     * Default implementation for get_property_value ().
     *
     */
static void gxml_serializable_real_default_get_property_value (GXmlSerializable* self, GParamSpec* spec, GValue* val) {
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	GParamSpec* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (spec != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = gxml_serializable_get_ignored_serializable_properties (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = spec;
	_tmp3_ = _tmp2_->name;
	_tmp4_ = g_hash_table_contains (_tmp1_, _tmp3_);
	if (!_tmp4_) {
		GParamSpec* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp5_ = spec;
		_tmp6_ = _tmp5_->name;
		g_object_get_property (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), _tmp6_, val);
	}
}


void gxml_serializable_default_get_property_value (GXmlSerializable* self, GParamSpec* spec, GValue* val) {
	g_return_if_fail (self != NULL);
	GXML_SERIALIZABLE_GET_INTERFACE (self)->default_get_property_value (self, spec, val);
}


/**
     * Set a property's value.
     *
     * @param spec Specifies the property whose value will be set
     * @param val The value to set the property to.
     *
     * {@link GXml.Serialization} uses {@link GLib.Object.set_property} (as
     * well as {@link GLib.ObjectClass.find_property},
     * {@link GLib.ObjectClass.list_properties}, and
     * {@link GLib.Object.get_property}) to manage serialization of
     * an object's properties.  {@link GXml.Serializable} gives an
     * implementing class an opportunity to override
     * {@link GLib.Object.set_property} to control how a property's
     * value is set.
     *
     * For instance, if an object has private data fields
     * that are not installed public properties, but that
     * should be serialized,
     * {@link GXml.Serializable.set_property} can be used to
     * handle this case as a virtual property, supported
     * by the other {@link GXml.Serializable} functions.
     */
void gxml_serializable_set_property_value (GXmlSerializable* self, GParamSpec* spec, GValue* val) {
	g_return_if_fail (self != NULL);
	GXML_SERIALIZABLE_GET_INTERFACE (self)->set_property_value (self, spec, val);
}


/**
     * Default implementation for set_property_value ().
     *
     */
static void gxml_serializable_real_default_set_property_value (GXmlSerializable* self, GParamSpec* spec, GValue* val) {
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	GParamSpec* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (spec != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = gxml_serializable_get_ignored_serializable_properties (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = spec;
	_tmp3_ = _tmp2_->name;
	_tmp4_ = g_hash_table_contains (_tmp1_, _tmp3_);
	if (!_tmp4_) {
		GParamSpec* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		GValue _tmp7_ = {0};
		_tmp5_ = spec;
		_tmp6_ = _tmp5_->name;
		_tmp7_ = *val;
		g_object_set_property (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), _tmp6_, &_tmp7_);
	}
}


void gxml_serializable_default_set_property_value (GXmlSerializable* self, GParamSpec* spec, GValue* val) {
	g_return_if_fail (self != NULL);
	GXML_SERIALIZABLE_GET_INTERFACE (self)->default_set_property_value (self, spec, val);
}


/**
     * Method to provide custome transformations from strings to
     * a {@link GLib.Value}. Could be used on {@link serialize} or simple 
     * transformations from string.
     *
     * Some specialized classes, like derived from {@link Serializable} class
     * implementator, can provide custome transformations.
     *
     * Returns: {@link true} if transformation was handled, {@link false} otherwise.
     *
     * Implementors:
     * To be overrided by derived classes of implementators to provide custome
     * transformations. Declare it as virtual if you want derived classes of 
     * implementators to provide custome transformations.
     * Call this method before use standard Serializable or implementator ones.
     *
     * @node a {@link GXml.Node} to get attribute from
     * @prop a {@link GLib.ParamSpec} describing attribute to deserialize
     */
gboolean gxml_serializable_transform_from_string (GXmlSerializable* self, const gchar* str, GValue* dest, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->transform_from_string (self, str, dest, error);
}


/**
     * Transforms a string into another type hosted by {@link GLib.Value}.
     *
     * A utility function that handles converting a string
     * representation of a value into the type specified by the
     * supplied #GValue dest.  A #GXmlSerializableError will be
     * set if the string cannot be parsed into the desired type.
     *
     * @param str the string to transform into the given #GValue object
     * @param dest the #GValue out parameter that will contain the parsed value from the string
     * @return `true` if parsing succeeded, otherwise `false`
     */
static gboolean int64_try_parse (const gchar* str, gint64* _result_) {
	gint64 _vala_result = 0LL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	_tmp2_ = g_ascii_strtoll (_tmp0_, &_tmp1_, (guint) 0);
	endptr = _tmp1_;
	_vala_result = _tmp2_;
	_tmp3_ = endptr;
	_tmp4_ = str;
	_tmp5_ = str;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp3_ == (((gchar*) _tmp4_) + _tmp7_)) {
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	} else {
		result = FALSE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _vala_result;
	}
}


static gboolean uint64_try_parse (const gchar* str, guint64* _result_) {
	guint64 _vala_result = 0ULL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	guint64 _tmp2_ = 0ULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	_tmp2_ = g_ascii_strtoull (_tmp0_, &_tmp1_, (guint) 0);
	endptr = _tmp1_;
	_vala_result = _tmp2_;
	_tmp3_ = endptr;
	_tmp4_ = str;
	_tmp5_ = str;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp3_ == (((gchar*) _tmp4_) + _tmp7_)) {
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	} else {
		result = FALSE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _vala_result;
	}
}


static gboolean bool_try_parse (const gchar* str, gboolean* _result_) {
	gboolean _vala_result = FALSE;
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	if (g_strcmp0 (_tmp0_, "true") == 0) {
		_vala_result = TRUE;
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	} else {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = str;
		if (g_strcmp0 (_tmp1_, "false") == 0) {
			_vala_result = FALSE;
			result = TRUE;
			if (_result_) {
				*_result_ = _vala_result;
			}
			return result;
		} else {
			_vala_result = FALSE;
			result = FALSE;
			if (_result_) {
				*_result_ = _vala_result;
			}
			return result;
		}
	}
	if (_result_) {
		*_result_ = _vala_result;
	}
}


static gboolean double_try_parse (const gchar* str, gdouble* _result_) {
	gdouble _vala_result = 0.0;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	_tmp2_ = g_ascii_strtod (_tmp0_, &_tmp1_);
	endptr = _tmp1_;
	_vala_result = _tmp2_;
	_tmp3_ = endptr;
	_tmp4_ = str;
	_tmp5_ = str;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp3_ == (((gchar*) _tmp4_) + _tmp7_)) {
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	} else {
		result = FALSE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _vala_result;
	}
}


gboolean gxml_serializable_string_to_gvalue (const gchar* str, GValue* dest, GError** error) {
	gboolean result = FALSE;
	GType t = 0UL;
	GType _tmp0_ = 0UL;
	GValue dest2 = {0};
	GType _tmp1_ = 0UL;
	GValue _tmp2_ = {0};
	gboolean ret = FALSE;
	GType _tmp3_ = 0UL;
	gboolean _tmp80_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (str != NULL, FALSE);
	g_return_val_if_fail (dest != NULL, FALSE);
	_tmp0_ = G_VALUE_TYPE (dest);
	t = _tmp0_;
	_tmp1_ = t;
	g_value_init (&_tmp2_, _tmp1_);
	dest2 = _tmp2_;
	ret = FALSE;
	_tmp3_ = t;
	if (_tmp3_ == G_TYPE_INT64) {
		gint64 val = 0LL;
		const gchar* _tmp4_ = NULL;
		gint64 _tmp5_ = 0LL;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		_tmp4_ = str;
		_tmp6_ = int64_try_parse (_tmp4_, &_tmp5_);
		val = _tmp5_;
		ret = _tmp6_;
		_tmp7_ = ret;
		if (_tmp7_) {
			gint64 _tmp8_ = 0LL;
			_tmp8_ = val;
			g_value_set_int64 (&dest2, _tmp8_);
		}
	} else {
		GType _tmp9_ = 0UL;
		_tmp9_ = t;
		if (_tmp9_ == G_TYPE_INT) {
			gint64 val = 0LL;
			const gchar* _tmp10_ = NULL;
			gint64 _tmp11_ = 0LL;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			_tmp10_ = str;
			_tmp12_ = int64_try_parse (_tmp10_, &_tmp11_);
			val = _tmp11_;
			ret = _tmp12_;
			_tmp13_ = ret;
			if (_tmp13_) {
				gint64 _tmp14_ = 0LL;
				_tmp14_ = val;
				g_value_set_int (&dest2, (gint) _tmp14_);
			}
		} else {
			GType _tmp15_ = 0UL;
			_tmp15_ = t;
			if (_tmp15_ == G_TYPE_LONG) {
				gint64 val = 0LL;
				const gchar* _tmp16_ = NULL;
				gint64 _tmp17_ = 0LL;
				gboolean _tmp18_ = FALSE;
				gboolean _tmp19_ = FALSE;
				_tmp16_ = str;
				_tmp18_ = int64_try_parse (_tmp16_, &_tmp17_);
				val = _tmp17_;
				ret = _tmp18_;
				_tmp19_ = ret;
				if (_tmp19_) {
					gint64 _tmp20_ = 0LL;
					_tmp20_ = val;
					g_value_set_long (&dest2, (glong) _tmp20_);
				}
			} else {
				GType _tmp21_ = 0UL;
				_tmp21_ = t;
				if (_tmp21_ == G_TYPE_UINT) {
					guint64 val = 0ULL;
					const gchar* _tmp22_ = NULL;
					guint64 _tmp23_ = 0ULL;
					gboolean _tmp24_ = FALSE;
					gboolean _tmp25_ = FALSE;
					_tmp22_ = str;
					_tmp24_ = uint64_try_parse (_tmp22_, &_tmp23_);
					val = _tmp23_;
					ret = _tmp24_;
					_tmp25_ = ret;
					if (_tmp25_) {
						guint64 _tmp26_ = 0ULL;
						_tmp26_ = val;
						g_value_set_uint (&dest2, (guint) _tmp26_);
					}
				} else {
					GType _tmp27_ = 0UL;
					_tmp27_ = t;
					if (_tmp27_ == G_TYPE_ULONG) {
						guint64 val = 0ULL;
						const gchar* _tmp28_ = NULL;
						guint64 _tmp29_ = 0ULL;
						gboolean _tmp30_ = FALSE;
						gboolean _tmp31_ = FALSE;
						_tmp28_ = str;
						_tmp30_ = uint64_try_parse (_tmp28_, &_tmp29_);
						val = _tmp29_;
						ret = _tmp30_;
						_tmp31_ = ret;
						if (_tmp31_) {
							guint64 _tmp32_ = 0ULL;
							_tmp32_ = val;
							g_value_set_ulong (&dest2, (gulong) _tmp32_);
						}
					} else {
						GType _tmp33_ = 0UL;
						_tmp33_ = t;
						if (_tmp33_ == G_TYPE_BOOLEAN) {
							gboolean val = FALSE;
							const gchar* _tmp34_ = NULL;
							gchar* _tmp35_ = NULL;
							gchar* _tmp36_ = NULL;
							gboolean _tmp37_ = FALSE;
							gboolean _tmp38_ = FALSE;
							gboolean _tmp39_ = FALSE;
							gboolean _tmp40_ = FALSE;
							_tmp34_ = str;
							_tmp35_ = g_utf8_strdown (_tmp34_, (gssize) (-1));
							_tmp36_ = _tmp35_;
							_tmp38_ = bool_try_parse (_tmp36_, &_tmp37_);
							val = _tmp37_;
							ret = _tmp38_;
							_tmp39_ = ret;
							_tmp40_ = _tmp39_;
							_g_free0 (_tmp36_);
							if (_tmp40_) {
								gboolean _tmp41_ = FALSE;
								_tmp41_ = val;
								g_value_set_boolean (&dest2, _tmp41_);
							}
						} else {
							GType _tmp42_ = 0UL;
							_tmp42_ = t;
							if (_tmp42_ == G_TYPE_FLOAT) {
								gdouble val = 0.0;
								const gchar* _tmp43_ = NULL;
								gdouble _tmp44_ = 0.0;
								gboolean _tmp45_ = FALSE;
								gboolean _tmp46_ = FALSE;
								_tmp43_ = str;
								_tmp45_ = double_try_parse (_tmp43_, &_tmp44_);
								val = _tmp44_;
								ret = _tmp45_;
								_tmp46_ = ret;
								if (_tmp46_) {
									gdouble _tmp47_ = 0.0;
									_tmp47_ = val;
									g_value_set_float (&dest2, (gfloat) _tmp47_);
								}
							} else {
								GType _tmp48_ = 0UL;
								_tmp48_ = t;
								if (_tmp48_ == G_TYPE_DOUBLE) {
									gdouble val = 0.0;
									const gchar* _tmp49_ = NULL;
									gdouble _tmp50_ = 0.0;
									gboolean _tmp51_ = FALSE;
									gboolean _tmp52_ = FALSE;
									_tmp49_ = str;
									_tmp51_ = double_try_parse (_tmp49_, &_tmp50_);
									val = _tmp50_;
									ret = _tmp51_;
									_tmp52_ = ret;
									if (_tmp52_) {
										gdouble _tmp53_ = 0.0;
										_tmp53_ = val;
										g_value_set_double (&dest2, _tmp53_);
									}
								} else {
									GType _tmp54_ = 0UL;
									_tmp54_ = t;
									if (_tmp54_ == G_TYPE_STRING) {
										const gchar* _tmp55_ = NULL;
										_tmp55_ = str;
										g_value_set_string (&dest2, _tmp55_);
										ret = TRUE;
									} else {
										GType _tmp56_ = 0UL;
										_tmp56_ = t;
										if (_tmp56_ == G_TYPE_CHAR) {
											gint64 val = 0LL;
											const gchar* _tmp57_ = NULL;
											gint64 _tmp58_ = 0LL;
											gboolean _tmp59_ = FALSE;
											gboolean _tmp60_ = FALSE;
											_tmp57_ = str;
											_tmp59_ = int64_try_parse (_tmp57_, &_tmp58_);
											val = _tmp58_;
											ret = _tmp59_;
											_tmp60_ = ret;
											if (_tmp60_) {
												gint64 _tmp61_ = 0LL;
												_tmp61_ = val;
												g_value_set_char (&dest2, (gchar) _tmp61_);
											}
										} else {
											GType _tmp62_ = 0UL;
											_tmp62_ = t;
											if (_tmp62_ == G_TYPE_UCHAR) {
												gint64 val = 0LL;
												const gchar* _tmp63_ = NULL;
												gint64 _tmp64_ = 0LL;
												gboolean _tmp65_ = FALSE;
												gboolean _tmp66_ = FALSE;
												_tmp63_ = str;
												_tmp65_ = int64_try_parse (_tmp63_, &_tmp64_);
												val = _tmp64_;
												ret = _tmp65_;
												_tmp66_ = ret;
												if (_tmp66_) {
													gint64 _tmp67_ = 0LL;
													_tmp67_ = val;
													g_value_set_uchar (&dest2, (guchar) _tmp67_);
												}
											} else {
												GType _tmp68_ = 0UL;
												_tmp68_ = t;
												if (_tmp68_ == G_TYPE_BOXED) {
												} else {
													GType _tmp69_ = 0UL;
													gboolean _tmp70_ = FALSE;
													_tmp69_ = t;
													_tmp70_ = G_TYPE_IS_ENUM (_tmp69_);
													if (_tmp70_) {
														gint64 val = 0LL;
														const gchar* _tmp71_ = NULL;
														gint64 _tmp72_ = 0LL;
														gboolean _tmp73_ = FALSE;
														gboolean _tmp74_ = FALSE;
														_tmp71_ = str;
														_tmp73_ = int64_try_parse (_tmp71_, &_tmp72_);
														val = _tmp72_;
														ret = _tmp73_;
														_tmp74_ = ret;
														if (_tmp74_) {
															gint64 _tmp75_ = 0LL;
															_tmp75_ = val;
															g_value_set_enum (&dest2, (gint) _tmp75_);
														}
													} else {
														GType _tmp76_ = 0UL;
														gboolean _tmp77_ = FALSE;
														_tmp76_ = t;
														_tmp77_ = G_TYPE_IS_FLAGS (_tmp76_);
														if (_tmp77_) {
														} else {
															GType _tmp78_ = 0UL;
															gboolean _tmp79_ = FALSE;
															_tmp78_ = t;
															_tmp79_ = G_TYPE_IS_OBJECT (_tmp78_);
															if (_tmp79_) {
															} else {
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp80_ = ret;
	if (_tmp80_ == TRUE) {
		GValue _tmp81_ = {0};
		GValue _tmp82_ = {0};
		_tmp81_ = dest2;
		if (G_IS_VALUE (&_tmp81_)) {
			g_value_init (&_tmp82_, G_VALUE_TYPE (&_tmp81_));
			g_value_copy (&_tmp81_, &_tmp82_);
		} else {
			_tmp82_ = _tmp81_;
		}
		G_IS_VALUE (dest) ? (g_value_unset (dest), NULL) : NULL;
		*dest = _tmp82_;
		result = TRUE;
		G_IS_VALUE (&dest2) ? (g_value_unset (&dest2), NULL) : NULL;
		return result;
	} else {
		const gchar* _tmp83_ = NULL;
		GType _tmp84_ = 0UL;
		const gchar* _tmp85_ = NULL;
		GError* _tmp86_ = NULL;
		_tmp83_ = str;
		_tmp84_ = t;
		_tmp85_ = g_type_name (_tmp84_);
		_tmp86_ = g_error_new (GXML_SERIALIZABLE_ERROR, GXML_SERIALIZABLE_ERROR_UNSUPPORTED_TYPE_ERROR, "Transformation Error on '%s' or Unsupported type: '%s'", _tmp83_, _tmp85_);
		_inner_error_ = _tmp86_;
		if (_inner_error_->domain == GXML_SERIALIZABLE_ERROR) {
			g_propagate_error (error, _inner_error_);
			G_IS_VALUE (&dest2) ? (g_value_unset (&dest2), NULL) : NULL;
			return FALSE;
		} else {
			G_IS_VALUE (&dest2) ? (g_value_unset (&dest2), NULL) : NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	G_IS_VALUE (&dest2) ? (g_value_unset (&dest2), NULL) : NULL;
}


/**
     * Method to provide custome transformations from
     * a {@link GLib.Value} to strings. Could be used on {@link deserialize} or simple 
     * transformations to strings.
     *
     * Some specialized classes, like derived from {@link Serializable} class
     * implementator, can provide custome transformations.
     *
     * Returns: {@link true} if transformation was handled, {@link false} otherwise.
     *
     * Implementors:
     * To be overrided by derived classes of implementators to provide custome
     * transformations. Declare it as virtual if you want derived classes of 
     * implementators to provide custome transformations.
     * Call this method before use standard Serializable or implementator ones.
     *
     * @node a {@link GXml.Node} to get attribute from
     * @prop a {@link GLib.ParamSpec} describing attribute to deserialize
     */
gboolean gxml_serializable_transform_to_string (GXmlSerializable* self, GValue* val, gchar** str, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->transform_to_string (self, val, str, error);
}


/**
     * Transforms a {@link GLib.Value} to its string representation.
     *
     * By default use GObject standard transformations.
     *
     */
gchar* gxml_serializable_gvalue_to_string (GValue* val, GError** error) {
	gchar* result = NULL;
	GValue ret = {0};
	GValue _tmp0_ = {0};
	GType _tmp1_ = 0UL;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (val != NULL, NULL);
	g_value_init (&_tmp0_, G_TYPE_STRING);
	g_value_set_string (&_tmp0_, "");
	ret = _tmp0_;
	_tmp1_ = G_VALUE_TYPE (val);
	_tmp2_ = g_value_type_transformable (_tmp1_, G_TYPE_STRING);
	if (_tmp2_) {
		gchar* _tmp3_ = NULL;
		g_value_transform (val, &ret);
		_tmp3_ = g_value_dup_string (&ret);
		result = _tmp3_;
		G_IS_VALUE (&ret) ? (g_value_unset (&ret), NULL) : NULL;
		return result;
	} else {
		GType _tmp4_ = 0UL;
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		_tmp4_ = G_VALUE_TYPE (val);
		_tmp5_ = g_type_name (_tmp4_);
		_tmp6_ = g_error_new (GXML_SERIALIZABLE_ERROR, GXML_SERIALIZABLE_ERROR_UNSUPPORTED_TYPE_ERROR, "Can't transform '%s' to string", _tmp5_);
		_inner_error_ = _tmp6_;
		if (_inner_error_->domain == GXML_SERIALIZABLE_ERROR) {
			g_propagate_error (error, _inner_error_);
			G_IS_VALUE (&ret) ? (g_value_unset (&ret), NULL) : NULL;
			return NULL;
		} else {
			G_IS_VALUE (&ret) ? (g_value_unset (&ret), NULL) : NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	G_IS_VALUE (&ret) ? (g_value_unset (&ret), NULL) : NULL;
}


GParamSpec** gxml_serializable_get_properties (GXmlSerializable* self, int* result_length1) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->get_properties (self, result_length1);
}


void gxml_serializable_set_properties (GXmlSerializable* self, GParamSpec** value, int value_length1) {
	g_return_if_fail (self != NULL);
	GXML_SERIALIZABLE_GET_INTERFACE (self)->set_properties (self, value, value_length1);
}


GHashTable* gxml_serializable_get_ignored_serializable_properties (GXmlSerializable* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->get_ignored_serializable_properties (self);
}


void gxml_serializable_set_ignored_serializable_properties (GXmlSerializable* self, GHashTable* value) {
	g_return_if_fail (self != NULL);
	GXML_SERIALIZABLE_GET_INTERFACE (self)->set_ignored_serializable_properties (self, value);
}


GHashTable* gxml_serializable_get_unknown_serializable_property (GXmlSerializable* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->get_unknown_serializable_property (self);
}


void gxml_serializable_set_unknown_serializable_property (GXmlSerializable* self, GHashTable* value) {
	g_return_if_fail (self != NULL);
	GXML_SERIALIZABLE_GET_INTERFACE (self)->set_unknown_serializable_property (self, value);
}


const gchar* gxml_serializable_get_serialized_xml_node_value (GXmlSerializable* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_GET_INTERFACE (self)->get_serialized_xml_node_value (self);
}


void gxml_serializable_set_serialized_xml_node_value (GXmlSerializable* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	GXML_SERIALIZABLE_GET_INTERFACE (self)->set_serialized_xml_node_value (self, value);
}


static void g_cclosure_user_marshal_VOID__OBJECT_G_PARAM_SPEC_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_G_PARAM_SPEC_POINTER) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_G_PARAM_SPEC_POINTER callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_G_PARAM_SPEC_POINTER) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_param (param_values + 2), g_value_get_pointer (param_values + 3), data2);
}


static void g_cclosure_user_marshal_VOID__OBJECT_G_PARAM_SPEC (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_G_PARAM_SPEC) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_G_PARAM_SPEC callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_G_PARAM_SPEC) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_param (param_values + 2), data2);
}


static void gxml_serializable_base_init (GXmlSerializableIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		     * Store all properties to be ignored on serialization.
		     *
		     * Use property's cannonical name as key and its {@link GLib.ParamSpec}. To
		     * get the last one use {@link GLib.get_class} and use, again, property's
		     * cannonical name to find it.
		     *
		     * Long named properties like this 'ignored_serializable_properties' are stored
		     * by GObject using its cannonical name, then you must use it as key, in this
		     * case use 'ignored-serializable-properties'.
		     *
		     * This property is ignored on serialisation.
		     *
		     * Implementors: By default {@link list_serializable_properties} initialize
		     * this property to store all public properties, except this one. Make shure to
		     * call {@link init_properties()} before add new propeties.
		     */
		g_object_interface_install_property (iface, g_param_spec_boxed ("ignored-serializable-properties", "ignored-serializable-properties", "ignored-serializable-properties", G_TYPE_HASH_TABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		/**
		     * On deserialization stores any {@link GXml.Node} not used on this
		     * object, but exists in current XML file.
		     *
		     * Node's name is used as key to find stored {@link GXml.Node}.
		     *
		     * This property is ignored on serialisation.
		     */
		g_object_interface_install_property (iface, g_param_spec_boxed ("unknown-serializable-property", "unknown-serializable-property", "unknown-serializable-property", G_TYPE_HASH_TABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		/**
		     * Used to add content in an {@link GXml.Element}.
		     *
		     * By default no contents is serialized/deseralized. Implementors must implement
		     * {@link Serializable.serialize_use_xml_node_value} function returning
		     * {@link true} in order to use this property.
		     *
		     * This property is ignored by default. Implementors must implement
		     * {@link serialize_use_xml_node_value ()} to return {@link true} and add a
		     * set and get function to get/set this value, in order to use your own API.
		     *
		     * This property is ignored on serialisation.
		     */
		g_object_interface_install_property (iface, g_param_spec_string ("serialized-xml-node-value", "serialized-xml-node-value", "serialized-xml-node-value", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		/**
		     * Signal to serialize unknown properties. Any new node must be added to
		     * @element before return the new @node added.
		     * 
		     * @element a {@link GXml.Node} to add attribute or child nodes to
		     * @prop a {@link GLib.ParamSpec} describing attribute to serialize
		     * @node set to the {@link GXml.Node} representing this attribute
		     */
		g_signal_new ("serialize_unknown_property", GXML_TYPE_SERIALIZABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_G_PARAM_SPEC_POINTER, G_TYPE_NONE, 3, GXML_TYPE_NODE, G_TYPE_PARAM, G_TYPE_POINTER);
		/**
		     * Signal to serialize unknown properties. Any new node must be added to
		     * @element before return the new @node added.
		     * 
		     * @element a {@link GXml.Node} to add attribute or child nodes to
		     * @prop a {@link GLib.ParamSpec} describing attribute to serialize
		     * @node set to the {@link GXml.Node} representing this attribute
		     */
		g_signal_new ("serialize_unknown_property_type", GXML_TYPE_SERIALIZABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_G_PARAM_SPEC_POINTER, G_TYPE_NONE, 3, GXML_TYPE_NODE, G_TYPE_PARAM, G_TYPE_POINTER);
		/**
		     * Signal to deserialize unknown properties.
		     *
		     * @node a {@link GXml.Node} to get attribute from
		     * @prop a {@link GLib.ParamSpec} describing attribute to deserialize
		     */
		g_signal_new ("deserialize_unknown_property", GXML_TYPE_SERIALIZABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_G_PARAM_SPEC, G_TYPE_NONE, 2, GXML_TYPE_NODE, G_TYPE_PARAM);
		/**
		     * Signal to deserialize unknown properties' type.
		     *
		     * @node a {@link GXml.Node} to get attribute from
		     * @prop a {@link GLib.ParamSpec} describing attribute to deserialize
		     */
		g_signal_new ("deserialize_unknown_property_type", GXML_TYPE_SERIALIZABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_G_PARAM_SPEC, G_TYPE_NONE, 2, GXML_TYPE_NODE, G_TYPE_PARAM);
		iface->default_find_property_spec = gxml_serializable_real_default_find_property_spec;
		iface->default_init_properties = gxml_serializable_real_default_init_properties;
		iface->default_list_serializable_properties = gxml_serializable_real_default_list_serializable_properties;
		iface->default_get_property_value = gxml_serializable_real_default_get_property_value;
		iface->default_set_property_value = gxml_serializable_real_default_set_property_value;
	}
}


/**
   * Interface allowing implementors direct control over serialisation of properties and other data
   */
GType gxml_serializable_get_type (void) {
	static volatile gsize gxml_serializable_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_serializable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlSerializableIface), (GBaseInitFunc) gxml_serializable_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gxml_serializable_type_id;
		gxml_serializable_type_id = g_type_register_static (G_TYPE_INTERFACE, "GXmlSerializable", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gxml_serializable_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&gxml_serializable_type_id__volatile, gxml_serializable_type_id);
	}
	return gxml_serializable_type_id__volatile;
}


GQuark gxml_serializable_error_quark (void) {
	return g_quark_from_static_string ("gxml_serializable_error-quark");
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



