/* Node.c generated by valac 0.28.1, the Vala compiler
 * generated from Node.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; c-basic-offset: 0; tab-width: 2 -*- */
/* ObjectModel.vala
 *
 * Copyright (C) 2015  Daniel Espinosa <esodan@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      Daniel Espinosa <esodan@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define GXML_TYPE_NODE (gxml_node_get_type ())
#define GXML_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NODE, GXmlNode))
#define GXML_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NODE))
#define GXML_NODE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NODE, GXmlNodeIface))

typedef struct _GXmlNode GXmlNode;
typedef struct _GXmlNodeIface GXmlNodeIface;

#define GXML_TYPE_NAMESPACE (gxml_namespace_get_type ())
#define GXML_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NAMESPACE, GXmlNamespace))
#define GXML_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NAMESPACE))
#define GXML_NAMESPACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NAMESPACE, GXmlNamespaceIface))

typedef struct _GXmlNamespace GXmlNamespace;
typedef struct _GXmlNamespaceIface GXmlNamespaceIface;

#define GXML_TYPE_NODE_TYPE (gxml_node_type_get_type ())

#define GXML_TYPE_DOCUMENT (gxml_document_get_type ())
#define GXML_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOCUMENT, GXmlDocument))
#define GXML_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOCUMENT))
#define GXML_DOCUMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOCUMENT, GXmlDocumentIface))

typedef struct _GXmlDocument GXmlDocument;
typedef struct _GXmlDocumentIface GXmlDocumentIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GXML_TYPE_ELEMENT (gxml_element_get_type ())
#define GXML_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ELEMENT, GXmlElement))
#define GXML_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ELEMENT))
#define GXML_ELEMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_ELEMENT, GXmlElementIface))

typedef struct _GXmlElement GXmlElement;
typedef struct _GXmlElementIface GXmlElementIface;

#define GXML_TYPE_TEXT (gxml_text_get_type ())
#define GXML_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_TEXT, GXmlText))
#define GXML_IS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_TEXT))
#define GXML_TEXT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_TEXT, GXmlTextIface))

typedef struct _GXmlText GXmlText;
typedef struct _GXmlTextIface GXmlTextIface;

struct _GXmlNamespaceIface {
	GTypeInterface parent_iface;
	const gchar* (*get_uri) (GXmlNamespace* self);
	const gchar* (*get_prefix) (GXmlNamespace* self);
};

typedef enum  {
	GXML_NODE_TYPE_X_UNKNOWN = 0,
	GXML_NODE_TYPE_ELEMENT = 1,
	GXML_NODE_TYPE_ATTRIBUTE,
	GXML_NODE_TYPE_TEXT,
	GXML_NODE_TYPE_CDATA_SECTION,
	GXML_NODE_TYPE_ENTITY_REFERENCE,
	GXML_NODE_TYPE_ENTITY,
	GXML_NODE_TYPE_PROCESSING_INSTRUCTION,
	GXML_NODE_TYPE_COMMENT,
	GXML_NODE_TYPE_DOCUMENT,
	GXML_NODE_TYPE_DOCUMENT_TYPE,
	GXML_NODE_TYPE_DOCUMENT_FRAGMENT,
	GXML_NODE_TYPE_NOTATION
} GXmlNodeType;

struct _GXmlDocumentIface {
	GTypeInterface parent_iface;
	GXmlNode* (*create_element) (GXmlDocument* self, const gchar* name);
	GXmlNode* (*create_text) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_comment) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_cdata) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_pi) (GXmlDocument* self, const gchar* target, const gchar* data);
	gboolean (*save) (GXmlDocument* self, GCancellable* cancellable, GError** error);
	gboolean (*save_as) (GXmlDocument* self, GFile* f, GCancellable* cancellable, GError** error);
	gboolean (*get_indent) (GXmlDocument* self);
	void (*set_indent) (GXmlDocument* self, gboolean value);
	gboolean (*get_ns_top) (GXmlDocument* self);
	void (*set_ns_top) (GXmlDocument* self, gboolean value);
	gboolean (*get_prefix_default_ns) (GXmlDocument* self);
	void (*set_prefix_default_ns) (GXmlDocument* self, gboolean value);
	GXmlNode* (*get_root) (GXmlDocument* self);
	GFile* (*get_file) (GXmlDocument* self);
	void (*set_file) (GXmlDocument* self, GFile* value);
};

struct _GXmlNodeIface {
	GTypeInterface parent_iface;
	gchar* (*to_string) (GXmlNode* self);
	gboolean (*set_namespace) (GXmlNode* self, const gchar* uri, const gchar* prefix);
	gchar* (*ns_prefix) (GXmlNode* self);
	gchar* (*ns_uri) (GXmlNode* self);
	GeeList* (*get_namespaces) (GXmlNode* self);
	GeeBidirList* (*get_childs) (GXmlNode* self);
	GeeMap* (*get_attrs) (GXmlNode* self);
	const gchar* (*get_name) (GXmlNode* self);
	const gchar* (*get_value) (GXmlNode* self);
	void (*set_value) (GXmlNode* self, const gchar* value);
	GXmlNodeType (*get_type_node) (GXmlNode* self);
	GXmlDocument* (*get_document) (GXmlNode* self);
};

struct _GXmlElementIface {
	GTypeInterface parent_iface;
	void (*normalize) (GXmlElement* self);
	void (*set_attr) (GXmlElement* self, const gchar* name, const gchar* value);
	GXmlNode* (*get_attr) (GXmlElement* self, const gchar* name);
	void (*finalize_attr) (GXmlElement* self);
	const gchar* (*get_tag_name) (GXmlElement* self);
	gchar* (*get_content) (GXmlElement* self);
	void (*set_content) (GXmlElement* self, const gchar* value);
};

struct _GXmlTextIface {
	GTypeInterface parent_iface;
	const gchar* (*get_str) (GXmlText* self);
};



GType gxml_namespace_get_type (void) G_GNUC_CONST;
GType gxml_node_type_get_type (void) G_GNUC_CONST;
GType gxml_document_get_type (void) G_GNUC_CONST;
GType gxml_node_get_type (void) G_GNUC_CONST;
gchar* gxml_node_to_string (GXmlNode* self);
gboolean gxml_node_set_namespace (GXmlNode* self, const gchar* uri, const gchar* prefix);
gchar* gxml_node_ns_prefix (GXmlNode* self);
static gchar* gxml_node_real_ns_prefix (GXmlNode* self);
GeeList* gxml_node_get_namespaces (GXmlNode* self);
const gchar* gxml_namespace_get_prefix (GXmlNamespace* self);
gchar* gxml_node_ns_uri (GXmlNode* self);
static gchar* gxml_node_real_ns_uri (GXmlNode* self);
const gchar* gxml_namespace_get_uri (GXmlNamespace* self);
gboolean gxml_node_copy (GXmlDocument* doc, GXmlNode* node, GXmlNode* source, gboolean deep);
GType gxml_element_get_type (void) G_GNUC_CONST;
GeeMap* gxml_node_get_attrs (GXmlNode* self);
void gxml_element_set_attr (GXmlElement* self, const gchar* name, const gchar* value);
const gchar* gxml_node_get_name (GXmlNode* self);
const gchar* gxml_node_get_value (GXmlNode* self);
GeeBidirList* gxml_node_get_childs (GXmlNode* self);
GXmlNode* gxml_document_create_element (GXmlDocument* self, const gchar* name);
GType gxml_text_get_type (void) G_GNUC_CONST;
GXmlNode* gxml_document_create_text (GXmlDocument* self, const gchar* text);
void gxml_node_set_value (GXmlNode* self, const gchar* value);
GXmlNodeType gxml_node_get_type_node (GXmlNode* self);
GXmlDocument* gxml_node_get_document (GXmlNode* self);


/**
   * Node's string representation.
   */
gchar* gxml_node_to_string (GXmlNode* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->to_string (self);
}


/**
   * Set a namespace to this node.
   *
   * Search for existing document's namespaces and applies it if found or creates
   * a new one, appending to document's namespaces collection.
   */
gboolean gxml_node_set_namespace (GXmlNode* self, const gchar* uri, const gchar* prefix) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_NODE_GET_INTERFACE (self)->set_namespace (self, uri, prefix);
}


/**
   * Node's defaults namespace's prefix.
   *
   * This allways returns first {@link GXml.Namespace}'s prefix in {@link GXml.Node}'s
    * namespaces collection.
   */
static gchar* gxml_node_real_ns_prefix (GXmlNode* self) {
	gchar* result = NULL;
	GeeList* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	GXmlNamespace* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	_tmp0_ = gxml_node_get_namespaces (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_list_first (_tmp1_);
	_tmp3_ = (GXmlNamespace*) _tmp2_;
	_tmp4_ = gxml_namespace_get_prefix (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp3_);
	result = _tmp7_;
	return result;
}


gchar* gxml_node_ns_prefix (GXmlNode* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->ns_prefix (self);
}


/**
   * Node's defaults namespace's URI.
   *
   * This allways returns first {@link GXml.Namespace}'s URI in {@link GXml.Node}'s
   * namespaces collection.
   */
static gchar* gxml_node_real_ns_uri (GXmlNode* self) {
	gchar* result = NULL;
	GeeList* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	GXmlNamespace* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	_tmp0_ = gxml_node_get_namespaces (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_list_first (_tmp1_);
	_tmp3_ = (GXmlNamespace*) _tmp2_;
	_tmp4_ = gxml_namespace_get_uri (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp3_);
	result = _tmp7_;
	return result;
}


gchar* gxml_node_ns_uri (GXmlNode* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->ns_uri (self);
}


/**
   * Copy a {@link GXml.Node} relaing on {@link GXml.Document} to other {@link GXml.Node}.
   *
   * node could belongs from different {@link GXml.Document}, while source is a node
   * belonging to given document.
   *
   * Just {@link GXml.Element} objects are supported. For attributes, use
   * {@link GXml.Element.set_attr} method, passing source's name and value as arguments.
   *
   * @param doc a {@link GXml.Document} owning destiny node
   * @param node a {@link GXml.Element} to copy nodes to
   * @param source a {@link GXml.Element} to copy nodes from, it could be holded by different {@link GXml.Document}
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gboolean gxml_node_copy (GXmlDocument* doc, GXmlNode* node, GXmlNode* source, gboolean deep) {
	gboolean result = FALSE;
	GXmlNode* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GXmlNode* _tmp2_ = NULL;
	g_return_val_if_fail (doc != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = node;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GXML_TYPE_DOCUMENT)) {
		result = FALSE;
		return result;
	}
	_tmp2_ = source;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GXML_TYPE_ELEMENT)) {
		GXmlNode* _tmp3_ = NULL;
		_tmp3_ = node;
		_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GXML_TYPE_ELEMENT);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		{
			GeeIterator* _p_it = NULL;
			GXmlNode* _tmp4_ = NULL;
			GeeMap* _tmp5_ = NULL;
			GeeMap* _tmp6_ = NULL;
			GeeCollection* _tmp7_ = NULL;
			GeeCollection* _tmp8_ = NULL;
			GeeCollection* _tmp9_ = NULL;
			GeeIterator* _tmp10_ = NULL;
			GeeIterator* _tmp11_ = NULL;
			_tmp4_ = source;
			_tmp5_ = gxml_node_get_attrs (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = gee_map_get_values (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = _tmp8_;
			_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
			_tmp11_ = _tmp10_;
			_g_object_unref0 (_tmp9_);
			_p_it = _tmp11_;
			while (TRUE) {
				GeeIterator* _tmp12_ = NULL;
				gboolean _tmp13_ = FALSE;
				GXmlNode* p = NULL;
				GeeIterator* _tmp14_ = NULL;
				gpointer _tmp15_ = NULL;
				GXmlNode* _tmp16_ = NULL;
				GXmlNode* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
				const gchar* _tmp19_ = NULL;
				GXmlNode* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				_tmp12_ = _p_it;
				_tmp13_ = gee_iterator_next (_tmp12_);
				if (!_tmp13_) {
					break;
				}
				_tmp14_ = _p_it;
				_tmp15_ = gee_iterator_get (_tmp14_);
				p = (GXmlNode*) _tmp15_;
				_tmp16_ = node;
				_tmp17_ = p;
				_tmp18_ = gxml_node_get_name (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = p;
				_tmp21_ = gxml_node_get_value (_tmp20_);
				_tmp22_ = _tmp21_;
				gxml_element_set_attr (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GXML_TYPE_ELEMENT, GXmlElement), _tmp19_, _tmp22_);
				_g_object_unref0 (p);
			}
			_g_object_unref0 (_p_it);
		}
		{
			GeeBidirList* _c_list = NULL;
			GXmlNode* _tmp23_ = NULL;
			GeeBidirList* _tmp24_ = NULL;
			GeeBidirList* _tmp25_ = NULL;
			GeeBidirList* _tmp26_ = NULL;
			gint _c_size = 0;
			GeeBidirList* _tmp27_ = NULL;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			gint _c_index = 0;
			_tmp23_ = source;
			_tmp24_ = gxml_node_get_childs (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = _g_object_ref0 (_tmp25_);
			_c_list = _tmp26_;
			_tmp27_ = _c_list;
			_tmp28_ = gee_collection_get_size ((GeeCollection*) _tmp27_);
			_tmp29_ = _tmp28_;
			_c_size = _tmp29_;
			_c_index = -1;
			while (TRUE) {
				gint _tmp30_ = 0;
				gint _tmp31_ = 0;
				gint _tmp32_ = 0;
				GXmlNode* c = NULL;
				GeeBidirList* _tmp33_ = NULL;
				gint _tmp34_ = 0;
				gpointer _tmp35_ = NULL;
				GXmlNode* _tmp36_ = NULL;
				GXmlNode* _tmp54_ = NULL;
				_tmp30_ = _c_index;
				_c_index = _tmp30_ + 1;
				_tmp31_ = _c_index;
				_tmp32_ = _c_size;
				if (!(_tmp31_ < _tmp32_)) {
					break;
				}
				_tmp33_ = _c_list;
				_tmp34_ = _c_index;
				_tmp35_ = gee_list_get ((GeeList*) _tmp33_, _tmp34_);
				c = (GXmlNode*) _tmp35_;
				_tmp36_ = c;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, GXML_TYPE_ELEMENT)) {
					GXmlNode* _tmp37_ = NULL;
					const gchar* _tmp38_ = NULL;
					const gchar* _tmp39_ = NULL;
					gboolean _tmp40_ = FALSE;
					GXmlNode* e = NULL;
					GXmlDocument* _tmp41_ = NULL;
					GXmlNode* _tmp42_ = NULL;
					const gchar* _tmp43_ = NULL;
					const gchar* _tmp44_ = NULL;
					GXmlNode* _tmp45_ = NULL;
					GXmlNode* _tmp46_ = NULL;
					GeeBidirList* _tmp47_ = NULL;
					GeeBidirList* _tmp48_ = NULL;
					GXmlNode* _tmp49_ = NULL;
					GXmlDocument* _tmp50_ = NULL;
					GXmlNode* _tmp51_ = NULL;
					GXmlNode* _tmp52_ = NULL;
					gboolean _tmp53_ = FALSE;
					_tmp37_ = c;
					_tmp38_ = gxml_node_get_name (_tmp37_);
					_tmp39_ = _tmp38_;
					if (_tmp39_ == NULL) {
						_g_object_unref0 (c);
						continue;
					}
					_tmp40_ = deep;
					if (!_tmp40_) {
						_g_object_unref0 (c);
						continue;
					}
					_tmp41_ = doc;
					_tmp42_ = c;
					_tmp43_ = gxml_node_get_name (_tmp42_);
					_tmp44_ = _tmp43_;
					_tmp45_ = gxml_document_create_element (_tmp41_, _tmp44_);
					e = _tmp45_;
					_tmp46_ = node;
					_tmp47_ = gxml_node_get_childs (_tmp46_);
					_tmp48_ = _tmp47_;
					_tmp49_ = e;
					gee_collection_add ((GeeCollection*) _tmp48_, _tmp49_);
					_tmp50_ = doc;
					_tmp51_ = e;
					_tmp52_ = c;
					_tmp53_ = deep;
					gxml_node_copy (_tmp50_, _tmp51_, _tmp52_, _tmp53_);
					_g_object_unref0 (e);
				}
				_tmp54_ = c;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp54_, GXML_TYPE_TEXT)) {
					GXmlNode* _tmp55_ = NULL;
					const gchar* _tmp56_ = NULL;
					const gchar* _tmp57_ = NULL;
					GXmlNode* t = NULL;
					GXmlDocument* _tmp59_ = NULL;
					GXmlNode* _tmp60_ = NULL;
					const gchar* _tmp61_ = NULL;
					const gchar* _tmp62_ = NULL;
					GXmlNode* _tmp63_ = NULL;
					GXmlNode* _tmp64_ = NULL;
					GeeBidirList* _tmp65_ = NULL;
					GeeBidirList* _tmp66_ = NULL;
					GXmlNode* _tmp67_ = NULL;
					_tmp55_ = c;
					_tmp56_ = gxml_node_get_value (_tmp55_);
					_tmp57_ = _tmp56_;
					if (_tmp57_ == NULL) {
						const gchar* _tmp58_ = NULL;
						_tmp58_ = _ ("Text node with NULL string");
						g_warning ("Node.vala:134: %s", _tmp58_);
						_g_object_unref0 (c);
						continue;
					}
					_tmp59_ = doc;
					_tmp60_ = c;
					_tmp61_ = gxml_node_get_value (_tmp60_);
					_tmp62_ = _tmp61_;
					_tmp63_ = gxml_document_create_text (_tmp59_, _tmp62_);
					t = _tmp63_;
					_tmp64_ = node;
					_tmp65_ = gxml_node_get_childs (_tmp64_);
					_tmp66_ = _tmp65_;
					_tmp67_ = t;
					gee_collection_add ((GeeCollection*) _tmp66_, _tmp67_);
					_g_object_unref0 (t);
				}
				_g_object_unref0 (c);
			}
			_g_object_unref0 (_c_list);
		}
	}
	result = FALSE;
	return result;
}


GeeList* gxml_node_get_namespaces (GXmlNode* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->get_namespaces (self);
}


GeeBidirList* gxml_node_get_childs (GXmlNode* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->get_childs (self);
}


GeeMap* gxml_node_get_attrs (GXmlNode* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->get_attrs (self);
}


const gchar* gxml_node_get_name (GXmlNode* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->get_name (self);
}


const gchar* gxml_node_get_value (GXmlNode* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->get_value (self);
}


void gxml_node_set_value (GXmlNode* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	GXML_NODE_GET_INTERFACE (self)->set_value (self, value);
}


GXmlNodeType gxml_node_get_type_node (GXmlNode* self) {
	g_return_val_if_fail (self != NULL, 0);
	return GXML_NODE_GET_INTERFACE (self)->get_type_node (self);
}


GXmlDocument* gxml_node_get_document (GXmlNode* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->get_document (self);
}


static void gxml_node_base_init (GXmlNodeIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		   * Collection of Namespaces applied to this {@link GXml.Node}.
		   */
		g_object_interface_install_property (iface, g_param_spec_object ("namespaces", "namespaces", "namespaces", GEE_TYPE_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		/**
		   * Collection of {@link GXml.Node} as childs.
		   *
		   * Depend on {@link GXml.Node} type, this childs could of different, like,
		   * elements, element's contents or properties.
		   */
		g_object_interface_install_property (iface, g_param_spec_object ("childs", "childs", "childs", GEE_TYPE_BIDIR_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		/**
		   * Attributes in this {@link GXml.Node}.
		   */
		g_object_interface_install_property (iface, g_param_spec_object ("attrs", "attrs", "attrs", GEE_TYPE_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		/**
		   * Node's name. The meaning differs, depending on node's type.
		   */
		g_object_interface_install_property (iface, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		/**
		   * Node's value. The meaning differs, depending on node's type.
		   */
		g_object_interface_install_property (iface, g_param_spec_string ("value", "value", "value", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		/**
		   * Node's type as a enumeration.
		   */
		g_object_interface_install_property (iface, g_param_spec_enum ("type-node", "type-node", "type-node", GXML_TYPE_NODE_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		/**
		   * Node's XML document holding this node.
		   */
		g_object_interface_install_property (iface, g_param_spec_object ("document", "document", "document", GXML_TYPE_DOCUMENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		iface->ns_prefix = gxml_node_real_ns_prefix;
		iface->ns_uri = gxml_node_real_ns_uri;
	}
}


/**
 * Base interface providing basic functionalities to all GXml interfaces.
 */
GType gxml_node_get_type (void) {
	static volatile gsize gxml_node_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlNodeIface), (GBaseInitFunc) gxml_node_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gxml_node_type_id;
		gxml_node_type_id = g_type_register_static (G_TYPE_INTERFACE, "GXmlNode", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gxml_node_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&gxml_node_type_id__volatile, gxml_node_type_id);
	}
	return gxml_node_type_id__volatile;
}



