/*
  gyrus-admin-mailbox.h

  GYRUS -- GNOME Cyrus Administrator. Administrator Mailboxes Modules.

  Copyright (C) 2003-2004 Alejandro Valds Jimnez <avaldes@utalca.cl>
  Copyright (C) 2003-2004 Jorge Bustos Bustos <jbustos@utalca.cl>
  Copyright (C) 2003-2004 Claudio Saavedra Valds <csaavedra@alumnos.utalca.cl>
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  
*/

#ifndef GYRUS_ADMIN_MAILBOX_H
#define GYRUS_ADMIN_MAILBOX_H


gboolean
gyrus_admin_mailbox_get_quota (GyrusAdmin *admin, const gchar *mailbox_path,
			       gint *quota_limit, gint *quota_used, gchar **message);

gboolean
gyrus_admin_mailbox_set_quota (GyrusAdmin *admin, const gchar *mailbox_path,
			       gdouble new_quota);

void
gyrus_admin_mailbox_clear_info (GyrusAdmin *admin);

void
gyrus_admin_mailbox_show_info (GyrusAdmin *admin, const gchar *user,
			       const gchar *mailbox_path);

void
gyrus_admin_mailbox_on_button_quota_apply_clicked (GtkButton *button,
						   gpointer userdata);
void
gyrus_admin_mailbox_on_entry_quota_new_activate (GtkEntry *entry,
						 gpointer user_data);

void
gyrus_admin_mailbox_set_sensitive (GyrusAdmin *admin, gboolean status);

gboolean
gyrus_admin_mailbox_new (GyrusAdmin *admin, const gchar *mailbox,
			 const gchar *path, gdouble quota, gchar **error);
void
gyrus_admin_mailbox_delete_all (GyrusAdmin *admin, const gchar *mailbox);

void
gyrus_admin_delete_selected_acl_entry (GyrusAdmin *admin);

void
gyrus_admin_start_editing_selected_acl (GyrusAdmin *admin);

gboolean
gyrus_admin_acl_has_selection (GyrusAdmin *admin);

void
gyrus_admin_add_acl_entry (GyrusAdmin *admin);

#endif /* GYRUS_ADMIN_MAILBOX_H */
