/* iagno.c generated by valac 0.22.0.22-b05f, the Vala compiler
 * generated from iagno.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <canberra-gtk.h>
#include <canberra.h>
#include <locale.h>


#define TYPE_IAGNO (iagno_get_type ())
#define IAGNO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IAGNO, Iagno))
#define IAGNO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IAGNO, IagnoClass))
#define IS_IAGNO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IAGNO))
#define IS_IAGNO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IAGNO))
#define IAGNO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IAGNO, IagnoClass))

typedef struct _Iagno Iagno;
typedef struct _IagnoClass IagnoClass;
typedef struct _IagnoPrivate IagnoPrivate;

#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;

#define TYPE_COMPUTER_PLAYER (computer_player_get_type ())
#define COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayer))
#define COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))
#define IS_COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPUTER_PLAYER))
#define IS_COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPUTER_PLAYER))
#define COMPUTER_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))

typedef struct _ComputerPlayer ComputerPlayer;
typedef struct _ComputerPlayerClass ComputerPlayerClass;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PLAYER (player_get_type ())
typedef struct _IagnoShowMessageData IagnoShowMessageData;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _Iagno {
	GtkApplication parent_instance;
	IagnoPrivate * priv;
};

struct _IagnoClass {
	GtkApplicationClass parent_class;
};

struct _IagnoPrivate {
	GSettings* settings;
	GtkWindow* window;
	gint window_width;
	gint window_height;
	gboolean is_fullscreen;
	gboolean is_maximized;
	GtkInfoBar* infobar;
	GtkStatusbar* statusbar;
	guint statusbar_id;
	GameView* view;
	GtkLabel* infobar_label;
	GtkLabel* dark_label;
	GtkLabel* light_label;
	GtkLabel* dark_score_label;
	GtkLabel* light_score_label;
	GSimpleAction* undo_action;
	ComputerPlayer* light_computer;
	ComputerPlayer* dark_computer;
	guint computer_timer;
	Game* game;
};

typedef enum  {
	PLAYER_NONE,
	PLAYER_LIGHT,
	PLAYER_DARK
} Player;

struct _IagnoShowMessageData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Iagno* self;
	gchar* message;
	GtkMessageType type;
	GtkInfoBar* _tmp0_;
	GtkInfoBar* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GtkInfoBar* _tmp4_;
	GtkMessageType _tmp5_;
	GtkLabel* _tmp6_;
	const gchar* _tmp7_;
	GtkInfoBar* _tmp8_;
};


static gpointer iagno_parent_class = NULL;

GType iagno_get_type (void) G_GNUC_CONST;
GType game_view_get_type (void) G_GNUC_CONST;
GType computer_player_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define IAGNO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_IAGNO, IagnoPrivate))
enum  {
	IAGNO_DUMMY_PROPERTY
};
static void iagno_new_game_cb (Iagno* self);
static void _iagno_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_undo_move_cb (Iagno* self);
static void _iagno_undo_move_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_preferences_cb (Iagno* self);
static void _iagno_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_help_cb (Iagno* self);
static void _iagno_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_about_cb (Iagno* self);
static void _iagno_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_quit_cb (Iagno* self);
static void _iagno_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_real_startup (GApplication* base);
Iagno* iagno_new (void);
Iagno* iagno_construct (GType object_type);
static void iagno_real_activate (GApplication* base);
static gboolean iagno_window_configure_event_cb (Iagno* self, GdkEventConfigure* event);
static gboolean _iagno_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self);
static gboolean iagno_window_state_event_cb (Iagno* self, GdkEventWindowState* event);
static gboolean _iagno_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
void game_view_set_game (GameView* self, Game* value);
static void iagno_player_move_cb (Iagno* self, gint x, gint y);
static void _iagno_player_move_cb_game_view_move (GameView* _sender, gint x, gint y, gpointer self);
void game_view_set_show_grid (GameView* self, gboolean value);
void game_view_set_flip_final_result (GameView* self, gboolean value);
void game_view_set_theme (GameView* self, const gchar* value);
static void iagno_start_game (Iagno* self);
static void iagno_real_shutdown (GApplication* base);
static void iagno_cancel_pending_computer_moves (Iagno* self);
Game* game_new (gint width, gint height);
Game* game_construct (GType object_type, gint width, gint height);
static void iagno_game_move_cb (Iagno* self, Game* g);
static void _iagno_game_move_cb_game_move (Game* _sender, gpointer self);
static void iagno_game_complete_cb (Iagno* self);
static void _iagno_game_complete_cb_game_complete (Game* _sender, gpointer self);
ComputerPlayer* computer_player_new (Game* game, gint level);
ComputerPlayer* computer_player_construct (GType object_type, Game* game, gint level);
static void iagno_update_ui (Iagno* self);
static gboolean iagno_computer_move_cb (Iagno* self);
static gboolean _iagno_computer_move_cb_gsource_func (gpointer self);
gboolean game_can_undo (Game* self);
GType player_get_type (void) G_GNUC_CONST;
Player game_get_current_color (Game* self);
gint game_get_n_dark_tiles (Game* self);
gint game_get_n_light_tiles (Game* self);
void game_undo (Game* self, gint count);
gboolean game_can_move (Game* self, Player color);
static void iagno_show_preferences_dialog (Iagno* self);
static void iagno_show_message_data_free (gpointer _data);
static void iagno_show_message (Iagno* self, const gchar* message, GtkMessageType type, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void iagno_show_message_finish (Iagno* self, GAsyncResult* _res_);
static gboolean iagno_show_message_co (IagnoShowMessageData* _data_);
static gboolean _iagno_show_message_co_gsource_func (gpointer self);
static void iagno_play_sound (Iagno* self, const gchar* name);
void game_pass (Game* self);
gint computer_player_get_level (ComputerPlayer* self);
void computer_player_move (ComputerPlayer* self);
gint game_place_tile (Game* self, gint x, gint y);
static void iagno_dark_level_changed_cb (Iagno* self, GtkComboBox* combo);
static void iagno_light_level_changed_cb (Iagno* self, GtkComboBox* combo);
static void iagno_sound_select (Iagno* self, GtkToggleButton* widget);
static void iagno_grid_toggled_cb (Iagno* self, GtkToggleButton* widget);
gboolean game_view_get_show_grid (GameView* self);
static void iagno_flip_final_toggled_cb (Iagno* self, GtkToggleButton* widget);
gboolean game_view_get_flip_final_result (GameView* self);
static void iagno_propbox_response_cb (Iagno* self, GtkWidget* widget, gint response_id);
static gboolean iagno_propbox_close_cb (Iagno* self, GtkWidget* widget, GdkEventAny* event);
static void iagno_theme_changed_cb (Iagno* self, GtkComboBox* widget);
void game_view_redraw (GameView* self);
static void _iagno_propbox_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static gboolean _iagno_propbox_close_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void _iagno_dark_level_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void _iagno_light_level_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void _iagno_sound_select_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _iagno_grid_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _iagno_flip_final_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void _iagno_theme_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
gint iagno_main (gchar** args, int args_length1);
static void iagno_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GActionEntry IAGNO_app_actions[6] = {{"new-game", _iagno_new_game_cb_gsimple_action_activate_callback}, {"undo-move", _iagno_undo_move_cb_gsimple_action_activate_callback}, {"preferences", _iagno_preferences_cb_gsimple_action_activate_callback}, {"help", _iagno_help_cb_gsimple_action_activate_callback}, {"about", _iagno_about_cb_gsimple_action_activate_callback}, {"quit", _iagno_quit_cb_gsimple_action_activate_callback}};

static void _iagno_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	iagno_new_game_cb (self);
}


static void _iagno_undo_move_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	iagno_undo_move_cb (self);
}


static void _iagno_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	iagno_preferences_cb (self);
}


static void _iagno_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	iagno_help_cb (self);
}


static void _iagno_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	iagno_about_cb (self);
}


static void _iagno_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	iagno_quit_cb (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void iagno_real_startup (GApplication* base) {
	Iagno * self;
	GAction* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	self = (Iagno*) base;
	G_APPLICATION_CLASS (iagno_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
	g_action_map_add_action_entries ((GActionMap*) self, IAGNO_app_actions, G_N_ELEMENTS (IAGNO_app_actions), self);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "undo-move");
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp0_) : NULL);
	_g_object_unref0 (self->priv->undo_action);
	self->priv->undo_action = _tmp1_;
}


Iagno* iagno_construct (GType object_type) {
	Iagno * self = NULL;
	self = (Iagno*) g_object_new (object_type, "application-id", "org.gnome.iagno", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	return self;
}


Iagno* iagno_new (void) {
	return iagno_construct (TYPE_IAGNO);
}


static gboolean _iagno_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self) {
	gboolean result;
	result = iagno_window_configure_event_cb (self, event);
	return result;
}


static gboolean _iagno_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = iagno_window_state_event_cb (self, event);
	return result;
}


static void _iagno_player_move_cb_game_view_move (GameView* _sender, gint x, gint y, gpointer self) {
	iagno_player_move_cb (self, x, y);
}


static void iagno_real_activate (GApplication* base) {
	Iagno * self;
	GtkWindow* _tmp0_ = NULL;
	GSettings* _tmp2_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp3_ = NULL;
	GtkBuilder* _tmp8_ = NULL;
	GObject* _tmp9_ = NULL;
	GtkGrid* top_grid = NULL;
	GtkBuilder* _tmp10_ = NULL;
	GObject* _tmp11_ = NULL;
	GtkGrid* _tmp12_ = NULL;
	GtkBuilder* _tmp13_ = NULL;
	GObject* _tmp14_ = NULL;
	GtkWindow* _tmp15_ = NULL;
	GtkWindow* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	GtkWindow* _tmp18_ = NULL;
	GtkWindow* _tmp19_ = NULL;
	GtkWindow* _tmp20_ = NULL;
	GSettings* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	GSettings* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	GSettings* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	GtkHeaderBar* headerbar = NULL;
	GtkHeaderBar* _tmp31_ = NULL;
	GtkHeaderBar* _tmp32_ = NULL;
	GtkHeaderBar* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	GtkHeaderBar* _tmp35_ = NULL;
	GtkWindow* _tmp36_ = NULL;
	GtkHeaderBar* _tmp37_ = NULL;
	GtkWindow* _tmp38_ = NULL;
	GameView* _tmp39_ = NULL;
	GameView* _tmp40_ = NULL;
	GameView* _tmp41_ = NULL;
	GameView* _tmp42_ = NULL;
	Game* _tmp43_ = NULL;
	GameView* _tmp44_ = NULL;
	GameView* _tmp45_ = NULL;
	GSettings* _tmp46_ = NULL;
	gboolean _tmp47_ = FALSE;
	GameView* _tmp48_ = NULL;
	GSettings* _tmp49_ = NULL;
	gboolean _tmp50_ = FALSE;
	gchar* tile_set = NULL;
	GSettings* _tmp51_ = NULL;
	gchar* _tmp52_ = NULL;
	GameView* _tmp53_ = NULL;
	const gchar* _tmp54_ = NULL;
	gchar* _tmp55_ = NULL;
	gchar* _tmp56_ = NULL;
	GameView* _tmp57_ = NULL;
	GtkGrid* _tmp58_ = NULL;
	GameView* _tmp59_ = NULL;
	GtkInfoBar* _tmp60_ = NULL;
	GtkGrid* _tmp61_ = NULL;
	GtkInfoBar* _tmp62_ = NULL;
	GtkLabel* _tmp63_ = NULL;
	GtkLabel* _tmp64_ = NULL;
	GtkInfoBar* _tmp65_ = NULL;
	GtkLabel* _tmp66_ = NULL;
	GtkStatusbar* _tmp67_ = NULL;
	GtkStatusbar* _tmp68_ = NULL;
	GtkToolbar* toolbar = NULL;
	GtkBuilder* _tmp69_ = NULL;
	GObject* _tmp70_ = NULL;
	GtkToolbar* _tmp71_ = NULL;
	GtkToolbar* _tmp72_ = NULL;
	GtkToolbar* _tmp73_ = NULL;
	GtkStyleContext* _tmp74_ = NULL;
	GtkToolbar* _tmp75_ = NULL;
	GtkSeparatorToolItem* _tmp76_ = NULL;
	GtkSeparatorToolItem* _tmp77_ = NULL;
	GtkToolItem* status_item = NULL;
	GtkToolItem* _tmp78_ = NULL;
	GtkToolItem* _tmp79_ = NULL;
	GtkToolItem* _tmp80_ = NULL;
	GtkAlignment* status_alignment = NULL;
	GtkAlignment* _tmp81_ = NULL;
	GtkAlignment* _tmp82_ = NULL;
	GtkStatusbar* _tmp83_ = NULL;
	GtkToolItem* _tmp84_ = NULL;
	GtkAlignment* _tmp85_ = NULL;
	GtkToolbar* _tmp86_ = NULL;
	GtkToolItem* _tmp87_ = NULL;
	GtkToolbar* _tmp88_ = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp89_ = NULL;
	GtkGrid* _tmp90_ = NULL;
	GtkGrid* _tmp91_ = NULL;
	GtkStatusbar* _tmp92_ = NULL;
	GtkGrid* _tmp93_ = NULL;
	const gchar* _tmp94_ = NULL;
	GtkLabel* _tmp95_ = NULL;
	GtkLabel* _tmp96_ = NULL;
	GtkGrid* _tmp97_ = NULL;
	GtkLabel* _tmp98_ = NULL;
	GtkLabel* _tmp99_ = NULL;
	GtkLabel* _tmp100_ = NULL;
	GtkGrid* _tmp101_ = NULL;
	GtkLabel* _tmp102_ = NULL;
	const gchar* _tmp103_ = NULL;
	GtkLabel* _tmp104_ = NULL;
	GtkLabel* _tmp105_ = NULL;
	GtkGrid* _tmp106_ = NULL;
	GtkLabel* _tmp107_ = NULL;
	GtkLabel* _tmp108_ = NULL;
	GtkLabel* _tmp109_ = NULL;
	GtkGrid* _tmp110_ = NULL;
	GtkLabel* _tmp111_ = NULL;
	GtkStatusbar* _tmp112_ = NULL;
	guint _tmp113_ = 0U;
	GtkWindow* _tmp114_ = NULL;
	GError * _inner_error_ = NULL;
	self = (Iagno*) base;
	_tmp0_ = self->priv->window;
	if (_tmp0_ != NULL) {
		GtkWindow* _tmp1_ = NULL;
		_tmp1_ = self->priv->window;
		gtk_widget_show ((GtkWidget*) _tmp1_);
		return;
	}
	_tmp2_ = g_settings_new ("org.gnome.iagno");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp2_;
	_tmp3_ = gtk_builder_new ();
	builder = _tmp3_;
	{
		GtkBuilder* _tmp4_ = NULL;
		_tmp4_ = builder;
		gtk_builder_add_from_file (_tmp4_, DATA_DIRECTORY "/iagno.ui", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		FILE* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = stderr;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp5_, "Could not load UI: %s\n", _tmp7_);
		_g_error_free0 (e);
		_g_object_unref0 (builder);
		return;
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp8_ = builder;
	_tmp9_ = gtk_builder_get_object (_tmp8_, "iagno-menu");
	gtk_application_set_app_menu ((GtkApplication*) self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, g_menu_model_get_type ()) ? ((GMenuModel*) _tmp9_) : NULL);
	_tmp10_ = builder;
	_tmp11_ = gtk_builder_get_object (_tmp10_, "grid");
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, GTK_TYPE_GRID) ? ((GtkGrid*) _tmp11_) : NULL);
	top_grid = _tmp12_;
	_tmp13_ = builder;
	_tmp14_ = gtk_builder_get_object (_tmp13_, "window");
	_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, GTK_TYPE_WINDOW) ? ((GtkWindow*) _tmp14_) : NULL);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp15_;
	_tmp16_ = self->priv->window;
	_tmp17_ = _ ("Iagno");
	gtk_window_set_title (_tmp16_, _tmp17_);
	_tmp18_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp18_, "configure-event", (GCallback) _iagno_window_configure_event_cb_gtk_widget_configure_event, self, 0);
	_tmp19_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp19_, "window-state-event", (GCallback) _iagno_window_state_event_cb_gtk_widget_window_state_event, self, 0);
	_tmp20_ = self->priv->window;
	_tmp21_ = self->priv->settings;
	_tmp22_ = g_settings_get_int (_tmp21_, "window-width");
	_tmp23_ = self->priv->settings;
	_tmp24_ = g_settings_get_int (_tmp23_, "window-height");
	gtk_window_set_default_size (_tmp20_, _tmp22_, _tmp24_);
	_tmp25_ = self->priv->settings;
	_tmp26_ = g_settings_get_boolean (_tmp25_, "window-is-fullscreen");
	if (_tmp26_) {
		GtkWindow* _tmp27_ = NULL;
		_tmp27_ = self->priv->window;
		gtk_window_fullscreen (_tmp27_);
	} else {
		GSettings* _tmp28_ = NULL;
		gboolean _tmp29_ = FALSE;
		_tmp28_ = self->priv->settings;
		_tmp29_ = g_settings_get_boolean (_tmp28_, "window-is-maximized");
		if (_tmp29_) {
			GtkWindow* _tmp30_ = NULL;
			_tmp30_ = self->priv->window;
			gtk_window_maximize (_tmp30_);
		}
	}
	_tmp31_ = (GtkHeaderBar*) gtk_header_bar_new ();
	g_object_ref_sink (_tmp31_);
	headerbar = _tmp31_;
	_tmp32_ = headerbar;
	gtk_header_bar_set_show_close_button (_tmp32_, TRUE);
	_tmp33_ = headerbar;
	_tmp34_ = _ ("Iagno");
	gtk_header_bar_set_title (_tmp33_, _tmp34_);
	_tmp35_ = headerbar;
	gtk_widget_show ((GtkWidget*) _tmp35_);
	_tmp36_ = self->priv->window;
	_tmp37_ = headerbar;
	gtk_window_set_titlebar (_tmp36_, (GtkWidget*) _tmp37_);
	_tmp38_ = self->priv->window;
	gtk_application_add_window ((GtkApplication*) self, _tmp38_);
	_tmp39_ = game_view_new ();
	g_object_ref_sink (_tmp39_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp39_;
	_tmp40_ = self->priv->view;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp40_, TRUE);
	_tmp41_ = self->priv->view;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp41_, TRUE);
	_tmp42_ = self->priv->view;
	_tmp43_ = self->priv->game;
	game_view_set_game (_tmp42_, _tmp43_);
	_tmp44_ = self->priv->view;
	g_signal_connect_object (_tmp44_, "move", (GCallback) _iagno_player_move_cb_game_view_move, self, 0);
	_tmp45_ = self->priv->view;
	_tmp46_ = self->priv->settings;
	_tmp47_ = g_settings_get_boolean (_tmp46_, "show-grid");
	game_view_set_show_grid (_tmp45_, _tmp47_);
	_tmp48_ = self->priv->view;
	_tmp49_ = self->priv->settings;
	_tmp50_ = g_settings_get_boolean (_tmp49_, "flip-final-results");
	game_view_set_flip_final_result (_tmp48_, _tmp50_);
	_tmp51_ = self->priv->settings;
	_tmp52_ = g_settings_get_string (_tmp51_, "tileset");
	tile_set = _tmp52_;
	_tmp53_ = self->priv->view;
	_tmp54_ = tile_set;
	_tmp55_ = g_build_filename (DATA_DIRECTORY, "themes", _tmp54_, NULL);
	_tmp56_ = _tmp55_;
	game_view_set_theme (_tmp53_, _tmp56_);
	_g_free0 (_tmp56_);
	_tmp57_ = self->priv->view;
	gtk_widget_show ((GtkWidget*) _tmp57_);
	_tmp58_ = top_grid;
	_tmp59_ = self->priv->view;
	gtk_grid_attach (_tmp58_, (GtkWidget*) _tmp59_, 0, 3, 1, 1);
	_tmp60_ = (GtkInfoBar*) gtk_info_bar_new ();
	g_object_ref_sink (_tmp60_);
	_g_object_unref0 (self->priv->infobar);
	self->priv->infobar = _tmp60_;
	_tmp61_ = top_grid;
	_tmp62_ = self->priv->infobar;
	gtk_grid_attach (_tmp61_, (GtkWidget*) _tmp62_, 0, 2, 1, 1);
	_tmp63_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp63_);
	_g_object_unref0 (self->priv->infobar_label);
	self->priv->infobar_label = _tmp63_;
	_tmp64_ = self->priv->infobar_label;
	gtk_widget_show ((GtkWidget*) _tmp64_);
	_tmp65_ = self->priv->infobar;
	_tmp66_ = self->priv->infobar_label;
	gtk_container_add ((GtkContainer*) _tmp65_, (GtkWidget*) _tmp66_);
	_tmp67_ = (GtkStatusbar*) gtk_statusbar_new ();
	g_object_ref_sink (_tmp67_);
	_g_object_unref0 (self->priv->statusbar);
	self->priv->statusbar = _tmp67_;
	_tmp68_ = self->priv->statusbar;
	gtk_widget_show ((GtkWidget*) _tmp68_);
	_tmp69_ = builder;
	_tmp70_ = gtk_builder_get_object (_tmp69_, "toolbar");
	_tmp71_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp70_, GTK_TYPE_TOOLBAR) ? ((GtkToolbar*) _tmp70_) : NULL);
	toolbar = _tmp71_;
	_tmp72_ = toolbar;
	gtk_toolbar_set_show_arrow (_tmp72_, FALSE);
	_tmp73_ = toolbar;
	_tmp74_ = gtk_widget_get_style_context ((GtkWidget*) _tmp73_);
	gtk_style_context_add_class (_tmp74_, GTK_STYLE_CLASS_PRIMARY_TOOLBAR);
	_tmp75_ = toolbar;
	_tmp76_ = (GtkSeparatorToolItem*) gtk_separator_tool_item_new ();
	g_object_ref_sink (_tmp76_);
	_tmp77_ = _tmp76_;
	gtk_toolbar_insert (_tmp75_, (GtkToolItem*) _tmp77_, -1);
	_g_object_unref0 (_tmp77_);
	_tmp78_ = gtk_tool_item_new ();
	g_object_ref_sink (_tmp78_);
	status_item = _tmp78_;
	_tmp79_ = status_item;
	gtk_tool_item_set_visible_horizontal (_tmp79_, TRUE);
	_tmp80_ = status_item;
	gtk_tool_item_set_expand (_tmp80_, TRUE);
	_tmp81_ = (GtkAlignment*) gtk_alignment_new (1.0f, 0.5f, 0.0f, 0.0f);
	g_object_ref_sink (_tmp81_);
	status_alignment = _tmp81_;
	_tmp82_ = status_alignment;
	_tmp83_ = self->priv->statusbar;
	gtk_container_add ((GtkContainer*) _tmp82_, (GtkWidget*) _tmp83_);
	_tmp84_ = status_item;
	_tmp85_ = status_alignment;
	gtk_container_add ((GtkContainer*) _tmp84_, (GtkWidget*) _tmp85_);
	_tmp86_ = toolbar;
	_tmp87_ = status_item;
	gtk_toolbar_insert (_tmp86_, _tmp87_, -1);
	_tmp88_ = toolbar;
	gtk_widget_show_all ((GtkWidget*) _tmp88_);
	_tmp89_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp89_);
	grid = _tmp89_;
	_tmp90_ = grid;
	gtk_grid_set_column_spacing (_tmp90_, (guint) 6);
	_tmp91_ = grid;
	gtk_widget_show ((GtkWidget*) _tmp91_);
	_tmp92_ = self->priv->statusbar;
	_tmp93_ = grid;
	gtk_box_pack_start ((GtkBox*) _tmp92_, (GtkWidget*) _tmp93_, FALSE, TRUE, (guint) 0);
	_tmp94_ = _ ("Dark:");
	_tmp95_ = (GtkLabel*) gtk_label_new (_tmp94_);
	g_object_ref_sink (_tmp95_);
	_g_object_unref0 (self->priv->dark_label);
	self->priv->dark_label = _tmp95_;
	_tmp96_ = self->priv->dark_label;
	gtk_widget_show ((GtkWidget*) _tmp96_);
	_tmp97_ = grid;
	_tmp98_ = self->priv->dark_label;
	gtk_grid_attach (_tmp97_, (GtkWidget*) _tmp98_, 1, 0, 1, 1);
	_tmp99_ = (GtkLabel*) gtk_label_new ("00");
	g_object_ref_sink (_tmp99_);
	_g_object_unref0 (self->priv->dark_score_label);
	self->priv->dark_score_label = _tmp99_;
	_tmp100_ = self->priv->dark_score_label;
	gtk_widget_show ((GtkWidget*) _tmp100_);
	_tmp101_ = grid;
	_tmp102_ = self->priv->dark_score_label;
	gtk_grid_attach (_tmp101_, (GtkWidget*) _tmp102_, 2, 0, 1, 1);
	_tmp103_ = _ ("Light:");
	_tmp104_ = (GtkLabel*) gtk_label_new (_tmp103_);
	g_object_ref_sink (_tmp104_);
	_g_object_unref0 (self->priv->light_label);
	self->priv->light_label = _tmp104_;
	_tmp105_ = self->priv->light_label;
	gtk_widget_show ((GtkWidget*) _tmp105_);
	_tmp106_ = grid;
	_tmp107_ = self->priv->light_label;
	gtk_grid_attach (_tmp106_, (GtkWidget*) _tmp107_, 4, 0, 1, 1);
	_tmp108_ = (GtkLabel*) gtk_label_new ("00");
	g_object_ref_sink (_tmp108_);
	_g_object_unref0 (self->priv->light_score_label);
	self->priv->light_score_label = _tmp108_;
	_tmp109_ = self->priv->light_score_label;
	gtk_widget_show ((GtkWidget*) _tmp109_);
	_tmp110_ = grid;
	_tmp111_ = self->priv->light_score_label;
	gtk_grid_attach (_tmp110_, (GtkWidget*) _tmp111_, 5, 0, 1, 1);
	_tmp112_ = self->priv->statusbar;
	_tmp113_ = gtk_statusbar_get_context_id (_tmp112_, "iagno");
	self->priv->statusbar_id = _tmp113_;
	iagno_start_game (self);
	_tmp114_ = self->priv->window;
	gtk_widget_show ((GtkWidget*) _tmp114_);
	_g_object_unref0 (grid);
	_g_object_unref0 (status_alignment);
	_g_object_unref0 (status_item);
	_g_object_unref0 (toolbar);
	_g_free0 (tile_set);
	_g_object_unref0 (headerbar);
	_g_object_unref0 (top_grid);
	_g_object_unref0 (builder);
}


static void iagno_real_shutdown (GApplication* base) {
	Iagno * self;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GSettings* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GSettings* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	self = (Iagno*) base;
	G_APPLICATION_CLASS (iagno_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
	_tmp0_ = self->priv->settings;
	_tmp1_ = self->priv->window_width;
	g_settings_set_int (_tmp0_, "window-width", _tmp1_);
	_tmp2_ = self->priv->settings;
	_tmp3_ = self->priv->window_height;
	g_settings_set_int (_tmp2_, "window-height", _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = self->priv->is_maximized;
	g_settings_set_boolean (_tmp4_, "window-is-maximized", _tmp5_);
	_tmp6_ = self->priv->settings;
	_tmp7_ = self->priv->is_fullscreen;
	g_settings_set_boolean (_tmp6_, "window-is-fullscreen", _tmp7_);
}


static gboolean iagno_window_configure_event_cb (Iagno* self, GdkEventConfigure* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = self->priv->is_maximized;
	if (!_tmp1_) {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = self->priv->is_fullscreen;
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		GdkEventConfigure _tmp4_ = {0};
		gint _tmp5_ = 0;
		GdkEventConfigure _tmp6_ = {0};
		gint _tmp7_ = 0;
		_tmp4_ = *event;
		_tmp5_ = _tmp4_.width;
		self->priv->window_width = _tmp5_;
		_tmp6_ = *event;
		_tmp7_ = _tmp6_.height;
		self->priv->window_height = _tmp7_;
	}
	result = FALSE;
	return result;
}


static gboolean iagno_window_state_event_cb (Iagno* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState _tmp0_ = {0};
	GdkWindowState _tmp1_ = 0;
	GdkEventWindowState _tmp4_ = {0};
	GdkWindowState _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.changed_mask;
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		GdkEventWindowState _tmp2_ = {0};
		GdkWindowState _tmp3_ = 0;
		_tmp2_ = *event;
		_tmp3_ = _tmp2_.new_window_state;
		self->priv->is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	_tmp4_ = *event;
	_tmp5_ = _tmp4_.changed_mask;
	if ((_tmp5_ & GDK_WINDOW_STATE_FULLSCREEN) != 0) {
		GdkEventWindowState _tmp6_ = {0};
		GdkWindowState _tmp7_ = 0;
		_tmp6_ = *event;
		_tmp7_ = _tmp6_.new_window_state;
		self->priv->is_fullscreen = (_tmp7_ & GDK_WINDOW_STATE_FULLSCREEN) != 0;
	}
	result = FALSE;
	return result;
}


static void iagno_quit_cb (Iagno* self) {
	GtkWindow* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void iagno_new_game_cb (Iagno* self) {
	g_return_if_fail (self != NULL);
	iagno_start_game (self);
}


static void _iagno_game_move_cb_game_move (Game* _sender, gpointer self) {
	iagno_game_move_cb (self, _sender);
}


static void _iagno_game_complete_cb_game_complete (Game* _sender, gpointer self) {
	iagno_game_complete_cb (self);
}


static gboolean _iagno_computer_move_cb_gsource_func (gpointer self) {
	gboolean result;
	result = iagno_computer_move_cb (self);
	return result;
}


static void iagno_start_game (Iagno* self) {
	Game* _tmp0_ = NULL;
	Game* _tmp2_ = NULL;
	Game* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
	GameView* _tmp5_ = NULL;
	Game* _tmp6_ = NULL;
	gint dark_level = 0;
	GSettings* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint light_level = 0;
	GSettings* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	ComputerPlayer* _tmp19_ = NULL;
	g_return_if_fail (self != NULL);
	iagno_cancel_pending_computer_moves (self);
	_tmp0_ = self->priv->game;
	if (_tmp0_ != NULL) {
		Game* _tmp1_ = NULL;
		_tmp1_ = self->priv->game;
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
	}
	_tmp2_ = game_new (8, 8);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp2_;
	_tmp3_ = self->priv->game;
	g_signal_connect_object (_tmp3_, "move", (GCallback) _iagno_game_move_cb_game_move, self, 0);
	_tmp4_ = self->priv->game;
	g_signal_connect_object (_tmp4_, "complete", (GCallback) _iagno_game_complete_cb_game_complete, self, 0);
	_tmp5_ = self->priv->view;
	_tmp6_ = self->priv->game;
	game_view_set_game (_tmp5_, _tmp6_);
	_tmp7_ = self->priv->settings;
	_tmp8_ = g_settings_get_int (_tmp7_, "black-level");
	dark_level = _tmp8_;
	_tmp9_ = dark_level;
	if (_tmp9_ > 0) {
		Game* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		ComputerPlayer* _tmp12_ = NULL;
		_tmp10_ = self->priv->game;
		_tmp11_ = dark_level;
		_tmp12_ = computer_player_new (_tmp10_, _tmp11_);
		_g_object_unref0 (self->priv->dark_computer);
		self->priv->dark_computer = _tmp12_;
	} else {
		_g_object_unref0 (self->priv->dark_computer);
		self->priv->dark_computer = NULL;
	}
	_tmp13_ = self->priv->settings;
	_tmp14_ = g_settings_get_int (_tmp13_, "white-level");
	light_level = _tmp14_;
	_tmp15_ = light_level;
	if (_tmp15_ > 0) {
		Game* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		ComputerPlayer* _tmp18_ = NULL;
		_tmp16_ = self->priv->game;
		_tmp17_ = light_level;
		_tmp18_ = computer_player_new (_tmp16_, _tmp17_);
		_g_object_unref0 (self->priv->light_computer);
		self->priv->light_computer = _tmp18_;
	} else {
		_g_object_unref0 (self->priv->light_computer);
		self->priv->light_computer = NULL;
	}
	iagno_update_ui (self);
	_tmp19_ = self->priv->dark_computer;
	if (_tmp19_ != NULL) {
		guint _tmp20_ = 0U;
		_tmp20_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, _iagno_computer_move_cb_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->computer_timer = _tmp20_;
	}
}


static void iagno_update_ui (Iagno* self) {
	GtkInfoBar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	ComputerPlayer* _tmp2_ = NULL;
	gboolean _tmp4_ = FALSE;
	Game* _tmp9_ = NULL;
	Player _tmp10_ = 0;
	Player _tmp11_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->infobar;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	_tmp2_ = self->priv->light_computer;
	if (_tmp2_ != NULL) {
		ComputerPlayer* _tmp3_ = NULL;
		_tmp3_ = self->priv->dark_computer;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp4_ = _tmp1_;
	if (_tmp4_) {
		GSimpleAction* _tmp5_ = NULL;
		_tmp5_ = self->priv->undo_action;
		g_simple_action_set_enabled (_tmp5_, FALSE);
	} else {
		GSimpleAction* _tmp6_ = NULL;
		Game* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp6_ = self->priv->undo_action;
		_tmp7_ = self->priv->game;
		_tmp8_ = game_can_undo (_tmp7_);
		g_simple_action_set_enabled (_tmp6_, _tmp8_);
	}
	_tmp9_ = self->priv->game;
	_tmp10_ = game_get_current_color (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ == PLAYER_DARK) {
		GtkLabel* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		GtkLabel* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		GtkLabel* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		Game* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		gint _tmp28_ = 0;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		GtkLabel* _tmp35_ = NULL;
		const gchar* _tmp36_ = NULL;
		Game* _tmp37_ = NULL;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		gchar* _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
		gchar* _tmp42_ = NULL;
		gchar* _tmp43_ = NULL;
		gchar* _tmp44_ = NULL;
		gchar* _tmp45_ = NULL;
		_tmp12_ = self->priv->dark_label;
		_tmp13_ = _ ("Dark:");
		_tmp14_ = g_strconcat ("<span font_weight='bold'>", _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strconcat (_tmp15_, "</span>", NULL);
		_tmp17_ = _tmp16_;
		gtk_label_set_markup (_tmp12_, _tmp17_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp15_);
		_tmp18_ = self->priv->light_label;
		_tmp19_ = _ ("Light:");
		_tmp20_ = g_strconcat ("<span font_weight='normal'>", _tmp19_, NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strconcat (_tmp21_, "</span>", NULL);
		_tmp23_ = _tmp22_;
		gtk_label_set_markup (_tmp18_, _tmp23_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp21_);
		_tmp24_ = self->priv->dark_score_label;
		_tmp25_ = _ ("%.2d");
		_tmp26_ = self->priv->game;
		_tmp27_ = game_get_n_dark_tiles (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = g_strdup_printf (_tmp25_, _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = g_strconcat ("<span font_weight='bold'>", _tmp30_, NULL);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_strconcat (_tmp32_, "</span>", NULL);
		_tmp34_ = _tmp33_;
		gtk_label_set_markup (_tmp24_, _tmp34_);
		_g_free0 (_tmp34_);
		_g_free0 (_tmp32_);
		_g_free0 (_tmp30_);
		_tmp35_ = self->priv->light_score_label;
		_tmp36_ = _ ("%.2d");
		_tmp37_ = self->priv->game;
		_tmp38_ = game_get_n_light_tiles (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = g_strdup_printf (_tmp36_, _tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = g_strconcat ("<span font_weight='normal'>", _tmp41_, NULL);
		_tmp43_ = _tmp42_;
		_tmp44_ = g_strconcat (_tmp43_, "</span>", NULL);
		_tmp45_ = _tmp44_;
		gtk_label_set_markup (_tmp35_, _tmp45_);
		_g_free0 (_tmp45_);
		_g_free0 (_tmp43_);
		_g_free0 (_tmp41_);
	} else {
		Game* _tmp46_ = NULL;
		Player _tmp47_ = 0;
		Player _tmp48_ = 0;
		_tmp46_ = self->priv->game;
		_tmp47_ = game_get_current_color (_tmp46_);
		_tmp48_ = _tmp47_;
		if (_tmp48_ == PLAYER_LIGHT) {
			GtkLabel* _tmp49_ = NULL;
			const gchar* _tmp50_ = NULL;
			gchar* _tmp51_ = NULL;
			gchar* _tmp52_ = NULL;
			gchar* _tmp53_ = NULL;
			gchar* _tmp54_ = NULL;
			GtkLabel* _tmp55_ = NULL;
			const gchar* _tmp56_ = NULL;
			gchar* _tmp57_ = NULL;
			gchar* _tmp58_ = NULL;
			gchar* _tmp59_ = NULL;
			gchar* _tmp60_ = NULL;
			GtkLabel* _tmp61_ = NULL;
			const gchar* _tmp62_ = NULL;
			Game* _tmp63_ = NULL;
			gint _tmp64_ = 0;
			gint _tmp65_ = 0;
			gchar* _tmp66_ = NULL;
			gchar* _tmp67_ = NULL;
			gchar* _tmp68_ = NULL;
			gchar* _tmp69_ = NULL;
			gchar* _tmp70_ = NULL;
			gchar* _tmp71_ = NULL;
			GtkLabel* _tmp72_ = NULL;
			const gchar* _tmp73_ = NULL;
			Game* _tmp74_ = NULL;
			gint _tmp75_ = 0;
			gint _tmp76_ = 0;
			gchar* _tmp77_ = NULL;
			gchar* _tmp78_ = NULL;
			gchar* _tmp79_ = NULL;
			gchar* _tmp80_ = NULL;
			gchar* _tmp81_ = NULL;
			gchar* _tmp82_ = NULL;
			_tmp49_ = self->priv->dark_label;
			_tmp50_ = _ ("Dark:");
			_tmp51_ = g_strconcat ("<span font_weight='normal'>", _tmp50_, NULL);
			_tmp52_ = _tmp51_;
			_tmp53_ = g_strconcat (_tmp52_, "</span>", NULL);
			_tmp54_ = _tmp53_;
			gtk_label_set_markup (_tmp49_, _tmp54_);
			_g_free0 (_tmp54_);
			_g_free0 (_tmp52_);
			_tmp55_ = self->priv->light_label;
			_tmp56_ = _ ("Light:");
			_tmp57_ = g_strconcat ("<span font_weight='bold'>", _tmp56_, NULL);
			_tmp58_ = _tmp57_;
			_tmp59_ = g_strconcat (_tmp58_, "</span>", NULL);
			_tmp60_ = _tmp59_;
			gtk_label_set_markup (_tmp55_, _tmp60_);
			_g_free0 (_tmp60_);
			_g_free0 (_tmp58_);
			_tmp61_ = self->priv->dark_score_label;
			_tmp62_ = _ ("%.2d");
			_tmp63_ = self->priv->game;
			_tmp64_ = game_get_n_dark_tiles (_tmp63_);
			_tmp65_ = _tmp64_;
			_tmp66_ = g_strdup_printf (_tmp62_, _tmp65_);
			_tmp67_ = _tmp66_;
			_tmp68_ = g_strconcat ("<span font_weight='normal'>", _tmp67_, NULL);
			_tmp69_ = _tmp68_;
			_tmp70_ = g_strconcat (_tmp69_, "</span>", NULL);
			_tmp71_ = _tmp70_;
			gtk_label_set_markup (_tmp61_, _tmp71_);
			_g_free0 (_tmp71_);
			_g_free0 (_tmp69_);
			_g_free0 (_tmp67_);
			_tmp72_ = self->priv->light_score_label;
			_tmp73_ = _ ("%.2d");
			_tmp74_ = self->priv->game;
			_tmp75_ = game_get_n_light_tiles (_tmp74_);
			_tmp76_ = _tmp75_;
			_tmp77_ = g_strdup_printf (_tmp73_, _tmp76_);
			_tmp78_ = _tmp77_;
			_tmp79_ = g_strconcat ("<span font_weight='bold'>", _tmp78_, NULL);
			_tmp80_ = _tmp79_;
			_tmp81_ = g_strconcat (_tmp80_, "</span>", NULL);
			_tmp82_ = _tmp81_;
			gtk_label_set_markup (_tmp72_, _tmp82_);
			_g_free0 (_tmp82_);
			_g_free0 (_tmp80_);
			_g_free0 (_tmp78_);
		}
	}
}


static void iagno_undo_move_cb (Iagno* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Game* _tmp2_ = NULL;
	Player _tmp3_ = 0;
	Player _tmp4_ = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp13_ = FALSE;
	Game* _tmp22_ = NULL;
	g_return_if_fail (self != NULL);
	iagno_cancel_pending_computer_moves (self);
	_tmp2_ = self->priv->game;
	_tmp3_ = game_get_current_color (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == PLAYER_DARK) {
		ComputerPlayer* _tmp5_ = NULL;
		_tmp5_ = self->priv->dark_computer;
		_tmp1_ = _tmp5_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp6_ = _tmp1_;
	if (_tmp6_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp7_ = FALSE;
		Game* _tmp8_ = NULL;
		Player _tmp9_ = 0;
		Player _tmp10_ = 0;
		gboolean _tmp12_ = FALSE;
		_tmp8_ = self->priv->game;
		_tmp9_ = game_get_current_color (_tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_ == PLAYER_LIGHT) {
			ComputerPlayer* _tmp11_ = NULL;
			_tmp11_ = self->priv->light_computer;
			_tmp7_ = _tmp11_ != NULL;
		} else {
			_tmp7_ = FALSE;
		}
		_tmp12_ = _tmp7_;
		_tmp0_ = _tmp12_;
	}
	_tmp13_ = _tmp0_;
	if (_tmp13_) {
		Game* _tmp14_ = NULL;
		_tmp14_ = self->priv->game;
		game_undo (_tmp14_, 1);
	} else {
		Game* _tmp15_ = NULL;
		_tmp15_ = self->priv->game;
		game_undo (_tmp15_, 2);
	}
	while (TRUE) {
		Game* _tmp16_ = NULL;
		Game* _tmp17_ = NULL;
		Player _tmp18_ = 0;
		Player _tmp19_ = 0;
		gboolean _tmp20_ = FALSE;
		Game* _tmp21_ = NULL;
		_tmp16_ = self->priv->game;
		_tmp17_ = self->priv->game;
		_tmp18_ = game_get_current_color (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = game_can_move (_tmp16_, _tmp19_);
		if (!(!_tmp20_)) {
			break;
		}
		_tmp21_ = self->priv->game;
		game_undo (_tmp21_, 2);
	}
	_tmp22_ = self->priv->game;
	iagno_game_move_cb (self, _tmp22_);
}


static void iagno_about_cb (Iagno* self) {
	gchar** authors = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar** documenters = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint documenters_length1 = 0;
	gint _documenters_size_ = 0;
	gchar* license = NULL;
	gchar* _tmp5_ = NULL;
	GtkWindow* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Ian Peters");
	_tmp1_ = g_strdup ("Robert Ancell");
	_tmp2_ = g_new0 (gchar*, 3 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	_tmp2_[2] = NULL;
	authors = _tmp2_;
	authors_length1 = 3;
	_authors_size_ = authors_length1;
	_tmp3_ = g_strdup ("Eric Baudais");
	_tmp4_ = g_new0 (gchar*, 2 + 1);
	_tmp4_[0] = _tmp3_;
	_tmp4_[1] = NULL;
	documenters = _tmp4_;
	documenters_length1 = 2;
	_documenters_size_ = documenters_length1;
	_tmp5_ = g_strdup ("Iagno is free software; you can redistribute it and/or modify it under" \
" the terms of the GNU General Public License as published by the Free " \
"Software Foundation; either version 2 of the License, or (at your opti" \
"on) any later version.\n" \
"\n" \
"Iagno is distributed in the hope that it will be useful, but WITHOUT A" \
"NY WARRANTY; without even the implied warranty of MERCHANTABILITY or F" \
"ITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License fo" \
"r more details.\n" \
"\n" \
"You should have received a copy of the GNU General Public License alon" \
"g with Iagno; if not, write to the Free Software Foundation, Inc., 51 " \
"Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA");
	license = _tmp5_;
	_tmp6_ = self->priv->window;
	_tmp7_ = _ ("Iagno");
	_tmp8_ = _ ("A disk flipping game derived from Reversi.\n" \
"\n" \
"Iagno is a part of GNOME Games.");
	_tmp9_ = _ ("translator-credits");
	_tmp10_ = _ ("GNOME Games web site");
	gtk_show_about_dialog (_tmp6_, "name", _tmp7_, "version", VERSION, "copyright", "Copyright \xc2\xa9 1998-2008 Ian Peters", "license", license, "comments", _tmp8_, "authors", authors, "documenters", documenters, "translator-credits", _tmp9_, "logo-icon-name", "iagno", "website-label", _tmp10_, "website", "http://www.gnome.org/projects/gnome-games/", "wrap-license", TRUE, NULL, NULL);
	_g_free0 (license);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}


static void iagno_preferences_cb (Iagno* self) {
	g_return_if_fail (self != NULL);
	iagno_show_preferences_dialog (self);
}


static void iagno_show_message_data_free (gpointer _data) {
	IagnoShowMessageData* _data_;
	_data_ = _data;
	_g_free0 (_data_->message);
	_g_object_unref0 (_data_->self);
	g_slice_free (IagnoShowMessageData, _data_);
}


static void iagno_show_message (Iagno* self, const gchar* message, GtkMessageType type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	IagnoShowMessageData* _data_;
	Iagno* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GtkMessageType _tmp3_ = 0;
	_data_ = g_slice_new0 (IagnoShowMessageData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, iagno_show_message);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, iagno_show_message_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = message;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->message);
	_data_->message = _tmp2_;
	_tmp3_ = type;
	_data_->type = _tmp3_;
	iagno_show_message_co (_data_);
}


static void iagno_show_message_finish (Iagno* self, GAsyncResult* _res_) {
	IagnoShowMessageData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean _iagno_show_message_co_gsource_func (gpointer self) {
	gboolean result;
	result = iagno_show_message_co (self);
	return result;
}


static gboolean iagno_show_message_co (IagnoShowMessageData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->infobar;
	gtk_widget_hide ((GtkWidget*) _data_->_tmp0_);
	while (TRUE) {
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _data_->self->priv->infobar;
		_data_->_tmp2_ = FALSE;
		_data_->_tmp2_ = gtk_widget_get_visible ((GtkWidget*) _data_->_tmp1_);
		_data_->_tmp3_ = FALSE;
		_data_->_tmp3_ = _data_->_tmp2_;
		if (!_data_->_tmp3_) {
			break;
		}
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _iagno_show_message_co_gsource_func, _data_, NULL);
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
	}
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->self->priv->infobar;
	_data_->_tmp5_ = 0;
	_data_->_tmp5_ = _data_->type;
	gtk_info_bar_set_message_type (_data_->_tmp4_, _data_->_tmp5_);
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->self->priv->infobar_label;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->message;
	gtk_label_set_label (_data_->_tmp6_, _data_->_tmp7_);
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->self->priv->infobar;
	gtk_widget_show ((GtkWidget*) _data_->_tmp8_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void iagno_help_cb (Iagno* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GtkWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
		_tmp0_ = self->priv->window;
		_tmp1_ = gtk_window_get_screen (_tmp0_);
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp1_, "help:iagno", _tmp2_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("iagno.vala:342: Failed to show help: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void iagno_game_move_cb (Iagno* self, Game* g) {
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	Game* _tmp3_ = NULL;
	Player _tmp4_ = 0;
	Player _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp13_ = FALSE;
	Game* _tmp14_ = NULL;
	Player _tmp15_ = 0;
	Player _tmp16_ = 0;
	gboolean _tmp18_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (g != NULL);
	_tmp0_ = g;
	_tmp1_ = self->priv->game;
	g_return_if_fail (_tmp0_ == _tmp1_);
	iagno_play_sound (self, "flip-piece");
	_tmp2_ = self->priv->game;
	_tmp3_ = self->priv->game;
	_tmp4_ = game_get_current_color (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = game_can_move (_tmp2_, _tmp5_);
	if (!_tmp6_) {
		Game* _tmp7_ = NULL;
		Game* _tmp8_ = NULL;
		Player _tmp9_ = 0;
		Player _tmp10_ = 0;
		_tmp7_ = self->priv->game;
		game_pass (_tmp7_);
		_tmp8_ = self->priv->game;
		_tmp9_ = game_get_current_color (_tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_ == PLAYER_DARK) {
			const gchar* _tmp11_ = NULL;
			_tmp11_ = _ ("Light must pass, Dark's move");
			iagno_show_message (self, _tmp11_, GTK_MESSAGE_INFO, NULL, NULL);
		} else {
			const gchar* _tmp12_ = NULL;
			_tmp12_ = _ ("Dark must pass, Light's move");
			iagno_show_message (self, _tmp12_, GTK_MESSAGE_INFO, NULL, NULL);
		}
		return;
	}
	iagno_update_ui (self);
	_tmp14_ = self->priv->game;
	_tmp15_ = game_get_current_color (_tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_ == PLAYER_LIGHT) {
		ComputerPlayer* _tmp17_ = NULL;
		_tmp17_ = self->priv->light_computer;
		_tmp13_ = _tmp17_ != NULL;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp18_ = _tmp13_;
	if (_tmp18_) {
		ComputerPlayer* _tmp19_ = NULL;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		guint _tmp22_ = 0U;
		_tmp19_ = self->priv->light_computer;
		_tmp20_ = computer_player_get_level (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) (5 - _tmp21_), _iagno_computer_move_cb_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->computer_timer = _tmp22_;
	} else {
		gboolean _tmp23_ = FALSE;
		Game* _tmp24_ = NULL;
		Player _tmp25_ = 0;
		Player _tmp26_ = 0;
		gboolean _tmp28_ = FALSE;
		_tmp24_ = self->priv->game;
		_tmp25_ = game_get_current_color (_tmp24_);
		_tmp26_ = _tmp25_;
		if (_tmp26_ == PLAYER_DARK) {
			ComputerPlayer* _tmp27_ = NULL;
			_tmp27_ = self->priv->dark_computer;
			_tmp23_ = _tmp27_ != NULL;
		} else {
			_tmp23_ = FALSE;
		}
		_tmp28_ = _tmp23_;
		if (_tmp28_) {
			ComputerPlayer* _tmp29_ = NULL;
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
			guint _tmp32_ = 0U;
			_tmp29_ = self->priv->dark_computer;
			_tmp30_ = computer_player_get_level (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) (5 - _tmp31_), _iagno_computer_move_cb_gsource_func, g_object_ref (self), g_object_unref);
			self->priv->computer_timer = _tmp32_;
		}
	}
}


static gboolean iagno_computer_move_cb (Iagno* self) {
	gboolean result = FALSE;
	Game* _tmp0_ = NULL;
	Player _tmp1_ = 0;
	Player _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	iagno_cancel_pending_computer_moves (self);
	_tmp0_ = self->priv->game;
	_tmp1_ = game_get_current_color (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == PLAYER_LIGHT) {
		ComputerPlayer* _tmp3_ = NULL;
		_tmp3_ = self->priv->light_computer;
		computer_player_move (_tmp3_);
	} else {
		ComputerPlayer* _tmp4_ = NULL;
		_tmp4_ = self->priv->dark_computer;
		computer_player_move (_tmp4_);
	}
	result = FALSE;
	return result;
}


static void iagno_cancel_pending_computer_moves (Iagno* self) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->computer_timer;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->computer_timer;
		g_source_remove (_tmp1_);
		self->priv->computer_timer = (guint) 0;
	}
}


static void iagno_game_complete_cb (Iagno* self) {
	Game* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Game* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	iagno_update_ui (self);
	_tmp0_ = self->priv->game;
	_tmp1_ = game_get_n_light_tiles (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->game;
	_tmp4_ = game_get_n_dark_tiles (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp2_ > _tmp5_) {
		const gchar* _tmp6_ = NULL;
		_tmp6_ = _ ("Light player wins!");
		iagno_show_message (self, _tmp6_, GTK_MESSAGE_INFO, NULL, NULL);
	} else {
		Game* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		Game* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		_tmp7_ = self->priv->game;
		_tmp8_ = game_get_n_dark_tiles (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = self->priv->game;
		_tmp11_ = game_get_n_light_tiles (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp9_ > _tmp12_) {
			const gchar* _tmp13_ = NULL;
			_tmp13_ = _ ("Dark player wins!");
			iagno_show_message (self, _tmp13_, GTK_MESSAGE_INFO, NULL, NULL);
		} else {
			Game* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			Game* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			_tmp14_ = self->priv->game;
			_tmp15_ = game_get_n_light_tiles (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = self->priv->game;
			_tmp18_ = game_get_n_dark_tiles (_tmp17_);
			_tmp19_ = _tmp18_;
			if (_tmp16_ == _tmp19_) {
				const gchar* _tmp20_ = NULL;
				_tmp20_ = _ ("The game was a draw.");
				iagno_show_message (self, _tmp20_, GTK_MESSAGE_INFO, NULL, NULL);
			}
		}
	}
	iagno_play_sound (self, "gameover");
}


static void iagno_play_sound (Iagno* self, const gchar* name) {
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GameView* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "sound");
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->view;
	_tmp3_ = name;
	_tmp4_ = name;
	_tmp5_ = g_strdup_printf ("%s.ogg", _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_build_filename (SOUND_DIRECTORY, _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	ca_gtk_play_for_widget ((GtkWidget*) _tmp2_, (guint32) 0, CA_PROP_MEDIA_NAME, _tmp3_, CA_PROP_MEDIA_FILENAME, _tmp8_, NULL);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
}


static void iagno_player_move_cb (Iagno* self, gint x, gint y) {
	gboolean _tmp0_ = FALSE;
	Game* _tmp1_ = NULL;
	Player _tmp2_ = 0;
	Player _tmp3_ = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	Game* _tmp8_ = NULL;
	Player _tmp9_ = 0;
	Player _tmp10_ = 0;
	gboolean _tmp13_ = FALSE;
	Game* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->game;
	_tmp2_ = game_get_current_color (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == PLAYER_LIGHT) {
		GSettings* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		_tmp4_ = self->priv->settings;
		_tmp5_ = g_settings_get_int (_tmp4_, "white-level");
		_tmp0_ = _tmp5_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp6_ = _tmp0_;
	if (_tmp6_) {
		return;
	}
	_tmp8_ = self->priv->game;
	_tmp9_ = game_get_current_color (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ == PLAYER_DARK) {
		GSettings* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		_tmp11_ = self->priv->settings;
		_tmp12_ = g_settings_get_int (_tmp11_, "black-level");
		_tmp7_ = _tmp12_ > 0;
	} else {
		_tmp7_ = FALSE;
	}
	_tmp13_ = _tmp7_;
	if (_tmp13_) {
		return;
	}
	_tmp14_ = self->priv->game;
	_tmp15_ = x;
	_tmp16_ = y;
	_tmp17_ = game_place_tile (_tmp14_, _tmp15_, _tmp16_);
	if (_tmp17_ == 0) {
		const gchar* _tmp18_ = NULL;
		_tmp18_ = _ ("Invalid move.");
		iagno_show_message (self, _tmp18_, GTK_MESSAGE_ERROR, NULL, NULL);
	}
}


static void iagno_dark_level_changed_cb (Iagno* self, GtkComboBox* combo) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gint level = 0;
	GtkComboBox* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	GSettings* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = combo;
	_tmp3_ = gtk_combo_box_get_model (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, 1, &level, -1);
	_tmp6_ = self->priv->settings;
	g_settings_set_int (_tmp6_, "black-level", level);
}


static void iagno_light_level_changed_cb (Iagno* self, GtkComboBox* combo) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gint level = 0;
	GtkComboBox* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	GSettings* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = combo;
	_tmp3_ = gtk_combo_box_get_model (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, 1, &level, -1);
	_tmp6_ = self->priv->settings;
	g_settings_set_int (_tmp6_, "white-level", level);
}


static void iagno_sound_select (Iagno* self, GtkToggleButton* widget) {
	gboolean play_sounds = FALSE;
	GtkToggleButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GSettings* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	play_sounds = _tmp1_;
	_tmp2_ = self->priv->settings;
	g_settings_set_boolean (_tmp2_, "sound", play_sounds);
}


static void iagno_grid_toggled_cb (Iagno* self, GtkToggleButton* widget) {
	GameView* _tmp0_ = NULL;
	GtkToggleButton* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GSettings* _tmp3_ = NULL;
	GameView* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->view;
	_tmp1_ = widget;
	_tmp2_ = gtk_toggle_button_get_active (_tmp1_);
	game_view_set_show_grid (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->settings;
	_tmp4_ = self->priv->view;
	_tmp5_ = game_view_get_show_grid (_tmp4_);
	_tmp6_ = _tmp5_;
	g_settings_set_boolean (_tmp3_, "show-grid", _tmp6_);
}


static void iagno_flip_final_toggled_cb (Iagno* self, GtkToggleButton* widget) {
	GameView* _tmp0_ = NULL;
	GtkToggleButton* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GSettings* _tmp3_ = NULL;
	GameView* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->view;
	_tmp1_ = widget;
	_tmp2_ = gtk_toggle_button_get_active (_tmp1_);
	game_view_set_flip_final_result (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->settings;
	_tmp4_ = self->priv->view;
	_tmp5_ = game_view_get_flip_final_result (_tmp4_);
	_tmp6_ = _tmp5_;
	g_settings_set_boolean (_tmp3_, "flip-final-results", _tmp6_);
}


static void iagno_propbox_response_cb (Iagno* self, GtkWidget* widget, gint response_id) {
	GtkWidget* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	gtk_widget_hide (_tmp0_);
}


static gboolean iagno_propbox_close_cb (Iagno* self, GtkWidget* widget, GdkEventAny* event) {
	gboolean result = FALSE;
	GtkWidget* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = widget;
	gtk_widget_hide (_tmp0_);
	result = TRUE;
	return result;
}


static void iagno_theme_changed_cb (Iagno* self, GtkComboBox* widget) {
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	gchar* tile_set = NULL;
	GtkTreeModel* _tmp6_ = NULL;
	GtkTreeIter _tmp7_ = {0};
	GSettings* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GameView* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	GameView* _tmp14_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	model = _tmp2_;
	_tmp3_ = widget;
	_tmp5_ = gtk_combo_box_get_active_iter (_tmp3_, &_tmp4_);
	iter = _tmp4_;
	if (!_tmp5_) {
		_g_object_unref0 (model);
		return;
	}
	_tmp6_ = model;
	_tmp7_ = iter;
	gtk_tree_model_get (_tmp6_, &_tmp7_, 1, &tile_set, -1);
	_tmp8_ = self->priv->settings;
	_tmp9_ = tile_set;
	g_settings_set_string (_tmp8_, "tileset", _tmp9_);
	_tmp10_ = self->priv->view;
	_tmp11_ = tile_set;
	_tmp12_ = g_build_filename (DATA_DIRECTORY, "themes", _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	game_view_set_theme (_tmp10_, _tmp13_);
	_g_free0 (_tmp13_);
	_tmp14_ = self->priv->view;
	game_view_redraw (_tmp14_);
	_g_free0 (tile_set);
	_g_object_unref0 (model);
}


static void _iagno_propbox_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	iagno_propbox_response_cb (self, _sender, response_id);
}


static gboolean _iagno_propbox_close_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = iagno_propbox_close_cb (self, _sender, event);
	return result;
}


static void _iagno_dark_level_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	iagno_dark_level_changed_cb (self, _sender);
}


static void _iagno_light_level_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	iagno_light_level_changed_cb (self, _sender);
}


static void _iagno_sound_select_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	iagno_sound_select (self, _sender);
}


static void _iagno_grid_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	iagno_grid_toggled_cb (self, _sender);
}


static void _iagno_flip_final_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	iagno_flip_final_toggled_cb (self, _sender);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp5_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally5;
	__catch5_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	gboolean _tmp3_ = FALSE;
	glong _tmp9_ = 0L;
	glong _tmp15_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		glong _tmp12_ = 0L;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_ = 0L;
		glong _tmp14_ = 0L;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_ = 0L;
		glong _tmp17_ = 0L;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static void _iagno_theme_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	iagno_theme_changed_cb (self, _sender);
}


static void iagno_show_preferences_dialog (Iagno* self) {
	GtkDialog* propbox = NULL;
	const gchar* _tmp0_ = NULL;
	GtkWindow* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkDialog* _tmp3_ = NULL;
	GtkDialog* _tmp4_ = NULL;
	GtkBox* box = NULL;
	GtkDialog* _tmp5_ = NULL;
	GtkBox* _tmp6_ = NULL;
	GtkBox* _tmp7_ = NULL;
	GtkBox* _tmp8_ = NULL;
	GtkDialog* _tmp9_ = NULL;
	GtkDialog* _tmp10_ = NULL;
	GtkDialog* _tmp11_ = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp12_ = NULL;
	GtkGrid* _tmp13_ = NULL;
	GtkGrid* _tmp14_ = NULL;
	GtkGrid* _tmp15_ = NULL;
	GtkBox* _tmp16_ = NULL;
	GtkGrid* _tmp17_ = NULL;
	GtkLabel* label = NULL;
	const gchar* _tmp18_ = NULL;
	GtkLabel* _tmp19_ = NULL;
	GtkLabel* _tmp20_ = NULL;
	GtkLabel* _tmp21_ = NULL;
	GtkGrid* _tmp22_ = NULL;
	GtkLabel* _tmp23_ = NULL;
	GtkComboBox* combo = NULL;
	GtkComboBox* _tmp24_ = NULL;
	GtkComboBox* _tmp25_ = NULL;
	GtkCellRendererText* renderer = NULL;
	GtkCellRendererText* _tmp26_ = NULL;
	GtkComboBox* _tmp27_ = NULL;
	GtkCellRendererText* _tmp28_ = NULL;
	GtkComboBox* _tmp29_ = NULL;
	GtkCellRendererText* _tmp30_ = NULL;
	GtkListStore* model = NULL;
	GtkListStore* _tmp31_ = NULL;
	GtkComboBox* _tmp32_ = NULL;
	GtkListStore* _tmp33_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp34_ = NULL;
	GtkTreeIter _tmp35_ = {0};
	GtkListStore* _tmp36_ = NULL;
	GtkTreeIter _tmp37_ = {0};
	const gchar* _tmp38_ = NULL;
	GSettings* _tmp39_ = NULL;
	gint _tmp40_ = 0;
	GtkListStore* _tmp43_ = NULL;
	GtkTreeIter _tmp44_ = {0};
	GtkListStore* _tmp45_ = NULL;
	GtkTreeIter _tmp46_ = {0};
	const gchar* _tmp47_ = NULL;
	GSettings* _tmp48_ = NULL;
	gint _tmp49_ = 0;
	GtkListStore* _tmp52_ = NULL;
	GtkTreeIter _tmp53_ = {0};
	GtkListStore* _tmp54_ = NULL;
	GtkTreeIter _tmp55_ = {0};
	const gchar* _tmp56_ = NULL;
	GSettings* _tmp57_ = NULL;
	gint _tmp58_ = 0;
	GtkListStore* _tmp61_ = NULL;
	GtkTreeIter _tmp62_ = {0};
	GtkListStore* _tmp63_ = NULL;
	GtkTreeIter _tmp64_ = {0};
	const gchar* _tmp65_ = NULL;
	GSettings* _tmp66_ = NULL;
	gint _tmp67_ = 0;
	GtkGrid* _tmp70_ = NULL;
	GtkComboBox* _tmp71_ = NULL;
	const gchar* _tmp72_ = NULL;
	GtkLabel* _tmp73_ = NULL;
	GtkLabel* _tmp74_ = NULL;
	GtkLabel* _tmp75_ = NULL;
	GtkGrid* _tmp76_ = NULL;
	GtkLabel* _tmp77_ = NULL;
	GtkComboBox* _tmp78_ = NULL;
	GtkComboBox* _tmp79_ = NULL;
	GtkCellRendererText* _tmp80_ = NULL;
	GtkComboBox* _tmp81_ = NULL;
	GtkCellRendererText* _tmp82_ = NULL;
	GtkComboBox* _tmp83_ = NULL;
	GtkCellRendererText* _tmp84_ = NULL;
	GtkListStore* _tmp85_ = NULL;
	GtkComboBox* _tmp86_ = NULL;
	GtkListStore* _tmp87_ = NULL;
	GtkListStore* _tmp88_ = NULL;
	GtkTreeIter _tmp89_ = {0};
	GtkListStore* _tmp90_ = NULL;
	GtkTreeIter _tmp91_ = {0};
	const gchar* _tmp92_ = NULL;
	GSettings* _tmp93_ = NULL;
	gint _tmp94_ = 0;
	GtkListStore* _tmp97_ = NULL;
	GtkTreeIter _tmp98_ = {0};
	GtkListStore* _tmp99_ = NULL;
	GtkTreeIter _tmp100_ = {0};
	const gchar* _tmp101_ = NULL;
	GSettings* _tmp102_ = NULL;
	gint _tmp103_ = 0;
	GtkListStore* _tmp106_ = NULL;
	GtkTreeIter _tmp107_ = {0};
	GtkListStore* _tmp108_ = NULL;
	GtkTreeIter _tmp109_ = {0};
	const gchar* _tmp110_ = NULL;
	GSettings* _tmp111_ = NULL;
	gint _tmp112_ = 0;
	GtkListStore* _tmp115_ = NULL;
	GtkTreeIter _tmp116_ = {0};
	GtkListStore* _tmp117_ = NULL;
	GtkTreeIter _tmp118_ = {0};
	const gchar* _tmp119_ = NULL;
	GSettings* _tmp120_ = NULL;
	gint _tmp121_ = 0;
	GtkGrid* _tmp124_ = NULL;
	GtkComboBox* _tmp125_ = NULL;
	GtkCheckButton* enable_sounds_button = NULL;
	const gchar* _tmp126_ = NULL;
	GtkCheckButton* _tmp127_ = NULL;
	GtkCheckButton* _tmp128_ = NULL;
	GSettings* _tmp129_ = NULL;
	gboolean _tmp130_ = FALSE;
	GtkCheckButton* _tmp131_ = NULL;
	GtkGrid* _tmp132_ = NULL;
	GtkCheckButton* _tmp133_ = NULL;
	GtkCheckButton* grid_button = NULL;
	const gchar* _tmp134_ = NULL;
	GtkCheckButton* _tmp135_ = NULL;
	GtkCheckButton* _tmp136_ = NULL;
	GSettings* _tmp137_ = NULL;
	gboolean _tmp138_ = FALSE;
	GtkCheckButton* _tmp139_ = NULL;
	GtkGrid* _tmp140_ = NULL;
	GtkCheckButton* _tmp141_ = NULL;
	GtkCheckButton* flip_final_button = NULL;
	const gchar* _tmp142_ = NULL;
	GtkCheckButton* _tmp143_ = NULL;
	GtkCheckButton* _tmp144_ = NULL;
	GSettings* _tmp145_ = NULL;
	gboolean _tmp146_ = FALSE;
	GtkCheckButton* _tmp147_ = NULL;
	GtkGrid* _tmp148_ = NULL;
	GtkCheckButton* _tmp149_ = NULL;
	const gchar* _tmp150_ = NULL;
	GtkLabel* _tmp151_ = NULL;
	GtkLabel* _tmp152_ = NULL;
	GtkLabel* _tmp153_ = NULL;
	GtkGrid* _tmp154_ = NULL;
	GtkLabel* _tmp155_ = NULL;
	GtkComboBox* theme_combo = NULL;
	GtkComboBox* _tmp156_ = NULL;
	GtkCellRendererText* _tmp157_ = NULL;
	GtkComboBox* _tmp158_ = NULL;
	GtkCellRendererText* _tmp159_ = NULL;
	GtkComboBox* _tmp160_ = NULL;
	GtkCellRendererText* _tmp161_ = NULL;
	GtkListStore* _tmp162_ = NULL;
	GtkComboBox* _tmp163_ = NULL;
	GtkListStore* _tmp164_ = NULL;
	GDir* dir = NULL;
	GList* dirlist = NULL;
	GList* _tmp179_ = NULL;
	GtkLabel* _tmp204_ = NULL;
	GtkComboBox* _tmp205_ = NULL;
	GtkComboBox* _tmp206_ = NULL;
	GtkGrid* _tmp207_ = NULL;
	GtkComboBox* _tmp208_ = NULL;
	GtkDialog* _tmp209_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("Iagno Preferences");
	_tmp1_ = self->priv->window;
	_tmp2_ = _ ("_Close");
	_tmp3_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp0_, _tmp1_, 0, _tmp2_, GTK_RESPONSE_CLOSE, NULL, NULL);
	g_object_ref_sink (_tmp3_);
	propbox = _tmp3_;
	_tmp4_ = propbox;
	gtk_container_set_border_width ((GtkContainer*) _tmp4_, (guint) 5);
	_tmp5_ = propbox;
	_tmp6_ = (GtkBox*) gtk_dialog_get_content_area (_tmp5_);
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GTK_TYPE_BOX, GtkBox));
	box = _tmp7_;
	_tmp8_ = box;
	gtk_box_set_spacing (_tmp8_, 2);
	_tmp9_ = propbox;
	gtk_window_set_resizable ((GtkWindow*) _tmp9_, FALSE);
	_tmp10_ = propbox;
	g_signal_connect_object (_tmp10_, "response", (GCallback) _iagno_propbox_response_cb_gtk_dialog_response, self, 0);
	_tmp11_ = propbox;
	g_signal_connect_object ((GtkWidget*) _tmp11_, "delete-event", (GCallback) _iagno_propbox_close_cb_gtk_widget_delete_event, self, 0);
	_tmp12_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp12_);
	grid = _tmp12_;
	_tmp13_ = grid;
	gtk_container_set_border_width ((GtkContainer*) _tmp13_, (guint) 6);
	_tmp14_ = grid;
	gtk_grid_set_row_spacing (_tmp14_, (guint) 6);
	_tmp15_ = grid;
	gtk_grid_set_column_spacing (_tmp15_, (guint) 18);
	_tmp16_ = box;
	_tmp17_ = grid;
	gtk_container_add ((GtkContainer*) _tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = _ ("Dark Player:");
	_tmp19_ = (GtkLabel*) gtk_label_new (_tmp18_);
	g_object_ref_sink (_tmp19_);
	label = _tmp19_;
	_tmp20_ = label;
	gtk_misc_set_alignment ((GtkMisc*) _tmp20_, 0.0f, 0.5f);
	_tmp21_ = label;
	g_object_set ((GtkWidget*) _tmp21_, "expand", TRUE, NULL);
	_tmp22_ = grid;
	_tmp23_ = label;
	gtk_grid_attach (_tmp22_, (GtkWidget*) _tmp23_, 0, 0, 1, 1);
	_tmp24_ = (GtkComboBox*) gtk_combo_box_new ();
	g_object_ref_sink (_tmp24_);
	combo = _tmp24_;
	_tmp25_ = combo;
	g_signal_connect_object (_tmp25_, "changed", (GCallback) _iagno_dark_level_changed_cb_gtk_combo_box_changed, self, 0);
	_tmp26_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp26_);
	renderer = _tmp26_;
	_tmp27_ = combo;
	_tmp28_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp27_, (GtkCellRenderer*) _tmp28_, TRUE);
	_tmp29_ = combo;
	_tmp30_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp29_, (GtkCellRenderer*) _tmp30_, "text", 0);
	_tmp31_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_INT);
	model = _tmp31_;
	_tmp32_ = combo;
	_tmp33_ = model;
	gtk_combo_box_set_model (_tmp32_, (GtkTreeModel*) _tmp33_);
	_tmp34_ = model;
	gtk_list_store_append (_tmp34_, &_tmp35_);
	iter = _tmp35_;
	_tmp36_ = model;
	_tmp37_ = iter;
	_tmp38_ = _ ("Human");
	gtk_list_store_set (_tmp36_, &_tmp37_, 0, _tmp38_, 1, 0, -1);
	_tmp39_ = self->priv->settings;
	_tmp40_ = g_settings_get_int (_tmp39_, "black-level");
	if (_tmp40_ == 0) {
		GtkComboBox* _tmp41_ = NULL;
		GtkTreeIter _tmp42_ = {0};
		_tmp41_ = combo;
		_tmp42_ = iter;
		gtk_combo_box_set_active_iter (_tmp41_, &_tmp42_);
	}
	_tmp43_ = model;
	gtk_list_store_append (_tmp43_, &_tmp44_);
	iter = _tmp44_;
	_tmp45_ = model;
	_tmp46_ = iter;
	_tmp47_ = _ ("Level one");
	gtk_list_store_set (_tmp45_, &_tmp46_, 0, _tmp47_, 1, 1, -1);
	_tmp48_ = self->priv->settings;
	_tmp49_ = g_settings_get_int (_tmp48_, "black-level");
	if (_tmp49_ == 1) {
		GtkComboBox* _tmp50_ = NULL;
		GtkTreeIter _tmp51_ = {0};
		_tmp50_ = combo;
		_tmp51_ = iter;
		gtk_combo_box_set_active_iter (_tmp50_, &_tmp51_);
	}
	_tmp52_ = model;
	gtk_list_store_append (_tmp52_, &_tmp53_);
	iter = _tmp53_;
	_tmp54_ = model;
	_tmp55_ = iter;
	_tmp56_ = _ ("Level two");
	gtk_list_store_set (_tmp54_, &_tmp55_, 0, _tmp56_, 1, 2, -1);
	_tmp57_ = self->priv->settings;
	_tmp58_ = g_settings_get_int (_tmp57_, "black-level");
	if (_tmp58_ == 2) {
		GtkComboBox* _tmp59_ = NULL;
		GtkTreeIter _tmp60_ = {0};
		_tmp59_ = combo;
		_tmp60_ = iter;
		gtk_combo_box_set_active_iter (_tmp59_, &_tmp60_);
	}
	_tmp61_ = model;
	gtk_list_store_append (_tmp61_, &_tmp62_);
	iter = _tmp62_;
	_tmp63_ = model;
	_tmp64_ = iter;
	_tmp65_ = _ ("Level three");
	gtk_list_store_set (_tmp63_, &_tmp64_, 0, _tmp65_, 1, 3, -1);
	_tmp66_ = self->priv->settings;
	_tmp67_ = g_settings_get_int (_tmp66_, "black-level");
	if (_tmp67_ == 3) {
		GtkComboBox* _tmp68_ = NULL;
		GtkTreeIter _tmp69_ = {0};
		_tmp68_ = combo;
		_tmp69_ = iter;
		gtk_combo_box_set_active_iter (_tmp68_, &_tmp69_);
	}
	_tmp70_ = grid;
	_tmp71_ = combo;
	gtk_grid_attach (_tmp70_, (GtkWidget*) _tmp71_, 1, 0, 1, 1);
	_tmp72_ = _ ("Light Player:");
	_tmp73_ = (GtkLabel*) gtk_label_new (_tmp72_);
	g_object_ref_sink (_tmp73_);
	_g_object_unref0 (label);
	label = _tmp73_;
	_tmp74_ = label;
	gtk_misc_set_alignment ((GtkMisc*) _tmp74_, 0.0f, 0.5f);
	_tmp75_ = label;
	g_object_set ((GtkWidget*) _tmp75_, "expand", TRUE, NULL);
	_tmp76_ = grid;
	_tmp77_ = label;
	gtk_grid_attach (_tmp76_, (GtkWidget*) _tmp77_, 0, 1, 1, 1);
	_tmp78_ = (GtkComboBox*) gtk_combo_box_new ();
	g_object_ref_sink (_tmp78_);
	_g_object_unref0 (combo);
	combo = _tmp78_;
	_tmp79_ = combo;
	g_signal_connect_object (_tmp79_, "changed", (GCallback) _iagno_light_level_changed_cb_gtk_combo_box_changed, self, 0);
	_tmp80_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp80_);
	_g_object_unref0 (renderer);
	renderer = _tmp80_;
	_tmp81_ = combo;
	_tmp82_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp81_, (GtkCellRenderer*) _tmp82_, TRUE);
	_tmp83_ = combo;
	_tmp84_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp83_, (GtkCellRenderer*) _tmp84_, "text", 0);
	_tmp85_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_INT);
	_g_object_unref0 (model);
	model = _tmp85_;
	_tmp86_ = combo;
	_tmp87_ = model;
	gtk_combo_box_set_model (_tmp86_, (GtkTreeModel*) _tmp87_);
	_tmp88_ = model;
	gtk_list_store_append (_tmp88_, &_tmp89_);
	iter = _tmp89_;
	_tmp90_ = model;
	_tmp91_ = iter;
	_tmp92_ = _ ("Human");
	gtk_list_store_set (_tmp90_, &_tmp91_, 0, _tmp92_, 1, 0, -1);
	_tmp93_ = self->priv->settings;
	_tmp94_ = g_settings_get_int (_tmp93_, "white-level");
	if (_tmp94_ == 0) {
		GtkComboBox* _tmp95_ = NULL;
		GtkTreeIter _tmp96_ = {0};
		_tmp95_ = combo;
		_tmp96_ = iter;
		gtk_combo_box_set_active_iter (_tmp95_, &_tmp96_);
	}
	_tmp97_ = model;
	gtk_list_store_append (_tmp97_, &_tmp98_);
	iter = _tmp98_;
	_tmp99_ = model;
	_tmp100_ = iter;
	_tmp101_ = _ ("Level one");
	gtk_list_store_set (_tmp99_, &_tmp100_, 0, _tmp101_, 1, 1, -1);
	_tmp102_ = self->priv->settings;
	_tmp103_ = g_settings_get_int (_tmp102_, "white-level");
	if (_tmp103_ == 1) {
		GtkComboBox* _tmp104_ = NULL;
		GtkTreeIter _tmp105_ = {0};
		_tmp104_ = combo;
		_tmp105_ = iter;
		gtk_combo_box_set_active_iter (_tmp104_, &_tmp105_);
	}
	_tmp106_ = model;
	gtk_list_store_append (_tmp106_, &_tmp107_);
	iter = _tmp107_;
	_tmp108_ = model;
	_tmp109_ = iter;
	_tmp110_ = _ ("Level two");
	gtk_list_store_set (_tmp108_, &_tmp109_, 0, _tmp110_, 1, 2, -1);
	_tmp111_ = self->priv->settings;
	_tmp112_ = g_settings_get_int (_tmp111_, "white-level");
	if (_tmp112_ == 2) {
		GtkComboBox* _tmp113_ = NULL;
		GtkTreeIter _tmp114_ = {0};
		_tmp113_ = combo;
		_tmp114_ = iter;
		gtk_combo_box_set_active_iter (_tmp113_, &_tmp114_);
	}
	_tmp115_ = model;
	gtk_list_store_append (_tmp115_, &_tmp116_);
	iter = _tmp116_;
	_tmp117_ = model;
	_tmp118_ = iter;
	_tmp119_ = _ ("Level three");
	gtk_list_store_set (_tmp117_, &_tmp118_, 0, _tmp119_, 1, 3, -1);
	_tmp120_ = self->priv->settings;
	_tmp121_ = g_settings_get_int (_tmp120_, "white-level");
	if (_tmp121_ == 3) {
		GtkComboBox* _tmp122_ = NULL;
		GtkTreeIter _tmp123_ = {0};
		_tmp122_ = combo;
		_tmp123_ = iter;
		gtk_combo_box_set_active_iter (_tmp122_, &_tmp123_);
	}
	_tmp124_ = grid;
	_tmp125_ = combo;
	gtk_grid_attach (_tmp124_, (GtkWidget*) _tmp125_, 1, 1, 1, 1);
	_tmp126_ = _ ("E_nable sounds");
	_tmp127_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp126_);
	g_object_ref_sink (_tmp127_);
	enable_sounds_button = _tmp127_;
	_tmp128_ = enable_sounds_button;
	_tmp129_ = self->priv->settings;
	_tmp130_ = g_settings_get_boolean (_tmp129_, "sound");
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp128_, _tmp130_);
	_tmp131_ = enable_sounds_button;
	g_signal_connect_object ((GtkToggleButton*) _tmp131_, "toggled", (GCallback) _iagno_sound_select_gtk_toggle_button_toggled, self, 0);
	_tmp132_ = grid;
	_tmp133_ = enable_sounds_button;
	gtk_grid_attach (_tmp132_, (GtkWidget*) _tmp133_, 0, 2, 2, 1);
	_tmp134_ = _ ("S_how grid");
	_tmp135_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp134_);
	g_object_ref_sink (_tmp135_);
	grid_button = _tmp135_;
	_tmp136_ = grid_button;
	_tmp137_ = self->priv->settings;
	_tmp138_ = g_settings_get_boolean (_tmp137_, "show-grid");
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp136_, _tmp138_);
	_tmp139_ = grid_button;
	g_signal_connect_object ((GtkToggleButton*) _tmp139_, "toggled", (GCallback) _iagno_grid_toggled_cb_gtk_toggle_button_toggled, self, 0);
	_tmp140_ = grid;
	_tmp141_ = grid_button;
	gtk_grid_attach (_tmp140_, (GtkWidget*) _tmp141_, 0, 3, 2, 1);
	_tmp142_ = _ ("_Flip final results");
	_tmp143_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp142_);
	g_object_ref_sink (_tmp143_);
	flip_final_button = _tmp143_;
	_tmp144_ = flip_final_button;
	_tmp145_ = self->priv->settings;
	_tmp146_ = g_settings_get_boolean (_tmp145_, "flip-final-results");
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp144_, _tmp146_);
	_tmp147_ = flip_final_button;
	g_signal_connect_object ((GtkToggleButton*) _tmp147_, "toggled", (GCallback) _iagno_flip_final_toggled_cb_gtk_toggle_button_toggled, self, 0);
	_tmp148_ = grid;
	_tmp149_ = flip_final_button;
	gtk_grid_attach (_tmp148_, (GtkWidget*) _tmp149_, 0, 4, 2, 1);
	_tmp150_ = _ ("_Tile set:");
	_tmp151_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp150_);
	g_object_ref_sink (_tmp151_);
	_g_object_unref0 (label);
	label = _tmp151_;
	_tmp152_ = label;
	gtk_misc_set_alignment ((GtkMisc*) _tmp152_, 0.0f, 0.5f);
	_tmp153_ = label;
	g_object_set ((GtkWidget*) _tmp153_, "expand", TRUE, NULL);
	_tmp154_ = grid;
	_tmp155_ = label;
	gtk_grid_attach (_tmp154_, (GtkWidget*) _tmp155_, 0, 5, 1, 1);
	_tmp156_ = (GtkComboBox*) gtk_combo_box_new ();
	g_object_ref_sink (_tmp156_);
	theme_combo = _tmp156_;
	_tmp157_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp157_);
	_g_object_unref0 (renderer);
	renderer = _tmp157_;
	_tmp158_ = theme_combo;
	_tmp159_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp158_, (GtkCellRenderer*) _tmp159_, TRUE);
	_tmp160_ = theme_combo;
	_tmp161_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp160_, (GtkCellRenderer*) _tmp161_, "text", 0);
	_tmp162_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);
	_g_object_unref0 (model);
	model = _tmp162_;
	_tmp163_ = theme_combo;
	_tmp164_ = model;
	gtk_combo_box_set_model (_tmp163_, (GtkTreeModel*) _tmp164_);
	dirlist = NULL;
	{
		GDir* _tmp165_ = NULL;
		gchar* _tmp166_ = NULL;
		gchar* _tmp167_ = NULL;
		GDir* _tmp168_ = NULL;
		GDir* _tmp169_ = NULL;
		_tmp166_ = g_build_filename (DATA_DIRECTORY, "themes", NULL);
		_tmp167_ = _tmp166_;
		_tmp168_ = g_dir_open (_tmp167_, (guint) 0, &_inner_error_);
		_tmp169_ = _tmp168_;
		_g_free0 (_tmp167_);
		_tmp165_ = _tmp169_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch4_g_file_error;
			}
			__g_list_free__g_free0_0 (dirlist);
			_g_dir_close0 (dir);
			_g_object_unref0 (theme_combo);
			_g_object_unref0 (flip_final_button);
			_g_object_unref0 (grid_button);
			_g_object_unref0 (enable_sounds_button);
			_g_object_unref0 (model);
			_g_object_unref0 (renderer);
			_g_object_unref0 (combo);
			_g_object_unref0 (label);
			_g_object_unref0 (grid);
			_g_object_unref0 (box);
			_g_object_unref0 (propbox);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_dir_close0 (dir);
		dir = _tmp165_;
		while (TRUE) {
			gchar* filename = NULL;
			GDir* _tmp170_ = NULL;
			const gchar* _tmp171_ = NULL;
			gchar* _tmp172_ = NULL;
			const gchar* _tmp173_ = NULL;
			const gchar* _tmp174_ = NULL;
			gchar* _tmp175_ = NULL;
			GCompareFunc _tmp176_ = NULL;
			_tmp170_ = dir;
			_tmp171_ = g_dir_read_name (_tmp170_);
			_tmp172_ = g_strdup (_tmp171_);
			filename = _tmp172_;
			_tmp173_ = filename;
			if (_tmp173_ == NULL) {
				_g_free0 (filename);
				break;
			}
			_tmp174_ = filename;
			_tmp175_ = g_strdup (_tmp174_);
			_tmp176_ = g_strcmp0;
			dirlist = g_list_insert_sorted (dirlist, _tmp175_, _tmp176_);
			_g_free0 (filename);
		}
	}
	goto __finally4;
	__catch4_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp177_ = NULL;
		const gchar* _tmp178_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp177_ = e;
		_tmp178_ = _tmp177_->message;
		g_warning ("iagno.vala:616: Failed to load themes: %s", _tmp178_);
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		__g_list_free__g_free0_0 (dirlist);
		_g_dir_close0 (dir);
		_g_object_unref0 (theme_combo);
		_g_object_unref0 (flip_final_button);
		_g_object_unref0 (grid_button);
		_g_object_unref0 (enable_sounds_button);
		_g_object_unref0 (model);
		_g_object_unref0 (renderer);
		_g_object_unref0 (combo);
		_g_object_unref0 (label);
		_g_object_unref0 (grid);
		_g_object_unref0 (box);
		_g_object_unref0 (propbox);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp179_ = dirlist;
	{
		GList* filename_collection = NULL;
		GList* filename_it = NULL;
		filename_collection = _tmp179_;
		for (filename_it = filename_collection; filename_it != NULL; filename_it = filename_it->next) {
			gchar* _tmp180_ = NULL;
			gchar* filename = NULL;
			_tmp180_ = g_strdup ((const gchar*) filename_it->data);
			filename = _tmp180_;
			{
				GtkListStore* _tmp181_ = NULL;
				GtkTreeIter _tmp182_ = {0};
				gchar* label_text = NULL;
				const gchar* _tmp183_ = NULL;
				gchar* _tmp184_ = NULL;
				const gchar* _tmp185_ = NULL;
				gchar* _tmp186_ = NULL;
				gint extension_index = 0;
				const gchar* _tmp187_ = NULL;
				gint _tmp188_ = 0;
				gint _tmp189_ = 0;
				GtkListStore* _tmp193_ = NULL;
				GtkTreeIter _tmp194_ = {0};
				const gchar* _tmp195_ = NULL;
				const gchar* _tmp196_ = NULL;
				const gchar* _tmp197_ = NULL;
				GSettings* _tmp198_ = NULL;
				gchar* _tmp199_ = NULL;
				gchar* _tmp200_ = NULL;
				gboolean _tmp201_ = FALSE;
				_tmp181_ = model;
				gtk_list_store_append (_tmp181_, &_tmp182_);
				iter = _tmp182_;
				_tmp183_ = filename;
				_tmp184_ = g_strdup (_tmp183_);
				label_text = _tmp184_;
				_tmp185_ = label_text;
				_tmp186_ = string_replace (_tmp185_, "_", " ");
				_g_free0 (label_text);
				label_text = _tmp186_;
				_tmp187_ = label_text;
				_tmp188_ = string_last_index_of_char (_tmp187_, (gunichar) '.', 0);
				extension_index = _tmp188_;
				_tmp189_ = extension_index;
				if (_tmp189_ > 0) {
					const gchar* _tmp190_ = NULL;
					gint _tmp191_ = 0;
					gchar* _tmp192_ = NULL;
					_tmp190_ = label_text;
					_tmp191_ = extension_index;
					_tmp192_ = string_substring (_tmp190_, (glong) 0, (glong) _tmp191_);
					_g_free0 (label_text);
					label_text = _tmp192_;
				}
				_tmp193_ = model;
				_tmp194_ = iter;
				_tmp195_ = label_text;
				_tmp196_ = filename;
				gtk_list_store_set (_tmp193_, &_tmp194_, 0, _tmp195_, 1, _tmp196_, -1);
				_tmp197_ = filename;
				_tmp198_ = self->priv->settings;
				_tmp199_ = g_settings_get_string (_tmp198_, "tileset");
				_tmp200_ = _tmp199_;
				_tmp201_ = g_strcmp0 (_tmp197_, _tmp200_) == 0;
				_g_free0 (_tmp200_);
				if (_tmp201_) {
					GtkComboBox* _tmp202_ = NULL;
					GtkTreeIter _tmp203_ = {0};
					_tmp202_ = theme_combo;
					_tmp203_ = iter;
					gtk_combo_box_set_active_iter (_tmp202_, &_tmp203_);
				}
				_g_free0 (label_text);
				_g_free0 (filename);
			}
		}
	}
	_tmp204_ = label;
	_tmp205_ = theme_combo;
	gtk_label_set_mnemonic_widget (_tmp204_, (GtkWidget*) _tmp205_);
	_tmp206_ = theme_combo;
	g_signal_connect_object (_tmp206_, "changed", (GCallback) _iagno_theme_changed_cb_gtk_combo_box_changed, self, 0);
	_tmp207_ = grid;
	_tmp208_ = theme_combo;
	gtk_grid_attach (_tmp207_, (GtkWidget*) _tmp208_, 1, 5, 1, 1);
	_tmp209_ = propbox;
	gtk_widget_show_all ((GtkWidget*) _tmp209_);
	__g_list_free__g_free0_0 (dirlist);
	_g_dir_close0 (dir);
	_g_object_unref0 (theme_combo);
	_g_object_unref0 (flip_final_button);
	_g_object_unref0 (grid_button);
	_g_object_unref0 (enable_sounds_button);
	_g_object_unref0 (model);
	_g_object_unref0 (renderer);
	_g_object_unref0 (combo);
	_g_object_unref0 (label);
	_g_object_unref0 (grid);
	_g_object_unref0 (box);
	_g_object_unref0 (propbox);
}


gint iagno_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* context = NULL;
	GOptionContext* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	GOptionContext* _tmp2_ = NULL;
	GOptionGroup* _tmp3_ = NULL;
	const gchar* _tmp8_ = NULL;
	Iagno* app = NULL;
	Iagno* _tmp9_ = NULL;
	gint _result_ = 0;
	Iagno* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = g_option_context_new (NULL);
	context = _tmp0_;
	_tmp1_ = context;
	g_option_context_set_translation_domain (_tmp1_, GETTEXT_PACKAGE);
	_tmp2_ = context;
	_tmp3_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (_tmp2_, _tmp3_);
	{
		GOptionContext* _tmp4_ = NULL;
		_tmp4_ = context;
		g_option_context_parse (_tmp4_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		FILE* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = stderr;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp5_, "%s\n", _tmp7_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		return result;
	}
	__finally6:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp8_ = _ ("Iagno");
	g_set_application_name (_tmp8_);
	gtk_window_set_default_icon_name ("iagno");
	_tmp9_ = iagno_new ();
	app = _tmp9_;
	_tmp10_ = app;
	_tmp11_ = g_application_run ((GApplication*) _tmp10_, 0, NULL);
	_result_ = _tmp11_;
	result = _result_;
	_g_object_unref0 (app);
	_g_option_context_free0 (context);
	return result;
}


int main (int argc, char ** argv) {
	return iagno_main (argv, argc);
}


static void iagno_class_init (IagnoClass * klass) {
	iagno_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (IagnoPrivate));
	G_APPLICATION_CLASS (klass)->startup = iagno_real_startup;
	G_APPLICATION_CLASS (klass)->activate = iagno_real_activate;
	G_APPLICATION_CLASS (klass)->shutdown = iagno_real_shutdown;
	G_OBJECT_CLASS (klass)->finalize = iagno_finalize;
}


static void iagno_instance_init (Iagno * self) {
	self->priv = IAGNO_GET_PRIVATE (self);
	self->priv->light_computer = NULL;
	self->priv->dark_computer = NULL;
	self->priv->computer_timer = (guint) 0;
	self->priv->game = NULL;
}


static void iagno_finalize (GObject* obj) {
	Iagno * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_IAGNO, Iagno);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->infobar);
	_g_object_unref0 (self->priv->statusbar);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->infobar_label);
	_g_object_unref0 (self->priv->dark_label);
	_g_object_unref0 (self->priv->light_label);
	_g_object_unref0 (self->priv->dark_score_label);
	_g_object_unref0 (self->priv->light_score_label);
	_g_object_unref0 (self->priv->undo_action);
	_g_object_unref0 (self->priv->light_computer);
	_g_object_unref0 (self->priv->dark_computer);
	_g_object_unref0 (self->priv->game);
	G_OBJECT_CLASS (iagno_parent_class)->finalize (obj);
}


GType iagno_get_type (void) {
	static volatile gsize iagno_type_id__volatile = 0;
	if (g_once_init_enter (&iagno_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IagnoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) iagno_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Iagno), 0, (GInstanceInitFunc) iagno_instance_init, NULL };
		GType iagno_type_id;
		iagno_type_id = g_type_register_static (GTK_TYPE_APPLICATION, "Iagno", &g_define_type_info, 0);
		g_once_init_leave (&iagno_type_id__volatile, iagno_type_id);
	}
	return iagno_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



