/* iagno.c generated by valac 0.27.1.22-4ade8, the Vala compiler
 * generated from iagno.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This file is part of Iagno.
 *
 * Iagno is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Iagno is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Iagno. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <gdk/gdk.h>
#include <canberra-gtk.h>
#include <canberra.h>


#define TYPE_IAGNO (iagno_get_type ())
#define IAGNO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IAGNO, Iagno))
#define IAGNO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IAGNO, IagnoClass))
#define IS_IAGNO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IAGNO))
#define IS_IAGNO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IAGNO))
#define IAGNO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IAGNO, IagnoClass))

typedef struct _Iagno Iagno;
typedef struct _IagnoClass IagnoClass;
typedef struct _IagnoPrivate IagnoPrivate;

#define TYPE_GAME_WINDOW (game_window_get_type ())
#define GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_WINDOW, GameWindow))
#define GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_WINDOW, GameWindowClass))
#define IS_GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_WINDOW))
#define IS_GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_WINDOW))
#define GAME_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_WINDOW, GameWindowClass))

typedef struct _GameWindow GameWindow;
typedef struct _GameWindowClass GameWindowClass;

#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;

#define TYPE_THEMES_DIALOG (themes_dialog_get_type ())
#define THEMES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEMES_DIALOG, ThemesDialog))
#define THEMES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEMES_DIALOG, ThemesDialogClass))
#define IS_THEMES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEMES_DIALOG))
#define IS_THEMES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEMES_DIALOG))
#define THEMES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEMES_DIALOG, ThemesDialogClass))

typedef struct _ThemesDialog ThemesDialog;
typedef struct _ThemesDialogClass ThemesDialogClass;

#define TYPE_COMPUTER_PLAYER (computer_player_get_type ())
#define COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayer))
#define COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))
#define IS_COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPUTER_PLAYER))
#define IS_COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPUTER_PLAYER))
#define COMPUTER_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))

typedef struct _ComputerPlayer ComputerPlayer;
typedef struct _ComputerPlayerClass ComputerPlayerClass;

#define TYPE_PLAYER (player_get_type ())

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;

#define IAGNO_TYPE_SOUND (iagno_sound_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
typedef struct _Block3Data Block3Data;

#define TYPE_GAME_WINDOW_FLAGS (game_window_flags_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GameWindowPrivate GameWindowPrivate;

struct _Iagno {
	GtkApplication parent_instance;
	IagnoPrivate * priv;
};

struct _IagnoClass {
	GtkApplicationClass parent_class;
};

typedef enum  {
	PLAYER_NONE,
	PLAYER_DARK,
	PLAYER_LIGHT
} Player;

struct _IagnoPrivate {
	GSettings* settings;
	GameWindow* window;
	GameView* view;
	GtkLabel* dark_score_label;
	GtkLabel* light_score_label;
	ThemesDialog* themes_dialog;
	ComputerPlayer* computer;
	Player player_one;
	Game* game;
};

typedef enum  {
	IAGNO_SOUND_FLIP,
	IAGNO_SOUND_GAMEOVER
} IagnoSound;

struct _Block3Data {
	int _ref_count_;
	Iagno* self;
	GtkBox* level_box;
	GtkBox* color_box;
};

typedef enum  {
	GAME_WINDOW_FLAGS_SHOW_UNDO = 1 << 0,
	GAME_WINDOW_FLAGS_SHOW_REDO = 1 << 1,
	GAME_WINDOW_FLAGS_SHOW_HINT = 1 << 2
} GameWindowFlags;

struct _GameWindow {
	GtkApplicationWindow parent_instance;
	GameWindowPrivate * priv;
	GSimpleAction* undo_action;
	GSimpleAction* redo_action;
};

struct _GameWindowClass {
	GtkApplicationWindowClass parent_class;
};


static gpointer iagno_parent_class = NULL;
static gboolean iagno_fast_mode;
static gboolean iagno_fast_mode = FALSE;
static gboolean iagno_alternative_start;
static gboolean iagno_alternative_start = FALSE;
static gint iagno_computer_level;
static gint iagno_computer_level = 0;
static gint iagno_size;
static gint iagno_size = 8;
static gboolean iagno_start_now;
static gboolean iagno_start_now = FALSE;
static gchar* iagno_color;
static gchar* iagno_color = NULL;
static gboolean* iagno_sound;
static gboolean* iagno_sound = NULL;
static gboolean* iagno_two_players;
static gboolean* iagno_two_players = NULL;

GType iagno_get_type (void) G_GNUC_CONST;
GType game_window_get_type (void) G_GNUC_CONST;
GType game_view_get_type (void) G_GNUC_CONST;
GType themes_dialog_get_type (void) G_GNUC_CONST;
GType computer_player_get_type (void) G_GNUC_CONST;
GType player_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define IAGNO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_IAGNO, IagnoPrivate))
enum  {
	IAGNO_DUMMY_PROPERTY
};
static GType iagno_sound_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define IAGNO_QUICK_MOVE_DELAY 0.4
#define IAGNO_MODERATE_MOVE_DELAY 1.0
#define IAGNO_SLOW_MOVE_DELAY 2.0
static void iagno_theme_cb (Iagno* self);
static void _iagno_theme_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_help_cb (Iagno* self);
static void _iagno_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_about_cb (Iagno* self);
static void _iagno_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
gint iagno_main (gchar** args, int args_length1);
Iagno* iagno_new (void);
Iagno* iagno_construct (GType object_type);
static gint iagno_real_handle_local_options (GApplication* base, GVariantDict* options);
static gboolean* _bool_dup (gboolean* self);
static void iagno_real_startup (GApplication* base);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
static void iagno_player_move_cb (Iagno* self, gint x, gint y);
static void _iagno_player_move_cb_game_view_move (GameView* _sender, gint x, gint y, gpointer self);
void game_view_set_scoreboard (GameView* self, GtkDrawingArea* value);
void game_view_set_theme (GameView* self, const gchar* value);
GType game_window_flags_get_type (void) G_GNUC_CONST;
GameWindow* game_window_new (const gchar* name, gint width, gint height, gboolean maximized, gboolean start_now, GameWindowFlags flags, GtkBox* new_game_screen, GtkWidget* _view);
GameWindow* game_window_construct (GType object_type, const gchar* name, gint width, gint height, gboolean maximized, gboolean start_now, GameWindowFlags flags, GtkBox* new_game_screen, GtkWidget* _view);
void game_window_add_to_sidebox (GameWindow* self, GtkWidget* widget);
static void iagno_start_game (Iagno* self);
static void _iagno_start_game_game_window_play (GameWindow* _sender, gpointer self);
static void iagno_wait_cb (Iagno* self);
static void _iagno_wait_cb_game_window_wait (GameWindow* _sender, gpointer self);
static void iagno_back_cb (Iagno* self);
static void _iagno_back_cb_game_window_back (GameWindow* _sender, gpointer self);
static void iagno_undo_cb (Iagno* self);
static void _iagno_undo_cb_game_window_undo (GameWindow* _sender, gpointer self);
static void __lambda8_ (Block3Data* _data3_);
static void ___lambda8__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda9_ (Block3Data* _data3_);
static void ___lambda9__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void iagno_real_activate (GApplication* base);
static void iagno_real_shutdown (GApplication* base);
void game_window_save_state (GameWindow* self, GSettings* settings);
ThemesDialog* themes_dialog_new (GSettings* settings, GameView* view);
ThemesDialog* themes_dialog_construct (GType object_type, GSettings* settings, GameView* view);
Player game_get_current_color (Game* self);
gboolean game_get_is_complete (Game* self);
void computer_player_move_async (ComputerPlayer* self, gdouble delay_seconds, GAsyncReadyCallback _callback_, gpointer _user_data_);
void computer_player_move_finish (ComputerPlayer* self, GAsyncResult* _res_);
static void iagno_game_complete (Iagno* self, gboolean play_gameover_sound);
void computer_player_cancel_move (ComputerPlayer* self);
Game* game_new (gboolean alternative_start, gint tmp_size);
Game* game_construct (GType object_type, gboolean alternative_start, gint tmp_size);
static void iagno_turn_ended_cb (Iagno* self);
static void _iagno_turn_ended_cb_game_turn_ended (Game* _sender, gpointer self);
void game_view_set_game (GameView* self, Game* value);
ComputerPlayer* computer_player_new (Game* game, gint difficulty_level);
ComputerPlayer* computer_player_construct (GType object_type, Game* game, gint difficulty_level);
static void iagno_update_ui (Iagno* self);
void game_window_set_subtitle (GameWindow* self, const gchar* subtitle);
gint game_get_number_of_moves (Game* self);
gint game_get_n_dark_tiles (Game* self);
gint game_get_n_light_tiles (Game* self);
void game_undo (Game* self, gint count);
gboolean game_get_current_player_can_move (Game* self);
static void iagno_play_sound (Iagno* self, IagnoSound sound);
void game_view_update_scoreboard (GameView* self);
static void iagno_prepare_move (Iagno* self);
static void iagno_pass (Iagno* self);
void game_pass (Game* self);
void game_window_finish_game (GameWindow* self);
gint game_place_tile (Game* self, gint x, gint y, gboolean apply);
const gchar* game_view_get_sound_flip (GameView* self);
const gchar* game_view_get_sound_gameover (GameView* self);
static void iagno_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GOptionEntry IAGNO_option_entries[11] = {{"alternative-start", (gchar) 0, 0, G_OPTION_ARG_NONE, &iagno_alternative_start, "Start with an alternative position", NULL}, {"fast-mode", 'f', 0, G_OPTION_ARG_NONE, &iagno_fast_mode, "Reduce delay before AI moves", NULL}, {"first", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Play first", NULL}, {"level", 'l', 0, G_OPTION_ARG_INT, &iagno_computer_level, "Set the level of the computer's AI", "LEVEL"}, {"mute", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Turn off the sound", NULL}, {"second", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Play second", NULL}, {"size", 's', 0, G_OPTION_ARG_INT, &iagno_size, "Size of the board (debug only)", "SIZE"}, {"two-players", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Two-players mode", NULL}, {"unmute", (gchar) 0, 0, G_OPTION_ARG_NONE, NULL, "Turn on the sound", NULL}, {"version", 'v', 0, G_OPTION_ARG_NONE, NULL, "Print release version and exit", NULL}, {NULL}};
static const GActionEntry IAGNO_app_actions[4] = {{"theme", _iagno_theme_cb_gsimple_action_activate_callback}, {"help", _iagno_help_cb_gsimple_action_activate_callback}, {"about", _iagno_about_cb_gsimple_action_activate_callback}, {"quit", _g_application_quit_gsimple_action_activate_callback}};

static GType iagno_sound_get_type (void) {
	static volatile gsize iagno_sound_type_id__volatile = 0;
	if (g_once_init_enter (&iagno_sound_type_id__volatile)) {
		static const GEnumValue values[] = {{IAGNO_SOUND_FLIP, "IAGNO_SOUND_FLIP", "flip"}, {IAGNO_SOUND_GAMEOVER, "IAGNO_SOUND_GAMEOVER", "gameover"}, {0, NULL, NULL}};
		GType iagno_sound_type_id;
		iagno_sound_type_id = g_enum_register_static ("IagnoSound", values);
		g_once_init_leave (&iagno_sound_type_id__volatile, iagno_sound_type_id);
	}
	return iagno_sound_type_id__volatile;
}


static void _iagno_theme_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 72 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_theme_cb ((Iagno*) self);
#line 296 "iagno.c"
}


static void _iagno_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 72 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_help_cb ((Iagno*) self);
#line 303 "iagno.c"
}


static void _iagno_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 72 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_about_cb ((Iagno*) self);
#line 310 "iagno.c"
}


static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 72 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_application_quit ((GApplication*) self);
#line 317 "iagno.c"
}


gint iagno_main (gchar** args, int args_length1) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	Iagno* _tmp1_ = NULL;
	Iagno* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 82 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	setlocale (LC_ALL, "");
#line 83 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 84 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 85 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	textdomain (GETTEXT_PACKAGE);
#line 87 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = _ ("Iagno");
#line 87 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_set_application_name (_tmp0_);
#line 88 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_window_set_default_icon_name ("iagno");
#line 90 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = iagno_new ();
#line 90 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = _tmp1_;
#line 90 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = args;
#line 90 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3__length1 = args_length1;
#line 90 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = g_application_run ((GApplication*) _tmp2_, _tmp3__length1, _tmp3_);
#line 90 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = _tmp4_;
#line 90 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (_tmp2_);
#line 90 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	result = _tmp5_;
#line 90 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return result;
#line 362 "iagno.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 80 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return iagno_main (argv, argc);
#line 372 "iagno.c"
}


Iagno* iagno_construct (GType object_type) {
	Iagno * self = NULL;
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self = (Iagno*) g_object_new (object_type, "application-id", "org.gnome.iagno", "flags", G_APPLICATION_FLAGS_NONE, NULL);
#line 97 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_application_add_main_option_entries ((GApplication*) self, IAGNO_option_entries);
#line 93 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return self;
#line 384 "iagno.c"
}


Iagno* iagno_new (void) {
#line 93 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return iagno_construct (TYPE_IAGNO);
#line 391 "iagno.c"
}


static gboolean* _bool_dup (gboolean* self) {
	gboolean* dup;
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	dup = g_new0 (gboolean, 1);
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	memcpy (dup, self, sizeof (gboolean));
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return dup;
#line 403 "iagno.c"
}


static gpointer __bool_dup0 (gpointer self) {
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return self ? _bool_dup (self) : NULL;
#line 410 "iagno.c"
}


static gint iagno_real_handle_local_options (GApplication* base, GVariantDict* options) {
	Iagno * self;
	gint result = 0;
	GVariantDict* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gint _tmp3_ = 0;
	GVariantDict* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gint _tmp15_ = 0;
	GVariantDict* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
#line 100 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self = (Iagno*) base;
#line 100 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_val_if_fail (options != NULL, 0);
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = options;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp1_) {
#line 436 "iagno.c"
		FILE* _tmp2_ = NULL;
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp2_ = stderr;
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		fprintf (_tmp2_, "%1$s %2$s\n", "iagno", VERSION);
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		result = EXIT_SUCCESS;
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		return result;
#line 446 "iagno.c"
	}
#line 109 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = iagno_size;
#line 109 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp3_ < 4) {
#line 452 "iagno.c"
		FILE* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 112 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp4_ = stderr;
#line 112 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp5_ = _ ("Size must be at least 4.");
#line 112 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		fprintf (_tmp4_, "%s\n", _tmp5_);
#line 113 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		result = EXIT_FAILURE;
#line 113 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		return result;
#line 465 "iagno.c"
	}
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp6_ = options;
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp7_ = g_variant_dict_contains (_tmp6_, "mute");
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp7_) {
#line 473 "iagno.c"
		gboolean _tmp8_ = FALSE;
		gboolean* _tmp9_ = NULL;
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp8_ = FALSE;
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp9_ = __bool_dup0 (&_tmp8_);
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_free0 (iagno_sound);
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		iagno_sound = _tmp9_;
#line 484 "iagno.c"
	} else {
		GVariantDict* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp10_ = options;
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp11_ = g_variant_dict_contains (_tmp10_, "unmute");
#line 118 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (_tmp11_) {
#line 494 "iagno.c"
			gboolean _tmp12_ = FALSE;
			gboolean* _tmp13_ = NULL;
#line 119 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp12_ = TRUE;
#line 119 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp13_ = __bool_dup0 (&_tmp12_);
#line 119 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_g_free0 (iagno_sound);
#line 119 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			iagno_sound = _tmp13_;
#line 505 "iagno.c"
		}
	}
#line 122 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp15_ = iagno_computer_level;
#line 122 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp15_ < 0) {
#line 122 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp14_ = TRUE;
#line 514 "iagno.c"
	} else {
		gint _tmp16_ = 0;
#line 122 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp16_ = iagno_computer_level;
#line 122 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp14_ = _tmp16_ > 3;
#line 521 "iagno.c"
	}
#line 122 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp14_) {
#line 525 "iagno.c"
		FILE* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp17_ = stderr;
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp18_ = _ ("Level should be between 1 (easy) and 3 (hard). Settings unchanged.");
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		fprintf (_tmp17_, "%s\n", _tmp18_);
#line 534 "iagno.c"
	}
#line 125 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp19_ = options;
#line 125 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp20_ = g_variant_dict_contains (_tmp19_, "two-players");
#line 125 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp20_) {
#line 542 "iagno.c"
		gboolean _tmp21_ = FALSE;
		gboolean* _tmp22_ = NULL;
#line 126 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp21_ = TRUE;
#line 126 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp22_ = __bool_dup0 (&_tmp21_);
#line 126 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_free0 (iagno_two_players);
#line 126 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		iagno_two_players = _tmp22_;
#line 127 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		iagno_start_now = TRUE;
#line 555 "iagno.c"
	} else {
		GVariantDict* _tmp23_ = NULL;
		gboolean _tmp24_ = FALSE;
#line 128 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp23_ = options;
#line 128 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp24_ = g_variant_dict_contains (_tmp23_, "first");
#line 128 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (_tmp24_) {
#line 565 "iagno.c"
			gchar* _tmp25_ = NULL;
			gboolean _tmp26_ = FALSE;
			gboolean* _tmp27_ = NULL;
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp25_ = g_strdup ("dark");
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_g_free0 (iagno_color);
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			iagno_color = _tmp25_;
#line 130 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp26_ = FALSE;
#line 130 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp27_ = __bool_dup0 (&_tmp26_);
#line 130 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_g_free0 (iagno_two_players);
#line 130 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			iagno_two_players = _tmp27_;
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			iagno_start_now = TRUE;
#line 585 "iagno.c"
		} else {
			GVariantDict* _tmp28_ = NULL;
			gboolean _tmp29_ = FALSE;
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp28_ = options;
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp29_ = g_variant_dict_contains (_tmp28_, "second");
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			if (_tmp29_) {
#line 595 "iagno.c"
				gchar* _tmp30_ = NULL;
				gboolean _tmp31_ = FALSE;
				gboolean* _tmp32_ = NULL;
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
				_tmp30_ = g_strdup ("light");
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
				_g_free0 (iagno_color);
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
				iagno_color = _tmp30_;
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
				_tmp31_ = FALSE;
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
				_tmp32_ = __bool_dup0 (&_tmp31_);
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
				_g_free0 (iagno_two_players);
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
				iagno_two_players = _tmp32_;
#line 135 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
				iagno_start_now = TRUE;
#line 615 "iagno.c"
			}
		}
	}
#line 139 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	result = -1;
#line 139 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return result;
#line 623 "iagno.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return _data3_;
#line 632 "iagno.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 641 "iagno.c"
		Iagno* self;
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		self = _data3_->self;
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_object_unref0 (_data3_->color_box);
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_object_unref0 (_data3_->level_box);
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_object_unref0 (self);
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_slice_free (Block3Data, _data3_);
#line 653 "iagno.c"
	}
}


static void _iagno_player_move_cb_game_view_move (GameView* _sender, gint x, gint y, gpointer self) {
#line 175 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_player_move_cb ((Iagno*) self, x, y);
#line 661 "iagno.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 177 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	return self ? g_object_ref (self) : NULL;
#line 668 "iagno.c"
}


static void _iagno_start_game_game_window_play (GameWindow* _sender, gpointer self) {
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_start_game ((Iagno*) self);
#line 675 "iagno.c"
}


static void _iagno_wait_cb_game_window_wait (GameWindow* _sender, gpointer self) {
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_wait_cb ((Iagno*) self);
#line 682 "iagno.c"
}


static void _iagno_back_cb_game_window_back (GameWindow* _sender, gpointer self) {
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_back_cb ((Iagno*) self);
#line 689 "iagno.c"
}


static void _iagno_undo_cb_game_window_undo (GameWindow* _sender, gpointer self) {
#line 197 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_undo_cb ((Iagno*) self);
#line 696 "iagno.c"
}


static void __lambda8_ (Block3Data* _data3_) {
	Iagno* self;
	GtkBox* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self = _data3_->self;
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = _data3_->level_box;
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = self->priv->settings;
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = g_settings_get_int (_tmp1_, "num-players");
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp2_ == 1);
#line 715 "iagno.c"
}


static void ___lambda8__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	__lambda8_ (self);
#line 722 "iagno.c"
}


static void __lambda9_ (Block3Data* _data3_) {
	Iagno* self;
	GtkBox* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 220 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self = _data3_->self;
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = _data3_->color_box;
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = self->priv->settings;
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = g_settings_get_int (_tmp1_, "num-players");
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp2_ == 1);
#line 741 "iagno.c"
}


static void ___lambda9__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 220 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	__lambda9_ (self);
#line 748 "iagno.c"
}


static void iagno_real_startup (GApplication* base) {
	Iagno * self;
	Block3Data* _data3_;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp0_ = NULL;
	GtkCssProvider* _tmp1_ = NULL;
	GdkScreen* _tmp2_ = NULL;
	GtkCssProvider* _tmp3_ = NULL;
	GSettings* _tmp4_ = NULL;
	gboolean* _tmp5_ = NULL;
	gboolean* _tmp8_ = NULL;
	const gchar* _tmp16_ = NULL;
	gboolean _tmp21_ = FALSE;
	gint _tmp22_ = 0;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp28_ = NULL;
	GameView* _tmp29_ = NULL;
	GameView* _tmp30_ = NULL;
	GtkDrawingArea* scoredrawing = NULL;
	GtkBuilder* _tmp31_ = NULL;
	GObject* _tmp32_ = NULL;
	GtkDrawingArea* _tmp33_ = NULL;
	GameView* _tmp34_ = NULL;
	GtkDrawingArea* _tmp35_ = NULL;
	GameView* _tmp36_ = NULL;
	GSettings* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	GSettings* _tmp41_ = NULL;
	gint _tmp42_ = 0;
	GSettings* _tmp43_ = NULL;
	gint _tmp44_ = 0;
	GSettings* _tmp45_ = NULL;
	gboolean _tmp46_ = FALSE;
	gboolean _tmp47_ = FALSE;
	GtkBuilder* _tmp48_ = NULL;
	GObject* _tmp49_ = NULL;
	GameView* _tmp50_ = NULL;
	GameWindow* _tmp51_ = NULL;
	GtkWidget* scoregrid = NULL;
	GtkBuilder* _tmp52_ = NULL;
	GObject* _tmp53_ = NULL;
	GtkWidget* _tmp54_ = NULL;
	GameWindow* _tmp55_ = NULL;
	GtkWidget* _tmp56_ = NULL;
	GameWindow* _tmp57_ = NULL;
	GameWindow* _tmp58_ = NULL;
	GameWindow* _tmp59_ = NULL;
	GameWindow* _tmp60_ = NULL;
	gchar* _tmp61_ = NULL;
	gchar** _tmp62_ = NULL;
	gchar** _tmp63_ = NULL;
	gint _tmp63__length1 = 0;
	gchar* _tmp64_ = NULL;
	gchar** _tmp65_ = NULL;
	gchar** _tmp66_ = NULL;
	gint _tmp66__length1 = 0;
	gchar* _tmp67_ = NULL;
	gchar** _tmp68_ = NULL;
	gchar** _tmp69_ = NULL;
	gint _tmp69__length1 = 0;
	gchar* _tmp70_ = NULL;
	gchar** _tmp71_ = NULL;
	gchar** _tmp72_ = NULL;
	gint _tmp72__length1 = 0;
	gchar* _tmp73_ = NULL;
	gchar** _tmp74_ = NULL;
	gchar** _tmp75_ = NULL;
	gint _tmp75__length1 = 0;
	GSettings* _tmp76_ = NULL;
	GAction* _tmp77_ = NULL;
	GAction* _tmp78_ = NULL;
	GSettings* _tmp79_ = NULL;
	GAction* _tmp80_ = NULL;
	GAction* _tmp81_ = NULL;
	GSettings* _tmp82_ = NULL;
	GAction* _tmp83_ = NULL;
	GAction* _tmp84_ = NULL;
	GSettings* _tmp85_ = NULL;
	GAction* _tmp86_ = NULL;
	GAction* _tmp87_ = NULL;
	GtkBuilder* _tmp88_ = NULL;
	GObject* _tmp89_ = NULL;
	GtkBox* _tmp90_ = NULL;
	GSettings* _tmp91_ = NULL;
	GtkBox* _tmp92_ = NULL;
	GSettings* _tmp93_ = NULL;
	gint _tmp94_ = 0;
	GtkBuilder* _tmp95_ = NULL;
	GObject* _tmp96_ = NULL;
	GtkBox* _tmp97_ = NULL;
	GSettings* _tmp98_ = NULL;
	GtkBox* _tmp99_ = NULL;
	GSettings* _tmp100_ = NULL;
	gint _tmp101_ = 0;
	GSettings* _tmp102_ = NULL;
	const gchar* _tmp103_ = NULL;
	GSettings* _tmp104_ = NULL;
	gint _tmp105_ = 0;
	gint _tmp106_ = 0;
	gboolean* _tmp107_ = NULL;
	GSettings* _tmp108_ = NULL;
	GtkBuilder* _tmp109_ = NULL;
	GObject* _tmp110_ = NULL;
	GtkLabel* _tmp111_ = NULL;
	GtkBuilder* _tmp112_ = NULL;
	GObject* _tmp113_ = NULL;
	GtkLabel* _tmp114_ = NULL;
	gboolean _tmp115_ = FALSE;
	GameWindow* _tmp116_ = NULL;
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self = (Iagno*) base;
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_data3_->_ref_count_ = 1;
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_data3_->self = g_object_ref (self);
#line 144 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	G_APPLICATION_CLASS (iagno_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 146 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = gtk_css_provider_new ();
#line 146 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	css_provider = _tmp0_;
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = css_provider;
#line 147 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_css_provider_load_from_resource (_tmp1_, "/org/gnome/iagno/ui/iagno.css");
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = gdk_screen_get_default ();
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = css_provider;
#line 148 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_style_context_add_provider_for_screen (_tmp2_, (GtkStyleProvider*) _tmp3_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = g_settings_new ("org.gnome.iagno");
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->settings);
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->settings = _tmp4_;
#line 153 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = iagno_sound;
#line 153 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp5_ != NULL) {
#line 897 "iagno.c"
		GSettings* _tmp6_ = NULL;
		gboolean* _tmp7_ = NULL;
#line 154 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp6_ = self->priv->settings;
#line 154 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp7_ = iagno_sound;
#line 154 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_settings_set_boolean (_tmp6_, "sound", *_tmp7_);
#line 906 "iagno.c"
	}
#line 156 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp8_ = iagno_two_players;
#line 156 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp8_ != NULL) {
#line 912 "iagno.c"
		gint _tmp9_ = 0;
		gboolean* _tmp10_ = NULL;
		GSettings* _tmp11_ = NULL;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp10_ = iagno_two_players;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (*_tmp10_) {
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp9_ = 2;
#line 922 "iagno.c"
		} else {
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp9_ = 1;
#line 926 "iagno.c"
		}
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp11_ = self->priv->settings;
#line 157 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_settings_set_int (_tmp11_, "num-players", _tmp9_);
#line 932 "iagno.c"
	} else {
		GSettings* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gboolean _tmp14_ = FALSE;
		gboolean* _tmp15_ = NULL;
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp12_ = self->priv->settings;
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp13_ = g_settings_get_int (_tmp12_, "num-players");
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp14_ = _tmp13_ == 2;
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp15_ = __bool_dup0 (&_tmp14_);
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_free0 (iagno_two_players);
#line 159 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		iagno_two_players = _tmp15_;
#line 950 "iagno.c"
	}
#line 161 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp16_ = iagno_color;
#line 161 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp16_ != NULL) {
#line 956 "iagno.c"
		GSettings* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
#line 162 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp17_ = self->priv->settings;
#line 162 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp18_ = iagno_color;
#line 162 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_settings_set_string (_tmp17_, "color", _tmp18_);
#line 965 "iagno.c"
	} else {
		GSettings* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
#line 164 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp19_ = self->priv->settings;
#line 164 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp20_ = g_settings_get_string (_tmp19_, "color");
#line 164 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_free0 (iagno_color);
#line 164 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		iagno_color = _tmp20_;
#line 977 "iagno.c"
	}
#line 166 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp22_ = iagno_computer_level;
#line 166 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp22_ > 0) {
#line 983 "iagno.c"
		gint _tmp23_ = 0;
#line 166 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp23_ = iagno_computer_level;
#line 166 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp21_ = _tmp23_ <= 3;
#line 989 "iagno.c"
	} else {
#line 166 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp21_ = FALSE;
#line 993 "iagno.c"
	}
#line 166 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp21_) {
#line 997 "iagno.c"
		GSettings* _tmp24_ = NULL;
		gint _tmp25_ = 0;
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp24_ = self->priv->settings;
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp25_ = iagno_computer_level;
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_settings_set_int (_tmp24_, "computer-level", _tmp25_);
#line 1006 "iagno.c"
	} else {
		GSettings* _tmp26_ = NULL;
		gint _tmp27_ = 0;
#line 169 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp26_ = self->priv->settings;
#line 169 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp27_ = g_settings_get_int (_tmp26_, "computer-level");
#line 169 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		iagno_computer_level = _tmp27_;
#line 1016 "iagno.c"
	}
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp28_ = gtk_builder_new_from_resource ("/org/gnome/iagno/ui/iagno-screens.ui");
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	builder = _tmp28_;
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp29_ = game_view_new ();
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp29_);
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->view);
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->view = _tmp29_;
#line 175 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp30_ = self->priv->view;
#line 175 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp30_, "move", (GCallback) _iagno_player_move_cb_game_view_move, self, 0);
#line 177 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp31_ = builder;
#line 177 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp32_ = gtk_builder_get_object (_tmp31_, "scoredrawing");
#line 177 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp33_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, gtk_drawing_area_get_type (), GtkDrawingArea));
#line 177 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	scoredrawing = _tmp33_;
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp34_ = self->priv->view;
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp35_ = scoredrawing;
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_view_set_scoreboard (_tmp34_, _tmp35_);
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp36_ = self->priv->view;
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp37_ = self->priv->settings;
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp38_ = g_settings_get_string (_tmp37_, "theme");
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp39_ = _tmp38_;
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_view_set_theme (_tmp36_, _tmp39_);
#line 179 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_free0 (_tmp39_);
#line 182 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp40_ = _ ("Iagno");
#line 182 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp41_ = self->priv->settings;
#line 182 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp42_ = g_settings_get_int (_tmp41_, "window-width");
#line 182 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp43_ = self->priv->settings;
#line 182 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp44_ = g_settings_get_int (_tmp43_, "window-height");
#line 182 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp45_ = self->priv->settings;
#line 182 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp46_ = g_settings_get_boolean (_tmp45_, "window-is-maximized");
#line 182 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp47_ = iagno_start_now;
#line 182 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp48_ = builder;
#line 182 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp49_ = gtk_builder_get_object (_tmp48_, "new-game-screen");
#line 182 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp50_ = self->priv->view;
#line 182 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp51_ = game_window_new (_tmp40_, _tmp42_, _tmp44_, _tmp46_, _tmp47_, GAME_WINDOW_FLAGS_SHOW_UNDO, G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, gtk_box_get_type (), GtkBox), (GtkWidget*) _tmp50_);
#line 182 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_object_ref_sink (_tmp51_);
#line 182 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->window);
#line 182 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->window = _tmp51_;
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp52_ = builder;
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp53_ = gtk_builder_get_object (_tmp52_, "scoregrid");
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp54_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, gtk_widget_get_type (), GtkWidget));
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	scoregrid = _tmp54_;
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp55_ = self->priv->window;
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp56_ = scoregrid;
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_window_add_to_sidebox (_tmp55_, _tmp56_);
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp57_ = self->priv->window;
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp57_, "play", (GCallback) _iagno_start_game_game_window_play, self, 0);
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp58_ = self->priv->window;
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp58_, "wait", (GCallback) _iagno_wait_cb_game_window_wait, self, 0);
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp59_ = self->priv->window;
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp59_, "back", (GCallback) _iagno_back_cb_game_window_back, self, 0);
#line 197 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp60_ = self->priv->window;
#line 197 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp60_, "undo", (GCallback) _iagno_undo_cb_game_window_undo, self, 0);
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_action_map_add_action_entries ((GActionMap*) self, IAGNO_app_actions, G_N_ELEMENTS (IAGNO_app_actions), self);
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp61_ = g_strdup ("<Primary>n");
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp62_ = g_new0 (gchar*, 1 + 1);
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp62_[0] = _tmp61_;
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp63_ = _tmp62_;
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp63__length1 = 1;
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.new-game", _tmp63_);
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp63_ = (_vala_array_free (_tmp63_, _tmp63__length1, (GDestroyNotify) g_free), NULL);
#line 202 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp64_ = g_strdup ("<Primary><Shift>n");
#line 202 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp65_ = g_new0 (gchar*, 1 + 1);
#line 202 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp65_[0] = _tmp64_;
#line 202 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp66_ = _tmp65_;
#line 202 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp66__length1 = 1;
#line 202 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.start-game", _tmp66_);
#line 202 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp66_ = (_vala_array_free (_tmp66_, _tmp66__length1, (GDestroyNotify) g_free), NULL);
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp67_ = g_strdup ("<Primary>z");
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp68_ = g_new0 (gchar*, 1 + 1);
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp68_[0] = _tmp67_;
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp69_ = _tmp68_;
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp69__length1 = 1;
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.undo", _tmp69_);
#line 203 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp69_ = (_vala_array_free (_tmp69_, _tmp69__length1, (GDestroyNotify) g_free), NULL);
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp70_ = g_strdup ("<Primary><Shift>z");
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp71_ = g_new0 (gchar*, 1 + 1);
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp71_[0] = _tmp70_;
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp72_ = _tmp71_;
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp72__length1 = 1;
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.redo", _tmp72_);
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp72_ = (_vala_array_free (_tmp72_, _tmp72__length1, (GDestroyNotify) g_free), NULL);
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp73_ = g_strdup ("Escape");
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp74_ = g_new0 (gchar*, 1 + 1);
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp74_[0] = _tmp73_;
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp75_ = _tmp74_;
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp75__length1 = 1;
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.back", _tmp75_);
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp75_ = (_vala_array_free (_tmp75_, _tmp75__length1, (GDestroyNotify) g_free), NULL);
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp76_ = self->priv->settings;
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp77_ = g_settings_create_action (_tmp76_, "sound");
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp78_ = _tmp77_;
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_action_map_add_action ((GActionMap*) self, _tmp78_);
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (_tmp78_);
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp79_ = self->priv->settings;
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp80_ = g_settings_create_action (_tmp79_, "color");
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp81_ = _tmp80_;
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_action_map_add_action ((GActionMap*) self, _tmp81_);
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (_tmp81_);
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp82_ = self->priv->settings;
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp83_ = g_settings_create_action (_tmp82_, "num-players");
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp84_ = _tmp83_;
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_action_map_add_action ((GActionMap*) self, _tmp84_);
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (_tmp84_);
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp85_ = self->priv->settings;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp86_ = g_settings_create_action (_tmp85_, "computer-level");
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp87_ = _tmp86_;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_action_map_add_action ((GActionMap*) self, _tmp87_);
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (_tmp87_);
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp88_ = builder;
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp89_ = gtk_builder_get_object (_tmp88_, "difficulty-box");
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp90_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp89_, gtk_box_get_type (), GtkBox));
#line 213 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_data3_->level_box = _tmp90_;
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp91_ = self->priv->settings;
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_signal_connect_data (_tmp91_, "changed::num-players", (GCallback) ___lambda8__g_settings_changed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp92_ = _data3_->level_box;
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp93_ = self->priv->settings;
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp94_ = g_settings_get_int (_tmp93_, "num-players");
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp92_, _tmp94_ == 1);
#line 219 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp95_ = builder;
#line 219 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp96_ = gtk_builder_get_object (_tmp95_, "color-box");
#line 219 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp97_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp96_, gtk_box_get_type (), GtkBox));
#line 219 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_data3_->color_box = _tmp97_;
#line 220 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp98_ = self->priv->settings;
#line 220 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_signal_connect_data (_tmp98_, "changed::num-players", (GCallback) ___lambda9__g_settings_changed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
#line 223 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp99_ = _data3_->color_box;
#line 223 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp100_ = self->priv->settings;
#line 223 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp101_ = g_settings_get_int (_tmp100_, "num-players");
#line 223 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp99_, _tmp101_ == 1);
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_settings_sync ();
#line 229 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp102_ = self->priv->settings;
#line 229 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp103_ = iagno_color;
#line 229 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_settings_set_string (_tmp102_, "color", _tmp103_);
#line 230 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp104_ = self->priv->settings;
#line 230 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp105_ = iagno_computer_level;
#line 230 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_settings_set_int (_tmp104_, "computer-level", _tmp105_);
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp107_ = iagno_two_players;
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (*_tmp107_) {
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp106_ = 2;
#line 1292 "iagno.c"
	} else {
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp106_ = 1;
#line 1296 "iagno.c"
	}
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp108_ = self->priv->settings;
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_settings_set_int (_tmp108_, "num-players", _tmp106_);
#line 234 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp109_ = builder;
#line 234 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp110_ = gtk_builder_get_object (_tmp109_, "light-score-label");
#line 234 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp111_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp110_, gtk_label_get_type (), GtkLabel));
#line 234 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->light_score_label);
#line 234 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->light_score_label = _tmp111_;
#line 235 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp112_ = builder;
#line 235 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp113_ = gtk_builder_get_object (_tmp112_, "dark-score-label");
#line 235 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp114_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp113_, gtk_label_get_type (), GtkLabel));
#line 235 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->dark_score_label);
#line 235 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->dark_score_label = _tmp114_;
#line 237 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp115_ = iagno_start_now;
#line 237 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp115_) {
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		iagno_start_game (self);
#line 1328 "iagno.c"
	}
#line 240 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp116_ = self->priv->window;
#line 240 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp116_);
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (scoregrid);
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (scoredrawing);
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (builder);
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (css_provider);
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	block3_data_unref (_data3_);
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_data3_ = NULL;
#line 1346 "iagno.c"
}


static void iagno_real_activate (GApplication* base) {
	Iagno * self;
	GameWindow* _tmp0_ = NULL;
#line 243 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self = (Iagno*) base;
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->window;
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_window_present ((GtkWindow*) _tmp0_);
#line 1359 "iagno.c"
}


static void iagno_real_shutdown (GApplication* base) {
	Iagno * self;
	GameWindow* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
#line 248 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self = (Iagno*) base;
#line 250 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	G_APPLICATION_CLASS (iagno_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 251 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->window;
#line 251 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = self->priv->settings;
#line 251 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_window_save_state (_tmp0_, _tmp1_);
#line 1377 "iagno.c"
}


static void iagno_theme_cb (Iagno* self) {
	ThemesDialog* _tmp0_ = NULL;
	ThemesDialog* _tmp6_ = NULL;
#line 258 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->themes_dialog;
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp0_ == NULL) {
#line 1390 "iagno.c"
		GSettings* _tmp1_ = NULL;
		GameView* _tmp2_ = NULL;
		ThemesDialog* _tmp3_ = NULL;
		ThemesDialog* _tmp4_ = NULL;
		GameWindow* _tmp5_ = NULL;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = self->priv->settings;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp2_ = self->priv->view;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp3_ = themes_dialog_new (_tmp1_, _tmp2_);
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_object_ref_sink (_tmp3_);
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_object_unref0 (self->priv->themes_dialog);
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		self->priv->themes_dialog = _tmp3_;
#line 264 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp4_ = self->priv->themes_dialog;
#line 264 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp5_ = self->priv->window;
#line 264 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		gtk_window_set_transient_for ((GtkWindow*) _tmp4_, (GtkWindow*) _tmp5_);
#line 1414 "iagno.c"
	}
#line 266 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp6_ = self->priv->themes_dialog;
#line 266 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_window_present ((GtkWindow*) _tmp6_);
#line 1420 "iagno.c"
}


static void iagno_help_cb (Iagno* self) {
	GError * _inner_error_ = NULL;
#line 269 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 1428 "iagno.c"
	{
		GameWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp0_ = self->priv->window;
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp2_ = gtk_get_current_event_time ();
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		gtk_show_uri (_tmp1_, "help:iagno", _tmp2_, &_inner_error_);
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1443 "iagno.c"
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 271 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		e = _inner_error_;
#line 271 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_inner_error_ = NULL;
#line 277 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp3_ = e;
#line 277 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp4_ = _tmp3_->message;
#line 277 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_warning ("iagno.vala:277: Failed to show help: %s", _tmp4_);
#line 271 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_error_free0 (e);
#line 1465 "iagno.c"
	}
	__finally5:
#line 271 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 271 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 271 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_clear_error (&_inner_error_);
#line 271 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		return;
#line 1476 "iagno.c"
	}
}


static void iagno_about_cb (Iagno* self) {
	gchar** authors = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar** documenters = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint documenters_length1 = 0;
	gint _documenters_size_ = 0;
	GameWindow* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
#line 281 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = g_strdup ("Ian Peters");
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = g_strdup ("Robert Ancell");
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = g_new0 (gchar*, 3 + 1);
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_[0] = _tmp0_;
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_[1] = _tmp1_;
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_[2] = NULL;
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	authors = _tmp2_;
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	authors_length1 = 3;
#line 283 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_authors_size_ = authors_length1;
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = g_strdup ("Tiffany Antopolski");
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = g_new0 (gchar*, 2 + 1);
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_[0] = _tmp3_;
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_[1] = NULL;
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	documenters = _tmp4_;
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	documenters_length1 = 2;
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_documenters_size_ = documenters_length1;
#line 286 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = self->priv->window;
#line 286 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp6_ = _ ("Iagno");
#line 286 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp7_ = _ ("A disk flipping game derived from Reversi");
#line 286 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp8_ = _ ("translator-credits");
#line 286 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_show_about_dialog ((GtkWindow*) _tmp5_, "name", _tmp6_, "version", VERSION, "copyright", "Copyright © 1998–2008 Ian Peters\n" "Copyright © 2013–2015 Michael Catanzaro\n" "Copyright © 2014–2015 Arnaud Bonatti", "license-type", GTK_LICENSE_GPL_3_0, "comments", _tmp7_, "authors", authors, "documenters", documenters, "translator-credits", _tmp8_, "logo-icon-name", "iagno", "website", "https://wiki.gnome.org/Apps/Iagno", NULL, NULL);
#line 281 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
#line 281 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
#line 1545 "iagno.c"
}


static void iagno_back_cb (Iagno* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Game* _tmp2_ = NULL;
	Player _tmp3_ = 0;
	Player _tmp4_ = 0;
	Player _tmp5_ = 0;
#line 308 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = self->priv->game;
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = game_get_current_color (_tmp2_);
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = _tmp3_;
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = self->priv->player_one;
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp4_ != _tmp5_) {
#line 1568 "iagno.c"
		ComputerPlayer* _tmp6_ = NULL;
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp6_ = self->priv->computer;
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = _tmp6_ != NULL;
#line 1574 "iagno.c"
	} else {
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = FALSE;
#line 1578 "iagno.c"
	}
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp1_) {
#line 1582 "iagno.c"
		Game* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp7_ = self->priv->game;
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp8_ = game_get_is_complete (_tmp7_);
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp9_ = _tmp8_;
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp0_ = !_tmp9_;
#line 1594 "iagno.c"
	} else {
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp0_ = FALSE;
#line 1598 "iagno.c"
	}
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp0_) {
#line 1602 "iagno.c"
		ComputerPlayer* _tmp10_ = NULL;
#line 311 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp10_ = self->priv->computer;
#line 311 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		computer_player_move_async (_tmp10_, IAGNO_SLOW_MOVE_DELAY, NULL, NULL);
#line 1608 "iagno.c"
	} else {
		Game* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
#line 312 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp11_ = self->priv->game;
#line 312 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp12_ = game_get_is_complete (_tmp11_);
#line 312 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp13_ = _tmp12_;
#line 312 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (_tmp13_) {
#line 313 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			iagno_game_complete (self, FALSE);
#line 1623 "iagno.c"
		}
	}
}


static void iagno_wait_cb (Iagno* self) {
	ComputerPlayer* _tmp0_ = NULL;
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 318 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->computer;
#line 318 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp0_ != NULL) {
#line 1637 "iagno.c"
		ComputerPlayer* _tmp1_ = NULL;
#line 319 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = self->priv->computer;
#line 319 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		computer_player_cancel_move (_tmp1_);
#line 1643 "iagno.c"
	}
}


static void _iagno_turn_ended_cb_game_turn_ended (Game* _sender, gpointer self) {
#line 331 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_turn_ended_cb ((Iagno*) self);
#line 1651 "iagno.c"
}


static void iagno_start_game (Iagno* self) {
	Game* _tmp0_ = NULL;
	ComputerPlayer* _tmp2_ = NULL;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_ = 0;
	Game* _tmp6_ = NULL;
	Game* _tmp7_ = NULL;
	GameView* _tmp8_ = NULL;
	Game* _tmp9_ = NULL;
	GSettings* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	GSettings* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gboolean _tmp18_ = FALSE;
	Player _tmp19_ = 0;
#line 322 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 324 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->game;
#line 324 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp0_ != NULL) {
#line 1676 "iagno.c"
		Game* _tmp1_ = NULL;
#line 325 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = self->priv->game;
#line 325 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
#line 1682 "iagno.c"
	}
#line 327 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = self->priv->computer;
#line 327 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp2_ != NULL) {
#line 1688 "iagno.c"
		ComputerPlayer* _tmp3_ = NULL;
#line 328 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp3_ = self->priv->computer;
#line 328 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		computer_player_cancel_move (_tmp3_);
#line 1694 "iagno.c"
	}
#line 330 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = iagno_alternative_start;
#line 330 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = iagno_size;
#line 330 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp6_ = game_new (_tmp4_, _tmp5_);
#line 330 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->game);
#line 330 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->game = _tmp6_;
#line 331 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp7_ = self->priv->game;
#line 331 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_signal_connect_object (_tmp7_, "turn-ended", (GCallback) _iagno_turn_ended_cb_game_turn_ended, self, 0);
#line 332 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp8_ = self->priv->view;
#line 332 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp9_ = self->priv->game;
#line 332 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_view_set_game (_tmp8_, _tmp9_);
#line 334 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp10_ = self->priv->settings;
#line 334 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp11_ = g_settings_get_int (_tmp10_, "num-players");
#line 334 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp11_ == 2) {
#line 335 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_object_unref0 (self->priv->computer);
#line 335 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		self->priv->computer = NULL;
#line 1726 "iagno.c"
	} else {
		Game* _tmp12_ = NULL;
		GSettings* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		ComputerPlayer* _tmp15_ = NULL;
#line 337 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp12_ = self->priv->game;
#line 337 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp13_ = self->priv->settings;
#line 337 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp14_ = g_settings_get_int (_tmp13_, "computer-level");
#line 337 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp15_ = computer_player_new (_tmp12_, _tmp14_);
#line 337 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_g_object_unref0 (self->priv->computer);
#line 337 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		self->priv->computer = _tmp15_;
#line 1744 "iagno.c"
	}
#line 339 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp16_ = self->priv->settings;
#line 339 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp17_ = g_settings_get_enum (_tmp16_, "color");
#line 339 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp17_ == 1) {
#line 340 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		self->priv->player_one = PLAYER_LIGHT;
#line 1754 "iagno.c"
	} else {
#line 342 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		self->priv->player_one = PLAYER_DARK;
#line 1758 "iagno.c"
	}
#line 344 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_update_ui (self);
#line 346 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp19_ = self->priv->player_one;
#line 346 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp19_ != PLAYER_DARK) {
#line 1766 "iagno.c"
		ComputerPlayer* _tmp20_ = NULL;
#line 346 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp20_ = self->priv->computer;
#line 346 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp18_ = _tmp20_ != NULL;
#line 1772 "iagno.c"
	} else {
#line 346 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp18_ = FALSE;
#line 1776 "iagno.c"
	}
#line 346 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp18_) {
#line 1780 "iagno.c"
		ComputerPlayer* _tmp21_ = NULL;
#line 347 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp21_ = self->priv->computer;
#line 347 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		computer_player_move_async (_tmp21_, IAGNO_MODERATE_MOVE_DELAY, NULL, NULL);
#line 1786 "iagno.c"
	}
}


static void iagno_update_ui (Iagno* self) {
	GameWindow* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	Player _tmp2_ = 0;
	GtkLabel* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	Game* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	GtkLabel* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	Game* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
#line 350 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 352 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->window;
#line 352 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_window_set_subtitle (_tmp0_, NULL);
#line 354 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = self->priv->player_one;
#line 354 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp2_ == PLAYER_DARK) {
#line 354 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = TRUE;
#line 1821 "iagno.c"
	} else {
		ComputerPlayer* _tmp3_ = NULL;
#line 354 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp3_ = self->priv->computer;
#line 354 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = _tmp3_ == NULL;
#line 1828 "iagno.c"
	}
#line 354 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp1_) {
#line 1832 "iagno.c"
		GameWindow* _tmp4_ = NULL;
		GSimpleAction* _tmp5_ = NULL;
		Game* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
#line 355 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp4_ = self->priv->window;
#line 355 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp5_ = _tmp4_->undo_action;
#line 355 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp6_ = self->priv->game;
#line 355 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp7_ = game_get_number_of_moves (_tmp6_);
#line 355 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp8_ = _tmp7_;
#line 355 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_simple_action_set_enabled (_tmp5_, _tmp8_ >= 1);
#line 1850 "iagno.c"
	} else {
		GameWindow* _tmp9_ = NULL;
		GSimpleAction* _tmp10_ = NULL;
		Game* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp9_ = self->priv->window;
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp10_ = _tmp9_->undo_action;
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp11_ = self->priv->game;
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp12_ = game_get_number_of_moves (_tmp11_);
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp13_ = _tmp12_;
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_simple_action_set_enabled (_tmp10_, _tmp13_ >= 2);
#line 1869 "iagno.c"
	}
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp14_ = self->priv->dark_score_label;
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp15_ = _ ("%.2d");
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp16_ = self->priv->game;
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp17_ = game_get_n_dark_tiles (_tmp16_);
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp18_ = _tmp17_;
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp19_ = g_strdup_printf (_tmp15_, _tmp18_);
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp20_ = _tmp19_;
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_label_set_text (_tmp14_, _tmp20_);
#line 360 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_free0 (_tmp20_);
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp21_ = self->priv->light_score_label;
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp22_ = _ ("%.2d");
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp23_ = self->priv->game;
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp24_ = game_get_n_light_tiles (_tmp23_);
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp25_ = _tmp24_;
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp26_ = g_strdup_printf (_tmp22_, _tmp25_);
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp27_ = _tmp26_;
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	gtk_label_set_text (_tmp21_, _tmp27_);
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_free0 (_tmp27_);
#line 1907 "iagno.c"
}


static void iagno_undo_cb (Iagno* self) {
	ComputerPlayer* _tmp0_ = NULL;
	GameView* _tmp17_ = NULL;
#line 364 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->computer;
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp0_ == NULL) {
#line 1920 "iagno.c"
		Game* _tmp1_ = NULL;
		Game* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 368 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = self->priv->game;
#line 368 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		game_undo (_tmp1_, 1);
#line 369 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp2_ = self->priv->game;
#line 369 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp3_ = game_get_current_player_can_move (_tmp2_);
#line 369 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp4_ = _tmp3_;
#line 369 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (!_tmp4_) {
#line 1937 "iagno.c"
			Game* _tmp5_ = NULL;
#line 370 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp5_ = self->priv->game;
#line 370 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			game_undo (_tmp5_, 1);
#line 1943 "iagno.c"
		}
	} else {
		ComputerPlayer* _tmp6_ = NULL;
		Game* _tmp7_ = NULL;
		Player _tmp8_ = 0;
		Player _tmp9_ = 0;
		Player _tmp10_ = 0;
#line 374 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp6_ = self->priv->computer;
#line 374 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		computer_player_cancel_move (_tmp6_);
#line 377 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp7_ = self->priv->game;
#line 377 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp8_ = game_get_current_color (_tmp7_);
#line 377 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp9_ = _tmp8_;
#line 377 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp10_ = self->priv->player_one;
#line 377 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (_tmp9_ != _tmp10_) {
#line 1965 "iagno.c"
			Game* _tmp11_ = NULL;
#line 378 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp11_ = self->priv->game;
#line 378 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			game_undo (_tmp11_, 1);
#line 1971 "iagno.c"
		} else {
			Game* _tmp12_ = NULL;
#line 380 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp12_ = self->priv->game;
#line 380 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			game_undo (_tmp12_, 2);
#line 1978 "iagno.c"
		}
#line 383 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		while (TRUE) {
#line 1982 "iagno.c"
			Game* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			gboolean _tmp15_ = FALSE;
			Game* _tmp16_ = NULL;
#line 383 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp13_ = self->priv->game;
#line 383 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp14_ = game_get_current_player_can_move (_tmp13_);
#line 383 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp15_ = _tmp14_;
#line 383 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			if (!(!_tmp15_)) {
#line 383 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
				break;
#line 1997 "iagno.c"
			}
#line 384 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp16_ = self->priv->game;
#line 384 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			game_undo (_tmp16_, 2);
#line 2003 "iagno.c"
		}
	}
#line 387 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_update_ui (self);
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_play_sound (self, IAGNO_SOUND_FLIP);
#line 389 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp17_ = self->priv->view;
#line 389 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_view_update_scoreboard (_tmp17_);
#line 2014 "iagno.c"
}


static void iagno_turn_ended_cb (Iagno* self) {
	Game* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 392 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 394 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_update_ui (self);
#line 395 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->game;
#line 395 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = game_get_current_player_can_move (_tmp0_);
#line 395 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = _tmp1_;
#line 395 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp2_) {
#line 396 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		iagno_prepare_move (self);
#line 2036 "iagno.c"
	} else {
		Game* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
#line 397 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp3_ = self->priv->game;
#line 397 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp4_ = game_get_is_complete (_tmp3_);
#line 397 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp5_ = _tmp4_;
#line 397 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (_tmp5_) {
#line 398 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			iagno_game_complete (self, TRUE);
#line 2051 "iagno.c"
		} else {
#line 400 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			iagno_pass (self);
#line 2055 "iagno.c"
		}
	}
}


static void iagno_prepare_move (Iagno* self) {
	GameView* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	Game* _tmp2_ = NULL;
	Player _tmp3_ = 0;
	Player _tmp4_ = 0;
	Player _tmp5_ = 0;
#line 403 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 406 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_play_sound (self, IAGNO_SOUND_FLIP);
#line 407 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->view;
#line 407 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_view_update_scoreboard (_tmp0_);
#line 414 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = self->priv->game;
#line 414 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = game_get_current_color (_tmp2_);
#line 414 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = _tmp3_;
#line 414 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = self->priv->player_one;
#line 414 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp4_ != _tmp5_) {
#line 2086 "iagno.c"
		ComputerPlayer* _tmp6_ = NULL;
#line 414 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp6_ = self->priv->computer;
#line 414 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = _tmp6_ != NULL;
#line 2092 "iagno.c"
	} else {
#line 414 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = FALSE;
#line 2096 "iagno.c"
	}
#line 414 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp1_) {
#line 2100 "iagno.c"
		gboolean _tmp7_ = FALSE;
#line 416 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp7_ = iagno_fast_mode;
#line 416 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (_tmp7_) {
#line 2106 "iagno.c"
			ComputerPlayer* _tmp8_ = NULL;
#line 417 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp8_ = self->priv->computer;
#line 417 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			computer_player_move_async (_tmp8_, IAGNO_QUICK_MOVE_DELAY, NULL, NULL);
#line 2112 "iagno.c"
		} else {
			ComputerPlayer* _tmp9_ = NULL;
#line 419 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp9_ = self->priv->computer;
#line 419 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			computer_player_move_async (_tmp9_, IAGNO_SLOW_MOVE_DELAY, NULL, NULL);
#line 2119 "iagno.c"
		}
	}
}


static void iagno_pass (Iagno* self) {
	GameView* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	Player _tmp3_ = 0;
	Player _tmp4_ = 0;
#line 423 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 426 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_play_sound (self, IAGNO_SOUND_FLIP);
#line 427 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->view;
#line 427 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_view_update_scoreboard (_tmp0_);
#line 429 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = self->priv->game;
#line 429 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_pass (_tmp1_);
#line 430 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = self->priv->game;
#line 430 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = game_get_current_color (_tmp2_);
#line 430 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = _tmp3_;
#line 430 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp4_ == PLAYER_DARK) {
#line 2151 "iagno.c"
		GameWindow* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 433 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp5_ = self->priv->window;
#line 433 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp6_ = _ ("Light must pass, Dark’s move");
#line 433 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		game_window_set_subtitle (_tmp5_, _tmp6_);
#line 2160 "iagno.c"
	} else {
		GameWindow* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 438 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp7_ = self->priv->window;
#line 438 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp8_ = _ ("Dark must pass, Light’s move");
#line 438 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		game_window_set_subtitle (_tmp7_, _tmp8_);
#line 2170 "iagno.c"
	}
}


static void iagno_game_complete (Iagno* self, gboolean play_gameover_sound) {
	GameWindow* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	Game* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gboolean _tmp19_ = FALSE;
#line 442 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->window;
#line 444 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	game_window_finish_game (_tmp0_);
#line 446 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = self->priv->game;
#line 446 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = game_get_n_light_tiles (_tmp1_);
#line 446 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = _tmp2_;
#line 446 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = self->priv->game;
#line 446 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = game_get_n_dark_tiles (_tmp4_);
#line 446 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp6_ = _tmp5_;
#line 446 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp3_ > _tmp6_) {
#line 2204 "iagno.c"
		GameWindow* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 449 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp7_ = self->priv->window;
#line 449 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp8_ = _ ("Light wins!");
#line 449 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		game_window_set_subtitle (_tmp7_, _tmp8_);
#line 2213 "iagno.c"
	} else {
		Game* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		Game* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
#line 451 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp9_ = self->priv->game;
#line 451 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp10_ = game_get_n_dark_tiles (_tmp9_);
#line 451 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp11_ = _tmp10_;
#line 451 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp12_ = self->priv->game;
#line 451 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp13_ = game_get_n_light_tiles (_tmp12_);
#line 451 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp14_ = _tmp13_;
#line 451 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		if (_tmp11_ > _tmp14_) {
#line 2235 "iagno.c"
			GameWindow* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
#line 454 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp15_ = self->priv->window;
#line 454 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp16_ = _ ("Dark wins!");
#line 454 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			game_window_set_subtitle (_tmp15_, _tmp16_);
#line 2244 "iagno.c"
		} else {
			GameWindow* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
#line 459 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp17_ = self->priv->window;
#line 459 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp18_ = _ ("The game is draw.");
#line 459 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			game_window_set_subtitle (_tmp17_, _tmp18_);
#line 2254 "iagno.c"
		}
	}
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp19_ = play_gameover_sound;
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp19_) {
#line 463 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		iagno_play_sound (self, IAGNO_SOUND_GAMEOVER);
#line 2263 "iagno.c"
	}
}


static void iagno_player_move_cb (Iagno* self, gint x, gint y) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Game* _tmp2_ = NULL;
	Player _tmp3_ = 0;
	Player _tmp4_ = 0;
	Player _tmp5_ = 0;
	Game* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
#line 466 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = self->priv->game;
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp3_ = game_get_current_color (_tmp2_);
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp4_ = _tmp3_;
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp5_ = self->priv->player_one;
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp4_ != _tmp5_) {
#line 2291 "iagno.c"
		ComputerPlayer* _tmp6_ = NULL;
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp6_ = self->priv->computer;
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = _tmp6_ != NULL;
#line 2297 "iagno.c"
	} else {
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp1_ = FALSE;
#line 2301 "iagno.c"
	}
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp1_) {
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp0_ = TRUE;
#line 2307 "iagno.c"
	} else {
		Game* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp7_ = self->priv->game;
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp8_ = game_get_current_player_can_move (_tmp7_);
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp9_ = _tmp8_;
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp0_ = !_tmp9_;
#line 2320 "iagno.c"
	}
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp0_) {
#line 470 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		return;
#line 2326 "iagno.c"
	}
#line 472 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp10_ = self->priv->game;
#line 472 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp11_ = x;
#line 472 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp12_ = y;
#line 472 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp13_ = game_place_tile (_tmp10_, _tmp11_, _tmp12_, TRUE);
#line 472 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp13_ == 0) {
#line 2338 "iagno.c"
		GameWindow* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
#line 475 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp14_ = self->priv->window;
#line 475 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp15_ = _ ("You can’t move there!");
#line 475 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		game_window_set_subtitle (_tmp14_, _tmp15_);
#line 2347 "iagno.c"
	}
}


static void iagno_play_sound (Iagno* self, IagnoSound sound) {
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* name = NULL;
	IagnoSound _tmp2_ = 0;
	gchar* path = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gint r = 0;
	GameView* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
#line 489 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_return_if_fail (self != NULL);
#line 491 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp0_ = self->priv->settings;
#line 491 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp1_ = g_settings_get_boolean (_tmp0_, "sound");
#line 491 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (!_tmp1_) {
#line 492 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		return;
#line 2376 "iagno.c"
	}
#line 495 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp2_ = sound;
#line 495 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	switch (_tmp2_) {
#line 495 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		case IAGNO_SOUND_FLIP:
#line 2384 "iagno.c"
		{
			GameView* _tmp3_ = NULL;
			const gchar* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
#line 498 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp3_ = self->priv->view;
#line 498 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp4_ = game_view_get_sound_flip (_tmp3_);
#line 498 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp5_ = _tmp4_;
#line 498 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp6_ = g_strdup (_tmp5_);
#line 498 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_g_free0 (name);
#line 498 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			name = _tmp6_;
#line 499 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			break;
#line 2404 "iagno.c"
		}
#line 495 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		case IAGNO_SOUND_GAMEOVER:
#line 2408 "iagno.c"
		{
			GameView* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
#line 501 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp7_ = self->priv->view;
#line 501 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp8_ = game_view_get_sound_gameover (_tmp7_);
#line 501 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp9_ = _tmp8_;
#line 501 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_tmp10_ = g_strdup (_tmp9_);
#line 501 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_g_free0 (name);
#line 501 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			name = _tmp10_;
#line 502 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			break;
#line 2428 "iagno.c"
		}
		default:
		{
#line 504 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			_g_free0 (name);
#line 504 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
			return;
#line 2436 "iagno.c"
		}
	}
#line 506 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp11_ = name;
#line 506 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp12_ = g_build_filename (SOUND_DIRECTORY, _tmp11_, NULL);
#line 506 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	path = _tmp12_;
#line 507 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp13_ = self->priv->view;
#line 507 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp14_ = name;
#line 507 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp15_ = path;
#line 507 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp16_ = ca_gtk_play_for_widget ((GtkWidget*) _tmp13_, (guint32) 0, CA_PROP_MEDIA_NAME, _tmp14_, CA_PROP_MEDIA_FILENAME, _tmp15_, NULL);
#line 507 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	r = _tmp16_;
#line 510 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_tmp17_ = r;
#line 510 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	if (_tmp17_ != 0) {
#line 2459 "iagno.c"
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
#line 511 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp18_ = name;
#line 511 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		_tmp19_ = path;
#line 511 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
		g_warning ("iagno.vala:511: Error playing file: %s\nfilepath should be:%s\n", _tmp18_, _tmp19_);
#line 2468 "iagno.c"
	}
#line 489 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_free0 (path);
#line 489 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_free0 (name);
#line 2474 "iagno.c"
}


static void iagno_class_init (IagnoClass * klass) {
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	iagno_parent_class = g_type_class_peek_parent (klass);
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	g_type_class_add_private (klass, sizeof (IagnoPrivate));
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	((GApplicationClass *) klass)->handle_local_options = iagno_real_handle_local_options;
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	((GApplicationClass *) klass)->startup = iagno_real_startup;
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	((GApplicationClass *) klass)->activate = iagno_real_activate;
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	((GApplicationClass *) klass)->shutdown = iagno_real_shutdown;
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	G_OBJECT_CLASS (klass)->finalize = iagno_finalize;
#line 2493 "iagno.c"
}


static void iagno_instance_init (Iagno * self) {
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv = IAGNO_GET_PRIVATE (self);
#line 49 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->computer = NULL;
#line 55 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self->priv->game = NULL;
#line 2504 "iagno.c"
}


static void iagno_finalize (GObject* obj) {
	Iagno * self;
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_IAGNO, Iagno);
#line 26 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->settings);
#line 42 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->window);
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->view);
#line 44 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->dark_score_label);
#line 45 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->light_score_label);
#line 46 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->themes_dialog);
#line 49 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->computer);
#line 55 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	_g_object_unref0 (self->priv->game);
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/iagno.vala"
	G_OBJECT_CLASS (iagno_parent_class)->finalize (obj);
#line 2530 "iagno.c"
}


GType iagno_get_type (void) {
	static volatile gsize iagno_type_id__volatile = 0;
	if (g_once_init_enter (&iagno_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IagnoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) iagno_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Iagno), 0, (GInstanceInitFunc) iagno_instance_init, NULL };
		GType iagno_type_id;
		iagno_type_id = g_type_register_static (gtk_application_get_type (), "Iagno", &g_define_type_info, 0);
		g_once_init_leave (&iagno_type_id__volatile, iagno_type_id);
	}
	return iagno_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



