/* -*- tab-width: 4; c-basic-offset: 4 -*- */

/* Path resolution apparatus */

using System;
using System.Collections.Generic;
using FS;

public abstract class FSPathResolver {
    Directory root;
    Directory cwd;

    public FSPathResolver (Directory root, string cwd)
    {
        this.root = root;
        Chdir (new Context(), cwd);
    }

    public void Chdir (Context ctx, string wd)
    {
        if (wd != null) {
            File fi = LookupName (ctx, this.root, wd);
            if (fi is Directory)
                this.cwd = (Directory) fi;
            else {
                Console.WriteLine ("Error in chdir to '" + wd + "'");
                this.cwd = this.root;
            }
        } else
            this.cwd = this.root;
    }

    public class Context {
        public int LinkCount;
        public Context ()
        {
            this.LinkCount = 20;
        }
    }

    public virtual void VisitLink (Context ctx, SymLink link) {}
    public virtual void VisitDirectory (Context ctx, Directory dir) {}
    public virtual void FoundFile (Context ctx, File fi) {}

    File FollowLink (Context ctx, SymLink link, Directory inDir)
    {
        if (ctx.LinkCount-- <= 0)
            return null;
        
        VisitLink (ctx, link);

        return LookupName (ctx, inDir, link.LinkTarget);
    }

    File LookupName (Context ctx, Directory inDir, string path)
    {
        string cur = path;
        if (path == null || path.Length < 1)
            return this.root;
        if (path[0] == '/') {
            inDir = this.root;
            cur = path.Substring(1);
        }

        File fi = null;
        while (cur != null) {
            int idx = cur.IndexOf ('/');
            string elem;

//            Console.Write ("LookupName '" + cur + "' in dir '" +
//                           inDir.Name + "' ");
            if (idx > 0) {
                elem = cur.Substring (0, idx);
                cur = cur.Substring (idx + 1);
            } else {
                elem = cur;
                cur = null;
            }

            if (inDir == null)
                Console.WriteLine ("Serious error grokking " + path + " '" + elem + "'");

            VisitDirectory (ctx, inDir);

            fi = inDir.Lookup (elem);

//            Console.WriteLine ("elem '" + elem + "' " +
//                               (fi != null ? "hit " + fi.Name : "no match"));
            if (fi is SymLink)
                fi = FollowLink (ctx, (SymLink) fi, inDir);
            if (cur != null) {
                if (fi is Directory)
                    inDir = (Directory) fi;
                else {
                    if (fi != null)
                        Console.WriteLine ("'" + fi.Name + "' is not a directory");
//                    else
//                        Console.WriteLine ("Missing '" + path + "'");
                    fi = null;
                    break;
                }
            } else {
//                Console.WriteLine ("Found '" + path + "'");
                FoundFile (ctx, fi);
                break;
            }
        }
        return fi;
    }

    public File LookupName (Context ctx, string path)
    {
        if (ctx == null)
            ctx = new Context();
        return LookupName (ctx, this.cwd, path);
    }
}
