/* -*- tab-width: 4; c-basic-offset: 4 -*- */

using System;
using System.Collections.Generic;
using Gtk;

// Instantiate it's child on show ...
class DelayedWidget : Gtk.Alignment {
    public delegate Gtk.Widget Create();
    Create     fnCreate;
    Gtk.Widget container;
    public DelayedWidget (Gtk.Widget container, Create fnCreate)
        : base ((float)0.5, (float)0.5, (float)1, (float)1)
    {
        this.container = container;
        this.fnCreate = fnCreate;
    }
    public void AddContent()
    {
        if (Child == null) {
            Gtk.Widget newChild = fnCreate();
            newChild.Show();
            Add (newChild);
            this.container.QueueDraw();
        }
    }
}

public class MainWindow : Gtk.Window
{
	SimulationData sd;
	Gtk.Notebook tabs;

	static List<MainWindow> windows;
    protected override bool OnDeleteEvent (Gdk.Event ev)
	{
		windows.Remove(this);
		if (windows.Count == 0)
			Application.Quit();
		return true;
	}

	static public List<MainWindow> AllWindows {
		get { return windows; }
	}

	void AppendPage(DelayedWidget.Create createFn, string label)
	{
        Gtk.Widget widget = new DelayedWidget (this.tabs, createFn);
		widget.Show();
		Gtk.Label lWidget = new Gtk.Label (label);
		lWidget.Show();
		tabs.AppendPage (widget, lWidget);
	}

	void CreateBody()
	{
		this.tabs = new Gtk.Notebook();
		this.tabs.Show();
        this.tabs.SwitchPage += delegate {
            (this.tabs.GetNthPage (this.tabs.Page) as DelayedWidget).AddContent();
        };
		AppendPage (delegate { return new StackView (this.sd); }, "stack view");
		AppendPage (delegate { return new FileView (this.sd); }, "file view");
		AppendPage (delegate { return new AddrView (this.sd); }, "address view");
		AppendPage (delegate { return new FSView (this.sd.FileSystem); }, "fs view");
		AppendPage (delegate { return new ScribbleView (this.sd); }, "scribble");

        if (System.Environment.GetEnvironmentVariable("IOGRIND_HACKER") == null) {
            Gtk.MessageDialog warning =
                new Gtk.MessageDialog (this, Gtk.DialogFlags.Modal,
                                       Gtk.MessageType.Warning,
                                       Gtk.ButtonsType.Ok, true,
                                       "<b>Warning</b> - the results of the simulation you are " +
                                       "about to (foolishly) believe, are generated almost " +
                                       "entirely from thermal noise.\n" +
                                       "<b>Any</b> similarity between the " +
                                       "fictional version of the program portrayed here and the " +
                                       "actual program is purely coincidental. This is a work of fiction, " +
                                       "this is not an attempt to defame the character, or authors of said " +
                                       "software. Terms and conditions may apply, do not operate heavy " +
                                       "machinery while keeping up payments on your home...\n" +
                                       "<b>Please not use this to optimise your software (yet).</b>");
            warning.Run();
            warning.Destroy();
        }

		Add (this.tabs);
	}

	public MainWindow (SimulationData sd, string profile) :
		base ("I/O profile " + profile)
	{
		this.sd = sd;
		SetDefaultSize (1300, 950);
		CreateBody();

		if (windows == null)
			windows = new List<MainWindow>();

		windows.Add (this);
	}
}
