using System;
using System.Collections.Generic;
using FS;

class ViewWindow : Gtk.Window
{
	static List<ViewWindow> windows;
	static public List<ViewWindow> AllWindows {
		get { return windows; }
	}
    protected override bool OnDeleteEvent (Gdk.Event ev)
	{
		windows.Remove(this);
		if (windows.Count == 0)
			Gtk.Application.Quit();
		return true;
	}

    public ViewWindow (FSData fsData) :
        base ("file system " + fsData.ImageName)
    {
        SetDefaultSize (1300, 950);
        Add (new FSView (fsData));
		if (windows == null)
			windows = new List<ViewWindow>();
		windows.Add (this);
    }
}

class MainClass
{
    static void PrintHelp ()
    {
        Console.WriteLine ("fsview [--help] <complete-fs.xml>");
    }
    
    static FSData LoadData (string fileName)
    {
        StatusFileStream strm = new GuiStatusFileStream (fileName);
        return new FSData (strm, fileName);
    }
    
    public static void Main (string[] args)
    {
        List<string> fsNames = new List<string>();

        Gtk.Application.Init ();

        foreach (string s in args) {
            if (s == "--help" || s == "-h") {
                PrintHelp();
                return;
            } else
                fsNames.Add (s);
        }
        if (fsNames.Count == 0) {
            PrintHelp();
            return;
        }
        
        foreach (string fname in fsNames) {
            FSData fsData;
            fsData = LoadData (fname);
            new ViewWindow (fsData);
        }

        foreach (Gtk.Window window in ViewWindow.AllWindows)
            window.ShowAll ();
        Gtk.Application.Run ();
    }
}
