/* -*- tab-width: 4; c-basic-offset: 4 -*- */

using System;
using System.Collections.Generic;
using StackFrame = SimulationData.StackFrame;

class StackColorModel : IHistColorModel {
	Dictionary<string,Cairo.Color> colors;
	GUtils.Palette  palette;
	Cairo.Color    unknown;
    int curColor;

	public StackColorModel()
	{
		this.colors = new Dictionary<string,Cairo.Color>();
		this.palette = new GUtils.Palette (27);
        this.curColor = 0;
		this.unknown = this.palette.GetColor (this.curColor++);
	}
	public Cairo.Color GetColor (IHistNode node)
	{
		string fname = ((StackNode)node).Name;

		int idx;
		idx = fname.IndexOf(':');
		if (idx <= 0 || idx > fname.Length)
			return this.unknown;

        fname = fname.Substring (0, idx - 1);

		if (!this.colors.ContainsKey (fname))
            this.colors.Add (fname, this.palette.GetColor (curColor++));

		return this.colors[fname];
	}
}

class StackNode : Node {
    StackFrame frame;
    public StackNode (Node parent, StackFrame frame, double weight)
		: base( parent, "", weight)
	{
		this.frame = frame;
	}
	public override string Label {
		get {
			return Utils.PathBaseName (frame.Detail.Name) + " " +
				Utils.PrettyTime (frame.TotalTime) + " " +
				Utils.PrettyBytes (frame.TotalBytes) + " " +
				Utils.PrettyBW (frame.TotalBytes, frame.TotalTime);
		}
	}
	public override string ShortLabel {
        get {
            int idx;
            string name = frame.Detail.Name;
            idx = name.IndexOf(':');
            if (idx <= 0 || idx + 1 >= name.Length)
                return name;
            return name.Substring (idx + 1);
        }
    }
    public string Name {
		get { return frame.Detail.Name; }
	}
    public override string TreeElemName {
        get {
            return frame.Detail.DisplayName;
        }
    }
}

class StackView : BaseView {

	Node CreateNode (Node parent, StackFrame frame)
	{
		return new StackNode (parent, frame,
                              this.type == ViewType.Time ? frame.TotalTime 
                              : frame.TotalBytes);
	}

#if STACK_DEBUG
    static int depth;
#endif
    Node ConvertNodes (StackFrame frame, Node parent)
    {
#if STACK_DEBUG
        depth++;
        for (int i = 0; i < depth; i++)
            Console.Write (" ");
        Console.WriteLine (frame.Detail.Name + " " + Utils.PrettyTime (frame.TotalTime));
#endif

        Node node = CreateNode (parent, frame);
        if (frame.Children != null)
            foreach (StackFrame fr in frame.Children)
                ConvertNodes (fr, node);
#if STACK_DEBUG
        depth--;
#endif
        return node;
    }

	public override Node UpdateView ()
	{
		Node root;
		if (!hierarchical) { // Flat tree of times ...
            Console.WriteLine ("FIXME: need to walk the tree & present by fn name (?)");
            root = new Node (null, "", 0);
		} else if (sd.StackRoot != null)
            root = ConvertNodes (sd.StackRoot, null);
        else
            root = null;
        return root;
	}

	public StackView (SimulationData sd)
        : base (sd, new StackColorModel(), new HistogramSettings (true))
	{
	}
}
