using System;
using System.Collections.Generic;
using FS;

// FIXME: visit directories ? ...
// until failure ?

public class SubsetResolver : FSPathResolver {
    FSData complete;
    FSData partial;

    Dictionary<File,File> completeToPartial;

    void InsertMap (File fiComplete, File fiPartial)
    {
        if (this.completeToPartial.ContainsKey (fiComplete)) {
            if (this.completeToPartial[fiComplete] != fiPartial)
                Console.WriteLine ("Mismatching insert " + fiComplete
                                   + " vs. " + fiPartial);
            return;
        }
        this.completeToPartial[fiComplete] = fiPartial;
    }

    // Find matching entries and populate a dict of them.
    void InitMap (File fiComplete, File fiPartial)
    {
        InsertMap (fiComplete, fiPartial);
        if (!(fiComplete is Directory))
            return;
        Directory compDir = (Directory) fiComplete;
        Directory partDir = (Directory) fiPartial;
        if (compDir.Children != null) {
            foreach (File src in compDir.Children) {
                File match = partDir.Lookup (src.Name);
                if (match != null)
                    InitMap (src, match);
            }
        }
    }

    public SubsetResolver (FSData complete, FSData partial)
        : base (complete.Root, null)
    {
        this.complete = complete;
        this.partial = partial;
        this.completeToPartial = new Dictionary<File,File>();
        InitMap (this.complete.Root, this.partial.Root);
    }

    public File CopyAcross (File src)
    {
        File partParent;
        if (src.Parent == null)
            partParent = this.partial.Root;
        else
            partParent = this.completeToPartial[ src.Parent ];

        File cpy = src.Copy ((Directory) partParent);
        return cpy;
    }

    public override void VisitLink (Context ctx, SymLink link)
    {
        FoundFile (ctx, link);
    }
    public override void VisitDirectory (Context ctx, Directory dir)
    {
        FoundFile (ctx, dir);
    }
    public override void FoundFile (Context ctx, File fi)
    {
        if (fi == null)
            return; // missing file.

        if (this.completeToPartial.ContainsKey (fi))
            return;

        File cpy = CopyAcross (fi);
        InitMap (fi, cpy);
    }

    public void Transfer (string path)
    {
        LookupName (null, path);
    }
}

class MainClass
{
    static void PrintHelp ()
    {
        Console.WriteLine ("ext2subset [--help] <complete-fs.xml> <partial-fs.xml> [<trace.prf>...]");
    }
    
    static FSData LoadData (string fileName)
    {
        StatusFileStream strm = new StatusFileStream (fileName);
        return new FSData (strm, fileName);
    }
    
    public static void Main (string[] args)
    {
        bool testCopy = false;
        string completeName = null;
        string partialName = null;
        List<string> traces = new List<string>();

        foreach (string s in args) {
            if (s == "--help" || s == "-h") {
                PrintHelp();
                return;
            } else if (s == "--copy")
                testCopy = true;
            else if (completeName == null)
                completeName = s;
            else if (partialName == null)
                partialName = s;
            else
                traces.Add(s);
        }

        FSData complete, partial;
        if (testCopy) {
            complete = LoadData (completeName);
            complete.Write (partialName);
            return;
        }

        if (traces.Count == 0) {
            System.Console.WriteLine("No trace(s) to merge");
            PrintHelp();
            return;
        }
        
        complete = LoadData (completeName);
        bool newSubset = false;
        try {
            partial = LoadData (partialName);
        } catch (System.IO.FileNotFoundException) {
            partial = new FSData (complete);
            Console.WriteLine ("New partial!");
            newSubset = true;
        }

        SubsetResolver res = new SubsetResolver (complete, partial);
        
        foreach (string t in traces) {
            Console.Write ("  adding " + t + " ");
            Trace.Data traceData = new Trace.Data (t);
            Console.Write (".");
            int progress = 0;
            foreach (Trace.Process p in traceData.Processes) {
                foreach (object ev in p.IOEvents) {
                    if (!(ev is Trace.OpenEvent) ||
                        (ev as Trace.OpenEvent).Failed)
                        continue;
                    res.Transfer ((ev as Trace.OpenEvent).FileName);
                    if ((++progress % 32) == 0)
                        Console.Write (".");
                }
            }
            Console.WriteLine ("done");
        }
        if (!newSubset) {
            System.IO.FileInfo info = new System.IO.FileInfo (partialName);
            info.MoveTo (partialName + ".bak");
        }
        partial.Write (partialName);
    }
}

