/* -*- mode: C; c-file-style: "gnu" -*- */
/*
 * Copyright (C) 2003  Richard Hult <richard@imendio.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __QUERY_H__
#define __QUERY_H__

#include <glib.h>
#include "expr.h"

typedef struct _Query Query;
typedef GList *(*QueryUpdateFunc) (Query *, gboolean, GList *from, gpointer);

typedef enum {
  LIMIT_TYPE_NONE = 0,

  LIMIT_TYPE_SONGS,
  LIMIT_TYPE_MINUTES,
  LIMIT_TYPE_HOURS,
  LIMIT_TYPE_MB,
  LIMIT_TYPE_GB
} LimitType;

typedef enum {
  MATCH_TYPE_NONE = 0,

  MATCH_TYPE_ALL,
  MATCH_TYPE_ANY
} MatchType;

typedef enum  {
  SELECTION_TYPE_NONE = 0,

  SELECTION_TYPE_DATE_ADDED,
  SELECTION_TYPE_MOST_RECENTLY_PLAYED,
  SELECTION_TYPE_LEAST_RECENTLY_PLAYED,
  SELECTION_TYPE_LAST_PLAYED,
  SELECTION_TYPE_RATING,
  SELECTION_TYPE_PLAY_COUNT,
  SELECTION_TYPE_QUALITY,
  SELECTION_TYPE_RANDOM,
  SELECTION_TYPE_YEAR
} SelectionType;

Query *       query_new                  (Expr            *expr);
Query *       query_ref                  (Query           *query);
void          query_unref                (Query           *query);
void          query_set_name             (Query           *query,
					  const char      *name);
const char *  query_get_name             (Query           *query);
void          query_set_simple           (Query           *query,
					  const char      *title,
					  const char      *artist,
					  const char      *album);
void          query_set_expr             (Query           *query,
					  Expr            *expr);
Expr *        query_get_expr             (Query           *query);
void          query_run                  (Query           *query,
					  GList           *songs,
					  QueryUpdateFunc  update_func,
					  gpointer         user_data);
gboolean      query_cancel               (Query           *query);


/*
 * Limits
 */
void          query_set_selection_type   (Query           *query,
					  SelectionType    selection);
SelectionType query_get_selection_type   (Query           *query);
void          query_set_limit_type       (Query           *query,
					  LimitType        type);
LimitType     query_get_limit_type       (Query           *query);
void          query_set_limit            (Query           *query,
					  int              limit);
MatchType     query_get_match_type       (Query           *query);
void          query_set_match_type       (Query           *query,
					  MatchType        type);
int           query_get_limit            (Query           *query);
const char *  limit_type_to_string       (LimitType        type);
LimitType     limit_type_from_string     (const char      *str);
const char *  match_type_to_string       (MatchType        type);
MatchType     match_type_from_string     (const char      *str);
const char *  selection_type_to_string   (SelectionType    type);
SelectionType selection_type_from_string (const char      *str);

void query_create_default_queries (void);

#endif /* __QUERY_H__ */
