/* preferences_dialog.c generated by valac 0.12.1, the Vala compiler
 * generated from preferences_dialog.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <config.h>
#include <stdio.h>
#include <gtksourceview/gtksourcestyleschememanager.h>
#include <gtksourceview/gtksourceview.h>
#include <gee.h>


#define TYPE_PREFERENCES_DIALOG (preferences_dialog_get_type ())
#define PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialog))
#define PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))
#define IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES_DIALOG))
#define IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES_DIALOG))
#define PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))

typedef struct _PreferencesDialog PreferencesDialog;
typedef struct _PreferencesDialogClass PreferencesDialogClass;
typedef struct _PreferencesDialogPrivate PreferencesDialogPrivate;

#define PREFERENCES_DIALOG_TYPE_STYLE_SCHEMES (preferences_dialog_style_schemes_get_type ())

#define PREFERENCES_DIALOG_TYPE_BUILD_TOOL_COLUMN (preferences_dialog_build_tool_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

#define TYPE_APP_SETTINGS (app_settings_get_type ())
#define APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_SETTINGS, AppSettings))
#define APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_SETTINGS, AppSettingsClass))
#define IS_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_SETTINGS))
#define IS_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_SETTINGS))
#define APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_SETTINGS, AppSettingsClass))

typedef struct _AppSettings AppSettings;
typedef struct _AppSettingsClass AppSettingsClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block2Data Block2Data;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_BUILD_TOOL (build_tool_get_type ())

#define TYPE_BUILD_JOB (build_job_get_type ())
typedef struct _BuildJob BuildJob;
typedef struct _BuildTool BuildTool;
#define _build_tool_free0(var) ((var == NULL) ? NULL : (var = (build_tool_free (var), NULL)))

struct _PreferencesDialog {
	GtkDialog parent_instance;
	PreferencesDialogPrivate * priv;
};

struct _PreferencesDialogClass {
	GtkDialogClass parent_class;
};

struct _PreferencesDialogPrivate {
	GtkListStore* build_tools_store;
	GtkTreeView* build_tools_view;
};

typedef enum  {
	PREFERENCES_DIALOG_STYLE_SCHEMES_ID,
	PREFERENCES_DIALOG_STYLE_SCHEMES_DESC,
	PREFERENCES_DIALOG_STYLE_SCHEMES_N_COLUMNS
} PreferencesDialogStyleSchemes;

typedef enum  {
	PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_PIXBUF,
	PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_LABEL,
	PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_DESCRIPTION,
	PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_N_COLUMNS
} PreferencesDialogBuildToolColumn;

struct _Block1Data {
	int _ref_count_;
	PreferencesDialog * self;
	GtkLabel* autosave_label;
	GtkButton* default_font_checkbutton;
	GtkTreeView* schemes_treeview;
	GtkLabel* interactive_comp_label;
	GSettings* settings;
};

struct _Block2Data {
	int _ref_count_;
	PreferencesDialog * self;
	GtkWidget* widget;
	gboolean must_be_enabled;
};

struct _BuildJob {
	gboolean must_succeed;
	gchar* post_processor;
	gchar* command;
	gchar** command_args;
	gint command_args_length1;
};

struct _BuildTool {
	gchar* description;
	gchar* extensions;
	gchar* label;
	gchar* icon;
	gboolean compilation;
	GList* jobs;
};


static gpointer preferences_dialog_parent_class = NULL;
static PreferencesDialog* preferences_dialog_preferences_dialog;
static PreferencesDialog* preferences_dialog_preferences_dialog = NULL;

GType preferences_dialog_get_type (void) G_GNUC_CONST;
#define PREFERENCES_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PREFERENCES_DIALOG, PreferencesDialogPrivate))
enum  {
	PREFERENCES_DIALOG_DUMMY_PROPERTY
};
static GType preferences_dialog_style_schemes_get_type (void) G_GNUC_UNUSED;
static GType preferences_dialog_build_tool_column_get_type (void) G_GNUC_UNUSED;
static PreferencesDialog* preferences_dialog_new (void);
static PreferencesDialog* preferences_dialog_construct (GType object_type);
static void _lambda0_ (gint response_id, PreferencesDialog* self);
static GtkDialog* preferences_dialog_get_reset_all_confirm_dialog (PreferencesDialog* self, const gchar* msg);
static void __lambda0__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void preferences_dialog_init_schemes_treeview (PreferencesDialog* self, GtkTreeView* treeview, const gchar* current_id);
static void _lambda1_ (GtkTreeView* treeview, Block1Data* _data1_);
static void __lambda1__gtk_tree_view_cursor_changed (GtkTreeView* _sender, gpointer self);
static void _lambda2_ (GSettings* setting, const gchar* key, Block1Data* _data1_);
static void __lambda2__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void preferences_dialog_set_sensitivity (PreferencesDialog* self, GSettings* settings, const gchar* key, GtkWidget* widget, gboolean must_be_enabled);
static void _lambda4_ (GSettings* setting, const gchar* key, Block1Data* _data1_);
static void __lambda4__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void _lambda5_ (GSettings* setting, const gchar* key, Block1Data* _data1_);
static void __lambda5__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void preferences_dialog_set_system_font_label (PreferencesDialog* self, GtkButton* button);
GType app_settings_get_type (void) G_GNUC_CONST;
AppSettings* app_settings_get_default (void);
static void _lambda96_ (Block1Data* _data1_);
static void __lambda96__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void preferences_dialog_init_build_tools_treeview (PreferencesDialog* self);
static void preferences_dialog_init_build_tools_buttons (PreferencesDialog* self, GtkButton* bt_new, GtkButton* bt_delete, GtkButton* bt_up, GtkButton* bt_down, GtkButton* bt_properties, GtkButton* bt_reset);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static void _lambda3_ (GSettings* setting, const gchar* k, Block2Data* _data2_);
static void __lambda3__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
const gchar* app_settings_get_system_font (AppSettings* self);
GType main_window_get_type (void) G_GNUC_CONST;
void preferences_dialog_show_me (MainWindow* parent);
static void _lambda67_ (void);
static void __lambda67__gtk_object_destroy (GtkObject* _sender, gpointer self);
static void preferences_dialog_update_build_tools_store (PreferencesDialog* self);
GType build_tool_get_type (void) G_GNUC_CONST;
GType build_job_get_type (void) G_GNUC_CONST;
BuildJob* build_job_dup (const BuildJob* self);
void build_job_free (BuildJob* self);
void build_job_copy (const BuildJob* self, BuildJob* dest);
void build_job_destroy (BuildJob* self);
BuildTool* build_tool_dup (const BuildTool* self);
void build_tool_free (BuildTool* self);
void build_tool_copy (const BuildTool* self, BuildTool* dest);
void build_tool_destroy (BuildTool* self);
GeeLinkedList* app_settings_get_build_tools (AppSettings* self);
static void _lambda97_ (PreferencesDialog* self);
static void preferences_dialog_run_build_tool_dialog (PreferencesDialog* self, gint num);
static void __lambda97__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda105_ (PreferencesDialog* self);
gint utils_get_selected_row (GtkTreeView* view, GtkTreeIter* iter_to_set);
static void __lambda105__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda106_ (PreferencesDialog* self);
void app_settings_delete_build_tool (AppSettings* self, gint num);
static void __lambda106__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda107_ (PreferencesDialog* self);
gboolean utils_tree_model_iter_prev (GtkTreeModel* model, GtkTreeIter* iter);
void app_settings_move_build_tool_up (AppSettings* self, gint num);
static void __lambda107__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda108_ (PreferencesDialog* self);
void app_settings_move_build_tool_down (AppSettings* self, gint num);
static void __lambda108__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda109_ (PreferencesDialog* self);
void app_settings_reset_all_build_tools (AppSettings* self);
static void __lambda109__gtk_button_clicked (GtkButton* _sender, gpointer self);
gboolean build_tool_dialog_show_me (GtkWindow* parent, gint num);
static void preferences_dialog_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static GType preferences_dialog_style_schemes_get_type (void) {
	static volatile gsize preferences_dialog_style_schemes_type_id__volatile = 0;
	if (g_once_init_enter (&preferences_dialog_style_schemes_type_id__volatile)) {
		static const GEnumValue values[] = {{PREFERENCES_DIALOG_STYLE_SCHEMES_ID, "PREFERENCES_DIALOG_STYLE_SCHEMES_ID", "id"}, {PREFERENCES_DIALOG_STYLE_SCHEMES_DESC, "PREFERENCES_DIALOG_STYLE_SCHEMES_DESC", "desc"}, {PREFERENCES_DIALOG_STYLE_SCHEMES_N_COLUMNS, "PREFERENCES_DIALOG_STYLE_SCHEMES_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType preferences_dialog_style_schemes_type_id;
		preferences_dialog_style_schemes_type_id = g_enum_register_static ("PreferencesDialogStyleSchemes", values);
		g_once_init_leave (&preferences_dialog_style_schemes_type_id__volatile, preferences_dialog_style_schemes_type_id);
	}
	return preferences_dialog_style_schemes_type_id__volatile;
}


static GType preferences_dialog_build_tool_column_get_type (void) {
	static volatile gsize preferences_dialog_build_tool_column_type_id__volatile = 0;
	if (g_once_init_enter (&preferences_dialog_build_tool_column_type_id__volatile)) {
		static const GEnumValue values[] = {{PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_PIXBUF, "PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_PIXBUF", "pixbuf"}, {PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_LABEL, "PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_LABEL", "label"}, {PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_DESCRIPTION, "PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_DESCRIPTION", "description"}, {PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_N_COLUMNS, "PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType preferences_dialog_build_tool_column_type_id;
		preferences_dialog_build_tool_column_type_id = g_enum_register_static ("PreferencesDialogBuildToolColumn", values);
		g_once_init_leave (&preferences_dialog_build_tool_column_type_id__volatile, preferences_dialog_build_tool_column_type_id);
	}
	return preferences_dialog_build_tool_column_type_id__volatile;
}


static void _lambda0_ (gint response_id, PreferencesDialog* self) {
	const gchar* _tmp0_ = NULL;
	GtkDialog* _tmp1_ = NULL;
	GtkDialog* dialog;
	gint _tmp2_;
	gint resp;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_ = NULL;
	gchar** settings_str;
	gint settings_str_length1;
	gint _settings_str_size_;
	if (response_id == GTK_RESPONSE_CLOSE) {
		gtk_widget_hide ((GtkWidget*) self);
		return;
	}
	_tmp0_ = _ ("Do you really want to reset all preferences?");
	_tmp1_ = preferences_dialog_get_reset_all_confirm_dialog (self, _tmp0_);
	dialog = _tmp1_;
	_tmp2_ = gtk_dialog_run (dialog);
	resp = _tmp2_;
	gtk_object_destroy ((GtkObject*) dialog);
	if (resp != GTK_RESPONSE_YES) {
		_g_object_unref0 (dialog);
		return;
	}
	_tmp3_ = g_strdup ("org.gnome.latexila.preferences.editor");
	_tmp4_ = g_strdup ("org.gnome.latexila.preferences.latex");
	_tmp5_ = g_strdup ("org.gnome.latexila.preferences.file-browser");
	_tmp6_ = g_new0 (gchar*, 3 + 1);
	_tmp6_[0] = _tmp3_;
	_tmp6_[1] = _tmp4_;
	_tmp6_[2] = _tmp5_;
	settings_str = _tmp6_;
	settings_str_length1 = 3;
	_settings_str_size_ = 3;
	{
		gchar** setting_str_collection;
		int setting_str_collection_length1;
		int setting_str_it;
		setting_str_collection = settings_str;
		setting_str_collection_length1 = settings_str_length1;
		for (setting_str_it = 0; setting_str_it < settings_str_length1; setting_str_it = setting_str_it + 1) {
			gchar* _tmp7_;
			gchar* setting_str;
			_tmp7_ = g_strdup (setting_str_collection[setting_str_it]);
			setting_str = _tmp7_;
			{
				GSettings* _tmp8_ = NULL;
				GSettings* settings;
				gchar** _tmp9_;
				gchar** _tmp10_ = NULL;
				gchar** keys;
				gint keys_length1;
				gint _keys_size_;
				_tmp8_ = g_settings_new (setting_str);
				settings = _tmp8_;
				_tmp10_ = _tmp9_ = g_settings_list_keys (settings);
				keys = _tmp10_;
				keys_length1 = _vala_array_length (_tmp9_);
				_keys_size_ = _vala_array_length (_tmp9_);
				{
					gchar** key_collection;
					int key_collection_length1;
					int key_it;
					key_collection = keys;
					key_collection_length1 = keys_length1;
					for (key_it = 0; key_it < keys_length1; key_it = key_it + 1) {
						gchar* _tmp11_;
						gchar* key;
						_tmp11_ = g_strdup (key_collection[key_it]);
						key = _tmp11_;
						{
							g_settings_reset (settings, key);
							_g_free0 (key);
						}
					}
				}
				keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (settings);
				_g_free0 (setting_str);
			}
		}
	}
	settings_str = (_vala_array_free (settings_str, settings_str_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (dialog);
}


static void __lambda0__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	_lambda0_ (response_id, self);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->settings);
		_g_object_unref0 (_data1_->interactive_comp_label);
		_g_object_unref0 (_data1_->schemes_treeview);
		_g_object_unref0 (_data1_->default_font_checkbutton);
		_g_object_unref0 (_data1_->autosave_label);
		g_slice_free (Block1Data, _data1_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda1_ (GtkTreeView* treeview, Block1Data* _data1_) {
	PreferencesDialog * self;
	GtkTreePath* tree_path = NULL;
	GtkTreeIter iter = {0};
	GtkTreePath* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* model;
	GtkTreeIter _tmp3_ = {0};
	gchar* id = NULL;
	self = _data1_->self;
	g_return_if_fail (treeview != NULL);
	gtk_tree_view_get_cursor (_data1_->schemes_treeview, &_tmp0_, NULL);
	_gtk_tree_path_free0 (tree_path);
	tree_path = _tmp0_;
	_tmp1_ = gtk_tree_view_get_model (treeview);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	model = _tmp2_;
	gtk_tree_model_get_iter (model, &_tmp3_, tree_path);
	iter = _tmp3_;
	gtk_tree_model_get (model, &iter, PREFERENCES_DIALOG_STYLE_SCHEMES_ID, &id, -1, -1);
	g_settings_set_string (_data1_->settings, "scheme", id);
	_g_free0 (id);
	_g_object_unref0 (model);
	_gtk_tree_path_free0 (tree_path);
}


static void __lambda1__gtk_tree_view_cursor_changed (GtkTreeView* _sender, gpointer self) {
	_lambda1_ (_sender, self);
}


static void _lambda2_ (GSettings* setting, const gchar* key, Block1Data* _data1_) {
	PreferencesDialog * self;
	gchar* _tmp0_ = NULL;
	gchar* val;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* model;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_;
	gboolean valid;
	self = _data1_->self;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = g_settings_get_string (setting, key);
	val = _tmp0_;
	_tmp1_ = gtk_tree_view_get_model (_data1_->schemes_treeview);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	model = _tmp2_;
	_tmp4_ = gtk_tree_model_get_iter_first (model, &_tmp3_);
	iter = _tmp3_;
	valid = _tmp4_;
	while (TRUE) {
		gchar* scheme = NULL;
		gboolean _tmp7_;
		if (!valid) {
			break;
		}
		gtk_tree_model_get (model, &iter, PREFERENCES_DIALOG_STYLE_SCHEMES_ID, &scheme, -1, -1);
		if (g_strcmp0 (scheme, val) == 0) {
			GtkTreeSelection* _tmp5_ = NULL;
			GtkTreeSelection* _tmp6_;
			GtkTreeSelection* select;
			_tmp5_ = gtk_tree_view_get_selection (_data1_->schemes_treeview);
			_tmp6_ = _g_object_ref0 (_tmp5_);
			select = _tmp6_;
			gtk_tree_selection_select_iter (select, &iter);
			_g_object_unref0 (select);
			_g_free0 (scheme);
			_g_object_unref0 (model);
			_g_free0 (val);
			return;
		}
		_tmp7_ = gtk_tree_model_iter_next (model, &iter);
		valid = _tmp7_;
		_g_free0 (scheme);
	}
	_g_object_unref0 (model);
	_g_free0 (val);
}


static void __lambda2__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	_lambda2_ (_sender, key, self);
}


static void _lambda4_ (GSettings* setting, const gchar* key, Block1Data* _data1_) {
	PreferencesDialog * self;
	guint val = 0U;
	const gchar* _tmp0_ = NULL;
	self = _data1_->self;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	g_settings_get (setting, key, "u", &val);
	if (val > 1) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = _ ("minutes");
		_tmp0_ = _tmp1_;
	} else {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = _ ("minute");
		_tmp0_ = _tmp2_;
	}
	gtk_label_set_label (_data1_->autosave_label, _tmp0_);
}


static void __lambda4__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	_lambda4_ (_sender, key, self);
}


static void _lambda5_ (GSettings* setting, const gchar* key, Block1Data* _data1_) {
	PreferencesDialog * self;
	gint _tmp0_;
	gint val;
	const gchar* _tmp1_ = NULL;
	self = _data1_->self;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = g_settings_get_int (setting, key);
	val = _tmp0_;
	if (val > 1) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = _ ("characters");
		_tmp1_ = _tmp2_;
	} else {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = _ ("character");
		_tmp1_ = _tmp3_;
	}
	gtk_label_set_label (_data1_->interactive_comp_label, _tmp1_);
}


static void __lambda5__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	_lambda5_ (_sender, key, self);
}


static void _lambda96_ (Block1Data* _data1_) {
	PreferencesDialog * self;
	self = _data1_->self;
	preferences_dialog_set_system_font_label (self, _data1_->default_font_checkbutton);
}


static void __lambda96__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda96_ (self);
}


static PreferencesDialog* preferences_dialog_construct (GType object_type) {
	PreferencesDialog * self = NULL;
	const gchar* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	GtkButton* reset_button;
	GtkImage* _tmp2_ = NULL;
	GtkImage* image;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* path;
	Block1Data* _data1_;
	GtkBuilder* _tmp5_ = NULL;
	GtkBuilder* builder;
	GObject* _tmp6_ = NULL;
	GtkNotebook* _tmp7_;
	GtkNotebook* notebook;
	GObject* _tmp8_ = NULL;
	GObject* _tmp9_;
	GObject* display_line_nb_checkbutton;
	GObject* _tmp10_ = NULL;
	GObject* _tmp11_;
	GObject* tab_width_spinbutton;
	GObject* _tmp12_ = NULL;
	GtkWidget* _tmp13_;
	GtkWidget* insert_spaces_checkbutton;
	GObject* _tmp14_ = NULL;
	GtkWidget* _tmp15_;
	GtkWidget* forget_no_tabs;
	GObject* _tmp16_ = NULL;
	GObject* _tmp17_;
	GObject* hl_current_line_checkbutton;
	GObject* _tmp18_ = NULL;
	GObject* _tmp19_;
	GObject* bracket_matching_checkbutton;
	GObject* _tmp20_ = NULL;
	GObject* _tmp21_;
	GObject* backup_checkbutton;
	GObject* _tmp22_ = NULL;
	GObject* _tmp23_;
	GObject* autosave_checkbutton;
	GObject* _tmp24_ = NULL;
	GtkWidget* _tmp25_;
	GtkWidget* autosave_spinbutton;
	GObject* _tmp26_ = NULL;
	GtkLabel* _tmp27_;
	GObject* _tmp28_ = NULL;
	GObject* _tmp29_;
	GObject* reopen_checkbutton;
	GObject* _tmp30_ = NULL;
	GtkButton* _tmp31_;
	GObject* _tmp32_ = NULL;
	GObject* _tmp33_;
	GObject* font_button;
	GObject* _tmp34_ = NULL;
	GtkWidget* _tmp35_;
	GtkWidget* font_hbox;
	GObject* _tmp36_ = NULL;
	GtkTreeView* _tmp37_;
	GObject* _tmp38_ = NULL;
	GObject* _tmp39_;
	GObject* interactive_comp_checkbutton;
	GObject* _tmp40_ = NULL;
	GtkWidget* _tmp41_;
	GtkWidget* interactive_comp_spinbutton;
	GObject* _tmp42_ = NULL;
	GtkLabel* _tmp43_;
	GObject* _tmp44_ = NULL;
	GObject* _tmp45_;
	GObject* document_view_program;
	GObject* _tmp46_ = NULL;
	GObject* _tmp47_;
	GObject* web_browser;
	GObject* _tmp48_ = NULL;
	GObject* _tmp49_;
	GObject* nb_most_used_symbols;
	GObject* _tmp50_ = NULL;
	GtkTreeView* _tmp51_;
	GObject* _tmp52_ = NULL;
	GtkButton* _tmp53_;
	GtkButton* bt_new;
	GObject* _tmp54_ = NULL;
	GtkButton* _tmp55_;
	GtkButton* bt_delete;
	GObject* _tmp56_ = NULL;
	GtkButton* _tmp57_;
	GtkButton* bt_up;
	GObject* _tmp58_ = NULL;
	GtkButton* _tmp59_;
	GtkButton* bt_down;
	GObject* _tmp60_ = NULL;
	GtkButton* _tmp61_;
	GtkButton* bt_properties;
	GObject* _tmp62_ = NULL;
	GtkButton* _tmp63_;
	GtkButton* bt_reset;
	GObject* _tmp64_ = NULL;
	GObject* _tmp65_;
	GObject* confirm_clean_up_checkbutton;
	GObject* _tmp66_ = NULL;
	GtkWidget* _tmp67_;
	GtkWidget* auto_clean_up_checkbutton;
	GObject* _tmp68_ = NULL;
	GObject* _tmp69_;
	GObject* clean_up_entry;
	GObject* _tmp70_ = NULL;
	GObject* _tmp71_;
	GObject* file_browser_show_all;
	GObject* _tmp72_ = NULL;
	GtkWidget* _tmp73_;
	GtkWidget* vbox_file_browser_show_all;
	GObject* _tmp74_ = NULL;
	GtkWidget* _tmp75_;
	GtkWidget* file_browser_except;
	GObject* _tmp76_ = NULL;
	GtkWidget* _tmp77_;
	GtkWidget* file_browser_show_hidden;
	GObject* _tmp78_ = NULL;
	GtkWidget* _tmp79_;
	GtkWidget* file_browser_entry;
	GSettings* _tmp80_ = NULL;
	GSettings* _tmp81_ = NULL;
	GSettings* latex_settings;
	GSettings* _tmp82_ = NULL;
	GSettings* fb_settings;
	gchar* _tmp83_ = NULL;
	gchar* current_scheme_id;
	guint interval = 0U;
	const gchar* _tmp84_ = NULL;
	gint _tmp87_;
	gint min_nb_chars;
	const gchar* _tmp88_ = NULL;
	AppSettings* _tmp91_ = NULL;
	AppSettings* app_settings;
	GtkWidget* _tmp92_ = NULL;
	GtkBox* _tmp93_;
	GtkBox* content_area;
	GError * _inner_error_ = NULL;
	self = (PreferencesDialog*) g_object_new (object_type, NULL);
	_tmp0_ = _ ("Reset All");
	_tmp1_ = (GtkButton*) gtk_button_new_with_label (_tmp0_);
	reset_button = g_object_ref_sink (_tmp1_);
	_tmp2_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_CLEAR, GTK_ICON_SIZE_MENU);
	image = g_object_ref_sink (_tmp2_);
	gtk_button_set_image (reset_button, (GtkWidget*) image);
	gtk_widget_show_all ((GtkWidget*) reset_button);
	gtk_dialog_add_action_widget ((GtkDialog*) self, (GtkWidget*) reset_button, (gint) GTK_RESPONSE_APPLY);
	gtk_dialog_add_button ((GtkDialog*) self, GTK_STOCK_CLOSE, (gint) GTK_RESPONSE_CLOSE);
	_tmp3_ = _ ("Preferences");
	gtk_window_set_title ((GtkWindow*) self, _tmp3_);
	gtk_dialog_set_has_separator ((GtkDialog*) self, FALSE);
	gtk_window_set_destroy_with_parent ((GtkWindow*) self, TRUE);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 5);
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) __lambda0__gtk_dialog_response, self, 0);
	_tmp4_ = g_build_filename (DATA_DIR, "ui", "preferences_dialog.ui", NULL);
	path = _tmp4_;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp5_ = gtk_builder_new ();
	builder = _tmp5_;
	gtk_builder_add_from_file (builder, path, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		goto __catch0_g_error;
	}
	_tmp6_ = gtk_builder_get_object (builder, "notebook");
	_tmp7_ = _g_object_ref0 (GTK_NOTEBOOK (_tmp6_));
	notebook = _tmp7_;
	_tmp8_ = gtk_builder_get_object (builder, "display_line_nb_checkbutton");
	_tmp9_ = _g_object_ref0 (_tmp8_);
	display_line_nb_checkbutton = _tmp9_;
	_tmp10_ = gtk_builder_get_object (builder, "tab_width_spinbutton");
	_tmp11_ = _g_object_ref0 (_tmp10_);
	tab_width_spinbutton = _tmp11_;
	_tmp12_ = gtk_builder_get_object (builder, "insert_spaces_checkbutton");
	_tmp13_ = _g_object_ref0 (GTK_WIDGET (_tmp12_));
	insert_spaces_checkbutton = _tmp13_;
	_tmp14_ = gtk_builder_get_object (builder, "forget_no_tabs");
	_tmp15_ = _g_object_ref0 (GTK_WIDGET (_tmp14_));
	forget_no_tabs = _tmp15_;
	_tmp16_ = gtk_builder_get_object (builder, "hl_current_line_checkbutton");
	_tmp17_ = _g_object_ref0 (_tmp16_);
	hl_current_line_checkbutton = _tmp17_;
	_tmp18_ = gtk_builder_get_object (builder, "bracket_matching_checkbutton");
	_tmp19_ = _g_object_ref0 (_tmp18_);
	bracket_matching_checkbutton = _tmp19_;
	_tmp20_ = gtk_builder_get_object (builder, "backup_checkbutton");
	_tmp21_ = _g_object_ref0 (_tmp20_);
	backup_checkbutton = _tmp21_;
	_tmp22_ = gtk_builder_get_object (builder, "autosave_checkbutton");
	_tmp23_ = _g_object_ref0 (_tmp22_);
	autosave_checkbutton = _tmp23_;
	_tmp24_ = gtk_builder_get_object (builder, "autosave_spinbutton");
	_tmp25_ = _g_object_ref0 (GTK_WIDGET (_tmp24_));
	autosave_spinbutton = _tmp25_;
	_tmp26_ = gtk_builder_get_object (builder, "autosave_label");
	_tmp27_ = _g_object_ref0 (GTK_LABEL (_tmp26_));
	_data1_->autosave_label = _tmp27_;
	_tmp28_ = gtk_builder_get_object (builder, "reopen_checkbutton");
	_tmp29_ = _g_object_ref0 (_tmp28_);
	reopen_checkbutton = _tmp29_;
	_tmp30_ = gtk_builder_get_object (builder, "default_font_checkbutton");
	_tmp31_ = _g_object_ref0 (GTK_BUTTON (_tmp30_));
	_data1_->default_font_checkbutton = _tmp31_;
	_tmp32_ = gtk_builder_get_object (builder, "font_button");
	_tmp33_ = _g_object_ref0 (_tmp32_);
	font_button = _tmp33_;
	_tmp34_ = gtk_builder_get_object (builder, "font_hbox");
	_tmp35_ = _g_object_ref0 (GTK_WIDGET (_tmp34_));
	font_hbox = _tmp35_;
	_tmp36_ = gtk_builder_get_object (builder, "schemes_treeview");
	_tmp37_ = _g_object_ref0 (GTK_TREE_VIEW (_tmp36_));
	_data1_->schemes_treeview = _tmp37_;
	_tmp38_ = gtk_builder_get_object (builder, "interactive_comp_checkbutton");
	_tmp39_ = _g_object_ref0 (_tmp38_);
	interactive_comp_checkbutton = _tmp39_;
	_tmp40_ = gtk_builder_get_object (builder, "interactive_comp_spinbutton");
	_tmp41_ = _g_object_ref0 (GTK_WIDGET (_tmp40_));
	interactive_comp_spinbutton = _tmp41_;
	_tmp42_ = gtk_builder_get_object (builder, "interactive_comp_label");
	_tmp43_ = _g_object_ref0 (GTK_LABEL (_tmp42_));
	_data1_->interactive_comp_label = _tmp43_;
	_tmp44_ = gtk_builder_get_object (builder, "document_view_program");
	_tmp45_ = _g_object_ref0 (_tmp44_);
	document_view_program = _tmp45_;
	_tmp46_ = gtk_builder_get_object (builder, "web_browser");
	_tmp47_ = _g_object_ref0 (_tmp46_);
	web_browser = _tmp47_;
	_tmp48_ = gtk_builder_get_object (builder, "nb_most_used_symbols");
	_tmp49_ = _g_object_ref0 (_tmp48_);
	nb_most_used_symbols = _tmp49_;
	_tmp50_ = gtk_builder_get_object (builder, "build_tools_treeview");
	_tmp51_ = _g_object_ref0 (GTK_TREE_VIEW (_tmp50_));
	_g_object_unref0 (self->priv->build_tools_view);
	self->priv->build_tools_view = _tmp51_;
	_tmp52_ = gtk_builder_get_object (builder, "build_tool_new");
	_tmp53_ = _g_object_ref0 (GTK_BUTTON (_tmp52_));
	bt_new = _tmp53_;
	_tmp54_ = gtk_builder_get_object (builder, "build_tool_delete");
	_tmp55_ = _g_object_ref0 (GTK_BUTTON (_tmp54_));
	bt_delete = _tmp55_;
	_tmp56_ = gtk_builder_get_object (builder, "build_tool_up");
	_tmp57_ = _g_object_ref0 (GTK_BUTTON (_tmp56_));
	bt_up = _tmp57_;
	_tmp58_ = gtk_builder_get_object (builder, "build_tool_down");
	_tmp59_ = _g_object_ref0 (GTK_BUTTON (_tmp58_));
	bt_down = _tmp59_;
	_tmp60_ = gtk_builder_get_object (builder, "build_tool_properties");
	_tmp61_ = _g_object_ref0 (GTK_BUTTON (_tmp60_));
	bt_properties = _tmp61_;
	_tmp62_ = gtk_builder_get_object (builder, "build_tool_reset");
	_tmp63_ = _g_object_ref0 (GTK_BUTTON (_tmp62_));
	bt_reset = _tmp63_;
	_tmp64_ = gtk_builder_get_object (builder, "confirm_clean_up_checkbutton");
	_tmp65_ = _g_object_ref0 (_tmp64_);
	confirm_clean_up_checkbutton = _tmp65_;
	_tmp66_ = gtk_builder_get_object (builder, "auto_clean_up_checkbutton");
	_tmp67_ = _g_object_ref0 (GTK_WIDGET (_tmp66_));
	auto_clean_up_checkbutton = _tmp67_;
	_tmp68_ = gtk_builder_get_object (builder, "clean_up_entry");
	_tmp69_ = _g_object_ref0 (_tmp68_);
	clean_up_entry = _tmp69_;
	_tmp70_ = gtk_builder_get_object (builder, "file_browser_show_all");
	_tmp71_ = _g_object_ref0 (_tmp70_);
	file_browser_show_all = _tmp71_;
	_tmp72_ = gtk_builder_get_object (builder, "vbox_file_browser_show_all");
	_tmp73_ = _g_object_ref0 (GTK_WIDGET (_tmp72_));
	vbox_file_browser_show_all = _tmp73_;
	_tmp74_ = gtk_builder_get_object (builder, "file_browser_except");
	_tmp75_ = _g_object_ref0 (GTK_WIDGET (_tmp74_));
	file_browser_except = _tmp75_;
	_tmp76_ = gtk_builder_get_object (builder, "file_browser_show_hidden");
	_tmp77_ = _g_object_ref0 (GTK_WIDGET (_tmp76_));
	file_browser_show_hidden = _tmp77_;
	_tmp78_ = gtk_builder_get_object (builder, "file_browser_entry");
	_tmp79_ = _g_object_ref0 (GTK_WIDGET (_tmp78_));
	file_browser_entry = _tmp79_;
	_tmp80_ = g_settings_new ("org.gnome.latexila.preferences.editor");
	_data1_->settings = _tmp80_;
	g_settings_bind (_data1_->settings, "use-default-font", _data1_->default_font_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (_data1_->settings, "editor-font", font_button, "font-name", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (_data1_->settings, "tabs-size", tab_width_spinbutton, "value", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (_data1_->settings, "insert-spaces", insert_spaces_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (_data1_->settings, "forget-no-tabs", forget_no_tabs, "active", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (_data1_->settings, "display-line-numbers", display_line_nb_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (_data1_->settings, "highlight-current-line", hl_current_line_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (_data1_->settings, "bracket-matching", bracket_matching_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (_data1_->settings, "create-backup-copy", backup_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (_data1_->settings, "auto-save", autosave_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (_data1_->settings, "auto-save-interval", autosave_spinbutton, "value", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (_data1_->settings, "reopen-files", reopen_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (_data1_->settings, "web-browser", web_browser, "text", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (_data1_->settings, "nb-most-used-symbols", nb_most_used_symbols, "value", G_SETTINGS_BIND_DEFAULT);
	_tmp81_ = g_settings_new ("org.gnome.latexila.preferences.latex");
	latex_settings = _tmp81_;
	g_settings_bind (latex_settings, "interactive-completion", interactive_comp_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (latex_settings, "interactive-completion-num", interactive_comp_spinbutton, "value", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (latex_settings, "document-view-program", document_view_program, "text", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (latex_settings, "no-confirm-clean", confirm_clean_up_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (latex_settings, "automatic-clean", auto_clean_up_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (latex_settings, "clean-extensions", clean_up_entry, "text", G_SETTINGS_BIND_DEFAULT);
	_tmp82_ = g_settings_new ("org.gnome.latexila.preferences.file-browser");
	fb_settings = _tmp82_;
	g_settings_bind (fb_settings, "show-all-files", file_browser_show_all, "active", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (fb_settings, "show-all-files-except", file_browser_except, "active", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (fb_settings, "show-hidden-files", file_browser_show_hidden, "active", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (fb_settings, "file-extensions", file_browser_entry, "text", G_SETTINGS_BIND_DEFAULT);
	_tmp83_ = g_settings_get_string (_data1_->settings, "scheme");
	current_scheme_id = _tmp83_;
	preferences_dialog_init_schemes_treeview (self, _data1_->schemes_treeview, current_scheme_id);
	g_signal_connect_data (_data1_->schemes_treeview, "cursor-changed", (GCallback) __lambda1__gtk_tree_view_cursor_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	g_signal_connect_data (_data1_->settings, "changed::scheme", (GCallback) __lambda2__g_settings_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	preferences_dialog_set_sensitivity (self, _data1_->settings, "insert-spaces", forget_no_tabs, TRUE);
	preferences_dialog_set_sensitivity (self, _data1_->settings, "auto-save", autosave_spinbutton, TRUE);
	g_settings_get (_data1_->settings, "auto-save-interval", "u", &interval);
	if (interval > 1) {
		const gchar* _tmp85_ = NULL;
		_tmp85_ = _ ("minutes");
		_tmp84_ = _tmp85_;
	} else {
		const gchar* _tmp86_ = NULL;
		_tmp86_ = _ ("minute");
		_tmp84_ = _tmp86_;
	}
	gtk_label_set_label (_data1_->autosave_label, _tmp84_);
	g_signal_connect_data (_data1_->settings, "changed::auto-save-interval", (GCallback) __lambda4__g_settings_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	preferences_dialog_set_sensitivity (self, latex_settings, "interactive-completion", interactive_comp_spinbutton, TRUE);
	_tmp87_ = g_settings_get_int (latex_settings, "interactive-completion-num");
	min_nb_chars = _tmp87_;
	if (min_nb_chars > 1) {
		const gchar* _tmp89_ = NULL;
		_tmp89_ = _ ("characters");
		_tmp88_ = _tmp89_;
	} else {
		const gchar* _tmp90_ = NULL;
		_tmp90_ = _ ("character");
		_tmp88_ = _tmp90_;
	}
	gtk_label_set_label (_data1_->interactive_comp_label, _tmp88_);
	g_signal_connect_data (latex_settings, "changed::interactive-completion-num", (GCallback) __lambda5__g_settings_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	preferences_dialog_set_sensitivity (self, _data1_->settings, "use-default-font", font_hbox, FALSE);
	preferences_dialog_set_system_font_label (self, _data1_->default_font_checkbutton);
	_tmp91_ = app_settings_get_default ();
	app_settings = _tmp91_;
	g_signal_connect_data ((GObject*) app_settings, "notify::system-font", (GCallback) __lambda96__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	preferences_dialog_set_sensitivity (self, latex_settings, "no-confirm-clean", auto_clean_up_checkbutton, TRUE);
	preferences_dialog_set_sensitivity (self, fb_settings, "show-all-files", vbox_file_browser_show_all, TRUE);
	preferences_dialog_set_sensitivity (self, fb_settings, "show-all-files", file_browser_entry, FALSE);
	preferences_dialog_init_build_tools_treeview (self);
	preferences_dialog_init_build_tools_buttons (self, bt_new, bt_delete, bt_up, bt_down, bt_properties, bt_reset);
	_tmp92_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp93_ = _g_object_ref0 (GTK_BOX (_tmp92_));
	content_area = _tmp93_;
	gtk_box_pack_start (content_area, (GtkWidget*) notebook, TRUE, TRUE, (guint) 0);
	gtk_container_set_border_width ((GtkContainer*) notebook, (guint) 5);
	_g_object_unref0 (content_area);
	_g_object_unref0 (app_settings);
	_g_free0 (current_scheme_id);
	_g_object_unref0 (fb_settings);
	_g_object_unref0 (latex_settings);
	_g_object_unref0 (file_browser_entry);
	_g_object_unref0 (file_browser_show_hidden);
	_g_object_unref0 (file_browser_except);
	_g_object_unref0 (vbox_file_browser_show_all);
	_g_object_unref0 (file_browser_show_all);
	_g_object_unref0 (clean_up_entry);
	_g_object_unref0 (auto_clean_up_checkbutton);
	_g_object_unref0 (confirm_clean_up_checkbutton);
	_g_object_unref0 (bt_reset);
	_g_object_unref0 (bt_properties);
	_g_object_unref0 (bt_down);
	_g_object_unref0 (bt_up);
	_g_object_unref0 (bt_delete);
	_g_object_unref0 (bt_new);
	_g_object_unref0 (nb_most_used_symbols);
	_g_object_unref0 (web_browser);
	_g_object_unref0 (document_view_program);
	_g_object_unref0 (interactive_comp_spinbutton);
	_g_object_unref0 (interactive_comp_checkbutton);
	_g_object_unref0 (font_hbox);
	_g_object_unref0 (font_button);
	_g_object_unref0 (reopen_checkbutton);
	_g_object_unref0 (autosave_spinbutton);
	_g_object_unref0 (autosave_checkbutton);
	_g_object_unref0 (backup_checkbutton);
	_g_object_unref0 (bracket_matching_checkbutton);
	_g_object_unref0 (hl_current_line_checkbutton);
	_g_object_unref0 (forget_no_tabs);
	_g_object_unref0 (insert_spaces_checkbutton);
	_g_object_unref0 (tab_width_spinbutton);
	_g_object_unref0 (display_line_nb_checkbutton);
	_g_object_unref0 (notebook);
	_g_object_unref0 (builder);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		gchar* _tmp94_ = NULL;
		gchar* message;
		GtkLabel* _tmp95_ = NULL;
		GtkLabel* label_error;
		GtkWidget* _tmp96_ = NULL;
		GtkBox* _tmp97_;
		GtkBox* content_area;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp94_ = g_strdup_printf ("Error: %s", e->message);
		message = _tmp94_;
		fprintf (stderr, "%s\n", message);
		_tmp95_ = (GtkLabel*) gtk_label_new (message);
		label_error = g_object_ref_sink (_tmp95_);
		gtk_label_set_line_wrap (label_error, TRUE);
		_tmp96_ = gtk_dialog_get_content_area ((GtkDialog*) self);
		_tmp97_ = _g_object_ref0 (GTK_BOX (_tmp96_));
		content_area = _tmp97_;
		gtk_box_pack_start (content_area, (GtkWidget*) label_error, TRUE, TRUE, (guint) 0);
		gtk_widget_show_all ((GtkWidget*) content_area);
		_g_object_unref0 (content_area);
		_g_object_unref0 (label_error);
		_g_free0 (message);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_free0 (path);
		_g_object_unref0 (image);
		_g_object_unref0 (reset_button);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_free0 (path);
	_g_object_unref0 (image);
	_g_object_unref0 (reset_button);
	return self;
}


static PreferencesDialog* preferences_dialog_new (void) {
	return preferences_dialog_construct (TYPE_PREFERENCES_DIALOG);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_object_unref0 (_data2_->widget);
		g_slice_free (Block2Data, _data2_);
	}
}


static void _lambda3_ (GSettings* setting, const gchar* k, Block2Data* _data2_) {
	PreferencesDialog * self;
	gboolean _tmp0_;
	gboolean v;
	gboolean _tmp1_ = FALSE;
	self = _data2_->self;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (k != NULL);
	_tmp0_ = g_settings_get_boolean (setting, k);
	v = _tmp0_;
	if (_data2_->must_be_enabled) {
		_tmp1_ = v;
	} else {
		_tmp1_ = !v;
	}
	gtk_widget_set_sensitive (_data2_->widget, _tmp1_);
}


static void __lambda3__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	_lambda3_ (_sender, key, self);
}


static void preferences_dialog_set_sensitivity (PreferencesDialog* self, GSettings* settings, const gchar* key, GtkWidget* widget, gboolean must_be_enabled) {
	Block2Data* _data2_;
	gboolean _tmp0_;
	gboolean val;
	gboolean _tmp1_ = FALSE;
	gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (widget != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_data2_->widget = _g_object_ref0 (widget);
	_data2_->must_be_enabled = must_be_enabled;
	_tmp0_ = g_settings_get_boolean (settings, key);
	val = _tmp0_;
	if (_data2_->must_be_enabled) {
		_tmp1_ = val;
	} else {
		_tmp1_ = !val;
	}
	gtk_widget_set_sensitive (_data2_->widget, _tmp1_);
	_tmp2_ = g_strconcat ("changed::", key, NULL);
	g_signal_connect_data (settings, _tmp2_, (GCallback) __lambda3__g_settings_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_g_free0 (_tmp2_);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static void preferences_dialog_set_system_font_label (PreferencesDialog* self, GtkButton* button) {
	AppSettings* _tmp0_ = NULL;
	AppSettings* app_settings;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* label;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = app_settings_get_default ();
	app_settings = _tmp0_;
	_tmp1_ = _ ("Use the system fixed width font (%s)");
	_tmp2_ = app_settings_get_system_font (app_settings);
	_tmp3_ = g_strdup_printf (_tmp1_, _tmp2_);
	label = _tmp3_;
	gtk_button_set_label (button, label);
	_g_free0 (label);
	_g_object_unref0 (app_settings);
}


static void _lambda67_ (void) {
	if (preferences_dialog_preferences_dialog != NULL) {
		_g_object_unref0 (preferences_dialog_preferences_dialog);
		preferences_dialog_preferences_dialog = NULL;
	}
}


static void __lambda67__gtk_object_destroy (GtkObject* _sender, gpointer self) {
	_lambda67_ ();
}


void preferences_dialog_show_me (MainWindow* parent) {
	GtkWindow* _tmp1_ = NULL;
	g_return_if_fail (parent != NULL);
	if (preferences_dialog_preferences_dialog == NULL) {
		PreferencesDialog* _tmp0_ = NULL;
		_tmp0_ = preferences_dialog_new ();
		_g_object_unref0 (preferences_dialog_preferences_dialog);
		preferences_dialog_preferences_dialog = g_object_ref_sink (_tmp0_);
		g_signal_connect ((GtkObject*) preferences_dialog_preferences_dialog, "destroy", (GCallback) __lambda67__gtk_object_destroy, NULL);
	}
	_tmp1_ = gtk_window_get_transient_for ((GtkWindow*) preferences_dialog_preferences_dialog);
	if (GTK_WINDOW (parent) != _tmp1_) {
		gtk_window_set_transient_for ((GtkWindow*) preferences_dialog_preferences_dialog, (GtkWindow*) parent);
	}
	gtk_window_present ((GtkWindow*) preferences_dialog_preferences_dialog);
}


static void preferences_dialog_init_schemes_treeview (PreferencesDialog* self, GtkTreeView* treeview, const gchar* current_id) {
	GtkListStore* _tmp0_ = NULL;
	GtkListStore* list_store;
	GtkCellRendererText* _tmp1_ = NULL;
	GtkCellRendererText* renderer;
	GtkTreeViewColumn* _tmp2_ = NULL;
	GtkTreeViewColumn* column;
	GtkTreeSelection* _tmp3_ = NULL;
	GtkTreeSelection* _tmp4_;
	GtkTreeSelection* select;
	GtkSourceStyleSchemeManager* _tmp5_ = NULL;
	GtkSourceStyleSchemeManager* _tmp6_;
	GtkSourceStyleSchemeManager* manager;
	gchar** _tmp7_;
	gchar** _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (treeview != NULL);
	g_return_if_fail (current_id != NULL);
	_tmp0_ = gtk_list_store_new ((gint) PREFERENCES_DIALOG_STYLE_SCHEMES_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING);
	list_store = _tmp0_;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) list_store, (gint) PREFERENCES_DIALOG_STYLE_SCHEMES_ID, GTK_SORT_ASCENDING);
	gtk_tree_view_set_model (treeview, (GtkTreeModel*) list_store);
	_tmp1_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	renderer = g_object_ref_sink (_tmp1_);
	_tmp2_ = gtk_tree_view_column_new_with_attributes ("Name and description", (GtkCellRenderer*) renderer, "markup", PREFERENCES_DIALOG_STYLE_SCHEMES_DESC, NULL, NULL);
	column = g_object_ref_sink (_tmp2_);
	gtk_tree_view_append_column (treeview, column);
	_tmp3_ = gtk_tree_view_get_selection (treeview);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	select = _tmp4_;
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	_tmp5_ = gtk_source_style_scheme_manager_get_default ();
	_tmp6_ = _g_object_ref0 (_tmp5_);
	manager = _tmp6_;
	_tmp8_ = _tmp7_ = gtk_source_style_scheme_manager_get_scheme_ids (manager);
	{
		gchar** id_collection;
		int id_collection_length1;
		int id_it;
		id_collection = _tmp8_;
		id_collection_length1 = _vala_array_length (_tmp7_);
		for (id_it = 0; id_it < _vala_array_length (_tmp7_); id_it = id_it + 1) {
			gchar* _tmp9_;
			gchar* id;
			_tmp9_ = g_strdup (id_collection[id_it]);
			id = _tmp9_;
			{
				GtkSourceStyleScheme* _tmp10_ = NULL;
				GtkSourceStyleScheme* _tmp11_;
				GtkSourceStyleScheme* scheme;
				const gchar* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
				gchar* desc;
				GtkTreeIter iter = {0};
				GtkTreeIter _tmp15_ = {0};
				const gchar* _tmp16_ = NULL;
				_tmp10_ = gtk_source_style_scheme_manager_get_scheme (manager, id);
				_tmp11_ = _g_object_ref0 (_tmp10_);
				scheme = _tmp11_;
				_tmp12_ = gtk_source_style_scheme_get_name (scheme);
				_tmp13_ = gtk_source_style_scheme_get_description (scheme);
				_tmp14_ = g_strdup_printf ("<b>%s</b> - %s", _tmp12_, _tmp13_);
				desc = _tmp14_;
				gtk_list_store_append (list_store, &_tmp15_);
				iter = _tmp15_;
				_tmp16_ = gtk_source_style_scheme_get_id (scheme);
				gtk_list_store_set (list_store, &iter, PREFERENCES_DIALOG_STYLE_SCHEMES_ID, _tmp16_, PREFERENCES_DIALOG_STYLE_SCHEMES_DESC, desc, -1, -1);
				if (g_strcmp0 (id, current_id) == 0) {
					gtk_tree_selection_select_iter (select, &iter);
				}
				_g_free0 (desc);
				_g_object_unref0 (scheme);
				_g_free0 (id);
			}
		}
	}
	_g_object_unref0 (manager);
	_g_object_unref0 (select);
	_g_object_unref0 (column);
	_g_object_unref0 (renderer);
	_g_object_unref0 (list_store);
}


static void preferences_dialog_init_build_tools_treeview (PreferencesDialog* self) {
	GtkListStore* _tmp0_ = NULL;
	GtkTreeViewColumn* _tmp1_ = NULL;
	GtkTreeViewColumn* column;
	GtkCellRendererPixbuf* _tmp2_ = NULL;
	GtkCellRendererPixbuf* pixbuf_renderer;
	GtkCellRendererText* _tmp3_ = NULL;
	GtkCellRendererText* text_renderer;
	GtkTreeSelection* _tmp4_ = NULL;
	GtkTreeSelection* _tmp5_;
	GtkTreeSelection* select;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_list_store_new ((gint) PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
	_g_object_unref0 (self->priv->build_tools_store);
	self->priv->build_tools_store = _tmp0_;
	gtk_tree_view_set_model (self->priv->build_tools_view, (GtkTreeModel*) self->priv->build_tools_store);
	_tmp1_ = gtk_tree_view_column_new ();
	column = g_object_ref_sink (_tmp1_);
	gtk_tree_view_append_column (self->priv->build_tools_view, column);
	_tmp2_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	pixbuf_renderer = g_object_ref_sink (_tmp2_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) pixbuf_renderer, FALSE);
	gtk_tree_view_column_set_attributes (column, (GtkCellRenderer*) pixbuf_renderer, "stock-id", PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_PIXBUF, NULL, NULL);
	_tmp3_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	text_renderer = g_object_ref_sink (_tmp3_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) text_renderer, TRUE);
	gtk_tree_view_column_set_attributes (column, (GtkCellRenderer*) text_renderer, "text", PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_LABEL, NULL, NULL);
	gtk_tree_view_set_tooltip_column (self->priv->build_tools_view, (gint) PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_DESCRIPTION);
	_tmp4_ = gtk_tree_view_get_selection (self->priv->build_tools_view);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	select = _tmp5_;
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	preferences_dialog_update_build_tools_store (self);
	_g_object_unref0 (select);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
	_g_object_unref0 (column);
}


static void preferences_dialog_update_build_tools_store (PreferencesDialog* self) {
	AppSettings* _tmp0_ = NULL;
	AppSettings* _tmp1_;
	GeeLinkedList* _tmp2_ = NULL;
	GeeLinkedList* _tmp3_;
	GeeLinkedList* tools;
	g_return_if_fail (self != NULL);
	gtk_list_store_clear (self->priv->build_tools_store);
	_tmp0_ = app_settings_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = app_settings_get_build_tools (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	tools = _tmp3_;
	{
		GeeLinkedList* _tmp4_;
		GeeLinkedList* _tool_list;
		gint _tmp5_;
		gint _tool_size;
		gint _tool_index;
		_tmp4_ = _g_object_ref0 (tools);
		_tool_list = _tmp4_;
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tool_list);
		_tool_size = _tmp5_;
		_tool_index = -1;
		while (TRUE) {
			gpointer _tmp6_ = NULL;
			BuildTool* _tmp7_;
			BuildTool _tmp8_;
			BuildTool _tmp9_ = {0};
			BuildTool _tmp10_;
			BuildTool tool;
			GtkTreeIter iter = {0};
			GtkTreeIter _tmp11_ = {0};
			_tool_index = _tool_index + 1;
			if (!(_tool_index < _tool_size)) {
				break;
			}
			_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tool_list, _tool_index);
			_tmp7_ = (BuildTool*) _tmp6_;
			build_tool_copy (_tmp7_, &_tmp9_);
			_tmp8_ = _tmp9_;
			_tmp10_ = _tmp8_;
			_build_tool_free0 (_tmp7_);
			tool = _tmp10_;
			gtk_list_store_append (self->priv->build_tools_store, &_tmp11_);
			iter = _tmp11_;
			gtk_list_store_set (self->priv->build_tools_store, &iter, PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_PIXBUF, tool.icon, PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_LABEL, tool.label, PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_DESCRIPTION, tool.description, -1, -1);
			build_tool_destroy (&tool);
		}
		_g_object_unref0 (_tool_list);
	}
}


static void _lambda97_ (PreferencesDialog* self) {
	preferences_dialog_run_build_tool_dialog (self, -1);
}


static void __lambda97__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda97_ (self);
}


static void _lambda105_ (PreferencesDialog* self) {
	gint _tmp0_;
	gint num;
	_tmp0_ = utils_get_selected_row (self->priv->build_tools_view, NULL);
	num = _tmp0_;
	preferences_dialog_run_build_tool_dialog (self, num);
}


static void __lambda105__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda105_ (self);
}


static void _lambda106_ (PreferencesDialog* self) {
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gint _tmp1_;
	gint i;
	gchar* label = NULL;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* model;
	const gchar* _tmp3_ = NULL;
	GtkMessageDialog* _tmp4_ = NULL;
	GtkDialog* dialog;
	gint _tmp5_;
	_tmp1_ = utils_get_selected_row (self->priv->build_tools_view, &_tmp0_);
	iter = _tmp0_;
	i = _tmp1_;
	if (i == (-1)) {
		return;
	}
	_tmp2_ = _g_object_ref0 (GTK_TREE_MODEL (self->priv->build_tools_store));
	model = _tmp2_;
	gtk_tree_model_get (model, &iter, PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_LABEL, &label, -1, -1);
	_tmp3_ = _ ("Do you really want to delete the build tool \"%s\"?");
	_tmp4_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _tmp3_, label);
	dialog = (GtkDialog*) g_object_ref_sink (_tmp4_);
	gtk_dialog_add_buttons (dialog, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_DELETE, GTK_RESPONSE_YES, NULL);
	_tmp5_ = gtk_dialog_run (dialog);
	if (_tmp5_ == GTK_RESPONSE_YES) {
		AppSettings* _tmp6_ = NULL;
		AppSettings* _tmp7_;
		gtk_list_store_remove (self->priv->build_tools_store, &iter);
		_tmp6_ = app_settings_get_default ();
		_tmp7_ = _tmp6_;
		app_settings_delete_build_tool (_tmp7_, i);
		_g_object_unref0 (_tmp7_);
	}
	gtk_object_destroy ((GtkObject*) dialog);
	_g_object_unref0 (dialog);
	_g_object_unref0 (model);
	_g_free0 (label);
}


static void __lambda106__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda106_ (self);
}


static void _lambda107_ (PreferencesDialog* self) {
	GtkTreeIter iter1 = {0};
	GtkTreeIter iter2 = {0};
	GtkTreeIter _tmp0_ = {0};
	gint _tmp1_;
	gint i;
	gboolean _tmp2_ = FALSE;
	_tmp1_ = utils_get_selected_row (self->priv->build_tools_view, &_tmp0_);
	iter1 = _tmp0_;
	i = _tmp1_;
	if (i != (-1)) {
		_tmp2_ = i > 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp3_;
		iter2 = iter1;
		_tmp3_ = utils_tree_model_iter_prev ((GtkTreeModel*) self->priv->build_tools_store, &iter2);
		if (_tmp3_) {
			AppSettings* _tmp4_ = NULL;
			AppSettings* _tmp5_;
			gtk_list_store_swap (self->priv->build_tools_store, &iter1, &iter2);
			_tmp4_ = app_settings_get_default ();
			_tmp5_ = _tmp4_;
			app_settings_move_build_tool_up (_tmp5_, i);
			_g_object_unref0 (_tmp5_);
		}
	}
}


static void __lambda107__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda107_ (self);
}


static void _lambda108_ (PreferencesDialog* self) {
	GtkTreeIter iter1 = {0};
	GtkTreeIter iter2 = {0};
	GtkTreeIter _tmp0_ = {0};
	gint _tmp1_;
	gint i;
	_tmp1_ = utils_get_selected_row (self->priv->build_tools_view, &_tmp0_);
	iter1 = _tmp0_;
	i = _tmp1_;
	if (i != (-1)) {
		gboolean _tmp2_;
		iter2 = iter1;
		_tmp2_ = gtk_tree_model_iter_next ((GtkTreeModel*) self->priv->build_tools_store, &iter2);
		if (_tmp2_) {
			AppSettings* _tmp3_ = NULL;
			AppSettings* _tmp4_;
			gtk_list_store_swap (self->priv->build_tools_store, &iter1, &iter2);
			_tmp3_ = app_settings_get_default ();
			_tmp4_ = _tmp3_;
			app_settings_move_build_tool_down (_tmp4_, i);
			_g_object_unref0 (_tmp4_);
		}
	}
}


static void __lambda108__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda108_ (self);
}


static void _lambda109_ (PreferencesDialog* self) {
	const gchar* _tmp0_ = NULL;
	GtkDialog* _tmp1_ = NULL;
	GtkDialog* dialog;
	gint _tmp2_;
	_tmp0_ = _ ("Do you really want to reset all build tools?");
	_tmp1_ = preferences_dialog_get_reset_all_confirm_dialog (self, _tmp0_);
	dialog = _tmp1_;
	_tmp2_ = gtk_dialog_run (dialog);
	if (_tmp2_ == GTK_RESPONSE_YES) {
		AppSettings* _tmp3_ = NULL;
		AppSettings* _tmp4_;
		_tmp3_ = app_settings_get_default ();
		_tmp4_ = _tmp3_;
		app_settings_reset_all_build_tools (_tmp4_);
		_g_object_unref0 (_tmp4_);
		preferences_dialog_update_build_tools_store (self);
	}
	gtk_object_destroy ((GtkObject*) dialog);
	_g_object_unref0 (dialog);
}


static void __lambda109__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda109_ (self);
}


static void preferences_dialog_init_build_tools_buttons (PreferencesDialog* self, GtkButton* bt_new, GtkButton* bt_delete, GtkButton* bt_up, GtkButton* bt_down, GtkButton* bt_properties, GtkButton* bt_reset) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (bt_new != NULL);
	g_return_if_fail (bt_delete != NULL);
	g_return_if_fail (bt_up != NULL);
	g_return_if_fail (bt_down != NULL);
	g_return_if_fail (bt_properties != NULL);
	g_return_if_fail (bt_reset != NULL);
	g_signal_connect_object (bt_new, "clicked", (GCallback) __lambda97__gtk_button_clicked, self, 0);
	g_signal_connect_object (bt_properties, "clicked", (GCallback) __lambda105__gtk_button_clicked, self, 0);
	g_signal_connect_object (bt_delete, "clicked", (GCallback) __lambda106__gtk_button_clicked, self, 0);
	g_signal_connect_object (bt_up, "clicked", (GCallback) __lambda107__gtk_button_clicked, self, 0);
	g_signal_connect_object (bt_down, "clicked", (GCallback) __lambda108__gtk_button_clicked, self, 0);
	g_signal_connect_object (bt_reset, "clicked", (GCallback) __lambda109__gtk_button_clicked, self, 0);
}


static GtkDialog* preferences_dialog_get_reset_all_confirm_dialog (PreferencesDialog* self, const gchar* msg) {
	GtkDialog* result = NULL;
	GtkMessageDialog* _tmp0_ = NULL;
	GtkDialog* dialog;
	const gchar* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	GtkButton* button;
	GtkImage* _tmp3_ = NULL;
	GtkImage* image;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	_tmp0_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, msg);
	dialog = (GtkDialog*) g_object_ref_sink (_tmp0_);
	gtk_dialog_add_button (dialog, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
	_tmp1_ = _ ("Reset All");
	_tmp2_ = (GtkButton*) gtk_button_new_with_label (_tmp1_);
	button = g_object_ref_sink (_tmp2_);
	_tmp3_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_CLEAR, GTK_ICON_SIZE_BUTTON);
	image = g_object_ref_sink (_tmp3_);
	gtk_button_set_image (button, (GtkWidget*) image);
	gtk_widget_show_all ((GtkWidget*) button);
	gtk_dialog_add_action_widget (dialog, (GtkWidget*) button, (gint) GTK_RESPONSE_YES);
	result = dialog;
	_g_object_unref0 (image);
	_g_object_unref0 (button);
	return result;
}


static void preferences_dialog_run_build_tool_dialog (PreferencesDialog* self, gint num) {
	GtkWindow* _tmp0_ = NULL;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_window_get_transient_for ((GtkWindow*) self);
	_tmp1_ = build_tool_dialog_show_me (_tmp0_, num);
	if (_tmp1_) {
		preferences_dialog_update_build_tools_store (self);
	}
}


static void preferences_dialog_class_init (PreferencesDialogClass * klass) {
	preferences_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PreferencesDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = preferences_dialog_finalize;
}


static void preferences_dialog_instance_init (PreferencesDialog * self) {
	self->priv = PREFERENCES_DIALOG_GET_PRIVATE (self);
}


static void preferences_dialog_finalize (GObject* obj) {
	PreferencesDialog * self;
	self = PREFERENCES_DIALOG (obj);
	_g_object_unref0 (self->priv->build_tools_store);
	_g_object_unref0 (self->priv->build_tools_view);
	G_OBJECT_CLASS (preferences_dialog_parent_class)->finalize (obj);
}


GType preferences_dialog_get_type (void) {
	static volatile gsize preferences_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&preferences_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PreferencesDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) preferences_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PreferencesDialog), 0, (GInstanceInitFunc) preferences_dialog_instance_init, NULL };
		GType preferences_dialog_type_id;
		preferences_dialog_type_id = g_type_register_static (GTK_TYPE_DIALOG, "PreferencesDialog", &g_define_type_info, 0);
		g_once_init_leave (&preferences_dialog_type_id__volatile, preferences_dialog_type_id);
	}
	return preferences_dialog_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



