/* build_tool_runner.c generated by valac 0.12.0, the Vala compiler
 * generated from build_tool_runner.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <gee.h>
#include <glib/gi18n-lib.h>


#define TYPE_BUILD_TOOL_RUNNER (build_tool_runner_get_type ())
#define BUILD_TOOL_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOL_RUNNER, BuildToolRunner))
#define BUILD_TOOL_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOL_RUNNER, BuildToolRunnerClass))
#define IS_BUILD_TOOL_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOL_RUNNER))
#define IS_BUILD_TOOL_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOL_RUNNER))
#define BUILD_TOOL_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOL_RUNNER, BuildToolRunnerClass))

typedef struct _BuildToolRunner BuildToolRunner;
typedef struct _BuildToolRunnerClass BuildToolRunnerClass;
typedef struct _BuildToolRunnerPrivate BuildToolRunnerPrivate;

#define TYPE_BUILD_VIEW (build_view_get_type ())
#define BUILD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_VIEW, BuildView))
#define BUILD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_VIEW, BuildViewClass))
#define IS_BUILD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_VIEW))
#define IS_BUILD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_VIEW))
#define BUILD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_VIEW, BuildViewClass))

typedef struct _BuildView BuildView;
typedef struct _BuildViewClass BuildViewClass;

#define TYPE_BUILD_JOB (build_job_get_type ())

#define TYPE_POST_PROCESSOR_TYPE (post_processor_type_get_type ())
typedef struct _BuildJob BuildJob;
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_BUILD_TOOL (build_tool_get_type ())
typedef struct _BuildTool BuildTool;

#define TYPE_PARTITION_STATE (partition_state_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_POST_PROCESSOR (post_processor_get_type ())
#define POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_POST_PROCESSOR, PostProcessor))
#define IS_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_POST_PROCESSOR))
#define POST_PROCESSOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_POST_PROCESSOR, PostProcessorIface))

typedef struct _PostProcessor PostProcessor;
typedef struct _PostProcessorIface PostProcessorIface;

#define TYPE_POST_PROCESSOR_ISSUES (post_processor_issues_get_type ())

#define TYPE_BUILD_ISSUE (build_issue_get_type ())

#define TYPE_BUILD_MESSAGE_TYPE (build_message_type_get_type ())
typedef struct _BuildIssue BuildIssue;
typedef struct _PostProcessorIssues PostProcessorIssues;

#define TYPE_ALL_OUTPUT_POST_PROCESSOR (all_output_post_processor_get_type ())
#define ALL_OUTPUT_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALL_OUTPUT_POST_PROCESSOR, AllOutputPostProcessor))
#define ALL_OUTPUT_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALL_OUTPUT_POST_PROCESSOR, AllOutputPostProcessorClass))
#define IS_ALL_OUTPUT_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALL_OUTPUT_POST_PROCESSOR))
#define IS_ALL_OUTPUT_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALL_OUTPUT_POST_PROCESSOR))
#define ALL_OUTPUT_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALL_OUTPUT_POST_PROCESSOR, AllOutputPostProcessorClass))

typedef struct _AllOutputPostProcessor AllOutputPostProcessor;
typedef struct _AllOutputPostProcessorClass AllOutputPostProcessorClass;

#define TYPE_LATEX_POST_PROCESSOR (latex_post_processor_get_type ())
#define LATEX_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEX_POST_PROCESSOR, LatexPostProcessor))
#define LATEX_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEX_POST_PROCESSOR, LatexPostProcessorClass))
#define IS_LATEX_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEX_POST_PROCESSOR))
#define IS_LATEX_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEX_POST_PROCESSOR))
#define LATEX_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEX_POST_PROCESSOR, LatexPostProcessorClass))

typedef struct _LatexPostProcessor LatexPostProcessor;
typedef struct _LatexPostProcessorClass LatexPostProcessorClass;

#define TYPE_LATEXMK_POST_PROCESSOR (latexmk_post_processor_get_type ())
#define LATEXMK_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEXMK_POST_PROCESSOR, LatexmkPostProcessor))
#define LATEXMK_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEXMK_POST_PROCESSOR, LatexmkPostProcessorClass))
#define IS_LATEXMK_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEXMK_POST_PROCESSOR))
#define IS_LATEXMK_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEXMK_POST_PROCESSOR))
#define LATEXMK_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEXMK_POST_PROCESSOR, LatexmkPostProcessorClass))

typedef struct _LatexmkPostProcessor LatexmkPostProcessor;
typedef struct _LatexmkPostProcessorClass LatexmkPostProcessorClass;

#define TYPE_NO_OUTPUT_POST_PROCESSOR (no_output_post_processor_get_type ())
#define NO_OUTPUT_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NO_OUTPUT_POST_PROCESSOR, NoOutputPostProcessor))
#define NO_OUTPUT_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NO_OUTPUT_POST_PROCESSOR, NoOutputPostProcessorClass))
#define IS_NO_OUTPUT_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NO_OUTPUT_POST_PROCESSOR))
#define IS_NO_OUTPUT_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NO_OUTPUT_POST_PROCESSOR))
#define NO_OUTPUT_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NO_OUTPUT_POST_PROCESSOR, NoOutputPostProcessorClass))

typedef struct _NoOutputPostProcessor NoOutputPostProcessor;
typedef struct _NoOutputPostProcessorClass NoOutputPostProcessorClass;

#define TYPE_RUBBER_POST_PROCESSOR (rubber_post_processor_get_type ())
#define RUBBER_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RUBBER_POST_PROCESSOR, RubberPostProcessor))
#define RUBBER_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RUBBER_POST_PROCESSOR, RubberPostProcessorClass))
#define IS_RUBBER_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RUBBER_POST_PROCESSOR))
#define IS_RUBBER_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RUBBER_POST_PROCESSOR))
#define RUBBER_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RUBBER_POST_PROCESSOR, RubberPostProcessorClass))

typedef struct _RubberPostProcessor RubberPostProcessor;
typedef struct _RubberPostProcessorClass RubberPostProcessorClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _BuildToolRunner {
	GObject parent_instance;
	BuildToolRunnerPrivate * priv;
};

struct _BuildToolRunnerClass {
	GObjectClass parent_class;
};

typedef enum  {
	POST_PROCESSOR_TYPE_ALL_OUTPUT = 0,
	POST_PROCESSOR_TYPE_LATEX,
	POST_PROCESSOR_TYPE_LATEXMK,
	POST_PROCESSOR_TYPE_NO_OUTPUT,
	POST_PROCESSOR_TYPE_RUBBER,
	POST_PROCESSOR_TYPE_N_POST_PROCESSORS
} PostProcessorType;

struct _BuildJob {
	gboolean must_succeed;
	PostProcessorType post_processor;
	gchar* command;
	gchar** command_args;
	gint command_args_length1;
};

struct _BuildToolRunnerPrivate {
	GPid* child_pid;
	guint* handlers;
	gint handlers_length1;
	gint _handlers_size_;
	GIOChannel* out_channel;
	gboolean read_output;
	gchar* output;
	BuildView* view;
	gboolean compilation;
	gchar* document_view_program;
	gboolean latexmk_show_all;
	GtkAction* action_stop_exec;
	GFile* file;
	gchar* filename;
	gchar* shortname;
	gchar* directory;
	GList* jobs;
	gint job_num;
	BuildJob current_job;
	GtkTreeIter root_partition;
	GtkTreeIter* job_partitions;
	gint job_partitions_length1;
	gint _job_partitions_size_;
};

struct _BuildTool {
	gchar* description;
	gchar* extensions;
	gchar* label;
	gchar* icon;
	gboolean show;
	gboolean compilation;
	GList* jobs;
};

typedef enum  {
	PARTITION_STATE_RUNNING,
	PARTITION_STATE_SUCCEEDED,
	PARTITION_STATE_FAILED,
	PARTITION_STATE_ABORTED
} PartitionState;

typedef enum  {
	BUILD_MESSAGE_TYPE_ERROR,
	BUILD_MESSAGE_TYPE_WARNING,
	BUILD_MESSAGE_TYPE_BADBOX,
	BUILD_MESSAGE_TYPE_OTHER
} BuildMessageType;

struct _BuildIssue {
	gchar* message;
	BuildMessageType message_type;
	gchar* filename;
	gint start_line;
	gint end_line;
};

struct _PostProcessorIssues {
	gchar* partition_msg;
	PartitionState partition_state;
	GeeArrayList* issues;
};

struct _PostProcessorIface {
	GTypeInterface parent_iface;
	void (*process) (PostProcessor* self, GFile* file, const gchar* output, gint status);
	PostProcessorIssues* (*get_issues) (PostProcessor* self, int* result_length1);
	gboolean (*get_successful) (PostProcessor* self);
	void (*set_successful) (PostProcessor* self, gboolean value);
};


static gpointer build_tool_runner_parent_class = NULL;

GType build_tool_runner_get_type (void) G_GNUC_CONST;
GType build_view_get_type (void) G_GNUC_CONST;
GType build_job_get_type (void) G_GNUC_CONST;
GType post_processor_type_get_type (void) G_GNUC_CONST;
BuildJob* build_job_dup (const BuildJob* self);
void build_job_free (BuildJob* self);
void build_job_copy (const BuildJob* self, BuildJob* dest);
void build_job_destroy (BuildJob* self);
#define BUILD_TOOL_RUNNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BUILD_TOOL_RUNNER, BuildToolRunnerPrivate))
enum  {
	BUILD_TOOL_RUNNER_DUMMY_PROPERTY
};
#define BUILD_TOOL_RUNNER_POLL_INTERVAL 250
GType build_tool_get_type (void) G_GNUC_CONST;
BuildTool* build_tool_dup (const BuildTool* self);
void build_tool_free (BuildTool* self);
void build_tool_copy (const BuildTool* self, BuildTool* dest);
void build_tool_destroy (BuildTool* self);
BuildToolRunner* build_tool_runner_new (GFile* file, BuildTool* tool, BuildView* view, GtkAction* action_stop_exec);
BuildToolRunner* build_tool_runner_construct (GType object_type, GFile* file, BuildTool* tool, BuildView* view, GtkAction* action_stop_exec);
gchar* utils_get_shortname (const gchar* path);
gchar* utils_get_extension (const gchar* path);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
void build_view_clear (BuildView* self);
GType partition_state_get_type (void) G_GNUC_CONST;
void build_view_add_partition (BuildView* self, const gchar* msg, PartitionState state, GtkTreeIter* parent, gboolean bold, GtkTreeIter* result);
static gchar** build_tool_runner_get_command (BuildToolRunner* self, BuildJob* build_job, gboolean basename, int* result_length1);
static void _vala_array_add2 (GtkTreeIter** array, int* length, int* size, const GtkTreeIter* value);
static void build_tool_runner_proceed (BuildToolRunner* self);
static void build_tool_runner_execute (BuildToolRunner* self, gchar** command, int command_length1, const gchar* working_directory, GError** error);
static void _lambda51_ (BuildToolRunner* self);
static void __lambda51__gspawn_child_setup_func (gpointer self);
static GPid* _g_pid_dup (GPid* self);
static void build_tool_runner_on_exit (BuildToolRunner* self, GPid pid, gint status);
static void _build_tool_runner_on_exit_gchild_watch_func (GPid pid, gint status, gpointer self);
static void _vala_array_add3 (guint** array, int* length, int* size, guint value);
static gboolean build_tool_runner_on_output (BuildToolRunner* self);
static gboolean _build_tool_runner_on_output_gsource_func (gpointer self);
static void _vala_array_add4 (guint** array, int* length, int* size, guint value);
static void build_tool_runner_execute_without_output (BuildToolRunner* self, gchar** command, int command_length1, const gchar* working_directory, GError** error);
static void _vala_array_add5 (guint** array, int* length, int* size, guint value);
void build_tool_runner_abort (BuildToolRunner* self);
void build_view_set_partition_state (BuildView* self, GtkTreeIter* partition_id, PartitionState state);
GType post_processor_issues_get_type (void) G_GNUC_CONST;
GType build_issue_get_type (void) G_GNUC_CONST;
GType build_message_type_get_type (void) G_GNUC_CONST;
BuildIssue* build_issue_dup (const BuildIssue* self);
void build_issue_free (BuildIssue* self);
void build_issue_copy (const BuildIssue* self, BuildIssue* dest);
void build_issue_destroy (BuildIssue* self);
PostProcessorIssues* post_processor_issues_dup (const PostProcessorIssues* self);
void post_processor_issues_free (PostProcessorIssues* self);
void post_processor_issues_copy (const PostProcessorIssues* self, PostProcessorIssues* dest);
void post_processor_issues_destroy (PostProcessorIssues* self);
GType post_processor_get_type (void) G_GNUC_CONST;
AllOutputPostProcessor* all_output_post_processor_new (void);
AllOutputPostProcessor* all_output_post_processor_construct (GType object_type);
GType all_output_post_processor_get_type (void) G_GNUC_CONST;
LatexPostProcessor* latex_post_processor_new (void);
LatexPostProcessor* latex_post_processor_construct (GType object_type);
GType latex_post_processor_get_type (void) G_GNUC_CONST;
LatexmkPostProcessor* latexmk_post_processor_new (gboolean show_all);
LatexmkPostProcessor* latexmk_post_processor_construct (GType object_type, gboolean show_all);
GType latexmk_post_processor_get_type (void) G_GNUC_CONST;
NoOutputPostProcessor* no_output_post_processor_new (void);
NoOutputPostProcessor* no_output_post_processor_construct (GType object_type);
GType no_output_post_processor_get_type (void) G_GNUC_CONST;
RubberPostProcessor* rubber_post_processor_new (void);
RubberPostProcessor* rubber_post_processor_construct (GType object_type);
GType rubber_post_processor_get_type (void) G_GNUC_CONST;
void post_processor_process (PostProcessor* self, GFile* file, const gchar* output, gint status);
PostProcessorIssues* post_processor_get_issues (PostProcessor* self, int* result_length1);
void build_view_append_issues (BuildView* self, GtkTreeIter* partition_id, GeeArrayList* issues);
gboolean post_processor_get_successful (PostProcessor* self);
static void build_tool_runner_failed (BuildToolRunner* self);
static void _vala_PostProcessorIssues_array_free (PostProcessorIssues* array, gint array_length);
static gchar** _vala_array_dup1 (gchar** self, int length);
static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value);
static gchar** _vala_array_dup2 (gchar** self, int length);
static void build_tool_runner_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void _vala_array_add2 (GtkTreeIter** array, int* length, int* size, const GtkTreeIter* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkTreeIter, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


BuildToolRunner* build_tool_runner_construct (GType object_type, GFile* file, BuildTool* tool, BuildView* view, GtkAction* action_stop_exec) {
	BuildToolRunner * self = NULL;
	GFile* _tmp0_;
	GtkAction* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_;
	gchar* _tmp6_ = NULL;
	GSettings* _tmp7_ = NULL;
	GSettings* settings;
	gchar* _tmp8_ = NULL;
	gboolean _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_ = NULL;
	gchar** extensions;
	gint extensions_length1;
	gint _extensions_size_;
	gboolean _tmp12_ = FALSE;
	gint _tmp13_;
	BuildView* _tmp16_;
	GtkTreeIter _tmp17_ = {0};
	GtkTreeIter _tmp18_ = {0};
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (view != NULL, NULL);
	g_return_val_if_fail (action_stop_exec != NULL, NULL);
	self = (BuildToolRunner*) g_object_new (object_type, NULL);
	g_return_if_fail (tool != NULL);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp0_;
	self->priv->compilation = (*tool).compilation;
	_tmp1_ = _g_object_ref0 (action_stop_exec);
	_g_object_unref0 (self->priv->action_stop_exec);
	self->priv->action_stop_exec = _tmp1_;
	_tmp2_ = g_file_get_parse_name (file);
	_g_free0 (self->priv->filename);
	self->priv->filename = _tmp2_;
	_tmp3_ = utils_get_shortname (self->priv->filename);
	_g_free0 (self->priv->shortname);
	self->priv->shortname = _tmp3_;
	_tmp4_ = g_file_get_parent (file);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_file_get_parse_name (_tmp5_);
	_g_free0 (self->priv->directory);
	self->priv->directory = _tmp6_;
	_g_object_unref0 (_tmp5_);
	_tmp7_ = g_settings_new ("org.gnome.latexila.preferences.latex");
	settings = _tmp7_;
	_tmp8_ = g_settings_get_string (settings, "document-view-program");
	_g_free0 (self->priv->document_view_program);
	self->priv->document_view_program = _tmp8_;
	_tmp9_ = g_settings_get_boolean (settings, "latexmk-always-show-all");
	self->priv->latexmk_show_all = _tmp9_;
	_tmp11_ = _tmp10_ = g_strsplit ((*tool).extensions, " ", 0);
	extensions = _tmp11_;
	extensions_length1 = _vala_array_length (_tmp10_);
	_extensions_size_ = _vala_array_length (_tmp10_);
	_tmp13_ = strlen ((*tool).extensions);
	if (_tmp13_ > 0) {
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		_tmp14_ = utils_get_extension (self->priv->filename);
		_tmp15_ = _tmp14_;
		_tmp12_ = !_vala_string_array_contains (extensions, extensions_length1, _tmp15_);
		_g_free0 (_tmp15_);
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		fprintf (stderr, "Warning: bad file extension\n");
		extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (settings);
		return self;
	}
	self->priv->jobs = (*tool).jobs;
	_tmp16_ = _g_object_ref0 (view);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp16_;
	build_view_clear (view);
	build_view_add_partition (view, (*tool).label, PARTITION_STATE_RUNNING, NULL, TRUE, &_tmp17_);
	_tmp18_ = _tmp17_;
	self->priv->root_partition = _tmp18_;
	{
		GList* job_collection;
		GList* job_it;
		job_collection = self->priv->jobs;
		for (job_it = job_collection; job_it != NULL; job_it = job_it->next) {
			BuildJob _tmp19_;
			BuildJob _tmp20_ = {0};
			BuildJob job;
			build_job_copy ((BuildJob*) job_it->data, &_tmp20_);
			_tmp19_ = _tmp20_;
			job = _tmp19_;
			{
				gint _tmp21_;
				gchar** _tmp22_ = NULL;
				gchar** command;
				gint command_length1;
				gint _command_size_;
				gchar* _tmp23_ = NULL;
				gchar* _tmp24_;
				GtkTreeIter _tmp25_ = {0};
				GtkTreeIter _tmp26_ = {0};
				_tmp22_ = build_tool_runner_get_command (self, &job, TRUE, &_tmp21_);
				command = _tmp22_;
				command_length1 = _tmp21_;
				_command_size_ = _tmp21_;
				_tmp23_ = g_strjoinv (" ", command);
				_tmp24_ = _tmp23_;
				build_view_add_partition (view, _tmp24_, PARTITION_STATE_RUNNING, &self->priv->root_partition, FALSE, &_tmp25_);
				_tmp26_ = _tmp25_;
				_vala_array_add2 (&self->priv->job_partitions, &self->priv->job_partitions_length1, &self->priv->_job_partitions_size_, &_tmp26_);
				_g_free0 (_tmp24_);
				command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
				build_job_destroy (&job);
			}
		}
	}
	gtk_action_set_sensitive (action_stop_exec, TRUE);
	build_tool_runner_proceed (self);
	extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (settings);
	return self;
}


BuildToolRunner* build_tool_runner_new (GFile* file, BuildTool* tool, BuildView* view, GtkAction* action_stop_exec) {
	return build_tool_runner_construct (TYPE_BUILD_TOOL_RUNNER, file, tool, view, action_stop_exec);
}


static void _lambda51_ (BuildToolRunner* self) {
	dup2 (STDOUT_FILENO, STDERR_FILENO);
}


static void __lambda51__gspawn_child_setup_func (gpointer self) {
	_lambda51_ (self);
}


static GPid* _g_pid_dup (GPid* self) {
	GPid* dup;
	dup = g_new0 (GPid, 1);
	memcpy (dup, self, sizeof (GPid));
	return dup;
}


static gpointer __g_pid_dup0 (gpointer self) {
	return self ? _g_pid_dup (self) : NULL;
}


static void _build_tool_runner_on_exit_gchild_watch_func (GPid pid, gint status, gpointer self) {
	build_tool_runner_on_exit (self, pid, status);
}


static void _vala_array_add3 (guint** array, int* length, int* size, guint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static gboolean _build_tool_runner_on_output_gsource_func (gpointer self) {
	gboolean result;
	result = build_tool_runner_on_output (self);
	return result;
}


static void _vala_array_add4 (guint** array, int* length, int* size, guint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void build_tool_runner_execute (BuildToolRunner* self, gchar** command, int command_length1, const gchar* working_directory, GError** error) {
	gint std_out = 0;
	GPid _tmp0_;
	gint _tmp1_;
	GPid* _tmp2_;
	guint _tmp3_;
	GIOChannel* _tmp4_ = NULL;
	guint _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_spawn_async_with_pipes (working_directory, command, NULL, G_SPAWN_DO_NOT_REAP_CHILD | G_SPAWN_SEARCH_PATH, __lambda51__gspawn_child_setup_func, self, &_tmp0_, NULL, &_tmp1_, NULL, &_inner_error_);
	_g_free0 (self->priv->child_pid);
	_tmp2_ = __g_pid_dup0 (&_tmp0_);
	self->priv->child_pid = _tmp2_;
	std_out = _tmp1_;
	if (_inner_error_ != NULL) {
		goto __catch15_g_error;
	}
	_tmp3_ = g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, *self->priv->child_pid, _build_tool_runner_on_exit_gchild_watch_func, g_object_ref (self), g_object_unref);
	_vala_array_add3 (&self->priv->handlers, &self->priv->handlers_length1, &self->priv->_handlers_size_, _tmp3_);
	_tmp4_ = g_io_channel_unix_new (std_out);
	_g_io_channel_unref0 (self->priv->out_channel);
	self->priv->out_channel = _tmp4_;
	g_io_channel_set_flags (self->priv->out_channel, G_IO_FLAG_NONBLOCK, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch15_g_error;
	}
	g_io_channel_set_encoding (self->priv->out_channel, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch15_g_error;
	}
	_tmp5_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) BUILD_TOOL_RUNNER_POLL_INTERVAL, _build_tool_runner_on_output_gsource_func, g_object_ref (self), g_object_unref);
	_vala_array_add4 (&self->priv->handlers, &self->priv->handlers_length1, &self->priv->_handlers_size_, _tmp5_);
	goto __finally15;
	__catch15_g_error:
	{
		GError * e;
		GError* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = _g_error_copy0 (e);
		_inner_error_ = _tmp6_;
		_g_error_free0 (e);
		goto __finally15;
	}
	__finally15:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static void _vala_array_add5 (guint** array, int* length, int* size, guint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void build_tool_runner_execute_without_output (BuildToolRunner* self, gchar** command, int command_length1, const gchar* working_directory, GError** error) {
	GPid _tmp0_;
	GPid* _tmp1_;
	guint _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->read_output = FALSE;
	g_spawn_async (working_directory, command, NULL, G_SPAWN_DO_NOT_REAP_CHILD | G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp0_, &_inner_error_);
	_g_free0 (self->priv->child_pid);
	_tmp1_ = __g_pid_dup0 (&_tmp0_);
	self->priv->child_pid = _tmp1_;
	if (_inner_error_ != NULL) {
		goto __catch16_g_error;
	}
	_tmp2_ = g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, *self->priv->child_pid, _build_tool_runner_on_exit_gchild_watch_func, g_object_ref (self), g_object_unref);
	_vala_array_add5 (&self->priv->handlers, &self->priv->handlers_length1, &self->priv->_handlers_size_, _tmp2_);
	goto __finally16;
	__catch16_g_error:
	{
		GError * e;
		GError* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = _g_error_copy0 (e);
		_inner_error_ = _tmp3_;
		_g_error_free0 (e);
		goto __finally16;
	}
	__finally16:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


void build_tool_runner_abort (BuildToolRunner* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->child_pid == NULL) {
		return;
	}
	{
		guint* handler_collection;
		int handler_collection_length1;
		int handler_it;
		handler_collection = self->priv->handlers;
		handler_collection_length1 = self->priv->handlers_length1;
		for (handler_it = 0; handler_it < self->priv->handlers_length1; handler_it = handler_it + 1) {
			guint handler;
			handler = handler_collection[handler_it];
			{
				g_source_remove (handler);
			}
		}
	}
	kill (*self->priv->child_pid, SIGTERM);
	gtk_action_set_sensitive (self->priv->action_stop_exec, FALSE);
	build_view_set_partition_state (self->priv->view, &self->priv->root_partition, PARTITION_STATE_ABORTED);
	{
		gint i;
		i = self->priv->job_num;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				GtkTreeIter _tmp1_;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < self->priv->job_partitions_length1)) {
					break;
				}
				_tmp1_ = self->priv->job_partitions[i];
				build_view_set_partition_state (self->priv->view, &_tmp1_, PARTITION_STATE_ABORTED);
			}
		}
	}
}


static gboolean build_tool_runner_on_output (BuildToolRunner* self) {
	gboolean result = FALSE;
	gchar* text;
	gsize length = 0UL;
	gchar* _tmp0_ = NULL;
	gsize _tmp1_;
	gboolean _tmp2_;
	gchar** _tmp4_;
	gchar** _tmp5_ = NULL;
	gchar** lines;
	gint lines_length1;
	gint _lines_size_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (self->priv->read_output, FALSE);
	text = NULL;
	g_io_channel_read_to_end (self->priv->out_channel, &_tmp0_, &_tmp1_, &_inner_error_);
	_g_free0 (text);
	text = _tmp0_;
	length = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_CONVERT_ERROR) {
			goto __catch17_g_convert_error;
		}
		if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
			goto __catch17_g_io_channel_error;
		}
		_g_free0 (text);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	goto __finally17;
	__catch17_g_convert_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "Read output: convert error: %s\n", e->message);
		_g_error_free0 (e);
	}
	goto __finally17;
	__catch17_g_io_channel_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "Read output: IO channel error: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally17:
	if (_inner_error_ != NULL) {
		_g_free0 (text);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	if (length <= 0) {
		result = TRUE;
		_g_free0 (text);
		return result;
	}
	_tmp2_ = g_utf8_validate (text, (gssize) (-1), NULL);
	if (_tmp2_) {
		gchar* _tmp3_;
		_tmp3_ = g_strconcat (self->priv->output, text, NULL);
		_g_free0 (self->priv->output);
		self->priv->output = _tmp3_;
		result = TRUE;
		_g_free0 (text);
		return result;
	}
	_tmp5_ = _tmp4_ = g_strsplit (text, "\n", 0);
	lines = _tmp5_;
	lines_length1 = _vala_array_length (_tmp4_);
	_lines_size_ = _vala_array_length (_tmp4_);
	{
		gchar** line_collection;
		int line_collection_length1;
		int line_it;
		line_collection = lines;
		line_collection_length1 = lines_length1;
		for (line_it = 0; line_it < lines_length1; line_it = line_it + 1) {
			gchar* _tmp6_;
			gchar* line;
			_tmp6_ = g_strdup (line_collection[line_it]);
			line = _tmp6_;
			{
				gchar* _tmp7_ = NULL;
				gchar* line_utf8;
				gboolean _tmp10_ = FALSE;
				_tmp7_ = g_locale_to_utf8 (line, (gssize) (-1), NULL, NULL, NULL);
				line_utf8 = _tmp7_;
				if (line_utf8 == NULL) {
					gchar* _tmp8_ = NULL;
					gchar* _tmp9_;
					_tmp8_ = g_convert (line, (gssize) (-1), "UTF-8", "ISO-8859-1", NULL, NULL, &_inner_error_);
					_tmp9_ = _tmp8_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == G_CONVERT_ERROR) {
							goto __catch18_g_convert_error;
						}
						_g_free0 (line_utf8);
						_g_free0 (line);
						lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (text);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
					_g_free0 (line_utf8);
					line_utf8 = _tmp9_;
					goto __finally18;
					__catch18_g_convert_error:
					{
						GError * e;
						e = _inner_error_;
						_inner_error_ = NULL;
						_g_error_free0 (e);
					}
					__finally18:
					if (_inner_error_ != NULL) {
						_g_free0 (line_utf8);
						_g_free0 (line);
						lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (text);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
				}
				if (line_utf8 != NULL) {
					gboolean _tmp11_;
					_tmp11_ = g_utf8_validate (line_utf8, (gssize) (-1), NULL);
					_tmp10_ = _tmp11_;
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					gchar* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					_tmp12_ = g_strconcat (line_utf8, "\n", NULL);
					_tmp13_ = _tmp12_;
					_tmp14_ = g_strconcat (self->priv->output, _tmp13_, NULL);
					_g_free0 (self->priv->output);
					self->priv->output = _tmp14_;
					_g_free0 (_tmp13_);
				} else {
					fprintf (stderr, "Read output failed: %s\n", line);
				}
				_g_free0 (line_utf8);
				_g_free0 (line);
			}
		}
	}
	result = TRUE;
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (text);
	return result;
}


static void _vala_PostProcessorIssues_array_free (PostProcessorIssues* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			post_processor_issues_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void build_tool_runner_on_exit (BuildToolRunner* self, GPid pid, gint status) {
	PostProcessor* post_processor = NULL;
	gint _tmp6_;
	PostProcessorIssues* _tmp7_ = NULL;
	PostProcessorIssues* all_issues;
	gint all_issues_length1;
	gint _all_issues_size_;
	gboolean _tmp14_;
	g_return_if_fail (self != NULL);
	{
		guint* handler_collection;
		int handler_collection_length1;
		int handler_it;
		handler_collection = self->priv->handlers;
		handler_collection_length1 = self->priv->handlers_length1;
		for (handler_it = 0; handler_it < self->priv->handlers_length1; handler_it = handler_it + 1) {
			guint handler;
			handler = handler_collection[handler_it];
			{
				g_source_remove (handler);
			}
		}
	}
	if (self->priv->read_output) {
		build_tool_runner_on_output (self);
	}
	switch (self->priv->current_job.post_processor) {
		case POST_PROCESSOR_TYPE_ALL_OUTPUT:
		{
			AllOutputPostProcessor* _tmp0_ = NULL;
			_tmp0_ = all_output_post_processor_new ();
			_g_object_unref0 (post_processor);
			post_processor = (PostProcessor*) _tmp0_;
			break;
		}
		case POST_PROCESSOR_TYPE_LATEX:
		{
			LatexPostProcessor* _tmp1_ = NULL;
			_tmp1_ = latex_post_processor_new ();
			_g_object_unref0 (post_processor);
			post_processor = (PostProcessor*) _tmp1_;
			break;
		}
		case POST_PROCESSOR_TYPE_LATEXMK:
		{
			LatexmkPostProcessor* _tmp2_ = NULL;
			_tmp2_ = latexmk_post_processor_new (self->priv->latexmk_show_all);
			_g_object_unref0 (post_processor);
			post_processor = (PostProcessor*) _tmp2_;
			break;
		}
		case POST_PROCESSOR_TYPE_NO_OUTPUT:
		{
			NoOutputPostProcessor* _tmp3_ = NULL;
			_tmp3_ = no_output_post_processor_new ();
			_g_object_unref0 (post_processor);
			post_processor = (PostProcessor*) _tmp3_;
			break;
		}
		case POST_PROCESSOR_TYPE_RUBBER:
		{
			RubberPostProcessor* _tmp4_ = NULL;
			_tmp4_ = rubber_post_processor_new ();
			_g_object_unref0 (post_processor);
			post_processor = (PostProcessor*) _tmp4_;
			break;
		}
		default:
		{
			NoOutputPostProcessor* _tmp5_ = NULL;
			fprintf (stderr, "Warning: unknown post processor. Use no-output.");
			_tmp5_ = no_output_post_processor_new ();
			_g_object_unref0 (post_processor);
			post_processor = (PostProcessor*) _tmp5_;
			break;
		}
	}
	post_processor_process (post_processor, self->priv->file, self->priv->output, status);
	_tmp7_ = post_processor_get_issues (post_processor, &_tmp6_);
	all_issues = _tmp7_;
	all_issues_length1 = _tmp6_;
	_all_issues_size_ = _tmp6_;
	{
		PostProcessorIssues* issues_collection;
		int issues_collection_length1;
		int issues_it;
		issues_collection = all_issues;
		issues_collection_length1 = all_issues_length1;
		for (issues_it = 0; issues_it < all_issues_length1; issues_it = issues_it + 1) {
			PostProcessorIssues _tmp8_;
			PostProcessorIssues _tmp9_ = {0};
			PostProcessorIssues issues;
			post_processor_issues_copy (&issues_collection[issues_it], &_tmp9_);
			_tmp8_ = _tmp9_;
			issues = _tmp8_;
			{
				if (issues.partition_msg != NULL) {
					GtkTreeIter _tmp10_;
					GtkTreeIter _tmp11_ = {0};
					GtkTreeIter _tmp12_ = {0};
					GtkTreeIter iter;
					_tmp10_ = self->priv->job_partitions[self->priv->job_num];
					build_view_add_partition (self->priv->view, issues.partition_msg, issues.partition_state, &_tmp10_, FALSE, &_tmp11_);
					_tmp12_ = _tmp11_;
					iter = _tmp12_;
					build_view_append_issues (self->priv->view, &iter, issues.issues);
				} else {
					GtkTreeIter _tmp13_;
					_tmp13_ = self->priv->job_partitions[self->priv->job_num];
					build_view_append_issues (self->priv->view, &_tmp13_, issues.issues);
				}
				post_processor_issues_destroy (&issues);
			}
		}
	}
	_tmp14_ = post_processor_get_successful (post_processor);
	if (_tmp14_) {
		GtkTreeIter _tmp15_;
		_tmp15_ = self->priv->job_partitions[self->priv->job_num];
		build_view_set_partition_state (self->priv->view, &_tmp15_, PARTITION_STATE_SUCCEEDED);
		self->priv->job_num++;
		build_tool_runner_proceed (self);
	} else {
		GtkTreeIter _tmp16_;
		_tmp16_ = self->priv->job_partitions[self->priv->job_num];
		build_view_set_partition_state (self->priv->view, &_tmp16_, PARTITION_STATE_FAILED);
		if (self->priv->current_job.must_succeed) {
			build_tool_runner_failed (self);
		} else {
			self->priv->job_num++;
			build_tool_runner_proceed (self);
		}
	}
	all_issues = (_vala_PostProcessorIssues_array_free (all_issues, all_issues_length1), NULL);
	_g_object_unref0 (post_processor);
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


static void build_tool_runner_proceed (BuildToolRunner* self) {
	guint _tmp0_;
	gchar* _tmp1_;
	gconstpointer _tmp2_ = NULL;
	gint _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** command;
	gint command_length1;
	gint _command_size_;
	gboolean _tmp5_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_list_length (self->priv->jobs);
	if (self->priv->job_num >= _tmp0_) {
		build_view_set_partition_state (self->priv->view, &self->priv->root_partition, PARTITION_STATE_SUCCEEDED);
		gtk_action_set_sensitive (self->priv->action_stop_exec, FALSE);
		g_signal_emit_by_name (self, "finished");
		return;
	}
	_tmp1_ = g_strdup ("");
	_g_free0 (self->priv->output);
	self->priv->output = _tmp1_;
	_tmp2_ = g_list_nth_data (self->priv->jobs, (guint) self->priv->job_num);
	self->priv->current_job = *((BuildJob*) _tmp2_);
	_tmp4_ = build_tool_runner_get_command (self, &self->priv->current_job, FALSE, &_tmp3_);
	command = _tmp4_;
	command_length1 = _tmp3_;
	_command_size_ = _tmp3_;
	if (self->priv->current_job.post_processor == POST_PROCESSOR_TYPE_RUBBER) {
		gboolean _tmp6_;
		_tmp6_ = string_contains (self->priv->filename, " ");
		_tmp5_ = _tmp6_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		GeeArrayList* _tmp7_ = NULL;
		GeeArrayList* issues;
		BuildIssue issue = {0};
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GtkTreeIter _tmp11_;
		_tmp7_ = gee_array_list_new (TYPE_BUILD_ISSUE, (GBoxedCopyFunc) build_issue_dup, build_issue_free, NULL);
		issues = _tmp7_;
		memset (&issue, 0, sizeof (BuildIssue));
		_tmp8_ = _ ("Rubber may not support filenames with spaces (even in a directory)");
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (issue.message);
		issue.message = _tmp9_;
		issue.message_type = BUILD_MESSAGE_TYPE_WARNING;
		_tmp10_ = g_strdup (self->priv->filename);
		_g_free0 (issue.filename);
		issue.filename = _tmp10_;
		gee_abstract_collection_add ((GeeAbstractCollection*) issues, &issue);
		_tmp11_ = self->priv->job_partitions[self->priv->job_num];
		build_view_append_issues (self->priv->view, &_tmp11_, issues);
		build_issue_destroy (&issue);
		_g_object_unref0 (issues);
	}
	if (self->priv->current_job.post_processor == POST_PROCESSOR_TYPE_NO_OUTPUT) {
		build_tool_runner_execute_without_output (self, command, command_length1, self->priv->directory, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch19_g_error;
		}
	} else {
		build_tool_runner_execute (self, command, command_length1, self->priv->directory, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch19_g_error;
		}
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError * e;
		GtkTreeIter _tmp12_;
		GtkTreeIter _tmp13_;
		GtkTreeIter _tmp14_ = {0};
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = self->priv->job_partitions[self->priv->job_num];
		build_view_set_partition_state (self->priv->view, &_tmp12_, PARTITION_STATE_FAILED);
		_tmp13_ = self->priv->job_partitions[self->priv->job_num];
		build_view_add_partition (self->priv->view, e->message, PARTITION_STATE_FAILED, &_tmp13_, FALSE, &_tmp14_);
		_tmp14_;
		if (self->priv->current_job.must_succeed) {
			build_tool_runner_failed (self);
		} else {
			self->priv->job_num++;
			build_tool_runner_proceed (self);
		}
		_g_error_free0 (e);
	}
	__finally19:
	if (_inner_error_ != NULL) {
		command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	glong string_length;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	string_length = (glong) _tmp0_;
	if (start < 0) {
		start = string_length + start;
	}
	if (end < 0) {
		end = string_length + end;
	}
	if (start >= 0) {
		_tmp1_ = start <= string_length;
	} else {
		_tmp1_ = FALSE;
	}
	g_return_val_if_fail (_tmp1_, NULL);
	if (end >= 0) {
		_tmp2_ = end <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp3_;
	return result;
}


static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	regex = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch20_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch20_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally20;
	__catch20_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally20:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar** build_tool_runner_get_command (BuildToolRunner* self, BuildJob* build_job, gboolean basename, int* result_length1) {
	gchar** result = NULL;
	gchar* base_filename;
	gchar* base_shortname;
	gchar** _tmp2_ = NULL;
	gchar** command;
	gint command_length1;
	gint _command_size_;
	gchar** _tmp44_;
	g_return_val_if_fail (self != NULL, NULL);
	base_filename = NULL;
	base_shortname = NULL;
	if (basename) {
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		_tmp0_ = g_file_get_basename (self->priv->file);
		_g_free0 (base_filename);
		base_filename = _tmp0_;
		_tmp1_ = utils_get_shortname (base_filename);
		_g_free0 (base_shortname);
		base_shortname = _tmp1_;
	}
	_tmp2_ = g_new0 (gchar*, 0 + 1);
	command = _tmp2_;
	command_length1 = 0;
	_command_size_ = 0;
	if ((*build_job).command_args != NULL) {
		gchar** _tmp3_;
		gchar** _tmp4_;
		_tmp3_ = (_tmp4_ = (*build_job).command_args, (_tmp4_ == NULL) ? ((gpointer) _tmp4_) : _vala_array_dup1 (_tmp4_, (*build_job).command_args_length1));
		command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
		command = _tmp3_;
		command_length1 = (*build_job).command_args_length1;
		_command_size_ = (*build_job).command_args_length1;
	} else {
		gchar** _tmp5_;
		gchar** _tmp6_ = NULL;
		gchar** args;
		gint args_length1;
		gint _args_size_;
		gchar* _tmp7_;
		gchar* arg_buf;
		gchar* delimiter;
		gchar** _tmp26_;
		gchar** _tmp27_;
		_tmp6_ = _tmp5_ = g_strsplit ((*build_job).command, " ", 0);
		args = _tmp6_;
		args_length1 = _vala_array_length (_tmp5_);
		_args_size_ = _vala_array_length (_tmp5_);
		_tmp7_ = g_strdup ("");
		arg_buf = _tmp7_;
		delimiter = NULL;
		{
			gchar** arg_collection;
			int arg_collection_length1;
			int arg_it;
			arg_collection = args;
			arg_collection_length1 = args_length1;
			for (arg_it = 0; arg_it < args_length1; arg_it = arg_it + 1) {
				gchar* _tmp8_;
				gchar* arg;
				_tmp8_ = g_strdup (arg_collection[arg_it]);
				arg = _tmp8_;
				{
					gboolean _tmp15_ = FALSE;
					gboolean _tmp16_ = FALSE;
					gboolean _tmp17_;
					gchar* _tmp25_;
					if (delimiter != NULL) {
						gchar* _tmp9_;
						gchar* _tmp10_;
						gchar* _tmp11_;
						gboolean _tmp12_;
						_tmp9_ = g_strconcat (" ", arg, NULL);
						_tmp10_ = _tmp9_;
						_tmp11_ = g_strconcat (arg_buf, _tmp10_, NULL);
						_g_free0 (arg_buf);
						arg_buf = _tmp11_;
						_g_free0 (_tmp10_);
						_tmp12_ = g_str_has_suffix (arg, delimiter);
						if (_tmp12_) {
							gint _tmp13_;
							gchar* _tmp14_ = NULL;
							_g_free0 (delimiter);
							delimiter = NULL;
							_tmp13_ = strlen (arg_buf);
							_tmp14_ = string_slice (arg_buf, (glong) 1, (glong) (_tmp13_ - 1));
							_vala_array_add6 (&command, &command_length1, &_command_size_, _tmp14_);
						}
						_g_free0 (arg);
						continue;
					}
					_tmp17_ = g_str_has_prefix (arg, "'");
					if (_tmp17_) {
						gboolean _tmp18_;
						_tmp18_ = g_str_has_suffix (arg, "'");
						_tmp16_ = !_tmp18_;
					} else {
						_tmp16_ = FALSE;
					}
					if (_tmp16_) {
						_tmp15_ = TRUE;
					} else {
						gboolean _tmp19_ = FALSE;
						gboolean _tmp20_;
						_tmp20_ = g_str_has_prefix (arg, "\"");
						if (_tmp20_) {
							gboolean _tmp21_;
							_tmp21_ = g_str_has_suffix (arg, "\"");
							_tmp19_ = !_tmp21_;
						} else {
							_tmp19_ = FALSE;
						}
						_tmp15_ = _tmp19_;
					}
					if (_tmp15_) {
						gchar _tmp22_;
						gchar* _tmp23_ = NULL;
						gchar* _tmp24_;
						_tmp22_ = string_get (arg, (glong) 0);
						_tmp23_ = g_strdup_printf ("%c", _tmp22_);
						_g_free0 (delimiter);
						delimiter = _tmp23_;
						_tmp24_ = g_strdup (arg);
						_g_free0 (arg_buf);
						arg_buf = _tmp24_;
						_g_free0 (arg);
						continue;
					}
					_tmp25_ = g_strdup (arg);
					_vala_array_add7 (&command, &command_length1, &_command_size_, _tmp25_);
					_g_free0 (arg);
				}
			}
		}
		_tmp26_ = (_tmp27_ = command, (_tmp27_ == NULL) ? ((gpointer) _tmp27_) : _vala_array_dup2 (_tmp27_, command_length1));
		(*build_job).command_args = (_vala_array_free ((*build_job).command_args, (*build_job).command_args_length1, (GDestroyNotify) g_free), NULL);
		(*build_job).command_args = _tmp26_;
		(*build_job).command_args_length1 = command_length1;
		_g_free0 (delimiter);
		_g_free0 (arg_buf);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp28_;
			_tmp28_ = TRUE;
			while (TRUE) {
				gboolean _tmp29_;
				gboolean _tmp32_;
				gboolean _tmp38_;
				if (!_tmp28_) {
					i++;
				}
				_tmp28_ = FALSE;
				if (!(i < command_length1)) {
					break;
				}
				_tmp29_ = string_contains (command[i], "$view");
				if (_tmp29_) {
					gchar* _tmp30_ = NULL;
					gchar* _tmp31_;
					_tmp30_ = string_replace (command[i], "$view", self->priv->document_view_program);
					_tmp31_ = _tmp30_;
					_g_free0 (command[i]);
					command[i] = _tmp31_;
					continue;
				}
				_tmp32_ = string_contains (command[i], "$filename");
				if (_tmp32_) {
					gchar* _tmp33_;
					gchar* _tmp34_;
					gchar* _tmp36_ = NULL;
					gchar* _tmp37_;
					_tmp33_ = g_strdup (base_filename);
					_tmp34_ = _tmp33_;
					if (_tmp34_ == NULL) {
						gchar* _tmp35_;
						_tmp35_ = g_strdup (self->priv->filename);
						_g_free0 (_tmp34_);
						_tmp34_ = _tmp35_;
					}
					_tmp36_ = string_replace (command[i], "$filename", _tmp34_);
					_tmp37_ = _tmp36_;
					_g_free0 (command[i]);
					command[i] = _tmp37_;
					_g_free0 (_tmp34_);
					continue;
				}
				_tmp38_ = string_contains (command[i], "$shortname");
				if (_tmp38_) {
					gchar* _tmp39_;
					gchar* _tmp40_;
					gchar* _tmp42_ = NULL;
					gchar* _tmp43_;
					_tmp39_ = g_strdup (base_shortname);
					_tmp40_ = _tmp39_;
					if (_tmp40_ == NULL) {
						gchar* _tmp41_;
						_tmp41_ = g_strdup (self->priv->shortname);
						_g_free0 (_tmp40_);
						_tmp40_ = _tmp41_;
					}
					_tmp42_ = string_replace (command[i], "$shortname", _tmp40_);
					_tmp43_ = _tmp42_;
					_g_free0 (command[i]);
					command[i] = _tmp43_;
					_g_free0 (_tmp40_);
					continue;
				}
			}
		}
	}
	_tmp44_ = command;
	*result_length1 = command_length1;
	result = _tmp44_;
	_g_free0 (base_shortname);
	_g_free0 (base_filename);
	return result;
}


static void build_tool_runner_failed (BuildToolRunner* self) {
	g_return_if_fail (self != NULL);
	build_view_set_partition_state (self->priv->view, &self->priv->root_partition, PARTITION_STATE_FAILED);
	{
		gint i;
		i = self->priv->job_num + 1;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				GtkTreeIter _tmp1_;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < self->priv->job_partitions_length1)) {
					break;
				}
				_tmp1_ = self->priv->job_partitions[i];
				build_view_set_partition_state (self->priv->view, &_tmp1_, PARTITION_STATE_ABORTED);
			}
		}
	}
	gtk_action_set_sensitive (self->priv->action_stop_exec, FALSE);
}


static void build_tool_runner_class_init (BuildToolRunnerClass * klass) {
	build_tool_runner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BuildToolRunnerPrivate));
	G_OBJECT_CLASS (klass)->finalize = build_tool_runner_finalize;
	g_signal_new ("finished", TYPE_BUILD_TOOL_RUNNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void build_tool_runner_instance_init (BuildToolRunner * self) {
	guint* _tmp0_ = NULL;
	gchar* _tmp1_;
	self->priv = BUILD_TOOL_RUNNER_GET_PRIVATE (self);
	self->priv->child_pid = NULL;
	_tmp0_ = g_new0 (guint, 0);
	self->priv->handlers = _tmp0_;
	self->priv->handlers_length1 = 0;
	self->priv->_handlers_size_ = self->priv->handlers_length1;
	self->priv->read_output = TRUE;
	_tmp1_ = g_strdup ("");
	self->priv->output = _tmp1_;
	self->priv->job_num = 0;
}


static void build_tool_runner_finalize (GObject* obj) {
	BuildToolRunner * self;
	self = BUILD_TOOL_RUNNER (obj);
	_g_free0 (self->priv->child_pid);
	self->priv->handlers = (g_free (self->priv->handlers), NULL);
	_g_io_channel_unref0 (self->priv->out_channel);
	_g_free0 (self->priv->output);
	_g_object_unref0 (self->priv->view);
	_g_free0 (self->priv->document_view_program);
	_g_object_unref0 (self->priv->action_stop_exec);
	_g_object_unref0 (self->priv->file);
	_g_free0 (self->priv->filename);
	_g_free0 (self->priv->shortname);
	_g_free0 (self->priv->directory);
	self->priv->job_partitions = (g_free (self->priv->job_partitions), NULL);
	G_OBJECT_CLASS (build_tool_runner_parent_class)->finalize (obj);
}


GType build_tool_runner_get_type (void) {
	static volatile gsize build_tool_runner_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_runner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BuildToolRunnerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) build_tool_runner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BuildToolRunner), 0, (GInstanceInitFunc) build_tool_runner_instance_init, NULL };
		GType build_tool_runner_type_id;
		build_tool_runner_type_id = g_type_register_static (G_TYPE_OBJECT, "BuildToolRunner", &g_define_type_info, 0);
		g_once_init_leave (&build_tool_runner_type_id__volatile, build_tool_runner_type_id);
	}
	return build_tool_runner_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



