/* dialogs.c generated by valac 0.12.0, the Vala compiler
 * generated from dialogs.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtksourceview/gtksourceview.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define DIALOGS_TYPE_UNSAVED_DOC_COLUMN (dialogs_unsaved_doc_column_get_type ())

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _Block20Data Block20Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _DocumentPrivate DocumentPrivate;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define DIALOGS_TYPE_CLEAN_FILE_COLUMN (dialogs_clean_file_column_get_type ())
typedef struct _Block21Data Block21Data;

typedef enum  {
	DIALOGS_UNSAVED_DOC_COLUMN_SAVE,
	DIALOGS_UNSAVED_DOC_COLUMN_NAME,
	DIALOGS_UNSAVED_DOC_COLUMN_DOC,
	DIALOGS_UNSAVED_DOC_COLUMN_N_COLUMNS
} DialogsUnsavedDocColumn;

struct _Block20Data {
	int _ref_count_;
	GtkListStore* store;
};

struct _Document {
	GtkSourceBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
	guint _unsaved_doc_num;
};

struct _DocumentClass {
	GtkSourceBufferClass parent_class;
};

typedef enum  {
	DIALOGS_CLEAN_FILE_COLUMN_DELETE,
	DIALOGS_CLEAN_FILE_COLUMN_NAME,
	DIALOGS_CLEAN_FILE_COLUMN_N_COLUMNS
} DialogsCleanFileColumn;

struct _Block21Data {
	int _ref_count_;
	GtkListStore* store;
};



GType dialogs_unsaved_doc_column_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType document_get_type (void) G_GNUC_CONST;
void dialogs_close_several_unsaved_documents (MainWindow* window, GList* unsaved_docs);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (Block20Data* _data20_);
GType document_tab_get_type (void) G_GNUC_CONST;
const gchar* document_tab_get_label_text (DocumentTab* self);
static void _lambda72_ (const gchar* path_str, Block20Data* _data20_);
static void __lambda72__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const gchar* path, gpointer self);
GtkWidget* utils_add_scrollbar (GtkWidget* child);
void main_window_remove_all_tabs (MainWindow* self);
GList* main_window_get_documents (MainWindow* self);
gboolean document_get_modified (Document* self);
gboolean main_window_close_tab (MainWindow* self, DocumentTab* tab, gboolean force_close);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
gboolean main_window_save_document (MainWindow* self, Document* doc, gboolean force_save_as);
GType dialogs_clean_file_column_get_type (void) G_GNUC_CONST;
gboolean dialogs_confirm_clean_build_files (MainWindow* window, GFile* directory, gchar** basenames, int basenames_length1);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (Block21Data* _data21_);
static void _lambda19_ (const gchar* path_str, Block21Data* _data21_);
static void __lambda19__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const gchar* path, gpointer self);
static void _vala_array_add17 (gchar*** array, int* length, int* size, gchar* value);
void utils_delete_file (GFile* file);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType dialogs_unsaved_doc_column_get_type (void) {
	static volatile gsize dialogs_unsaved_doc_column_type_id__volatile = 0;
	if (g_once_init_enter (&dialogs_unsaved_doc_column_type_id__volatile)) {
		static const GEnumValue values[] = {{DIALOGS_UNSAVED_DOC_COLUMN_SAVE, "DIALOGS_UNSAVED_DOC_COLUMN_SAVE", "save"}, {DIALOGS_UNSAVED_DOC_COLUMN_NAME, "DIALOGS_UNSAVED_DOC_COLUMN_NAME", "name"}, {DIALOGS_UNSAVED_DOC_COLUMN_DOC, "DIALOGS_UNSAVED_DOC_COLUMN_DOC", "doc"}, {DIALOGS_UNSAVED_DOC_COLUMN_N_COLUMNS, "DIALOGS_UNSAVED_DOC_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType dialogs_unsaved_doc_column_type_id;
		dialogs_unsaved_doc_column_type_id = g_enum_register_static ("DialogsUnsavedDocColumn", values);
		g_once_init_leave (&dialogs_unsaved_doc_column_type_id__volatile, dialogs_unsaved_doc_column_type_id);
	}
	return dialogs_unsaved_doc_column_type_id__volatile;
}


static Block20Data* block20_data_ref (Block20Data* _data20_) {
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}


static void block20_data_unref (Block20Data* _data20_) {
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		_g_object_unref0 (_data20_->store);
		g_slice_free (Block20Data, _data20_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda72_ (const gchar* path_str, Block20Data* _data20_) {
	GtkTreePath* _tmp0_ = NULL;
	GtkTreePath* path;
	GtkTreeIter iter = {0};
	gboolean active = FALSE;
	GtkTreeIter _tmp1_ = {0};
	g_return_if_fail (path_str != NULL);
	_tmp0_ = gtk_tree_path_new_from_string (path_str);
	path = _tmp0_;
	gtk_tree_model_get_iter ((GtkTreeModel*) _data20_->store, &_tmp1_, path);
	iter = _tmp1_;
	gtk_tree_model_get ((GtkTreeModel*) _data20_->store, &iter, DIALOGS_UNSAVED_DOC_COLUMN_SAVE, &active, -1, -1);
	gtk_list_store_set (_data20_->store, &iter, DIALOGS_UNSAVED_DOC_COLUMN_SAVE, !active, -1, -1);
	_gtk_tree_path_free0 (path);
}


static void __lambda72__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const gchar* path, gpointer self) {
	_lambda72_ (path, self);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


void dialogs_close_several_unsaved_documents (MainWindow* window, GList* unsaved_docs) {
	Block20Data* _data20_;
	guint _tmp0_;
	const gchar* _tmp1_ = NULL;
	GtkDialog* _tmp2_ = NULL;
	GtkDialog* dialog;
	GtkHBox* _tmp3_ = NULL;
	GtkHBox* hbox;
	GtkWidget* _tmp4_ = NULL;
	GtkVBox* _tmp5_;
	GtkVBox* content_area;
	GtkImage* _tmp6_ = NULL;
	GtkImage* image;
	GtkVBox* _tmp7_ = NULL;
	GtkVBox* vbox;
	GtkLabel* _tmp8_ = NULL;
	GtkLabel* primary_label;
	const gchar* _tmp9_ = NULL;
	guint _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GtkVBox* _tmp17_ = NULL;
	GtkVBox* vbox2;
	const gchar* _tmp18_ = NULL;
	GtkLabel* _tmp19_ = NULL;
	GtkLabel* select_label;
	GtkTreeView* _tmp20_ = NULL;
	GtkTreeView* treeview;
	GtkListStore* _tmp21_ = NULL;
	GtkCellRendererToggle* _tmp25_ = NULL;
	GtkCellRendererToggle* renderer1;
	GtkTreeViewColumn* _tmp26_ = NULL;
	GtkTreeViewColumn* column;
	GtkCellRendererText* _tmp27_ = NULL;
	GtkCellRendererText* renderer2;
	GtkTreeViewColumn* _tmp28_ = NULL;
	GtkWidget* _tmp29_ = NULL;
	GtkScrolledWindow* sw;
	const gchar* _tmp30_ = NULL;
	GtkLabel* _tmp31_ = NULL;
	GtkLabel* secondary_label;
	gint _tmp32_;
	gint resp;
	g_return_if_fail (window != NULL);
	_data20_ = g_slice_new0 (Block20Data);
	_data20_->_ref_count_ = 1;
	_tmp0_ = g_list_length (unsaved_docs);
	g_return_if_fail (_tmp0_ >= 2);
	_tmp1_ = _ ("Close without Saving");
	_tmp2_ = (GtkDialog*) gtk_dialog_new_with_buttons (NULL, (GtkWindow*) window, GTK_DIALOG_DESTROY_WITH_PARENT, _tmp1_, GTK_RESPONSE_CLOSE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT, NULL, NULL);
	dialog = g_object_ref_sink (_tmp2_);
	gtk_dialog_set_has_separator (dialog, FALSE);
	_tmp3_ = (GtkHBox*) gtk_hbox_new (FALSE, 12);
	hbox = g_object_ref_sink (_tmp3_);
	gtk_container_set_border_width ((GtkContainer*) hbox, (guint) 5);
	_tmp4_ = gtk_dialog_get_content_area (dialog);
	_tmp5_ = _g_object_ref0 (GTK_VBOX (_tmp4_));
	content_area = _tmp5_;
	gtk_box_pack_start ((GtkBox*) content_area, (GtkWidget*) hbox, TRUE, TRUE, (guint) 0);
	_tmp6_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_DIALOG_WARNING, GTK_ICON_SIZE_DIALOG);
	image = g_object_ref_sink (_tmp6_);
	gtk_misc_set_alignment ((GtkMisc*) image, (gfloat) 0.5, (gfloat) 0.0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
	_tmp7_ = (GtkVBox*) gtk_vbox_new (FALSE, 12);
	vbox = g_object_ref_sink (_tmp7_);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) vbox, TRUE, TRUE, (guint) 0);
	_tmp8_ = (GtkLabel*) gtk_label_new (NULL);
	primary_label = g_object_ref_sink (_tmp8_);
	gtk_label_set_line_wrap (primary_label, TRUE);
	gtk_label_set_use_markup (primary_label, TRUE);
	gtk_misc_set_alignment ((GtkMisc*) primary_label, (gfloat) 0.0, (gfloat) 0.5);
	gtk_label_set_selectable (primary_label, TRUE);
	_tmp9_ = _ ("There are %d documents with unsaved changes. Save changes before closi" \
"ng?");
	_tmp10_ = g_list_length (unsaved_docs);
	_tmp11_ = g_strdup_printf (_tmp9_, _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat ("<span weight=\"bold\" size=\"larger\">", _tmp12_, NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strconcat (_tmp14_, "</span>", NULL);
	_tmp16_ = _tmp15_;
	gtk_label_set_markup (primary_label, _tmp16_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) primary_label, FALSE, FALSE, (guint) 0);
	_tmp17_ = (GtkVBox*) gtk_vbox_new (FALSE, 8);
	vbox2 = g_object_ref_sink (_tmp17_);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) vbox2, FALSE, FALSE, (guint) 0);
	_tmp18_ = _ ("Select the documents you want to save:");
	_tmp19_ = (GtkLabel*) gtk_label_new (_tmp18_);
	select_label = g_object_ref_sink (_tmp19_);
	gtk_label_set_line_wrap (select_label, TRUE);
	gtk_misc_set_alignment ((GtkMisc*) select_label, (gfloat) 0.0, (gfloat) 0.5);
	gtk_box_pack_start ((GtkBox*) vbox2, (GtkWidget*) select_label, FALSE, FALSE, (guint) 0);
	_tmp20_ = (GtkTreeView*) gtk_tree_view_new ();
	treeview = g_object_ref_sink (_tmp20_);
	gtk_widget_set_size_request ((GtkWidget*) treeview, 260, 120);
	gtk_tree_view_set_headers_visible (treeview, FALSE);
	gtk_tree_view_set_enable_search (treeview, FALSE);
	_tmp21_ = gtk_list_store_new ((gint) DIALOGS_UNSAVED_DOC_COLUMN_N_COLUMNS, G_TYPE_BOOLEAN, G_TYPE_STRING, TYPE_DOCUMENT);
	_data20_->store = _tmp21_;
	{
		GList* doc_collection;
		GList* doc_it;
		doc_collection = unsaved_docs;
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			Document* _tmp22_;
			Document* doc;
			_tmp22_ = _g_object_ref0 ((Document*) doc_it->data);
			doc = _tmp22_;
			{
				GtkTreeIter iter = {0};
				GtkTreeIter _tmp23_ = {0};
				const gchar* _tmp24_ = NULL;
				gtk_list_store_append (_data20_->store, &_tmp23_);
				iter = _tmp23_;
				_tmp24_ = document_tab_get_label_text (doc->tab);
				gtk_list_store_set (_data20_->store, &iter, DIALOGS_UNSAVED_DOC_COLUMN_SAVE, TRUE, DIALOGS_UNSAVED_DOC_COLUMN_NAME, _tmp24_, DIALOGS_UNSAVED_DOC_COLUMN_DOC, doc, -1, -1);
				_g_object_unref0 (doc);
			}
		}
	}
	gtk_tree_view_set_model (treeview, (GtkTreeModel*) _data20_->store);
	_tmp25_ = (GtkCellRendererToggle*) gtk_cell_renderer_toggle_new ();
	renderer1 = g_object_ref_sink (_tmp25_);
	g_signal_connect_data (renderer1, "toggled", (GCallback) __lambda72__gtk_cell_renderer_toggle_toggled, block20_data_ref (_data20_), (GClosureNotify) block20_data_unref, 0);
	_tmp26_ = gtk_tree_view_column_new_with_attributes ("Save?", (GtkCellRenderer*) renderer1, "active", DIALOGS_UNSAVED_DOC_COLUMN_SAVE, NULL, NULL);
	column = g_object_ref_sink (_tmp26_);
	gtk_tree_view_append_column (treeview, column);
	_tmp27_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	renderer2 = g_object_ref_sink (_tmp27_);
	_tmp28_ = gtk_tree_view_column_new_with_attributes ("Name", (GtkCellRenderer*) renderer2, "text", DIALOGS_UNSAVED_DOC_COLUMN_NAME, NULL, NULL);
	_g_object_unref0 (column);
	column = g_object_ref_sink (_tmp28_);
	gtk_tree_view_append_column (treeview, column);
	_tmp29_ = utils_add_scrollbar ((GtkWidget*) treeview);
	sw = GTK_SCROLLED_WINDOW (_tmp29_);
	gtk_scrolled_window_set_shadow_type (sw, GTK_SHADOW_IN);
	gtk_box_pack_start ((GtkBox*) vbox2, (GtkWidget*) sw, TRUE, TRUE, (guint) 0);
	_tmp30_ = _ ("If you don't save, all your changes will be permanently lost.");
	_tmp31_ = (GtkLabel*) gtk_label_new (_tmp30_);
	secondary_label = g_object_ref_sink (_tmp31_);
	gtk_label_set_line_wrap (secondary_label, TRUE);
	gtk_misc_set_alignment ((GtkMisc*) secondary_label, (gfloat) 0.0, (gfloat) 0.5);
	gtk_label_set_selectable (secondary_label, TRUE);
	gtk_box_pack_start ((GtkBox*) vbox2, (GtkWidget*) secondary_label, FALSE, FALSE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) hbox);
	_tmp32_ = gtk_dialog_run (dialog);
	resp = _tmp32_;
	if (resp == GTK_RESPONSE_CLOSE) {
		main_window_remove_all_tabs (window);
	} else {
		if (resp == GTK_RESPONSE_ACCEPT) {
			GList* _tmp33_ = NULL;
			GList* selected_docs;
			GtkTreeIter iter = {0};
			GtkTreeIter _tmp36_ = {0};
			gboolean _tmp37_;
			gboolean valid;
			_tmp33_ = main_window_get_documents (window);
			{
				GList* doc_collection;
				GList* doc_it;
				doc_collection = _tmp33_;
				for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
					Document* _tmp34_;
					Document* doc;
					_tmp34_ = _g_object_ref0 ((Document*) doc_it->data);
					doc = _tmp34_;
					{
						gboolean _tmp35_;
						_tmp35_ = document_get_modified (doc);
						if (!_tmp35_) {
							main_window_close_tab (window, doc->tab, FALSE);
						}
						_g_object_unref0 (doc);
					}
				}
				__g_list_free__g_object_unref0_0 (doc_collection);
			}
			selected_docs = NULL;
			_tmp37_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _data20_->store, &_tmp36_);
			iter = _tmp36_;
			valid = _tmp37_;
			while (TRUE) {
				gboolean selected = FALSE;
				Document* doc = NULL;
				gboolean _tmp39_;
				if (!valid) {
					break;
				}
				gtk_tree_model_get ((GtkTreeModel*) _data20_->store, &iter, DIALOGS_UNSAVED_DOC_COLUMN_SAVE, &selected, DIALOGS_UNSAVED_DOC_COLUMN_DOC, &doc, -1, -1);
				if (selected) {
					Document* _tmp38_;
					_tmp38_ = _g_object_ref0 (doc);
					selected_docs = g_list_prepend (selected_docs, _tmp38_);
				} else {
					main_window_close_tab (window, doc->tab, TRUE);
				}
				_tmp39_ = gtk_tree_model_iter_next ((GtkTreeModel*) _data20_->store, &iter);
				valid = _tmp39_;
				_g_object_unref0 (doc);
			}
			selected_docs = g_list_reverse (selected_docs);
			{
				GList* doc_collection;
				GList* doc_it;
				doc_collection = selected_docs;
				for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
					Document* _tmp40_;
					Document* doc;
					_tmp40_ = _g_object_ref0 ((Document*) doc_it->data);
					doc = _tmp40_;
					{
						gboolean _tmp41_;
						_tmp41_ = main_window_save_document (window, doc, FALSE);
						if (_tmp41_) {
							main_window_close_tab (window, doc->tab, TRUE);
						}
						_g_object_unref0 (doc);
					}
				}
			}
			__g_list_free__g_object_unref0_0 (selected_docs);
		}
	}
	gtk_object_destroy ((GtkObject*) dialog);
	_g_object_unref0 (secondary_label);
	_g_object_unref0 (sw);
	_g_object_unref0 (renderer2);
	_g_object_unref0 (column);
	_g_object_unref0 (renderer1);
	_g_object_unref0 (treeview);
	_g_object_unref0 (select_label);
	_g_object_unref0 (vbox2);
	_g_object_unref0 (primary_label);
	_g_object_unref0 (vbox);
	_g_object_unref0 (image);
	_g_object_unref0 (content_area);
	_g_object_unref0 (hbox);
	_g_object_unref0 (dialog);
	block20_data_unref (_data20_);
	_data20_ = NULL;
}


GType dialogs_clean_file_column_get_type (void) {
	static volatile gsize dialogs_clean_file_column_type_id__volatile = 0;
	if (g_once_init_enter (&dialogs_clean_file_column_type_id__volatile)) {
		static const GEnumValue values[] = {{DIALOGS_CLEAN_FILE_COLUMN_DELETE, "DIALOGS_CLEAN_FILE_COLUMN_DELETE", "delete"}, {DIALOGS_CLEAN_FILE_COLUMN_NAME, "DIALOGS_CLEAN_FILE_COLUMN_NAME", "name"}, {DIALOGS_CLEAN_FILE_COLUMN_N_COLUMNS, "DIALOGS_CLEAN_FILE_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType dialogs_clean_file_column_type_id;
		dialogs_clean_file_column_type_id = g_enum_register_static ("DialogsCleanFileColumn", values);
		g_once_init_leave (&dialogs_clean_file_column_type_id__volatile, dialogs_clean_file_column_type_id);
	}
	return dialogs_clean_file_column_type_id__volatile;
}


static Block21Data* block21_data_ref (Block21Data* _data21_) {
	g_atomic_int_inc (&_data21_->_ref_count_);
	return _data21_;
}


static void block21_data_unref (Block21Data* _data21_) {
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
		_g_object_unref0 (_data21_->store);
		g_slice_free (Block21Data, _data21_);
	}
}


static void _lambda19_ (const gchar* path_str, Block21Data* _data21_) {
	GtkTreePath* _tmp0_ = NULL;
	GtkTreePath* path;
	GtkTreeIter iter = {0};
	gboolean active = FALSE;
	GtkTreeIter _tmp1_ = {0};
	g_return_if_fail (path_str != NULL);
	_tmp0_ = gtk_tree_path_new_from_string (path_str);
	path = _tmp0_;
	gtk_tree_model_get_iter ((GtkTreeModel*) _data21_->store, &_tmp1_, path);
	iter = _tmp1_;
	gtk_tree_model_get ((GtkTreeModel*) _data21_->store, &iter, DIALOGS_CLEAN_FILE_COLUMN_DELETE, &active, -1, -1);
	gtk_list_store_set (_data21_->store, &iter, DIALOGS_CLEAN_FILE_COLUMN_DELETE, !active, -1, -1);
	_gtk_tree_path_free0 (path);
}


static void __lambda19__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const gchar* path, gpointer self) {
	_lambda19_ (path, self);
}


static void _vala_array_add17 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gboolean dialogs_confirm_clean_build_files (MainWindow* window, GFile* directory, gchar** basenames, int basenames_length1) {
	gboolean result = FALSE;
	Block21Data* _data21_;
	GtkDialog* _tmp0_ = NULL;
	GtkDialog* dialog;
	GtkHBox* _tmp1_ = NULL;
	GtkHBox* hbox;
	GtkWidget* _tmp2_ = NULL;
	GtkVBox* _tmp3_;
	GtkVBox* content_area;
	GtkImage* _tmp4_ = NULL;
	GtkImage* image;
	GtkVBox* _tmp5_ = NULL;
	GtkVBox* vbox;
	GtkLabel* _tmp6_ = NULL;
	GtkLabel* primary_label;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GtkVBox* _tmp12_ = NULL;
	GtkVBox* vbox2;
	const gchar* _tmp13_ = NULL;
	GtkLabel* _tmp14_ = NULL;
	GtkLabel* select_label;
	GtkTreeView* _tmp15_ = NULL;
	GtkTreeView* treeview;
	GtkListStore* _tmp16_ = NULL;
	GtkCellRendererToggle* _tmp19_ = NULL;
	GtkCellRendererToggle* renderer1;
	GtkTreeViewColumn* _tmp20_ = NULL;
	GtkTreeViewColumn* column;
	GtkCellRendererText* _tmp21_ = NULL;
	GtkCellRendererText* renderer2;
	GtkTreeViewColumn* _tmp22_ = NULL;
	GtkWidget* _tmp23_ = NULL;
	GtkScrolledWindow* sw;
	gboolean ret;
	gint _tmp24_;
	g_return_val_if_fail (window != NULL, FALSE);
	g_return_val_if_fail (directory != NULL, FALSE);
	_data21_ = g_slice_new0 (Block21Data);
	_data21_->_ref_count_ = 1;
	g_return_if_fail (basenames_length1 > 0);
	_tmp0_ = (GtkDialog*) gtk_dialog_new_with_buttons (NULL, (GtkWindow*) window, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_DELETE, GTK_RESPONSE_ACCEPT, NULL, NULL);
	dialog = g_object_ref_sink (_tmp0_);
	gtk_dialog_set_has_separator (dialog, FALSE);
	_tmp1_ = (GtkHBox*) gtk_hbox_new (FALSE, 12);
	hbox = g_object_ref_sink (_tmp1_);
	gtk_container_set_border_width ((GtkContainer*) hbox, (guint) 5);
	_tmp2_ = gtk_dialog_get_content_area (dialog);
	_tmp3_ = _g_object_ref0 (GTK_VBOX (_tmp2_));
	content_area = _tmp3_;
	gtk_box_pack_start ((GtkBox*) content_area, (GtkWidget*) hbox, TRUE, TRUE, (guint) 0);
	_tmp4_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_DIALOG_WARNING, GTK_ICON_SIZE_DIALOG);
	image = g_object_ref_sink (_tmp4_);
	gtk_misc_set_alignment ((GtkMisc*) image, (gfloat) 0.5, (gfloat) 0.0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
	_tmp5_ = (GtkVBox*) gtk_vbox_new (FALSE, 12);
	vbox = g_object_ref_sink (_tmp5_);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) vbox, TRUE, TRUE, (guint) 0);
	_tmp6_ = (GtkLabel*) gtk_label_new (NULL);
	primary_label = g_object_ref_sink (_tmp6_);
	gtk_label_set_line_wrap (primary_label, TRUE);
	gtk_label_set_use_markup (primary_label, TRUE);
	gtk_misc_set_alignment ((GtkMisc*) primary_label, (gfloat) 0.0, (gfloat) 0.5);
	gtk_label_set_selectable (primary_label, TRUE);
	_tmp7_ = _ ("Do you really want to delete these files?");
	_tmp8_ = g_strconcat ("<span weight=\"bold\" size=\"larger\">", _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, "</span>", NULL);
	_tmp11_ = _tmp10_;
	gtk_label_set_markup (primary_label, _tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) primary_label, FALSE, FALSE, (guint) 0);
	_tmp12_ = (GtkVBox*) gtk_vbox_new (FALSE, 8);
	vbox2 = g_object_ref_sink (_tmp12_);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) vbox2, FALSE, FALSE, (guint) 0);
	_tmp13_ = _ ("Select the files you want to delete:");
	_tmp14_ = (GtkLabel*) gtk_label_new (_tmp13_);
	select_label = g_object_ref_sink (_tmp14_);
	gtk_label_set_line_wrap (select_label, TRUE);
	gtk_misc_set_alignment ((GtkMisc*) select_label, (gfloat) 0.0, (gfloat) 0.5);
	gtk_box_pack_start ((GtkBox*) vbox2, (GtkWidget*) select_label, FALSE, FALSE, (guint) 0);
	_tmp15_ = (GtkTreeView*) gtk_tree_view_new ();
	treeview = g_object_ref_sink (_tmp15_);
	gtk_widget_set_size_request ((GtkWidget*) treeview, 260, 120);
	gtk_tree_view_set_headers_visible (treeview, FALSE);
	gtk_tree_view_set_enable_search (treeview, FALSE);
	_tmp16_ = gtk_list_store_new ((gint) DIALOGS_CLEAN_FILE_COLUMN_N_COLUMNS, G_TYPE_BOOLEAN, G_TYPE_STRING);
	_data21_->store = _tmp16_;
	{
		gchar** basename_collection;
		int basename_collection_length1;
		int basename_it;
		basename_collection = basenames;
		basename_collection_length1 = basenames_length1;
		for (basename_it = 0; basename_it < basenames_length1; basename_it = basename_it + 1) {
			gchar* _tmp17_;
			gchar* basename;
			_tmp17_ = g_strdup (basename_collection[basename_it]);
			basename = _tmp17_;
			{
				GtkTreeIter iter = {0};
				GtkTreeIter _tmp18_ = {0};
				gtk_list_store_append (_data21_->store, &_tmp18_);
				iter = _tmp18_;
				gtk_list_store_set (_data21_->store, &iter, DIALOGS_CLEAN_FILE_COLUMN_DELETE, TRUE, DIALOGS_CLEAN_FILE_COLUMN_NAME, basename, -1, -1);
				_g_free0 (basename);
			}
		}
	}
	gtk_tree_view_set_model (treeview, (GtkTreeModel*) _data21_->store);
	_tmp19_ = (GtkCellRendererToggle*) gtk_cell_renderer_toggle_new ();
	renderer1 = g_object_ref_sink (_tmp19_);
	g_signal_connect_data (renderer1, "toggled", (GCallback) __lambda19__gtk_cell_renderer_toggle_toggled, block21_data_ref (_data21_), (GClosureNotify) block21_data_unref, 0);
	_tmp20_ = gtk_tree_view_column_new_with_attributes ("Delete?", (GtkCellRenderer*) renderer1, "active", DIALOGS_CLEAN_FILE_COLUMN_DELETE, NULL, NULL);
	column = g_object_ref_sink (_tmp20_);
	gtk_tree_view_append_column (treeview, column);
	_tmp21_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	renderer2 = g_object_ref_sink (_tmp21_);
	_tmp22_ = gtk_tree_view_column_new_with_attributes ("Name", (GtkCellRenderer*) renderer2, "text", DIALOGS_CLEAN_FILE_COLUMN_NAME, NULL, NULL);
	_g_object_unref0 (column);
	column = g_object_ref_sink (_tmp22_);
	gtk_tree_view_append_column (treeview, column);
	_tmp23_ = utils_add_scrollbar ((GtkWidget*) treeview);
	sw = GTK_SCROLLED_WINDOW (_tmp23_);
	gtk_scrolled_window_set_shadow_type (sw, GTK_SHADOW_IN);
	gtk_box_pack_start ((GtkBox*) vbox2, (GtkWidget*) sw, TRUE, TRUE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) hbox);
	ret = FALSE;
	_tmp24_ = gtk_dialog_run (dialog);
	if (_tmp24_ == GTK_RESPONSE_ACCEPT) {
		gchar** _tmp25_ = NULL;
		gchar** selected_files;
		gint selected_files_length1;
		gint _selected_files_size_;
		GtkTreeIter iter = {0};
		GtkTreeIter _tmp26_ = {0};
		gboolean _tmp27_;
		gboolean valid;
		_tmp25_ = g_new0 (gchar*, 0 + 1);
		selected_files = _tmp25_;
		selected_files_length1 = 0;
		_selected_files_size_ = 0;
		_tmp27_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _data21_->store, &_tmp26_);
		iter = _tmp26_;
		valid = _tmp27_;
		while (TRUE) {
			gboolean selected = FALSE;
			gchar* basename = NULL;
			gboolean _tmp29_;
			if (!valid) {
				break;
			}
			gtk_tree_model_get ((GtkTreeModel*) _data21_->store, &iter, DIALOGS_CLEAN_FILE_COLUMN_DELETE, &selected, DIALOGS_CLEAN_FILE_COLUMN_NAME, &basename, -1, -1);
			if (selected) {
				gchar* _tmp28_;
				_tmp28_ = g_strdup (basename);
				_vala_array_add17 (&selected_files, &selected_files_length1, &_selected_files_size_, _tmp28_);
			}
			_tmp29_ = gtk_tree_model_iter_next ((GtkTreeModel*) _data21_->store, &iter);
			valid = _tmp29_;
			_g_free0 (basename);
		}
		{
			gchar** selected_file_collection;
			int selected_file_collection_length1;
			int selected_file_it;
			selected_file_collection = selected_files;
			selected_file_collection_length1 = selected_files_length1;
			for (selected_file_it = 0; selected_file_it < selected_files_length1; selected_file_it = selected_file_it + 1) {
				gchar* _tmp30_;
				gchar* selected_file;
				_tmp30_ = g_strdup (selected_file_collection[selected_file_it]);
				selected_file = _tmp30_;
				{
					GFile* _tmp31_ = NULL;
					GFile* file;
					ret = TRUE;
					_tmp31_ = g_file_get_child (directory, selected_file);
					file = _tmp31_;
					utils_delete_file (file);
					_g_object_unref0 (file);
					_g_free0 (selected_file);
				}
			}
		}
		selected_files = (_vala_array_free (selected_files, selected_files_length1, (GDestroyNotify) g_free), NULL);
	}
	gtk_object_destroy ((GtkObject*) dialog);
	result = ret;
	_g_object_unref0 (sw);
	_g_object_unref0 (renderer2);
	_g_object_unref0 (column);
	_g_object_unref0 (renderer1);
	_g_object_unref0 (treeview);
	_g_object_unref0 (select_label);
	_g_object_unref0 (vbox2);
	_g_object_unref0 (primary_label);
	_g_object_unref0 (vbox);
	_g_object_unref0 (image);
	_g_object_unref0 (content_area);
	_g_object_unref0 (hbox);
	_g_object_unref0 (dialog);
	block21_data_unref (_data21_);
	_data21_ = NULL;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



