/* clean_build_files.c generated by valac 0.12.1, the Vala compiler
 * generated from clean_build_files.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtksourceview/gtksourceview.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdio.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>


#define TYPE_CLEAN_BUILD_FILES (clean_build_files_get_type ())
#define CLEAN_BUILD_FILES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CLEAN_BUILD_FILES, CleanBuildFiles))
#define CLEAN_BUILD_FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CLEAN_BUILD_FILES, CleanBuildFilesClass))
#define IS_CLEAN_BUILD_FILES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CLEAN_BUILD_FILES))
#define IS_CLEAN_BUILD_FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CLEAN_BUILD_FILES))
#define CLEAN_BUILD_FILES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CLEAN_BUILD_FILES, CleanBuildFilesClass))

typedef struct _CleanBuildFiles CleanBuildFiles;
typedef struct _CleanBuildFilesClass CleanBuildFilesClass;
typedef struct _CleanBuildFilesPrivate CleanBuildFilesPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define CLEAN_BUILD_FILES_TYPE_CLEAN_FILE_COLUMN (clean_build_files_clean_file_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block22Data Block22Data;
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

struct _CleanBuildFiles {
	GObject parent_instance;
	CleanBuildFilesPrivate * priv;
};

struct _CleanBuildFilesClass {
	GObjectClass parent_class;
};

struct _CleanBuildFilesPrivate {
	MainWindow* _main_window;
	Document* _doc;
	gchar** _extensions;
	gint _extensions_length1;
	gint __extensions_size_;
	gboolean _no_confirm;
};

typedef enum  {
	CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_DELETE,
	CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_NAME,
	CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_FILE,
	CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_N_COLUMNS
} CleanBuildFilesCleanFileColumn;

struct _Project {
	GFile* directory;
	GFile* main_file;
};

struct _Block22Data {
	int _ref_count_;
	CleanBuildFiles * self;
	GtkListStore* store;
};


static gpointer clean_build_files_parent_class = NULL;

GType clean_build_files_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType document_get_type (void) G_GNUC_CONST;
#define CLEAN_BUILD_FILES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CLEAN_BUILD_FILES, CleanBuildFilesPrivate))
enum  {
	CLEAN_BUILD_FILES_DUMMY_PROPERTY
};
static GType clean_build_files_clean_file_column_get_type (void) G_GNUC_UNUSED;
CleanBuildFiles* clean_build_files_new (MainWindow* main_window, Document* doc);
CleanBuildFiles* clean_build_files_construct (GType object_type, MainWindow* main_window, Document* doc);
gboolean clean_build_files_clean (CleanBuildFiles* self);
gboolean document_is_main_file_a_tex_file (Document* self);
GType project_get_type (void) G_GNUC_CONST;
Project* project_dup (const Project* self);
void project_free (Project* self);
void project_copy (const Project* self, Project* dest);
void project_destroy (Project* self);
Project* document_get_project (Document* self);
static GeeArrayList* clean_build_files_get_build_files_in_directory (CleanBuildFiles* self, GFile* directory);
GFile* document_get_location (Document* self);
static GeeArrayList* clean_build_files_get_build_files_simple (CleanBuildFiles* self);
static void clean_build_files_show_info_no_file (CleanBuildFiles* self);
void utils_delete_file (GFile* file);
static gboolean clean_build_files_confirm_cleanup (CleanBuildFiles* self, GeeArrayList* files_to_delete, GFile* directory);
gchar* utils_get_shortname (const gchar* path);
gchar* utils_get_extension (const gchar* path);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static GtkTreeView* clean_build_files_get_list_files (CleanBuildFiles* self, GeeArrayList* files_to_delete, GFile* directory);
static GtkDialog* clean_build_files_get_dialog (CleanBuildFiles* self, GtkTreeView* list_files);
static gboolean clean_build_files_run_dialog (CleanBuildFiles* self, GtkDialog* dialog, GtkTreeModel* list_store);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (Block22Data* _data22_);
static gint clean_build_files_on_sort_list_files (CleanBuildFiles* self, GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b);
static gint _clean_build_files_on_sort_list_files_gtk_tree_iter_compare_func (GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer self);
gchar* utils_get_relative_path (GFile* origin, GFile* target, GFile* common_dir);
static void _lambda33_ (const gchar* path_str, Block22Data* _data22_);
static void __lambda33__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const gchar* path, gpointer self);
GtkWidget* utils_add_scrollbar (GtkWidget* child);
static void _vala_array_add18 (GFile*** array, int* length, int* size, GFile* value);
static void clean_build_files_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static GType clean_build_files_clean_file_column_get_type (void) {
	static volatile gsize clean_build_files_clean_file_column_type_id__volatile = 0;
	if (g_once_init_enter (&clean_build_files_clean_file_column_type_id__volatile)) {
		static const GEnumValue values[] = {{CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_DELETE, "CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_DELETE", "delete"}, {CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_NAME, "CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_NAME", "name"}, {CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_FILE, "CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_FILE", "file"}, {CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_N_COLUMNS, "CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType clean_build_files_clean_file_column_type_id;
		clean_build_files_clean_file_column_type_id = g_enum_register_static ("CleanBuildFilesCleanFileColumn", values);
		g_once_init_leave (&clean_build_files_clean_file_column_type_id__volatile, clean_build_files_clean_file_column_type_id);
	}
	return clean_build_files_clean_file_column_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


CleanBuildFiles* clean_build_files_construct (GType object_type, MainWindow* main_window, Document* doc) {
	CleanBuildFiles * self = NULL;
	Document* _tmp0_;
	GSettings* _tmp1_ = NULL;
	GSettings* settings;
	gchar* _tmp2_ = NULL;
	gchar* exts;
	gchar** _tmp3_;
	gchar** _tmp4_ = NULL;
	gboolean _tmp5_;
	g_return_val_if_fail (main_window != NULL, NULL);
	g_return_val_if_fail (doc != NULL, NULL);
	self = (CleanBuildFiles*) g_object_new (object_type, NULL);
	self->priv->_main_window = main_window;
	_tmp0_ = _g_object_ref0 (doc);
	_g_object_unref0 (self->priv->_doc);
	self->priv->_doc = _tmp0_;
	_tmp1_ = g_settings_new ("org.gnome.latexila.preferences.latex");
	settings = _tmp1_;
	_tmp2_ = g_settings_get_string (settings, "clean-extensions");
	exts = _tmp2_;
	_tmp4_ = _tmp3_ = g_strsplit (exts, " ", 0);
	self->priv->_extensions = (_vala_array_free (self->priv->_extensions, self->priv->_extensions_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_extensions = _tmp4_;
	self->priv->_extensions_length1 = _vala_array_length (_tmp3_);
	self->priv->__extensions_size_ = _vala_array_length (_tmp3_);
	_tmp5_ = g_settings_get_boolean (settings, "no-confirm-clean");
	self->priv->_no_confirm = _tmp5_;
	_g_free0 (exts);
	_g_object_unref0 (settings);
	return self;
}


CleanBuildFiles* clean_build_files_new (MainWindow* main_window, Document* doc) {
	return clean_build_files_construct (TYPE_CLEAN_BUILD_FILES, main_window, doc);
}


gboolean clean_build_files_clean (CleanBuildFiles* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	GeeArrayList* files_to_delete = NULL;
	GFile* directory = NULL;
	Project* _tmp1_ = NULL;
	Project* project;
	gint _tmp7_;
	gboolean _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = document_is_main_file_a_tex_file (self->priv->_doc);
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = document_get_project (self->priv->_doc);
	project = _tmp1_;
	if (project != NULL) {
		GFile* _tmp2_;
		GeeArrayList* _tmp3_ = NULL;
		_tmp2_ = _g_object_ref0 ((*project).directory);
		_g_object_unref0 (directory);
		directory = _tmp2_;
		_tmp3_ = clean_build_files_get_build_files_in_directory (self, directory);
		_g_object_unref0 (files_to_delete);
		files_to_delete = _tmp3_;
	} else {
		GFile* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
		GeeArrayList* _tmp6_ = NULL;
		_tmp4_ = document_get_location (self->priv->_doc);
		_tmp5_ = g_file_get_parent (_tmp4_);
		_g_object_unref0 (directory);
		directory = _tmp5_;
		_tmp6_ = clean_build_files_get_build_files_simple (self);
		_g_object_unref0 (files_to_delete);
		files_to_delete = _tmp6_;
	}
	_tmp7_ = gee_collection_get_size ((GeeCollection*) files_to_delete);
	if (_tmp7_ == 0) {
		if (!self->priv->_no_confirm) {
			clean_build_files_show_info_no_file (self);
		}
		result = FALSE;
		_project_free0 (project);
		_g_object_unref0 (directory);
		_g_object_unref0 (files_to_delete);
		return result;
	}
	if (self->priv->_no_confirm) {
		{
			GeeArrayList* _tmp8_;
			GeeArrayList* _file_to_delete_list;
			gint _tmp9_;
			gint _file_to_delete_size;
			gint _file_to_delete_index;
			_tmp8_ = _g_object_ref0 (files_to_delete);
			_file_to_delete_list = _tmp8_;
			_tmp9_ = gee_collection_get_size ((GeeCollection*) _file_to_delete_list);
			_file_to_delete_size = _tmp9_;
			_file_to_delete_index = -1;
			while (TRUE) {
				gpointer _tmp10_ = NULL;
				GFile* file_to_delete;
				_file_to_delete_index = _file_to_delete_index + 1;
				if (!(_file_to_delete_index < _file_to_delete_size)) {
					break;
				}
				_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _file_to_delete_list, _file_to_delete_index);
				file_to_delete = (GFile*) _tmp10_;
				utils_delete_file (file_to_delete);
				_g_object_unref0 (file_to_delete);
			}
			_g_object_unref0 (_file_to_delete_list);
		}
		result = TRUE;
		_project_free0 (project);
		_g_object_unref0 (directory);
		_g_object_unref0 (files_to_delete);
		return result;
	}
	_tmp11_ = clean_build_files_confirm_cleanup (self, files_to_delete, directory);
	result = _tmp11_;
	_project_free0 (project);
	_g_object_unref0 (directory);
	_g_object_unref0 (files_to_delete);
	return result;
}


static GeeArrayList* clean_build_files_get_build_files_simple (CleanBuildFiles* self) {
	GeeArrayList* result = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_;
	GFile* location;
	GFile* _tmp2_ = NULL;
	GFile* directory;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* shortname;
	GeeArrayList* _tmp7_ = NULL;
	GeeArrayList* files_to_delete;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = document_get_location (self->priv->_doc);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	location = _tmp1_;
	_tmp2_ = g_file_get_parent (location);
	directory = _tmp2_;
	_tmp3_ = g_file_get_basename (location);
	_tmp4_ = _tmp3_;
	_tmp5_ = utils_get_shortname (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	shortname = _tmp6_;
	_tmp7_ = gee_array_list_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	files_to_delete = _tmp7_;
	{
		gchar** extension_collection;
		int extension_collection_length1;
		int extension_it;
		extension_collection = self->priv->_extensions;
		extension_collection_length1 = self->priv->_extensions_length1;
		for (extension_it = 0; extension_it < self->priv->_extensions_length1; extension_it = extension_it + 1) {
			gchar* _tmp8_;
			gchar* extension;
			_tmp8_ = g_strdup (extension_collection[extension_it]);
			extension = _tmp8_;
			{
				gchar* _tmp9_;
				gchar* basename;
				GFile* _tmp10_ = NULL;
				GFile* file;
				gboolean _tmp11_;
				_tmp9_ = g_strconcat (shortname, extension, NULL);
				basename = _tmp9_;
				_tmp10_ = g_file_get_child (directory, basename);
				file = _tmp10_;
				_tmp11_ = g_file_query_exists (file, NULL);
				if (_tmp11_) {
					gee_abstract_collection_add ((GeeAbstractCollection*) files_to_delete, file);
				}
				_g_object_unref0 (file);
				_g_free0 (basename);
				_g_free0 (extension);
			}
		}
	}
	result = files_to_delete;
	_g_free0 (shortname);
	_g_object_unref0 (directory);
	_g_object_unref0 (location);
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static GeeArrayList* clean_build_files_get_build_files_in_directory (CleanBuildFiles* self, GFile* directory) {
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* files_to_delete;
	GFileEnumerator* enumerator = NULL;
	GFileEnumerator* _tmp1_ = NULL;
	GFileEnumerator* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (directory != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	files_to_delete = _tmp0_;
	_tmp1_ = g_file_enumerate_children (directory, "standard::type,standard::name", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		goto __catch54_g_error;
	}
	_g_object_unref0 (enumerator);
	enumerator = _tmp2_;
	goto __finally54;
	__catch54_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "Error: clean build files: %s\n", e->message);
		result = files_to_delete;
		_g_error_free0 (e);
		_g_object_unref0 (enumerator);
		return result;
	}
	__finally54:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (enumerator);
		_g_object_unref0 (files_to_delete);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	while (TRUE) {
		GFileInfo* info;
		GFileInfo* _tmp3_ = NULL;
		GFileInfo* _tmp4_;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* name;
		gchar _tmp7_;
		GFile* _tmp8_ = NULL;
		GFile* file;
		GFileType _tmp9_;
		GFileType type;
		gchar* _tmp11_ = NULL;
		gchar* extension;
		info = NULL;
		_tmp3_ = g_file_enumerator_next_file (enumerator, NULL, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			goto __catch55_g_error;
		}
		_g_object_unref0 (info);
		info = _tmp4_;
		goto __finally55;
		__catch55_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			fprintf (stderr, "Error: clean build files: %s\n", e->message);
			_g_error_free0 (e);
			_g_object_unref0 (info);
			break;
		}
		__finally55:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (info);
			_g_object_unref0 (enumerator);
			_g_object_unref0 (files_to_delete);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		if (info == NULL) {
			_g_object_unref0 (info);
			break;
		}
		_tmp5_ = g_file_info_get_name (info);
		_tmp6_ = g_strdup (_tmp5_);
		name = _tmp6_;
		_tmp7_ = string_get (name, (glong) 0);
		if (_tmp7_ == '.') {
			_g_free0 (name);
			_g_object_unref0 (info);
			continue;
		}
		_tmp8_ = g_file_get_child (directory, name);
		file = _tmp8_;
		_tmp9_ = g_file_info_get_file_type (info);
		type = _tmp9_;
		if (type == G_FILE_TYPE_DIRECTORY) {
			GeeArrayList* _tmp10_ = NULL;
			GeeArrayList* files_to_delete_in_dir;
			_tmp10_ = clean_build_files_get_build_files_in_directory (self, file);
			files_to_delete_in_dir = _tmp10_;
			gee_abstract_collection_add_all ((GeeAbstractCollection*) files_to_delete, (GeeCollection*) files_to_delete_in_dir);
			_g_object_unref0 (files_to_delete_in_dir);
			_g_object_unref0 (file);
			_g_free0 (name);
			_g_object_unref0 (info);
			continue;
		}
		_tmp11_ = utils_get_extension (name);
		extension = _tmp11_;
		if (_vala_string_array_contains (self->priv->_extensions, self->priv->_extensions_length1, extension)) {
			gee_abstract_collection_add ((GeeAbstractCollection*) files_to_delete, file);
		}
		_g_free0 (extension);
		_g_object_unref0 (file);
		_g_free0 (name);
		_g_object_unref0 (info);
	}
	result = files_to_delete;
	_g_object_unref0 (enumerator);
	return result;
}


static gboolean clean_build_files_confirm_cleanup (CleanBuildFiles* self, GeeArrayList* files_to_delete, GFile* directory) {
	gboolean result = FALSE;
	gint _tmp0_;
	GtkTreeView* _tmp1_ = NULL;
	GtkTreeView* list_files;
	GtkDialog* _tmp2_ = NULL;
	GtkDialog* dialog;
	GtkTreeModel* _tmp3_ = NULL;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (files_to_delete != NULL, FALSE);
	g_return_val_if_fail (directory != NULL, FALSE);
	_tmp0_ = gee_collection_get_size ((GeeCollection*) files_to_delete);
	g_return_val_if_fail (0 < _tmp0_, FALSE);
	_tmp1_ = clean_build_files_get_list_files (self, files_to_delete, directory);
	list_files = _tmp1_;
	_tmp2_ = clean_build_files_get_dialog (self, list_files);
	dialog = _tmp2_;
	_tmp3_ = gtk_tree_view_get_model (list_files);
	_tmp4_ = clean_build_files_run_dialog (self, dialog, _tmp3_);
	result = _tmp4_;
	_g_object_unref0 (dialog);
	_g_object_unref0 (list_files);
	return result;
}


static Block22Data* block22_data_ref (Block22Data* _data22_) {
	g_atomic_int_inc (&_data22_->_ref_count_);
	return _data22_;
}


static void block22_data_unref (Block22Data* _data22_) {
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
		_g_object_unref0 (_data22_->self);
		_g_object_unref0 (_data22_->store);
		g_slice_free (Block22Data, _data22_);
	}
}


static gint _clean_build_files_on_sort_list_files_gtk_tree_iter_compare_func (GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer self) {
	gint result;
	result = clean_build_files_on_sort_list_files (self, model, a, b);
	return result;
}


static void _lambda33_ (const gchar* path_str, Block22Data* _data22_) {
	CleanBuildFiles * self;
	GtkTreePath* _tmp0_ = NULL;
	GtkTreePath* path;
	GtkTreeIter iter = {0};
	gboolean active = FALSE;
	GtkTreeIter _tmp1_ = {0};
	self = _data22_->self;
	g_return_if_fail (path_str != NULL);
	_tmp0_ = gtk_tree_path_new_from_string (path_str);
	path = _tmp0_;
	gtk_tree_model_get_iter ((GtkTreeModel*) _data22_->store, &_tmp1_, path);
	iter = _tmp1_;
	gtk_tree_model_get ((GtkTreeModel*) _data22_->store, &iter, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_DELETE, &active, -1, -1);
	gtk_list_store_set (_data22_->store, &iter, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_DELETE, !active, -1, -1);
	_gtk_tree_path_free0 (path);
}


static void __lambda33__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const gchar* path, gpointer self) {
	_lambda33_ (path, self);
}


static GtkTreeView* clean_build_files_get_list_files (CleanBuildFiles* self, GeeArrayList* files_to_delete, GFile* directory) {
	GtkTreeView* result = NULL;
	Block22Data* _data22_;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeView* treeview;
	GtkListStore* _tmp1_ = NULL;
	GtkCellRendererToggle* _tmp7_ = NULL;
	GtkCellRendererToggle* toggle_renderer;
	GtkTreeViewColumn* _tmp8_ = NULL;
	GtkTreeViewColumn* column;
	GtkCellRendererText* _tmp9_ = NULL;
	GtkCellRendererText* text_renderer;
	GtkTreeViewColumn* _tmp10_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (files_to_delete != NULL, NULL);
	g_return_val_if_fail (directory != NULL, NULL);
	_data22_ = g_slice_new0 (Block22Data);
	_data22_->_ref_count_ = 1;
	_data22_->self = g_object_ref (self);
	_tmp0_ = (GtkTreeView*) gtk_tree_view_new ();
	treeview = g_object_ref_sink (_tmp0_);
	gtk_widget_set_size_request ((GtkWidget*) treeview, 260, 120);
	gtk_tree_view_set_headers_visible (treeview, FALSE);
	gtk_tree_view_set_enable_search (treeview, FALSE);
	_tmp1_ = gtk_list_store_new ((gint) CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_N_COLUMNS, G_TYPE_BOOLEAN, G_TYPE_STRING, G_TYPE_FILE);
	_data22_->store = _tmp1_;
	gtk_tree_sortable_set_sort_func ((GtkTreeSortable*) _data22_->store, 0, _clean_build_files_on_sort_list_files_gtk_tree_iter_compare_func, g_object_ref (self), g_object_unref);
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _data22_->store, 0, GTK_SORT_ASCENDING);
	{
		GeeArrayList* _tmp2_;
		GeeArrayList* _file_to_delete_list;
		gint _tmp3_;
		gint _file_to_delete_size;
		gint _file_to_delete_index;
		_tmp2_ = _g_object_ref0 (files_to_delete);
		_file_to_delete_list = _tmp2_;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _file_to_delete_list);
		_file_to_delete_size = _tmp3_;
		_file_to_delete_index = -1;
		while (TRUE) {
			gpointer _tmp4_ = NULL;
			GFile* file_to_delete;
			gchar* _tmp5_ = NULL;
			gchar* relative_path;
			GtkTreeIter iter = {0};
			GtkTreeIter _tmp6_ = {0};
			_file_to_delete_index = _file_to_delete_index + 1;
			if (!(_file_to_delete_index < _file_to_delete_size)) {
				break;
			}
			_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) _file_to_delete_list, _file_to_delete_index);
			file_to_delete = (GFile*) _tmp4_;
			_tmp5_ = utils_get_relative_path (directory, file_to_delete, directory);
			relative_path = _tmp5_;
			gtk_list_store_append (_data22_->store, &_tmp6_);
			iter = _tmp6_;
			gtk_list_store_set (_data22_->store, &iter, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_DELETE, TRUE, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_NAME, relative_path, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_FILE, file_to_delete, -1, -1);
			_g_free0 (relative_path);
			_g_object_unref0 (file_to_delete);
		}
		_g_object_unref0 (_file_to_delete_list);
	}
	gtk_tree_view_set_model (treeview, (GtkTreeModel*) _data22_->store);
	_tmp7_ = (GtkCellRendererToggle*) gtk_cell_renderer_toggle_new ();
	toggle_renderer = g_object_ref_sink (_tmp7_);
	g_signal_connect_data (toggle_renderer, "toggled", (GCallback) __lambda33__gtk_cell_renderer_toggle_toggled, block22_data_ref (_data22_), (GClosureNotify) block22_data_unref, 0);
	_tmp8_ = gtk_tree_view_column_new_with_attributes ("Delete?", (GtkCellRenderer*) toggle_renderer, "active", CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_DELETE, NULL, NULL);
	column = g_object_ref_sink (_tmp8_);
	gtk_tree_view_append_column (treeview, column);
	_tmp9_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	text_renderer = g_object_ref_sink (_tmp9_);
	_tmp10_ = gtk_tree_view_column_new_with_attributes ("Name", (GtkCellRenderer*) text_renderer, "text", CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_NAME, NULL, NULL);
	_g_object_unref0 (column);
	column = g_object_ref_sink (_tmp10_);
	gtk_tree_view_append_column (treeview, column);
	result = treeview;
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (column);
	_g_object_unref0 (toggle_renderer);
	block22_data_unref (_data22_);
	_data22_ = NULL;
	return result;
}


static GtkDialog* clean_build_files_get_dialog (CleanBuildFiles* self, GtkTreeView* list_files) {
	GtkDialog* result = NULL;
	GtkDialog* _tmp0_ = NULL;
	GtkDialog* dialog;
	GtkHBox* _tmp1_ = NULL;
	GtkHBox* hbox;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_;
	GtkVBox* _tmp4_;
	GtkVBox* content_area;
	GtkImage* _tmp5_ = NULL;
	GtkImage* image;
	GtkVBox* _tmp6_ = NULL;
	GtkVBox* vbox;
	GtkLabel* _tmp7_ = NULL;
	GtkLabel* primary_label;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GtkVBox* _tmp13_ = NULL;
	GtkVBox* vbox2;
	const gchar* _tmp14_ = NULL;
	GtkLabel* _tmp15_ = NULL;
	GtkLabel* select_label;
	GtkWidget* _tmp16_ = NULL;
	GtkWidget* _tmp17_;
	GtkScrolledWindow* sw;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (list_files != NULL, NULL);
	_tmp0_ = (GtkDialog*) gtk_dialog_new_with_buttons (NULL, (GtkWindow*) self->priv->_main_window, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_DELETE, GTK_RESPONSE_ACCEPT, NULL, NULL);
	dialog = g_object_ref_sink (_tmp0_);
	gtk_dialog_set_has_separator (dialog, FALSE);
	_tmp1_ = (GtkHBox*) gtk_hbox_new (FALSE, 12);
	hbox = g_object_ref_sink (_tmp1_);
	gtk_container_set_border_width ((GtkContainer*) hbox, (guint) 5);
	_tmp2_ = gtk_dialog_get_content_area (dialog);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (GTK_IS_VBOX (_tmp3_) ? ((GtkVBox*) _tmp3_) : NULL);
	content_area = _tmp4_;
	gtk_box_pack_start ((GtkBox*) content_area, (GtkWidget*) hbox, TRUE, TRUE, (guint) 0);
	_tmp5_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_DIALOG_WARNING, GTK_ICON_SIZE_DIALOG);
	image = g_object_ref_sink (_tmp5_);
	gtk_misc_set_alignment ((GtkMisc*) image, (gfloat) 0.5, (gfloat) 0.0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
	_tmp6_ = (GtkVBox*) gtk_vbox_new (FALSE, 12);
	vbox = g_object_ref_sink (_tmp6_);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) vbox, TRUE, TRUE, (guint) 0);
	_tmp7_ = (GtkLabel*) gtk_label_new (NULL);
	primary_label = g_object_ref_sink (_tmp7_);
	gtk_label_set_line_wrap (primary_label, TRUE);
	gtk_label_set_use_markup (primary_label, TRUE);
	gtk_misc_set_alignment ((GtkMisc*) primary_label, (gfloat) 0.0, (gfloat) 0.5);
	gtk_label_set_selectable (primary_label, TRUE);
	_tmp8_ = _ ("Do you really want to delete these files?");
	_tmp9_ = g_strconcat ("<span weight=\"bold\" size=\"larger\">", _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat (_tmp10_, "</span>", NULL);
	_tmp12_ = _tmp11_;
	gtk_label_set_markup (primary_label, _tmp12_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) primary_label, FALSE, FALSE, (guint) 0);
	_tmp13_ = (GtkVBox*) gtk_vbox_new (FALSE, 8);
	vbox2 = g_object_ref_sink (_tmp13_);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) vbox2, TRUE, TRUE, (guint) 0);
	_tmp14_ = _ ("Select the files you want to delete:");
	_tmp15_ = (GtkLabel*) gtk_label_new (_tmp14_);
	select_label = g_object_ref_sink (_tmp15_);
	gtk_label_set_line_wrap (select_label, TRUE);
	gtk_misc_set_alignment ((GtkMisc*) select_label, (gfloat) 0.0, (gfloat) 0.5);
	gtk_box_pack_start ((GtkBox*) vbox2, (GtkWidget*) select_label, FALSE, FALSE, (guint) 0);
	_tmp16_ = utils_add_scrollbar ((GtkWidget*) list_files);
	_tmp17_ = _tmp16_;
	sw = GTK_IS_SCROLLED_WINDOW (_tmp17_) ? ((GtkScrolledWindow*) _tmp17_) : NULL;
	gtk_scrolled_window_set_shadow_type (sw, GTK_SHADOW_IN);
	gtk_box_pack_start ((GtkBox*) vbox2, (GtkWidget*) sw, TRUE, TRUE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) hbox);
	result = dialog;
	_g_object_unref0 (sw);
	_g_object_unref0 (select_label);
	_g_object_unref0 (vbox2);
	_g_object_unref0 (primary_label);
	_g_object_unref0 (vbox);
	_g_object_unref0 (image);
	_g_object_unref0 (content_area);
	_g_object_unref0 (hbox);
	return result;
}


static void _vala_array_add18 (GFile*** array, int* length, int* size, GFile* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean clean_build_files_run_dialog (CleanBuildFiles* self, GtkDialog* dialog, GtkTreeModel* list_store) {
	gboolean result = FALSE;
	gboolean ret;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dialog != NULL, FALSE);
	g_return_val_if_fail (list_store != NULL, FALSE);
	ret = FALSE;
	_tmp0_ = gtk_dialog_run (dialog);
	if (_tmp0_ == GTK_RESPONSE_ACCEPT) {
		GFile** _tmp1_ = NULL;
		GFile** selected_files;
		gint selected_files_length1;
		gint _selected_files_size_;
		GtkTreeIter iter = {0};
		GtkTreeIter _tmp2_ = {0};
		gboolean _tmp3_;
		gboolean valid;
		_tmp1_ = g_new0 (GFile*, 0 + 1);
		selected_files = _tmp1_;
		selected_files_length1 = 0;
		_selected_files_size_ = 0;
		_tmp3_ = gtk_tree_model_get_iter_first (list_store, &_tmp2_);
		iter = _tmp2_;
		valid = _tmp3_;
		while (TRUE) {
			gboolean selected = FALSE;
			GFile* file_to_delete = NULL;
			gboolean _tmp5_;
			if (!valid) {
				break;
			}
			gtk_tree_model_get (list_store, &iter, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_DELETE, &selected, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_FILE, &file_to_delete, -1, -1);
			if (selected) {
				GFile* _tmp4_;
				_tmp4_ = _g_object_ref0 (file_to_delete);
				_vala_array_add18 (&selected_files, &selected_files_length1, &_selected_files_size_, _tmp4_);
			}
			_tmp5_ = gtk_tree_model_iter_next (list_store, &iter);
			valid = _tmp5_;
			_g_object_unref0 (file_to_delete);
		}
		ret = 0 < selected_files_length1;
		{
			GFile** file_to_delete_collection;
			int file_to_delete_collection_length1;
			int file_to_delete_it;
			file_to_delete_collection = selected_files;
			file_to_delete_collection_length1 = selected_files_length1;
			for (file_to_delete_it = 0; file_to_delete_it < selected_files_length1; file_to_delete_it = file_to_delete_it + 1) {
				GFile* _tmp6_;
				GFile* file_to_delete;
				_tmp6_ = _g_object_ref0 (file_to_delete_collection[file_to_delete_it]);
				file_to_delete = _tmp6_;
				{
					utils_delete_file (file_to_delete);
					_g_object_unref0 (file_to_delete);
				}
			}
		}
		selected_files = (_vala_array_free (selected_files, selected_files_length1, (GDestroyNotify) g_object_unref), NULL);
	}
	gtk_object_destroy ((GtkObject*) dialog);
	result = ret;
	return result;
}


static gint clean_build_files_on_sort_list_files (CleanBuildFiles* self, GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b) {
	gint result = 0;
	gchar* name_a = NULL;
	gchar* name_b = NULL;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (model != NULL, 0);
	gtk_tree_model_get (model, a, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_NAME, &name_a, -1, -1);
	gtk_tree_model_get (model, b, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_NAME, &name_b, -1, -1);
	_tmp0_ = g_utf8_collate (name_a, name_b);
	result = _tmp0_;
	_g_free0 (name_b);
	_g_free0 (name_a);
	return result;
}


static void clean_build_files_show_info_no_file (CleanBuildFiles* self) {
	const gchar* _tmp0_ = NULL;
	GtkMessageDialog* _tmp1_ = NULL;
	GtkDialog* dialog;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("No build file to clean up.");
	_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self->priv->_main_window, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, _tmp0_);
	dialog = (GtkDialog*) g_object_ref_sink (_tmp1_);
	gtk_dialog_run (dialog);
	gtk_object_destroy ((GtkObject*) dialog);
	_g_object_unref0 (dialog);
}


static void clean_build_files_class_init (CleanBuildFilesClass * klass) {
	clean_build_files_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CleanBuildFilesPrivate));
	G_OBJECT_CLASS (klass)->finalize = clean_build_files_finalize;
}


static void clean_build_files_instance_init (CleanBuildFiles * self) {
	self->priv = CLEAN_BUILD_FILES_GET_PRIVATE (self);
}


static void clean_build_files_finalize (GObject* obj) {
	CleanBuildFiles * self;
	self = CLEAN_BUILD_FILES (obj);
	_g_object_unref0 (self->priv->_doc);
	self->priv->_extensions = (_vala_array_free (self->priv->_extensions, self->priv->_extensions_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (clean_build_files_parent_class)->finalize (obj);
}


GType clean_build_files_get_type (void) {
	static volatile gsize clean_build_files_type_id__volatile = 0;
	if (g_once_init_enter (&clean_build_files_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CleanBuildFilesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clean_build_files_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CleanBuildFiles), 0, (GInstanceInitFunc) clean_build_files_instance_init, NULL };
		GType clean_build_files_type_id;
		clean_build_files_type_id = g_type_register_static (G_TYPE_OBJECT, "CleanBuildFiles", &g_define_type_info, 0);
		g_once_init_leave (&clean_build_files_type_id__volatile, clean_build_files_type_id);
	}
	return clean_build_files_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



