/* preferences_dialog.c generated by valac 0.12.1, the Vala compiler
 * generated from preferences_dialog.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <gtksourceview/gtksourcestyleschememanager.h>
#include <gtksourceview/gtksourceview.h>
#include <gee.h>


#define TYPE_PREFERENCES_DIALOG (preferences_dialog_get_type ())
#define PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialog))
#define PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))
#define IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES_DIALOG))
#define IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES_DIALOG))
#define PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))

typedef struct _PreferencesDialog PreferencesDialog;
typedef struct _PreferencesDialogClass PreferencesDialogClass;
typedef struct _PreferencesDialogPrivate PreferencesDialogPrivate;

#define PREFERENCES_DIALOG_TYPE_STYLE_SCHEMES (preferences_dialog_style_schemes_get_type ())

#define PREFERENCES_DIALOG_TYPE_BUILD_TOOL_COLUMN (preferences_dialog_build_tool_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _Block1Data Block1Data;

#define TYPE_APP_SETTINGS (app_settings_get_type ())
#define APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_SETTINGS, AppSettings))
#define APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_SETTINGS, AppSettingsClass))
#define IS_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_SETTINGS))
#define IS_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_SETTINGS))
#define APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_SETTINGS, AppSettingsClass))

typedef struct _AppSettings AppSettings;
typedef struct _AppSettingsClass AppSettingsClass;
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
typedef struct _Block2Data Block2Data;

#define TYPE_BUILD_TOOLS (build_tools_get_type ())
#define BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOLS, BuildTools))
#define BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOLS, BuildToolsClass))
#define IS_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOLS))
#define IS_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOLS))
#define BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOLS, BuildToolsClass))

typedef struct _BuildTools BuildTools;
typedef struct _BuildToolsClass BuildToolsClass;

#define TYPE_BUILD_TOOL (build_tool_get_type ())

#define TYPE_BUILD_JOB (build_job_get_type ())

#define TYPE_POST_PROCESSOR_TYPE (post_processor_type_get_type ())
typedef struct _BuildJob BuildJob;
typedef struct _BuildTool BuildTool;
#define _build_tool_free0(var) ((var == NULL) ? NULL : (var = (build_tool_free (var), NULL)))
#define _build_tools_unref0(var) ((var == NULL) ? NULL : (var = (build_tools_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block5Data Block5Data;

struct _PreferencesDialog {
	GtkDialog parent_instance;
	PreferencesDialogPrivate * priv;
};

struct _PreferencesDialogClass {
	GtkDialogClass parent_class;
};

struct _PreferencesDialogPrivate {
	GtkListStore* build_tools_store;
};

typedef enum  {
	PREFERENCES_DIALOG_STYLE_SCHEMES_ID,
	PREFERENCES_DIALOG_STYLE_SCHEMES_DESC,
	PREFERENCES_DIALOG_STYLE_SCHEMES_N_COLUMNS
} PreferencesDialogStyleSchemes;

typedef enum  {
	PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_SHOW,
	PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_PIXBUF,
	PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_LABEL,
	PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_DESCRIPTION,
	PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_N_COLUMNS
} PreferencesDialogBuildToolColumn;

typedef const gchar* (*PreferencesDialogPlural) (gulong n, void* user_data);
struct _Block1Data {
	int _ref_count_;
	PreferencesDialog * self;
	GSettings* settings;
	GtkButton* default_font_checkbutton;
	GtkTreeView* schemes_treeview;
};

struct _Block2Data {
	int _ref_count_;
	PreferencesDialog * self;
	GtkTreeView* build_tools_view;
};

typedef enum  {
	POST_PROCESSOR_TYPE_ALL_OUTPUT = 0,
	POST_PROCESSOR_TYPE_LATEX,
	POST_PROCESSOR_TYPE_LATEXMK,
	POST_PROCESSOR_TYPE_NO_OUTPUT,
	POST_PROCESSOR_TYPE_RUBBER,
	POST_PROCESSOR_TYPE_N_POST_PROCESSORS
} PostProcessorType;

struct _BuildJob {
	gboolean must_succeed;
	PostProcessorType post_processor;
	gchar* command;
};

struct _BuildTool {
	gchar* description;
	gchar* extensions;
	gchar* label;
	gchar* icon;
	gboolean show;
	gboolean compilation;
	GList* jobs;
};

struct _Block3Data {
	int _ref_count_;
	PreferencesDialog * self;
	GtkWidget* widget;
	gboolean must_be_enabled;
};

struct _Block4Data {
	int _ref_count_;
	PreferencesDialog * self;
	GtkLabel* label;
	PreferencesDialogPlural plural;
	gpointer plural_target;
};

struct _Block5Data {
	int _ref_count_;
	PreferencesDialog * self;
	GtkTreeViewColumn* label_column;
};


static gpointer preferences_dialog_parent_class = NULL;
static PreferencesDialog* preferences_dialog_preferences_dialog;
static PreferencesDialog* preferences_dialog_preferences_dialog = NULL;

GType preferences_dialog_get_type (void) G_GNUC_CONST;
#define PREFERENCES_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PREFERENCES_DIALOG, PreferencesDialogPrivate))
enum  {
	PREFERENCES_DIALOG_DUMMY_PROPERTY
};
static GType preferences_dialog_style_schemes_get_type (void) G_GNUC_UNUSED;
static GType preferences_dialog_build_tool_column_get_type (void) G_GNUC_UNUSED;
static PreferencesDialog* preferences_dialog_new (void);
static PreferencesDialog* preferences_dialog_construct (GType object_type);
static void _lambda0_ (gint response_id, PreferencesDialog* self);
static void preferences_dialog_reset_all (PreferencesDialog* self);
static void __lambda0__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void preferences_dialog_init_editor_tab (PreferencesDialog* self, GtkBuilder* builder);
static void preferences_dialog_init_font_and_colors_tab (PreferencesDialog* self, GtkBuilder* builder);
static void preferences_dialog_init_latex_tab (PreferencesDialog* self, GtkBuilder* builder);
static void preferences_dialog_init_other_tab (PreferencesDialog* self, GtkBuilder* builder);
GType main_window_get_type (void) G_GNUC_CONST;
void preferences_dialog_show_me (MainWindow* parent);
static void _lambda85_ (void);
static void __lambda85__gtk_object_destroy (GtkObject* _sender, gpointer self);
static GtkDialog* preferences_dialog_get_reset_all_confirm_dialog (PreferencesDialog* self, const gchar* msg);
static void preferences_dialog_set_spin_button_range (PreferencesDialog* self, GtkSpinButton* spin_button, GSettings* settings, const gchar* key);
static void preferences_dialog_set_sensitivity (PreferencesDialog* self, GSettings* settings, const gchar* key, GtkWidget* widget, gboolean must_be_enabled);
static void preferences_dialog_set_plural (PreferencesDialog* self, GtkLabel* label, GSettings* settings, const gchar* key, PreferencesDialogPlural plural, void* plural_target);
static const gchar* _lambda3_ (gulong n, PreferencesDialog* self);
static const gchar* __lambda3__preferences_dialog_plural (gulong n, gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void preferences_dialog_set_system_font_label (PreferencesDialog* self, GtkButton* button);
GType app_settings_get_type (void) G_GNUC_CONST;
AppSettings* app_settings_get_default (void);
static void _lambda113_ (Block1Data* _data1_);
static void __lambda113__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void preferences_dialog_init_schemes_treeview (PreferencesDialog* self, GtkTreeView* treeview, const gchar* current_id);
static void _lambda114_ (GtkTreeView* treeview, Block1Data* _data1_);
static void __lambda114__gtk_tree_view_cursor_changed (GtkTreeView* _sender, gpointer self);
static void _lambda115_ (GSettings* setting, const gchar* key, Block1Data* _data1_);
static void __lambda115__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static const gchar* _lambda116_ (gulong n, PreferencesDialog* self);
static const gchar* __lambda116__preferences_dialog_plural (gulong n, gpointer self);
static void preferences_dialog_init_build_tools_treeview (PreferencesDialog* self, GtkTreeView* build_tools_view);
static void _lambda126_ (Block2Data* _data2_);
gint utils_get_selected_row (GtkTreeView* view, GtkTreeIter* iter);
static void preferences_dialog_run_build_tool_dialog (PreferencesDialog* self, gint num);
static void __lambda126__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda127_ (PreferencesDialog* self);
static void __lambda127__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda128_ (Block2Data* _data2_);
gpointer build_tools_ref (gpointer instance);
void build_tools_unref (gpointer instance);
GParamSpec* param_spec_build_tools (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_build_tools (GValue* value, gpointer v_object);
void value_take_build_tools (GValue* value, gpointer v_object);
gpointer value_get_build_tools (const GValue* value);
GType build_tools_get_type (void) G_GNUC_CONST;
BuildTools* build_tools_get_default (void);
GType build_tool_get_type (void) G_GNUC_CONST;
GType build_job_get_type (void) G_GNUC_CONST;
GType post_processor_type_get_type (void) G_GNUC_CONST;
BuildJob* build_job_dup (const BuildJob* self);
void build_job_free (BuildJob* self);
void build_job_copy (const BuildJob* self, BuildJob* dest);
void build_job_destroy (BuildJob* self);
BuildTool* build_tool_dup (const BuildTool* self);
void build_tool_free (BuildTool* self);
void build_tool_copy (const BuildTool* self, BuildTool* dest);
void build_tool_destroy (BuildTool* self);
BuildTool* build_tools_get (BuildTools* self, gint id);
void build_tools_insert (BuildTools* self, gint pos, BuildTool* tool);
static void preferences_dialog_update_build_tools_store (PreferencesDialog* self);
static void __lambda128__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda129_ (Block2Data* _data2_);
gboolean utils_tree_model_iter_prev (GtkTreeModel* model, GtkTreeIter* iter);
void build_tools_move_up (BuildTools* self, gint num);
static void __lambda129__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda130_ (Block2Data* _data2_);
void build_tools_move_down (BuildTools* self, gint num);
static void __lambda130__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda131_ (Block2Data* _data2_);
void build_tools_delete (BuildTools* self, gint num);
static void __lambda131__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda132_ (PreferencesDialog* self);
void build_tools_reset_all (BuildTools* self);
static void __lambda132__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static void _lambda1_ (GSettings* setting, const gchar* k, Block3Data* _data3_);
static void __lambda1__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
const gchar* app_settings_get_system_font (AppSettings* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
static void _lambda2_ (GSettings* setting, const gchar* k, Block4Data* _data4_);
static void __lambda2__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
static void _lambda117_ (const gchar* path_string, PreferencesDialog* self);
void build_tools_update (BuildTools* self, gint num, BuildTool* tool, gboolean keep_show);
static void __lambda117__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const gchar* path, gpointer self);
static void _lambda118_ (GtkTreePath* path, GtkTreeViewColumn* column, Block5Data* _data5_);
static void __lambda118__gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
GeeIterator* build_tools_iterator (BuildTools* self);
gboolean build_tool_dialog_show_me (GtkWindow* parent, gint num);
static void preferences_dialog_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static GType preferences_dialog_style_schemes_get_type (void) {
	static volatile gsize preferences_dialog_style_schemes_type_id__volatile = 0;
	if (g_once_init_enter (&preferences_dialog_style_schemes_type_id__volatile)) {
		static const GEnumValue values[] = {{PREFERENCES_DIALOG_STYLE_SCHEMES_ID, "PREFERENCES_DIALOG_STYLE_SCHEMES_ID", "id"}, {PREFERENCES_DIALOG_STYLE_SCHEMES_DESC, "PREFERENCES_DIALOG_STYLE_SCHEMES_DESC", "desc"}, {PREFERENCES_DIALOG_STYLE_SCHEMES_N_COLUMNS, "PREFERENCES_DIALOG_STYLE_SCHEMES_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType preferences_dialog_style_schemes_type_id;
		preferences_dialog_style_schemes_type_id = g_enum_register_static ("PreferencesDialogStyleSchemes", values);
		g_once_init_leave (&preferences_dialog_style_schemes_type_id__volatile, preferences_dialog_style_schemes_type_id);
	}
	return preferences_dialog_style_schemes_type_id__volatile;
}


static GType preferences_dialog_build_tool_column_get_type (void) {
	static volatile gsize preferences_dialog_build_tool_column_type_id__volatile = 0;
	if (g_once_init_enter (&preferences_dialog_build_tool_column_type_id__volatile)) {
		static const GEnumValue values[] = {{PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_SHOW, "PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_SHOW", "show"}, {PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_PIXBUF, "PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_PIXBUF", "pixbuf"}, {PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_LABEL, "PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_LABEL", "label"}, {PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_DESCRIPTION, "PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_DESCRIPTION", "description"}, {PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_N_COLUMNS, "PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType preferences_dialog_build_tool_column_type_id;
		preferences_dialog_build_tool_column_type_id = g_enum_register_static ("PreferencesDialogBuildToolColumn", values);
		g_once_init_leave (&preferences_dialog_build_tool_column_type_id__volatile, preferences_dialog_build_tool_column_type_id);
	}
	return preferences_dialog_build_tool_column_type_id__volatile;
}


static void _lambda0_ (gint response_id, PreferencesDialog* self) {
	switch (response_id) {
		case GTK_RESPONSE_CLOSE:
		{
			gtk_widget_hide ((GtkWidget*) self);
			return;
		}
		case GTK_RESPONSE_APPLY:
		{
			preferences_dialog_reset_all (self);
			return;
		}
		default:
		break;
	}
}


static void __lambda0__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	_lambda0_ (response_id, self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static PreferencesDialog* preferences_dialog_construct (GType object_type) {
	PreferencesDialog * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	GtkButton* reset_button;
	GtkImage* _tmp3_ = NULL;
	GtkImage* image;
	const gchar* _tmp4_ = NULL;
	GtkBuilder* _tmp5_ = NULL;
	GtkBuilder* builder;
	gchar* _tmp6_ = NULL;
	gchar* ui_path;
	GObject* _tmp11_ = NULL;
	GtkNotebook* _tmp12_;
	GtkNotebook* notebook;
	GtkWidget* _tmp13_ = NULL;
	GtkBox* _tmp14_;
	GtkBox* content_area;
	GError * _inner_error_ = NULL;
	self = (PreferencesDialog*) g_object_new (object_type, NULL);
	_tmp0_ = _ ("Preferences");
	gtk_window_set_title ((GtkWindow*) self, _tmp0_);
	gtk_dialog_set_has_separator ((GtkDialog*) self, FALSE);
	gtk_window_set_destroy_with_parent ((GtkWindow*) self, TRUE);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 5);
	_tmp1_ = _ ("Reset All");
	_tmp2_ = (GtkButton*) gtk_button_new_with_label (_tmp1_);
	reset_button = g_object_ref_sink (_tmp2_);
	_tmp3_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_CLEAR, GTK_ICON_SIZE_MENU);
	image = g_object_ref_sink (_tmp3_);
	gtk_button_set_image (reset_button, (GtkWidget*) image);
	_tmp4_ = _ ("Reset all preferences");
	gtk_widget_set_tooltip_text ((GtkWidget*) reset_button, _tmp4_);
	gtk_widget_show_all ((GtkWidget*) reset_button);
	gtk_dialog_add_action_widget ((GtkDialog*) self, (GtkWidget*) reset_button, (gint) GTK_RESPONSE_APPLY);
	gtk_dialog_add_button ((GtkDialog*) self, GTK_STOCK_CLOSE, (gint) GTK_RESPONSE_CLOSE);
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) __lambda0__gtk_dialog_response, self, 0);
	_tmp5_ = gtk_builder_new ();
	builder = _tmp5_;
	_tmp6_ = g_build_filename (DATA_DIR, "ui", "preferences_dialog.ui", NULL);
	ui_path = _tmp6_;
	gtk_builder_add_from_file (builder, ui_path, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (ui_path);
		goto __catch0_g_error;
	}
	_g_free0 (ui_path);
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		gchar* _tmp7_ = NULL;
		gchar* message;
		GtkLabel* _tmp8_ = NULL;
		GtkLabel* label_error;
		GtkWidget* _tmp9_ = NULL;
		GtkBox* _tmp10_;
		GtkBox* content_area;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = g_strdup_printf ("Error: %s", e->message);
		message = _tmp7_;
		g_warning ("preferences_dialog.vala:74: %s", message);
		_tmp8_ = (GtkLabel*) gtk_label_new (message);
		label_error = g_object_ref_sink (_tmp8_);
		gtk_label_set_line_wrap (label_error, TRUE);
		_tmp9_ = gtk_dialog_get_content_area ((GtkDialog*) self);
		_tmp10_ = _g_object_ref0 (GTK_BOX (_tmp9_));
		content_area = _tmp10_;
		gtk_box_pack_start (content_area, (GtkWidget*) label_error, TRUE, TRUE, (guint) 0);
		gtk_widget_show_all ((GtkWidget*) content_area);
		_g_object_unref0 (content_area);
		_g_object_unref0 (label_error);
		_g_free0 (message);
		_g_error_free0 (e);
		_g_object_unref0 (builder);
		_g_object_unref0 (image);
		_g_object_unref0 (reset_button);
		return self;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		_g_object_unref0 (image);
		_g_object_unref0 (reset_button);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	preferences_dialog_init_editor_tab (self, builder);
	preferences_dialog_init_font_and_colors_tab (self, builder);
	preferences_dialog_init_latex_tab (self, builder);
	preferences_dialog_init_other_tab (self, builder);
	_tmp11_ = gtk_builder_get_object (builder, "notebook");
	_tmp12_ = _g_object_ref0 (GTK_NOTEBOOK (_tmp11_));
	notebook = _tmp12_;
	_tmp13_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp14_ = _g_object_ref0 (GTK_BOX (_tmp13_));
	content_area = _tmp14_;
	gtk_box_pack_start (content_area, (GtkWidget*) notebook, TRUE, TRUE, (guint) 0);
	_g_object_unref0 (content_area);
	_g_object_unref0 (notebook);
	_g_object_unref0 (builder);
	_g_object_unref0 (image);
	_g_object_unref0 (reset_button);
	return self;
}


static PreferencesDialog* preferences_dialog_new (void) {
	return preferences_dialog_construct (TYPE_PREFERENCES_DIALOG);
}


static void _lambda85_ (void) {
	if (preferences_dialog_preferences_dialog != NULL) {
		_g_object_unref0 (preferences_dialog_preferences_dialog);
		preferences_dialog_preferences_dialog = NULL;
	}
}


static void __lambda85__gtk_object_destroy (GtkObject* _sender, gpointer self) {
	_lambda85_ ();
}


void preferences_dialog_show_me (MainWindow* parent) {
	GtkWindow* _tmp1_ = NULL;
	g_return_if_fail (parent != NULL);
	if (preferences_dialog_preferences_dialog == NULL) {
		PreferencesDialog* _tmp0_ = NULL;
		_tmp0_ = preferences_dialog_new ();
		_g_object_unref0 (preferences_dialog_preferences_dialog);
		preferences_dialog_preferences_dialog = g_object_ref_sink (_tmp0_);
		g_signal_connect ((GtkObject*) preferences_dialog_preferences_dialog, "destroy", (GCallback) __lambda85__gtk_object_destroy, NULL);
	}
	_tmp1_ = gtk_window_get_transient_for ((GtkWindow*) preferences_dialog_preferences_dialog);
	if (GTK_WINDOW (parent) != _tmp1_) {
		gtk_window_set_transient_for ((GtkWindow*) preferences_dialog_preferences_dialog, (GtkWindow*) parent);
	}
	gtk_window_present ((GtkWindow*) preferences_dialog_preferences_dialog);
}


static void preferences_dialog_reset_all (PreferencesDialog* self) {
	const gchar* _tmp0_ = NULL;
	GtkDialog* _tmp1_ = NULL;
	GtkDialog* dialog;
	gint _tmp2_;
	gint resp;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_ = NULL;
	gchar** settings_str;
	gint settings_str_length1;
	gint _settings_str_size_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("Do you really want to reset all preferences?");
	_tmp1_ = preferences_dialog_get_reset_all_confirm_dialog (self, _tmp0_);
	dialog = _tmp1_;
	_tmp2_ = gtk_dialog_run (dialog);
	resp = _tmp2_;
	gtk_object_destroy ((GtkObject*) dialog);
	if (resp != GTK_RESPONSE_YES) {
		_g_object_unref0 (dialog);
		return;
	}
	_tmp3_ = g_strdup ("org.gnome.latexila.preferences.editor");
	_tmp4_ = g_strdup ("org.gnome.latexila.preferences.latex");
	_tmp5_ = g_strdup ("org.gnome.latexila.preferences.file-browser");
	_tmp6_ = g_new0 (gchar*, 3 + 1);
	_tmp6_[0] = _tmp3_;
	_tmp6_[1] = _tmp4_;
	_tmp6_[2] = _tmp5_;
	settings_str = _tmp6_;
	settings_str_length1 = 3;
	_settings_str_size_ = 3;
	{
		gchar** setting_str_collection;
		int setting_str_collection_length1;
		int setting_str_it;
		setting_str_collection = settings_str;
		setting_str_collection_length1 = settings_str_length1;
		for (setting_str_it = 0; setting_str_it < settings_str_length1; setting_str_it = setting_str_it + 1) {
			gchar* _tmp7_;
			gchar* setting_str;
			_tmp7_ = g_strdup (setting_str_collection[setting_str_it]);
			setting_str = _tmp7_;
			{
				GSettings* _tmp8_ = NULL;
				GSettings* settings;
				gchar** _tmp9_;
				gchar** _tmp10_ = NULL;
				gchar** keys;
				gint keys_length1;
				gint _keys_size_;
				_tmp8_ = g_settings_new (setting_str);
				settings = _tmp8_;
				_tmp10_ = _tmp9_ = g_settings_list_keys (settings);
				keys = _tmp10_;
				keys_length1 = _vala_array_length (_tmp9_);
				_keys_size_ = _vala_array_length (_tmp9_);
				{
					gchar** key_collection;
					int key_collection_length1;
					int key_it;
					key_collection = keys;
					key_collection_length1 = keys_length1;
					for (key_it = 0; key_it < keys_length1; key_it = key_it + 1) {
						gchar* _tmp11_;
						gchar* key;
						_tmp11_ = g_strdup (key_collection[key_it]);
						key = _tmp11_;
						{
							g_settings_reset (settings, key);
							_g_free0 (key);
						}
					}
				}
				keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (settings);
				_g_free0 (setting_str);
			}
		}
	}
	settings_str = (_vala_array_free (settings_str, settings_str_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (dialog);
}


static const gchar* _lambda3_ (gulong n, PreferencesDialog* self) {
	const gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	_tmp0_ = ngettext ("minute", "minutes", n);
	result = _tmp0_;
	return result;
}


static const gchar* __lambda3__preferences_dialog_plural (gulong n, gpointer self) {
	const gchar* result;
	result = _lambda3_ (n, self);
	return result;
}


static void preferences_dialog_init_editor_tab (PreferencesDialog* self, GtkBuilder* builder) {
	GSettings* _tmp0_ = NULL;
	GSettings* settings;
	GObject* _tmp1_ = NULL;
	GObject* _tmp2_;
	GObject* display_line_nb_checkbutton;
	GObject* _tmp3_ = NULL;
	GObject* _tmp4_;
	GtkSpinButton* _tmp5_;
	GtkSpinButton* tab_width_spinbutton;
	GObject* _tmp6_ = NULL;
	GObject* _tmp7_;
	GObject* insert_spaces_checkbutton;
	GObject* _tmp8_ = NULL;
	GObject* _tmp9_;
	GtkWidget* _tmp10_;
	GtkWidget* forget_no_tabs;
	GObject* _tmp11_ = NULL;
	GObject* _tmp12_;
	GObject* hl_current_line_checkbutton;
	GObject* _tmp13_ = NULL;
	GObject* _tmp14_;
	GObject* bracket_matching_checkbutton;
	GObject* _tmp15_ = NULL;
	GObject* _tmp16_;
	GObject* backup_checkbutton;
	GObject* _tmp17_ = NULL;
	GObject* _tmp18_;
	GObject* autosave_checkbutton;
	GObject* _tmp19_ = NULL;
	GObject* _tmp20_;
	GtkSpinButton* _tmp21_;
	GtkSpinButton* autosave_spinbutton;
	GObject* _tmp22_ = NULL;
	GObject* _tmp23_;
	GtkLabel* _tmp24_;
	GtkLabel* autosave_label;
	GObject* _tmp25_ = NULL;
	GObject* _tmp26_;
	GObject* reopen_checkbutton;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_tmp0_ = g_settings_new ("org.gnome.latexila.preferences.editor");
	settings = _tmp0_;
	_tmp1_ = gtk_builder_get_object (builder, "display_line_nb_checkbutton");
	_tmp2_ = _g_object_ref0 (_tmp1_);
	display_line_nb_checkbutton = _tmp2_;
	g_settings_bind (settings, "display-line-numbers", display_line_nb_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp3_ = gtk_builder_get_object (builder, "tab_width_spinbutton");
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (GTK_IS_SPIN_BUTTON (_tmp4_) ? ((GtkSpinButton*) _tmp4_) : NULL);
	tab_width_spinbutton = _tmp5_;
	preferences_dialog_set_spin_button_range (self, tab_width_spinbutton, settings, "tabs-size");
	g_settings_bind (settings, "tabs-size", tab_width_spinbutton, "value", G_SETTINGS_BIND_DEFAULT);
	_tmp6_ = gtk_builder_get_object (builder, "insert_spaces_checkbutton");
	_tmp7_ = _g_object_ref0 (_tmp6_);
	insert_spaces_checkbutton = _tmp7_;
	g_settings_bind (settings, "insert-spaces", insert_spaces_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp8_ = gtk_builder_get_object (builder, "forget_no_tabs");
	_tmp9_ = _tmp8_;
	_tmp10_ = _g_object_ref0 (GTK_IS_WIDGET (_tmp9_) ? ((GtkWidget*) _tmp9_) : NULL);
	forget_no_tabs = _tmp10_;
	g_settings_bind (settings, "forget-no-tabs", forget_no_tabs, "active", G_SETTINGS_BIND_DEFAULT);
	preferences_dialog_set_sensitivity (self, settings, "insert-spaces", forget_no_tabs, TRUE);
	_tmp11_ = gtk_builder_get_object (builder, "hl_current_line_checkbutton");
	_tmp12_ = _g_object_ref0 (_tmp11_);
	hl_current_line_checkbutton = _tmp12_;
	g_settings_bind (settings, "highlight-current-line", hl_current_line_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp13_ = gtk_builder_get_object (builder, "bracket_matching_checkbutton");
	_tmp14_ = _g_object_ref0 (_tmp13_);
	bracket_matching_checkbutton = _tmp14_;
	g_settings_bind (settings, "bracket-matching", bracket_matching_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp15_ = gtk_builder_get_object (builder, "backup_checkbutton");
	_tmp16_ = _g_object_ref0 (_tmp15_);
	backup_checkbutton = _tmp16_;
	g_settings_bind (settings, "create-backup-copy", backup_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp17_ = gtk_builder_get_object (builder, "autosave_checkbutton");
	_tmp18_ = _g_object_ref0 (_tmp17_);
	autosave_checkbutton = _tmp18_;
	g_settings_bind (settings, "auto-save", autosave_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp19_ = gtk_builder_get_object (builder, "autosave_spinbutton");
	_tmp20_ = _tmp19_;
	_tmp21_ = _g_object_ref0 (GTK_IS_SPIN_BUTTON (_tmp20_) ? ((GtkSpinButton*) _tmp20_) : NULL);
	autosave_spinbutton = _tmp21_;
	preferences_dialog_set_spin_button_range (self, autosave_spinbutton, settings, "auto-save-interval");
	g_settings_bind (settings, "auto-save-interval", autosave_spinbutton, "value", G_SETTINGS_BIND_DEFAULT);
	preferences_dialog_set_sensitivity (self, settings, "auto-save", (GtkWidget*) autosave_spinbutton, TRUE);
	_tmp22_ = gtk_builder_get_object (builder, "autosave_label");
	_tmp23_ = _tmp22_;
	_tmp24_ = _g_object_ref0 (GTK_IS_LABEL (_tmp23_) ? ((GtkLabel*) _tmp23_) : NULL);
	autosave_label = _tmp24_;
	preferences_dialog_set_plural (self, autosave_label, settings, "auto-save-interval", __lambda3__preferences_dialog_plural, self);
	_tmp25_ = gtk_builder_get_object (builder, "reopen_checkbutton");
	_tmp26_ = _g_object_ref0 (_tmp25_);
	reopen_checkbutton = _tmp26_;
	g_settings_bind (settings, "reopen-files", reopen_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (reopen_checkbutton);
	_g_object_unref0 (autosave_label);
	_g_object_unref0 (autosave_spinbutton);
	_g_object_unref0 (autosave_checkbutton);
	_g_object_unref0 (backup_checkbutton);
	_g_object_unref0 (bracket_matching_checkbutton);
	_g_object_unref0 (hl_current_line_checkbutton);
	_g_object_unref0 (forget_no_tabs);
	_g_object_unref0 (insert_spaces_checkbutton);
	_g_object_unref0 (tab_width_spinbutton);
	_g_object_unref0 (display_line_nb_checkbutton);
	_g_object_unref0 (settings);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->schemes_treeview);
		_g_object_unref0 (_data1_->default_font_checkbutton);
		_g_object_unref0 (_data1_->settings);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _lambda113_ (Block1Data* _data1_) {
	PreferencesDialog * self;
	self = _data1_->self;
	preferences_dialog_set_system_font_label (self, _data1_->default_font_checkbutton);
}


static void __lambda113__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda113_ (self);
}


static void _lambda114_ (GtkTreeView* treeview, Block1Data* _data1_) {
	PreferencesDialog * self;
	GtkTreePath* tree_path = NULL;
	GtkTreeIter iter = {0};
	GtkTreePath* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* model;
	GtkTreeIter _tmp3_ = {0};
	gchar* id = NULL;
	self = _data1_->self;
	g_return_if_fail (treeview != NULL);
	gtk_tree_view_get_cursor (_data1_->schemes_treeview, &_tmp0_, NULL);
	_gtk_tree_path_free0 (tree_path);
	tree_path = _tmp0_;
	_tmp1_ = gtk_tree_view_get_model (treeview);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	model = _tmp2_;
	gtk_tree_model_get_iter (model, &_tmp3_, tree_path);
	iter = _tmp3_;
	gtk_tree_model_get (model, &iter, PREFERENCES_DIALOG_STYLE_SCHEMES_ID, &id, -1, -1);
	g_settings_set_string (_data1_->settings, "scheme", id);
	_g_free0 (id);
	_g_object_unref0 (model);
	_gtk_tree_path_free0 (tree_path);
}


static void __lambda114__gtk_tree_view_cursor_changed (GtkTreeView* _sender, gpointer self) {
	_lambda114_ (_sender, self);
}


static void _lambda115_ (GSettings* setting, const gchar* key, Block1Data* _data1_) {
	PreferencesDialog * self;
	gchar* _tmp0_ = NULL;
	gchar* val;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* model;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_;
	gboolean valid;
	self = _data1_->self;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = g_settings_get_string (setting, key);
	val = _tmp0_;
	_tmp1_ = gtk_tree_view_get_model (_data1_->schemes_treeview);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	model = _tmp2_;
	_tmp4_ = gtk_tree_model_get_iter_first (model, &_tmp3_);
	iter = _tmp3_;
	valid = _tmp4_;
	while (TRUE) {
		gchar* scheme = NULL;
		gboolean _tmp7_;
		if (!valid) {
			break;
		}
		gtk_tree_model_get (model, &iter, PREFERENCES_DIALOG_STYLE_SCHEMES_ID, &scheme, -1, -1);
		if (g_strcmp0 (scheme, val) == 0) {
			GtkTreeSelection* _tmp5_ = NULL;
			GtkTreeSelection* _tmp6_;
			GtkTreeSelection* select;
			_tmp5_ = gtk_tree_view_get_selection (_data1_->schemes_treeview);
			_tmp6_ = _g_object_ref0 (_tmp5_);
			select = _tmp6_;
			gtk_tree_selection_select_iter (select, &iter);
			_g_object_unref0 (select);
			_g_free0 (scheme);
			_g_object_unref0 (model);
			_g_free0 (val);
			return;
		}
		_tmp7_ = gtk_tree_model_iter_next (model, &iter);
		valid = _tmp7_;
		_g_free0 (scheme);
	}
	_g_object_unref0 (model);
	_g_free0 (val);
}


static void __lambda115__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	_lambda115_ (_sender, key, self);
}


static void preferences_dialog_init_font_and_colors_tab (PreferencesDialog* self, GtkBuilder* builder) {
	Block1Data* _data1_;
	GSettings* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	GObject* _tmp2_;
	GtkButton* _tmp3_;
	AppSettings* _tmp4_ = NULL;
	AppSettings* app_settings;
	GObject* _tmp5_ = NULL;
	GObject* _tmp6_;
	GObject* font_button;
	GObject* _tmp7_ = NULL;
	GObject* _tmp8_;
	GtkWidget* _tmp9_;
	GtkWidget* font_hbox;
	GObject* _tmp10_ = NULL;
	GObject* _tmp11_;
	GtkTreeView* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* current_scheme_id;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = g_settings_new ("org.gnome.latexila.preferences.editor");
	_data1_->settings = _tmp0_;
	_tmp1_ = gtk_builder_get_object (builder, "default_font_checkbutton");
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp2_) ? ((GtkButton*) _tmp2_) : NULL);
	_data1_->default_font_checkbutton = _tmp3_;
	g_settings_bind (_data1_->settings, "use-default-font", _data1_->default_font_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	preferences_dialog_set_system_font_label (self, _data1_->default_font_checkbutton);
	_tmp4_ = app_settings_get_default ();
	app_settings = _tmp4_;
	g_signal_connect_data ((GObject*) app_settings, "notify::system-font", (GCallback) __lambda113__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp5_ = gtk_builder_get_object (builder, "font_button");
	_tmp6_ = _g_object_ref0 (_tmp5_);
	font_button = _tmp6_;
	g_settings_bind (_data1_->settings, "editor-font", font_button, "font-name", G_SETTINGS_BIND_DEFAULT);
	_tmp7_ = gtk_builder_get_object (builder, "font_hbox");
	_tmp8_ = _tmp7_;
	_tmp9_ = _g_object_ref0 (GTK_IS_WIDGET (_tmp8_) ? ((GtkWidget*) _tmp8_) : NULL);
	font_hbox = _tmp9_;
	preferences_dialog_set_sensitivity (self, _data1_->settings, "use-default-font", font_hbox, FALSE);
	_tmp10_ = gtk_builder_get_object (builder, "schemes_treeview");
	_tmp11_ = _tmp10_;
	_tmp12_ = _g_object_ref0 (GTK_IS_TREE_VIEW (_tmp11_) ? ((GtkTreeView*) _tmp11_) : NULL);
	_data1_->schemes_treeview = _tmp12_;
	_tmp13_ = g_settings_get_string (_data1_->settings, "scheme");
	current_scheme_id = _tmp13_;
	preferences_dialog_init_schemes_treeview (self, _data1_->schemes_treeview, current_scheme_id);
	g_signal_connect_data (_data1_->schemes_treeview, "cursor-changed", (GCallback) __lambda114__gtk_tree_view_cursor_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	g_signal_connect_data (_data1_->settings, "changed::scheme", (GCallback) __lambda115__g_settings_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_g_free0 (current_scheme_id);
	_g_object_unref0 (font_hbox);
	_g_object_unref0 (font_button);
	_g_object_unref0 (app_settings);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_object_unref0 (_data2_->build_tools_view);
		g_slice_free (Block2Data, _data2_);
	}
}


static const gchar* _lambda116_ (gulong n, PreferencesDialog* self) {
	const gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	_tmp0_ = ngettext ("character", "characters", n);
	result = _tmp0_;
	return result;
}


static const gchar* __lambda116__preferences_dialog_plural (gulong n, gpointer self) {
	const gchar* result;
	result = _lambda116_ (n, self);
	return result;
}


static void _lambda126_ (Block2Data* _data2_) {
	PreferencesDialog * self;
	gint _tmp0_;
	gint num;
	self = _data2_->self;
	_tmp0_ = utils_get_selected_row (_data2_->build_tools_view, NULL);
	num = _tmp0_;
	if (0 <= num) {
		preferences_dialog_run_build_tool_dialog (self, num);
	}
}


static void __lambda126__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda126_ (self);
}


static void _lambda127_ (PreferencesDialog* self) {
	preferences_dialog_run_build_tool_dialog (self, -1);
}


static void __lambda127__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda127_ (self);
}


static void _lambda128_ (Block2Data* _data2_) {
	PreferencesDialog * self;
	gint _tmp0_;
	gint selected_row;
	BuildTools* _tmp1_ = NULL;
	BuildTools* build_tools;
	BuildTool* _tmp2_ = NULL;
	BuildTool* tool;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	self = _data2_->self;
	_tmp0_ = utils_get_selected_row (_data2_->build_tools_view, NULL);
	selected_row = _tmp0_;
	if (selected_row < 0) {
		return;
	}
	_tmp1_ = build_tools_get_default ();
	build_tools = _tmp1_;
	_tmp2_ = build_tools_get (build_tools, selected_row);
	tool = _tmp2_;
	g_return_if_fail (tool != NULL);
	(*tool).show = FALSE;
	_tmp3_ = _ ("%s [copy]");
	_tmp4_ = g_strdup_printf (_tmp3_, (*tool).label);
	_g_free0 ((*tool).label);
	(*tool).label = _tmp4_;
	build_tools_insert (build_tools, selected_row + 1, tool);
	preferences_dialog_update_build_tools_store (self);
	_build_tool_free0 (tool);
	_build_tools_unref0 (build_tools);
}


static void __lambda128__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda128_ (self);
}


static void _lambda129_ (Block2Data* _data2_) {
	PreferencesDialog * self;
	GtkTreeIter iter1 = {0};
	GtkTreeIter iter2 = {0};
	GtkTreeIter _tmp0_ = {0};
	gint _tmp1_;
	gint i;
	gboolean _tmp2_ = FALSE;
	self = _data2_->self;
	_tmp1_ = utils_get_selected_row (_data2_->build_tools_view, &_tmp0_);
	iter1 = _tmp0_;
	i = _tmp1_;
	if (i != (-1)) {
		_tmp2_ = i > 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp3_;
		iter2 = iter1;
		_tmp3_ = utils_tree_model_iter_prev ((GtkTreeModel*) self->priv->build_tools_store, &iter2);
		if (_tmp3_) {
			BuildTools* _tmp4_ = NULL;
			BuildTools* _tmp5_;
			gtk_list_store_swap (self->priv->build_tools_store, &iter1, &iter2);
			_tmp4_ = build_tools_get_default ();
			_tmp5_ = _tmp4_;
			build_tools_move_up (_tmp5_, i);
			_build_tools_unref0 (_tmp5_);
		}
	}
}


static void __lambda129__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda129_ (self);
}


static void _lambda130_ (Block2Data* _data2_) {
	PreferencesDialog * self;
	GtkTreeIter iter1 = {0};
	GtkTreeIter iter2 = {0};
	GtkTreeIter _tmp0_ = {0};
	gint _tmp1_;
	gint i;
	self = _data2_->self;
	_tmp1_ = utils_get_selected_row (_data2_->build_tools_view, &_tmp0_);
	iter1 = _tmp0_;
	i = _tmp1_;
	if (i != (-1)) {
		gboolean _tmp2_;
		iter2 = iter1;
		_tmp2_ = gtk_tree_model_iter_next ((GtkTreeModel*) self->priv->build_tools_store, &iter2);
		if (_tmp2_) {
			BuildTools* _tmp3_ = NULL;
			BuildTools* _tmp4_;
			gtk_list_store_swap (self->priv->build_tools_store, &iter1, &iter2);
			_tmp3_ = build_tools_get_default ();
			_tmp4_ = _tmp3_;
			build_tools_move_down (_tmp4_, i);
			_build_tools_unref0 (_tmp4_);
		}
	}
}


static void __lambda130__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda130_ (self);
}


static void _lambda131_ (Block2Data* _data2_) {
	PreferencesDialog * self;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gint _tmp1_;
	gint selected_row;
	gchar* label = NULL;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* model;
	const gchar* _tmp3_ = NULL;
	GtkMessageDialog* _tmp4_ = NULL;
	GtkDialog* dialog;
	gint _tmp5_;
	self = _data2_->self;
	_tmp1_ = utils_get_selected_row (_data2_->build_tools_view, &_tmp0_);
	iter = _tmp0_;
	selected_row = _tmp1_;
	if (selected_row == (-1)) {
		return;
	}
	_tmp2_ = _g_object_ref0 (GTK_TREE_MODEL (self->priv->build_tools_store));
	model = _tmp2_;
	gtk_tree_model_get (model, &iter, PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_LABEL, &label, -1, -1);
	_tmp3_ = _ ("Do you really want to delete the build tool \"%s\"?");
	_tmp4_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _tmp3_, label);
	dialog = (GtkDialog*) g_object_ref_sink (_tmp4_);
	gtk_dialog_add_buttons (dialog, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_DELETE, GTK_RESPONSE_YES, NULL);
	_tmp5_ = gtk_dialog_run (dialog);
	if (_tmp5_ == GTK_RESPONSE_YES) {
		BuildTools* _tmp6_ = NULL;
		BuildTools* _tmp7_;
		gtk_list_store_remove (self->priv->build_tools_store, &iter);
		_tmp6_ = build_tools_get_default ();
		_tmp7_ = _tmp6_;
		build_tools_delete (_tmp7_, selected_row);
		_build_tools_unref0 (_tmp7_);
	}
	gtk_object_destroy ((GtkObject*) dialog);
	_g_object_unref0 (dialog);
	_g_object_unref0 (model);
	_g_free0 (label);
}


static void __lambda131__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda131_ (self);
}


static void _lambda132_ (PreferencesDialog* self) {
	const gchar* _tmp0_ = NULL;
	GtkDialog* _tmp1_ = NULL;
	GtkDialog* dialog;
	gint _tmp2_;
	_tmp0_ = _ ("Do you really want to reset all build tools?");
	_tmp1_ = preferences_dialog_get_reset_all_confirm_dialog (self, _tmp0_);
	dialog = _tmp1_;
	_tmp2_ = gtk_dialog_run (dialog);
	if (_tmp2_ == GTK_RESPONSE_YES) {
		BuildTools* _tmp3_ = NULL;
		BuildTools* _tmp4_;
		_tmp3_ = build_tools_get_default ();
		_tmp4_ = _tmp3_;
		build_tools_reset_all (_tmp4_);
		_build_tools_unref0 (_tmp4_);
		preferences_dialog_update_build_tools_store (self);
	}
	gtk_object_destroy ((GtkObject*) dialog);
	_g_object_unref0 (dialog);
}


static void __lambda132__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda132_ (self);
}


static void preferences_dialog_init_latex_tab (PreferencesDialog* self, GtkBuilder* builder) {
	Block2Data* _data2_;
	GSettings* _tmp0_ = NULL;
	GSettings* settings;
	GObject* _tmp1_ = NULL;
	GObject* _tmp2_;
	GObject* interactive_comp_checkbutton;
	GObject* _tmp3_ = NULL;
	GObject* _tmp4_;
	GtkSpinButton* _tmp5_;
	GtkSpinButton* interactive_comp_spinbutton;
	GObject* _tmp6_ = NULL;
	GObject* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* interactive_comp_label;
	GObject* _tmp9_ = NULL;
	GObject* _tmp10_;
	GObject* document_view_program;
	GObject* _tmp11_ = NULL;
	GObject* _tmp12_;
	GObject* latexmk_checkbutton;
	GObject* _tmp13_ = NULL;
	GObject* _tmp14_;
	GtkTreeView* _tmp15_;
	GObject* _tmp16_ = NULL;
	GObject* _tmp17_;
	GtkButton* _tmp18_;
	GtkButton* bt_properties;
	GObject* _tmp19_ = NULL;
	GObject* _tmp20_;
	GtkButton* _tmp21_;
	GtkButton* bt_new;
	GObject* _tmp22_ = NULL;
	GObject* _tmp23_;
	GtkButton* _tmp24_;
	GtkButton* bt_copy;
	GObject* _tmp25_ = NULL;
	GObject* _tmp26_;
	GtkButton* _tmp27_;
	GtkButton* bt_up;
	GObject* _tmp28_ = NULL;
	GObject* _tmp29_;
	GtkButton* _tmp30_;
	GtkButton* bt_down;
	GObject* _tmp31_ = NULL;
	GObject* _tmp32_;
	GtkButton* _tmp33_;
	GtkButton* bt_delete;
	GObject* _tmp34_ = NULL;
	GObject* _tmp35_;
	GtkButton* _tmp36_;
	GtkButton* bt_reset;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = g_settings_new ("org.gnome.latexila.preferences.latex");
	settings = _tmp0_;
	_tmp1_ = gtk_builder_get_object (builder, "interactive_comp_checkbutton");
	_tmp2_ = _g_object_ref0 (_tmp1_);
	interactive_comp_checkbutton = _tmp2_;
	g_settings_bind (settings, "interactive-completion", interactive_comp_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp3_ = gtk_builder_get_object (builder, "interactive_comp_spinbutton");
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (GTK_IS_SPIN_BUTTON (_tmp4_) ? ((GtkSpinButton*) _tmp4_) : NULL);
	interactive_comp_spinbutton = _tmp5_;
	preferences_dialog_set_spin_button_range (self, interactive_comp_spinbutton, settings, "interactive-completion-num");
	g_settings_bind (settings, "interactive-completion-num", interactive_comp_spinbutton, "value", G_SETTINGS_BIND_DEFAULT);
	preferences_dialog_set_sensitivity (self, settings, "interactive-completion", (GtkWidget*) interactive_comp_spinbutton, TRUE);
	_tmp6_ = gtk_builder_get_object (builder, "interactive_comp_label");
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_object_ref0 (GTK_IS_LABEL (_tmp7_) ? ((GtkLabel*) _tmp7_) : NULL);
	interactive_comp_label = _tmp8_;
	preferences_dialog_set_plural (self, interactive_comp_label, settings, "interactive-completion-num", __lambda116__preferences_dialog_plural, self);
	_tmp9_ = gtk_builder_get_object (builder, "document_view_program");
	_tmp10_ = _g_object_ref0 (_tmp9_);
	document_view_program = _tmp10_;
	g_settings_bind (settings, "document-view-program", document_view_program, "text", G_SETTINGS_BIND_DEFAULT);
	_tmp11_ = gtk_builder_get_object (builder, "latexmk_checkbutton");
	_tmp12_ = _g_object_ref0 (_tmp11_);
	latexmk_checkbutton = _tmp12_;
	g_settings_bind (settings, "latexmk-always-show-all", latexmk_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp13_ = gtk_builder_get_object (builder, "build_tools_treeview");
	_tmp14_ = _tmp13_;
	_tmp15_ = _g_object_ref0 (GTK_IS_TREE_VIEW (_tmp14_) ? ((GtkTreeView*) _tmp14_) : NULL);
	_data2_->build_tools_view = _tmp15_;
	preferences_dialog_init_build_tools_treeview (self, _data2_->build_tools_view);
	_tmp16_ = gtk_builder_get_object (builder, "build_tool_properties");
	_tmp17_ = _tmp16_;
	_tmp18_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp17_) ? ((GtkButton*) _tmp17_) : NULL);
	bt_properties = _tmp18_;
	g_signal_connect_data (bt_properties, "clicked", (GCallback) __lambda126__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp19_ = gtk_builder_get_object (builder, "build_tool_new");
	_tmp20_ = _tmp19_;
	_tmp21_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp20_) ? ((GtkButton*) _tmp20_) : NULL);
	bt_new = _tmp21_;
	g_signal_connect_object (bt_new, "clicked", (GCallback) __lambda127__gtk_button_clicked, self, 0);
	_tmp22_ = gtk_builder_get_object (builder, "build_tool_copy");
	_tmp23_ = _tmp22_;
	_tmp24_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp23_) ? ((GtkButton*) _tmp23_) : NULL);
	bt_copy = _tmp24_;
	g_signal_connect_data (bt_copy, "clicked", (GCallback) __lambda128__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp25_ = gtk_builder_get_object (builder, "build_tool_up");
	_tmp26_ = _tmp25_;
	_tmp27_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp26_) ? ((GtkButton*) _tmp26_) : NULL);
	bt_up = _tmp27_;
	g_signal_connect_data (bt_up, "clicked", (GCallback) __lambda129__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp28_ = gtk_builder_get_object (builder, "build_tool_down");
	_tmp29_ = _tmp28_;
	_tmp30_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp29_) ? ((GtkButton*) _tmp29_) : NULL);
	bt_down = _tmp30_;
	g_signal_connect_data (bt_down, "clicked", (GCallback) __lambda130__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp31_ = gtk_builder_get_object (builder, "build_tool_delete");
	_tmp32_ = _tmp31_;
	_tmp33_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp32_) ? ((GtkButton*) _tmp32_) : NULL);
	bt_delete = _tmp33_;
	g_signal_connect_data (bt_delete, "clicked", (GCallback) __lambda131__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp34_ = gtk_builder_get_object (builder, "build_tool_reset");
	_tmp35_ = _tmp34_;
	_tmp36_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp35_) ? ((GtkButton*) _tmp35_) : NULL);
	bt_reset = _tmp36_;
	g_signal_connect_object (bt_reset, "clicked", (GCallback) __lambda132__gtk_button_clicked, self, 0);
	_g_object_unref0 (bt_reset);
	_g_object_unref0 (bt_delete);
	_g_object_unref0 (bt_down);
	_g_object_unref0 (bt_up);
	_g_object_unref0 (bt_copy);
	_g_object_unref0 (bt_new);
	_g_object_unref0 (bt_properties);
	_g_object_unref0 (latexmk_checkbutton);
	_g_object_unref0 (document_view_program);
	_g_object_unref0 (interactive_comp_label);
	_g_object_unref0 (interactive_comp_spinbutton);
	_g_object_unref0 (interactive_comp_checkbutton);
	_g_object_unref0 (settings);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static void preferences_dialog_init_other_tab (PreferencesDialog* self, GtkBuilder* builder) {
	GSettings* _tmp0_ = NULL;
	GSettings* settings;
	GSettings* _tmp1_ = NULL;
	GSettings* latex_settings;
	GSettings* _tmp2_ = NULL;
	GSettings* fb_settings;
	GObject* _tmp3_ = NULL;
	GObject* _tmp4_;
	GtkSpinButton* _tmp5_;
	GtkSpinButton* nb_most_used_symbols;
	GObject* _tmp6_ = NULL;
	GObject* _tmp7_;
	GObject* confirm_clean_up_checkbutton;
	GObject* _tmp8_ = NULL;
	GObject* _tmp9_;
	GtkWidget* _tmp10_;
	GtkWidget* auto_clean_up_checkbutton;
	GObject* _tmp11_ = NULL;
	GObject* _tmp12_;
	GObject* clean_up_entry;
	GObject* _tmp13_ = NULL;
	GObject* _tmp14_;
	GObject* file_browser_show_all;
	GObject* _tmp15_ = NULL;
	GObject* _tmp16_;
	GtkWidget* _tmp17_;
	GtkWidget* vbox_file_browser_show_all;
	GObject* _tmp18_ = NULL;
	GObject* _tmp19_;
	GObject* file_browser_except;
	GObject* _tmp20_ = NULL;
	GObject* _tmp21_;
	GObject* file_browser_show_hidden;
	GObject* _tmp22_ = NULL;
	GObject* _tmp23_;
	GtkWidget* _tmp24_;
	GtkWidget* file_browser_entry;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_tmp0_ = g_settings_new ("org.gnome.latexila.preferences.editor");
	settings = _tmp0_;
	_tmp1_ = g_settings_new ("org.gnome.latexila.preferences.latex");
	latex_settings = _tmp1_;
	_tmp2_ = g_settings_new ("org.gnome.latexila.preferences.file-browser");
	fb_settings = _tmp2_;
	_tmp3_ = gtk_builder_get_object (builder, "nb_most_used_symbols");
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (GTK_IS_SPIN_BUTTON (_tmp4_) ? ((GtkSpinButton*) _tmp4_) : NULL);
	nb_most_used_symbols = _tmp5_;
	preferences_dialog_set_spin_button_range (self, nb_most_used_symbols, settings, "nb-most-used-symbols");
	g_settings_bind (settings, "nb-most-used-symbols", nb_most_used_symbols, "value", G_SETTINGS_BIND_DEFAULT);
	_tmp6_ = gtk_builder_get_object (builder, "confirm_clean_up_checkbutton");
	_tmp7_ = _g_object_ref0 (_tmp6_);
	confirm_clean_up_checkbutton = _tmp7_;
	g_settings_bind (latex_settings, "no-confirm-clean", confirm_clean_up_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp8_ = gtk_builder_get_object (builder, "auto_clean_up_checkbutton");
	_tmp9_ = _tmp8_;
	_tmp10_ = _g_object_ref0 (GTK_IS_WIDGET (_tmp9_) ? ((GtkWidget*) _tmp9_) : NULL);
	auto_clean_up_checkbutton = _tmp10_;
	g_settings_bind (latex_settings, "automatic-clean", auto_clean_up_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	preferences_dialog_set_sensitivity (self, latex_settings, "no-confirm-clean", auto_clean_up_checkbutton, TRUE);
	_tmp11_ = gtk_builder_get_object (builder, "clean_up_entry");
	_tmp12_ = _g_object_ref0 (_tmp11_);
	clean_up_entry = _tmp12_;
	g_settings_bind (latex_settings, "clean-extensions", clean_up_entry, "text", G_SETTINGS_BIND_DEFAULT);
	_tmp13_ = gtk_builder_get_object (builder, "file_browser_show_all");
	_tmp14_ = _g_object_ref0 (_tmp13_);
	file_browser_show_all = _tmp14_;
	g_settings_bind (fb_settings, "show-all-files", file_browser_show_all, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp15_ = gtk_builder_get_object (builder, "vbox_file_browser_show_all");
	_tmp16_ = _tmp15_;
	_tmp17_ = _g_object_ref0 (GTK_IS_WIDGET (_tmp16_) ? ((GtkWidget*) _tmp16_) : NULL);
	vbox_file_browser_show_all = _tmp17_;
	preferences_dialog_set_sensitivity (self, fb_settings, "show-all-files", vbox_file_browser_show_all, TRUE);
	_tmp18_ = gtk_builder_get_object (builder, "file_browser_except");
	_tmp19_ = _g_object_ref0 (_tmp18_);
	file_browser_except = _tmp19_;
	g_settings_bind (fb_settings, "show-all-files-except", file_browser_except, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp20_ = gtk_builder_get_object (builder, "file_browser_show_hidden");
	_tmp21_ = _g_object_ref0 (_tmp20_);
	file_browser_show_hidden = _tmp21_;
	g_settings_bind (fb_settings, "show-hidden-files", file_browser_show_hidden, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp22_ = gtk_builder_get_object (builder, "file_browser_entry");
	_tmp23_ = _tmp22_;
	_tmp24_ = _g_object_ref0 (GTK_IS_WIDGET (_tmp23_) ? ((GtkWidget*) _tmp23_) : NULL);
	file_browser_entry = _tmp24_;
	g_settings_bind (fb_settings, "file-extensions", file_browser_entry, "text", G_SETTINGS_BIND_DEFAULT);
	preferences_dialog_set_sensitivity (self, fb_settings, "show-all-files", file_browser_entry, FALSE);
	_g_object_unref0 (file_browser_entry);
	_g_object_unref0 (file_browser_show_hidden);
	_g_object_unref0 (file_browser_except);
	_g_object_unref0 (vbox_file_browser_show_all);
	_g_object_unref0 (file_browser_show_all);
	_g_object_unref0 (clean_up_entry);
	_g_object_unref0 (auto_clean_up_checkbutton);
	_g_object_unref0 (confirm_clean_up_checkbutton);
	_g_object_unref0 (nb_most_used_symbols);
	_g_object_unref0 (fb_settings);
	_g_object_unref0 (latex_settings);
	_g_object_unref0 (settings);
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		_g_object_unref0 (_data3_->widget);
		g_slice_free (Block3Data, _data3_);
	}
}


static void _lambda1_ (GSettings* setting, const gchar* k, Block3Data* _data3_) {
	PreferencesDialog * self;
	gboolean _tmp0_;
	gboolean v;
	gboolean _tmp1_ = FALSE;
	self = _data3_->self;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (k != NULL);
	_tmp0_ = g_settings_get_boolean (setting, k);
	v = _tmp0_;
	if (_data3_->must_be_enabled) {
		_tmp1_ = v;
	} else {
		_tmp1_ = !v;
	}
	gtk_widget_set_sensitive (_data3_->widget, _tmp1_);
}


static void __lambda1__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	_lambda1_ (_sender, key, self);
}


static void preferences_dialog_set_sensitivity (PreferencesDialog* self, GSettings* settings, const gchar* key, GtkWidget* widget, gboolean must_be_enabled) {
	Block3Data* _data3_;
	gboolean _tmp0_;
	gboolean val;
	gboolean _tmp1_ = FALSE;
	gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (widget != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_data3_->widget = _g_object_ref0 (widget);
	_data3_->must_be_enabled = must_be_enabled;
	_tmp0_ = g_settings_get_boolean (settings, key);
	val = _tmp0_;
	if (_data3_->must_be_enabled) {
		_tmp1_ = val;
	} else {
		_tmp1_ = !val;
	}
	gtk_widget_set_sensitive (_data3_->widget, _tmp1_);
	_tmp2_ = g_strconcat ("changed::", key, NULL);
	g_signal_connect_data (settings, _tmp2_, (GCallback) __lambda1__g_settings_changed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_g_free0 (_tmp2_);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


static void preferences_dialog_set_system_font_label (PreferencesDialog* self, GtkButton* button) {
	AppSettings* _tmp0_ = NULL;
	AppSettings* app_settings;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* label;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = app_settings_get_default ();
	app_settings = _tmp0_;
	_tmp1_ = _ ("Use the system fixed width font (%s)");
	_tmp2_ = app_settings_get_system_font (app_settings);
	_tmp3_ = g_strdup_printf (_tmp1_, _tmp2_);
	label = _tmp3_;
	gtk_button_set_label (button, label);
	_g_free0 (label);
	_g_object_unref0 (app_settings);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_object_unref0 (_data4_->self);
		_g_object_unref0 (_data4_->label);
		g_slice_free (Block4Data, _data4_);
	}
}


static void _lambda2_ (GSettings* setting, const gchar* k, Block4Data* _data4_) {
	PreferencesDialog * self;
	guint v = 0U;
	const gchar* _tmp0_ = NULL;
	self = _data4_->self;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (k != NULL);
	g_settings_get (setting, k, "u", &v);
	_tmp0_ = _data4_->plural ((gulong) v, _data4_->plural_target);
	gtk_label_set_label (_data4_->label, _tmp0_);
}


static void __lambda2__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	_lambda2_ (_sender, key, self);
}


static void preferences_dialog_set_plural (PreferencesDialog* self, GtkLabel* label, GSettings* settings, const gchar* key, PreferencesDialogPlural plural, void* plural_target) {
	Block4Data* _data4_;
	guint val = 0U;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_data4_->label = _g_object_ref0 (label);
	_data4_->plural = plural;
	_data4_->plural_target = plural_target;
	g_settings_get (settings, key, "u", &val);
	_tmp0_ = _data4_->plural ((gulong) val, _data4_->plural_target);
	gtk_label_set_label (_data4_->label, _tmp0_);
	_tmp1_ = g_strconcat ("changed::", key, NULL);
	g_signal_connect_data (settings, _tmp1_, (GCallback) __lambda2__g_settings_changed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_g_free0 (_tmp1_);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static void preferences_dialog_set_spin_button_range (PreferencesDialog* self, GtkSpinButton* spin_button, GSettings* settings, const gchar* key) {
	GVariant* _tmp0_ = NULL;
	GVariant* _tmp1_;
	GVariant* range;
	gchar* range_type = NULL;
	GVariant* range_contents = NULL;
	guint min = 0U;
	guint max = 0U;
	guint cur_value = 0U;
	GtkAdjustment* _tmp2_ = NULL;
	GtkAdjustment* adjustment;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spin_button != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = g_settings_get_range (settings, key);
	_tmp1_ = _g_variant_ref0 (_tmp0_);
	range = _tmp1_;
	g_variant_get (range, "(sv)", &range_type, &range_contents, NULL);
	g_return_if_fail (g_strcmp0 (range_type, "range") == 0);
	g_variant_get (range_contents, "(uu)", &min, &max, NULL);
	g_settings_get (settings, key, "u", &cur_value);
	_tmp2_ = (GtkAdjustment*) gtk_adjustment_new ((gdouble) cur_value, (gdouble) min, (gdouble) max, 1.0, (gdouble) 0, (gdouble) 0);
	adjustment = g_object_ref_sink (_tmp2_);
	gtk_spin_button_set_adjustment (spin_button, adjustment);
	_g_object_unref0 (adjustment);
	_g_variant_unref0 (range_contents);
	_g_free0 (range_type);
	_g_variant_unref0 (range);
}


static void preferences_dialog_init_schemes_treeview (PreferencesDialog* self, GtkTreeView* treeview, const gchar* current_id) {
	GtkListStore* _tmp0_ = NULL;
	GtkListStore* list_store;
	GtkCellRendererText* _tmp1_ = NULL;
	GtkCellRendererText* renderer;
	GtkTreeViewColumn* _tmp2_ = NULL;
	GtkTreeViewColumn* column;
	GtkTreeSelection* _tmp3_ = NULL;
	GtkTreeSelection* _tmp4_;
	GtkTreeSelection* select;
	GtkSourceStyleSchemeManager* _tmp5_ = NULL;
	GtkSourceStyleSchemeManager* _tmp6_;
	GtkSourceStyleSchemeManager* manager;
	gchar** _tmp7_;
	gchar** _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (treeview != NULL);
	g_return_if_fail (current_id != NULL);
	_tmp0_ = gtk_list_store_new ((gint) PREFERENCES_DIALOG_STYLE_SCHEMES_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING);
	list_store = _tmp0_;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) list_store, (gint) PREFERENCES_DIALOG_STYLE_SCHEMES_ID, GTK_SORT_ASCENDING);
	gtk_tree_view_set_model (treeview, (GtkTreeModel*) list_store);
	_tmp1_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	renderer = g_object_ref_sink (_tmp1_);
	_tmp2_ = gtk_tree_view_column_new_with_attributes ("Name and description", (GtkCellRenderer*) renderer, "markup", PREFERENCES_DIALOG_STYLE_SCHEMES_DESC, NULL, NULL);
	column = g_object_ref_sink (_tmp2_);
	gtk_tree_view_append_column (treeview, column);
	_tmp3_ = gtk_tree_view_get_selection (treeview);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	select = _tmp4_;
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	_tmp5_ = gtk_source_style_scheme_manager_get_default ();
	_tmp6_ = _g_object_ref0 (_tmp5_);
	manager = _tmp6_;
	_tmp8_ = _tmp7_ = gtk_source_style_scheme_manager_get_scheme_ids (manager);
	{
		gchar** id_collection;
		int id_collection_length1;
		int id_it;
		id_collection = _tmp8_;
		id_collection_length1 = _vala_array_length (_tmp7_);
		for (id_it = 0; id_it < _vala_array_length (_tmp7_); id_it = id_it + 1) {
			gchar* _tmp9_;
			gchar* id;
			_tmp9_ = g_strdup (id_collection[id_it]);
			id = _tmp9_;
			{
				GtkSourceStyleScheme* _tmp10_ = NULL;
				GtkSourceStyleScheme* _tmp11_;
				GtkSourceStyleScheme* scheme;
				const gchar* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
				gchar* desc;
				GtkTreeIter iter = {0};
				GtkTreeIter _tmp15_ = {0};
				const gchar* _tmp16_ = NULL;
				_tmp10_ = gtk_source_style_scheme_manager_get_scheme (manager, id);
				_tmp11_ = _g_object_ref0 (_tmp10_);
				scheme = _tmp11_;
				_tmp12_ = gtk_source_style_scheme_get_name (scheme);
				_tmp13_ = gtk_source_style_scheme_get_description (scheme);
				_tmp14_ = g_strdup_printf ("<b>%s</b> - %s", _tmp12_, _tmp13_);
				desc = _tmp14_;
				gtk_list_store_append (list_store, &_tmp15_);
				iter = _tmp15_;
				_tmp16_ = gtk_source_style_scheme_get_id (scheme);
				gtk_list_store_set (list_store, &iter, PREFERENCES_DIALOG_STYLE_SCHEMES_ID, _tmp16_, PREFERENCES_DIALOG_STYLE_SCHEMES_DESC, desc, -1, -1);
				if (g_strcmp0 (id, current_id) == 0) {
					gtk_tree_selection_select_iter (select, &iter);
				}
				_g_free0 (desc);
				_g_object_unref0 (scheme);
				_g_free0 (id);
			}
		}
	}
	_g_object_unref0 (manager);
	_g_object_unref0 (select);
	_g_object_unref0 (column);
	_g_object_unref0 (renderer);
	_g_object_unref0 (list_store);
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		_g_object_unref0 (_data5_->self);
		_g_object_unref0 (_data5_->label_column);
		g_slice_free (Block5Data, _data5_);
	}
}


static void _lambda117_ (const gchar* path_string, PreferencesDialog* self) {
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean val = FALSE;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* model;
	gint _tmp2_;
	gint num;
	BuildTools* _tmp3_ = NULL;
	BuildTools* build_tools;
	BuildTool* _tmp4_ = NULL;
	BuildTool* _tmp5_;
	BuildTool _tmp6_;
	BuildTool _tmp7_ = {0};
	BuildTool _tmp8_;
	BuildTool build_tool;
	g_return_if_fail (path_string != NULL);
	gtk_tree_model_get_iter_from_string ((GtkTreeModel*) self->priv->build_tools_store, &_tmp0_, path_string);
	iter = _tmp0_;
	_tmp1_ = _g_object_ref0 (GTK_TREE_MODEL (self->priv->build_tools_store));
	model = _tmp1_;
	gtk_tree_model_get (model, &iter, PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_SHOW, &val, -1, -1);
	val = !val;
	gtk_list_store_set (self->priv->build_tools_store, &iter, PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_SHOW, val, -1, -1);
	_tmp2_ = atoi (path_string);
	num = _tmp2_;
	_tmp3_ = build_tools_get_default ();
	build_tools = _tmp3_;
	_tmp4_ = build_tools_get (build_tools, num);
	_tmp5_ = _tmp4_;
	build_tool_copy (_tmp5_, &_tmp7_);
	_tmp6_ = _tmp7_;
	_tmp8_ = _tmp6_;
	_build_tool_free0 (_tmp5_);
	build_tool = _tmp8_;
	build_tool.show = val;
	build_tools_update (build_tools, num, &build_tool, FALSE);
	build_tool_destroy (&build_tool);
	_build_tools_unref0 (build_tools);
	_g_object_unref0 (model);
}


static void __lambda117__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const gchar* path, gpointer self) {
	_lambda117_ (path, self);
}


static void _lambda118_ (GtkTreePath* path, GtkTreeViewColumn* column, Block5Data* _data5_) {
	PreferencesDialog * self;
	self = _data5_->self;
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	if (column == _data5_->label_column) {
		gint* _tmp0_ = NULL;
		gint num;
		_tmp0_ = gtk_tree_path_get_indices (path);
		num = _tmp0_[0];
		preferences_dialog_run_build_tool_dialog (self, num);
	}
}


static void __lambda118__gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
	_lambda118_ (path, column, self);
}


static void preferences_dialog_init_build_tools_treeview (PreferencesDialog* self, GtkTreeView* build_tools_view) {
	Block5Data* _data5_;
	GtkListStore* _tmp0_ = NULL;
	GtkTreeViewColumn* _tmp1_ = NULL;
	GtkTreeViewColumn* active_column;
	const gchar* _tmp2_ = NULL;
	GtkCellRendererToggle* _tmp3_ = NULL;
	GtkCellRendererToggle* toggle_renderer;
	GtkTreeViewColumn* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GtkCellRendererPixbuf* _tmp6_ = NULL;
	GtkCellRendererPixbuf* pixbuf_renderer;
	GtkCellRendererText* _tmp7_ = NULL;
	GtkCellRendererText* text_renderer;
	GtkTreeSelection* _tmp8_ = NULL;
	GtkTreeSelection* _tmp9_;
	GtkTreeSelection* select;
	g_return_if_fail (self != NULL);
	g_return_if_fail (build_tools_view != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = gtk_list_store_new ((gint) PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_N_COLUMNS, G_TYPE_BOOLEAN, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
	_g_object_unref0 (self->priv->build_tools_store);
	self->priv->build_tools_store = _tmp0_;
	gtk_tree_view_set_model (build_tools_view, (GtkTreeModel*) self->priv->build_tools_store);
	_tmp1_ = gtk_tree_view_column_new ();
	active_column = g_object_ref_sink (_tmp1_);
	_tmp2_ = _ ("Active");
	gtk_tree_view_column_set_title (active_column, _tmp2_);
	gtk_tree_view_append_column (build_tools_view, active_column);
	_tmp3_ = (GtkCellRendererToggle*) gtk_cell_renderer_toggle_new ();
	toggle_renderer = g_object_ref_sink (_tmp3_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) active_column, (GtkCellRenderer*) toggle_renderer, FALSE);
	gtk_tree_view_column_set_attributes (active_column, (GtkCellRenderer*) toggle_renderer, "active", PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_SHOW, NULL, NULL);
	_tmp4_ = gtk_tree_view_column_new ();
	_data5_->label_column = g_object_ref_sink (_tmp4_);
	_tmp5_ = _ ("Label");
	gtk_tree_view_column_set_title (_data5_->label_column, _tmp5_);
	gtk_tree_view_append_column (build_tools_view, _data5_->label_column);
	_tmp6_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	pixbuf_renderer = g_object_ref_sink (_tmp6_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) _data5_->label_column, (GtkCellRenderer*) pixbuf_renderer, FALSE);
	gtk_tree_view_column_set_attributes (_data5_->label_column, (GtkCellRenderer*) pixbuf_renderer, "stock-id", PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_PIXBUF, NULL, NULL);
	_tmp7_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	text_renderer = g_object_ref_sink (_tmp7_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) _data5_->label_column, (GtkCellRenderer*) text_renderer, TRUE);
	gtk_tree_view_column_set_attributes (_data5_->label_column, (GtkCellRenderer*) text_renderer, "text", PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_LABEL, NULL, NULL);
	gtk_tree_view_set_tooltip_column (build_tools_view, (gint) PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_DESCRIPTION);
	_tmp8_ = gtk_tree_view_get_selection (build_tools_view);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	select = _tmp9_;
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	preferences_dialog_update_build_tools_store (self);
	g_signal_connect_object (toggle_renderer, "toggled", (GCallback) __lambda117__gtk_cell_renderer_toggle_toggled, self, 0);
	g_signal_connect_data (build_tools_view, "row-activated", (GCallback) __lambda118__gtk_tree_view_row_activated, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_g_object_unref0 (select);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
	_g_object_unref0 (toggle_renderer);
	_g_object_unref0 (active_column);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}


static void preferences_dialog_update_build_tools_store (PreferencesDialog* self) {
	g_return_if_fail (self != NULL);
	gtk_list_store_clear (self->priv->build_tools_store);
	{
		BuildTools* _tmp0_ = NULL;
		BuildTools* _tmp1_;
		GeeIterator* _tmp2_ = NULL;
		GeeIterator* _tmp3_;
		GeeIterator* _tool_it;
		_tmp0_ = build_tools_get_default ();
		_tmp1_ = _tmp0_;
		_tmp2_ = build_tools_iterator (_tmp1_);
		_tmp3_ = _tmp2_;
		_build_tools_unref0 (_tmp1_);
		_tool_it = _tmp3_;
		while (TRUE) {
			gboolean _tmp4_;
			gpointer _tmp5_ = NULL;
			BuildTool* _tmp6_;
			BuildTool _tmp7_;
			BuildTool _tmp8_ = {0};
			BuildTool _tmp9_;
			BuildTool tool;
			GtkTreeIter iter = {0};
			GtkTreeIter _tmp10_ = {0};
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_;
			_tmp4_ = gee_iterator_next (_tool_it);
			if (!_tmp4_) {
				break;
			}
			_tmp5_ = gee_iterator_get (_tool_it);
			_tmp6_ = (BuildTool*) _tmp5_;
			build_tool_copy (_tmp6_, &_tmp8_);
			_tmp7_ = _tmp8_;
			_tmp9_ = _tmp7_;
			_build_tool_free0 (_tmp6_);
			tool = _tmp9_;
			gtk_list_store_append (self->priv->build_tools_store, &_tmp10_);
			iter = _tmp10_;
			_tmp11_ = g_markup_escape_text (tool.description, (gssize) (-1));
			_tmp12_ = _tmp11_;
			gtk_list_store_set (self->priv->build_tools_store, &iter, PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_SHOW, tool.show, PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_PIXBUF, tool.icon, PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_LABEL, tool.label, PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_DESCRIPTION, _tmp12_, -1, -1);
			_g_free0 (_tmp12_);
			build_tool_destroy (&tool);
		}
		_g_object_unref0 (_tool_it);
	}
}


static GtkDialog* preferences_dialog_get_reset_all_confirm_dialog (PreferencesDialog* self, const gchar* msg) {
	GtkDialog* result = NULL;
	GtkMessageDialog* _tmp0_ = NULL;
	GtkDialog* dialog;
	const gchar* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	GtkButton* button;
	GtkImage* _tmp3_ = NULL;
	GtkImage* image;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	_tmp0_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", msg);
	dialog = (GtkDialog*) g_object_ref_sink (_tmp0_);
	gtk_dialog_add_button (dialog, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
	_tmp1_ = _ ("Reset All");
	_tmp2_ = (GtkButton*) gtk_button_new_with_label (_tmp1_);
	button = g_object_ref_sink (_tmp2_);
	_tmp3_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_CLEAR, GTK_ICON_SIZE_BUTTON);
	image = g_object_ref_sink (_tmp3_);
	gtk_button_set_image (button, (GtkWidget*) image);
	gtk_widget_show_all ((GtkWidget*) button);
	gtk_dialog_add_action_widget (dialog, (GtkWidget*) button, (gint) GTK_RESPONSE_YES);
	result = dialog;
	_g_object_unref0 (image);
	_g_object_unref0 (button);
	return result;
}


static void preferences_dialog_run_build_tool_dialog (PreferencesDialog* self, gint num) {
	GtkWindow* _tmp0_ = NULL;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_window_get_transient_for ((GtkWindow*) self);
	_tmp1_ = build_tool_dialog_show_me (_tmp0_, num);
	if (_tmp1_) {
		preferences_dialog_update_build_tools_store (self);
	}
}


static void preferences_dialog_class_init (PreferencesDialogClass * klass) {
	preferences_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PreferencesDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = preferences_dialog_finalize;
}


static void preferences_dialog_instance_init (PreferencesDialog * self) {
	self->priv = PREFERENCES_DIALOG_GET_PRIVATE (self);
}


static void preferences_dialog_finalize (GObject* obj) {
	PreferencesDialog * self;
	self = PREFERENCES_DIALOG (obj);
	_g_object_unref0 (self->priv->build_tools_store);
	G_OBJECT_CLASS (preferences_dialog_parent_class)->finalize (obj);
}


GType preferences_dialog_get_type (void) {
	static volatile gsize preferences_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&preferences_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PreferencesDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) preferences_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PreferencesDialog), 0, (GInstanceInitFunc) preferences_dialog_instance_init, NULL };
		GType preferences_dialog_type_id;
		preferences_dialog_type_id = g_type_register_static (GTK_TYPE_DIALOG, "PreferencesDialog", &g_define_type_info, 0);
		g_once_init_leave (&preferences_dialog_type_id__volatile, preferences_dialog_type_id);
	}
	return preferences_dialog_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



