/* build_tool_dialog.c generated by valac 0.14.0.77-0077, the Vala compiler
 * generated from build_tool_dialog.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include "config.h"
#include <gee.h>


#define TYPE_BUILD_TOOL_DIALOG (build_tool_dialog_get_type ())
#define BUILD_TOOL_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOL_DIALOG, BuildToolDialog))
#define BUILD_TOOL_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOL_DIALOG, BuildToolDialogClass))
#define IS_BUILD_TOOL_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOL_DIALOG))
#define IS_BUILD_TOOL_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOL_DIALOG))
#define BUILD_TOOL_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOL_DIALOG, BuildToolDialogClass))

typedef struct _BuildToolDialog BuildToolDialog;
typedef struct _BuildToolDialogClass BuildToolDialogClass;
typedef struct _BuildToolDialogPrivate BuildToolDialogPrivate;

#define BUILD_TOOL_DIALOG_TYPE_JOB_COLUMN (build_tool_dialog_job_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BUILD_TOOL_DIALOG_TYPE_ICON_COLUMN (build_tool_dialog_icon_column_get_type ())
typedef struct _BuildToolDialogIconColumn BuildToolDialogIconColumn;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_POST_PROCESSOR_TYPE (post_processor_type_get_type ())

#define TYPE_BUILD_TOOL (build_tool_get_type ())

#define TYPE_BUILD_JOB (build_job_get_type ())
typedef struct _BuildJob BuildJob;
typedef struct _BuildTool BuildTool;

#define TYPE_BUILD_TOOLS (build_tools_get_type ())
#define BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOLS, BuildTools))
#define BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOLS, BuildToolsClass))
#define IS_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOLS))
#define IS_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOLS))
#define BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOLS, BuildToolsClass))

typedef struct _BuildTools BuildTools;
typedef struct _BuildToolsClass BuildToolsClass;
#define _build_tool_free0(var) ((var == NULL) ? NULL : (var = (build_tool_free (var), NULL)))
#define _build_tools_unref0(var) ((var == NULL) ? NULL : (var = (build_tools_unref (var), NULL)))
#define _build_job_free0(var) ((var == NULL) ? NULL : (var = (build_job_free (var), NULL)))

struct _BuildToolDialog {
	GtkDialog parent_instance;
	BuildToolDialogPrivate * priv;
};

struct _BuildToolDialogClass {
	GtkDialogClass parent_class;
};

struct _BuildToolDialogPrivate {
	GtkEntry* entry_label;
	GtkEntry* entry_desc;
	GtkEntry* entry_extensions;
	GtkComboBox* combobox_icon;
	GtkEntry* entry_command;
	GtkButton* button_add;
	GtkTreeView* treeview_jobs;
	GtkButton* button_delete;
	GtkButton* button_up;
	GtkButton* button_down;
	GtkListStore* jobs_store;
};

typedef enum  {
	BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND,
	BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED,
	BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR,
	BUILD_TOOL_DIALOG_JOB_COLUMN_N_COLUMNS
} BuildToolDialogJobColumn;

struct _BuildToolDialogIconColumn {
	gchar* stock_id;
	gchar* label;
};

typedef enum  {
	POST_PROCESSOR_TYPE_ALL_OUTPUT = 0,
	POST_PROCESSOR_TYPE_LATEX,
	POST_PROCESSOR_TYPE_LATEXMK,
	POST_PROCESSOR_TYPE_NO_OUTPUT,
	POST_PROCESSOR_TYPE_RUBBER,
	POST_PROCESSOR_TYPE_N_POST_PROCESSORS
} PostProcessorType;

struct _BuildJob {
	gboolean must_succeed;
	PostProcessorType post_processor;
	gchar* command;
};

struct _BuildTool {
	gchar* description;
	gchar* extensions;
	gchar* label;
	gchar* icon;
	gboolean show;
	gboolean compilation;
	GeeArrayList* jobs;
};


static gpointer build_tool_dialog_parent_class = NULL;
static BuildToolDialog* build_tool_dialog_instance;
static BuildToolDialog* build_tool_dialog_instance = NULL;

GType build_tool_dialog_get_type (void) G_GNUC_CONST;
#define BUILD_TOOL_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BUILD_TOOL_DIALOG, BuildToolDialogPrivate))
enum  {
	BUILD_TOOL_DIALOG_DUMMY_PROPERTY
};
static GType build_tool_dialog_job_column_get_type (void) G_GNUC_UNUSED;
static GType build_tool_dialog_icon_column_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static BuildToolDialogIconColumn* build_tool_dialog_icon_column_dup (const BuildToolDialogIconColumn* self);
static void build_tool_dialog_icon_column_free (BuildToolDialogIconColumn* self);
static void build_tool_dialog_icon_column_copy (const BuildToolDialogIconColumn* self, BuildToolDialogIconColumn* dest);
static void build_tool_dialog_icon_column_destroy (BuildToolDialogIconColumn* self);
static BuildToolDialog* build_tool_dialog_new (void);
static BuildToolDialog* build_tool_dialog_construct (GType object_type);
static void build_tool_dialog_init_icon_treeview (BuildToolDialog* self);
static void build_tool_dialog_init_jobs_treeview (BuildToolDialog* self);
static void build_tool_dialog_init_actions (BuildToolDialog* self);
gboolean build_tool_dialog_show_me (GtkWindow* parent, gint num);
static void ___lambda88_ (void);
static void ____lambda88__gtk_object_destroy (GtkObject* _sender, gpointer self);
static void build_tool_dialog_init (BuildToolDialog* self, gint num);
static gboolean build_tool_dialog_run_me (BuildToolDialog* self, gint num);
GType post_processor_type_get_type (void) G_GNUC_CONST;
gchar* build_tools_get_post_processor_name_from_type (PostProcessorType type);
static void __lambda82_ (BuildToolDialog* self, const gchar* path_string, const gchar* new_text);
static void ___lambda82__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender, const gchar* path, const gchar* new_text, gpointer self);
static void __lambda83_ (BuildToolDialog* self, const gchar* path_string);
static void ___lambda83__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const gchar* path, gpointer self);
static void __lambda84_ (BuildToolDialog* self, const gchar* path_string, const gchar* new_text);
static void ___lambda84__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender, const gchar* path, const gchar* new_text, gpointer self);
static void build_tool_dialog_on_command_add (BuildToolDialog* self);
static void _build_tool_dialog_on_command_add_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _build_tool_dialog_on_command_add_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void __lambda85_ (BuildToolDialog* self);
gint utils_get_selected_row (GtkTreeView* view, GtkTreeIter* iter);
static void ___lambda85__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda86_ (BuildToolDialog* self);
gboolean utils_tree_model_iter_prev (GtkTreeModel* model, GtkTreeIter* iter);
static void ___lambda86__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda87_ (BuildToolDialog* self);
static void ___lambda87__gtk_button_clicked (GtkButton* _sender, gpointer self);
void utils_set_entry_error (GtkWidget* entry, gboolean _error_);
static void build_tool_dialog_init_new_build_tool (BuildToolDialog* self);
GType build_tool_get_type (void) G_GNUC_CONST;
GType build_job_get_type (void) G_GNUC_CONST;
BuildJob* build_job_dup (const BuildJob* self);
void build_job_free (BuildJob* self);
void build_job_copy (const BuildJob* self, BuildJob* dest);
void build_job_destroy (BuildJob* self);
BuildTool* build_tool_dup (const BuildTool* self);
void build_tool_free (BuildTool* self);
void build_tool_copy (const BuildTool* self, BuildTool* dest);
void build_tool_destroy (BuildTool* self);
static void build_tool_dialog_init_with_build_tool (BuildToolDialog* self, BuildTool* tool);
gpointer build_tools_ref (gpointer instance);
void build_tools_unref (gpointer instance);
GParamSpec* param_spec_build_tools (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_build_tools (GValue* value, gpointer v_object);
void value_take_build_tools (GValue* value, gpointer v_object);
gpointer value_get_build_tools (const GValue* value);
GType build_tools_get_type (void) G_GNUC_CONST;
BuildTools* build_tools_get_default (void);
BuildTool* build_tools_get (BuildTools* self, gint id);
PostProcessorType* build_tools_get_post_processor_type_from_name (const gchar* name);
void build_tools_add (BuildTools* self, BuildTool* tool);
void build_tools_update (BuildTools* self, gint num, BuildTool* tool, gboolean keep_show);
static void build_tool_dialog_finalize (GObject* obj);

static const BuildToolDialogIconColumn BUILD_TOOL_DIALOG_icons[9] = {{GTK_STOCK_EXECUTE, "Execute"}, {"compile_dvi", "LaTeX → DVI"}, {"compile_pdf", "LaTeX → PDF"}, {"compile_ps", "LaTeX → PS"}, {GTK_STOCK_CONVERT, "Convert"}, {GTK_STOCK_FILE, "View File"}, {"view_dvi", "View DVI"}, {"view_pdf", "View PDF"}, {"view_ps", "View PS"}};

static GType build_tool_dialog_job_column_get_type (void) {
	static volatile gsize build_tool_dialog_job_column_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_dialog_job_column_type_id__volatile)) {
		static const GEnumValue values[] = {{BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, "BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND", "command"}, {BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED, "BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED", "must-succeed"}, {BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, "BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR", "post-processor"}, {BUILD_TOOL_DIALOG_JOB_COLUMN_N_COLUMNS, "BUILD_TOOL_DIALOG_JOB_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType build_tool_dialog_job_column_type_id;
		build_tool_dialog_job_column_type_id = g_enum_register_static ("BuildToolDialogJobColumn", values);
		g_once_init_leave (&build_tool_dialog_job_column_type_id__volatile, build_tool_dialog_job_column_type_id);
	}
	return build_tool_dialog_job_column_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static BuildToolDialog* build_tool_dialog_construct (GType object_type) {
	BuildToolDialog * self = NULL;
	const gchar* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	self = (BuildToolDialog*) g_object_new (object_type, NULL);
	gtk_dialog_add_button ((GtkDialog*) self, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
	gtk_dialog_add_button ((GtkDialog*) self, GTK_STOCK_OK, (gint) GTK_RESPONSE_OK);
	_tmp0_ = _ ("Build Tool");
	gtk_window_set_title ((GtkWindow*) self, _tmp0_);
	gtk_dialog_set_has_separator ((GtkDialog*) self, FALSE);
	gtk_window_set_destroy_with_parent ((GtkWindow*) self, TRUE);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 5);
	{
		gchar* _tmp1_ = NULL;
		gchar* path;
		GtkBuilder* _tmp2_;
		GtkBuilder* builder;
		GObject* _tmp3_ = NULL;
		GtkVBox* _tmp4_;
		GtkVBox* main_vbox;
		GtkVBox* _tmp5_;
		GObject* _tmp6_ = NULL;
		GtkEntry* _tmp7_;
		GObject* _tmp8_ = NULL;
		GtkEntry* _tmp9_;
		GObject* _tmp10_ = NULL;
		GtkEntry* _tmp11_;
		GObject* _tmp12_ = NULL;
		GtkComboBox* _tmp13_;
		GObject* _tmp14_ = NULL;
		GtkEntry* _tmp15_;
		GObject* _tmp16_ = NULL;
		GtkButton* _tmp17_;
		GObject* _tmp18_ = NULL;
		GtkTreeView* _tmp19_;
		GObject* _tmp20_ = NULL;
		GtkButton* _tmp21_;
		GObject* _tmp22_ = NULL;
		GtkButton* _tmp23_;
		GObject* _tmp24_ = NULL;
		GtkButton* _tmp25_;
		GtkWidget* _tmp26_ = NULL;
		GtkBox* _tmp27_;
		GtkBox* content_area;
		GtkBox* _tmp28_;
		GtkVBox* _tmp29_;
		GtkBox* _tmp30_;
		_tmp1_ = g_build_filename (DATA_DIR, "ui", "build_tool.ui", NULL);
		path = _tmp1_;
		_tmp2_ = gtk_builder_new ();
		builder = _tmp2_;
		gtk_builder_add_from_file (builder, path, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (builder);
			_g_free0 (path);
			goto __catch29_g_error;
		}
		_tmp3_ = gtk_builder_get_object (builder, "main_vbox");
		_tmp4_ = _g_object_ref0 (GTK_VBOX (_tmp3_));
		main_vbox = _tmp4_;
		_tmp5_ = main_vbox;
		gtk_widget_unparent ((GtkWidget*) _tmp5_);
		_tmp6_ = gtk_builder_get_object (builder, "entry_label");
		_tmp7_ = _g_object_ref0 (GTK_ENTRY (_tmp6_));
		_g_object_unref0 (self->priv->entry_label);
		self->priv->entry_label = _tmp7_;
		_tmp8_ = gtk_builder_get_object (builder, "entry_desc");
		_tmp9_ = _g_object_ref0 (GTK_ENTRY (_tmp8_));
		_g_object_unref0 (self->priv->entry_desc);
		self->priv->entry_desc = _tmp9_;
		_tmp10_ = gtk_builder_get_object (builder, "entry_extensions");
		_tmp11_ = _g_object_ref0 (GTK_ENTRY (_tmp10_));
		_g_object_unref0 (self->priv->entry_extensions);
		self->priv->entry_extensions = _tmp11_;
		_tmp12_ = gtk_builder_get_object (builder, "combobox_icon");
		_tmp13_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp12_));
		_g_object_unref0 (self->priv->combobox_icon);
		self->priv->combobox_icon = _tmp13_;
		_tmp14_ = gtk_builder_get_object (builder, "entry_command");
		_tmp15_ = _g_object_ref0 (GTK_ENTRY (_tmp14_));
		_g_object_unref0 (self->priv->entry_command);
		self->priv->entry_command = _tmp15_;
		_tmp16_ = gtk_builder_get_object (builder, "button_add");
		_tmp17_ = _g_object_ref0 (GTK_BUTTON (_tmp16_));
		_g_object_unref0 (self->priv->button_add);
		self->priv->button_add = _tmp17_;
		_tmp18_ = gtk_builder_get_object (builder, "treeview_jobs");
		_tmp19_ = _g_object_ref0 (GTK_TREE_VIEW (_tmp18_));
		_g_object_unref0 (self->priv->treeview_jobs);
		self->priv->treeview_jobs = _tmp19_;
		_tmp20_ = gtk_builder_get_object (builder, "button_delete");
		_tmp21_ = _g_object_ref0 (GTK_BUTTON (_tmp20_));
		_g_object_unref0 (self->priv->button_delete);
		self->priv->button_delete = _tmp21_;
		_tmp22_ = gtk_builder_get_object (builder, "button_up");
		_tmp23_ = _g_object_ref0 (GTK_BUTTON (_tmp22_));
		_g_object_unref0 (self->priv->button_up);
		self->priv->button_up = _tmp23_;
		_tmp24_ = gtk_builder_get_object (builder, "button_down");
		_tmp25_ = _g_object_ref0 (GTK_BUTTON (_tmp24_));
		_g_object_unref0 (self->priv->button_down);
		self->priv->button_down = _tmp25_;
		_tmp26_ = gtk_dialog_get_content_area ((GtkDialog*) self);
		_tmp27_ = _g_object_ref0 (GTK_BOX (_tmp26_));
		content_area = _tmp27_;
		_tmp28_ = content_area;
		_tmp29_ = main_vbox;
		gtk_box_pack_start (_tmp28_, (GtkWidget*) _tmp29_, TRUE, TRUE, (guint) 0);
		_tmp30_ = content_area;
		gtk_widget_show_all ((GtkWidget*) _tmp30_);
		build_tool_dialog_init_icon_treeview (self);
		build_tool_dialog_init_jobs_treeview (self);
		build_tool_dialog_init_actions (self);
		_g_object_unref0 (content_area);
		_g_object_unref0 (main_vbox);
		_g_object_unref0 (builder);
		_g_free0 (path);
	}
	goto __finally29;
	__catch29_g_error:
	{
		GError* e = NULL;
		GError* _tmp31_;
		const gchar* _tmp32_;
		gchar* _tmp33_ = NULL;
		gchar* message;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		GtkLabel* _tmp36_;
		GtkLabel* _tmp37_;
		GtkLabel* label_error;
		GtkLabel* _tmp38_;
		GtkWidget* _tmp39_ = NULL;
		GtkBox* _tmp40_;
		GtkBox* content_area;
		GtkBox* _tmp41_;
		GtkLabel* _tmp42_;
		GtkBox* _tmp43_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp31_ = e;
		_tmp32_ = _tmp31_->message;
		_tmp33_ = g_strdup_printf ("Error: %s", _tmp32_);
		message = _tmp33_;
		_tmp34_ = message;
		g_warning ("build_tool_dialog.vala:109: %s", _tmp34_);
		_tmp35_ = message;
		_tmp36_ = (GtkLabel*) gtk_label_new (_tmp35_);
		_tmp37_ = g_object_ref_sink (_tmp36_);
		label_error = _tmp37_;
		_tmp38_ = label_error;
		gtk_label_set_line_wrap (_tmp38_, TRUE);
		_tmp39_ = gtk_dialog_get_content_area ((GtkDialog*) self);
		_tmp40_ = _g_object_ref0 (GTK_BOX (_tmp39_));
		content_area = _tmp40_;
		_tmp41_ = content_area;
		_tmp42_ = label_error;
		gtk_box_pack_start (_tmp41_, (GtkWidget*) _tmp42_, TRUE, TRUE, (guint) 0);
		_tmp43_ = content_area;
		gtk_widget_show_all ((GtkWidget*) _tmp43_);
		_g_object_unref0 (content_area);
		_g_object_unref0 (label_error);
		_g_free0 (message);
		_g_error_free0 (e);
	}
	__finally29:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


static BuildToolDialog* build_tool_dialog_new (void) {
	return build_tool_dialog_construct (TYPE_BUILD_TOOL_DIALOG);
}


static void ___lambda88_ (void) {
	BuildToolDialog* _tmp0_;
	_tmp0_ = build_tool_dialog_instance;
	if (_tmp0_ != NULL) {
		_g_object_unref0 (build_tool_dialog_instance);
		build_tool_dialog_instance = NULL;
	}
}


static void ____lambda88__gtk_object_destroy (GtkObject* _sender, gpointer self) {
	___lambda88_ ();
}


gboolean build_tool_dialog_show_me (GtkWindow* parent, gint num) {
	gboolean result = FALSE;
	BuildToolDialog* _tmp0_;
	GtkWindow* _tmp4_;
	BuildToolDialog* _tmp5_;
	GtkWindow* _tmp6_ = NULL;
	BuildToolDialog* _tmp9_;
	BuildToolDialog* _tmp10_;
	gint _tmp11_;
	BuildToolDialog* _tmp12_;
	gint _tmp13_;
	gboolean _tmp14_ = FALSE;
	g_return_val_if_fail (parent != NULL, FALSE);
	_tmp0_ = build_tool_dialog_instance;
	if (_tmp0_ == NULL) {
		BuildToolDialog* _tmp1_;
		BuildToolDialog* _tmp2_;
		BuildToolDialog* _tmp3_;
		_tmp1_ = build_tool_dialog_new ();
		_tmp2_ = g_object_ref_sink (_tmp1_);
		_g_object_unref0 (build_tool_dialog_instance);
		build_tool_dialog_instance = _tmp2_;
		_tmp3_ = build_tool_dialog_instance;
		g_signal_connect ((GtkObject*) _tmp3_, "destroy", (GCallback) ____lambda88__gtk_object_destroy, NULL);
	}
	_tmp4_ = parent;
	_tmp5_ = build_tool_dialog_instance;
	_tmp6_ = gtk_window_get_transient_for ((GtkWindow*) _tmp5_);
	if (_tmp4_ != _tmp6_) {
		BuildToolDialog* _tmp7_;
		GtkWindow* _tmp8_;
		_tmp7_ = build_tool_dialog_instance;
		_tmp8_ = parent;
		gtk_window_set_transient_for ((GtkWindow*) _tmp7_, _tmp8_);
	}
	_tmp9_ = build_tool_dialog_instance;
	gtk_window_present ((GtkWindow*) _tmp9_);
	_tmp10_ = build_tool_dialog_instance;
	_tmp11_ = num;
	build_tool_dialog_init (_tmp10_, _tmp11_);
	_tmp12_ = build_tool_dialog_instance;
	_tmp13_ = num;
	_tmp14_ = build_tool_dialog_run_me (_tmp12_, _tmp13_);
	result = _tmp14_;
	return result;
}


static void build_tool_dialog_init_icon_treeview (BuildToolDialog* self) {
	GtkListStore* _tmp0_;
	GtkListStore* icon_store;
	GtkComboBox* _tmp11_;
	GtkListStore* _tmp12_;
	GtkCellRendererPixbuf* _tmp13_;
	GtkCellRendererPixbuf* _tmp14_;
	GtkCellRendererPixbuf* pixbuf_renderer;
	GtkComboBox* _tmp15_;
	GtkComboBox* _tmp16_;
	GtkCellRendererText* _tmp17_;
	GtkCellRendererText* _tmp18_;
	GtkCellRendererText* text_renderer;
	GtkComboBox* _tmp19_;
	GtkComboBox* _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);
	icon_store = _tmp0_;
	{
		BuildToolDialogIconColumn* icon_collection = NULL;
		gint icon_collection_length1 = 0;
		gint _icon_collection_size_ = 0;
		gint icon_it = 0;
		icon_collection = BUILD_TOOL_DIALOG_icons;
		icon_collection_length1 = G_N_ELEMENTS (BUILD_TOOL_DIALOG_icons);
		for (icon_it = 0; icon_it < G_N_ELEMENTS (BUILD_TOOL_DIALOG_icons); icon_it = icon_it + 1) {
			BuildToolDialogIconColumn _tmp1_ = {0};
			BuildToolDialogIconColumn icon = {0};
			build_tool_dialog_icon_column_copy (&icon_collection[icon_it], &_tmp1_);
			icon = _tmp1_;
			{
				GtkTreeIter iter = {0};
				GtkListStore* _tmp2_;
				GtkTreeIter _tmp3_ = {0};
				GtkListStore* _tmp4_;
				GtkTreeIter _tmp5_;
				BuildToolDialogIconColumn _tmp6_;
				const gchar* _tmp7_;
				BuildToolDialogIconColumn _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_ = NULL;
				_tmp2_ = icon_store;
				gtk_list_store_append (_tmp2_, &_tmp3_);
				iter = _tmp3_;
				_tmp4_ = icon_store;
				_tmp5_ = iter;
				_tmp6_ = icon;
				_tmp7_ = _tmp6_.stock_id;
				_tmp8_ = icon;
				_tmp9_ = _tmp8_.label;
				_tmp10_ = _ (_tmp9_);
				gtk_list_store_set (_tmp4_, &_tmp5_, 0, _tmp7_, 1, _tmp10_, -1, -1);
				build_tool_dialog_icon_column_destroy (&icon);
			}
		}
	}
	_tmp11_ = self->priv->combobox_icon;
	_tmp12_ = icon_store;
	gtk_combo_box_set_model (_tmp11_, (GtkTreeModel*) _tmp12_);
	_tmp13_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	_tmp14_ = g_object_ref_sink (_tmp13_);
	pixbuf_renderer = _tmp14_;
	_tmp15_ = self->priv->combobox_icon;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp15_, (GtkCellRenderer*) pixbuf_renderer, FALSE);
	_tmp16_ = self->priv->combobox_icon;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp16_, (GtkCellRenderer*) pixbuf_renderer, "stock-id", 0, NULL, NULL);
	_tmp17_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp18_ = g_object_ref_sink (_tmp17_);
	text_renderer = _tmp18_;
	_tmp19_ = self->priv->combobox_icon;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp19_, (GtkCellRenderer*) text_renderer, TRUE);
	_tmp20_ = self->priv->combobox_icon;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp20_, (GtkCellRenderer*) text_renderer, "text", 1, NULL, NULL);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
	_g_object_unref0 (icon_store);
}


static void __lambda82_ (BuildToolDialog* self, const gchar* path_string, const gchar* new_text) {
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	const gchar* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	GtkListStore* _tmp3_;
	GtkTreeIter _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (path_string != NULL);
	g_return_if_fail (new_text != NULL);
	_tmp0_ = self->priv->jobs_store;
	_tmp1_ = path_string;
	gtk_tree_model_get_iter_from_string ((GtkTreeModel*) _tmp0_, &_tmp2_, _tmp1_);
	iter = _tmp2_;
	_tmp3_ = self->priv->jobs_store;
	_tmp4_ = iter;
	_tmp5_ = new_text;
	gtk_list_store_set (_tmp3_, &_tmp4_, BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, _tmp5_, -1, -1);
}


static void ___lambda82__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender, const gchar* path, const gchar* new_text, gpointer self) {
	__lambda82_ (self, path, new_text);
}


static void __lambda83_ (BuildToolDialog* self, const gchar* path_string) {
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	const gchar* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gboolean val = FALSE;
	GtkListStore* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* model;
	GtkTreeIter _tmp5_;
	GtkListStore* _tmp6_;
	GtkTreeIter _tmp7_;
	g_return_if_fail (path_string != NULL);
	_tmp0_ = self->priv->jobs_store;
	_tmp1_ = path_string;
	gtk_tree_model_get_iter_from_string ((GtkTreeModel*) _tmp0_, &_tmp2_, _tmp1_);
	iter = _tmp2_;
	_tmp3_ = self->priv->jobs_store;
	_tmp4_ = _g_object_ref0 (GTK_TREE_MODEL (_tmp3_));
	model = _tmp4_;
	_tmp5_ = iter;
	gtk_tree_model_get (model, &_tmp5_, BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED, &val, -1, -1);
	_tmp6_ = self->priv->jobs_store;
	_tmp7_ = iter;
	gtk_list_store_set (_tmp6_, &_tmp7_, BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED, !val, -1, -1);
	_g_object_unref0 (model);
}


static void ___lambda83__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const gchar* path, gpointer self) {
	__lambda83_ (self, path);
}


static void __lambda84_ (BuildToolDialog* self, const gchar* path_string, const gchar* new_text) {
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	const gchar* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	GtkListStore* _tmp3_;
	GtkTreeIter _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (path_string != NULL);
	g_return_if_fail (new_text != NULL);
	_tmp0_ = self->priv->jobs_store;
	_tmp1_ = path_string;
	gtk_tree_model_get_iter_from_string ((GtkTreeModel*) _tmp0_, &_tmp2_, _tmp1_);
	iter = _tmp2_;
	_tmp3_ = self->priv->jobs_store;
	_tmp4_ = iter;
	_tmp5_ = new_text;
	gtk_list_store_set (_tmp3_, &_tmp4_, BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, _tmp5_, -1, -1);
}


static void ___lambda84__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender, const gchar* path, const gchar* new_text, gpointer self) {
	__lambda84_ (self, path, new_text);
}


static void build_tool_dialog_init_jobs_treeview (BuildToolDialog* self) {
	GtkListStore* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkListStore* _tmp2_;
	GtkListStore* _tmp3_;
	GtkListStore* post_processor_store;
	GtkCellRendererText* _tmp15_;
	GtkCellRendererText* _tmp16_;
	GtkCellRendererText* text_renderer;
	const gchar* _tmp17_ = NULL;
	GtkTreeViewColumn* _tmp18_;
	GtkTreeViewColumn* _tmp19_;
	GtkTreeViewColumn* column;
	GtkTreeView* _tmp20_;
	GtkCellRendererToggle* _tmp21_;
	GtkCellRendererToggle* _tmp22_;
	GtkCellRendererToggle* toggle_renderer;
	GtkTreeView* _tmp23_;
	const gchar* _tmp24_ = NULL;
	GtkCellRendererCombo* _tmp25_;
	GtkCellRendererCombo* _tmp26_;
	GtkCellRendererCombo* combo_renderer;
	GtkListStore* _tmp27_;
	GtkTreeView* _tmp28_;
	const gchar* _tmp29_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_list_store_new ((gint) BUILD_TOOL_DIALOG_JOB_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_STRING);
	_g_object_unref0 (self->priv->jobs_store);
	self->priv->jobs_store = _tmp0_;
	_tmp1_ = self->priv->treeview_jobs;
	_tmp2_ = self->priv->jobs_store;
	gtk_tree_view_set_model (_tmp1_, (GtkTreeModel*) _tmp2_);
	_tmp3_ = gtk_list_store_new (1, G_TYPE_STRING);
	post_processor_store = _tmp3_;
	{
		gint type;
		type = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				gint _tmp7_;
				GtkTreeIter iterpp = {0};
				GtkListStore* _tmp8_;
				GtkTreeIter _tmp9_ = {0};
				GtkListStore* _tmp10_;
				GtkTreeIter _tmp11_;
				gint _tmp12_;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = type;
					type = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = type;
				if (!(_tmp7_ < ((gint) POST_PROCESSOR_TYPE_N_POST_PROCESSORS))) {
					break;
				}
				_tmp8_ = post_processor_store;
				gtk_list_store_append (_tmp8_, &_tmp9_);
				iterpp = _tmp9_;
				_tmp10_ = post_processor_store;
				_tmp11_ = iterpp;
				_tmp12_ = type;
				_tmp13_ = build_tools_get_post_processor_name_from_type ((PostProcessorType) _tmp12_);
				_tmp14_ = _tmp13_;
				gtk_list_store_set (_tmp10_, &_tmp11_, 0, _tmp14_, -1, -1);
				_g_free0 (_tmp14_);
			}
		}
	}
	_tmp15_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp16_ = g_object_ref_sink (_tmp15_);
	text_renderer = _tmp16_;
	g_object_set (text_renderer, "editable", TRUE, NULL);
	_tmp17_ = _ ("Commands");
	_tmp18_ = gtk_tree_view_column_new_with_attributes (_tmp17_, (GtkCellRenderer*) text_renderer, "text", BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, NULL, NULL);
	_tmp19_ = g_object_ref_sink (_tmp18_);
	column = _tmp19_;
	gtk_tree_view_column_set_resizable (column, TRUE);
	_tmp20_ = self->priv->treeview_jobs;
	gtk_tree_view_append_column (_tmp20_, column);
	_tmp21_ = (GtkCellRendererToggle*) gtk_cell_renderer_toggle_new ();
	_tmp22_ = g_object_ref_sink (_tmp21_);
	toggle_renderer = _tmp22_;
	gtk_cell_renderer_toggle_set_activatable (toggle_renderer, TRUE);
	_tmp23_ = self->priv->treeview_jobs;
	_tmp24_ = _ ("Must Succeed");
	gtk_tree_view_insert_column_with_attributes (_tmp23_, -1, _tmp24_, (GtkCellRenderer*) toggle_renderer, "active", BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED, NULL, NULL);
	_tmp25_ = (GtkCellRendererCombo*) gtk_cell_renderer_combo_new ();
	_tmp26_ = g_object_ref_sink (_tmp25_);
	combo_renderer = _tmp26_;
	g_object_set ((GtkCellRendererText*) combo_renderer, "editable", TRUE, NULL);
	_tmp27_ = post_processor_store;
	g_object_set (combo_renderer, "model", (GtkTreeModel*) _tmp27_, NULL);
	g_object_set (combo_renderer, "text-column", 0, NULL);
	g_object_set (combo_renderer, "has-entry", FALSE, NULL);
	_tmp28_ = self->priv->treeview_jobs;
	_tmp29_ = _ ("Post Processor");
	gtk_tree_view_insert_column_with_attributes (_tmp28_, -1, _tmp29_, (GtkCellRenderer*) combo_renderer, "text", BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, NULL, NULL);
	g_signal_connect_object (text_renderer, "edited", (GCallback) ___lambda82__gtk_cell_renderer_text_edited, self, 0);
	g_signal_connect_object (toggle_renderer, "toggled", (GCallback) ___lambda83__gtk_cell_renderer_toggle_toggled, self, 0);
	g_signal_connect_object ((GtkCellRendererText*) combo_renderer, "edited", (GCallback) ___lambda84__gtk_cell_renderer_text_edited, self, 0);
	_g_object_unref0 (combo_renderer);
	_g_object_unref0 (toggle_renderer);
	_g_object_unref0 (column);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (post_processor_store);
}


static void _build_tool_dialog_on_command_add_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	build_tool_dialog_on_command_add (self);
}


static void _build_tool_dialog_on_command_add_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	build_tool_dialog_on_command_add (self);
}


static void __lambda85_ (BuildToolDialog* self) {
	GtkTreeIter iter = {0};
	GtkTreeView* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gint _tmp2_ = 0;
	gint i;
	gint _tmp3_;
	_tmp0_ = self->priv->treeview_jobs;
	_tmp2_ = utils_get_selected_row (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	i = _tmp2_;
	_tmp3_ = i;
	if (_tmp3_ != (-1)) {
		GtkListStore* _tmp4_;
		GtkTreeIter _tmp5_;
		_tmp4_ = self->priv->jobs_store;
		_tmp5_ = iter;
		gtk_list_store_remove (_tmp4_, &_tmp5_);
	}
}


static void ___lambda85__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda85_ (self);
}


static void __lambda86_ (BuildToolDialog* self) {
	GtkTreeIter iter1 = {0};
	GtkTreeIter iter2 = {0};
	GtkTreeView* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gint _tmp2_ = 0;
	gint i;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_;
	gboolean _tmp6_;
	_tmp0_ = self->priv->treeview_jobs;
	_tmp2_ = utils_get_selected_row (_tmp0_, &_tmp1_);
	iter1 = _tmp1_;
	i = _tmp2_;
	_tmp4_ = i;
	if (_tmp4_ != (-1)) {
		gint _tmp5_;
		_tmp5_ = i;
		_tmp3_ = _tmp5_ > 0;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp6_ = _tmp3_;
	if (_tmp6_) {
		GtkTreeIter _tmp7_;
		GtkListStore* _tmp8_;
		gboolean _tmp9_ = FALSE;
		_tmp7_ = iter1;
		iter2 = _tmp7_;
		_tmp8_ = self->priv->jobs_store;
		_tmp9_ = utils_tree_model_iter_prev ((GtkTreeModel*) _tmp8_, &iter2);
		if (_tmp9_) {
			GtkListStore* _tmp10_;
			GtkTreeIter _tmp11_;
			GtkTreeIter _tmp12_;
			_tmp10_ = self->priv->jobs_store;
			_tmp11_ = iter1;
			_tmp12_ = iter2;
			gtk_list_store_swap (_tmp10_, &_tmp11_, &_tmp12_);
		}
	}
}


static void ___lambda86__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda86_ (self);
}


static void __lambda87_ (BuildToolDialog* self) {
	GtkTreeIter iter1 = {0};
	GtkTreeIter iter2 = {0};
	GtkTreeView* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gint _tmp2_ = 0;
	gint i;
	gint _tmp3_;
	_tmp0_ = self->priv->treeview_jobs;
	_tmp2_ = utils_get_selected_row (_tmp0_, &_tmp1_);
	iter1 = _tmp1_;
	i = _tmp2_;
	_tmp3_ = i;
	if (_tmp3_ != (-1)) {
		GtkTreeIter _tmp4_;
		GtkListStore* _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = iter1;
		iter2 = _tmp4_;
		_tmp5_ = self->priv->jobs_store;
		_tmp6_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp5_, &iter2);
		if (_tmp6_) {
			GtkListStore* _tmp7_;
			GtkTreeIter _tmp8_;
			GtkTreeIter _tmp9_;
			_tmp7_ = self->priv->jobs_store;
			_tmp8_ = iter1;
			_tmp9_ = iter2;
			gtk_list_store_swap (_tmp7_, &_tmp8_, &_tmp9_);
		}
	}
}


static void ___lambda87__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda87_ (self);
}


static void build_tool_dialog_init_actions (BuildToolDialog* self) {
	GtkButton* _tmp0_;
	GtkEntry* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->button_add;
	g_signal_connect_object (_tmp0_, "clicked", (GCallback) _build_tool_dialog_on_command_add_gtk_button_clicked, self, 0);
	_tmp1_ = self->priv->entry_command;
	g_signal_connect_object (_tmp1_, "activate", (GCallback) _build_tool_dialog_on_command_add_gtk_entry_activate, self, 0);
	_tmp2_ = self->priv->button_delete;
	g_signal_connect_object (_tmp2_, "clicked", (GCallback) ___lambda85__gtk_button_clicked, self, 0);
	_tmp3_ = self->priv->button_up;
	g_signal_connect_object (_tmp3_, "clicked", (GCallback) ___lambda86__gtk_button_clicked, self, 0);
	_tmp4_ = self->priv->button_down;
	g_signal_connect_object (_tmp4_, "clicked", (GCallback) ___lambda87__gtk_button_clicked, self, 0);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void build_tool_dialog_on_command_add (BuildToolDialog* self) {
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gboolean _tmp5_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp6_;
	GtkTreeIter _tmp7_ = {0};
	GtkListStore* _tmp8_;
	GtkTreeIter _tmp9_;
	GtkEntry* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	GtkEntry* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->entry_command;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = string_strip (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp4_, "") == 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		return;
	}
	_tmp6_ = self->priv->jobs_store;
	gtk_list_store_append (_tmp6_, &_tmp7_);
	iter = _tmp7_;
	_tmp8_ = self->priv->jobs_store;
	_tmp9_ = iter;
	_tmp10_ = self->priv->entry_command;
	_tmp11_ = gtk_entry_get_text (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = build_tools_get_post_processor_name_from_type (POST_PROCESSOR_TYPE_NO_OUTPUT);
	_tmp14_ = _tmp13_;
	gtk_list_store_set (_tmp8_, &_tmp9_, BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, _tmp12_, BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED, TRUE, BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, _tmp14_, -1, -1);
	_g_free0 (_tmp14_);
	_tmp15_ = self->priv->entry_command;
	gtk_entry_set_text (_tmp15_, "");
}


static void build_tool_dialog_init (BuildToolDialog* self, gint num) {
	GtkEntry* _tmp0_;
	GtkListStore* _tmp1_;
	GtkEntry* _tmp2_;
	GtkEntry* _tmp3_;
	gint _tmp4_;
	GtkTreeView* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->entry_command;
	gtk_entry_set_text (_tmp0_, "");
	_tmp1_ = self->priv->jobs_store;
	gtk_list_store_clear (_tmp1_);
	_tmp2_ = self->priv->entry_label;
	utils_set_entry_error ((GtkWidget*) _tmp2_, FALSE);
	_tmp3_ = self->priv->entry_command;
	utils_set_entry_error ((GtkWidget*) _tmp3_, FALSE);
	_tmp4_ = num;
	if (_tmp4_ == (-1)) {
		BuildToolDialog* _tmp5_;
		_tmp5_ = build_tool_dialog_instance;
		build_tool_dialog_init_new_build_tool (_tmp5_);
	} else {
		BuildToolDialog* _tmp6_;
		BuildTools* _tmp7_ = NULL;
		BuildTools* _tmp8_;
		gint _tmp9_;
		BuildTool* _tmp10_ = NULL;
		BuildTool* _tmp11_;
		BuildTool _tmp12_;
		_tmp6_ = build_tool_dialog_instance;
		_tmp7_ = build_tools_get_default ();
		_tmp8_ = _tmp7_;
		_tmp9_ = num;
		_tmp10_ = build_tools_get (_tmp8_, _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = *_tmp11_;
		build_tool_dialog_init_with_build_tool (_tmp6_, &_tmp12_);
		_build_tool_free0 (_tmp11_);
		_build_tools_unref0 (_tmp8_);
	}
	_tmp13_ = self->priv->treeview_jobs;
	gtk_tree_view_columns_autosize (_tmp13_);
}


static void build_tool_dialog_init_new_build_tool (BuildToolDialog* self) {
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* _tmp2_;
	GtkComboBox* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->entry_label;
	gtk_entry_set_text (_tmp0_, "");
	_tmp1_ = self->priv->entry_desc;
	gtk_entry_set_text (_tmp1_, "");
	_tmp2_ = self->priv->entry_extensions;
	gtk_entry_set_text (_tmp2_, ".tex");
	_tmp3_ = self->priv->combobox_icon;
	gtk_combo_box_set_active (_tmp3_, 0);
}


static void build_tool_dialog_init_with_build_tool (BuildToolDialog* self, BuildTool* tool) {
	GtkEntry* _tmp0_;
	BuildTool _tmp1_;
	const gchar* _tmp2_;
	GtkEntry* _tmp3_;
	BuildTool _tmp4_;
	const gchar* _tmp5_;
	GtkEntry* _tmp6_;
	BuildTool _tmp7_;
	const gchar* _tmp8_;
	GtkComboBox* _tmp9_;
	GtkListStore* _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tool != NULL);
	_tmp0_ = self->priv->entry_label;
	_tmp1_ = *tool;
	_tmp2_ = _tmp1_.label;
	gtk_entry_set_text (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->entry_desc;
	_tmp4_ = *tool;
	_tmp5_ = _tmp4_.description;
	gtk_entry_set_text (_tmp3_, _tmp5_);
	_tmp6_ = self->priv->entry_extensions;
	_tmp7_ = *tool;
	_tmp8_ = _tmp7_.extensions;
	gtk_entry_set_text (_tmp6_, _tmp8_);
	_tmp9_ = self->priv->combobox_icon;
	gtk_combo_box_set_active (_tmp9_, 0);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp10_;
			_tmp10_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_;
				gint _tmp13_;
				gint _tmp14_;
				BuildToolDialogIconColumn _tmp15_;
				const gchar* _tmp16_;
				BuildTool _tmp17_;
				const gchar* _tmp18_;
				_tmp11_ = _tmp10_;
				if (!_tmp11_) {
					gint _tmp12_;
					_tmp12_ = i;
					i = _tmp12_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp13_ = i;
				if (!(_tmp13_ < G_N_ELEMENTS (BUILD_TOOL_DIALOG_icons))) {
					break;
				}
				_tmp14_ = i;
				_tmp15_ = BUILD_TOOL_DIALOG_icons[_tmp14_];
				_tmp16_ = _tmp15_.stock_id;
				_tmp17_ = *tool;
				_tmp18_ = _tmp17_.icon;
				if (g_strcmp0 (_tmp16_, _tmp18_) == 0) {
					GtkComboBox* _tmp19_;
					gint _tmp20_;
					_tmp19_ = self->priv->combobox_icon;
					_tmp20_ = i;
					gtk_combo_box_set_active (_tmp19_, _tmp20_);
					break;
				}
			}
		}
	}
	_tmp21_ = self->priv->jobs_store;
	gtk_list_store_clear (_tmp21_);
	{
		BuildTool _tmp22_;
		GeeArrayList* _tmp23_;
		GeeArrayList* _tmp24_;
		GeeArrayList* _job_list;
		GeeArrayList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _job_size;
		gint _job_index;
		_tmp22_ = *tool;
		_tmp23_ = _tmp22_.jobs;
		_tmp24_ = _g_object_ref0 (_tmp23_);
		_job_list = _tmp24_;
		_tmp25_ = _job_list;
		_tmp26_ = gee_collection_get_size ((GeeCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_job_size = _tmp27_;
		_job_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			GeeArrayList* _tmp31_;
			gint _tmp32_;
			gpointer _tmp33_ = NULL;
			BuildJob* _tmp34_;
			BuildJob _tmp35_ = {0};
			BuildJob _tmp36_;
			BuildJob job;
			GtkTreeIter iter = {0};
			GtkListStore* _tmp37_;
			GtkTreeIter _tmp38_ = {0};
			GtkListStore* _tmp39_;
			GtkTreeIter _tmp40_;
			BuildJob _tmp41_;
			const gchar* _tmp42_;
			BuildJob _tmp43_;
			gboolean _tmp44_;
			BuildJob _tmp45_;
			PostProcessorType _tmp46_;
			gchar* _tmp47_ = NULL;
			gchar* _tmp48_;
			_tmp28_ = _job_index;
			_job_index = _tmp28_ + 1;
			_tmp29_ = _job_index;
			_tmp30_ = _job_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _job_list;
			_tmp32_ = _job_index;
			_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, _tmp32_);
			_tmp34_ = (BuildJob*) _tmp33_;
			build_job_copy (_tmp34_, &_tmp35_);
			_tmp36_ = _tmp35_;
			_build_job_free0 (_tmp34_);
			job = _tmp36_;
			_tmp37_ = self->priv->jobs_store;
			gtk_list_store_append (_tmp37_, &_tmp38_);
			iter = _tmp38_;
			_tmp39_ = self->priv->jobs_store;
			_tmp40_ = iter;
			_tmp41_ = job;
			_tmp42_ = _tmp41_.command;
			_tmp43_ = job;
			_tmp44_ = _tmp43_.must_succeed;
			_tmp45_ = job;
			_tmp46_ = _tmp45_.post_processor;
			_tmp47_ = build_tools_get_post_processor_name_from_type (_tmp46_);
			_tmp48_ = _tmp47_;
			gtk_list_store_set (_tmp39_, &_tmp40_, BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, _tmp42_, BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED, _tmp44_, BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, _tmp48_, -1, -1);
			_g_free0 (_tmp48_);
			build_job_destroy (&job);
		}
		_g_object_unref0 (_job_list);
	}
}


static gboolean build_tool_dialog_run_me (BuildToolDialog* self, gint num) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	while (TRUE) {
		gint _tmp0_ = 0;
		gboolean ok;
		GtkEntry* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gboolean _tmp6_;
		GtkTreeIter iter = {0};
		GtkListStore* _tmp9_;
		GtkTreeIter _tmp10_ = {0};
		gboolean _tmp11_ = FALSE;
		gboolean _tmp14_;
		BuildTool tool = {0};
		GtkEntry* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		GtkEntry* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_;
		gboolean _tmp25_;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		GtkEntry* _tmp35_;
		const gchar* _tmp36_;
		const gchar* _tmp37_;
		gchar* _tmp38_ = NULL;
		GeeArrayList* _tmp39_;
		GtkComboBox* _tmp40_;
		GtkTreeIter _tmp41_ = {0};
		GtkComboBox* _tmp42_;
		GtkTreeModel* _tmp43_ = NULL;
		GtkTreeModel* _tmp44_;
		GtkTreeModel* model;
		GtkTreeModel* _tmp45_;
		GtkTreeIter _tmp46_;
		GtkTreeView* _tmp47_;
		GtkTreeModel* _tmp48_ = NULL;
		GtkTreeModel* _tmp49_;
		GtkListStore* _tmp50_;
		GtkTreeIter _tmp51_ = {0};
		gboolean _tmp52_ = FALSE;
		gboolean valid;
		gint _tmp66_;
		_tmp0_ = gtk_dialog_run ((GtkDialog*) self);
		if (!(_tmp0_ == ((gint) GTK_RESPONSE_OK))) {
			break;
		}
		ok = TRUE;
		_tmp1_ = self->priv->entry_label;
		_tmp2_ = gtk_entry_get_text (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = string_strip (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strcmp0 (_tmp5_, "") == 0;
		_g_free0 (_tmp5_);
		if (_tmp6_) {
			GtkEntry* _tmp7_;
			_tmp7_ = self->priv->entry_label;
			utils_set_entry_error ((GtkWidget*) _tmp7_, TRUE);
			ok = FALSE;
		} else {
			GtkEntry* _tmp8_;
			_tmp8_ = self->priv->entry_label;
			utils_set_entry_error ((GtkWidget*) _tmp8_, FALSE);
		}
		_tmp9_ = self->priv->jobs_store;
		_tmp11_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp9_, &_tmp10_);
		iter = _tmp10_;
		if (!_tmp11_) {
			GtkEntry* _tmp12_;
			_tmp12_ = self->priv->entry_command;
			utils_set_entry_error ((GtkWidget*) _tmp12_, TRUE);
			ok = FALSE;
		} else {
			GtkEntry* _tmp13_;
			_tmp13_ = self->priv->entry_command;
			utils_set_entry_error ((GtkWidget*) _tmp13_, FALSE);
		}
		_tmp14_ = ok;
		if (!_tmp14_) {
			continue;
		}
		memset (&tool, 0, sizeof (BuildTool));
		_tmp15_ = self->priv->entry_label;
		_tmp16_ = gtk_entry_get_text (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = string_strip (_tmp17_);
		_g_free0 (tool.label);
		tool.label = _tmp18_;
		_tmp20_ = self->priv->entry_desc;
		_tmp21_ = gtk_entry_get_text (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = string_strip (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strcmp0 (_tmp24_, "") == 0;
		_g_free0 (_tmp24_);
		if (_tmp25_) {
			BuildTool _tmp26_;
			const gchar* _tmp27_;
			gchar* _tmp28_;
			_tmp26_ = tool;
			_tmp27_ = _tmp26_.label;
			_tmp28_ = g_strdup (_tmp27_);
			_g_free0 (_tmp19_);
			_tmp19_ = _tmp28_;
		} else {
			GtkEntry* _tmp29_;
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			gchar* _tmp32_ = NULL;
			_tmp29_ = self->priv->entry_desc;
			_tmp30_ = gtk_entry_get_text (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = string_strip (_tmp31_);
			_g_free0 (_tmp19_);
			_tmp19_ = _tmp32_;
		}
		_tmp33_ = _tmp19_;
		_tmp34_ = g_strdup (_tmp33_);
		_g_free0 (tool.description);
		tool.description = _tmp34_;
		_tmp35_ = self->priv->entry_extensions;
		_tmp36_ = gtk_entry_get_text (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = string_strip (_tmp37_);
		_g_free0 (tool.extensions);
		tool.extensions = _tmp38_;
		_tmp39_ = gee_array_list_new (TYPE_BUILD_JOB, (GBoxedCopyFunc) build_job_dup, build_job_free, NULL);
		_g_object_unref0 (tool.jobs);
		tool.jobs = _tmp39_;
		_tmp40_ = self->priv->combobox_icon;
		gtk_combo_box_get_active_iter (_tmp40_, &_tmp41_);
		iter = _tmp41_;
		_tmp42_ = self->priv->combobox_icon;
		_tmp43_ = gtk_combo_box_get_model (_tmp42_);
		_tmp44_ = _g_object_ref0 (_tmp43_);
		model = _tmp44_;
		_tmp45_ = model;
		_tmp46_ = iter;
		gtk_tree_model_get (_tmp45_, &_tmp46_, 0, &tool.icon, -1, -1);
		_tmp47_ = self->priv->treeview_jobs;
		_tmp48_ = gtk_tree_view_get_model (_tmp47_);
		_tmp49_ = _g_object_ref0 (_tmp48_);
		_g_object_unref0 (model);
		model = _tmp49_;
		_tmp50_ = self->priv->jobs_store;
		_tmp52_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp50_, &_tmp51_);
		iter = _tmp51_;
		valid = _tmp52_;
		while (TRUE) {
			gboolean _tmp53_;
			BuildJob job = {0};
			gchar* command = NULL;
			gchar* post_processor_name = NULL;
			GtkTreeModel* _tmp54_;
			GtkTreeIter _tmp55_;
			const gchar* _tmp56_;
			gchar* _tmp57_ = NULL;
			const gchar* _tmp58_;
			PostProcessorType* _tmp59_ = 0;
			PostProcessorType* _tmp60_;
			BuildTool _tmp61_;
			GeeArrayList* _tmp62_;
			BuildJob _tmp63_;
			GtkListStore* _tmp64_;
			gboolean _tmp65_ = FALSE;
			_tmp53_ = valid;
			if (!_tmp53_) {
				break;
			}
			memset (&job, 0, sizeof (BuildJob));
			_tmp54_ = model;
			_tmp55_ = iter;
			gtk_tree_model_get (_tmp54_, &_tmp55_, BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, &command, BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED, &job.must_succeed, BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, &post_processor_name, -1, -1);
			_tmp56_ = command;
			_tmp57_ = string_strip (_tmp56_);
			_g_free0 (job.command);
			job.command = _tmp57_;
			_tmp58_ = post_processor_name;
			_tmp59_ = build_tools_get_post_processor_type_from_name (_tmp58_);
			_tmp60_ = _tmp59_;
			job.post_processor = *_tmp60_;
			_g_free0 (_tmp60_);
			_tmp61_ = tool;
			_tmp62_ = _tmp61_.jobs;
			_tmp63_ = job;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp62_, &_tmp63_);
			_tmp64_ = self->priv->jobs_store;
			_tmp65_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp64_, &iter);
			valid = _tmp65_;
			_g_free0 (post_processor_name);
			_g_free0 (command);
			build_job_destroy (&job);
		}
		_tmp66_ = num;
		if (_tmp66_ == (-1)) {
			BuildTools* _tmp67_ = NULL;
			BuildTools* _tmp68_;
			BuildTool _tmp69_;
			tool.show = TRUE;
			_tmp67_ = build_tools_get_default ();
			_tmp68_ = _tmp67_;
			_tmp69_ = tool;
			build_tools_add (_tmp68_, &_tmp69_);
			_build_tools_unref0 (_tmp68_);
		} else {
			BuildTools* _tmp70_ = NULL;
			BuildTools* _tmp71_;
			gint _tmp72_;
			BuildTool _tmp73_;
			_tmp70_ = build_tools_get_default ();
			_tmp71_ = _tmp70_;
			_tmp72_ = num;
			_tmp73_ = tool;
			build_tools_update (_tmp71_, _tmp72_, &_tmp73_, TRUE);
			_build_tools_unref0 (_tmp71_);
		}
		gtk_widget_hide ((GtkWidget*) self);
		result = TRUE;
		_g_object_unref0 (model);
		_g_free0 (_tmp19_);
		build_tool_destroy (&tool);
		return result;
	}
	gtk_widget_hide ((GtkWidget*) self);
	result = FALSE;
	return result;
}


static void build_tool_dialog_icon_column_copy (const BuildToolDialogIconColumn* self, BuildToolDialogIconColumn* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).stock_id;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).stock_id);
	(*dest).stock_id = _tmp1_;
	_tmp2_ = (*self).label;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).label);
	(*dest).label = _tmp3_;
}


static void build_tool_dialog_icon_column_destroy (BuildToolDialogIconColumn* self) {
	_g_free0 ((*self).stock_id);
	_g_free0 ((*self).label);
}


static BuildToolDialogIconColumn* build_tool_dialog_icon_column_dup (const BuildToolDialogIconColumn* self) {
	BuildToolDialogIconColumn* dup;
	dup = g_new0 (BuildToolDialogIconColumn, 1);
	build_tool_dialog_icon_column_copy (self, dup);
	return dup;
}


static void build_tool_dialog_icon_column_free (BuildToolDialogIconColumn* self) {
	build_tool_dialog_icon_column_destroy (self);
	g_free (self);
}


static GType build_tool_dialog_icon_column_get_type (void) {
	static volatile gsize build_tool_dialog_icon_column_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_dialog_icon_column_type_id__volatile)) {
		GType build_tool_dialog_icon_column_type_id;
		build_tool_dialog_icon_column_type_id = g_boxed_type_register_static ("BuildToolDialogIconColumn", (GBoxedCopyFunc) build_tool_dialog_icon_column_dup, (GBoxedFreeFunc) build_tool_dialog_icon_column_free);
		g_once_init_leave (&build_tool_dialog_icon_column_type_id__volatile, build_tool_dialog_icon_column_type_id);
	}
	return build_tool_dialog_icon_column_type_id__volatile;
}


static void build_tool_dialog_class_init (BuildToolDialogClass * klass) {
	build_tool_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BuildToolDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = build_tool_dialog_finalize;
}


static void build_tool_dialog_instance_init (BuildToolDialog * self) {
	self->priv = BUILD_TOOL_DIALOG_GET_PRIVATE (self);
}


static void build_tool_dialog_finalize (GObject* obj) {
	BuildToolDialog * self;
	self = BUILD_TOOL_DIALOG (obj);
	_g_object_unref0 (self->priv->entry_label);
	_g_object_unref0 (self->priv->entry_desc);
	_g_object_unref0 (self->priv->entry_extensions);
	_g_object_unref0 (self->priv->combobox_icon);
	_g_object_unref0 (self->priv->entry_command);
	_g_object_unref0 (self->priv->button_add);
	_g_object_unref0 (self->priv->treeview_jobs);
	_g_object_unref0 (self->priv->button_delete);
	_g_object_unref0 (self->priv->button_up);
	_g_object_unref0 (self->priv->button_down);
	_g_object_unref0 (self->priv->jobs_store);
	G_OBJECT_CLASS (build_tool_dialog_parent_class)->finalize (obj);
}


GType build_tool_dialog_get_type (void) {
	static volatile gsize build_tool_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BuildToolDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) build_tool_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BuildToolDialog), 0, (GInstanceInitFunc) build_tool_dialog_instance_init, NULL };
		GType build_tool_dialog_type_id;
		build_tool_dialog_type_id = g_type_register_static (GTK_TYPE_DIALOG, "BuildToolDialog", &g_define_type_info, 0);
		g_once_init_leave (&build_tool_dialog_type_id__volatile, build_tool_dialog_type_id);
	}
	return build_tool_dialog_type_id__volatile;
}



