/* build_view.c generated by valac 0.15.1, the Vala compiler
 * generated from build_view.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gtksourceview/gtksourceview.h>


#define TYPE_PARTITION_STATE (partition_state_get_type ())

#define TYPE_BUILD_MSG_TYPE (build_msg_type_get_type ())

#define TYPE_BUILD_MSG (build_msg_get_type ())
typedef struct _BuildMsg BuildMsg;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_BUILD_VIEW (build_view_get_type ())
#define BUILD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_VIEW, BuildView))
#define BUILD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_VIEW, BuildViewClass))
#define IS_BUILD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_VIEW))
#define IS_BUILD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_VIEW))
#define BUILD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_VIEW, BuildViewClass))

typedef struct _BuildView BuildView;
typedef struct _BuildViewClass BuildViewClass;
typedef struct _BuildViewPrivate BuildViewPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define BUILD_VIEW_TYPE_BUILD_INFO (build_view_build_info_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

typedef enum  {
	PARTITION_STATE_RUNNING,
	PARTITION_STATE_SUCCEEDED,
	PARTITION_STATE_FAILED,
	PARTITION_STATE_ABORTED
} PartitionState;

typedef enum  {
	BUILD_MSG_TYPE_ERROR,
	BUILD_MSG_TYPE_WARNING,
	BUILD_MSG_TYPE_BADBOX,
	BUILD_MSG_TYPE_OTHER
} BuildMsgType;

struct _BuildMsg {
	gchar* text;
	BuildMsgType type;
	gchar* filename;
	gboolean lines_set;
	gint start_line;
	gint end_line;
	gboolean expand;
};

struct _BuildView {
	GtkHBox parent_instance;
	BuildViewPrivate * priv;
};

struct _BuildViewClass {
	GtkHBoxClass parent_class;
};

struct _BuildViewPrivate {
	gboolean _show_errors;
	gboolean _show_warnings;
	gboolean _show_badboxes;
	MainWindow* _main_window;
	GtkTreeStore* _store;
	GtkTreeModelFilter* _filtered_model;
	GtkTreeView* _view;
	GtkToggleAction* _action_view_bottom_panel;
};

typedef enum  {
	BUILD_VIEW_BUILD_INFO_ICON,
	BUILD_VIEW_BUILD_INFO_MESSAGE,
	BUILD_VIEW_BUILD_INFO_MESSAGE_TYPE,
	BUILD_VIEW_BUILD_INFO_WEIGHT,
	BUILD_VIEW_BUILD_INFO_BASENAME,
	BUILD_VIEW_BUILD_INFO_PATH,
	BUILD_VIEW_BUILD_INFO_FILE,
	BUILD_VIEW_BUILD_INFO_START_LINE,
	BUILD_VIEW_BUILD_INFO_END_LINE,
	BUILD_VIEW_BUILD_INFO_LINE,
	BUILD_VIEW_BUILD_INFO_N_COLUMNS
} BuildViewBuildInfo;


static gpointer build_view_parent_class = NULL;

GType partition_state_get_type (void) G_GNUC_CONST;
GType build_msg_type_get_type (void) G_GNUC_CONST;
GType build_msg_get_type (void) G_GNUC_CONST;
BuildMsg* build_msg_dup (const BuildMsg* self);
void build_msg_free (BuildMsg* self);
void build_msg_copy (const BuildMsg* self, BuildMsg* dest);
void build_msg_destroy (BuildMsg* self);
GType build_view_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
#define BUILD_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BUILD_VIEW, BuildViewPrivate))
enum  {
	BUILD_VIEW_DUMMY_PROPERTY,
	BUILD_VIEW_SHOW_ERRORS,
	BUILD_VIEW_SHOW_WARNINGS,
	BUILD_VIEW_SHOW_BADBOXES
};
static GType build_view_build_info_get_type (void) G_GNUC_UNUSED;
BuildView* build_view_new (MainWindow* main_window, GtkToolbar* toolbar, GtkToggleAction* view_bottom_panel);
BuildView* build_view_construct (GType object_type, MainWindow* main_window, GtkToolbar* toolbar, GtkToggleAction* view_bottom_panel);
static gboolean __lambda24_ (BuildView* self, GtkTreeModel* model, GtkTreeIter* iter);
gboolean build_view_get_show_errors (BuildView* self);
gboolean build_view_get_show_warnings (BuildView* self);
gboolean build_view_get_show_badboxes (BuildView* self);
static gboolean ___lambda24__gtk_tree_model_filter_visible_func (GtkTreeModel* model, GtkTreeIter* iter, gpointer self);
static void __lambda25_ (BuildView* self);
static void ___lambda25__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda26_ (BuildView* self);
static void ___lambda26__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda27_ (BuildView* self);
static void ___lambda27__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean __lambda28_ (BuildView* self, GtkTreeSelection* select, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected);
static gboolean build_view_select_row (BuildView* self, GtkTreeModel* model, GtkTreePath* path);
static gboolean ___lambda28__gtk_tree_selection_func (GtkTreeSelection* selection, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected, gpointer self);
static void __lambda38_ (BuildView* self, GtkTreePath* path);
static void ___lambda38__gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
static void __lambda39_ (BuildView* self);
static void ___lambda39__gtk_button_clicked (GtkButton* _sender, gpointer self);
GtkWidget* utils_add_scrollbar (GtkWidget* child);
static void build_view_jump_to_file (BuildView* self, GFile* file, gint start_line, gint end_line);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentTab* main_window_open_document (MainWindow* self, GFile* location, gboolean jump_to);
void utils_flush_queue (void);
GType document_get_type (void) G_GNUC_CONST;
Document* document_tab_get_document (DocumentTab* self);
void document_select_lines (Document* self, gint start, gint end);
void build_view_clear (BuildView* self);
void build_view_add_partition (BuildView* self, const gchar* msg, PartitionState state, GtkTreeIter* parent, gboolean bold, GtkTreeIter* result);
static gchar* build_view_get_icon_from_state (BuildView* self, PartitionState state);
void build_view_set_partition_state (BuildView* self, GtkTreeIter* partition_id, PartitionState state);
void build_view_append_messages (BuildView* self, GtkTreeIter* parent, GNode* messages, gboolean parent_is_partition);
void build_view_append_single_message (BuildView* self, GtkTreeIter* partition_id, BuildMsg* message, GtkTreeIter* result);
gchar* utils_replace_home_dir_with_tilde (const gchar* uri);
static gchar* build_view_get_icon_from_msg_type (BuildView* self, BuildMsgType type);
void build_view_show (BuildView* self);
void build_view_set_show_errors (BuildView* self, gboolean value);
void build_view_set_show_warnings (BuildView* self, gboolean value);
void build_view_set_show_badboxes (BuildView* self, gboolean value);
static void build_view_finalize (GObject* obj);
static void _vala_build_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_build_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType partition_state_get_type (void) {
	static volatile gsize partition_state_type_id__volatile = 0;
	if (g_once_init_enter (&partition_state_type_id__volatile)) {
		static const GEnumValue values[] = {{PARTITION_STATE_RUNNING, "PARTITION_STATE_RUNNING", "running"}, {PARTITION_STATE_SUCCEEDED, "PARTITION_STATE_SUCCEEDED", "succeeded"}, {PARTITION_STATE_FAILED, "PARTITION_STATE_FAILED", "failed"}, {PARTITION_STATE_ABORTED, "PARTITION_STATE_ABORTED", "aborted"}, {0, NULL, NULL}};
		GType partition_state_type_id;
		partition_state_type_id = g_enum_register_static ("PartitionState", values);
		g_once_init_leave (&partition_state_type_id__volatile, partition_state_type_id);
	}
	return partition_state_type_id__volatile;
}


GType build_msg_type_get_type (void) {
	static volatile gsize build_msg_type_type_id__volatile = 0;
	if (g_once_init_enter (&build_msg_type_type_id__volatile)) {
		static const GEnumValue values[] = {{BUILD_MSG_TYPE_ERROR, "BUILD_MSG_TYPE_ERROR", "error"}, {BUILD_MSG_TYPE_WARNING, "BUILD_MSG_TYPE_WARNING", "warning"}, {BUILD_MSG_TYPE_BADBOX, "BUILD_MSG_TYPE_BADBOX", "badbox"}, {BUILD_MSG_TYPE_OTHER, "BUILD_MSG_TYPE_OTHER", "other"}, {0, NULL, NULL}};
		GType build_msg_type_type_id;
		build_msg_type_type_id = g_enum_register_static ("BuildMsgType", values);
		g_once_init_leave (&build_msg_type_type_id__volatile, build_msg_type_type_id);
	}
	return build_msg_type_type_id__volatile;
}


void build_msg_copy (const BuildMsg* self, BuildMsg* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	BuildMsgType _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gboolean _tmp8_;
	_tmp0_ = (*self).text;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).text);
	(*dest).text = _tmp1_;
	_tmp2_ = (*self).type;
	(*dest).type = _tmp2_;
	_tmp3_ = (*self).filename;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 ((*dest).filename);
	(*dest).filename = _tmp4_;
	_tmp5_ = (*self).lines_set;
	(*dest).lines_set = _tmp5_;
	_tmp6_ = (*self).start_line;
	(*dest).start_line = _tmp6_;
	_tmp7_ = (*self).end_line;
	(*dest).end_line = _tmp7_;
	_tmp8_ = (*self).expand;
	(*dest).expand = _tmp8_;
}


void build_msg_destroy (BuildMsg* self) {
	_g_free0 ((*self).text);
	_g_free0 ((*self).filename);
}


BuildMsg* build_msg_dup (const BuildMsg* self) {
	BuildMsg* dup;
	dup = g_new0 (BuildMsg, 1);
	build_msg_copy (self, dup);
	return dup;
}


void build_msg_free (BuildMsg* self) {
	build_msg_destroy (self);
	g_free (self);
}


GType build_msg_get_type (void) {
	static volatile gsize build_msg_type_id__volatile = 0;
	if (g_once_init_enter (&build_msg_type_id__volatile)) {
		GType build_msg_type_id;
		build_msg_type_id = g_boxed_type_register_static ("BuildMsg", (GBoxedCopyFunc) build_msg_dup, (GBoxedFreeFunc) build_msg_free);
		g_once_init_leave (&build_msg_type_id__volatile, build_msg_type_id);
	}
	return build_msg_type_id__volatile;
}


static GType build_view_build_info_get_type (void) {
	static volatile gsize build_view_build_info_type_id__volatile = 0;
	if (g_once_init_enter (&build_view_build_info_type_id__volatile)) {
		static const GEnumValue values[] = {{BUILD_VIEW_BUILD_INFO_ICON, "BUILD_VIEW_BUILD_INFO_ICON", "icon"}, {BUILD_VIEW_BUILD_INFO_MESSAGE, "BUILD_VIEW_BUILD_INFO_MESSAGE", "message"}, {BUILD_VIEW_BUILD_INFO_MESSAGE_TYPE, "BUILD_VIEW_BUILD_INFO_MESSAGE_TYPE", "message-type"}, {BUILD_VIEW_BUILD_INFO_WEIGHT, "BUILD_VIEW_BUILD_INFO_WEIGHT", "weight"}, {BUILD_VIEW_BUILD_INFO_BASENAME, "BUILD_VIEW_BUILD_INFO_BASENAME", "basename"}, {BUILD_VIEW_BUILD_INFO_PATH, "BUILD_VIEW_BUILD_INFO_PATH", "path"}, {BUILD_VIEW_BUILD_INFO_FILE, "BUILD_VIEW_BUILD_INFO_FILE", "file"}, {BUILD_VIEW_BUILD_INFO_START_LINE, "BUILD_VIEW_BUILD_INFO_START_LINE", "start-line"}, {BUILD_VIEW_BUILD_INFO_END_LINE, "BUILD_VIEW_BUILD_INFO_END_LINE", "end-line"}, {BUILD_VIEW_BUILD_INFO_LINE, "BUILD_VIEW_BUILD_INFO_LINE", "line"}, {BUILD_VIEW_BUILD_INFO_N_COLUMNS, "BUILD_VIEW_BUILD_INFO_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType build_view_build_info_type_id;
		build_view_build_info_type_id = g_enum_register_static ("BuildViewBuildInfo", values);
		g_once_init_leave (&build_view_build_info_type_id__volatile, build_view_build_info_type_id);
	}
	return build_view_build_info_type_id__volatile;
}


static gboolean __lambda24_ (BuildView* self, GtkTreeModel* model, GtkTreeIter* iter) {
	gboolean result = FALSE;
	BuildMsgType msg_type = 0;
	GtkTreeModel* _tmp0_;
	GtkTreeIter _tmp1_;
	BuildMsgType _tmp2_;
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = model;
	_tmp1_ = *iter;
	gtk_tree_model_get (_tmp0_, &_tmp1_, BUILD_VIEW_BUILD_INFO_MESSAGE_TYPE, &msg_type, -1, -1);
	_tmp2_ = msg_type;
	switch (_tmp2_) {
		case BUILD_MSG_TYPE_ERROR:
		{
			gboolean _tmp3_;
			_tmp3_ = self->priv->_show_errors;
			result = _tmp3_;
			return result;
		}
		case BUILD_MSG_TYPE_WARNING:
		{
			gboolean _tmp4_;
			_tmp4_ = self->priv->_show_warnings;
			result = _tmp4_;
			return result;
		}
		case BUILD_MSG_TYPE_BADBOX:
		{
			gboolean _tmp5_;
			_tmp5_ = self->priv->_show_badboxes;
			result = _tmp5_;
			return result;
		}
		default:
		{
			result = TRUE;
			return result;
		}
	}
}


static gboolean ___lambda24__gtk_tree_model_filter_visible_func (GtkTreeModel* model, GtkTreeIter* iter, gpointer self) {
	gboolean result;
	result = __lambda24_ (self, model, iter);
	return result;
}


static void __lambda25_ (BuildView* self) {
	GtkTreeModelFilter* _tmp0_;
	_tmp0_ = self->priv->_filtered_model;
	gtk_tree_model_filter_refilter (_tmp0_);
}


static void ___lambda25__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda25_ (self);
}


static void __lambda26_ (BuildView* self) {
	GtkTreeModelFilter* _tmp0_;
	_tmp0_ = self->priv->_filtered_model;
	gtk_tree_model_filter_refilter (_tmp0_);
}


static void ___lambda26__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda26_ (self);
}


static void __lambda27_ (BuildView* self) {
	GtkTreeModelFilter* _tmp0_;
	_tmp0_ = self->priv->_filtered_model;
	gtk_tree_model_filter_refilter (_tmp0_);
}


static void ___lambda27__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda27_ (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean __lambda28_ (BuildView* self, GtkTreeSelection* select, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreePath* _tmp2_;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (select != NULL, FALSE);
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = path_currently_selected;
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp1_ = model;
	_tmp2_ = path;
	_tmp3_ = build_view_select_row (self, _tmp1_, _tmp2_);
	result = _tmp3_;
	return result;
}


static gboolean ___lambda28__gtk_tree_selection_func (GtkTreeSelection* selection, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected, gpointer self) {
	gboolean result;
	result = __lambda28_ (self, selection, model, path, path_currently_selected);
	return result;
}


static void __lambda38_ (BuildView* self, GtkTreePath* path) {
	GtkTreeModelFilter* _tmp0_;
	GtkTreePath* _tmp1_;
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->_filtered_model;
	_tmp1_ = path;
	build_view_select_row (self, (GtkTreeModel*) _tmp0_, _tmp1_);
}


static void ___lambda38__gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
	__lambda38_ (self, path);
}


static void __lambda39_ (BuildView* self) {
	GtkToggleAction* _tmp0_;
	gtk_widget_hide ((GtkWidget*) self);
	_tmp0_ = self->priv->_action_view_bottom_panel;
	gtk_toggle_action_set_active (_tmp0_, FALSE);
}


static void ___lambda39__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda39_ (self);
}


BuildView* build_view_construct (GType object_type, MainWindow* main_window, GtkToolbar* toolbar, GtkToggleAction* view_bottom_panel) {
	BuildView * self = NULL;
	MainWindow* _tmp0_;
	GtkToggleAction* _tmp1_;
	GtkTreeStore* _tmp2_;
	GtkTreeStore* _tmp3_;
	GtkTreeModelFilter* _tmp4_;
	GtkTreeModelFilter* _tmp5_;
	GtkTreeModelFilter* _tmp6_;
	GtkTreeView* _tmp7_;
	GtkTreeView* _tmp8_;
	GtkTreeViewColumn* _tmp9_;
	GtkTreeViewColumn* _tmp10_;
	GtkTreeViewColumn* column_job;
	const gchar* _tmp11_ = NULL;
	GtkCellRendererPixbuf* _tmp12_;
	GtkCellRendererPixbuf* _tmp13_;
	GtkCellRendererPixbuf* renderer_pixbuf;
	GtkCellRendererText* _tmp14_;
	GtkCellRendererText* _tmp15_;
	GtkCellRendererText* renderer_text;
	GtkTreeView* _tmp16_;
	GtkTreeView* _tmp17_;
	const gchar* _tmp18_ = NULL;
	GtkCellRendererText* _tmp19_;
	GtkCellRendererText* _tmp20_;
	GtkTreeView* _tmp21_;
	const gchar* _tmp22_ = NULL;
	GtkCellRendererText* _tmp23_;
	GtkCellRendererText* _tmp24_;
	GtkTreeView* _tmp25_;
	GtkTreeView* _tmp26_;
	GtkTreeSelection* _tmp27_ = NULL;
	GtkTreeSelection* _tmp28_;
	GtkTreeSelection* select;
	GtkTreeView* _tmp29_;
	GtkButton* _tmp30_;
	GtkButton* _tmp31_;
	GtkButton* close_button;
	const gchar* _tmp32_ = NULL;
	GtkImage* _tmp33_;
	GtkImage* _tmp34_;
	GtkTreeView* _tmp35_;
	GtkWidget* _tmp36_ = NULL;
	GtkWidget* sw;
	GtkVBox* _tmp37_;
	GtkVBox* _tmp38_;
	GtkVBox* vbox;
	GtkToolbar* _tmp39_;
	g_return_val_if_fail (main_window != NULL, NULL);
	g_return_val_if_fail (toolbar != NULL, NULL);
	g_return_val_if_fail (view_bottom_panel != NULL, NULL);
	self = (BuildView*) g_object_new (object_type, NULL);
	_tmp0_ = main_window;
	self->priv->_main_window = _tmp0_;
	_tmp1_ = view_bottom_panel;
	self->priv->_action_view_bottom_panel = _tmp1_;
	_tmp2_ = gtk_tree_store_new ((gint) BUILD_VIEW_BUILD_INFO_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, TYPE_BUILD_MSG_TYPE, G_TYPE_INT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_FILE, G_TYPE_INT, G_TYPE_INT, G_TYPE_STRING);
	_g_object_unref0 (self->priv->_store);
	self->priv->_store = _tmp2_;
	_tmp3_ = self->priv->_store;
	_tmp4_ = (GtkTreeModelFilter*) gtk_tree_model_filter_new ((GtkTreeModel*) _tmp3_, NULL);
	_g_object_unref0 (self->priv->_filtered_model);
	self->priv->_filtered_model = _tmp4_;
	_tmp5_ = self->priv->_filtered_model;
	gtk_tree_model_filter_set_visible_func (_tmp5_, ___lambda24__gtk_tree_model_filter_visible_func, g_object_ref (self), g_object_unref);
	g_signal_connect_object ((GObject*) self, "notify::show-errors", (GCallback) ___lambda25__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::show-warnings", (GCallback) ___lambda26__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::show-badboxes", (GCallback) ___lambda27__g_object_notify, self, 0);
	_tmp6_ = self->priv->_filtered_model;
	_tmp7_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _tmp6_);
	_tmp8_ = g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->_view);
	self->priv->_view = _tmp8_;
	_tmp9_ = gtk_tree_view_column_new ();
	_tmp10_ = g_object_ref_sink (_tmp9_);
	column_job = _tmp10_;
	_tmp11_ = _ ("Job");
	gtk_tree_view_column_set_title (column_job, _tmp11_);
	_tmp12_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	_tmp13_ = g_object_ref_sink (_tmp12_);
	renderer_pixbuf = _tmp13_;
	gtk_cell_layout_pack_start ((GtkCellLayout*) column_job, (GtkCellRenderer*) renderer_pixbuf, FALSE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) column_job, (GtkCellRenderer*) renderer_pixbuf, "stock-id", (gint) BUILD_VIEW_BUILD_INFO_ICON);
	_tmp14_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp15_ = g_object_ref_sink (_tmp14_);
	renderer_text = _tmp15_;
	g_object_set (renderer_text, "weight-set", TRUE, NULL);
	g_object_set (renderer_text, "editable", TRUE, NULL);
	g_object_set (renderer_text, "editable-set", TRUE, NULL);
	gtk_cell_layout_pack_start ((GtkCellLayout*) column_job, (GtkCellRenderer*) renderer_text, TRUE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) column_job, (GtkCellRenderer*) renderer_text, "text", (gint) BUILD_VIEW_BUILD_INFO_MESSAGE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) column_job, (GtkCellRenderer*) renderer_text, "weight", (gint) BUILD_VIEW_BUILD_INFO_WEIGHT);
	_tmp16_ = self->priv->_view;
	gtk_tree_view_append_column (_tmp16_, column_job);
	_tmp17_ = self->priv->_view;
	_tmp18_ = _ ("File");
	_tmp19_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp20_ = g_object_ref_sink (_tmp19_);
	gtk_tree_view_insert_column_with_attributes (_tmp17_, -1, _tmp18_, (GtkCellRenderer*) _tmp20_, "text", BUILD_VIEW_BUILD_INFO_BASENAME, NULL);
	_g_object_unref0 (_tmp20_);
	_tmp21_ = self->priv->_view;
	_tmp22_ = _ ("Line");
	_tmp23_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp24_ = g_object_ref_sink (_tmp23_);
	gtk_tree_view_insert_column_with_attributes (_tmp21_, -1, _tmp22_, (GtkCellRenderer*) _tmp24_, "text", BUILD_VIEW_BUILD_INFO_LINE, NULL);
	_g_object_unref0 (_tmp24_);
	_tmp25_ = self->priv->_view;
	gtk_tree_view_set_tooltip_column (_tmp25_, (gint) BUILD_VIEW_BUILD_INFO_PATH);
	_tmp26_ = self->priv->_view;
	_tmp27_ = gtk_tree_view_get_selection (_tmp26_);
	_tmp28_ = _g_object_ref0 (_tmp27_);
	select = _tmp28_;
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	gtk_tree_selection_set_select_function (select, ___lambda28__gtk_tree_selection_func, g_object_ref (self), g_object_unref);
	_tmp29_ = self->priv->_view;
	g_signal_connect_object (_tmp29_, "row-activated", (GCallback) ___lambda38__gtk_tree_view_row_activated, self, 0);
	_tmp30_ = (GtkButton*) gtk_button_new ();
	_tmp31_ = g_object_ref_sink (_tmp30_);
	close_button = _tmp31_;
	gtk_button_set_relief (close_button, GTK_RELIEF_NONE);
	gtk_button_set_focus_on_click (close_button, FALSE);
	_tmp32_ = _ ("Hide panel");
	gtk_widget_set_tooltip_text ((GtkWidget*) close_button, _tmp32_);
	_tmp33_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_CLOSE, GTK_ICON_SIZE_MENU);
	_tmp34_ = g_object_ref_sink (_tmp33_);
	gtk_container_add ((GtkContainer*) close_button, (GtkWidget*) _tmp34_);
	_g_object_unref0 (_tmp34_);
	g_signal_connect_object (close_button, "clicked", (GCallback) ___lambda39__gtk_button_clicked, self, 0);
	_tmp35_ = self->priv->_view;
	_tmp36_ = utils_add_scrollbar ((GtkWidget*) _tmp35_);
	sw = _tmp36_;
	gtk_box_pack_start ((GtkBox*) self, sw, TRUE, TRUE, (guint) 0);
	_tmp37_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
	_tmp38_ = g_object_ref_sink (_tmp37_);
	vbox = _tmp38_;
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) close_button, FALSE, FALSE, (guint) 0);
	_tmp39_ = toolbar;
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) _tmp39_, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) vbox, FALSE, FALSE, (guint) 0);
	_g_object_unref0 (vbox);
	_g_object_unref0 (sw);
	_g_object_unref0 (close_button);
	_g_object_unref0 (select);
	_g_object_unref0 (renderer_text);
	_g_object_unref0 (renderer_pixbuf);
	_g_object_unref0 (column_job);
	return self;
}


BuildView* build_view_new (MainWindow* main_window, GtkToolbar* toolbar, GtkToggleAction* view_bottom_panel) {
	return build_view_construct (TYPE_BUILD_VIEW, main_window, toolbar, view_bottom_panel);
}


static gboolean build_view_select_row (BuildView* self, GtkTreeModel* model, GtkTreePath* path) {
	gboolean result = FALSE;
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	BuildMsgType msg_type = 0;
	GFile* file = NULL;
	gint start_line = 0;
	gint end_line = 0;
	GtkTreeModel* _tmp4_;
	GtkTreeIter _tmp5_;
	gboolean _tmp6_ = FALSE;
	BuildMsgType _tmp7_;
	gboolean _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = model;
	_tmp1_ = path;
	_tmp3_ = gtk_tree_model_get_iter (_tmp0_, &_tmp2_, _tmp1_);
	iter = _tmp2_;
	if (!_tmp3_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = model;
	_tmp5_ = iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, BUILD_VIEW_BUILD_INFO_MESSAGE_TYPE, &msg_type, BUILD_VIEW_BUILD_INFO_FILE, &file, BUILD_VIEW_BUILD_INFO_START_LINE, &start_line, BUILD_VIEW_BUILD_INFO_END_LINE, &end_line, -1, -1);
	_tmp7_ = msg_type;
	if (_tmp7_ != BUILD_MSG_TYPE_OTHER) {
		GFile* _tmp8_;
		_tmp8_ = file;
		_tmp6_ = _tmp8_ != NULL;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp9_ = _tmp6_;
	if (_tmp9_) {
		GFile* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		_tmp10_ = file;
		_tmp11_ = start_line;
		_tmp12_ = end_line;
		build_view_jump_to_file (self, _tmp10_, _tmp11_, _tmp12_);
		result = TRUE;
		_g_object_unref0 (file);
		return result;
	} else {
		BuildMsgType _tmp13_;
		_tmp13_ = msg_type;
		if (_tmp13_ == BUILD_MSG_TYPE_OTHER) {
			GtkTreeModel* _tmp14_;
			GtkTreeIter _tmp15_;
			gboolean _tmp16_ = FALSE;
			_tmp14_ = model;
			_tmp15_ = iter;
			_tmp16_ = gtk_tree_model_iter_has_child (_tmp14_, &_tmp15_);
			if (_tmp16_) {
				GtkTreeView* _tmp17_;
				GtkTreePath* _tmp18_;
				gboolean _tmp19_ = FALSE;
				_tmp17_ = self->priv->_view;
				_tmp18_ = path;
				_tmp19_ = gtk_tree_view_row_expanded (_tmp17_, _tmp18_);
				if (_tmp19_) {
					GtkTreeView* _tmp20_;
					GtkTreePath* _tmp21_;
					_tmp20_ = self->priv->_view;
					_tmp21_ = path;
					gtk_tree_view_collapse_row (_tmp20_, _tmp21_);
				} else {
					GtkTreeView* _tmp22_;
					GtkTreePath* _tmp23_;
					_tmp22_ = self->priv->_view;
					_tmp23_ = path;
					gtk_tree_view_expand_to_path (_tmp22_, _tmp23_);
				}
				result = FALSE;
				_g_object_unref0 (file);
				return result;
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (file);
	return result;
}


static void build_view_jump_to_file (BuildView* self, GFile* file, gint start_line, gint end_line) {
	MainWindow* _tmp0_;
	GFile* _tmp1_;
	DocumentTab* _tmp2_ = NULL;
	DocumentTab* tab;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = file;
	_tmp2_ = main_window_open_document (_tmp0_, _tmp1_, TRUE);
	tab = _tmp2_;
	utils_flush_queue ();
	_tmp3_ = start_line;
	if (_tmp3_ != (-1)) {
		gint _tmp4_ = 0;
		gint _tmp5_;
		gint _tmp8_;
		gint end;
		DocumentTab* _tmp9_;
		Document* _tmp10_;
		Document* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp5_ = end_line;
		if (_tmp5_ != (-1)) {
			gint _tmp6_;
			_tmp6_ = end_line;
			_tmp4_ = _tmp6_ - 1;
		} else {
			gint _tmp7_;
			_tmp7_ = start_line;
			_tmp4_ = _tmp7_;
		}
		_tmp8_ = _tmp4_;
		end = _tmp8_;
		_tmp9_ = tab;
		_tmp10_ = document_tab_get_document (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = start_line;
		_tmp13_ = end;
		document_select_lines (_tmp11_, _tmp12_ - 1, _tmp13_);
	}
	_g_object_unref0 (tab);
}


void build_view_clear (BuildView* self) {
	GtkTreeStore* _tmp0_;
	GtkTreeView* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_store;
	gtk_tree_store_clear (_tmp0_);
	_tmp1_ = self->priv->_view;
	gtk_tree_view_columns_autosize (_tmp1_);
}


void build_view_add_partition (BuildView* self, const gchar* msg, PartitionState state, GtkTreeIter* parent, gboolean bold, GtkTreeIter* result) {
	GtkTreeIter iter = {0};
	GtkTreeStore* _tmp0_;
	GtkTreeIter* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gint _tmp3_ = 0;
	gboolean _tmp4_;
	GtkTreeStore* _tmp5_;
	GtkTreeIter _tmp6_;
	PartitionState _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gint _tmp11_;
	GtkTreeView* _tmp12_;
	GtkTreeStore* _tmp13_;
	GtkTreeIter _tmp14_;
	GtkTreePath* _tmp15_ = NULL;
	GtkTreePath* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = self->priv->_store;
	_tmp1_ = parent;
	gtk_tree_store_append (_tmp0_, &_tmp2_, _tmp1_);
	iter = _tmp2_;
	_tmp4_ = bold;
	if (_tmp4_) {
		_tmp3_ = 800;
	} else {
		_tmp3_ = 400;
	}
	_tmp5_ = self->priv->_store;
	_tmp6_ = iter;
	_tmp7_ = state;
	_tmp8_ = build_view_get_icon_from_state (self, _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = msg;
	_tmp11_ = _tmp3_;
	gtk_tree_store_set (_tmp5_, &_tmp6_, BUILD_VIEW_BUILD_INFO_ICON, _tmp9_, BUILD_VIEW_BUILD_INFO_MESSAGE, _tmp10_, BUILD_VIEW_BUILD_INFO_MESSAGE_TYPE, BUILD_MSG_TYPE_OTHER, BUILD_VIEW_BUILD_INFO_WEIGHT, _tmp11_, -1, -1);
	_g_free0 (_tmp9_);
	_tmp12_ = self->priv->_view;
	_tmp13_ = self->priv->_store;
	_tmp14_ = iter;
	_tmp15_ = gtk_tree_model_get_path ((GtkTreeModel*) _tmp13_, &_tmp14_);
	_tmp16_ = _tmp15_;
	gtk_tree_view_expand_to_path (_tmp12_, _tmp16_);
	_gtk_tree_path_free0 (_tmp16_);
	*result = iter;
	return;
}


void build_view_set_partition_state (BuildView* self, GtkTreeIter* partition_id, PartitionState state) {
	GtkTreeStore* _tmp0_;
	GtkTreeIter _tmp1_;
	PartitionState _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (partition_id != NULL);
	_tmp0_ = self->priv->_store;
	_tmp1_ = *partition_id;
	_tmp2_ = state;
	_tmp3_ = build_view_get_icon_from_state (self, _tmp2_);
	_tmp4_ = _tmp3_;
	gtk_tree_store_set (_tmp0_, &_tmp1_, BUILD_VIEW_BUILD_INFO_ICON, _tmp4_, -1, -1);
	_g_free0 (_tmp4_);
}


void build_view_append_messages (BuildView* self, GtkTreeIter* parent, GNode* messages, gboolean parent_is_partition) {
	GNode* _tmp0_;
	GNode* _tmp1_ = NULL;
	GNode* cur_node;
	gboolean _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	g_return_if_fail (messages != NULL);
	_tmp0_ = messages;
	_tmp1_ = g_node_first_child (_tmp0_);
	cur_node = _tmp1_;
	while (TRUE) {
		GNode* _tmp2_;
		GtkTreeIter _tmp3_;
		GNode* _tmp4_;
		gconstpointer _tmp5_;
		BuildMsg _tmp6_;
		GtkTreeIter _tmp7_ = {0};
		GtkTreeIter child;
		GNode* _tmp8_;
		GNode* _tmp9_;
		GNode* _tmp22_;
		GNode* _tmp23_ = NULL;
		_tmp2_ = cur_node;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = *parent;
		_tmp4_ = cur_node;
		_tmp5_ = _tmp4_->data;
		_tmp6_ = *((BuildMsg*) _tmp5_);
		build_view_append_single_message (self, &_tmp3_, &_tmp6_, &_tmp7_);
		child = _tmp7_;
		_tmp8_ = cur_node;
		_tmp9_ = _tmp8_->children;
		if (_tmp9_ != NULL) {
			GtkTreeStore* _tmp10_;
			GtkTreeIter _tmp11_;
			GtkTreeIter _tmp12_;
			GNode* _tmp13_;
			GNode* _tmp14_;
			gconstpointer _tmp15_;
			gboolean _tmp16_;
			_tmp10_ = self->priv->_store;
			_tmp11_ = child;
			gtk_tree_store_set (_tmp10_, &_tmp11_, BUILD_VIEW_BUILD_INFO_ICON, "completion_choice", -1, -1);
			_tmp12_ = child;
			_tmp13_ = cur_node;
			build_view_append_messages (self, &_tmp12_, _tmp13_, FALSE);
			_tmp14_ = cur_node;
			_tmp15_ = _tmp14_->data;
			_tmp16_ = (*((BuildMsg*) _tmp15_)).expand;
			if (_tmp16_) {
				GtkTreeView* _tmp17_;
				GtkTreeStore* _tmp18_;
				GtkTreeIter _tmp19_;
				GtkTreePath* _tmp20_ = NULL;
				GtkTreePath* _tmp21_;
				_tmp17_ = self->priv->_view;
				_tmp18_ = self->priv->_store;
				_tmp19_ = child;
				_tmp20_ = gtk_tree_model_get_path ((GtkTreeModel*) _tmp18_, &_tmp19_);
				_tmp21_ = _tmp20_;
				gtk_tree_view_expand_to_path (_tmp17_, _tmp21_);
				_gtk_tree_path_free0 (_tmp21_);
			}
		}
		_tmp22_ = cur_node;
		_tmp23_ = g_node_next_sibling (_tmp22_);
		cur_node = _tmp23_;
	}
	_tmp24_ = parent_is_partition;
	if (_tmp24_) {
		GtkTreeView* _tmp25_;
		GtkTreeStore* _tmp26_;
		GtkTreeIter _tmp27_;
		GtkTreePath* _tmp28_ = NULL;
		GtkTreePath* _tmp29_;
		_tmp25_ = self->priv->_view;
		_tmp26_ = self->priv->_store;
		_tmp27_ = *parent;
		_tmp28_ = gtk_tree_model_get_path ((GtkTreeModel*) _tmp26_, &_tmp27_);
		_tmp29_ = _tmp28_;
		gtk_tree_view_expand_row (_tmp25_, _tmp29_, FALSE);
		_gtk_tree_path_free0 (_tmp29_);
	}
}


void build_view_append_single_message (BuildView* self, GtkTreeIter* partition_id, BuildMsg* message, GtkTreeIter* result) {
	GFile* file;
	gchar* path;
	BuildMsg _tmp0_;
	const gchar* _tmp1_;
	gint start_line;
	gint end_line;
	gchar* line_str;
	BuildMsg _tmp10_;
	gboolean _tmp11_;
	GtkTreeIter iter = {0};
	GtkTreeStore* _tmp18_;
	GtkTreeIter _tmp19_;
	GtkTreeIter _tmp20_ = {0};
	gchar* _tmp21_ = NULL;
	GFile* _tmp22_;
	GtkTreeStore* _tmp25_;
	GtkTreeIter _tmp26_;
	BuildMsg _tmp27_;
	BuildMsgType _tmp28_;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_;
	BuildMsg _tmp31_;
	const gchar* _tmp32_;
	BuildMsg _tmp33_;
	BuildMsgType _tmp34_;
	const gchar* _tmp35_;
	GFile* _tmp36_;
	const gchar* _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	const gchar* _tmp40_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (partition_id != NULL);
	g_return_if_fail (message != NULL);
	file = NULL;
	path = NULL;
	_tmp0_ = *message;
	_tmp1_ = _tmp0_.filename;
	if (_tmp1_ != NULL) {
		BuildMsg _tmp2_;
		const gchar* _tmp3_;
		GFile* _tmp4_ = NULL;
		BuildMsg _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_;
		gchar* _tmp9_ = NULL;
		_tmp2_ = *message;
		_tmp3_ = _tmp2_.filename;
		_tmp4_ = g_file_new_for_path (_tmp3_);
		_g_object_unref0 (file);
		file = _tmp4_;
		_tmp5_ = *message;
		_tmp6_ = _tmp5_.filename;
		_tmp7_ = utils_replace_home_dir_with_tilde (_tmp6_);
		_g_free0 (path);
		path = _tmp7_;
		_tmp8_ = path;
		_tmp9_ = g_markup_escape_text (_tmp8_, (gssize) (-1));
		_g_free0 (path);
		path = _tmp9_;
	}
	start_line = -1;
	end_line = -1;
	line_str = NULL;
	_tmp10_ = *message;
	_tmp11_ = _tmp10_.lines_set;
	if (_tmp11_) {
		BuildMsg _tmp12_;
		gint _tmp13_;
		BuildMsg _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gchar* _tmp17_ = NULL;
		_tmp12_ = *message;
		_tmp13_ = _tmp12_.start_line;
		start_line = _tmp13_;
		_tmp14_ = *message;
		_tmp15_ = _tmp14_.end_line;
		end_line = _tmp15_;
		_tmp16_ = start_line;
		_tmp17_ = g_strdup_printf ("%i", _tmp16_);
		_g_free0 (line_str);
		line_str = _tmp17_;
	}
	_tmp18_ = self->priv->_store;
	_tmp19_ = *partition_id;
	gtk_tree_store_append (_tmp18_, &_tmp20_, &_tmp19_);
	iter = _tmp20_;
	_tmp22_ = file;
	if (_tmp22_ != NULL) {
		GFile* _tmp23_;
		gchar* _tmp24_ = NULL;
		_tmp23_ = file;
		_tmp24_ = g_file_get_basename (_tmp23_);
		_g_free0 (_tmp21_);
		_tmp21_ = _tmp24_;
	} else {
		_g_free0 (_tmp21_);
		_tmp21_ = NULL;
	}
	_tmp25_ = self->priv->_store;
	_tmp26_ = iter;
	_tmp27_ = *message;
	_tmp28_ = _tmp27_.type;
	_tmp29_ = build_view_get_icon_from_msg_type (self, _tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = *message;
	_tmp32_ = _tmp31_.text;
	_tmp33_ = *message;
	_tmp34_ = _tmp33_.type;
	_tmp35_ = _tmp21_;
	_tmp36_ = file;
	_tmp37_ = path;
	_tmp38_ = start_line;
	_tmp39_ = end_line;
	_tmp40_ = line_str;
	gtk_tree_store_set (_tmp25_, &_tmp26_, BUILD_VIEW_BUILD_INFO_ICON, _tmp30_, BUILD_VIEW_BUILD_INFO_MESSAGE, _tmp32_, BUILD_VIEW_BUILD_INFO_MESSAGE_TYPE, _tmp34_, BUILD_VIEW_BUILD_INFO_WEIGHT, 400, BUILD_VIEW_BUILD_INFO_BASENAME, _tmp35_, BUILD_VIEW_BUILD_INFO_FILE, _tmp36_, BUILD_VIEW_BUILD_INFO_PATH, _tmp37_, BUILD_VIEW_BUILD_INFO_START_LINE, _tmp38_, BUILD_VIEW_BUILD_INFO_END_LINE, _tmp39_, BUILD_VIEW_BUILD_INFO_LINE, _tmp40_, -1, -1);
	_g_free0 (_tmp30_);
	*result = iter;
	_g_free0 (_tmp21_);
	_g_free0 (line_str);
	_g_free0 (path);
	_g_object_unref0 (file);
	return;
}


static gchar* build_view_get_icon_from_state (BuildView* self, PartitionState state) {
	gchar* result = NULL;
	PartitionState _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = state;
	switch (_tmp0_) {
		case PARTITION_STATE_RUNNING:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (GTK_STOCK_EXECUTE);
			result = _tmp1_;
			return result;
		}
		case PARTITION_STATE_SUCCEEDED:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (GTK_STOCK_APPLY);
			result = _tmp2_;
			return result;
		}
		case PARTITION_STATE_FAILED:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (GTK_STOCK_DIALOG_ERROR);
			result = _tmp3_;
			return result;
		}
		case PARTITION_STATE_ABORTED:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (GTK_STOCK_STOP);
			result = _tmp4_;
			return result;
		}
		default:
		{
			g_return_val_if_reached (NULL);
		}
	}
}


static gchar* build_view_get_icon_from_msg_type (BuildView* self, BuildMsgType type) {
	gchar* result = NULL;
	BuildMsgType _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = type;
	switch (_tmp0_) {
		case BUILD_MSG_TYPE_ERROR:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (GTK_STOCK_DIALOG_ERROR);
			result = _tmp1_;
			return result;
		}
		case BUILD_MSG_TYPE_WARNING:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (GTK_STOCK_DIALOG_WARNING);
			result = _tmp2_;
			return result;
		}
		case BUILD_MSG_TYPE_BADBOX:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("badbox");
			result = _tmp3_;
			return result;
		}
		case BUILD_MSG_TYPE_OTHER:
		{
			result = NULL;
			return result;
		}
		default:
		{
			g_return_val_if_reached (NULL);
		}
	}
}


void build_view_show (BuildView* self) {
	GtkToggleAction* _tmp0_;
	g_return_if_fail (self != NULL);
	GTK_WIDGET_CLASS (build_view_parent_class)->show ((GtkWidget*) GTK_HBOX (self));
	_tmp0_ = self->priv->_action_view_bottom_panel;
	gtk_toggle_action_set_active (_tmp0_, TRUE);
}


gboolean build_view_get_show_errors (BuildView* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_errors;
	result = _tmp0_;
	return result;
}


void build_view_set_show_errors (BuildView* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_show_errors = _tmp0_;
	g_object_notify ((GObject *) self, "show-errors");
}


gboolean build_view_get_show_warnings (BuildView* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_warnings;
	result = _tmp0_;
	return result;
}


void build_view_set_show_warnings (BuildView* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_show_warnings = _tmp0_;
	g_object_notify ((GObject *) self, "show-warnings");
}


gboolean build_view_get_show_badboxes (BuildView* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_badboxes;
	result = _tmp0_;
	return result;
}


void build_view_set_show_badboxes (BuildView* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_show_badboxes = _tmp0_;
	g_object_notify ((GObject *) self, "show-badboxes");
}


static void build_view_class_init (BuildViewClass * klass) {
	build_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BuildViewPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_build_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_build_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = build_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUILD_VIEW_SHOW_ERRORS, g_param_spec_boolean ("show-errors", "show-errors", "show-errors", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUILD_VIEW_SHOW_WARNINGS, g_param_spec_boolean ("show-warnings", "show-warnings", "show-warnings", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUILD_VIEW_SHOW_BADBOXES, g_param_spec_boolean ("show-badboxes", "show-badboxes", "show-badboxes", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void build_view_instance_init (BuildView * self) {
	self->priv = BUILD_VIEW_GET_PRIVATE (self);
}


static void build_view_finalize (GObject* obj) {
	BuildView * self;
	self = BUILD_VIEW (obj);
	_g_object_unref0 (self->priv->_store);
	_g_object_unref0 (self->priv->_filtered_model);
	_g_object_unref0 (self->priv->_view);
	G_OBJECT_CLASS (build_view_parent_class)->finalize (obj);
}


GType build_view_get_type (void) {
	static volatile gsize build_view_type_id__volatile = 0;
	if (g_once_init_enter (&build_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BuildViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) build_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BuildView), 0, (GInstanceInitFunc) build_view_instance_init, NULL };
		GType build_view_type_id;
		build_view_type_id = g_type_register_static (GTK_TYPE_HBOX, "BuildView", &g_define_type_info, 0);
		g_once_init_leave (&build_view_type_id__volatile, build_view_type_id);
	}
	return build_view_type_id__volatile;
}


static void _vala_build_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BuildView * self;
	self = BUILD_VIEW (object);
	switch (property_id) {
		case BUILD_VIEW_SHOW_ERRORS:
		g_value_set_boolean (value, build_view_get_show_errors (self));
		break;
		case BUILD_VIEW_SHOW_WARNINGS:
		g_value_set_boolean (value, build_view_get_show_warnings (self));
		break;
		case BUILD_VIEW_SHOW_BADBOXES:
		g_value_set_boolean (value, build_view_get_show_badboxes (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_build_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BuildView * self;
	self = BUILD_VIEW (object);
	switch (property_id) {
		case BUILD_VIEW_SHOW_ERRORS:
		build_view_set_show_errors (self, g_value_get_boolean (value));
		break;
		case BUILD_VIEW_SHOW_WARNINGS:
		build_view_set_show_warnings (self, g_value_get_boolean (value));
		break;
		case BUILD_VIEW_SHOW_BADBOXES:
		build_view_set_show_badboxes (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



