/* latex_post_processor.c generated by valac 0.15.1, the Vala compiler
 * generated from latex_post_processor.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>


#define TYPE_POST_PROCESSOR (post_processor_get_type ())
#define POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_POST_PROCESSOR, PostProcessor))
#define POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_POST_PROCESSOR, PostProcessorClass))
#define IS_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_POST_PROCESSOR))
#define IS_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_POST_PROCESSOR))
#define POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_POST_PROCESSOR, PostProcessorClass))

typedef struct _PostProcessor PostProcessor;
typedef struct _PostProcessorClass PostProcessorClass;
typedef struct _PostProcessorPrivate PostProcessorPrivate;

#define TYPE_BUILD_MSG (build_msg_get_type ())

#define TYPE_BUILD_MSG_TYPE (build_msg_type_get_type ())
typedef struct _BuildMsg BuildMsg;

#define TYPE_LATEX_POST_PROCESSOR (latex_post_processor_get_type ())
#define LATEX_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEX_POST_PROCESSOR, LatexPostProcessor))
#define LATEX_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEX_POST_PROCESSOR, LatexPostProcessorClass))
#define IS_LATEX_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEX_POST_PROCESSOR))
#define IS_LATEX_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEX_POST_PROCESSOR))
#define LATEX_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEX_POST_PROCESSOR, LatexPostProcessorClass))

typedef struct _LatexPostProcessor LatexPostProcessor;
typedef struct _LatexPostProcessorClass LatexPostProcessorClass;
typedef struct _LatexPostProcessorPrivate LatexPostProcessorPrivate;

#define LATEX_POST_PROCESSOR_TYPE_FILTER_STATUS (latex_post_processor_filter_status_get_type ())

#define LATEX_POST_PROCESSOR_TYPE_FILE_IN_STACK (latex_post_processor_file_in_stack_get_type ())
typedef struct _LatexPostProcessorFileInStack LatexPostProcessorFileInStack;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_slist_free__latex_post_processor_file_in_stack_free0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__latex_post_processor_file_in_stack_free0_ (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))

typedef enum  {
	BUILD_MSG_TYPE_ERROR,
	BUILD_MSG_TYPE_WARNING,
	BUILD_MSG_TYPE_BADBOX,
	BUILD_MSG_TYPE_OTHER
} BuildMsgType;

struct _BuildMsg {
	gchar* text;
	BuildMsgType type;
	gchar* filename;
	gboolean lines_set;
	gint start_line;
	gint end_line;
	gboolean expand;
};

struct _PostProcessor {
	GObject parent_instance;
	PostProcessorPrivate * priv;
	GNode* _all_messages;
};

struct _PostProcessorClass {
	GObjectClass parent_class;
	void (*process) (PostProcessor* self, GFile* file, const gchar* output);
};

struct _LatexPostProcessor {
	PostProcessor parent_instance;
	LatexPostProcessorPrivate * priv;
};

struct _LatexPostProcessorClass {
	PostProcessorClass parent_class;
};

typedef enum  {
	LATEX_POST_PROCESSOR_FILTER_STATUS_START,
	LATEX_POST_PROCESSOR_FILTER_STATUS_BADBOX,
	LATEX_POST_PROCESSOR_FILTER_STATUS_WARNING,
	LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR,
	LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR_SEARCH_LINE,
	LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME,
	LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME_HEURISTIC
} LatexPostProcessorFilterStatus;

struct _LatexPostProcessorFileInStack {
	gchar* filename;
	gboolean reliable;
	gboolean exists;
};

struct _LatexPostProcessorPrivate {
	BuildMsg msg;
	LatexPostProcessorFilterStatus status;
	gchar* line_buf;
	gint nb_lines;
	gchar* filename_buf;
	GSList* stack_files;
	gchar* directory_path;
	gint nb_badboxes;
	gint nb_warnings;
	gint nb_errors;
};


static gpointer latex_post_processor_parent_class = NULL;
static GRegex* latex_post_processor_reg_badbox;
static GRegex* latex_post_processor_reg_badbox = NULL;
static GRegex* latex_post_processor_reg_badbox_lines;
static GRegex* latex_post_processor_reg_badbox_lines = NULL;
static GRegex* latex_post_processor_reg_badbox_line;
static GRegex* latex_post_processor_reg_badbox_line = NULL;
static GRegex* latex_post_processor_reg_badbox_output;
static GRegex* latex_post_processor_reg_badbox_output = NULL;
static GRegex* latex_post_processor_reg_warning;
static GRegex* latex_post_processor_reg_warning = NULL;
static GRegex* latex_post_processor_reg_warning_no_file;
static GRegex* latex_post_processor_reg_warning_no_file = NULL;
static GRegex* latex_post_processor_reg_warning_line;
static GRegex* latex_post_processor_reg_warning_line = NULL;
static GRegex* latex_post_processor_reg_warning_international_line;
static GRegex* latex_post_processor_reg_warning_international_line = NULL;
static GRegex* latex_post_processor_reg_latex_error;
static GRegex* latex_post_processor_reg_latex_error = NULL;
static GRegex* latex_post_processor_reg_pdflatex_error;
static GRegex* latex_post_processor_reg_pdflatex_error = NULL;
static GRegex* latex_post_processor_reg_tex_error;
static GRegex* latex_post_processor_reg_tex_error = NULL;
static GRegex* latex_post_processor_reg_error_line;
static GRegex* latex_post_processor_reg_error_line = NULL;
static GRegex* latex_post_processor_reg_file_pop;
static GRegex* latex_post_processor_reg_file_pop = NULL;
static GRegex* latex_post_processor_reg_other_bytes;
static GRegex* latex_post_processor_reg_other_bytes = NULL;
static GRegex* latex_post_processor_reg_spaces;
static GRegex* latex_post_processor_reg_spaces = NULL;

GType post_processor_get_type (void) G_GNUC_CONST;
GType build_msg_get_type (void) G_GNUC_CONST;
GType build_msg_type_get_type (void) G_GNUC_CONST;
BuildMsg* build_msg_dup (const BuildMsg* self);
void build_msg_free (BuildMsg* self);
void build_msg_copy (const BuildMsg* self, BuildMsg* dest);
void build_msg_destroy (BuildMsg* self);
GType latex_post_processor_get_type (void) G_GNUC_CONST;
static GType latex_post_processor_filter_status_get_type (void) G_GNUC_UNUSED;
static GType latex_post_processor_file_in_stack_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static LatexPostProcessorFileInStack* latex_post_processor_file_in_stack_dup (const LatexPostProcessorFileInStack* self);
static void latex_post_processor_file_in_stack_free (LatexPostProcessorFileInStack* self);
static void latex_post_processor_file_in_stack_copy (const LatexPostProcessorFileInStack* self, LatexPostProcessorFileInStack* dest);
static void latex_post_processor_file_in_stack_destroy (LatexPostProcessorFileInStack* self);
#define LATEX_POST_PROCESSOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LATEX_POST_PROCESSOR, LatexPostProcessorPrivate))
enum  {
	LATEX_POST_PROCESSOR_DUMMY_PROPERTY
};
static void _latex_post_processor_file_in_stack_free0_ (gpointer var);
static void _g_slist_free__latex_post_processor_file_in_stack_free0_ (GSList* self);
#define LATEX_POST_PROCESSOR_NO_LINE (-1)
LatexPostProcessor* latex_post_processor_new (void);
LatexPostProcessor* latex_post_processor_construct (GType object_type);
PostProcessor* post_processor_construct (GType object_type);
static void latex_post_processor_reset_msg (LatexPostProcessor* self);
static void latex_post_processor_real_process (PostProcessor* base, GFile* file, const gchar* output);
static void latex_post_processor_latex_output_filter (LatexPostProcessor* self, const gchar* line);
static void latex_post_processor_add_msg (LatexPostProcessor* self, gboolean set_filename);
static gboolean latex_post_processor_detect_badbox (LatexPostProcessor* self, const gchar* line);
static gboolean latex_post_processor_detect_warning (LatexPostProcessor* self, const gchar* line);
static gboolean latex_post_processor_detect_error (LatexPostProcessor* self, const gchar* line);
static gboolean latex_post_processor_detect_other (LatexPostProcessor* self, const gchar* line);
static void latex_post_processor_update_stack_file (LatexPostProcessor* self, const gchar* line);
static gboolean latex_post_processor_detect_badbox_line (LatexPostProcessor* self, const gchar* badbox, gboolean current_line_is_empty);
static gboolean latex_post_processor_detect_warning_line (LatexPostProcessor* self, const gchar* warning, gboolean current_line_is_empty);
static void latex_post_processor_pop_file_from_stack (LatexPostProcessor* self);
static void latex_post_processor_update_stack_file_heuristic (LatexPostProcessor* self, const gchar* line);
static void latex_post_processor_push_file_on_stack (LatexPostProcessor* self, const gchar* filename, gboolean reliable);
static gboolean latex_post_processor_file_exists (LatexPostProcessor* self, const gchar* filename);
static gboolean latex_post_processor_top_file_on_stack_is_reliable (LatexPostProcessor* self);
static gchar* latex_post_processor_get_path_if_file_exists (LatexPostProcessor* self, const gchar* filename);
static gchar* latex_post_processor_get_current_filename (LatexPostProcessor* self);
GNode* post_processor_append_message (PostProcessor* self, BuildMsg* message);
static void latex_post_processor_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static GType latex_post_processor_filter_status_get_type (void) {
	static volatile gsize latex_post_processor_filter_status_type_id__volatile = 0;
	if (g_once_init_enter (&latex_post_processor_filter_status_type_id__volatile)) {
		static const GEnumValue values[] = {{LATEX_POST_PROCESSOR_FILTER_STATUS_START, "LATEX_POST_PROCESSOR_FILTER_STATUS_START", "start"}, {LATEX_POST_PROCESSOR_FILTER_STATUS_BADBOX, "LATEX_POST_PROCESSOR_FILTER_STATUS_BADBOX", "badbox"}, {LATEX_POST_PROCESSOR_FILTER_STATUS_WARNING, "LATEX_POST_PROCESSOR_FILTER_STATUS_WARNING", "warning"}, {LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR, "LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR", "error"}, {LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR_SEARCH_LINE, "LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR_SEARCH_LINE", "error-search-line"}, {LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME, "LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME", "filename"}, {LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME_HEURISTIC, "LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME_HEURISTIC", "filename-heuristic"}, {0, NULL, NULL}};
		GType latex_post_processor_filter_status_type_id;
		latex_post_processor_filter_status_type_id = g_enum_register_static ("LatexPostProcessorFilterStatus", values);
		g_once_init_leave (&latex_post_processor_filter_status_type_id__volatile, latex_post_processor_filter_status_type_id);
	}
	return latex_post_processor_filter_status_type_id__volatile;
}


static void _latex_post_processor_file_in_stack_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (latex_post_processor_file_in_stack_free (var), NULL));
}


static void _g_slist_free__latex_post_processor_file_in_stack_free0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _latex_post_processor_file_in_stack_free0_, NULL);
	g_slist_free (self);
}


LatexPostProcessor* latex_post_processor_construct (GType object_type) {
	LatexPostProcessor * self = NULL;
	GRegex* _tmp0_;
	GError * _inner_error_ = NULL;
	self = (LatexPostProcessor*) post_processor_construct (object_type);
	latex_post_processor_reset_msg (self);
	_tmp0_ = latex_post_processor_reg_badbox;
	if (_tmp0_ != NULL) {
		return self;
	}
	{
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		GRegex* _tmp7_;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* warning_str;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		GRegex* _tmp13_;
		GRegex* _tmp14_;
		GRegex* _tmp15_;
		GRegex* _tmp16_;
		GRegex* _tmp17_;
		GRegex* _tmp18_;
		GRegex* _tmp19_;
		GRegex* _tmp20_;
		GRegex* _tmp21_;
		GRegex* _tmp22_;
		GRegex* _tmp23_;
		GRegex* _tmp24_;
		GRegex* _tmp25_;
		GRegex* _tmp26_;
		GRegex* _tmp27_;
		GRegex* _tmp28_;
		GRegex* _tmp29_;
		GRegex* _tmp30_;
		GRegex* _tmp31_;
		GRegex* _tmp32_;
		GRegex* _tmp33_;
		GRegex* _tmp34_;
		_tmp1_ = g_regex_new ("^(Over|Under)full \\\\[hv]box", 0, 0, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch26_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (latex_post_processor_reg_badbox);
		latex_post_processor_reg_badbox = _tmp2_;
		_tmp3_ = g_regex_new ("(.*) at lines (\\d+)--(\\d+)", 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch26_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (latex_post_processor_reg_badbox_lines);
		latex_post_processor_reg_badbox_lines = _tmp4_;
		_tmp5_ = g_regex_new ("(.*) at line (\\d+)", 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch26_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (latex_post_processor_reg_badbox_line);
		latex_post_processor_reg_badbox_line = _tmp6_;
		_tmp7_ = g_regex_new ("(.*)has occurred while \\output is active", 0, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch26_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (latex_post_processor_reg_badbox_output);
		latex_post_processor_reg_badbox_output = _tmp8_;
		_tmp9_ = g_strdup ("^(((! )?(La|pdf)TeX)|Package|Class)");
		warning_str = _tmp9_;
		_tmp10_ = warning_str;
		_tmp11_ = g_strconcat (_tmp10_, "(?P<name>.*) Warning[^:]*:\\s*(?P<contents>.*)", NULL);
		_g_free0 (warning_str);
		warning_str = _tmp11_;
		_tmp12_ = warning_str;
		_tmp13_ = g_regex_new (_tmp12_, G_REGEX_CASELESS | G_REGEX_OPTIMIZE, 0, &_inner_error_);
		_tmp14_ = _tmp13_;
		if (_inner_error_ != NULL) {
			_g_free0 (warning_str);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch26_g_regex_error;
			}
			_g_free0 (warning_str);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (latex_post_processor_reg_warning);
		latex_post_processor_reg_warning = _tmp14_;
		_tmp15_ = g_regex_new ("(No file .*)", 0, 0, &_inner_error_);
		_tmp16_ = _tmp15_;
		if (_inner_error_ != NULL) {
			_g_free0 (warning_str);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch26_g_regex_error;
			}
			_g_free0 (warning_str);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (latex_post_processor_reg_warning_no_file);
		latex_post_processor_reg_warning_no_file = _tmp16_;
		_tmp17_ = g_regex_new ("(.*) on input line (\\d+)\\.$", 0, 0, &_inner_error_);
		_tmp18_ = _tmp17_;
		if (_inner_error_ != NULL) {
			_g_free0 (warning_str);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch26_g_regex_error;
			}
			_g_free0 (warning_str);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (latex_post_processor_reg_warning_line);
		latex_post_processor_reg_warning_line = _tmp18_;
		_tmp19_ = g_regex_new ("(.*)(\\d+)\\.$", 0, 0, &_inner_error_);
		_tmp20_ = _tmp19_;
		if (_inner_error_ != NULL) {
			_g_free0 (warning_str);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch26_g_regex_error;
			}
			_g_free0 (warning_str);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (latex_post_processor_reg_warning_international_line);
		latex_post_processor_reg_warning_international_line = _tmp20_;
		_tmp21_ = g_regex_new ("^! LaTeX Error: (.*)$", 0, 0, &_inner_error_);
		_tmp22_ = _tmp21_;
		if (_inner_error_ != NULL) {
			_g_free0 (warning_str);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch26_g_regex_error;
			}
			_g_free0 (warning_str);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (latex_post_processor_reg_latex_error);
		latex_post_processor_reg_latex_error = _tmp22_;
		_tmp23_ = g_regex_new ("^Error: pdflatex (.*)$", 0, 0, &_inner_error_);
		_tmp24_ = _tmp23_;
		if (_inner_error_ != NULL) {
			_g_free0 (warning_str);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch26_g_regex_error;
			}
			_g_free0 (warning_str);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (latex_post_processor_reg_pdflatex_error);
		latex_post_processor_reg_pdflatex_error = _tmp24_;
		_tmp25_ = g_regex_new ("^! (.*)\\.$", 0, 0, &_inner_error_);
		_tmp26_ = _tmp25_;
		if (_inner_error_ != NULL) {
			_g_free0 (warning_str);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch26_g_regex_error;
			}
			_g_free0 (warning_str);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (latex_post_processor_reg_tex_error);
		latex_post_processor_reg_tex_error = _tmp26_;
		_tmp27_ = g_regex_new ("^l\\.(\\d+)(.*)", 0, 0, &_inner_error_);
		_tmp28_ = _tmp27_;
		if (_inner_error_ != NULL) {
			_g_free0 (warning_str);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch26_g_regex_error;
			}
			_g_free0 (warning_str);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (latex_post_processor_reg_error_line);
		latex_post_processor_reg_error_line = _tmp28_;
		_tmp29_ = g_regex_new ("(\\) )?:<-$", 0, 0, &_inner_error_);
		_tmp30_ = _tmp29_;
		if (_inner_error_ != NULL) {
			_g_free0 (warning_str);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch26_g_regex_error;
			}
			_g_free0 (warning_str);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (latex_post_processor_reg_file_pop);
		latex_post_processor_reg_file_pop = _tmp30_;
		_tmp31_ = g_regex_new ("(?P<nb>\\d+) bytes", 0, 0, &_inner_error_);
		_tmp32_ = _tmp31_;
		if (_inner_error_ != NULL) {
			_g_free0 (warning_str);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch26_g_regex_error;
			}
			_g_free0 (warning_str);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (latex_post_processor_reg_other_bytes);
		latex_post_processor_reg_other_bytes = _tmp32_;
		_tmp33_ = g_regex_new ("\\s{2,}", 0, 0, &_inner_error_);
		_tmp34_ = _tmp33_;
		if (_inner_error_ != NULL) {
			_g_free0 (warning_str);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch26_g_regex_error;
			}
			_g_free0 (warning_str);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (latex_post_processor_reg_spaces);
		latex_post_processor_reg_spaces = _tmp34_;
		_g_free0 (warning_str);
	}
	goto __finally26;
	__catch26_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp35_;
		const gchar* _tmp36_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp35_ = e;
		_tmp36_ = _tmp35_->message;
		g_warning ("latex_post_processor.vala:128: LatexPostProcessor: %s", _tmp36_);
		_g_error_free0 (e);
	}
	__finally26:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


LatexPostProcessor* latex_post_processor_new (void) {
	return latex_post_processor_construct (TYPE_LATEX_POST_PROCESSOR);
}


static void latex_post_processor_real_process (PostProcessor* base, GFile* file, const gchar* output) {
	LatexPostProcessor * self;
	GFile* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_ = NULL;
	gchar** lines;
	gint lines_length1;
	gint _lines_size_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp10_ = NULL;
	gint _tmp11_;
	const gchar* _tmp12_ = NULL;
	gint _tmp13_;
	const gchar* _tmp14_ = NULL;
	gint _tmp15_;
	gint _tmp16_;
	const gchar* _tmp17_;
	gint _tmp18_;
	const gchar* _tmp19_;
	gint _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_ = NULL;
	self = (LatexPostProcessor*) base;
	g_return_if_fail (file != NULL);
	g_return_if_fail (output != NULL);
	_tmp0_ = file;
	_tmp1_ = g_file_get_parent (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_get_parse_name (_tmp2_);
	_g_free0 (self->priv->directory_path);
	self->priv->directory_path = _tmp3_;
	_g_object_unref0 (_tmp2_);
	_tmp4_ = output;
	_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, "\n", 0);
	lines = _tmp6_;
	lines_length1 = _vala_array_length (_tmp5_);
	_lines_size_ = lines_length1;
	_tmp7_ = lines;
	_tmp7__length1 = lines_length1;
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp7_;
		line_collection_length1 = _tmp7__length1;
		for (line_it = 0; line_it < _tmp7__length1; line_it = line_it + 1) {
			gchar* _tmp8_;
			gchar* line = NULL;
			_tmp8_ = g_strdup (line_collection[line_it]);
			line = _tmp8_;
			{
				const gchar* _tmp9_;
				_tmp9_ = line;
				latex_post_processor_latex_output_filter (self, _tmp9_);
				_g_free0 (line);
			}
		}
	}
	_tmp11_ = self->priv->nb_errors;
	if (_tmp11_ == 1) {
		_tmp10_ = "error";
	} else {
		_tmp10_ = "errors";
	}
	_tmp13_ = self->priv->nb_warnings;
	if (_tmp13_ == 1) {
		_tmp12_ = "warning";
	} else {
		_tmp12_ = "warnings";
	}
	_tmp15_ = self->priv->nb_badboxes;
	if (_tmp15_ == 1) {
		_tmp14_ = "badbox";
	} else {
		_tmp14_ = "badboxes";
	}
	_tmp16_ = self->priv->nb_errors;
	_tmp17_ = _tmp10_;
	_tmp18_ = self->priv->nb_warnings;
	_tmp19_ = _tmp12_;
	_tmp20_ = self->priv->nb_badboxes;
	_tmp21_ = _tmp14_;
	_tmp22_ = g_strdup_printf ("%d %s, %d %s, %d %s", _tmp16_, _tmp17_, _tmp18_, _tmp19_, _tmp20_, _tmp21_);
	_g_free0 (self->priv->msg.text);
	self->priv->msg.text = _tmp22_;
	self->priv->msg.type = BUILD_MSG_TYPE_OTHER;
	latex_post_processor_add_msg (self, FALSE);
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
}


static void latex_post_processor_latex_output_filter (LatexPostProcessor* self, const gchar* line) {
	LatexPostProcessorFilterStatus _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	_tmp0_ = self->priv->status;
	switch (_tmp0_) {
		case LATEX_POST_PROCESSOR_FILTER_STATUS_START:
		{
			const gchar* _tmp1_;
			gint _tmp2_;
			gint _tmp3_;
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_ = FALSE;
			const gchar* _tmp7_;
			gboolean _tmp8_ = FALSE;
			gboolean _tmp11_;
			gboolean _tmp14_;
			gboolean _tmp17_;
			_tmp1_ = line;
			_tmp2_ = strlen (_tmp1_);
			_tmp3_ = _tmp2_;
			if (_tmp3_ == 0) {
				return;
			}
			_tmp7_ = line;
			_tmp8_ = latex_post_processor_detect_badbox (self, _tmp7_);
			if (_tmp8_) {
				_tmp6_ = TRUE;
			} else {
				const gchar* _tmp9_;
				gboolean _tmp10_ = FALSE;
				_tmp9_ = line;
				_tmp10_ = latex_post_processor_detect_warning (self, _tmp9_);
				_tmp6_ = _tmp10_;
			}
			_tmp11_ = _tmp6_;
			if (_tmp11_) {
				_tmp5_ = TRUE;
			} else {
				const gchar* _tmp12_;
				gboolean _tmp13_ = FALSE;
				_tmp12_ = line;
				_tmp13_ = latex_post_processor_detect_error (self, _tmp12_);
				_tmp5_ = _tmp13_;
			}
			_tmp14_ = _tmp5_;
			if (_tmp14_) {
				_tmp4_ = TRUE;
			} else {
				const gchar* _tmp15_;
				gboolean _tmp16_ = FALSE;
				_tmp15_ = line;
				_tmp16_ = latex_post_processor_detect_other (self, _tmp15_);
				_tmp4_ = _tmp16_;
			}
			_tmp17_ = _tmp4_;
			if (!_tmp17_) {
				const gchar* _tmp18_;
				_tmp18_ = line;
				latex_post_processor_update_stack_file (self, _tmp18_);
			}
			break;
		}
		case LATEX_POST_PROCESSOR_FILTER_STATUS_BADBOX:
		{
			const gchar* _tmp19_;
			_tmp19_ = line;
			latex_post_processor_detect_badbox (self, _tmp19_);
			break;
		}
		case LATEX_POST_PROCESSOR_FILTER_STATUS_WARNING:
		{
			const gchar* _tmp20_;
			_tmp20_ = line;
			latex_post_processor_detect_warning (self, _tmp20_);
			break;
		}
		case LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR:
		case LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR_SEARCH_LINE:
		{
			const gchar* _tmp21_;
			_tmp21_ = line;
			latex_post_processor_detect_error (self, _tmp21_);
			break;
		}
		case LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME:
		case LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME_HEURISTIC:
		{
			const gchar* _tmp22_;
			_tmp22_ = line;
			latex_post_processor_update_stack_file (self, _tmp22_);
			break;
		}
		default:
		{
			self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
			break;
		}
	}
}


static gboolean latex_post_processor_detect_badbox (LatexPostProcessor* self, const gchar* line) {
	gboolean result = FALSE;
	LatexPostProcessorFilterStatus _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_tmp0_ = self->priv->status;
	switch (_tmp0_) {
		case LATEX_POST_PROCESSOR_FILTER_STATUS_START:
		{
			GRegex* _tmp1_;
			const gchar* _tmp2_;
			gboolean _tmp3_ = FALSE;
			const gchar* _tmp4_;
			gboolean _tmp5_ = FALSE;
			_tmp1_ = latex_post_processor_reg_badbox;
			_tmp2_ = line;
			_tmp3_ = g_regex_match (_tmp1_, _tmp2_, 0, NULL);
			if (!_tmp3_) {
				result = FALSE;
				return result;
			}
			self->priv->msg.type = BUILD_MSG_TYPE_BADBOX;
			_tmp4_ = line;
			_tmp5_ = latex_post_processor_detect_badbox_line (self, _tmp4_, FALSE);
			if (_tmp5_) {
				latex_post_processor_add_msg (self, TRUE);
			} else {
				const gchar* _tmp6_;
				gchar* _tmp7_;
				gint _tmp8_;
				_tmp6_ = line;
				_tmp7_ = g_strdup (_tmp6_);
				_g_free0 (self->priv->line_buf);
				self->priv->line_buf = _tmp7_;
				_tmp8_ = self->priv->nb_lines;
				self->priv->nb_lines = _tmp8_ + 1;
			}
			result = TRUE;
			return result;
		}
		case LATEX_POST_PROCESSOR_FILTER_STATUS_BADBOX:
		{
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gint _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			gboolean _tmp17_ = FALSE;
			_tmp9_ = self->priv->line_buf;
			_tmp10_ = line;
			_tmp11_ = g_strconcat (_tmp9_, _tmp10_, NULL);
			_g_free0 (self->priv->line_buf);
			self->priv->line_buf = _tmp11_;
			_tmp12_ = self->priv->nb_lines;
			self->priv->nb_lines = _tmp12_ + 1;
			_tmp13_ = self->priv->line_buf;
			_tmp14_ = line;
			_tmp15_ = strlen (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = latex_post_processor_detect_badbox_line (self, _tmp13_, _tmp16_ == 0);
			if (_tmp17_) {
				latex_post_processor_add_msg (self, TRUE);
				self->priv->nb_lines = 0;
			}
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


static gboolean latex_post_processor_detect_badbox_line (LatexPostProcessor* self, const gchar* badbox, gboolean current_line_is_empty) {
	gboolean result = FALSE;
	GRegex* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (badbox != NULL, FALSE);
	_tmp0_ = latex_post_processor_reg_badbox_lines;
	_tmp1_ = badbox;
	_tmp2_ = g_regex_match (_tmp0_, _tmp1_, 0, NULL);
	if (_tmp2_) {
		GRegex* _tmp3_;
		const gchar* _tmp4_;
		gchar** _tmp5_;
		gchar** _tmp6_ = NULL;
		gchar** strings;
		gint strings_length1;
		gint _strings_size_;
		gchar** _tmp7_;
		gint _tmp7__length1;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar** _tmp10_;
		gint _tmp10__length1;
		const gchar* _tmp11_;
		gint _tmp12_ = 0;
		gint n1;
		gchar** _tmp13_;
		gint _tmp13__length1;
		const gchar* _tmp14_;
		gint _tmp15_ = 0;
		gint n2;
		gint _tmp16_;
		gint _tmp17_;
		self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
		_tmp3_ = latex_post_processor_reg_badbox_lines;
		_tmp4_ = badbox;
		_tmp6_ = _tmp5_ = g_regex_split (_tmp3_, _tmp4_, 0);
		strings = _tmp6_;
		strings_length1 = _vala_array_length (_tmp5_);
		_strings_size_ = strings_length1;
		_tmp7_ = strings;
		_tmp7__length1 = strings_length1;
		_tmp8_ = _tmp7_[1];
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (self->priv->msg.text);
		self->priv->msg.text = _tmp9_;
		_tmp10_ = strings;
		_tmp10__length1 = strings_length1;
		_tmp11_ = _tmp10_[2];
		_tmp12_ = atoi (_tmp11_);
		n1 = _tmp12_;
		_tmp13_ = strings;
		_tmp13__length1 = strings_length1;
		_tmp14_ = _tmp13_[3];
		_tmp15_ = atoi (_tmp14_);
		n2 = _tmp15_;
		_tmp16_ = n1;
		_tmp17_ = n2;
		if (_tmp16_ <= _tmp17_) {
			gint _tmp18_;
			gint _tmp19_;
			_tmp18_ = n1;
			self->priv->msg.start_line = _tmp18_;
			_tmp19_ = n2;
			self->priv->msg.end_line = _tmp19_;
		} else {
			gint _tmp20_;
			gint _tmp21_;
			_tmp20_ = n2;
			self->priv->msg.start_line = _tmp20_;
			_tmp21_ = n1;
			self->priv->msg.end_line = _tmp21_;
		}
		result = TRUE;
		strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
		return result;
	} else {
		GRegex* _tmp22_;
		const gchar* _tmp23_;
		gboolean _tmp24_ = FALSE;
		_tmp22_ = latex_post_processor_reg_badbox_line;
		_tmp23_ = badbox;
		_tmp24_ = g_regex_match (_tmp22_, _tmp23_, 0, NULL);
		if (_tmp24_) {
			GRegex* _tmp25_;
			const gchar* _tmp26_;
			gchar** _tmp27_;
			gchar** _tmp28_ = NULL;
			gchar** strings;
			gint strings_length1;
			gint _strings_size_;
			gchar** _tmp29_;
			gint _tmp29__length1;
			const gchar* _tmp30_;
			gchar* _tmp31_;
			gchar** _tmp32_;
			gint _tmp32__length1;
			const gchar* _tmp33_;
			gint _tmp34_ = 0;
			self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
			_tmp25_ = latex_post_processor_reg_badbox_line;
			_tmp26_ = badbox;
			_tmp28_ = _tmp27_ = g_regex_split (_tmp25_, _tmp26_, 0);
			strings = _tmp28_;
			strings_length1 = _vala_array_length (_tmp27_);
			_strings_size_ = strings_length1;
			_tmp29_ = strings;
			_tmp29__length1 = strings_length1;
			_tmp30_ = _tmp29_[1];
			_tmp31_ = g_strdup (_tmp30_);
			_g_free0 (self->priv->msg.text);
			self->priv->msg.text = _tmp31_;
			_tmp32_ = strings;
			_tmp32__length1 = strings_length1;
			_tmp33_ = _tmp32_[2];
			_tmp34_ = atoi (_tmp33_);
			self->priv->msg.start_line = _tmp34_;
			result = TRUE;
			strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
			return result;
		} else {
			GRegex* _tmp35_;
			const gchar* _tmp36_;
			gboolean _tmp37_ = FALSE;
			_tmp35_ = latex_post_processor_reg_badbox_output;
			_tmp36_ = badbox;
			_tmp37_ = g_regex_match (_tmp35_, _tmp36_, 0, NULL);
			if (_tmp37_) {
				GRegex* _tmp38_;
				const gchar* _tmp39_;
				gchar** _tmp40_;
				gchar** _tmp41_ = NULL;
				gchar** strings;
				gint strings_length1;
				gint _strings_size_;
				gchar** _tmp42_;
				gint _tmp42__length1;
				const gchar* _tmp43_;
				gchar* _tmp44_;
				self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
				_tmp38_ = latex_post_processor_reg_badbox_output;
				_tmp39_ = badbox;
				_tmp41_ = _tmp40_ = g_regex_split (_tmp38_, _tmp39_, 0);
				strings = _tmp41_;
				strings_length1 = _vala_array_length (_tmp40_);
				_strings_size_ = strings_length1;
				_tmp42_ = strings;
				_tmp42__length1 = strings_length1;
				_tmp43_ = _tmp42_[1];
				_tmp44_ = g_strdup (_tmp43_);
				_g_free0 (self->priv->msg.text);
				self->priv->msg.text = _tmp44_;
				self->priv->msg.start_line = LATEX_POST_PROCESSOR_NO_LINE;
				result = TRUE;
				strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
				return result;
			} else {
				gboolean _tmp45_ = FALSE;
				gint _tmp46_;
				gboolean _tmp48_;
				_tmp46_ = self->priv->nb_lines;
				if (_tmp46_ > 4) {
					_tmp45_ = TRUE;
				} else {
					gboolean _tmp47_;
					_tmp47_ = current_line_is_empty;
					_tmp45_ = _tmp47_;
				}
				_tmp48_ = _tmp45_;
				if (_tmp48_) {
					const gchar* _tmp49_;
					gchar* _tmp50_;
					self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
					_tmp49_ = badbox;
					_tmp50_ = g_strdup (_tmp49_);
					_g_free0 (self->priv->msg.text);
					self->priv->msg.text = _tmp50_;
					self->priv->msg.start_line = LATEX_POST_PROCESSOR_NO_LINE;
					result = TRUE;
					return result;
				}
			}
		}
	}
	self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_BADBOX;
	result = FALSE;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gboolean latex_post_processor_detect_warning (LatexPostProcessor* self, const gchar* line) {
	gboolean result = FALSE;
	LatexPostProcessorFilterStatus _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_tmp0_ = self->priv->status;
	switch (_tmp0_) {
		case LATEX_POST_PROCESSOR_FILTER_STATUS_START:
		{
			GMatchInfo* match_info = NULL;
			GRegex* _tmp1_;
			const gchar* _tmp2_;
			GMatchInfo* _tmp3_ = NULL;
			gboolean _tmp4_ = FALSE;
			_tmp1_ = latex_post_processor_reg_warning;
			_tmp2_ = line;
			_tmp4_ = g_regex_match (_tmp1_, _tmp2_, 0, &_tmp3_);
			_g_match_info_free0 (match_info);
			match_info = _tmp3_;
			if (_tmp4_) {
				GMatchInfo* _tmp5_;
				gchar* _tmp6_ = NULL;
				gchar* contents;
				GMatchInfo* _tmp7_;
				gchar* _tmp8_ = NULL;
				gchar* _tmp9_;
				gchar* _tmp10_ = NULL;
				gchar* _tmp11_;
				gchar* name;
				const gchar* _tmp12_;
				const gchar* _tmp18_;
				gboolean _tmp19_ = FALSE;
				self->priv->msg.type = BUILD_MSG_TYPE_WARNING;
				_tmp5_ = match_info;
				_tmp6_ = g_match_info_fetch_named (_tmp5_, "contents");
				contents = _tmp6_;
				_tmp7_ = match_info;
				_tmp8_ = g_match_info_fetch_named (_tmp7_, "name");
				_tmp9_ = _tmp8_;
				_tmp10_ = string_strip (_tmp9_);
				_tmp11_ = _tmp10_;
				_g_free0 (_tmp9_);
				name = _tmp11_;
				_tmp12_ = name;
				if (g_strcmp0 (_tmp12_, "") != 0) {
					const gchar* _tmp13_;
					const gchar* _tmp14_ = NULL;
					const gchar* _tmp15_;
					const gchar* _tmp16_ = NULL;
					gchar* _tmp17_ = NULL;
					_tmp13_ = name;
					_tmp14_ = string_to_string (_tmp13_);
					_tmp15_ = contents;
					_tmp16_ = string_to_string (_tmp15_);
					_tmp17_ = g_strconcat (_tmp14_, ": ", _tmp16_, NULL);
					_g_free0 (contents);
					contents = _tmp17_;
				}
				_tmp18_ = contents;
				_tmp19_ = latex_post_processor_detect_warning_line (self, _tmp18_, FALSE);
				if (_tmp19_) {
					latex_post_processor_add_msg (self, TRUE);
				} else {
					const gchar* _tmp20_;
					gchar* _tmp21_;
					gint _tmp22_;
					_tmp20_ = contents;
					_tmp21_ = g_strdup (_tmp20_);
					_g_free0 (self->priv->line_buf);
					self->priv->line_buf = _tmp21_;
					_tmp22_ = self->priv->nb_lines;
					self->priv->nb_lines = _tmp22_ + 1;
				}
				result = TRUE;
				_g_free0 (name);
				_g_free0 (contents);
				_g_match_info_free0 (match_info);
				return result;
			} else {
				GRegex* _tmp23_;
				const gchar* _tmp24_;
				gboolean _tmp25_ = FALSE;
				_tmp23_ = latex_post_processor_reg_warning_no_file;
				_tmp24_ = line;
				_tmp25_ = g_regex_match (_tmp23_, _tmp24_, 0, NULL);
				if (_tmp25_) {
					GRegex* _tmp26_;
					const gchar* _tmp27_;
					gchar** _tmp28_;
					gchar** _tmp29_ = NULL;
					gchar** strings;
					gint strings_length1;
					gint _strings_size_;
					gchar** _tmp30_;
					gint _tmp30__length1;
					const gchar* _tmp31_;
					gchar* _tmp32_;
					self->priv->msg.type = BUILD_MSG_TYPE_WARNING;
					_tmp26_ = latex_post_processor_reg_warning_no_file;
					_tmp27_ = line;
					_tmp29_ = _tmp28_ = g_regex_split (_tmp26_, _tmp27_, 0);
					strings = _tmp29_;
					strings_length1 = _vala_array_length (_tmp28_);
					_strings_size_ = strings_length1;
					_tmp30_ = strings;
					_tmp30__length1 = strings_length1;
					_tmp31_ = _tmp30_[1];
					_tmp32_ = g_strdup (_tmp31_);
					_g_free0 (self->priv->msg.text);
					self->priv->msg.text = _tmp32_;
					self->priv->msg.start_line = LATEX_POST_PROCESSOR_NO_LINE;
					latex_post_processor_add_msg (self, TRUE);
					result = TRUE;
					strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
					_g_match_info_free0 (match_info);
					return result;
				}
			}
			result = FALSE;
			_g_match_info_free0 (match_info);
			return result;
		}
		case LATEX_POST_PROCESSOR_FILTER_STATUS_WARNING:
		{
			const gchar* _tmp33_;
			const gchar* _tmp34_;
			gchar* _tmp35_;
			gint _tmp36_;
			const gchar* _tmp37_;
			const gchar* _tmp38_;
			gint _tmp39_;
			gint _tmp40_;
			gboolean _tmp41_ = FALSE;
			_tmp33_ = self->priv->line_buf;
			_tmp34_ = line;
			_tmp35_ = g_strconcat (_tmp33_, _tmp34_, NULL);
			_g_free0 (self->priv->line_buf);
			self->priv->line_buf = _tmp35_;
			_tmp36_ = self->priv->nb_lines;
			self->priv->nb_lines = _tmp36_ + 1;
			_tmp37_ = self->priv->line_buf;
			_tmp38_ = line;
			_tmp39_ = strlen (_tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = latex_post_processor_detect_warning_line (self, _tmp37_, _tmp40_ == 0);
			if (_tmp41_) {
				latex_post_processor_add_msg (self, TRUE);
				self->priv->nb_lines = 0;
			}
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean latex_post_processor_detect_warning_line (LatexPostProcessor* self, const gchar* warning, gboolean current_line_is_empty) {
	gboolean result = FALSE;
	GRegex* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (warning != NULL, FALSE);
	_tmp0_ = latex_post_processor_reg_warning_line;
	_tmp1_ = warning;
	_tmp2_ = g_regex_match (_tmp0_, _tmp1_, 0, NULL);
	if (_tmp2_) {
		GRegex* _tmp3_;
		const gchar* _tmp4_;
		gchar** _tmp5_;
		gchar** _tmp6_ = NULL;
		gchar** strings;
		gint strings_length1;
		gint _strings_size_;
		gchar** _tmp7_;
		gint _tmp7__length1;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar** _tmp10_;
		gint _tmp10__length1;
		const gchar* _tmp11_;
		gint _tmp12_ = 0;
		self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
		_tmp3_ = latex_post_processor_reg_warning_line;
		_tmp4_ = warning;
		_tmp6_ = _tmp5_ = g_regex_split (_tmp3_, _tmp4_, 0);
		strings = _tmp6_;
		strings_length1 = _vala_array_length (_tmp5_);
		_strings_size_ = strings_length1;
		_tmp7_ = strings;
		_tmp7__length1 = strings_length1;
		_tmp8_ = _tmp7_[1];
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (self->priv->msg.text);
		self->priv->msg.text = _tmp9_;
		_tmp10_ = strings;
		_tmp10__length1 = strings_length1;
		_tmp11_ = _tmp10_[2];
		_tmp12_ = atoi (_tmp11_);
		self->priv->msg.start_line = _tmp12_;
		result = TRUE;
		strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
		return result;
	} else {
		GRegex* _tmp13_;
		const gchar* _tmp14_;
		gboolean _tmp15_ = FALSE;
		_tmp13_ = latex_post_processor_reg_warning_international_line;
		_tmp14_ = warning;
		_tmp15_ = g_regex_match (_tmp13_, _tmp14_, 0, NULL);
		if (_tmp15_) {
			GRegex* _tmp16_;
			const gchar* _tmp17_;
			gchar** _tmp18_;
			gchar** _tmp19_ = NULL;
			gchar** strings;
			gint strings_length1;
			gint _strings_size_;
			gchar** _tmp20_;
			gint _tmp20__length1;
			const gchar* _tmp21_;
			gchar* _tmp22_;
			gchar** _tmp23_;
			gint _tmp23__length1;
			const gchar* _tmp24_;
			gint _tmp25_ = 0;
			self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
			_tmp16_ = latex_post_processor_reg_warning_international_line;
			_tmp17_ = warning;
			_tmp19_ = _tmp18_ = g_regex_split (_tmp16_, _tmp17_, 0);
			strings = _tmp19_;
			strings_length1 = _vala_array_length (_tmp18_);
			_strings_size_ = strings_length1;
			_tmp20_ = strings;
			_tmp20__length1 = strings_length1;
			_tmp21_ = _tmp20_[1];
			_tmp22_ = g_strdup (_tmp21_);
			_g_free0 (self->priv->msg.text);
			self->priv->msg.text = _tmp22_;
			_tmp23_ = strings;
			_tmp23__length1 = strings_length1;
			_tmp24_ = _tmp23_[2];
			_tmp25_ = atoi (_tmp24_);
			self->priv->msg.start_line = _tmp25_;
			result = TRUE;
			strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
			return result;
		} else {
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			gchar _tmp30_ = '\0';
			_tmp26_ = warning;
			_tmp27_ = warning;
			_tmp28_ = strlen (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = string_get (_tmp26_, (glong) (_tmp29_ - 1));
			if (_tmp30_ == '.') {
				const gchar* _tmp31_;
				gchar* _tmp32_;
				self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
				_tmp31_ = warning;
				_tmp32_ = g_strdup (_tmp31_);
				_g_free0 (self->priv->msg.text);
				self->priv->msg.text = _tmp32_;
				self->priv->msg.start_line = LATEX_POST_PROCESSOR_NO_LINE;
				result = TRUE;
				return result;
			} else {
				gboolean _tmp33_ = FALSE;
				gint _tmp34_;
				gboolean _tmp36_;
				_tmp34_ = self->priv->nb_lines;
				if (_tmp34_ > 5) {
					_tmp33_ = TRUE;
				} else {
					gboolean _tmp35_;
					_tmp35_ = current_line_is_empty;
					_tmp33_ = _tmp35_;
				}
				_tmp36_ = _tmp33_;
				if (_tmp36_) {
					const gchar* _tmp37_;
					gchar* _tmp38_;
					self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
					_tmp37_ = warning;
					_tmp38_ = g_strdup (_tmp37_);
					_g_free0 (self->priv->msg.text);
					self->priv->msg.text = _tmp38_;
					self->priv->msg.start_line = LATEX_POST_PROCESSOR_NO_LINE;
					result = TRUE;
					return result;
				}
			}
		}
	}
	self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_WARNING;
	result = FALSE;
	return result;
}


static gboolean latex_post_processor_detect_error (LatexPostProcessor* self, const gchar* line) {
	gboolean result = FALSE;
	LatexPostProcessorFilterStatus _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_tmp0_ = self->priv->status;
	switch (_tmp0_) {
		case LATEX_POST_PROCESSOR_FILTER_STATUS_START:
		{
			gboolean found;
			gchar* tmp;
			GRegex* _tmp1_;
			const gchar* _tmp2_;
			gboolean _tmp3_ = FALSE;
			gboolean _tmp31_;
			found = TRUE;
			tmp = NULL;
			_tmp1_ = latex_post_processor_reg_latex_error;
			_tmp2_ = line;
			_tmp3_ = g_regex_match (_tmp1_, _tmp2_, 0, NULL);
			if (_tmp3_) {
				GRegex* _tmp4_;
				const gchar* _tmp5_;
				gchar** _tmp6_;
				gchar** _tmp7_ = NULL;
				gchar** strings;
				gint strings_length1;
				gint _strings_size_;
				gchar** _tmp8_;
				gint _tmp8__length1;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				_tmp4_ = latex_post_processor_reg_latex_error;
				_tmp5_ = line;
				_tmp7_ = _tmp6_ = g_regex_split (_tmp4_, _tmp5_, 0);
				strings = _tmp7_;
				strings_length1 = _vala_array_length (_tmp6_);
				_strings_size_ = strings_length1;
				_tmp8_ = strings;
				_tmp8__length1 = strings_length1;
				_tmp9_ = _tmp8_[1];
				_tmp10_ = g_strdup (_tmp9_);
				_g_free0 (tmp);
				tmp = _tmp10_;
				strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
			} else {
				GRegex* _tmp11_;
				const gchar* _tmp12_;
				gboolean _tmp13_ = FALSE;
				_tmp11_ = latex_post_processor_reg_pdflatex_error;
				_tmp12_ = line;
				_tmp13_ = g_regex_match (_tmp11_, _tmp12_, 0, NULL);
				if (_tmp13_) {
					GRegex* _tmp14_;
					const gchar* _tmp15_;
					gchar** _tmp16_;
					gchar** _tmp17_ = NULL;
					gchar** strings;
					gint strings_length1;
					gint _strings_size_;
					gchar** _tmp18_;
					gint _tmp18__length1;
					const gchar* _tmp19_;
					gchar* _tmp20_;
					_tmp14_ = latex_post_processor_reg_pdflatex_error;
					_tmp15_ = line;
					_tmp17_ = _tmp16_ = g_regex_split (_tmp14_, _tmp15_, 0);
					strings = _tmp17_;
					strings_length1 = _vala_array_length (_tmp16_);
					_strings_size_ = strings_length1;
					_tmp18_ = strings;
					_tmp18__length1 = strings_length1;
					_tmp19_ = _tmp18_[1];
					_tmp20_ = g_strdup (_tmp19_);
					_g_free0 (tmp);
					tmp = _tmp20_;
					strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
				} else {
					GRegex* _tmp21_;
					const gchar* _tmp22_;
					gboolean _tmp23_ = FALSE;
					_tmp21_ = latex_post_processor_reg_tex_error;
					_tmp22_ = line;
					_tmp23_ = g_regex_match (_tmp21_, _tmp22_, 0, NULL);
					if (_tmp23_) {
						GRegex* _tmp24_;
						const gchar* _tmp25_;
						gchar** _tmp26_;
						gchar** _tmp27_ = NULL;
						gchar** strings;
						gint strings_length1;
						gint _strings_size_;
						gchar** _tmp28_;
						gint _tmp28__length1;
						const gchar* _tmp29_;
						gchar* _tmp30_;
						_tmp24_ = latex_post_processor_reg_tex_error;
						_tmp25_ = line;
						_tmp27_ = _tmp26_ = g_regex_split (_tmp24_, _tmp25_, 0);
						strings = _tmp27_;
						strings_length1 = _vala_array_length (_tmp26_);
						_strings_size_ = strings_length1;
						_tmp28_ = strings;
						_tmp28__length1 = strings_length1;
						_tmp29_ = _tmp28_[1];
						_tmp30_ = g_strdup (_tmp29_);
						_g_free0 (tmp);
						tmp = _tmp30_;
						strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
					} else {
						found = FALSE;
					}
				}
			}
			_tmp31_ = found;
			if (_tmp31_) {
				gint _tmp32_;
				const gchar* _tmp33_;
				const gchar* _tmp34_;
				gint _tmp35_;
				gint _tmp36_;
				gchar _tmp37_ = '\0';
				_tmp32_ = self->priv->nb_lines;
				self->priv->nb_lines = _tmp32_ + 1;
				self->priv->msg.type = BUILD_MSG_TYPE_ERROR;
				_tmp33_ = line;
				_tmp34_ = line;
				_tmp35_ = strlen (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = string_get (_tmp33_, (glong) (_tmp36_ - 1));
				if (_tmp37_ == '.') {
					const gchar* _tmp38_;
					gchar* _tmp39_;
					_tmp38_ = tmp;
					_tmp39_ = g_strdup (_tmp38_);
					_g_free0 (self->priv->msg.text);
					self->priv->msg.text = _tmp39_;
					self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR_SEARCH_LINE;
				} else {
					const gchar* _tmp40_;
					gchar* _tmp41_;
					_tmp40_ = tmp;
					_tmp41_ = g_strdup (_tmp40_);
					_g_free0 (self->priv->line_buf);
					self->priv->line_buf = _tmp41_;
					self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR;
				}
				result = TRUE;
				_g_free0 (tmp);
				return result;
			}
			result = FALSE;
			_g_free0 (tmp);
			return result;
		}
		case LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR:
		{
			const gchar* _tmp42_;
			const gchar* _tmp43_;
			gchar* _tmp44_;
			gint _tmp45_;
			const gchar* _tmp46_;
			const gchar* _tmp47_;
			gint _tmp48_;
			gint _tmp49_;
			gchar _tmp50_ = '\0';
			_tmp42_ = self->priv->line_buf;
			_tmp43_ = line;
			_tmp44_ = g_strconcat (_tmp42_, _tmp43_, NULL);
			_g_free0 (self->priv->line_buf);
			self->priv->line_buf = _tmp44_;
			_tmp45_ = self->priv->nb_lines;
			self->priv->nb_lines = _tmp45_ + 1;
			_tmp46_ = line;
			_tmp47_ = line;
			_tmp48_ = strlen (_tmp47_);
			_tmp49_ = _tmp48_;
			_tmp50_ = string_get (_tmp46_, (glong) (_tmp49_ - 1));
			if (_tmp50_ == '.') {
				const gchar* _tmp51_;
				gchar* _tmp52_;
				_tmp51_ = self->priv->line_buf;
				_tmp52_ = g_strdup (_tmp51_);
				_g_free0 (self->priv->msg.text);
				self->priv->msg.text = _tmp52_;
				self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR_SEARCH_LINE;
			} else {
				gint _tmp53_;
				_tmp53_ = self->priv->nb_lines;
				if (_tmp53_ > 4) {
					const gchar* _tmp54_;
					gchar* _tmp55_;
					_tmp54_ = self->priv->line_buf;
					_tmp55_ = g_strdup (_tmp54_);
					_g_free0 (self->priv->msg.text);
					self->priv->msg.text = _tmp55_;
					self->priv->msg.start_line = LATEX_POST_PROCESSOR_NO_LINE;
					latex_post_processor_add_msg (self, TRUE);
					self->priv->nb_lines = 0;
					self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
				}
			}
			result = TRUE;
			return result;
		}
		case LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR_SEARCH_LINE:
		{
			gint _tmp56_;
			GRegex* _tmp57_;
			const gchar* _tmp58_;
			gboolean _tmp59_ = FALSE;
			_tmp56_ = self->priv->nb_lines;
			self->priv->nb_lines = _tmp56_ + 1;
			_tmp57_ = latex_post_processor_reg_error_line;
			_tmp58_ = line;
			_tmp59_ = g_regex_match (_tmp57_, _tmp58_, 0, NULL);
			if (_tmp59_) {
				GRegex* _tmp60_;
				const gchar* _tmp61_;
				gchar** _tmp62_;
				gchar** _tmp63_ = NULL;
				gchar** strings;
				gint strings_length1;
				gint _strings_size_;
				gchar** _tmp64_;
				gint _tmp64__length1;
				const gchar* _tmp65_;
				gint _tmp66_ = 0;
				_tmp60_ = latex_post_processor_reg_error_line;
				_tmp61_ = line;
				_tmp63_ = _tmp62_ = g_regex_split (_tmp60_, _tmp61_, 0);
				strings = _tmp63_;
				strings_length1 = _vala_array_length (_tmp62_);
				_strings_size_ = strings_length1;
				_tmp64_ = strings;
				_tmp64__length1 = strings_length1;
				_tmp65_ = _tmp64_[1];
				_tmp66_ = atoi (_tmp65_);
				self->priv->msg.start_line = _tmp66_;
				latex_post_processor_add_msg (self, TRUE);
				self->priv->nb_lines = 0;
				self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
				result = TRUE;
				strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
				return result;
			} else {
				gint _tmp67_;
				_tmp67_ = self->priv->nb_lines;
				if (_tmp67_ > 11) {
					self->priv->msg.start_line = LATEX_POST_PROCESSOR_NO_LINE;
					latex_post_processor_add_msg (self, TRUE);
					self->priv->nb_lines = 0;
					self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
					result = TRUE;
					return result;
				}
			}
			break;
		}
		default:
		{
			break;
		}
	}
	result = FALSE;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gint64 int64_parse (const gchar* str) {
	gint64 result = 0LL;
	const gchar* _tmp0_;
	gint64 _tmp1_ = 0LL;
	g_return_val_if_fail (str != NULL, 0LL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoll (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static gboolean latex_post_processor_detect_other (LatexPostProcessor* self, const gchar* line) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GMatchInfo* match_info = NULL;
	GRegex* _tmp2_;
	const gchar* _tmp3_;
	GMatchInfo* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GMatchInfo* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* nb_bytes_str;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gint64 _tmp12_ = 0LL;
	gint64 nb_bytes;
	gint64 _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* human_size;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_tmp0_ = line;
	_tmp1_ = string_contains (_tmp0_, "Output written on");
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	self->priv->msg.start_line = LATEX_POST_PROCESSOR_NO_LINE;
	self->priv->msg.type = BUILD_MSG_TYPE_OTHER;
	_tmp2_ = latex_post_processor_reg_other_bytes;
	_tmp3_ = line;
	_tmp5_ = g_regex_match (_tmp2_, _tmp3_, 0, &_tmp4_);
	_g_match_info_free0 (match_info);
	match_info = _tmp4_;
	if (!_tmp5_) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = line;
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (self->priv->msg.text);
		self->priv->msg.text = _tmp7_;
		latex_post_processor_add_msg (self, FALSE);
		result = TRUE;
		_g_match_info_free0 (match_info);
		return result;
	}
	_tmp8_ = match_info;
	_tmp9_ = g_match_info_fetch_named (_tmp8_, "nb");
	nb_bytes_str = _tmp9_;
	_tmp10_ = nb_bytes_str;
	g_return_val_if_fail (_tmp10_ != NULL, FALSE);
	_tmp11_ = nb_bytes_str;
	_tmp12_ = int64_parse (_tmp11_);
	nb_bytes = _tmp12_;
	_tmp13_ = nb_bytes;
	_tmp14_ = g_format_size_full ((guint64) _tmp13_, G_FORMAT_SIZE_DEFAULT);
	human_size = _tmp14_;
	{
		GRegex* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* new_line;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp15_ = latex_post_processor_reg_other_bytes;
		_tmp16_ = line;
		_tmp17_ = human_size;
		_tmp18_ = g_regex_replace_literal (_tmp15_, _tmp16_, (gssize) (-1), 0, _tmp17_, 0, &_inner_error_);
		new_line = _tmp18_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch27_g_regex_error;
			}
			_g_free0 (human_size);
			_g_free0 (nb_bytes_str);
			_g_match_info_free0 (match_info);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp19_ = new_line;
		_tmp20_ = g_strdup (_tmp19_);
		_g_free0 (self->priv->msg.text);
		self->priv->msg.text = _tmp20_;
		_g_free0 (new_line);
	}
	goto __finally27;
	__catch27_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp21_ = e;
		_tmp22_ = _tmp21_->message;
		g_warning ("latex_post_processor.vala:511: LaTeX post processor: %s", _tmp22_);
		_tmp23_ = line;
		_tmp24_ = g_strdup (_tmp23_);
		_g_free0 (self->priv->msg.text);
		self->priv->msg.text = _tmp24_;
		_g_error_free0 (e);
	}
	__finally27:
	if (_inner_error_ != NULL) {
		_g_free0 (human_size);
		_g_free0 (nb_bytes_str);
		_g_match_info_free0 (match_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	latex_post_processor_add_msg (self, FALSE);
	result = TRUE;
	_g_free0 (human_size);
	_g_free0 (nb_bytes_str);
	_g_match_info_free0 (match_info);
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static void latex_post_processor_update_stack_file (LatexPostProcessor* self, const gchar* line) {
	LatexPostProcessorFilterStatus _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	_tmp0_ = self->priv->status;
	switch (_tmp0_) {
		case LATEX_POST_PROCESSOR_FILTER_STATUS_START:
		case LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME_HEURISTIC:
		{
			const gchar* _tmp1_;
			gboolean _tmp2_ = FALSE;
			_tmp1_ = line;
			_tmp2_ = g_str_has_prefix (_tmp1_, ":<+ ");
			if (_tmp2_) {
				const gchar* _tmp3_;
				gchar* _tmp4_ = NULL;
				gchar* _tmp5_;
				gchar* _tmp6_ = NULL;
				_tmp3_ = line;
				_tmp4_ = string_substring (_tmp3_, (glong) 4, (glong) (-1));
				_tmp5_ = _tmp4_;
				_tmp6_ = string_strip (_tmp5_);
				_g_free0 (self->priv->filename_buf);
				self->priv->filename_buf = _tmp6_;
				_g_free0 (_tmp5_);
				self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME;
			} else {
				gboolean _tmp7_ = FALSE;
				GRegex* _tmp8_;
				const gchar* _tmp9_;
				gboolean _tmp10_ = FALSE;
				gboolean _tmp13_;
				_tmp8_ = latex_post_processor_reg_file_pop;
				_tmp9_ = line;
				_tmp10_ = g_regex_match (_tmp8_, _tmp9_, 0, NULL);
				if (_tmp10_) {
					_tmp7_ = TRUE;
				} else {
					const gchar* _tmp11_;
					gboolean _tmp12_ = FALSE;
					_tmp11_ = line;
					_tmp12_ = g_str_has_prefix (_tmp11_, ":<-");
					_tmp7_ = _tmp12_;
				}
				_tmp13_ = _tmp7_;
				if (_tmp13_) {
					latex_post_processor_pop_file_from_stack (self);
				} else {
					const gchar* _tmp14_;
					_tmp14_ = line;
					latex_post_processor_update_stack_file_heuristic (self, _tmp14_);
				}
			}
			break;
		}
		case LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME:
		{
			gboolean _tmp15_ = FALSE;
			const gchar* _tmp16_;
			gchar _tmp17_ = '\0';
			gboolean _tmp20_;
			_tmp16_ = line;
			_tmp17_ = string_get (_tmp16_, (glong) 0);
			if (_tmp17_ == '(') {
				_tmp15_ = TRUE;
			} else {
				const gchar* _tmp18_;
				gboolean _tmp19_ = FALSE;
				_tmp18_ = line;
				_tmp19_ = g_str_has_prefix (_tmp18_, "\\openout");
				_tmp15_ = _tmp19_;
			}
			_tmp20_ = _tmp15_;
			if (_tmp20_) {
				const gchar* _tmp21_;
				_tmp21_ = self->priv->filename_buf;
				latex_post_processor_push_file_on_stack (self, _tmp21_, TRUE);
				self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
			} else {
				const gchar* _tmp22_;
				gchar _tmp23_ = '\0';
				_tmp22_ = line;
				_tmp23_ = string_get (_tmp22_, (glong) 0);
				if (_tmp23_ == '!') {
					const gchar* _tmp24_;
					self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
					_tmp24_ = line;
					latex_post_processor_detect_error (self, _tmp24_);
				} else {
					const gchar* _tmp25_;
					gboolean _tmp26_ = FALSE;
					_tmp25_ = line;
					_tmp26_ = g_str_has_prefix (_tmp25_, "No file");
					if (_tmp26_) {
						const gchar* _tmp27_;
						self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
						_tmp27_ = line;
						latex_post_processor_detect_warning (self, _tmp27_);
					} else {
						const gchar* _tmp28_;
						const gchar* _tmp29_;
						gchar* _tmp30_ = NULL;
						gchar* _tmp31_;
						gchar* _tmp32_;
						_tmp28_ = self->priv->filename_buf;
						_tmp29_ = line;
						_tmp30_ = string_strip (_tmp29_);
						_tmp31_ = _tmp30_;
						_tmp32_ = g_strconcat (_tmp28_, _tmp31_, NULL);
						_g_free0 (self->priv->filename_buf);
						self->priv->filename_buf = _tmp32_;
						_g_free0 (_tmp31_);
					}
				}
			}
			break;
		}
		default:
		{
			break;
		}
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static void latex_post_processor_update_stack_file_heuristic (LatexPostProcessor* self, const gchar* line) {
	LatexPostProcessorFilterStatus _tmp0_;
	gboolean expect_filename;
	gint index;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	glong length;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_;
	gboolean _tmp8_;
	gboolean _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	_tmp0_ = self->priv->status;
	expect_filename = _tmp0_ == LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME_HEURISTIC;
	index = 0;
	_tmp1_ = line;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	length = (glong) _tmp3_;
	_tmp6_ = expect_filename;
	if (_tmp6_) {
		glong _tmp7_;
		_tmp7_ = length;
		_tmp5_ = _tmp7_ > ((glong) 0);
	} else {
		_tmp5_ = FALSE;
	}
	_tmp8_ = _tmp5_;
	if (_tmp8_) {
		const gchar* _tmp9_;
		gchar _tmp10_ = '\0';
		_tmp9_ = line;
		_tmp10_ = string_get (_tmp9_, (glong) 0);
		_tmp4_ = _tmp10_ == ')';
	} else {
		_tmp4_ = FALSE;
	}
	_tmp11_ = _tmp4_;
	if (_tmp11_) {
		const gchar* _tmp12_;
		_tmp12_ = self->priv->filename_buf;
		latex_post_processor_push_file_on_stack (self, _tmp12_, FALSE);
		expect_filename = FALSE;
		self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp13_;
			_tmp13_ = TRUE;
			while (TRUE) {
				gboolean _tmp14_;
				gint _tmp16_;
				glong _tmp17_;
				gboolean is_last_char;
				gboolean next_is_terminator;
				gboolean _tmp18_;
				gboolean _tmp33_ = FALSE;
				gboolean _tmp34_;
				gboolean _tmp36_;
				_tmp14_ = _tmp13_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp16_ = i;
				_tmp17_ = length;
				if (!(((glong) _tmp16_) < _tmp17_)) {
					break;
				}
				is_last_char = FALSE;
				next_is_terminator = FALSE;
				_tmp18_ = expect_filename;
				if (_tmp18_) {
					gint _tmp19_;
					glong _tmp20_;
					gboolean _tmp21_ = FALSE;
					gboolean _tmp22_;
					gboolean _tmp32_;
					_tmp19_ = i;
					_tmp20_ = length;
					is_last_char = ((glong) (_tmp19_ + 1)) == _tmp20_;
					_tmp22_ = is_last_char;
					if (_tmp22_) {
						_tmp21_ = FALSE;
					} else {
						gboolean _tmp23_ = FALSE;
						const gchar* _tmp24_;
						gint _tmp25_;
						gchar _tmp26_ = '\0';
						gboolean _tmp27_ = FALSE;
						gboolean _tmp31_;
						_tmp24_ = line;
						_tmp25_ = i;
						_tmp26_ = string_get (_tmp24_, (glong) (_tmp25_ + 1));
						_tmp27_ = g_ascii_isspace (_tmp26_);
						if (_tmp27_) {
							_tmp23_ = TRUE;
						} else {
							const gchar* _tmp28_;
							gint _tmp29_;
							gchar _tmp30_ = '\0';
							_tmp28_ = line;
							_tmp29_ = i;
							_tmp30_ = string_get (_tmp28_, (glong) (_tmp29_ + 1));
							_tmp23_ = _tmp30_ == ')';
						}
						_tmp31_ = _tmp23_;
						_tmp21_ = _tmp31_;
					}
					_tmp32_ = _tmp21_;
					next_is_terminator = _tmp32_;
				}
				_tmp34_ = is_last_char;
				if (_tmp34_) {
					_tmp33_ = TRUE;
				} else {
					gboolean _tmp35_;
					_tmp35_ = next_is_terminator;
					_tmp33_ = _tmp35_;
				}
				_tmp36_ = _tmp33_;
				if (_tmp36_) {
					const gchar* _tmp37_;
					const gchar* _tmp38_;
					gint _tmp39_;
					gint _tmp40_;
					gchar* _tmp41_ = NULL;
					gchar* _tmp42_;
					gchar* _tmp43_;
					const gchar* _tmp44_;
					gint _tmp45_;
					gint _tmp46_;
					gboolean _tmp47_ = FALSE;
					gboolean _tmp48_ = FALSE;
					gboolean _tmp49_ = FALSE;
					gboolean _tmp50_;
					gboolean _tmp52_;
					gboolean _tmp54_;
					gboolean _tmp57_;
					_tmp37_ = self->priv->filename_buf;
					_tmp38_ = line;
					_tmp39_ = index;
					_tmp40_ = i;
					_tmp41_ = string_slice (_tmp38_, (glong) _tmp39_, (glong) (_tmp40_ + 1));
					_tmp42_ = _tmp41_;
					_tmp43_ = g_strconcat (_tmp37_, _tmp42_, NULL);
					_g_free0 (self->priv->filename_buf);
					self->priv->filename_buf = _tmp43_;
					_g_free0 (_tmp42_);
					_tmp44_ = self->priv->filename_buf;
					_tmp45_ = strlen (_tmp44_);
					_tmp46_ = _tmp45_;
					if (_tmp46_ == 0) {
						continue;
					}
					_tmp50_ = is_last_char;
					if (_tmp50_) {
						gint _tmp51_;
						_tmp51_ = i;
						_tmp49_ = _tmp51_ < 78;
					} else {
						_tmp49_ = FALSE;
					}
					_tmp52_ = _tmp49_;
					if (_tmp52_) {
						_tmp48_ = TRUE;
					} else {
						gboolean _tmp53_;
						_tmp53_ = next_is_terminator;
						_tmp48_ = _tmp53_;
					}
					_tmp54_ = _tmp48_;
					if (_tmp54_) {
						_tmp47_ = TRUE;
					} else {
						const gchar* _tmp55_;
						gboolean _tmp56_ = FALSE;
						_tmp55_ = self->priv->filename_buf;
						_tmp56_ = latex_post_processor_file_exists (self, _tmp55_);
						_tmp47_ = _tmp56_;
					}
					_tmp57_ = _tmp47_;
					if (_tmp57_) {
						const gchar* _tmp58_;
						_tmp58_ = self->priv->filename_buf;
						latex_post_processor_push_file_on_stack (self, _tmp58_, FALSE);
						expect_filename = FALSE;
						self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
					} else {
						gboolean _tmp59_;
						_tmp59_ = is_last_char;
						if (_tmp59_) {
							const gchar* _tmp60_;
							gboolean _tmp61_ = FALSE;
							_tmp60_ = self->priv->filename_buf;
							_tmp61_ = latex_post_processor_file_exists (self, _tmp60_);
							if (_tmp61_) {
								const gchar* _tmp62_;
								_tmp62_ = self->priv->filename_buf;
								latex_post_processor_push_file_on_stack (self, _tmp62_, FALSE);
								expect_filename = FALSE;
								self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
							} else {
								self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME_HEURISTIC;
							}
						} else {
							gchar* _tmp63_;
							self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
							_tmp63_ = g_strdup ("");
							_g_free0 (self->priv->filename_buf);
							self->priv->filename_buf = _tmp63_;
							expect_filename = FALSE;
						}
					}
				} else {
					const gchar* _tmp64_;
					gint _tmp65_;
					gchar _tmp66_ = '\0';
					_tmp64_ = line;
					_tmp65_ = i;
					_tmp66_ = string_get (_tmp64_, (glong) _tmp65_);
					if (_tmp66_ == '(') {
						gchar* _tmp67_;
						gint _tmp68_;
						self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
						_tmp67_ = g_strdup ("");
						_g_free0 (self->priv->filename_buf);
						self->priv->filename_buf = _tmp67_;
						expect_filename = TRUE;
						_tmp68_ = i;
						index = _tmp68_ + 1;
					} else {
						gboolean _tmp69_ = FALSE;
						gboolean _tmp70_ = FALSE;
						const gchar* _tmp71_;
						gint _tmp72_;
						gchar _tmp73_ = '\0';
						gboolean _tmp76_;
						gboolean _tmp78_;
						_tmp71_ = line;
						_tmp72_ = i;
						_tmp73_ = string_get (_tmp71_, (glong) _tmp72_);
						if (_tmp73_ == ')') {
							GSList* _tmp74_;
							guint _tmp75_ = 0U;
							_tmp74_ = self->priv->stack_files;
							_tmp75_ = g_slist_length (_tmp74_);
							_tmp70_ = _tmp75_ > ((guint) 0);
						} else {
							_tmp70_ = FALSE;
						}
						_tmp76_ = _tmp70_;
						if (_tmp76_) {
							gboolean _tmp77_ = FALSE;
							_tmp77_ = latex_post_processor_top_file_on_stack_is_reliable (self);
							_tmp69_ = !_tmp77_;
						} else {
							_tmp69_ = FALSE;
						}
						_tmp78_ = _tmp69_;
						if (_tmp78_) {
							latex_post_processor_pop_file_from_stack (self);
						}
					}
				}
			}
		}
	}
}


static gboolean latex_post_processor_file_exists (LatexPostProcessor* self, const gchar* filename) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (filename != NULL, FALSE);
	_tmp0_ = filename;
	_tmp1_ = latex_post_processor_get_path_if_file_exists (self, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_free0 (_tmp2_);
	result = _tmp3_;
	return result;
}


static gchar* latex_post_processor_get_path_if_file_exists (LatexPostProcessor* self, const gchar* filename) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gchar* full_path = NULL;
	const gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp16_;
	gboolean _tmp17_ = FALSE;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar** _tmp23_ = NULL;
	gchar** extensions;
	gint extensions_length1;
	gint _extensions_size_;
	gchar** _tmp24_;
	gint _tmp24__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp0_ = filename;
	_tmp1_ = g_path_is_absolute (_tmp0_);
	if (_tmp1_) {
		const gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = filename;
		_tmp3_ = g_file_test (_tmp2_, G_FILE_TEST_IS_REGULAR);
		if (_tmp3_) {
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = filename;
			_tmp5_ = g_strdup (_tmp4_);
			result = _tmp5_;
			return result;
		} else {
			result = NULL;
			return result;
		}
	}
	_tmp6_ = filename;
	_tmp7_ = g_str_has_prefix (_tmp6_, "./");
	if (_tmp7_) {
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		gchar* _tmp12_ = NULL;
		_tmp8_ = self->priv->directory_path;
		_tmp9_ = filename;
		_tmp10_ = string_substring (_tmp9_, (glong) 2, (glong) (-1));
		_tmp11_ = _tmp10_;
		_tmp12_ = g_build_filename (_tmp8_, _tmp11_, NULL, NULL);
		_g_free0 (full_path);
		full_path = _tmp12_;
		_g_free0 (_tmp11_);
	} else {
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_ = NULL;
		_tmp13_ = self->priv->directory_path;
		_tmp14_ = filename;
		_tmp15_ = g_build_filename (_tmp13_, _tmp14_, NULL, NULL);
		_g_free0 (full_path);
		full_path = _tmp15_;
	}
	_tmp16_ = full_path;
	_tmp17_ = g_file_test (_tmp16_, G_FILE_TEST_IS_REGULAR);
	if (_tmp17_) {
		result = full_path;
		return result;
	}
	_tmp18_ = g_strdup (".tex");
	_tmp19_ = g_strdup (".ltx");
	_tmp20_ = g_strdup (".latex");
	_tmp21_ = g_strdup (".dtx");
	_tmp22_ = g_strdup (".ins");
	_tmp23_ = g_new0 (gchar*, 5 + 1);
	_tmp23_[0] = _tmp18_;
	_tmp23_[1] = _tmp19_;
	_tmp23_[2] = _tmp20_;
	_tmp23_[3] = _tmp21_;
	_tmp23_[4] = _tmp22_;
	extensions = _tmp23_;
	extensions_length1 = 5;
	_extensions_size_ = extensions_length1;
	_tmp24_ = extensions;
	_tmp24__length1 = extensions_length1;
	{
		gchar** ext_collection = NULL;
		gint ext_collection_length1 = 0;
		gint _ext_collection_size_ = 0;
		gint ext_it = 0;
		ext_collection = _tmp24_;
		ext_collection_length1 = _tmp24__length1;
		for (ext_it = 0; ext_it < _tmp24__length1; ext_it = ext_it + 1) {
			gchar* _tmp25_;
			gchar* ext = NULL;
			_tmp25_ = g_strdup (ext_collection[ext_it]);
			ext = _tmp25_;
			{
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* path_with_ext;
				const gchar* _tmp29_;
				gboolean _tmp30_ = FALSE;
				_tmp26_ = full_path;
				_tmp27_ = ext;
				_tmp28_ = g_strconcat (_tmp26_, _tmp27_, NULL);
				path_with_ext = _tmp28_;
				_tmp29_ = path_with_ext;
				_tmp30_ = g_file_test (_tmp29_, G_FILE_TEST_IS_REGULAR);
				if (_tmp30_) {
					result = path_with_ext;
					_g_free0 (ext);
					extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (full_path);
					return result;
				}
				_g_free0 (path_with_ext);
				_g_free0 (ext);
			}
		}
	}
	result = NULL;
	extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (full_path);
	return result;
}


static gchar* latex_post_processor_get_current_filename (LatexPostProcessor* self) {
	gchar* result = NULL;
	GSList* _tmp0_;
	GSList* stack_file;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->stack_files;
	stack_file = _tmp0_;
	while (TRUE) {
		GSList* _tmp1_;
		GSList* _tmp2_;
		gconstpointer _tmp3_;
		LatexPostProcessorFileInStack _tmp4_ = {0};
		LatexPostProcessorFileInStack file;
		LatexPostProcessorFileInStack _tmp5_;
		gboolean _tmp6_;
		GSList* _tmp10_;
		GSList* _tmp11_;
		_tmp1_ = stack_file;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = stack_file;
		_tmp3_ = _tmp2_->data;
		latex_post_processor_file_in_stack_copy ((LatexPostProcessorFileInStack*) _tmp3_, &_tmp4_);
		file = _tmp4_;
		_tmp5_ = file;
		_tmp6_ = _tmp5_.exists;
		if (_tmp6_) {
			LatexPostProcessorFileInStack _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp7_ = file;
			_tmp8_ = _tmp7_.filename;
			_tmp9_ = g_strdup (_tmp8_);
			result = _tmp9_;
			latex_post_processor_file_in_stack_destroy (&file);
			return result;
		}
		_tmp10_ = stack_file;
		_tmp11_ = _tmp10_->next;
		stack_file = _tmp11_;
		latex_post_processor_file_in_stack_destroy (&file);
	}
	result = NULL;
	return result;
}


static gpointer _latex_post_processor_file_in_stack_dup0 (gpointer self) {
	return self ? latex_post_processor_file_in_stack_dup (self) : NULL;
}


static void latex_post_processor_push_file_on_stack (LatexPostProcessor* self, const gchar* filename, gboolean reliable) {
	LatexPostProcessorFileInStack file = {0};
	gboolean _tmp0_;
	gchar* clean_filename = NULL;
	gchar* _tmp1_;
	gchar* bad_suffix;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* path;
	const gchar* _tmp14_;
	LatexPostProcessorFileInStack _tmp19_;
	LatexPostProcessorFileInStack _tmp20_;
	LatexPostProcessorFileInStack* _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	memset (&file, 0, sizeof (LatexPostProcessorFileInStack));
	_tmp0_ = reliable;
	file.reliable = _tmp0_;
	_tmp1_ = g_strdup ("pdfTeX");
	bad_suffix = _tmp1_;
	_tmp2_ = filename;
	_tmp3_ = bad_suffix;
	_tmp4_ = g_str_has_suffix (_tmp2_, _tmp3_);
	if (_tmp4_) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gchar* _tmp9_ = NULL;
		_tmp5_ = filename;
		_tmp6_ = bad_suffix;
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = string_slice (_tmp5_, (glong) 0, (glong) (-_tmp8_));
		_g_free0 (clean_filename);
		clean_filename = _tmp9_;
	} else {
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = filename;
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (clean_filename);
		clean_filename = _tmp11_;
	}
	_tmp12_ = clean_filename;
	_tmp13_ = latex_post_processor_get_path_if_file_exists (self, _tmp12_);
	path = _tmp13_;
	_tmp14_ = path;
	if (_tmp14_ != NULL) {
		const gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp15_ = path;
		_tmp16_ = g_strdup (_tmp15_);
		_g_free0 (file.filename);
		file.filename = _tmp16_;
		file.exists = TRUE;
	} else {
		const gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp17_ = clean_filename;
		_tmp18_ = g_strdup (_tmp17_);
		_g_free0 (file.filename);
		file.filename = _tmp18_;
		file.exists = FALSE;
	}
	_tmp19_ = file;
	_tmp20_ = _tmp19_;
	_tmp21_ = _latex_post_processor_file_in_stack_dup0 (&_tmp20_);
	self->priv->stack_files = g_slist_prepend (self->priv->stack_files, _tmp21_);
	_g_free0 (path);
	_g_free0 (bad_suffix);
	_g_free0 (clean_filename);
	latex_post_processor_file_in_stack_destroy (&file);
}


static void latex_post_processor_pop_file_from_stack (LatexPostProcessor* self) {
	GSList* _tmp0_;
	GSList* _tmp1_;
	gconstpointer _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack_files;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->stack_files;
	_tmp2_ = _tmp1_->data;
	self->priv->stack_files = g_slist_remove (self->priv->stack_files, (LatexPostProcessorFileInStack*) _tmp2_);
}


static gboolean latex_post_processor_top_file_on_stack_is_reliable (LatexPostProcessor* self) {
	gboolean result = FALSE;
	GSList* _tmp0_;
	GSList* _tmp1_;
	gconstpointer _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->stack_files;
	g_return_val_if_fail (_tmp0_ != NULL, TRUE);
	_tmp1_ = self->priv->stack_files;
	_tmp2_ = _tmp1_->data;
	_tmp3_ = (*((LatexPostProcessorFileInStack*) _tmp2_)).reliable;
	result = _tmp3_;
	return result;
}


static void latex_post_processor_add_msg (LatexPostProcessor* self, gboolean set_filename) {
	gboolean _tmp0_ = FALSE;
	BuildMsg _tmp1_;
	BuildMsgType _tmp2_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	BuildMsg _tmp15_;
	BuildMsgType _tmp16_;
	BuildMsg _tmp20_;
	gint _tmp21_;
	BuildMsg _tmp22_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->msg;
	_tmp2_ = _tmp1_.type;
	if (_tmp2_ == BUILD_MSG_TYPE_WARNING) {
		BuildMsg _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = self->priv->msg;
		_tmp4_ = _tmp3_.text;
		_tmp0_ = g_strcmp0 (_tmp4_, "There were undefined references.") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		latex_post_processor_reset_msg (self);
		return;
	}
	_tmp6_ = set_filename;
	if (_tmp6_) {
		gchar* _tmp7_ = NULL;
		_tmp7_ = latex_post_processor_get_current_filename (self);
		_g_free0 (self->priv->msg.filename);
		self->priv->msg.filename = _tmp7_;
	}
	{
		GRegex* _tmp8_;
		BuildMsg _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		_tmp8_ = latex_post_processor_reg_spaces;
		_tmp9_ = self->priv->msg;
		_tmp10_ = _tmp9_.text;
		_tmp11_ = g_regex_replace (_tmp8_, _tmp10_, (gssize) (-1), 0, " ", 0, &_inner_error_);
		_tmp12_ = _tmp11_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch28_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (self->priv->msg.text);
		self->priv->msg.text = _tmp12_;
	}
	goto __finally28;
	__catch28_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("latex_post_processor.vala:809: Latex post processor: %s", _tmp14_);
		_g_error_free0 (e);
	}
	__finally28:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp15_ = self->priv->msg;
	_tmp16_ = _tmp15_.type;
	switch (_tmp16_) {
		case BUILD_MSG_TYPE_BADBOX:
		{
			gint _tmp17_;
			_tmp17_ = self->priv->nb_badboxes;
			self->priv->nb_badboxes = _tmp17_ + 1;
			break;
		}
		case BUILD_MSG_TYPE_WARNING:
		{
			gint _tmp18_;
			_tmp18_ = self->priv->nb_warnings;
			self->priv->nb_warnings = _tmp18_ + 1;
			break;
		}
		case BUILD_MSG_TYPE_ERROR:
		{
			gint _tmp19_;
			_tmp19_ = self->priv->nb_errors;
			self->priv->nb_errors = _tmp19_ + 1;
			break;
		}
		default:
		break;
	}
	_tmp20_ = self->priv->msg;
	_tmp21_ = _tmp20_.start_line;
	if (_tmp21_ != LATEX_POST_PROCESSOR_NO_LINE) {
		self->priv->msg.lines_set = TRUE;
	}
	_tmp22_ = self->priv->msg;
	post_processor_append_message ((PostProcessor*) self, &_tmp22_);
	latex_post_processor_reset_msg (self);
}


static void latex_post_processor_reset_msg (LatexPostProcessor* self) {
	g_return_if_fail (self != NULL);
	build_msg_destroy (&self->priv->msg);
	memset (&self->priv->msg, 0, sizeof (BuildMsg));
	_g_free0 (self->priv->msg.text);
	self->priv->msg.text = NULL;
	self->priv->msg.type = BUILD_MSG_TYPE_OTHER;
	_g_free0 (self->priv->msg.filename);
	self->priv->msg.filename = NULL;
	self->priv->msg.start_line = LATEX_POST_PROCESSOR_NO_LINE;
	self->priv->msg.end_line = LATEX_POST_PROCESSOR_NO_LINE;
	self->priv->msg.lines_set = FALSE;
}


static void latex_post_processor_file_in_stack_copy (const LatexPostProcessorFileInStack* self, LatexPostProcessorFileInStack* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	_tmp0_ = (*self).filename;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).filename);
	(*dest).filename = _tmp1_;
	_tmp2_ = (*self).reliable;
	(*dest).reliable = _tmp2_;
	_tmp3_ = (*self).exists;
	(*dest).exists = _tmp3_;
}


static void latex_post_processor_file_in_stack_destroy (LatexPostProcessorFileInStack* self) {
	_g_free0 ((*self).filename);
}


static LatexPostProcessorFileInStack* latex_post_processor_file_in_stack_dup (const LatexPostProcessorFileInStack* self) {
	LatexPostProcessorFileInStack* dup;
	dup = g_new0 (LatexPostProcessorFileInStack, 1);
	latex_post_processor_file_in_stack_copy (self, dup);
	return dup;
}


static void latex_post_processor_file_in_stack_free (LatexPostProcessorFileInStack* self) {
	latex_post_processor_file_in_stack_destroy (self);
	g_free (self);
}


static GType latex_post_processor_file_in_stack_get_type (void) {
	static volatile gsize latex_post_processor_file_in_stack_type_id__volatile = 0;
	if (g_once_init_enter (&latex_post_processor_file_in_stack_type_id__volatile)) {
		GType latex_post_processor_file_in_stack_type_id;
		latex_post_processor_file_in_stack_type_id = g_boxed_type_register_static ("LatexPostProcessorFileInStack", (GBoxedCopyFunc) latex_post_processor_file_in_stack_dup, (GBoxedFreeFunc) latex_post_processor_file_in_stack_free);
		g_once_init_leave (&latex_post_processor_file_in_stack_type_id__volatile, latex_post_processor_file_in_stack_type_id);
	}
	return latex_post_processor_file_in_stack_type_id__volatile;
}


static void latex_post_processor_class_init (LatexPostProcessorClass * klass) {
	latex_post_processor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (LatexPostProcessorPrivate));
	POST_PROCESSOR_CLASS (klass)->process = latex_post_processor_real_process;
	G_OBJECT_CLASS (klass)->finalize = latex_post_processor_finalize;
}


static void latex_post_processor_instance_init (LatexPostProcessor * self) {
	self->priv = LATEX_POST_PROCESSOR_GET_PRIVATE (self);
	self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
	self->priv->nb_lines = 0;
	self->priv->stack_files = NULL;
	self->priv->directory_path = NULL;
	self->priv->nb_badboxes = 0;
	self->priv->nb_warnings = 0;
	self->priv->nb_errors = 0;
}


static void latex_post_processor_finalize (GObject* obj) {
	LatexPostProcessor * self;
	self = LATEX_POST_PROCESSOR (obj);
	build_msg_destroy (&self->priv->msg);
	_g_free0 (self->priv->line_buf);
	_g_free0 (self->priv->filename_buf);
	__g_slist_free__latex_post_processor_file_in_stack_free0_0 (self->priv->stack_files);
	_g_free0 (self->priv->directory_path);
	G_OBJECT_CLASS (latex_post_processor_parent_class)->finalize (obj);
}


GType latex_post_processor_get_type (void) {
	static volatile gsize latex_post_processor_type_id__volatile = 0;
	if (g_once_init_enter (&latex_post_processor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LatexPostProcessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) latex_post_processor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LatexPostProcessor), 0, (GInstanceInitFunc) latex_post_processor_instance_init, NULL };
		GType latex_post_processor_type_id;
		latex_post_processor_type_id = g_type_register_static (TYPE_POST_PROCESSOR, "LatexPostProcessor", &g_define_type_info, 0);
		g_once_init_leave (&latex_post_processor_type_id__volatile, latex_post_processor_type_id);
	}
	return latex_post_processor_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



