/* latexila.c generated by valac 0.15.1, the Vala compiler
 * generated from latexila.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <gtksourceview/gtksourceview.h>
#include <unique/unique.h>


#define TYPE_LATEXILA (latexila_get_type ())
#define LATEXILA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEXILA, Latexila))
#define LATEXILA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEXILA, LatexilaClass))
#define IS_LATEXILA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEXILA))
#define IS_LATEXILA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEXILA))
#define LATEXILA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEXILA, LatexilaClass))

typedef struct _Latexila Latexila;
typedef struct _LatexilaClass LatexilaClass;
typedef struct _LatexilaPrivate LatexilaPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define LATEXILA_TYPE_STOCK_ICON (latexila_stock_icon_get_type ())
typedef struct _LatexilaStockIcon LatexilaStockIcon;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_APP_SETTINGS (app_settings_get_type ())
#define APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_SETTINGS, AppSettings))
#define APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_SETTINGS, AppSettingsClass))
#define IS_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_SETTINGS))
#define IS_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_SETTINGS))
#define APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_SETTINGS, AppSettingsClass))

typedef struct _AppSettings AppSettings;
typedef struct _AppSettingsClass AppSettingsClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;
typedef struct _Block5Data Block5Data;

#define TYPE_PROJECTS (projects_get_type ())
#define PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECTS, Projects))
#define PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECTS, ProjectsClass))
#define IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECTS))
#define IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECTS))
#define PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECTS, ProjectsClass))

typedef struct _Projects Projects;
typedef struct _ProjectsClass ProjectsClass;
#define _projects_unref0(var) ((var == NULL) ? NULL : (var = (projects_unref (var), NULL)))

#define TYPE_BUILD_TOOLS (build_tools_get_type ())
#define BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOLS, BuildTools))
#define BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOLS, BuildToolsClass))
#define IS_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOLS))
#define IS_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOLS))
#define BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOLS, BuildToolsClass))

typedef struct _BuildTools BuildTools;
typedef struct _BuildToolsClass BuildToolsClass;
#define _build_tools_unref0(var) ((var == NULL) ? NULL : (var = (build_tools_unref (var), NULL)))

#define TYPE_MOST_USED_SYMBOLS (most_used_symbols_get_type ())
#define MOST_USED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOST_USED_SYMBOLS, MostUsedSymbols))
#define MOST_USED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsClass))
#define IS_MOST_USED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOST_USED_SYMBOLS))
#define IS_MOST_USED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOST_USED_SYMBOLS))
#define MOST_USED_SYMBOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsClass))

typedef struct _MostUsedSymbols MostUsedSymbols;
typedef struct _MostUsedSymbolsClass MostUsedSymbolsClass;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
#define _gtk_icon_source_free0(var) ((var == NULL) ? NULL : (var = (gtk_icon_source_free (var), NULL)))
#define _gtk_icon_set_unref0(var) ((var == NULL) ? NULL : (var = (gtk_icon_set_unref (var), NULL)))

struct _Latexila {
	GObject parent_instance;
	LatexilaPrivate * priv;
};

struct _LatexilaClass {
	GObjectClass parent_class;
};

struct _LatexilaPrivate {
	GList* _windows;
	MainWindow* _active_window;
};

struct _LatexilaStockIcon {
	gchar* filename;
	gchar* stock_id;
};

struct _Block5Data {
	int _ref_count_;
	Latexila * self;
	MainWindow* window;
};


static gpointer latexila_parent_class = NULL;
extern gint latexila_NEW_WINDOW;
gint latexila_NEW_WINDOW = 1;
static Latexila* latexila_instance;
static Latexila* latexila_instance = NULL;

GType latexila_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
#define LATEXILA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LATEXILA, LatexilaPrivate))
enum  {
	LATEXILA_DUMMY_PROPERTY,
	LATEXILA_WINDOWS,
	LATEXILA_ACTIVE_WINDOW
};
static GType latexila_stock_icon_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static LatexilaStockIcon* latexila_stock_icon_dup (const LatexilaStockIcon* self);
static void latexila_stock_icon_free (LatexilaStockIcon* self);
static void latexila_stock_icon_copy (const LatexilaStockIcon* self, LatexilaStockIcon* dest);
static void latexila_stock_icon_destroy (LatexilaStockIcon* self);
static Latexila* latexila_new (void);
static Latexila* latexila_construct (GType object_type);
static void latexila_set_windows (Latexila* self, GList* value);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void latexila_register_my_stock_icons (Latexila* self);
static void latexila_add_theme_icon_to_stock (Latexila* self, const gchar* icon_name, const gchar* stock_id);
GType app_settings_get_type (void) G_GNUC_CONST;
AppSettings* app_settings_get_default (void);
MainWindow* latexila_create_window (Latexila* self, GdkScreen* screen);
Latexila* latexila_get_default (void);
GType document_get_type (void) G_GNUC_CONST;
GList* latexila_get_documents (Latexila* self);
GList* latexila_get_windows (Latexila* self);
GList* main_window_get_documents (MainWindow* self);
GType document_view_get_type (void) G_GNUC_CONST;
GList* latexila_get_views (Latexila* self);
GList* main_window_get_views (MainWindow* self);
UniqueResponse latexila_message (Latexila* self, UniqueApp* sender, gint command, UniqueMessageData* data, guint time);
MainWindow* latexila_get_active_window (Latexila* self);
gboolean main_window_is_on_workspace_screen (MainWindow* self, GdkScreen* screen, guint workspace);
static void latexila_set_active_window (Latexila* self, MainWindow* value);
void latexila_create_document (Latexila* self);
void latexila_open_documents (Latexila* self, gchar** uris);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
void main_window_save_state (MainWindow* self, gboolean sync);
MainWindow* main_window_new (void);
MainWindow* main_window_construct (GType object_type);
static void __lambda23_ (Block5Data* _data5_);
gpointer projects_ref (gpointer instance);
void projects_unref (gpointer instance);
GParamSpec* param_spec_projects (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_projects (GValue* value, gpointer v_object);
void value_take_projects (GValue* value, gpointer v_object);
gpointer value_get_projects (const GValue* value);
GType projects_get_type (void) G_GNUC_CONST;
Projects* projects_get_default (void);
void projects_save (Projects* self);
gpointer build_tools_ref (gpointer instance);
void build_tools_unref (gpointer instance);
GParamSpec* param_spec_build_tools (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_build_tools (GValue* value, gpointer v_object);
void value_take_build_tools (GValue* value, gpointer v_object);
gpointer value_get_build_tools (const GValue* value);
GType build_tools_get_type (void) G_GNUC_CONST;
BuildTools* build_tools_get_default (void);
void build_tools_save (BuildTools* self);
GType most_used_symbols_get_type (void) G_GNUC_CONST;
MostUsedSymbols* most_used_symbols_get_default (void);
void most_used_symbols_save (MostUsedSymbols* self);
static void ___lambda23__gtk_object_destroy (GtkObject* _sender, gpointer self);
static gboolean __lambda50_ (Block5Data* _data5_);
static gboolean ___lambda50__gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentTab* main_window_create_tab (MainWindow* self, gboolean jump_to);
DocumentTab* main_window_open_document (MainWindow* self, GFile* location, gboolean jump_to);
static void latexila_finalize (GObject* obj);
static void _vala_latexila_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_latexila_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const LatexilaStockIcon LATEXILA_stock_icons[82] = {{DATA_DIR "/images/icons/compile_dvi.png", "compile_dvi"}, {DATA_DIR "/images/icons/compile_pdf.png", "compile_pdf"}, {DATA_DIR "/images/icons/compile_ps.png", "compile_ps"}, {DATA_DIR "/images/icons/view_dvi.png", "view_dvi"}, {DATA_DIR "/images/icons/view_pdf.png", "view_pdf"}, {DATA_DIR "/images/icons/view_ps.png", "view_ps"}, {DATA_DIR "/images/icons/textbf.png", "bold"}, {DATA_DIR "/images/icons/textit.png", "italic"}, {DATA_DIR "/images/icons/texttt.png", "typewriter"}, {DATA_DIR "/images/icons/textsl.png", "slanted"}, {DATA_DIR "/images/icons/textsc.png", "small_caps"}, {DATA_DIR "/images/icons/textsf.png", "sans_serif"}, {DATA_DIR "/images/icons/roman.png", "roman"}, {DATA_DIR "/images/icons/underline.png", "underline"}, {DATA_DIR "/images/misc-math/set-R.png", "blackboard"}, {DATA_DIR "/images/icons/sectioning-part.png", "sectioning-part"}, {DATA_DIR "/images/icons/sectioning-chapter.png", "sectioning-chapter"}, {DATA_DIR "/images/icons/sectioning-section.png", "sectioning-section"}, {DATA_DIR "/images/icons/sectioning-subsection.png", "sectioning-subsection"}, {DATA_DIR "/images/icons/sectioning-subsubsection.png", "sectioning-subsubsection"}, {DATA_DIR "/images/icons/sectioning-paragraph.png", "sectioning-paragraph"}, {DATA_DIR "/images/icons/character-size.png", "character-size"}, {DATA_DIR "/images/icons/list-itemize.png", "list-itemize"}, {DATA_DIR "/images/icons/list-enumerate.png", "list-enumerate"}, {DATA_DIR "/images/icons/list-description.png", "list-description"}, {DATA_DIR "/images/icons/list-item.png", "list-item"}, {DATA_DIR "/images/icons/references.png", "references"}, {DATA_DIR "/images/icons/math.png", "math"}, {DATA_DIR "/images/icons/math-centered.png", "math-centered"}, {DATA_DIR "/images/icons/math-numbered.png", "math-numbered"}, {DATA_DIR "/images/icons/math-array.png", "math-array"}, {DATA_DIR "/images/icons/math-numbered-array.png", "math-numbered-array"}, {DATA_DIR "/images/icons/math-superscript.png", "math-superscript"}, {DATA_DIR "/images/icons/math-subscript.png", "math-subscript"}, {DATA_DIR "/images/icons/math-frac.png", "math-frac"}, {DATA_DIR "/images/icons/math-square-root.png", "math-square-root"}, {DATA_DIR "/images/icons/math-nth-root.png", "math-nth-root"}, {DATA_DIR "/images/icons/mathcal.png", "mathcal"}, {DATA_DIR "/images/icons/mathfrak.png", "mathfrak"}, {DATA_DIR "/images/icons/delimiters-left.png", "delimiters-left"}, {DATA_DIR "/images/icons/delimiters-right.png", "delimiters-right"}, {DATA_DIR "/images/icons/badbox.png", "badbox"}, {DATA_DIR "/images/icons/logviewer.png", "view_log"}, {DATA_DIR "/images/greek/01.png", "symbol_alpha"}, {DATA_DIR "/images/icons/accent0.png", "accent0"}, {DATA_DIR "/images/icons/accent1.png", "accent1"}, {DATA_DIR "/images/icons/accent2.png", "accent2"}, {DATA_DIR "/images/icons/accent3.png", "accent3"}, {DATA_DIR "/images/icons/accent4.png", "accent4"}, {DATA_DIR "/images/icons/accent5.png", "accent5"}, {DATA_DIR "/images/icons/accent6.png", "accent6"}, {DATA_DIR "/images/icons/accent7.png", "accent7"}, {DATA_DIR "/images/icons/accent8.png", "accent8"}, {DATA_DIR "/images/icons/accent9.png", "accent9"}, {DATA_DIR "/images/icons/accent10.png", "accent10"}, {DATA_DIR "/images/icons/accent11.png", "accent11"}, {DATA_DIR "/images/icons/accent12.png", "accent12"}, {DATA_DIR "/images/icons/accent13.png", "accent13"}, {DATA_DIR "/images/icons/accent14.png", "accent14"}, {DATA_DIR "/images/icons/accent15.png", "accent15"}, {DATA_DIR "/images/icons/mathaccent0.png", "mathaccent0"}, {DATA_DIR "/images/icons/mathaccent1.png", "mathaccent1"}, {DATA_DIR "/images/icons/mathaccent2.png", "mathaccent2"}, {DATA_DIR "/images/icons/mathaccent3.png", "mathaccent3"}, {DATA_DIR "/images/icons/mathaccent4.png", "mathaccent4"}, {DATA_DIR "/images/icons/mathaccent5.png", "mathaccent5"}, {DATA_DIR "/images/icons/mathaccent6.png", "mathaccent6"}, {DATA_DIR "/images/icons/mathaccent7.png", "mathaccent7"}, {DATA_DIR "/images/icons/mathaccent8.png", "mathaccent8"}, {DATA_DIR "/images/icons/mathaccent9.png", "mathaccent9"}, {DATA_DIR "/images/icons/mathaccent10.png", "mathaccent10"}, {DATA_DIR "/images/icons/completion_choice.png", "completion_choice"}, {DATA_DIR "/images/icons/completion_cmd.png", "completion_cmd"}, {DATA_DIR "/images/icons/tree_part.png", "tree_part"}, {DATA_DIR "/images/icons/tree_chapter.png", "tree_chapter"}, {DATA_DIR "/images/icons/tree_section.png", "tree_section"}, {DATA_DIR "/images/icons/tree_subsection.png", "tree_subsection"}, {DATA_DIR "/images/icons/tree_subsubsection.png", "tree_subsubsection"}, {DATA_DIR "/images/icons/tree_paragraph.png", "tree_paragraph"}, {DATA_DIR "/images/icons/tree_todo.png", "tree_todo"}, {DATA_DIR "/images/icons/tree_label.png", "tree_label"}, {DATA_DIR "/images/icons/table.png", "table"}};

static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static Latexila* latexila_construct (GType object_type) {
	Latexila * self = NULL;
	GList* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_ = NULL;
	gchar** filenames;
	gint filenames_length1;
	gint _filenames_size_;
	GList* list;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GList* _tmp14_;
	AppSettings* _tmp15_ = NULL;
	AppSettings* _tmp16_;
	MainWindow* _tmp17_ = NULL;
	MainWindow* _tmp18_;
	GError * _inner_error_ = NULL;
	self = (Latexila*) g_object_new (object_type, NULL);
	_tmp0_ = NULL;
	latexila_set_windows (self, _tmp0_);
	__g_list_free__g_object_unref0_0 (_tmp0_);
	gtk_rc_parse_string ("\n" \
"            style \"my-button-style\"\n" \
"            {\n" \
"                GtkWidget::focus-padding = 0\n" \
"                GtkWidget::focus-line-width = 0\n" \
"                xthickness = 0\n" \
"                ythickness = 0\n" \
"            }\n" \
"            widget \"*.my-close-button\" style \"my-button-style\"\n" \
"        ");
	_tmp1_ = g_strdup (ICONS_DIR "/16x16/apps/latexila.png");
	_tmp2_ = g_strdup (ICONS_DIR "/22x22/apps/latexila.png");
	_tmp3_ = g_strdup (ICONS_DIR "/24x24/apps/latexila.png");
	_tmp4_ = g_strdup (ICONS_DIR "/32x32/apps/latexila.png");
	_tmp5_ = g_strdup (ICONS_DIR "/48x48/apps/latexila.png");
	_tmp6_ = g_new0 (gchar*, 5 + 1);
	_tmp6_[0] = _tmp1_;
	_tmp6_[1] = _tmp2_;
	_tmp6_[2] = _tmp3_;
	_tmp6_[3] = _tmp4_;
	_tmp6_[4] = _tmp5_;
	filenames = _tmp6_;
	filenames_length1 = 5;
	_filenames_size_ = filenames_length1;
	list = NULL;
	_tmp7_ = filenames;
	_tmp7__length1 = filenames_length1;
	{
		gchar** filename_collection = NULL;
		gint filename_collection_length1 = 0;
		gint _filename_collection_size_ = 0;
		gint filename_it = 0;
		filename_collection = _tmp7_;
		filename_collection_length1 = _tmp7__length1;
		for (filename_it = 0; filename_it < _tmp7__length1; filename_it = filename_it + 1) {
			gchar* _tmp8_;
			gchar* filename = NULL;
			_tmp8_ = g_strdup (filename_collection[filename_it]);
			filename = _tmp8_;
			{
				{
					const gchar* _tmp9_;
					GdkPixbuf* _tmp10_;
					GdkPixbuf* _tmp11_;
					_tmp9_ = filename;
					_tmp10_ = gdk_pixbuf_new_from_file (_tmp9_, &_inner_error_);
					_tmp11_ = _tmp10_;
					if (_inner_error_ != NULL) {
						goto __catch16_g_error;
					}
					list = g_list_append (list, _tmp11_);
				}
				goto __finally16;
				__catch16_g_error:
				{
					GError* e = NULL;
					GError* _tmp12_;
					const gchar* _tmp13_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp12_ = e;
					_tmp13_ = _tmp12_->message;
					g_warning ("latexila.vala:165: Error with an icon: %s", _tmp13_);
					_g_error_free0 (e);
				}
				__finally16:
				if (_inner_error_ != NULL) {
					_g_free0 (filename);
					__g_list_free__g_object_unref0_0 (list);
					filenames = (_vala_array_free (filenames, filenames_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_g_free0 (filename);
			}
		}
	}
	_tmp14_ = list;
	gtk_window_set_default_icon_list (_tmp14_);
	latexila_register_my_stock_icons (self);
	latexila_add_theme_icon_to_stock (self, "image-x-generic", "image");
	latexila_add_theme_icon_to_stock (self, "x-office-presentation", "presentation");
	_tmp15_ = app_settings_get_default ();
	_tmp16_ = _tmp15_;
	_g_object_unref0 (_tmp16_);
	_tmp17_ = latexila_create_window (self, NULL);
	_tmp18_ = _tmp17_;
	_g_object_unref0 (_tmp18_);
	__g_list_free__g_object_unref0_0 (list);
	filenames = (_vala_array_free (filenames, filenames_length1, (GDestroyNotify) g_free), NULL);
	return self;
}


static Latexila* latexila_new (void) {
	return latexila_construct (TYPE_LATEXILA);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


Latexila* latexila_get_default (void) {
	Latexila* result = NULL;
	Latexila* _tmp0_;
	Latexila* _tmp2_;
	Latexila* _tmp3_;
	_tmp0_ = latexila_instance;
	if (_tmp0_ == NULL) {
		Latexila* _tmp1_;
		_tmp1_ = latexila_new ();
		_g_object_unref0 (latexila_instance);
		latexila_instance = _tmp1_;
	}
	_tmp2_ = latexila_instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


GList* latexila_get_documents (Latexila* self) {
	GList* result = NULL;
	GList* res;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	res = NULL;
	_tmp0_ = self->priv->_windows;
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp0_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			MainWindow* _tmp1_;
			MainWindow* w = NULL;
			_tmp1_ = _g_object_ref0 ((MainWindow*) w_it->data);
			w = _tmp1_;
			{
				MainWindow* _tmp2_;
				GList* _tmp3_ = NULL;
				_tmp2_ = w;
				_tmp3_ = main_window_get_documents (_tmp2_);
				res = g_list_concat (res, _tmp3_);
				_g_object_unref0 (w);
			}
		}
	}
	result = res;
	return result;
}


GList* latexila_get_views (Latexila* self) {
	GList* result = NULL;
	GList* res;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	res = NULL;
	_tmp0_ = self->priv->_windows;
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp0_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			MainWindow* _tmp1_;
			MainWindow* w = NULL;
			_tmp1_ = _g_object_ref0 ((MainWindow*) w_it->data);
			w = _tmp1_;
			{
				MainWindow* _tmp2_;
				GList* _tmp3_ = NULL;
				_tmp2_ = w;
				_tmp3_ = main_window_get_views (_tmp2_);
				res = g_list_concat (res, _tmp3_);
				_g_object_unref0 (w);
			}
		}
	}
	result = res;
	return result;
}


UniqueResponse latexila_message (Latexila* self, UniqueApp* sender, gint command, UniqueMessageData* data, guint time) {
	UniqueResponse result = 0;
	gint _tmp0_;
	gint _tmp1_;
	UniqueMessageData* _tmp4_;
	guint _tmp5_ = 0U;
	guint workspace;
	UniqueMessageData* _tmp6_;
	GdkScreen* _tmp7_ = NULL;
	GdkScreen* _tmp8_;
	GdkScreen* screen;
	MainWindow* _tmp9_;
	GdkScreen* _tmp10_;
	guint _tmp11_;
	gboolean _tmp12_ = FALSE;
	gint _tmp26_;
	MainWindow* _tmp31_;
	guint _tmp32_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sender != NULL, 0);
	g_return_val_if_fail (data != NULL, 0);
	_tmp0_ = command;
	_tmp1_ = latexila_NEW_WINDOW;
	if (_tmp0_ == _tmp1_) {
		MainWindow* _tmp2_ = NULL;
		MainWindow* _tmp3_;
		_tmp2_ = latexila_create_window (self, NULL);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp3_);
		result = UNIQUE_RESPONSE_OK;
		return result;
	}
	_tmp4_ = data;
	_tmp5_ = unique_message_data_get_workspace (_tmp4_);
	workspace = _tmp5_;
	_tmp6_ = data;
	_tmp7_ = unique_message_data_get_screen (_tmp6_);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	screen = _tmp8_;
	_tmp9_ = self->priv->_active_window;
	_tmp10_ = screen;
	_tmp11_ = workspace;
	_tmp12_ = main_window_is_on_workspace_screen (_tmp9_, _tmp10_, _tmp11_);
	if (!_tmp12_) {
		gboolean found;
		GList* _tmp13_;
		gboolean _tmp22_;
		found = FALSE;
		_tmp13_ = self->priv->_windows;
		{
			GList* w_collection = NULL;
			GList* w_it = NULL;
			w_collection = _tmp13_;
			for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
				MainWindow* _tmp14_;
				MainWindow* w = NULL;
				_tmp14_ = _g_object_ref0 ((MainWindow*) w_it->data);
				w = _tmp14_;
				{
					MainWindow* _tmp15_;
					MainWindow* _tmp16_;
					MainWindow* _tmp17_;
					GdkScreen* _tmp18_;
					guint _tmp19_;
					gboolean _tmp20_ = FALSE;
					_tmp15_ = w;
					_tmp16_ = self->priv->_active_window;
					if (_tmp15_ == _tmp16_) {
						_g_object_unref0 (w);
						continue;
					}
					_tmp17_ = w;
					_tmp18_ = screen;
					_tmp19_ = workspace;
					_tmp20_ = main_window_is_on_workspace_screen (_tmp17_, _tmp18_, _tmp19_);
					if (_tmp20_) {
						MainWindow* _tmp21_;
						found = TRUE;
						_tmp21_ = w;
						latexila_set_active_window (self, _tmp21_);
						_g_object_unref0 (w);
						break;
					}
					_g_object_unref0 (w);
				}
			}
		}
		_tmp22_ = found;
		if (!_tmp22_) {
			GdkScreen* _tmp23_;
			MainWindow* _tmp24_ = NULL;
			MainWindow* _tmp25_;
			_tmp23_ = screen;
			_tmp24_ = latexila_create_window (self, _tmp23_);
			_tmp25_ = _tmp24_;
			_g_object_unref0 (_tmp25_);
		}
	}
	_tmp26_ = command;
	if (_tmp26_ == ((gint) UNIQUE_NEW)) {
		latexila_create_document (self);
	} else {
		gint _tmp27_;
		_tmp27_ = command;
		if (_tmp27_ == ((gint) UNIQUE_OPEN)) {
			UniqueMessageData* _tmp28_;
			gchar** _tmp29_ = NULL;
			gchar** _tmp30_;
			gint _tmp30__length1;
			_tmp28_ = data;
			_tmp29_ = unique_message_data_get_uris (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp30__length1 = -1;
			latexila_open_documents (self, _tmp30_);
			_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
		}
	}
	_tmp31_ = self->priv->_active_window;
	_tmp32_ = time;
	gtk_window_present_with_time ((GtkWindow*) _tmp31_, (guint32) _tmp32_);
	result = UNIQUE_RESPONSE_OK;
	_g_object_unref0 (screen);
	return result;
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		Latexila * self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->window);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static void __lambda23_ (Block5Data* _data5_) {
	Latexila * self;
	GList* _tmp0_;
	MainWindow* _tmp1_;
	GList* _tmp2_;
	guint _tmp3_ = 0U;
	self = _data5_->self;
	_tmp0_ = self->priv->_windows;
	_tmp1_ = _data5_->window;
	latexila_set_windows (self, g_list_remove (_tmp0_, _tmp1_));
	_tmp2_ = self->priv->_windows;
	_tmp3_ = g_list_length (_tmp2_);
	if (_tmp3_ == ((guint) 0)) {
		Projects* _tmp4_ = NULL;
		Projects* _tmp5_;
		BuildTools* _tmp6_ = NULL;
		BuildTools* _tmp7_;
		MostUsedSymbols* _tmp8_ = NULL;
		MostUsedSymbols* _tmp9_;
		_tmp4_ = projects_get_default ();
		_tmp5_ = _tmp4_;
		projects_save (_tmp5_);
		_projects_unref0 (_tmp5_);
		_tmp6_ = build_tools_get_default ();
		_tmp7_ = _tmp6_;
		build_tools_save (_tmp7_);
		_build_tools_unref0 (_tmp7_);
		_tmp8_ = most_used_symbols_get_default ();
		_tmp9_ = _tmp8_;
		most_used_symbols_save (_tmp9_);
		_g_object_unref0 (_tmp9_);
		gtk_main_quit ();
	} else {
		MainWindow* _tmp10_;
		MainWindow* _tmp11_;
		_tmp10_ = _data5_->window;
		_tmp11_ = self->priv->_active_window;
		if (_tmp10_ == _tmp11_) {
			GList* _tmp12_;
			gconstpointer _tmp13_;
			_tmp12_ = self->priv->_windows;
			_tmp13_ = _tmp12_->data;
			latexila_set_active_window (self, MAIN_WINDOW ((MainWindow*) _tmp13_));
			g_object_notify ((GObject*) self, "active-window");
		}
	}
}


static void ___lambda23__gtk_object_destroy (GtkObject* _sender, gpointer self) {
	__lambda23_ (self);
}


static gboolean __lambda50_ (Block5Data* _data5_) {
	Latexila * self;
	gboolean result = FALSE;
	MainWindow* _tmp0_;
	self = _data5_->self;
	_tmp0_ = _data5_->window;
	latexila_set_active_window (self, _tmp0_);
	g_object_notify ((GObject*) self, "active-window");
	result = FALSE;
	return result;
}


static gboolean ___lambda50__gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = __lambda50_ (self);
	return result;
}


MainWindow* latexila_create_window (Latexila* self, GdkScreen* screen) {
	MainWindow* result = NULL;
	Block5Data* _data5_;
	MainWindow* _tmp0_;
	MainWindow* _tmp2_;
	MainWindow* _tmp3_;
	MainWindow* _tmp4_;
	GdkScreen* _tmp5_;
	MainWindow* _tmp8_;
	MainWindow* _tmp9_;
	GList* _tmp10_;
	MainWindow* _tmp11_;
	MainWindow* _tmp12_;
	MainWindow* _tmp13_;
	MainWindow* _tmp14_;
	MainWindow* _tmp15_;
	g_return_val_if_fail (self != NULL, NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = self->priv->_active_window;
	if (_tmp0_ != NULL) {
		MainWindow* _tmp1_;
		_tmp1_ = self->priv->_active_window;
		main_window_save_state (_tmp1_, TRUE);
	}
	_tmp2_ = main_window_new ();
	_tmp3_ = g_object_ref_sink (_tmp2_);
	_data5_->window = _tmp3_;
	_tmp4_ = _data5_->window;
	latexila_set_active_window (self, _tmp4_);
	g_object_notify ((GObject*) self, "active-window");
	_tmp5_ = screen;
	if (_tmp5_ != NULL) {
		MainWindow* _tmp6_;
		GdkScreen* _tmp7_;
		_tmp6_ = _data5_->window;
		_tmp7_ = screen;
		gtk_window_set_screen ((GtkWindow*) _tmp6_, _tmp7_);
	}
	_tmp8_ = _data5_->window;
	g_signal_connect_data ((GtkObject*) _tmp8_, "destroy", (GCallback) ___lambda23__gtk_object_destroy, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_tmp9_ = _data5_->window;
	g_signal_connect_data ((GtkWidget*) _tmp9_, "focus-in-event", (GCallback) ___lambda50__gtk_widget_focus_in_event, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_tmp10_ = self->priv->_windows;
	_tmp11_ = _data5_->window;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	latexila_set_windows (self, g_list_append (_tmp10_, _tmp12_));
	_tmp13_ = _data5_->window;
	gtk_widget_show ((GtkWidget*) _tmp13_);
	_tmp14_ = _data5_->window;
	_tmp15_ = _g_object_ref0 (_tmp14_);
	result = _tmp15_;
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return result;
}


void latexila_create_document (Latexila* self) {
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_ = NULL;
	DocumentTab* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_active_window;
	_tmp1_ = main_window_create_tab (_tmp0_, TRUE);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
}


void latexila_open_documents (Latexila* self, gchar** uris) {
	gboolean jump_to;
	gchar** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	jump_to = TRUE;
	_tmp0_ = uris;
	_tmp0__length1 = _vala_array_length (uris);
	{
		gchar** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
		uri_collection = _tmp0_;
		uri_collection_length1 = _tmp0__length1;
		for (uri_it = 0; uri_it < _tmp0__length1; uri_it = uri_it + 1) {
			gchar* _tmp1_;
			gchar* uri = NULL;
			_tmp1_ = g_strdup (uri_collection[uri_it]);
			uri = _tmp1_;
			{
				const gchar* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				const gchar* _tmp5_;
				GFile* _tmp6_ = NULL;
				GFile* location;
				MainWindow* _tmp7_;
				GFile* _tmp8_;
				gboolean _tmp9_;
				DocumentTab* _tmp10_ = NULL;
				DocumentTab* _tmp11_;
				_tmp2_ = uri;
				_tmp3_ = strlen (_tmp2_);
				_tmp4_ = _tmp3_;
				if (_tmp4_ == 0) {
					_g_free0 (uri);
					continue;
				}
				_tmp5_ = uri;
				_tmp6_ = g_file_new_for_uri (_tmp5_);
				location = _tmp6_;
				_tmp7_ = self->priv->_active_window;
				_tmp8_ = location;
				_tmp9_ = jump_to;
				_tmp10_ = main_window_open_document (_tmp7_, _tmp8_, _tmp9_);
				_tmp11_ = _tmp10_;
				_g_object_unref0 (_tmp11_);
				jump_to = FALSE;
				_g_object_unref0 (location);
				_g_free0 (uri);
			}
		}
	}
}


static void latexila_register_my_stock_icons (Latexila* self) {
	GtkIconFactory* _tmp0_;
	GtkIconFactory* icon_factory;
	GtkIconFactory* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_icon_factory_new ();
	icon_factory = _tmp0_;
	{
		LatexilaStockIcon* icon_collection = NULL;
		gint icon_collection_length1 = 0;
		gint _icon_collection_size_ = 0;
		gint icon_it = 0;
		icon_collection = LATEXILA_stock_icons;
		icon_collection_length1 = G_N_ELEMENTS (LATEXILA_stock_icons);
		for (icon_it = 0; icon_it < G_N_ELEMENTS (LATEXILA_stock_icons); icon_it = icon_it + 1) {
			LatexilaStockIcon _tmp1_ = {0};
			LatexilaStockIcon icon = {0};
			latexila_stock_icon_copy (&icon_collection[icon_it], &_tmp1_);
			icon = _tmp1_;
			{
				GtkIconSet* _tmp2_;
				GtkIconSet* icon_set;
				GtkIconSource* _tmp3_;
				GtkIconSource* icon_source;
				GtkIconSource* _tmp4_;
				LatexilaStockIcon _tmp5_;
				const gchar* _tmp6_;
				GtkIconSet* _tmp7_;
				GtkIconSource* _tmp8_;
				GtkIconFactory* _tmp9_;
				LatexilaStockIcon _tmp10_;
				const gchar* _tmp11_;
				GtkIconSet* _tmp12_;
				_tmp2_ = gtk_icon_set_new ();
				icon_set = _tmp2_;
				_tmp3_ = gtk_icon_source_new ();
				icon_source = _tmp3_;
				_tmp4_ = icon_source;
				_tmp5_ = icon;
				_tmp6_ = _tmp5_.filename;
				gtk_icon_source_set_filename (_tmp4_, _tmp6_);
				_tmp7_ = icon_set;
				_tmp8_ = icon_source;
				gtk_icon_set_add_source (_tmp7_, _tmp8_);
				_tmp9_ = icon_factory;
				_tmp10_ = icon;
				_tmp11_ = _tmp10_.stock_id;
				_tmp12_ = icon_set;
				gtk_icon_factory_add (_tmp9_, _tmp11_, _tmp12_);
				_gtk_icon_source_free0 (icon_source);
				_gtk_icon_set_unref0 (icon_set);
				latexila_stock_icon_destroy (&icon);
			}
		}
	}
	_tmp13_ = icon_factory;
	gtk_icon_factory_add_default (_tmp13_);
	_g_object_unref0 (icon_factory);
}


static void latexila_add_theme_icon_to_stock (Latexila* self, const gchar* icon_name, const gchar* stock_id) {
	GtkIconTheme* _tmp0_ = NULL;
	GtkIconTheme* _tmp1_;
	GtkIconTheme* theme;
	GtkIconSet* _tmp2_;
	GtkIconSet* icon_set;
	GtkIconSize* _tmp3_ = NULL;
	GtkIconSize* sizes;
	gint sizes_length1;
	gint _sizes_size_;
	GtkIconSize* _tmp4_;
	gint _tmp4__length1;
	GtkIconFactory* _tmp21_;
	GtkIconFactory* icon_factory;
	const gchar* _tmp22_;
	GtkIconSet* _tmp23_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_name != NULL);
	g_return_if_fail (stock_id != NULL);
	_tmp0_ = gtk_icon_theme_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	theme = _tmp1_;
	_tmp2_ = gtk_icon_set_new ();
	icon_set = _tmp2_;
	_tmp3_ = g_new0 (GtkIconSize, 6);
	_tmp3_[0] = GTK_ICON_SIZE_MENU;
	_tmp3_[1] = GTK_ICON_SIZE_SMALL_TOOLBAR;
	_tmp3_[2] = GTK_ICON_SIZE_LARGE_TOOLBAR;
	_tmp3_[3] = GTK_ICON_SIZE_BUTTON;
	_tmp3_[4] = GTK_ICON_SIZE_DND;
	_tmp3_[5] = GTK_ICON_SIZE_DIALOG;
	sizes = _tmp3_;
	sizes_length1 = 6;
	_sizes_size_ = sizes_length1;
	_tmp4_ = sizes;
	_tmp4__length1 = sizes_length1;
	{
		GtkIconSize* size_collection = NULL;
		gint size_collection_length1 = 0;
		gint _size_collection_size_ = 0;
		gint size_it = 0;
		size_collection = _tmp4_;
		size_collection_length1 = _tmp4__length1;
		for (size_it = 0; size_it < _tmp4__length1; size_it = size_it + 1) {
			GtkIconSize size = 0;
			size = size_collection[size_it];
			{
				gint nb_pixels = 0;
				GtkIconSize _tmp5_;
				gint _tmp6_ = 0;
				GdkPixbuf* pixbuf;
				GtkIconSource* _tmp14_;
				GtkIconSource* icon_source;
				GtkIconSource* _tmp15_;
				GdkPixbuf* _tmp16_;
				GtkIconSource* _tmp17_;
				GtkIconSize _tmp18_;
				GtkIconSet* _tmp19_;
				GtkIconSource* _tmp20_;
				_tmp5_ = size;
				gtk_icon_size_lookup (_tmp5_, &_tmp6_, NULL);
				nb_pixels = _tmp6_;
				pixbuf = NULL;
				{
					GtkIconTheme* _tmp7_;
					const gchar* _tmp8_;
					gint _tmp9_;
					GdkPixbuf* _tmp10_ = NULL;
					GdkPixbuf* _tmp11_;
					_tmp7_ = theme;
					_tmp8_ = icon_name;
					_tmp9_ = nb_pixels;
					_tmp10_ = gtk_icon_theme_load_icon (_tmp7_, _tmp8_, _tmp9_, 0, &_inner_error_);
					_tmp11_ = _tmp10_;
					if (_inner_error_ != NULL) {
						goto __catch17_g_error;
					}
					_g_object_unref0 (pixbuf);
					pixbuf = _tmp11_;
				}
				goto __finally17;
				__catch17_g_error:
				{
					GError* e = NULL;
					GError* _tmp12_;
					const gchar* _tmp13_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp12_ = e;
					_tmp13_ = _tmp12_->message;
					g_warning ("latexila.vala:350: Get theme icon failed: %s", _tmp13_);
					_g_error_free0 (e);
					_g_object_unref0 (pixbuf);
					continue;
				}
				__finally17:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (pixbuf);
					sizes = (g_free (sizes), NULL);
					_gtk_icon_set_unref0 (icon_set);
					_g_object_unref0 (theme);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp14_ = gtk_icon_source_new ();
				icon_source = _tmp14_;
				_tmp15_ = icon_source;
				_tmp16_ = pixbuf;
				gtk_icon_source_set_pixbuf (_tmp15_, _tmp16_);
				_tmp17_ = icon_source;
				_tmp18_ = size;
				gtk_icon_source_set_size (_tmp17_, _tmp18_);
				_tmp19_ = icon_set;
				_tmp20_ = icon_source;
				gtk_icon_set_add_source (_tmp19_, _tmp20_);
				_gtk_icon_source_free0 (icon_source);
				_g_object_unref0 (pixbuf);
			}
		}
	}
	_tmp21_ = gtk_icon_factory_new ();
	icon_factory = _tmp21_;
	_tmp22_ = stock_id;
	_tmp23_ = icon_set;
	gtk_icon_factory_add (icon_factory, _tmp22_, _tmp23_);
	gtk_icon_factory_add_default (icon_factory);
	_g_object_unref0 (icon_factory);
	sizes = (g_free (sizes), NULL);
	_gtk_icon_set_unref0 (icon_set);
	_g_object_unref0 (theme);
}


GList* latexila_get_windows (Latexila* self) {
	GList* result;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_windows;
	result = _tmp0_;
	return result;
}


static void latexila_set_windows (Latexila* self, GList* value) {
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_windows = _tmp0_;
	g_object_notify ((GObject *) self, "windows");
}


MainWindow* latexila_get_active_window (Latexila* self) {
	MainWindow* result;
	MainWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_active_window;
	result = _tmp0_;
	return result;
}


static void latexila_set_active_window (Latexila* self, MainWindow* value) {
	MainWindow* _tmp0_;
	MainWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_active_window);
	self->priv->_active_window = _tmp1_;
	g_object_notify ((GObject *) self, "active-window");
}


static void latexila_stock_icon_copy (const LatexilaStockIcon* self, LatexilaStockIcon* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).filename;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).filename);
	(*dest).filename = _tmp1_;
	_tmp2_ = (*self).stock_id;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).stock_id);
	(*dest).stock_id = _tmp3_;
}


static void latexila_stock_icon_destroy (LatexilaStockIcon* self) {
	_g_free0 ((*self).filename);
	_g_free0 ((*self).stock_id);
}


static LatexilaStockIcon* latexila_stock_icon_dup (const LatexilaStockIcon* self) {
	LatexilaStockIcon* dup;
	dup = g_new0 (LatexilaStockIcon, 1);
	latexila_stock_icon_copy (self, dup);
	return dup;
}


static void latexila_stock_icon_free (LatexilaStockIcon* self) {
	latexila_stock_icon_destroy (self);
	g_free (self);
}


static GType latexila_stock_icon_get_type (void) {
	static volatile gsize latexila_stock_icon_type_id__volatile = 0;
	if (g_once_init_enter (&latexila_stock_icon_type_id__volatile)) {
		GType latexila_stock_icon_type_id;
		latexila_stock_icon_type_id = g_boxed_type_register_static ("LatexilaStockIcon", (GBoxedCopyFunc) latexila_stock_icon_dup, (GBoxedFreeFunc) latexila_stock_icon_free);
		g_once_init_leave (&latexila_stock_icon_type_id__volatile, latexila_stock_icon_type_id);
	}
	return latexila_stock_icon_type_id__volatile;
}


static void latexila_class_init (LatexilaClass * klass) {
	latexila_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (LatexilaPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_latexila_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_latexila_set_property;
	G_OBJECT_CLASS (klass)->finalize = latexila_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), LATEXILA_WINDOWS, g_param_spec_pointer ("windows", "windows", "windows", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), LATEXILA_ACTIVE_WINDOW, g_param_spec_object ("active-window", "active-window", "active-window", TYPE_MAIN_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void latexila_instance_init (Latexila * self) {
	self->priv = LATEXILA_GET_PRIVATE (self);
}


static void latexila_finalize (GObject* obj) {
	Latexila * self;
	self = LATEXILA (obj);
	_g_object_unref0 (self->priv->_active_window);
	G_OBJECT_CLASS (latexila_parent_class)->finalize (obj);
}


GType latexila_get_type (void) {
	static volatile gsize latexila_type_id__volatile = 0;
	if (g_once_init_enter (&latexila_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LatexilaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) latexila_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Latexila), 0, (GInstanceInitFunc) latexila_instance_init, NULL };
		GType latexila_type_id;
		latexila_type_id = g_type_register_static (G_TYPE_OBJECT, "Latexila", &g_define_type_info, 0);
		g_once_init_leave (&latexila_type_id__volatile, latexila_type_id);
	}
	return latexila_type_id__volatile;
}


static void _vala_latexila_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Latexila * self;
	self = LATEXILA (object);
	switch (property_id) {
		case LATEXILA_WINDOWS:
		g_value_set_pointer (value, latexila_get_windows (self));
		break;
		case LATEXILA_ACTIVE_WINDOW:
		g_value_set_object (value, latexila_get_active_window (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_latexila_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Latexila * self;
	self = LATEXILA (object);
	switch (property_id) {
		case LATEXILA_WINDOWS:
		latexila_set_windows (self, g_value_get_pointer (value));
		break;
		case LATEXILA_ACTIVE_WINDOW:
		latexila_set_active_window (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



