/* templates.c generated by valac 0.15.1, the Vala compiler
 * generated from templates.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include "config.h"
#include <gtksourceview/gtksourceview.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>


#define TYPE_TEMPLATES (templates_get_type ())
#define TEMPLATES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEMPLATES, Templates))
#define TEMPLATES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEMPLATES, TemplatesClass))
#define IS_TEMPLATES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEMPLATES))
#define IS_TEMPLATES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEMPLATES))
#define TEMPLATES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEMPLATES, TemplatesClass))

typedef struct _Templates Templates;
typedef struct _TemplatesClass TemplatesClass;
typedef struct _TemplatesPrivate TemplatesPrivate;

#define TEMPLATES_TYPE_TEMPLATE_COLUMN (templates_template_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _Block12Data Block12Data;
#define __g_list_free__gtk_tree_path_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_tree_path_free0_ (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

struct _Templates {
	GObject parent_instance;
	TemplatesPrivate * priv;
};

struct _TemplatesClass {
	GObjectClass parent_class;
};

struct _TemplatesPrivate {
	GtkListStore* default_store;
	GtkListStore* personal_store;
	gint nb_personal_templates;
	gchar* rc_file;
	gchar* rc_dir;
};

typedef enum  {
	TEMPLATES_TEMPLATE_COLUMN_PIXBUF,
	TEMPLATES_TEMPLATE_COLUMN_ICON_ID,
	TEMPLATES_TEMPLATE_COLUMN_NAME,
	TEMPLATES_TEMPLATE_COLUMN_CONTENTS,
	TEMPLATES_TEMPLATE_COLUMN_N_COLUMNS
} TemplatesTemplateColumn;

struct _Block12Data {
	int _ref_count_;
	Templates * self;
	GtkDialog* dialog;
	GtkVPaned* vpaned;
	GtkIconView* icon_view_default_templates;
	GtkIconView* icon_view_personal_templates;
	MainWindow* parent;
};


static gpointer templates_parent_class = NULL;
static Templates* templates_templates;
static Templates* templates_templates = NULL;

GType templates_get_type (void) G_GNUC_CONST;
#define TEMPLATES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TEMPLATES, TemplatesPrivate))
enum  {
	TEMPLATES_DUMMY_PROPERTY
};
static GType templates_template_column_get_type (void) G_GNUC_UNUSED;
static Templates* templates_new (void);
static Templates* templates_construct (GType object_type);
static void templates_add_template_from_string (Templates* self, GtkListStore* store, const gchar* name, const gchar* icon_id, const gchar* contents);
static void templates_add_default_template (Templates* self, const gchar* name, const gchar* icon_id, const gchar* filename);
static void templates_add_template_from_file (Templates* self, GtkListStore* store, const gchar* name, const gchar* icon_id, GFile* file);
Templates* templates_get_default (void);
GType main_window_get_type (void) G_GNUC_CONST;
void templates_show_dialog_new (Templates* self, MainWindow* parent);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (Block12Data* _data12_);
static GtkIconView* templates_create_icon_view (Templates* self, GtkListStore* store);
GtkWidget* utils_add_scrollbar (GtkWidget* child);
GtkWidget* utils_get_dialog_component (const gchar* title, GtkWidget* widget);
static void __lambda67_ (Block12Data* _data12_);
static void templates_on_icon_view_selection_changed (Templates* self, GtkIconView* icon_view, GtkIconView* other_icon_view);
static void ___lambda67__gtk_icon_view_selection_changed (GtkIconView* _sender, gpointer self);
static void __lambda68_ (Block12Data* _data12_);
static void ___lambda68__gtk_icon_view_selection_changed (GtkIconView* _sender, gpointer self);
static void __lambda69_ (Block12Data* _data12_, GtkTreePath* path);
static void templates_open_template (Templates* self, MainWindow* main_window, GtkTreeModel* model, GtkTreePath* path);
static void templates_close_dialog_new (Templates* self, GtkDialog* dialog, GtkVPaned* vpaned);
static void ___lambda69__gtk_icon_view_item_activated (GtkIconView* _sender, GtkTreePath* path, gpointer self);
static void __lambda70_ (Block12Data* _data12_, GtkTreePath* path);
static void ___lambda70__gtk_icon_view_item_activated (GtkIconView* _sender, GtkTreePath* path, gpointer self);
static void _gtk_tree_path_free0_ (gpointer var);
static void _g_list_free__gtk_tree_path_free0_ (GList* self);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentTab* main_window_create_tab (MainWindow* self, gboolean jump_to);
GType document_get_type (void) G_GNUC_CONST;
Document* document_tab_get_document (DocumentTab* self);
void document_set_contents (Document* self, const gchar* contents);
void templates_show_dialog_create (Templates* self, MainWindow* parent);
DocumentTab* main_window_get_active_tab (MainWindow* self);
Document* main_window_get_active_document (MainWindow* self);
static void templates_add_personal_template (Templates* self, const gchar* contents);
void templates_show_dialog_delete (Templates* self, MainWindow* parent);
static void templates_save_rc_file (Templates* self);
static void templates_save_contents (Templates* self);
static gchar* templates_get_theme_icon (Templates* self, const gchar* icon_id);
static void _vala_array_add9 (GFile*** array, int* length, int* size, GFile* value);
static void templates_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static GType templates_template_column_get_type (void) {
	static volatile gsize templates_template_column_type_id__volatile = 0;
	if (g_once_init_enter (&templates_template_column_type_id__volatile)) {
		static const GEnumValue values[] = {{TEMPLATES_TEMPLATE_COLUMN_PIXBUF, "TEMPLATES_TEMPLATE_COLUMN_PIXBUF", "pixbuf"}, {TEMPLATES_TEMPLATE_COLUMN_ICON_ID, "TEMPLATES_TEMPLATE_COLUMN_ICON_ID", "icon-id"}, {TEMPLATES_TEMPLATE_COLUMN_NAME, "TEMPLATES_TEMPLATE_COLUMN_NAME", "name"}, {TEMPLATES_TEMPLATE_COLUMN_CONTENTS, "TEMPLATES_TEMPLATE_COLUMN_CONTENTS", "contents"}, {TEMPLATES_TEMPLATE_COLUMN_N_COLUMNS, "TEMPLATES_TEMPLATE_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType templates_template_column_type_id;
		templates_template_column_type_id = g_enum_register_static ("TemplatesTemplateColumn", values);
		g_once_init_leave (&templates_template_column_type_id__volatile, templates_template_column_type_id);
	}
	return templates_template_column_type_id__volatile;
}


static Templates* templates_construct (GType object_type) {
	Templates * self = NULL;
	GtkListStore* _tmp0_;
	GtkListStore* _tmp1_;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkListStore* _tmp8_;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_;
	GFile* _tmp14_ = NULL;
	GFile* _tmp15_;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_;
	GError * _inner_error_ = NULL;
	self = (Templates*) g_object_new (object_type, NULL);
	_tmp0_ = gtk_list_store_new ((gint) TEMPLATES_TEMPLATE_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
	_g_object_unref0 (self->priv->default_store);
	self->priv->default_store = _tmp0_;
	_tmp1_ = self->priv->default_store;
	_tmp2_ = _ ("Empty");
	templates_add_template_from_string (self, _tmp1_, _tmp2_, "empty", "");
	_tmp3_ = _ ("Article");
	templates_add_default_template (self, _tmp3_, "article", "article.tex");
	_tmp4_ = _ ("Report");
	templates_add_default_template (self, _tmp4_, "report", "report.tex");
	_tmp5_ = _ ("Book");
	templates_add_default_template (self, _tmp5_, "book", "book.tex");
	_tmp6_ = _ ("Letter");
	templates_add_default_template (self, _tmp6_, "letter", "letter.tex");
	_tmp7_ = _ ("Presentation");
	templates_add_default_template (self, _tmp7_, "beamer", "beamer.tex");
	_tmp8_ = gtk_list_store_new ((gint) TEMPLATES_TEMPLATE_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
	_g_object_unref0 (self->priv->personal_store);
	self->priv->personal_store = _tmp8_;
	self->priv->nb_personal_templates = 0;
	_tmp9_ = g_get_user_data_dir ();
	_tmp10_ = g_build_filename (_tmp9_, "latexila", "templatesrc", NULL, NULL);
	_g_free0 (self->priv->rc_file);
	self->priv->rc_file = _tmp10_;
	_tmp11_ = g_get_user_data_dir ();
	_tmp12_ = g_build_filename (_tmp11_, "latexila", NULL, NULL);
	_g_free0 (self->priv->rc_dir);
	self->priv->rc_dir = _tmp12_;
	_tmp13_ = self->priv->rc_file;
	_tmp14_ = g_file_new_for_path (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_file_query_exists (_tmp15_, NULL);
	_tmp17_ = !_tmp16_;
	_g_object_unref0 (_tmp15_);
	if (_tmp17_) {
		return self;
	}
	{
		GKeyFile* _tmp18_;
		GKeyFile* key_file;
		GKeyFile* _tmp19_;
		const gchar* _tmp20_;
		GKeyFile* _tmp21_;
		gsize _tmp22_;
		gchar** _tmp23_ = NULL;
		gchar** names;
		gint names_length1;
		gint _names_size_;
		GKeyFile* _tmp24_;
		gsize _tmp25_;
		gchar** _tmp26_ = NULL;
		gchar** icons;
		gint icons_length1;
		gint _icons_size_;
		gchar** _tmp27_;
		gint _tmp27__length1;
		_tmp18_ = g_key_file_new ();
		key_file = _tmp18_;
		_tmp19_ = key_file;
		_tmp20_ = self->priv->rc_file;
		g_key_file_load_from_file (_tmp19_, _tmp20_, G_KEY_FILE_NONE, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_key_file_free0 (key_file);
			goto __catch34_g_error;
		}
		_tmp21_ = key_file;
		_tmp23_ = g_key_file_get_string_list (_tmp21_, APP_NAME, "names", &_tmp22_, &_inner_error_);
		names = _tmp23_;
		names_length1 = _tmp22_;
		_names_size_ = names_length1;
		if (_inner_error_ != NULL) {
			_g_key_file_free0 (key_file);
			goto __catch34_g_error;
		}
		_tmp24_ = key_file;
		_tmp26_ = g_key_file_get_string_list (_tmp24_, APP_NAME, "icons", &_tmp25_, &_inner_error_);
		icons = _tmp26_;
		icons_length1 = _tmp25_;
		_icons_size_ = icons_length1;
		if (_inner_error_ != NULL) {
			names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
			_g_key_file_free0 (key_file);
			goto __catch34_g_error;
		}
		_tmp27_ = names;
		_tmp27__length1 = names_length1;
		self->priv->nb_personal_templates = _tmp27__length1;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp28_;
				_tmp28_ = TRUE;
				while (TRUE) {
					gboolean _tmp29_;
					gint _tmp31_;
					gint _tmp32_;
					const gchar* _tmp33_;
					gint _tmp34_;
					gchar* _tmp35_ = NULL;
					gchar* _tmp36_;
					GFile* _tmp37_ = NULL;
					GFile* _tmp38_;
					GFile* file;
					GFile* _tmp39_;
					gboolean _tmp40_ = FALSE;
					GtkListStore* _tmp41_;
					gchar** _tmp42_;
					gint _tmp42__length1;
					gint _tmp43_;
					const gchar* _tmp44_;
					gchar** _tmp45_;
					gint _tmp45__length1;
					gint _tmp46_;
					const gchar* _tmp47_;
					GFile* _tmp48_;
					_tmp29_ = _tmp28_;
					if (!_tmp29_) {
						gint _tmp30_;
						_tmp30_ = i;
						i = _tmp30_ + 1;
					}
					_tmp28_ = FALSE;
					_tmp31_ = i;
					_tmp32_ = self->priv->nb_personal_templates;
					if (!(_tmp31_ < _tmp32_)) {
						break;
					}
					_tmp33_ = self->priv->rc_dir;
					_tmp34_ = i;
					_tmp35_ = g_strdup_printf ("%s/%d.tex", _tmp33_, _tmp34_);
					_tmp36_ = _tmp35_;
					_tmp37_ = g_file_new_for_path (_tmp36_);
					_tmp38_ = _tmp37_;
					_g_free0 (_tmp36_);
					file = _tmp38_;
					_tmp39_ = file;
					_tmp40_ = g_file_query_exists (_tmp39_, NULL);
					if (!_tmp40_) {
						_g_object_unref0 (file);
						continue;
					}
					_tmp41_ = self->priv->personal_store;
					_tmp42_ = names;
					_tmp42__length1 = names_length1;
					_tmp43_ = i;
					_tmp44_ = _tmp42_[_tmp43_];
					_tmp45_ = icons;
					_tmp45__length1 = icons_length1;
					_tmp46_ = i;
					_tmp47_ = _tmp45_[_tmp46_];
					_tmp48_ = file;
					templates_add_template_from_file (self, _tmp41_, _tmp44_, _tmp47_, _tmp48_);
					_g_object_unref0 (file);
				}
			}
		}
		icons = (_vala_array_free (icons, icons_length1, (GDestroyNotify) g_free), NULL);
		names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
		_g_key_file_free0 (key_file);
	}
	goto __finally34;
	__catch34_g_error:
	{
		GError* e = NULL;
		GError* _tmp49_;
		const gchar* _tmp50_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp49_ = e;
		_tmp50_ = _tmp49_->message;
		g_warning ("templates.vala:91: Load templates failed: %s", _tmp50_);
		_g_error_free0 (e);
		return self;
	}
	__finally34:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


static Templates* templates_new (void) {
	return templates_construct (TYPE_TEMPLATES);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


Templates* templates_get_default (void) {
	Templates* result = NULL;
	Templates* _tmp0_;
	Templates* _tmp2_;
	Templates* _tmp3_;
	_tmp0_ = templates_templates;
	if (_tmp0_ == NULL) {
		Templates* _tmp1_;
		_tmp1_ = templates_new ();
		_g_object_unref0 (templates_templates);
		templates_templates = _tmp1_;
	}
	_tmp2_ = templates_templates;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


static Block12Data* block12_data_ref (Block12Data* _data12_) {
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}


static void block12_data_unref (Block12Data* _data12_) {
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		Templates * self;
		self = _data12_->self;
		_g_object_unref0 (_data12_->icon_view_personal_templates);
		_g_object_unref0 (_data12_->icon_view_default_templates);
		_g_object_unref0 (_data12_->vpaned);
		_g_object_unref0 (_data12_->dialog);
		_g_object_unref0 (_data12_->parent);
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}


static void __lambda67_ (Block12Data* _data12_) {
	Templates * self;
	GtkIconView* _tmp0_;
	GtkIconView* _tmp1_;
	self = _data12_->self;
	_tmp0_ = _data12_->icon_view_default_templates;
	_tmp1_ = _data12_->icon_view_personal_templates;
	templates_on_icon_view_selection_changed (self, _tmp0_, _tmp1_);
}


static void ___lambda67__gtk_icon_view_selection_changed (GtkIconView* _sender, gpointer self) {
	__lambda67_ (self);
}


static void __lambda68_ (Block12Data* _data12_) {
	Templates * self;
	GtkIconView* _tmp0_;
	GtkIconView* _tmp1_;
	self = _data12_->self;
	_tmp0_ = _data12_->icon_view_personal_templates;
	_tmp1_ = _data12_->icon_view_default_templates;
	templates_on_icon_view_selection_changed (self, _tmp0_, _tmp1_);
}


static void ___lambda68__gtk_icon_view_selection_changed (GtkIconView* _sender, gpointer self) {
	__lambda68_ (self);
}


static void __lambda69_ (Block12Data* _data12_, GtkTreePath* path) {
	Templates * self;
	MainWindow* _tmp0_;
	GtkListStore* _tmp1_;
	GtkTreePath* _tmp2_;
	GtkDialog* _tmp3_;
	GtkVPaned* _tmp4_;
	self = _data12_->self;
	g_return_if_fail (path != NULL);
	_tmp0_ = _data12_->parent;
	_tmp1_ = self->priv->default_store;
	_tmp2_ = path;
	templates_open_template (self, _tmp0_, (GtkTreeModel*) _tmp1_, _tmp2_);
	_tmp3_ = _data12_->dialog;
	_tmp4_ = _data12_->vpaned;
	templates_close_dialog_new (self, _tmp3_, _tmp4_);
}


static void ___lambda69__gtk_icon_view_item_activated (GtkIconView* _sender, GtkTreePath* path, gpointer self) {
	__lambda69_ (self, path);
}


static void __lambda70_ (Block12Data* _data12_, GtkTreePath* path) {
	Templates * self;
	MainWindow* _tmp0_;
	GtkListStore* _tmp1_;
	GtkTreePath* _tmp2_;
	GtkDialog* _tmp3_;
	GtkVPaned* _tmp4_;
	self = _data12_->self;
	g_return_if_fail (path != NULL);
	_tmp0_ = _data12_->parent;
	_tmp1_ = self->priv->personal_store;
	_tmp2_ = path;
	templates_open_template (self, _tmp0_, (GtkTreeModel*) _tmp1_, _tmp2_);
	_tmp3_ = _data12_->dialog;
	_tmp4_ = _data12_->vpaned;
	templates_close_dialog_new (self, _tmp3_, _tmp4_);
}


static void ___lambda70__gtk_icon_view_item_activated (GtkIconView* _sender, GtkTreePath* path, gpointer self) {
	__lambda70_ (self, path);
}


static void _gtk_tree_path_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL));
}


static void _g_list_free__gtk_tree_path_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gtk_tree_path_free0_, NULL);
	g_list_free (self);
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


void templates_show_dialog_new (Templates* self, MainWindow* parent) {
	Block12Data* _data12_;
	MainWindow* _tmp0_;
	MainWindow* _tmp1_;
	const gchar* _tmp2_ = NULL;
	MainWindow* _tmp3_;
	GtkDialog* _tmp4_;
	GtkDialog* _tmp5_;
	GSettings* _tmp6_;
	GSettings* settings;
	gint w = 0;
	gint h = 0;
	GSettings* _tmp7_;
	GtkDialog* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GtkDialog* _tmp11_;
	GtkDialog* _tmp12_;
	GtkWidget* _tmp13_ = NULL;
	GtkBox* _tmp14_;
	GtkBox* content_area;
	GtkVPaned* _tmp15_;
	GtkVPaned* _tmp16_;
	GtkBox* _tmp17_;
	GtkVPaned* _tmp18_;
	GtkVPaned* _tmp19_;
	GSettings* _tmp20_;
	gint _tmp21_ = 0;
	GtkListStore* _tmp22_;
	GtkIconView* _tmp23_ = NULL;
	GtkIconView* _tmp24_;
	GtkWidget* _tmp25_ = NULL;
	GtkWidget* scrollbar;
	const gchar* _tmp26_ = NULL;
	GtkWidget* _tmp27_;
	GtkWidget* _tmp28_ = NULL;
	GtkWidget* component;
	GtkVPaned* _tmp29_;
	GtkWidget* _tmp30_;
	GtkListStore* _tmp31_;
	GtkIconView* _tmp32_ = NULL;
	GtkIconView* _tmp33_;
	GtkWidget* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	GtkWidget* _tmp36_;
	GtkWidget* _tmp37_ = NULL;
	GtkVPaned* _tmp38_;
	GtkWidget* _tmp39_;
	GtkBox* _tmp40_;
	GtkIconView* _tmp41_;
	GtkIconView* _tmp42_;
	GtkIconView* _tmp43_;
	GtkIconView* _tmp44_;
	GtkDialog* _tmp45_;
	gint _tmp46_ = 0;
	GtkDialog* _tmp63_;
	GtkVPaned* _tmp64_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
	_tmp0_ = parent;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data12_->parent = _tmp1_;
	_tmp2_ = _ ("New File...");
	_tmp3_ = _data12_->parent;
	_tmp4_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp2_, (GtkWindow*) _tmp3_, GTK_DIALOG_NO_SEPARATOR, GTK_STOCK_OK, GTK_RESPONSE_ACCEPT, GTK_STOCK_CANCEL, GTK_RESPONSE_REJECT, NULL, NULL);
	_tmp5_ = g_object_ref_sink (_tmp4_);
	_data12_->dialog = _tmp5_;
	_tmp6_ = g_settings_new ("org.gnome.latexila.state.window");
	settings = _tmp6_;
	_tmp7_ = settings;
	g_settings_get (_tmp7_, "new-file-dialog-size", "(ii)", &w, &h);
	_tmp8_ = _data12_->dialog;
	_tmp9_ = w;
	_tmp10_ = h;
	gtk_window_set_default_size ((GtkWindow*) _tmp8_, _tmp9_, _tmp10_);
	_tmp11_ = _data12_->dialog;
	gtk_widget_set_size_request ((GtkWidget*) _tmp11_, 0, 0);
	_tmp12_ = _data12_->dialog;
	_tmp13_ = gtk_dialog_get_content_area (_tmp12_);
	_tmp14_ = _g_object_ref0 (GTK_BOX (_tmp13_));
	content_area = _tmp14_;
	_tmp15_ = (GtkVPaned*) gtk_vpaned_new ();
	_tmp16_ = g_object_ref_sink (_tmp15_);
	_data12_->vpaned = _tmp16_;
	_tmp17_ = content_area;
	_tmp18_ = _data12_->vpaned;
	gtk_box_pack_start (_tmp17_, (GtkWidget*) _tmp18_, TRUE, TRUE, (guint) 0);
	_tmp19_ = _data12_->vpaned;
	_tmp20_ = settings;
	_tmp21_ = g_settings_get_int (_tmp20_, "new-file-dialog-paned-position");
	gtk_paned_set_position ((GtkPaned*) _tmp19_, _tmp21_);
	_tmp22_ = self->priv->default_store;
	_tmp23_ = templates_create_icon_view (self, _tmp22_);
	_data12_->icon_view_default_templates = _tmp23_;
	_tmp24_ = _data12_->icon_view_default_templates;
	_tmp25_ = utils_add_scrollbar ((GtkWidget*) _tmp24_);
	scrollbar = _tmp25_;
	_tmp26_ = _ ("Default templates");
	_tmp27_ = scrollbar;
	_tmp28_ = utils_get_dialog_component (_tmp26_, _tmp27_);
	component = _tmp28_;
	_tmp29_ = _data12_->vpaned;
	_tmp30_ = component;
	gtk_paned_pack1 ((GtkPaned*) _tmp29_, _tmp30_, TRUE, TRUE);
	_tmp31_ = self->priv->personal_store;
	_tmp32_ = templates_create_icon_view (self, _tmp31_);
	_data12_->icon_view_personal_templates = _tmp32_;
	_tmp33_ = _data12_->icon_view_personal_templates;
	_tmp34_ = utils_add_scrollbar ((GtkWidget*) _tmp33_);
	_g_object_unref0 (scrollbar);
	scrollbar = _tmp34_;
	_tmp35_ = _ ("Your personal templates");
	_tmp36_ = scrollbar;
	_tmp37_ = utils_get_dialog_component (_tmp35_, _tmp36_);
	_g_object_unref0 (component);
	component = _tmp37_;
	_tmp38_ = _data12_->vpaned;
	_tmp39_ = component;
	gtk_paned_pack2 ((GtkPaned*) _tmp38_, _tmp39_, FALSE, TRUE);
	_tmp40_ = content_area;
	gtk_widget_show_all ((GtkWidget*) _tmp40_);
	_tmp41_ = _data12_->icon_view_default_templates;
	g_signal_connect_data (_tmp41_, "selection-changed", (GCallback) ___lambda67__gtk_icon_view_selection_changed, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
	_tmp42_ = _data12_->icon_view_personal_templates;
	g_signal_connect_data (_tmp42_, "selection-changed", (GCallback) ___lambda68__gtk_icon_view_selection_changed, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
	_tmp43_ = _data12_->icon_view_default_templates;
	g_signal_connect_data (_tmp43_, "item-activated", (GCallback) ___lambda69__gtk_icon_view_item_activated, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
	_tmp44_ = _data12_->icon_view_personal_templates;
	g_signal_connect_data (_tmp44_, "item-activated", (GCallback) ___lambda70__gtk_icon_view_item_activated, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
	_tmp45_ = _data12_->dialog;
	_tmp46_ = gtk_dialog_run (_tmp45_);
	if (_tmp46_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		GtkIconView* _tmp47_;
		GList* _tmp48_ = NULL;
		GList* selected_items;
		GtkListStore* _tmp49_;
		GtkTreeModel* _tmp50_;
		GtkTreeModel* model;
		GList* _tmp51_;
		guint _tmp52_ = 0U;
		GList* _tmp57_;
		gconstpointer _tmp58_ = NULL;
		GtkTreePath* _tmp59_;
		GtkTreePath* path;
		MainWindow* _tmp60_;
		GtkTreeModel* _tmp61_;
		GtkTreePath* _tmp62_;
		_tmp47_ = _data12_->icon_view_default_templates;
		_tmp48_ = gtk_icon_view_get_selected_items (_tmp47_);
		selected_items = _tmp48_;
		_tmp49_ = self->priv->default_store;
		_tmp50_ = _g_object_ref0 (GTK_TREE_MODEL (_tmp49_));
		model = _tmp50_;
		_tmp51_ = selected_items;
		_tmp52_ = g_list_length (_tmp51_);
		if (_tmp52_ == ((guint) 0)) {
			GtkIconView* _tmp53_;
			GList* _tmp54_ = NULL;
			GtkListStore* _tmp55_;
			GtkTreeModel* _tmp56_;
			_tmp53_ = _data12_->icon_view_personal_templates;
			_tmp54_ = gtk_icon_view_get_selected_items (_tmp53_);
			__g_list_free__gtk_tree_path_free0_0 (selected_items);
			selected_items = _tmp54_;
			_tmp55_ = self->priv->personal_store;
			_tmp56_ = _g_object_ref0 (GTK_TREE_MODEL (_tmp55_));
			_g_object_unref0 (model);
			model = _tmp56_;
		}
		_tmp57_ = selected_items;
		_tmp58_ = g_list_nth_data (_tmp57_, (guint) 0);
		_tmp59_ = _gtk_tree_path_copy0 ((GtkTreePath*) ((GtkTreePath*) _tmp58_));
		path = _tmp59_;
		_tmp60_ = _data12_->parent;
		_tmp61_ = model;
		_tmp62_ = path;
		templates_open_template (self, _tmp60_, _tmp61_, _tmp62_);
		_gtk_tree_path_free0 (path);
		_g_object_unref0 (model);
		__g_list_free__gtk_tree_path_free0_0 (selected_items);
	}
	_tmp63_ = _data12_->dialog;
	_tmp64_ = _data12_->vpaned;
	templates_close_dialog_new (self, _tmp63_, _tmp64_);
	_g_object_unref0 (component);
	_g_object_unref0 (scrollbar);
	_g_object_unref0 (content_area);
	_g_object_unref0 (settings);
	block12_data_unref (_data12_);
	_data12_ = NULL;
}


static void templates_open_template (Templates* self, MainWindow* main_window, GtkTreeModel* model, GtkTreePath* path) {
	GtkTreeIter _tmp0_ = {0};
	GtkTreeIter iter;
	gchar* _tmp1_;
	gchar* contents;
	gboolean _tmp2_ = FALSE;
	GtkTreePath* _tmp3_;
	gboolean _tmp8_;
	MainWindow* _tmp11_;
	DocumentTab* _tmp12_ = NULL;
	DocumentTab* tab;
	Document* _tmp13_;
	Document* _tmp14_;
	const gchar* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (main_window != NULL);
	g_return_if_fail (model != NULL);
	iter = _tmp0_;
	_tmp1_ = g_strdup ("");
	contents = _tmp1_;
	_tmp3_ = path;
	if (_tmp3_ != NULL) {
		GtkTreeModel* _tmp4_;
		GtkTreePath* _tmp5_;
		GtkTreeIter _tmp6_ = {0};
		gboolean _tmp7_ = FALSE;
		_tmp4_ = model;
		_tmp5_ = path;
		_tmp7_ = gtk_tree_model_get_iter (_tmp4_, &_tmp6_, _tmp5_);
		iter = _tmp6_;
		_tmp2_ = _tmp7_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp8_ = _tmp2_;
	if (_tmp8_) {
		GtkTreeModel* _tmp9_;
		GtkTreeIter _tmp10_;
		_tmp9_ = model;
		_tmp10_ = iter;
		gtk_tree_model_get (_tmp9_, &_tmp10_, TEMPLATES_TEMPLATE_COLUMN_CONTENTS, &contents, -1, -1);
	}
	_tmp11_ = main_window;
	_tmp12_ = main_window_create_tab (_tmp11_, TRUE);
	tab = _tmp12_;
	_tmp13_ = document_tab_get_document (tab);
	_tmp14_ = _tmp13_;
	_tmp15_ = contents;
	document_set_contents (_tmp14_, _tmp15_);
	_g_object_unref0 (tab);
	_g_free0 (contents);
}


static void templates_close_dialog_new (Templates* self, GtkDialog* dialog, GtkVPaned* vpaned) {
	gint w = 0;
	gint h = 0;
	GtkDialog* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GSettings* _tmp3_;
	GSettings* settings;
	GtkVPaned* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GtkDialog* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	g_return_if_fail (vpaned != NULL);
	_tmp0_ = dialog;
	gtk_window_get_size ((GtkWindow*) _tmp0_, &_tmp1_, &_tmp2_);
	w = _tmp1_;
	h = _tmp2_;
	_tmp3_ = g_settings_new ("org.gnome.latexila.state.window");
	settings = _tmp3_;
	g_settings_set (settings, "new-file-dialog-size", "(ii)", w, h);
	_tmp4_ = vpaned;
	_tmp5_ = gtk_paned_get_position ((GtkPaned*) _tmp4_);
	_tmp6_ = _tmp5_;
	g_settings_set_int (settings, "new-file-dialog-paned-position", _tmp6_);
	_tmp7_ = dialog;
	gtk_object_destroy ((GtkObject*) _tmp7_);
	_g_object_unref0 (settings);
}


void templates_show_dialog_create (Templates* self, MainWindow* parent) {
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	const gchar* _tmp3_ = NULL;
	MainWindow* _tmp4_;
	GtkDialog* _tmp5_;
	GtkDialog* _tmp6_;
	GtkDialog* dialog;
	GtkDialog* _tmp7_;
	GtkDialog* _tmp8_;
	GtkWidget* _tmp9_ = NULL;
	GtkBox* _tmp10_;
	GtkBox* content_area;
	GtkBox* _tmp11_;
	GtkEntry* _tmp12_;
	GtkEntry* _tmp13_;
	GtkEntry* entry;
	const gchar* _tmp14_ = NULL;
	GtkEntry* _tmp15_;
	GtkWidget* _tmp16_ = NULL;
	GtkWidget* component;
	GtkBox* _tmp17_;
	GtkWidget* _tmp18_;
	GtkListStore* _tmp19_;
	GtkIconView* _tmp20_ = NULL;
	GtkIconView* icon_view;
	GtkIconView* _tmp21_;
	GtkWidget* _tmp22_ = NULL;
	GtkWidget* scrollbar;
	const gchar* _tmp23_ = NULL;
	GtkWidget* _tmp24_;
	GtkWidget* _tmp25_ = NULL;
	GtkBox* _tmp26_;
	GtkWidget* _tmp27_;
	GtkBox* _tmp28_;
	GtkDialog* _tmp67_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	_tmp0_ = parent;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = _ ("New Template...");
	_tmp4_ = parent;
	_tmp5_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp3_, (GtkWindow*) _tmp4_, 0, GTK_STOCK_OK, GTK_RESPONSE_ACCEPT, GTK_STOCK_CANCEL, GTK_RESPONSE_REJECT, NULL, NULL);
	_tmp6_ = g_object_ref_sink (_tmp5_);
	dialog = _tmp6_;
	_tmp7_ = dialog;
	gtk_window_set_default_size ((GtkWindow*) _tmp7_, 420, 370);
	_tmp8_ = dialog;
	_tmp9_ = gtk_dialog_get_content_area (_tmp8_);
	_tmp10_ = _g_object_ref0 (GTK_IS_BOX (_tmp9_) ? ((GtkBox*) _tmp9_) : NULL);
	content_area = _tmp10_;
	_tmp11_ = content_area;
	gtk_box_set_homogeneous (_tmp11_, FALSE);
	_tmp12_ = (GtkEntry*) gtk_entry_new ();
	_tmp13_ = g_object_ref_sink (_tmp12_);
	entry = _tmp13_;
	_tmp14_ = _ ("Name of the new template");
	_tmp15_ = entry;
	_tmp16_ = utils_get_dialog_component (_tmp14_, (GtkWidget*) _tmp15_);
	component = _tmp16_;
	_tmp17_ = content_area;
	_tmp18_ = component;
	gtk_box_pack_start (_tmp17_, _tmp18_, FALSE, TRUE, (guint) 0);
	_tmp19_ = self->priv->default_store;
	_tmp20_ = templates_create_icon_view (self, _tmp19_);
	icon_view = _tmp20_;
	_tmp21_ = icon_view;
	_tmp22_ = utils_add_scrollbar ((GtkWidget*) _tmp21_);
	scrollbar = _tmp22_;
	_tmp23_ = _ ("Choose an icon");
	_tmp24_ = scrollbar;
	_tmp25_ = utils_get_dialog_component (_tmp23_, _tmp24_);
	_g_object_unref0 (component);
	component = _tmp25_;
	_tmp26_ = content_area;
	_tmp27_ = component;
	gtk_box_pack_start (_tmp26_, _tmp27_, TRUE, TRUE, (guint) 0);
	_tmp28_ = content_area;
	gtk_widget_show_all ((GtkWidget*) _tmp28_);
	while (TRUE) {
		GtkDialog* _tmp29_;
		gint _tmp30_ = 0;
		GtkEntry* _tmp31_;
		guint _tmp32_;
		guint _tmp33_;
		GtkIconView* _tmp34_;
		GList* _tmp35_ = NULL;
		GList* selected_items;
		GList* _tmp36_;
		guint _tmp37_ = 0U;
		gint _tmp38_;
		GtkTextIter start = {0};
		GtkTextIter end = {0};
		MainWindow* _tmp39_;
		Document* _tmp40_;
		Document* _tmp41_;
		GtkTextIter _tmp42_ = {0};
		GtkTextIter _tmp43_ = {0};
		MainWindow* _tmp44_;
		Document* _tmp45_;
		Document* _tmp46_;
		GtkTextIter _tmp47_;
		GtkTextIter _tmp48_;
		gchar* _tmp49_ = NULL;
		gchar* contents;
		GtkListStore* _tmp50_;
		GtkTreeModel* _tmp51_;
		GtkTreeModel* model;
		GList* _tmp52_;
		gconstpointer _tmp53_ = NULL;
		GtkTreePath* _tmp54_;
		GtkTreePath* path;
		GtkTreeIter iter = {0};
		gchar* icon_id = NULL;
		GtkTreeModel* _tmp55_;
		GtkTreePath* _tmp56_;
		GtkTreeIter _tmp57_ = {0};
		GtkTreeModel* _tmp58_;
		GtkTreeIter _tmp59_;
		GtkListStore* _tmp60_;
		GtkEntry* _tmp61_;
		const gchar* _tmp62_;
		const gchar* _tmp63_;
		const gchar* _tmp64_;
		const gchar* _tmp65_;
		const gchar* _tmp66_;
		_tmp29_ = dialog;
		_tmp30_ = gtk_dialog_run (_tmp29_);
		if (!(_tmp30_ == ((gint) GTK_RESPONSE_ACCEPT))) {
			break;
		}
		_tmp31_ = entry;
		_tmp32_ = gtk_entry_get_text_length (_tmp31_);
		_tmp33_ = _tmp32_;
		if (_tmp33_ == ((guint) 0)) {
			continue;
		}
		_tmp34_ = icon_view;
		_tmp35_ = gtk_icon_view_get_selected_items (_tmp34_);
		selected_items = _tmp35_;
		_tmp36_ = selected_items;
		_tmp37_ = g_list_length (_tmp36_);
		if (_tmp37_ == ((guint) 0)) {
			__g_list_free__gtk_tree_path_free0_0 (selected_items);
			continue;
		}
		_tmp38_ = self->priv->nb_personal_templates;
		self->priv->nb_personal_templates = _tmp38_ + 1;
		_tmp39_ = parent;
		_tmp40_ = main_window_get_active_document (_tmp39_);
		_tmp41_ = _tmp40_;
		gtk_text_buffer_get_bounds ((GtkTextBuffer*) _tmp41_, &_tmp42_, &_tmp43_);
		start = _tmp42_;
		end = _tmp43_;
		_tmp44_ = parent;
		_tmp45_ = main_window_get_active_document (_tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = start;
		_tmp48_ = end;
		_tmp49_ = gtk_text_buffer_get_text ((GtkTextBuffer*) _tmp46_, &_tmp47_, &_tmp48_, FALSE);
		contents = _tmp49_;
		_tmp50_ = self->priv->default_store;
		_tmp51_ = _g_object_ref0 (GTK_TREE_MODEL (_tmp50_));
		model = _tmp51_;
		_tmp52_ = selected_items;
		_tmp53_ = g_list_nth_data (_tmp52_, (guint) 0);
		_tmp54_ = _gtk_tree_path_copy0 ((GtkTreePath*) _tmp53_);
		path = _tmp54_;
		_tmp55_ = model;
		_tmp56_ = path;
		gtk_tree_model_get_iter (_tmp55_, &_tmp57_, _tmp56_);
		iter = _tmp57_;
		_tmp58_ = model;
		_tmp59_ = iter;
		gtk_tree_model_get (_tmp58_, &_tmp59_, TEMPLATES_TEMPLATE_COLUMN_ICON_ID, &icon_id, -1, -1);
		_tmp60_ = self->priv->personal_store;
		_tmp61_ = entry;
		_tmp62_ = gtk_entry_get_text (_tmp61_);
		_tmp63_ = _tmp62_;
		_tmp64_ = icon_id;
		_tmp65_ = contents;
		templates_add_template_from_string (self, _tmp60_, _tmp63_, _tmp64_, _tmp65_);
		_tmp66_ = contents;
		templates_add_personal_template (self, _tmp66_);
		_g_free0 (icon_id);
		_gtk_tree_path_free0 (path);
		_g_object_unref0 (model);
		_g_free0 (contents);
		__g_list_free__gtk_tree_path_free0_0 (selected_items);
		break;
	}
	_tmp67_ = dialog;
	gtk_object_destroy ((GtkObject*) _tmp67_);
	_g_object_unref0 (scrollbar);
	_g_object_unref0 (icon_view);
	_g_object_unref0 (component);
	_g_object_unref0 (entry);
	_g_object_unref0 (content_area);
	_g_object_unref0 (dialog);
}


void templates_show_dialog_delete (Templates* self, MainWindow* parent) {
	const gchar* _tmp0_ = NULL;
	MainWindow* _tmp1_;
	GtkDialog* _tmp2_;
	GtkDialog* _tmp3_;
	GtkDialog* dialog;
	GtkDialog* _tmp4_;
	GtkDialog* _tmp5_;
	GtkWidget* _tmp6_ = NULL;
	GtkBox* _tmp7_;
	GtkBox* content_area;
	GtkListStore* _tmp8_;
	GtkIconView* _tmp9_ = NULL;
	GtkIconView* icon_view;
	GtkIconView* _tmp10_;
	GtkIconView* _tmp11_;
	GtkWidget* _tmp12_ = NULL;
	GtkWidget* scrollbar;
	const gchar* _tmp13_ = NULL;
	GtkWidget* _tmp14_;
	GtkWidget* _tmp15_ = NULL;
	GtkWidget* component;
	GtkBox* _tmp16_;
	GtkWidget* _tmp17_;
	GtkBox* _tmp18_;
	gint _tmp19_;
	gint nb_personal_templates_before;
	gint _tmp44_;
	gint _tmp45_;
	GtkDialog* _tmp46_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	_tmp0_ = _ ("Delete Template(s)...");
	_tmp1_ = parent;
	_tmp2_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp0_, (GtkWindow*) _tmp1_, GTK_DIALOG_NO_SEPARATOR, GTK_STOCK_DELETE, GTK_RESPONSE_ACCEPT, GTK_STOCK_CLOSE, GTK_RESPONSE_REJECT, NULL, NULL);
	_tmp3_ = g_object_ref_sink (_tmp2_);
	dialog = _tmp3_;
	_tmp4_ = dialog;
	gtk_window_set_default_size ((GtkWindow*) _tmp4_, 400, 200);
	_tmp5_ = dialog;
	_tmp6_ = gtk_dialog_get_content_area (_tmp5_);
	_tmp7_ = _g_object_ref0 (GTK_BOX (_tmp6_));
	content_area = _tmp7_;
	_tmp8_ = self->priv->personal_store;
	_tmp9_ = templates_create_icon_view (self, _tmp8_);
	icon_view = _tmp9_;
	_tmp10_ = icon_view;
	gtk_icon_view_set_selection_mode (_tmp10_, GTK_SELECTION_MULTIPLE);
	_tmp11_ = icon_view;
	_tmp12_ = utils_add_scrollbar ((GtkWidget*) _tmp11_);
	scrollbar = _tmp12_;
	_tmp13_ = _ ("Personal templates");
	_tmp14_ = scrollbar;
	_tmp15_ = utils_get_dialog_component (_tmp13_, _tmp14_);
	component = _tmp15_;
	_tmp16_ = content_area;
	_tmp17_ = component;
	gtk_box_pack_start (_tmp16_, _tmp17_, TRUE, TRUE, (guint) 0);
	_tmp18_ = content_area;
	gtk_widget_show_all ((GtkWidget*) _tmp18_);
	_tmp19_ = self->priv->nb_personal_templates;
	nb_personal_templates_before = _tmp19_;
	while (TRUE) {
		GtkDialog* _tmp20_;
		gint _tmp21_ = 0;
		GtkIconView* _tmp22_;
		GList* _tmp23_ = NULL;
		GList* selected_items;
		GtkListStore* _tmp24_;
		GtkTreeModel* _tmp25_;
		GtkTreeModel* model;
		GList* _tmp26_;
		guint _tmp27_ = 0U;
		guint nb_selected_items;
		gint _tmp42_;
		guint _tmp43_;
		_tmp20_ = dialog;
		_tmp21_ = gtk_dialog_run (_tmp20_);
		if (!(_tmp21_ == ((gint) GTK_RESPONSE_ACCEPT))) {
			break;
		}
		_tmp22_ = icon_view;
		_tmp23_ = gtk_icon_view_get_selected_items (_tmp22_);
		selected_items = _tmp23_;
		_tmp24_ = self->priv->personal_store;
		_tmp25_ = _g_object_ref0 (GTK_TREE_MODEL (_tmp24_));
		model = _tmp25_;
		_tmp26_ = selected_items;
		_tmp27_ = g_list_length (_tmp26_);
		nb_selected_items = _tmp27_;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp28_;
				_tmp28_ = TRUE;
				while (TRUE) {
					gboolean _tmp29_;
					gint _tmp31_;
					guint _tmp32_;
					GList* _tmp33_;
					gint _tmp34_;
					gconstpointer _tmp35_ = NULL;
					GtkTreePath* _tmp36_;
					GtkTreePath* path;
					GtkTreeIter iter = {0};
					GtkTreeModel* _tmp37_;
					GtkTreePath* _tmp38_;
					GtkTreeIter _tmp39_ = {0};
					GtkListStore* _tmp40_;
					GtkTreeIter _tmp41_;
					_tmp29_ = _tmp28_;
					if (!_tmp29_) {
						gint _tmp30_;
						_tmp30_ = i;
						i = _tmp30_ + 1;
					}
					_tmp28_ = FALSE;
					_tmp31_ = i;
					_tmp32_ = nb_selected_items;
					if (!(((guint) _tmp31_) < _tmp32_)) {
						break;
					}
					_tmp33_ = selected_items;
					_tmp34_ = i;
					_tmp35_ = g_list_nth_data (_tmp33_, (guint) _tmp34_);
					_tmp36_ = _gtk_tree_path_copy0 ((GtkTreePath*) _tmp35_);
					path = _tmp36_;
					_tmp37_ = model;
					_tmp38_ = path;
					gtk_tree_model_get_iter (_tmp37_, &_tmp39_, _tmp38_);
					iter = _tmp39_;
					_tmp40_ = self->priv->personal_store;
					_tmp41_ = iter;
					gtk_list_store_remove (_tmp40_, &_tmp41_);
					_gtk_tree_path_free0 (path);
				}
			}
		}
		_tmp42_ = self->priv->nb_personal_templates;
		_tmp43_ = nb_selected_items;
		self->priv->nb_personal_templates = _tmp42_ - ((gint) _tmp43_);
		_g_object_unref0 (model);
		__g_list_free__gtk_tree_path_free0_0 (selected_items);
	}
	_tmp44_ = self->priv->nb_personal_templates;
	_tmp45_ = nb_personal_templates_before;
	if (_tmp44_ != _tmp45_) {
		templates_save_rc_file (self);
		templates_save_contents (self);
	}
	_tmp46_ = dialog;
	gtk_object_destroy ((GtkObject*) _tmp46_);
	_g_object_unref0 (component);
	_g_object_unref0 (scrollbar);
	_g_object_unref0 (icon_view);
	_g_object_unref0 (content_area);
	_g_object_unref0 (dialog);
}


static void templates_add_template_from_string (Templates* self, GtkListStore* store, const gchar* name, const gchar* icon_id, const gchar* contents) {
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GtkListStore* _tmp2_;
	GtkTreeIter _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (icon_id != NULL);
	g_return_if_fail (contents != NULL);
	_tmp0_ = store;
	gtk_list_store_append (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = store;
	_tmp3_ = iter;
	_tmp4_ = icon_id;
	_tmp5_ = templates_get_theme_icon (self, _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = icon_id;
	_tmp8_ = name;
	_tmp9_ = contents;
	gtk_list_store_set (_tmp2_, &_tmp3_, TEMPLATES_TEMPLATE_COLUMN_PIXBUF, _tmp6_, TEMPLATES_TEMPLATE_COLUMN_ICON_ID, _tmp7_, TEMPLATES_TEMPLATE_COLUMN_NAME, _tmp8_, TEMPLATES_TEMPLATE_COLUMN_CONTENTS, _tmp9_, -1, -1);
	_g_free0 (_tmp6_);
}


static void templates_add_template_from_file (Templates* self, GtkListStore* store, const gchar* name, const gchar* icon_id, GFile* file) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (icon_id != NULL);
	g_return_if_fail (file != NULL);
	{
		guint8* chars = NULL;
		gint chars_length1 = 0;
		gint _chars_size_ = 0;
		GFile* _tmp0_;
		guint8* _tmp1_ = NULL;
		gsize _tmp2_;
		guint8* _tmp3_;
		gint _tmp3__length1;
		gchar* contents;
		GtkListStore* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp0_ = file;
		g_file_load_contents (_tmp0_, NULL, &_tmp1_, &_tmp2_, NULL, &_inner_error_);
		chars = (g_free (chars), NULL);
		chars = _tmp1_;
		chars_length1 = _tmp2_;
		_chars_size_ = chars_length1;
		if (_inner_error_ != NULL) {
			chars = (g_free (chars), NULL);
			goto __catch35_g_error;
		}
		_tmp3_ = chars;
		_tmp3__length1 = chars_length1;
		chars = NULL;
		contents = (gchar*) _tmp3_;
		_tmp4_ = store;
		_tmp5_ = name;
		_tmp6_ = icon_id;
		_tmp7_ = contents;
		templates_add_template_from_string (self, _tmp4_, _tmp5_, _tmp6_, _tmp7_);
		_g_free0 (contents);
		chars = (g_free (chars), NULL);
	}
	goto __finally35;
	__catch35_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = name;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("templates.vala:347: Impossible to load the template '%s': %s", _tmp8_, _tmp10_);
		_g_error_free0 (e);
	}
	__finally35:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _vala_array_add9 (GFile*** array, int* length, int* size, GFile* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void templates_add_default_template (Templates* self, const gchar* name, const gchar* icon_id, const gchar* filename) {
	GFile** _tmp0_ = NULL;
	GFile** files;
	gint files_length1;
	gint _files_size_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** language_names;
	gint language_names_length1;
	gint _language_names_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	GFile** _tmp11_;
	gint _tmp11__length1;
	const gchar* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (icon_id != NULL);
	g_return_if_fail (filename != NULL);
	_tmp0_ = g_new0 (GFile*, 0 + 1);
	files = _tmp0_;
	files_length1 = 0;
	_files_size_ = files_length1;
	_tmp2_ = _tmp1_ = g_get_language_names ();
	language_names = _tmp2_;
	language_names_length1 = _vala_array_length (_tmp1_);
	_language_names_size_ = language_names_length1;
	_tmp3_ = language_names;
	_tmp3__length1 = language_names_length1;
	{
		gchar** language_name_collection = NULL;
		gint language_name_collection_length1 = 0;
		gint _language_name_collection_size_ = 0;
		gint language_name_it = 0;
		language_name_collection = _tmp3_;
		language_name_collection_length1 = _tmp3__length1;
		for (language_name_it = 0; language_name_it < _tmp3__length1; language_name_it = language_name_it + 1) {
			gchar* _tmp4_;
			gchar* language_name = NULL;
			_tmp4_ = g_strdup (language_name_collection[language_name_it]);
			language_name = _tmp4_;
			{
				GFile** _tmp5_;
				gint _tmp5__length1;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				gchar* _tmp8_ = NULL;
				gchar* _tmp9_;
				GFile* _tmp10_ = NULL;
				_tmp5_ = files;
				_tmp5__length1 = files_length1;
				_tmp6_ = language_name;
				_tmp7_ = filename;
				_tmp8_ = g_build_filename (DATA_DIR, "templates", _tmp6_, _tmp7_, NULL);
				_tmp9_ = _tmp8_;
				_tmp10_ = g_file_new_for_path (_tmp9_);
				_vala_array_add9 (&files, &files_length1, &_files_size_, _tmp10_);
				_g_free0 (_tmp9_);
				_g_free0 (language_name);
			}
		}
	}
	_tmp11_ = files;
	_tmp11__length1 = files_length1;
	{
		GFile** file_collection = NULL;
		gint file_collection_length1 = 0;
		gint _file_collection_size_ = 0;
		gint file_it = 0;
		file_collection = _tmp11_;
		file_collection_length1 = _tmp11__length1;
		for (file_it = 0; file_it < _tmp11__length1; file_it = file_it + 1) {
			GFile* _tmp12_;
			GFile* file = NULL;
			_tmp12_ = _g_object_ref0 (file_collection[file_it]);
			file = _tmp12_;
			{
				GFile* _tmp13_;
				gboolean _tmp14_ = FALSE;
				GtkListStore* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				GFile* _tmp18_;
				_tmp13_ = file;
				_tmp14_ = g_file_query_exists (_tmp13_, NULL);
				if (!_tmp14_) {
					_g_object_unref0 (file);
					continue;
				}
				_tmp15_ = self->priv->default_store;
				_tmp16_ = name;
				_tmp17_ = icon_id;
				_tmp18_ = file;
				templates_add_template_from_file (self, _tmp15_, _tmp16_, _tmp17_, _tmp18_);
				_g_object_unref0 (file);
				files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
				return;
			}
		}
	}
	_tmp19_ = name;
	g_warning ("templates.vala:371: Template '%s' not found.", _tmp19_);
	files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
}


static GtkIconView* templates_create_icon_view (Templates* self, GtkListStore* store) {
	GtkIconView* result = NULL;
	GtkListStore* _tmp0_;
	GtkIconView* _tmp1_;
	GtkIconView* _tmp2_;
	GtkIconView* icon_view;
	GtkCellRendererPixbuf* _tmp3_;
	GtkCellRendererPixbuf* _tmp4_;
	GtkCellRendererPixbuf* pixbuf_renderer;
	GtkCellRendererText* _tmp5_;
	GtkCellRendererText* _tmp6_;
	GtkCellRendererText* text_renderer;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (store != NULL, NULL);
	_tmp0_ = store;
	_tmp1_ = (GtkIconView*) gtk_icon_view_new_with_model ((GtkTreeModel*) _tmp0_);
	_tmp2_ = g_object_ref_sink (_tmp1_);
	icon_view = _tmp2_;
	gtk_icon_view_set_selection_mode (icon_view, GTK_SELECTION_SINGLE);
	_tmp3_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	_tmp4_ = g_object_ref_sink (_tmp3_);
	pixbuf_renderer = _tmp4_;
	g_object_set (pixbuf_renderer, "stock-size", (guint) GTK_ICON_SIZE_DIALOG, NULL);
	g_object_set ((GtkCellRenderer*) pixbuf_renderer, "xalign", (gfloat) 0.5, NULL);
	g_object_set ((GtkCellRenderer*) pixbuf_renderer, "yalign", (gfloat) 1.0, NULL);
	gtk_cell_layout_pack_start ((GtkCellLayout*) icon_view, (GtkCellRenderer*) pixbuf_renderer, FALSE);
	gtk_cell_layout_set_attributes ((GtkCellLayout*) icon_view, (GtkCellRenderer*) pixbuf_renderer, "icon-name", TEMPLATES_TEMPLATE_COLUMN_PIXBUF, NULL, NULL);
	_tmp5_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp6_ = g_object_ref_sink (_tmp5_);
	text_renderer = _tmp6_;
	g_object_set (text_renderer, "alignment", PANGO_ALIGN_CENTER, NULL);
	g_object_set (text_renderer, "wrap-mode", PANGO_WRAP_WORD, NULL);
	g_object_set ((GtkCellRenderer*) text_renderer, "xalign", (gfloat) 0.5, NULL);
	g_object_set ((GtkCellRenderer*) text_renderer, "yalign", (gfloat) 0.0, NULL);
	gtk_cell_layout_pack_end ((GtkCellLayout*) icon_view, (GtkCellRenderer*) text_renderer, FALSE);
	gtk_cell_layout_set_attributes ((GtkCellLayout*) icon_view, (GtkCellRenderer*) text_renderer, "text", TEMPLATES_TEMPLATE_COLUMN_NAME, NULL, NULL);
	result = icon_view;
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
	return result;
}


static void templates_on_icon_view_selection_changed (Templates* self, GtkIconView* icon_view, GtkIconView* other_icon_view) {
	GtkIconView* _tmp0_;
	GList* _tmp1_ = NULL;
	GList* selected_items;
	GList* _tmp2_;
	guint _tmp3_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_view != NULL);
	g_return_if_fail (other_icon_view != NULL);
	_tmp0_ = icon_view;
	_tmp1_ = gtk_icon_view_get_selected_items (_tmp0_);
	selected_items = _tmp1_;
	_tmp2_ = selected_items;
	_tmp3_ = g_list_length (_tmp2_);
	if (_tmp3_ > ((guint) 0)) {
		GtkIconView* _tmp4_;
		_tmp4_ = other_icon_view;
		g_signal_emit_by_name (_tmp4_, "unselect-all");
	}
	__g_list_free__gtk_tree_path_free0_0 (selected_items);
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static void templates_add_personal_template (Templates* self, const gchar* contents) {
	const gchar* _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_;
	GFile* file;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contents != NULL);
	templates_save_rc_file (self);
	_tmp0_ = self->priv->rc_dir;
	_tmp1_ = self->priv->nb_personal_templates;
	_tmp2_ = g_strdup_printf ("%s/%d.tex", _tmp0_, _tmp1_ - 1);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	file = _tmp5_;
	{
		GFile* _tmp6_;
		GFile* _tmp7_ = NULL;
		GFile* parent;
		gboolean _tmp8_ = FALSE;
		GFile* _tmp9_;
		gboolean _tmp12_;
		GFile* _tmp14_;
		const gchar* _tmp15_;
		guint8* _tmp16_;
		gint _tmp16__length1;
		guint8* _tmp17_;
		gint _tmp17__length1;
		_tmp6_ = file;
		_tmp7_ = g_file_get_parent (_tmp6_);
		parent = _tmp7_;
		_tmp9_ = parent;
		if (_tmp9_ != NULL) {
			GFile* _tmp10_;
			gboolean _tmp11_ = FALSE;
			_tmp10_ = parent;
			_tmp11_ = g_file_query_exists (_tmp10_, NULL);
			_tmp8_ = !_tmp11_;
		} else {
			_tmp8_ = FALSE;
		}
		_tmp12_ = _tmp8_;
		if (_tmp12_) {
			GFile* _tmp13_;
			_tmp13_ = parent;
			g_file_make_directory_with_parents (_tmp13_, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (parent);
				goto __catch36_g_error;
			}
		}
		_tmp14_ = file;
		_tmp15_ = contents;
		_tmp16_ = string_get_data (_tmp15_, &_tmp16__length1);
		_tmp17_ = _tmp16_;
		_tmp17__length1 = _tmp16__length1;
		g_file_replace_contents (_tmp14_, _tmp17_, (gsize) _tmp17__length1, NULL, FALSE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parent);
			goto __catch36_g_error;
		}
		_g_object_unref0 (parent);
	}
	goto __finally36;
	__catch36_g_error:
	{
		GError* e = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		g_warning ("templates.vala:437: Impossible to save the templates: %s", _tmp19_);
		_g_error_free0 (e);
	}
	__finally36:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (file);
}


static void templates_save_rc_file (Templates* self) {
	gint _tmp0_;
	gint _tmp4_;
	gchar** _tmp5_ = NULL;
	gchar** names;
	gint names_length1;
	gint _names_size_;
	gint _tmp6_;
	gchar** _tmp7_ = NULL;
	gchar** icons;
	gint icons_length1;
	gint _icons_size_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp8_;
	GtkTreeModel* _tmp9_;
	GtkTreeModel* model;
	GtkTreeModel* _tmp10_;
	GtkTreeIter _tmp11_ = {0};
	gboolean _tmp12_ = FALSE;
	gboolean valid_iter;
	gint i;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->nb_personal_templates;
	if (_tmp0_ == 0) {
		{
			const gchar* _tmp1_;
			GFile* _tmp2_ = NULL;
			GFile* _tmp3_;
			_tmp1_ = self->priv->rc_file;
			_tmp2_ = g_file_new_for_path (_tmp1_);
			_tmp3_ = _tmp2_;
			g_file_delete (_tmp3_, NULL, &_inner_error_);
			_g_object_unref0 (_tmp3_);
			if (_inner_error_ != NULL) {
				goto __catch37_g_error;
			}
		}
		goto __finally37;
		__catch37_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally37:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		return;
	}
	_tmp4_ = self->priv->nb_personal_templates;
	_tmp5_ = g_new0 (gchar*, _tmp4_ + 1);
	names = _tmp5_;
	names_length1 = _tmp4_;
	_names_size_ = names_length1;
	_tmp6_ = self->priv->nb_personal_templates;
	_tmp7_ = g_new0 (gchar*, _tmp6_ + 1);
	icons = _tmp7_;
	icons_length1 = _tmp6_;
	_icons_size_ = icons_length1;
	_tmp8_ = self->priv->personal_store;
	_tmp9_ = _g_object_ref0 (GTK_TREE_MODEL (_tmp8_));
	model = _tmp9_;
	_tmp10_ = model;
	_tmp12_ = gtk_tree_model_get_iter_first (_tmp10_, &_tmp11_);
	iter = _tmp11_;
	valid_iter = _tmp12_;
	i = 0;
	while (TRUE) {
		gboolean _tmp13_;
		GtkTreeModel* _tmp14_;
		GtkTreeIter _tmp15_;
		gchar** _tmp16_;
		gint _tmp16__length1;
		gint _tmp17_;
		gchar** _tmp18_;
		gint _tmp18__length1;
		gint _tmp19_;
		GtkTreeModel* _tmp20_;
		gboolean _tmp21_ = FALSE;
		gint _tmp22_;
		_tmp13_ = valid_iter;
		if (!_tmp13_) {
			break;
		}
		_tmp14_ = model;
		_tmp15_ = iter;
		_tmp16_ = names;
		_tmp16__length1 = names_length1;
		_tmp17_ = i;
		_tmp18_ = icons;
		_tmp18__length1 = icons_length1;
		_tmp19_ = i;
		gtk_tree_model_get (_tmp14_, &_tmp15_, TEMPLATES_TEMPLATE_COLUMN_NAME, &_tmp16_[_tmp17_], TEMPLATES_TEMPLATE_COLUMN_ICON_ID, &_tmp18_[_tmp19_], -1, -1);
		_tmp20_ = model;
		_tmp21_ = gtk_tree_model_iter_next (_tmp20_, &iter);
		valid_iter = _tmp21_;
		_tmp22_ = i;
		i = _tmp22_ + 1;
	}
	{
		GKeyFile* _tmp23_;
		GKeyFile* key_file;
		GKeyFile* _tmp24_;
		gchar** _tmp25_;
		gint _tmp25__length1;
		GKeyFile* _tmp26_;
		gchar** _tmp27_;
		gint _tmp27__length1;
		GKeyFile* _tmp28_;
		gchar* _tmp29_ = NULL;
		gchar* key_file_data;
		const gchar* _tmp30_;
		GFile* _tmp31_ = NULL;
		GFile* file;
		GFile* _tmp32_;
		GFile* _tmp33_ = NULL;
		GFile* parent;
		gboolean _tmp34_ = FALSE;
		GFile* _tmp35_;
		gboolean _tmp38_;
		GFile* _tmp40_;
		const gchar* _tmp41_;
		guint8* _tmp42_;
		gint _tmp42__length1;
		guint8* _tmp43_;
		gint _tmp43__length1;
		_tmp23_ = g_key_file_new ();
		key_file = _tmp23_;
		_tmp24_ = key_file;
		_tmp25_ = names;
		_tmp25__length1 = names_length1;
		g_key_file_set_string_list (_tmp24_, APP_NAME, "names", (const gchar* const*) _tmp25_, _tmp25__length1);
		_tmp26_ = key_file;
		_tmp27_ = icons;
		_tmp27__length1 = icons_length1;
		g_key_file_set_string_list (_tmp26_, APP_NAME, "icons", (const gchar* const*) _tmp27_, _tmp27__length1);
		_tmp28_ = key_file;
		_tmp29_ = g_key_file_to_data (_tmp28_, NULL, NULL);
		key_file_data = _tmp29_;
		_tmp30_ = self->priv->rc_file;
		_tmp31_ = g_file_new_for_path (_tmp30_);
		file = _tmp31_;
		_tmp32_ = file;
		_tmp33_ = g_file_get_parent (_tmp32_);
		parent = _tmp33_;
		_tmp35_ = parent;
		if (_tmp35_ != NULL) {
			GFile* _tmp36_;
			gboolean _tmp37_ = FALSE;
			_tmp36_ = parent;
			_tmp37_ = g_file_query_exists (_tmp36_, NULL);
			_tmp34_ = !_tmp37_;
		} else {
			_tmp34_ = FALSE;
		}
		_tmp38_ = _tmp34_;
		if (_tmp38_) {
			GFile* _tmp39_;
			_tmp39_ = parent;
			g_file_make_directory_with_parents (_tmp39_, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (parent);
				_g_object_unref0 (file);
				_g_free0 (key_file_data);
				_g_key_file_free0 (key_file);
				goto __catch38_g_error;
			}
		}
		_tmp40_ = file;
		_tmp41_ = key_file_data;
		_tmp42_ = string_get_data (_tmp41_, &_tmp42__length1);
		_tmp43_ = _tmp42_;
		_tmp43__length1 = _tmp42__length1;
		g_file_replace_contents (_tmp40_, _tmp43_, (gsize) _tmp43__length1, NULL, FALSE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parent);
			_g_object_unref0 (file);
			_g_free0 (key_file_data);
			_g_key_file_free0 (key_file);
			goto __catch38_g_error;
		}
		_g_object_unref0 (parent);
		_g_object_unref0 (file);
		_g_free0 (key_file_data);
		_g_key_file_free0 (key_file);
	}
	goto __finally38;
	__catch38_g_error:
	{
		GError* e = NULL;
		GError* _tmp44_;
		const gchar* _tmp45_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp44_ = e;
		_tmp45_ = _tmp44_->message;
		g_warning ("templates.vala:492: Impossible to save the templates: %s", _tmp45_);
		_g_error_free0 (e);
	}
	__finally38:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (model);
		icons = (_vala_array_free (icons, icons_length1, (GDestroyNotify) g_free), NULL);
		names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (model);
	icons = (_vala_array_free (icons, icons_length1, (GDestroyNotify) g_free), NULL);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
}


static void templates_save_contents (Templates* self) {
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* model;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_ = {0};
	gboolean _tmp7_ = FALSE;
	gboolean valid_iter;
	gint i;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->rc_dir;
	_tmp1_ = g_strdup_printf ("rm -f %s/*.tex", _tmp0_);
	_tmp2_ = _tmp1_;
	system (_tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->personal_store;
	_tmp4_ = _g_object_ref0 (GTK_TREE_MODEL (_tmp3_));
	model = _tmp4_;
	_tmp5_ = model;
	_tmp7_ = gtk_tree_model_get_iter_first (_tmp5_, &_tmp6_);
	iter = _tmp6_;
	valid_iter = _tmp7_;
	i = 0;
	while (TRUE) {
		gboolean _tmp8_;
		gchar* contents = NULL;
		GtkTreeModel* _tmp9_;
		GtkTreeIter _tmp10_;
		const gchar* _tmp11_;
		gint _tmp12_;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		GFile* _tmp15_ = NULL;
		GFile* _tmp16_;
		GFile* file;
		GtkTreeModel* _tmp31_;
		gboolean _tmp32_ = FALSE;
		gint _tmp33_;
		_tmp8_ = valid_iter;
		if (!_tmp8_) {
			break;
		}
		_tmp9_ = model;
		_tmp10_ = iter;
		gtk_tree_model_get (_tmp9_, &_tmp10_, TEMPLATES_TEMPLATE_COLUMN_CONTENTS, &contents, -1, -1);
		_tmp11_ = self->priv->rc_dir;
		_tmp12_ = i;
		_tmp13_ = g_strdup_printf ("%s/%d.tex", _tmp11_, _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_file_new_for_path (_tmp14_);
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp14_);
		file = _tmp16_;
		{
			GFile* _tmp17_;
			GFile* _tmp18_ = NULL;
			GFile* parent;
			gboolean _tmp19_ = FALSE;
			GFile* _tmp20_;
			gboolean _tmp23_;
			GFile* _tmp25_;
			const gchar* _tmp26_;
			guint8* _tmp27_;
			gint _tmp27__length1;
			guint8* _tmp28_;
			gint _tmp28__length1;
			_tmp17_ = file;
			_tmp18_ = g_file_get_parent (_tmp17_);
			parent = _tmp18_;
			_tmp20_ = parent;
			if (_tmp20_ != NULL) {
				GFile* _tmp21_;
				gboolean _tmp22_ = FALSE;
				_tmp21_ = parent;
				_tmp22_ = g_file_query_exists (_tmp21_, NULL);
				_tmp19_ = !_tmp22_;
			} else {
				_tmp19_ = FALSE;
			}
			_tmp23_ = _tmp19_;
			if (_tmp23_) {
				GFile* _tmp24_;
				_tmp24_ = parent;
				g_file_make_directory_with_parents (_tmp24_, NULL, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_object_unref0 (parent);
					goto __catch39_g_error;
				}
			}
			_tmp25_ = file;
			_tmp26_ = contents;
			_tmp27_ = string_get_data (_tmp26_, &_tmp27__length1);
			_tmp28_ = _tmp27_;
			_tmp28__length1 = _tmp27__length1;
			g_file_replace_contents (_tmp25_, _tmp28_, (gsize) _tmp28__length1, NULL, FALSE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (parent);
				goto __catch39_g_error;
			}
			_g_object_unref0 (parent);
		}
		goto __finally39;
		__catch39_g_error:
		{
			GError* e = NULL;
			GError* _tmp29_;
			const gchar* _tmp30_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp29_ = e;
			_tmp30_ = _tmp29_->message;
			g_warning ("templates.vala:525: Impossible to save the template: %s", _tmp30_);
			_g_error_free0 (e);
		}
		__finally39:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (file);
			_g_free0 (contents);
			_g_object_unref0 (model);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp31_ = model;
		_tmp32_ = gtk_tree_model_iter_next (_tmp31_, &iter);
		valid_iter = _tmp32_;
		_tmp33_ = i;
		i = _tmp33_ + 1;
		_g_object_unref0 (file);
		_g_free0 (contents);
	}
	_g_object_unref0 (model);
}


static gchar* templates_get_theme_icon (Templates* self, const gchar* icon_id) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (icon_id != NULL, NULL);
	_tmp0_ = icon_id;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("empty")))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup ("text-x-preview");
				result = _tmp4_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("article")))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup ("text-x-generic");
				result = _tmp5_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("report")))) {
		switch (0) {
			default:
			{
				gchar* _tmp6_;
				_tmp6_ = g_strdup ("x-office-document");
				result = _tmp6_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("book")))) {
		switch (0) {
			default:
			{
				gchar* _tmp7_;
				_tmp7_ = g_strdup ("accessories-dictionary");
				result = _tmp7_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("letter")))) {
		switch (0) {
			default:
			{
				gchar* _tmp8_;
				_tmp8_ = g_strdup ("emblem-mail");
				result = _tmp8_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("beamer")))) {
		switch (0) {
			default:
			{
				gchar* _tmp9_;
				_tmp9_ = g_strdup ("x-office-presentation");
				result = _tmp9_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_return_val_if_reached (NULL);
			}
		}
	}
}


static void templates_class_init (TemplatesClass * klass) {
	templates_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TemplatesPrivate));
	G_OBJECT_CLASS (klass)->finalize = templates_finalize;
}


static void templates_instance_init (Templates * self) {
	self->priv = TEMPLATES_GET_PRIVATE (self);
}


static void templates_finalize (GObject* obj) {
	Templates * self;
	self = TEMPLATES (obj);
	_g_object_unref0 (self->priv->default_store);
	_g_object_unref0 (self->priv->personal_store);
	_g_free0 (self->priv->rc_file);
	_g_free0 (self->priv->rc_dir);
	G_OBJECT_CLASS (templates_parent_class)->finalize (obj);
}


GType templates_get_type (void) {
	static volatile gsize templates_type_id__volatile = 0;
	if (g_once_init_enter (&templates_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TemplatesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) templates_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Templates), 0, (GInstanceInitFunc) templates_instance_init, NULL };
		GType templates_type_id;
		templates_type_id = g_type_register_static (G_TYPE_OBJECT, "Templates", &g_define_type_info, 0);
		g_once_init_leave (&templates_type_id__volatile, templates_type_id);
	}
	return templates_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



