/* document_structure.c generated by valac 0.16.1, the Vala compiler
 * generated from document_structure.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtksourceview/gtksourceview.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>


#define TYPE_DOCUMENT_STRUCTURE (document_structure_get_type ())
#define DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructure))
#define DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))
#define IS_DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_STRUCTURE))
#define IS_DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_STRUCTURE))
#define DOCUMENT_STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))

typedef struct _DocumentStructure DocumentStructure;
typedef struct _DocumentStructureClass DocumentStructureClass;
typedef struct _DocumentStructurePrivate DocumentStructurePrivate;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_STRUCTURE_MODEL (structure_model_get_type ())
#define STRUCTURE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STRUCTURE_MODEL, StructureModel))
#define STRUCTURE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STRUCTURE_MODEL, StructureModelClass))
#define IS_STRUCTURE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STRUCTURE_MODEL))
#define IS_STRUCTURE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STRUCTURE_MODEL))
#define STRUCTURE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STRUCTURE_MODEL, StructureModelClass))

typedef struct _StructureModel StructureModel;
typedef struct _StructureModelClass StructureModelClass;

#define DOCUMENT_STRUCTURE_TYPE_ENV_DATA (document_structure_env_data_get_type ())

#define TYPE_STRUCT_TYPE (struct_type_get_type ())
typedef struct _DocumentStructureEnvData DocumentStructureEnvData;

#define DOCUMENT_STRUCTURE_TYPE_LOW_LEVEL_TYPE (document_structure_low_level_type_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _document_structure_env_data_free0(var) ((var == NULL) ? NULL : (var = (document_structure_env_data_free (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

#define TYPE_STRUCT_DATA (struct_data_get_type ())
typedef struct _StructData StructData;

#define TYPE_STRUCT_ACTION (struct_action_get_type ())

#define TYPE_STRUCT_COLUMN (struct_column_get_type ())

struct _DocumentStructure {
	GObject parent_instance;
	DocumentStructurePrivate * priv;
};

struct _DocumentStructureClass {
	GObjectClass parent_class;
};

typedef enum  {
	STRUCT_TYPE_PART,
	STRUCT_TYPE_CHAPTER,
	STRUCT_TYPE_SECTION,
	STRUCT_TYPE_SUBSECTION,
	STRUCT_TYPE_SUBSUBSECTION,
	STRUCT_TYPE_PARAGRAPH,
	STRUCT_TYPE_SUBPARAGRAPH,
	STRUCT_TYPE_LABEL,
	STRUCT_TYPE_INCLUDE,
	STRUCT_TYPE_IMAGE,
	STRUCT_TYPE_TODO,
	STRUCT_TYPE_FIXME,
	STRUCT_TYPE_NB_COMMON_TYPES,
	STRUCT_TYPE_TABLE,
	STRUCT_TYPE_FIGURE,
	STRUCT_TYPE_NB_TYPES
} StructType;

struct _DocumentStructureEnvData {
	GtkTreePath* path;
	StructType type;
	gchar* first_caption;
};

struct _DocumentStructurePrivate {
	Document* _doc;
	gint _nb_marks;
	GtkTextMark* _end_document_mark;
	StructureModel* _model;
	gboolean _in_verbatim_env;
	DocumentStructureEnvData* _last_env_data;
	gint _start_parsing_line;
	GTimer* _timer;
	gboolean _parsing_done;
};

typedef enum  {
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_PART,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_CHAPTER,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_SECTION,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_SUBSECTION,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_SUBSUBSECTION,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_PARAGRAPH,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_SUBPARAGRAPH,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_LABEL,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_INCLUDE,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_IMAGE,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_TODO,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_FIXME,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_NB_COMMON_TYPES,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_FIGURE,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_FIGURE,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_TABLE,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_TABLE,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_VERBATIM,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_VERBATIM,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_DOCUMENT,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_CAPTION
} DocumentStructureLowLevelType;

struct _StructData {
	StructType type;
	gchar* text;
	GtkTextMark* start_mark;
	GtkTextMark* end_mark;
};

typedef enum  {
	STRUCT_ACTION_CUT,
	STRUCT_ACTION_COPY,
	STRUCT_ACTION_DELETE,
	STRUCT_ACTION_SELECT,
	STRUCT_ACTION_COMMENT,
	STRUCT_ACTION_SHIFT_LEFT,
	STRUCT_ACTION_SHIFT_RIGHT,
	STRUCT_ACTION_NB_ACTIONS
} StructAction;

typedef enum  {
	STRUCT_ERROR_GENERAL,
	STRUCT_ERROR_DATA_OUTDATED
} StructError;
#define STRUCT_ERROR struct_error_quark ()
typedef enum  {
	STRUCT_COLUMN_PIXBUF,
	STRUCT_COLUMN_TEXT,
	STRUCT_COLUMN_TOOLTIP,
	STRUCT_COLUMN_START_MARK,
	STRUCT_COLUMN_END_MARK,
	STRUCT_COLUMN_TYPE,
	STRUCT_COLUMN_N_COLUMNS
} StructColumn;


static gpointer document_structure_parent_class = NULL;
static GRegex* document_structure__chars_regex;
static GRegex* document_structure__chars_regex = NULL;
static GRegex* document_structure__comment_regex;
static GRegex* document_structure__comment_regex = NULL;
static GRegex* document_structure__command_name_regex;
static GRegex* document_structure__command_name_regex = NULL;
static gchar** document_structure__section_names;
static gint document_structure__section_names_length1;
static gchar** document_structure__section_names = NULL;
static gint document_structure__section_names_length1 = 0;
static gint _document_structure__section_names_size_ = 0;

GType document_structure_get_type (void) G_GNUC_CONST;
GType document_get_type (void) G_GNUC_CONST;
GType structure_model_get_type (void) G_GNUC_CONST;
static GType document_structure_env_data_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType struct_type_get_type (void) G_GNUC_CONST;
static DocumentStructureEnvData* document_structure_env_data_dup (const DocumentStructureEnvData* self);
static void document_structure_env_data_free (DocumentStructureEnvData* self);
static void document_structure_env_data_copy (const DocumentStructureEnvData* self, DocumentStructureEnvData* dest);
static void document_structure_env_data_destroy (DocumentStructureEnvData* self);
#define DOCUMENT_STRUCTURE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DOCUMENT_STRUCTURE, DocumentStructurePrivate))
enum  {
	DOCUMENT_STRUCTURE_DUMMY_PROPERTY,
	DOCUMENT_STRUCTURE_PARSING_DONE
};
static GType document_structure_low_level_type_get_type (void) G_GNUC_UNUSED;
#define DOCUMENT_STRUCTURE_MARK_NAME_PREFIX "struct_item_"
#define DOCUMENT_STRUCTURE_ITEM_MAX_LENGTH 60
#define DOCUMENT_STRUCTURE_MAX_NB_LINES_TO_PARSE 2000
#define DOCUMENT_STRUCTURE__measure_parsing_time FALSE
DocumentStructure* document_structure_new (Document* doc);
DocumentStructure* document_structure_construct (GType object_type, Document* doc);
void document_structure_parse (DocumentStructure* self);
static void document_structure_set_parsing_done (DocumentStructure* self, gboolean value);
StructureModel* structure_model_new (void);
StructureModel* structure_model_construct (GType object_type);
static void document_structure_clear_all_structure_marks (DocumentStructure* self);
static gboolean __lambda119_ (DocumentStructure* self);
static gboolean document_structure_parse_impl (DocumentStructure* self);
static gboolean ___lambda119__gsource_func (gpointer self);
StructureModel* document_structure_get_model (DocumentStructure* self);
static gchar* document_structure_get_document_line_contents (DocumentStructure* self, gint line_num);
static gboolean document_structure_search_low_level_item (DocumentStructure* self, const gchar* line, gint start_index, DocumentStructureLowLevelType** type, gchar** contents, gint** start_match_index, gint** end_match_index);
static void document_structure_handle_item (DocumentStructure* self, DocumentStructureLowLevelType type, const gchar* contents, GtkTextIter* iter);
static gint* _int_dup (gint* self);
gboolean utils_char_is_escaped (const gchar* text, glong char_index);
static gboolean document_structure_search_markup (DocumentStructure* self, const gchar* line, gint after_backslash_index, DocumentStructureLowLevelType** type, gchar** contents, gint** end_match_index);
static gboolean document_structure_search_comment (DocumentStructure* self, const gchar* line, gint after_percent_index, DocumentStructureLowLevelType** type, gchar** contents, gint** end_match_index);
static gchar* document_structure_get_markup_name (DocumentStructure* self, const gchar* line, gint after_backslash_index, gint** begin_contents_index);
static gboolean document_structure_search_env (DocumentStructure* self, const gchar* line, gint begin_contents_index, gboolean is_begin_env, DocumentStructureLowLevelType** type, gint** end_match_index);
static DocumentStructureLowLevelType* document_structure_get_markup_low_level_type (DocumentStructure* self, const gchar* markup_name);
static gchar* document_structure_get_markup_contents (DocumentStructure* self, const gchar* line, gint begin_contents_index, gint** end_match_index);
static DocumentStructureLowLevelType* _document_structure_low_level_type_dup (DocumentStructureLowLevelType* self);
static gboolean document_structure_search_firt_non_optional_arg (DocumentStructure* self, const gchar* line, gint start_index, gint* begin_contents_index);
static gchar* document_structure_truncate (DocumentStructure* self, const gchar* text);
static GtkTreeIter* document_structure_add_item (DocumentStructure* self, StructType type, const gchar* text, GtkTextIter* start_iter);
static void document_structure_create_new_environment (DocumentStructure* self, DocumentStructureLowLevelType type, GtkTextIter* start_iter);
static gboolean document_structure_verify_end_environment_type (DocumentStructure* self, DocumentStructureLowLevelType type);
static GtkTextMark* document_structure_create_text_mark_from_iter (DocumentStructure* self, GtkTextIter* iter);
void structure_model_modify_data (StructureModel* self, GtkTreePath* path, const gchar* text, GtkTextMark* end_mark);
GType struct_data_get_type (void) G_GNUC_CONST;
StructData* struct_data_dup (const StructData* self);
void struct_data_free (StructData* self);
void struct_data_copy (const StructData* self, StructData* dest);
void struct_data_destroy (StructData* self);
static GtkTreeIter* document_structure_add_item_data (DocumentStructure* self, StructData* data);
GtkTreeIter* structure_model_add_item_at_end (StructureModel* self, StructData* item);
GType struct_action_get_type (void) G_GNUC_CONST;
GQuark struct_error_quark (void);
void document_structure_do_action (DocumentStructure* self, StructAction action_type, GtkTreeIter* tree_iter, gboolean* refresh_simple_list, GError** error);
static gboolean document_structure_comment_item (DocumentStructure* self, GtkTreeIter* tree_iter);
void structure_model_delete (StructureModel* self, GtkTreeIter* iter);
gboolean structure_model_item_contains_subparagraph (StructureModel* self, GtkTreeIter* iter);
static gboolean document_structure_shift_item (DocumentStructure* self, GtkTreeIter* tree_iter, gboolean shift_right, gboolean* doc_modified);
void structure_model_shift_right (StructureModel* self, GtkTreeIter* iter);
void structure_model_shift_left (StructureModel* self, GtkTreeIter* iter);
static gboolean document_structure_get_exact_item_bounds (DocumentStructure* self, GtkTreeIter* tree_iter, GtkTextIter* start_iter, GtkTextIter* end_iter);
static void document_structure_backward_indentation (DocumentStructure* self, GtkTextIter* iter);
GType struct_column_get_type (void) G_GNUC_CONST;
gboolean structure_is_section (StructType type);
void document_comment_between (Document* self, GtkTextIter* start_iter, GtkTextIter* end_iter, gboolean end_iter_set);
GtkTreeIter* structure_model_get_next_sibling_or_parent (StructureModel* self, GtkTreeIter* section_iter, GError** error);
static void document_structure_get_end_document_iter (DocumentStructure* self, gboolean* end_of_file, GtkTextIter* result);
static gboolean document_structure_get_low_level_item_bounds (DocumentStructure* self, StructType item_type, const gchar* item_contents, GtkTextIter* start_match_iter, gboolean is_start, GtkTextIter* end_match_iter);
static gboolean document_structure_same_items (DocumentStructure* self, StructType item_type, const gchar* item_contents, DocumentStructureLowLevelType item_found_type, const gchar* item_found_contents, gboolean start);
static gchar* document_structure_get_section_name_from_type (DocumentStructure* self, StructType type);
void document_insert (Document* self, GtkTextIter* iter, const gchar* text, gint len);
gboolean document_structure_get_parsing_done (DocumentStructure* self);
static void document_structure_finalize (GObject* obj);
static void _vala_document_structure_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_document_structure_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static GType document_structure_low_level_type_get_type (void) {
	static volatile gsize document_structure_low_level_type_type_id__volatile = 0;
	if (g_once_init_enter (&document_structure_low_level_type_type_id__volatile)) {
		static const GEnumValue values[] = {{DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_PART, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_PART", "part"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_CHAPTER, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_CHAPTER", "chapter"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_SECTION, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_SECTION", "section"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_SUBSECTION, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_SUBSECTION", "subsection"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_SUBSUBSECTION, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_SUBSUBSECTION", "subsubsection"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_PARAGRAPH, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_PARAGRAPH", "paragraph"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_SUBPARAGRAPH, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_SUBPARAGRAPH", "subparagraph"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_LABEL, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_LABEL", "label"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_INCLUDE, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_INCLUDE", "include"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_IMAGE, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_IMAGE", "image"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_TODO, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_TODO", "todo"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_FIXME, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_FIXME", "fixme"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_NB_COMMON_TYPES, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_NB_COMMON_TYPES", "nb-common-types"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_FIGURE, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_FIGURE", "begin-figure"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_FIGURE, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_FIGURE", "end-figure"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_TABLE, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_TABLE", "begin-table"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_TABLE, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_TABLE", "end-table"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_VERBATIM, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_VERBATIM", "begin-verbatim"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_VERBATIM, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_VERBATIM", "end-verbatim"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_DOCUMENT, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_DOCUMENT", "end-document"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_CAPTION, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_CAPTION", "caption"}, {0, NULL, NULL}};
		GType document_structure_low_level_type_type_id;
		document_structure_low_level_type_type_id = g_enum_register_static ("DocumentStructureLowLevelType", values);
		g_once_init_leave (&document_structure_low_level_type_type_id__volatile, document_structure_low_level_type_type_id);
	}
	return document_structure_low_level_type_type_id__volatile;
}


DocumentStructure* document_structure_construct (GType object_type, Document* doc) {
	DocumentStructure * self = NULL;
	Document* _tmp0_;
	GRegex* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (doc != NULL, NULL);
	self = (DocumentStructure*) g_object_new (object_type, NULL);
	_tmp0_ = doc;
	self->priv->_doc = _tmp0_;
	_tmp1_ = document_structure__chars_regex;
	if (_tmp1_ != NULL) {
		return self;
	}
	{
		GRegex* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		GRegex* _tmp7_;
		_tmp2_ = g_regex_new ("\\\\|%", 0, 0, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch48_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (document_structure__chars_regex);
		document_structure__chars_regex = _tmp3_;
		_tmp4_ = g_regex_new ("^(?P<type>TODO|FIXME)\\s+:?\\s*(?P<text>.*)$", G_REGEX_OPTIMIZE, 0, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch48_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (document_structure__comment_regex);
		document_structure__comment_regex = _tmp5_;
		_tmp6_ = g_regex_new ("^(?P<name>[a-z]+\\*?)\\s*(\\[|{)", G_REGEX_OPTIMIZE, 0, &_inner_error_);
		_tmp7_ = _tmp6_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch48_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (document_structure__command_name_regex);
		document_structure__command_name_regex = _tmp7_;
	}
	goto __finally48;
	__catch48_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("document_structure.vala:111: Structure: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally48:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


DocumentStructure* document_structure_new (Document* doc) {
	return document_structure_construct (TYPE_DOCUMENT_STRUCTURE, doc);
}


static gboolean __lambda119_ (DocumentStructure* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	_tmp0_ = document_structure_parse_impl (self);
	result = _tmp0_;
	return result;
}


static gboolean ___lambda119__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda119_ (self);
	return result;
}


void document_structure_parse (DocumentStructure* self) {
	StructureModel* _tmp0_;
	g_return_if_fail (self != NULL);
	document_structure_set_parsing_done (self, FALSE);
	_tmp0_ = structure_model_new ();
	_g_object_unref0 (self->priv->_model);
	self->priv->_model = _tmp0_;
	_document_structure_env_data_free0 (self->priv->_last_env_data);
	self->priv->_last_env_data = NULL;
	self->priv->_start_parsing_line = 0;
	_g_object_unref0 (self->priv->_end_document_mark);
	self->priv->_end_document_mark = NULL;
	document_structure_clear_all_structure_marks (self);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda119__gsource_func, g_object_ref (self), g_object_unref);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


StructureModel* document_structure_get_model (DocumentStructure* self) {
	StructureModel* result = NULL;
	StructureModel* _tmp0_;
	StructureModel* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_model;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/*************************************************************************/
static gboolean document_structure_parse_impl (DocumentStructure* self) {
	gboolean result = FALSE;
	gint _tmp3_;
	gint cur_line;
	Document* _tmp4_;
	gint _tmp5_ = 0;
	gint nb_lines;
	gint _tmp6_;
	gint stop_parsing_line;
	g_return_val_if_fail (self != NULL, FALSE);
	if (DOCUMENT_STRUCTURE__measure_parsing_time) {
		GTimer* _tmp0_;
		_tmp0_ = self->priv->_timer;
		if (_tmp0_ == NULL) {
			GTimer* _tmp1_;
			_tmp1_ = g_timer_new ();
			_g_timer_destroy0 (self->priv->_timer);
			self->priv->_timer = _tmp1_;
		} else {
			GTimer* _tmp2_;
			_tmp2_ = self->priv->_timer;
			g_timer_continue (_tmp2_);
		}
	}
	_tmp3_ = self->priv->_start_parsing_line;
	cur_line = _tmp3_;
	_tmp4_ = self->priv->_doc;
	_tmp5_ = gtk_text_buffer_get_line_count ((GtkTextBuffer*) _tmp4_);
	nb_lines = _tmp5_;
	_tmp6_ = self->priv->_start_parsing_line;
	stop_parsing_line = _tmp6_ + DOCUMENT_STRUCTURE_MAX_NB_LINES_TO_PARSE;
	while (TRUE) {
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _tmp13_;
		gchar* _tmp14_ = NULL;
		gchar* line;
		gint start_index;
		const gchar* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint line_length;
		gint _tmp36_;
		_tmp7_ = cur_line;
		_tmp8_ = nb_lines;
		if (!(_tmp7_ < _tmp8_)) {
			break;
		}
		_tmp9_ = cur_line;
		_tmp10_ = stop_parsing_line;
		if (_tmp9_ == _tmp10_) {
			gint _tmp11_;
			_tmp11_ = cur_line;
			self->priv->_start_parsing_line = _tmp11_;
			if (DOCUMENT_STRUCTURE__measure_parsing_time) {
				GTimer* _tmp12_;
				_tmp12_ = self->priv->_timer;
				g_timer_stop (_tmp12_);
			}
			result = TRUE;
			return result;
		}
		_tmp13_ = cur_line;
		_tmp14_ = document_structure_get_document_line_contents (self, _tmp13_);
		line = _tmp14_;
		start_index = 0;
		_tmp15_ = line;
		_tmp16_ = strlen (_tmp15_);
		_tmp17_ = _tmp16_;
		line_length = _tmp17_;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			DocumentStructureLowLevelType* type = NULL;
			gchar* contents = NULL;
			gint* start_match_index = NULL;
			gint* end_match_index = NULL;
			const gchar* _tmp20_;
			gint _tmp21_;
			DocumentStructureLowLevelType* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			gint* _tmp24_ = NULL;
			gint* _tmp25_ = NULL;
			gboolean _tmp26_ = FALSE;
			gboolean item_found;
			gboolean _tmp27_;
			GtkTextIter iter = {0};
			Document* _tmp28_;
			gint _tmp29_;
			gint* _tmp30_;
			GtkTextIter _tmp31_ = {0};
			DocumentStructureLowLevelType* _tmp32_;
			const gchar* _tmp33_;
			GtkTextIter _tmp34_;
			gint* _tmp35_;
			_tmp18_ = start_index;
			_tmp19_ = line_length;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = line;
			_tmp21_ = start_index;
			_tmp26_ = document_structure_search_low_level_item (self, _tmp20_, _tmp21_, &_tmp22_, &_tmp23_, &_tmp24_, &_tmp25_);
			_g_free0 (type);
			type = _tmp22_;
			_g_free0 (contents);
			contents = _tmp23_;
			_g_free0 (start_match_index);
			start_match_index = _tmp24_;
			_g_free0 (end_match_index);
			end_match_index = _tmp25_;
			item_found = _tmp26_;
			_tmp27_ = item_found;
			if (!_tmp27_) {
				_g_free0 (end_match_index);
				_g_free0 (start_match_index);
				_g_free0 (contents);
				_g_free0 (type);
				break;
			}
			_tmp28_ = self->priv->_doc;
			_tmp29_ = cur_line;
			_tmp30_ = start_match_index;
			gtk_text_buffer_get_iter_at_line_index ((GtkTextBuffer*) _tmp28_, &_tmp31_, _tmp29_, *_tmp30_);
			iter = _tmp31_;
			_tmp32_ = type;
			_tmp33_ = contents;
			_tmp34_ = iter;
			document_structure_handle_item (self, *_tmp32_, _tmp33_, &_tmp34_);
			_tmp35_ = end_match_index;
			start_index = *_tmp35_;
			_g_free0 (end_match_index);
			_g_free0 (start_match_index);
			_g_free0 (contents);
			_g_free0 (type);
		}
		_tmp36_ = cur_line;
		cur_line = _tmp36_ + 1;
		_g_free0 (line);
	}
	if (DOCUMENT_STRUCTURE__measure_parsing_time) {
		GTimer* _tmp37_;
		GTimer* _tmp38_;
		gdouble _tmp39_ = 0.0;
		GTimer* _tmp40_;
		_tmp37_ = self->priv->_timer;
		g_timer_stop (_tmp37_);
		_tmp38_ = self->priv->_timer;
		_tmp39_ = g_timer_elapsed (_tmp38_, NULL);
		g_message ("document_structure.vala:203: Structure parsing took %f seconds", _tmp39_);
		_tmp40_ = self->priv->_timer;
		g_timer_reset (_tmp40_);
	}
	document_structure_set_parsing_done (self, TRUE);
	result = FALSE;
	return result;
}


static gint* _int_dup (gint* self) {
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}


static gpointer __int_dup0 (gpointer self) {
	return self ? _int_dup (self) : NULL;
}


static gboolean document_structure_search_low_level_item (DocumentStructure* self, const gchar* line, gint start_index, DocumentStructureLowLevelType** type, gchar** contents, gint** start_match_index, gint** end_match_index) {
	DocumentStructureLowLevelType* _vala_type = NULL;
	gchar* _vala_contents = NULL;
	gint* _vala_start_match_index = NULL;
	gint* _vala_end_match_index = NULL;
	gboolean result = FALSE;
	GMatchInfo* match_info = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_g_free0 (_vala_type);
	_vala_type = NULL;
	_g_free0 (_vala_contents);
	_vala_contents = NULL;
	_g_free0 (_vala_start_match_index);
	_vala_start_match_index = NULL;
	_g_free0 (_vala_end_match_index);
	_vala_end_match_index = NULL;
	{
		GRegex* _tmp0_;
		const gchar* _tmp1_;
		gint _tmp2_;
		GMatchInfo* _tmp3_ = NULL;
		_tmp0_ = document_structure__chars_regex;
		_tmp1_ = line;
		_tmp2_ = start_index;
		g_regex_match_full (_tmp0_, _tmp1_, (gssize) (-1), _tmp2_, 0, &_tmp3_, &_inner_error_);
		_g_match_info_free0 (match_info);
		match_info = _tmp3_;
		if (_inner_error_ != NULL) {
			goto __catch49_g_error;
		}
	}
	goto __finally49;
	__catch49_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("document_structure.vala:235: Structure parsing: chars regex: %s", _tmp5_);
		result = FALSE;
		_g_error_free0 (e);
		_g_match_info_free0 (match_info);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (contents) {
			*contents = _vala_contents;
		} else {
			_g_free0 (_vala_contents);
		}
		if (start_match_index) {
			*start_match_index = _vala_start_match_index;
		} else {
			_g_free0 (_vala_start_match_index);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	__finally49:
	if (_inner_error_ != NULL) {
		_g_match_info_free0 (match_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	while (TRUE) {
		GMatchInfo* _tmp6_;
		gboolean _tmp7_ = FALSE;
		gint after_char_index = 0;
		GMatchInfo* _tmp8_;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gboolean _tmp11_ = FALSE;
		gint _tmp12_;
		gint* _tmp13_;
		const gchar* _tmp14_;
		gint* _tmp15_;
		gboolean _tmp16_ = FALSE;
		_tmp6_ = match_info;
		_tmp7_ = g_match_info_matches (_tmp6_);
		if (!_tmp7_) {
			break;
		}
		_tmp8_ = match_info;
		_tmp11_ = g_match_info_fetch_pos (_tmp8_, 0, &_tmp9_, &_tmp10_);
		_g_free0 (_vala_start_match_index);
		_tmp12_ = _tmp9_;
		_tmp13_ = __int_dup0 (&_tmp12_);
		_vala_start_match_index = _tmp13_;
		after_char_index = _tmp10_;
		if (!_tmp11_) {
			g_warning ("document_structure.vala:244: Structure parsing: position can not be fe" \
"tched");
			result = FALSE;
			_g_match_info_free0 (match_info);
			if (type) {
				*type = _vala_type;
			} else {
				_g_free0 (_vala_type);
			}
			if (contents) {
				*contents = _vala_contents;
			} else {
				_g_free0 (_vala_contents);
			}
			if (start_match_index) {
				*start_match_index = _vala_start_match_index;
			} else {
				_g_free0 (_vala_start_match_index);
			}
			if (end_match_index) {
				*end_match_index = _vala_end_match_index;
			} else {
				_g_free0 (_vala_end_match_index);
			}
			return result;
		}
		_tmp14_ = line;
		_tmp15_ = _vala_start_match_index;
		_tmp16_ = utils_char_is_escaped (_tmp14_, *_tmp15_);
		if (!_tmp16_) {
			GMatchInfo* _tmp17_;
			gchar* _tmp18_ = NULL;
			gchar* char_matched;
			const gchar* _tmp19_;
			_tmp17_ = match_info;
			_tmp18_ = g_match_info_fetch (_tmp17_, 0);
			char_matched = _tmp18_;
			_tmp19_ = char_matched;
			if (g_strcmp0 (_tmp19_, "\\") == 0) {
				const gchar* _tmp20_;
				gint _tmp21_;
				DocumentStructureLowLevelType* _tmp22_ = NULL;
				gchar* _tmp23_ = NULL;
				gint* _tmp24_ = NULL;
				gboolean _tmp25_ = FALSE;
				gboolean markup_found;
				gboolean _tmp26_;
				_tmp20_ = line;
				_tmp21_ = after_char_index;
				_tmp25_ = document_structure_search_markup (self, _tmp20_, _tmp21_, &_tmp22_, &_tmp23_, &_tmp24_);
				_g_free0 (_vala_type);
				_vala_type = _tmp22_;
				_g_free0 (_vala_contents);
				_vala_contents = _tmp23_;
				_g_free0 (_vala_end_match_index);
				_vala_end_match_index = _tmp24_;
				markup_found = _tmp25_;
				_tmp26_ = markup_found;
				if (_tmp26_) {
					result = TRUE;
					_g_free0 (char_matched);
					_g_match_info_free0 (match_info);
					if (type) {
						*type = _vala_type;
					} else {
						_g_free0 (_vala_type);
					}
					if (contents) {
						*contents = _vala_contents;
					} else {
						_g_free0 (_vala_contents);
					}
					if (start_match_index) {
						*start_match_index = _vala_start_match_index;
					} else {
						_g_free0 (_vala_start_match_index);
					}
					if (end_match_index) {
						*end_match_index = _vala_end_match_index;
					} else {
						_g_free0 (_vala_end_match_index);
					}
					return result;
				}
			} else {
				const gchar* _tmp27_;
				gint _tmp28_;
				DocumentStructureLowLevelType* _tmp29_ = NULL;
				gchar* _tmp30_ = NULL;
				gint* _tmp31_ = NULL;
				gboolean _tmp32_ = FALSE;
				_tmp27_ = line;
				_tmp28_ = after_char_index;
				_tmp32_ = document_structure_search_comment (self, _tmp27_, _tmp28_, &_tmp29_, &_tmp30_, &_tmp31_);
				_g_free0 (_vala_type);
				_vala_type = _tmp29_;
				_g_free0 (_vala_contents);
				_vala_contents = _tmp30_;
				_g_free0 (_vala_end_match_index);
				_vala_end_match_index = _tmp31_;
				result = _tmp32_;
				_g_free0 (char_matched);
				_g_match_info_free0 (match_info);
				if (type) {
					*type = _vala_type;
				} else {
					_g_free0 (_vala_type);
				}
				if (contents) {
					*contents = _vala_contents;
				} else {
					_g_free0 (_vala_contents);
				}
				if (start_match_index) {
					*start_match_index = _vala_start_match_index;
				} else {
					_g_free0 (_vala_start_match_index);
				}
				if (end_match_index) {
					*end_match_index = _vala_end_match_index;
				} else {
					_g_free0 (_vala_end_match_index);
				}
				return result;
			}
			_g_free0 (char_matched);
		}
		{
			GMatchInfo* _tmp33_;
			_tmp33_ = match_info;
			g_match_info_next (_tmp33_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch50_g_regex_error;
				}
				_g_match_info_free0 (match_info);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		goto __finally50;
		__catch50_g_regex_error:
		{
			GError* e = NULL;
			GError* _tmp34_;
			const gchar* _tmp35_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp34_ = e;
			_tmp35_ = _tmp34_->message;
			g_warning ("document_structure.vala:280: Structure parsing: %s", _tmp35_);
			_g_error_free0 (e);
			break;
		}
		__finally50:
		if (_inner_error_ != NULL) {
			_g_match_info_free0 (match_info);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = FALSE;
	_g_match_info_free0 (match_info);
	if (type) {
		*type = _vala_type;
	} else {
		_g_free0 (_vala_type);
	}
	if (contents) {
		*contents = _vala_contents;
	} else {
		_g_free0 (_vala_contents);
	}
	if (start_match_index) {
		*start_match_index = _vala_start_match_index;
	} else {
		_g_free0 (_vala_start_match_index);
	}
	if (end_match_index) {
		*end_match_index = _vala_end_match_index;
	} else {
		_g_free0 (_vala_end_match_index);
	}
	return result;
}


static gboolean document_structure_search_markup (DocumentStructure* self, const gchar* line, gint after_backslash_index, DocumentStructureLowLevelType** type, gchar** contents, gint** end_match_index) {
	DocumentStructureLowLevelType* _vala_type = NULL;
	gchar* _vala_contents = NULL;
	gint* _vala_end_match_index = NULL;
	gboolean result = FALSE;
	gint* begin_contents_index = NULL;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* name;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean is_begin_env;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_;
	gboolean _tmp9_;
	const gchar* _tmp16_;
	DocumentStructureLowLevelType* _tmp17_ = NULL;
	DocumentStructureLowLevelType* _tmp18_;
	const gchar* _tmp19_;
	gint* _tmp20_;
	gint* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	const gchar* _tmp23_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_g_free0 (_vala_type);
	_vala_type = NULL;
	_g_free0 (_vala_contents);
	_vala_contents = NULL;
	_g_free0 (_vala_end_match_index);
	_vala_end_match_index = NULL;
	_tmp0_ = line;
	_tmp1_ = after_backslash_index;
	_tmp3_ = document_structure_get_markup_name (self, _tmp0_, _tmp1_, &_tmp2_);
	_g_free0 (begin_contents_index);
	begin_contents_index = _tmp2_;
	name = _tmp3_;
	_tmp4_ = name;
	if (_tmp4_ == NULL) {
		result = FALSE;
		_g_free0 (name);
		_g_free0 (begin_contents_index);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (contents) {
			*contents = _vala_contents;
		} else {
			_g_free0 (_vala_contents);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	_tmp5_ = name;
	is_begin_env = g_strcmp0 (_tmp5_, "begin") == 0;
	_tmp7_ = is_begin_env;
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		const gchar* _tmp8_;
		_tmp8_ = name;
		_tmp6_ = g_strcmp0 (_tmp8_, "end") == 0;
	}
	_tmp9_ = _tmp6_;
	if (_tmp9_) {
		const gchar* _tmp10_;
		gint* _tmp11_;
		gboolean _tmp12_;
		DocumentStructureLowLevelType* _tmp13_ = NULL;
		gint* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		_g_free0 (_vala_contents);
		_vala_contents = NULL;
		_tmp10_ = line;
		_tmp11_ = begin_contents_index;
		_tmp12_ = is_begin_env;
		_tmp15_ = document_structure_search_env (self, _tmp10_, *_tmp11_, _tmp12_, &_tmp13_, &_tmp14_);
		_g_free0 (_vala_type);
		_vala_type = _tmp13_;
		_g_free0 (_vala_end_match_index);
		_vala_end_match_index = _tmp14_;
		result = _tmp15_;
		_g_free0 (name);
		_g_free0 (begin_contents_index);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (contents) {
			*contents = _vala_contents;
		} else {
			_g_free0 (_vala_contents);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	_tmp16_ = name;
	_tmp17_ = document_structure_get_markup_low_level_type (self, _tmp16_);
	_g_free0 (_vala_type);
	_vala_type = _tmp17_;
	_tmp18_ = _vala_type;
	if (_tmp18_ == NULL) {
		result = FALSE;
		_g_free0 (name);
		_g_free0 (begin_contents_index);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (contents) {
			*contents = _vala_contents;
		} else {
			_g_free0 (_vala_contents);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	_tmp19_ = line;
	_tmp20_ = begin_contents_index;
	_tmp22_ = document_structure_get_markup_contents (self, _tmp19_, *_tmp20_, &_tmp21_);
	_g_free0 (_vala_end_match_index);
	_vala_end_match_index = _tmp21_;
	_g_free0 (_vala_contents);
	_vala_contents = _tmp22_;
	_tmp23_ = _vala_contents;
	result = _tmp23_ != NULL;
	_g_free0 (name);
	_g_free0 (begin_contents_index);
	if (type) {
		*type = _vala_type;
	} else {
		_g_free0 (_vala_type);
	}
	if (contents) {
		*contents = _vala_contents;
	} else {
		_g_free0 (_vala_contents);
	}
	if (end_match_index) {
		*end_match_index = _vala_end_match_index;
	} else {
		_g_free0 (_vala_end_match_index);
	}
	return result;
}


static DocumentStructureLowLevelType* _document_structure_low_level_type_dup (DocumentStructureLowLevelType* self) {
	DocumentStructureLowLevelType* dup;
	dup = g_new0 (DocumentStructureLowLevelType, 1);
	memcpy (dup, self, sizeof (DocumentStructureLowLevelType));
	return dup;
}


static gpointer __document_structure_low_level_type_dup0 (gpointer self) {
	return self ? _document_structure_low_level_type_dup (self) : NULL;
}


static gboolean document_structure_search_env (DocumentStructure* self, const gchar* line, gint begin_contents_index, gboolean is_begin_env, DocumentStructureLowLevelType** type, gint** end_match_index) {
	DocumentStructureLowLevelType* _vala_type = NULL;
	gint* _vala_end_match_index = NULL;
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* contents;
	const gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	gboolean _tmp8_;
	const gchar* _tmp13_;
	const gchar* _tmp18_;
	gboolean _tmp23_ = FALSE;
	const gchar* _tmp24_;
	gboolean _tmp26_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_g_free0 (_vala_type);
	_vala_type = NULL;
	_tmp0_ = line;
	_tmp1_ = begin_contents_index;
	_tmp3_ = document_structure_get_markup_contents (self, _tmp0_, _tmp1_, &_tmp2_);
	_g_free0 (_vala_end_match_index);
	_vala_end_match_index = _tmp2_;
	contents = _tmp3_;
	_tmp4_ = contents;
	if (_tmp4_ == NULL) {
		result = FALSE;
		_g_free0 (contents);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	_tmp6_ = contents;
	if (g_strcmp0 (_tmp6_, "verbatim") == 0) {
		_tmp5_ = TRUE;
	} else {
		const gchar* _tmp7_;
		_tmp7_ = contents;
		_tmp5_ = g_strcmp0 (_tmp7_, "verbatim*") == 0;
	}
	_tmp8_ = _tmp5_;
	if (_tmp8_) {
		DocumentStructureLowLevelType _tmp9_ = 0;
		gboolean _tmp10_;
		DocumentStructureLowLevelType _tmp11_;
		DocumentStructureLowLevelType* _tmp12_;
		_tmp10_ = is_begin_env;
		if (_tmp10_) {
			_tmp9_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_VERBATIM;
		} else {
			_tmp9_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_VERBATIM;
		}
		_tmp11_ = _tmp9_;
		_tmp12_ = __document_structure_low_level_type_dup0 (&_tmp11_);
		_g_free0 (_vala_type);
		_vala_type = _tmp12_;
		result = TRUE;
		_g_free0 (contents);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	_tmp13_ = contents;
	if (g_strcmp0 (_tmp13_, "figure") == 0) {
		DocumentStructureLowLevelType _tmp14_ = 0;
		gboolean _tmp15_;
		DocumentStructureLowLevelType _tmp16_;
		DocumentStructureLowLevelType* _tmp17_;
		_tmp15_ = is_begin_env;
		if (_tmp15_) {
			_tmp14_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_FIGURE;
		} else {
			_tmp14_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_FIGURE;
		}
		_tmp16_ = _tmp14_;
		_tmp17_ = __document_structure_low_level_type_dup0 (&_tmp16_);
		_g_free0 (_vala_type);
		_vala_type = _tmp17_;
		result = TRUE;
		_g_free0 (contents);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	_tmp18_ = contents;
	if (g_strcmp0 (_tmp18_, "table") == 0) {
		DocumentStructureLowLevelType _tmp19_ = 0;
		gboolean _tmp20_;
		DocumentStructureLowLevelType _tmp21_;
		DocumentStructureLowLevelType* _tmp22_;
		_tmp20_ = is_begin_env;
		if (_tmp20_) {
			_tmp19_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_TABLE;
		} else {
			_tmp19_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_TABLE;
		}
		_tmp21_ = _tmp19_;
		_tmp22_ = __document_structure_low_level_type_dup0 (&_tmp21_);
		_g_free0 (_vala_type);
		_vala_type = _tmp22_;
		result = TRUE;
		_g_free0 (contents);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	_tmp24_ = contents;
	if (g_strcmp0 (_tmp24_, "document") == 0) {
		gboolean _tmp25_;
		_tmp25_ = is_begin_env;
		_tmp23_ = !_tmp25_;
	} else {
		_tmp23_ = FALSE;
	}
	_tmp26_ = _tmp23_;
	if (_tmp26_) {
		DocumentStructureLowLevelType _tmp27_;
		DocumentStructureLowLevelType* _tmp28_;
		_tmp27_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_DOCUMENT;
		_tmp28_ = __document_structure_low_level_type_dup0 (&_tmp27_);
		_g_free0 (_vala_type);
		_vala_type = _tmp28_;
		result = TRUE;
		_g_free0 (contents);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	result = FALSE;
	_g_free0 (contents);
	if (type) {
		*type = _vala_type;
	} else {
		_g_free0 (_vala_type);
	}
	if (end_match_index) {
		*end_match_index = _vala_end_match_index;
	} else {
		_g_free0 (_vala_end_match_index);
	}
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static gchar* document_structure_get_markup_name (DocumentStructure* self, const gchar* line, gint after_backslash_index, gint** begin_contents_index) {
	gint* _vala_begin_contents_index = NULL;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* after_backslash_text;
	GMatchInfo* match_info = NULL;
	GRegex* _tmp3_;
	const gchar* _tmp4_;
	GMatchInfo* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gint pos = 0;
	GMatchInfo* _tmp7_;
	gint _tmp8_ = 0;
	gint _tmp9_;
	gint _tmp10_;
	gint begin_first_arg_index;
	GMatchInfo* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* markup_name;
	const gchar* _tmp13_;
	gint _tmp14_;
	gint _tmp15_ = 0;
	gboolean _tmp16_ = FALSE;
	gint _tmp17_;
	gint* _tmp18_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	_g_free0 (_vala_begin_contents_index);
	_vala_begin_contents_index = NULL;
	_tmp0_ = line;
	_tmp1_ = after_backslash_index;
	_tmp2_ = string_substring (_tmp0_, (glong) _tmp1_, (glong) (-1));
	after_backslash_text = _tmp2_;
	_tmp3_ = document_structure__command_name_regex;
	_tmp4_ = after_backslash_text;
	_tmp6_ = g_regex_match (_tmp3_, _tmp4_, 0, &_tmp5_);
	_g_match_info_free0 (match_info);
	match_info = _tmp5_;
	if (!_tmp6_) {
		result = NULL;
		_g_match_info_free0 (match_info);
		_g_free0 (after_backslash_text);
		if (begin_contents_index) {
			*begin_contents_index = _vala_begin_contents_index;
		} else {
			_g_free0 (_vala_begin_contents_index);
		}
		return result;
	}
	_tmp7_ = match_info;
	g_match_info_fetch_pos (_tmp7_, 0, NULL, &_tmp8_);
	pos = _tmp8_;
	_tmp9_ = after_backslash_index;
	_tmp10_ = pos;
	begin_first_arg_index = _tmp9_ + _tmp10_;
	_tmp11_ = match_info;
	_tmp12_ = g_match_info_fetch_named (_tmp11_, "name");
	markup_name = _tmp12_;
	_tmp13_ = line;
	_tmp14_ = begin_first_arg_index;
	_tmp16_ = document_structure_search_firt_non_optional_arg (self, _tmp13_, _tmp14_ - 1, &_tmp15_);
	_g_free0 (_vala_begin_contents_index);
	_tmp17_ = _tmp15_;
	_tmp18_ = __int_dup0 (&_tmp17_);
	_vala_begin_contents_index = _tmp18_;
	if (_tmp16_) {
		result = markup_name;
		_g_match_info_free0 (match_info);
		_g_free0 (after_backslash_text);
		if (begin_contents_index) {
			*begin_contents_index = _vala_begin_contents_index;
		} else {
			_g_free0 (_vala_begin_contents_index);
		}
		return result;
	}
	result = NULL;
	_g_free0 (markup_name);
	_g_match_info_free0 (match_info);
	_g_free0 (after_backslash_text);
	if (begin_contents_index) {
		*begin_contents_index = _vala_begin_contents_index;
	} else {
		_g_free0 (_vala_begin_contents_index);
	}
	return result;
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_;
	gunichar _tmp1_ = 0U;
	gunichar _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	_vala_c = _tmp1_;
	_tmp2_ = _vala_c;
	if (_tmp2_ != ((gunichar) 0)) {
		gint _tmp3_;
		gchar* _tmp4_ = NULL;
		_tmp3_ = *index;
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
		*index = (gint) (_tmp4_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


static gboolean document_structure_search_firt_non_optional_arg (DocumentStructure* self, const gchar* line, gint start_index, gint* begin_contents_index) {
	gint _vala_begin_contents_index = 0;
	gboolean result = FALSE;
	gint _tmp0_;
	gint cur_index;
	gboolean in_optional_arg;
	gint additional_bracket_level;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_vala_begin_contents_index = 0;
	_tmp0_ = start_index;
	cur_index = _tmp0_;
	in_optional_arg = FALSE;
	additional_bracket_level = 0;
	while (TRUE) {
		gint _tmp1_;
		gint next_index;
		gunichar cur_char = 0U;
		const gchar* _tmp2_;
		gunichar _tmp3_ = 0U;
		gboolean _tmp4_ = FALSE;
		gboolean end;
		gboolean _tmp5_;
		gboolean _tmp18_;
		gint _tmp19_;
		_tmp1_ = cur_index;
		next_index = _tmp1_;
		_tmp2_ = line;
		_tmp4_ = string_get_next_char (_tmp2_, &next_index, &_tmp3_);
		cur_char = _tmp3_;
		end = !_tmp4_;
		_tmp5_ = in_optional_arg;
		if (_tmp5_) {
			gunichar _tmp6_;
			_tmp6_ = cur_char;
			switch (_tmp6_) {
				case ']':
				{
					const gchar* _tmp7_;
					gint _tmp8_;
					gboolean _tmp9_ = FALSE;
					_tmp7_ = line;
					_tmp8_ = cur_index;
					_tmp9_ = utils_char_is_escaped (_tmp7_, (glong) _tmp8_);
					if (!_tmp9_) {
						gint _tmp10_;
						_tmp10_ = additional_bracket_level;
						if (0 < _tmp10_) {
							gint _tmp11_;
							_tmp11_ = additional_bracket_level;
							additional_bracket_level = _tmp11_ - 1;
						} else {
							in_optional_arg = FALSE;
						}
					}
					break;
				}
				case '[':
				{
					const gchar* _tmp12_;
					gint _tmp13_;
					gboolean _tmp14_ = FALSE;
					_tmp12_ = line;
					_tmp13_ = cur_index;
					_tmp14_ = utils_char_is_escaped (_tmp12_, (glong) _tmp13_);
					if (!_tmp14_) {
						gint _tmp15_;
						_tmp15_ = additional_bracket_level;
						additional_bracket_level = _tmp15_ + 1;
					}
					break;
				}
				default:
				break;
			}
		} else {
			gunichar _tmp16_;
			_tmp16_ = cur_char;
			switch (_tmp16_) {
				case '{':
				{
					gint _tmp17_;
					_tmp17_ = next_index;
					_vala_begin_contents_index = _tmp17_;
					result = TRUE;
					if (begin_contents_index) {
						*begin_contents_index = _vala_begin_contents_index;
					}
					return result;
				}
				case '[':
				{
					in_optional_arg = TRUE;
					break;
				}
				case ' ':
				case '\t':
				{
					break;
				}
				default:
				{
					result = FALSE;
					if (begin_contents_index) {
						*begin_contents_index = _vala_begin_contents_index;
					}
					return result;
				}
			}
		}
		_tmp18_ = end;
		if (_tmp18_) {
			result = FALSE;
			if (begin_contents_index) {
				*begin_contents_index = _vala_begin_contents_index;
			}
			return result;
		}
		_tmp19_ = next_index;
		cur_index = _tmp19_;
	}
	if (begin_contents_index) {
		*begin_contents_index = _vala_begin_contents_index;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static gchar* document_structure_get_markup_contents (DocumentStructure* self, const gchar* line, gint begin_contents_index, gint** end_match_index) {
	gint* _vala_end_match_index = NULL;
	gchar* result = NULL;
	gint brace_level;
	gint _tmp0_;
	gint cur_index;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	_g_free0 (_vala_end_match_index);
	_vala_end_match_index = NULL;
	brace_level = 0;
	_tmp0_ = begin_contents_index;
	cur_index = _tmp0_;
	while (TRUE) {
		gint _tmp1_;
		gint next_index;
		gunichar cur_char = 0U;
		const gchar* _tmp2_;
		gunichar _tmp3_ = 0U;
		gboolean _tmp4_ = FALSE;
		gboolean end;
		gboolean _tmp5_ = FALSE;
		gunichar _tmp6_;
		gboolean _tmp10_;
		gboolean _tmp27_;
		gint _tmp28_;
		_tmp1_ = cur_index;
		next_index = _tmp1_;
		_tmp2_ = line;
		_tmp4_ = string_get_next_char (_tmp2_, &next_index, &_tmp3_);
		cur_char = _tmp3_;
		end = !_tmp4_;
		_tmp6_ = cur_char;
		if (_tmp6_ == ((gunichar) '{')) {
			const gchar* _tmp7_;
			gint _tmp8_;
			gboolean _tmp9_ = FALSE;
			_tmp7_ = line;
			_tmp8_ = cur_index;
			_tmp9_ = utils_char_is_escaped (_tmp7_, (glong) _tmp8_);
			_tmp5_ = !_tmp9_;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp10_ = _tmp5_;
		if (_tmp10_) {
			gint _tmp11_;
			_tmp11_ = brace_level;
			brace_level = _tmp11_ + 1;
		} else {
			gboolean _tmp12_ = FALSE;
			gunichar _tmp13_;
			gboolean _tmp17_;
			_tmp13_ = cur_char;
			if (_tmp13_ == ((gunichar) '}')) {
				const gchar* _tmp14_;
				gint _tmp15_;
				gboolean _tmp16_ = FALSE;
				_tmp14_ = line;
				_tmp15_ = cur_index;
				_tmp16_ = utils_char_is_escaped (_tmp14_, (glong) _tmp15_);
				_tmp12_ = !_tmp16_;
			} else {
				_tmp12_ = FALSE;
			}
			_tmp17_ = _tmp12_;
			if (_tmp17_) {
				gint _tmp18_;
				_tmp18_ = brace_level;
				if (_tmp18_ > 0) {
					gint _tmp19_;
					_tmp19_ = brace_level;
					brace_level = _tmp19_ - 1;
				} else {
					const gchar* _tmp20_;
					gint _tmp21_;
					gint _tmp22_;
					gchar* _tmp23_ = NULL;
					gchar* contents;
					const gchar* _tmp24_;
					gint _tmp25_;
					gint* _tmp26_;
					_tmp20_ = line;
					_tmp21_ = begin_contents_index;
					_tmp22_ = cur_index;
					_tmp23_ = string_slice (_tmp20_, (glong) _tmp21_, (glong) _tmp22_);
					contents = _tmp23_;
					_tmp24_ = contents;
					if (g_strcmp0 (_tmp24_, "") == 0) {
						result = NULL;
						_g_free0 (contents);
						if (end_match_index) {
							*end_match_index = _vala_end_match_index;
						} else {
							_g_free0 (_vala_end_match_index);
						}
						return result;
					}
					_tmp25_ = next_index;
					_tmp26_ = __int_dup0 (&_tmp25_);
					_g_free0 (_vala_end_match_index);
					_vala_end_match_index = _tmp26_;
					result = contents;
					if (end_match_index) {
						*end_match_index = _vala_end_match_index;
					} else {
						_g_free0 (_vala_end_match_index);
					}
					return result;
				}
			}
		}
		_tmp27_ = end;
		if (_tmp27_) {
			result = NULL;
			if (end_match_index) {
				*end_match_index = _vala_end_match_index;
			} else {
				_g_free0 (_vala_end_match_index);
			}
			return result;
		}
		_tmp28_ = next_index;
		cur_index = _tmp28_;
	}
	if (end_match_index) {
		*end_match_index = _vala_end_match_index;
	} else {
		_g_free0 (_vala_end_match_index);
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gboolean document_structure_search_comment (DocumentStructure* self, const gchar* line, gint after_percent_index, DocumentStructureLowLevelType** type, gchar** contents, gint** end_match_index) {
	DocumentStructureLowLevelType* _vala_type = NULL;
	gchar* _vala_contents = NULL;
	gint* _vala_end_match_index = NULL;
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* text_after;
	GMatchInfo* match_info = NULL;
	GRegex* _tmp6_;
	const gchar* _tmp7_;
	GMatchInfo* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	GMatchInfo* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* type_str;
	DocumentStructureLowLevelType _tmp12_ = 0;
	const gchar* _tmp13_;
	DocumentStructureLowLevelType _tmp14_;
	DocumentStructureLowLevelType* _tmp15_;
	GMatchInfo* _tmp16_;
	gchar* _tmp17_ = NULL;
	const gchar* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gint* _tmp21_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_g_free0 (_vala_type);
	_vala_type = NULL;
	_g_free0 (_vala_contents);
	_vala_contents = NULL;
	_g_free0 (_vala_end_match_index);
	_vala_end_match_index = NULL;
	_tmp0_ = line;
	_tmp1_ = after_percent_index;
	_tmp2_ = string_substring (_tmp0_, (glong) _tmp1_, (glong) (-1));
	_tmp3_ = _tmp2_;
	_tmp4_ = string_strip (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	text_after = _tmp5_;
	_tmp6_ = document_structure__comment_regex;
	_tmp7_ = text_after;
	_tmp9_ = g_regex_match (_tmp6_, _tmp7_, 0, &_tmp8_);
	_g_match_info_free0 (match_info);
	match_info = _tmp8_;
	if (!_tmp9_) {
		result = FALSE;
		_g_match_info_free0 (match_info);
		_g_free0 (text_after);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (contents) {
			*contents = _vala_contents;
		} else {
			_g_free0 (_vala_contents);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	_tmp10_ = match_info;
	_tmp11_ = g_match_info_fetch_named (_tmp10_, "type");
	type_str = _tmp11_;
	_tmp13_ = type_str;
	if (g_strcmp0 (_tmp13_, "TODO") == 0) {
		_tmp12_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_TODO;
	} else {
		_tmp12_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_FIXME;
	}
	_tmp14_ = _tmp12_;
	_tmp15_ = __document_structure_low_level_type_dup0 (&_tmp14_);
	_g_free0 (_vala_type);
	_vala_type = _tmp15_;
	_tmp16_ = match_info;
	_tmp17_ = g_match_info_fetch_named (_tmp16_, "text");
	_g_free0 (_vala_contents);
	_vala_contents = _tmp17_;
	_tmp18_ = line;
	_tmp19_ = strlen (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = __int_dup0 (&_tmp20_);
	_g_free0 (_vala_end_match_index);
	_vala_end_match_index = _tmp21_;
	result = TRUE;
	_g_free0 (type_str);
	_g_match_info_free0 (match_info);
	_g_free0 (text_after);
	if (type) {
		*type = _vala_type;
	} else {
		_g_free0 (_vala_type);
	}
	if (contents) {
		*contents = _vala_contents;
	} else {
		_g_free0 (_vala_contents);
	}
	if (end_match_index) {
		*end_match_index = _vala_end_match_index;
	} else {
		_g_free0 (_vala_end_match_index);
	}
	return result;
}


static void document_structure_handle_item (DocumentStructure* self, DocumentStructureLowLevelType type, const gchar* contents, GtkTextIter* iter) {
	gboolean _tmp0_;
	gboolean _tmp2_ = FALSE;
	DocumentStructureLowLevelType _tmp3_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = self->priv->_in_verbatim_env;
	if (_tmp0_) {
		DocumentStructureLowLevelType _tmp1_;
		_tmp1_ = type;
		if (_tmp1_ == DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_VERBATIM) {
			self->priv->_in_verbatim_env = FALSE;
		}
		return;
	}
	_tmp3_ = type;
	if (_tmp3_ == DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_TODO) {
		_tmp2_ = TRUE;
	} else {
		DocumentStructureLowLevelType _tmp4_;
		_tmp4_ = type;
		_tmp2_ = _tmp4_ == DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_FIXME;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		DocumentStructureLowLevelType _tmp12_;
		const gchar* _tmp13_;
		GtkTextIter _tmp14_;
		GtkTreeIter* _tmp15_ = NULL;
		GtkTreeIter* _tmp16_;
		_tmp6_ = contents;
		_tmp7_ = document_structure_truncate (self, _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		if (_tmp9_ == NULL) {
			const gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp10_ = contents;
			_tmp11_ = g_strdup (_tmp10_);
			_g_free0 (_tmp8_);
			_tmp8_ = _tmp11_;
		}
		_tmp12_ = type;
		_tmp13_ = _tmp8_;
		_tmp14_ = *iter;
		_tmp15_ = document_structure_add_item (self, (StructType) _tmp12_, _tmp13_, &_tmp14_);
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp16_);
		_g_free0 (_tmp8_);
	} else {
		DocumentStructureLowLevelType _tmp17_;
		_tmp17_ = type;
		if (_tmp17_ < DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_NB_COMMON_TYPES) {
			DocumentStructureLowLevelType _tmp18_;
			const gchar* _tmp19_;
			GtkTextIter _tmp20_;
			GtkTreeIter* _tmp21_ = NULL;
			GtkTreeIter* _tmp22_;
			_tmp18_ = type;
			_tmp19_ = contents;
			_tmp20_ = *iter;
			_tmp21_ = document_structure_add_item (self, (StructType) _tmp18_, _tmp19_, &_tmp20_);
			_tmp22_ = _tmp21_;
			_g_free0 (_tmp22_);
		} else {
			DocumentStructureLowLevelType _tmp23_;
			_tmp23_ = type;
			if (_tmp23_ == DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_VERBATIM) {
				self->priv->_in_verbatim_env = TRUE;
			} else {
				gboolean _tmp24_ = FALSE;
				DocumentStructureLowLevelType _tmp25_;
				gboolean _tmp27_;
				_tmp25_ = type;
				if (_tmp25_ == DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_FIGURE) {
					_tmp24_ = TRUE;
				} else {
					DocumentStructureLowLevelType _tmp26_;
					_tmp26_ = type;
					_tmp24_ = _tmp26_ == DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_TABLE;
				}
				_tmp27_ = _tmp24_;
				if (_tmp27_) {
					DocumentStructureLowLevelType _tmp28_;
					GtkTextIter _tmp29_;
					_tmp28_ = type;
					_tmp29_ = *iter;
					document_structure_create_new_environment (self, _tmp28_, &_tmp29_);
				} else {
					gboolean _tmp30_ = FALSE;
					gboolean _tmp31_ = FALSE;
					DocumentStructureLowLevelType _tmp32_;
					gboolean _tmp34_;
					gboolean _tmp37_;
					_tmp32_ = type;
					if (_tmp32_ == DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_CAPTION) {
						DocumentStructureEnvData* _tmp33_;
						_tmp33_ = self->priv->_last_env_data;
						_tmp31_ = _tmp33_ != NULL;
					} else {
						_tmp31_ = FALSE;
					}
					_tmp34_ = _tmp31_;
					if (_tmp34_) {
						DocumentStructureEnvData* _tmp35_;
						const gchar* _tmp36_;
						_tmp35_ = self->priv->_last_env_data;
						_tmp36_ = (*_tmp35_).first_caption;
						_tmp30_ = _tmp36_ == NULL;
					} else {
						_tmp30_ = FALSE;
					}
					_tmp37_ = _tmp30_;
					if (_tmp37_) {
						const gchar* _tmp38_;
						gchar* _tmp39_ = NULL;
						gchar* _tmp40_;
						const gchar* _tmp41_;
						DocumentStructureEnvData* _tmp44_;
						const gchar* _tmp45_;
						gchar* _tmp46_;
						_tmp38_ = contents;
						_tmp39_ = document_structure_truncate (self, _tmp38_);
						_tmp40_ = _tmp39_;
						_tmp41_ = _tmp40_;
						if (_tmp41_ == NULL) {
							const gchar* _tmp42_;
							gchar* _tmp43_;
							_tmp42_ = contents;
							_tmp43_ = g_strdup (_tmp42_);
							_g_free0 (_tmp40_);
							_tmp40_ = _tmp43_;
						}
						_tmp44_ = self->priv->_last_env_data;
						_tmp45_ = _tmp40_;
						_tmp46_ = g_strdup (_tmp45_);
						_g_free0 ((*_tmp44_).first_caption);
						(*_tmp44_).first_caption = _tmp46_;
						_g_free0 (_tmp40_);
					} else {
						DocumentStructureLowLevelType _tmp47_;
						gboolean _tmp48_ = FALSE;
						_tmp47_ = type;
						_tmp48_ = document_structure_verify_end_environment_type (self, _tmp47_);
						if (_tmp48_) {
							GtkTextIter _tmp49_;
							GtkTextMark* _tmp50_ = NULL;
							GtkTextMark* end_mark;
							StructureModel* _tmp51_;
							DocumentStructureEnvData* _tmp52_;
							GtkTreePath* _tmp53_;
							DocumentStructureEnvData* _tmp54_;
							const gchar* _tmp55_;
							GtkTextMark* _tmp56_;
							_tmp49_ = *iter;
							_tmp50_ = document_structure_create_text_mark_from_iter (self, &_tmp49_);
							end_mark = _tmp50_;
							_tmp51_ = self->priv->_model;
							_tmp52_ = self->priv->_last_env_data;
							_tmp53_ = (*_tmp52_).path;
							_tmp54_ = self->priv->_last_env_data;
							_tmp55_ = (*_tmp54_).first_caption;
							_tmp56_ = end_mark;
							structure_model_modify_data (_tmp51_, _tmp53_, _tmp55_, _tmp56_);
							_document_structure_env_data_free0 (self->priv->_last_env_data);
							self->priv->_last_env_data = NULL;
							_g_object_unref0 (end_mark);
						} else {
							DocumentStructureLowLevelType _tmp57_;
							_tmp57_ = type;
							if (_tmp57_ == DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_DOCUMENT) {
								GtkTextIter _tmp58_;
								GtkTextMark* _tmp59_ = NULL;
								_tmp58_ = *iter;
								_tmp59_ = document_structure_create_text_mark_from_iter (self, &_tmp58_);
								_g_object_unref0 (self->priv->_end_document_mark);
								self->priv->_end_document_mark = _tmp59_;
							}
						}
					}
				}
			}
		}
	}
}


static gpointer _document_structure_env_data_dup0 (gpointer self) {
	return self ? document_structure_env_data_dup (self) : NULL;
}


static void document_structure_create_new_environment (DocumentStructure* self, DocumentStructureLowLevelType type, GtkTextIter* start_iter) {
	gboolean _tmp0_ = FALSE;
	DocumentStructureLowLevelType _tmp1_;
	gboolean _tmp3_;
	DocumentStructureEnvData _tmp4_ = {0};
	DocumentStructureEnvData _tmp5_;
	DocumentStructureEnvData* _tmp6_;
	DocumentStructureEnvData* _tmp7_;
	DocumentStructureLowLevelType _tmp8_;
	DocumentStructureEnvData* _tmp11_;
	StructType _tmp12_;
	GtkTextIter _tmp13_;
	GtkTreeIter* _tmp14_ = NULL;
	GtkTreeIter* _tmp15_;
	GtkTreeIter _tmp16_;
	GtkTreeIter tree_iter;
	DocumentStructureEnvData* _tmp17_;
	StructureModel* _tmp18_;
	GtkTreeIter _tmp19_;
	GtkTreePath* _tmp20_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (start_iter != NULL);
	_tmp1_ = type;
	if (_tmp1_ == DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_FIGURE) {
		_tmp0_ = TRUE;
	} else {
		DocumentStructureLowLevelType _tmp2_;
		_tmp2_ = type;
		_tmp0_ = _tmp2_ == DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_TABLE;
	}
	_tmp3_ = _tmp0_;
	g_return_if_fail (_tmp3_);
	memset (&_tmp4_, 0, sizeof (DocumentStructureEnvData));
	_tmp5_ = _tmp4_;
	_tmp6_ = _document_structure_env_data_dup0 (&_tmp5_);
	_document_structure_env_data_free0 (self->priv->_last_env_data);
	self->priv->_last_env_data = _tmp6_;
	document_structure_env_data_destroy (&_tmp5_);
	_tmp7_ = self->priv->_last_env_data;
	_g_free0 ((*_tmp7_).first_caption);
	(*_tmp7_).first_caption = NULL;
	_tmp8_ = type;
	if (_tmp8_ == DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_TABLE) {
		DocumentStructureEnvData* _tmp9_;
		_tmp9_ = self->priv->_last_env_data;
		(*_tmp9_).type = STRUCT_TYPE_TABLE;
	} else {
		DocumentStructureEnvData* _tmp10_;
		_tmp10_ = self->priv->_last_env_data;
		(*_tmp10_).type = STRUCT_TYPE_FIGURE;
	}
	_tmp11_ = self->priv->_last_env_data;
	_tmp12_ = (*_tmp11_).type;
	_tmp13_ = *start_iter;
	_tmp14_ = document_structure_add_item (self, _tmp12_, NULL, &_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = *_tmp15_;
	_g_free0 (_tmp15_);
	tree_iter = _tmp16_;
	_tmp17_ = self->priv->_last_env_data;
	_tmp18_ = self->priv->_model;
	_tmp19_ = tree_iter;
	_tmp20_ = gtk_tree_model_get_path ((GtkTreeModel*) _tmp18_, &_tmp19_);
	_gtk_tree_path_free0 ((*_tmp17_).path);
	(*_tmp17_).path = _tmp20_;
}


static gboolean document_structure_verify_end_environment_type (DocumentStructure* self, DocumentStructureLowLevelType type) {
	gboolean result = FALSE;
	DocumentStructureEnvData* _tmp0_;
	DocumentStructureLowLevelType _tmp1_;
	DocumentStructureLowLevelType _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_last_env_data;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = type;
	if (_tmp1_ == DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_TABLE) {
		DocumentStructureEnvData* _tmp2_;
		StructType _tmp3_;
		_tmp2_ = self->priv->_last_env_data;
		_tmp3_ = (*_tmp2_).type;
		result = _tmp3_ == STRUCT_TYPE_TABLE;
		return result;
	}
	_tmp4_ = type;
	if (_tmp4_ == DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_FIGURE) {
		DocumentStructureEnvData* _tmp5_;
		StructType _tmp6_;
		_tmp5_ = self->priv->_last_env_data;
		_tmp6_ = (*_tmp5_).type;
		result = _tmp6_ == STRUCT_TYPE_FIGURE;
		return result;
	}
	result = FALSE;
	return result;
}


static GtkTreeIter* document_structure_add_item (DocumentStructure* self, StructType type, const gchar* text, GtkTextIter* start_iter) {
	GtkTreeIter* result = NULL;
	StructData _tmp0_ = {0};
	StructData data;
	StructType _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GtkTextIter _tmp4_;
	GtkTextMark* _tmp5_ = NULL;
	StructData _tmp6_;
	GtkTreeIter* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (start_iter != NULL, NULL);
	data = _tmp0_;
	_tmp1_ = type;
	data.type = _tmp1_;
	_tmp2_ = text;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (data.text);
	data.text = _tmp3_;
	_tmp4_ = *start_iter;
	_tmp5_ = document_structure_create_text_mark_from_iter (self, &_tmp4_);
	_g_object_unref0 (data.start_mark);
	data.start_mark = _tmp5_;
	_g_object_unref0 (data.end_mark);
	data.end_mark = NULL;
	_tmp6_ = data;
	_tmp7_ = document_structure_add_item_data (self, &_tmp6_);
	result = _tmp7_;
	struct_data_destroy (&data);
	return result;
}


static GtkTreeIter* document_structure_add_item_data (DocumentStructure* self, StructData* data) {
	GtkTreeIter* result = NULL;
	StructData _tmp0_;
	const gchar* _tmp1_;
	StructureModel* _tmp3_;
	StructData _tmp4_;
	GtkTreeIter* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.text;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("");
		_g_free0 ((*data).text);
		(*data).text = _tmp2_;
	}
	_tmp3_ = self->priv->_model;
	_tmp4_ = *data;
	_tmp5_ = structure_model_add_item_at_end (_tmp3_, &_tmp4_);
	result = _tmp5_;
	return result;
}


static GtkTextMark* document_structure_create_text_mark_from_iter (DocumentStructure* self, GtkTextIter* iter) {
	GtkTextMark* result = NULL;
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* doc;
	gint _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* name;
	GtkTextIter _tmp7_;
	GtkTextMark* _tmp8_ = NULL;
	GtkTextMark* _tmp9_;
	GtkTextMark* mark;
	gint _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = gtk_text_iter_get_buffer (iter);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	doc = _tmp1_;
	_tmp2_ = self->priv->_nb_marks;
	_tmp3_ = g_strdup_printf ("%i", _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (DOCUMENT_STRUCTURE_MARK_NAME_PREFIX, _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	name = _tmp6_;
	_tmp7_ = *iter;
	_tmp8_ = gtk_text_buffer_create_mark (doc, name, &_tmp7_, FALSE);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	mark = _tmp9_;
	_tmp10_ = self->priv->_nb_marks;
	self->priv->_nb_marks = _tmp10_ + 1;
	result = mark;
	_g_free0 (name);
	_g_object_unref0 (doc);
	return result;
}


static void document_structure_clear_all_structure_marks (DocumentStructure* self) {
	g_return_if_fail (self != NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* mark_name;
				Document* _tmp10_;
				const gchar* _tmp11_;
				GtkTextMark* _tmp12_ = NULL;
				GtkTextMark* _tmp13_;
				GtkTextMark* mark;
				GtkTextMark* _tmp14_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->priv->_nb_marks;
				if (!(_tmp3_ < _tmp4_)) {
					break;
				}
				_tmp5_ = i;
				_tmp6_ = g_strdup_printf ("%i", _tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = g_strconcat (DOCUMENT_STRUCTURE_MARK_NAME_PREFIX, _tmp7_, NULL);
				_tmp9_ = _tmp8_;
				_g_free0 (_tmp7_);
				mark_name = _tmp9_;
				_tmp10_ = self->priv->_doc;
				_tmp11_ = mark_name;
				_tmp12_ = gtk_text_buffer_get_mark ((GtkTextBuffer*) _tmp10_, _tmp11_);
				_tmp13_ = _g_object_ref0 (_tmp12_);
				mark = _tmp13_;
				_tmp14_ = mark;
				if (_tmp14_ != NULL) {
					Document* _tmp15_;
					GtkTextMark* _tmp16_;
					_tmp15_ = self->priv->_doc;
					_tmp16_ = mark;
					gtk_text_buffer_delete_mark ((GtkTextBuffer*) _tmp15_, _tmp16_);
				}
				_g_object_unref0 (mark);
				_g_free0 (mark_name);
			}
		}
	}
	self->priv->_nb_marks = 0;
}


static gint string_index_of_nth_char (const gchar* self, glong c) {
	gint result = 0;
	glong _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = c;
	_tmp1_ = g_utf8_offset_to_pointer (self, _tmp0_);
	result = (gint) (_tmp1_ - ((gchar*) self));
	return result;
}


static gchar* document_structure_truncate (DocumentStructure* self, const gchar* text) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_ = 0;
	const gchar* _tmp3_;
	gint _tmp4_ = 0;
	gint index;
	const gchar* _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = text;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = text;
	_tmp2_ = g_utf8_strlen (_tmp1_, (gssize) (-1));
	if (_tmp2_ <= DOCUMENT_STRUCTURE_ITEM_MAX_LENGTH) {
		result = NULL;
		return result;
	}
	_tmp3_ = text;
	_tmp4_ = string_index_of_nth_char (_tmp3_, (glong) DOCUMENT_STRUCTURE_ITEM_MAX_LENGTH);
	index = _tmp4_;
	_tmp5_ = text;
	_tmp6_ = index;
	_tmp7_ = string_substring (_tmp5_, (glong) 0, (glong) _tmp6_);
	result = _tmp7_;
	return result;
}


static DocumentStructureLowLevelType* document_structure_get_markup_low_level_type (DocumentStructure* self, const gchar* markup_name) {
	DocumentStructureLowLevelType* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	static GQuark _tmp2_label8 = 0;
	static GQuark _tmp2_label9 = 0;
	static GQuark _tmp2_label10 = 0;
	static GQuark _tmp2_label11 = 0;
	static GQuark _tmp2_label12 = 0;
	static GQuark _tmp2_label13 = 0;
	static GQuark _tmp2_label14 = 0;
	static GQuark _tmp2_label15 = 0;
	static GQuark _tmp2_label16 = 0;
	static GQuark _tmp2_label17 = 0;
	static GQuark _tmp2_label18 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (markup_name != NULL, NULL);
	_tmp0_ = markup_name;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if ((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("part")))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("part*"))))) {
		switch (0) {
			default:
			{
				DocumentStructureLowLevelType _tmp4_;
				DocumentStructureLowLevelType* _tmp5_;
				_tmp4_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_PART;
				_tmp5_ = __document_structure_low_level_type_dup0 (&_tmp4_);
				result = _tmp5_;
				return result;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("chapter")))) || (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("chapter*"))))) {
		switch (0) {
			default:
			{
				DocumentStructureLowLevelType _tmp6_;
				DocumentStructureLowLevelType* _tmp7_;
				_tmp6_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_CHAPTER;
				_tmp7_ = __document_structure_low_level_type_dup0 (&_tmp6_);
				result = _tmp7_;
				return result;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("section")))) || (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("section*"))))) {
		switch (0) {
			default:
			{
				DocumentStructureLowLevelType _tmp8_;
				DocumentStructureLowLevelType* _tmp9_;
				_tmp8_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_SECTION;
				_tmp9_ = __document_structure_low_level_type_dup0 (&_tmp8_);
				result = _tmp9_;
				return result;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("subsection")))) || (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("subsection*"))))) {
		switch (0) {
			default:
			{
				DocumentStructureLowLevelType _tmp10_;
				DocumentStructureLowLevelType* _tmp11_;
				_tmp10_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_SUBSECTION;
				_tmp11_ = __document_structure_low_level_type_dup0 (&_tmp10_);
				result = _tmp11_;
				return result;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label8) ? _tmp2_label8 : (_tmp2_label8 = g_quark_from_static_string ("subsubsection")))) || (_tmp3_ == ((0 != _tmp2_label9) ? _tmp2_label9 : (_tmp2_label9 = g_quark_from_static_string ("subsubsection*"))))) {
		switch (0) {
			default:
			{
				DocumentStructureLowLevelType _tmp12_;
				DocumentStructureLowLevelType* _tmp13_;
				_tmp12_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_SUBSUBSECTION;
				_tmp13_ = __document_structure_low_level_type_dup0 (&_tmp12_);
				result = _tmp13_;
				return result;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label10) ? _tmp2_label10 : (_tmp2_label10 = g_quark_from_static_string ("paragraph")))) || (_tmp3_ == ((0 != _tmp2_label11) ? _tmp2_label11 : (_tmp2_label11 = g_quark_from_static_string ("paragraph*"))))) {
		switch (0) {
			default:
			{
				DocumentStructureLowLevelType _tmp14_;
				DocumentStructureLowLevelType* _tmp15_;
				_tmp14_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_PARAGRAPH;
				_tmp15_ = __document_structure_low_level_type_dup0 (&_tmp14_);
				result = _tmp15_;
				return result;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label12) ? _tmp2_label12 : (_tmp2_label12 = g_quark_from_static_string ("subparagraph")))) || (_tmp3_ == ((0 != _tmp2_label13) ? _tmp2_label13 : (_tmp2_label13 = g_quark_from_static_string ("subparagraph*"))))) {
		switch (0) {
			default:
			{
				DocumentStructureLowLevelType _tmp16_;
				DocumentStructureLowLevelType* _tmp17_;
				_tmp16_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_SUBPARAGRAPH;
				_tmp17_ = __document_structure_low_level_type_dup0 (&_tmp16_);
				result = _tmp17_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label14) ? _tmp2_label14 : (_tmp2_label14 = g_quark_from_static_string ("label")))) {
		switch (0) {
			default:
			{
				DocumentStructureLowLevelType _tmp18_;
				DocumentStructureLowLevelType* _tmp19_;
				_tmp18_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_LABEL;
				_tmp19_ = __document_structure_low_level_type_dup0 (&_tmp18_);
				result = _tmp19_;
				return result;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label15) ? _tmp2_label15 : (_tmp2_label15 = g_quark_from_static_string ("input")))) || (_tmp3_ == ((0 != _tmp2_label16) ? _tmp2_label16 : (_tmp2_label16 = g_quark_from_static_string ("include"))))) {
		switch (0) {
			default:
			{
				DocumentStructureLowLevelType _tmp20_;
				DocumentStructureLowLevelType* _tmp21_;
				_tmp20_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_INCLUDE;
				_tmp21_ = __document_structure_low_level_type_dup0 (&_tmp20_);
				result = _tmp21_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label17) ? _tmp2_label17 : (_tmp2_label17 = g_quark_from_static_string ("includegraphics")))) {
		switch (0) {
			default:
			{
				DocumentStructureLowLevelType _tmp22_;
				DocumentStructureLowLevelType* _tmp23_;
				_tmp22_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_IMAGE;
				_tmp23_ = __document_structure_low_level_type_dup0 (&_tmp22_);
				result = _tmp23_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label18) ? _tmp2_label18 : (_tmp2_label18 = g_quark_from_static_string ("caption")))) {
		switch (0) {
			default:
			{
				DocumentStructureLowLevelType _tmp24_;
				DocumentStructureLowLevelType* _tmp25_;
				_tmp24_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_CAPTION;
				_tmp25_ = __document_structure_low_level_type_dup0 (&_tmp24_);
				result = _tmp25_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = NULL;
				return result;
			}
		}
	}
}


/*************************************************************************/
void document_structure_do_action (DocumentStructure* self, StructAction action_type, GtkTreeIter* tree_iter, gboolean* refresh_simple_list, GError** error) {
	gboolean _vala_refresh_simple_list = FALSE;
	StructAction _tmp0_;
	StructAction _tmp6_;
	gboolean shift_right;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_;
	gboolean _tmp10_;
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	GtkTreeIter _tmp34_;
	GtkTextIter _tmp35_ = {0};
	GtkTextIter _tmp36_ = {0};
	gboolean _tmp37_ = FALSE;
	gboolean found;
	gboolean _tmp38_;
	gint _tmp40_ = 0;
	gint _tmp41_ = 0;
	StructAction _tmp42_;
	gboolean _tmp46_ = FALSE;
	StructAction _tmp47_;
	gboolean _tmp49_;
	gboolean _tmp58_ = FALSE;
	StructAction _tmp59_;
	gboolean _tmp61_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tree_iter != NULL);
	_vala_refresh_simple_list = FALSE;
	_tmp0_ = action_type;
	if (_tmp0_ == STRUCT_ACTION_COMMENT) {
		GtkTreeIter _tmp1_;
		gboolean _tmp2_ = FALSE;
		StructureModel* _tmp4_;
		GtkTreeIter _tmp5_;
		_tmp1_ = *tree_iter;
		_tmp2_ = document_structure_comment_item (self, &_tmp1_);
		if (!_tmp2_) {
			GError* _tmp3_;
			_tmp3_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_DATA_OUTDATED, "");
			_inner_error_ = _tmp3_;
			if (_inner_error_->domain == STRUCT_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp4_ = self->priv->_model;
		_tmp5_ = *tree_iter;
		structure_model_delete (_tmp4_, &_tmp5_);
		_vala_refresh_simple_list = TRUE;
		if (refresh_simple_list) {
			*refresh_simple_list = _vala_refresh_simple_list;
		}
		return;
	}
	_tmp6_ = action_type;
	shift_right = _tmp6_ == STRUCT_ACTION_SHIFT_RIGHT;
	_tmp8_ = shift_right;
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		StructAction _tmp9_;
		_tmp9_ = action_type;
		_tmp7_ = _tmp9_ == STRUCT_ACTION_SHIFT_LEFT;
	}
	_tmp10_ = _tmp7_;
	if (_tmp10_) {
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_;
		gboolean _tmp16_;
		Document* _tmp19_;
		gboolean doc_modified = FALSE;
		GtkTreeIter _tmp20_;
		gboolean _tmp21_;
		gboolean _tmp22_ = FALSE;
		gboolean _tmp23_ = FALSE;
		gboolean success;
		Document* _tmp24_;
		gboolean _tmp25_;
		gboolean _tmp29_;
		_tmp12_ = shift_right;
		if (_tmp12_) {
			StructureModel* _tmp13_;
			GtkTreeIter _tmp14_;
			gboolean _tmp15_ = FALSE;
			_tmp13_ = self->priv->_model;
			_tmp14_ = *tree_iter;
			_tmp15_ = structure_model_item_contains_subparagraph (_tmp13_, &_tmp14_);
			_tmp11_ = _tmp15_;
		} else {
			_tmp11_ = FALSE;
		}
		_tmp16_ = _tmp11_;
		if (_tmp16_) {
			const gchar* _tmp17_ = NULL;
			GError* _tmp18_;
			_tmp17_ = _ ("The structure item already contains a sub-paragraph.");
			_tmp18_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_GENERAL, _tmp17_);
			_inner_error_ = _tmp18_;
			if (_inner_error_->domain == STRUCT_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp19_ = self->priv->_doc;
		gtk_text_buffer_begin_user_action ((GtkTextBuffer*) _tmp19_);
		_tmp20_ = *tree_iter;
		_tmp21_ = shift_right;
		_tmp23_ = document_structure_shift_item (self, &_tmp20_, _tmp21_, &_tmp22_);
		doc_modified = _tmp22_;
		success = _tmp23_;
		_tmp24_ = self->priv->_doc;
		gtk_text_buffer_end_user_action ((GtkTextBuffer*) _tmp24_);
		_tmp25_ = success;
		if (!_tmp25_) {
			gboolean _tmp26_;
			GError* _tmp28_;
			_tmp26_ = doc_modified;
			if (_tmp26_) {
				Document* _tmp27_;
				_tmp27_ = self->priv->_doc;
				gtk_source_buffer_undo ((GtkSourceBuffer*) _tmp27_);
			}
			_tmp28_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_DATA_OUTDATED, "");
			_inner_error_ = _tmp28_;
			if (_inner_error_->domain == STRUCT_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp29_ = shift_right;
		if (_tmp29_) {
			StructureModel* _tmp30_;
			GtkTreeIter _tmp31_;
			_tmp30_ = self->priv->_model;
			_tmp31_ = *tree_iter;
			structure_model_shift_right (_tmp30_, &_tmp31_);
		} else {
			StructureModel* _tmp32_;
			GtkTreeIter _tmp33_;
			_tmp32_ = self->priv->_model;
			_tmp33_ = *tree_iter;
			structure_model_shift_left (_tmp32_, &_tmp33_);
		}
		if (refresh_simple_list) {
			*refresh_simple_list = _vala_refresh_simple_list;
		}
		return;
	}
	_tmp34_ = *tree_iter;
	_tmp37_ = document_structure_get_exact_item_bounds (self, &_tmp34_, &_tmp35_, &_tmp36_);
	start_iter = _tmp35_;
	end_iter = _tmp36_;
	found = _tmp37_;
	_tmp38_ = found;
	if (!_tmp38_) {
		GError* _tmp39_;
		_tmp39_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_DATA_OUTDATED, "");
		_inner_error_ = _tmp39_;
		if (_inner_error_->domain == STRUCT_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp40_ = gtk_text_iter_get_line (&start_iter);
	_tmp41_ = gtk_text_iter_get_line (&end_iter);
	if (_tmp40_ != _tmp41_) {
		document_structure_backward_indentation (self, &start_iter);
		document_structure_backward_indentation (self, &end_iter);
	}
	_tmp42_ = action_type;
	if (_tmp42_ == STRUCT_ACTION_SELECT) {
		Document* _tmp43_;
		GtkTextIter _tmp44_;
		GtkTextIter _tmp45_;
		_tmp43_ = self->priv->_doc;
		_tmp44_ = start_iter;
		_tmp45_ = end_iter;
		gtk_text_buffer_select_range ((GtkTextBuffer*) _tmp43_, &_tmp44_, &_tmp45_);
		if (refresh_simple_list) {
			*refresh_simple_list = _vala_refresh_simple_list;
		}
		return;
	}
	_tmp47_ = action_type;
	if (_tmp47_ == STRUCT_ACTION_COPY) {
		_tmp46_ = TRUE;
	} else {
		StructAction _tmp48_;
		_tmp48_ = action_type;
		_tmp46_ = _tmp48_ == STRUCT_ACTION_CUT;
	}
	_tmp49_ = _tmp46_;
	if (_tmp49_) {
		Document* _tmp50_;
		GtkTextIter _tmp51_;
		GtkTextIter _tmp52_;
		gchar* _tmp53_ = NULL;
		gchar* data;
		GtkClipboard* _tmp54_ = NULL;
		GtkClipboard* _tmp55_;
		GtkClipboard* clipboard;
		GtkClipboard* _tmp56_;
		const gchar* _tmp57_;
		_tmp50_ = self->priv->_doc;
		_tmp51_ = start_iter;
		_tmp52_ = end_iter;
		_tmp53_ = gtk_text_buffer_get_text ((GtkTextBuffer*) _tmp50_, &_tmp51_, &_tmp52_, FALSE);
		data = _tmp53_;
		_tmp54_ = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
		_tmp55_ = _g_object_ref0 (_tmp54_);
		clipboard = _tmp55_;
		_tmp56_ = clipboard;
		_tmp57_ = data;
		gtk_clipboard_set_text (_tmp56_, _tmp57_, -1);
		_g_object_unref0 (clipboard);
		_g_free0 (data);
	}
	_tmp59_ = action_type;
	if (_tmp59_ == STRUCT_ACTION_DELETE) {
		_tmp58_ = TRUE;
	} else {
		StructAction _tmp60_;
		_tmp60_ = action_type;
		_tmp58_ = _tmp60_ == STRUCT_ACTION_CUT;
	}
	_tmp61_ = _tmp58_;
	if (_tmp61_) {
		Document* _tmp62_;
		Document* _tmp63_;
		Document* _tmp64_;
		StructureModel* _tmp65_;
		GtkTreeIter _tmp66_;
		_tmp62_ = self->priv->_doc;
		gtk_text_buffer_begin_user_action ((GtkTextBuffer*) _tmp62_);
		_tmp63_ = self->priv->_doc;
		gtk_text_buffer_delete ((GtkTextBuffer*) _tmp63_, &start_iter, &end_iter);
		_tmp64_ = self->priv->_doc;
		gtk_text_buffer_end_user_action ((GtkTextBuffer*) _tmp64_);
		_tmp65_ = self->priv->_model;
		_tmp66_ = *tree_iter;
		structure_model_delete (_tmp65_, &_tmp66_);
		_vala_refresh_simple_list = TRUE;
	}
	if (refresh_simple_list) {
		*refresh_simple_list = _vala_refresh_simple_list;
	}
}


static gboolean document_structure_comment_item (DocumentStructure* self, GtkTreeIter* tree_iter) {
	gboolean result = FALSE;
	StructType type = 0;
	GtkTextMark* start_mark;
	GtkTextMark* end_mark;
	StructureModel* _tmp0_;
	GtkTreeIter _tmp1_;
	GtkTextIter start_iter = {0};
	GtkTextIter _tmp2_ = {0};
	GtkTextIter end_iter;
	gboolean end_iter_set;
	Document* _tmp3_;
	GtkTextMark* _tmp4_;
	GtkTextIter _tmp5_ = {0};
	GtkTextMark* _tmp6_;
	StructType _tmp10_;
	gboolean _tmp11_ = FALSE;
	GtkTreeIter* next_section_iter;
	gboolean go_one_line_backward;
	GtkTreeIter* _tmp22_;
	gboolean _tmp32_;
	Document* _tmp34_;
	GtkTextIter _tmp35_;
	GtkTextIter _tmp36_;
	gboolean _tmp37_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tree_iter != NULL, FALSE);
	start_mark = NULL;
	end_mark = NULL;
	_tmp0_ = self->priv->_model;
	_tmp1_ = *tree_iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp0_, &_tmp1_, STRUCT_COLUMN_TYPE, &type, STRUCT_COLUMN_START_MARK, &start_mark, STRUCT_COLUMN_END_MARK, &end_mark, -1, -1);
	end_iter = _tmp2_;
	end_iter_set = FALSE;
	_tmp3_ = self->priv->_doc;
	_tmp4_ = start_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp3_, &_tmp5_, _tmp4_);
	start_iter = _tmp5_;
	_tmp6_ = end_mark;
	if (_tmp6_ != NULL) {
		Document* _tmp7_;
		GtkTextMark* _tmp8_;
		GtkTextIter _tmp9_ = {0};
		_tmp7_ = self->priv->_doc;
		_tmp8_ = end_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp7_, &_tmp9_, _tmp8_);
		end_iter = _tmp9_;
		end_iter_set = TRUE;
	}
	_tmp10_ = type;
	_tmp11_ = structure_is_section (_tmp10_);
	if (!_tmp11_) {
		Document* _tmp12_;
		GtkTextIter _tmp13_;
		GtkTextIter _tmp14_;
		gboolean _tmp15_;
		_tmp12_ = self->priv->_doc;
		_tmp13_ = start_iter;
		_tmp14_ = end_iter;
		_tmp15_ = end_iter_set;
		document_comment_between (_tmp12_, &_tmp13_, &_tmp14_, _tmp15_);
		result = TRUE;
		_g_object_unref0 (end_mark);
		_g_object_unref0 (start_mark);
		return result;
	}
	next_section_iter = NULL;
	{
		StructureModel* _tmp16_;
		GtkTreeIter _tmp17_;
		GtkTreeIter* _tmp18_ = NULL;
		GtkTreeIter* _tmp19_;
		_tmp16_ = self->priv->_model;
		_tmp17_ = *tree_iter;
		_tmp18_ = structure_model_get_next_sibling_or_parent (_tmp16_, &_tmp17_, &_inner_error_);
		_tmp19_ = _tmp18_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == STRUCT_ERROR) {
				goto __catch51_struct_error;
			}
			_g_free0 (next_section_iter);
			_g_object_unref0 (end_mark);
			_g_object_unref0 (start_mark);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_g_free0 (next_section_iter);
		next_section_iter = _tmp19_;
	}
	goto __finally51;
	__catch51_struct_error:
	{
		GError* e = NULL;
		GError* _tmp20_;
		const gchar* _tmp21_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp20_ = e;
		_tmp21_ = _tmp20_->message;
		g_warning ("document_structure.vala:834: Structure: get next sibling or parent: %s", _tmp21_);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (next_section_iter);
		_g_object_unref0 (end_mark);
		_g_object_unref0 (start_mark);
		return result;
	}
	__finally51:
	if (_inner_error_ != NULL) {
		_g_free0 (next_section_iter);
		_g_object_unref0 (end_mark);
		_g_object_unref0 (start_mark);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	go_one_line_backward = TRUE;
	_tmp22_ = next_section_iter;
	if (_tmp22_ == NULL) {
		gboolean end_of_file = FALSE;
		gboolean _tmp23_ = FALSE;
		GtkTextIter _tmp24_ = {0};
		gboolean _tmp25_;
		document_structure_get_end_document_iter (self, &_tmp23_, &_tmp24_);
		end_of_file = _tmp23_;
		end_iter = _tmp24_;
		end_iter_set = TRUE;
		_tmp25_ = end_of_file;
		go_one_line_backward = !_tmp25_;
	} else {
		StructureModel* _tmp26_;
		GtkTreeIter* _tmp27_;
		GtkTreeIter _tmp28_;
		Document* _tmp29_;
		GtkTextMark* _tmp30_;
		GtkTextIter _tmp31_ = {0};
		_tmp26_ = self->priv->_model;
		_tmp27_ = next_section_iter;
		_tmp28_ = *_tmp27_;
		gtk_tree_model_get ((GtkTreeModel*) _tmp26_, &_tmp28_, STRUCT_COLUMN_START_MARK, &end_mark, -1, -1);
		_tmp29_ = self->priv->_doc;
		_tmp30_ = end_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp29_, &_tmp31_, _tmp30_);
		end_iter = _tmp31_;
		end_iter_set = TRUE;
	}
	_tmp32_ = go_one_line_backward;
	if (_tmp32_) {
		gboolean _tmp33_ = FALSE;
		_tmp33_ = gtk_text_iter_backward_line (&end_iter);
		if (!_tmp33_) {
			end_iter_set = FALSE;
		}
	}
	_tmp34_ = self->priv->_doc;
	_tmp35_ = start_iter;
	_tmp36_ = end_iter;
	_tmp37_ = end_iter_set;
	document_comment_between (_tmp34_, &_tmp35_, &_tmp36_, _tmp37_);
	result = TRUE;
	_g_free0 (next_section_iter);
	_g_object_unref0 (end_mark);
	_g_object_unref0 (start_mark);
	return result;
}


static gboolean document_structure_get_exact_item_bounds (DocumentStructure* self, GtkTreeIter* tree_iter, GtkTextIter* start_iter, GtkTextIter* end_iter) {
	GtkTextIter _vala_start_iter = {0};
	GtkTextIter _vala_end_iter = {0};
	gboolean result = FALSE;
	StructType item_type = 0;
	GtkTextMark* start_mark;
	GtkTextMark* end_mark;
	gchar* item_contents;
	StructureModel* _tmp0_;
	GtkTreeIter _tmp1_;
	Document* _tmp2_;
	GtkTextMark* _tmp3_;
	GtkTextIter _tmp4_ = {0};
	StructType _tmp5_;
	const gchar* _tmp6_;
	GtkTextIter _tmp7_;
	GtkTextIter _tmp8_ = {0};
	gboolean _tmp9_ = FALSE;
	gboolean found;
	gboolean _tmp10_;
	StructType _tmp11_;
	gboolean _tmp12_ = FALSE;
	GtkTextMark* _tmp32_;
	GtkTextIter end_env_iter = {0};
	Document* _tmp33_;
	GtkTextMark* _tmp34_;
	GtkTextIter _tmp35_ = {0};
	StructType _tmp36_;
	const gchar* _tmp37_;
	GtkTextIter _tmp38_;
	GtkTextIter _tmp39_ = {0};
	gboolean _tmp40_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tree_iter != NULL, FALSE);
	start_mark = NULL;
	end_mark = NULL;
	item_contents = NULL;
	_tmp0_ = self->priv->_model;
	_tmp1_ = *tree_iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp0_, &_tmp1_, STRUCT_COLUMN_TYPE, &item_type, STRUCT_COLUMN_START_MARK, &start_mark, STRUCT_COLUMN_END_MARK, &end_mark, STRUCT_COLUMN_TEXT, &item_contents, -1, -1);
	_tmp2_ = self->priv->_doc;
	_tmp3_ = start_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp2_, &_tmp4_, _tmp3_);
	_vala_start_iter = _tmp4_;
	_tmp5_ = item_type;
	_tmp6_ = item_contents;
	_tmp7_ = _vala_start_iter;
	_tmp9_ = document_structure_get_low_level_item_bounds (self, _tmp5_, _tmp6_, &_tmp7_, TRUE, &_tmp8_);
	_vala_end_iter = _tmp8_;
	found = _tmp9_;
	_tmp10_ = found;
	if (!_tmp10_) {
		result = FALSE;
		_g_free0 (item_contents);
		_g_object_unref0 (end_mark);
		_g_object_unref0 (start_mark);
		if (start_iter) {
			*start_iter = _vala_start_iter;
		}
		if (end_iter) {
			*end_iter = _vala_end_iter;
		}
		return result;
	}
	_tmp11_ = item_type;
	_tmp12_ = structure_is_section (_tmp11_);
	if (_tmp12_) {
		GtkTreeIter* next_section_iter;
		GtkTreeIter* _tmp19_;
		StructureModel* _tmp21_;
		GtkTreeIter* _tmp22_;
		GtkTreeIter _tmp23_;
		Document* _tmp24_;
		GtkTextMark* _tmp25_;
		GtkTextIter _tmp26_ = {0};
		StructType _tmp27_;
		const gchar* _tmp28_;
		GtkTextIter _tmp29_;
		gboolean _tmp30_ = FALSE;
		next_section_iter = NULL;
		{
			StructureModel* _tmp13_;
			GtkTreeIter _tmp14_;
			GtkTreeIter* _tmp15_ = NULL;
			GtkTreeIter* _tmp16_;
			_tmp13_ = self->priv->_model;
			_tmp14_ = *tree_iter;
			_tmp15_ = structure_model_get_next_sibling_or_parent (_tmp13_, &_tmp14_, &_inner_error_);
			_tmp16_ = _tmp15_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == STRUCT_ERROR) {
					goto __catch52_struct_error;
				}
				_g_free0 (next_section_iter);
				_g_free0 (item_contents);
				_g_object_unref0 (end_mark);
				_g_object_unref0 (start_mark);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			_g_free0 (next_section_iter);
			next_section_iter = _tmp16_;
		}
		goto __finally52;
		__catch52_struct_error:
		{
			GError* e = NULL;
			GError* _tmp17_;
			const gchar* _tmp18_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp17_ = e;
			_tmp18_ = _tmp17_->message;
			g_warning ("document_structure.vala:909: Structure: get next sibling or parent: %s", _tmp18_);
			result = FALSE;
			_g_error_free0 (e);
			_g_free0 (next_section_iter);
			_g_free0 (item_contents);
			_g_object_unref0 (end_mark);
			_g_object_unref0 (start_mark);
			if (start_iter) {
				*start_iter = _vala_start_iter;
			}
			if (end_iter) {
				*end_iter = _vala_end_iter;
			}
			return result;
		}
		__finally52:
		if (_inner_error_ != NULL) {
			_g_free0 (next_section_iter);
			_g_free0 (item_contents);
			_g_object_unref0 (end_mark);
			_g_object_unref0 (start_mark);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp19_ = next_section_iter;
		if (_tmp19_ == NULL) {
			GtkTextIter _tmp20_ = {0};
			document_structure_get_end_document_iter (self, NULL, &_tmp20_);
			_vala_end_iter = _tmp20_;
			result = TRUE;
			_g_free0 (next_section_iter);
			_g_free0 (item_contents);
			_g_object_unref0 (end_mark);
			_g_object_unref0 (start_mark);
			if (start_iter) {
				*start_iter = _vala_start_iter;
			}
			if (end_iter) {
				*end_iter = _vala_end_iter;
			}
			return result;
		}
		_tmp21_ = self->priv->_model;
		_tmp22_ = next_section_iter;
		_tmp23_ = *_tmp22_;
		gtk_tree_model_get ((GtkTreeModel*) _tmp21_, &_tmp23_, STRUCT_COLUMN_TYPE, &item_type, STRUCT_COLUMN_START_MARK, &start_mark, STRUCT_COLUMN_TEXT, &item_contents, -1, -1);
		_tmp24_ = self->priv->_doc;
		_tmp25_ = start_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp24_, &_tmp26_, _tmp25_);
		_vala_end_iter = _tmp26_;
		_tmp27_ = item_type;
		_tmp28_ = item_contents;
		_tmp29_ = _vala_end_iter;
		_tmp30_ = document_structure_get_low_level_item_bounds (self, _tmp27_, _tmp28_, &_tmp29_, TRUE, NULL);
		result = _tmp30_;
		_g_free0 (next_section_iter);
		_g_free0 (item_contents);
		_g_object_unref0 (end_mark);
		_g_object_unref0 (start_mark);
		if (start_iter) {
			*start_iter = _vala_start_iter;
		}
		if (end_iter) {
			*end_iter = _vala_end_iter;
		}
		return result;
	} else {
		StructType _tmp31_;
		_tmp31_ = item_type;
		if (_tmp31_ < STRUCT_TYPE_NB_COMMON_TYPES) {
			result = TRUE;
			_g_free0 (item_contents);
			_g_object_unref0 (end_mark);
			_g_object_unref0 (start_mark);
			if (start_iter) {
				*start_iter = _vala_start_iter;
			}
			if (end_iter) {
				*end_iter = _vala_end_iter;
			}
			return result;
		}
	}
	_tmp32_ = end_mark;
	if (_tmp32_ == NULL) {
		result = FALSE;
		_g_free0 (item_contents);
		_g_object_unref0 (end_mark);
		_g_object_unref0 (start_mark);
		if (start_iter) {
			*start_iter = _vala_start_iter;
		}
		if (end_iter) {
			*end_iter = _vala_end_iter;
		}
		return result;
	}
	_tmp33_ = self->priv->_doc;
	_tmp34_ = end_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp33_, &_tmp35_, _tmp34_);
	end_env_iter = _tmp35_;
	_tmp36_ = item_type;
	_tmp37_ = item_contents;
	_tmp38_ = end_env_iter;
	_tmp40_ = document_structure_get_low_level_item_bounds (self, _tmp36_, _tmp37_, &_tmp38_, FALSE, &_tmp39_);
	_vala_end_iter = _tmp39_;
	result = _tmp40_;
	_g_free0 (item_contents);
	_g_object_unref0 (end_mark);
	_g_object_unref0 (start_mark);
	if (start_iter) {
		*start_iter = _vala_start_iter;
	}
	if (end_iter) {
		*end_iter = _vala_end_iter;
	}
	return result;
}


static gboolean document_structure_get_low_level_item_bounds (DocumentStructure* self, StructType item_type, const gchar* item_contents, GtkTextIter* start_match_iter, gboolean is_start, GtkTextIter* end_match_iter) {
	GtkTextIter _vala_end_match_iter = {0};
	gboolean result = FALSE;
	GtkTextIter _tmp0_ = {0};
	gint _tmp1_ = 0;
	gint line_num;
	gint _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* line;
	gint _tmp4_ = 0;
	gint start_index;
	DocumentStructureLowLevelType* low_level_type = NULL;
	gchar* contents = NULL;
	gint* start_match_index = NULL;
	gint* end_match_index = NULL;
	const gchar* _tmp5_;
	gint _tmp6_;
	DocumentStructureLowLevelType* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gint* _tmp9_ = NULL;
	gint* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean found;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_;
	gboolean _tmp16_;
	const gchar* _tmp17_;
	StructType _tmp19_;
	const gchar* _tmp20_;
	DocumentStructureLowLevelType* _tmp21_;
	const gchar* _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item_contents != NULL, FALSE);
	g_return_val_if_fail (start_match_iter != NULL, FALSE);
	_vala_end_match_iter = _tmp0_;
	_tmp1_ = gtk_text_iter_get_line (start_match_iter);
	line_num = _tmp1_;
	_tmp2_ = line_num;
	_tmp3_ = document_structure_get_document_line_contents (self, _tmp2_);
	line = _tmp3_;
	_tmp4_ = gtk_text_iter_get_line_index (start_match_iter);
	start_index = _tmp4_;
	_tmp5_ = line;
	_tmp6_ = start_index;
	_tmp11_ = document_structure_search_low_level_item (self, _tmp5_, _tmp6_, &_tmp7_, &_tmp8_, &_tmp9_, &_tmp10_);
	_g_free0 (low_level_type);
	low_level_type = _tmp7_;
	_g_free0 (contents);
	contents = _tmp8_;
	_g_free0 (start_match_index);
	start_match_index = _tmp9_;
	_g_free0 (end_match_index);
	end_match_index = _tmp10_;
	found = _tmp11_;
	_tmp13_ = found;
	if (!_tmp13_) {
		_tmp12_ = TRUE;
	} else {
		gint _tmp14_;
		gint* _tmp15_;
		_tmp14_ = start_index;
		_tmp15_ = start_match_index;
		_tmp12_ = (_tmp14_) != (*_tmp15_);
	}
	_tmp16_ = _tmp12_;
	if (_tmp16_) {
		result = FALSE;
		_g_free0 (end_match_index);
		_g_free0 (start_match_index);
		_g_free0 (contents);
		_g_free0 (low_level_type);
		_g_free0 (line);
		if (end_match_iter) {
			*end_match_iter = _vala_end_match_iter;
		}
		return result;
	}
	_tmp17_ = contents;
	if (_tmp17_ == NULL) {
		gchar* _tmp18_;
		_tmp18_ = g_strdup ("");
		_g_free0 (contents);
		contents = _tmp18_;
	}
	_tmp19_ = item_type;
	_tmp20_ = item_contents;
	_tmp21_ = low_level_type;
	_tmp22_ = contents;
	_tmp23_ = is_start;
	_tmp24_ = document_structure_same_items (self, _tmp19_, _tmp20_, *_tmp21_, _tmp22_, _tmp23_);
	if (_tmp24_) {
		Document* _tmp25_;
		gint _tmp26_;
		gint* _tmp27_;
		GtkTextIter _tmp28_ = {0};
		_tmp25_ = self->priv->_doc;
		_tmp26_ = line_num;
		_tmp27_ = end_match_index;
		gtk_text_buffer_get_iter_at_line_index ((GtkTextBuffer*) _tmp25_, &_tmp28_, _tmp26_, *_tmp27_);
		_vala_end_match_iter = _tmp28_;
		result = TRUE;
		_g_free0 (end_match_index);
		_g_free0 (start_match_index);
		_g_free0 (contents);
		_g_free0 (low_level_type);
		_g_free0 (line);
		if (end_match_iter) {
			*end_match_iter = _vala_end_match_iter;
		}
		return result;
	}
	result = FALSE;
	_g_free0 (end_match_index);
	_g_free0 (start_match_index);
	_g_free0 (contents);
	_g_free0 (low_level_type);
	_g_free0 (line);
	if (end_match_iter) {
		*end_match_iter = _vala_end_match_iter;
	}
	return result;
}


static gboolean document_structure_same_items (DocumentStructure* self, StructType item_type, const gchar* item_contents, DocumentStructureLowLevelType item_found_type, const gchar* item_found_contents, gboolean start) {
	gboolean result = FALSE;
	DocumentStructureLowLevelType _tmp0_;
	StructType _tmp9_;
	StructType _tmp13_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item_contents != NULL, FALSE);
	g_return_val_if_fail (item_found_contents != NULL, FALSE);
	_tmp0_ = item_found_type;
	if (_tmp0_ < DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_NB_COMMON_TYPES) {
		StructType _tmp1_;
		DocumentStructureLowLevelType _tmp2_;
		gboolean same_type;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gboolean same_contents;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_;
		gboolean _tmp8_;
		_tmp1_ = item_type;
		_tmp2_ = item_found_type;
		same_type = _tmp1_ == ((StructType) _tmp2_);
		_tmp3_ = item_contents;
		_tmp4_ = item_found_contents;
		same_contents = g_strcmp0 (_tmp3_, _tmp4_) == 0;
		_tmp6_ = same_type;
		if (_tmp6_) {
			gboolean _tmp7_;
			_tmp7_ = same_contents;
			_tmp5_ = _tmp7_;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp8_ = _tmp5_;
		result = _tmp8_;
		return result;
	}
	_tmp9_ = item_type;
	if (_tmp9_ == STRUCT_TYPE_FIGURE) {
		gboolean _tmp10_;
		_tmp10_ = start;
		if (_tmp10_) {
			DocumentStructureLowLevelType _tmp11_;
			_tmp11_ = item_found_type;
			result = _tmp11_ == DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_FIGURE;
			return result;
		} else {
			DocumentStructureLowLevelType _tmp12_;
			_tmp12_ = item_found_type;
			result = _tmp12_ == DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_FIGURE;
			return result;
		}
	}
	_tmp13_ = item_type;
	if (_tmp13_ == STRUCT_TYPE_TABLE) {
		gboolean _tmp14_;
		_tmp14_ = start;
		if (_tmp14_) {
			DocumentStructureLowLevelType _tmp15_;
			_tmp15_ = item_found_type;
			result = _tmp15_ == DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_TABLE;
			return result;
		} else {
			DocumentStructureLowLevelType _tmp16_;
			_tmp16_ = item_found_type;
			result = _tmp16_ == DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_TABLE;
			return result;
		}
	}
	result = FALSE;
	return result;
}


static gchar* document_structure_get_document_line_contents (DocumentStructure* self, gint line_num) {
	gchar* result = NULL;
	Document* _tmp0_;
	gint _tmp1_ = 0;
	gint nb_lines;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_;
	gboolean _tmp6_;
	GtkTextIter begin = {0};
	Document* _tmp7_;
	gint _tmp8_;
	GtkTextIter _tmp9_ = {0};
	gboolean _tmp10_ = FALSE;
	GtkTextIter _tmp12_;
	GtkTextIter end;
	Document* _tmp13_;
	GtkTextIter _tmp14_;
	GtkTextIter _tmp15_;
	gchar* _tmp16_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_doc;
	_tmp1_ = gtk_text_buffer_get_line_count ((GtkTextBuffer*) _tmp0_);
	nb_lines = _tmp1_;
	_tmp3_ = line_num;
	if (0 <= _tmp3_) {
		gint _tmp4_;
		gint _tmp5_;
		_tmp4_ = line_num;
		_tmp5_ = nb_lines;
		_tmp2_ = _tmp4_ < _tmp5_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp6_ = _tmp2_;
	g_return_val_if_fail (_tmp6_, NULL);
	_tmp7_ = self->priv->_doc;
	_tmp8_ = line_num;
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) _tmp7_, &_tmp9_, _tmp8_);
	begin = _tmp9_;
	_tmp10_ = gtk_text_iter_ends_line (&begin);
	if (_tmp10_) {
		gchar* _tmp11_;
		_tmp11_ = g_strdup ("");
		result = _tmp11_;
		return result;
	}
	_tmp12_ = begin;
	end = _tmp12_;
	gtk_text_iter_forward_to_line_end (&end);
	_tmp13_ = self->priv->_doc;
	_tmp14_ = begin;
	_tmp15_ = end;
	_tmp16_ = gtk_text_buffer_get_text ((GtkTextBuffer*) _tmp13_, &_tmp14_, &_tmp15_, FALSE);
	result = _tmp16_;
	return result;
}


static void document_structure_get_end_document_iter (DocumentStructure* self, gboolean* end_of_file, GtkTextIter* result) {
	gboolean _vala_end_of_file = FALSE;
	GtkTextMark* _tmp0_;
	GtkTextIter eof_iter = {0};
	Document* _tmp4_;
	GtkTextIter _tmp5_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_end_document_mark;
	if (_tmp0_ != NULL) {
		GtkTextIter end_document_iter = {0};
		Document* _tmp1_;
		GtkTextMark* _tmp2_;
		GtkTextIter _tmp3_ = {0};
		_vala_end_of_file = FALSE;
		_tmp1_ = self->priv->_doc;
		_tmp2_ = self->priv->_end_document_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp1_, &_tmp3_, _tmp2_);
		end_document_iter = _tmp3_;
		*result = end_document_iter;
		if (end_of_file) {
			*end_of_file = _vala_end_of_file;
		}
		return;
	}
	_vala_end_of_file = TRUE;
	_tmp4_ = self->priv->_doc;
	gtk_text_buffer_get_end_iter ((GtkTextBuffer*) _tmp4_, &_tmp5_);
	eof_iter = _tmp5_;
	*result = eof_iter;
	if (end_of_file) {
		*end_of_file = _vala_end_of_file;
	}
	return;
}


static void document_structure_backward_indentation (DocumentStructure* self, GtkTextIter* iter) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint line_num;
	GtkTextIter begin_line_iter = {0};
	Document* _tmp2_;
	gint _tmp3_;
	GtkTextIter _tmp4_ = {0};
	Document* _tmp5_;
	GtkTextIter _tmp6_;
	GtkTextIter _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* text_between;
	const gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gboolean _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = gtk_text_iter_starts_line (iter);
	if (_tmp0_) {
		return;
	}
	_tmp1_ = gtk_text_iter_get_line (iter);
	line_num = _tmp1_;
	_tmp2_ = self->priv->_doc;
	_tmp3_ = line_num;
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) _tmp2_, &_tmp4_, _tmp3_);
	begin_line_iter = _tmp4_;
	_tmp5_ = self->priv->_doc;
	_tmp6_ = begin_line_iter;
	_tmp7_ = *iter;
	_tmp8_ = gtk_text_buffer_get_text ((GtkTextBuffer*) _tmp5_, &_tmp6_, &_tmp7_, FALSE);
	text_between = _tmp8_;
	_tmp9_ = text_between;
	_tmp10_ = string_strip (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strcmp0 (_tmp11_, "") == 0;
	_g_free0 (_tmp11_);
	if (_tmp12_) {
		GtkTextIter _tmp13_;
		_tmp13_ = begin_line_iter;
		*iter = _tmp13_;
	}
	_g_free0 (text_between);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean document_structure_shift_item (DocumentStructure* self, GtkTreeIter* tree_iter, gboolean shift_right, gboolean* doc_modified) {
	gboolean _vala_doc_modified = FALSE;
	gboolean result = FALSE;
	StructType type = 0;
	GtkTextMark* mark = NULL;
	StructureModel* _tmp0_;
	GtkTreeIter _tmp1_;
	gboolean _tmp2_;
	StructType _tmp5_;
	gboolean _tmp6_ = FALSE;
	GtkTextIter text_iter = {0};
	Document* _tmp7_;
	GtkTextMark* _tmp8_;
	GtkTextIter _tmp9_ = {0};
	gint _tmp10_ = 0;
	gint line_num;
	gint _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* line;
	const gchar* _tmp13_;
	gint _tmp14_ = 0;
	gint backslash_index;
	const gchar* _tmp15_;
	gint _tmp16_;
	gchar _tmp17_ = '\0';
	gint _tmp18_;
	gint after_backslash_index;
	const gchar* _tmp19_;
	gint _tmp20_;
	gchar* _tmp21_ = NULL;
	gchar* markup_name;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	DocumentStructureLowLevelType* _tmp24_ = NULL;
	DocumentStructureLowLevelType* markup_type;
	DocumentStructureLowLevelType* _tmp25_;
	DocumentStructureLowLevelType* _tmp26_;
	DocumentStructureLowLevelType markup_type_hack;
	StructType _tmp27_;
	DocumentStructureLowLevelType _tmp28_;
	const gchar* _tmp29_;
	gboolean _tmp30_ = FALSE;
	gboolean with_star;
	StructType new_type = 0;
	gboolean _tmp31_;
	StructType _tmp34_;
	gchar* _tmp35_ = NULL;
	gchar* new_markup_name;
	const gchar* _tmp36_;
	gboolean _tmp37_;
	GtkTextIter begin_markup_name_iter = {0};
	Document* _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	GtkTextIter _tmp43_ = {0};
	GtkTextIter end_markup_name_iter = {0};
	Document* _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	const gchar* _tmp47_;
	gint _tmp48_;
	gint _tmp49_;
	GtkTextIter _tmp50_ = {0};
	Document* _tmp51_;
	Document* _tmp52_;
	const gchar* _tmp53_;
	StructureModel* _tmp54_;
	GtkTreeIter _tmp55_;
	gint _tmp56_ = 0;
	gint nb_children;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tree_iter != NULL, FALSE);
	_vala_doc_modified = FALSE;
	_tmp0_ = self->priv->_model;
	_tmp1_ = *tree_iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp0_, &_tmp1_, STRUCT_COLUMN_TYPE, &type, STRUCT_COLUMN_START_MARK, &mark, -1, -1);
	_tmp2_ = shift_right;
	if (_tmp2_) {
		StructType _tmp3_;
		_tmp3_ = type;
		g_return_val_if_fail (_tmp3_ != STRUCT_TYPE_SUBPARAGRAPH, FALSE);
	} else {
		StructType _tmp4_;
		_tmp4_ = type;
		g_return_val_if_fail (_tmp4_ != STRUCT_TYPE_PART, FALSE);
	}
	_tmp5_ = type;
	_tmp6_ = structure_is_section (_tmp5_);
	if (!_tmp6_) {
		result = TRUE;
		_g_object_unref0 (mark);
		if (doc_modified) {
			*doc_modified = _vala_doc_modified;
		}
		return result;
	}
	_tmp7_ = self->priv->_doc;
	_tmp8_ = mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp7_, &_tmp9_, _tmp8_);
	text_iter = _tmp9_;
	_tmp10_ = gtk_text_iter_get_line (&text_iter);
	line_num = _tmp10_;
	_tmp11_ = line_num;
	_tmp12_ = document_structure_get_document_line_contents (self, _tmp11_);
	line = _tmp12_;
	_tmp13_ = line;
	g_return_val_if_fail (_tmp13_ != NULL, FALSE);
	_tmp14_ = gtk_text_iter_get_line_index (&text_iter);
	backslash_index = _tmp14_;
	_tmp15_ = line;
	_tmp16_ = backslash_index;
	_tmp17_ = string_get (_tmp15_, (glong) _tmp16_);
	if (_tmp17_ != '\\') {
		result = FALSE;
		_g_free0 (line);
		_g_object_unref0 (mark);
		if (doc_modified) {
			*doc_modified = _vala_doc_modified;
		}
		return result;
	}
	_tmp18_ = backslash_index;
	after_backslash_index = _tmp18_ + 1;
	_tmp19_ = line;
	_tmp20_ = after_backslash_index;
	_tmp21_ = document_structure_get_markup_name (self, _tmp19_, _tmp20_, NULL);
	markup_name = _tmp21_;
	_tmp22_ = markup_name;
	if (_tmp22_ == NULL) {
		result = FALSE;
		_g_free0 (markup_name);
		_g_free0 (line);
		_g_object_unref0 (mark);
		if (doc_modified) {
			*doc_modified = _vala_doc_modified;
		}
		return result;
	}
	_tmp23_ = markup_name;
	_tmp24_ = document_structure_get_markup_low_level_type (self, _tmp23_);
	markup_type = _tmp24_;
	_tmp25_ = markup_type;
	if (_tmp25_ == NULL) {
		result = FALSE;
		_g_free0 (markup_type);
		_g_free0 (markup_name);
		_g_free0 (line);
		_g_object_unref0 (mark);
		if (doc_modified) {
			*doc_modified = _vala_doc_modified;
		}
		return result;
	}
	_tmp26_ = markup_type;
	markup_type_hack = *_tmp26_;
	_tmp27_ = type;
	_tmp28_ = markup_type_hack;
	if (((gint) _tmp27_) != ((gint) _tmp28_)) {
		result = FALSE;
		_g_free0 (markup_type);
		_g_free0 (markup_name);
		_g_free0 (line);
		_g_object_unref0 (mark);
		if (doc_modified) {
			*doc_modified = _vala_doc_modified;
		}
		return result;
	}
	_tmp29_ = markup_name;
	_tmp30_ = g_str_has_suffix (_tmp29_, "*");
	with_star = _tmp30_;
	_tmp31_ = shift_right;
	if (_tmp31_) {
		StructType _tmp32_;
		_tmp32_ = type;
		new_type = _tmp32_ + 1;
	} else {
		StructType _tmp33_;
		_tmp33_ = type;
		new_type = _tmp33_ - 1;
	}
	_tmp34_ = new_type;
	_tmp35_ = document_structure_get_section_name_from_type (self, _tmp34_);
	new_markup_name = _tmp35_;
	_tmp36_ = new_markup_name;
	g_return_val_if_fail (_tmp36_ != NULL, FALSE);
	_tmp37_ = with_star;
	if (_tmp37_) {
		const gchar* _tmp38_;
		gchar* _tmp39_;
		_tmp38_ = new_markup_name;
		_tmp39_ = g_strconcat (_tmp38_, "*", NULL);
		_g_free0 (new_markup_name);
		new_markup_name = _tmp39_;
	}
	_tmp40_ = self->priv->_doc;
	_tmp41_ = line_num;
	_tmp42_ = after_backslash_index;
	gtk_text_buffer_get_iter_at_line_index ((GtkTextBuffer*) _tmp40_, &_tmp43_, _tmp41_, _tmp42_);
	begin_markup_name_iter = _tmp43_;
	_tmp44_ = self->priv->_doc;
	_tmp45_ = line_num;
	_tmp46_ = after_backslash_index;
	_tmp47_ = markup_name;
	_tmp48_ = strlen (_tmp47_);
	_tmp49_ = _tmp48_;
	gtk_text_buffer_get_iter_at_line_index ((GtkTextBuffer*) _tmp44_, &_tmp50_, _tmp45_, _tmp46_ + _tmp49_);
	end_markup_name_iter = _tmp50_;
	_tmp51_ = self->priv->_doc;
	gtk_text_buffer_delete ((GtkTextBuffer*) _tmp51_, &begin_markup_name_iter, &end_markup_name_iter);
	_tmp52_ = self->priv->_doc;
	_tmp53_ = new_markup_name;
	document_insert (_tmp52_, &begin_markup_name_iter, _tmp53_, -1);
	_vala_doc_modified = TRUE;
	_tmp54_ = self->priv->_model;
	_tmp55_ = *tree_iter;
	_tmp56_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp54_, &_tmp55_);
	nb_children = _tmp56_;
	{
		gint child_num;
		child_num = 0;
		{
			gboolean _tmp57_;
			_tmp57_ = TRUE;
			while (TRUE) {
				gboolean _tmp58_;
				gint _tmp60_;
				gint _tmp61_;
				GtkTreeIter child_iter = {0};
				StructureModel* _tmp62_;
				GtkTreeIter _tmp63_;
				gint _tmp64_;
				GtkTreeIter _tmp65_ = {0};
				gboolean _tmp66_ = FALSE;
				gboolean child_iter_set;
				gboolean _tmp67_;
				GtkTreeIter _tmp68_;
				gboolean _tmp69_;
				gboolean _tmp70_ = FALSE;
				_tmp58_ = _tmp57_;
				if (!_tmp58_) {
					gint _tmp59_;
					_tmp59_ = child_num;
					child_num = _tmp59_ + 1;
				}
				_tmp57_ = FALSE;
				_tmp60_ = child_num;
				_tmp61_ = nb_children;
				if (!(_tmp60_ < _tmp61_)) {
					break;
				}
				_tmp62_ = self->priv->_model;
				_tmp63_ = *tree_iter;
				_tmp64_ = child_num;
				_tmp66_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp62_, &_tmp65_, &_tmp63_, _tmp64_);
				child_iter = _tmp65_;
				child_iter_set = _tmp66_;
				_tmp67_ = child_iter_set;
				g_return_val_if_fail (_tmp67_, FALSE);
				_tmp68_ = child_iter;
				_tmp69_ = shift_right;
				_tmp70_ = document_structure_shift_item (self, &_tmp68_, _tmp69_, NULL);
				if (!_tmp70_) {
					result = FALSE;
					_g_free0 (new_markup_name);
					_g_free0 (markup_type);
					_g_free0 (markup_name);
					_g_free0 (line);
					_g_object_unref0 (mark);
					if (doc_modified) {
						*doc_modified = _vala_doc_modified;
					}
					return result;
				}
			}
		}
	}
	result = TRUE;
	_g_free0 (new_markup_name);
	_g_free0 (markup_type);
	_g_free0 (markup_name);
	_g_free0 (line);
	_g_object_unref0 (mark);
	if (doc_modified) {
		*doc_modified = _vala_doc_modified;
	}
	return result;
}


static gchar* document_structure_get_section_name_from_type (DocumentStructure* self, StructType type) {
	gchar* result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	StructType _tmp23_;
	gboolean _tmp24_ = FALSE;
	gchar** _tmp25_;
	gint _tmp25__length1;
	StructType _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = document_structure__section_names;
	_tmp0__length1 = document_structure__section_names_length1;
	if (_tmp0_ == NULL) {
		gchar** _tmp1_ = NULL;
		gchar** _tmp2_;
		gint _tmp2__length1;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar** _tmp5_;
		gint _tmp5__length1;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar** _tmp14_;
		gint _tmp14__length1;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar** _tmp17_;
		gint _tmp17__length1;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar** _tmp20_;
		gint _tmp20__length1;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp1_ = g_new0 (gchar*, 7 + 1);
		document_structure__section_names = (_vala_array_free (document_structure__section_names, document_structure__section_names_length1, (GDestroyNotify) g_free), NULL);
		document_structure__section_names = _tmp1_;
		document_structure__section_names_length1 = 7;
		_document_structure__section_names_size_ = document_structure__section_names_length1;
		_tmp2_ = document_structure__section_names;
		_tmp2__length1 = document_structure__section_names_length1;
		_tmp3_ = g_strdup ("part");
		_g_free0 (_tmp2_[STRUCT_TYPE_PART]);
		_tmp2_[STRUCT_TYPE_PART] = _tmp3_;
		_tmp4_ = _tmp2_[STRUCT_TYPE_PART];
		_tmp5_ = document_structure__section_names;
		_tmp5__length1 = document_structure__section_names_length1;
		_tmp6_ = g_strdup ("chapter");
		_g_free0 (_tmp5_[STRUCT_TYPE_CHAPTER]);
		_tmp5_[STRUCT_TYPE_CHAPTER] = _tmp6_;
		_tmp7_ = _tmp5_[STRUCT_TYPE_CHAPTER];
		_tmp8_ = document_structure__section_names;
		_tmp8__length1 = document_structure__section_names_length1;
		_tmp9_ = g_strdup ("section");
		_g_free0 (_tmp8_[STRUCT_TYPE_SECTION]);
		_tmp8_[STRUCT_TYPE_SECTION] = _tmp9_;
		_tmp10_ = _tmp8_[STRUCT_TYPE_SECTION];
		_tmp11_ = document_structure__section_names;
		_tmp11__length1 = document_structure__section_names_length1;
		_tmp12_ = g_strdup ("subsection");
		_g_free0 (_tmp11_[STRUCT_TYPE_SUBSECTION]);
		_tmp11_[STRUCT_TYPE_SUBSECTION] = _tmp12_;
		_tmp13_ = _tmp11_[STRUCT_TYPE_SUBSECTION];
		_tmp14_ = document_structure__section_names;
		_tmp14__length1 = document_structure__section_names_length1;
		_tmp15_ = g_strdup ("subsubsection");
		_g_free0 (_tmp14_[STRUCT_TYPE_SUBSUBSECTION]);
		_tmp14_[STRUCT_TYPE_SUBSUBSECTION] = _tmp15_;
		_tmp16_ = _tmp14_[STRUCT_TYPE_SUBSUBSECTION];
		_tmp17_ = document_structure__section_names;
		_tmp17__length1 = document_structure__section_names_length1;
		_tmp18_ = g_strdup ("paragraph");
		_g_free0 (_tmp17_[STRUCT_TYPE_PARAGRAPH]);
		_tmp17_[STRUCT_TYPE_PARAGRAPH] = _tmp18_;
		_tmp19_ = _tmp17_[STRUCT_TYPE_PARAGRAPH];
		_tmp20_ = document_structure__section_names;
		_tmp20__length1 = document_structure__section_names_length1;
		_tmp21_ = g_strdup ("subparagraph");
		_g_free0 (_tmp20_[STRUCT_TYPE_SUBPARAGRAPH]);
		_tmp20_[STRUCT_TYPE_SUBPARAGRAPH] = _tmp21_;
		_tmp22_ = _tmp20_[STRUCT_TYPE_SUBPARAGRAPH];
	}
	_tmp23_ = type;
	_tmp24_ = structure_is_section (_tmp23_);
	g_return_val_if_fail (_tmp24_, NULL);
	_tmp25_ = document_structure__section_names;
	_tmp25__length1 = document_structure__section_names_length1;
	_tmp26_ = type;
	_tmp27_ = _tmp25_[_tmp26_];
	_tmp28_ = g_strdup (_tmp27_);
	result = _tmp28_;
	return result;
}


gboolean document_structure_get_parsing_done (DocumentStructure* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_parsing_done;
	result = _tmp0_;
	return result;
}


static void document_structure_set_parsing_done (DocumentStructure* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_parsing_done = _tmp0_;
	g_object_notify ((GObject *) self, "parsing-done");
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


static void document_structure_env_data_copy (const DocumentStructureEnvData* self, DocumentStructureEnvData* dest) {
	GtkTreePath* _tmp0_;
	GtkTreePath* _tmp1_;
	StructType _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	_tmp0_ = (*self).path;
	_tmp1_ = _gtk_tree_path_copy0 (_tmp0_);
	_gtk_tree_path_free0 ((*dest).path);
	(*dest).path = _tmp1_;
	_tmp2_ = (*self).type;
	(*dest).type = _tmp2_;
	_tmp3_ = (*self).first_caption;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 ((*dest).first_caption);
	(*dest).first_caption = _tmp4_;
}


static void document_structure_env_data_destroy (DocumentStructureEnvData* self) {
	_gtk_tree_path_free0 ((*self).path);
	_g_free0 ((*self).first_caption);
}


static DocumentStructureEnvData* document_structure_env_data_dup (const DocumentStructureEnvData* self) {
	DocumentStructureEnvData* dup;
	dup = g_new0 (DocumentStructureEnvData, 1);
	document_structure_env_data_copy (self, dup);
	return dup;
}


static void document_structure_env_data_free (DocumentStructureEnvData* self) {
	document_structure_env_data_destroy (self);
	g_free (self);
}


static GType document_structure_env_data_get_type (void) {
	static volatile gsize document_structure_env_data_type_id__volatile = 0;
	if (g_once_init_enter (&document_structure_env_data_type_id__volatile)) {
		GType document_structure_env_data_type_id;
		document_structure_env_data_type_id = g_boxed_type_register_static ("DocumentStructureEnvData", (GBoxedCopyFunc) document_structure_env_data_dup, (GBoxedFreeFunc) document_structure_env_data_free);
		g_once_init_leave (&document_structure_env_data_type_id__volatile, document_structure_env_data_type_id);
	}
	return document_structure_env_data_type_id__volatile;
}


static void document_structure_class_init (DocumentStructureClass * klass) {
	document_structure_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DocumentStructurePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_document_structure_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_document_structure_set_property;
	G_OBJECT_CLASS (klass)->finalize = document_structure_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_STRUCTURE_PARSING_DONE, g_param_spec_boolean ("parsing-done", "parsing-done", "parsing-done", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void document_structure_instance_init (DocumentStructure * self) {
	self->priv = DOCUMENT_STRUCTURE_GET_PRIVATE (self);
	self->priv->_nb_marks = 0;
	self->priv->_end_document_mark = NULL;
	self->priv->_model = NULL;
	self->priv->_in_verbatim_env = FALSE;
	self->priv->_last_env_data = NULL;
	self->priv->_start_parsing_line = 0;
	self->priv->_timer = NULL;
	self->priv->_parsing_done = FALSE;
}


static void document_structure_finalize (GObject* obj) {
	DocumentStructure * self;
	self = DOCUMENT_STRUCTURE (obj);
	_g_object_unref0 (self->priv->_end_document_mark);
	_g_object_unref0 (self->priv->_model);
	_document_structure_env_data_free0 (self->priv->_last_env_data);
	_g_timer_destroy0 (self->priv->_timer);
	G_OBJECT_CLASS (document_structure_parent_class)->finalize (obj);
}


GType document_structure_get_type (void) {
	static volatile gsize document_structure_type_id__volatile = 0;
	if (g_once_init_enter (&document_structure_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DocumentStructureClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) document_structure_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DocumentStructure), 0, (GInstanceInitFunc) document_structure_instance_init, NULL };
		GType document_structure_type_id;
		document_structure_type_id = g_type_register_static (G_TYPE_OBJECT, "DocumentStructure", &g_define_type_info, 0);
		g_once_init_leave (&document_structure_type_id__volatile, document_structure_type_id);
	}
	return document_structure_type_id__volatile;
}


static void _vala_document_structure_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DocumentStructure * self;
	self = DOCUMENT_STRUCTURE (object);
	switch (property_id) {
		case DOCUMENT_STRUCTURE_PARSING_DONE:
		g_value_set_boolean (value, document_structure_get_parsing_done (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_document_structure_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DocumentStructure * self;
	self = DOCUMENT_STRUCTURE (object);
	switch (property_id) {
		case DOCUMENT_STRUCTURE_PARSING_DONE:
		document_structure_set_parsing_done (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



