/* document_view.c generated by valac 0.16.1, the Vala compiler
 * generated from document_view.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtksourceview/gtksourceview.h>
#include <gio/gio.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include "gtkspell/gtkspell.h"


#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;
typedef struct _DocumentViewPrivate DocumentViewPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _pango_font_description_free0(var) ((var == NULL) ? NULL : (var = (pango_font_description_free (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_COMPLETION_PROVIDER (completion_provider_get_type ())
#define COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_PROVIDER, CompletionProvider))
#define COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))
#define IS_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_PROVIDER))
#define IS_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_PROVIDER))
#define COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))

typedef struct _CompletionProvider CompletionProvider;
typedef struct _CompletionProviderClass CompletionProviderClass;
typedef struct _Block4Data Block4Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_APP_SETTINGS (app_settings_get_type ())
#define APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_SETTINGS, AppSettings))
#define APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_SETTINGS, AppSettingsClass))
#define IS_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_SETTINGS))
#define IS_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_SETTINGS))
#define APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_SETTINGS, AppSettingsClass))

typedef struct _AppSettings AppSettings;
typedef struct _AppSettingsClass AppSettingsClass;
#define _0(var) ((var == NULL) ? NULL : (var = ( (var), NULL)))

struct _DocumentView {
	GtkSourceView parent_instance;
	DocumentViewPrivate * priv;
};

struct _DocumentViewClass {
	GtkSourceViewClass parent_class;
};

struct _DocumentViewPrivate {
	GSettings* _editor_settings;
	PangoFontDescription* _font_desc;
};

struct _Block4Data {
	int _ref_count_;
	DocumentView * self;
	CompletionProvider* provider;
};


static gpointer document_view_parent_class = NULL;

GType document_view_get_type (void) G_GNUC_CONST;
#define DOCUMENT_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DOCUMENT_VIEW, DocumentViewPrivate))
enum  {
	DOCUMENT_VIEW_DUMMY_PROPERTY
};
#define DOCUMENT_VIEW_SCROLL_MARGIN 0.02
GType document_get_type (void) G_GNUC_CONST;
DocumentView* document_view_new (Document* doc);
DocumentView* document_view_construct (GType object_type, Document* doc);
static void __lambda133_ (DocumentView* self, GObject* d, GParamSpec* p);
gboolean document_get_readonly (Document* self);
static void ___lambda133__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void document_view_set_font_from_settings (DocumentView* self);
void document_set_style_scheme_from_string (Document* self, const gchar* scheme_id);
GType completion_provider_get_type (void) G_GNUC_CONST;
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
CompletionProvider* completion_provider_get_default (void);
static void ___lambda134_ (Block4Data* _data4_);
void completion_provider_hide_calltip_window (CompletionProvider* self);
static void ____lambda134__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean document_view_on_backspace (DocumentView* self, GdkEventKey* event);
static gboolean _document_view_on_backspace_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
void document_view_activate_spell_checking (DocumentView* self);
void document_view_scroll_to_cursor (DocumentView* self, gdouble margin);
void document_view_cut_selection (DocumentView* self);
void document_view_copy_selection (DocumentView* self);
void document_view_my_paste_clipboard (DocumentView* self);
void document_view_delete_selection (DocumentView* self);
void document_view_my_select_all (DocumentView* self);
guint document_view_my_get_visual_column (DocumentView* self, GtkTextIter* iter);
GType app_settings_get_type (void) G_GNUC_CONST;
AppSettings* app_settings_get_default (void);
const gchar* app_settings_get_system_font (AppSettings* self);
void document_view_set_font_from_string (DocumentView* self, const gchar* font);
void document_view_enlarge_font (DocumentView* self);
void document_view_shrink_font (DocumentView* self);
gchar* document_view_get_indentation_style (DocumentView* self);
void document_view_disable_spell_checking (DocumentView* self);
static void document_view_finalize (GObject* obj);


static void __lambda133_ (DocumentView* self, GObject* d, GParamSpec* p) {
	GObject* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (d != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = d;
	_tmp1_ = document_get_readonly (DOCUMENT (_tmp0_));
	_tmp2_ = _tmp1_;
	gtk_text_view_set_editable ((GtkTextView*) self, !_tmp2_);
}


static void ___lambda133__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda133_ (self, _sender, pspec);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		DocumentView * self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->provider);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static void ___lambda134_ (Block4Data* _data4_) {
	DocumentView * self;
	self = _data4_->self;
	completion_provider_hide_calltip_window (_data4_->provider);
}


static void ____lambda134__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	___lambda134_ (self);
}


static gboolean _document_view_on_backspace_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = document_view_on_backspace (self, event);
	return result;
}


DocumentView* document_view_construct (GType object_type, Document* doc) {
	DocumentView * self = NULL;
	Document* _tmp0_;
	Document* _tmp1_;
	GSettings* _tmp2_;
	guint tmp = 0U;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GSettings* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GSettings* _tmp8_;
	gboolean _tmp9_ = FALSE;
	Document* _tmp10_;
	GSettings* _tmp11_;
	gboolean _tmp12_ = FALSE;
	Document* _tmp13_;
	GSettings* _tmp14_;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	GSettings* _tmp26_;
	gboolean _tmp27_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (doc != NULL, NULL);
	self = (DocumentView*) g_object_new (object_type, NULL);
	_tmp0_ = doc;
	gtk_text_view_set_buffer ((GtkTextView*) self, (GtkTextBuffer*) _tmp0_);
	_tmp1_ = doc;
	g_signal_connect_object ((GObject*) _tmp1_, "notify::readonly", (GCallback) ___lambda133__g_object_notify, self, 0);
	gtk_text_view_set_wrap_mode ((GtkTextView*) self, GTK_WRAP_WORD);
	gtk_source_view_set_auto_indent ((GtkSourceView*) self, TRUE);
	gtk_source_view_set_indent_width ((GtkSourceView*) self, -1);
	_tmp2_ = g_settings_new ("org.gnome.latexila.preferences.editor");
	_g_object_unref0 (self->priv->_editor_settings);
	self->priv->_editor_settings = _tmp2_;
	document_view_set_font_from_settings (self);
	_tmp3_ = self->priv->_editor_settings;
	g_settings_get (_tmp3_, "tabs-size", "u", &tmp);
	gtk_source_view_set_tab_width ((GtkSourceView*) self, tmp);
	_tmp4_ = self->priv->_editor_settings;
	_tmp5_ = g_settings_get_boolean (_tmp4_, "insert-spaces");
	gtk_source_view_set_insert_spaces_instead_of_tabs ((GtkSourceView*) self, _tmp5_);
	_tmp6_ = self->priv->_editor_settings;
	_tmp7_ = g_settings_get_boolean (_tmp6_, "display-line-numbers");
	gtk_source_view_set_show_line_numbers ((GtkSourceView*) self, _tmp7_);
	_tmp8_ = self->priv->_editor_settings;
	_tmp9_ = g_settings_get_boolean (_tmp8_, "highlight-current-line");
	gtk_source_view_set_highlight_current_line ((GtkSourceView*) self, _tmp9_);
	_tmp10_ = doc;
	_tmp11_ = self->priv->_editor_settings;
	_tmp12_ = g_settings_get_boolean (_tmp11_, "bracket-matching");
	gtk_source_buffer_set_highlight_matching_brackets ((GtkSourceBuffer*) _tmp10_, _tmp12_);
	_tmp13_ = doc;
	_tmp14_ = self->priv->_editor_settings;
	_tmp15_ = g_settings_get_string (_tmp14_, "scheme");
	_tmp16_ = _tmp15_;
	document_set_style_scheme_from_string (_tmp13_, _tmp16_);
	_g_free0 (_tmp16_);
	gtk_source_view_set_smart_home_end ((GtkSourceView*) self, GTK_SOURCE_SMART_HOME_END_AFTER);
	{
		Block4Data* _data4_;
		CompletionProvider* _tmp17_ = NULL;
		GtkSourceCompletion* _tmp18_;
		GtkSourceCompletion* _tmp19_;
		GtkSourceCompletion* _tmp20_;
		GtkSourceCompletion* _tmp21_;
		GtkTextBuffer* _tmp22_;
		GtkTextBuffer* _tmp23_;
		_data4_ = g_slice_new0 (Block4Data);
		_data4_->_ref_count_ = 1;
		_data4_->self = g_object_ref (self);
		_tmp17_ = completion_provider_get_default ();
		_data4_->provider = _tmp17_;
		_tmp18_ = gtk_source_view_get_completion ((GtkSourceView*) self);
		_tmp19_ = _tmp18_;
		gtk_source_completion_add_provider (_tmp19_, (GtkSourceCompletionProvider*) _data4_->provider, &_inner_error_);
		if (_inner_error_ != NULL) {
			block4_data_unref (_data4_);
			_data4_ = NULL;
			goto __catch15_g_error;
		}
		_tmp20_ = gtk_source_view_get_completion ((GtkSourceView*) self);
		_tmp21_ = _tmp20_;
		g_object_set (_tmp21_, "remember-info-visibility", TRUE, NULL);
		_tmp22_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp23_ = _tmp22_;
		g_signal_connect_data ((GObject*) _tmp23_, "notify::cursor-position", (GCallback) ____lambda134__g_object_notify, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
		block4_data_unref (_data4_);
		_data4_ = NULL;
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError* e = NULL;
		GError* _tmp24_;
		const gchar* _tmp25_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->message;
		g_warning ("document_view.vala:77: Completion: %s", _tmp25_);
		_g_error_free0 (e);
	}
	__finally15:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	g_signal_connect_object ((GtkWidget*) self, "key-press-event", (GCallback) _document_view_on_backspace_gtk_widget_key_press_event, self, 0);
	_tmp26_ = self->priv->_editor_settings;
	_tmp27_ = g_settings_get_boolean (_tmp26_, "spell-checking");
	if (_tmp27_) {
		document_view_activate_spell_checking (self);
	}
	return self;
}


DocumentView* document_view_new (Document* doc) {
	return document_view_construct (TYPE_DOCUMENT_VIEW, doc);
}


void document_view_scroll_to_cursor (DocumentView* self, gdouble margin) {
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextMark* _tmp2_ = NULL;
	gdouble _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_text_buffer_get_insert (_tmp1_);
	_tmp3_ = margin;
	gtk_text_view_scroll_to_mark ((GtkTextView*) self, _tmp2_, _tmp3_, FALSE, (gdouble) 0, (gdouble) 0);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void document_view_cut_selection (DocumentView* self) {
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkClipboard* _tmp2_ = NULL;
	GtkClipboard* _tmp3_;
	GtkClipboard* clipboard;
	GtkTextBuffer* _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkTextBuffer* _tmp6_;
	GtkTextBuffer* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = gtk_widget_get_clipboard ((GtkWidget*) self, GDK_SELECTION_CLIPBOARD);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	clipboard = _tmp3_;
	_tmp4_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = document_get_readonly (DOCUMENT (_tmp7_));
	_tmp9_ = _tmp8_;
	gtk_text_buffer_cut_clipboard (_tmp5_, clipboard, !_tmp9_);
	document_view_scroll_to_cursor (self, DOCUMENT_VIEW_SCROLL_MARGIN);
	gtk_widget_grab_focus ((GtkWidget*) self);
	_g_object_unref0 (clipboard);
}


void document_view_copy_selection (DocumentView* self) {
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkClipboard* _tmp2_ = NULL;
	GtkClipboard* _tmp3_;
	GtkClipboard* clipboard;
	GtkTextBuffer* _tmp4_;
	GtkTextBuffer* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = gtk_widget_get_clipboard ((GtkWidget*) self, GDK_SELECTION_CLIPBOARD);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	clipboard = _tmp3_;
	_tmp4_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp5_ = _tmp4_;
	gtk_text_buffer_copy_clipboard (_tmp5_, clipboard);
	gtk_widget_grab_focus ((GtkWidget*) self);
	_g_object_unref0 (clipboard);
}


void document_view_my_paste_clipboard (DocumentView* self) {
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkClipboard* _tmp2_ = NULL;
	GtkClipboard* _tmp3_;
	GtkClipboard* clipboard;
	GtkTextBuffer* _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkTextBuffer* _tmp6_;
	GtkTextBuffer* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = gtk_widget_get_clipboard ((GtkWidget*) self, GDK_SELECTION_CLIPBOARD);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	clipboard = _tmp3_;
	_tmp4_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = document_get_readonly (DOCUMENT (_tmp7_));
	_tmp9_ = _tmp8_;
	gtk_text_buffer_paste_clipboard (_tmp5_, clipboard, NULL, !_tmp9_);
	document_view_scroll_to_cursor (self, DOCUMENT_VIEW_SCROLL_MARGIN);
	gtk_widget_grab_focus ((GtkWidget*) self);
	_g_object_unref0 (clipboard);
}


void document_view_delete_selection (DocumentView* self) {
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* _tmp4_;
	GtkTextBuffer* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = document_get_readonly (DOCUMENT (_tmp5_));
	_tmp7_ = _tmp6_;
	gtk_text_buffer_delete_selection (_tmp3_, TRUE, !_tmp7_);
	document_view_scroll_to_cursor (self, DOCUMENT_VIEW_SCROLL_MARGIN);
}


void document_view_my_select_all (DocumentView* self) {
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextIter _tmp4_ = {0};
	GtkTextIter _tmp5_ = {0};
	GtkTextBuffer* _tmp6_;
	GtkTextBuffer* _tmp7_;
	GtkTextIter _tmp8_;
	GtkTextIter _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp3_ = _tmp2_;
	gtk_text_buffer_get_bounds (_tmp3_, &_tmp4_, &_tmp5_);
	start = _tmp4_;
	end = _tmp5_;
	_tmp6_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = start;
	_tmp9_ = end;
	gtk_text_buffer_select_range (_tmp7_, &_tmp8_, &_tmp9_);
}


guint document_view_my_get_visual_column (DocumentView* self, GtkTextIter* iter) {
	guint result = 0U;
	guint column;
	guint _tmp0_ = 0U;
	guint tab_width;
	GtkTextIter _tmp1_;
	GtkTextIter position;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (iter != NULL, 0U);
	column = (guint) 0;
	_tmp0_ = gtk_source_view_get_tab_width ((GtkSourceView*) self);
	tab_width = _tmp0_;
	_tmp1_ = *iter;
	position = _tmp1_;
	gtk_text_iter_set_visible_line_offset (&position, 0);
	while (TRUE) {
		GtkTextIter _tmp2_;
		gboolean _tmp3_ = FALSE;
		gunichar _tmp4_ = 0U;
		gboolean _tmp10_ = FALSE;
		_tmp2_ = position;
		_tmp3_ = gtk_text_iter_equal (iter, &_tmp2_);
		if (!(!_tmp3_)) {
			break;
		}
		_tmp4_ = gtk_text_iter_get_char (&position);
		if (_tmp4_ == ((gunichar) '\t')) {
			guint _tmp5_;
			guint _tmp6_;
			guint _tmp7_;
			guint _tmp8_;
			_tmp5_ = column;
			_tmp6_ = tab_width;
			_tmp7_ = column;
			_tmp8_ = tab_width;
			column = _tmp5_ + (_tmp6_ - (_tmp7_ % _tmp8_));
		} else {
			guint _tmp9_;
			_tmp9_ = column;
			column = _tmp9_ + 1;
		}
		_tmp10_ = gtk_text_iter_forward_char (&position);
		if (!_tmp10_) {
			break;
		}
	}
	result = column;
	return result;
}


void document_view_set_font_from_settings (DocumentView* self) {
	gchar* font = NULL;
	GSettings* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_editor_settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "use-default-font");
	if (_tmp1_) {
		AppSettings* _tmp2_ = NULL;
		AppSettings* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp2_ = app_settings_get_default ();
		_tmp3_ = _tmp2_;
		_tmp4_ = app_settings_get_system_font (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (font);
		font = _tmp6_;
		_g_object_unref0 (_tmp3_);
	} else {
		GSettings* _tmp7_;
		gchar* _tmp8_ = NULL;
		_tmp7_ = self->priv->_editor_settings;
		_tmp8_ = g_settings_get_string (_tmp7_, "editor-font");
		_g_free0 (font);
		font = _tmp8_;
	}
	_tmp9_ = font;
	document_view_set_font_from_string (self, _tmp9_);
	_g_free0 (font);
}


void document_view_set_font_from_string (DocumentView* self, const gchar* font) {
	const gchar* _tmp0_;
	PangoFontDescription* _tmp1_ = NULL;
	const PangoFontDescription* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (font != NULL);
	_tmp0_ = font;
	_tmp1_ = pango_font_description_from_string (_tmp0_);
	_pango_font_description_free0 (self->priv->_font_desc);
	self->priv->_font_desc = _tmp1_;
	_tmp2_ = self->priv->_font_desc;
	gtk_widget_modify_font ((GtkWidget*) self, _tmp2_);
}


void document_view_enlarge_font (DocumentView* self) {
	const PangoFontDescription* _tmp0_;
	const PangoFontDescription* _tmp1_;
	gint _tmp2_ = 0;
	const PangoFontDescription* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_font_desc;
	_tmp1_ = self->priv->_font_desc;
	_tmp2_ = pango_font_description_get_size (_tmp1_);
	pango_font_description_set_size (_tmp0_, _tmp2_ + PANGO_SCALE);
	_tmp3_ = self->priv->_font_desc;
	gtk_widget_modify_font ((GtkWidget*) self, _tmp3_);
}


void document_view_shrink_font (DocumentView* self) {
	const PangoFontDescription* _tmp0_;
	const PangoFontDescription* _tmp1_;
	gint _tmp2_ = 0;
	const PangoFontDescription* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_font_desc;
	_tmp1_ = self->priv->_font_desc;
	_tmp2_ = pango_font_description_get_size (_tmp1_);
	pango_font_description_set_size (_tmp0_, _tmp2_ - PANGO_SCALE);
	_tmp3_ = self->priv->_font_desc;
	gtk_widget_modify_font ((GtkWidget*) self, _tmp3_);
}


gchar* document_view_get_indentation_style (DocumentView* self) {
	gchar* result = NULL;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gchar* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_source_view_get_insert_spaces_instead_of_tabs ((GtkSourceView*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		guint _tmp2_;
		guint _tmp3_;
		gchar* _tmp4_ = NULL;
		_tmp2_ = gtk_source_view_get_tab_width ((GtkSourceView*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strnfill ((gsize) _tmp3_, ' ');
		result = _tmp4_;
		return result;
	}
	_tmp5_ = g_strdup ("\t");
	result = _tmp5_;
	return result;
}


void document_view_activate_spell_checking (DocumentView* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	document_view_disable_spell_checking (self);
	{
		GtkSpell* _tmp0_;
		GtkSpell* _tmp1_;
		_tmp0_ = gtkspell_new_attach ((GtkTextView*) self, NULL, &_inner_error_);
		_tmp1_ = _tmp0_;
		_0 (_tmp1_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == GTKSPELL_ERROR) {
				goto __catch16_gtkspell_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally16;
	__catch16_gtkspell_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("document_view.vala:207: Spell error: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally16:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void document_view_disable_spell_checking (DocumentView* self) {
	GtkSpell* _tmp0_ = NULL;
	GtkSpell* spell;
	GtkSpell* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtkspell_get_from_text_view ((GtkTextView*) self);
	spell = _tmp0_;
	_tmp1_ = spell;
	if (_tmp1_ != NULL) {
		GtkSpell* _tmp2_;
		_tmp2_ = spell;
		gtkspell_detach (_tmp2_);
	}
	_0 (spell);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean document_view_on_backspace (DocumentView* self, GdkEventKey* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GSettings* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp8_;
	gboolean _tmp11_;
	gboolean _tmp16_;
	gboolean _tmp19_;
	GtkTextIter iter_start = {0};
	GtkTextIter iter_insert = {0};
	GtkTextBuffer* _tmp20_;
	GtkTextBuffer* _tmp21_;
	GtkTextBuffer* _tmp22_;
	GtkTextBuffer* _tmp23_;
	GtkTextMark* _tmp24_ = NULL;
	GtkTextIter _tmp25_ = {0};
	GtkTextBuffer* _tmp26_;
	GtkTextBuffer* _tmp27_;
	gint _tmp28_ = 0;
	GtkTextIter _tmp29_ = {0};
	GtkTextBuffer* _tmp30_;
	GtkTextBuffer* _tmp31_;
	GtkTextIter _tmp32_;
	GtkTextIter _tmp33_;
	gchar* _tmp34_ = NULL;
	gchar* text;
	const gchar* _tmp35_;
	gint nb_chars_to_delete;
	gboolean between;
	GtkTextIter _tmp54_;
	gint _tmp55_;
	gboolean _tmp56_ = FALSE;
	GtkTextBuffer* _tmp57_;
	GtkTextBuffer* _tmp58_;
	GtkTextBuffer* _tmp59_;
	GtkTextBuffer* _tmp60_;
	GtkTextIter _tmp61_;
	GtkTextIter _tmp62_;
	GtkTextBuffer* _tmp63_;
	GtkTextBuffer* _tmp64_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp4_ = self->priv->_editor_settings;
	_tmp5_ = g_settings_get_boolean (_tmp4_, "insert-spaces");
	if (!_tmp5_) {
		_tmp3_ = TRUE;
	} else {
		GSettings* _tmp6_;
		gboolean _tmp7_ = FALSE;
		_tmp6_ = self->priv->_editor_settings;
		_tmp7_ = g_settings_get_boolean (_tmp6_, "forget-no-tabs");
		_tmp3_ = !_tmp7_;
	}
	_tmp8_ = _tmp3_;
	if (_tmp8_) {
		_tmp2_ = TRUE;
	} else {
		GdkEventKey _tmp9_;
		guint _tmp10_;
		_tmp9_ = *event;
		_tmp10_ = _tmp9_.keyval;
		_tmp2_ = _tmp10_ != ((guint) 0xff08);
	}
	_tmp11_ = _tmp2_;
	if (_tmp11_) {
		_tmp1_ = TRUE;
	} else {
		GtkTextBuffer* _tmp12_;
		GtkTextBuffer* _tmp13_;
		gboolean _tmp14_;
		gboolean _tmp15_;
		_tmp12_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp13_ = _tmp12_;
		_tmp14_ = gtk_text_buffer_get_has_selection (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp1_ = _tmp15_;
	}
	_tmp16_ = _tmp1_;
	if (_tmp16_) {
		_tmp0_ = TRUE;
	} else {
		guint _tmp17_;
		guint _tmp18_;
		_tmp17_ = gtk_source_view_get_tab_width ((GtkSourceView*) self);
		_tmp18_ = _tmp17_;
		_tmp0_ = _tmp18_ == ((guint) 1);
	}
	_tmp19_ = _tmp0_;
	if (_tmp19_) {
		result = FALSE;
		return result;
	}
	_tmp20_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp23_ = _tmp22_;
	_tmp24_ = gtk_text_buffer_get_insert (_tmp23_);
	gtk_text_buffer_get_iter_at_mark (_tmp21_, &_tmp25_, _tmp24_);
	iter_insert = _tmp25_;
	_tmp26_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp27_ = _tmp26_;
	_tmp28_ = gtk_text_iter_get_line (&iter_insert);
	gtk_text_buffer_get_iter_at_line (_tmp27_, &_tmp29_, _tmp28_);
	iter_start = _tmp29_;
	_tmp30_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp31_ = _tmp30_;
	_tmp32_ = iter_start;
	_tmp33_ = iter_insert;
	_tmp34_ = gtk_text_buffer_get_text (_tmp31_, &_tmp32_, &_tmp33_, FALSE);
	text = _tmp34_;
	_tmp35_ = text;
	if (g_strcmp0 (_tmp35_, "") == 0) {
		result = FALSE;
		_g_free0 (text);
		return result;
	}
	nb_chars_to_delete = 0;
	between = TRUE;
	{
		glong i;
		i = (glong) 0;
		{
			gboolean _tmp36_;
			_tmp36_ = TRUE;
			while (TRUE) {
				gboolean _tmp37_;
				glong _tmp39_;
				const gchar* _tmp40_;
				gint _tmp41_;
				gint _tmp42_;
				const gchar* _tmp43_;
				glong _tmp44_;
				gchar _tmp45_ = '\0';
				const gchar* _tmp46_;
				glong _tmp47_;
				gchar _tmp48_ = '\0';
				gboolean _tmp49_;
				gint _tmp50_;
				gint _tmp51_;
				guint _tmp52_;
				guint _tmp53_;
				_tmp37_ = _tmp36_;
				if (!_tmp37_) {
					glong _tmp38_;
					_tmp38_ = i;
					i = _tmp38_ + 1;
				}
				_tmp36_ = FALSE;
				_tmp39_ = i;
				_tmp40_ = text;
				_tmp41_ = strlen (_tmp40_);
				_tmp42_ = _tmp41_;
				if (!(_tmp39_ < ((glong) _tmp42_))) {
					break;
				}
				_tmp43_ = text;
				_tmp44_ = i;
				_tmp45_ = string_get (_tmp43_, _tmp44_);
				if (_tmp45_ == '\t') {
					nb_chars_to_delete = 1;
					between = TRUE;
					continue;
				}
				_tmp46_ = text;
				_tmp47_ = i;
				_tmp48_ = string_get (_tmp46_, _tmp47_);
				if (_tmp48_ != ' ') {
					result = FALSE;
					_g_free0 (text);
					return result;
				}
				_tmp49_ = between;
				if (_tmp49_) {
					nb_chars_to_delete = 1;
					between = FALSE;
					continue;
				}
				_tmp50_ = nb_chars_to_delete;
				nb_chars_to_delete = _tmp50_ + 1;
				_tmp51_ = nb_chars_to_delete;
				_tmp52_ = gtk_source_view_get_tab_width ((GtkSourceView*) self);
				_tmp53_ = _tmp52_;
				if (((guint) _tmp51_) == _tmp53_) {
					between = TRUE;
				}
			}
		}
	}
	_tmp54_ = iter_insert;
	iter_start = _tmp54_;
	_tmp55_ = nb_chars_to_delete;
	_tmp56_ = gtk_text_iter_backward_chars (&iter_start, _tmp55_);
	if (!_tmp56_) {
		result = FALSE;
		_g_free0 (text);
		return result;
	}
	_tmp57_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp58_ = _tmp57_;
	gtk_text_buffer_begin_user_action (_tmp58_);
	_tmp59_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp60_ = _tmp59_;
	_tmp61_ = iter_start;
	_tmp62_ = iter_insert;
	g_signal_emit_by_name (_tmp60_, "delete-range", &_tmp61_, &_tmp62_);
	_tmp63_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp64_ = _tmp63_;
	gtk_text_buffer_end_user_action (_tmp64_);
	result = TRUE;
	_g_free0 (text);
	return result;
}


static void document_view_class_init (DocumentViewClass * klass) {
	document_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DocumentViewPrivate));
	G_OBJECT_CLASS (klass)->finalize = document_view_finalize;
}


static void document_view_instance_init (DocumentView * self) {
	self->priv = DOCUMENT_VIEW_GET_PRIVATE (self);
}


static void document_view_finalize (GObject* obj) {
	DocumentView * self;
	self = DOCUMENT_VIEW (obj);
	_g_object_unref0 (self->priv->_editor_settings);
	_pango_font_description_free0 (self->priv->_font_desc);
	G_OBJECT_CLASS (document_view_parent_class)->finalize (obj);
}


GType document_view_get_type (void) {
	static volatile gsize document_view_type_id__volatile = 0;
	if (g_once_init_enter (&document_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DocumentViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) document_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DocumentView), 0, (GInstanceInitFunc) document_view_instance_init, NULL };
		GType document_view_type_id;
		document_view_type_id = g_type_register_static (GTK_TYPE_SOURCE_VIEW, "DocumentView", &g_define_type_info, 0);
		g_once_init_leave (&document_view_type_id__volatile, document_view_type_id);
	}
	return document_view_type_id__volatile;
}



