/* most_used_symbols.c generated by valac 0.16.1, the Vala compiler
 * generated from most_used_symbols.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>


#define TYPE_MOST_USED_SYMBOL (most_used_symbol_get_type ())
typedef struct _MostUsedSymbol MostUsedSymbol;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_MOST_USED_SYMBOLS (most_used_symbols_get_type ())
#define MOST_USED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOST_USED_SYMBOLS, MostUsedSymbols))
#define MOST_USED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsClass))
#define IS_MOST_USED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOST_USED_SYMBOLS))
#define IS_MOST_USED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOST_USED_SYMBOLS))
#define MOST_USED_SYMBOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsClass))

typedef struct _MostUsedSymbols MostUsedSymbols;
typedef struct _MostUsedSymbolsClass MostUsedSymbolsClass;
typedef struct _MostUsedSymbolsPrivate MostUsedSymbolsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_markup_parse_context_free0(var) ((var == NULL) ? NULL : (var = (g_markup_parse_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _most_used_symbol_free0(var) ((var == NULL) ? NULL : (var = (most_used_symbol_free (var), NULL)))

struct _MostUsedSymbol {
	gchar* id;
	gchar* latex_command;
	gchar* package_required;
	guint num;
};

struct _MostUsedSymbols {
	GObject parent_instance;
	MostUsedSymbolsPrivate * priv;
};

struct _MostUsedSymbolsClass {
	GObjectClass parent_class;
};

struct _MostUsedSymbolsPrivate {
	GeeLinkedList* most_used_symbols;
	gboolean modified;
	GSettings* settings;
};


static gpointer most_used_symbols_parent_class = NULL;
static MostUsedSymbols* most_used_symbols_instance;
static MostUsedSymbols* most_used_symbols_instance = NULL;

GType most_used_symbol_get_type (void) G_GNUC_CONST;
MostUsedSymbol* most_used_symbol_dup (const MostUsedSymbol* self);
void most_used_symbol_free (MostUsedSymbol* self);
void most_used_symbol_copy (const MostUsedSymbol* self, MostUsedSymbol* dest);
void most_used_symbol_destroy (MostUsedSymbol* self);
GType most_used_symbols_get_type (void) G_GNUC_CONST;
#define MOST_USED_SYMBOLS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsPrivate))
enum  {
	MOST_USED_SYMBOLS_DUMMY_PROPERTY
};
static MostUsedSymbols* most_used_symbols_new (void);
static MostUsedSymbols* most_used_symbols_construct (GType object_type);
static GFile* most_used_symbols_get_xml_file (MostUsedSymbols* self);
gchar* utils_load_file (GFile* file);
static void most_used_symbols_parser_start (MostUsedSymbols* self, GMarkupParseContext* context, const gchar* name, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error);
static void _most_used_symbols_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer self, GError** error);
MostUsedSymbols* most_used_symbols_get_default (void);
GeeIterator* most_used_symbols_iterator (MostUsedSymbols* self);
void most_used_symbols_clear (MostUsedSymbols* self);
void most_used_symbols_add_symbol (MostUsedSymbols* self, const gchar* id, const gchar* command, const gchar* package);
static gint most_used_symbols_sort (MostUsedSymbols* self, gint index, MostUsedSymbol* mus);
void symbols_remove_most_used_symbol (gint index);
void symbols_insert_most_used_symbol (gint index, MostUsedSymbol* symbol);
void symbols_swap_most_used_symbol (gint current_index, gint new_index);
void most_used_symbols_save (MostUsedSymbols* self);
void utils_delete_file (GFile* file);
gboolean utils_save_file (GFile* file, const gchar* contents, gboolean make_backup);
static void most_used_symbols_finalize (GObject* obj);
static gint _vala_array_length (gpointer array);


void most_used_symbol_copy (const MostUsedSymbol* self, MostUsedSymbol* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	guint _tmp6_;
	_tmp0_ = (*self).id;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).id);
	(*dest).id = _tmp1_;
	_tmp2_ = (*self).latex_command;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).latex_command);
	(*dest).latex_command = _tmp3_;
	_tmp4_ = (*self).package_required;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).package_required);
	(*dest).package_required = _tmp5_;
	_tmp6_ = (*self).num;
	(*dest).num = _tmp6_;
}


void most_used_symbol_destroy (MostUsedSymbol* self) {
	_g_free0 ((*self).id);
	_g_free0 ((*self).latex_command);
	_g_free0 ((*self).package_required);
}


MostUsedSymbol* most_used_symbol_dup (const MostUsedSymbol* self) {
	MostUsedSymbol* dup;
	dup = g_new0 (MostUsedSymbol, 1);
	most_used_symbol_copy (self, dup);
	return dup;
}


void most_used_symbol_free (MostUsedSymbol* self) {
	most_used_symbol_destroy (self);
	g_free (self);
}


GType most_used_symbol_get_type (void) {
	static volatile gsize most_used_symbol_type_id__volatile = 0;
	if (g_once_init_enter (&most_used_symbol_type_id__volatile)) {
		GType most_used_symbol_type_id;
		most_used_symbol_type_id = g_boxed_type_register_static ("MostUsedSymbol", (GBoxedCopyFunc) most_used_symbol_dup, (GBoxedFreeFunc) most_used_symbol_free);
		g_once_init_leave (&most_used_symbol_type_id__volatile, most_used_symbol_type_id);
	}
	return most_used_symbol_type_id__volatile;
}


static void _most_used_symbols_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer self, GError** error) {
	most_used_symbols_parser_start (self, context, element_name, attribute_names, _vala_array_length (attribute_names), attribute_values, _vala_array_length (attribute_values), error);
}


static MostUsedSymbols* most_used_symbols_construct (GType object_type) {
	MostUsedSymbols * self = NULL;
	GeeLinkedList* _tmp0_;
	GSettings* _tmp1_;
	GFile* _tmp2_ = NULL;
	GFile* file;
	GFile* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GFile* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* contents;
	const gchar* _tmp7_;
	GError * _inner_error_ = NULL;
	self = (MostUsedSymbols*) g_object_new (object_type, NULL);
	_tmp0_ = gee_linked_list_new (TYPE_MOST_USED_SYMBOL, (GBoxedCopyFunc) most_used_symbol_dup, most_used_symbol_free, NULL);
	_g_object_unref0 (self->priv->most_used_symbols);
	self->priv->most_used_symbols = _tmp0_;
	_tmp1_ = g_settings_new ("org.gnome.latexila.preferences.editor");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	_tmp2_ = most_used_symbols_get_xml_file (self);
	file = _tmp2_;
	_tmp3_ = file;
	_tmp4_ = g_file_query_exists (_tmp3_, NULL);
	if (!_tmp4_) {
		_g_object_unref0 (file);
		return self;
	}
	_tmp5_ = file;
	_tmp6_ = utils_load_file (_tmp5_);
	contents = _tmp6_;
	_tmp7_ = contents;
	if (_tmp7_ == NULL) {
		_g_free0 (contents);
		_g_object_unref0 (file);
		return self;
	}
	{
		GMarkupParser _tmp8_ = {0};
		GMarkupParser parser;
		GMarkupParser _tmp9_;
		GMarkupParseContext* _tmp10_;
		GMarkupParseContext* context;
		GMarkupParseContext* _tmp11_;
		const gchar* _tmp12_;
		_tmp8_.start_element = _most_used_symbols_parser_start_gmarkup_parser_start_element_func;
		_tmp8_.end_element = NULL;
		_tmp8_.text = NULL;
		_tmp8_.passthrough = NULL;
		_tmp8_.error = NULL;
		parser = _tmp8_;
		_tmp9_ = parser;
		_tmp10_ = g_markup_parse_context_new (&_tmp9_, 0, self, NULL);
		context = _tmp10_;
		_tmp11_ = context;
		_tmp12_ = contents;
		g_markup_parse_context_parse (_tmp11_, _tmp12_, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_markup_parse_context_free0 (context);
			goto __catch47_g_error;
		}
		_g_markup_parse_context_free0 (context);
	}
	goto __finally47;
	__catch47_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("most_used_symbols.vala:60: Impossible to load the most used symbols: %" \
"s", _tmp14_);
		_g_error_free0 (e);
	}
	__finally47:
	if (_inner_error_ != NULL) {
		_g_free0 (contents);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_free0 (contents);
	_g_object_unref0 (file);
	return self;
}


static MostUsedSymbols* most_used_symbols_new (void) {
	return most_used_symbols_construct (TYPE_MOST_USED_SYMBOLS);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


MostUsedSymbols* most_used_symbols_get_default (void) {
	MostUsedSymbols* result = NULL;
	MostUsedSymbols* _tmp0_;
	MostUsedSymbols* _tmp2_;
	MostUsedSymbols* _tmp3_;
	_tmp0_ = most_used_symbols_instance;
	if (_tmp0_ == NULL) {
		MostUsedSymbols* _tmp1_;
		_tmp1_ = most_used_symbols_new ();
		_g_object_unref0 (most_used_symbols_instance);
		most_used_symbols_instance = _tmp1_;
	}
	_tmp2_ = most_used_symbols_instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


GeeIterator* most_used_symbols_iterator (MostUsedSymbols* self) {
	GeeIterator* result = NULL;
	guint max = 0U;
	GSettings* _tmp0_;
	GeeLinkedList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_ = 0;
	gint slice_max;
	GeeLinkedList* _tmp5_;
	GeeList* _tmp6_ = NULL;
	GeeList* slice;
	GeeIterator* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->settings;
	g_settings_get (_tmp0_, "nb-most-used-symbols", "u", &max);
	_tmp1_ = self->priv->most_used_symbols;
	_tmp2_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = MIN ((gint) max, _tmp3_);
	slice_max = _tmp4_;
	_tmp5_ = self->priv->most_used_symbols;
	_tmp6_ = gee_abstract_list_slice ((GeeAbstractList*) _tmp5_, 0, slice_max);
	slice = _tmp6_;
	_tmp7_ = gee_iterable_iterator ((GeeIterable*) slice);
	result = GEE_ITERATOR (_tmp7_);
	_g_object_unref0 (slice);
	return result;
}


void most_used_symbols_clear (MostUsedSymbols* self) {
	GeeLinkedList* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->modified = TRUE;
	_tmp0_ = self->priv->most_used_symbols;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
}


void most_used_symbols_add_symbol (MostUsedSymbols* self, const gchar* id, const gchar* command, const gchar* package) {
	guint max = 0U;
	GSettings* _tmp0_;
	gint i;
	MostUsedSymbol new_symbol = {0};
	const gchar* _tmp36_;
	gchar* _tmp37_;
	const gchar* _tmp38_;
	gchar* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	GeeLinkedList* _tmp42_;
	MostUsedSymbol _tmp43_;
	GeeLinkedList* _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	guint _tmp47_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (command != NULL);
	self->priv->modified = TRUE;
	_tmp0_ = self->priv->settings;
	g_settings_get (_tmp0_, "nb-most-used-symbols", "u", &max);
	i = 0;
	{
		GeeLinkedList* _tmp1_;
		GeeLinkedList* _tmp2_;
		GeeLinkedList* _mus_list;
		GeeLinkedList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _mus_size;
		gint _mus_index;
		_tmp1_ = self->priv->most_used_symbols;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_mus_list = _tmp2_;
		_tmp3_ = _mus_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_mus_size = _tmp5_;
		_mus_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			GeeLinkedList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_ = NULL;
			MostUsedSymbol* _tmp12_;
			MostUsedSymbol _tmp13_ = {0};
			MostUsedSymbol _tmp14_;
			MostUsedSymbol mus;
			MostUsedSymbol _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			gint _tmp35_;
			_tmp6_ = _mus_index;
			_mus_index = _tmp6_ + 1;
			_tmp7_ = _mus_index;
			_tmp8_ = _mus_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _mus_list;
			_tmp10_ = _mus_index;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
			_tmp12_ = (MostUsedSymbol*) _tmp11_;
			most_used_symbol_copy (_tmp12_, &_tmp13_);
			_tmp14_ = _tmp13_;
			_most_used_symbol_free0 (_tmp12_);
			mus = _tmp14_;
			_tmp15_ = mus;
			_tmp16_ = _tmp15_.id;
			_tmp17_ = id;
			if (g_strcmp0 (_tmp16_, _tmp17_) == 0) {
				guint _tmp18_;
				gint _tmp19_;
				MostUsedSymbol _tmp20_;
				gint _tmp21_ = 0;
				gint new_i;
				gboolean _tmp22_ = FALSE;
				gint _tmp23_;
				gint _tmp24_;
				gboolean _tmp27_;
				_tmp18_ = mus.num;
				mus.num = _tmp18_ + 1;
				_tmp19_ = i;
				_tmp20_ = mus;
				_tmp21_ = most_used_symbols_sort (self, _tmp19_, &_tmp20_);
				new_i = _tmp21_;
				_tmp23_ = new_i;
				_tmp24_ = i;
				if (_tmp23_ != _tmp24_) {
					gint _tmp25_;
					guint _tmp26_;
					_tmp25_ = new_i;
					_tmp26_ = max;
					_tmp22_ = ((guint) _tmp25_) < _tmp26_;
				} else {
					_tmp22_ = FALSE;
				}
				_tmp27_ = _tmp22_;
				if (_tmp27_) {
					gint _tmp28_;
					guint _tmp29_;
					_tmp28_ = i;
					_tmp29_ = max;
					if (((guint) _tmp28_) >= _tmp29_) {
						guint _tmp30_;
						gint _tmp31_;
						MostUsedSymbol _tmp32_;
						_tmp30_ = max;
						symbols_remove_most_used_symbol (((gint) _tmp30_) - 1);
						_tmp31_ = new_i;
						_tmp32_ = mus;
						symbols_insert_most_used_symbol (_tmp31_, &_tmp32_);
					} else {
						gint _tmp33_;
						gint _tmp34_;
						_tmp33_ = i;
						_tmp34_ = new_i;
						symbols_swap_most_used_symbol (_tmp33_, _tmp34_);
					}
				}
				most_used_symbol_destroy (&mus);
				_g_object_unref0 (_mus_list);
				return;
			}
			_tmp35_ = i;
			i = _tmp35_ + 1;
			most_used_symbol_destroy (&mus);
		}
		_g_object_unref0 (_mus_list);
	}
	memset (&new_symbol, 0, sizeof (MostUsedSymbol));
	_tmp36_ = id;
	_tmp37_ = g_strdup (_tmp36_);
	_g_free0 (new_symbol.id);
	new_symbol.id = _tmp37_;
	_tmp38_ = command;
	_tmp39_ = g_strdup (_tmp38_);
	_g_free0 (new_symbol.latex_command);
	new_symbol.latex_command = _tmp39_;
	_tmp40_ = package;
	_tmp41_ = g_strdup (_tmp40_);
	_g_free0 (new_symbol.package_required);
	new_symbol.package_required = _tmp41_;
	new_symbol.num = (guint) 1;
	_tmp42_ = self->priv->most_used_symbols;
	_tmp43_ = new_symbol;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp42_, &_tmp43_);
	_tmp44_ = self->priv->most_used_symbols;
	_tmp45_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = max;
	if (((guint) _tmp46_) <= _tmp47_) {
		GeeLinkedList* _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
		MostUsedSymbol _tmp51_;
		_tmp48_ = self->priv->most_used_symbols;
		_tmp49_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = new_symbol;
		symbols_insert_most_used_symbol (_tmp50_ - 1, &_tmp51_);
	}
	most_used_symbol_destroy (&new_symbol);
}


static gint most_used_symbols_sort (MostUsedSymbols* self, gint index, MostUsedSymbol* mus) {
	gint result = 0;
	gint _tmp0_;
	gint new_index = 0;
	gint _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (mus != NULL, 0);
	_tmp0_ = index;
	if (_tmp0_ == 0) {
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		MostUsedSymbol _tmp3_;
		_tmp1_ = self->priv->most_used_symbols;
		_tmp2_ = index;
		_tmp3_ = *mus;
		gee_abstract_list_set ((GeeAbstractList*) _tmp1_, _tmp2_, &_tmp3_);
		result = 0;
		return result;
	}
	{
		gint _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = index;
		new_index = _tmp4_ - 1;
		_tmp5_ = TRUE;
		while (TRUE) {
			gboolean _tmp6_;
			gint _tmp8_;
			GeeLinkedList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_ = NULL;
			MostUsedSymbol* _tmp12_;
			MostUsedSymbol _tmp13_ = {0};
			MostUsedSymbol _tmp14_;
			MostUsedSymbol symbol;
			MostUsedSymbol _tmp15_;
			guint _tmp16_;
			MostUsedSymbol _tmp17_;
			guint _tmp18_;
			_tmp6_ = _tmp5_;
			if (!_tmp6_) {
				gint _tmp7_;
				_tmp7_ = new_index;
				new_index = _tmp7_ - 1;
			}
			_tmp5_ = FALSE;
			_tmp8_ = new_index;
			if (!(_tmp8_ >= 0)) {
				break;
			}
			_tmp9_ = self->priv->most_used_symbols;
			_tmp10_ = new_index;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
			_tmp12_ = (MostUsedSymbol*) _tmp11_;
			most_used_symbol_copy (_tmp12_, &_tmp13_);
			_tmp14_ = _tmp13_;
			_most_used_symbol_free0 (_tmp12_);
			symbol = _tmp14_;
			_tmp15_ = symbol;
			_tmp16_ = _tmp15_.num;
			_tmp17_ = *mus;
			_tmp18_ = _tmp17_.num;
			if (_tmp16_ >= _tmp18_) {
				gint _tmp19_;
				_tmp19_ = new_index;
				new_index = _tmp19_ + 1;
				most_used_symbol_destroy (&symbol);
				break;
			}
			most_used_symbol_destroy (&symbol);
		}
	}
	_tmp20_ = new_index;
	if (_tmp20_ < 0) {
		new_index = 0;
	}
	_tmp21_ = new_index;
	_tmp22_ = index;
	if (_tmp21_ < _tmp22_) {
		GeeLinkedList* _tmp23_;
		gint _tmp24_;
		gpointer _tmp25_ = NULL;
		MostUsedSymbol* _tmp26_;
		GeeLinkedList* _tmp27_;
		gint _tmp28_;
		MostUsedSymbol _tmp29_;
		_tmp23_ = self->priv->most_used_symbols;
		_tmp24_ = index;
		_tmp25_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp23_, _tmp24_);
		_tmp26_ = (MostUsedSymbol*) _tmp25_;
		_most_used_symbol_free0 (_tmp26_);
		_tmp27_ = self->priv->most_used_symbols;
		_tmp28_ = new_index;
		_tmp29_ = *mus;
		gee_abstract_list_insert ((GeeAbstractList*) _tmp27_, _tmp28_, &_tmp29_);
	} else {
		GeeLinkedList* _tmp30_;
		gint _tmp31_;
		MostUsedSymbol _tmp32_;
		_tmp30_ = self->priv->most_used_symbols;
		_tmp31_ = index;
		_tmp32_ = *mus;
		gee_abstract_list_set ((GeeAbstractList*) _tmp30_, _tmp31_, &_tmp32_);
	}
	result = new_index;
	return result;
}


static void most_used_symbols_parser_start (MostUsedSymbols* self, GMarkupParseContext* context, const gchar* name, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("symbols")))) {
		switch (0) {
			default:
			{
				return;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("symbol")))) {
		switch (0) {
			default:
			{
				MostUsedSymbol symbol = {0};
				GeeLinkedList* _tmp45_;
				MostUsedSymbol _tmp46_;
				memset (&symbol, 0, sizeof (MostUsedSymbol));
				{
					gint i;
					i = 0;
					{
						gboolean _tmp4_;
						_tmp4_ = TRUE;
						while (TRUE) {
							gboolean _tmp5_;
							gint _tmp7_;
							gchar** _tmp8_;
							gint _tmp8__length1;
							gchar** _tmp9_;
							gint _tmp9__length1;
							gint _tmp10_;
							const gchar* _tmp11_;
							const gchar* _tmp12_;
							GQuark _tmp14_ = 0U;
							static GQuark _tmp13_label0 = 0;
							static GQuark _tmp13_label1 = 0;
							static GQuark _tmp13_label2 = 0;
							static GQuark _tmp13_label3 = 0;
							_tmp5_ = _tmp4_;
							if (!_tmp5_) {
								gint _tmp6_;
								_tmp6_ = i;
								i = _tmp6_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp7_ = i;
							_tmp8_ = attr_names;
							_tmp8__length1 = attr_names_length1;
							if (!(_tmp7_ < _tmp8__length1)) {
								break;
							}
							_tmp9_ = attr_names;
							_tmp9__length1 = attr_names_length1;
							_tmp10_ = i;
							_tmp11_ = _tmp9_[_tmp10_];
							_tmp12_ = _tmp11_;
							_tmp14_ = (NULL == _tmp12_) ? 0 : g_quark_from_string (_tmp12_);
							if (_tmp14_ == ((0 != _tmp13_label0) ? _tmp13_label0 : (_tmp13_label0 = g_quark_from_static_string ("id")))) {
								switch (0) {
									default:
									{
										gchar** _tmp15_;
										gint _tmp15__length1;
										gint _tmp16_;
										const gchar* _tmp17_;
										gchar* _tmp18_;
										_tmp15_ = attr_values;
										_tmp15__length1 = attr_values_length1;
										_tmp16_ = i;
										_tmp17_ = _tmp15_[_tmp16_];
										_tmp18_ = g_strdup (_tmp17_);
										_g_free0 (symbol.id);
										symbol.id = _tmp18_;
										break;
									}
								}
							} else if (_tmp14_ == ((0 != _tmp13_label1) ? _tmp13_label1 : (_tmp13_label1 = g_quark_from_static_string ("command")))) {
								switch (0) {
									default:
									{
										gchar** _tmp19_;
										gint _tmp19__length1;
										gint _tmp20_;
										const gchar* _tmp21_;
										gchar* _tmp22_;
										_tmp19_ = attr_values;
										_tmp19__length1 = attr_values_length1;
										_tmp20_ = i;
										_tmp21_ = _tmp19_[_tmp20_];
										_tmp22_ = g_strdup (_tmp21_);
										_g_free0 (symbol.latex_command);
										symbol.latex_command = _tmp22_;
										break;
									}
								}
							} else if (_tmp14_ == ((0 != _tmp13_label2) ? _tmp13_label2 : (_tmp13_label2 = g_quark_from_static_string ("package")))) {
								switch (0) {
									default:
									{
										const gchar* _tmp23_ = NULL;
										gchar** _tmp24_;
										gint _tmp24__length1;
										gint _tmp25_;
										const gchar* _tmp26_;
										const gchar* _tmp30_;
										gchar* _tmp31_;
										_tmp24_ = attr_values;
										_tmp24__length1 = attr_values_length1;
										_tmp25_ = i;
										_tmp26_ = _tmp24_[_tmp25_];
										if (g_strcmp0 (_tmp26_, "") != 0) {
											gchar** _tmp27_;
											gint _tmp27__length1;
											gint _tmp28_;
											const gchar* _tmp29_;
											_tmp27_ = attr_values;
											_tmp27__length1 = attr_values_length1;
											_tmp28_ = i;
											_tmp29_ = _tmp27_[_tmp28_];
											_tmp23_ = _tmp29_;
										} else {
											_tmp23_ = NULL;
										}
										_tmp30_ = _tmp23_;
										_tmp31_ = g_strdup (_tmp30_);
										_g_free0 (symbol.package_required);
										symbol.package_required = _tmp31_;
										break;
									}
								}
							} else if (_tmp14_ == ((0 != _tmp13_label3) ? _tmp13_label3 : (_tmp13_label3 = g_quark_from_static_string ("num")))) {
								switch (0) {
									default:
									{
										gchar** _tmp32_;
										gint _tmp32__length1;
										gint _tmp33_;
										const gchar* _tmp34_;
										gint _tmp35_ = 0;
										_tmp32_ = attr_values;
										_tmp32__length1 = attr_values_length1;
										_tmp33_ = i;
										_tmp34_ = _tmp32_[_tmp33_];
										_tmp35_ = atoi (_tmp34_);
										symbol.num = (guint) _tmp35_;
										break;
									}
								}
							} else {
								switch (0) {
									default:
									{
										gchar** _tmp36_;
										gint _tmp36__length1;
										gint _tmp37_;
										const gchar* _tmp38_;
										gchar* _tmp39_;
										gchar* _tmp40_;
										gchar* _tmp41_;
										gchar* _tmp42_;
										GError* _tmp43_;
										GError* _tmp44_;
										_tmp36_ = attr_names;
										_tmp36__length1 = attr_names_length1;
										_tmp37_ = i;
										_tmp38_ = _tmp36_[_tmp37_];
										_tmp39_ = g_strconcat ("unknown attribute \"", _tmp38_, NULL);
										_tmp40_ = _tmp39_;
										_tmp41_ = g_strconcat (_tmp40_, "\"", NULL);
										_tmp42_ = _tmp41_;
										_tmp43_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp42_);
										_tmp44_ = _tmp43_;
										_g_free0 (_tmp42_);
										_g_free0 (_tmp40_);
										_inner_error_ = _tmp44_;
										if (_inner_error_->domain == G_MARKUP_ERROR) {
											g_propagate_error (error, _inner_error_);
											most_used_symbol_destroy (&symbol);
											return;
										} else {
											most_used_symbol_destroy (&symbol);
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return;
										}
									}
								}
							}
						}
					}
				}
				_tmp45_ = self->priv->most_used_symbols;
				_tmp46_ = symbol;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp45_, &_tmp46_);
				most_used_symbol_destroy (&symbol);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp47_;
				gchar* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				GError* _tmp52_;
				GError* _tmp53_;
				_tmp47_ = name;
				_tmp48_ = g_strconcat ("unknown element \"", _tmp47_, NULL);
				_tmp49_ = _tmp48_;
				_tmp50_ = g_strconcat (_tmp49_, "\"", NULL);
				_tmp51_ = _tmp50_;
				_tmp52_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ELEMENT, _tmp51_);
				_tmp53_ = _tmp52_;
				_g_free0 (_tmp51_);
				_g_free0 (_tmp49_);
				_inner_error_ = _tmp53_;
				if (_inner_error_->domain == G_MARKUP_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static GFile* most_used_symbols_get_xml_file (MostUsedSymbols* self) {
	GFile* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* path;
	GFile* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "latexila", "most_used_symbols.xml", NULL, NULL);
	path = _tmp1_;
	_tmp2_ = g_file_new_for_path (path);
	result = _tmp2_;
	_g_free0 (path);
	return result;
}


void most_used_symbols_save (MostUsedSymbols* self) {
	gboolean _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* file;
	GeeLinkedList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gchar* _tmp6_;
	gchar* content;
	const gchar* _tmp38_;
	gchar* _tmp39_;
	GFile* _tmp40_;
	const gchar* _tmp41_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->modified;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = most_used_symbols_get_xml_file (self);
	file = _tmp1_;
	_tmp2_ = self->priv->most_used_symbols;
	_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		GFile* _tmp5_;
		_tmp5_ = file;
		utils_delete_file (_tmp5_);
		_g_object_unref0 (file);
		return;
	}
	_tmp6_ = g_strdup ("<symbols>\n");
	content = _tmp6_;
	{
		GeeLinkedList* _tmp7_;
		GeeLinkedList* _tmp8_;
		GeeLinkedList* _symbol_list;
		GeeLinkedList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _symbol_size;
		gint _symbol_index;
		_tmp7_ = self->priv->most_used_symbols;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_symbol_list = _tmp8_;
		_tmp9_ = _symbol_list;
		_tmp10_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_symbol_size = _tmp11_;
		_symbol_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			GeeLinkedList* _tmp15_;
			gint _tmp16_;
			gpointer _tmp17_ = NULL;
			MostUsedSymbol* _tmp18_;
			MostUsedSymbol _tmp19_ = {0};
			MostUsedSymbol _tmp20_;
			MostUsedSymbol symbol;
			MostUsedSymbol _tmp21_;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp27_;
			MostUsedSymbol _tmp28_;
			const gchar* _tmp29_;
			MostUsedSymbol _tmp30_;
			const gchar* _tmp31_;
			const gchar* _tmp32_;
			MostUsedSymbol _tmp33_;
			guint _tmp34_;
			gchar* _tmp35_ = NULL;
			gchar* _tmp36_;
			gchar* _tmp37_;
			_tmp12_ = _symbol_index;
			_symbol_index = _tmp12_ + 1;
			_tmp13_ = _symbol_index;
			_tmp14_ = _symbol_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _symbol_list;
			_tmp16_ = _symbol_index;
			_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _tmp16_);
			_tmp18_ = (MostUsedSymbol*) _tmp17_;
			most_used_symbol_copy (_tmp18_, &_tmp19_);
			_tmp20_ = _tmp19_;
			_most_used_symbol_free0 (_tmp18_);
			symbol = _tmp20_;
			_tmp21_ = symbol;
			_tmp22_ = _tmp21_.package_required;
			_tmp23_ = g_strdup (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = _tmp24_;
			if (_tmp25_ == NULL) {
				gchar* _tmp26_;
				_tmp26_ = g_strdup ("");
				_g_free0 (_tmp24_);
				_tmp24_ = _tmp26_;
			}
			_tmp27_ = content;
			_tmp28_ = symbol;
			_tmp29_ = _tmp28_.id;
			_tmp30_ = symbol;
			_tmp31_ = _tmp30_.latex_command;
			_tmp32_ = _tmp24_;
			_tmp33_ = symbol;
			_tmp34_ = _tmp33_.num;
			_tmp35_ = g_strdup_printf ("  <symbol id=\"%s\" command=\"%s\" package=\"%s\" num=\"%u\" />\n", _tmp29_, _tmp31_, _tmp32_, _tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = g_strconcat (_tmp27_, _tmp36_, NULL);
			_g_free0 (content);
			content = _tmp37_;
			_g_free0 (_tmp36_);
			_g_free0 (_tmp24_);
			most_used_symbol_destroy (&symbol);
		}
		_g_object_unref0 (_symbol_list);
	}
	_tmp38_ = content;
	_tmp39_ = g_strconcat (_tmp38_, "</symbols>\n", NULL);
	_g_free0 (content);
	content = _tmp39_;
	_tmp40_ = file;
	_tmp41_ = content;
	utils_save_file (_tmp40_, _tmp41_, FALSE);
	_g_free0 (content);
	_g_object_unref0 (file);
}


static void most_used_symbols_class_init (MostUsedSymbolsClass * klass) {
	most_used_symbols_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MostUsedSymbolsPrivate));
	G_OBJECT_CLASS (klass)->finalize = most_used_symbols_finalize;
}


static void most_used_symbols_instance_init (MostUsedSymbols * self) {
	self->priv = MOST_USED_SYMBOLS_GET_PRIVATE (self);
	self->priv->modified = FALSE;
}


static void most_used_symbols_finalize (GObject* obj) {
	MostUsedSymbols * self;
	self = MOST_USED_SYMBOLS (obj);
	_g_object_unref0 (self->priv->most_used_symbols);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (most_used_symbols_parent_class)->finalize (obj);
}


GType most_used_symbols_get_type (void) {
	static volatile gsize most_used_symbols_type_id__volatile = 0;
	if (g_once_init_enter (&most_used_symbols_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MostUsedSymbolsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) most_used_symbols_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MostUsedSymbols), 0, (GInstanceInitFunc) most_used_symbols_instance_init, NULL };
		GType most_used_symbols_type_id;
		most_used_symbols_type_id = g_type_register_static (G_TYPE_OBJECT, "MostUsedSymbols", &g_define_type_info, 0);
		g_once_init_leave (&most_used_symbols_type_id__volatile, most_used_symbols_type_id);
	}
	return most_used_symbols_type_id__volatile;
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



