/* post_processors.c generated by valac 0.16.1, the Vala compiler
 * generated from post_processors.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define TYPE_POST_PROCESSOR (post_processor_get_type ())
#define POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_POST_PROCESSOR, PostProcessor))
#define POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_POST_PROCESSOR, PostProcessorClass))
#define IS_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_POST_PROCESSOR))
#define IS_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_POST_PROCESSOR))
#define POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_POST_PROCESSOR, PostProcessorClass))

typedef struct _PostProcessor PostProcessor;
typedef struct _PostProcessorClass PostProcessorClass;
typedef struct _PostProcessorPrivate PostProcessorPrivate;

#define TYPE_BUILD_MSG (build_msg_get_type ())

#define TYPE_BUILD_MSG_TYPE (build_msg_type_get_type ())
typedef struct _BuildMsg BuildMsg;
#define __g_node_destroy__build_msg_free0_0(var) ((var == NULL) ? NULL : (var = (_g_node_destroy__build_msg_free0_ (var), NULL)))

#define TYPE_NO_OUTPUT_POST_PROCESSOR (no_output_post_processor_get_type ())
#define NO_OUTPUT_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NO_OUTPUT_POST_PROCESSOR, NoOutputPostProcessor))
#define NO_OUTPUT_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NO_OUTPUT_POST_PROCESSOR, NoOutputPostProcessorClass))
#define IS_NO_OUTPUT_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NO_OUTPUT_POST_PROCESSOR))
#define IS_NO_OUTPUT_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NO_OUTPUT_POST_PROCESSOR))
#define NO_OUTPUT_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NO_OUTPUT_POST_PROCESSOR, NoOutputPostProcessorClass))

typedef struct _NoOutputPostProcessor NoOutputPostProcessor;
typedef struct _NoOutputPostProcessorClass NoOutputPostProcessorClass;
typedef struct _NoOutputPostProcessorPrivate NoOutputPostProcessorPrivate;

#define TYPE_ALL_OUTPUT_POST_PROCESSOR (all_output_post_processor_get_type ())
#define ALL_OUTPUT_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALL_OUTPUT_POST_PROCESSOR, AllOutputPostProcessor))
#define ALL_OUTPUT_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALL_OUTPUT_POST_PROCESSOR, AllOutputPostProcessorClass))
#define IS_ALL_OUTPUT_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALL_OUTPUT_POST_PROCESSOR))
#define IS_ALL_OUTPUT_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALL_OUTPUT_POST_PROCESSOR))
#define ALL_OUTPUT_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALL_OUTPUT_POST_PROCESSOR, AllOutputPostProcessorClass))

typedef struct _AllOutputPostProcessor AllOutputPostProcessor;
typedef struct _AllOutputPostProcessorClass AllOutputPostProcessorClass;
typedef struct _AllOutputPostProcessorPrivate AllOutputPostProcessorPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_RUBBER_POST_PROCESSOR (rubber_post_processor_get_type ())
#define RUBBER_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RUBBER_POST_PROCESSOR, RubberPostProcessor))
#define RUBBER_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RUBBER_POST_PROCESSOR, RubberPostProcessorClass))
#define IS_RUBBER_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RUBBER_POST_PROCESSOR))
#define IS_RUBBER_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RUBBER_POST_PROCESSOR))
#define RUBBER_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RUBBER_POST_PROCESSOR, RubberPostProcessorClass))

typedef struct _RubberPostProcessor RubberPostProcessor;
typedef struct _RubberPostProcessorClass RubberPostProcessorClass;
typedef struct _RubberPostProcessorPrivate RubberPostProcessorPrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))

#define TYPE_LATEXMK_POST_PROCESSOR (latexmk_post_processor_get_type ())
#define LATEXMK_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEXMK_POST_PROCESSOR, LatexmkPostProcessor))
#define LATEXMK_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEXMK_POST_PROCESSOR, LatexmkPostProcessorClass))
#define IS_LATEXMK_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEXMK_POST_PROCESSOR))
#define IS_LATEXMK_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEXMK_POST_PROCESSOR))
#define LATEXMK_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEXMK_POST_PROCESSOR, LatexmkPostProcessorClass))

typedef struct _LatexmkPostProcessor LatexmkPostProcessor;
typedef struct _LatexmkPostProcessorClass LatexmkPostProcessorClass;
typedef struct _LatexmkPostProcessorPrivate LatexmkPostProcessorPrivate;
#define _build_msg_free0(var) ((var == NULL) ? NULL : (var = (build_msg_free (var), NULL)))

#define TYPE_LATEX_POST_PROCESSOR (latex_post_processor_get_type ())
#define LATEX_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEX_POST_PROCESSOR, LatexPostProcessor))
#define LATEX_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEX_POST_PROCESSOR, LatexPostProcessorClass))
#define IS_LATEX_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEX_POST_PROCESSOR))
#define IS_LATEX_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEX_POST_PROCESSOR))
#define LATEX_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEX_POST_PROCESSOR, LatexPostProcessorClass))

typedef struct _LatexPostProcessor LatexPostProcessor;
typedef struct _LatexPostProcessorClass LatexPostProcessorClass;

typedef enum  {
	BUILD_MSG_TYPE_ERROR,
	BUILD_MSG_TYPE_WARNING,
	BUILD_MSG_TYPE_BADBOX,
	BUILD_MSG_TYPE_OTHER
} BuildMsgType;

struct _BuildMsg {
	gchar* text;
	BuildMsgType type;
	gchar* filename;
	gboolean lines_set;
	gint start_line;
	gint end_line;
	gboolean expand;
};

struct _PostProcessor {
	GObject parent_instance;
	PostProcessorPrivate * priv;
	GNode* _all_messages;
};

struct _PostProcessorClass {
	GObjectClass parent_class;
	void (*process) (PostProcessor* self, GFile* file, const gchar* output);
};

struct _PostProcessorPrivate {
	GNode* _prev_message;
	gboolean _successful;
};

struct _NoOutputPostProcessor {
	PostProcessor parent_instance;
	NoOutputPostProcessorPrivate * priv;
};

struct _NoOutputPostProcessorClass {
	PostProcessorClass parent_class;
};

struct _AllOutputPostProcessor {
	PostProcessor parent_instance;
	AllOutputPostProcessorPrivate * priv;
};

struct _AllOutputPostProcessorClass {
	PostProcessorClass parent_class;
};

struct _RubberPostProcessor {
	PostProcessor parent_instance;
	RubberPostProcessorPrivate * priv;
};

struct _RubberPostProcessorClass {
	PostProcessorClass parent_class;
};

struct _LatexmkPostProcessor {
	PostProcessor parent_instance;
	LatexmkPostProcessorPrivate * priv;
};

struct _LatexmkPostProcessorClass {
	PostProcessorClass parent_class;
};

struct _LatexmkPostProcessorPrivate {
	gboolean _force_show_all;
};


static gpointer post_processor_parent_class = NULL;
static gpointer no_output_post_processor_parent_class = NULL;
static gpointer all_output_post_processor_parent_class = NULL;
static gpointer rubber_post_processor_parent_class = NULL;
static GRegex* rubber_post_processor__pattern;
static GRegex* rubber_post_processor__pattern = NULL;
static gpointer latexmk_post_processor_parent_class = NULL;
static GRegex* latexmk_post_processor__reg_rule;
static GRegex* latexmk_post_processor__reg_rule = NULL;
static GRegex* latexmk_post_processor__reg_no_rule;
static GRegex* latexmk_post_processor__reg_no_rule = NULL;

GType post_processor_get_type (void) G_GNUC_CONST;
GType build_msg_get_type (void) G_GNUC_CONST;
GType build_msg_type_get_type (void) G_GNUC_CONST;
BuildMsg* build_msg_dup (const BuildMsg* self);
void build_msg_free (BuildMsg* self);
void build_msg_copy (const BuildMsg* self, BuildMsg* dest);
void build_msg_destroy (BuildMsg* self);
#define POST_PROCESSOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_POST_PROCESSOR, PostProcessorPrivate))
enum  {
	POST_PROCESSOR_DUMMY_PROPERTY,
	POST_PROCESSOR_SUCCESSFUL
};
static void _build_msg_free0_ (gpointer var);
static void _g_node_destroy__build_msg_free0_ (GNode* self);
static void _g_node_destroy__build_msg_free0_ (GNode* self);
GNode* post_processor_get_messages (PostProcessor* self);
GNode* post_processor_append_message (PostProcessor* self, BuildMsg* message);
void post_processor_set_status (PostProcessor* self, gint status);
void post_processor_set_successful (PostProcessor* self, gboolean value);
void post_processor_process (PostProcessor* self, GFile* file, const gchar* output);
static void post_processor_real_process (PostProcessor* self, GFile* file, const gchar* output);
PostProcessor* post_processor_construct (GType object_type);
gboolean post_processor_get_successful (PostProcessor* self);
static void post_processor_finalize (GObject* obj);
static void _vala_post_processor_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_post_processor_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType no_output_post_processor_get_type (void) G_GNUC_CONST;
enum  {
	NO_OUTPUT_POST_PROCESSOR_DUMMY_PROPERTY
};
static void no_output_post_processor_real_process (PostProcessor* base, GFile* file, const gchar* output);
NoOutputPostProcessor* no_output_post_processor_new (void);
NoOutputPostProcessor* no_output_post_processor_construct (GType object_type);
GType all_output_post_processor_get_type (void) G_GNUC_CONST;
enum  {
	ALL_OUTPUT_POST_PROCESSOR_DUMMY_PROPERTY
};
static void all_output_post_processor_real_process (PostProcessor* base, GFile* file, const gchar* output);
AllOutputPostProcessor* all_output_post_processor_new (void);
AllOutputPostProcessor* all_output_post_processor_construct (GType object_type);
GType rubber_post_processor_get_type (void) G_GNUC_CONST;
enum  {
	RUBBER_POST_PROCESSOR_DUMMY_PROPERTY
};
RubberPostProcessor* rubber_post_processor_new (void);
RubberPostProcessor* rubber_post_processor_construct (GType object_type);
static void rubber_post_processor_real_process (PostProcessor* base, GFile* file, const gchar* output);
static void rubber_post_processor_finalize (GObject* obj);
GType latexmk_post_processor_get_type (void) G_GNUC_CONST;
#define LATEXMK_POST_PROCESSOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LATEXMK_POST_PROCESSOR, LatexmkPostProcessorPrivate))
enum  {
	LATEXMK_POST_PROCESSOR_DUMMY_PROPERTY
};
LatexmkPostProcessor* latexmk_post_processor_new (gboolean force_show_all);
LatexmkPostProcessor* latexmk_post_processor_construct (GType object_type, gboolean force_show_all);
static void latexmk_post_processor_real_process (PostProcessor* base, GFile* file, const gchar* output);
LatexPostProcessor* latex_post_processor_new (void);
LatexPostProcessor* latex_post_processor_construct (GType object_type);
GType latex_post_processor_get_type (void) G_GNUC_CONST;
static void latexmk_post_processor_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _build_msg_dup0 (gpointer self) {
	return self ? build_msg_dup (self) : NULL;
}


static void _build_msg_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (build_msg_free (var), NULL));
}


static gboolean _g_node_destroy__build_msg_free0__node (GNode* node, gpointer unused) {
	_build_msg_free0_ (node->data);
	return FALSE;
}


static void _g_node_destroy__build_msg_free0_ (GNode* self) {
	g_node_traverse (self, G_POST_ORDER, G_TRAVERSE_ALL, -1, _g_node_destroy__build_msg_free0__node, NULL);
	g_node_destroy (self);
}


GNode* post_processor_get_messages (PostProcessor* self) {
	GNode* result = NULL;
	GNode* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->_all_messages;
	self->_all_messages = NULL;
	result = _tmp0_;
	return result;
}


GNode* post_processor_append_message (PostProcessor* self, BuildMsg* message) {
	GNode* result = NULL;
	GNode* new_message = NULL;
	gboolean _tmp0_ = FALSE;
	GNode* _tmp1_;
	gboolean _tmp4_;
	gboolean prev_msg_is_invalid;
	gboolean _tmp5_ = FALSE;
	GNode* _tmp6_;
	gboolean _tmp8_;
	GNode* _tmp21_;
	GNode* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (message != NULL, NULL);
	_tmp1_ = self->priv->_prev_message;
	if (_tmp1_ != NULL) {
		GNode* _tmp2_;
		GNode* _tmp3_;
		_tmp2_ = self->priv->_prev_message;
		_tmp3_ = _tmp2_->next;
		_tmp0_ = _tmp3_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	prev_msg_is_invalid = _tmp4_;
	_tmp6_ = self->priv->_prev_message;
	if (_tmp6_ == NULL) {
		_tmp5_ = TRUE;
	} else {
		gboolean _tmp7_;
		_tmp7_ = prev_msg_is_invalid;
		_tmp5_ = _tmp7_;
	}
	_tmp8_ = _tmp5_;
	if (_tmp8_) {
		GNode* _tmp9_;
		BuildMsg _tmp10_;
		BuildMsg _tmp11_;
		BuildMsg* _tmp12_;
		GNode* _tmp13_ = NULL;
		_tmp9_ = self->_all_messages;
		_tmp10_ = *message;
		_tmp11_ = _tmp10_;
		_tmp12_ = _build_msg_dup0 (&_tmp11_);
		_tmp13_ = g_node_append_data (_tmp9_, _tmp12_);
		new_message = _tmp13_;
	} else {
		GNode* _tmp14_;
		GNode* _tmp15_;
		BuildMsg _tmp16_;
		BuildMsg _tmp17_;
		BuildMsg* _tmp18_;
		GNode* _tmp19_;
		GNode* _tmp20_ = NULL;
		_tmp14_ = self->_all_messages;
		_tmp15_ = self->priv->_prev_message;
		_tmp16_ = *message;
		_tmp17_ = _tmp16_;
		_tmp18_ = _build_msg_dup0 (&_tmp17_);
		_tmp19_ = g_node_new (_tmp18_);
		_tmp20_ = g_node_insert_after (_tmp14_, _tmp15_, _tmp19_);
		new_message = _tmp20_;
	}
	_tmp21_ = new_message;
	self->priv->_prev_message = _tmp21_;
	_tmp22_ = new_message;
	result = _tmp22_;
	return result;
}


void post_processor_set_status (PostProcessor* self, gint status) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = status;
	post_processor_set_successful (self, _tmp0_ == 0);
}


static void post_processor_real_process (PostProcessor* self, GFile* file, const gchar* output) {
	g_critical ("Type `%s' does not implement abstract method `post_processor_process'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void post_processor_process (PostProcessor* self, GFile* file, const gchar* output) {
	g_return_if_fail (self != NULL);
	POST_PROCESSOR_GET_CLASS (self)->process (self, file, output);
}


PostProcessor* post_processor_construct (GType object_type) {
	PostProcessor * self = NULL;
	self = (PostProcessor*) g_object_new (object_type, NULL);
	return self;
}


gboolean post_processor_get_successful (PostProcessor* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_successful;
	result = _tmp0_;
	return result;
}


void post_processor_set_successful (PostProcessor* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_successful = _tmp0_;
	g_object_notify ((GObject *) self, "successful");
}


static void post_processor_class_init (PostProcessorClass * klass) {
	post_processor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PostProcessorPrivate));
	POST_PROCESSOR_CLASS (klass)->process = post_processor_real_process;
	G_OBJECT_CLASS (klass)->get_property = _vala_post_processor_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_post_processor_set_property;
	G_OBJECT_CLASS (klass)->finalize = post_processor_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), POST_PROCESSOR_SUCCESSFUL, g_param_spec_boolean ("successful", "successful", "successful", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void post_processor_instance_init (PostProcessor * self) {
	BuildMsg _tmp0_ = {0};
	BuildMsg _tmp1_;
	BuildMsg* _tmp2_;
	GNode* _tmp3_;
	self->priv = POST_PROCESSOR_GET_PRIVATE (self);
	memset (&_tmp0_, 0, sizeof (BuildMsg));
	_tmp1_ = _tmp0_;
	_tmp2_ = _build_msg_dup0 (&_tmp1_);
	_tmp3_ = g_node_new (_tmp2_);
	self->_all_messages = _tmp3_;
	build_msg_destroy (&_tmp1_);
	self->priv->_prev_message = NULL;
}


static void post_processor_finalize (GObject* obj) {
	PostProcessor * self;
	self = POST_PROCESSOR (obj);
	__g_node_destroy__build_msg_free0_0 (self->_all_messages);
	G_OBJECT_CLASS (post_processor_parent_class)->finalize (obj);
}


GType post_processor_get_type (void) {
	static volatile gsize post_processor_type_id__volatile = 0;
	if (g_once_init_enter (&post_processor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PostProcessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) post_processor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PostProcessor), 0, (GInstanceInitFunc) post_processor_instance_init, NULL };
		GType post_processor_type_id;
		post_processor_type_id = g_type_register_static (G_TYPE_OBJECT, "PostProcessor", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&post_processor_type_id__volatile, post_processor_type_id);
	}
	return post_processor_type_id__volatile;
}


static void _vala_post_processor_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	PostProcessor * self;
	self = POST_PROCESSOR (object);
	switch (property_id) {
		case POST_PROCESSOR_SUCCESSFUL:
		g_value_set_boolean (value, post_processor_get_successful (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_post_processor_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	PostProcessor * self;
	self = POST_PROCESSOR (object);
	switch (property_id) {
		case POST_PROCESSOR_SUCCESSFUL:
		post_processor_set_successful (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void no_output_post_processor_real_process (PostProcessor* base, GFile* file, const gchar* output) {
	NoOutputPostProcessor * self;
	self = (NoOutputPostProcessor*) base;
	g_return_if_fail (file != NULL);
	g_return_if_fail (output != NULL);
}


NoOutputPostProcessor* no_output_post_processor_construct (GType object_type) {
	NoOutputPostProcessor * self = NULL;
	self = (NoOutputPostProcessor*) post_processor_construct (object_type);
	return self;
}


NoOutputPostProcessor* no_output_post_processor_new (void) {
	return no_output_post_processor_construct (TYPE_NO_OUTPUT_POST_PROCESSOR);
}


static void no_output_post_processor_class_init (NoOutputPostProcessorClass * klass) {
	no_output_post_processor_parent_class = g_type_class_peek_parent (klass);
	POST_PROCESSOR_CLASS (klass)->process = no_output_post_processor_real_process;
}


static void no_output_post_processor_instance_init (NoOutputPostProcessor * self) {
}


GType no_output_post_processor_get_type (void) {
	static volatile gsize no_output_post_processor_type_id__volatile = 0;
	if (g_once_init_enter (&no_output_post_processor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NoOutputPostProcessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) no_output_post_processor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NoOutputPostProcessor), 0, (GInstanceInitFunc) no_output_post_processor_instance_init, NULL };
		GType no_output_post_processor_type_id;
		no_output_post_processor_type_id = g_type_register_static (TYPE_POST_PROCESSOR, "NoOutputPostProcessor", &g_define_type_info, 0);
		g_once_init_leave (&no_output_post_processor_type_id__volatile, no_output_post_processor_type_id);
	}
	return no_output_post_processor_type_id__volatile;
}


static void all_output_post_processor_real_process (PostProcessor* base, GFile* file, const gchar* output) {
	AllOutputPostProcessor * self;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	const gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_ = NULL;
	gchar** lines;
	gint lines_length1;
	gint _lines_size_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gint nb_lines;
	gint _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gint _tmp9_;
	const gchar* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	BuildMsg message = {0};
	self = (AllOutputPostProcessor*) base;
	g_return_if_fail (file != NULL);
	g_return_if_fail (output != NULL);
	_tmp0_ = output;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		return;
	}
	_tmp3_ = output;
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, "\n", 0);
	lines = _tmp5_;
	lines_length1 = _vala_array_length (_tmp4_);
	_lines_size_ = lines_length1;
	_tmp6_ = lines;
	_tmp6__length1 = lines_length1;
	nb_lines = _tmp6__length1;
	_tmp7_ = nb_lines;
	g_return_if_fail (_tmp7_ > 0);
	_tmp8_ = lines;
	_tmp8__length1 = lines_length1;
	_tmp9_ = nb_lines;
	_tmp10_ = _tmp8_[_tmp9_ - 1];
	_tmp11_ = strlen (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ == 0) {
		gint _tmp13_;
		_tmp13_ = nb_lines;
		nb_lines = _tmp13_ - 1;
	}
	memset (&message, 0, sizeof (BuildMsg));
	message.type = BUILD_MSG_TYPE_OTHER;
	_g_free0 (message.filename);
	message.filename = NULL;
	message.lines_set = FALSE;
	{
		gint line_num;
		line_num = 0;
		{
			gboolean _tmp14_;
			_tmp14_ = TRUE;
			while (TRUE) {
				gboolean _tmp15_;
				gint _tmp17_;
				gint _tmp18_;
				gchar** _tmp19_;
				gint _tmp19__length1;
				gint _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				BuildMsg _tmp23_;
				_tmp15_ = _tmp14_;
				if (!_tmp15_) {
					gint _tmp16_;
					_tmp16_ = line_num;
					line_num = _tmp16_ + 1;
				}
				_tmp14_ = FALSE;
				_tmp17_ = line_num;
				_tmp18_ = nb_lines;
				if (!(_tmp17_ < _tmp18_)) {
					break;
				}
				_tmp19_ = lines;
				_tmp19__length1 = lines_length1;
				_tmp20_ = line_num;
				_tmp21_ = _tmp19_[_tmp20_];
				_tmp22_ = g_strdup (_tmp21_);
				_g_free0 (message.text);
				message.text = _tmp22_;
				_tmp23_ = message;
				post_processor_append_message ((PostProcessor*) self, &_tmp23_);
			}
		}
	}
	build_msg_destroy (&message);
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
}


AllOutputPostProcessor* all_output_post_processor_construct (GType object_type) {
	AllOutputPostProcessor * self = NULL;
	self = (AllOutputPostProcessor*) post_processor_construct (object_type);
	return self;
}


AllOutputPostProcessor* all_output_post_processor_new (void) {
	return all_output_post_processor_construct (TYPE_ALL_OUTPUT_POST_PROCESSOR);
}


static void all_output_post_processor_class_init (AllOutputPostProcessorClass * klass) {
	all_output_post_processor_parent_class = g_type_class_peek_parent (klass);
	POST_PROCESSOR_CLASS (klass)->process = all_output_post_processor_real_process;
}


static void all_output_post_processor_instance_init (AllOutputPostProcessor * self) {
}


GType all_output_post_processor_get_type (void) {
	static volatile gsize all_output_post_processor_type_id__volatile = 0;
	if (g_once_init_enter (&all_output_post_processor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AllOutputPostProcessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) all_output_post_processor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AllOutputPostProcessor), 0, (GInstanceInitFunc) all_output_post_processor_instance_init, NULL };
		GType all_output_post_processor_type_id;
		all_output_post_processor_type_id = g_type_register_static (TYPE_POST_PROCESSOR, "AllOutputPostProcessor", &g_define_type_info, 0);
		g_once_init_leave (&all_output_post_processor_type_id__volatile, all_output_post_processor_type_id);
	}
	return all_output_post_processor_type_id__volatile;
}


RubberPostProcessor* rubber_post_processor_construct (GType object_type) {
	RubberPostProcessor * self = NULL;
	GRegex* _tmp0_;
	GError * _inner_error_ = NULL;
	self = (RubberPostProcessor*) post_processor_construct (object_type);
	_tmp0_ = rubber_post_processor__pattern;
	if (_tmp0_ != NULL) {
		return self;
	}
	{
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		_tmp1_ = g_regex_new ("(?P<file>[^:\n]+)(:(?P<line>[\\d\\-]+))?:(?P<text>.+)$", G_REGEX_MULTILINE | G_REGEX_OPTIMIZE, 0, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch41_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (rubber_post_processor__pattern);
		rubber_post_processor__pattern = _tmp2_;
	}
	goto __finally41;
	__catch41_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("post_processors.vala:115: RubberPostProcessor: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally41:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


RubberPostProcessor* rubber_post_processor_new (void) {
	return rubber_post_processor_construct (TYPE_RUBBER_POST_PROCESSOR);
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void rubber_post_processor_real_process (PostProcessor* base, GFile* file, const gchar* output) {
	RubberPostProcessor * self;
	GRegex* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* parent_path;
	GMatchInfo* match_info = NULL;
	GRegex* _tmp6_;
	const gchar* _tmp7_;
	GMatchInfo* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RubberPostProcessor*) base;
	g_return_if_fail (file != NULL);
	g_return_if_fail (output != NULL);
	_tmp0_ = rubber_post_processor__pattern;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = file;
	_tmp2_ = g_file_get_parent (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_get_parse_name (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	parent_path = _tmp5_;
	_tmp6_ = rubber_post_processor__pattern;
	_tmp7_ = output;
	g_regex_match (_tmp6_, _tmp7_, 0, &_tmp8_);
	_g_match_info_free0 (match_info);
	match_info = _tmp8_;
	while (TRUE) {
		GMatchInfo* _tmp9_;
		gboolean _tmp10_ = FALSE;
		BuildMsg message = {0};
		GMatchInfo* _tmp11_;
		gchar* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		BuildMsg _tmp14_;
		const gchar* _tmp15_;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp20_;
		GMatchInfo* _tmp21_;
		gchar* _tmp22_ = NULL;
		gchar* line;
		gboolean _tmp23_ = FALSE;
		const gchar* _tmp24_;
		gboolean _tmp28_;
		GMatchInfo* _tmp49_;
		gchar* _tmp50_ = NULL;
		BuildMsg _tmp51_;
		const gchar* _tmp52_;
		gchar _tmp53_ = '\0';
		BuildMsg _tmp58_;
		_tmp9_ = match_info;
		_tmp10_ = g_match_info_matches (_tmp9_);
		if (!_tmp10_) {
			break;
		}
		memset (&message, 0, sizeof (BuildMsg));
		_tmp11_ = match_info;
		_tmp12_ = g_match_info_fetch_named (_tmp11_, "text");
		_g_free0 (message.text);
		message.text = _tmp12_;
		message.type = BUILD_MSG_TYPE_ERROR;
		_tmp14_ = message;
		_tmp15_ = _tmp14_.text;
		_tmp16_ = string_contains (_tmp15_, "Underfull");
		if (_tmp16_) {
			_tmp13_ = TRUE;
		} else {
			BuildMsg _tmp17_;
			const gchar* _tmp18_;
			gboolean _tmp19_ = FALSE;
			_tmp17_ = message;
			_tmp18_ = _tmp17_.text;
			_tmp19_ = string_contains (_tmp18_, "Overfull");
			_tmp13_ = _tmp19_;
		}
		_tmp20_ = _tmp13_;
		if (_tmp20_) {
			message.type = BUILD_MSG_TYPE_BADBOX;
		}
		message.lines_set = FALSE;
		_tmp21_ = match_info;
		_tmp22_ = g_match_info_fetch_named (_tmp21_, "line");
		line = _tmp22_;
		_tmp24_ = line;
		if (_tmp24_ != NULL) {
			const gchar* _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			_tmp25_ = line;
			_tmp26_ = strlen (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp23_ = 0 < _tmp27_;
		} else {
			_tmp23_ = FALSE;
		}
		_tmp28_ = _tmp23_;
		if (_tmp28_) {
			const gchar* _tmp29_;
			gchar** _tmp30_;
			gchar** _tmp31_ = NULL;
			gchar** parts;
			gint parts_length1;
			gint _parts_size_;
			gchar** _tmp32_;
			gint _tmp32__length1;
			const gchar* _tmp33_;
			gint _tmp34_ = 0;
			gboolean _tmp35_ = FALSE;
			gboolean _tmp36_ = FALSE;
			gchar** _tmp37_;
			gint _tmp37__length1;
			gboolean _tmp40_;
			gboolean _tmp45_;
			message.lines_set = TRUE;
			_tmp29_ = line;
			_tmp31_ = _tmp30_ = g_strsplit (_tmp29_, "-", 0);
			parts = _tmp31_;
			parts_length1 = _vala_array_length (_tmp30_);
			_parts_size_ = parts_length1;
			_tmp32_ = parts;
			_tmp32__length1 = parts_length1;
			_tmp33_ = _tmp32_[0];
			_tmp34_ = atoi (_tmp33_);
			message.start_line = _tmp34_;
			_tmp37_ = parts;
			_tmp37__length1 = parts_length1;
			if (1 < _tmp37__length1) {
				gchar** _tmp38_;
				gint _tmp38__length1;
				const gchar* _tmp39_;
				_tmp38_ = parts;
				_tmp38__length1 = parts_length1;
				_tmp39_ = _tmp38_[1];
				_tmp36_ = _tmp39_ != NULL;
			} else {
				_tmp36_ = FALSE;
			}
			_tmp40_ = _tmp36_;
			if (_tmp40_) {
				gchar** _tmp41_;
				gint _tmp41__length1;
				const gchar* _tmp42_;
				gint _tmp43_;
				gint _tmp44_;
				_tmp41_ = parts;
				_tmp41__length1 = parts_length1;
				_tmp42_ = _tmp41_[1];
				_tmp43_ = strlen (_tmp42_);
				_tmp44_ = _tmp43_;
				_tmp35_ = 0 < _tmp44_;
			} else {
				_tmp35_ = FALSE;
			}
			_tmp45_ = _tmp35_;
			if (_tmp45_) {
				gchar** _tmp46_;
				gint _tmp46__length1;
				const gchar* _tmp47_;
				gint _tmp48_ = 0;
				_tmp46_ = parts;
				_tmp46__length1 = parts_length1;
				_tmp47_ = _tmp46_[1];
				_tmp48_ = atoi (_tmp47_);
				message.end_line = _tmp48_;
			} else {
				message.end_line = -1;
			}
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp49_ = match_info;
		_tmp50_ = g_match_info_fetch_named (_tmp49_, "file");
		_g_free0 (message.filename);
		message.filename = _tmp50_;
		_tmp51_ = message;
		_tmp52_ = _tmp51_.filename;
		_tmp53_ = string_get (_tmp52_, (glong) 0);
		if (_tmp53_ != '/') {
			const gchar* _tmp54_;
			BuildMsg _tmp55_;
			const gchar* _tmp56_;
			gchar* _tmp57_ = NULL;
			_tmp54_ = parent_path;
			_tmp55_ = message;
			_tmp56_ = _tmp55_.filename;
			_tmp57_ = g_strdup_printf ("%s/%s", _tmp54_, _tmp56_);
			_g_free0 (message.filename);
			message.filename = _tmp57_;
		}
		_tmp58_ = message;
		post_processor_append_message ((PostProcessor*) self, &_tmp58_);
		{
			GMatchInfo* _tmp59_;
			_tmp59_ = match_info;
			g_match_info_next (_tmp59_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch42_g_regex_error;
				}
				_g_free0 (line);
				build_msg_destroy (&message);
				_g_match_info_free0 (match_info);
				_g_free0 (parent_path);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		goto __finally42;
		__catch42_g_regex_error:
		{
			GError* e = NULL;
			GError* _tmp60_;
			const gchar* _tmp61_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp60_ = e;
			_tmp61_ = _tmp60_->message;
			g_warning ("post_processors.vala:164: RubberPostProcessor: %s", _tmp61_);
			_g_error_free0 (e);
			_g_free0 (line);
			build_msg_destroy (&message);
			break;
		}
		__finally42:
		if (_inner_error_ != NULL) {
			_g_free0 (line);
			build_msg_destroy (&message);
			_g_match_info_free0 (match_info);
			_g_free0 (parent_path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (line);
		build_msg_destroy (&message);
	}
	_g_match_info_free0 (match_info);
	_g_free0 (parent_path);
}


static void rubber_post_processor_class_init (RubberPostProcessorClass * klass) {
	rubber_post_processor_parent_class = g_type_class_peek_parent (klass);
	POST_PROCESSOR_CLASS (klass)->process = rubber_post_processor_real_process;
	G_OBJECT_CLASS (klass)->finalize = rubber_post_processor_finalize;
}


static void rubber_post_processor_instance_init (RubberPostProcessor * self) {
}


static void rubber_post_processor_finalize (GObject* obj) {
	RubberPostProcessor * self;
	self = RUBBER_POST_PROCESSOR (obj);
	G_OBJECT_CLASS (rubber_post_processor_parent_class)->finalize (obj);
}


GType rubber_post_processor_get_type (void) {
	static volatile gsize rubber_post_processor_type_id__volatile = 0;
	if (g_once_init_enter (&rubber_post_processor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RubberPostProcessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rubber_post_processor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RubberPostProcessor), 0, (GInstanceInitFunc) rubber_post_processor_instance_init, NULL };
		GType rubber_post_processor_type_id;
		rubber_post_processor_type_id = g_type_register_static (TYPE_POST_PROCESSOR, "RubberPostProcessor", &g_define_type_info, 0);
		g_once_init_leave (&rubber_post_processor_type_id__volatile, rubber_post_processor_type_id);
	}
	return rubber_post_processor_type_id__volatile;
}


LatexmkPostProcessor* latexmk_post_processor_construct (GType object_type, gboolean force_show_all) {
	LatexmkPostProcessor * self = NULL;
	gboolean _tmp0_;
	GRegex* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (LatexmkPostProcessor*) post_processor_construct (object_type);
	_tmp0_ = force_show_all;
	self->priv->_force_show_all = _tmp0_;
	_tmp1_ = latexmk_post_processor__reg_rule;
	if (_tmp1_ != NULL) {
		return self;
	}
	{
		gchar* _tmp2_;
		gchar* ungreedy_lines;
		gchar* _tmp3_;
		gchar* reg_rule_str;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		const gchar* _tmp33_;
		GRegex* _tmp34_;
		GRegex* _tmp35_;
		gchar* _tmp36_;
		gchar* reg_no_rule_str;
		const gchar* _tmp37_;
		gchar* _tmp38_;
		const gchar* _tmp39_;
		gchar* _tmp40_;
		const gchar* _tmp41_;
		GRegex* _tmp42_;
		GRegex* _tmp43_;
		_tmp2_ = g_strdup ("((?U)(.*\\R)*)");
		ungreedy_lines = _tmp2_;
		_tmp3_ = g_strdup ("(?P<title>Run number \\d+ of rule '(?P<rule>.*)')\\R");
		reg_rule_str = _tmp3_;
		_tmp4_ = reg_rule_str;
		_tmp5_ = g_strconcat (_tmp4_, "(-{12}\\R){2}", NULL);
		_g_free0 (reg_rule_str);
		reg_rule_str = _tmp5_;
		_tmp6_ = reg_rule_str;
		_tmp7_ = g_strconcat (_tmp6_, "Running '(?P<cmd>.*)'\\R", NULL);
		_g_free0 (reg_rule_str);
		reg_rule_str = _tmp7_;
		_tmp8_ = reg_rule_str;
		_tmp9_ = g_strconcat (_tmp8_, "-{12}\\R", NULL);
		_g_free0 (reg_rule_str);
		reg_rule_str = _tmp9_;
		_tmp10_ = reg_rule_str;
		_tmp11_ = ungreedy_lines;
		_tmp12_ = g_strconcat (_tmp10_, _tmp11_, NULL);
		_g_free0 (reg_rule_str);
		reg_rule_str = _tmp12_;
		_tmp13_ = reg_rule_str;
		_tmp14_ = g_strconcat (_tmp13_, "(Latexmk: applying rule .*\\R)+", NULL);
		_g_free0 (reg_rule_str);
		reg_rule_str = _tmp14_;
		_tmp15_ = reg_rule_str;
		_tmp16_ = g_strconcat (_tmp15_, "(For rule '.*', running .*\\R)?", NULL);
		_g_free0 (reg_rule_str);
		reg_rule_str = _tmp16_;
		_tmp17_ = reg_rule_str;
		_tmp18_ = ungreedy_lines;
		_tmp19_ = g_strconcat ("(?P<output>", _tmp18_, NULL);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strconcat (_tmp20_, ")", NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat (_tmp17_, _tmp22_, NULL);
		_g_free0 (reg_rule_str);
		reg_rule_str = _tmp23_;
		_g_free0 (_tmp22_);
		_g_free0 (_tmp20_);
		_tmp24_ = reg_rule_str;
		_tmp25_ = ungreedy_lines;
		_tmp26_ = g_strconcat ("(?P<latexmk>(Latexmk:|Rule '.*':)", _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strconcat (_tmp27_, ")", NULL);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strconcat (_tmp24_, _tmp29_, NULL);
		_g_free0 (reg_rule_str);
		reg_rule_str = _tmp30_;
		_g_free0 (_tmp29_);
		_g_free0 (_tmp27_);
		_tmp31_ = reg_rule_str;
		_tmp32_ = g_strconcat (_tmp31_, "(-{12}\\R|$)", NULL);
		_g_free0 (reg_rule_str);
		reg_rule_str = _tmp32_;
		_tmp33_ = reg_rule_str;
		_tmp34_ = g_regex_new (_tmp33_, G_REGEX_OPTIMIZE, 0, &_inner_error_);
		_tmp35_ = _tmp34_;
		if (_inner_error_ != NULL) {
			_g_free0 (reg_rule_str);
			_g_free0 (ungreedy_lines);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch43_g_regex_error;
			}
			_g_free0 (reg_rule_str);
			_g_free0 (ungreedy_lines);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (latexmk_post_processor__reg_rule);
		latexmk_post_processor__reg_rule = _tmp35_;
		_tmp36_ = g_strdup ("(Latexmk: This is Latexmk.*\\R)?");
		reg_no_rule_str = _tmp36_;
		_tmp37_ = reg_no_rule_str;
		_tmp38_ = g_strconcat (_tmp37_, "(\\*{4} Report bugs.*\\R)?", NULL);
		_g_free0 (reg_no_rule_str);
		reg_no_rule_str = _tmp38_;
		_tmp39_ = reg_no_rule_str;
		_tmp40_ = g_strconcat (_tmp39_, "(?P<output>(.*\\R)*)", NULL);
		_g_free0 (reg_no_rule_str);
		reg_no_rule_str = _tmp40_;
		_tmp41_ = reg_no_rule_str;
		_tmp42_ = g_regex_new (_tmp41_, 0, 0, &_inner_error_);
		_tmp43_ = _tmp42_;
		if (_inner_error_ != NULL) {
			_g_free0 (reg_no_rule_str);
			_g_free0 (reg_rule_str);
			_g_free0 (ungreedy_lines);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch43_g_regex_error;
			}
			_g_free0 (reg_no_rule_str);
			_g_free0 (reg_rule_str);
			_g_free0 (ungreedy_lines);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_regex_unref0 (latexmk_post_processor__reg_no_rule);
		latexmk_post_processor__reg_no_rule = _tmp43_;
		_g_free0 (reg_no_rule_str);
		_g_free0 (reg_rule_str);
		_g_free0 (ungreedy_lines);
	}
	goto __finally43;
	__catch43_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp44_;
		const gchar* _tmp45_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp44_ = e;
		_tmp45_ = _tmp44_->message;
		g_warning ("post_processors.vala:209: LatexmkPostProcessor: %s", _tmp45_);
		_g_error_free0 (e);
	}
	__finally43:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


LatexmkPostProcessor* latexmk_post_processor_new (gboolean force_show_all) {
	return latexmk_post_processor_construct (TYPE_LATEXMK_POST_PROCESSOR, force_show_all);
}


static GNode* g_node_unlink_vala (GNode* self) {
	GNode* result = NULL;
	void* ptr;
	void* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	ptr = self;
	g_node_unlink (self);
	_tmp0_ = ptr;
	ptr = NULL;
	result = (GNode*) _tmp0_;
	return result;
}


static void latexmk_post_processor_real_process (PostProcessor* base, GFile* file, const gchar* output) {
	LatexmkPostProcessor * self;
	gboolean _tmp0_ = FALSE;
	GRegex* _tmp1_;
	gboolean _tmp3_;
	gchar* last_latex_output;
	GNode* last_latex_node;
	GMatchInfo* match_info = NULL;
	GRegex* _tmp4_;
	const gchar* _tmp5_;
	GMatchInfo* _tmp6_ = NULL;
	const gchar* _tmp69_;
	GNode* _tmp108_;
	GNode* _tmp109_;
	AllOutputPostProcessor* _tmp110_;
	PostProcessor* all_output_pp;
	GRegex* _tmp111_;
	const gchar* _tmp112_;
	GMatchInfo* _tmp113_ = NULL;
	gboolean _tmp114_ = FALSE;
	PostProcessor* _tmp123_;
	GNode* _tmp124_ = NULL;
	GError * _inner_error_ = NULL;
	self = (LatexmkPostProcessor*) base;
	g_return_if_fail (file != NULL);
	g_return_if_fail (output != NULL);
	_tmp1_ = latexmk_post_processor__reg_rule;
	if (_tmp1_ != NULL) {
		GRegex* _tmp2_;
		_tmp2_ = latexmk_post_processor__reg_no_rule;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	g_return_if_fail (_tmp3_);
	last_latex_output = NULL;
	last_latex_node = NULL;
	_tmp4_ = latexmk_post_processor__reg_rule;
	_tmp5_ = output;
	g_regex_match (_tmp4_, _tmp5_, 0, &_tmp6_);
	_g_match_info_free0 (match_info);
	match_info = _tmp6_;
	while (TRUE) {
		GMatchInfo* _tmp7_;
		gboolean _tmp8_ = FALSE;
		GNode* cmd_messages;
		GMatchInfo* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* rule;
		gboolean _tmp11_ = FALSE;
		const gchar* _tmp12_;
		gboolean _tmp14_;
		gboolean is_latex_cmd;
		gboolean _tmp15_;
		BuildMsg title_msg = {0};
		GMatchInfo* _tmp30_;
		gchar* _tmp31_ = NULL;
		GNode* _tmp32_;
		BuildMsg _tmp33_;
		BuildMsg _tmp34_;
		BuildMsg* _tmp35_;
		BuildMsg cmd_line_msg = {0};
		GMatchInfo* _tmp36_;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_;
		gchar* _tmp39_;
		GNode* _tmp40_;
		BuildMsg _tmp41_;
		BuildMsg _tmp42_;
		BuildMsg* _tmp43_;
		gboolean _tmp44_;
		GMatchInfo* _tmp50_;
		gchar* _tmp51_ = NULL;
		gchar* latexmk_output;
		AllOutputPostProcessor* _tmp52_;
		PostProcessor* all_output_pp;
		PostProcessor* _tmp53_;
		GFile* _tmp54_;
		const gchar* _tmp55_;
		PostProcessor* _tmp56_;
		GNode* _tmp57_ = NULL;
		GNode* latexmk_messages;
		const gchar* _tmp58_ = NULL;
		gchar* _tmp59_;
		GNode* _tmp60_;
		BuildMsg _tmp61_;
		BuildMsg _tmp62_;
		BuildMsg* _tmp63_;
		GNode* _tmp64_;
		GNode* _tmp65_;
		_tmp7_ = match_info;
		_tmp8_ = g_match_info_matches (_tmp7_);
		if (!_tmp8_) {
			break;
		}
		cmd_messages = NULL;
		_tmp9_ = match_info;
		_tmp10_ = g_match_info_fetch_named (_tmp9_, "rule");
		rule = _tmp10_;
		_tmp12_ = rule;
		if (g_strcmp0 (_tmp12_, "latex") == 0) {
			_tmp11_ = TRUE;
		} else {
			const gchar* _tmp13_;
			_tmp13_ = rule;
			_tmp11_ = g_strcmp0 (_tmp13_, "pdflatex") == 0;
		}
		_tmp14_ = _tmp11_;
		is_latex_cmd = _tmp14_;
		_tmp15_ = is_latex_cmd;
		if (_tmp15_) {
			GMatchInfo* _tmp16_;
			gchar* _tmp17_ = NULL;
			BuildMsg _tmp18_ = {0};
			BuildMsg _tmp19_;
			BuildMsg* _tmp20_;
			GNode* _tmp21_;
			_tmp16_ = match_info;
			_tmp17_ = g_match_info_fetch_named (_tmp16_, "output");
			_g_free0 (last_latex_output);
			last_latex_output = _tmp17_;
			memset (&_tmp18_, 0, sizeof (BuildMsg));
			_tmp19_ = _tmp18_;
			_tmp20_ = _build_msg_dup0 (&_tmp19_);
			_tmp21_ = g_node_new (_tmp20_);
			__g_node_destroy__build_msg_free0_0 (cmd_messages);
			cmd_messages = _tmp21_;
			build_msg_destroy (&_tmp19_);
		} else {
			GMatchInfo* _tmp22_;
			gchar* _tmp23_ = NULL;
			gchar* cmd_output;
			AllOutputPostProcessor* _tmp24_;
			PostProcessor* all_output_pp;
			PostProcessor* _tmp25_;
			GFile* _tmp26_;
			const gchar* _tmp27_;
			PostProcessor* _tmp28_;
			GNode* _tmp29_ = NULL;
			_tmp22_ = match_info;
			_tmp23_ = g_match_info_fetch_named (_tmp22_, "output");
			cmd_output = _tmp23_;
			_tmp24_ = all_output_post_processor_new ();
			all_output_pp = (PostProcessor*) _tmp24_;
			_tmp25_ = all_output_pp;
			_tmp26_ = file;
			_tmp27_ = cmd_output;
			post_processor_process (_tmp25_, _tmp26_, _tmp27_);
			_tmp28_ = all_output_pp;
			_tmp29_ = post_processor_get_messages (_tmp28_);
			__g_node_destroy__build_msg_free0_0 (cmd_messages);
			cmd_messages = _tmp29_;
			_g_object_unref0 (all_output_pp);
			_g_free0 (cmd_output);
		}
		memset (&title_msg, 0, sizeof (BuildMsg));
		title_msg.type = BUILD_MSG_TYPE_OTHER;
		title_msg.lines_set = FALSE;
		_tmp30_ = match_info;
		_tmp31_ = g_match_info_fetch_named (_tmp30_, "title");
		_g_free0 (title_msg.text);
		title_msg.text = _tmp31_;
		title_msg.expand = FALSE;
		_tmp32_ = cmd_messages;
		_tmp33_ = title_msg;
		_tmp34_ = _tmp33_;
		_tmp35_ = _build_msg_dup0 (&_tmp34_);
		_build_msg_free0 (_tmp32_->data);
		_tmp32_->data = _tmp35_;
		memset (&cmd_line_msg, 0, sizeof (BuildMsg));
		cmd_line_msg.type = BUILD_MSG_TYPE_OTHER;
		cmd_line_msg.lines_set = FALSE;
		_tmp36_ = match_info;
		_tmp37_ = g_match_info_fetch_named (_tmp36_, "cmd");
		_tmp38_ = _tmp37_;
		_tmp39_ = g_strconcat ("$ ", _tmp38_, NULL);
		_g_free0 (cmd_line_msg.text);
		cmd_line_msg.text = _tmp39_;
		_g_free0 (_tmp38_);
		_tmp40_ = cmd_messages;
		_tmp41_ = cmd_line_msg;
		_tmp42_ = _tmp41_;
		_tmp43_ = _build_msg_dup0 (&_tmp42_);
		g_node_insert_data (_tmp40_, 0, _tmp43_);
		_tmp44_ = is_latex_cmd;
		if (_tmp44_) {
			GNode* _tmp45_;
			GNode* _tmp46_;
			GNode* _tmp47_ = NULL;
			_tmp45_ = ((PostProcessor*) self)->_all_messages;
			_tmp46_ = cmd_messages;
			cmd_messages = NULL;
			_tmp47_ = g_node_append (_tmp45_, _tmp46_);
			last_latex_node = _tmp47_;
		} else {
			GNode* _tmp48_;
			GNode* _tmp49_;
			_tmp48_ = ((PostProcessor*) self)->_all_messages;
			_tmp49_ = cmd_messages;
			cmd_messages = NULL;
			g_node_append (_tmp48_, _tmp49_);
		}
		_tmp50_ = match_info;
		_tmp51_ = g_match_info_fetch_named (_tmp50_, "latexmk");
		latexmk_output = _tmp51_;
		_tmp52_ = all_output_post_processor_new ();
		all_output_pp = (PostProcessor*) _tmp52_;
		_tmp53_ = all_output_pp;
		_tmp54_ = file;
		_tmp55_ = latexmk_output;
		post_processor_process (_tmp53_, _tmp54_, _tmp55_);
		_tmp56_ = all_output_pp;
		_tmp57_ = post_processor_get_messages (_tmp56_);
		latexmk_messages = _tmp57_;
		_tmp58_ = _ ("Latexmk messages");
		_tmp59_ = g_strdup (_tmp58_);
		_g_free0 (title_msg.text);
		title_msg.text = _tmp59_;
		_tmp60_ = latexmk_messages;
		_tmp61_ = title_msg;
		_tmp62_ = _tmp61_;
		_tmp63_ = _build_msg_dup0 (&_tmp62_);
		_build_msg_free0 (_tmp60_->data);
		_tmp60_->data = _tmp63_;
		_tmp64_ = ((PostProcessor*) self)->_all_messages;
		_tmp65_ = latexmk_messages;
		latexmk_messages = NULL;
		g_node_append (_tmp64_, _tmp65_);
		{
			GMatchInfo* _tmp66_;
			_tmp66_ = match_info;
			g_match_info_next (_tmp66_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch44_g_regex_error;
				}
				__g_node_destroy__build_msg_free0_0 (latexmk_messages);
				_g_object_unref0 (all_output_pp);
				_g_free0 (latexmk_output);
				build_msg_destroy (&cmd_line_msg);
				build_msg_destroy (&title_msg);
				_g_free0 (rule);
				__g_node_destroy__build_msg_free0_0 (cmd_messages);
				_g_match_info_free0 (match_info);
				_g_free0 (last_latex_output);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		goto __finally44;
		__catch44_g_regex_error:
		{
			GError* e = NULL;
			GError* _tmp67_;
			const gchar* _tmp68_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp67_ = e;
			_tmp68_ = _tmp67_->message;
			g_warning ("post_processors.vala:287: LatexmkPostProcessor: %s", _tmp68_);
			_g_error_free0 (e);
			__g_node_destroy__build_msg_free0_0 (latexmk_messages);
			_g_object_unref0 (all_output_pp);
			_g_free0 (latexmk_output);
			build_msg_destroy (&cmd_line_msg);
			build_msg_destroy (&title_msg);
			_g_free0 (rule);
			__g_node_destroy__build_msg_free0_0 (cmd_messages);
			break;
		}
		__finally44:
		if (_inner_error_ != NULL) {
			__g_node_destroy__build_msg_free0_0 (latexmk_messages);
			_g_object_unref0 (all_output_pp);
			_g_free0 (latexmk_output);
			build_msg_destroy (&cmd_line_msg);
			build_msg_destroy (&title_msg);
			_g_free0 (rule);
			__g_node_destroy__build_msg_free0_0 (cmd_messages);
			_g_match_info_free0 (match_info);
			_g_free0 (last_latex_output);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		__g_node_destroy__build_msg_free0_0 (latexmk_messages);
		_g_object_unref0 (all_output_pp);
		_g_free0 (latexmk_output);
		build_msg_destroy (&cmd_line_msg);
		build_msg_destroy (&title_msg);
		_g_free0 (rule);
		__g_node_destroy__build_msg_free0_0 (cmd_messages);
	}
	_tmp69_ = last_latex_output;
	if (_tmp69_ != NULL) {
		LatexPostProcessor* _tmp70_;
		PostProcessor* latex_pp;
		PostProcessor* _tmp71_;
		GFile* _tmp72_;
		const gchar* _tmp73_;
		PostProcessor* _tmp74_;
		GNode* _tmp75_ = NULL;
		GNode* latex_messages;
		GNode* _tmp76_;
		GNode* _tmp77_ = NULL;
		GNode* _tmp78_ = NULL;
		GNode* _tmp79_;
		gboolean last_cmd_is_latex_cmd;
		gboolean _tmp80_ = FALSE;
		gboolean _tmp81_;
		gboolean _tmp87_;
		_tmp70_ = latex_post_processor_new ();
		latex_pp = (PostProcessor*) _tmp70_;
		_tmp71_ = latex_pp;
		_tmp72_ = file;
		_tmp73_ = last_latex_output;
		post_processor_process (_tmp71_, _tmp72_, _tmp73_);
		_tmp74_ = latex_pp;
		_tmp75_ = post_processor_get_messages (_tmp74_);
		latex_messages = _tmp75_;
		_tmp76_ = ((PostProcessor*) self)->_all_messages;
		_tmp77_ = g_node_last_child (_tmp76_);
		_tmp78_ = g_node_prev_sibling (_tmp77_);
		_tmp79_ = last_latex_node;
		last_cmd_is_latex_cmd = _tmp78_ == _tmp79_;
		_tmp81_ = self->priv->_force_show_all;
		if (!_tmp81_) {
			gboolean _tmp82_ = FALSE;
			gboolean _tmp83_;
			gboolean _tmp84_;
			gboolean _tmp86_;
			_tmp83_ = post_processor_get_successful ((PostProcessor*) self);
			_tmp84_ = _tmp83_;
			if (_tmp84_) {
				_tmp82_ = TRUE;
			} else {
				gboolean _tmp85_;
				_tmp85_ = last_cmd_is_latex_cmd;
				_tmp82_ = _tmp85_;
			}
			_tmp86_ = _tmp82_;
			_tmp80_ = _tmp86_;
		} else {
			_tmp80_ = FALSE;
		}
		_tmp87_ = _tmp80_;
		if (_tmp87_) {
			GNode* _tmp88_;
			_tmp88_ = latex_messages;
			latex_messages = NULL;
			__g_node_destroy__build_msg_free0_0 (((PostProcessor*) self)->_all_messages);
			((PostProcessor*) self)->_all_messages = _tmp88_;
		} else {
			GNode* _tmp89_;
			GNode* _tmp90_;
			gconstpointer _tmp91_;
			BuildMsg* _tmp92_;
			GNode* _tmp93_;
			gconstpointer _tmp94_;
			GNode* _tmp95_;
			GNode* _tmp96_;
			GNode* _tmp97_ = NULL;
			GNode* _tmp98_ = NULL;
			GNode* _tmp99_;
			GNode* _tmp100_;
			gint _tmp101_ = 0;
			gint pos;
			GNode* _tmp102_;
			GNode* _tmp103_ = NULL;
			GNode* _tmp104_;
			GNode* _tmp105_;
			gint _tmp106_;
			GNode* _tmp107_;
			_tmp89_ = latex_messages;
			_tmp90_ = last_latex_node;
			_tmp91_ = _tmp90_->data;
			_tmp92_ = _build_msg_dup0 ((BuildMsg*) _tmp91_);
			_build_msg_free0 (_tmp89_->data);
			_tmp89_->data = _tmp92_;
			_tmp93_ = latex_messages;
			_tmp94_ = _tmp93_->data;
			(*((BuildMsg*) _tmp94_)).expand = TRUE;
			_tmp95_ = latex_messages;
			_tmp96_ = last_latex_node;
			_tmp97_ = g_node_first_child (_tmp96_);
			_tmp98_ = g_node_unlink_vala (_tmp97_);
			g_node_insert (_tmp95_, 0, _tmp98_);
			_tmp99_ = ((PostProcessor*) self)->_all_messages;
			_tmp100_ = last_latex_node;
			_tmp101_ = g_node_child_position (_tmp99_, _tmp100_);
			pos = _tmp101_;
			_tmp102_ = last_latex_node;
			_tmp103_ = g_node_unlink_vala (_tmp102_);
			_tmp104_ = _tmp103_;
			__g_node_destroy__build_msg_free0_0 (_tmp104_);
			_tmp105_ = ((PostProcessor*) self)->_all_messages;
			_tmp106_ = pos;
			_tmp107_ = latex_messages;
			latex_messages = NULL;
			g_node_insert (_tmp105_, _tmp106_, _tmp107_);
		}
		__g_node_destroy__build_msg_free0_0 (latex_messages);
		_g_object_unref0 (latex_pp);
	}
	_tmp108_ = ((PostProcessor*) self)->_all_messages;
	_tmp109_ = _tmp108_->children;
	if (_tmp109_ != NULL) {
		_g_match_info_free0 (match_info);
		_g_free0 (last_latex_output);
		return;
	}
	_tmp110_ = all_output_post_processor_new ();
	all_output_pp = (PostProcessor*) _tmp110_;
	_tmp111_ = latexmk_post_processor__reg_no_rule;
	_tmp112_ = output;
	_tmp114_ = g_regex_match (_tmp111_, _tmp112_, 0, &_tmp113_);
	_g_match_info_free0 (match_info);
	match_info = _tmp113_;
	if (_tmp114_) {
		GMatchInfo* _tmp115_;
		gchar* _tmp116_ = NULL;
		gchar* all_output;
		PostProcessor* _tmp117_;
		GFile* _tmp118_;
		const gchar* _tmp119_;
		_tmp115_ = match_info;
		_tmp116_ = g_match_info_fetch_named (_tmp115_, "output");
		all_output = _tmp116_;
		_tmp117_ = all_output_pp;
		_tmp118_ = file;
		_tmp119_ = all_output;
		post_processor_process (_tmp117_, _tmp118_, _tmp119_);
		_g_free0 (all_output);
	} else {
		PostProcessor* _tmp120_;
		GFile* _tmp121_;
		const gchar* _tmp122_;
		_tmp120_ = all_output_pp;
		_tmp121_ = file;
		_tmp122_ = output;
		post_processor_process (_tmp120_, _tmp121_, _tmp122_);
	}
	_tmp123_ = all_output_pp;
	_tmp124_ = post_processor_get_messages (_tmp123_);
	__g_node_destroy__build_msg_free0_0 (((PostProcessor*) self)->_all_messages);
	((PostProcessor*) self)->_all_messages = _tmp124_;
	_g_object_unref0 (all_output_pp);
	_g_match_info_free0 (match_info);
	_g_free0 (last_latex_output);
}


static void latexmk_post_processor_class_init (LatexmkPostProcessorClass * klass) {
	latexmk_post_processor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (LatexmkPostProcessorPrivate));
	POST_PROCESSOR_CLASS (klass)->process = latexmk_post_processor_real_process;
	G_OBJECT_CLASS (klass)->finalize = latexmk_post_processor_finalize;
}


static void latexmk_post_processor_instance_init (LatexmkPostProcessor * self) {
	self->priv = LATEXMK_POST_PROCESSOR_GET_PRIVATE (self);
}


static void latexmk_post_processor_finalize (GObject* obj) {
	LatexmkPostProcessor * self;
	self = LATEXMK_POST_PROCESSOR (obj);
	G_OBJECT_CLASS (latexmk_post_processor_parent_class)->finalize (obj);
}


GType latexmk_post_processor_get_type (void) {
	static volatile gsize latexmk_post_processor_type_id__volatile = 0;
	if (g_once_init_enter (&latexmk_post_processor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LatexmkPostProcessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) latexmk_post_processor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LatexmkPostProcessor), 0, (GInstanceInitFunc) latexmk_post_processor_instance_init, NULL };
		GType latexmk_post_processor_type_id;
		latexmk_post_processor_type_id = g_type_register_static (TYPE_POST_PROCESSOR, "LatexmkPostProcessor", &g_define_type_info, 0);
		g_once_init_leave (&latexmk_post_processor_type_id__volatile, latexmk_post_processor_type_id);
	}
	return latexmk_post_processor_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



