/* project_dialogs.c generated by valac 0.16.1, the Vala compiler
 * generated from project_dialogs.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gtksourceview/gtksourceview.h>
#include <gee.h>


#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _Block9Data Block9Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;

#define TYPE_PROJECTS (projects_get_type ())
#define PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECTS, Projects))
#define PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECTS, ProjectsClass))
#define IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECTS))
#define IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECTS))
#define PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECTS, ProjectsClass))

typedef struct _Projects Projects;
typedef struct _ProjectsClass ProjectsClass;
#define _projects_unref0(var) ((var == NULL) ? NULL : (var = (projects_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))

#define PROJECT_DIALOGS_TYPE_PROJECT_COLUMN (project_dialogs_project_column_get_type ())
typedef struct _Block10Data Block10Data;

struct _Block9Data {
	int _ref_count_;
	GtkFileChooserButton* directory_chooser;
	GtkFileChooserButton* main_file_chooser;
};

struct _Project {
	GFile* directory;
	GFile* main_file;
};

typedef enum  {
	PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY,
	PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE,
	PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS
} ProjectDialogsProjectColumn;

struct _Block10Data {
	int _ref_count_;
	GtkDialog* dialog;
	GtkListStore* store;
	GtkTreeView* treeview;
};



GType main_window_get_type (void) G_GNUC_CONST;
void project_dialogs_new_project (MainWindow* main_window);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
GtkWidget* utils_get_dialog_component (const gchar* title, GtkWidget* widget);
static void __lambda101_ (Block9Data* _data9_);
static void ___lambda101__gtk_file_chooser_button_file_set (GtkFileChooserButton* _sender, gpointer self);
GType document_get_type (void) G_GNUC_CONST;
Document* main_window_get_active_document (MainWindow* self);
GFile* document_get_location (Document* self);
gboolean project_dialogs_main_file_is_in_directory (GtkWindow* window, GFile* main_file, GFile* directory);
GType project_get_type (void) G_GNUC_CONST;
Project* project_dup (const Project* self);
void project_free (Project* self);
void project_copy (const Project* self, Project* dest);
void project_destroy (Project* self);
gpointer projects_ref (gpointer instance);
void projects_unref (gpointer instance);
GParamSpec* param_spec_projects (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_projects (GValue* value, gpointer v_object);
void value_take_projects (GValue* value, gpointer v_object);
gpointer value_get_projects (const GValue* value);
GType projects_get_type (void) G_GNUC_CONST;
Projects* projects_get_default (void);
gboolean projects_add (Projects* self, Project* new_project, GFile** conflict_file);
gchar* utils_replace_home_dir_with_tilde (const gchar* uri);
gboolean project_dialogs_configure_project (GtkWindow* main_window, gint project_id);
Project* projects_get (Projects* self, gint id);
gboolean projects_change_main_file (Projects* self, gint num, GFile* new_main_file);
GType project_dialogs_project_column_get_type (void) G_GNUC_CONST;
void project_dialogs_manage_projects (MainWindow* main_window);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
void project_dialogs_update_model (GtkListStore* model);
GtkWidget* utils_add_scrollbar (GtkWidget* child);
static void __lambda102_ (Block10Data* _data10_);
gint utils_get_selected_row (GtkTreeView* view, GtkTreeIter* iter);
static void ___lambda102__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda103_ (Block10Data* _data10_);
void projects_delete (Projects* self, gint num);
static void ___lambda103__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda104_ (Block10Data* _data10_);
void projects_clear_all (Projects* self);
static void ___lambda104__gtk_button_clicked (GtkButton* _sender, gpointer self);
GeeIterator* projects_iterator (Projects* self);


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void block9_data_unref (void * _userdata_) {
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		_g_object_unref0 (_data9_->main_file_chooser);
		_g_object_unref0 (_data9_->directory_chooser);
		g_slice_free (Block9Data, _data9_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda101_ (Block9Data* _data9_) {
	GtkFileChooserButton* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_;
	GFile* dir;
	GError * _inner_error_ = NULL;
	_tmp0_ = _data9_->directory_chooser;
	_tmp1_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	dir = _tmp2_;
	{
		GtkFileChooserButton* _tmp3_;
		_tmp3_ = _data9_->main_file_chooser;
		gtk_file_chooser_set_current_folder_file ((GtkFileChooser*) _tmp3_, dir, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch29_g_error;
		}
	}
	goto __finally29;
	__catch29_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally29:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (dir);
}


static void ___lambda101__gtk_file_chooser_button_file_set (GtkFileChooserButton* _sender, gpointer self) {
	__lambda101_ (self);
}


void project_dialogs_new_project (MainWindow* main_window) {
	Block9Data* _data9_;
	const gchar* _tmp0_ = NULL;
	MainWindow* _tmp1_;
	GtkDialog* _tmp2_;
	GtkDialog* _tmp3_;
	GtkDialog* dialog;
	GtkDialog* _tmp4_;
	GtkWidget* _tmp5_ = NULL;
	GtkVBox* _tmp6_;
	GtkVBox* content_area;
	const gchar* _tmp7_ = NULL;
	GtkFileChooserButton* _tmp8_;
	GtkFileChooserButton* _tmp9_;
	GtkFileChooserButton* _tmp10_;
	const gchar* _tmp11_ = NULL;
	GtkFileChooserButton* _tmp12_;
	GtkWidget* _tmp13_ = NULL;
	GtkWidget* component;
	GtkVBox* _tmp14_;
	GtkWidget* _tmp15_;
	const gchar* _tmp16_ = NULL;
	GtkFileChooserButton* _tmp17_;
	GtkFileChooserButton* _tmp18_;
	const gchar* _tmp19_ = NULL;
	GtkFileChooserButton* _tmp20_;
	GtkWidget* _tmp21_ = NULL;
	GtkVBox* _tmp22_;
	GtkWidget* _tmp23_;
	GtkVBox* _tmp24_;
	GtkFileChooserButton* _tmp25_;
	MainWindow* _tmp26_;
	Document* _tmp27_;
	Document* _tmp28_;
	Document* _tmp29_;
	Document* doc;
	gboolean _tmp30_ = FALSE;
	Document* _tmp31_;
	gboolean _tmp35_;
	GtkDialog* _tmp86_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (main_window != NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_tmp0_ = _ ("New Project");
	_tmp1_ = main_window;
	_tmp2_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp0_, (GtkWindow*) _tmp1_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_NEW, GTK_RESPONSE_OK, NULL, NULL);
	_tmp3_ = g_object_ref_sink (_tmp2_);
	dialog = _tmp3_;
	_tmp4_ = dialog;
	_tmp5_ = gtk_dialog_get_content_area (_tmp4_);
	_tmp6_ = _g_object_ref0 (GTK_IS_VBOX (_tmp5_) ? ((GtkVBox*) _tmp5_) : NULL);
	content_area = _tmp6_;
	_tmp7_ = _ ("Directory");
	_tmp8_ = (GtkFileChooserButton*) gtk_file_chooser_button_new (_tmp7_, GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER);
	_tmp9_ = g_object_ref_sink (_tmp8_);
	_data9_->directory_chooser = _tmp9_;
	_tmp10_ = _data9_->directory_chooser;
	gtk_widget_set_size_request ((GtkWidget*) _tmp10_, 250, -1);
	_tmp11_ = _ ("Directory");
	_tmp12_ = _data9_->directory_chooser;
	_tmp13_ = utils_get_dialog_component (_tmp11_, (GtkWidget*) _tmp12_);
	component = _tmp13_;
	_tmp14_ = content_area;
	_tmp15_ = component;
	gtk_box_pack_start ((GtkBox*) _tmp14_, _tmp15_, FALSE, TRUE, (guint) 0);
	_tmp16_ = _ ("Main File");
	_tmp17_ = (GtkFileChooserButton*) gtk_file_chooser_button_new (_tmp16_, GTK_FILE_CHOOSER_ACTION_OPEN);
	_tmp18_ = g_object_ref_sink (_tmp17_);
	_data9_->main_file_chooser = _tmp18_;
	_tmp19_ = _ ("Main File");
	_tmp20_ = _data9_->main_file_chooser;
	_tmp21_ = utils_get_dialog_component (_tmp19_, (GtkWidget*) _tmp20_);
	_g_object_unref0 (component);
	component = _tmp21_;
	_tmp22_ = content_area;
	_tmp23_ = component;
	gtk_box_pack_start ((GtkBox*) _tmp22_, _tmp23_, FALSE, TRUE, (guint) 0);
	_tmp24_ = content_area;
	gtk_widget_show_all ((GtkWidget*) _tmp24_);
	_tmp25_ = _data9_->directory_chooser;
	g_signal_connect_data (_tmp25_, "file-set", (GCallback) ___lambda101__gtk_file_chooser_button_file_set, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
	_tmp26_ = main_window;
	_tmp27_ = main_window_get_active_document (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = _g_object_ref0 (_tmp28_);
	doc = _tmp29_;
	_tmp31_ = doc;
	if (_tmp31_ != NULL) {
		Document* _tmp32_;
		GFile* _tmp33_;
		GFile* _tmp34_;
		_tmp32_ = doc;
		_tmp33_ = document_get_location (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp30_ = _tmp34_ != NULL;
	} else {
		_tmp30_ = FALSE;
	}
	_tmp35_ = _tmp30_;
	if (_tmp35_) {
		{
			GtkFileChooserButton* _tmp36_;
			Document* _tmp37_;
			GFile* _tmp38_;
			GFile* _tmp39_;
			GFile* _tmp40_ = NULL;
			GFile* _tmp41_;
			GtkFileChooserButton* _tmp42_;
			Document* _tmp43_;
			GFile* _tmp44_;
			GFile* _tmp45_;
			_tmp36_ = _data9_->directory_chooser;
			_tmp37_ = doc;
			_tmp38_ = document_get_location (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = g_file_get_parent (_tmp39_);
			_tmp41_ = _tmp40_;
			gtk_file_chooser_set_file ((GtkFileChooser*) _tmp36_, _tmp41_, &_inner_error_);
			_g_object_unref0 (_tmp41_);
			if (_inner_error_ != NULL) {
				goto __catch30_g_error;
			}
			_tmp42_ = _data9_->main_file_chooser;
			_tmp43_ = doc;
			_tmp44_ = document_get_location (_tmp43_);
			_tmp45_ = _tmp44_;
			gtk_file_chooser_set_file ((GtkFileChooser*) _tmp42_, _tmp45_, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch30_g_error;
			}
		}
		goto __finally30;
		__catch30_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally30:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (doc);
			_g_object_unref0 (component);
			_g_object_unref0 (content_area);
			_g_object_unref0 (dialog);
			block9_data_unref (_data9_);
			_data9_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	while (TRUE) {
		GtkDialog* _tmp46_;
		gint _tmp47_ = 0;
		GtkFileChooserButton* _tmp48_;
		GFile* _tmp49_ = NULL;
		GFile* _tmp50_;
		GFile* directory;
		GtkFileChooserButton* _tmp51_;
		GFile* _tmp52_ = NULL;
		GFile* _tmp53_;
		GFile* main_file;
		gboolean _tmp54_ = FALSE;
		GFile* _tmp55_;
		gboolean _tmp57_;
		GtkDialog* _tmp58_;
		GFile* _tmp59_;
		GFile* _tmp60_;
		gboolean _tmp61_ = FALSE;
		Project project = {0};
		GFile* _tmp62_;
		GFile* _tmp63_;
		GFile* _tmp64_;
		GFile* _tmp65_;
		GFile* conflict = NULL;
		Projects* _tmp66_ = NULL;
		Projects* _tmp67_;
		Project _tmp68_;
		GFile* _tmp69_ = NULL;
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_;
		GtkDialog* _tmp72_;
		const gchar* _tmp73_ = NULL;
		GFile* _tmp74_;
		gchar* _tmp75_ = NULL;
		gchar* _tmp76_;
		gchar* _tmp77_ = NULL;
		gchar* _tmp78_;
		gchar* _tmp79_;
		gchar* _tmp80_;
		GtkMessageDialog* _tmp81_;
		GtkDialog* _tmp82_;
		GtkDialog* _tmp83_;
		GtkDialog* error_dialog;
		GtkDialog* _tmp84_;
		GtkDialog* _tmp85_;
		_tmp46_ = dialog;
		_tmp47_ = gtk_dialog_run (_tmp46_);
		if (!(_tmp47_ == ((gint) GTK_RESPONSE_OK))) {
			break;
		}
		_tmp48_ = _data9_->directory_chooser;
		_tmp49_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp48_);
		_tmp50_ = _g_object_ref0 (_tmp49_);
		directory = _tmp50_;
		_tmp51_ = _data9_->main_file_chooser;
		_tmp52_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp51_);
		_tmp53_ = _g_object_ref0 (_tmp52_);
		main_file = _tmp53_;
		_tmp55_ = directory;
		if (_tmp55_ == NULL) {
			_tmp54_ = TRUE;
		} else {
			GFile* _tmp56_;
			_tmp56_ = main_file;
			_tmp54_ = _tmp56_ == NULL;
		}
		_tmp57_ = _tmp54_;
		if (_tmp57_) {
			_g_object_unref0 (main_file);
			_g_object_unref0 (directory);
			continue;
		}
		_tmp58_ = dialog;
		_tmp59_ = main_file;
		_tmp60_ = directory;
		_tmp61_ = project_dialogs_main_file_is_in_directory ((GtkWindow*) _tmp58_, _tmp59_, _tmp60_);
		if (!_tmp61_) {
			_g_object_unref0 (main_file);
			_g_object_unref0 (directory);
			continue;
		}
		memset (&project, 0, sizeof (Project));
		_tmp62_ = directory;
		_tmp63_ = _g_object_ref0 (_tmp62_);
		_g_object_unref0 (project.directory);
		project.directory = _tmp63_;
		_tmp64_ = main_file;
		_tmp65_ = _g_object_ref0 (_tmp64_);
		_g_object_unref0 (project.main_file);
		project.main_file = _tmp65_;
		_tmp66_ = projects_get_default ();
		_tmp67_ = _tmp66_;
		_tmp68_ = project;
		_tmp70_ = projects_add (_tmp67_, &_tmp68_, &_tmp69_);
		_g_object_unref0 (conflict);
		conflict = _tmp69_;
		_tmp71_ = _tmp70_;
		_projects_unref0 (_tmp67_);
		if (_tmp71_) {
			_g_object_unref0 (conflict);
			project_destroy (&project);
			_g_object_unref0 (main_file);
			_g_object_unref0 (directory);
			break;
		}
		_tmp72_ = dialog;
		_tmp73_ = _ ("There is a conflict with the project \"%s\".");
		_tmp74_ = conflict;
		_tmp75_ = g_file_get_parse_name (_tmp74_);
		_tmp76_ = _tmp75_;
		_tmp77_ = utils_replace_home_dir_with_tilde (_tmp76_);
		_tmp78_ = _tmp77_;
		_tmp79_ = g_strconcat (_tmp78_, "/", NULL);
		_tmp80_ = _tmp79_;
		_tmp81_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp72_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _tmp73_, _tmp80_);
		_tmp82_ = (GtkDialog*) g_object_ref_sink (_tmp81_);
		_tmp83_ = _tmp82_;
		_g_free0 (_tmp80_);
		_g_free0 (_tmp78_);
		_g_free0 (_tmp76_);
		error_dialog = _tmp83_;
		_tmp84_ = error_dialog;
		gtk_dialog_run (_tmp84_);
		_tmp85_ = error_dialog;
		gtk_object_destroy ((GtkObject*) _tmp85_);
		_g_object_unref0 (error_dialog);
		_g_object_unref0 (conflict);
		project_destroy (&project);
		_g_object_unref0 (main_file);
		_g_object_unref0 (directory);
	}
	_tmp86_ = dialog;
	gtk_object_destroy ((GtkObject*) _tmp86_);
	_g_object_unref0 (doc);
	_g_object_unref0 (component);
	_g_object_unref0 (content_area);
	_g_object_unref0 (dialog);
	block9_data_unref (_data9_);
	_data9_ = NULL;
}


gboolean project_dialogs_configure_project (GtkWindow* main_window, gint project_id) {
	gboolean result = FALSE;
	Projects* _tmp0_ = NULL;
	Projects* _tmp1_;
	gint _tmp2_;
	Project* _tmp3_ = NULL;
	Project* _tmp4_;
	Project* project;
	Project* _tmp5_;
	const gchar* _tmp6_ = NULL;
	GtkWindow* _tmp7_;
	GtkDialog* _tmp8_;
	GtkDialog* _tmp9_;
	GtkDialog* dialog;
	GtkDialog* _tmp10_;
	GtkWidget* _tmp11_ = NULL;
	GtkVBox* _tmp12_;
	GtkVBox* content_area;
	Project* _tmp13_;
	GFile* _tmp14_;
	gchar* _tmp15_ = NULL;
	gchar* project_dir;
	const gchar* _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	GtkLabel* _tmp21_;
	GtkLabel* _tmp22_;
	GtkLabel* location;
	GtkLabel* _tmp23_;
	const gchar* _tmp24_ = NULL;
	GtkLabel* _tmp25_;
	GtkWidget* _tmp26_ = NULL;
	GtkWidget* component;
	GtkVBox* _tmp27_;
	GtkWidget* _tmp28_;
	const gchar* _tmp29_ = NULL;
	GtkFileChooserButton* _tmp30_;
	GtkFileChooserButton* _tmp31_;
	GtkFileChooserButton* main_file_chooser;
	const gchar* _tmp32_ = NULL;
	GtkFileChooserButton* _tmp33_;
	GtkWidget* _tmp34_ = NULL;
	GtkVBox* _tmp35_;
	GtkWidget* _tmp36_;
	GtkVBox* _tmp37_;
	gboolean ret;
	GtkDialog* _tmp57_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (main_window != NULL, FALSE);
	_tmp0_ = projects_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = project_id;
	_tmp3_ = projects_get (_tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	_projects_unref0 (_tmp1_);
	project = _tmp4_;
	_tmp5_ = project;
	g_return_val_if_fail (_tmp5_ != NULL, FALSE);
	_tmp6_ = _ ("Configure Project");
	_tmp7_ = main_window;
	_tmp8_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp6_, _tmp7_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OK, GTK_RESPONSE_OK, NULL, NULL);
	_tmp9_ = g_object_ref_sink (_tmp8_);
	dialog = _tmp9_;
	_tmp10_ = dialog;
	_tmp11_ = gtk_dialog_get_content_area (_tmp10_);
	_tmp12_ = _g_object_ref0 (GTK_IS_VBOX (_tmp11_) ? ((GtkVBox*) _tmp11_) : NULL);
	content_area = _tmp12_;
	_tmp13_ = project;
	_tmp14_ = (*_tmp13_).directory;
	_tmp15_ = g_file_get_parse_name (_tmp14_);
	project_dir = _tmp15_;
	_tmp16_ = project_dir;
	_tmp17_ = utils_replace_home_dir_with_tilde (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strconcat (_tmp18_, "/", NULL);
	_g_free0 (project_dir);
	project_dir = _tmp19_;
	_g_free0 (_tmp18_);
	_tmp20_ = project_dir;
	_tmp21_ = (GtkLabel*) gtk_label_new (_tmp20_);
	_tmp22_ = g_object_ref_sink (_tmp21_);
	location = _tmp22_;
	_tmp23_ = location;
	gtk_label_set_line_wrap (_tmp23_, TRUE);
	_tmp24_ = _ ("Location of the project");
	_tmp25_ = location;
	_tmp26_ = utils_get_dialog_component (_tmp24_, (GtkWidget*) _tmp25_);
	component = _tmp26_;
	_tmp27_ = content_area;
	_tmp28_ = component;
	gtk_box_pack_start ((GtkBox*) _tmp27_, _tmp28_, FALSE, TRUE, (guint) 0);
	_tmp29_ = _ ("Main File");
	_tmp30_ = (GtkFileChooserButton*) gtk_file_chooser_button_new (_tmp29_, GTK_FILE_CHOOSER_ACTION_OPEN);
	_tmp31_ = g_object_ref_sink (_tmp30_);
	main_file_chooser = _tmp31_;
	_tmp32_ = _ ("Main File");
	_tmp33_ = main_file_chooser;
	_tmp34_ = utils_get_dialog_component (_tmp32_, (GtkWidget*) _tmp33_);
	_g_object_unref0 (component);
	component = _tmp34_;
	_tmp35_ = content_area;
	_tmp36_ = component;
	gtk_box_pack_start ((GtkBox*) _tmp35_, _tmp36_, FALSE, TRUE, (guint) 0);
	_tmp37_ = content_area;
	gtk_widget_show_all ((GtkWidget*) _tmp37_);
	{
		GtkFileChooserButton* _tmp38_;
		Project* _tmp39_;
		GFile* _tmp40_;
		_tmp38_ = main_file_chooser;
		_tmp39_ = project;
		_tmp40_ = (*_tmp39_).main_file;
		gtk_file_chooser_set_file ((GtkFileChooser*) _tmp38_, _tmp40_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch31_g_error;
		}
	}
	goto __finally31;
	__catch31_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally31:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (main_file_chooser);
		_g_object_unref0 (component);
		_g_object_unref0 (location);
		_g_free0 (project_dir);
		_g_object_unref0 (content_area);
		_g_object_unref0 (dialog);
		_project_free0 (project);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	ret = FALSE;
	while (TRUE) {
		GtkDialog* _tmp41_;
		gint _tmp42_ = 0;
		GtkFileChooserButton* _tmp43_;
		GFile* _tmp44_ = NULL;
		GFile* _tmp45_;
		GFile* main_file;
		GFile* _tmp46_;
		GtkDialog* _tmp47_;
		GFile* _tmp48_;
		Project* _tmp49_;
		GFile* _tmp50_;
		gboolean _tmp51_ = FALSE;
		Projects* _tmp52_ = NULL;
		Projects* _tmp53_;
		gint _tmp54_;
		GFile* _tmp55_;
		gboolean _tmp56_ = FALSE;
		_tmp41_ = dialog;
		_tmp42_ = gtk_dialog_run (_tmp41_);
		if (!(_tmp42_ == ((gint) GTK_RESPONSE_OK))) {
			break;
		}
		_tmp43_ = main_file_chooser;
		_tmp44_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp43_);
		_tmp45_ = _g_object_ref0 (_tmp44_);
		main_file = _tmp45_;
		_tmp46_ = main_file;
		if (_tmp46_ == NULL) {
			_g_object_unref0 (main_file);
			continue;
		}
		_tmp47_ = dialog;
		_tmp48_ = main_file;
		_tmp49_ = project;
		_tmp50_ = (*_tmp49_).directory;
		_tmp51_ = project_dialogs_main_file_is_in_directory ((GtkWindow*) _tmp47_, _tmp48_, _tmp50_);
		if (!_tmp51_) {
			_g_object_unref0 (main_file);
			continue;
		}
		_tmp52_ = projects_get_default ();
		_tmp53_ = _tmp52_;
		_tmp54_ = project_id;
		_tmp55_ = main_file;
		_tmp56_ = projects_change_main_file (_tmp53_, _tmp54_, _tmp55_);
		ret = _tmp56_;
		_projects_unref0 (_tmp53_);
		_g_object_unref0 (main_file);
		break;
	}
	_tmp57_ = dialog;
	gtk_object_destroy ((GtkObject*) _tmp57_);
	result = ret;
	_g_object_unref0 (main_file_chooser);
	_g_object_unref0 (component);
	_g_object_unref0 (location);
	_g_free0 (project_dir);
	_g_object_unref0 (content_area);
	_g_object_unref0 (dialog);
	_project_free0 (project);
	return result;
}


GType project_dialogs_project_column_get_type (void) {
	static volatile gsize project_dialogs_project_column_type_id__volatile = 0;
	if (g_once_init_enter (&project_dialogs_project_column_type_id__volatile)) {
		static const GEnumValue values[] = {{PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, "PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY", "directory"}, {PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE, "PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE", "main-file"}, {PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS, "PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType project_dialogs_project_column_type_id;
		project_dialogs_project_column_type_id = g_enum_register_static ("ProjectDialogsProjectColumn", values);
		g_once_init_leave (&project_dialogs_project_column_type_id__volatile, project_dialogs_project_column_type_id);
	}
	return project_dialogs_project_column_type_id__volatile;
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}


static void block10_data_unref (void * _userdata_) {
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		_g_object_unref0 (_data10_->treeview);
		_g_object_unref0 (_data10_->store);
		_g_object_unref0 (_data10_->dialog);
		g_slice_free (Block10Data, _data10_);
	}
}


static void __lambda102_ (Block10Data* _data10_) {
	gint _tmp0_ = 0;
	gint i;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_;
	gboolean _tmp5_;
	_tmp0_ = utils_get_selected_row (_data10_->treeview, NULL);
	i = _tmp0_;
	_tmp2_ = i;
	if (_tmp2_ != (-1)) {
		gint _tmp3_;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = i;
		_tmp4_ = project_dialogs_configure_project ((GtkWindow*) _data10_->dialog, _tmp3_);
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp5_ = _tmp1_;
	if (_tmp5_) {
		project_dialogs_update_model (_data10_->store);
	}
}


static void ___lambda102__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda102_ (self);
}


static void __lambda103_ (Block10Data* _data10_) {
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gint _tmp1_ = 0;
	gint i;
	gint _tmp2_;
	gchar* directory = NULL;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* model;
	GtkTreeModel* _tmp4_;
	GtkTreeIter _tmp5_;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_;
	GtkMessageDialog* _tmp8_;
	GtkDialog* _tmp9_;
	GtkDialog* delete_dialog;
	GtkDialog* _tmp10_;
	GtkDialog* _tmp11_;
	gint _tmp12_ = 0;
	GtkDialog* _tmp17_;
	_tmp1_ = utils_get_selected_row (_data10_->treeview, &_tmp0_);
	iter = _tmp0_;
	i = _tmp1_;
	_tmp2_ = i;
	if (_tmp2_ == (-1)) {
		return;
	}
	_tmp3_ = _g_object_ref0 (GTK_TREE_MODEL (_data10_->store));
	model = _tmp3_;
	_tmp4_ = model;
	_tmp5_ = iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, &directory, -1, -1);
	_tmp6_ = _ ("Do you really want to delete the project \"%s\"?");
	_tmp7_ = directory;
	_tmp8_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _data10_->dialog, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _tmp6_, _tmp7_);
	_tmp9_ = (GtkDialog*) g_object_ref_sink (_tmp8_);
	delete_dialog = _tmp9_;
	_tmp10_ = delete_dialog;
	gtk_dialog_add_buttons (_tmp10_, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_DELETE, GTK_RESPONSE_YES, NULL);
	_tmp11_ = delete_dialog;
	_tmp12_ = gtk_dialog_run (_tmp11_);
	if (_tmp12_ == ((gint) GTK_RESPONSE_YES)) {
		GtkTreeIter _tmp13_;
		Projects* _tmp14_ = NULL;
		Projects* _tmp15_;
		gint _tmp16_;
		_tmp13_ = iter;
		gtk_list_store_remove (_data10_->store, &_tmp13_);
		_tmp14_ = projects_get_default ();
		_tmp15_ = _tmp14_;
		_tmp16_ = i;
		projects_delete (_tmp15_, _tmp16_);
		_projects_unref0 (_tmp15_);
	}
	_tmp17_ = delete_dialog;
	gtk_object_destroy ((GtkObject*) _tmp17_);
	_g_object_unref0 (delete_dialog);
	_g_object_unref0 (model);
	_g_free0 (directory);
}


static void ___lambda103__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda103_ (self);
}


static void __lambda104_ (Block10Data* _data10_) {
	const gchar* _tmp0_ = NULL;
	GtkMessageDialog* _tmp1_;
	GtkDialog* _tmp2_;
	GtkDialog* clear_dialog;
	GtkDialog* _tmp3_;
	const gchar* _tmp4_ = NULL;
	GtkButton* _tmp5_;
	GtkButton* _tmp6_;
	GtkButton* button;
	GtkImage* _tmp7_;
	GtkImage* _tmp8_;
	GtkImage* img;
	GtkButton* _tmp9_;
	GtkImage* _tmp10_;
	GtkButton* _tmp11_;
	GtkDialog* _tmp12_;
	GtkButton* _tmp13_;
	GtkDialog* _tmp14_;
	gint _tmp15_ = 0;
	GtkDialog* _tmp18_;
	_tmp0_ = _ ("Do you really want to clear all projects?");
	_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _data10_->dialog, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _tmp0_);
	_tmp2_ = (GtkDialog*) g_object_ref_sink (_tmp1_);
	clear_dialog = _tmp2_;
	_tmp3_ = clear_dialog;
	gtk_dialog_add_button (_tmp3_, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
	_tmp4_ = _ ("Clear All");
	_tmp5_ = (GtkButton*) gtk_button_new_with_label (_tmp4_);
	_tmp6_ = g_object_ref_sink (_tmp5_);
	button = _tmp6_;
	_tmp7_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_CLEAR, GTK_ICON_SIZE_BUTTON);
	_tmp8_ = g_object_ref_sink (_tmp7_);
	img = _tmp8_;
	_tmp9_ = button;
	_tmp10_ = img;
	gtk_button_set_image (_tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = button;
	gtk_widget_show_all ((GtkWidget*) _tmp11_);
	_tmp12_ = clear_dialog;
	_tmp13_ = button;
	gtk_dialog_add_action_widget (_tmp12_, (GtkWidget*) _tmp13_, (gint) GTK_RESPONSE_YES);
	_tmp14_ = clear_dialog;
	_tmp15_ = gtk_dialog_run (_tmp14_);
	if (_tmp15_ == ((gint) GTK_RESPONSE_YES)) {
		Projects* _tmp16_ = NULL;
		Projects* _tmp17_;
		_tmp16_ = projects_get_default ();
		_tmp17_ = _tmp16_;
		projects_clear_all (_tmp17_);
		_projects_unref0 (_tmp17_);
		gtk_list_store_clear (_data10_->store);
	}
	_tmp18_ = clear_dialog;
	gtk_object_destroy ((GtkObject*) _tmp18_);
	_g_object_unref0 (img);
	_g_object_unref0 (button);
	_g_object_unref0 (clear_dialog);
}


static void ___lambda104__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda104_ (self);
}


void project_dialogs_manage_projects (MainWindow* main_window) {
	Block10Data* _data10_;
	const gchar* _tmp0_ = NULL;
	MainWindow* _tmp1_;
	GtkDialog* _tmp2_;
	GtkDialog* _tmp3_;
	GtkWidget* _tmp4_ = NULL;
	GtkVBox* _tmp5_;
	GtkVBox* content_area;
	GtkListStore* _tmp6_;
	GtkTreeView* _tmp7_;
	GtkTreeView* _tmp8_;
	GtkTreeViewColumn* _tmp9_;
	GtkTreeViewColumn* _tmp10_;
	GtkTreeViewColumn* column;
	GtkTreeViewColumn* _tmp11_;
	GtkTreeViewColumn* _tmp12_;
	const gchar* _tmp13_ = NULL;
	GtkCellRendererPixbuf* _tmp14_;
	GtkCellRendererPixbuf* _tmp15_;
	GtkCellRendererPixbuf* pixbuf_renderer;
	GtkCellRendererPixbuf* _tmp16_;
	GtkTreeViewColumn* _tmp17_;
	GtkCellRendererPixbuf* _tmp18_;
	GtkCellRendererText* _tmp19_;
	GtkCellRendererText* _tmp20_;
	GtkCellRendererText* text_renderer;
	GtkTreeViewColumn* _tmp21_;
	GtkCellRendererText* _tmp22_;
	GtkTreeViewColumn* _tmp23_;
	GtkCellRendererText* _tmp24_;
	GtkTreeViewColumn* _tmp25_;
	GtkTreeViewColumn* _tmp26_;
	GtkTreeViewColumn* _tmp27_;
	GtkTreeViewColumn* _tmp28_;
	const gchar* _tmp29_ = NULL;
	GtkCellRendererPixbuf* _tmp30_;
	GtkCellRendererPixbuf* _tmp31_;
	GtkCellRendererPixbuf* _tmp32_;
	GtkTreeViewColumn* _tmp33_;
	GtkCellRendererPixbuf* _tmp34_;
	GtkCellRendererText* _tmp35_;
	GtkCellRendererText* _tmp36_;
	GtkTreeViewColumn* _tmp37_;
	GtkCellRendererText* _tmp38_;
	GtkTreeViewColumn* _tmp39_;
	GtkCellRendererText* _tmp40_;
	GtkTreeSelection* _tmp41_ = NULL;
	GtkTreeSelection* _tmp42_;
	GtkTreeSelection* select;
	GtkWidget* _tmp43_ = NULL;
	GtkWidget* sw;
	GtkHBox* _tmp44_;
	GtkHBox* _tmp45_;
	GtkHBox* hbox;
	GtkButton* _tmp46_;
	GtkButton* _tmp47_;
	GtkButton* edit_button;
	GtkButton* _tmp48_;
	GtkButton* _tmp49_;
	GtkButton* delete_button;
	const gchar* _tmp50_ = NULL;
	GtkButton* _tmp51_;
	GtkButton* _tmp52_;
	GtkButton* clear_all_button;
	GtkImage* _tmp53_;
	GtkImage* _tmp54_;
	GtkImage* image;
	g_return_if_fail (main_window != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_tmp0_ = _ ("Manage Projects");
	_tmp1_ = main_window;
	_tmp2_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp0_, (GtkWindow*) _tmp1_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_CLOSE, GTK_RESPONSE_OK, NULL, NULL);
	_tmp3_ = g_object_ref_sink (_tmp2_);
	_data10_->dialog = _tmp3_;
	_tmp4_ = gtk_dialog_get_content_area (_data10_->dialog);
	_tmp5_ = _g_object_ref0 (GTK_VBOX (_tmp4_));
	content_area = _tmp5_;
	_tmp6_ = gtk_list_store_new ((gint) PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING);
	_data10_->store = _tmp6_;
	project_dialogs_update_model (_data10_->store);
	_tmp7_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _data10_->store);
	_tmp8_ = g_object_ref_sink (_tmp7_);
	_data10_->treeview = _tmp8_;
	gtk_widget_set_size_request ((GtkWidget*) _data10_->treeview, 400, 150);
	gtk_tree_view_set_rules_hint (_data10_->treeview, TRUE);
	_tmp9_ = gtk_tree_view_column_new ();
	_tmp10_ = g_object_ref_sink (_tmp9_);
	column = _tmp10_;
	_tmp11_ = column;
	gtk_tree_view_append_column (_data10_->treeview, _tmp11_);
	_tmp12_ = column;
	_tmp13_ = _ ("Directory");
	gtk_tree_view_column_set_title (_tmp12_, _tmp13_);
	_tmp14_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	_tmp15_ = g_object_ref_sink (_tmp14_);
	pixbuf_renderer = _tmp15_;
	_tmp16_ = pixbuf_renderer;
	g_object_set (_tmp16_, "stock-id", GTK_STOCK_DIRECTORY, NULL);
	_tmp17_ = column;
	_tmp18_ = pixbuf_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp17_, (GtkCellRenderer*) _tmp18_, FALSE);
	_tmp19_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp20_ = g_object_ref_sink (_tmp19_);
	text_renderer = _tmp20_;
	_tmp21_ = column;
	_tmp22_ = text_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp21_, (GtkCellRenderer*) _tmp22_, TRUE);
	_tmp23_ = column;
	_tmp24_ = text_renderer;
	gtk_tree_view_column_set_attributes (_tmp23_, (GtkCellRenderer*) _tmp24_, "text", PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, NULL, NULL);
	_tmp25_ = gtk_tree_view_column_new ();
	_tmp26_ = g_object_ref_sink (_tmp25_);
	_g_object_unref0 (column);
	column = _tmp26_;
	_tmp27_ = column;
	gtk_tree_view_append_column (_data10_->treeview, _tmp27_);
	_tmp28_ = column;
	_tmp29_ = _ ("Main File");
	gtk_tree_view_column_set_title (_tmp28_, _tmp29_);
	_tmp30_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	_tmp31_ = g_object_ref_sink (_tmp30_);
	_g_object_unref0 (pixbuf_renderer);
	pixbuf_renderer = _tmp31_;
	_tmp32_ = pixbuf_renderer;
	g_object_set (_tmp32_, "stock-id", GTK_STOCK_FILE, NULL);
	_tmp33_ = column;
	_tmp34_ = pixbuf_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp33_, (GtkCellRenderer*) _tmp34_, FALSE);
	_tmp35_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp36_ = g_object_ref_sink (_tmp35_);
	_g_object_unref0 (text_renderer);
	text_renderer = _tmp36_;
	_tmp37_ = column;
	_tmp38_ = text_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp37_, (GtkCellRenderer*) _tmp38_, TRUE);
	_tmp39_ = column;
	_tmp40_ = text_renderer;
	gtk_tree_view_column_set_attributes (_tmp39_, (GtkCellRenderer*) _tmp40_, "text", PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE, NULL, NULL);
	_tmp41_ = gtk_tree_view_get_selection (_data10_->treeview);
	_tmp42_ = _g_object_ref0 (_tmp41_);
	select = _tmp42_;
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	_tmp43_ = utils_add_scrollbar ((GtkWidget*) _data10_->treeview);
	sw = _tmp43_;
	gtk_box_pack_start ((GtkBox*) content_area, sw, TRUE, TRUE, (guint) 0);
	_tmp44_ = (GtkHBox*) gtk_hbox_new (FALSE, 5);
	_tmp45_ = g_object_ref_sink (_tmp44_);
	hbox = _tmp45_;
	gtk_box_pack_start ((GtkBox*) content_area, (GtkWidget*) hbox, FALSE, FALSE, (guint) 5);
	_tmp46_ = (GtkButton*) gtk_button_new_from_stock (GTK_STOCK_PROPERTIES);
	_tmp47_ = g_object_ref_sink (_tmp46_);
	edit_button = _tmp47_;
	_tmp48_ = (GtkButton*) gtk_button_new_from_stock (GTK_STOCK_DELETE);
	_tmp49_ = g_object_ref_sink (_tmp48_);
	delete_button = _tmp49_;
	_tmp50_ = _ ("Clear All");
	_tmp51_ = (GtkButton*) gtk_button_new_with_label (_tmp50_);
	_tmp52_ = g_object_ref_sink (_tmp51_);
	clear_all_button = _tmp52_;
	_tmp53_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_CLEAR, GTK_ICON_SIZE_MENU);
	_tmp54_ = g_object_ref_sink (_tmp53_);
	image = _tmp54_;
	gtk_button_set_image (clear_all_button, (GtkWidget*) image);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) edit_button, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) delete_button, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) clear_all_button, TRUE, TRUE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) content_area);
	g_signal_connect_data (edit_button, "clicked", (GCallback) ___lambda102__gtk_button_clicked, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	g_signal_connect_data (delete_button, "clicked", (GCallback) ___lambda103__gtk_button_clicked, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	g_signal_connect_data (clear_all_button, "clicked", (GCallback) ___lambda104__gtk_button_clicked, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	gtk_dialog_run (_data10_->dialog);
	gtk_object_destroy ((GtkObject*) _data10_->dialog);
	_g_object_unref0 (image);
	_g_object_unref0 (clear_all_button);
	_g_object_unref0 (delete_button);
	_g_object_unref0 (edit_button);
	_g_object_unref0 (hbox);
	_g_object_unref0 (sw);
	_g_object_unref0 (select);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
	_g_object_unref0 (column);
	_g_object_unref0 (content_area);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}


gboolean project_dialogs_main_file_is_in_directory (GtkWindow* window, GFile* main_file, GFile* directory) {
	gboolean result = FALSE;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GtkWindow* _tmp3_;
	const gchar* _tmp4_ = NULL;
	GtkMessageDialog* _tmp5_;
	GtkDialog* _tmp6_;
	GtkDialog* error_dialog;
	GtkDialog* _tmp7_;
	GtkDialog* _tmp8_;
	g_return_val_if_fail (window != NULL, FALSE);
	g_return_val_if_fail (main_file != NULL, FALSE);
	g_return_val_if_fail (directory != NULL, FALSE);
	_tmp0_ = main_file;
	_tmp1_ = directory;
	_tmp2_ = g_file_has_prefix (_tmp0_, _tmp1_);
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	_tmp3_ = window;
	_tmp4_ = _ ("The Main File is not in the directory.");
	_tmp5_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp3_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "%s", _tmp4_);
	_tmp6_ = (GtkDialog*) g_object_ref_sink (_tmp5_);
	error_dialog = _tmp6_;
	_tmp7_ = error_dialog;
	gtk_dialog_run (_tmp7_);
	_tmp8_ = error_dialog;
	gtk_object_destroy ((GtkObject*) _tmp8_);
	result = FALSE;
	_g_object_unref0 (error_dialog);
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


void project_dialogs_update_model (GtkListStore* model) {
	GtkListStore* _tmp0_;
	g_return_if_fail (model != NULL);
	_tmp0_ = model;
	gtk_list_store_clear (_tmp0_);
	{
		Projects* _tmp1_ = NULL;
		Projects* _tmp2_;
		GeeIterator* _tmp3_ = NULL;
		GeeIterator* _tmp4_;
		GeeIterator* _project_it;
		_tmp1_ = projects_get_default ();
		_tmp2_ = _tmp1_;
		_tmp3_ = projects_iterator (_tmp2_);
		_tmp4_ = _tmp3_;
		_projects_unref0 (_tmp2_);
		_project_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			gboolean _tmp6_ = FALSE;
			GeeIterator* _tmp7_;
			gpointer _tmp8_ = NULL;
			Project* _tmp9_;
			Project _tmp10_ = {0};
			Project _tmp11_;
			Project project;
			Project _tmp12_;
			GFile* _tmp13_;
			gchar* _tmp14_ = NULL;
			gchar* uri_directory;
			Project _tmp15_;
			GFile* _tmp16_;
			gchar* _tmp17_ = NULL;
			gchar* uri_main_file;
			const gchar* _tmp18_;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* dir;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			const gchar* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			gchar* _tmp30_ = NULL;
			gchar* main_file;
			GtkTreeIter iter = {0};
			GtkListStore* _tmp31_;
			GtkTreeIter _tmp32_ = {0};
			GtkListStore* _tmp33_;
			GtkTreeIter _tmp34_;
			const gchar* _tmp35_;
			const gchar* _tmp36_;
			_tmp5_ = _project_it;
			_tmp6_ = gee_iterator_next (_tmp5_);
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = _project_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			_tmp9_ = (Project*) _tmp8_;
			project_copy (_tmp9_, &_tmp10_);
			_tmp11_ = _tmp10_;
			_project_free0 (_tmp9_);
			project = _tmp11_;
			_tmp12_ = project;
			_tmp13_ = _tmp12_.directory;
			_tmp14_ = g_file_get_parse_name (_tmp13_);
			uri_directory = _tmp14_;
			_tmp15_ = project;
			_tmp16_ = _tmp15_.main_file;
			_tmp17_ = g_file_get_parse_name (_tmp16_);
			uri_main_file = _tmp17_;
			_tmp18_ = uri_directory;
			_tmp19_ = utils_replace_home_dir_with_tilde (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strconcat (_tmp20_, "/", NULL);
			_tmp22_ = _tmp21_;
			_g_free0 (_tmp20_);
			dir = _tmp22_;
			_tmp23_ = uri_main_file;
			_tmp24_ = uri_directory;
			_tmp25_ = strlen (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = uri_main_file;
			_tmp28_ = strlen (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = string_slice (_tmp23_, (glong) (_tmp26_ + 1), (glong) _tmp29_);
			main_file = _tmp30_;
			_tmp31_ = model;
			gtk_list_store_append (_tmp31_, &_tmp32_);
			iter = _tmp32_;
			_tmp33_ = model;
			_tmp34_ = iter;
			_tmp35_ = dir;
			_tmp36_ = main_file;
			gtk_list_store_set (_tmp33_, &_tmp34_, PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, _tmp35_, PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE, _tmp36_, -1, -1);
			_g_free0 (main_file);
			_g_free0 (dir);
			_g_free0 (uri_main_file);
			_g_free0 (uri_directory);
			project_destroy (&project);
		}
		_g_object_unref0 (_project_it);
	}
}



