/* templates_dialogs.c generated by valac 0.16.1, the Vala compiler
 * generated from templates_dialogs.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2012 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gtksourceview/gtksourceview.h>
#include <gobject/gvaluecollector.h>


#define TYPE_OPEN_TEMPLATE_DIALOG (open_template_dialog_get_type ())
#define OPEN_TEMPLATE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_OPEN_TEMPLATE_DIALOG, OpenTemplateDialog))
#define OPEN_TEMPLATE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_OPEN_TEMPLATE_DIALOG, OpenTemplateDialogClass))
#define IS_OPEN_TEMPLATE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_OPEN_TEMPLATE_DIALOG))
#define IS_OPEN_TEMPLATE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_OPEN_TEMPLATE_DIALOG))
#define OPEN_TEMPLATE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_OPEN_TEMPLATE_DIALOG, OpenTemplateDialogClass))

typedef struct _OpenTemplateDialog OpenTemplateDialog;
typedef struct _OpenTemplateDialogClass OpenTemplateDialogClass;
typedef struct _OpenTemplateDialogPrivate OpenTemplateDialogPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_TEMPLATES (templates_get_type ())
#define TEMPLATES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEMPLATES, Templates))
#define TEMPLATES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEMPLATES, TemplatesClass))
#define IS_TEMPLATES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEMPLATES))
#define IS_TEMPLATES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEMPLATES))
#define TEMPLATES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEMPLATES, TemplatesClass))

typedef struct _Templates Templates;
typedef struct _TemplatesClass TemplatesClass;
#define __g_list_free__gtk_tree_path_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_tree_path_free0_ (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _ParamSpecOpenTemplateDialog ParamSpecOpenTemplateDialog;

#define TYPE_CREATE_TEMPLATE_DIALOG (create_template_dialog_get_type ())
#define CREATE_TEMPLATE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CREATE_TEMPLATE_DIALOG, CreateTemplateDialog))
#define CREATE_TEMPLATE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CREATE_TEMPLATE_DIALOG, CreateTemplateDialogClass))
#define IS_CREATE_TEMPLATE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CREATE_TEMPLATE_DIALOG))
#define IS_CREATE_TEMPLATE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CREATE_TEMPLATE_DIALOG))
#define CREATE_TEMPLATE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CREATE_TEMPLATE_DIALOG, CreateTemplateDialogClass))

typedef struct _CreateTemplateDialog CreateTemplateDialog;
typedef struct _CreateTemplateDialogClass CreateTemplateDialogClass;
typedef struct _CreateTemplateDialogPrivate CreateTemplateDialogPrivate;

#define TYPE_DELETE_TEMPLATE_DIALOG (delete_template_dialog_get_type ())
#define DELETE_TEMPLATE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELETE_TEMPLATE_DIALOG, DeleteTemplateDialog))
#define DELETE_TEMPLATE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELETE_TEMPLATE_DIALOG, DeleteTemplateDialogClass))
#define IS_DELETE_TEMPLATE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELETE_TEMPLATE_DIALOG))
#define IS_DELETE_TEMPLATE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELETE_TEMPLATE_DIALOG))
#define DELETE_TEMPLATE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELETE_TEMPLATE_DIALOG, DeleteTemplateDialogClass))

typedef struct _DeleteTemplateDialog DeleteTemplateDialog;
typedef struct _DeleteTemplateDialogClass DeleteTemplateDialogClass;
typedef struct _DeleteTemplateDialogPrivate DeleteTemplateDialogPrivate;

struct _OpenTemplateDialog {
	GTypeInstance parent_instance;
	volatile int ref_count;
	OpenTemplateDialogPrivate * priv;
};

struct _OpenTemplateDialogClass {
	GTypeClass parent_class;
	void (*finalize) (OpenTemplateDialog *self);
};

struct _OpenTemplateDialogPrivate {
	MainWindow* _main_window;
	GtkDialog* _dialog;
	GtkIconView* _icon_view_default_templates;
	GtkIconView* _icon_view_personal_templates;
	GtkVPaned* _vpaned;
	GSettings* _settings;
};

struct _ParamSpecOpenTemplateDialog {
	GParamSpec parent_instance;
};

struct _CreateTemplateDialog {
	GtkDialog parent_instance;
	CreateTemplateDialogPrivate * priv;
};

struct _CreateTemplateDialogClass {
	GtkDialogClass parent_class;
};

struct _DeleteTemplateDialog {
	GtkDialog parent_instance;
	DeleteTemplateDialogPrivate * priv;
};

struct _DeleteTemplateDialogClass {
	GtkDialogClass parent_class;
};


static gpointer open_template_dialog_parent_class = NULL;
static gpointer create_template_dialog_parent_class = NULL;
static gpointer delete_template_dialog_parent_class = NULL;

gpointer open_template_dialog_ref (gpointer instance);
void open_template_dialog_unref (gpointer instance);
GParamSpec* param_spec_open_template_dialog (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_open_template_dialog (GValue* value, gpointer v_object);
void value_take_open_template_dialog (GValue* value, gpointer v_object);
gpointer value_get_open_template_dialog (const GValue* value);
GType open_template_dialog_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
#define OPEN_TEMPLATE_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_OPEN_TEMPLATE_DIALOG, OpenTemplateDialogPrivate))
enum  {
	OPEN_TEMPLATE_DIALOG_DUMMY_PROPERTY
};
OpenTemplateDialog* open_template_dialog_new (MainWindow* main_window);
OpenTemplateDialog* open_template_dialog_construct (GType object_type, MainWindow* main_window);
GType templates_get_type (void) G_GNUC_CONST;
Templates* templates_get_default (void);
GtkIconView* templates_create_icon_view_default_templates (Templates* self);
GtkWidget* utils_add_scrollbar (GtkWidget* child);
GtkWidget* utils_get_dialog_component (const gchar* title, GtkWidget* widget);
GtkIconView* templates_create_icon_view_personal_templates (Templates* self);
static void open_template_dialog_connect_to_signals (OpenTemplateDialog* self);
static void open_template_dialog_run_me (OpenTemplateDialog* self);
static void open_template_dialog_close_dialog (OpenTemplateDialog* self);
static void __lambda66_ (OpenTemplateDialog* self);
static void open_template_dialog_on_icon_view_selection_changed (OpenTemplateDialog* self, GtkIconView* icon_view, GtkIconView* other_icon_view);
static void ___lambda66__gtk_icon_view_selection_changed (GtkIconView* _sender, gpointer self);
static void __lambda67_ (OpenTemplateDialog* self);
static void ___lambda67__gtk_icon_view_selection_changed (GtkIconView* _sender, gpointer self);
static void __lambda68_ (OpenTemplateDialog* self, GtkTreePath* path);
static void open_template_dialog_open_default_template (OpenTemplateDialog* self, GtkTreePath* path);
static void ___lambda68__gtk_icon_view_item_activated (GtkIconView* _sender, GtkTreePath* path, gpointer self);
static void __lambda69_ (OpenTemplateDialog* self, GtkTreePath* path);
static void open_template_dialog_open_personal_template (OpenTemplateDialog* self, GtkTreePath* path);
static void ___lambda69__gtk_icon_view_item_activated (GtkIconView* _sender, GtkTreePath* path, gpointer self);
static void _gtk_tree_path_free0_ (gpointer var);
static void _g_list_free__gtk_tree_path_free0_ (GList* self);
static void open_template_dialog_create_document (OpenTemplateDialog* self, const gchar* contents);
gchar* templates_get_default_template_contents (Templates* self, GtkTreePath* path);
gchar* templates_get_personal_template_contents (Templates* self, GtkTreePath* path);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentTab* main_window_create_tab (MainWindow* self, gboolean jump_to);
GType document_get_type (void) G_GNUC_CONST;
Document* document_tab_get_document (DocumentTab* self);
void document_set_contents (Document* self, const gchar* contents);
static void open_template_dialog_finalize (OpenTemplateDialog* obj);
GType create_template_dialog_get_type (void) G_GNUC_CONST;
enum  {
	CREATE_TEMPLATE_DIALOG_DUMMY_PROPERTY
};
CreateTemplateDialog* create_template_dialog_new (MainWindow* parent);
CreateTemplateDialog* create_template_dialog_construct (GType object_type, MainWindow* parent);
DocumentTab* main_window_get_active_tab (MainWindow* self);
static void create_template_dialog_run_me (CreateTemplateDialog* self, MainWindow* parent, GtkEntry* entry, GtkIconView* icon_view);
Document* main_window_get_active_document (MainWindow* self);
gchar* templates_get_icon_id (Templates* self, GtkTreePath* default_template_path);
void templates_create_personal_template (Templates* self, const gchar* name, const gchar* icon_id, const gchar* contents);
GType delete_template_dialog_get_type (void) G_GNUC_CONST;
enum  {
	DELETE_TEMPLATE_DIALOG_DUMMY_PROPERTY
};
DeleteTemplateDialog* delete_template_dialog_new (MainWindow* parent);
DeleteTemplateDialog* delete_template_dialog_construct (GType object_type, MainWindow* parent);
static void delete_template_dialog_run_me (DeleteTemplateDialog* self, GtkIconView* icon_view);
void templates_delete_personal_template (Templates* self, GtkTreePath* template_path);
void templates_save_rc_file (Templates* self);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


OpenTemplateDialog* open_template_dialog_construct (GType object_type, MainWindow* main_window) {
	OpenTemplateDialog* self = NULL;
	MainWindow* _tmp0_;
	const gchar* _tmp1_ = NULL;
	MainWindow* _tmp2_;
	GtkDialog* _tmp3_;
	GtkDialog* _tmp4_;
	GSettings* _tmp5_;
	gint width = 0;
	gint height = 0;
	GSettings* _tmp6_;
	GtkDialog* _tmp7_;
	GtkDialog* _tmp8_;
	GtkDialog* _tmp9_;
	GtkWidget* _tmp10_ = NULL;
	GtkBox* _tmp11_;
	GtkBox* content_area;
	GtkVPaned* _tmp12_;
	GtkVPaned* _tmp13_;
	GtkVPaned* _tmp14_;
	GtkVPaned* _tmp15_;
	GSettings* _tmp16_;
	gint _tmp17_ = 0;
	Templates* _tmp18_ = NULL;
	Templates* templates;
	GtkIconView* _tmp19_ = NULL;
	GtkIconView* _tmp20_;
	GtkWidget* _tmp21_ = NULL;
	GtkWidget* scrollbar;
	const gchar* _tmp22_ = NULL;
	GtkWidget* _tmp23_;
	GtkWidget* _tmp24_ = NULL;
	GtkWidget* component;
	GtkVPaned* _tmp25_;
	GtkWidget* _tmp26_;
	GtkIconView* _tmp27_ = NULL;
	GtkIconView* _tmp28_;
	GtkWidget* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	GtkWidget* _tmp31_;
	GtkWidget* _tmp32_ = NULL;
	GtkVPaned* _tmp33_;
	GtkWidget* _tmp34_;
	g_return_val_if_fail (main_window != NULL, NULL);
	self = (OpenTemplateDialog*) g_type_create_instance (object_type);
	_tmp0_ = main_window;
	self->priv->_main_window = _tmp0_;
	_tmp1_ = _ ("New File...");
	_tmp2_ = main_window;
	_tmp3_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp1_, (GtkWindow*) _tmp2_, GTK_DIALOG_NO_SEPARATOR, GTK_STOCK_OK, GTK_RESPONSE_ACCEPT, GTK_STOCK_CANCEL, GTK_RESPONSE_REJECT, NULL, NULL);
	_tmp4_ = g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->_dialog);
	self->priv->_dialog = _tmp4_;
	_tmp5_ = g_settings_new ("org.gnome.latexila.state.window");
	_g_object_unref0 (self->priv->_settings);
	self->priv->_settings = _tmp5_;
	_tmp6_ = self->priv->_settings;
	g_settings_get (_tmp6_, "new-file-dialog-size", "(ii)", &width, &height);
	_tmp7_ = self->priv->_dialog;
	gtk_window_set_default_size ((GtkWindow*) _tmp7_, width, height);
	_tmp8_ = self->priv->_dialog;
	gtk_widget_set_size_request ((GtkWidget*) _tmp8_, 0, 0);
	_tmp9_ = self->priv->_dialog;
	_tmp10_ = gtk_dialog_get_content_area (_tmp9_);
	_tmp11_ = _g_object_ref0 (GTK_IS_BOX (_tmp10_) ? ((GtkBox*) _tmp10_) : NULL);
	content_area = _tmp11_;
	_tmp12_ = (GtkVPaned*) gtk_vpaned_new ();
	_tmp13_ = g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->_vpaned);
	self->priv->_vpaned = _tmp13_;
	_tmp14_ = self->priv->_vpaned;
	gtk_box_pack_start (content_area, (GtkWidget*) _tmp14_, TRUE, TRUE, (guint) 0);
	_tmp15_ = self->priv->_vpaned;
	_tmp16_ = self->priv->_settings;
	_tmp17_ = g_settings_get_int (_tmp16_, "new-file-dialog-paned-position");
	gtk_paned_set_position ((GtkPaned*) _tmp15_, _tmp17_);
	_tmp18_ = templates_get_default ();
	templates = _tmp18_;
	_tmp19_ = templates_create_icon_view_default_templates (templates);
	_g_object_unref0 (self->priv->_icon_view_default_templates);
	self->priv->_icon_view_default_templates = _tmp19_;
	_tmp20_ = self->priv->_icon_view_default_templates;
	_tmp21_ = utils_add_scrollbar ((GtkWidget*) _tmp20_);
	scrollbar = _tmp21_;
	_tmp22_ = _ ("Default templates");
	_tmp23_ = scrollbar;
	_tmp24_ = utils_get_dialog_component (_tmp22_, _tmp23_);
	component = _tmp24_;
	_tmp25_ = self->priv->_vpaned;
	_tmp26_ = component;
	gtk_paned_pack1 ((GtkPaned*) _tmp25_, _tmp26_, TRUE, TRUE);
	_tmp27_ = templates_create_icon_view_personal_templates (templates);
	_g_object_unref0 (self->priv->_icon_view_personal_templates);
	self->priv->_icon_view_personal_templates = _tmp27_;
	_tmp28_ = self->priv->_icon_view_personal_templates;
	_tmp29_ = utils_add_scrollbar ((GtkWidget*) _tmp28_);
	_g_object_unref0 (scrollbar);
	scrollbar = _tmp29_;
	_tmp30_ = _ ("Your personal templates");
	_tmp31_ = scrollbar;
	_tmp32_ = utils_get_dialog_component (_tmp30_, _tmp31_);
	_g_object_unref0 (component);
	component = _tmp32_;
	_tmp33_ = self->priv->_vpaned;
	_tmp34_ = component;
	gtk_paned_pack2 ((GtkPaned*) _tmp33_, _tmp34_, FALSE, TRUE);
	gtk_widget_show_all ((GtkWidget*) content_area);
	open_template_dialog_connect_to_signals (self);
	open_template_dialog_run_me (self);
	open_template_dialog_close_dialog (self);
	_g_object_unref0 (component);
	_g_object_unref0 (scrollbar);
	_g_object_unref0 (templates);
	_g_object_unref0 (content_area);
	return self;
}


OpenTemplateDialog* open_template_dialog_new (MainWindow* main_window) {
	return open_template_dialog_construct (TYPE_OPEN_TEMPLATE_DIALOG, main_window);
}


static void __lambda66_ (OpenTemplateDialog* self) {
	GtkIconView* _tmp0_;
	GtkIconView* _tmp1_;
	_tmp0_ = self->priv->_icon_view_default_templates;
	_tmp1_ = self->priv->_icon_view_personal_templates;
	open_template_dialog_on_icon_view_selection_changed (self, _tmp0_, _tmp1_);
}


static void ___lambda66__gtk_icon_view_selection_changed (GtkIconView* _sender, gpointer self) {
	__lambda66_ (self);
}


static void __lambda67_ (OpenTemplateDialog* self) {
	GtkIconView* _tmp0_;
	GtkIconView* _tmp1_;
	_tmp0_ = self->priv->_icon_view_personal_templates;
	_tmp1_ = self->priv->_icon_view_default_templates;
	open_template_dialog_on_icon_view_selection_changed (self, _tmp0_, _tmp1_);
}


static void ___lambda67__gtk_icon_view_selection_changed (GtkIconView* _sender, gpointer self) {
	__lambda67_ (self);
}


static void __lambda68_ (OpenTemplateDialog* self, GtkTreePath* path) {
	GtkTreePath* _tmp0_;
	g_return_if_fail (path != NULL);
	_tmp0_ = path;
	open_template_dialog_open_default_template (self, _tmp0_);
	open_template_dialog_close_dialog (self);
}


static void ___lambda68__gtk_icon_view_item_activated (GtkIconView* _sender, GtkTreePath* path, gpointer self) {
	__lambda68_ (self, path);
}


static void __lambda69_ (OpenTemplateDialog* self, GtkTreePath* path) {
	GtkTreePath* _tmp0_;
	g_return_if_fail (path != NULL);
	_tmp0_ = path;
	open_template_dialog_open_personal_template (self, _tmp0_);
	open_template_dialog_close_dialog (self);
}


static void ___lambda69__gtk_icon_view_item_activated (GtkIconView* _sender, GtkTreePath* path, gpointer self) {
	__lambda69_ (self, path);
}


static void open_template_dialog_connect_to_signals (OpenTemplateDialog* self) {
	GtkIconView* _tmp0_;
	GtkIconView* _tmp1_;
	GtkIconView* _tmp2_;
	GtkIconView* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_icon_view_default_templates;
	g_signal_connect (_tmp0_, "selection-changed", (GCallback) ___lambda66__gtk_icon_view_selection_changed, self);
	_tmp1_ = self->priv->_icon_view_personal_templates;
	g_signal_connect (_tmp1_, "selection-changed", (GCallback) ___lambda67__gtk_icon_view_selection_changed, self);
	_tmp2_ = self->priv->_icon_view_default_templates;
	g_signal_connect (_tmp2_, "item-activated", (GCallback) ___lambda68__gtk_icon_view_item_activated, self);
	_tmp3_ = self->priv->_icon_view_personal_templates;
	g_signal_connect (_tmp3_, "item-activated", (GCallback) ___lambda69__gtk_icon_view_item_activated, self);
}


static void _gtk_tree_path_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL));
}


static void _g_list_free__gtk_tree_path_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gtk_tree_path_free0_, NULL);
	g_list_free (self);
}


static void open_template_dialog_on_icon_view_selection_changed (OpenTemplateDialog* self, GtkIconView* icon_view, GtkIconView* other_icon_view) {
	GtkIconView* _tmp0_;
	GList* _tmp1_ = NULL;
	GList* selected_items;
	GList* _tmp2_;
	guint _tmp3_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_view != NULL);
	g_return_if_fail (other_icon_view != NULL);
	_tmp0_ = icon_view;
	_tmp1_ = gtk_icon_view_get_selected_items (_tmp0_);
	selected_items = _tmp1_;
	_tmp2_ = selected_items;
	_tmp3_ = g_list_length (_tmp2_);
	if (_tmp3_ > ((guint) 0)) {
		GtkIconView* _tmp4_;
		_tmp4_ = other_icon_view;
		g_signal_emit_by_name (_tmp4_, "unselect-all");
	}
	__g_list_free__gtk_tree_path_free0_0 (selected_items);
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


static void open_template_dialog_run_me (OpenTemplateDialog* self) {
	GtkDialog* _tmp0_;
	gint _tmp1_ = 0;
	GtkIconView* _tmp2_;
	GList* _tmp3_ = NULL;
	GList* selected_items;
	GList* _tmp4_;
	guint _tmp5_ = 0U;
	GtkIconView* _tmp10_;
	GList* _tmp11_ = NULL;
	GList* _tmp12_;
	guint _tmp13_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_dialog;
	_tmp1_ = gtk_dialog_run (_tmp0_);
	if (_tmp1_ != ((gint) GTK_RESPONSE_ACCEPT)) {
		return;
	}
	_tmp2_ = self->priv->_icon_view_default_templates;
	_tmp3_ = gtk_icon_view_get_selected_items (_tmp2_);
	selected_items = _tmp3_;
	_tmp4_ = selected_items;
	_tmp5_ = g_list_length (_tmp4_);
	if (_tmp5_ > ((guint) 0)) {
		GList* _tmp6_;
		gconstpointer _tmp7_ = NULL;
		GtkTreePath* _tmp8_;
		GtkTreePath* path;
		GtkTreePath* _tmp9_;
		_tmp6_ = selected_items;
		_tmp7_ = g_list_nth_data (_tmp6_, (guint) 0);
		_tmp8_ = _gtk_tree_path_copy0 ((GtkTreePath*) _tmp7_);
		path = _tmp8_;
		_tmp9_ = path;
		open_template_dialog_open_default_template (self, _tmp9_);
		_gtk_tree_path_free0 (path);
		__g_list_free__gtk_tree_path_free0_0 (selected_items);
		return;
	}
	_tmp10_ = self->priv->_icon_view_personal_templates;
	_tmp11_ = gtk_icon_view_get_selected_items (_tmp10_);
	__g_list_free__gtk_tree_path_free0_0 (selected_items);
	selected_items = _tmp11_;
	_tmp12_ = selected_items;
	_tmp13_ = g_list_length (_tmp12_);
	if (_tmp13_ > ((guint) 0)) {
		GList* _tmp14_;
		gconstpointer _tmp15_ = NULL;
		GtkTreePath* _tmp16_;
		GtkTreePath* path;
		GtkTreePath* _tmp17_;
		_tmp14_ = selected_items;
		_tmp15_ = g_list_nth_data (_tmp14_, (guint) 0);
		_tmp16_ = _gtk_tree_path_copy0 ((GtkTreePath*) _tmp15_);
		path = _tmp16_;
		_tmp17_ = path;
		open_template_dialog_open_personal_template (self, _tmp17_);
		_gtk_tree_path_free0 (path);
		__g_list_free__gtk_tree_path_free0_0 (selected_items);
		return;
	}
	open_template_dialog_create_document (self, "");
	__g_list_free__gtk_tree_path_free0_0 (selected_items);
}


static void open_template_dialog_open_default_template (OpenTemplateDialog* self, GtkTreePath* path) {
	Templates* _tmp0_ = NULL;
	Templates* templates;
	GtkTreePath* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = templates_get_default ();
	templates = _tmp0_;
	_tmp1_ = path;
	_tmp2_ = templates_get_default_template_contents (templates, _tmp1_);
	_tmp3_ = _tmp2_;
	open_template_dialog_create_document (self, _tmp3_);
	_g_free0 (_tmp3_);
	_g_object_unref0 (templates);
}


static void open_template_dialog_open_personal_template (OpenTemplateDialog* self, GtkTreePath* path) {
	Templates* _tmp0_ = NULL;
	Templates* templates;
	GtkTreePath* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = templates_get_default ();
	templates = _tmp0_;
	_tmp1_ = path;
	_tmp2_ = templates_get_personal_template_contents (templates, _tmp1_);
	_tmp3_ = _tmp2_;
	open_template_dialog_create_document (self, _tmp3_);
	_g_free0 (_tmp3_);
	_g_object_unref0 (templates);
}


static void open_template_dialog_create_document (OpenTemplateDialog* self, const gchar* contents) {
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_ = NULL;
	DocumentTab* tab;
	Document* _tmp2_;
	Document* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contents != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_create_tab (_tmp0_, TRUE);
	tab = _tmp1_;
	_tmp2_ = document_tab_get_document (tab);
	_tmp3_ = _tmp2_;
	_tmp4_ = contents;
	document_set_contents (_tmp3_, _tmp4_);
	_g_object_unref0 (tab);
}


static void open_template_dialog_close_dialog (OpenTemplateDialog* self) {
	gint width = 0;
	gint height = 0;
	GtkDialog* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GtkVPaned* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GtkDialog* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_dialog;
	gtk_window_get_size ((GtkWindow*) _tmp0_, &_tmp1_, &_tmp2_);
	width = _tmp1_;
	height = _tmp2_;
	_tmp3_ = self->priv->_settings;
	g_settings_set (_tmp3_, "new-file-dialog-size", "(ii)", width, height);
	_tmp4_ = self->priv->_settings;
	_tmp5_ = self->priv->_vpaned;
	_tmp6_ = gtk_paned_get_position ((GtkPaned*) _tmp5_);
	_tmp7_ = _tmp6_;
	g_settings_set_int (_tmp4_, "new-file-dialog-paned-position", _tmp7_);
	_tmp8_ = self->priv->_dialog;
	gtk_object_destroy ((GtkObject*) _tmp8_);
}


static void value_open_template_dialog_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_open_template_dialog_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		open_template_dialog_unref (value->data[0].v_pointer);
	}
}


static void value_open_template_dialog_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = open_template_dialog_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_open_template_dialog_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_open_template_dialog_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		OpenTemplateDialog* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = open_template_dialog_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_open_template_dialog_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	OpenTemplateDialog** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = open_template_dialog_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_open_template_dialog (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecOpenTemplateDialog* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_OPEN_TEMPLATE_DIALOG), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_open_template_dialog (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_OPEN_TEMPLATE_DIALOG), NULL);
	return value->data[0].v_pointer;
}


void value_set_open_template_dialog (GValue* value, gpointer v_object) {
	OpenTemplateDialog* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_OPEN_TEMPLATE_DIALOG));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_OPEN_TEMPLATE_DIALOG));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		open_template_dialog_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		open_template_dialog_unref (old);
	}
}


void value_take_open_template_dialog (GValue* value, gpointer v_object) {
	OpenTemplateDialog* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_OPEN_TEMPLATE_DIALOG));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_OPEN_TEMPLATE_DIALOG));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		open_template_dialog_unref (old);
	}
}


static void open_template_dialog_class_init (OpenTemplateDialogClass * klass) {
	open_template_dialog_parent_class = g_type_class_peek_parent (klass);
	OPEN_TEMPLATE_DIALOG_CLASS (klass)->finalize = open_template_dialog_finalize;
	g_type_class_add_private (klass, sizeof (OpenTemplateDialogPrivate));
}


static void open_template_dialog_instance_init (OpenTemplateDialog * self) {
	self->priv = OPEN_TEMPLATE_DIALOG_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void open_template_dialog_finalize (OpenTemplateDialog* obj) {
	OpenTemplateDialog * self;
	self = OPEN_TEMPLATE_DIALOG (obj);
	_g_object_unref0 (self->priv->_dialog);
	_g_object_unref0 (self->priv->_icon_view_default_templates);
	_g_object_unref0 (self->priv->_icon_view_personal_templates);
	_g_object_unref0 (self->priv->_vpaned);
	_g_object_unref0 (self->priv->_settings);
}


GType open_template_dialog_get_type (void) {
	static volatile gsize open_template_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&open_template_dialog_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_open_template_dialog_init, value_open_template_dialog_free_value, value_open_template_dialog_copy_value, value_open_template_dialog_peek_pointer, "p", value_open_template_dialog_collect_value, "p", value_open_template_dialog_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (OpenTemplateDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) open_template_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (OpenTemplateDialog), 0, (GInstanceInitFunc) open_template_dialog_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType open_template_dialog_type_id;
		open_template_dialog_type_id = g_type_register_fundamental (g_type_fundamental_next (), "OpenTemplateDialog", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&open_template_dialog_type_id__volatile, open_template_dialog_type_id);
	}
	return open_template_dialog_type_id__volatile;
}


gpointer open_template_dialog_ref (gpointer instance) {
	OpenTemplateDialog* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void open_template_dialog_unref (gpointer instance) {
	OpenTemplateDialog* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		OPEN_TEMPLATE_DIALOG_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


CreateTemplateDialog* create_template_dialog_construct (GType object_type, MainWindow* parent) {
	CreateTemplateDialog * self = NULL;
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	const gchar* _tmp3_ = NULL;
	MainWindow* _tmp4_;
	GtkWidget* _tmp5_ = NULL;
	GtkBox* _tmp6_;
	GtkBox* content_area;
	GtkEntry* _tmp7_;
	GtkEntry* _tmp8_;
	GtkEntry* entry;
	const gchar* _tmp9_ = NULL;
	GtkWidget* _tmp10_ = NULL;
	GtkWidget* component;
	GtkWidget* _tmp11_;
	Templates* _tmp12_ = NULL;
	Templates* templates;
	GtkIconView* _tmp13_ = NULL;
	GtkIconView* icon_view;
	GtkWidget* _tmp14_ = NULL;
	GtkWidget* scrollbar;
	const gchar* _tmp15_ = NULL;
	GtkWidget* _tmp16_ = NULL;
	GtkWidget* _tmp17_;
	MainWindow* _tmp18_;
	g_return_val_if_fail (parent != NULL, NULL);
	self = (CreateTemplateDialog*) g_object_new (object_type, NULL);
	_tmp0_ = parent;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = _ ("New Template...");
	gtk_window_set_title ((GtkWindow*) self, _tmp3_);
	_tmp4_ = parent;
	gtk_window_set_transient_for ((GtkWindow*) self, (GtkWindow*) _tmp4_);
	gtk_dialog_add_button ((GtkDialog*) self, GTK_STOCK_OK, (gint) GTK_RESPONSE_ACCEPT);
	gtk_dialog_add_button ((GtkDialog*) self, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_REJECT);
	gtk_window_set_default_size ((GtkWindow*) self, 420, 370);
	_tmp5_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp6_ = _g_object_ref0 (GTK_IS_BOX (_tmp5_) ? ((GtkBox*) _tmp5_) : NULL);
	content_area = _tmp6_;
	gtk_box_set_homogeneous (content_area, FALSE);
	_tmp7_ = (GtkEntry*) gtk_entry_new ();
	_tmp8_ = g_object_ref_sink (_tmp7_);
	entry = _tmp8_;
	_tmp9_ = _ ("Name of the new template");
	_tmp10_ = utils_get_dialog_component (_tmp9_, (GtkWidget*) entry);
	component = _tmp10_;
	_tmp11_ = component;
	gtk_box_pack_start (content_area, _tmp11_, FALSE, TRUE, (guint) 0);
	_tmp12_ = templates_get_default ();
	templates = _tmp12_;
	_tmp13_ = templates_create_icon_view_default_templates (templates);
	icon_view = _tmp13_;
	_tmp14_ = utils_add_scrollbar ((GtkWidget*) icon_view);
	scrollbar = _tmp14_;
	_tmp15_ = _ ("Choose an icon");
	_tmp16_ = utils_get_dialog_component (_tmp15_, scrollbar);
	_g_object_unref0 (component);
	component = _tmp16_;
	_tmp17_ = component;
	gtk_box_pack_start (content_area, _tmp17_, TRUE, TRUE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) content_area);
	_tmp18_ = parent;
	create_template_dialog_run_me (self, _tmp18_, entry, icon_view);
	_g_object_unref0 (scrollbar);
	_g_object_unref0 (icon_view);
	_g_object_unref0 (templates);
	_g_object_unref0 (component);
	_g_object_unref0 (entry);
	_g_object_unref0 (content_area);
	return self;
}


CreateTemplateDialog* create_template_dialog_new (MainWindow* parent) {
	return create_template_dialog_construct (TYPE_CREATE_TEMPLATE_DIALOG, parent);
}


static void create_template_dialog_run_me (CreateTemplateDialog* self, MainWindow* parent, GtkEntry* entry, GtkIconView* icon_view) {
	Templates* _tmp0_ = NULL;
	Templates* templates;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	g_return_if_fail (entry != NULL);
	g_return_if_fail (icon_view != NULL);
	_tmp0_ = templates_get_default ();
	templates = _tmp0_;
	while (TRUE) {
		gint _tmp1_ = 0;
		GtkEntry* _tmp2_;
		guint _tmp3_;
		guint _tmp4_;
		GtkIconView* _tmp5_;
		GList* _tmp6_ = NULL;
		GList* selected_items;
		GList* _tmp7_;
		guint _tmp8_ = 0U;
		GtkTextIter start = {0};
		GtkTextIter end = {0};
		MainWindow* _tmp9_;
		Document* _tmp10_;
		Document* _tmp11_;
		GtkTextIter _tmp12_ = {0};
		GtkTextIter _tmp13_ = {0};
		MainWindow* _tmp14_;
		Document* _tmp15_;
		Document* _tmp16_;
		GtkTextIter _tmp17_;
		GtkTextIter _tmp18_;
		gchar* _tmp19_ = NULL;
		gchar* contents;
		GList* _tmp20_;
		gconstpointer _tmp21_ = NULL;
		GtkTreePath* _tmp22_;
		GtkTreePath* path;
		Templates* _tmp23_;
		GtkTreePath* _tmp24_;
		gchar* _tmp25_ = NULL;
		gchar* icon_id;
		Templates* _tmp26_;
		GtkEntry* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		_tmp1_ = gtk_dialog_run ((GtkDialog*) self);
		if (!(_tmp1_ == ((gint) GTK_RESPONSE_ACCEPT))) {
			break;
		}
		_tmp2_ = entry;
		_tmp3_ = gtk_entry_get_text_length (_tmp2_);
		_tmp4_ = _tmp3_;
		if (_tmp4_ == ((guint) 0)) {
			continue;
		}
		_tmp5_ = icon_view;
		_tmp6_ = gtk_icon_view_get_selected_items (_tmp5_);
		selected_items = _tmp6_;
		_tmp7_ = selected_items;
		_tmp8_ = g_list_length (_tmp7_);
		if (_tmp8_ == ((guint) 0)) {
			__g_list_free__gtk_tree_path_free0_0 (selected_items);
			continue;
		}
		_tmp9_ = parent;
		_tmp10_ = main_window_get_active_document (_tmp9_);
		_tmp11_ = _tmp10_;
		gtk_text_buffer_get_bounds ((GtkTextBuffer*) _tmp11_, &_tmp12_, &_tmp13_);
		start = _tmp12_;
		end = _tmp13_;
		_tmp14_ = parent;
		_tmp15_ = main_window_get_active_document (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = start;
		_tmp18_ = end;
		_tmp19_ = gtk_text_buffer_get_text ((GtkTextBuffer*) _tmp16_, &_tmp17_, &_tmp18_, FALSE);
		contents = _tmp19_;
		_tmp20_ = selected_items;
		_tmp21_ = g_list_nth_data (_tmp20_, (guint) 0);
		_tmp22_ = _gtk_tree_path_copy0 ((GtkTreePath*) _tmp21_);
		path = _tmp22_;
		_tmp23_ = templates;
		_tmp24_ = path;
		_tmp25_ = templates_get_icon_id (_tmp23_, _tmp24_);
		icon_id = _tmp25_;
		_tmp26_ = templates;
		_tmp27_ = entry;
		_tmp28_ = gtk_entry_get_text (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = icon_id;
		_tmp31_ = contents;
		templates_create_personal_template (_tmp26_, _tmp29_, _tmp30_, _tmp31_);
		_g_free0 (icon_id);
		_gtk_tree_path_free0 (path);
		_g_free0 (contents);
		__g_list_free__gtk_tree_path_free0_0 (selected_items);
		break;
	}
	_g_object_unref0 (templates);
}


static void create_template_dialog_class_init (CreateTemplateDialogClass * klass) {
	create_template_dialog_parent_class = g_type_class_peek_parent (klass);
}


static void create_template_dialog_instance_init (CreateTemplateDialog * self) {
}


GType create_template_dialog_get_type (void) {
	static volatile gsize create_template_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&create_template_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CreateTemplateDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) create_template_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CreateTemplateDialog), 0, (GInstanceInitFunc) create_template_dialog_instance_init, NULL };
		GType create_template_dialog_type_id;
		create_template_dialog_type_id = g_type_register_static (GTK_TYPE_DIALOG, "CreateTemplateDialog", &g_define_type_info, 0);
		g_once_init_leave (&create_template_dialog_type_id__volatile, create_template_dialog_type_id);
	}
	return create_template_dialog_type_id__volatile;
}


DeleteTemplateDialog* delete_template_dialog_construct (GType object_type, MainWindow* parent) {
	DeleteTemplateDialog * self = NULL;
	const gchar* _tmp0_ = NULL;
	MainWindow* _tmp1_;
	Templates* _tmp2_ = NULL;
	Templates* templates;
	GtkIconView* _tmp3_ = NULL;
	GtkIconView* icon_view;
	GtkWidget* _tmp4_ = NULL;
	GtkWidget* scrollbar;
	const gchar* _tmp5_ = NULL;
	GtkWidget* _tmp6_ = NULL;
	GtkWidget* component;
	GtkWidget* _tmp7_ = NULL;
	GtkBox* _tmp8_;
	GtkBox* content_area;
	g_return_val_if_fail (parent != NULL, NULL);
	self = (DeleteTemplateDialog*) g_object_new (object_type, NULL);
	_tmp0_ = _ ("Delete Template(s)...");
	gtk_window_set_title ((GtkWindow*) self, _tmp0_);
	gtk_dialog_add_button ((GtkDialog*) self, GTK_STOCK_DELETE, (gint) GTK_RESPONSE_ACCEPT);
	gtk_dialog_add_button ((GtkDialog*) self, GTK_STOCK_CLOSE, (gint) GTK_RESPONSE_REJECT);
	gtk_dialog_set_has_separator ((GtkDialog*) self, FALSE);
	_tmp1_ = parent;
	gtk_window_set_transient_for ((GtkWindow*) self, (GtkWindow*) _tmp1_);
	gtk_window_set_default_size ((GtkWindow*) self, 400, 200);
	_tmp2_ = templates_get_default ();
	templates = _tmp2_;
	_tmp3_ = templates_create_icon_view_personal_templates (templates);
	icon_view = _tmp3_;
	gtk_icon_view_set_selection_mode (icon_view, GTK_SELECTION_MULTIPLE);
	_tmp4_ = utils_add_scrollbar ((GtkWidget*) icon_view);
	scrollbar = _tmp4_;
	_tmp5_ = _ ("Personal templates");
	_tmp6_ = utils_get_dialog_component (_tmp5_, scrollbar);
	component = _tmp6_;
	_tmp7_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp8_ = _g_object_ref0 (GTK_IS_BOX (_tmp7_) ? ((GtkBox*) _tmp7_) : NULL);
	content_area = _tmp8_;
	gtk_box_pack_start (content_area, component, TRUE, TRUE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) content_area);
	delete_template_dialog_run_me (self, icon_view);
	_g_object_unref0 (content_area);
	_g_object_unref0 (component);
	_g_object_unref0 (scrollbar);
	_g_object_unref0 (icon_view);
	_g_object_unref0 (templates);
	return self;
}


DeleteTemplateDialog* delete_template_dialog_new (MainWindow* parent) {
	return delete_template_dialog_construct (TYPE_DELETE_TEMPLATE_DIALOG, parent);
}


static void delete_template_dialog_run_me (DeleteTemplateDialog* self, GtkIconView* icon_view) {
	Templates* _tmp0_ = NULL;
	Templates* templates;
	gboolean template_deleted;
	gboolean _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_view != NULL);
	_tmp0_ = templates_get_default ();
	templates = _tmp0_;
	template_deleted = FALSE;
	while (TRUE) {
		gint _tmp1_ = 0;
		GtkIconView* _tmp2_;
		GList* _tmp3_ = NULL;
		GList* selected_items;
		GList* _tmp4_;
		guint _tmp5_ = 0U;
		guint nb_selected_items;
		_tmp1_ = gtk_dialog_run ((GtkDialog*) self);
		if (!(_tmp1_ == ((gint) GTK_RESPONSE_ACCEPT))) {
			break;
		}
		_tmp2_ = icon_view;
		_tmp3_ = gtk_icon_view_get_selected_items (_tmp2_);
		selected_items = _tmp3_;
		_tmp4_ = selected_items;
		_tmp5_ = g_list_length (_tmp4_);
		nb_selected_items = _tmp5_;
		{
			gint item_num;
			item_num = 0;
			{
				gboolean _tmp6_;
				_tmp6_ = TRUE;
				while (TRUE) {
					gboolean _tmp7_;
					gint _tmp9_;
					guint _tmp10_;
					GList* _tmp11_;
					gint _tmp12_;
					gconstpointer _tmp13_ = NULL;
					GtkTreePath* _tmp14_;
					GtkTreePath* path;
					Templates* _tmp15_;
					GtkTreePath* _tmp16_;
					_tmp7_ = _tmp6_;
					if (!_tmp7_) {
						gint _tmp8_;
						_tmp8_ = item_num;
						item_num = _tmp8_ + 1;
					}
					_tmp6_ = FALSE;
					_tmp9_ = item_num;
					_tmp10_ = nb_selected_items;
					if (!(((guint) _tmp9_) < _tmp10_)) {
						break;
					}
					_tmp11_ = selected_items;
					_tmp12_ = item_num;
					_tmp13_ = g_list_nth_data (_tmp11_, (guint) _tmp12_);
					_tmp14_ = _gtk_tree_path_copy0 ((GtkTreePath*) _tmp13_);
					path = _tmp14_;
					_tmp15_ = templates;
					_tmp16_ = path;
					templates_delete_personal_template (_tmp15_, _tmp16_);
					template_deleted = TRUE;
					_gtk_tree_path_free0 (path);
				}
			}
		}
		__g_list_free__gtk_tree_path_free0_0 (selected_items);
	}
	_tmp17_ = template_deleted;
	if (_tmp17_) {
		Templates* _tmp18_;
		_tmp18_ = templates;
		templates_save_rc_file (_tmp18_);
	}
	_g_object_unref0 (templates);
}


static void delete_template_dialog_class_init (DeleteTemplateDialogClass * klass) {
	delete_template_dialog_parent_class = g_type_class_peek_parent (klass);
}


static void delete_template_dialog_instance_init (DeleteTemplateDialog * self) {
}


GType delete_template_dialog_get_type (void) {
	static volatile gsize delete_template_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&delete_template_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DeleteTemplateDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) delete_template_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DeleteTemplateDialog), 0, (GInstanceInitFunc) delete_template_dialog_instance_init, NULL };
		GType delete_template_dialog_type_id;
		delete_template_dialog_type_id = g_type_register_static (GTK_TYPE_DIALOG, "DeleteTemplateDialog", &g_define_type_info, 0);
		g_once_init_leave (&delete_template_dialog_type_id__volatile, delete_template_dialog_type_id);
	}
	return delete_template_dialog_type_id__volatile;
}



