/* build_tool_dialog.c generated by valac 0.16.0, the Vala compiler
 * generated from build_tool_dialog.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2012 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>


#define TYPE_BUILD_TOOL_DIALOG (build_tool_dialog_get_type ())
#define BUILD_TOOL_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOL_DIALOG, BuildToolDialog))
#define BUILD_TOOL_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOL_DIALOG, BuildToolDialogClass))
#define IS_BUILD_TOOL_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOL_DIALOG))
#define IS_BUILD_TOOL_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOL_DIALOG))
#define BUILD_TOOL_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOL_DIALOG, BuildToolDialogClass))

typedef struct _BuildToolDialog BuildToolDialog;
typedef struct _BuildToolDialogClass BuildToolDialogClass;
typedef struct _BuildToolDialogPrivate BuildToolDialogPrivate;

#define TYPE_ERROR_ENTRY (error_entry_get_type ())
#define ERROR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ERROR_ENTRY, ErrorEntry))
#define ERROR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ERROR_ENTRY, ErrorEntryClass))
#define IS_ERROR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ERROR_ENTRY))
#define IS_ERROR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ERROR_ENTRY))
#define ERROR_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ERROR_ENTRY, ErrorEntryClass))

typedef struct _ErrorEntry ErrorEntry;
typedef struct _ErrorEntryClass ErrorEntryClass;

#define BUILD_TOOL_DIALOG_TYPE_JOB_COLUMN (build_tool_dialog_job_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BUILD_TOOL_DIALOG_TYPE_ICON_COLUMN (build_tool_dialog_icon_column_get_type ())
typedef struct _BuildToolDialogIconColumn BuildToolDialogIconColumn;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_POST_PROCESSOR_TYPE (post_processor_type_get_type ())

#define TYPE_BUILD_TOOL (build_tool_get_type ())

#define TYPE_BUILD_JOB (build_job_get_type ())
typedef struct _BuildJob BuildJob;
typedef struct _BuildTool BuildTool;

#define TYPE_BUILD_TOOLS (build_tools_get_type ())
#define BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOLS, BuildTools))
#define BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOLS, BuildToolsClass))
#define IS_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOLS))
#define IS_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOLS))
#define BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOLS, BuildToolsClass))

typedef struct _BuildTools BuildTools;
typedef struct _BuildToolsClass BuildToolsClass;
#define _build_tool_free0(var) ((var == NULL) ? NULL : (var = (build_tool_free (var), NULL)))
#define _build_tools_unref0(var) ((var == NULL) ? NULL : (var = (build_tools_unref (var), NULL)))
#define _build_job_free0(var) ((var == NULL) ? NULL : (var = (build_job_free (var), NULL)))

struct _BuildToolDialog {
	GtkDialog parent_instance;
	BuildToolDialogPrivate * priv;
};

struct _BuildToolDialogClass {
	GtkDialogClass parent_class;
};

struct _BuildToolDialogPrivate {
	ErrorEntry* _entry_label;
	GtkEntry* _entry_desc;
	GtkEntry* _entry_extensions;
	GtkComboBox* _combobox_icon;
	ErrorEntry* _entry_command;
	GtkButton* _button_add;
	GtkTreeView* _treeview_jobs;
	GtkButton* _button_delete;
	GtkButton* _button_up;
	GtkButton* _button_down;
	GtkListStore* _jobs_store;
};

typedef enum  {
	BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND,
	BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED,
	BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR,
	BUILD_TOOL_DIALOG_JOB_COLUMN_N_COLUMNS
} BuildToolDialogJobColumn;

struct _BuildToolDialogIconColumn {
	gchar* stock_id;
	gchar* label;
};

typedef enum  {
	POST_PROCESSOR_TYPE_ALL_OUTPUT = 0,
	POST_PROCESSOR_TYPE_LATEX,
	POST_PROCESSOR_TYPE_LATEXMK,
	POST_PROCESSOR_TYPE_NO_OUTPUT,
	POST_PROCESSOR_TYPE_RUBBER,
	POST_PROCESSOR_TYPE_N_POST_PROCESSORS
} PostProcessorType;

struct _BuildJob {
	gboolean must_succeed;
	PostProcessorType post_processor;
	gchar* command;
};

struct _BuildTool {
	gchar* description;
	gchar* extensions;
	gchar* label;
	gchar* icon;
	gboolean show;
	gboolean compilation;
	GeeArrayList* jobs;
};


static gpointer build_tool_dialog_parent_class = NULL;
static BuildToolDialog* build_tool_dialog__instance;
static BuildToolDialog* build_tool_dialog__instance = NULL;

GType build_tool_dialog_get_type (void) G_GNUC_CONST;
GType error_entry_get_type (void) G_GNUC_CONST;
#define BUILD_TOOL_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BUILD_TOOL_DIALOG, BuildToolDialogPrivate))
enum  {
	BUILD_TOOL_DIALOG_DUMMY_PROPERTY
};
static GType build_tool_dialog_job_column_get_type (void) G_GNUC_UNUSED;
static GType build_tool_dialog_icon_column_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static BuildToolDialogIconColumn* build_tool_dialog_icon_column_dup (const BuildToolDialogIconColumn* self);
static void build_tool_dialog_icon_column_free (BuildToolDialogIconColumn* self);
static void build_tool_dialog_icon_column_copy (const BuildToolDialogIconColumn* self, BuildToolDialogIconColumn* dest);
static void build_tool_dialog_icon_column_destroy (BuildToolDialogIconColumn* self);
static BuildToolDialog* build_tool_dialog_new (void);
static BuildToolDialog* build_tool_dialog_construct (GType object_type);
static GtkGrid* build_tool_dialog_get_label_grid (BuildToolDialog* self);
static GtkGrid* build_tool_dialog_get_desc_grid (BuildToolDialog* self);
static GtkGrid* build_tool_dialog_get_extensions_grid (BuildToolDialog* self);
static GtkGrid* build_tool_dialog_get_icon_grid (BuildToolDialog* self);
static GtkGrid* build_tool_dialog_get_jobs_grid (BuildToolDialog* self);
static void build_tool_dialog_init_icon_treeview (BuildToolDialog* self);
static void build_tool_dialog_init_jobs_treeview (BuildToolDialog* self);
static void build_tool_dialog_init_actions (BuildToolDialog* self);
gboolean build_tool_dialog_show_me (GtkWindow* parent, gint build_tool_num);
static void ___lambda95_ (void);
static void ____lambda95__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static void build_tool_dialog_init (BuildToolDialog* self, gint build_tool_num);
static gboolean build_tool_dialog_run_me (BuildToolDialog* self, gint build_tool_num);
ErrorEntry* error_entry_new (void);
ErrorEntry* error_entry_construct (GType object_type);
GtkGrid* utils_get_dialog_component (const gchar* title, GtkWidget* widget);
GtkWidget* utils_add_scrollbar (GtkWidget* child);
GType post_processor_type_get_type (void) G_GNUC_CONST;
gchar* build_tools_get_post_processor_name_from_type (PostProcessorType type);
static void __lambda89_ (BuildToolDialog* self, const gchar* path_string, const gchar* new_text);
static void ___lambda89__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender, const gchar* path, const gchar* new_text, gpointer self);
static void __lambda90_ (BuildToolDialog* self, const gchar* path_string);
static void ___lambda90__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const gchar* path, gpointer self);
static void __lambda91_ (BuildToolDialog* self, const gchar* path_string, const gchar* new_text);
static void ___lambda91__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender, const gchar* path, const gchar* new_text, gpointer self);
static void build_tool_dialog_on_command_add (BuildToolDialog* self);
static void _build_tool_dialog_on_command_add_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _build_tool_dialog_on_command_add_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void __lambda92_ (BuildToolDialog* self);
gint utils_get_selected_row (GtkTreeView* view, GtkTreeIter* iter);
static void ___lambda92__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda93_ (BuildToolDialog* self);
gboolean utils_tree_model_iter_prev (GtkTreeModel* model, GtkTreeIter* iter);
static void ___lambda93__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda94_ (BuildToolDialog* self);
static void ___lambda94__gtk_button_clicked (GtkButton* _sender, gpointer self);
void error_entry_set_error (ErrorEntry* self, gboolean value);
static void build_tool_dialog_init_new_build_tool (BuildToolDialog* self);
GType build_tool_get_type (void) G_GNUC_CONST;
GType build_job_get_type (void) G_GNUC_CONST;
BuildJob* build_job_dup (const BuildJob* self);
void build_job_free (BuildJob* self);
void build_job_copy (const BuildJob* self, BuildJob* dest);
void build_job_destroy (BuildJob* self);
BuildTool* build_tool_dup (const BuildTool* self);
void build_tool_free (BuildTool* self);
void build_tool_copy (const BuildTool* self, BuildTool* dest);
void build_tool_destroy (BuildTool* self);
static void build_tool_dialog_init_with_build_tool (BuildToolDialog* self, BuildTool* tool);
gpointer build_tools_ref (gpointer instance);
void build_tools_unref (gpointer instance);
GParamSpec* param_spec_build_tools (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_build_tools (GValue* value, gpointer v_object);
void value_take_build_tools (GValue* value, gpointer v_object);
gpointer value_get_build_tools (const GValue* value);
GType build_tools_get_type (void) G_GNUC_CONST;
BuildTools* build_tools_get_default (void);
BuildTool* build_tools_get (BuildTools* self, gint id);
gboolean error_entry_get_error (ErrorEntry* self);
PostProcessorType* build_tools_get_post_processor_type_from_name (const gchar* name);
void build_tools_add (BuildTools* self, BuildTool* tool);
void build_tools_update (BuildTools* self, gint num, BuildTool* tool, gboolean keep_show);
static void build_tool_dialog_finalize (GObject* obj);

static const BuildToolDialogIconColumn BUILD_TOOL_DIALOG__icons[9] = {{GTK_STOCK_EXECUTE, "Execute"}, {"compile_dvi", "LaTeX → DVI"}, {"compile_pdf", "LaTeX → PDF"}, {"compile_ps", "LaTeX → PS"}, {GTK_STOCK_CONVERT, "Convert"}, {GTK_STOCK_FILE, "View File"}, {"view_dvi", "View DVI"}, {"view_pdf", "View PDF"}, {"view_ps", "View PS"}};

static GType build_tool_dialog_job_column_get_type (void) {
	static volatile gsize build_tool_dialog_job_column_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_dialog_job_column_type_id__volatile)) {
		static const GEnumValue values[] = {{BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, "BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND", "command"}, {BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED, "BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED", "must-succeed"}, {BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, "BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR", "post-processor"}, {BUILD_TOOL_DIALOG_JOB_COLUMN_N_COLUMNS, "BUILD_TOOL_DIALOG_JOB_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType build_tool_dialog_job_column_type_id;
		build_tool_dialog_job_column_type_id = g_enum_register_static ("BuildToolDialogJobColumn", values);
		g_once_init_leave (&build_tool_dialog_job_column_type_id__volatile, build_tool_dialog_job_column_type_id);
	}
	return build_tool_dialog_job_column_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static BuildToolDialog* build_tool_dialog_construct (GType object_type) {
	BuildToolDialog * self = NULL;
	const gchar* _tmp0_ = NULL;
	GtkGrid* _tmp1_ = NULL;
	GtkGrid* label_grid;
	GtkGrid* _tmp2_ = NULL;
	GtkGrid* desc_grid;
	GtkGrid* _tmp3_ = NULL;
	GtkGrid* extensions_grid;
	GtkGrid* _tmp4_ = NULL;
	GtkGrid* icon_grid;
	GtkGrid* _tmp5_ = NULL;
	GtkGrid* jobs_grid;
	GtkGrid* _tmp6_;
	GtkGrid* _tmp7_;
	GtkGrid* main_grid;
	GtkBox* _tmp8_ = NULL;
	GtkBox* _tmp9_;
	GtkBox* content_area;
	self = (BuildToolDialog*) g_object_new (object_type, NULL);
	gtk_dialog_add_button ((GtkDialog*) self, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
	gtk_dialog_add_button ((GtkDialog*) self, GTK_STOCK_OK, (gint) GTK_RESPONSE_OK);
	_tmp0_ = _ ("Build Tool");
	gtk_window_set_title ((GtkWindow*) self, _tmp0_);
	gtk_window_set_destroy_with_parent ((GtkWindow*) self, TRUE);
	_tmp1_ = build_tool_dialog_get_label_grid (self);
	label_grid = _tmp1_;
	_tmp2_ = build_tool_dialog_get_desc_grid (self);
	desc_grid = _tmp2_;
	_tmp3_ = build_tool_dialog_get_extensions_grid (self);
	extensions_grid = _tmp3_;
	_tmp4_ = build_tool_dialog_get_icon_grid (self);
	icon_grid = _tmp4_;
	_tmp5_ = build_tool_dialog_get_jobs_grid (self);
	jobs_grid = _tmp5_;
	_tmp6_ = (GtkGrid*) gtk_grid_new ();
	_tmp7_ = g_object_ref_sink (_tmp6_);
	main_grid = _tmp7_;
	gtk_grid_set_row_spacing (main_grid, (guint) 5);
	gtk_grid_set_column_spacing (main_grid, (guint) 5);
	gtk_grid_attach (main_grid, (GtkWidget*) label_grid, 0, 0, 1, 1);
	gtk_grid_attach (main_grid, (GtkWidget*) desc_grid, 1, 0, 1, 1);
	gtk_grid_attach (main_grid, (GtkWidget*) extensions_grid, 0, 1, 1, 1);
	gtk_grid_attach (main_grid, (GtkWidget*) icon_grid, 1, 1, 1, 1);
	gtk_grid_attach (main_grid, (GtkWidget*) jobs_grid, 0, 2, 2, 1);
	_tmp8_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp9_ = _g_object_ref0 (GTK_IS_BOX (_tmp8_) ? ((GtkBox*) _tmp8_) : NULL);
	content_area = _tmp9_;
	gtk_box_pack_start (content_area, (GtkWidget*) main_grid, TRUE, TRUE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) content_area);
	build_tool_dialog_init_icon_treeview (self);
	build_tool_dialog_init_jobs_treeview (self);
	build_tool_dialog_init_actions (self);
	_g_object_unref0 (content_area);
	_g_object_unref0 (main_grid);
	_g_object_unref0 (jobs_grid);
	_g_object_unref0 (icon_grid);
	_g_object_unref0 (extensions_grid);
	_g_object_unref0 (desc_grid);
	_g_object_unref0 (label_grid);
	return self;
}


static BuildToolDialog* build_tool_dialog_new (void) {
	return build_tool_dialog_construct (TYPE_BUILD_TOOL_DIALOG);
}


static void ___lambda95_ (void) {
	BuildToolDialog* _tmp0_;
	_tmp0_ = build_tool_dialog__instance;
	if (_tmp0_ != NULL) {
		_g_object_unref0 (build_tool_dialog__instance);
		build_tool_dialog__instance = NULL;
	}
}


static void ____lambda95__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	___lambda95_ ();
}


gboolean build_tool_dialog_show_me (GtkWindow* parent, gint build_tool_num) {
	gboolean result = FALSE;
	BuildToolDialog* _tmp0_;
	GtkWindow* _tmp4_;
	BuildToolDialog* _tmp5_;
	GtkWindow* _tmp6_ = NULL;
	BuildToolDialog* _tmp9_;
	BuildToolDialog* _tmp10_;
	gint _tmp11_;
	BuildToolDialog* _tmp12_;
	gint _tmp13_;
	gboolean _tmp14_ = FALSE;
	g_return_val_if_fail (parent != NULL, FALSE);
	_tmp0_ = build_tool_dialog__instance;
	if (_tmp0_ == NULL) {
		BuildToolDialog* _tmp1_;
		BuildToolDialog* _tmp2_;
		BuildToolDialog* _tmp3_;
		_tmp1_ = build_tool_dialog_new ();
		_tmp2_ = g_object_ref_sink (_tmp1_);
		_g_object_unref0 (build_tool_dialog__instance);
		build_tool_dialog__instance = _tmp2_;
		_tmp3_ = build_tool_dialog__instance;
		g_signal_connect ((GtkWidget*) _tmp3_, "destroy", (GCallback) ____lambda95__gtk_widget_destroy, NULL);
	}
	_tmp4_ = parent;
	_tmp5_ = build_tool_dialog__instance;
	_tmp6_ = gtk_window_get_transient_for ((GtkWindow*) _tmp5_);
	if (_tmp4_ != _tmp6_) {
		BuildToolDialog* _tmp7_;
		GtkWindow* _tmp8_;
		_tmp7_ = build_tool_dialog__instance;
		_tmp8_ = parent;
		gtk_window_set_transient_for ((GtkWindow*) _tmp7_, _tmp8_);
	}
	_tmp9_ = build_tool_dialog__instance;
	gtk_window_present ((GtkWindow*) _tmp9_);
	_tmp10_ = build_tool_dialog__instance;
	_tmp11_ = build_tool_num;
	build_tool_dialog_init (_tmp10_, _tmp11_);
	_tmp12_ = build_tool_dialog__instance;
	_tmp13_ = build_tool_num;
	_tmp14_ = build_tool_dialog_run_me (_tmp12_, _tmp13_);
	result = _tmp14_;
	return result;
}


static GtkGrid* build_tool_dialog_get_label_grid (BuildToolDialog* self) {
	GtkGrid* result = NULL;
	GtkGrid* _tmp0_;
	GtkGrid* _tmp1_;
	GtkGrid* grid;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* title;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* arrow;
	const gchar* _tmp11_ = NULL;
	ErrorEntry* _tmp12_;
	ErrorEntry* _tmp13_;
	ErrorEntry* _tmp14_;
	ErrorEntry* _tmp15_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	_tmp1_ = g_object_ref_sink (_tmp0_);
	grid = _tmp1_;
	gtk_grid_set_row_spacing (grid, (guint) 6);
	gtk_container_set_border_width ((GtkContainer*) grid, (guint) 6);
	_tmp2_ = (GtkLabel*) gtk_label_new (NULL);
	_tmp3_ = g_object_ref_sink (_tmp2_);
	title = _tmp3_;
	_tmp4_ = _ ("Label");
	_tmp5_ = g_strconcat ("<b>", _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat (_tmp6_, "</b>", NULL);
	_tmp8_ = _tmp7_;
	gtk_label_set_markup (title, _tmp8_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	gtk_widget_set_halign ((GtkWidget*) title, GTK_ALIGN_START);
	gtk_grid_attach (grid, (GtkWidget*) title, 0, 0, 1, 1);
	_tmp9_ = (GtkLabel*) gtk_label_new ("→");
	_tmp10_ = g_object_ref_sink (_tmp9_);
	arrow = _tmp10_;
	_tmp11_ = _ ("You can select this arrow and copy/paste it!");
	gtk_widget_set_tooltip_text ((GtkWidget*) arrow, _tmp11_);
	gtk_widget_set_halign ((GtkWidget*) arrow, GTK_ALIGN_CENTER);
	gtk_widget_set_hexpand ((GtkWidget*) arrow, TRUE);
	gtk_label_set_selectable (arrow, TRUE);
	gtk_grid_attach (grid, (GtkWidget*) arrow, 1, 0, 1, 1);
	gtk_widget_set_hexpand ((GtkWidget*) grid, FALSE);
	_tmp12_ = error_entry_new ();
	_tmp13_ = g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->_entry_label);
	self->priv->_entry_label = _tmp13_;
	_tmp14_ = self->priv->_entry_label;
	gtk_widget_set_margin_left ((GtkWidget*) _tmp14_, 12);
	_tmp15_ = self->priv->_entry_label;
	gtk_grid_attach (grid, (GtkWidget*) _tmp15_, 0, 1, 2, 1);
	result = grid;
	_g_object_unref0 (arrow);
	_g_object_unref0 (title);
	return result;
}


static GtkGrid* build_tool_dialog_get_desc_grid (BuildToolDialog* self) {
	GtkGrid* result = NULL;
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* _tmp2_;
	const gchar* _tmp3_ = NULL;
	GtkEntry* _tmp4_;
	GtkGrid* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkEntry*) gtk_entry_new ();
	_tmp1_ = g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->_entry_desc);
	self->priv->_entry_desc = _tmp1_;
	_tmp2_ = self->priv->_entry_desc;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp2_, TRUE);
	_tmp3_ = _ ("Description");
	_tmp4_ = self->priv->_entry_desc;
	_tmp5_ = utils_get_dialog_component (_tmp3_, (GtkWidget*) _tmp4_);
	result = _tmp5_;
	return result;
}


static GtkGrid* build_tool_dialog_get_extensions_grid (BuildToolDialog* self) {
	GtkGrid* result = NULL;
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* _tmp2_;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GtkEntry* _tmp5_;
	GtkGrid* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkEntry*) gtk_entry_new ();
	_tmp1_ = g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->_entry_extensions);
	self->priv->_entry_extensions = _tmp1_;
	_tmp2_ = self->priv->_entry_extensions;
	_tmp3_ = _ ("File extensions for which the build tool can be executed.\n" \
"The extensions are separated by spaces.");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp2_, _tmp3_);
	_tmp4_ = _ ("Extensions");
	_tmp5_ = self->priv->_entry_extensions;
	_tmp6_ = utils_get_dialog_component (_tmp4_, (GtkWidget*) _tmp5_);
	result = _tmp6_;
	return result;
}


static GtkGrid* build_tool_dialog_get_icon_grid (BuildToolDialog* self) {
	GtkGrid* result = NULL;
	GtkComboBox* _tmp0_;
	GtkComboBox* _tmp1_;
	const gchar* _tmp2_ = NULL;
	GtkComboBox* _tmp3_;
	GtkGrid* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkComboBox*) gtk_combo_box_new ();
	_tmp1_ = g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->_combobox_icon);
	self->priv->_combobox_icon = _tmp1_;
	_tmp2_ = _ ("Icon");
	_tmp3_ = self->priv->_combobox_icon;
	_tmp4_ = utils_get_dialog_component (_tmp2_, (GtkWidget*) _tmp3_);
	result = _tmp4_;
	return result;
}


static GtkGrid* build_tool_dialog_get_jobs_grid (BuildToolDialog* self) {
	GtkGrid* result = NULL;
	const gchar* _tmp0_ = NULL;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* placeholders;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* placeholder_filename;
	const gchar* _tmp5_ = NULL;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* placeholder_shortname;
	const gchar* _tmp8_ = NULL;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* placeholder_view;
	const gchar* _tmp11_ = NULL;
	ErrorEntry* _tmp12_;
	ErrorEntry* _tmp13_;
	ErrorEntry* _tmp14_;
	GtkButton* _tmp15_;
	GtkButton* _tmp16_;
	GtkButton* _tmp17_;
	const gchar* _tmp18_ = NULL;
	GtkTreeView* _tmp19_;
	GtkTreeView* _tmp20_;
	GtkTreeView* _tmp21_;
	GtkTreeView* _tmp22_;
	GtkTreeView* _tmp23_;
	GtkWidget* _tmp24_ = NULL;
	GtkWidget* scrolled_treeview;
	GtkButton* _tmp25_;
	GtkButton* _tmp26_;
	GtkButton* _tmp27_;
	GtkButton* _tmp28_;
	GtkButton* _tmp29_;
	GtkButton* _tmp30_;
	GtkGrid* _tmp31_;
	GtkGrid* _tmp32_;
	GtkGrid* placeholders_grid;
	GtkGrid* _tmp33_;
	GtkGrid* _tmp34_;
	GtkGrid* cmd_grid;
	ErrorEntry* _tmp35_;
	GtkButton* _tmp36_;
	GtkGrid* _tmp37_;
	GtkGrid* _tmp38_;
	GtkGrid* buttons_grid;
	GtkButton* _tmp39_;
	GtkButton* _tmp40_;
	GtkButton* _tmp41_;
	GtkGrid* _tmp42_;
	GtkGrid* _tmp43_;
	GtkGrid* jobs_grid;
	const gchar* _tmp44_ = NULL;
	GtkGrid* _tmp45_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _ ("Placeholders:");
	_tmp1_ = (GtkLabel*) gtk_label_new (_tmp0_);
	_tmp2_ = g_object_ref_sink (_tmp1_);
	placeholders = _tmp2_;
	_tmp3_ = (GtkLabel*) gtk_label_new ("$filename");
	_tmp4_ = g_object_ref_sink (_tmp3_);
	placeholder_filename = _tmp4_;
	_tmp5_ = _ ("The active document filename");
	gtk_widget_set_tooltip_text ((GtkWidget*) placeholder_filename, _tmp5_);
	_tmp6_ = (GtkLabel*) gtk_label_new ("$shortname");
	_tmp7_ = g_object_ref_sink (_tmp6_);
	placeholder_shortname = _tmp7_;
	_tmp8_ = _ ("The active document filename without its extension");
	gtk_widget_set_tooltip_text ((GtkWidget*) placeholder_shortname, _tmp8_);
	_tmp9_ = (GtkLabel*) gtk_label_new ("$view");
	_tmp10_ = g_object_ref_sink (_tmp9_);
	placeholder_view = _tmp10_;
	_tmp11_ = _ ("The program for viewing documents.\n" \
"Its value can be changed in the preferences dialog.");
	gtk_widget_set_tooltip_text ((GtkWidget*) placeholder_view, _tmp11_);
	_tmp12_ = error_entry_new ();
	_tmp13_ = g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->_entry_command);
	self->priv->_entry_command = _tmp13_;
	_tmp14_ = self->priv->_entry_command;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp14_, TRUE);
	_tmp15_ = (GtkButton*) gtk_button_new_from_stock (GTK_STOCK_ADD);
	_tmp16_ = g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->_button_add);
	self->priv->_button_add = _tmp16_;
	_tmp17_ = self->priv->_button_add;
	_tmp18_ = _ ("New command");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp17_, _tmp18_);
	_tmp19_ = (GtkTreeView*) gtk_tree_view_new ();
	_tmp20_ = g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->_treeview_jobs);
	self->priv->_treeview_jobs = _tmp20_;
	_tmp21_ = self->priv->_treeview_jobs;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp21_, TRUE);
	_tmp22_ = self->priv->_treeview_jobs;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp22_, TRUE);
	_tmp23_ = self->priv->_treeview_jobs;
	_tmp24_ = utils_add_scrollbar ((GtkWidget*) _tmp23_);
	scrolled_treeview = _tmp24_;
	gtk_widget_set_size_request (scrolled_treeview, 600, 110);
	_tmp25_ = (GtkButton*) gtk_button_new_from_stock (GTK_STOCK_REMOVE);
	_tmp26_ = g_object_ref_sink (_tmp25_);
	_g_object_unref0 (self->priv->_button_delete);
	self->priv->_button_delete = _tmp26_;
	_tmp27_ = (GtkButton*) gtk_button_new_from_stock (GTK_STOCK_GO_UP);
	_tmp28_ = g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->priv->_button_up);
	self->priv->_button_up = _tmp28_;
	_tmp29_ = (GtkButton*) gtk_button_new_from_stock (GTK_STOCK_GO_DOWN);
	_tmp30_ = g_object_ref_sink (_tmp29_);
	_g_object_unref0 (self->priv->_button_down);
	self->priv->_button_down = _tmp30_;
	_tmp31_ = (GtkGrid*) gtk_grid_new ();
	_tmp32_ = g_object_ref_sink (_tmp31_);
	placeholders_grid = _tmp32_;
	gtk_orientable_set_orientation ((GtkOrientable*) placeholders_grid, GTK_ORIENTATION_HORIZONTAL);
	gtk_grid_set_column_spacing (placeholders_grid, (guint) 10);
	gtk_container_add ((GtkContainer*) placeholders_grid, (GtkWidget*) placeholders);
	gtk_container_add ((GtkContainer*) placeholders_grid, (GtkWidget*) placeholder_filename);
	gtk_container_add ((GtkContainer*) placeholders_grid, (GtkWidget*) placeholder_shortname);
	gtk_container_add ((GtkContainer*) placeholders_grid, (GtkWidget*) placeholder_view);
	_tmp33_ = (GtkGrid*) gtk_grid_new ();
	_tmp34_ = g_object_ref_sink (_tmp33_);
	cmd_grid = _tmp34_;
	gtk_orientable_set_orientation ((GtkOrientable*) cmd_grid, GTK_ORIENTATION_HORIZONTAL);
	gtk_grid_set_column_spacing (cmd_grid, (guint) 5);
	_tmp35_ = self->priv->_entry_command;
	gtk_container_add ((GtkContainer*) cmd_grid, (GtkWidget*) _tmp35_);
	_tmp36_ = self->priv->_button_add;
	gtk_container_add ((GtkContainer*) cmd_grid, (GtkWidget*) _tmp36_);
	_tmp37_ = (GtkGrid*) gtk_grid_new ();
	_tmp38_ = g_object_ref_sink (_tmp37_);
	buttons_grid = _tmp38_;
	gtk_orientable_set_orientation ((GtkOrientable*) buttons_grid, GTK_ORIENTATION_HORIZONTAL);
	gtk_grid_set_column_spacing (buttons_grid, (guint) 5);
	_tmp39_ = self->priv->_button_delete;
	gtk_container_add ((GtkContainer*) buttons_grid, (GtkWidget*) _tmp39_);
	_tmp40_ = self->priv->_button_up;
	gtk_container_add ((GtkContainer*) buttons_grid, (GtkWidget*) _tmp40_);
	_tmp41_ = self->priv->_button_down;
	gtk_container_add ((GtkContainer*) buttons_grid, (GtkWidget*) _tmp41_);
	_tmp42_ = (GtkGrid*) gtk_grid_new ();
	_tmp43_ = g_object_ref_sink (_tmp42_);
	jobs_grid = _tmp43_;
	gtk_orientable_set_orientation ((GtkOrientable*) jobs_grid, GTK_ORIENTATION_VERTICAL);
	gtk_grid_set_row_spacing (jobs_grid, (guint) 5);
	gtk_container_add ((GtkContainer*) jobs_grid, (GtkWidget*) placeholders_grid);
	gtk_container_add ((GtkContainer*) jobs_grid, (GtkWidget*) cmd_grid);
	gtk_container_add ((GtkContainer*) jobs_grid, scrolled_treeview);
	gtk_container_add ((GtkContainer*) jobs_grid, (GtkWidget*) buttons_grid);
	_tmp44_ = _ ("Jobs");
	_tmp45_ = utils_get_dialog_component (_tmp44_, (GtkWidget*) jobs_grid);
	result = _tmp45_;
	_g_object_unref0 (jobs_grid);
	_g_object_unref0 (buttons_grid);
	_g_object_unref0 (cmd_grid);
	_g_object_unref0 (placeholders_grid);
	_g_object_unref0 (scrolled_treeview);
	_g_object_unref0 (placeholder_view);
	_g_object_unref0 (placeholder_shortname);
	_g_object_unref0 (placeholder_filename);
	_g_object_unref0 (placeholders);
	return result;
}


static void build_tool_dialog_init_icon_treeview (BuildToolDialog* self) {
	GtkListStore* _tmp0_;
	GtkListStore* icon_store;
	GtkComboBox* _tmp11_;
	GtkListStore* _tmp12_;
	GtkCellRendererPixbuf* _tmp13_;
	GtkCellRendererPixbuf* _tmp14_;
	GtkCellRendererPixbuf* pixbuf_renderer;
	GtkComboBox* _tmp15_;
	GtkComboBox* _tmp16_;
	GtkCellRendererText* _tmp17_;
	GtkCellRendererText* _tmp18_;
	GtkCellRendererText* text_renderer;
	GtkComboBox* _tmp19_;
	GtkComboBox* _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);
	icon_store = _tmp0_;
	{
		BuildToolDialogIconColumn* icon_collection = NULL;
		gint icon_collection_length1 = 0;
		gint _icon_collection_size_ = 0;
		gint icon_it = 0;
		icon_collection = BUILD_TOOL_DIALOG__icons;
		icon_collection_length1 = G_N_ELEMENTS (BUILD_TOOL_DIALOG__icons);
		for (icon_it = 0; icon_it < G_N_ELEMENTS (BUILD_TOOL_DIALOG__icons); icon_it = icon_it + 1) {
			BuildToolDialogIconColumn _tmp1_ = {0};
			BuildToolDialogIconColumn icon = {0};
			build_tool_dialog_icon_column_copy (&icon_collection[icon_it], &_tmp1_);
			icon = _tmp1_;
			{
				GtkTreeIter iter = {0};
				GtkListStore* _tmp2_;
				GtkTreeIter _tmp3_ = {0};
				GtkListStore* _tmp4_;
				GtkTreeIter _tmp5_;
				BuildToolDialogIconColumn _tmp6_;
				const gchar* _tmp7_;
				BuildToolDialogIconColumn _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_ = NULL;
				_tmp2_ = icon_store;
				gtk_list_store_append (_tmp2_, &_tmp3_);
				iter = _tmp3_;
				_tmp4_ = icon_store;
				_tmp5_ = iter;
				_tmp6_ = icon;
				_tmp7_ = _tmp6_.stock_id;
				_tmp8_ = icon;
				_tmp9_ = _tmp8_.label;
				_tmp10_ = _ (_tmp9_);
				gtk_list_store_set (_tmp4_, &_tmp5_, 0, _tmp7_, 1, _tmp10_, -1, -1);
				build_tool_dialog_icon_column_destroy (&icon);
			}
		}
	}
	_tmp11_ = self->priv->_combobox_icon;
	_tmp12_ = icon_store;
	gtk_combo_box_set_model (_tmp11_, (GtkTreeModel*) _tmp12_);
	_tmp13_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	_tmp14_ = g_object_ref_sink (_tmp13_);
	pixbuf_renderer = _tmp14_;
	_tmp15_ = self->priv->_combobox_icon;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp15_, (GtkCellRenderer*) pixbuf_renderer, FALSE);
	_tmp16_ = self->priv->_combobox_icon;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp16_, (GtkCellRenderer*) pixbuf_renderer, "stock-id", 0, NULL, NULL);
	_tmp17_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp18_ = g_object_ref_sink (_tmp17_);
	text_renderer = _tmp18_;
	_tmp19_ = self->priv->_combobox_icon;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp19_, (GtkCellRenderer*) text_renderer, TRUE);
	_tmp20_ = self->priv->_combobox_icon;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp20_, (GtkCellRenderer*) text_renderer, "text", 1, NULL, NULL);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
	_g_object_unref0 (icon_store);
}


static void __lambda89_ (BuildToolDialog* self, const gchar* path_string, const gchar* new_text) {
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	const gchar* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	GtkListStore* _tmp3_;
	GtkTreeIter _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (path_string != NULL);
	g_return_if_fail (new_text != NULL);
	_tmp0_ = self->priv->_jobs_store;
	_tmp1_ = path_string;
	gtk_tree_model_get_iter_from_string ((GtkTreeModel*) _tmp0_, &_tmp2_, _tmp1_);
	iter = _tmp2_;
	_tmp3_ = self->priv->_jobs_store;
	_tmp4_ = iter;
	_tmp5_ = new_text;
	gtk_list_store_set (_tmp3_, &_tmp4_, BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, _tmp5_, -1, -1);
}


static void ___lambda89__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender, const gchar* path, const gchar* new_text, gpointer self) {
	__lambda89_ (self, path, new_text);
}


static void __lambda90_ (BuildToolDialog* self, const gchar* path_string) {
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	const gchar* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gboolean val = FALSE;
	GtkListStore* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* model;
	GtkTreeIter _tmp5_;
	GtkListStore* _tmp6_;
	GtkTreeIter _tmp7_;
	g_return_if_fail (path_string != NULL);
	_tmp0_ = self->priv->_jobs_store;
	_tmp1_ = path_string;
	gtk_tree_model_get_iter_from_string ((GtkTreeModel*) _tmp0_, &_tmp2_, _tmp1_);
	iter = _tmp2_;
	_tmp3_ = self->priv->_jobs_store;
	_tmp4_ = _g_object_ref0 (GTK_TREE_MODEL (_tmp3_));
	model = _tmp4_;
	_tmp5_ = iter;
	gtk_tree_model_get (model, &_tmp5_, BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED, &val, -1, -1);
	_tmp6_ = self->priv->_jobs_store;
	_tmp7_ = iter;
	gtk_list_store_set (_tmp6_, &_tmp7_, BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED, !val, -1, -1);
	_g_object_unref0 (model);
}


static void ___lambda90__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const gchar* path, gpointer self) {
	__lambda90_ (self, path);
}


static void __lambda91_ (BuildToolDialog* self, const gchar* path_string, const gchar* new_text) {
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	const gchar* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	GtkListStore* _tmp3_;
	GtkTreeIter _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (path_string != NULL);
	g_return_if_fail (new_text != NULL);
	_tmp0_ = self->priv->_jobs_store;
	_tmp1_ = path_string;
	gtk_tree_model_get_iter_from_string ((GtkTreeModel*) _tmp0_, &_tmp2_, _tmp1_);
	iter = _tmp2_;
	_tmp3_ = self->priv->_jobs_store;
	_tmp4_ = iter;
	_tmp5_ = new_text;
	gtk_list_store_set (_tmp3_, &_tmp4_, BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, _tmp5_, -1, -1);
}


static void ___lambda91__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender, const gchar* path, const gchar* new_text, gpointer self) {
	__lambda91_ (self, path, new_text);
}


static void build_tool_dialog_init_jobs_treeview (BuildToolDialog* self) {
	GtkListStore* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkListStore* _tmp2_;
	GtkListStore* _tmp3_;
	GtkListStore* post_processor_store;
	GtkCellRendererText* _tmp15_;
	GtkCellRendererText* _tmp16_;
	GtkCellRendererText* text_renderer;
	const gchar* _tmp17_ = NULL;
	GtkTreeViewColumn* _tmp18_;
	GtkTreeViewColumn* _tmp19_;
	GtkTreeViewColumn* column;
	GtkTreeView* _tmp20_;
	GtkCellRendererToggle* _tmp21_;
	GtkCellRendererToggle* _tmp22_;
	GtkCellRendererToggle* toggle_renderer;
	GtkTreeView* _tmp23_;
	const gchar* _tmp24_ = NULL;
	GtkCellRendererCombo* _tmp25_;
	GtkCellRendererCombo* _tmp26_;
	GtkCellRendererCombo* combo_renderer;
	GtkListStore* _tmp27_;
	GtkTreeView* _tmp28_;
	const gchar* _tmp29_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_list_store_new ((gint) BUILD_TOOL_DIALOG_JOB_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_STRING);
	_g_object_unref0 (self->priv->_jobs_store);
	self->priv->_jobs_store = _tmp0_;
	_tmp1_ = self->priv->_treeview_jobs;
	_tmp2_ = self->priv->_jobs_store;
	gtk_tree_view_set_model (_tmp1_, (GtkTreeModel*) _tmp2_);
	_tmp3_ = gtk_list_store_new (1, G_TYPE_STRING);
	post_processor_store = _tmp3_;
	{
		gint type;
		type = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				gint _tmp7_;
				GtkTreeIter iterpp = {0};
				GtkListStore* _tmp8_;
				GtkTreeIter _tmp9_ = {0};
				GtkListStore* _tmp10_;
				GtkTreeIter _tmp11_;
				gint _tmp12_;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = type;
					type = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = type;
				if (!(_tmp7_ < ((gint) POST_PROCESSOR_TYPE_N_POST_PROCESSORS))) {
					break;
				}
				_tmp8_ = post_processor_store;
				gtk_list_store_append (_tmp8_, &_tmp9_);
				iterpp = _tmp9_;
				_tmp10_ = post_processor_store;
				_tmp11_ = iterpp;
				_tmp12_ = type;
				_tmp13_ = build_tools_get_post_processor_name_from_type ((PostProcessorType) _tmp12_);
				_tmp14_ = _tmp13_;
				gtk_list_store_set (_tmp10_, &_tmp11_, 0, _tmp14_, -1, -1);
				_g_free0 (_tmp14_);
			}
		}
	}
	_tmp15_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp16_ = g_object_ref_sink (_tmp15_);
	text_renderer = _tmp16_;
	g_object_set (text_renderer, "editable", TRUE, NULL);
	_tmp17_ = _ ("Commands");
	_tmp18_ = gtk_tree_view_column_new_with_attributes (_tmp17_, (GtkCellRenderer*) text_renderer, "text", BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, NULL, NULL);
	_tmp19_ = g_object_ref_sink (_tmp18_);
	column = _tmp19_;
	gtk_tree_view_column_set_resizable (column, TRUE);
	_tmp20_ = self->priv->_treeview_jobs;
	gtk_tree_view_append_column (_tmp20_, column);
	_tmp21_ = (GtkCellRendererToggle*) gtk_cell_renderer_toggle_new ();
	_tmp22_ = g_object_ref_sink (_tmp21_);
	toggle_renderer = _tmp22_;
	gtk_cell_renderer_toggle_set_activatable (toggle_renderer, TRUE);
	_tmp23_ = self->priv->_treeview_jobs;
	_tmp24_ = _ ("Must Succeed");
	gtk_tree_view_insert_column_with_attributes (_tmp23_, -1, _tmp24_, (GtkCellRenderer*) toggle_renderer, "active", BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED, NULL, NULL);
	_tmp25_ = (GtkCellRendererCombo*) gtk_cell_renderer_combo_new ();
	_tmp26_ = g_object_ref_sink (_tmp25_);
	combo_renderer = _tmp26_;
	g_object_set ((GtkCellRendererText*) combo_renderer, "editable", TRUE, NULL);
	_tmp27_ = post_processor_store;
	g_object_set (combo_renderer, "model", (GtkTreeModel*) _tmp27_, NULL);
	g_object_set (combo_renderer, "text-column", 0, NULL);
	g_object_set (combo_renderer, "has-entry", FALSE, NULL);
	_tmp28_ = self->priv->_treeview_jobs;
	_tmp29_ = _ ("Post Processor");
	gtk_tree_view_insert_column_with_attributes (_tmp28_, -1, _tmp29_, (GtkCellRenderer*) combo_renderer, "text", BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, NULL, NULL);
	g_signal_connect_object (text_renderer, "edited", (GCallback) ___lambda89__gtk_cell_renderer_text_edited, self, 0);
	g_signal_connect_object (toggle_renderer, "toggled", (GCallback) ___lambda90__gtk_cell_renderer_toggle_toggled, self, 0);
	g_signal_connect_object ((GtkCellRendererText*) combo_renderer, "edited", (GCallback) ___lambda91__gtk_cell_renderer_text_edited, self, 0);
	_g_object_unref0 (combo_renderer);
	_g_object_unref0 (toggle_renderer);
	_g_object_unref0 (column);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (post_processor_store);
}


static void _build_tool_dialog_on_command_add_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	build_tool_dialog_on_command_add (self);
}


static void _build_tool_dialog_on_command_add_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	build_tool_dialog_on_command_add (self);
}


static void __lambda92_ (BuildToolDialog* self) {
	GtkTreeIter iter = {0};
	GtkTreeView* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gint _tmp2_ = 0;
	gint i;
	gint _tmp3_;
	_tmp0_ = self->priv->_treeview_jobs;
	_tmp2_ = utils_get_selected_row (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	i = _tmp2_;
	_tmp3_ = i;
	if (_tmp3_ != (-1)) {
		GtkListStore* _tmp4_;
		GtkTreeIter _tmp5_;
		_tmp4_ = self->priv->_jobs_store;
		_tmp5_ = iter;
		gtk_list_store_remove (_tmp4_, &_tmp5_);
	}
}


static void ___lambda92__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda92_ (self);
}


static void __lambda93_ (BuildToolDialog* self) {
	GtkTreeIter iter1 = {0};
	GtkTreeIter iter2 = {0};
	GtkTreeView* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gint _tmp2_ = 0;
	gint i;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_;
	gboolean _tmp6_;
	_tmp0_ = self->priv->_treeview_jobs;
	_tmp2_ = utils_get_selected_row (_tmp0_, &_tmp1_);
	iter1 = _tmp1_;
	i = _tmp2_;
	_tmp4_ = i;
	if (_tmp4_ != (-1)) {
		gint _tmp5_;
		_tmp5_ = i;
		_tmp3_ = _tmp5_ > 0;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp6_ = _tmp3_;
	if (_tmp6_) {
		GtkTreeIter _tmp7_;
		GtkListStore* _tmp8_;
		gboolean _tmp9_ = FALSE;
		_tmp7_ = iter1;
		iter2 = _tmp7_;
		_tmp8_ = self->priv->_jobs_store;
		_tmp9_ = utils_tree_model_iter_prev ((GtkTreeModel*) _tmp8_, &iter2);
		if (_tmp9_) {
			GtkListStore* _tmp10_;
			GtkTreeIter _tmp11_;
			GtkTreeIter _tmp12_;
			_tmp10_ = self->priv->_jobs_store;
			_tmp11_ = iter1;
			_tmp12_ = iter2;
			gtk_list_store_swap (_tmp10_, &_tmp11_, &_tmp12_);
		}
	}
}


static void ___lambda93__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda93_ (self);
}


static void __lambda94_ (BuildToolDialog* self) {
	GtkTreeIter iter1 = {0};
	GtkTreeIter iter2 = {0};
	GtkTreeView* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gint _tmp2_ = 0;
	gint i;
	gint _tmp3_;
	_tmp0_ = self->priv->_treeview_jobs;
	_tmp2_ = utils_get_selected_row (_tmp0_, &_tmp1_);
	iter1 = _tmp1_;
	i = _tmp2_;
	_tmp3_ = i;
	if (_tmp3_ != (-1)) {
		GtkTreeIter _tmp4_;
		GtkListStore* _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = iter1;
		iter2 = _tmp4_;
		_tmp5_ = self->priv->_jobs_store;
		_tmp6_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp5_, &iter2);
		if (_tmp6_) {
			GtkListStore* _tmp7_;
			GtkTreeIter _tmp8_;
			GtkTreeIter _tmp9_;
			_tmp7_ = self->priv->_jobs_store;
			_tmp8_ = iter1;
			_tmp9_ = iter2;
			gtk_list_store_swap (_tmp7_, &_tmp8_, &_tmp9_);
		}
	}
}


static void ___lambda94__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda94_ (self);
}


static void build_tool_dialog_init_actions (BuildToolDialog* self) {
	GtkButton* _tmp0_;
	ErrorEntry* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_button_add;
	g_signal_connect_object (_tmp0_, "clicked", (GCallback) _build_tool_dialog_on_command_add_gtk_button_clicked, self, 0);
	_tmp1_ = self->priv->_entry_command;
	g_signal_connect_object ((GtkEntry*) _tmp1_, "activate", (GCallback) _build_tool_dialog_on_command_add_gtk_entry_activate, self, 0);
	_tmp2_ = self->priv->_button_delete;
	g_signal_connect_object (_tmp2_, "clicked", (GCallback) ___lambda92__gtk_button_clicked, self, 0);
	_tmp3_ = self->priv->_button_up;
	g_signal_connect_object (_tmp3_, "clicked", (GCallback) ___lambda93__gtk_button_clicked, self, 0);
	_tmp4_ = self->priv->_button_down;
	g_signal_connect_object (_tmp4_, "clicked", (GCallback) ___lambda94__gtk_button_clicked, self, 0);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void build_tool_dialog_on_command_add (BuildToolDialog* self) {
	ErrorEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gboolean _tmp5_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp6_;
	GtkTreeIter _tmp7_ = {0};
	GtkListStore* _tmp8_;
	GtkTreeIter _tmp9_;
	ErrorEntry* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	ErrorEntry* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_entry_command;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = string_strip (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp4_, "") == 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		return;
	}
	_tmp6_ = self->priv->_jobs_store;
	gtk_list_store_append (_tmp6_, &_tmp7_);
	iter = _tmp7_;
	_tmp8_ = self->priv->_jobs_store;
	_tmp9_ = iter;
	_tmp10_ = self->priv->_entry_command;
	_tmp11_ = gtk_entry_get_text ((GtkEntry*) _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = build_tools_get_post_processor_name_from_type (POST_PROCESSOR_TYPE_NO_OUTPUT);
	_tmp14_ = _tmp13_;
	gtk_list_store_set (_tmp8_, &_tmp9_, BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, _tmp12_, BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED, TRUE, BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, _tmp14_, -1, -1);
	_g_free0 (_tmp14_);
	_tmp15_ = self->priv->_entry_command;
	gtk_entry_set_text ((GtkEntry*) _tmp15_, "");
}


static void build_tool_dialog_init (BuildToolDialog* self, gint build_tool_num) {
	ErrorEntry* _tmp0_;
	GtkListStore* _tmp1_;
	ErrorEntry* _tmp2_;
	ErrorEntry* _tmp3_;
	gint _tmp4_;
	GtkTreeView* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_entry_command;
	gtk_entry_set_text ((GtkEntry*) _tmp0_, "");
	_tmp1_ = self->priv->_jobs_store;
	gtk_list_store_clear (_tmp1_);
	_tmp2_ = self->priv->_entry_label;
	error_entry_set_error (_tmp2_, FALSE);
	_tmp3_ = self->priv->_entry_command;
	error_entry_set_error (_tmp3_, FALSE);
	_tmp4_ = build_tool_num;
	if (_tmp4_ == (-1)) {
		BuildToolDialog* _tmp5_;
		_tmp5_ = build_tool_dialog__instance;
		build_tool_dialog_init_new_build_tool (_tmp5_);
	} else {
		BuildToolDialog* _tmp6_;
		BuildTools* _tmp7_ = NULL;
		BuildTools* _tmp8_;
		gint _tmp9_;
		BuildTool* _tmp10_ = NULL;
		BuildTool* _tmp11_;
		BuildTool _tmp12_;
		_tmp6_ = build_tool_dialog__instance;
		_tmp7_ = build_tools_get_default ();
		_tmp8_ = _tmp7_;
		_tmp9_ = build_tool_num;
		_tmp10_ = build_tools_get (_tmp8_, _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = *_tmp11_;
		build_tool_dialog_init_with_build_tool (_tmp6_, &_tmp12_);
		_build_tool_free0 (_tmp11_);
		_build_tools_unref0 (_tmp8_);
	}
	_tmp13_ = self->priv->_treeview_jobs;
	gtk_tree_view_columns_autosize (_tmp13_);
}


static void build_tool_dialog_init_new_build_tool (BuildToolDialog* self) {
	ErrorEntry* _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* _tmp2_;
	GtkComboBox* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_entry_label;
	gtk_entry_set_text ((GtkEntry*) _tmp0_, "");
	_tmp1_ = self->priv->_entry_desc;
	gtk_entry_set_text (_tmp1_, "");
	_tmp2_ = self->priv->_entry_extensions;
	gtk_entry_set_text (_tmp2_, ".tex");
	_tmp3_ = self->priv->_combobox_icon;
	gtk_combo_box_set_active (_tmp3_, 0);
}


static void build_tool_dialog_init_with_build_tool (BuildToolDialog* self, BuildTool* tool) {
	ErrorEntry* _tmp0_;
	BuildTool _tmp1_;
	const gchar* _tmp2_;
	GtkEntry* _tmp3_;
	BuildTool _tmp4_;
	const gchar* _tmp5_;
	GtkEntry* _tmp6_;
	BuildTool _tmp7_;
	const gchar* _tmp8_;
	GtkComboBox* _tmp9_;
	GtkListStore* _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tool != NULL);
	_tmp0_ = self->priv->_entry_label;
	_tmp1_ = *tool;
	_tmp2_ = _tmp1_.label;
	gtk_entry_set_text ((GtkEntry*) _tmp0_, _tmp2_);
	_tmp3_ = self->priv->_entry_desc;
	_tmp4_ = *tool;
	_tmp5_ = _tmp4_.description;
	gtk_entry_set_text (_tmp3_, _tmp5_);
	_tmp6_ = self->priv->_entry_extensions;
	_tmp7_ = *tool;
	_tmp8_ = _tmp7_.extensions;
	gtk_entry_set_text (_tmp6_, _tmp8_);
	_tmp9_ = self->priv->_combobox_icon;
	gtk_combo_box_set_active (_tmp9_, 0);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp10_;
			_tmp10_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_;
				gint _tmp13_;
				gint _tmp14_;
				BuildToolDialogIconColumn _tmp15_;
				const gchar* _tmp16_;
				BuildTool _tmp17_;
				const gchar* _tmp18_;
				_tmp11_ = _tmp10_;
				if (!_tmp11_) {
					gint _tmp12_;
					_tmp12_ = i;
					i = _tmp12_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp13_ = i;
				if (!(_tmp13_ < G_N_ELEMENTS (BUILD_TOOL_DIALOG__icons))) {
					break;
				}
				_tmp14_ = i;
				_tmp15_ = BUILD_TOOL_DIALOG__icons[_tmp14_];
				_tmp16_ = _tmp15_.stock_id;
				_tmp17_ = *tool;
				_tmp18_ = _tmp17_.icon;
				if (g_strcmp0 (_tmp16_, _tmp18_) == 0) {
					GtkComboBox* _tmp19_;
					gint _tmp20_;
					_tmp19_ = self->priv->_combobox_icon;
					_tmp20_ = i;
					gtk_combo_box_set_active (_tmp19_, _tmp20_);
					break;
				}
			}
		}
	}
	_tmp21_ = self->priv->_jobs_store;
	gtk_list_store_clear (_tmp21_);
	{
		BuildTool _tmp22_;
		GeeArrayList* _tmp23_;
		GeeArrayList* _tmp24_;
		GeeArrayList* _job_list;
		GeeArrayList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _job_size;
		gint _job_index;
		_tmp22_ = *tool;
		_tmp23_ = _tmp22_.jobs;
		_tmp24_ = _g_object_ref0 (_tmp23_);
		_job_list = _tmp24_;
		_tmp25_ = _job_list;
		_tmp26_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_job_size = _tmp27_;
		_job_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			GeeArrayList* _tmp31_;
			gint _tmp32_;
			gpointer _tmp33_ = NULL;
			BuildJob* _tmp34_;
			BuildJob _tmp35_ = {0};
			BuildJob _tmp36_;
			BuildJob job;
			GtkTreeIter iter = {0};
			GtkListStore* _tmp37_;
			GtkTreeIter _tmp38_ = {0};
			GtkListStore* _tmp39_;
			GtkTreeIter _tmp40_;
			BuildJob _tmp41_;
			const gchar* _tmp42_;
			BuildJob _tmp43_;
			gboolean _tmp44_;
			BuildJob _tmp45_;
			PostProcessorType _tmp46_;
			gchar* _tmp47_ = NULL;
			gchar* _tmp48_;
			_tmp28_ = _job_index;
			_job_index = _tmp28_ + 1;
			_tmp29_ = _job_index;
			_tmp30_ = _job_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _job_list;
			_tmp32_ = _job_index;
			_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, _tmp32_);
			_tmp34_ = (BuildJob*) _tmp33_;
			build_job_copy (_tmp34_, &_tmp35_);
			_tmp36_ = _tmp35_;
			_build_job_free0 (_tmp34_);
			job = _tmp36_;
			_tmp37_ = self->priv->_jobs_store;
			gtk_list_store_append (_tmp37_, &_tmp38_);
			iter = _tmp38_;
			_tmp39_ = self->priv->_jobs_store;
			_tmp40_ = iter;
			_tmp41_ = job;
			_tmp42_ = _tmp41_.command;
			_tmp43_ = job;
			_tmp44_ = _tmp43_.must_succeed;
			_tmp45_ = job;
			_tmp46_ = _tmp45_.post_processor;
			_tmp47_ = build_tools_get_post_processor_name_from_type (_tmp46_);
			_tmp48_ = _tmp47_;
			gtk_list_store_set (_tmp39_, &_tmp40_, BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, _tmp42_, BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED, _tmp44_, BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, _tmp48_, -1, -1);
			_g_free0 (_tmp48_);
			build_job_destroy (&job);
		}
		_g_object_unref0 (_job_list);
	}
}


static gboolean build_tool_dialog_run_me (BuildToolDialog* self, gint build_tool_num) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	while (TRUE) {
		gint _tmp0_ = 0;
		ErrorEntry* _tmp1_;
		ErrorEntry* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		GtkTreeIter iter = {0};
		ErrorEntry* _tmp7_;
		GtkListStore* _tmp8_;
		GtkTreeIter _tmp9_ = {0};
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		ErrorEntry* _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp14_;
		gboolean _tmp18_;
		BuildTool tool = {0};
		ErrorEntry* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		GtkEntry* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_;
		gboolean _tmp29_;
		const gchar* _tmp37_;
		gchar* _tmp38_;
		GtkEntry* _tmp39_;
		const gchar* _tmp40_;
		const gchar* _tmp41_;
		gchar* _tmp42_ = NULL;
		GeeArrayList* _tmp43_;
		GtkComboBox* _tmp44_;
		GtkTreeIter _tmp45_ = {0};
		GtkComboBox* _tmp46_;
		GtkTreeModel* _tmp47_ = NULL;
		GtkTreeModel* _tmp48_;
		GtkTreeModel* model;
		GtkTreeModel* _tmp49_;
		GtkTreeIter _tmp50_;
		GtkTreeView* _tmp51_;
		GtkTreeModel* _tmp52_ = NULL;
		GtkTreeModel* _tmp53_;
		GtkListStore* _tmp54_;
		GtkTreeIter _tmp55_ = {0};
		gboolean _tmp56_ = FALSE;
		gboolean valid;
		gint _tmp70_;
		_tmp0_ = gtk_dialog_run ((GtkDialog*) self);
		if (!(_tmp0_ == ((gint) GTK_RESPONSE_OK))) {
			break;
		}
		_tmp1_ = self->priv->_entry_label;
		_tmp2_ = self->priv->_entry_label;
		_tmp3_ = gtk_entry_get_text ((GtkEntry*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = string_strip (_tmp4_);
		_tmp6_ = _tmp5_;
		error_entry_set_error (_tmp1_, g_strcmp0 (_tmp6_, "") == 0);
		_g_free0 (_tmp6_);
		_tmp7_ = self->priv->_entry_command;
		_tmp8_ = self->priv->_jobs_store;
		_tmp10_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp8_, &_tmp9_);
		iter = _tmp9_;
		error_entry_set_error (_tmp7_, !_tmp10_);
		_tmp12_ = self->priv->_entry_label;
		_tmp13_ = error_entry_get_error (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_) {
			_tmp11_ = TRUE;
		} else {
			ErrorEntry* _tmp15_;
			gboolean _tmp16_;
			gboolean _tmp17_;
			_tmp15_ = self->priv->_entry_command;
			_tmp16_ = error_entry_get_error (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp11_ = _tmp17_;
		}
		_tmp18_ = _tmp11_;
		if (_tmp18_) {
			continue;
		}
		memset (&tool, 0, sizeof (BuildTool));
		_tmp19_ = self->priv->_entry_label;
		_tmp20_ = gtk_entry_get_text ((GtkEntry*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = string_strip (_tmp21_);
		_g_free0 (tool.label);
		tool.label = _tmp22_;
		_tmp24_ = self->priv->_entry_desc;
		_tmp25_ = gtk_entry_get_text (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = string_strip (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = g_strcmp0 (_tmp28_, "") == 0;
		_g_free0 (_tmp28_);
		if (_tmp29_) {
			BuildTool _tmp30_;
			const gchar* _tmp31_;
			gchar* _tmp32_;
			_tmp30_ = tool;
			_tmp31_ = _tmp30_.label;
			_tmp32_ = g_strdup (_tmp31_);
			_g_free0 (_tmp23_);
			_tmp23_ = _tmp32_;
		} else {
			GtkEntry* _tmp33_;
			const gchar* _tmp34_;
			const gchar* _tmp35_;
			gchar* _tmp36_ = NULL;
			_tmp33_ = self->priv->_entry_desc;
			_tmp34_ = gtk_entry_get_text (_tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = string_strip (_tmp35_);
			_g_free0 (_tmp23_);
			_tmp23_ = _tmp36_;
		}
		_tmp37_ = _tmp23_;
		_tmp38_ = g_strdup (_tmp37_);
		_g_free0 (tool.description);
		tool.description = _tmp38_;
		_tmp39_ = self->priv->_entry_extensions;
		_tmp40_ = gtk_entry_get_text (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = string_strip (_tmp41_);
		_g_free0 (tool.extensions);
		tool.extensions = _tmp42_;
		_tmp43_ = gee_array_list_new (TYPE_BUILD_JOB, (GBoxedCopyFunc) build_job_dup, build_job_free, NULL);
		_g_object_unref0 (tool.jobs);
		tool.jobs = _tmp43_;
		_tmp44_ = self->priv->_combobox_icon;
		gtk_combo_box_get_active_iter (_tmp44_, &_tmp45_);
		iter = _tmp45_;
		_tmp46_ = self->priv->_combobox_icon;
		_tmp47_ = gtk_combo_box_get_model (_tmp46_);
		_tmp48_ = _g_object_ref0 (_tmp47_);
		model = _tmp48_;
		_tmp49_ = model;
		_tmp50_ = iter;
		gtk_tree_model_get (_tmp49_, &_tmp50_, 0, &tool.icon, -1, -1);
		_tmp51_ = self->priv->_treeview_jobs;
		_tmp52_ = gtk_tree_view_get_model (_tmp51_);
		_tmp53_ = _g_object_ref0 (_tmp52_);
		_g_object_unref0 (model);
		model = _tmp53_;
		_tmp54_ = self->priv->_jobs_store;
		_tmp56_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp54_, &_tmp55_);
		iter = _tmp55_;
		valid = _tmp56_;
		while (TRUE) {
			gboolean _tmp57_;
			BuildJob job = {0};
			gchar* command = NULL;
			gchar* post_processor_name = NULL;
			GtkTreeModel* _tmp58_;
			GtkTreeIter _tmp59_;
			const gchar* _tmp60_;
			gchar* _tmp61_ = NULL;
			const gchar* _tmp62_;
			PostProcessorType* _tmp63_ = NULL;
			PostProcessorType* _tmp64_;
			BuildTool _tmp65_;
			GeeArrayList* _tmp66_;
			BuildJob _tmp67_;
			GtkListStore* _tmp68_;
			gboolean _tmp69_ = FALSE;
			_tmp57_ = valid;
			if (!_tmp57_) {
				break;
			}
			memset (&job, 0, sizeof (BuildJob));
			_tmp58_ = model;
			_tmp59_ = iter;
			gtk_tree_model_get (_tmp58_, &_tmp59_, BUILD_TOOL_DIALOG_JOB_COLUMN_COMMAND, &command, BUILD_TOOL_DIALOG_JOB_COLUMN_MUST_SUCCEED, &job.must_succeed, BUILD_TOOL_DIALOG_JOB_COLUMN_POST_PROCESSOR, &post_processor_name, -1, -1);
			_tmp60_ = command;
			_tmp61_ = string_strip (_tmp60_);
			_g_free0 (job.command);
			job.command = _tmp61_;
			_tmp62_ = post_processor_name;
			_tmp63_ = build_tools_get_post_processor_type_from_name (_tmp62_);
			_tmp64_ = _tmp63_;
			job.post_processor = *_tmp64_;
			_g_free0 (_tmp64_);
			_tmp65_ = tool;
			_tmp66_ = _tmp65_.jobs;
			_tmp67_ = job;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp66_, &_tmp67_);
			_tmp68_ = self->priv->_jobs_store;
			_tmp69_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp68_, &iter);
			valid = _tmp69_;
			_g_free0 (post_processor_name);
			_g_free0 (command);
			build_job_destroy (&job);
		}
		_tmp70_ = build_tool_num;
		if (_tmp70_ == (-1)) {
			BuildTools* _tmp71_ = NULL;
			BuildTools* _tmp72_;
			BuildTool _tmp73_;
			tool.show = TRUE;
			_tmp71_ = build_tools_get_default ();
			_tmp72_ = _tmp71_;
			_tmp73_ = tool;
			build_tools_add (_tmp72_, &_tmp73_);
			_build_tools_unref0 (_tmp72_);
		} else {
			BuildTools* _tmp74_ = NULL;
			BuildTools* _tmp75_;
			gint _tmp76_;
			BuildTool _tmp77_;
			_tmp74_ = build_tools_get_default ();
			_tmp75_ = _tmp74_;
			_tmp76_ = build_tool_num;
			_tmp77_ = tool;
			build_tools_update (_tmp75_, _tmp76_, &_tmp77_, TRUE);
			_build_tools_unref0 (_tmp75_);
		}
		gtk_widget_hide ((GtkWidget*) self);
		result = TRUE;
		_g_object_unref0 (model);
		_g_free0 (_tmp23_);
		build_tool_destroy (&tool);
		return result;
	}
	gtk_widget_hide ((GtkWidget*) self);
	result = FALSE;
	return result;
}


static void build_tool_dialog_icon_column_copy (const BuildToolDialogIconColumn* self, BuildToolDialogIconColumn* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).stock_id;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).stock_id);
	(*dest).stock_id = _tmp1_;
	_tmp2_ = (*self).label;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).label);
	(*dest).label = _tmp3_;
}


static void build_tool_dialog_icon_column_destroy (BuildToolDialogIconColumn* self) {
	_g_free0 ((*self).stock_id);
	_g_free0 ((*self).label);
}


static BuildToolDialogIconColumn* build_tool_dialog_icon_column_dup (const BuildToolDialogIconColumn* self) {
	BuildToolDialogIconColumn* dup;
	dup = g_new0 (BuildToolDialogIconColumn, 1);
	build_tool_dialog_icon_column_copy (self, dup);
	return dup;
}


static void build_tool_dialog_icon_column_free (BuildToolDialogIconColumn* self) {
	build_tool_dialog_icon_column_destroy (self);
	g_free (self);
}


static GType build_tool_dialog_icon_column_get_type (void) {
	static volatile gsize build_tool_dialog_icon_column_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_dialog_icon_column_type_id__volatile)) {
		GType build_tool_dialog_icon_column_type_id;
		build_tool_dialog_icon_column_type_id = g_boxed_type_register_static ("BuildToolDialogIconColumn", (GBoxedCopyFunc) build_tool_dialog_icon_column_dup, (GBoxedFreeFunc) build_tool_dialog_icon_column_free);
		g_once_init_leave (&build_tool_dialog_icon_column_type_id__volatile, build_tool_dialog_icon_column_type_id);
	}
	return build_tool_dialog_icon_column_type_id__volatile;
}


static void build_tool_dialog_class_init (BuildToolDialogClass * klass) {
	build_tool_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BuildToolDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = build_tool_dialog_finalize;
}


static void build_tool_dialog_instance_init (BuildToolDialog * self) {
	self->priv = BUILD_TOOL_DIALOG_GET_PRIVATE (self);
}


static void build_tool_dialog_finalize (GObject* obj) {
	BuildToolDialog * self;
	self = BUILD_TOOL_DIALOG (obj);
	_g_object_unref0 (self->priv->_entry_label);
	_g_object_unref0 (self->priv->_entry_desc);
	_g_object_unref0 (self->priv->_entry_extensions);
	_g_object_unref0 (self->priv->_combobox_icon);
	_g_object_unref0 (self->priv->_entry_command);
	_g_object_unref0 (self->priv->_button_add);
	_g_object_unref0 (self->priv->_treeview_jobs);
	_g_object_unref0 (self->priv->_button_delete);
	_g_object_unref0 (self->priv->_button_up);
	_g_object_unref0 (self->priv->_button_down);
	_g_object_unref0 (self->priv->_jobs_store);
	G_OBJECT_CLASS (build_tool_dialog_parent_class)->finalize (obj);
}


GType build_tool_dialog_get_type (void) {
	static volatile gsize build_tool_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BuildToolDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) build_tool_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BuildToolDialog), 0, (GInstanceInitFunc) build_tool_dialog_instance_init, NULL };
		GType build_tool_dialog_type_id;
		build_tool_dialog_type_id = g_type_register_static (GTK_TYPE_DIALOG, "BuildToolDialog", &g_define_type_info, 0);
		g_once_init_leave (&build_tool_dialog_type_id__volatile, build_tool_dialog_type_id);
	}
	return build_tool_dialog_type_id__volatile;
}



