/* preferences_dialog.c generated by valac 0.16.0, the Vala compiler
 * generated from preferences_dialog.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include "config.h"
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <gtksourceview/gtksource.h>


#define TYPE_PREFERENCES_DIALOG (preferences_dialog_get_type ())
#define PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialog))
#define PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))
#define IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES_DIALOG))
#define IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES_DIALOG))
#define PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))

typedef struct _PreferencesDialog PreferencesDialog;
typedef struct _PreferencesDialogClass PreferencesDialogClass;
typedef struct _PreferencesDialogPrivate PreferencesDialogPrivate;

#define PREFERENCES_DIALOG_TYPE_STYLE_SCHEMES (preferences_dialog_style_schemes_get_type ())

#define PREFERENCES_DIALOG_TYPE_BUILD_TOOL_COLUMN (preferences_dialog_build_tool_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _Block18Data Block18Data;

#define TYPE_APP_SETTINGS (app_settings_get_type ())
#define APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_SETTINGS, AppSettings))
#define APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_SETTINGS, AppSettingsClass))
#define IS_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_SETTINGS))
#define IS_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_SETTINGS))
#define APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_SETTINGS, AppSettingsClass))

typedef struct _AppSettings AppSettings;
typedef struct _AppSettingsClass AppSettingsClass;
#define __g_list_free__gtk_tree_path_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_tree_path_free0_ (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
typedef struct _Block19Data Block19Data;

#define TYPE_BUILD_TOOLS (build_tools_get_type ())
#define BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOLS, BuildTools))
#define BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOLS, BuildToolsClass))
#define IS_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOLS))
#define IS_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOLS))
#define BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOLS, BuildToolsClass))

typedef struct _BuildTools BuildTools;
typedef struct _BuildToolsClass BuildToolsClass;

#define TYPE_BUILD_TOOL (build_tool_get_type ())

#define TYPE_BUILD_JOB (build_job_get_type ())

#define TYPE_POST_PROCESSOR_TYPE (post_processor_type_get_type ())
typedef struct _BuildJob BuildJob;
typedef struct _BuildTool BuildTool;
#define _build_tool_free0(var) ((var == NULL) ? NULL : (var = (build_tool_free (var), NULL)))
#define _build_tools_unref0(var) ((var == NULL) ? NULL : (var = (build_tools_unref (var), NULL)))
typedef struct _Block20Data Block20Data;
typedef struct _Block21Data Block21Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block22Data Block22Data;

struct _PreferencesDialog {
	GtkDialog parent_instance;
	PreferencesDialogPrivate * priv;
};

struct _PreferencesDialogClass {
	GtkDialogClass parent_class;
};

struct _PreferencesDialogPrivate {
	GtkListStore* build_tools_store;
};

typedef enum  {
	PREFERENCES_DIALOG_STYLE_SCHEMES_ID,
	PREFERENCES_DIALOG_STYLE_SCHEMES_DESC,
	PREFERENCES_DIALOG_STYLE_SCHEMES_N_COLUMNS
} PreferencesDialogStyleSchemes;

typedef enum  {
	PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_SHOW,
	PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_PIXBUF,
	PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_LABEL,
	PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_DESCRIPTION,
	PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_N_COLUMNS
} PreferencesDialogBuildToolColumn;

typedef const gchar* (*PreferencesDialogPlural) (gulong n, void* user_data);
struct _Block18Data {
	int _ref_count_;
	PreferencesDialog * self;
	GSettings* settings;
	GtkButton* default_font_checkbutton;
	GtkTreeView* schemes_treeview;
	GtkTreeSelection* schemes_select;
};

struct _Block19Data {
	int _ref_count_;
	PreferencesDialog * self;
	GtkTreeView* build_tools_view;
};

typedef enum  {
	POST_PROCESSOR_TYPE_ALL_OUTPUT = 0,
	POST_PROCESSOR_TYPE_LATEX,
	POST_PROCESSOR_TYPE_LATEXMK,
	POST_PROCESSOR_TYPE_NO_OUTPUT,
	POST_PROCESSOR_TYPE_RUBBER,
	POST_PROCESSOR_TYPE_N_POST_PROCESSORS
} PostProcessorType;

struct _BuildJob {
	gboolean must_succeed;
	PostProcessorType post_processor;
	gchar* command;
};

struct _BuildTool {
	gchar* description;
	gchar* extensions;
	gchar* label;
	gchar* icon;
	gboolean show;
	gboolean compilation;
	GeeArrayList* jobs;
};

struct _Block20Data {
	int _ref_count_;
	PreferencesDialog * self;
	GtkWidget* widget;
	gboolean must_be_enabled;
};

struct _Block21Data {
	int _ref_count_;
	PreferencesDialog * self;
	GtkLabel* label;
	PreferencesDialogPlural plural;
	gpointer plural_target;
};

struct _Block22Data {
	int _ref_count_;
	PreferencesDialog * self;
	GtkTreeViewColumn* label_column;
};


static gpointer preferences_dialog_parent_class = NULL;
static PreferencesDialog* preferences_dialog_preferences_dialog;
static PreferencesDialog* preferences_dialog_preferences_dialog = NULL;

GType preferences_dialog_get_type (void) G_GNUC_CONST;
#define PREFERENCES_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PREFERENCES_DIALOG, PreferencesDialogPrivate))
enum  {
	PREFERENCES_DIALOG_DUMMY_PROPERTY
};
static GType preferences_dialog_style_schemes_get_type (void) G_GNUC_UNUSED;
static GType preferences_dialog_build_tool_column_get_type (void) G_GNUC_UNUSED;
static PreferencesDialog* preferences_dialog_new (void);
static PreferencesDialog* preferences_dialog_construct (GType object_type);
static void __lambda79_ (PreferencesDialog* self, gint response_id);
static void preferences_dialog_reset_all (PreferencesDialog* self);
static void ___lambda79__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void preferences_dialog_init_editor_tab (PreferencesDialog* self, GtkBuilder* builder);
static void preferences_dialog_init_font_and_colors_tab (PreferencesDialog* self, GtkBuilder* builder);
static void preferences_dialog_init_latex_tab (PreferencesDialog* self, GtkBuilder* builder);
static void preferences_dialog_init_other_tab (PreferencesDialog* self, GtkBuilder* builder);
GType main_window_get_type (void) G_GNUC_CONST;
void preferences_dialog_show_me (MainWindow* parent);
static void ___lambda103_ (void);
static void ____lambda103__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static GtkDialog* preferences_dialog_get_reset_all_confirm_dialog (PreferencesDialog* self, const gchar* msg);
static void preferences_dialog_set_spin_button_range (PreferencesDialog* self, GtkSpinButton* spin_button, GSettings* settings, const gchar* key);
static void preferences_dialog_set_sensitivity (PreferencesDialog* self, GSettings* settings, const gchar* key, GtkWidget* widget, gboolean must_be_enabled);
static void preferences_dialog_set_plural (PreferencesDialog* self, GtkLabel* label, GSettings* settings, const gchar* key, PreferencesDialogPlural plural, void* plural_target);
static const gchar* __lambda82_ (PreferencesDialog* self, gulong n);
static const gchar* ___lambda82__preferences_dialog_plural (gulong n, gpointer self);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
static void preferences_dialog_set_system_font_label (PreferencesDialog* self, GtkButton* button);
GType app_settings_get_type (void) G_GNUC_CONST;
AppSettings* app_settings_get_default (void);
static void __lambda83_ (Block18Data* _data18_);
static void ___lambda83__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void preferences_dialog_init_schemes_treeview (PreferencesDialog* self, GtkTreeView* treeview, const gchar* current_id);
static void __lambda84_ (Block18Data* _data18_);
static void _gtk_tree_path_free0_ (gpointer var);
static void _g_list_free__gtk_tree_path_free0_ (GList* self);
static void ___lambda84__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static void __lambda85_ (Block18Data* _data18_, GSettings* setting, const gchar* key);
static void ___lambda85__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (void * _userdata_);
static const gchar* __lambda86_ (PreferencesDialog* self, gulong n);
static const gchar* ___lambda86__preferences_dialog_plural (gulong n, gpointer self);
static void preferences_dialog_init_build_tools_treeview (PreferencesDialog* self, GtkTreeView* build_tools_view);
static void __lambda96_ (Block19Data* _data19_);
gint utils_get_selected_row (GtkTreeView* view, GtkTreeIter* iter);
static void preferences_dialog_run_build_tool_dialog (PreferencesDialog* self, gint num);
static void ___lambda96__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda97_ (PreferencesDialog* self);
static void ___lambda97__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda98_ (Block19Data* _data19_);
gpointer build_tools_ref (gpointer instance);
void build_tools_unref (gpointer instance);
GParamSpec* param_spec_build_tools (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_build_tools (GValue* value, gpointer v_object);
void value_take_build_tools (GValue* value, gpointer v_object);
gpointer value_get_build_tools (const GValue* value);
GType build_tools_get_type (void) G_GNUC_CONST;
BuildTools* build_tools_get_default (void);
GType build_tool_get_type (void) G_GNUC_CONST;
GType build_job_get_type (void) G_GNUC_CONST;
GType post_processor_type_get_type (void) G_GNUC_CONST;
BuildJob* build_job_dup (const BuildJob* self);
void build_job_free (BuildJob* self);
void build_job_copy (const BuildJob* self, BuildJob* dest);
void build_job_destroy (BuildJob* self);
BuildTool* build_tool_dup (const BuildTool* self);
void build_tool_free (BuildTool* self);
void build_tool_copy (const BuildTool* self, BuildTool* dest);
void build_tool_destroy (BuildTool* self);
BuildTool* build_tools_get (BuildTools* self, gint id);
void build_tools_insert (BuildTools* self, gint pos, BuildTool* tool);
static void preferences_dialog_update_build_tools_store (PreferencesDialog* self);
static void ___lambda98__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda99_ (Block19Data* _data19_);
gboolean utils_tree_model_iter_prev (GtkTreeModel* model, GtkTreeIter* iter);
void build_tools_move_up (BuildTools* self, gint num);
static void ___lambda99__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda100_ (Block19Data* _data19_);
void build_tools_move_down (BuildTools* self, gint num);
static void ___lambda100__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda101_ (Block19Data* _data19_);
void build_tools_delete (BuildTools* self, gint num);
static void ___lambda101__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda102_ (PreferencesDialog* self);
void build_tools_reset_all (BuildTools* self);
static void ___lambda102__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
static void __lambda80_ (Block20Data* _data20_, GSettings* setting, const gchar* k);
static void ___lambda80__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
const gchar* app_settings_get_system_font (AppSettings* self);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (void * _userdata_);
static void __lambda81_ (Block21Data* _data21_, GSettings* setting, const gchar* k);
static void ___lambda81__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
static void __lambda87_ (PreferencesDialog* self, const gchar* path_string);
void build_tools_update (BuildTools* self, gint num, BuildTool* tool, gboolean keep_show);
static void ___lambda87__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const gchar* path, gpointer self);
static void __lambda88_ (Block22Data* _data22_, GtkTreePath* path, GtkTreeViewColumn* column);
static void ___lambda88__gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
GeeIterator* build_tools_iterator (BuildTools* self);
gboolean build_tool_dialog_show_me (GtkWindow* parent, gint build_tool_num);
static void preferences_dialog_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static GType preferences_dialog_style_schemes_get_type (void) {
	static volatile gsize preferences_dialog_style_schemes_type_id__volatile = 0;
	if (g_once_init_enter (&preferences_dialog_style_schemes_type_id__volatile)) {
		static const GEnumValue values[] = {{PREFERENCES_DIALOG_STYLE_SCHEMES_ID, "PREFERENCES_DIALOG_STYLE_SCHEMES_ID", "id"}, {PREFERENCES_DIALOG_STYLE_SCHEMES_DESC, "PREFERENCES_DIALOG_STYLE_SCHEMES_DESC", "desc"}, {PREFERENCES_DIALOG_STYLE_SCHEMES_N_COLUMNS, "PREFERENCES_DIALOG_STYLE_SCHEMES_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType preferences_dialog_style_schemes_type_id;
		preferences_dialog_style_schemes_type_id = g_enum_register_static ("PreferencesDialogStyleSchemes", values);
		g_once_init_leave (&preferences_dialog_style_schemes_type_id__volatile, preferences_dialog_style_schemes_type_id);
	}
	return preferences_dialog_style_schemes_type_id__volatile;
}


static GType preferences_dialog_build_tool_column_get_type (void) {
	static volatile gsize preferences_dialog_build_tool_column_type_id__volatile = 0;
	if (g_once_init_enter (&preferences_dialog_build_tool_column_type_id__volatile)) {
		static const GEnumValue values[] = {{PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_SHOW, "PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_SHOW", "show"}, {PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_PIXBUF, "PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_PIXBUF", "pixbuf"}, {PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_LABEL, "PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_LABEL", "label"}, {PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_DESCRIPTION, "PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_DESCRIPTION", "description"}, {PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_N_COLUMNS, "PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType preferences_dialog_build_tool_column_type_id;
		preferences_dialog_build_tool_column_type_id = g_enum_register_static ("PreferencesDialogBuildToolColumn", values);
		g_once_init_leave (&preferences_dialog_build_tool_column_type_id__volatile, preferences_dialog_build_tool_column_type_id);
	}
	return preferences_dialog_build_tool_column_type_id__volatile;
}


static void __lambda79_ (PreferencesDialog* self, gint response_id) {
	gint _tmp0_;
	_tmp0_ = response_id;
	switch (_tmp0_) {
		case GTK_RESPONSE_CLOSE:
		{
			gtk_widget_hide ((GtkWidget*) self);
			return;
		}
		case GTK_RESPONSE_APPLY:
		{
			preferences_dialog_reset_all (self);
			return;
		}
		default:
		break;
	}
}


static void ___lambda79__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda79_ (self, response_id);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static PreferencesDialog* preferences_dialog_construct (GType object_type) {
	PreferencesDialog * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	GtkButton* reset_button;
	GtkImage* _tmp4_;
	GtkImage* _tmp5_;
	GtkImage* image;
	GtkButton* _tmp6_;
	GtkImage* _tmp7_;
	GtkButton* _tmp8_;
	const gchar* _tmp9_ = NULL;
	GtkButton* _tmp10_;
	GtkButton* _tmp11_;
	GtkBuilder* _tmp12_;
	GtkBuilder* builder;
	GtkBuilder* _tmp29_;
	GtkBuilder* _tmp30_;
	GtkBuilder* _tmp31_;
	GtkBuilder* _tmp32_;
	GtkBuilder* _tmp33_;
	GObject* _tmp34_ = NULL;
	GtkNotebook* _tmp35_;
	GtkNotebook* notebook;
	GtkNotebook* _tmp36_;
	GtkBox* _tmp37_ = NULL;
	GtkBox* _tmp38_;
	GtkBox* content_area;
	GtkBox* _tmp39_;
	GtkNotebook* _tmp40_;
	GError * _inner_error_ = NULL;
	self = (PreferencesDialog*) g_object_new (object_type, NULL);
	_tmp0_ = _ ("Preferences");
	gtk_window_set_title ((GtkWindow*) self, _tmp0_);
	gtk_window_set_destroy_with_parent ((GtkWindow*) self, TRUE);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 5);
	_tmp1_ = _ ("Reset All");
	_tmp2_ = (GtkButton*) gtk_button_new_with_label (_tmp1_);
	_tmp3_ = g_object_ref_sink (_tmp2_);
	reset_button = _tmp3_;
	_tmp4_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_CLEAR, GTK_ICON_SIZE_MENU);
	_tmp5_ = g_object_ref_sink (_tmp4_);
	image = _tmp5_;
	_tmp6_ = reset_button;
	_tmp7_ = image;
	gtk_button_set_image (_tmp6_, (GtkWidget*) _tmp7_);
	_tmp8_ = reset_button;
	_tmp9_ = _ ("Reset all preferences");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp8_, _tmp9_);
	_tmp10_ = reset_button;
	gtk_widget_show_all ((GtkWidget*) _tmp10_);
	_tmp11_ = reset_button;
	gtk_dialog_add_action_widget ((GtkDialog*) self, (GtkWidget*) _tmp11_, (gint) GTK_RESPONSE_APPLY);
	gtk_dialog_add_button ((GtkDialog*) self, GTK_STOCK_CLOSE, (gint) GTK_RESPONSE_CLOSE);
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) ___lambda79__gtk_dialog_response, self, 0);
	_tmp12_ = gtk_builder_new ();
	builder = _tmp12_;
	{
		gchar* _tmp13_ = NULL;
		gchar* ui_path;
		GtkBuilder* _tmp14_;
		const gchar* _tmp15_;
		_tmp13_ = g_build_filename (DATA_DIR, "ui", "preferences_dialog.ui", NULL);
		ui_path = _tmp13_;
		_tmp14_ = builder;
		_tmp15_ = ui_path;
		gtk_builder_add_from_file (_tmp14_, _tmp15_, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (ui_path);
			goto __catch52_g_error;
		}
		_g_free0 (ui_path);
	}
	goto __finally52;
	__catch52_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* message;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		GtkLabel* _tmp21_;
		GtkLabel* _tmp22_;
		GtkLabel* label_error;
		GtkLabel* _tmp23_;
		GtkBox* _tmp24_ = NULL;
		GtkBox* _tmp25_;
		GtkBox* content_area;
		GtkBox* _tmp26_;
		GtkLabel* _tmp27_;
		GtkBox* _tmp28_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		_tmp18_ = g_strdup_printf ("Error: %s", _tmp17_);
		message = _tmp18_;
		_tmp19_ = message;
		g_warning ("preferences_dialog.vala:73: %s", _tmp19_);
		_tmp20_ = message;
		_tmp21_ = (GtkLabel*) gtk_label_new (_tmp20_);
		_tmp22_ = g_object_ref_sink (_tmp21_);
		label_error = _tmp22_;
		_tmp23_ = label_error;
		gtk_label_set_line_wrap (_tmp23_, TRUE);
		_tmp24_ = gtk_dialog_get_content_area ((GtkDialog*) self);
		_tmp25_ = _g_object_ref0 (GTK_BOX (_tmp24_));
		content_area = _tmp25_;
		_tmp26_ = content_area;
		_tmp27_ = label_error;
		gtk_box_pack_start (_tmp26_, (GtkWidget*) _tmp27_, TRUE, TRUE, (guint) 0);
		_tmp28_ = content_area;
		gtk_widget_show_all ((GtkWidget*) _tmp28_);
		_g_object_unref0 (content_area);
		_g_object_unref0 (label_error);
		_g_free0 (message);
		_g_error_free0 (e);
		_g_object_unref0 (builder);
		_g_object_unref0 (image);
		_g_object_unref0 (reset_button);
		return self;
	}
	__finally52:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		_g_object_unref0 (image);
		_g_object_unref0 (reset_button);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp29_ = builder;
	preferences_dialog_init_editor_tab (self, _tmp29_);
	_tmp30_ = builder;
	preferences_dialog_init_font_and_colors_tab (self, _tmp30_);
	_tmp31_ = builder;
	preferences_dialog_init_latex_tab (self, _tmp31_);
	_tmp32_ = builder;
	preferences_dialog_init_other_tab (self, _tmp32_);
	_tmp33_ = builder;
	_tmp34_ = gtk_builder_get_object (_tmp33_, "notebook");
	_tmp35_ = _g_object_ref0 (GTK_IS_NOTEBOOK (_tmp34_) ? ((GtkNotebook*) _tmp34_) : NULL);
	notebook = _tmp35_;
	_tmp36_ = notebook;
	gtk_widget_unparent ((GtkWidget*) _tmp36_);
	_tmp37_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp38_ = _g_object_ref0 (GTK_BOX (_tmp37_));
	content_area = _tmp38_;
	_tmp39_ = content_area;
	_tmp40_ = notebook;
	gtk_box_pack_start (_tmp39_, (GtkWidget*) _tmp40_, TRUE, TRUE, (guint) 0);
	_g_object_unref0 (content_area);
	_g_object_unref0 (notebook);
	_g_object_unref0 (builder);
	_g_object_unref0 (image);
	_g_object_unref0 (reset_button);
	return self;
}


static PreferencesDialog* preferences_dialog_new (void) {
	return preferences_dialog_construct (TYPE_PREFERENCES_DIALOG);
}


static void ___lambda103_ (void) {
	PreferencesDialog* _tmp0_;
	_tmp0_ = preferences_dialog_preferences_dialog;
	if (_tmp0_ != NULL) {
		_g_object_unref0 (preferences_dialog_preferences_dialog);
		preferences_dialog_preferences_dialog = NULL;
	}
}


static void ____lambda103__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	___lambda103_ ();
}


void preferences_dialog_show_me (MainWindow* parent) {
	PreferencesDialog* _tmp0_;
	MainWindow* _tmp4_;
	PreferencesDialog* _tmp5_;
	GtkWindow* _tmp6_ = NULL;
	PreferencesDialog* _tmp9_;
	g_return_if_fail (parent != NULL);
	_tmp0_ = preferences_dialog_preferences_dialog;
	if (_tmp0_ == NULL) {
		PreferencesDialog* _tmp1_;
		PreferencesDialog* _tmp2_;
		PreferencesDialog* _tmp3_;
		_tmp1_ = preferences_dialog_new ();
		_tmp2_ = g_object_ref_sink (_tmp1_);
		_g_object_unref0 (preferences_dialog_preferences_dialog);
		preferences_dialog_preferences_dialog = _tmp2_;
		_tmp3_ = preferences_dialog_preferences_dialog;
		g_signal_connect ((GtkWidget*) _tmp3_, "destroy", (GCallback) ____lambda103__gtk_widget_destroy, NULL);
	}
	_tmp4_ = parent;
	_tmp5_ = preferences_dialog_preferences_dialog;
	_tmp6_ = gtk_window_get_transient_for ((GtkWindow*) _tmp5_);
	if (GTK_WINDOW (_tmp4_) != _tmp6_) {
		PreferencesDialog* _tmp7_;
		MainWindow* _tmp8_;
		_tmp7_ = preferences_dialog_preferences_dialog;
		_tmp8_ = parent;
		gtk_window_set_transient_for ((GtkWindow*) _tmp7_, (GtkWindow*) _tmp8_);
	}
	_tmp9_ = preferences_dialog_preferences_dialog;
	gtk_window_present ((GtkWindow*) _tmp9_);
}


static void preferences_dialog_reset_all (PreferencesDialog* self) {
	const gchar* _tmp0_ = NULL;
	GtkDialog* _tmp1_ = NULL;
	GtkDialog* dialog;
	GtkDialog* _tmp2_;
	gint _tmp3_ = 0;
	gint resp;
	GtkDialog* _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar** _tmp9_ = NULL;
	gchar** settings_str;
	gint settings_str_length1;
	gint _settings_str_size_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("Do you really want to reset all preferences?");
	_tmp1_ = preferences_dialog_get_reset_all_confirm_dialog (self, _tmp0_);
	dialog = _tmp1_;
	_tmp2_ = dialog;
	_tmp3_ = gtk_dialog_run (_tmp2_);
	resp = _tmp3_;
	_tmp4_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp4_);
	_tmp5_ = resp;
	if (_tmp5_ != ((gint) GTK_RESPONSE_YES)) {
		_g_object_unref0 (dialog);
		return;
	}
	_tmp6_ = g_strdup ("org.gnome.latexila.preferences.editor");
	_tmp7_ = g_strdup ("org.gnome.latexila.preferences.latex");
	_tmp8_ = g_strdup ("org.gnome.latexila.preferences.file-browser");
	_tmp9_ = g_new0 (gchar*, 3 + 1);
	_tmp9_[0] = _tmp6_;
	_tmp9_[1] = _tmp7_;
	_tmp9_[2] = _tmp8_;
	settings_str = _tmp9_;
	settings_str_length1 = 3;
	_settings_str_size_ = settings_str_length1;
	_tmp10_ = settings_str;
	_tmp10__length1 = settings_str_length1;
	{
		gchar** setting_str_collection = NULL;
		gint setting_str_collection_length1 = 0;
		gint _setting_str_collection_size_ = 0;
		gint setting_str_it = 0;
		setting_str_collection = _tmp10_;
		setting_str_collection_length1 = _tmp10__length1;
		for (setting_str_it = 0; setting_str_it < _tmp10__length1; setting_str_it = setting_str_it + 1) {
			gchar* _tmp11_;
			gchar* setting_str = NULL;
			_tmp11_ = g_strdup (setting_str_collection[setting_str_it]);
			setting_str = _tmp11_;
			{
				const gchar* _tmp12_;
				GSettings* _tmp13_;
				GSettings* settings;
				GSettings* _tmp14_;
				gchar** _tmp15_;
				gchar** _tmp16_ = NULL;
				gchar** keys;
				gint keys_length1;
				gint _keys_size_;
				gchar** _tmp17_;
				gint _tmp17__length1;
				_tmp12_ = setting_str;
				_tmp13_ = g_settings_new (_tmp12_);
				settings = _tmp13_;
				_tmp14_ = settings;
				_tmp16_ = _tmp15_ = g_settings_list_keys (_tmp14_);
				keys = _tmp16_;
				keys_length1 = _vala_array_length (_tmp15_);
				_keys_size_ = keys_length1;
				_tmp17_ = keys;
				_tmp17__length1 = keys_length1;
				{
					gchar** key_collection = NULL;
					gint key_collection_length1 = 0;
					gint _key_collection_size_ = 0;
					gint key_it = 0;
					key_collection = _tmp17_;
					key_collection_length1 = _tmp17__length1;
					for (key_it = 0; key_it < _tmp17__length1; key_it = key_it + 1) {
						gchar* _tmp18_;
						gchar* key = NULL;
						_tmp18_ = g_strdup (key_collection[key_it]);
						key = _tmp18_;
						{
							GSettings* _tmp19_;
							const gchar* _tmp20_;
							_tmp19_ = settings;
							_tmp20_ = key;
							g_settings_reset (_tmp19_, _tmp20_);
							_g_free0 (key);
						}
					}
				}
				keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (settings);
				_g_free0 (setting_str);
			}
		}
	}
	settings_str = (_vala_array_free (settings_str, settings_str_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (dialog);
}


static const gchar* __lambda82_ (PreferencesDialog* self, gulong n) {
	const gchar* result = NULL;
	gulong _tmp0_;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = n;
	_tmp1_ = ngettext ("minute", "minutes", _tmp0_);
	result = _tmp1_;
	return result;
}


static const gchar* ___lambda82__preferences_dialog_plural (gulong n, gpointer self) {
	const gchar* result;
	result = __lambda82_ (self, n);
	return result;
}


static void preferences_dialog_init_editor_tab (PreferencesDialog* self, GtkBuilder* builder) {
	GSettings* _tmp0_;
	GSettings* settings;
	GtkBuilder* _tmp1_;
	GObject* _tmp2_ = NULL;
	GObject* _tmp3_;
	GObject* display_line_nb_checkbutton;
	GtkBuilder* _tmp4_;
	GObject* _tmp5_ = NULL;
	GtkSpinButton* _tmp6_;
	GtkSpinButton* tab_width_spinbutton;
	GtkBuilder* _tmp7_;
	GObject* _tmp8_ = NULL;
	GObject* _tmp9_;
	GObject* insert_spaces_checkbutton;
	GtkBuilder* _tmp10_;
	GObject* _tmp11_ = NULL;
	GtkWidget* _tmp12_;
	GtkWidget* forget_no_tabs;
	GtkBuilder* _tmp13_;
	GObject* _tmp14_ = NULL;
	GObject* _tmp15_;
	GObject* hl_current_line_checkbutton;
	GtkBuilder* _tmp16_;
	GObject* _tmp17_ = NULL;
	GObject* _tmp18_;
	GObject* bracket_matching_checkbutton;
	GtkBuilder* _tmp19_;
	GObject* _tmp20_ = NULL;
	GObject* _tmp21_;
	GObject* backup_checkbutton;
	GtkBuilder* _tmp22_;
	GObject* _tmp23_ = NULL;
	GObject* _tmp24_;
	GObject* autosave_checkbutton;
	GtkBuilder* _tmp25_;
	GObject* _tmp26_ = NULL;
	GtkSpinButton* _tmp27_;
	GtkSpinButton* autosave_spinbutton;
	GtkBuilder* _tmp28_;
	GObject* _tmp29_ = NULL;
	GtkLabel* _tmp30_;
	GtkLabel* autosave_label;
	GtkBuilder* _tmp31_;
	GObject* _tmp32_ = NULL;
	GObject* _tmp33_;
	GObject* reopen_checkbutton;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_tmp0_ = g_settings_new ("org.gnome.latexila.preferences.editor");
	settings = _tmp0_;
	_tmp1_ = builder;
	_tmp2_ = gtk_builder_get_object (_tmp1_, "display_line_nb_checkbutton");
	_tmp3_ = _g_object_ref0 (_tmp2_);
	display_line_nb_checkbutton = _tmp3_;
	g_settings_bind (settings, "display-line-numbers", display_line_nb_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp4_ = builder;
	_tmp5_ = gtk_builder_get_object (_tmp4_, "tab_width_spinbutton");
	_tmp6_ = _g_object_ref0 (GTK_IS_SPIN_BUTTON (_tmp5_) ? ((GtkSpinButton*) _tmp5_) : NULL);
	tab_width_spinbutton = _tmp6_;
	preferences_dialog_set_spin_button_range (self, tab_width_spinbutton, settings, "tabs-size");
	g_settings_bind (settings, "tabs-size", (GObject*) tab_width_spinbutton, "value", G_SETTINGS_BIND_DEFAULT);
	_tmp7_ = builder;
	_tmp8_ = gtk_builder_get_object (_tmp7_, "insert_spaces_checkbutton");
	_tmp9_ = _g_object_ref0 (_tmp8_);
	insert_spaces_checkbutton = _tmp9_;
	g_settings_bind (settings, "insert-spaces", insert_spaces_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp10_ = builder;
	_tmp11_ = gtk_builder_get_object (_tmp10_, "forget_no_tabs");
	_tmp12_ = _g_object_ref0 (GTK_IS_WIDGET (_tmp11_) ? ((GtkWidget*) _tmp11_) : NULL);
	forget_no_tabs = _tmp12_;
	g_settings_bind (settings, "forget-no-tabs", (GObject*) forget_no_tabs, "active", G_SETTINGS_BIND_DEFAULT);
	preferences_dialog_set_sensitivity (self, settings, "insert-spaces", forget_no_tabs, TRUE);
	_tmp13_ = builder;
	_tmp14_ = gtk_builder_get_object (_tmp13_, "hl_current_line_checkbutton");
	_tmp15_ = _g_object_ref0 (_tmp14_);
	hl_current_line_checkbutton = _tmp15_;
	g_settings_bind (settings, "highlight-current-line", hl_current_line_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp16_ = builder;
	_tmp17_ = gtk_builder_get_object (_tmp16_, "bracket_matching_checkbutton");
	_tmp18_ = _g_object_ref0 (_tmp17_);
	bracket_matching_checkbutton = _tmp18_;
	g_settings_bind (settings, "bracket-matching", bracket_matching_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp19_ = builder;
	_tmp20_ = gtk_builder_get_object (_tmp19_, "backup_checkbutton");
	_tmp21_ = _g_object_ref0 (_tmp20_);
	backup_checkbutton = _tmp21_;
	g_settings_bind (settings, "create-backup-copy", backup_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp22_ = builder;
	_tmp23_ = gtk_builder_get_object (_tmp22_, "autosave_checkbutton");
	_tmp24_ = _g_object_ref0 (_tmp23_);
	autosave_checkbutton = _tmp24_;
	g_settings_bind (settings, "auto-save", autosave_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp25_ = builder;
	_tmp26_ = gtk_builder_get_object (_tmp25_, "autosave_spinbutton");
	_tmp27_ = _g_object_ref0 (GTK_IS_SPIN_BUTTON (_tmp26_) ? ((GtkSpinButton*) _tmp26_) : NULL);
	autosave_spinbutton = _tmp27_;
	preferences_dialog_set_spin_button_range (self, autosave_spinbutton, settings, "auto-save-interval");
	g_settings_bind (settings, "auto-save-interval", (GObject*) autosave_spinbutton, "value", G_SETTINGS_BIND_DEFAULT);
	preferences_dialog_set_sensitivity (self, settings, "auto-save", (GtkWidget*) autosave_spinbutton, TRUE);
	_tmp28_ = builder;
	_tmp29_ = gtk_builder_get_object (_tmp28_, "autosave_label");
	_tmp30_ = _g_object_ref0 (GTK_IS_LABEL (_tmp29_) ? ((GtkLabel*) _tmp29_) : NULL);
	autosave_label = _tmp30_;
	preferences_dialog_set_plural (self, autosave_label, settings, "auto-save-interval", ___lambda82__preferences_dialog_plural, self);
	_tmp31_ = builder;
	_tmp32_ = gtk_builder_get_object (_tmp31_, "reopen_checkbutton");
	_tmp33_ = _g_object_ref0 (_tmp32_);
	reopen_checkbutton = _tmp33_;
	g_settings_bind (settings, "reopen-files", reopen_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (reopen_checkbutton);
	_g_object_unref0 (autosave_label);
	_g_object_unref0 (autosave_spinbutton);
	_g_object_unref0 (autosave_checkbutton);
	_g_object_unref0 (backup_checkbutton);
	_g_object_unref0 (bracket_matching_checkbutton);
	_g_object_unref0 (hl_current_line_checkbutton);
	_g_object_unref0 (forget_no_tabs);
	_g_object_unref0 (insert_spaces_checkbutton);
	_g_object_unref0 (tab_width_spinbutton);
	_g_object_unref0 (display_line_nb_checkbutton);
	_g_object_unref0 (settings);
}


static Block18Data* block18_data_ref (Block18Data* _data18_) {
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}


static void block18_data_unref (void * _userdata_) {
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		PreferencesDialog * self;
		self = _data18_->self;
		_g_object_unref0 (_data18_->schemes_select);
		_g_object_unref0 (_data18_->schemes_treeview);
		_g_object_unref0 (_data18_->default_font_checkbutton);
		_g_object_unref0 (_data18_->settings);
		_g_object_unref0 (self);
		g_slice_free (Block18Data, _data18_);
	}
}


static void __lambda83_ (Block18Data* _data18_) {
	PreferencesDialog * self;
	self = _data18_->self;
	preferences_dialog_set_system_font_label (self, _data18_->default_font_checkbutton);
}


static void ___lambda83__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda83_ (self);
}


static void _gtk_tree_path_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL));
}


static void _g_list_free__gtk_tree_path_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gtk_tree_path_free0_, NULL);
	g_list_free (self);
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


static void __lambda84_ (Block18Data* _data18_) {
	PreferencesDialog * self;
	GtkTreeModel* model = NULL;
	GtkTreeModel* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GList* rows;
	GList* _tmp2_;
	guint _tmp3_ = 0U;
	GList* _tmp4_;
	gconstpointer _tmp5_ = NULL;
	GtkTreePath* _tmp6_;
	GtkTreePath* path;
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp7_;
	GtkTreePath* _tmp8_;
	GtkTreeIter _tmp9_ = {0};
	gchar* id = NULL;
	GtkTreeModel* _tmp10_;
	GtkTreeIter _tmp11_;
	const gchar* _tmp12_;
	self = _data18_->self;
	_tmp1_ = gtk_tree_selection_get_selected_rows (_data18_->schemes_select, &_tmp0_);
	model = _tmp0_;
	rows = _tmp1_;
	_tmp2_ = rows;
	_tmp3_ = g_list_length (_tmp2_);
	if (_tmp3_ != ((guint) 1)) {
		__g_list_free__gtk_tree_path_free0_0 (rows);
		return;
	}
	_tmp4_ = rows;
	_tmp5_ = g_list_nth_data (_tmp4_, (guint) 0);
	_tmp6_ = _gtk_tree_path_copy0 ((GtkTreePath*) _tmp5_);
	path = _tmp6_;
	_tmp7_ = model;
	_tmp8_ = path;
	gtk_tree_model_get_iter (_tmp7_, &_tmp9_, _tmp8_);
	iter = _tmp9_;
	_tmp10_ = model;
	_tmp11_ = iter;
	gtk_tree_model_get (_tmp10_, &_tmp11_, PREFERENCES_DIALOG_STYLE_SCHEMES_ID, &id, -1);
	_tmp12_ = id;
	g_settings_set_string (_data18_->settings, "scheme", _tmp12_);
	_g_free0 (id);
	_gtk_tree_path_free0 (path);
	__g_list_free__gtk_tree_path_free0_0 (rows);
}


static void ___lambda84__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	__lambda84_ (self);
}


static void __lambda85_ (Block18Data* _data18_, GSettings* setting, const gchar* key) {
	PreferencesDialog * self;
	GSettings* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* val;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeModel* model;
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp6_;
	GtkTreeIter _tmp7_ = {0};
	gboolean _tmp8_ = FALSE;
	gboolean valid;
	self = _data18_->self;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = setting;
	_tmp1_ = key;
	_tmp2_ = g_settings_get_string (_tmp0_, _tmp1_);
	val = _tmp2_;
	_tmp3_ = gtk_tree_view_get_model (_data18_->schemes_treeview);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	model = _tmp5_;
	_tmp6_ = model;
	_tmp8_ = gtk_tree_model_get_iter_first (_tmp6_, &_tmp7_);
	iter = _tmp7_;
	valid = _tmp8_;
	while (TRUE) {
		gboolean _tmp9_;
		gchar* scheme = NULL;
		GtkTreeModel* _tmp10_;
		GtkTreeIter _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		GtkTreeModel* _tmp18_;
		gboolean _tmp19_ = FALSE;
		_tmp9_ = valid;
		if (!_tmp9_) {
			break;
		}
		_tmp10_ = model;
		_tmp11_ = iter;
		gtk_tree_model_get (_tmp10_, &_tmp11_, PREFERENCES_DIALOG_STYLE_SCHEMES_ID, &scheme, -1, -1);
		_tmp12_ = scheme;
		_tmp13_ = val;
		if (g_strcmp0 (_tmp12_, _tmp13_) == 0) {
			GtkTreeSelection* _tmp14_ = NULL;
			GtkTreeSelection* _tmp15_;
			GtkTreeSelection* select;
			GtkTreeSelection* _tmp16_;
			GtkTreeIter _tmp17_;
			_tmp14_ = gtk_tree_view_get_selection (_data18_->schemes_treeview);
			_tmp15_ = _g_object_ref0 (_tmp14_);
			select = _tmp15_;
			_tmp16_ = select;
			_tmp17_ = iter;
			gtk_tree_selection_select_iter (_tmp16_, &_tmp17_);
			_g_object_unref0 (select);
			_g_free0 (scheme);
			_g_object_unref0 (model);
			_g_free0 (val);
			return;
		}
		_tmp18_ = model;
		_tmp19_ = gtk_tree_model_iter_next (_tmp18_, &iter);
		valid = _tmp19_;
		_g_free0 (scheme);
	}
	_g_object_unref0 (model);
	_g_free0 (val);
}


static void ___lambda85__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda85_ (self, _sender, key);
}


static void preferences_dialog_init_font_and_colors_tab (PreferencesDialog* self, GtkBuilder* builder) {
	Block18Data* _data18_;
	GSettings* _tmp0_;
	GtkBuilder* _tmp1_;
	GObject* _tmp2_ = NULL;
	GtkButton* _tmp3_;
	AppSettings* _tmp4_ = NULL;
	AppSettings* app_settings;
	GtkBuilder* _tmp5_;
	GObject* _tmp6_ = NULL;
	GObject* _tmp7_;
	GObject* font_button;
	GtkBuilder* _tmp8_;
	GObject* _tmp9_ = NULL;
	GtkWidget* _tmp10_;
	GtkWidget* font_hbox;
	GtkBuilder* _tmp11_;
	GObject* _tmp12_ = NULL;
	GtkTreeView* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* current_scheme_id;
	GtkTreeSelection* _tmp15_ = NULL;
	GtkTreeSelection* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_data18_ = g_slice_new0 (Block18Data);
	_data18_->_ref_count_ = 1;
	_data18_->self = g_object_ref (self);
	_tmp0_ = g_settings_new ("org.gnome.latexila.preferences.editor");
	_data18_->settings = _tmp0_;
	_tmp1_ = builder;
	_tmp2_ = gtk_builder_get_object (_tmp1_, "default_font_checkbutton");
	_tmp3_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp2_) ? ((GtkButton*) _tmp2_) : NULL);
	_data18_->default_font_checkbutton = _tmp3_;
	g_settings_bind (_data18_->settings, "use-default-font", (GObject*) _data18_->default_font_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	preferences_dialog_set_system_font_label (self, _data18_->default_font_checkbutton);
	_tmp4_ = app_settings_get_default ();
	app_settings = _tmp4_;
	g_signal_connect_data ((GObject*) app_settings, "notify::system-font", (GCallback) ___lambda83__g_object_notify, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
	_tmp5_ = builder;
	_tmp6_ = gtk_builder_get_object (_tmp5_, "font_button");
	_tmp7_ = _g_object_ref0 (_tmp6_);
	font_button = _tmp7_;
	g_settings_bind (_data18_->settings, "editor-font", font_button, "font-name", G_SETTINGS_BIND_DEFAULT);
	_tmp8_ = builder;
	_tmp9_ = gtk_builder_get_object (_tmp8_, "font_hbox");
	_tmp10_ = _g_object_ref0 (GTK_IS_WIDGET (_tmp9_) ? ((GtkWidget*) _tmp9_) : NULL);
	font_hbox = _tmp10_;
	preferences_dialog_set_sensitivity (self, _data18_->settings, "use-default-font", font_hbox, FALSE);
	_tmp11_ = builder;
	_tmp12_ = gtk_builder_get_object (_tmp11_, "schemes_treeview");
	_tmp13_ = _g_object_ref0 (GTK_IS_TREE_VIEW (_tmp12_) ? ((GtkTreeView*) _tmp12_) : NULL);
	_data18_->schemes_treeview = _tmp13_;
	_tmp14_ = g_settings_get_string (_data18_->settings, "scheme");
	current_scheme_id = _tmp14_;
	preferences_dialog_init_schemes_treeview (self, _data18_->schemes_treeview, current_scheme_id);
	_tmp15_ = gtk_tree_view_get_selection (_data18_->schemes_treeview);
	_tmp16_ = _g_object_ref0 (_tmp15_);
	_data18_->schemes_select = _tmp16_;
	g_signal_connect_data (_data18_->schemes_select, "changed", (GCallback) ___lambda84__gtk_tree_selection_changed, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
	g_signal_connect_data (_data18_->settings, "changed::scheme", (GCallback) ___lambda85__g_settings_changed, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
	_g_free0 (current_scheme_id);
	_g_object_unref0 (font_hbox);
	_g_object_unref0 (font_button);
	_g_object_unref0 (app_settings);
	block18_data_unref (_data18_);
	_data18_ = NULL;
}


static Block19Data* block19_data_ref (Block19Data* _data19_) {
	g_atomic_int_inc (&_data19_->_ref_count_);
	return _data19_;
}


static void block19_data_unref (void * _userdata_) {
	Block19Data* _data19_;
	_data19_ = (Block19Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
		PreferencesDialog * self;
		self = _data19_->self;
		_g_object_unref0 (_data19_->build_tools_view);
		_g_object_unref0 (self);
		g_slice_free (Block19Data, _data19_);
	}
}


static const gchar* __lambda86_ (PreferencesDialog* self, gulong n) {
	const gchar* result = NULL;
	gulong _tmp0_;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = n;
	_tmp1_ = ngettext ("character", "characters", _tmp0_);
	result = _tmp1_;
	return result;
}


static const gchar* ___lambda86__preferences_dialog_plural (gulong n, gpointer self) {
	const gchar* result;
	result = __lambda86_ (self, n);
	return result;
}


static void __lambda96_ (Block19Data* _data19_) {
	PreferencesDialog * self;
	gint _tmp0_ = 0;
	gint num;
	gint _tmp1_;
	self = _data19_->self;
	_tmp0_ = utils_get_selected_row (_data19_->build_tools_view, NULL);
	num = _tmp0_;
	_tmp1_ = num;
	if (0 <= _tmp1_) {
		gint _tmp2_;
		_tmp2_ = num;
		preferences_dialog_run_build_tool_dialog (self, _tmp2_);
	}
}


static void ___lambda96__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda96_ (self);
}


static void __lambda97_ (PreferencesDialog* self) {
	preferences_dialog_run_build_tool_dialog (self, -1);
}


static void ___lambda97__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda97_ (self);
}


static void __lambda98_ (Block19Data* _data19_) {
	PreferencesDialog * self;
	gint _tmp0_ = 0;
	gint selected_row;
	gint _tmp1_;
	BuildTools* _tmp2_ = NULL;
	BuildTools* build_tools;
	BuildTools* _tmp3_;
	gint _tmp4_;
	BuildTool* _tmp5_ = NULL;
	BuildTool* tool;
	BuildTool* _tmp6_;
	BuildTool* _tmp7_;
	BuildTool* _tmp8_;
	const gchar* _tmp9_ = NULL;
	BuildTool* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	BuildTools* _tmp13_;
	gint _tmp14_;
	BuildTool* _tmp15_;
	BuildTool _tmp16_;
	self = _data19_->self;
	_tmp0_ = utils_get_selected_row (_data19_->build_tools_view, NULL);
	selected_row = _tmp0_;
	_tmp1_ = selected_row;
	if (_tmp1_ < 0) {
		return;
	}
	_tmp2_ = build_tools_get_default ();
	build_tools = _tmp2_;
	_tmp3_ = build_tools;
	_tmp4_ = selected_row;
	_tmp5_ = build_tools_get (_tmp3_, _tmp4_);
	tool = _tmp5_;
	_tmp6_ = tool;
	g_return_if_fail (_tmp6_ != NULL);
	_tmp7_ = tool;
	(*_tmp7_).show = FALSE;
	_tmp8_ = tool;
	_tmp9_ = _ ("%s [copy]");
	_tmp10_ = tool;
	_tmp11_ = (*_tmp10_).label;
	_tmp12_ = g_strdup_printf (_tmp9_, _tmp11_);
	_g_free0 ((*_tmp8_).label);
	(*_tmp8_).label = _tmp12_;
	_tmp13_ = build_tools;
	_tmp14_ = selected_row;
	_tmp15_ = tool;
	_tmp16_ = *_tmp15_;
	build_tools_insert (_tmp13_, _tmp14_ + 1, &_tmp16_);
	preferences_dialog_update_build_tools_store (self);
	_build_tool_free0 (tool);
	_build_tools_unref0 (build_tools);
}


static void ___lambda98__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda98_ (self);
}


static void __lambda99_ (Block19Data* _data19_) {
	PreferencesDialog * self;
	GtkTreeIter iter1 = {0};
	GtkTreeIter iter2 = {0};
	GtkTreeIter _tmp0_ = {0};
	gint _tmp1_ = 0;
	gint i;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_;
	gboolean _tmp5_;
	self = _data19_->self;
	_tmp1_ = utils_get_selected_row (_data19_->build_tools_view, &_tmp0_);
	iter1 = _tmp0_;
	i = _tmp1_;
	_tmp3_ = i;
	if (_tmp3_ != (-1)) {
		gint _tmp4_;
		_tmp4_ = i;
		_tmp2_ = _tmp4_ > 0;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		GtkTreeIter _tmp6_;
		GtkListStore* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp6_ = iter1;
		iter2 = _tmp6_;
		_tmp7_ = self->priv->build_tools_store;
		_tmp8_ = utils_tree_model_iter_prev ((GtkTreeModel*) _tmp7_, &iter2);
		if (_tmp8_) {
			GtkListStore* _tmp9_;
			GtkTreeIter _tmp10_;
			GtkTreeIter _tmp11_;
			BuildTools* _tmp12_ = NULL;
			BuildTools* _tmp13_;
			gint _tmp14_;
			_tmp9_ = self->priv->build_tools_store;
			_tmp10_ = iter1;
			_tmp11_ = iter2;
			gtk_list_store_swap (_tmp9_, &_tmp10_, &_tmp11_);
			_tmp12_ = build_tools_get_default ();
			_tmp13_ = _tmp12_;
			_tmp14_ = i;
			build_tools_move_up (_tmp13_, _tmp14_);
			_build_tools_unref0 (_tmp13_);
		}
	}
}


static void ___lambda99__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda99_ (self);
}


static void __lambda100_ (Block19Data* _data19_) {
	PreferencesDialog * self;
	GtkTreeIter iter1 = {0};
	GtkTreeIter iter2 = {0};
	GtkTreeIter _tmp0_ = {0};
	gint _tmp1_ = 0;
	gint i;
	gint _tmp2_;
	self = _data19_->self;
	_tmp1_ = utils_get_selected_row (_data19_->build_tools_view, &_tmp0_);
	iter1 = _tmp0_;
	i = _tmp1_;
	_tmp2_ = i;
	if (_tmp2_ != (-1)) {
		GtkTreeIter _tmp3_;
		GtkListStore* _tmp4_;
		gboolean _tmp5_ = FALSE;
		_tmp3_ = iter1;
		iter2 = _tmp3_;
		_tmp4_ = self->priv->build_tools_store;
		_tmp5_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp4_, &iter2);
		if (_tmp5_) {
			GtkListStore* _tmp6_;
			GtkTreeIter _tmp7_;
			GtkTreeIter _tmp8_;
			BuildTools* _tmp9_ = NULL;
			BuildTools* _tmp10_;
			gint _tmp11_;
			_tmp6_ = self->priv->build_tools_store;
			_tmp7_ = iter1;
			_tmp8_ = iter2;
			gtk_list_store_swap (_tmp6_, &_tmp7_, &_tmp8_);
			_tmp9_ = build_tools_get_default ();
			_tmp10_ = _tmp9_;
			_tmp11_ = i;
			build_tools_move_down (_tmp10_, _tmp11_);
			_build_tools_unref0 (_tmp10_);
		}
	}
}


static void ___lambda100__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda100_ (self);
}


static void __lambda101_ (Block19Data* _data19_) {
	PreferencesDialog * self;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gint _tmp1_ = 0;
	gint selected_row;
	gint _tmp2_;
	gchar* label = NULL;
	GtkListStore* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* model;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_;
	GtkMessageDialog* _tmp9_;
	GtkDialog* _tmp10_;
	GtkDialog* dialog;
	GtkDialog* _tmp11_;
	GtkDialog* _tmp12_;
	gint _tmp13_ = 0;
	GtkDialog* _tmp19_;
	self = _data19_->self;
	_tmp1_ = utils_get_selected_row (_data19_->build_tools_view, &_tmp0_);
	iter = _tmp0_;
	selected_row = _tmp1_;
	_tmp2_ = selected_row;
	if (_tmp2_ == (-1)) {
		return;
	}
	_tmp3_ = self->priv->build_tools_store;
	_tmp4_ = _g_object_ref0 (GTK_TREE_MODEL (_tmp3_));
	model = _tmp4_;
	_tmp5_ = model;
	_tmp6_ = iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_LABEL, &label, -1, -1);
	_tmp7_ = _ ("Do you really want to delete the build tool \"%s\"?");
	_tmp8_ = label;
	_tmp9_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _tmp7_, _tmp8_);
	_tmp10_ = (GtkDialog*) g_object_ref_sink (_tmp9_);
	dialog = _tmp10_;
	_tmp11_ = dialog;
	gtk_dialog_add_buttons (_tmp11_, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_DELETE, GTK_RESPONSE_YES, NULL);
	_tmp12_ = dialog;
	_tmp13_ = gtk_dialog_run (_tmp12_);
	if (_tmp13_ == ((gint) GTK_RESPONSE_YES)) {
		GtkListStore* _tmp14_;
		GtkTreeIter _tmp15_;
		BuildTools* _tmp16_ = NULL;
		BuildTools* _tmp17_;
		gint _tmp18_;
		_tmp14_ = self->priv->build_tools_store;
		_tmp15_ = iter;
		gtk_list_store_remove (_tmp14_, &_tmp15_);
		_tmp16_ = build_tools_get_default ();
		_tmp17_ = _tmp16_;
		_tmp18_ = selected_row;
		build_tools_delete (_tmp17_, _tmp18_);
		_build_tools_unref0 (_tmp17_);
	}
	_tmp19_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp19_);
	_g_object_unref0 (dialog);
	_g_object_unref0 (model);
	_g_free0 (label);
}


static void ___lambda101__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda101_ (self);
}


static void __lambda102_ (PreferencesDialog* self) {
	const gchar* _tmp0_ = NULL;
	GtkDialog* _tmp1_ = NULL;
	GtkDialog* dialog;
	GtkDialog* _tmp2_;
	gint _tmp3_ = 0;
	GtkDialog* _tmp6_;
	_tmp0_ = _ ("Do you really want to reset all build tools?");
	_tmp1_ = preferences_dialog_get_reset_all_confirm_dialog (self, _tmp0_);
	dialog = _tmp1_;
	_tmp2_ = dialog;
	_tmp3_ = gtk_dialog_run (_tmp2_);
	if (_tmp3_ == ((gint) GTK_RESPONSE_YES)) {
		BuildTools* _tmp4_ = NULL;
		BuildTools* _tmp5_;
		_tmp4_ = build_tools_get_default ();
		_tmp5_ = _tmp4_;
		build_tools_reset_all (_tmp5_);
		_build_tools_unref0 (_tmp5_);
		preferences_dialog_update_build_tools_store (self);
	}
	_tmp6_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp6_);
	_g_object_unref0 (dialog);
}


static void ___lambda102__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda102_ (self);
}


static void preferences_dialog_init_latex_tab (PreferencesDialog* self, GtkBuilder* builder) {
	Block19Data* _data19_;
	GSettings* _tmp0_;
	GSettings* settings;
	GtkBuilder* _tmp1_;
	GObject* _tmp2_ = NULL;
	GObject* _tmp3_;
	GObject* interactive_comp_checkbutton;
	GtkBuilder* _tmp4_;
	GObject* _tmp5_ = NULL;
	GtkSpinButton* _tmp6_;
	GtkSpinButton* interactive_comp_spinbutton;
	GtkBuilder* _tmp7_;
	GObject* _tmp8_ = NULL;
	GtkLabel* _tmp9_;
	GtkLabel* interactive_comp_label;
	GtkBuilder* _tmp10_;
	GObject* _tmp11_ = NULL;
	GObject* _tmp12_;
	GObject* document_view_program;
	GtkBuilder* _tmp13_;
	GObject* _tmp14_ = NULL;
	GObject* _tmp15_;
	GObject* latexmk_checkbutton;
	GtkBuilder* _tmp16_;
	GObject* _tmp17_ = NULL;
	GtkTreeView* _tmp18_;
	GtkBuilder* _tmp19_;
	GObject* _tmp20_ = NULL;
	GtkButton* _tmp21_;
	GtkButton* bt_properties;
	GtkBuilder* _tmp22_;
	GObject* _tmp23_ = NULL;
	GtkButton* _tmp24_;
	GtkButton* bt_new;
	GtkBuilder* _tmp25_;
	GObject* _tmp26_ = NULL;
	GtkButton* _tmp27_;
	GtkButton* bt_copy;
	GtkBuilder* _tmp28_;
	GObject* _tmp29_ = NULL;
	GtkButton* _tmp30_;
	GtkButton* bt_up;
	GtkBuilder* _tmp31_;
	GObject* _tmp32_ = NULL;
	GtkButton* _tmp33_;
	GtkButton* bt_down;
	GtkBuilder* _tmp34_;
	GObject* _tmp35_ = NULL;
	GtkButton* _tmp36_;
	GtkButton* bt_delete;
	GtkBuilder* _tmp37_;
	GObject* _tmp38_ = NULL;
	GtkButton* _tmp39_;
	GtkButton* bt_reset;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_data19_ = g_slice_new0 (Block19Data);
	_data19_->_ref_count_ = 1;
	_data19_->self = g_object_ref (self);
	_tmp0_ = g_settings_new ("org.gnome.latexila.preferences.latex");
	settings = _tmp0_;
	_tmp1_ = builder;
	_tmp2_ = gtk_builder_get_object (_tmp1_, "interactive_comp_checkbutton");
	_tmp3_ = _g_object_ref0 (_tmp2_);
	interactive_comp_checkbutton = _tmp3_;
	g_settings_bind (settings, "interactive-completion", interactive_comp_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp4_ = builder;
	_tmp5_ = gtk_builder_get_object (_tmp4_, "interactive_comp_spinbutton");
	_tmp6_ = _g_object_ref0 (GTK_IS_SPIN_BUTTON (_tmp5_) ? ((GtkSpinButton*) _tmp5_) : NULL);
	interactive_comp_spinbutton = _tmp6_;
	preferences_dialog_set_spin_button_range (self, interactive_comp_spinbutton, settings, "interactive-completion-num");
	g_settings_bind (settings, "interactive-completion-num", (GObject*) interactive_comp_spinbutton, "value", G_SETTINGS_BIND_DEFAULT);
	preferences_dialog_set_sensitivity (self, settings, "interactive-completion", (GtkWidget*) interactive_comp_spinbutton, TRUE);
	_tmp7_ = builder;
	_tmp8_ = gtk_builder_get_object (_tmp7_, "interactive_comp_label");
	_tmp9_ = _g_object_ref0 (GTK_IS_LABEL (_tmp8_) ? ((GtkLabel*) _tmp8_) : NULL);
	interactive_comp_label = _tmp9_;
	preferences_dialog_set_plural (self, interactive_comp_label, settings, "interactive-completion-num", ___lambda86__preferences_dialog_plural, self);
	_tmp10_ = builder;
	_tmp11_ = gtk_builder_get_object (_tmp10_, "document_view_program");
	_tmp12_ = _g_object_ref0 (_tmp11_);
	document_view_program = _tmp12_;
	g_settings_bind (settings, "document-view-program", document_view_program, "text", G_SETTINGS_BIND_DEFAULT);
	_tmp13_ = builder;
	_tmp14_ = gtk_builder_get_object (_tmp13_, "latexmk_checkbutton");
	_tmp15_ = _g_object_ref0 (_tmp14_);
	latexmk_checkbutton = _tmp15_;
	g_settings_bind (settings, "latexmk-always-show-all", latexmk_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp16_ = builder;
	_tmp17_ = gtk_builder_get_object (_tmp16_, "build_tools_treeview");
	_tmp18_ = _g_object_ref0 (GTK_IS_TREE_VIEW (_tmp17_) ? ((GtkTreeView*) _tmp17_) : NULL);
	_data19_->build_tools_view = _tmp18_;
	preferences_dialog_init_build_tools_treeview (self, _data19_->build_tools_view);
	_tmp19_ = builder;
	_tmp20_ = gtk_builder_get_object (_tmp19_, "build_tool_properties");
	_tmp21_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp20_) ? ((GtkButton*) _tmp20_) : NULL);
	bt_properties = _tmp21_;
	g_signal_connect_data (bt_properties, "clicked", (GCallback) ___lambda96__gtk_button_clicked, block19_data_ref (_data19_), (GClosureNotify) block19_data_unref, 0);
	_tmp22_ = builder;
	_tmp23_ = gtk_builder_get_object (_tmp22_, "build_tool_new");
	_tmp24_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp23_) ? ((GtkButton*) _tmp23_) : NULL);
	bt_new = _tmp24_;
	g_signal_connect_object (bt_new, "clicked", (GCallback) ___lambda97__gtk_button_clicked, self, 0);
	_tmp25_ = builder;
	_tmp26_ = gtk_builder_get_object (_tmp25_, "build_tool_copy");
	_tmp27_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp26_) ? ((GtkButton*) _tmp26_) : NULL);
	bt_copy = _tmp27_;
	g_signal_connect_data (bt_copy, "clicked", (GCallback) ___lambda98__gtk_button_clicked, block19_data_ref (_data19_), (GClosureNotify) block19_data_unref, 0);
	_tmp28_ = builder;
	_tmp29_ = gtk_builder_get_object (_tmp28_, "build_tool_up");
	_tmp30_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp29_) ? ((GtkButton*) _tmp29_) : NULL);
	bt_up = _tmp30_;
	g_signal_connect_data (bt_up, "clicked", (GCallback) ___lambda99__gtk_button_clicked, block19_data_ref (_data19_), (GClosureNotify) block19_data_unref, 0);
	_tmp31_ = builder;
	_tmp32_ = gtk_builder_get_object (_tmp31_, "build_tool_down");
	_tmp33_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp32_) ? ((GtkButton*) _tmp32_) : NULL);
	bt_down = _tmp33_;
	g_signal_connect_data (bt_down, "clicked", (GCallback) ___lambda100__gtk_button_clicked, block19_data_ref (_data19_), (GClosureNotify) block19_data_unref, 0);
	_tmp34_ = builder;
	_tmp35_ = gtk_builder_get_object (_tmp34_, "build_tool_delete");
	_tmp36_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp35_) ? ((GtkButton*) _tmp35_) : NULL);
	bt_delete = _tmp36_;
	g_signal_connect_data (bt_delete, "clicked", (GCallback) ___lambda101__gtk_button_clicked, block19_data_ref (_data19_), (GClosureNotify) block19_data_unref, 0);
	_tmp37_ = builder;
	_tmp38_ = gtk_builder_get_object (_tmp37_, "build_tool_reset");
	_tmp39_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp38_) ? ((GtkButton*) _tmp38_) : NULL);
	bt_reset = _tmp39_;
	g_signal_connect_object (bt_reset, "clicked", (GCallback) ___lambda102__gtk_button_clicked, self, 0);
	_g_object_unref0 (bt_reset);
	_g_object_unref0 (bt_delete);
	_g_object_unref0 (bt_down);
	_g_object_unref0 (bt_up);
	_g_object_unref0 (bt_copy);
	_g_object_unref0 (bt_new);
	_g_object_unref0 (bt_properties);
	_g_object_unref0 (latexmk_checkbutton);
	_g_object_unref0 (document_view_program);
	_g_object_unref0 (interactive_comp_label);
	_g_object_unref0 (interactive_comp_spinbutton);
	_g_object_unref0 (interactive_comp_checkbutton);
	_g_object_unref0 (settings);
	block19_data_unref (_data19_);
	_data19_ = NULL;
}


static void preferences_dialog_init_other_tab (PreferencesDialog* self, GtkBuilder* builder) {
	GSettings* _tmp0_;
	GSettings* settings;
	GSettings* _tmp1_;
	GSettings* latex_settings;
	GSettings* _tmp2_;
	GSettings* fb_settings;
	GtkBuilder* _tmp3_;
	GObject* _tmp4_ = NULL;
	GtkSpinButton* _tmp5_;
	GtkSpinButton* nb_most_used_symbols;
	GtkBuilder* _tmp6_;
	GObject* _tmp7_ = NULL;
	GObject* _tmp8_;
	GObject* confirm_clean_up_checkbutton;
	GtkBuilder* _tmp9_;
	GObject* _tmp10_ = NULL;
	GtkWidget* _tmp11_;
	GtkWidget* auto_clean_up_checkbutton;
	GtkBuilder* _tmp12_;
	GObject* _tmp13_ = NULL;
	GObject* _tmp14_;
	GObject* clean_up_entry;
	GtkBuilder* _tmp15_;
	GObject* _tmp16_ = NULL;
	GObject* _tmp17_;
	GObject* file_browser_show_all;
	GtkBuilder* _tmp18_;
	GObject* _tmp19_ = NULL;
	GtkWidget* _tmp20_;
	GtkWidget* file_browser_except;
	GtkBuilder* _tmp21_;
	GObject* _tmp22_ = NULL;
	GtkWidget* _tmp23_;
	GtkWidget* file_browser_show_hidden;
	GtkBuilder* _tmp24_;
	GObject* _tmp25_ = NULL;
	GtkWidget* _tmp26_;
	GtkWidget* file_browser_entry;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_tmp0_ = g_settings_new ("org.gnome.latexila.preferences.editor");
	settings = _tmp0_;
	_tmp1_ = g_settings_new ("org.gnome.latexila.preferences.latex");
	latex_settings = _tmp1_;
	_tmp2_ = g_settings_new ("org.gnome.latexila.preferences.file-browser");
	fb_settings = _tmp2_;
	_tmp3_ = builder;
	_tmp4_ = gtk_builder_get_object (_tmp3_, "nb_most_used_symbols");
	_tmp5_ = _g_object_ref0 (GTK_IS_SPIN_BUTTON (_tmp4_) ? ((GtkSpinButton*) _tmp4_) : NULL);
	nb_most_used_symbols = _tmp5_;
	preferences_dialog_set_spin_button_range (self, nb_most_used_symbols, settings, "nb-most-used-symbols");
	g_settings_bind (settings, "nb-most-used-symbols", (GObject*) nb_most_used_symbols, "value", G_SETTINGS_BIND_DEFAULT);
	_tmp6_ = builder;
	_tmp7_ = gtk_builder_get_object (_tmp6_, "confirm_clean_up_checkbutton");
	_tmp8_ = _g_object_ref0 (_tmp7_);
	confirm_clean_up_checkbutton = _tmp8_;
	g_settings_bind (latex_settings, "no-confirm-clean", confirm_clean_up_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp9_ = builder;
	_tmp10_ = gtk_builder_get_object (_tmp9_, "auto_clean_up_checkbutton");
	_tmp11_ = _g_object_ref0 (GTK_IS_WIDGET (_tmp10_) ? ((GtkWidget*) _tmp10_) : NULL);
	auto_clean_up_checkbutton = _tmp11_;
	g_settings_bind (latex_settings, "automatic-clean", (GObject*) auto_clean_up_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	preferences_dialog_set_sensitivity (self, latex_settings, "no-confirm-clean", auto_clean_up_checkbutton, TRUE);
	_tmp12_ = builder;
	_tmp13_ = gtk_builder_get_object (_tmp12_, "clean_up_entry");
	_tmp14_ = _g_object_ref0 (_tmp13_);
	clean_up_entry = _tmp14_;
	g_settings_bind (latex_settings, "clean-extensions", clean_up_entry, "text", G_SETTINGS_BIND_DEFAULT);
	_tmp15_ = builder;
	_tmp16_ = gtk_builder_get_object (_tmp15_, "file_browser_show_all");
	_tmp17_ = _g_object_ref0 (_tmp16_);
	file_browser_show_all = _tmp17_;
	g_settings_bind (fb_settings, "show-all-files", file_browser_show_all, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp18_ = builder;
	_tmp19_ = gtk_builder_get_object (_tmp18_, "file_browser_except");
	_tmp20_ = _g_object_ref0 (GTK_IS_WIDGET (_tmp19_) ? ((GtkWidget*) _tmp19_) : NULL);
	file_browser_except = _tmp20_;
	g_settings_bind (fb_settings, "show-all-files-except", (GObject*) file_browser_except, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp21_ = builder;
	_tmp22_ = gtk_builder_get_object (_tmp21_, "file_browser_show_hidden");
	_tmp23_ = _g_object_ref0 (GTK_IS_WIDGET (_tmp22_) ? ((GtkWidget*) _tmp22_) : NULL);
	file_browser_show_hidden = _tmp23_;
	g_settings_bind (fb_settings, "show-hidden-files", (GObject*) file_browser_show_hidden, "active", G_SETTINGS_BIND_DEFAULT);
	preferences_dialog_set_sensitivity (self, fb_settings, "show-all-files", file_browser_except, TRUE);
	preferences_dialog_set_sensitivity (self, fb_settings, "show-all-files", file_browser_show_hidden, TRUE);
	_tmp24_ = builder;
	_tmp25_ = gtk_builder_get_object (_tmp24_, "file_browser_entry");
	_tmp26_ = _g_object_ref0 (GTK_IS_WIDGET (_tmp25_) ? ((GtkWidget*) _tmp25_) : NULL);
	file_browser_entry = _tmp26_;
	g_settings_bind (fb_settings, "file-extensions", (GObject*) file_browser_entry, "text", G_SETTINGS_BIND_DEFAULT);
	preferences_dialog_set_sensitivity (self, fb_settings, "show-all-files", file_browser_entry, FALSE);
	_g_object_unref0 (file_browser_entry);
	_g_object_unref0 (file_browser_show_hidden);
	_g_object_unref0 (file_browser_except);
	_g_object_unref0 (file_browser_show_all);
	_g_object_unref0 (clean_up_entry);
	_g_object_unref0 (auto_clean_up_checkbutton);
	_g_object_unref0 (confirm_clean_up_checkbutton);
	_g_object_unref0 (nb_most_used_symbols);
	_g_object_unref0 (fb_settings);
	_g_object_unref0 (latex_settings);
	_g_object_unref0 (settings);
}


static Block20Data* block20_data_ref (Block20Data* _data20_) {
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}


static void block20_data_unref (void * _userdata_) {
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		PreferencesDialog * self;
		self = _data20_->self;
		_g_object_unref0 (_data20_->widget);
		_g_object_unref0 (self);
		g_slice_free (Block20Data, _data20_);
	}
}


static void __lambda80_ (Block20Data* _data20_, GSettings* setting, const gchar* k) {
	PreferencesDialog * self;
	GSettings* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean v;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	GtkWidget* _tmp7_;
	gboolean _tmp8_;
	self = _data20_->self;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (k != NULL);
	_tmp0_ = setting;
	_tmp1_ = k;
	_tmp2_ = g_settings_get_boolean (_tmp0_, _tmp1_);
	v = _tmp2_;
	_tmp4_ = _data20_->must_be_enabled;
	if (_tmp4_) {
		gboolean _tmp5_;
		_tmp5_ = v;
		_tmp3_ = _tmp5_;
	} else {
		gboolean _tmp6_;
		_tmp6_ = v;
		_tmp3_ = !_tmp6_;
	}
	_tmp7_ = _data20_->widget;
	_tmp8_ = _tmp3_;
	gtk_widget_set_sensitive (_tmp7_, _tmp8_);
}


static void ___lambda80__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda80_ (self, _sender, key);
}


static void preferences_dialog_set_sensitivity (PreferencesDialog* self, GSettings* settings, const gchar* key, GtkWidget* widget, gboolean must_be_enabled) {
	Block20Data* _data20_;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	gboolean _tmp2_;
	GSettings* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean val;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_;
	GtkWidget* _tmp10_;
	gboolean _tmp11_;
	GSettings* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (widget != NULL);
	_data20_ = g_slice_new0 (Block20Data);
	_data20_->_ref_count_ = 1;
	_data20_->self = g_object_ref (self);
	_tmp0_ = widget;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data20_->widget = _tmp1_;
	_tmp2_ = must_be_enabled;
	_data20_->must_be_enabled = _tmp2_;
	_tmp3_ = settings;
	_tmp4_ = key;
	_tmp5_ = g_settings_get_boolean (_tmp3_, _tmp4_);
	val = _tmp5_;
	_tmp7_ = _data20_->must_be_enabled;
	if (_tmp7_) {
		gboolean _tmp8_;
		_tmp8_ = val;
		_tmp6_ = _tmp8_;
	} else {
		gboolean _tmp9_;
		_tmp9_ = val;
		_tmp6_ = !_tmp9_;
	}
	_tmp10_ = _data20_->widget;
	_tmp11_ = _tmp6_;
	gtk_widget_set_sensitive (_tmp10_, _tmp11_);
	_tmp12_ = settings;
	_tmp13_ = key;
	_tmp14_ = g_strconcat ("changed::", _tmp13_, NULL);
	g_signal_connect_data (_tmp12_, _tmp14_, (GCallback) ___lambda80__g_settings_changed, block20_data_ref (_data20_), (GClosureNotify) block20_data_unref, 0);
	_g_free0 (_tmp14_);
	block20_data_unref (_data20_);
	_data20_ = NULL;
}


static void preferences_dialog_set_system_font_label (PreferencesDialog* self, GtkButton* button) {
	AppSettings* _tmp0_ = NULL;
	AppSettings* app_settings;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* label;
	GtkButton* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = app_settings_get_default ();
	app_settings = _tmp0_;
	_tmp1_ = _ ("Use the system fixed width font (%s)");
	_tmp2_ = app_settings_get_system_font (app_settings);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf (_tmp1_, _tmp3_);
	label = _tmp4_;
	_tmp5_ = button;
	gtk_button_set_label (_tmp5_, label);
	_g_free0 (label);
	_g_object_unref0 (app_settings);
}


static Block21Data* block21_data_ref (Block21Data* _data21_) {
	g_atomic_int_inc (&_data21_->_ref_count_);
	return _data21_;
}


static void block21_data_unref (void * _userdata_) {
	Block21Data* _data21_;
	_data21_ = (Block21Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
		PreferencesDialog * self;
		self = _data21_->self;
		_g_object_unref0 (_data21_->label);
		_g_object_unref0 (self);
		g_slice_free (Block21Data, _data21_);
	}
}


static void __lambda81_ (Block21Data* _data21_, GSettings* setting, const gchar* k) {
	PreferencesDialog * self;
	guint v = 0U;
	GSettings* _tmp0_;
	const gchar* _tmp1_;
	GtkLabel* _tmp2_;
	PreferencesDialogPlural _tmp3_;
	void* _tmp3__target;
	const gchar* _tmp4_ = NULL;
	self = _data21_->self;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (k != NULL);
	_tmp0_ = setting;
	_tmp1_ = k;
	g_settings_get (_tmp0_, _tmp1_, "u", &v);
	_tmp2_ = _data21_->label;
	_tmp3_ = _data21_->plural;
	_tmp3__target = _data21_->plural_target;
	_tmp4_ = _tmp3_ ((gulong) v, _tmp3__target);
	gtk_label_set_label (_tmp2_, _tmp4_);
}


static void ___lambda81__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda81_ (self, _sender, key);
}


static void preferences_dialog_set_plural (PreferencesDialog* self, GtkLabel* label, GSettings* settings, const gchar* key, PreferencesDialogPlural plural, void* plural_target) {
	Block21Data* _data21_;
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	PreferencesDialogPlural _tmp2_;
	void* _tmp2__target;
	guint val = 0U;
	GSettings* _tmp3_;
	const gchar* _tmp4_;
	GtkLabel* _tmp5_;
	PreferencesDialogPlural _tmp6_;
	void* _tmp6__target;
	const gchar* _tmp7_ = NULL;
	GSettings* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	_data21_ = g_slice_new0 (Block21Data);
	_data21_->_ref_count_ = 1;
	_data21_->self = g_object_ref (self);
	_tmp0_ = label;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data21_->label = _tmp1_;
	_tmp2_ = plural;
	_tmp2__target = plural_target;
	_data21_->plural = _tmp2_;
	_data21_->plural_target = _tmp2__target;
	_tmp3_ = settings;
	_tmp4_ = key;
	g_settings_get (_tmp3_, _tmp4_, "u", &val);
	_tmp5_ = _data21_->label;
	_tmp6_ = _data21_->plural;
	_tmp6__target = _data21_->plural_target;
	_tmp7_ = _tmp6_ ((gulong) val, _tmp6__target);
	gtk_label_set_label (_tmp5_, _tmp7_);
	_tmp8_ = settings;
	_tmp9_ = key;
	_tmp10_ = g_strconcat ("changed::", _tmp9_, NULL);
	g_signal_connect_data (_tmp8_, _tmp10_, (GCallback) ___lambda81__g_settings_changed, block21_data_ref (_data21_), (GClosureNotify) block21_data_unref, 0);
	_g_free0 (_tmp10_);
	block21_data_unref (_data21_);
	_data21_ = NULL;
}


static void preferences_dialog_set_spin_button_range (PreferencesDialog* self, GtkSpinButton* spin_button, GSettings* settings, const gchar* key) {
	GSettings* _tmp0_;
	const gchar* _tmp1_;
	GVariant* _tmp2_ = NULL;
	GVariant* range;
	gchar* range_type = NULL;
	GVariant* range_contents = NULL;
	guint min = 0U;
	guint max = 0U;
	guint cur_value = 0U;
	GSettings* _tmp3_;
	const gchar* _tmp4_;
	GtkAdjustment* _tmp5_;
	GtkAdjustment* _tmp6_;
	GtkAdjustment* adjustment;
	GtkSpinButton* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spin_button != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = settings;
	_tmp1_ = key;
	_tmp2_ = g_settings_get_range (_tmp0_, _tmp1_);
	range = _tmp2_;
	g_variant_get (range, "(sv)", &range_type, &range_contents, NULL);
	g_return_if_fail (g_strcmp0 (range_type, "range") == 0);
	g_variant_get (range_contents, "(uu)", &min, &max, NULL);
	_tmp3_ = settings;
	_tmp4_ = key;
	g_settings_get (_tmp3_, _tmp4_, "u", &cur_value);
	_tmp5_ = gtk_adjustment_new ((gdouble) cur_value, (gdouble) min, (gdouble) max, 1.0, (gdouble) 0, (gdouble) 0);
	_tmp6_ = g_object_ref_sink (_tmp5_);
	adjustment = _tmp6_;
	_tmp7_ = spin_button;
	gtk_spin_button_set_adjustment (_tmp7_, adjustment);
	_g_object_unref0 (adjustment);
	_g_variant_unref0 (range_contents);
	_g_free0 (range_type);
	_g_variant_unref0 (range);
}


static void preferences_dialog_init_schemes_treeview (PreferencesDialog* self, GtkTreeView* treeview, const gchar* current_id) {
	GtkListStore* _tmp0_;
	GtkListStore* list_store;
	GtkListStore* _tmp1_;
	GtkTreeView* _tmp2_;
	GtkListStore* _tmp3_;
	GtkCellRendererText* _tmp4_;
	GtkCellRendererText* _tmp5_;
	GtkCellRendererText* renderer;
	GtkCellRendererText* _tmp6_;
	GtkTreeViewColumn* _tmp7_;
	GtkTreeViewColumn* _tmp8_;
	GtkTreeViewColumn* column;
	GtkTreeView* _tmp9_;
	GtkTreeViewColumn* _tmp10_;
	GtkTreeView* _tmp11_;
	GtkTreeSelection* _tmp12_ = NULL;
	GtkTreeSelection* _tmp13_;
	GtkTreeSelection* select;
	GtkTreeSelection* _tmp14_;
	GtkSourceStyleSchemeManager* _tmp15_ = NULL;
	GtkSourceStyleSchemeManager* _tmp16_;
	GtkSourceStyleSchemeManager* manager;
	GtkSourceStyleSchemeManager* _tmp17_;
	gchar** _tmp18_;
	gchar** _tmp19_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (treeview != NULL);
	g_return_if_fail (current_id != NULL);
	_tmp0_ = gtk_list_store_new ((gint) PREFERENCES_DIALOG_STYLE_SCHEMES_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING);
	list_store = _tmp0_;
	_tmp1_ = list_store;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp1_, (gint) PREFERENCES_DIALOG_STYLE_SCHEMES_ID, GTK_SORT_ASCENDING);
	_tmp2_ = treeview;
	_tmp3_ = list_store;
	gtk_tree_view_set_model (_tmp2_, (GtkTreeModel*) _tmp3_);
	_tmp4_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp5_ = g_object_ref_sink (_tmp4_);
	renderer = _tmp5_;
	_tmp6_ = renderer;
	_tmp7_ = gtk_tree_view_column_new_with_attributes ("Name and description", (GtkCellRenderer*) _tmp6_, "markup", PREFERENCES_DIALOG_STYLE_SCHEMES_DESC, NULL, NULL);
	_tmp8_ = g_object_ref_sink (_tmp7_);
	column = _tmp8_;
	_tmp9_ = treeview;
	_tmp10_ = column;
	gtk_tree_view_append_column (_tmp9_, _tmp10_);
	_tmp11_ = treeview;
	_tmp12_ = gtk_tree_view_get_selection (_tmp11_);
	_tmp13_ = _g_object_ref0 (_tmp12_);
	select = _tmp13_;
	_tmp14_ = select;
	gtk_tree_selection_set_mode (_tmp14_, GTK_SELECTION_SINGLE);
	_tmp15_ = gtk_source_style_scheme_manager_get_default ();
	_tmp16_ = _g_object_ref0 (_tmp15_);
	manager = _tmp16_;
	_tmp17_ = manager;
	_tmp19_ = _tmp18_ = gtk_source_style_scheme_manager_get_scheme_ids (_tmp17_);
	{
		gchar** id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp19_;
		id_collection_length1 = _vala_array_length (_tmp18_);
		for (id_it = 0; id_it < _vala_array_length (_tmp18_); id_it = id_it + 1) {
			gchar* _tmp20_;
			gchar* id = NULL;
			_tmp20_ = g_strdup (id_collection[id_it]);
			id = _tmp20_;
			{
				GtkSourceStyleSchemeManager* _tmp21_;
				const gchar* _tmp22_;
				GtkSourceStyleScheme* _tmp23_ = NULL;
				GtkSourceStyleScheme* _tmp24_;
				GtkSourceStyleScheme* scheme;
				GtkSourceStyleScheme* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				GtkSourceStyleScheme* _tmp28_;
				const gchar* _tmp29_;
				const gchar* _tmp30_;
				gchar* _tmp31_ = NULL;
				gchar* desc;
				GtkTreeIter iter = {0};
				GtkListStore* _tmp32_;
				GtkTreeIter _tmp33_ = {0};
				GtkListStore* _tmp34_;
				GtkTreeIter _tmp35_;
				GtkSourceStyleScheme* _tmp36_;
				const gchar* _tmp37_;
				const gchar* _tmp38_;
				const gchar* _tmp39_;
				const gchar* _tmp40_;
				const gchar* _tmp41_;
				_tmp21_ = manager;
				_tmp22_ = id;
				_tmp23_ = gtk_source_style_scheme_manager_get_scheme (_tmp21_, _tmp22_);
				_tmp24_ = _g_object_ref0 (_tmp23_);
				scheme = _tmp24_;
				_tmp25_ = scheme;
				_tmp26_ = gtk_source_style_scheme_get_name (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = scheme;
				_tmp29_ = gtk_source_style_scheme_get_description (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = g_strdup_printf ("<b>%s</b> - %s", _tmp27_, _tmp30_);
				desc = _tmp31_;
				_tmp32_ = list_store;
				gtk_list_store_append (_tmp32_, &_tmp33_);
				iter = _tmp33_;
				_tmp34_ = list_store;
				_tmp35_ = iter;
				_tmp36_ = scheme;
				_tmp37_ = gtk_source_style_scheme_get_id (_tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = desc;
				gtk_list_store_set (_tmp34_, &_tmp35_, PREFERENCES_DIALOG_STYLE_SCHEMES_ID, _tmp38_, PREFERENCES_DIALOG_STYLE_SCHEMES_DESC, _tmp39_, -1, -1);
				_tmp40_ = id;
				_tmp41_ = current_id;
				if (g_strcmp0 (_tmp40_, _tmp41_) == 0) {
					GtkTreeSelection* _tmp42_;
					GtkTreeIter _tmp43_;
					_tmp42_ = select;
					_tmp43_ = iter;
					gtk_tree_selection_select_iter (_tmp42_, &_tmp43_);
				}
				_g_free0 (desc);
				_g_object_unref0 (scheme);
				_g_free0 (id);
			}
		}
	}
	_g_object_unref0 (manager);
	_g_object_unref0 (select);
	_g_object_unref0 (column);
	_g_object_unref0 (renderer);
	_g_object_unref0 (list_store);
}


static Block22Data* block22_data_ref (Block22Data* _data22_) {
	g_atomic_int_inc (&_data22_->_ref_count_);
	return _data22_;
}


static void block22_data_unref (void * _userdata_) {
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
		PreferencesDialog * self;
		self = _data22_->self;
		_g_object_unref0 (_data22_->label_column);
		_g_object_unref0 (self);
		g_slice_free (Block22Data, _data22_);
	}
}


static void __lambda87_ (PreferencesDialog* self, const gchar* path_string) {
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	const gchar* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gboolean val = FALSE;
	GtkListStore* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* model;
	GtkTreeIter _tmp5_;
	gboolean _tmp6_;
	GtkListStore* _tmp7_;
	GtkTreeIter _tmp8_;
	gboolean _tmp9_;
	const gchar* _tmp10_;
	gint _tmp11_ = 0;
	gint num;
	BuildTools* _tmp12_ = NULL;
	BuildTools* build_tools;
	BuildTool* _tmp13_ = NULL;
	BuildTool* _tmp14_;
	BuildTool _tmp15_ = {0};
	BuildTool _tmp16_;
	BuildTool build_tool;
	gboolean _tmp17_;
	BuildTool _tmp18_;
	g_return_if_fail (path_string != NULL);
	_tmp0_ = self->priv->build_tools_store;
	_tmp1_ = path_string;
	gtk_tree_model_get_iter_from_string ((GtkTreeModel*) _tmp0_, &_tmp2_, _tmp1_);
	iter = _tmp2_;
	_tmp3_ = self->priv->build_tools_store;
	_tmp4_ = _g_object_ref0 (GTK_TREE_MODEL (_tmp3_));
	model = _tmp4_;
	_tmp5_ = iter;
	gtk_tree_model_get (model, &_tmp5_, PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_SHOW, &val, -1, -1);
	_tmp6_ = val;
	val = !_tmp6_;
	_tmp7_ = self->priv->build_tools_store;
	_tmp8_ = iter;
	_tmp9_ = val;
	gtk_list_store_set (_tmp7_, &_tmp8_, PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_SHOW, _tmp9_, -1, -1);
	_tmp10_ = path_string;
	_tmp11_ = atoi (_tmp10_);
	num = _tmp11_;
	_tmp12_ = build_tools_get_default ();
	build_tools = _tmp12_;
	_tmp13_ = build_tools_get (build_tools, num);
	_tmp14_ = _tmp13_;
	build_tool_copy (_tmp14_, &_tmp15_);
	_tmp16_ = _tmp15_;
	_build_tool_free0 (_tmp14_);
	build_tool = _tmp16_;
	_tmp17_ = val;
	build_tool.show = _tmp17_;
	_tmp18_ = build_tool;
	build_tools_update (build_tools, num, &_tmp18_, FALSE);
	build_tool_destroy (&build_tool);
	_build_tools_unref0 (build_tools);
	_g_object_unref0 (model);
}


static void ___lambda87__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const gchar* path, gpointer self) {
	__lambda87_ (self, path);
}


static void __lambda88_ (Block22Data* _data22_, GtkTreePath* path, GtkTreeViewColumn* column) {
	PreferencesDialog * self;
	GtkTreeViewColumn* _tmp0_;
	self = _data22_->self;
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	_tmp0_ = column;
	if (_tmp0_ == _data22_->label_column) {
		GtkTreePath* _tmp1_;
		gint _tmp2_ = 0;
		gint* _tmp3_ = NULL;
		gint _tmp4_;
		gint num;
		gint _tmp5_;
		_tmp1_ = path;
		_tmp3_ = gtk_tree_path_get_indices_with_depth (_tmp1_, &_tmp2_);
		_tmp4_ = _tmp3_[0];
		num = _tmp4_;
		_tmp5_ = num;
		preferences_dialog_run_build_tool_dialog (self, _tmp5_);
	}
}


static void ___lambda88__gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
	__lambda88_ (self, path, column);
}


static void preferences_dialog_init_build_tools_treeview (PreferencesDialog* self, GtkTreeView* build_tools_view) {
	Block22Data* _data22_;
	GtkListStore* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkListStore* _tmp2_;
	GtkTreeViewColumn* _tmp3_;
	GtkTreeViewColumn* _tmp4_;
	GtkTreeViewColumn* active_column;
	const gchar* _tmp5_ = NULL;
	GtkTreeView* _tmp6_;
	GtkCellRendererToggle* _tmp7_;
	GtkCellRendererToggle* _tmp8_;
	GtkCellRendererToggle* toggle_renderer;
	GtkTreeViewColumn* _tmp9_;
	GtkTreeViewColumn* _tmp10_;
	const gchar* _tmp11_ = NULL;
	GtkTreeView* _tmp12_;
	GtkCellRendererPixbuf* _tmp13_;
	GtkCellRendererPixbuf* _tmp14_;
	GtkCellRendererPixbuf* pixbuf_renderer;
	GtkCellRendererText* _tmp15_;
	GtkCellRendererText* _tmp16_;
	GtkCellRendererText* text_renderer;
	GtkTreeView* _tmp17_;
	GtkTreeView* _tmp18_;
	GtkTreeSelection* _tmp19_ = NULL;
	GtkTreeSelection* _tmp20_;
	GtkTreeSelection* select;
	GtkTreeView* _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (build_tools_view != NULL);
	_data22_ = g_slice_new0 (Block22Data);
	_data22_->_ref_count_ = 1;
	_data22_->self = g_object_ref (self);
	_tmp0_ = gtk_list_store_new ((gint) PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_N_COLUMNS, G_TYPE_BOOLEAN, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
	_g_object_unref0 (self->priv->build_tools_store);
	self->priv->build_tools_store = _tmp0_;
	_tmp1_ = build_tools_view;
	_tmp2_ = self->priv->build_tools_store;
	gtk_tree_view_set_model (_tmp1_, (GtkTreeModel*) _tmp2_);
	_tmp3_ = gtk_tree_view_column_new ();
	_tmp4_ = g_object_ref_sink (_tmp3_);
	active_column = _tmp4_;
	_tmp5_ = _ ("Active");
	gtk_tree_view_column_set_title (active_column, _tmp5_);
	_tmp6_ = build_tools_view;
	gtk_tree_view_append_column (_tmp6_, active_column);
	_tmp7_ = (GtkCellRendererToggle*) gtk_cell_renderer_toggle_new ();
	_tmp8_ = g_object_ref_sink (_tmp7_);
	toggle_renderer = _tmp8_;
	gtk_cell_layout_pack_start ((GtkCellLayout*) active_column, (GtkCellRenderer*) toggle_renderer, FALSE);
	gtk_tree_view_column_set_attributes (active_column, (GtkCellRenderer*) toggle_renderer, "active", PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_SHOW, NULL, NULL);
	_tmp9_ = gtk_tree_view_column_new ();
	_tmp10_ = g_object_ref_sink (_tmp9_);
	_data22_->label_column = _tmp10_;
	_tmp11_ = _ ("Label");
	gtk_tree_view_column_set_title (_data22_->label_column, _tmp11_);
	_tmp12_ = build_tools_view;
	gtk_tree_view_append_column (_tmp12_, _data22_->label_column);
	_tmp13_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	_tmp14_ = g_object_ref_sink (_tmp13_);
	pixbuf_renderer = _tmp14_;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _data22_->label_column, (GtkCellRenderer*) pixbuf_renderer, FALSE);
	gtk_tree_view_column_set_attributes (_data22_->label_column, (GtkCellRenderer*) pixbuf_renderer, "stock-id", PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_PIXBUF, NULL, NULL);
	_tmp15_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp16_ = g_object_ref_sink (_tmp15_);
	text_renderer = _tmp16_;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _data22_->label_column, (GtkCellRenderer*) text_renderer, TRUE);
	gtk_tree_view_column_set_attributes (_data22_->label_column, (GtkCellRenderer*) text_renderer, "text", PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_LABEL, NULL, NULL);
	_tmp17_ = build_tools_view;
	gtk_tree_view_set_tooltip_column (_tmp17_, (gint) PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_DESCRIPTION);
	_tmp18_ = build_tools_view;
	_tmp19_ = gtk_tree_view_get_selection (_tmp18_);
	_tmp20_ = _g_object_ref0 (_tmp19_);
	select = _tmp20_;
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	preferences_dialog_update_build_tools_store (self);
	g_signal_connect_object (toggle_renderer, "toggled", (GCallback) ___lambda87__gtk_cell_renderer_toggle_toggled, self, 0);
	_tmp21_ = build_tools_view;
	g_signal_connect_data (_tmp21_, "row-activated", (GCallback) ___lambda88__gtk_tree_view_row_activated, block22_data_ref (_data22_), (GClosureNotify) block22_data_unref, 0);
	_g_object_unref0 (select);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
	_g_object_unref0 (toggle_renderer);
	_g_object_unref0 (active_column);
	block22_data_unref (_data22_);
	_data22_ = NULL;
}


static void preferences_dialog_update_build_tools_store (PreferencesDialog* self) {
	GtkListStore* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->build_tools_store;
	gtk_list_store_clear (_tmp0_);
	{
		BuildTools* _tmp1_ = NULL;
		BuildTools* _tmp2_;
		GeeIterator* _tmp3_ = NULL;
		GeeIterator* _tmp4_;
		GeeIterator* _tool_it;
		_tmp1_ = build_tools_get_default ();
		_tmp2_ = _tmp1_;
		_tmp3_ = build_tools_iterator (_tmp2_);
		_tmp4_ = _tmp3_;
		_build_tools_unref0 (_tmp2_);
		_tool_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			gboolean _tmp6_ = FALSE;
			GeeIterator* _tmp7_;
			gpointer _tmp8_ = NULL;
			BuildTool* _tmp9_;
			BuildTool _tmp10_ = {0};
			BuildTool _tmp11_;
			BuildTool tool;
			GtkTreeIter iter = {0};
			GtkListStore* _tmp12_;
			GtkTreeIter _tmp13_ = {0};
			GtkListStore* _tmp14_;
			GtkTreeIter _tmp15_;
			BuildTool _tmp16_;
			gboolean _tmp17_;
			BuildTool _tmp18_;
			const gchar* _tmp19_;
			BuildTool _tmp20_;
			const gchar* _tmp21_;
			BuildTool _tmp22_;
			const gchar* _tmp23_;
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_;
			_tmp5_ = _tool_it;
			_tmp6_ = gee_iterator_next (_tmp5_);
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = _tool_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			_tmp9_ = (BuildTool*) _tmp8_;
			build_tool_copy (_tmp9_, &_tmp10_);
			_tmp11_ = _tmp10_;
			_build_tool_free0 (_tmp9_);
			tool = _tmp11_;
			_tmp12_ = self->priv->build_tools_store;
			gtk_list_store_append (_tmp12_, &_tmp13_);
			iter = _tmp13_;
			_tmp14_ = self->priv->build_tools_store;
			_tmp15_ = iter;
			_tmp16_ = tool;
			_tmp17_ = _tmp16_.show;
			_tmp18_ = tool;
			_tmp19_ = _tmp18_.icon;
			_tmp20_ = tool;
			_tmp21_ = _tmp20_.label;
			_tmp22_ = tool;
			_tmp23_ = _tmp22_.description;
			_tmp24_ = g_markup_escape_text (_tmp23_, (gssize) (-1));
			_tmp25_ = _tmp24_;
			gtk_list_store_set (_tmp14_, &_tmp15_, PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_SHOW, _tmp17_, PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_PIXBUF, _tmp19_, PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_LABEL, _tmp21_, PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_DESCRIPTION, _tmp25_, -1, -1);
			_g_free0 (_tmp25_);
			build_tool_destroy (&tool);
		}
		_g_object_unref0 (_tool_it);
	}
}


static GtkDialog* preferences_dialog_get_reset_all_confirm_dialog (PreferencesDialog* self, const gchar* msg) {
	GtkDialog* result = NULL;
	const gchar* _tmp0_;
	GtkMessageDialog* _tmp1_;
	GtkDialog* _tmp2_;
	GtkDialog* dialog;
	const gchar* _tmp3_ = NULL;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	GtkButton* button;
	GtkImage* _tmp6_;
	GtkImage* _tmp7_;
	GtkImage* image;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	_tmp0_ = msg;
	_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _tmp0_);
	_tmp2_ = (GtkDialog*) g_object_ref_sink (_tmp1_);
	dialog = _tmp2_;
	gtk_dialog_add_button (dialog, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
	_tmp3_ = _ ("Reset All");
	_tmp4_ = (GtkButton*) gtk_button_new_with_label (_tmp3_);
	_tmp5_ = g_object_ref_sink (_tmp4_);
	button = _tmp5_;
	_tmp6_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_CLEAR, GTK_ICON_SIZE_BUTTON);
	_tmp7_ = g_object_ref_sink (_tmp6_);
	image = _tmp7_;
	gtk_button_set_image (button, (GtkWidget*) image);
	gtk_widget_show_all ((GtkWidget*) button);
	gtk_dialog_add_action_widget (dialog, (GtkWidget*) button, (gint) GTK_RESPONSE_YES);
	result = dialog;
	_g_object_unref0 (image);
	_g_object_unref0 (button);
	return result;
}


static void preferences_dialog_run_build_tool_dialog (PreferencesDialog* self, gint num) {
	GtkWindow* _tmp0_ = NULL;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_window_get_transient_for ((GtkWindow*) self);
	_tmp1_ = num;
	_tmp2_ = build_tool_dialog_show_me (_tmp0_, _tmp1_);
	if (_tmp2_) {
		preferences_dialog_update_build_tools_store (self);
	}
}


static void preferences_dialog_class_init (PreferencesDialogClass * klass) {
	preferences_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PreferencesDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = preferences_dialog_finalize;
}


static void preferences_dialog_instance_init (PreferencesDialog * self) {
	self->priv = PREFERENCES_DIALOG_GET_PRIVATE (self);
}


static void preferences_dialog_finalize (GObject* obj) {
	PreferencesDialog * self;
	self = PREFERENCES_DIALOG (obj);
	_g_object_unref0 (self->priv->build_tools_store);
	G_OBJECT_CLASS (preferences_dialog_parent_class)->finalize (obj);
}


GType preferences_dialog_get_type (void) {
	static volatile gsize preferences_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&preferences_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PreferencesDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) preferences_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PreferencesDialog), 0, (GInstanceInitFunc) preferences_dialog_instance_init, NULL };
		GType preferences_dialog_type_id;
		preferences_dialog_type_id = g_type_register_static (GTK_TYPE_DIALOG, "PreferencesDialog", &g_define_type_info, 0);
		g_once_init_leave (&preferences_dialog_type_id__volatile, preferences_dialog_type_id);
	}
	return preferences_dialog_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



