/* search.c generated by valac 0.16.0, the Vala compiler
 * generated from search.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2012 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <gtksourceview/gtksource.h>
#include <float.h>
#include <math.h>


#define TYPE_GOTO_LINE (goto_line_get_type ())
#define GOTO_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GOTO_LINE, GotoLine))
#define GOTO_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GOTO_LINE, GotoLineClass))
#define IS_GOTO_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GOTO_LINE))
#define IS_GOTO_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GOTO_LINE))
#define GOTO_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GOTO_LINE, GotoLineClass))

typedef struct _GotoLine GotoLine;
typedef struct _GotoLineClass GotoLineClass;
typedef struct _GotoLinePrivate GotoLinePrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_ERROR_ENTRY (error_entry_get_type ())
#define ERROR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ERROR_ENTRY, ErrorEntry))
#define ERROR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ERROR_ENTRY, ErrorEntryClass))
#define IS_ERROR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ERROR_ENTRY))
#define IS_ERROR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ERROR_ENTRY))
#define ERROR_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ERROR_ENTRY, ErrorEntryClass))

typedef struct _ErrorEntry ErrorEntry;
typedef struct _ErrorEntryClass ErrorEntryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

#define TYPE_SEARCH_AND_REPLACE (search_and_replace_get_type ())
#define SEARCH_AND_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_AND_REPLACE, SearchAndReplace))
#define SEARCH_AND_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_AND_REPLACE, SearchAndReplaceClass))
#define IS_SEARCH_AND_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_AND_REPLACE))
#define IS_SEARCH_AND_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_AND_REPLACE))
#define SEARCH_AND_REPLACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_AND_REPLACE, SearchAndReplaceClass))

typedef struct _SearchAndReplace SearchAndReplace;
typedef struct _SearchAndReplaceClass SearchAndReplaceClass;
typedef struct _SearchAndReplacePrivate SearchAndReplacePrivate;

#define SEARCH_AND_REPLACE_TYPE_MODE (search_and_replace_mode_get_type ())
typedef struct _Block12Data Block12Data;
typedef struct _Block13Data Block13Data;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_SELECTION_TYPE (selection_type_get_type ())

struct _GotoLine {
	GtkGrid parent_instance;
	GotoLinePrivate * priv;
};

struct _GotoLineClass {
	GtkGridClass parent_class;
};

struct _GotoLinePrivate {
	MainWindow* main_window;
	ErrorEntry* entry;
};

struct _SearchAndReplace {
	GObject parent_instance;
	SearchAndReplacePrivate * priv;
};

struct _SearchAndReplaceClass {
	GObjectClass parent_class;
};

struct _SearchAndReplacePrivate {
	MainWindow* _main_window;
	Document* _working_document;
	GtkGrid* _main_grid;
	GtkGrid* _replace_grid;
	GtkButton* _button_arrow;
	GtkArrow* _arrow;
	ErrorEntry* _entry_find;
	GtkEntry* _entry_replace;
	GtkCheckMenuItem* _check_case_sensitive;
	GtkCheckMenuItem* _check_entire_word;
	gint min_nb_chars_for_inc_search;
};

typedef enum  {
	SEARCH_AND_REPLACE_MODE_SEARCH,
	SEARCH_AND_REPLACE_MODE_SEARCH_AND_REPLACE
} SearchAndReplaceMode;

struct _Block12Data {
	int _ref_count_;
	SearchAndReplace * self;
	GtkButton* button_clear_find;
	GtkButton* button_previous;
	GtkButton* button_next;
	GtkButton* button_clear_replace;
	GtkButton* button_replace;
	GtkButton* button_replace_all;
};

struct _Block13Data {
	int _ref_count_;
	SearchAndReplace * self;
	GtkMenu* menu;
};

typedef enum  {
	SELECTION_TYPE_NO_SELECTION,
	SELECTION_TYPE_ONE_LINE,
	SELECTION_TYPE_MULTIPLE_LINES
} SelectionType;


static gpointer goto_line_parent_class = NULL;
static gpointer search_and_replace_parent_class = NULL;

GType goto_line_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType error_entry_get_type (void) G_GNUC_CONST;
#define GOTO_LINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GOTO_LINE, GotoLinePrivate))
enum  {
	GOTO_LINE_DUMMY_PROPERTY
};
GotoLine* goto_line_new (MainWindow* main_window);
GotoLine* goto_line_construct (GType object_type, MainWindow* main_window);
static void __lambda58_ (GotoLine* self);
static void ___lambda58__gtk_button_clicked (GtkButton* _sender, gpointer self);
ErrorEntry* error_entry_new (void);
ErrorEntry* error_entry_construct (GType object_type);
static void __lambda59_ (GotoLine* self);
static void ___lambda59__gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void __lambda60_ (GotoLine* self);
static void ___lambda60__gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self);
static void goto_line_on_changed (GotoLine* self);
static void _goto_line_on_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self);
void goto_line_show (GotoLine* self);
void error_entry_set_error (ErrorEntry* self, gboolean value);
GType document_get_type (void) G_GNUC_CONST;
Document* main_window_get_active_document (MainWindow* self);
gboolean document_goto_line (Document* self, gint line);
GType document_view_get_type (void) G_GNUC_CONST;
DocumentView* main_window_get_active_view (MainWindow* self);
void document_view_scroll_to_cursor (DocumentView* self, gdouble margin);
static void goto_line_finalize (GObject* obj);
GType search_and_replace_get_type (void) G_GNUC_CONST;
#define SEARCH_AND_REPLACE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SEARCH_AND_REPLACE, SearchAndReplacePrivate))
enum  {
	SEARCH_AND_REPLACE_DUMMY_PROPERTY
};
static GType search_and_replace_mode_get_type (void) G_GNUC_UNUSED;
static SearchAndReplaceMode search_and_replace_get_mode (SearchAndReplace* self);
SearchAndReplace* search_and_replace_new (MainWindow* main_window);
SearchAndReplace* search_and_replace_construct (GType object_type, MainWindow* main_window);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static void search_and_replace_init_find_entry (SearchAndReplace* self);
static GtkButton* search_and_replace_get_button (SearchAndReplace* self, const gchar* stock_id);
static void __lambda62_ (SearchAndReplace* self);
static void ___lambda62__gtk_button_clicked (GtkButton* _sender, gpointer self);
void search_and_replace_hide (SearchAndReplace* self);
static void _search_and_replace_hide_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda63_ (SearchAndReplace* self);
static void ___lambda63__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda64_ (SearchAndReplace* self);
static void ___lambda64__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda65_ (SearchAndReplace* self);
static void search_and_replace_set_search_text (SearchAndReplace* self, gboolean select);
void document_search_backward (Document* self);
static void ___lambda65__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void search_and_replace_search_forward (SearchAndReplace* self);
static void _search_and_replace_search_forward_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _search_and_replace_search_forward_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void __lambda66_ (Block12Data* _data12_);
static void search_and_replace_clear_search (SearchAndReplace* self);
static void ___lambda66__gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void __lambda67_ (Block12Data* _data12_);
static void ___lambda67__gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void __lambda68_ (SearchAndReplace* self);
static void ___lambda68__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void __lambda69_ (SearchAndReplace* self);
static void ___lambda69__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void search_and_replace_replace (SearchAndReplace* self);
static void _search_and_replace_replace_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _search_and_replace_replace_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void __lambda71_ (SearchAndReplace* self);
void document_replace_all (Document* self, const gchar* text);
static void ___lambda71__gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean __lambda72_ (SearchAndReplace* self, GdkEventKey* event);
void search_and_replace_show_search_and_replace (SearchAndReplace* self);
static void search_and_replace_select_current_match (SearchAndReplace* self);
static gboolean ___lambda72__gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
static void __lambda61_ (Block13Data* _data13_, GtkEntryIconPosition icon_pos, GdkEvent* event);
static void ___lambda61__gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self);
GtkWidget* search_and_replace_get_widget (SearchAndReplace* self);
void search_and_replace_show_search (SearchAndReplace* self);
static void search_and_replace_show (SearchAndReplace* self);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentTab* main_window_get_active_tab (MainWindow* self);
static void search_and_replace_set_replace_sensitivity (SearchAndReplace* self);
GType selection_type_get_type (void) G_GNUC_CONST;
SelectionType document_get_selection_type (Document* self);
static void _search_and_replace_set_replace_sensitivity_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void document_set_search_text (Document* self, const gchar* text, gboolean case_sensitive, gboolean entire_word, guint* nb_matches, guint* num_match, gboolean select);
static gboolean search_and_replace_get_case_sensitive (SearchAndReplace* self);
static gboolean search_and_replace_get_entire_word (SearchAndReplace* self);
void document_select_current_match (Document* self);
void document_search_forward (Document* self);
void document_clear_search (Document* self, gboolean disconnect_signals);
gboolean document_get_readonly (Document* self);
void document_replace (Document* self, const gchar* text);
static void search_and_replace_finalize (GObject* obj);
static void _vala_search_and_replace_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


static void __lambda58_ (GotoLine* self) {
	gtk_widget_hide ((GtkWidget*) self);
}


static void ___lambda58__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda58_ (self);
}


static void __lambda59_ (GotoLine* self) {
	gtk_widget_hide ((GtkWidget*) self);
}


static void ___lambda59__gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	__lambda59_ (self);
}


static void __lambda60_ (GotoLine* self) {
	gtk_widget_hide ((GtkWidget*) self);
}


static void ___lambda60__gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self) {
	__lambda60_ (self);
}


static void _goto_line_on_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	goto_line_on_changed (self);
}


GotoLine* goto_line_construct (GType object_type, MainWindow* main_window) {
	GotoLine * self = NULL;
	MainWindow* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* close_button;
	GtkImage* _tmp3_;
	GtkImage* _tmp4_;
	GtkImage* img;
	const gchar* _tmp5_ = NULL;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* label;
	ErrorEntry* _tmp8_;
	ErrorEntry* _tmp9_;
	ErrorEntry* _tmp10_;
	GThemedIcon* _tmp11_;
	GIcon* icon;
	ErrorEntry* _tmp12_;
	ErrorEntry* _tmp13_;
	ErrorEntry* _tmp14_;
	const gchar* _tmp15_ = NULL;
	ErrorEntry* _tmp16_;
	ErrorEntry* _tmp17_;
	ErrorEntry* _tmp18_;
	ErrorEntry* _tmp19_;
	g_return_val_if_fail (main_window != NULL, NULL);
	self = (GotoLine*) g_object_new (object_type, NULL);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_HORIZONTAL);
	gtk_grid_set_column_spacing ((GtkGrid*) self, (guint) 3);
	_tmp0_ = main_window;
	self->priv->main_window = _tmp0_;
	_tmp1_ = (GtkButton*) gtk_button_new ();
	_tmp2_ = g_object_ref_sink (_tmp1_);
	close_button = _tmp2_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) close_button);
	gtk_button_set_relief (close_button, GTK_RELIEF_NONE);
	_tmp3_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_CLOSE, GTK_ICON_SIZE_MENU);
	_tmp4_ = g_object_ref_sink (_tmp3_);
	img = _tmp4_;
	gtk_container_add ((GtkContainer*) close_button, (GtkWidget*) img);
	g_signal_connect_object (close_button, "clicked", (GCallback) ___lambda58__gtk_button_clicked, self, 0);
	_tmp5_ = _ ("Go to Line:");
	_tmp6_ = (GtkLabel*) gtk_label_new (_tmp5_);
	_tmp7_ = g_object_ref_sink (_tmp6_);
	label = _tmp7_;
	gtk_widget_set_margin_left ((GtkWidget*) label, 2);
	gtk_widget_set_margin_right ((GtkWidget*) label, 2);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) label);
	_tmp8_ = error_entry_new ();
	_tmp9_ = g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->entry);
	self->priv->entry = _tmp9_;
	_tmp10_ = self->priv->entry;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp10_);
	_tmp11_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks ("go-jump-symbolic");
	icon = (GIcon*) _tmp11_;
	_tmp12_ = self->priv->entry;
	gtk_entry_set_icon_from_gicon ((GtkEntry*) _tmp12_, GTK_ENTRY_ICON_SECONDARY, icon);
	_tmp13_ = self->priv->entry;
	gtk_entry_set_icon_activatable ((GtkEntry*) _tmp13_, GTK_ENTRY_ICON_SECONDARY, TRUE);
	_tmp14_ = self->priv->entry;
	_tmp15_ = _ ("Line you want to move the cursor to");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp14_, _tmp15_);
	_tmp16_ = self->priv->entry;
	gtk_widget_set_size_request ((GtkWidget*) _tmp16_, 100, -1);
	_tmp17_ = self->priv->entry;
	g_signal_connect_object ((GtkEntry*) _tmp17_, "activate", (GCallback) ___lambda59__gtk_entry_activate, self, 0);
	_tmp18_ = self->priv->entry;
	g_signal_connect_object ((GtkEntry*) _tmp18_, "icon-press", (GCallback) ___lambda60__gtk_entry_icon_press, self, 0);
	_tmp19_ = self->priv->entry;
	g_signal_connect_object ((GtkEditable*) _tmp19_, "changed", (GCallback) _goto_line_on_changed_gtk_editable_changed, self, 0);
	_g_object_unref0 (icon);
	_g_object_unref0 (label);
	_g_object_unref0 (img);
	_g_object_unref0 (close_button);
	return self;
}


GotoLine* goto_line_new (MainWindow* main_window) {
	return goto_line_construct (TYPE_GOTO_LINE, main_window);
}


void goto_line_show (GotoLine* self) {
	ErrorEntry* _tmp0_;
	ErrorEntry* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->entry;
	gtk_entry_set_text ((GtkEntry*) _tmp0_, "");
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp1_ = self->priv->entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void goto_line_on_changed (GotoLine* self) {
	ErrorEntry* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	ErrorEntry* _tmp4_;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* text;
	const gchar* _tmp20_;
	gint _tmp21_ = 0;
	gint line;
	ErrorEntry* _tmp22_;
	MainWindow* _tmp23_;
	Document* _tmp24_;
	Document* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	gboolean _tmp28_ = FALSE;
	MainWindow* _tmp29_;
	DocumentView* _tmp30_;
	DocumentView* _tmp31_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->entry;
	_tmp1_ = gtk_entry_get_text_length ((GtkEntry*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == ((guint) 0)) {
		ErrorEntry* _tmp3_;
		_tmp3_ = self->priv->entry;
		error_entry_set_error (_tmp3_, FALSE);
		return;
	}
	_tmp4_ = self->priv->entry;
	_tmp5_ = gtk_entry_get_text ((GtkEntry*) _tmp4_);
	_tmp6_ = g_strdup (_tmp5_);
	text = _tmp6_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				gboolean _tmp8_;
				gint _tmp10_;
				const gchar* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				const gchar* _tmp14_;
				gint _tmp15_;
				gchar _tmp16_ = '\0';
				gunichar c;
				gunichar _tmp17_;
				gboolean _tmp18_ = FALSE;
				_tmp8_ = _tmp7_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp10_ = i;
				_tmp11_ = text;
				_tmp12_ = strlen (_tmp11_);
				_tmp13_ = _tmp12_;
				if (!(_tmp10_ < _tmp13_)) {
					break;
				}
				_tmp14_ = text;
				_tmp15_ = i;
				_tmp16_ = string_get (_tmp14_, (glong) _tmp15_);
				c = (gunichar) _tmp16_;
				_tmp17_ = c;
				_tmp18_ = g_unichar_isdigit (_tmp17_);
				if (!_tmp18_) {
					ErrorEntry* _tmp19_;
					_tmp19_ = self->priv->entry;
					error_entry_set_error (_tmp19_, TRUE);
					_g_free0 (text);
					return;
				}
			}
		}
	}
	_tmp20_ = text;
	_tmp21_ = atoi (_tmp20_);
	line = _tmp21_;
	_tmp22_ = self->priv->entry;
	_tmp23_ = self->priv->main_window;
	_tmp24_ = main_window_get_active_document (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = line;
	line = _tmp26_ - 1;
	_tmp27_ = line;
	_tmp28_ = document_goto_line (_tmp25_, _tmp27_);
	error_entry_set_error (_tmp22_, !_tmp28_);
	_tmp29_ = self->priv->main_window;
	_tmp30_ = main_window_get_active_view (_tmp29_);
	_tmp31_ = _tmp30_;
	document_view_scroll_to_cursor (_tmp31_, 0.25);
	_g_free0 (text);
}


static void goto_line_class_init (GotoLineClass * klass) {
	goto_line_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GotoLinePrivate));
	G_OBJECT_CLASS (klass)->finalize = goto_line_finalize;
}


static void goto_line_instance_init (GotoLine * self) {
	self->priv = GOTO_LINE_GET_PRIVATE (self);
}


static void goto_line_finalize (GObject* obj) {
	GotoLine * self;
	self = GOTO_LINE (obj);
	_g_object_unref0 (self->priv->entry);
	G_OBJECT_CLASS (goto_line_parent_class)->finalize (obj);
}


GType goto_line_get_type (void) {
	static volatile gsize goto_line_type_id__volatile = 0;
	if (g_once_init_enter (&goto_line_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GotoLineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) goto_line_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GotoLine), 0, (GInstanceInitFunc) goto_line_instance_init, NULL };
		GType goto_line_type_id;
		goto_line_type_id = g_type_register_static (GTK_TYPE_GRID, "GotoLine", &g_define_type_info, 0);
		g_once_init_leave (&goto_line_type_id__volatile, goto_line_type_id);
	}
	return goto_line_type_id__volatile;
}


static GType search_and_replace_mode_get_type (void) {
	static volatile gsize search_and_replace_mode_type_id__volatile = 0;
	if (g_once_init_enter (&search_and_replace_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{SEARCH_AND_REPLACE_MODE_SEARCH, "SEARCH_AND_REPLACE_MODE_SEARCH", "search"}, {SEARCH_AND_REPLACE_MODE_SEARCH_AND_REPLACE, "SEARCH_AND_REPLACE_MODE_SEARCH_AND_REPLACE", "search-and-replace"}, {0, NULL, NULL}};
		GType search_and_replace_mode_type_id;
		search_and_replace_mode_type_id = g_enum_register_static ("SearchAndReplaceMode", values);
		g_once_init_leave (&search_and_replace_mode_type_id__volatile, search_and_replace_mode_type_id);
	}
	return search_and_replace_mode_type_id__volatile;
}


static SearchAndReplaceMode search_and_replace_get_mode (SearchAndReplace* self) {
	SearchAndReplaceMode result = 0;
	GtkArrow* _tmp0_;
	GtkArrowType _tmp1_ = 0;
	GtkArrowType _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_arrow;
	g_object_get (_tmp0_, "arrow-type", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == GTK_ARROW_UP) {
		result = SEARCH_AND_REPLACE_MODE_SEARCH_AND_REPLACE;
		return result;
	}
	result = SEARCH_AND_REPLACE_MODE_SEARCH;
	return result;
}


static Block12Data* block12_data_ref (Block12Data* _data12_) {
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}


static void block12_data_unref (void * _userdata_) {
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		SearchAndReplace * self;
		self = _data12_->self;
		_g_object_unref0 (_data12_->button_replace_all);
		_g_object_unref0 (_data12_->button_replace);
		_g_object_unref0 (_data12_->button_clear_replace);
		_g_object_unref0 (_data12_->button_next);
		_g_object_unref0 (_data12_->button_previous);
		_g_object_unref0 (_data12_->button_clear_find);
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}


static void __lambda62_ (SearchAndReplace* self) {
	SearchAndReplaceMode _tmp0_ = 0;
	_tmp0_ = search_and_replace_get_mode (self);
	if (_tmp0_ == SEARCH_AND_REPLACE_MODE_SEARCH_AND_REPLACE) {
		GtkArrow* _tmp1_;
		GtkGrid* _tmp2_;
		_tmp1_ = self->priv->_arrow;
		g_object_set (_tmp1_, "arrow-type", GTK_ARROW_DOWN, NULL);
		_tmp2_ = self->priv->_replace_grid;
		gtk_widget_hide ((GtkWidget*) _tmp2_);
	} else {
		GtkArrow* _tmp3_;
		GtkGrid* _tmp4_;
		_tmp3_ = self->priv->_arrow;
		g_object_set (_tmp3_, "arrow-type", GTK_ARROW_UP, NULL);
		_tmp4_ = self->priv->_replace_grid;
		gtk_widget_show ((GtkWidget*) _tmp4_);
	}
}


static void ___lambda62__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda62_ (self);
}


static void _search_and_replace_hide_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	search_and_replace_hide (self);
}


static void __lambda63_ (SearchAndReplace* self) {
	ErrorEntry* _tmp0_;
	_tmp0_ = self->priv->_entry_find;
	gtk_entry_set_text ((GtkEntry*) _tmp0_, "");
}


static void ___lambda63__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda63_ (self);
}


static void __lambda64_ (SearchAndReplace* self) {
	GtkEntry* _tmp0_;
	_tmp0_ = self->priv->_entry_replace;
	gtk_entry_set_text (_tmp0_, "");
}


static void ___lambda64__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda64_ (self);
}


static void __lambda65_ (SearchAndReplace* self) {
	Document* _tmp0_;
	Document* _tmp1_;
	search_and_replace_set_search_text (self, FALSE);
	_tmp0_ = self->priv->_working_document;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->priv->_working_document;
	document_search_backward (_tmp1_);
}


static void ___lambda65__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda65_ (self);
}


static void _search_and_replace_search_forward_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	search_and_replace_search_forward (self);
}


static void _search_and_replace_search_forward_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	search_and_replace_search_forward (self);
}


static void __lambda66_ (Block12Data* _data12_) {
	SearchAndReplace * self;
	ErrorEntry* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	gboolean sensitive;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	ErrorEntry* _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	self = _data12_->self;
	_tmp0_ = self->priv->_entry_find;
	_tmp1_ = gtk_entry_get_text_length ((GtkEntry*) _tmp0_);
	_tmp2_ = _tmp1_;
	sensitive = _tmp2_ > ((guint) 0);
	_tmp3_ = sensitive;
	gtk_widget_set_sensitive ((GtkWidget*) _data12_->button_clear_find, _tmp3_);
	_tmp4_ = sensitive;
	gtk_widget_set_sensitive ((GtkWidget*) _data12_->button_previous, _tmp4_);
	_tmp5_ = sensitive;
	gtk_widget_set_sensitive ((GtkWidget*) _data12_->button_next, _tmp5_);
	_tmp6_ = sensitive;
	gtk_widget_set_sensitive ((GtkWidget*) _data12_->button_replace, _tmp6_);
	_tmp7_ = sensitive;
	gtk_widget_set_sensitive ((GtkWidget*) _data12_->button_replace_all, _tmp7_);
	_tmp8_ = self->priv->_entry_find;
	_tmp9_ = gtk_entry_get_text_length ((GtkEntry*) _tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ == ((guint) 0)) {
		search_and_replace_clear_search (self);
	} else {
		ErrorEntry* _tmp11_;
		guint _tmp12_;
		guint _tmp13_;
		gint _tmp14_;
		_tmp11_ = self->priv->_entry_find;
		_tmp12_ = gtk_entry_get_text_length ((GtkEntry*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = self->priv->min_nb_chars_for_inc_search;
		if (_tmp13_ >= ((guint) _tmp14_)) {
			search_and_replace_set_search_text (self, TRUE);
		}
	}
}


static void ___lambda66__gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	__lambda66_ (self);
}


static void __lambda67_ (Block12Data* _data12_) {
	SearchAndReplace * self;
	GtkEntry* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	self = _data12_->self;
	_tmp0_ = self->priv->_entry_replace;
	_tmp1_ = gtk_entry_get_text_length (_tmp0_);
	_tmp2_ = _tmp1_;
	gtk_widget_set_sensitive ((GtkWidget*) _data12_->button_clear_replace, _tmp2_ > ((guint) 0));
}


static void ___lambda67__gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	__lambda67_ (self);
}


static void __lambda68_ (SearchAndReplace* self) {
	search_and_replace_set_search_text (self, TRUE);
}


static void ___lambda68__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	__lambda68_ (self);
}


static void __lambda69_ (SearchAndReplace* self) {
	search_and_replace_set_search_text (self, TRUE);
}


static void ___lambda69__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	__lambda69_ (self);
}


static void _search_and_replace_replace_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	search_and_replace_replace (self);
}


static void _search_and_replace_replace_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	search_and_replace_replace (self);
}


static void __lambda71_ (SearchAndReplace* self) {
	ErrorEntry* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	Document* _tmp3_;
	GtkEntry* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	_tmp0_ = self->priv->_entry_find;
	_tmp1_ = gtk_entry_get_text_length ((GtkEntry*) _tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != ((guint) 0));
	search_and_replace_set_search_text (self, TRUE);
	_tmp3_ = self->priv->_working_document;
	_tmp4_ = self->priv->_entry_replace;
	_tmp5_ = gtk_entry_get_text (_tmp4_);
	_tmp6_ = _tmp5_;
	document_replace_all (_tmp3_, _tmp6_);
}


static void ___lambda71__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda71_ (self);
}


static gboolean __lambda72_ (SearchAndReplace* self, GdkEventKey* event) {
	gboolean result = FALSE;
	GdkEventKey _tmp0_;
	guint _tmp1_;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.keyval;
	switch (_tmp1_) {
		case GDK_KEY_Tab:
		{
			GtkEntry* _tmp2_;
			search_and_replace_show_search_and_replace (self);
			_tmp2_ = self->priv->_entry_replace;
			gtk_widget_grab_focus ((GtkWidget*) _tmp2_);
			result = TRUE;
			return result;
		}
		case GDK_KEY_Escape:
		{
			search_and_replace_select_current_match (self);
			search_and_replace_hide (self);
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


static gboolean ___lambda72__gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = __lambda72_ (self, event);
	return result;
}


SearchAndReplace* search_and_replace_construct (GType object_type, MainWindow* main_window) {
	SearchAndReplace * self = NULL;
	Block12Data* _data12_;
	MainWindow* _tmp0_;
	GtkGrid* _tmp1_;
	GtkGrid* _tmp2_;
	GtkGrid* _tmp3_;
	GtkGrid* _tmp4_;
	GtkButton* _tmp5_;
	GtkButton* _tmp6_;
	GtkArrow* _tmp7_;
	GtkArrow* _tmp8_;
	GtkButton* _tmp9_;
	GtkArrow* _tmp10_;
	GtkGrid* _tmp11_;
	GtkButton* _tmp12_;
	GtkGrid* _tmp13_;
	GtkGrid* _tmp14_;
	GtkGrid* find_grid;
	GtkGrid* _tmp15_;
	ErrorEntry* _tmp16_;
	GtkButton* _tmp17_ = NULL;
	GtkButton* _tmp18_ = NULL;
	GtkButton* _tmp19_ = NULL;
	GtkButton* _tmp20_ = NULL;
	GtkButton* button_close;
	GtkGrid* _tmp21_;
	GtkGrid* _tmp22_;
	GtkGrid* _tmp23_;
	GtkGrid* _tmp24_;
	GtkGrid* _tmp25_;
	GtkGrid* _tmp26_;
	GtkEntry* _tmp27_;
	GtkEntry* _tmp28_;
	GtkEntry* _tmp29_;
	const gchar* _tmp30_ = NULL;
	GtkEntry* _tmp31_;
	GtkEntry* _tmp32_;
	GtkGrid* _tmp33_;
	GtkEntry* _tmp34_;
	GtkButton* _tmp35_ = NULL;
	GtkButton* _tmp36_ = NULL;
	GtkButton* _tmp37_;
	GtkButton* _tmp38_;
	GtkGrid* _tmp39_;
	GtkGrid* _tmp40_;
	GtkGrid* replace_all_grid;
	GtkImage* _tmp41_;
	GtkImage* _tmp42_;
	GtkImage* image;
	const gchar* _tmp43_ = NULL;
	GtkLabel* _tmp44_;
	GtkLabel* _tmp45_;
	GtkLabel* label;
	GtkGrid* _tmp46_;
	GtkGrid* _tmp47_;
	GtkGrid* _tmp48_;
	GtkButton* _tmp49_;
	ErrorEntry* _tmp50_;
	ErrorEntry* _tmp51_;
	GtkEntry* _tmp52_;
	GtkCheckMenuItem* _tmp53_;
	GtkCheckMenuItem* _tmp54_;
	GtkEntry* _tmp55_;
	ErrorEntry* _tmp56_;
	GtkGrid* _tmp57_;
	g_return_val_if_fail (main_window != NULL, NULL);
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	self = (SearchAndReplace*) g_object_new (object_type, NULL);
	_data12_->self = g_object_ref (self);
	_tmp0_ = main_window;
	self->priv->_main_window = _tmp0_;
	_tmp1_ = (GtkGrid*) gtk_grid_new ();
	_tmp2_ = g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->_main_grid);
	self->priv->_main_grid = _tmp2_;
	_tmp3_ = self->priv->_main_grid;
	gtk_grid_set_column_spacing (_tmp3_, (guint) 3);
	_tmp4_ = self->priv->_main_grid;
	gtk_grid_set_row_spacing (_tmp4_, (guint) 3);
	_tmp5_ = (GtkButton*) gtk_button_new ();
	_tmp6_ = g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->_button_arrow);
	self->priv->_button_arrow = _tmp6_;
	_tmp7_ = (GtkArrow*) gtk_arrow_new (GTK_ARROW_DOWN, GTK_SHADOW_OUT);
	_tmp8_ = g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->_arrow);
	self->priv->_arrow = _tmp8_;
	_tmp9_ = self->priv->_button_arrow;
	_tmp10_ = self->priv->_arrow;
	gtk_container_add ((GtkContainer*) _tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = self->priv->_main_grid;
	_tmp12_ = self->priv->_button_arrow;
	gtk_grid_attach (_tmp11_, (GtkWidget*) _tmp12_, 0, 0, 1, 1);
	_tmp13_ = (GtkGrid*) gtk_grid_new ();
	_tmp14_ = g_object_ref_sink (_tmp13_);
	find_grid = _tmp14_;
	gtk_orientable_set_orientation ((GtkOrientable*) find_grid, GTK_ORIENTATION_HORIZONTAL);
	gtk_grid_set_column_spacing (find_grid, (guint) 2);
	_tmp15_ = self->priv->_main_grid;
	gtk_grid_attach (_tmp15_, (GtkWidget*) find_grid, 1, 0, 1, 1);
	search_and_replace_init_find_entry (self);
	_tmp16_ = self->priv->_entry_find;
	gtk_container_add ((GtkContainer*) find_grid, (GtkWidget*) _tmp16_);
	_tmp17_ = search_and_replace_get_button (self, GTK_STOCK_CLEAR);
	_data12_->button_clear_find = _tmp17_;
	_tmp18_ = search_and_replace_get_button (self, GTK_STOCK_GO_UP);
	_data12_->button_previous = _tmp18_;
	_tmp19_ = search_and_replace_get_button (self, GTK_STOCK_GO_DOWN);
	_data12_->button_next = _tmp19_;
	_tmp20_ = search_and_replace_get_button (self, GTK_STOCK_CLOSE);
	button_close = _tmp20_;
	gtk_container_add ((GtkContainer*) find_grid, (GtkWidget*) _data12_->button_clear_find);
	gtk_container_add ((GtkContainer*) find_grid, (GtkWidget*) _data12_->button_previous);
	gtk_container_add ((GtkContainer*) find_grid, (GtkWidget*) _data12_->button_next);
	gtk_container_add ((GtkContainer*) find_grid, (GtkWidget*) button_close);
	gtk_widget_set_sensitive ((GtkWidget*) _data12_->button_clear_find, FALSE);
	gtk_widget_set_sensitive ((GtkWidget*) _data12_->button_previous, FALSE);
	gtk_widget_set_sensitive ((GtkWidget*) _data12_->button_next, FALSE);
	_tmp21_ = (GtkGrid*) gtk_grid_new ();
	_tmp22_ = g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->_replace_grid);
	self->priv->_replace_grid = _tmp22_;
	_tmp23_ = self->priv->_replace_grid;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp23_, GTK_ORIENTATION_HORIZONTAL);
	_tmp24_ = self->priv->_replace_grid;
	gtk_grid_set_column_spacing (_tmp24_, (guint) 2);
	_tmp25_ = self->priv->_main_grid;
	_tmp26_ = self->priv->_replace_grid;
	gtk_grid_attach (_tmp25_, (GtkWidget*) _tmp26_, 1, 1, 1, 1);
	_tmp27_ = (GtkEntry*) gtk_entry_new ();
	_tmp28_ = g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->priv->_entry_replace);
	self->priv->_entry_replace = _tmp28_;
	_tmp29_ = self->priv->_entry_replace;
	_tmp30_ = _ ("Replace with");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp29_, _tmp30_);
	_tmp31_ = self->priv->_entry_replace;
	g_object_set ((GtkWidget*) _tmp31_, "can-focus", TRUE, NULL);
	_tmp32_ = self->priv->_entry_replace;
	gtk_entry_set_width_chars (_tmp32_, 25);
	_tmp33_ = self->priv->_replace_grid;
	_tmp34_ = self->priv->_entry_replace;
	gtk_container_add ((GtkContainer*) _tmp33_, (GtkWidget*) _tmp34_);
	_tmp35_ = search_and_replace_get_button (self, GTK_STOCK_CLEAR);
	_data12_->button_clear_replace = _tmp35_;
	_tmp36_ = search_and_replace_get_button (self, GTK_STOCK_FIND_AND_REPLACE);
	_data12_->button_replace = _tmp36_;
	_tmp37_ = (GtkButton*) gtk_button_new ();
	_tmp38_ = g_object_ref_sink (_tmp37_);
	_data12_->button_replace_all = _tmp38_;
	gtk_button_set_relief (_data12_->button_replace_all, GTK_RELIEF_NONE);
	_tmp39_ = (GtkGrid*) gtk_grid_new ();
	_tmp40_ = g_object_ref_sink (_tmp39_);
	replace_all_grid = _tmp40_;
	gtk_orientable_set_orientation ((GtkOrientable*) replace_all_grid, GTK_ORIENTATION_HORIZONTAL);
	gtk_grid_set_column_spacing (replace_all_grid, (guint) 8);
	_tmp41_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_FIND_AND_REPLACE, GTK_ICON_SIZE_MENU);
	_tmp42_ = g_object_ref_sink (_tmp41_);
	image = _tmp42_;
	gtk_container_add ((GtkContainer*) replace_all_grid, (GtkWidget*) image);
	_tmp43_ = _ ("All");
	_tmp44_ = (GtkLabel*) gtk_label_new (_tmp43_);
	_tmp45_ = g_object_ref_sink (_tmp44_);
	label = _tmp45_;
	gtk_container_add ((GtkContainer*) replace_all_grid, (GtkWidget*) label);
	gtk_container_add ((GtkContainer*) _data12_->button_replace_all, (GtkWidget*) replace_all_grid);
	_tmp46_ = self->priv->_replace_grid;
	gtk_container_add ((GtkContainer*) _tmp46_, (GtkWidget*) _data12_->button_clear_replace);
	_tmp47_ = self->priv->_replace_grid;
	gtk_container_add ((GtkContainer*) _tmp47_, (GtkWidget*) _data12_->button_replace);
	_tmp48_ = self->priv->_replace_grid;
	gtk_container_add ((GtkContainer*) _tmp48_, (GtkWidget*) _data12_->button_replace_all);
	gtk_widget_set_sensitive ((GtkWidget*) _data12_->button_clear_replace, FALSE);
	gtk_widget_set_sensitive ((GtkWidget*) _data12_->button_replace, FALSE);
	gtk_widget_set_sensitive ((GtkWidget*) _data12_->button_replace_all, FALSE);
	_tmp49_ = self->priv->_button_arrow;
	g_signal_connect_object (_tmp49_, "clicked", (GCallback) ___lambda62__gtk_button_clicked, self, 0);
	g_signal_connect_object (button_close, "clicked", (GCallback) _search_and_replace_hide_gtk_button_clicked, self, 0);
	g_signal_connect_object (_data12_->button_clear_find, "clicked", (GCallback) ___lambda63__gtk_button_clicked, self, 0);
	g_signal_connect_object (_data12_->button_clear_replace, "clicked", (GCallback) ___lambda64__gtk_button_clicked, self, 0);
	g_signal_connect_object (_data12_->button_previous, "clicked", (GCallback) ___lambda65__gtk_button_clicked, self, 0);
	g_signal_connect_object (_data12_->button_next, "clicked", (GCallback) _search_and_replace_search_forward_gtk_button_clicked, self, 0);
	_tmp50_ = self->priv->_entry_find;
	g_signal_connect_object ((GtkEntry*) _tmp50_, "activate", (GCallback) _search_and_replace_search_forward_gtk_entry_activate, self, 0);
	_tmp51_ = self->priv->_entry_find;
	g_signal_connect_data ((GtkEditable*) _tmp51_, "changed", (GCallback) ___lambda66__gtk_editable_changed, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
	_tmp52_ = self->priv->_entry_replace;
	g_signal_connect_data ((GtkEditable*) _tmp52_, "changed", (GCallback) ___lambda67__gtk_editable_changed, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
	_tmp53_ = self->priv->_check_case_sensitive;
	g_signal_connect_object (_tmp53_, "toggled", (GCallback) ___lambda68__gtk_check_menu_item_toggled, self, 0);
	_tmp54_ = self->priv->_check_entire_word;
	g_signal_connect_object (_tmp54_, "toggled", (GCallback) ___lambda69__gtk_check_menu_item_toggled, self, 0);
	g_signal_connect_object (_data12_->button_replace, "clicked", (GCallback) _search_and_replace_replace_gtk_button_clicked, self, 0);
	_tmp55_ = self->priv->_entry_replace;
	g_signal_connect_object (_tmp55_, "activate", (GCallback) _search_and_replace_replace_gtk_entry_activate, self, 0);
	g_signal_connect_object (_data12_->button_replace_all, "clicked", (GCallback) ___lambda71__gtk_button_clicked, self, 0);
	_tmp56_ = self->priv->_entry_find;
	g_signal_connect_object ((GtkWidget*) _tmp56_, "key-press-event", (GCallback) ___lambda72__gtk_widget_key_press_event, self, 0);
	_tmp57_ = self->priv->_main_grid;
	gtk_widget_hide ((GtkWidget*) _tmp57_);
	_g_object_unref0 (label);
	_g_object_unref0 (image);
	_g_object_unref0 (replace_all_grid);
	_g_object_unref0 (button_close);
	_g_object_unref0 (find_grid);
	block12_data_unref (_data12_);
	_data12_ = NULL;
	return self;
}


SearchAndReplace* search_and_replace_new (MainWindow* main_window) {
	return search_and_replace_construct (TYPE_SEARCH_AND_REPLACE, main_window);
}


static Block13Data* block13_data_ref (Block13Data* _data13_) {
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}


static void block13_data_unref (void * _userdata_) {
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		SearchAndReplace * self;
		self = _data13_->self;
		_g_object_unref0 (_data13_->menu);
		_g_object_unref0 (self);
		g_slice_free (Block13Data, _data13_);
	}
}


static void __lambda61_ (Block13Data* _data13_, GtkEntryIconPosition icon_pos, GdkEvent* event) {
	SearchAndReplace * self;
	GtkEntryIconPosition _tmp0_;
	self = _data13_->self;
	g_return_if_fail (event != NULL);
	_tmp0_ = icon_pos;
	if (_tmp0_ == GTK_ENTRY_ICON_PRIMARY) {
		GdkEvent* _tmp1_;
		GdkEventButton _tmp2_;
		guint _tmp3_;
		GdkEvent* _tmp4_;
		GdkEventButton _tmp5_;
		guint32 _tmp6_;
		_tmp1_ = event;
		_tmp2_ = _tmp1_->button;
		_tmp3_ = _tmp2_.button;
		_tmp4_ = event;
		_tmp5_ = _tmp4_->button;
		_tmp6_ = _tmp5_.time;
		gtk_menu_popup (_data13_->menu, NULL, NULL, NULL, NULL, _tmp3_, _tmp6_);
	}
}


static void ___lambda61__gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self) {
	__lambda61_ (self, p0, p1);
}


static void search_and_replace_init_find_entry (SearchAndReplace* self) {
	Block13Data* _data13_;
	ErrorEntry* _tmp0_;
	ErrorEntry* _tmp1_;
	ErrorEntry* _tmp2_;
	GThemedIcon* _tmp3_;
	GThemedIcon* _tmp4_;
	ErrorEntry* _tmp5_;
	ErrorEntry* _tmp6_;
	const gchar* _tmp7_ = NULL;
	ErrorEntry* _tmp8_;
	ErrorEntry* _tmp9_;
	GtkMenu* _tmp10_;
	GtkMenu* _tmp11_;
	const gchar* _tmp12_ = NULL;
	GtkCheckMenuItem* _tmp13_;
	GtkCheckMenuItem* _tmp14_;
	const gchar* _tmp15_ = NULL;
	GtkCheckMenuItem* _tmp16_;
	GtkCheckMenuItem* _tmp17_;
	GtkCheckMenuItem* _tmp18_;
	GtkCheckMenuItem* _tmp19_;
	ErrorEntry* _tmp20_;
	g_return_if_fail (self != NULL);
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->self = g_object_ref (self);
	_tmp0_ = error_entry_new ();
	_tmp1_ = g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->_entry_find);
	self->priv->_entry_find = _tmp1_;
	_tmp2_ = self->priv->_entry_find;
	_tmp3_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks ("document-properties-symbolic");
	_tmp4_ = _tmp3_;
	g_object_set ((GtkEntry*) _tmp2_, "primary-icon-gicon", (GIcon*) _tmp4_, NULL);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = self->priv->_entry_find;
	g_object_set ((GtkEntry*) _tmp5_, "primary-icon-activatable", TRUE, NULL);
	_tmp6_ = self->priv->_entry_find;
	_tmp7_ = _ ("Search for");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp6_, _tmp7_);
	_tmp8_ = self->priv->_entry_find;
	g_object_set ((GtkWidget*) _tmp8_, "can-focus", TRUE, NULL);
	_tmp9_ = self->priv->_entry_find;
	gtk_entry_set_width_chars ((GtkEntry*) _tmp9_, 25);
	_tmp10_ = (GtkMenu*) gtk_menu_new ();
	_tmp11_ = g_object_ref_sink (_tmp10_);
	_data13_->menu = _tmp11_;
	_tmp12_ = _ ("Case sensitive");
	_tmp13_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_tmp12_);
	_tmp14_ = g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->_check_case_sensitive);
	self->priv->_check_case_sensitive = _tmp14_;
	_tmp15_ = _ ("Entire words only");
	_tmp16_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_tmp15_);
	_tmp17_ = g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->_check_entire_word);
	self->priv->_check_entire_word = _tmp17_;
	_tmp18_ = self->priv->_check_case_sensitive;
	gtk_menu_shell_append ((GtkMenuShell*) _data13_->menu, (GtkWidget*) ((GtkMenuItem*) _tmp18_));
	_tmp19_ = self->priv->_check_entire_word;
	gtk_menu_shell_append ((GtkMenuShell*) _data13_->menu, (GtkWidget*) ((GtkMenuItem*) _tmp19_));
	gtk_widget_show_all ((GtkWidget*) _data13_->menu);
	_tmp20_ = self->priv->_entry_find;
	g_signal_connect_data ((GtkEntry*) _tmp20_, "icon-press", (GCallback) ___lambda61__gtk_entry_icon_press, block13_data_ref (_data13_), (GClosureNotify) block13_data_unref, 0);
	block13_data_unref (_data13_);
	_data13_ = NULL;
}


static GtkButton* search_and_replace_get_button (SearchAndReplace* self, const gchar* stock_id) {
	GtkButton* result = NULL;
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* button;
	const gchar* _tmp2_;
	GtkImage* _tmp3_;
	GtkImage* _tmp4_;
	GtkImage* image;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (stock_id != NULL, NULL);
	_tmp0_ = (GtkButton*) gtk_button_new ();
	_tmp1_ = g_object_ref_sink (_tmp0_);
	button = _tmp1_;
	_tmp2_ = stock_id;
	_tmp3_ = (GtkImage*) gtk_image_new_from_stock (_tmp2_, GTK_ICON_SIZE_MENU);
	_tmp4_ = g_object_ref_sink (_tmp3_);
	image = _tmp4_;
	gtk_container_add ((GtkContainer*) button, (GtkWidget*) image);
	gtk_button_set_relief (button, GTK_RELIEF_NONE);
	result = button;
	_g_object_unref0 (image);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GtkWidget* search_and_replace_get_widget (SearchAndReplace* self) {
	GtkWidget* result = NULL;
	GtkGrid* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_main_grid;
	_tmp1_ = _g_object_ref0 ((GtkWidget*) _tmp0_);
	result = _tmp1_;
	return result;
}


void search_and_replace_show_search (SearchAndReplace* self) {
	GtkArrow* _tmp0_;
	GtkGrid* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_arrow;
	g_object_set (_tmp0_, "arrow-type", GTK_ARROW_DOWN, NULL);
	search_and_replace_show (self);
	_tmp1_ = self->priv->_replace_grid;
	gtk_widget_hide ((GtkWidget*) _tmp1_);
}


void search_and_replace_show_search_and_replace (SearchAndReplace* self) {
	GtkArrow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_arrow;
	g_object_set (_tmp0_, "arrow-type", GTK_ARROW_UP, NULL);
	search_and_replace_show (self);
}


static void _search_and_replace_set_replace_sensitivity_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	search_and_replace_set_replace_sensitivity (self);
}


static void search_and_replace_show (SearchAndReplace* self) {
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	GtkGrid* _tmp3_;
	ErrorEntry* _tmp4_;
	MainWindow* _tmp5_;
	Document* _tmp6_;
	Document* _tmp7_;
	Document* _tmp8_;
	Document* doc;
	Document* _tmp9_;
	SelectionType _tmp10_ = 0;
	MainWindow* _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->_main_grid;
	gtk_widget_show_all ((GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->_entry_find;
	gtk_widget_grab_focus ((GtkWidget*) _tmp4_);
	search_and_replace_set_replace_sensitivity (self);
	_tmp5_ = self->priv->_main_window;
	_tmp6_ = main_window_get_active_document (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	doc = _tmp8_;
	_tmp9_ = doc;
	_tmp10_ = document_get_selection_type (_tmp9_);
	if (_tmp10_ == SELECTION_TYPE_ONE_LINE) {
		GtkTextIter start = {0};
		GtkTextIter end = {0};
		Document* _tmp11_;
		GtkTextIter _tmp12_ = {0};
		GtkTextIter _tmp13_ = {0};
		ErrorEntry* _tmp14_;
		Document* _tmp15_;
		GtkTextIter _tmp16_;
		GtkTextIter _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		_tmp11_ = doc;
		gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) _tmp11_, &_tmp12_, &_tmp13_);
		start = _tmp12_;
		end = _tmp13_;
		_tmp14_ = self->priv->_entry_find;
		_tmp15_ = doc;
		_tmp16_ = start;
		_tmp17_ = end;
		_tmp18_ = gtk_text_buffer_get_text ((GtkTextBuffer*) _tmp15_, &_tmp16_, &_tmp17_, FALSE);
		_tmp19_ = _tmp18_;
		gtk_entry_set_text ((GtkEntry*) _tmp14_, _tmp19_);
		_g_free0 (_tmp19_);
	}
	_tmp20_ = self->priv->_main_window;
	g_signal_connect_object ((GObject*) _tmp20_, "notify::active-document", (GCallback) _search_and_replace_set_replace_sensitivity_g_object_notify, self, 0);
	_g_object_unref0 (doc);
}


void search_and_replace_hide (SearchAndReplace* self) {
	GtkGrid* _tmp0_;
	Document* _tmp1_;
	MainWindow* _tmp2_;
	DocumentView* _tmp3_;
	DocumentView* _tmp4_;
	MainWindow* _tmp8_;
	guint _tmp9_ = 0U;
	GQuark _tmp10_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_grid;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->_working_document;
	if (_tmp1_ != NULL) {
		search_and_replace_clear_search (self);
	}
	_tmp2_ = self->priv->_main_window;
	_tmp3_ = main_window_get_active_view (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		MainWindow* _tmp5_;
		DocumentView* _tmp6_;
		DocumentView* _tmp7_;
		_tmp5_ = self->priv->_main_window;
		_tmp6_ = main_window_get_active_view (_tmp5_);
		_tmp7_ = _tmp6_;
		gtk_widget_grab_focus ((GtkWidget*) _tmp7_);
	}
	_tmp8_ = self->priv->_main_window;
	g_signal_parse_name ("notify::active-document", G_TYPE_OBJECT, &_tmp9_, &_tmp10_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, _tmp10_, NULL, (GCallback) _search_and_replace_set_replace_sensitivity_g_object_notify, self);
}


static void search_and_replace_set_search_text (SearchAndReplace* self, gboolean select) {
	MainWindow* _tmp0_;
	Document* _tmp1_;
	Document* _tmp2_;
	ErrorEntry* _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	MainWindow* _tmp6_;
	Document* _tmp7_;
	Document* _tmp8_;
	Document* _tmp9_;
	guint nb_matches = 0U;
	Document* _tmp15_;
	ErrorEntry* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	guint _tmp24_ = 0U;
	ErrorEntry* _tmp25_;
	guint _tmp26_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_document (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->_entry_find;
	_tmp4_ = gtk_entry_get_text_length ((GtkEntry*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == ((guint) 0)) {
		return;
	}
	_tmp6_ = self->priv->_main_window;
	_tmp7_ = main_window_get_active_document (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->_working_document;
	if (_tmp8_ != _tmp9_) {
		Document* _tmp10_;
		MainWindow* _tmp11_;
		Document* _tmp12_;
		Document* _tmp13_;
		Document* _tmp14_;
		_tmp10_ = self->priv->_working_document;
		if (_tmp10_ != NULL) {
			search_and_replace_clear_search (self);
		}
		_tmp11_ = self->priv->_main_window;
		_tmp12_ = main_window_get_active_document (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _g_object_ref0 (_tmp13_);
		_g_object_unref0 (self->priv->_working_document);
		self->priv->_working_document = _tmp14_;
	}
	_tmp15_ = self->priv->_working_document;
	_tmp16_ = self->priv->_entry_find;
	_tmp17_ = gtk_entry_get_text ((GtkEntry*) _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = search_and_replace_get_case_sensitive (self);
	_tmp20_ = _tmp19_;
	_tmp21_ = search_and_replace_get_entire_word (self);
	_tmp22_ = _tmp21_;
	_tmp23_ = select;
	document_set_search_text (_tmp15_, _tmp18_, _tmp20_, _tmp22_, &_tmp24_, NULL, _tmp23_);
	nb_matches = _tmp24_;
	_tmp25_ = self->priv->_entry_find;
	_tmp26_ = nb_matches;
	error_entry_set_error (_tmp25_, _tmp26_ == ((guint) 0));
}


static void search_and_replace_select_current_match (SearchAndReplace* self) {
	MainWindow* _tmp0_;
	Document* _tmp1_;
	Document* _tmp2_;
	Document* _tmp3_;
	Document* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_document (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->_working_document;
	if (_tmp3_ != NULL) {
	}
	_tmp4_ = self->priv->_working_document;
	document_select_current_match (_tmp4_);
}


static void search_and_replace_search_forward (SearchAndReplace* self) {
	Document* _tmp0_;
	Document* _tmp1_;
	g_return_if_fail (self != NULL);
	search_and_replace_set_search_text (self, FALSE);
	_tmp0_ = self->priv->_working_document;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->priv->_working_document;
	document_search_forward (_tmp1_);
}


static void search_and_replace_clear_search (SearchAndReplace* self) {
	Document* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_working_document;
	if (_tmp0_ != NULL) {
		Document* _tmp1_;
		_tmp1_ = self->priv->_working_document;
		document_clear_search (_tmp1_, TRUE);
		_g_object_unref0 (self->priv->_working_document);
		self->priv->_working_document = NULL;
	}
}


static void search_and_replace_set_replace_sensitivity (SearchAndReplace* self) {
	MainWindow* _tmp0_;
	Document* _tmp1_;
	Document* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean readonly;
	GtkGrid* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_document (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = document_get_readonly (_tmp2_);
	_tmp4_ = _tmp3_;
	readonly = _tmp4_;
	_tmp5_ = self->priv->_replace_grid;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, !readonly);
}


static void search_and_replace_replace (SearchAndReplace* self) {
	ErrorEntry* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	Document* _tmp3_;
	GtkEntry* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_entry_find;
	_tmp1_ = gtk_entry_get_text_length ((GtkEntry*) _tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != ((guint) 0));
	search_and_replace_set_search_text (self, TRUE);
	_tmp3_ = self->priv->_working_document;
	_tmp4_ = self->priv->_entry_replace;
	_tmp5_ = gtk_entry_get_text (_tmp4_);
	_tmp6_ = _tmp5_;
	document_replace (_tmp3_, _tmp6_);
}


static gboolean search_and_replace_get_case_sensitive (SearchAndReplace* self) {
	gboolean result;
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_check_case_sensitive;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	result = _tmp1_;
	return result;
}


static gboolean search_and_replace_get_entire_word (SearchAndReplace* self) {
	gboolean result;
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_check_entire_word;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	result = _tmp1_;
	return result;
}


static void search_and_replace_class_init (SearchAndReplaceClass * klass) {
	search_and_replace_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SearchAndReplacePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_search_and_replace_get_property;
	G_OBJECT_CLASS (klass)->finalize = search_and_replace_finalize;
}


static void search_and_replace_instance_init (SearchAndReplace * self) {
	self->priv = SEARCH_AND_REPLACE_GET_PRIVATE (self);
	self->priv->min_nb_chars_for_inc_search = 3;
}


static void search_and_replace_finalize (GObject* obj) {
	SearchAndReplace * self;
	self = SEARCH_AND_REPLACE (obj);
	_g_object_unref0 (self->priv->_working_document);
	_g_object_unref0 (self->priv->_main_grid);
	_g_object_unref0 (self->priv->_replace_grid);
	_g_object_unref0 (self->priv->_button_arrow);
	_g_object_unref0 (self->priv->_arrow);
	_g_object_unref0 (self->priv->_entry_find);
	_g_object_unref0 (self->priv->_entry_replace);
	_g_object_unref0 (self->priv->_check_case_sensitive);
	_g_object_unref0 (self->priv->_check_entire_word);
	G_OBJECT_CLASS (search_and_replace_parent_class)->finalize (obj);
}


GType search_and_replace_get_type (void) {
	static volatile gsize search_and_replace_type_id__volatile = 0;
	if (g_once_init_enter (&search_and_replace_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SearchAndReplaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_and_replace_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchAndReplace), 0, (GInstanceInitFunc) search_and_replace_instance_init, NULL };
		GType search_and_replace_type_id;
		search_and_replace_type_id = g_type_register_static (G_TYPE_OBJECT, "SearchAndReplace", &g_define_type_info, 0);
		g_once_init_leave (&search_and_replace_type_id__volatile, search_and_replace_type_id);
	}
	return search_and_replace_type_id__volatile;
}


static void _vala_search_and_replace_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SearchAndReplace * self;
	self = SEARCH_AND_REPLACE (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



