/* stock_icons.c generated by valac 0.16.0, the Vala compiler
 * generated from stock_icons.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2012 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */
/* Add some icons to the stock icons, so it can be used e.g. in menus.*/
/* See also:*/
/* data/images/stock-icons/stock-icons.gresource.xml*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gobject/gvaluecollector.h>


#define TYPE_STOCK_ICONS (stock_icons_get_type ())
#define STOCK_ICONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STOCK_ICONS, StockIcons))
#define STOCK_ICONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STOCK_ICONS, StockIconsClass))
#define IS_STOCK_ICONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STOCK_ICONS))
#define IS_STOCK_ICONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STOCK_ICONS))
#define STOCK_ICONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STOCK_ICONS, StockIconsClass))

typedef struct _StockIcons StockIcons;
typedef struct _StockIconsClass StockIconsClass;
typedef struct _StockIconsPrivate StockIconsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gtk_icon_set_unref0(var) ((var == NULL) ? NULL : (var = (gtk_icon_set_unref (var), NULL)))
#define _gtk_icon_source_free0(var) ((var == NULL) ? NULL : (var = (gtk_icon_source_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecStockIcons ParamSpecStockIcons;

struct _StockIcons {
	GTypeInstance parent_instance;
	volatile int ref_count;
	StockIconsPrivate * priv;
};

struct _StockIconsClass {
	GTypeClass parent_class;
	void (*finalize) (StockIcons *self);
};

struct _ParamSpecStockIcons {
	GParamSpec parent_instance;
};


static gpointer stock_icons_parent_class = NULL;

gpointer stock_icons_ref (gpointer instance);
void stock_icons_unref (gpointer instance);
GParamSpec* param_spec_stock_icons (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_stock_icons (GValue* value, gpointer v_object);
void value_take_stock_icons (GValue* value, gpointer v_object);
gpointer value_get_stock_icons (const GValue* value);
GType stock_icons_get_type (void) G_GNUC_CONST;
enum  {
	STOCK_ICONS_DUMMY_PROPERTY
};
StockIcons* stock_icons_new (void);
StockIcons* stock_icons_construct (GType object_type);
static void stock_icons_register_new_stock_icons (StockIcons* self);
static void stock_icons_add_theme_icon_to_stock (StockIcons* self, const gchar* icon_name, const gchar* stock_id);
gchar* utils_get_shortname (const gchar* path);
static void stock_icons_finalize (StockIcons* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


StockIcons* stock_icons_construct (GType object_type) {
	StockIcons* self = NULL;
	self = (StockIcons*) g_type_create_instance (object_type);
	stock_icons_register_new_stock_icons (self);
	stock_icons_add_theme_icon_to_stock (self, "image-x-generic", "image");
	stock_icons_add_theme_icon_to_stock (self, "x-office-presentation", "presentation");
	return self;
}


StockIcons* stock_icons_new (void) {
	return stock_icons_construct (TYPE_STOCK_ICONS);
}


static void stock_icons_add_theme_icon_to_stock (StockIcons* self, const gchar* icon_name, const gchar* stock_id) {
	GtkIconSource* _tmp0_;
	GtkIconSource* icon_source;
	const gchar* _tmp1_;
	GtkIconSet* _tmp2_;
	GtkIconSet* icon_set;
	GtkIconFactory* _tmp3_;
	GtkIconFactory* icon_factory;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_name != NULL);
	g_return_if_fail (stock_id != NULL);
	_tmp0_ = gtk_icon_source_new ();
	icon_source = _tmp0_;
	_tmp1_ = icon_name;
	gtk_icon_source_set_icon_name (icon_source, _tmp1_);
	_tmp2_ = gtk_icon_set_new ();
	icon_set = _tmp2_;
	gtk_icon_set_add_source (icon_set, icon_source);
	_tmp3_ = gtk_icon_factory_new ();
	icon_factory = _tmp3_;
	_tmp4_ = stock_id;
	gtk_icon_factory_add (icon_factory, _tmp4_, icon_set);
	gtk_icon_factory_add_default (icon_factory);
	_g_object_unref0 (icon_factory);
	_gtk_icon_set_unref0 (icon_set);
	_gtk_icon_source_free0 (icon_source);
}


static void stock_icons_register_new_stock_icons (StockIcons* self) {
	gchar* _tmp0_;
	gchar* resource_path;
	gchar** icon_files = NULL;
	gint icon_files_length1 = 0;
	gint _icon_files_size_ = 0;
	GtkIconFactory* _tmp7_;
	GtkIconFactory* icon_factory;
	gchar** _tmp8_;
	gint _tmp8__length1;
	GtkIconFactory* _tmp30_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("/org/gnome/latexila/stock-icons/");
	resource_path = _tmp0_;
	{
		const gchar* _tmp1_;
		gchar** _tmp2_;
		gchar** _tmp3_ = NULL;
		gchar** _tmp4_;
		gint _tmp4__length1;
		gint __tmp4__size_;
		_tmp1_ = resource_path;
		_tmp3_ = _tmp2_ = g_resources_enumerate_children (_tmp1_, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_tmp4__length1 = _vala_array_length (_tmp2_);
		__tmp4__size_ = _tmp4__length1;
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		icon_files = (_vala_array_free (icon_files, icon_files_length1, (GDestroyNotify) g_free), NULL);
		icon_files = _tmp4_;
		icon_files_length1 = _tmp4__length1;
		_icon_files_size_ = icon_files_length1;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("stock_icons.vala:61: Failed to register new stock icons: %s", _tmp6_);
		_g_error_free0 (e);
		icon_files = (_vala_array_free (icon_files, icon_files_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (resource_path);
		return;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		icon_files = (_vala_array_free (icon_files, icon_files_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (resource_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = gtk_icon_factory_new ();
	icon_factory = _tmp7_;
	_tmp8_ = icon_files;
	_tmp8__length1 = icon_files_length1;
	{
		gchar** icon_file_collection = NULL;
		gint icon_file_collection_length1 = 0;
		gint _icon_file_collection_size_ = 0;
		gint icon_file_it = 0;
		icon_file_collection = _tmp8_;
		icon_file_collection_length1 = _tmp8__length1;
		for (icon_file_it = 0; icon_file_it < _tmp8__length1; icon_file_it = icon_file_it + 1) {
			gchar* _tmp9_;
			gchar* icon_file = NULL;
			_tmp9_ = g_strdup (icon_file_collection[icon_file_it]);
			icon_file = _tmp9_;
			{
				GtkIconSet* _tmp10_;
				GtkIconSet* icon_set;
				GtkIconSource* _tmp11_;
				GtkIconSource* icon_source;
				GdkPixbuf* pixbuf = NULL;
				GtkIconSource* _tmp21_;
				GdkPixbuf* _tmp22_;
				GtkIconSet* _tmp23_;
				GtkIconSource* _tmp24_;
				const gchar* _tmp25_;
				gchar* _tmp26_ = NULL;
				gchar* icon_name;
				GtkIconFactory* _tmp27_;
				const gchar* _tmp28_;
				GtkIconSet* _tmp29_;
				_tmp10_ = gtk_icon_set_new ();
				icon_set = _tmp10_;
				_tmp11_ = gtk_icon_source_new ();
				icon_source = _tmp11_;
				{
					const gchar* _tmp12_;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					GdkPixbuf* _tmp16_ = NULL;
					GdkPixbuf* _tmp17_;
					GdkPixbuf* _tmp18_;
					_tmp12_ = resource_path;
					_tmp13_ = icon_file;
					_tmp14_ = g_strconcat (_tmp12_, _tmp13_, NULL);
					_tmp15_ = _tmp14_;
					_tmp16_ = gdk_pixbuf_new_from_resource (_tmp15_, &_inner_error_);
					_tmp17_ = _tmp16_;
					_g_free0 (_tmp15_);
					_tmp18_ = _tmp17_;
					if (_inner_error_ != NULL) {
						goto __catch1_g_error;
					}
					_g_object_unref0 (pixbuf);
					pixbuf = _tmp18_;
				}
				goto __finally1;
				__catch1_g_error:
				{
					GError* e = NULL;
					GError* _tmp19_;
					const gchar* _tmp20_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp19_ = e;
					_tmp20_ = _tmp19_->message;
					g_warning ("stock_icons.vala:79: Failed to register stock icon: %s", _tmp20_);
					_g_error_free0 (e);
					_g_object_unref0 (pixbuf);
					_gtk_icon_source_free0 (icon_source);
					_gtk_icon_set_unref0 (icon_set);
					_g_free0 (icon_file);
					continue;
				}
				__finally1:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (pixbuf);
					_gtk_icon_source_free0 (icon_source);
					_gtk_icon_set_unref0 (icon_set);
					_g_free0 (icon_file);
					_g_object_unref0 (icon_factory);
					icon_files = (_vala_array_free (icon_files, icon_files_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (resource_path);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp21_ = icon_source;
				_tmp22_ = pixbuf;
				gtk_icon_source_set_pixbuf (_tmp21_, _tmp22_);
				_tmp23_ = icon_set;
				_tmp24_ = icon_source;
				gtk_icon_set_add_source (_tmp23_, _tmp24_);
				_tmp25_ = icon_file;
				_tmp26_ = utils_get_shortname (_tmp25_);
				icon_name = _tmp26_;
				_tmp27_ = icon_factory;
				_tmp28_ = icon_name;
				_tmp29_ = icon_set;
				gtk_icon_factory_add (_tmp27_, _tmp28_, _tmp29_);
				_g_free0 (icon_name);
				_g_object_unref0 (pixbuf);
				_gtk_icon_source_free0 (icon_source);
				_gtk_icon_set_unref0 (icon_set);
				_g_free0 (icon_file);
			}
		}
	}
	_tmp30_ = icon_factory;
	gtk_icon_factory_add_default (_tmp30_);
	_g_object_unref0 (icon_factory);
	icon_files = (_vala_array_free (icon_files, icon_files_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (resource_path);
}


static void value_stock_icons_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_stock_icons_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		stock_icons_unref (value->data[0].v_pointer);
	}
}


static void value_stock_icons_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = stock_icons_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_stock_icons_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_stock_icons_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		StockIcons* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = stock_icons_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_stock_icons_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	StockIcons** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = stock_icons_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_stock_icons (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecStockIcons* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_STOCK_ICONS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_stock_icons (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_STOCK_ICONS), NULL);
	return value->data[0].v_pointer;
}


void value_set_stock_icons (GValue* value, gpointer v_object) {
	StockIcons* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_STOCK_ICONS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_STOCK_ICONS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		stock_icons_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		stock_icons_unref (old);
	}
}


void value_take_stock_icons (GValue* value, gpointer v_object) {
	StockIcons* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_STOCK_ICONS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_STOCK_ICONS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		stock_icons_unref (old);
	}
}


static void stock_icons_class_init (StockIconsClass * klass) {
	stock_icons_parent_class = g_type_class_peek_parent (klass);
	STOCK_ICONS_CLASS (klass)->finalize = stock_icons_finalize;
}


static void stock_icons_instance_init (StockIcons * self) {
	self->ref_count = 1;
}


static void stock_icons_finalize (StockIcons* obj) {
	StockIcons * self;
	self = STOCK_ICONS (obj);
}


GType stock_icons_get_type (void) {
	static volatile gsize stock_icons_type_id__volatile = 0;
	if (g_once_init_enter (&stock_icons_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_stock_icons_init, value_stock_icons_free_value, value_stock_icons_copy_value, value_stock_icons_peek_pointer, "p", value_stock_icons_collect_value, "p", value_stock_icons_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (StockIconsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) stock_icons_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StockIcons), 0, (GInstanceInitFunc) stock_icons_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType stock_icons_type_id;
		stock_icons_type_id = g_type_register_fundamental (g_type_fundamental_next (), "StockIcons", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&stock_icons_type_id__volatile, stock_icons_type_id);
	}
	return stock_icons_type_id__volatile;
}


gpointer stock_icons_ref (gpointer instance) {
	StockIcons* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void stock_icons_unref (gpointer instance) {
	StockIcons* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		STOCK_ICONS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



