/* build_tool_runner.c generated by valac 0.18.0.80-b1b683, the Vala compiler
 * generated from build_tool_runner.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2012 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>


#define TYPE_BUILD_TOOL_RUNNER (build_tool_runner_get_type ())
#define BUILD_TOOL_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOL_RUNNER, BuildToolRunner))
#define BUILD_TOOL_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOL_RUNNER, BuildToolRunnerClass))
#define IS_BUILD_TOOL_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOL_RUNNER))
#define IS_BUILD_TOOL_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOL_RUNNER))
#define BUILD_TOOL_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOL_RUNNER, BuildToolRunnerClass))

typedef struct _BuildToolRunner BuildToolRunner;
typedef struct _BuildToolRunnerClass BuildToolRunnerClass;
typedef struct _BuildToolRunnerPrivate BuildToolRunnerPrivate;

#define TYPE_BUILD_TOOL (build_tool_get_type ())

#define TYPE_BUILD_JOB (build_job_get_type ())

#define TYPE_POST_PROCESSOR_TYPE (post_processor_type_get_type ())
typedef struct _BuildJob BuildJob;
typedef struct _BuildTool BuildTool;

#define TYPE_BUILD_VIEW (build_view_get_type ())
#define BUILD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_VIEW, BuildView))
#define BUILD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_VIEW, BuildViewClass))
#define IS_BUILD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_VIEW))
#define IS_BUILD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_VIEW))
#define BUILD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_VIEW, BuildViewClass))

typedef struct _BuildView BuildView;
typedef struct _BuildViewClass BuildViewClass;

#define TYPE_BUILD_JOB_RUNNER (build_job_runner_get_type ())
#define BUILD_JOB_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_JOB_RUNNER, BuildJobRunner))
#define BUILD_JOB_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_JOB_RUNNER, BuildJobRunnerClass))
#define IS_BUILD_JOB_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_JOB_RUNNER))
#define IS_BUILD_JOB_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_JOB_RUNNER))
#define BUILD_JOB_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_JOB_RUNNER, BuildJobRunnerClass))

typedef struct _BuildJobRunner BuildJobRunner;
typedef struct _BuildJobRunnerClass BuildJobRunnerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))

#define TYPE_BUILD_STATE (build_state_get_type ())

#define TYPE_BUILD_MSG (build_msg_get_type ())

#define TYPE_BUILD_MSG_TYPE (build_msg_type_get_type ())
typedef struct _BuildMsg BuildMsg;
#define _build_job_free0(var) ((var == NULL) ? NULL : (var = (build_job_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _BuildToolRunner {
	GObject parent_instance;
	BuildToolRunnerPrivate * priv;
};

struct _BuildToolRunnerClass {
	GObjectClass parent_class;
};

typedef enum  {
	POST_PROCESSOR_TYPE_ALL_OUTPUT = 0,
	POST_PROCESSOR_TYPE_LATEX,
	POST_PROCESSOR_TYPE_LATEXMK,
	POST_PROCESSOR_TYPE_NO_OUTPUT,
	POST_PROCESSOR_TYPE_N_POST_PROCESSORS
} PostProcessorType;

struct _BuildJob {
	PostProcessorType post_processor;
	gchar* command;
};

struct _BuildTool {
	gchar* _description;
	gchar* extensions;
	gchar* label;
	gchar* icon;
	gchar* files_to_open;
	gboolean enabled;
	GeeArrayList* jobs;
	gint id;
};

struct _BuildToolRunnerPrivate {
	BuildTool _tool;
	GFile* _on_file;
	BuildView* _view;
	GtkTreeIter _main_title;
	gint _job_num;
	BuildJob _current_job;
	GtkTreeIter* _current_job_title;
	BuildJobRunner* _current_job_runner;
	GtkTreeIter* _job_titles;
	gint _job_titles_length1;
	gint __job_titles_size_;
	BuildJobRunner** _job_runners;
	gint _job_runners_length1;
	gint __job_runners_size_;
	gboolean _aborted;
};

typedef enum  {
	BUILD_STATE_RUNNING,
	BUILD_STATE_SUCCEEDED,
	BUILD_STATE_FAILED,
	BUILD_STATE_ABORTED
} BuildState;

typedef enum  {
	BUILD_MSG_TYPE_TITLE,
	BUILD_MSG_TYPE_JOB_TITLE,
	BUILD_MSG_TYPE_JOB_SUB_COMMAND,
	BUILD_MSG_TYPE_ERROR,
	BUILD_MSG_TYPE_WARNING,
	BUILD_MSG_TYPE_BADBOX,
	BUILD_MSG_TYPE_INFO
} BuildMsgType;

struct _BuildMsg {
	BuildMsgType type;
	gchar* text;
	gchar* filename;
	gint start_line;
	gint end_line;
	gboolean expand;
	GeeList* children;
};


static gpointer build_tool_runner_parent_class = NULL;

GType build_tool_runner_get_type (void) G_GNUC_CONST;
GType build_tool_get_type (void) G_GNUC_CONST;
GType build_job_get_type (void) G_GNUC_CONST;
GType post_processor_type_get_type (void) G_GNUC_CONST;
BuildJob* build_job_dup (const BuildJob* self);
void build_job_free (BuildJob* self);
void build_job_copy (const BuildJob* self, BuildJob* dest);
void build_job_destroy (BuildJob* self);
BuildTool* build_tool_dup (const BuildTool* self);
void build_tool_free (BuildTool* self);
void build_tool_copy (const BuildTool* self, BuildTool* dest);
void build_tool_destroy (BuildTool* self);
GType build_view_get_type (void) G_GNUC_CONST;
GType build_job_runner_get_type (void) G_GNUC_CONST;
#define BUILD_TOOL_RUNNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BUILD_TOOL_RUNNER, BuildToolRunnerPrivate))
enum  {
	BUILD_TOOL_RUNNER_DUMMY_PROPERTY
};
BuildToolRunner* build_tool_runner_new (BuildTool* build_tool, GFile* on_file, BuildView* build_view);
BuildToolRunner* build_tool_runner_construct (GType object_type, BuildTool* build_tool, GFile* on_file, BuildView* build_view);
void build_view_clear (BuildView* self);
void build_view_set_has_details (BuildView* self, gboolean value);
GType build_state_get_type (void) G_GNUC_CONST;
void build_view_add_main_title (BuildView* self, const gchar* main_title, BuildState state, GtkTreeIter* result);
static void __lambda39_ (BuildToolRunner* self);
gboolean build_job_runner_has_details (BuildJobRunner* self);
static void ___lambda39__build_tool_runner_finished (BuildToolRunner* _sender, gpointer self);
static void __lambda40_ (BuildToolRunner* self);
void build_view_remove_children (BuildView* self, GtkTreeIter* parent);
GType build_msg_get_type (void) G_GNUC_CONST;
GType build_msg_type_get_type (void) G_GNUC_CONST;
BuildMsg* build_msg_dup (const BuildMsg* self);
void build_msg_free (BuildMsg* self);
void build_msg_copy (const BuildMsg* self, BuildMsg* dest);
void build_msg_destroy (BuildMsg* self);
gboolean build_view_get_show_details (BuildView* self);
GeeList* build_job_runner_get_detailed_messages (BuildJobRunner* self);
GeeList* build_job_runner_get_messages (BuildJobRunner* self);
void build_view_append_messages (BuildView* self, GtkTreeIter* parent, GeeList* messages, gboolean expand);
static void ___lambda40__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void build_tool_runner_abort (BuildToolRunner* self);
void build_job_runner_abort (BuildJobRunner* self);
void build_view_set_title_state (BuildView* self, GtkTreeIter* title_id, BuildState state);
void build_tool_runner_run (BuildToolRunner* self);
static void _vala_array_add7 (GtkTreeIter** array, int* length, int* size, const GtkTreeIter* value);
static void _vala_array_add8 (BuildJobRunner*** array, int* length, int* size, BuildJobRunner* value);
static void build_tool_runner_run_current_job (BuildToolRunner* self);
static gboolean build_tool_runner_open_files (BuildToolRunner* self);
BuildJobRunner* build_job_runner_new (BuildJob* build_job, GFile* on_file);
BuildJobRunner* build_job_runner_construct (GType object_type, BuildJob* build_job, GFile* on_file);
static gboolean build_tool_runner_add_job_title (BuildToolRunner* self);
static void build_tool_runner_failed (BuildToolRunner* self);
static void __lambda41_ (BuildToolRunner* self, gboolean success);
static void ___lambda41__build_job_runner_finished (BuildJobRunner* _sender, gboolean success, gpointer self);
void build_job_runner_run (BuildJobRunner* self, GError** error);
void build_msg_init (BuildMsg *self);
void build_view_append_single_message (BuildView* self, GtkTreeIter* parent, BuildMsg* msg, GtkTreeIter* result);
gchar* build_job_runner_get_command_name (BuildJobRunner* self);
gchar* build_job_runner_get_command_line (BuildJobRunner* self, GError** error);
void build_view_add_job_title (BuildView* self, const gchar* job_title, BuildState state, GtkTreeIter* result);
static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self);
static gboolean build_tool_runner_open_file (BuildToolRunner* self, const gchar* file_to_open);
gchar* utils_get_shortname (const gchar* path);
void utils_show_uri (GdkScreen* screen, const gchar* uri, GError** error);
static void build_tool_runner_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda39_ (BuildToolRunner* self) {
	BuildJobRunner** _tmp0_;
	gint _tmp0__length1;
	_tmp0_ = self->priv->_job_runners;
	_tmp0__length1 = self->priv->_job_runners_length1;
	{
		BuildJobRunner** job_runner_collection = NULL;
		gint job_runner_collection_length1 = 0;
		gint _job_runner_collection_size_ = 0;
		gint job_runner_it = 0;
		job_runner_collection = _tmp0_;
		job_runner_collection_length1 = _tmp0__length1;
		for (job_runner_it = 0; job_runner_it < _tmp0__length1; job_runner_it = job_runner_it + 1) {
			BuildJobRunner* _tmp1_;
			BuildJobRunner* job_runner = NULL;
			_tmp1_ = _g_object_ref0 (job_runner_collection[job_runner_it]);
			job_runner = _tmp1_;
			{
				BuildJobRunner* _tmp2_;
				gboolean _tmp3_ = FALSE;
				_tmp2_ = job_runner;
				_tmp3_ = build_job_runner_has_details (_tmp2_);
				if (_tmp3_) {
					BuildView* _tmp4_;
					_tmp4_ = self->priv->_view;
					build_view_set_has_details (_tmp4_, TRUE);
					_g_object_unref0 (job_runner);
					return;
				}
				_g_object_unref0 (job_runner);
			}
		}
	}
}


static void ___lambda39__build_tool_runner_finished (BuildToolRunner* _sender, gpointer self) {
	__lambda39_ (self);
}


static void __lambda40_ (BuildToolRunner* self) {
	{
		gint job_num;
		job_num = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				GtkTreeIter* _tmp4_;
				gint _tmp4__length1;
				GtkTreeIter* _tmp5_;
				gint _tmp5__length1;
				gint _tmp6_;
				GtkTreeIter _tmp7_;
				GtkTreeIter job_title;
				BuildJobRunner** _tmp8_;
				gint _tmp8__length1;
				gint _tmp9_;
				BuildJobRunner* _tmp10_;
				BuildJobRunner* _tmp11_;
				BuildJobRunner* job_runner;
				BuildJobRunner* _tmp12_;
				gboolean _tmp13_ = FALSE;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = job_num;
					job_num = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = job_num;
				_tmp4_ = self->priv->_job_titles;
				_tmp4__length1 = self->priv->_job_titles_length1;
				if (!(_tmp3_ < _tmp4__length1)) {
					break;
				}
				_tmp5_ = self->priv->_job_titles;
				_tmp5__length1 = self->priv->_job_titles_length1;
				_tmp6_ = job_num;
				_tmp7_ = _tmp5_[_tmp6_];
				job_title = _tmp7_;
				_tmp8_ = self->priv->_job_runners;
				_tmp8__length1 = self->priv->_job_runners_length1;
				_tmp9_ = job_num;
				_tmp10_ = _tmp8_[_tmp9_];
				_tmp11_ = _g_object_ref0 (_tmp10_);
				job_runner = _tmp11_;
				_tmp12_ = job_runner;
				_tmp13_ = build_job_runner_has_details (_tmp12_);
				if (_tmp13_) {
					BuildView* _tmp14_;
					GtkTreeIter _tmp15_;
					GeeList* messages = NULL;
					BuildView* _tmp16_;
					gboolean _tmp17_;
					gboolean _tmp18_;
					BuildView* _tmp23_;
					GtkTreeIter _tmp24_;
					GeeList* _tmp25_;
					_tmp14_ = self->priv->_view;
					_tmp15_ = job_title;
					build_view_remove_children (_tmp14_, &_tmp15_);
					_tmp16_ = self->priv->_view;
					_tmp17_ = build_view_get_show_details (_tmp16_);
					_tmp18_ = _tmp17_;
					if (_tmp18_) {
						BuildJobRunner* _tmp19_;
						GeeList* _tmp20_ = NULL;
						_tmp19_ = job_runner;
						_tmp20_ = build_job_runner_get_detailed_messages (_tmp19_);
						_g_object_unref0 (messages);
						messages = _tmp20_;
					} else {
						BuildJobRunner* _tmp21_;
						GeeList* _tmp22_ = NULL;
						_tmp21_ = job_runner;
						_tmp22_ = build_job_runner_get_messages (_tmp21_);
						_g_object_unref0 (messages);
						messages = _tmp22_;
					}
					_tmp23_ = self->priv->_view;
					_tmp24_ = job_title;
					_tmp25_ = messages;
					build_view_append_messages (_tmp23_, &_tmp24_, _tmp25_, TRUE);
					_g_object_unref0 (messages);
				}
				_g_object_unref0 (job_runner);
			}
		}
	}
}


static void ___lambda40__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda40_ (self);
}


BuildToolRunner* build_tool_runner_construct (GType object_type, BuildTool* build_tool, GFile* on_file, BuildView* build_view) {
	BuildToolRunner * self = NULL;
	BuildTool _tmp0_;
	BuildTool _tmp1_ = {0};
	GFile* _tmp2_;
	GFile* _tmp3_;
	BuildView* _tmp4_;
	BuildView* _tmp5_;
	BuildView* _tmp6_;
	BuildView* _tmp7_;
	BuildView* _tmp8_;
	BuildTool _tmp9_;
	const gchar* _tmp10_;
	GtkTreeIter _tmp11_ = {0};
	BuildView* _tmp12_;
	g_return_val_if_fail (build_tool != NULL, NULL);
	g_return_val_if_fail (on_file != NULL, NULL);
	g_return_val_if_fail (build_view != NULL, NULL);
	self = (BuildToolRunner*) g_object_new (object_type, NULL);
	_tmp0_ = *build_tool;
	build_tool_copy (&_tmp0_, &_tmp1_);
	build_tool_destroy (&self->priv->_tool);
	self->priv->_tool = _tmp1_;
	_tmp2_ = on_file;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->_on_file);
	self->priv->_on_file = _tmp3_;
	_tmp4_ = build_view;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->_view);
	self->priv->_view = _tmp5_;
	_tmp6_ = self->priv->_view;
	build_view_clear (_tmp6_);
	_tmp7_ = self->priv->_view;
	build_view_set_has_details (_tmp7_, FALSE);
	_tmp8_ = self->priv->_view;
	_tmp9_ = self->priv->_tool;
	_tmp10_ = _tmp9_.label;
	build_view_add_main_title (_tmp8_, _tmp10_, BUILD_STATE_RUNNING, &_tmp11_);
	self->priv->_main_title = _tmp11_;
	g_signal_connect_object (self, "finished", (GCallback) ___lambda39__build_tool_runner_finished, self, 0);
	_tmp12_ = self->priv->_view;
	g_signal_connect_object ((GObject*) _tmp12_, "notify::show-details", (GCallback) ___lambda40__g_object_notify, self, 0);
	return self;
}


BuildToolRunner* build_tool_runner_new (BuildTool* build_tool, GFile* on_file, BuildView* build_view) {
	return build_tool_runner_construct (TYPE_BUILD_TOOL_RUNNER, build_tool, on_file, build_view);
}


void build_tool_runner_abort (BuildToolRunner* self) {
	BuildJobRunner* _tmp0_;
	BuildView* _tmp2_;
	GtkTreeIter _tmp3_;
	GtkTreeIter* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_current_job_runner;
	if (_tmp0_ != NULL) {
		BuildJobRunner* _tmp1_;
		_tmp1_ = self->priv->_current_job_runner;
		build_job_runner_abort (_tmp1_);
	}
	_tmp2_ = self->priv->_view;
	_tmp3_ = self->priv->_main_title;
	build_view_set_title_state (_tmp2_, &_tmp3_, BUILD_STATE_ABORTED);
	_tmp4_ = self->priv->_current_job_title;
	if (_tmp4_ != NULL) {
		BuildView* _tmp5_;
		GtkTreeIter* _tmp6_;
		GtkTreeIter _tmp7_;
		_tmp5_ = self->priv->_view;
		_tmp6_ = self->priv->_current_job_title;
		_tmp7_ = *_tmp6_;
		build_view_set_title_state (_tmp5_, &_tmp7_, BUILD_STATE_ABORTED);
	}
	self->priv->_aborted = TRUE;
	g_signal_emit_by_name (self, "finished");
}


static void _vala_array_add7 (GtkTreeIter** array, int* length, int* size, const GtkTreeIter* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkTreeIter, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void _vala_array_add8 (BuildJobRunner*** array, int* length, int* size, BuildJobRunner* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (BuildJobRunner*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void build_tool_runner_run (BuildToolRunner* self) {
	gint _tmp0_;
	gint _tmp7_;
	BuildTool _tmp8_;
	GeeArrayList* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_job_num;
	if (_tmp0_ > 0) {
		GtkTreeIter* _tmp1_;
		gint _tmp1__length1;
		GtkTreeIter* _tmp2_;
		GtkTreeIter _tmp3_;
		BuildJobRunner** _tmp4_;
		gint _tmp4__length1;
		BuildJobRunner* _tmp5_;
		BuildJobRunner* _tmp6_;
		_tmp1_ = self->priv->_job_titles;
		_tmp1__length1 = self->priv->_job_titles_length1;
		_tmp2_ = self->priv->_current_job_title;
		_tmp3_ = *_tmp2_;
		_vala_array_add7 (&self->priv->_job_titles, &self->priv->_job_titles_length1, &self->priv->__job_titles_size_, &_tmp3_);
		_tmp4_ = self->priv->_job_runners;
		_tmp4__length1 = self->priv->_job_runners_length1;
		_tmp5_ = self->priv->_current_job_runner;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_vala_array_add8 (&self->priv->_job_runners, &self->priv->_job_runners_length1, &self->priv->__job_runners_size_, _tmp6_);
	}
	_g_object_unref0 (self->priv->_current_job_runner);
	self->priv->_current_job_runner = NULL;
	_tmp7_ = self->priv->_job_num;
	_tmp8_ = self->priv->_tool;
	_tmp9_ = _tmp8_.jobs;
	_tmp10_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp7_ < _tmp11_) {
		BuildTool _tmp12_;
		GeeArrayList* _tmp13_;
		gint _tmp14_;
		gpointer _tmp15_ = NULL;
		BuildJob* _tmp16_;
		BuildJob _tmp17_ = {0};
		_tmp12_ = self->priv->_tool;
		_tmp13_ = _tmp12_.jobs;
		_tmp14_ = self->priv->_job_num;
		_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, _tmp14_);
		_tmp16_ = (BuildJob*) _tmp15_;
		build_job_copy (_tmp16_, &_tmp17_);
		build_job_destroy (&self->priv->_current_job);
		self->priv->_current_job = _tmp17_;
		_build_job_free0 (_tmp16_);
		build_tool_runner_run_current_job (self);
	} else {
		gboolean _tmp18_ = FALSE;
		_tmp18_ = build_tool_runner_open_files (self);
		if (_tmp18_) {
			BuildView* _tmp19_;
			GtkTreeIter _tmp20_;
			_tmp19_ = self->priv->_view;
			_tmp20_ = self->priv->_main_title;
			build_view_set_title_state (_tmp19_, &_tmp20_, BUILD_STATE_SUCCEEDED);
			g_signal_emit_by_name (self, "finished");
		}
	}
}


static void __lambda41_ (BuildToolRunner* self, gboolean success) {
	GeeList* messages = NULL;
	BuildView* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	BuildView* _tmp7_;
	GtkTreeIter* _tmp8_;
	GeeList* _tmp9_;
	GtkTreeIter _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	BuildView* _tmp13_;
	GtkTreeIter* _tmp14_;
	GtkTreeIter _tmp15_;
	gint _tmp16_;
	_tmp0_ = self->priv->_view;
	_tmp1_ = build_view_get_show_details (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		BuildJobRunner* _tmp3_;
		GeeList* _tmp4_ = NULL;
		_tmp3_ = self->priv->_current_job_runner;
		_tmp4_ = build_job_runner_get_detailed_messages (_tmp3_);
		_g_object_unref0 (messages);
		messages = _tmp4_;
	} else {
		BuildJobRunner* _tmp5_;
		GeeList* _tmp6_ = NULL;
		_tmp5_ = self->priv->_current_job_runner;
		_tmp6_ = build_job_runner_get_messages (_tmp5_);
		_g_object_unref0 (messages);
		messages = _tmp6_;
	}
	_tmp7_ = self->priv->_view;
	_tmp8_ = self->priv->_current_job_title;
	_tmp9_ = messages;
	_tmp10_ = *_tmp8_;
	build_view_append_messages (_tmp7_, &_tmp10_, _tmp9_, TRUE);
	_tmp11_ = self->priv->_aborted;
	if (_tmp11_) {
		_g_object_unref0 (messages);
		return;
	}
	_tmp12_ = success;
	if (!_tmp12_) {
		build_tool_runner_failed (self);
		_g_object_unref0 (messages);
		return;
	}
	_tmp13_ = self->priv->_view;
	_tmp14_ = self->priv->_current_job_title;
	_tmp15_ = *_tmp14_;
	build_view_set_title_state (_tmp13_, &_tmp15_, BUILD_STATE_SUCCEEDED);
	_tmp16_ = self->priv->_job_num;
	self->priv->_job_num = _tmp16_ + 1;
	build_tool_runner_run (self);
	_g_object_unref0 (messages);
}


static void ___lambda41__build_job_runner_finished (BuildJobRunner* _sender, gboolean success, gpointer self) {
	__lambda41_ (self, success);
}


static void build_tool_runner_run_current_job (BuildToolRunner* self) {
	BuildJob _tmp0_;
	GFile* _tmp1_;
	BuildJobRunner* _tmp2_;
	gboolean _tmp3_ = FALSE;
	BuildJobRunner* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_current_job;
	_tmp1_ = self->priv->_on_file;
	_tmp2_ = build_job_runner_new (&_tmp0_, _tmp1_);
	_g_object_unref0 (self->priv->_current_job_runner);
	self->priv->_current_job_runner = _tmp2_;
	_tmp3_ = build_tool_runner_add_job_title (self);
	if (!_tmp3_) {
		build_tool_runner_failed (self);
		return;
	}
	_tmp4_ = self->priv->_current_job_runner;
	g_signal_connect_object (_tmp4_, "finished", (GCallback) ___lambda41__build_job_runner_finished, self, 0);
	{
		BuildJobRunner* _tmp5_;
		_tmp5_ = self->priv->_current_job_runner;
		build_job_runner_run (_tmp5_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SHELL_ERROR) {
				goto __catch5_g_shell_error;
			}
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_shell_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_critical ("build_tool_runner.vala:173: Failed to parse command line a second time" \
": %s", _tmp7_);
		build_tool_runner_failed (self);
		_g_error_free0 (e);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		BuildMsg error_msg = {0};
		GError* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		BuildView* _tmp11_;
		GtkTreeIter* _tmp12_;
		BuildMsg _tmp13_;
		GtkTreeIter _tmp14_;
		GtkTreeIter _tmp15_ = {0};
		GError* _tmp16_;
		e = _inner_error_;
		_inner_error_ = NULL;
		build_msg_init (&error_msg);
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (error_msg.text);
		error_msg.text = _tmp10_;
		error_msg.type = BUILD_MSG_TYPE_ERROR;
		_tmp11_ = self->priv->_view;
		_tmp12_ = self->priv->_current_job_title;
		_tmp13_ = error_msg;
		_tmp14_ = *_tmp12_;
		build_view_append_single_message (_tmp11_, &_tmp14_, &_tmp13_, &_tmp15_);
		_tmp16_ = e;
		if (g_error_matches (_tmp16_, G_SPAWN_ERROR, G_SPAWN_ERROR_NOENT)) {
			BuildJobRunner* _tmp17_;
			gchar* _tmp18_ = NULL;
			gchar* command_name;
			BuildMsg info_msg = {0};
			const gchar* _tmp19_ = NULL;
			const gchar* _tmp20_;
			gchar* _tmp21_ = NULL;
			BuildView* _tmp22_;
			GtkTreeIter* _tmp23_;
			BuildMsg _tmp24_;
			GtkTreeIter _tmp25_;
			GtkTreeIter _tmp26_ = {0};
			_tmp17_ = self->priv->_current_job_runner;
			_tmp18_ = build_job_runner_get_command_name (_tmp17_);
			command_name = _tmp18_;
			build_msg_init (&info_msg);
			_tmp19_ = _ ("%s doesn't seem to be installed.");
			_tmp20_ = command_name;
			_tmp21_ = g_strdup_printf (_tmp19_, _tmp20_);
			_g_free0 (info_msg.text);
			info_msg.text = _tmp21_;
			_tmp22_ = self->priv->_view;
			_tmp23_ = self->priv->_current_job_title;
			_tmp24_ = info_msg;
			_tmp25_ = *_tmp23_;
			build_view_append_single_message (_tmp22_, &_tmp25_, &_tmp24_, &_tmp26_);
			build_msg_destroy (&info_msg);
			_g_free0 (command_name);
		}
		build_tool_runner_failed (self);
		build_msg_destroy (&error_msg);
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self) {
	GtkTreeIter* dup;
	dup = g_new0 (GtkTreeIter, 1);
	memcpy (dup, self, sizeof (GtkTreeIter));
	return dup;
}


static gpointer __gtk_tree_iter_dup0 (gpointer self) {
	return self ? _gtk_tree_iter_dup (self) : NULL;
}


static gboolean build_tool_runner_add_job_title (BuildToolRunner* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		BuildJobRunner* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* command_line;
		BuildView* _tmp2_;
		GtkTreeIter _tmp3_ = {0};
		GtkTreeIter* _tmp4_;
		_tmp0_ = self->priv->_current_job_runner;
		_tmp1_ = build_job_runner_get_command_line (_tmp0_, &_inner_error_);
		command_line = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SHELL_ERROR) {
				goto __catch6_g_shell_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp2_ = self->priv->_view;
		build_view_add_job_title (_tmp2_, command_line, BUILD_STATE_RUNNING, &_tmp3_);
		_tmp4_ = __gtk_tree_iter_dup0 (&_tmp3_);
		_g_free0 (self->priv->_current_job_title);
		self->priv->_current_job_title = _tmp4_;
		result = TRUE;
		_g_free0 (command_line);
		return result;
	}
	goto __finally6;
	__catch6_g_shell_error:
	{
		GError* _error_ = NULL;
		BuildView* _tmp5_;
		BuildJob _tmp6_;
		const gchar* _tmp7_;
		GtkTreeIter _tmp8_ = {0};
		GtkTreeIter* _tmp9_;
		BuildMsg message = {0};
		gchar* _tmp10_;
		BuildView* _tmp11_;
		GtkTreeIter* _tmp12_;
		BuildMsg _tmp13_;
		GtkTreeIter _tmp14_;
		GtkTreeIter _tmp15_ = {0};
		GError* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		BuildView* _tmp19_;
		GtkTreeIter* _tmp20_;
		BuildMsg _tmp21_;
		GtkTreeIter _tmp22_;
		GtkTreeIter _tmp23_ = {0};
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = self->priv->_view;
		_tmp6_ = self->priv->_current_job;
		_tmp7_ = _tmp6_.command;
		build_view_add_job_title (_tmp5_, _tmp7_, BUILD_STATE_FAILED, &_tmp8_);
		_tmp9_ = __gtk_tree_iter_dup0 (&_tmp8_);
		_g_free0 (self->priv->_current_job_title);
		self->priv->_current_job_title = _tmp9_;
		build_msg_init (&message);
		_tmp10_ = g_strdup ("Failed to parse command line:");
		_g_free0 (message.text);
		message.text = _tmp10_;
		message.type = BUILD_MSG_TYPE_ERROR;
		_tmp11_ = self->priv->_view;
		_tmp12_ = self->priv->_current_job_title;
		_tmp13_ = message;
		_tmp14_ = *_tmp12_;
		build_view_append_single_message (_tmp11_, &_tmp14_, &_tmp13_, &_tmp15_);
		_tmp16_ = _error_;
		_tmp17_ = _tmp16_->message;
		_tmp18_ = g_strdup (_tmp17_);
		_g_free0 (message.text);
		message.text = _tmp18_;
		message.type = BUILD_MSG_TYPE_INFO;
		_tmp19_ = self->priv->_view;
		_tmp20_ = self->priv->_current_job_title;
		_tmp21_ = message;
		_tmp22_ = *_tmp20_;
		build_view_append_single_message (_tmp19_, &_tmp22_, &_tmp21_, &_tmp23_);
		result = FALSE;
		build_msg_destroy (&message);
		_g_error_free0 (_error_);
		return result;
	}
	__finally6:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return FALSE;
}


static gboolean build_tool_runner_open_files (BuildToolRunner* self) {
	gboolean result = FALSE;
	BuildTool _tmp0_;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** files_to_open;
	gint files_to_open_length1;
	gint _files_to_open_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_tool;
	_tmp1_ = _tmp0_.files_to_open;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, " ", 0);
	files_to_open = _tmp3_;
	files_to_open_length1 = _vala_array_length (_tmp2_);
	_files_to_open_size_ = files_to_open_length1;
	_tmp4_ = files_to_open;
	_tmp4__length1 = files_to_open_length1;
	{
		gchar** file_to_open_collection = NULL;
		gint file_to_open_collection_length1 = 0;
		gint _file_to_open_collection_size_ = 0;
		gint file_to_open_it = 0;
		file_to_open_collection = _tmp4_;
		file_to_open_collection_length1 = _tmp4__length1;
		for (file_to_open_it = 0; file_to_open_it < _tmp4__length1; file_to_open_it = file_to_open_it + 1) {
			gchar* _tmp5_;
			gchar* file_to_open = NULL;
			_tmp5_ = g_strdup (file_to_open_collection[file_to_open_it]);
			file_to_open = _tmp5_;
			{
				const gchar* _tmp6_;
				gboolean _tmp7_ = FALSE;
				_tmp6_ = file_to_open;
				_tmp7_ = build_tool_runner_open_file (self, _tmp6_);
				if (!_tmp7_) {
					result = FALSE;
					_g_free0 (file_to_open);
					files_to_open = (_vala_array_free (files_to_open, files_to_open_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_g_free0 (file_to_open);
			}
		}
	}
	result = TRUE;
	files_to_open = (_vala_array_free (files_to_open, files_to_open_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch7_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch7_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally7;
	__catch7_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gboolean build_tool_runner_open_file (BuildToolRunner* self, const gchar* file_to_open) {
	gboolean result = FALSE;
	GFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* filename;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* shortname;
	gchar* uri = NULL;
	const gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* basename;
	BuildView* _tmp18_;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_;
	GtkTreeIter _tmp23_ = {0};
	GtkTreeIter* _tmp24_;
	const gchar* _tmp25_;
	GFile* _tmp26_ = NULL;
	GFile* file;
	GFile* _tmp27_;
	gboolean _tmp28_ = FALSE;
	BuildView* _tmp56_;
	GtkTreeIter* _tmp57_;
	GtkTreeIter _tmp58_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file_to_open != NULL, FALSE);
	_tmp0_ = self->priv->_on_file;
	_tmp1_ = g_file_get_uri (_tmp0_);
	filename = _tmp1_;
	_tmp2_ = filename;
	_tmp3_ = utils_get_shortname (_tmp2_);
	shortname = _tmp3_;
	_tmp4_ = file_to_open;
	_tmp5_ = string_contains (_tmp4_, "$filename");
	if (_tmp5_) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_ = NULL;
		_tmp6_ = file_to_open;
		_tmp7_ = filename;
		_tmp8_ = string_replace (_tmp6_, "$filename", _tmp7_);
		_g_free0 (uri);
		uri = _tmp8_;
	} else {
		const gchar* _tmp9_;
		gboolean _tmp10_ = FALSE;
		_tmp9_ = file_to_open;
		_tmp10_ = string_contains (_tmp9_, "$shortname");
		if (_tmp10_) {
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_ = NULL;
			_tmp11_ = file_to_open;
			_tmp12_ = shortname;
			_tmp13_ = string_replace (_tmp11_, "$shortname", _tmp12_);
			_g_free0 (uri);
			uri = _tmp13_;
		} else {
			const gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp14_ = file_to_open;
			_tmp15_ = g_strconcat ("file://", _tmp14_, NULL);
			_g_free0 (uri);
			uri = _tmp15_;
		}
	}
	_tmp16_ = uri;
	_tmp17_ = g_path_get_basename (_tmp16_);
	basename = _tmp17_;
	_tmp18_ = self->priv->_view;
	_tmp19_ = _ ("Open %s");
	_tmp20_ = basename;
	_tmp21_ = g_strdup_printf (_tmp19_, _tmp20_);
	_tmp22_ = _tmp21_;
	build_view_add_job_title (_tmp18_, _tmp22_, BUILD_STATE_RUNNING, &_tmp23_);
	_tmp24_ = __gtk_tree_iter_dup0 (&_tmp23_);
	_g_free0 (self->priv->_current_job_title);
	self->priv->_current_job_title = _tmp24_;
	_g_free0 (_tmp22_);
	_tmp25_ = uri;
	_tmp26_ = g_file_new_for_uri (_tmp25_);
	file = _tmp26_;
	_tmp27_ = file;
	_tmp28_ = g_file_query_exists (_tmp27_, NULL);
	if (!_tmp28_) {
		BuildMsg message = {0};
		const gchar* _tmp29_ = NULL;
		const gchar* _tmp30_;
		gchar* _tmp31_ = NULL;
		BuildView* _tmp32_;
		GtkTreeIter* _tmp33_;
		BuildMsg _tmp34_;
		GtkTreeIter _tmp35_;
		GtkTreeIter _tmp36_ = {0};
		build_msg_init (&message);
		_tmp29_ = _ ("The file '%s' doesn't exist.");
		_tmp30_ = uri;
		_tmp31_ = g_strdup_printf (_tmp29_, _tmp30_);
		_g_free0 (message.text);
		message.text = _tmp31_;
		message.type = BUILD_MSG_TYPE_ERROR;
		_tmp32_ = self->priv->_view;
		_tmp33_ = self->priv->_current_job_title;
		_tmp34_ = message;
		_tmp35_ = *_tmp33_;
		build_view_append_single_message (_tmp32_, &_tmp35_, &_tmp34_, &_tmp36_);
		build_tool_runner_failed (self);
		result = FALSE;
		build_msg_destroy (&message);
		_g_object_unref0 (file);
		_g_free0 (basename);
		_g_free0 (uri);
		_g_free0 (shortname);
		_g_free0 (filename);
		return result;
	}
	{
		BuildView* _tmp37_;
		GdkScreen* _tmp38_ = NULL;
		const gchar* _tmp39_;
		_tmp37_ = self->priv->_view;
		_tmp38_ = gtk_widget_get_screen ((GtkWidget*) _tmp37_);
		_tmp39_ = uri;
		utils_show_uri (_tmp38_, _tmp39_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		BuildMsg message = {0};
		const gchar* _tmp40_ = NULL;
		const gchar* _tmp41_;
		gchar* _tmp42_ = NULL;
		BuildView* _tmp43_;
		GtkTreeIter* _tmp44_;
		BuildMsg _tmp45_;
		GtkTreeIter _tmp46_;
		GtkTreeIter _tmp47_ = {0};
		GError* _tmp48_;
		const gchar* _tmp49_;
		gchar* _tmp50_;
		BuildView* _tmp51_;
		GtkTreeIter* _tmp52_;
		BuildMsg _tmp53_;
		GtkTreeIter _tmp54_;
		GtkTreeIter _tmp55_ = {0};
		e = _inner_error_;
		_inner_error_ = NULL;
		build_msg_init (&message);
		_tmp40_ = _ ("Failed to open '%s':");
		_tmp41_ = uri;
		_tmp42_ = g_strdup_printf (_tmp40_, _tmp41_);
		_g_free0 (message.text);
		message.text = _tmp42_;
		message.type = BUILD_MSG_TYPE_ERROR;
		_tmp43_ = self->priv->_view;
		_tmp44_ = self->priv->_current_job_title;
		_tmp45_ = message;
		_tmp46_ = *_tmp44_;
		build_view_append_single_message (_tmp43_, &_tmp46_, &_tmp45_, &_tmp47_);
		_tmp48_ = e;
		_tmp49_ = _tmp48_->message;
		_tmp50_ = g_strdup (_tmp49_);
		_g_free0 (message.text);
		message.text = _tmp50_;
		_tmp51_ = self->priv->_view;
		_tmp52_ = self->priv->_current_job_title;
		_tmp53_ = message;
		_tmp54_ = *_tmp52_;
		build_view_append_single_message (_tmp51_, &_tmp54_, &_tmp53_, &_tmp55_);
		build_tool_runner_failed (self);
		result = FALSE;
		build_msg_destroy (&message);
		_g_error_free0 (e);
		_g_object_unref0 (file);
		_g_free0 (basename);
		_g_free0 (uri);
		_g_free0 (shortname);
		_g_free0 (filename);
		return result;
	}
	__finally8:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		_g_free0 (basename);
		_g_free0 (uri);
		_g_free0 (shortname);
		_g_free0 (filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp56_ = self->priv->_view;
	_tmp57_ = self->priv->_current_job_title;
	_tmp58_ = *_tmp57_;
	build_view_set_title_state (_tmp56_, &_tmp58_, BUILD_STATE_SUCCEEDED);
	result = TRUE;
	_g_object_unref0 (file);
	_g_free0 (basename);
	_g_free0 (uri);
	_g_free0 (shortname);
	_g_free0 (filename);
	return result;
}


static void build_tool_runner_failed (BuildToolRunner* self) {
	BuildView* _tmp0_;
	GtkTreeIter _tmp1_;
	BuildView* _tmp2_;
	GtkTreeIter* _tmp3_;
	GtkTreeIter _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_view;
	_tmp1_ = self->priv->_main_title;
	build_view_set_title_state (_tmp0_, &_tmp1_, BUILD_STATE_FAILED);
	_tmp2_ = self->priv->_view;
	_tmp3_ = self->priv->_current_job_title;
	_tmp4_ = *_tmp3_;
	build_view_set_title_state (_tmp2_, &_tmp4_, BUILD_STATE_FAILED);
	g_signal_emit_by_name (self, "finished");
}


static void build_tool_runner_class_init (BuildToolRunnerClass * klass) {
	build_tool_runner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BuildToolRunnerPrivate));
	G_OBJECT_CLASS (klass)->finalize = build_tool_runner_finalize;
	g_signal_new ("finished", TYPE_BUILD_TOOL_RUNNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void build_tool_runner_instance_init (BuildToolRunner * self) {
	GtkTreeIter* _tmp0_ = NULL;
	BuildJobRunner** _tmp1_ = NULL;
	self->priv = BUILD_TOOL_RUNNER_GET_PRIVATE (self);
	self->priv->_job_num = 0;
	self->priv->_current_job_title = NULL;
	self->priv->_current_job_runner = NULL;
	_tmp0_ = g_new0 (GtkTreeIter, 0);
	self->priv->_job_titles = _tmp0_;
	self->priv->_job_titles_length1 = 0;
	self->priv->__job_titles_size_ = self->priv->_job_titles_length1;
	_tmp1_ = g_new0 (BuildJobRunner*, 0 + 1);
	self->priv->_job_runners = _tmp1_;
	self->priv->_job_runners_length1 = 0;
	self->priv->__job_runners_size_ = self->priv->_job_runners_length1;
	self->priv->_aborted = FALSE;
}


static void build_tool_runner_finalize (GObject* obj) {
	BuildToolRunner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BUILD_TOOL_RUNNER, BuildToolRunner);
	build_tool_destroy (&self->priv->_tool);
	_g_object_unref0 (self->priv->_on_file);
	_g_object_unref0 (self->priv->_view);
	build_job_destroy (&self->priv->_current_job);
	_g_free0 (self->priv->_current_job_title);
	_g_object_unref0 (self->priv->_current_job_runner);
	self->priv->_job_titles = (g_free (self->priv->_job_titles), NULL);
	self->priv->_job_runners = (_vala_array_free (self->priv->_job_runners, self->priv->_job_runners_length1, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (build_tool_runner_parent_class)->finalize (obj);
}


GType build_tool_runner_get_type (void) {
	static volatile gsize build_tool_runner_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_runner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BuildToolRunnerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) build_tool_runner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BuildToolRunner), 0, (GInstanceInitFunc) build_tool_runner_instance_init, NULL };
		GType build_tool_runner_type_id;
		build_tool_runner_type_id = g_type_register_static (G_TYPE_OBJECT, "BuildToolRunner", &g_define_type_info, 0);
		g_once_init_leave (&build_tool_runner_type_id__volatile, build_tool_runner_type_id);
	}
	return build_tool_runner_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



