/* utils.c generated by valac 0.18.0.80-b1b683, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2012 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib/gi18n-lib.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define TYPE_SYNCTEX (synctex_get_type ())
#define SYNCTEX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYNCTEX, Synctex))
#define SYNCTEX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYNCTEX, SynctexClass))
#define IS_SYNCTEX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYNCTEX))
#define IS_SYNCTEX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYNCTEX))
#define SYNCTEX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYNCTEX, SynctexClass))

typedef struct _Synctex Synctex;
typedef struct _SynctexClass SynctexClass;
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))



gchar* utils_str_middle_truncate (const gchar* str, guint max_length);
gboolean utils_char_is_escaped (const gchar* text, glong char_index);
const gchar* utils_get_string_from_resource (const gchar* resource_path);
gchar* utils_replace_home_dir_with_tilde (const gchar* uri);
gchar* utils_uri_get_dirname (const gchar* uri);
gchar* utils_get_dirname_for_display (GFile* location);
gchar* utils_get_shortname (const gchar* path);
glong utils_get_extension_pos (const gchar* path);
gchar* utils_get_extension (const gchar* path);
void utils_delete_file (GFile* file);
gboolean utils_create_parent_directories (GFile* file);
gboolean utils_save_file (GFile* file, const gchar* contents, gboolean make_backup);
gchar* utils_load_file (GFile* file);
gchar* utils_get_relative_path (GFile* origin, GFile* target, GFile* common_dir);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void utils_show_uri (GdkScreen* screen, const gchar* uri, GError** error);
GType synctex_get_type (void) G_GNUC_CONST;
Synctex* synctex_get_default (void);
gboolean synctex_create_evince_window (Synctex* self, const gchar* pdf_uri);
GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child);
gboolean utils_tree_model_iter_prev (GtkTreeModel* model, GtkTreeIter* iter);
gint utils_get_selected_row (GtkTreeView* view, GtkTreeIter* iter);
GdkPixbuf* utils_get_pixbuf_from_stock (const gchar* stock_id, GtkIconSize size);
GtkGrid* utils_get_dialog_component (const gchar* title, GtkWidget* widget);
GtkWindow* utils_get_toplevel_window (GtkWidget* widget);
GtkDialog* utils_get_reset_all_confirm_dialog (GtkWindow* window, const gchar* msg);
void utils_flush_queue (void);


/*************************************************************************/
static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


gchar* utils_str_middle_truncate (const gchar* str, guint max_length) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint _tmp3_;
	guint _tmp6_;
	guint half_length;
	const gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint l;
	const gchar* _tmp10_;
	guint _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	gint _tmp17_;
	guint _tmp18_;
	gint _tmp19_;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = str;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = max_length;
	if (((guint) _tmp2_) <= _tmp3_) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = str;
		_tmp5_ = g_strdup (_tmp4_);
		result = _tmp5_;
		return result;
	}
	_tmp6_ = max_length;
	half_length = (_tmp6_ - 4) / 2;
	_tmp7_ = str;
	_tmp8_ = strlen (_tmp7_);
	_tmp9_ = _tmp8_;
	l = _tmp9_;
	_tmp10_ = str;
	_tmp11_ = half_length;
	_tmp12_ = string_slice (_tmp10_, (glong) 0, (glong) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp13_, "...", NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = str;
	_tmp17_ = l;
	_tmp18_ = half_length;
	_tmp19_ = l;
	_tmp20_ = string_slice (_tmp16_, (glong) (_tmp17_ - _tmp18_), (glong) _tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strconcat (_tmp15_, _tmp21_, NULL);
	_tmp23_ = _tmp22_;
	_g_free0 (_tmp21_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	result = _tmp23_;
	return result;
}


static gboolean string_get_prev_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	if (0 < _tmp0_) {
		gint _tmp1_;
		gchar* _tmp2_ = NULL;
		gint _tmp3_;
		gunichar _tmp4_ = 0U;
		_tmp1_ = *index;
		_tmp2_ = g_utf8_prev_char (((gchar*) self) + _tmp1_);
		*index = (gint) (_tmp2_ - ((gchar*) self));
		_tmp3_ = *index;
		_tmp4_ = g_utf8_get_char (((gchar*) self) + _tmp3_);
		_vala_c = _tmp4_;
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		_vala_c = (gunichar) 0;
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


gboolean utils_char_is_escaped (const gchar* text, glong char_index) {
	gboolean result = FALSE;
	glong _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean escaped;
	glong _tmp4_;
	gint index;
	gunichar cur_char = 0U;
	g_return_val_if_fail (text != NULL, FALSE);
	_tmp0_ = char_index;
	_tmp1_ = text;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	g_return_val_if_fail (_tmp0_ < ((glong) _tmp3_), FALSE);
	escaped = FALSE;
	_tmp4_ = char_index;
	index = (gint) _tmp4_;
	while (TRUE) {
		const gchar* _tmp5_;
		gunichar _tmp6_ = 0U;
		gboolean _tmp7_ = FALSE;
		gunichar _tmp8_;
		gboolean _tmp9_;
		_tmp5_ = text;
		_tmp7_ = string_get_prev_char (_tmp5_, &index, &_tmp6_);
		cur_char = _tmp6_;
		if (!_tmp7_) {
			break;
		}
		_tmp8_ = cur_char;
		if (_tmp8_ != ((gunichar) '\\')) {
			break;
		}
		_tmp9_ = escaped;
		escaped = !_tmp9_;
	}
	result = escaped;
	return result;
}


const gchar* utils_get_string_from_resource (const gchar* resource_path) {
	const gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (resource_path != NULL, NULL);
	{
		const gchar* _tmp0_;
		GBytes* _tmp1_ = NULL;
		GBytes* bytes;
		gsize _tmp2_;
		guint8* _tmp3_ = NULL;
		_tmp0_ = resource_path;
		_tmp1_ = g_resources_lookup_data (_tmp0_, 0, &_inner_error_);
		bytes = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch67_g_error;
		}
		_tmp3_ = g_bytes_get_data (bytes, &_tmp2_);
		result = (const gchar*) _tmp3_;
		_g_bytes_unref0 (bytes);
		return result;
	}
	goto __finally67;
	__catch67_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = resource_path;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("utils.vala:64: Failed to load data from resource '%s': %s", _tmp4_, _tmp6_);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally67:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


/*************************************************************************/
gchar* utils_replace_home_dir_with_tilde (const gchar* uri) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* home;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = uri;
	g_return_val_if_fail (_tmp0_ != NULL, NULL);
	_tmp1_ = g_get_home_dir ();
	_tmp2_ = g_strdup (_tmp1_);
	home = _tmp2_;
	_tmp3_ = uri;
	_tmp4_ = home;
	if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("~");
		result = _tmp5_;
		_g_free0 (home);
		return result;
	}
	_tmp6_ = uri;
	_tmp7_ = home;
	_tmp8_ = g_str_has_prefix (_tmp6_, _tmp7_);
	if (_tmp8_) {
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		const gchar* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp9_ = uri;
		_tmp10_ = home;
		_tmp11_ = strlen (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = uri;
		_tmp14_ = strlen (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = string_slice (_tmp9_, (glong) _tmp12_, (glong) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strconcat ("~", _tmp17_, NULL);
		_tmp19_ = _tmp18_;
		_g_free0 (_tmp17_);
		result = _tmp19_;
		_g_free0 (home);
		return result;
	}
	_tmp20_ = uri;
	_tmp21_ = g_strdup (_tmp20_);
	result = _tmp21_;
	_g_free0 (home);
	return result;
}


gchar* utils_uri_get_dirname (const gchar* uri) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* dir;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = uri;
	g_return_val_if_fail (_tmp0_ != NULL, NULL);
	_tmp1_ = uri;
	_tmp2_ = g_path_get_dirname (_tmp1_);
	dir = _tmp2_;
	_tmp3_ = dir;
	if (g_strcmp0 (_tmp3_, ".") == 0) {
		result = NULL;
		_g_free0 (dir);
		return result;
	}
	_tmp4_ = dir;
	_tmp5_ = utils_replace_home_dir_with_tilde (_tmp4_);
	result = _tmp5_;
	_g_free0 (dir);
	return result;
}


gchar* utils_get_dirname_for_display (GFile* location) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (location != NULL, NULL);
	{
		GFile* _tmp0_;
		GMount* _tmp1_ = NULL;
		GMount* mount;
		GMount* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* mount_name;
		GFile* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp10_;
		gchar* _tmp11_ = NULL;
		gchar* dirname;
		gboolean _tmp12_ = FALSE;
		const gchar* _tmp13_;
		gboolean _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp0_ = location;
		_tmp1_ = g_file_find_enclosing_mount (_tmp0_, NULL, &_inner_error_);
		mount = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch68_g_error;
		}
		_tmp2_ = mount;
		_tmp3_ = g_mount_get_name (_tmp2_);
		mount_name = _tmp3_;
		_tmp4_ = location;
		_tmp5_ = g_file_get_path (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		if (_tmp7_ == NULL) {
			GFile* _tmp8_;
			gchar* _tmp9_ = NULL;
			_tmp8_ = location;
			_tmp9_ = g_file_get_uri (_tmp8_);
			_g_free0 (_tmp6_);
			_tmp6_ = _tmp9_;
		}
		_tmp10_ = _tmp6_;
		_tmp11_ = utils_uri_get_dirname (_tmp10_);
		dirname = _tmp11_;
		_tmp13_ = dirname;
		if (_tmp13_ == NULL) {
			_tmp12_ = TRUE;
		} else {
			const gchar* _tmp14_;
			_tmp14_ = dirname;
			_tmp12_ = g_strcmp0 (_tmp14_, ".") == 0;
		}
		_tmp15_ = _tmp12_;
		if (_tmp15_) {
			result = mount_name;
			_g_free0 (dirname);
			_g_free0 (_tmp6_);
			_g_object_unref0 (mount);
			return result;
		}
		_tmp16_ = mount_name;
		_tmp17_ = g_strconcat (_tmp16_, " ", NULL);
		_tmp18_ = _tmp17_;
		_tmp19_ = dirname;
		_tmp20_ = g_strconcat (_tmp18_, _tmp19_, NULL);
		_tmp21_ = _tmp20_;
		_g_free0 (_tmp18_);
		result = _tmp21_;
		_g_free0 (dirname);
		_g_free0 (_tmp6_);
		_g_free0 (mount_name);
		_g_object_unref0 (mount);
		return result;
	}
	goto __finally68;
	__catch68_g_error:
	{
		GError* e = NULL;
		GFile* _tmp22_;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp28_;
		gchar* _tmp29_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp22_ = location;
		_tmp23_ = g_file_get_path (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = _tmp24_;
		if (_tmp25_ == NULL) {
			GFile* _tmp26_;
			gchar* _tmp27_ = NULL;
			_tmp26_ = location;
			_tmp27_ = g_file_get_uri (_tmp26_);
			_g_free0 (_tmp24_);
			_tmp24_ = _tmp27_;
		}
		_tmp28_ = _tmp24_;
		_tmp29_ = utils_uri_get_dirname (_tmp28_);
		result = _tmp29_;
		_g_free0 (_tmp24_);
		_g_error_free0 (e);
		return result;
	}
	__finally68:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


gchar* utils_get_shortname (const gchar* path) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	glong _tmp2_ = 0L;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = path;
	_tmp1_ = path;
	_tmp2_ = utils_get_extension_pos (_tmp1_);
	_tmp3_ = string_slice (_tmp0_, (glong) 0, _tmp2_);
	result = _tmp3_;
	return result;
}


gchar* utils_get_extension (const gchar* path) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	glong _tmp2_ = 0L;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = path;
	_tmp1_ = path;
	_tmp2_ = utils_get_extension_pos (_tmp1_);
	_tmp3_ = path;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = string_slice (_tmp0_, _tmp2_, (glong) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_utf8_strdown (_tmp7_, (gssize) (-1));
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	result = _tmp9_;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


glong utils_get_extension_pos (const gchar* path) {
	glong result = 0L;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	glong l;
	g_return_val_if_fail (path != NULL, 0L);
	_tmp0_ = path;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	l = (glong) _tmp2_;
	{
		glong _tmp3_;
		glong i;
		_tmp3_ = l;
		i = _tmp3_ - 1;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				glong _tmp7_;
				const gchar* _tmp8_;
				glong _tmp9_;
				gchar _tmp10_ = '\0';
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					glong _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ - 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = i;
				if (!(_tmp7_ >= ((glong) 0))) {
					break;
				}
				_tmp8_ = path;
				_tmp9_ = i;
				_tmp10_ = string_get (_tmp8_, _tmp9_);
				if (_tmp10_ == '/') {
					result = l;
					return result;
				} else {
					const gchar* _tmp11_;
					glong _tmp12_;
					gchar _tmp13_ = '\0';
					_tmp11_ = path;
					_tmp12_ = i;
					_tmp13_ = string_get (_tmp11_, _tmp12_);
					if (_tmp13_ == '.') {
						result = i;
						return result;
					}
				}
			}
		}
	}
	result = l;
	return result;
}


void utils_delete_file (GFile* file) {
	GFile* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (file != NULL);
	_tmp0_ = file;
	_tmp1_ = g_file_query_exists (_tmp0_, NULL);
	if (!_tmp1_) {
		return;
	}
	{
		GFile* _tmp2_;
		_tmp2_ = file;
		g_file_delete (_tmp2_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch69_g_error;
		}
	}
	goto __finally69;
	__catch69_g_error:
	{
		GError* e = NULL;
		GFile* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = file;
		_tmp4_ = g_file_get_parse_name (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("utils.vala:158: Delete file '%s' failed: %s", _tmp5_, _tmp7_);
		_g_free0 (_tmp5_);
		_g_error_free0 (e);
	}
	__finally69:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


gboolean utils_create_parent_directories (GFile* file) {
	gboolean result = FALSE;
	GFile* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* parent;
	gboolean _tmp2_ = FALSE;
	GFile* _tmp3_;
	gboolean _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = file;
	_tmp1_ = g_file_get_parent (_tmp0_);
	parent = _tmp1_;
	_tmp3_ = parent;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		GFile* _tmp4_;
		gboolean _tmp5_ = FALSE;
		_tmp4_ = parent;
		_tmp5_ = g_file_query_exists (_tmp4_, NULL);
		_tmp2_ = _tmp5_;
	}
	_tmp6_ = _tmp2_;
	if (_tmp6_) {
		result = TRUE;
		_g_object_unref0 (parent);
		return result;
	}
	{
		GFile* _tmp7_;
		_tmp7_ = parent;
		g_file_make_directory_with_parents (_tmp7_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch70_g_error;
		}
	}
	goto __finally70;
	__catch70_g_error:
	{
		GError* e = NULL;
		GFile* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = file;
		_tmp9_ = g_file_get_parse_name (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_warning ("utils.vala:175: Failed to create directory parents for the file '%s': " \
"%s", _tmp10_, _tmp12_);
		_g_free0 (_tmp10_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (parent);
		return result;
	}
	__finally70:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (parent);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	_g_object_unref0 (parent);
	return result;
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


gboolean utils_save_file (GFile* file, const gchar* contents, gboolean make_backup) {
	gboolean result = FALSE;
	GFile* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file != NULL, FALSE);
	g_return_val_if_fail (contents != NULL, FALSE);
	_tmp0_ = file;
	_tmp1_ = utils_create_parent_directories (_tmp0_);
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	{
		GFile* _tmp2_;
		const gchar* _tmp3_;
		guint8* _tmp4_;
		gint _tmp4__length1;
		guint8* _tmp5_;
		gint _tmp5__length1;
		gboolean _tmp6_;
		_tmp2_ = file;
		_tmp3_ = contents;
		_tmp4_ = string_get_data (_tmp3_, &_tmp4__length1);
		_tmp5_ = _tmp4_;
		_tmp5__length1 = _tmp4__length1;
		_tmp6_ = make_backup;
		g_file_replace_contents (_tmp2_, _tmp5_, (gsize) _tmp5__length1, NULL, _tmp6_, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch71_g_error;
		}
	}
	goto __finally71;
	__catch71_g_error:
	{
		GError* e = NULL;
		GFile* _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = file;
		_tmp8_ = g_file_get_parse_name (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_warning ("utils.vala:195: Failed to save the file '%s': %s", _tmp9_, _tmp11_);
		_g_free0 (_tmp9_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally71:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


gchar* utils_load_file (GFile* file) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	{
		guint8* chars = NULL;
		gint chars_length1 = 0;
		gint _chars_size_ = 0;
		GFile* _tmp0_;
		guint8* _tmp1_ = NULL;
		gsize _tmp2_;
		guint8* _tmp3_;
		gint _tmp3__length1;
		_tmp0_ = file;
		g_file_load_contents (_tmp0_, NULL, &_tmp1_, &_tmp2_, NULL, &_inner_error_);
		chars = (g_free (chars), NULL);
		chars = _tmp1_;
		chars_length1 = _tmp2_;
		_chars_size_ = chars_length1;
		if (_inner_error_ != NULL) {
			chars = (g_free (chars), NULL);
			goto __catch72_g_error;
		}
		_tmp3_ = chars;
		_tmp3__length1 = chars_length1;
		chars = NULL;
		result = (gchar*) _tmp3_;
		chars = (g_free (chars), NULL);
		return result;
	}
	goto __finally72;
	__catch72_g_error:
	{
		GError* e = NULL;
		GFile* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = file;
		_tmp5_ = g_file_get_parse_name (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("utils.vala:214: Failed to load the file '%s': %s", _tmp6_, _tmp8_);
		_g_free0 (_tmp6_);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally72:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


gchar* utils_get_relative_path (GFile* origin, GFile* target, GFile* common_dir) {
	gchar* result = NULL;
	GFile* origin_dir = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GFile* _tmp7_;
	GFile* _tmp8_ = NULL;
	GFile* target_parent;
	GFile* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	gboolean _tmp13_ = FALSE;
	GList* target_dirs;
	GList* origin_dirs;
	guint dir_index;
	guint _tmp56_;
	guint nb_common_dirs;
	gchar* _tmp57_;
	gchar* relative_path;
	GList* _tmp58_;
	guint _tmp59_ = 0U;
	guint _tmp60_;
	guint nb_remaining_origin_dirs;
	const gchar* _tmp86_;
	GFile* _tmp87_;
	gchar* _tmp88_ = NULL;
	gchar* _tmp89_;
	gchar* _tmp90_;
	g_return_val_if_fail (origin != NULL, NULL);
	g_return_val_if_fail (target != NULL, NULL);
	g_return_val_if_fail (common_dir != NULL, NULL);
	_tmp0_ = origin;
	_tmp1_ = common_dir;
	_tmp2_ = g_file_equal (_tmp0_, _tmp1_);
	if (_tmp2_) {
		GFile* _tmp3_;
		GFile* _tmp4_;
		_tmp3_ = origin;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_g_object_unref0 (origin_dir);
		origin_dir = _tmp4_;
	} else {
		GFile* _tmp5_;
		GFile* _tmp6_ = NULL;
		_tmp5_ = origin;
		_tmp6_ = g_file_get_parent (_tmp5_);
		_g_object_unref0 (origin_dir);
		origin_dir = _tmp6_;
	}
	_tmp7_ = target;
	_tmp8_ = g_file_get_parent (_tmp7_);
	target_parent = _tmp8_;
	_tmp9_ = origin_dir;
	g_return_val_if_fail (_tmp9_ != NULL, NULL);
	_tmp10_ = target_parent;
	g_return_val_if_fail (_tmp10_ != NULL, NULL);
	_tmp11_ = target_parent;
	_tmp12_ = origin_dir;
	_tmp13_ = g_file_equal (_tmp11_, _tmp12_);
	if (_tmp13_) {
		GFile* _tmp14_;
		gchar* _tmp15_ = NULL;
		_tmp14_ = target;
		_tmp15_ = g_file_get_basename (_tmp14_);
		result = _tmp15_;
		_g_object_unref0 (target_parent);
		_g_object_unref0 (origin_dir);
		return result;
	}
	target_dirs = NULL;
	origin_dirs = NULL;
	while (TRUE) {
		gboolean _tmp16_ = FALSE;
		GFile* _tmp17_;
		gboolean _tmp21_;
		GFile* _tmp22_;
		GFile* _tmp23_;
		GFile* _tmp24_;
		GFile* _tmp25_ = NULL;
		_tmp17_ = target_parent;
		if (_tmp17_ != NULL) {
			GFile* _tmp18_;
			GFile* _tmp19_;
			gboolean _tmp20_ = FALSE;
			_tmp18_ = target_parent;
			_tmp19_ = common_dir;
			_tmp20_ = g_file_equal (_tmp18_, _tmp19_);
			_tmp16_ = !_tmp20_;
		} else {
			_tmp16_ = FALSE;
		}
		_tmp21_ = _tmp16_;
		if (!_tmp21_) {
			break;
		}
		_tmp22_ = target_parent;
		_tmp23_ = _g_object_ref0 (_tmp22_);
		target_dirs = g_list_prepend (target_dirs, _tmp23_);
		_tmp24_ = target_parent;
		_tmp25_ = g_file_get_parent (_tmp24_);
		_g_object_unref0 (target_parent);
		target_parent = _tmp25_;
	}
	while (TRUE) {
		gboolean _tmp26_ = FALSE;
		GFile* _tmp27_;
		gboolean _tmp31_;
		GFile* _tmp32_;
		GFile* _tmp33_;
		GFile* _tmp34_;
		GFile* _tmp35_ = NULL;
		_tmp27_ = origin_dir;
		if (_tmp27_ != NULL) {
			GFile* _tmp28_;
			GFile* _tmp29_;
			gboolean _tmp30_ = FALSE;
			_tmp28_ = origin_dir;
			_tmp29_ = common_dir;
			_tmp30_ = g_file_equal (_tmp28_, _tmp29_);
			_tmp26_ = !_tmp30_;
		} else {
			_tmp26_ = FALSE;
		}
		_tmp31_ = _tmp26_;
		if (!_tmp31_) {
			break;
		}
		_tmp32_ = origin_dir;
		_tmp33_ = _g_object_ref0 (_tmp32_);
		origin_dirs = g_list_prepend (origin_dirs, _tmp33_);
		_tmp34_ = origin_dir;
		_tmp35_ = g_file_get_parent (_tmp34_);
		_g_object_unref0 (origin_dir);
		origin_dir = _tmp35_;
	}
	dir_index = (guint) 0;
	while (TRUE) {
		gboolean _tmp36_ = FALSE;
		guint _tmp37_;
		GList* _tmp38_;
		guint _tmp39_ = 0U;
		gboolean _tmp43_;
		GList* _tmp44_;
		guint _tmp45_;
		gconstpointer _tmp46_ = NULL;
		GFile* _tmp47_;
		GFile* cur_target_dir;
		GList* _tmp48_;
		guint _tmp49_;
		gconstpointer _tmp50_ = NULL;
		GFile* _tmp51_;
		GFile* cur_origin_dir;
		GFile* _tmp52_;
		GFile* _tmp53_;
		gboolean _tmp54_ = FALSE;
		guint _tmp55_;
		_tmp37_ = dir_index;
		_tmp38_ = target_dirs;
		_tmp39_ = g_list_length (_tmp38_);
		if (_tmp37_ < _tmp39_) {
			guint _tmp40_;
			GList* _tmp41_;
			guint _tmp42_ = 0U;
			_tmp40_ = dir_index;
			_tmp41_ = origin_dirs;
			_tmp42_ = g_list_length (_tmp41_);
			_tmp36_ = _tmp40_ < _tmp42_;
		} else {
			_tmp36_ = FALSE;
		}
		_tmp43_ = _tmp36_;
		if (!_tmp43_) {
			break;
		}
		_tmp44_ = target_dirs;
		_tmp45_ = dir_index;
		_tmp46_ = g_list_nth_data (_tmp44_, _tmp45_);
		_tmp47_ = _g_object_ref0 ((GFile*) _tmp46_);
		cur_target_dir = _tmp47_;
		_tmp48_ = origin_dirs;
		_tmp49_ = dir_index;
		_tmp50_ = g_list_nth_data (_tmp48_, _tmp49_);
		_tmp51_ = _g_object_ref0 ((GFile*) _tmp50_);
		cur_origin_dir = _tmp51_;
		_tmp52_ = cur_target_dir;
		_tmp53_ = cur_origin_dir;
		_tmp54_ = g_file_equal (_tmp52_, _tmp53_);
		if (!_tmp54_) {
			_g_object_unref0 (cur_origin_dir);
			_g_object_unref0 (cur_target_dir);
			break;
		}
		_tmp55_ = dir_index;
		dir_index = _tmp55_ + 1;
		_g_object_unref0 (cur_origin_dir);
		_g_object_unref0 (cur_target_dir);
	}
	_tmp56_ = dir_index;
	nb_common_dirs = _tmp56_;
	_tmp57_ = g_strdup ("");
	relative_path = _tmp57_;
	_tmp58_ = origin_dirs;
	_tmp59_ = g_list_length (_tmp58_);
	_tmp60_ = nb_common_dirs;
	nb_remaining_origin_dirs = _tmp59_ - _tmp60_;
	{
		guint i;
		i = (guint) 0;
		{
			gboolean _tmp61_;
			_tmp61_ = TRUE;
			while (TRUE) {
				gboolean _tmp62_;
				guint _tmp64_;
				guint _tmp65_;
				const gchar* _tmp66_;
				gchar* _tmp67_;
				_tmp62_ = _tmp61_;
				if (!_tmp62_) {
					guint _tmp63_;
					_tmp63_ = i;
					i = _tmp63_ + 1;
				}
				_tmp61_ = FALSE;
				_tmp64_ = i;
				_tmp65_ = nb_remaining_origin_dirs;
				if (!(_tmp64_ < _tmp65_)) {
					break;
				}
				_tmp66_ = relative_path;
				_tmp67_ = g_strconcat (_tmp66_, "../", NULL);
				_g_free0 (relative_path);
				relative_path = _tmp67_;
			}
		}
	}
	{
		guint _tmp68_;
		guint i;
		_tmp68_ = nb_common_dirs;
		i = _tmp68_;
		{
			gboolean _tmp69_;
			_tmp69_ = TRUE;
			while (TRUE) {
				gboolean _tmp70_;
				guint _tmp72_;
				GList* _tmp73_;
				guint _tmp74_ = 0U;
				GList* _tmp75_;
				guint _tmp76_;
				gconstpointer _tmp77_ = NULL;
				GFile* _tmp78_;
				GFile* cur_target_dir;
				const gchar* _tmp79_;
				GFile* _tmp80_;
				gchar* _tmp81_ = NULL;
				gchar* _tmp82_;
				gchar* _tmp83_;
				gchar* _tmp84_;
				gchar* _tmp85_;
				_tmp70_ = _tmp69_;
				if (!_tmp70_) {
					guint _tmp71_;
					_tmp71_ = i;
					i = _tmp71_ + 1;
				}
				_tmp69_ = FALSE;
				_tmp72_ = i;
				_tmp73_ = target_dirs;
				_tmp74_ = g_list_length (_tmp73_);
				if (!(_tmp72_ < _tmp74_)) {
					break;
				}
				_tmp75_ = target_dirs;
				_tmp76_ = i;
				_tmp77_ = g_list_nth_data (_tmp75_, _tmp76_);
				_tmp78_ = _g_object_ref0 ((GFile*) _tmp77_);
				cur_target_dir = _tmp78_;
				_tmp79_ = relative_path;
				_tmp80_ = cur_target_dir;
				_tmp81_ = g_file_get_basename (_tmp80_);
				_tmp82_ = _tmp81_;
				_tmp83_ = g_strconcat (_tmp82_, "/", NULL);
				_tmp84_ = _tmp83_;
				_tmp85_ = g_strconcat (_tmp79_, _tmp84_, NULL);
				_g_free0 (relative_path);
				relative_path = _tmp85_;
				_g_free0 (_tmp84_);
				_g_free0 (_tmp82_);
				_g_object_unref0 (cur_target_dir);
			}
		}
	}
	_tmp86_ = relative_path;
	_tmp87_ = target;
	_tmp88_ = g_file_get_basename (_tmp87_);
	_tmp89_ = _tmp88_;
	_tmp90_ = g_strconcat (_tmp86_, _tmp89_, NULL);
	_g_free0 (relative_path);
	relative_path = _tmp90_;
	_g_free0 (_tmp89_);
	result = relative_path;
	__g_list_free__g_object_unref0_0 (origin_dirs);
	__g_list_free__g_object_unref0_0 (target_dirs);
	_g_object_unref0 (target_parent);
	_g_object_unref0 (origin_dir);
	return result;
}


void utils_show_uri (GdkScreen* screen, const gchar* uri, GError** error) {
	GdkScreen* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gboolean _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (uri != NULL);
	_tmp0_ = screen;
	_tmp1_ = uri;
	_tmp2_ = gtk_show_uri (_tmp0_, _tmp1_, (guint32) GDK_CURRENT_TIME, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	if (!_tmp3_) {
		return;
	}
	_tmp4_ = uri;
	_tmp5_ = utils_get_extension (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strcmp0 (_tmp6_, ".pdf") == 0;
	_g_free0 (_tmp6_);
	if (_tmp7_) {
		Synctex* _tmp8_ = NULL;
		Synctex* synctex;
		Synctex* _tmp9_;
		const gchar* _tmp10_;
		_tmp8_ = synctex_get_default ();
		synctex = _tmp8_;
		_tmp9_ = synctex;
		_tmp10_ = uri;
		synctex_create_evince_window (_tmp9_, _tmp10_);
		_g_object_unref0 (synctex);
	}
}


/*************************************************************************/
GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child) {
	GtkScrolledWindow* result = NULL;
	GtkScrolledWindow* _tmp0_;
	GtkScrolledWindow* sw;
	GtkWidget* _tmp1_;
	g_return_val_if_fail (child != NULL, NULL);
	_tmp0_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	sw = _tmp0_;
	_tmp1_ = child;
	gtk_container_add ((GtkContainer*) sw, _tmp1_);
	result = sw;
	return result;
}


gboolean utils_tree_model_iter_prev (GtkTreeModel* model, GtkTreeIter* iter) {
	gboolean result = FALSE;
	GtkTreeModel* _tmp0_;
	GtkTreeIter _tmp1_;
	GtkTreePath* _tmp2_ = NULL;
	GtkTreePath* path;
	GtkTreePath* _tmp3_;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = model;
	_tmp1_ = *iter;
	_tmp2_ = gtk_tree_model_get_path (_tmp0_, &_tmp1_);
	path = _tmp2_;
	_tmp3_ = path;
	_tmp4_ = gtk_tree_path_prev (_tmp3_);
	if (_tmp4_) {
		GtkTreeModel* _tmp5_;
		GtkTreePath* _tmp6_;
		GtkTreeIter _tmp7_ = {0};
		gboolean _tmp8_ = FALSE;
		gboolean ret;
		_tmp5_ = model;
		_tmp6_ = path;
		_tmp8_ = gtk_tree_model_get_iter (_tmp5_, &_tmp7_, _tmp6_);
		*iter = _tmp7_;
		ret = _tmp8_;
		result = ret;
		_gtk_tree_path_free0 (path);
		return result;
	}
	result = FALSE;
	_gtk_tree_path_free0 (path);
	return result;
}


gint utils_get_selected_row (GtkTreeView* view, GtkTreeIter* iter) {
	GtkTreeIter _vala_iter = {0};
	gint result = 0;
	GtkTreeView* _tmp0_;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeSelection* _tmp2_;
	GtkTreeSelection* select;
	GtkTreeSelection* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (view != NULL, 0);
	_tmp0_ = view;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	select = _tmp2_;
	_tmp3_ = select;
	_tmp5_ = gtk_tree_selection_get_selected (_tmp3_, NULL, &_tmp4_);
	_vala_iter = _tmp4_;
	if (_tmp5_) {
		GtkTreeView* _tmp6_;
		GtkTreeModel* _tmp7_ = NULL;
		GtkTreeModel* _tmp8_;
		GtkTreeModel* model;
		GtkTreeModel* _tmp9_;
		GtkTreeIter _tmp10_;
		GtkTreePath* _tmp11_ = NULL;
		GtkTreePath* path;
		GtkTreePath* _tmp12_;
		gint _tmp13_ = 0;
		gint* _tmp14_ = NULL;
		gint _tmp15_;
		_tmp6_ = view;
		_tmp7_ = gtk_tree_view_get_model (_tmp6_);
		_tmp8_ = _g_object_ref0 (_tmp7_);
		model = _tmp8_;
		_tmp9_ = model;
		_tmp10_ = _vala_iter;
		_tmp11_ = gtk_tree_model_get_path (_tmp9_, &_tmp10_);
		path = _tmp11_;
		_tmp12_ = path;
		_tmp14_ = gtk_tree_path_get_indices_with_depth (_tmp12_, &_tmp13_);
		_tmp15_ = _tmp14_[0];
		result = _tmp15_;
		_gtk_tree_path_free0 (path);
		_g_object_unref0 (model);
		_g_object_unref0 (select);
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	result = -1;
	_g_object_unref0 (select);
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}


GdkPixbuf* utils_get_pixbuf_from_stock (const gchar* stock_id, GtkIconSize size) {
	GdkPixbuf* result = NULL;
	GtkInvisible* _tmp0_;
	GtkInvisible* w;
	const gchar* _tmp1_;
	GtkIconSize _tmp2_;
	GdkPixbuf* _tmp3_ = NULL;
	GdkPixbuf* pixbuf;
	g_return_val_if_fail (stock_id != NULL, NULL);
	_tmp0_ = (GtkInvisible*) gtk_invisible_new ();
	g_object_ref_sink (_tmp0_);
	w = _tmp0_;
	_tmp1_ = stock_id;
	_tmp2_ = size;
	_tmp3_ = gtk_widget_render_icon ((GtkWidget*) w, _tmp1_, _tmp2_, "vala");
	pixbuf = _tmp3_;
	result = pixbuf;
	_g_object_unref0 (w);
	return result;
}


GtkGrid* utils_get_dialog_component (const gchar* title, GtkWidget* widget) {
	GtkGrid* result = NULL;
	GtkGrid* _tmp0_;
	GtkGrid* grid;
	GtkLabel* _tmp1_;
	GtkLabel* label;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GtkWidget* _tmp7_;
	GtkWidget* _tmp8_;
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (widget != NULL, NULL);
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	grid = _tmp0_;
	gtk_orientable_set_orientation ((GtkOrientable*) grid, GTK_ORIENTATION_VERTICAL);
	gtk_grid_set_row_spacing (grid, (guint) 6);
	gtk_container_set_border_width ((GtkContainer*) grid, (guint) 6);
	_tmp1_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp1_);
	label = _tmp1_;
	_tmp2_ = title;
	_tmp3_ = g_strconcat ("<b>", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "</b>", NULL);
	_tmp6_ = _tmp5_;
	gtk_label_set_markup (label, _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	gtk_widget_set_halign ((GtkWidget*) label, GTK_ALIGN_START);
	gtk_container_add ((GtkContainer*) grid, (GtkWidget*) label);
	_tmp7_ = widget;
	gtk_widget_set_margin_left (_tmp7_, 12);
	_tmp8_ = widget;
	gtk_container_add ((GtkContainer*) grid, _tmp8_);
	result = grid;
	_g_object_unref0 (label);
	return result;
}


GtkWindow* utils_get_toplevel_window (GtkWidget* widget) {
	GtkWindow* result = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* toplevel;
	GtkWidget* _tmp2_;
	g_return_val_if_fail (widget != NULL, NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_widget_get_toplevel (_tmp0_);
	toplevel = _tmp1_;
	_tmp2_ = toplevel;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GTK_TYPE_WINDOW)) {
		GtkWidget* _tmp3_;
		_tmp3_ = toplevel;
		result = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GTK_TYPE_WINDOW) ? ((GtkWindow*) _tmp3_) : NULL;
		return result;
	}
	result = NULL;
	return result;
}


GtkDialog* utils_get_reset_all_confirm_dialog (GtkWindow* window, const gchar* msg) {
	GtkDialog* result = NULL;
	GtkWindow* _tmp0_;
	const gchar* _tmp1_;
	GtkMessageDialog* _tmp2_;
	GtkDialog* dialog;
	const gchar* _tmp3_ = NULL;
	GtkButton* _tmp4_;
	GtkButton* button;
	GtkImage* _tmp5_;
	GtkImage* image;
	g_return_val_if_fail (window != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	_tmp0_ = window;
	_tmp1_ = msg;
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp0_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _tmp1_);
	g_object_ref_sink (_tmp2_);
	dialog = (GtkDialog*) _tmp2_;
	gtk_dialog_add_button (dialog, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
	_tmp3_ = _ ("Reset All");
	_tmp4_ = (GtkButton*) gtk_button_new_with_label (_tmp3_);
	g_object_ref_sink (_tmp4_);
	button = _tmp4_;
	_tmp5_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_CLEAR, GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp5_);
	image = _tmp5_;
	gtk_button_set_image (button, (GtkWidget*) image);
	gtk_widget_show_all ((GtkWidget*) button);
	gtk_dialog_add_action_widget (dialog, (GtkWidget*) button, (gint) GTK_RESPONSE_YES);
	result = dialog;
	_g_object_unref0 (image);
	_g_object_unref0 (button);
	return result;
}


/*************************************************************************/
void utils_flush_queue (void) {
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		_tmp0_ = gtk_events_pending ();
		if (!_tmp0_) {
			break;
		}
		gtk_main_iteration ();
	}
}



