/* main_window_documents.c generated by valac 0.20.0.2-fd7ed, the Vala compiler
 * generated from main_window_documents.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2012 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "config.h"
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gtksourceview/gtksource.h>
#include <gobject/gvaluecollector.h>


#define TYPE_MAIN_WINDOW_DOCUMENTS (main_window_documents_get_type ())
#define MAIN_WINDOW_DOCUMENTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_DOCUMENTS, MainWindowDocuments))
#define MAIN_WINDOW_DOCUMENTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_DOCUMENTS, MainWindowDocumentsClass))
#define IS_MAIN_WINDOW_DOCUMENTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_DOCUMENTS))
#define IS_MAIN_WINDOW_DOCUMENTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_DOCUMENTS))
#define MAIN_WINDOW_DOCUMENTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_DOCUMENTS, MainWindowDocumentsClass))

typedef struct _MainWindowDocuments MainWindowDocuments;
typedef struct _MainWindowDocumentsClass MainWindowDocumentsClass;
typedef struct _MainWindowDocumentsPrivate MainWindowDocumentsPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_DOCUMENTS_PANEL (documents_panel_get_type ())
#define DOCUMENTS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENTS_PANEL, DocumentsPanel))
#define DOCUMENTS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENTS_PANEL, DocumentsPanelClass))
#define IS_DOCUMENTS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENTS_PANEL))
#define IS_DOCUMENTS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENTS_PANEL))
#define DOCUMENTS_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENTS_PANEL, DocumentsPanelClass))

typedef struct _DocumentsPanel DocumentsPanel;
typedef struct _DocumentsPanelClass DocumentsPanelClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_LATEXILA (latexila_get_type ())
#define LATEXILA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEXILA, Latexila))
#define LATEXILA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEXILA, LatexilaClass))
#define IS_LATEXILA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEXILA))
#define IS_LATEXILA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEXILA))
#define LATEXILA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEXILA, LatexilaClass))

typedef struct _Latexila Latexila;
typedef struct _LatexilaClass LatexilaClass;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;
typedef struct _ParamSpecMainWindowDocuments ParamSpecMainWindowDocuments;

struct _MainWindowDocuments {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MainWindowDocumentsPrivate * priv;
};

struct _MainWindowDocumentsClass {
	GTypeClass parent_class;
	void (*finalize) (MainWindowDocuments *self);
};

struct _MainWindowDocumentsPrivate {
	MainWindow* _main_window;
	GtkUIManager* _ui_manager;
	DocumentsPanel* _documents_panel;
	GtkActionGroup* _static_action_group;
	GtkActionGroup* _list_action_group;
	guint _list_id;
};

struct _ParamSpecMainWindowDocuments {
	GParamSpec parent_instance;
};


static gpointer main_window_documents_parent_class = NULL;

gpointer main_window_documents_ref (gpointer instance);
void main_window_documents_unref (gpointer instance);
GParamSpec* param_spec_main_window_documents (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_main_window_documents (GValue* value, gpointer v_object);
void value_take_main_window_documents (GValue* value, gpointer v_object);
gpointer value_get_main_window_documents (const GValue* value);
GType main_window_documents_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType documents_panel_get_type (void) G_GNUC_CONST;
#define MAIN_WINDOW_DOCUMENTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MAIN_WINDOW_DOCUMENTS, MainWindowDocumentsPrivate))
enum  {
	MAIN_WINDOW_DOCUMENTS_DUMMY_PROPERTY
};
void main_window_documents_on_save_all (MainWindowDocuments* self);
static void _main_window_documents_on_save_all_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_documents_on_close_all (MainWindowDocuments* self);
static void _main_window_documents_on_close_all_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_documents_on_previous (MainWindowDocuments* self);
static void _main_window_documents_on_previous_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_documents_on_next (MainWindowDocuments* self);
static void _main_window_documents_on_next_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_documents_on_move_to_new_window (MainWindowDocuments* self);
static void _main_window_documents_on_move_to_new_window_gtk_action_callback (GtkAction* action, gpointer self);
MainWindowDocuments* main_window_documents_new (MainWindow* main_window, GtkUIManager* ui_manager);
MainWindowDocuments* main_window_documents_construct (GType object_type, MainWindow* main_window, GtkUIManager* ui_manager);
void main_window_documents_set_documents_panel (MainWindowDocuments* self, DocumentsPanel* documents_panel);
static void main_window_documents_connect_signals (MainWindowDocuments* self);
static void main_window_documents_update_sensitivity (MainWindowDocuments* self);
static void __lambda38_ (MainWindowDocuments* self);
static void main_window_documents_update_documents_list (MainWindowDocuments* self);
static void ___lambda38__gtk_notebook_page_reordered (GtkNotebook* _sender, GtkWidget* child, guint page_num, gpointer self);
static void __lambda39_ (MainWindowDocuments* self, GtkWidget* pg, guint page_num);
static void main_window_documents_set_active_document (MainWindowDocuments* self, guint doc_num);
static void ___lambda39__gtk_notebook_switch_page (GtkNotebook* _sender, GtkWidget* page, guint page_num, gpointer self);
static void __lambda40_ (MainWindowDocuments* self);
static void ___lambda40__gtk_notebook_page_removed (GtkNotebook* _sender, GtkWidget* child, guint page_num, gpointer self);
static void __lambda41_ (MainWindowDocuments* self);
static void ___lambda41__gtk_notebook_page_added (GtkNotebook* _sender, GtkWidget* child, guint page_num, gpointer self);
static void main_window_documents_list_action_activate (MainWindowDocuments* self, GtkAction* action);
static void _main_window_documents_list_action_activate_gtk_action_activate (GtkAction* _sender, gpointer self);
GType document_tab_get_type (void) G_GNUC_CONST;
static gchar* main_window_documents_get_list_action_name (MainWindowDocuments* self, guint doc_num);
gchar* document_tab_get_name (DocumentTab* self);
gchar* document_tab_get_menu_tip (DocumentTab* self);
DocumentTab* main_window_get_active_tab (MainWindow* self);
void main_window_documents_update_document_name (MainWindowDocuments* self, DocumentTab* tab);
static void main_window_documents_update_next_prev_doc_sensitivity (MainWindowDocuments* self);
GType document_get_type (void) G_GNUC_CONST;
GeeList* main_window_get_unsaved_documents (MainWindow* self);
void document_save (Document* self, gboolean check_file_changed_on_disk, gboolean force);
gboolean main_window_close_all_documents (MainWindow* self);
GType latexila_get_type (void) G_GNUC_CONST;
Latexila* latexila_get_instance (void);
MainWindow* latexila_create_window (Latexila* self);
GType document_view_get_type (void) G_GNUC_CONST;
DocumentView* document_tab_get_view (DocumentTab* self);
void documents_panel_remove_tab (DocumentsPanel* self, DocumentTab* tab);
void main_window_create_tab_with_view (MainWindow* self, DocumentView* view);
static void main_window_documents_finalize (MainWindowDocuments* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GtkActionEntry MAIN_WINDOW_DOCUMENTS__action_entries[6] = {{"Documents", NULL, "_Documents"}, {"DocumentsSaveAll", GTK_STOCK_SAVE, "_Save All", "<Shift><Control>L", "Save all open files", (GCallback) _main_window_documents_on_save_all_gtk_action_callback}, {"DocumentsCloseAll", GTK_STOCK_CLOSE, "_Close All", "<Shift><Control>W", "Close all open files", (GCallback) _main_window_documents_on_close_all_gtk_action_callback}, {"DocumentsPrevious", GTK_STOCK_GO_BACK, "_Previous Document", "<Control><Alt>Page_Up", "Activate previous document", (GCallback) _main_window_documents_on_previous_gtk_action_callback}, {"DocumentsNext", GTK_STOCK_GO_FORWARD, "_Next Document", "<Control><Alt>Page_Down", "Activate next document", (GCallback) _main_window_documents_on_next_gtk_action_callback}, {"DocumentsMoveToNewWindow", NULL, "_Move to New Window", NULL, "Move the current document to a new window", (GCallback) _main_window_documents_on_move_to_new_window_gtk_action_callback}};

static void _main_window_documents_on_save_all_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_documents_on_save_all (self);
}


static void _main_window_documents_on_close_all_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_documents_on_close_all (self);
}


static void _main_window_documents_on_previous_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_documents_on_previous (self);
}


static void _main_window_documents_on_next_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_documents_on_next (self);
}


static void _main_window_documents_on_move_to_new_window_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_documents_on_move_to_new_window (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


MainWindowDocuments* main_window_documents_construct (GType object_type, MainWindow* main_window, GtkUIManager* ui_manager) {
	MainWindowDocuments* self = NULL;
	MainWindow* _tmp0_;
	GtkUIManager* _tmp1_;
	GtkUIManager* _tmp2_;
	GtkActionGroup* _tmp3_;
	GtkActionGroup* _tmp4_;
	GtkActionGroup* _tmp5_;
	GtkUIManager* _tmp6_;
	GtkActionGroup* _tmp7_;
	GtkActionGroup* _tmp8_;
	GtkUIManager* _tmp9_;
	GtkActionGroup* _tmp10_;
	g_return_val_if_fail (main_window != NULL, NULL);
	g_return_val_if_fail (ui_manager != NULL, NULL);
	self = (MainWindowDocuments*) g_type_create_instance (object_type);
	_tmp0_ = main_window;
	self->priv->_main_window = _tmp0_;
	_tmp1_ = ui_manager;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->_ui_manager);
	self->priv->_ui_manager = _tmp2_;
	_tmp3_ = gtk_action_group_new ("DocumentsMenuActionGroup");
	_g_object_unref0 (self->priv->_static_action_group);
	self->priv->_static_action_group = _tmp3_;
	_tmp4_ = self->priv->_static_action_group;
	gtk_action_group_set_translation_domain (_tmp4_, GETTEXT_PACKAGE);
	_tmp5_ = self->priv->_static_action_group;
	gtk_action_group_add_actions (_tmp5_, MAIN_WINDOW_DOCUMENTS__action_entries, G_N_ELEMENTS (MAIN_WINDOW_DOCUMENTS__action_entries), self);
	_tmp6_ = ui_manager;
	_tmp7_ = self->priv->_static_action_group;
	gtk_ui_manager_insert_action_group (_tmp6_, _tmp7_, 0);
	_tmp8_ = gtk_action_group_new ("DocumentsListActionGroup");
	_g_object_unref0 (self->priv->_list_action_group);
	self->priv->_list_action_group = _tmp8_;
	_tmp9_ = ui_manager;
	_tmp10_ = self->priv->_list_action_group;
	gtk_ui_manager_insert_action_group (_tmp9_, _tmp10_, 0);
	return self;
}


MainWindowDocuments* main_window_documents_new (MainWindow* main_window, GtkUIManager* ui_manager) {
	return main_window_documents_construct (TYPE_MAIN_WINDOW_DOCUMENTS, main_window, ui_manager);
}


void main_window_documents_set_documents_panel (MainWindowDocuments* self, DocumentsPanel* documents_panel) {
	DocumentsPanel* _tmp0_;
	DocumentsPanel* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (documents_panel != NULL);
	_tmp0_ = documents_panel;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_documents_panel);
	self->priv->_documents_panel = _tmp1_;
	main_window_documents_connect_signals (self);
	main_window_documents_update_sensitivity (self);
}


static void __lambda38_ (MainWindowDocuments* self) {
	main_window_documents_update_sensitivity (self);
	main_window_documents_update_documents_list (self);
}


static void ___lambda38__gtk_notebook_page_reordered (GtkNotebook* _sender, GtkWidget* child, guint page_num, gpointer self) {
	__lambda38_ (self);
}


static void __lambda39_ (MainWindowDocuments* self, GtkWidget* pg, guint page_num) {
	guint _tmp0_;
	g_return_if_fail (pg != NULL);
	_tmp0_ = page_num;
	main_window_documents_set_active_document (self, _tmp0_);
	main_window_documents_update_sensitivity (self);
}


static void ___lambda39__gtk_notebook_switch_page (GtkNotebook* _sender, GtkWidget* page, guint page_num, gpointer self) {
	__lambda39_ (self, page, page_num);
}


static void __lambda40_ (MainWindowDocuments* self) {
	main_window_documents_update_documents_list (self);
	main_window_documents_update_sensitivity (self);
}


static void ___lambda40__gtk_notebook_page_removed (GtkNotebook* _sender, GtkWidget* child, guint page_num, gpointer self) {
	__lambda40_ (self);
}


static void __lambda41_ (MainWindowDocuments* self) {
	main_window_documents_update_documents_list (self);
	main_window_documents_update_sensitivity (self);
}


static void ___lambda41__gtk_notebook_page_added (GtkNotebook* _sender, GtkWidget* child, guint page_num, gpointer self) {
	__lambda41_ (self);
}


static void main_window_documents_connect_signals (MainWindowDocuments* self) {
	DocumentsPanel* _tmp0_;
	DocumentsPanel* _tmp1_;
	DocumentsPanel* _tmp2_;
	DocumentsPanel* _tmp3_;
	DocumentsPanel* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_documents_panel;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->priv->_documents_panel;
	g_signal_connect ((GtkNotebook*) _tmp1_, "page-reordered", (GCallback) ___lambda38__gtk_notebook_page_reordered, self);
	_tmp2_ = self->priv->_documents_panel;
	g_signal_connect ((GtkNotebook*) _tmp2_, "switch-page", (GCallback) ___lambda39__gtk_notebook_switch_page, self);
	_tmp3_ = self->priv->_documents_panel;
	g_signal_connect ((GtkNotebook*) _tmp3_, "page-removed", (GCallback) ___lambda40__gtk_notebook_page_removed, self);
	_tmp4_ = self->priv->_documents_panel;
	g_signal_connect ((GtkNotebook*) _tmp4_, "page-added", (GCallback) ___lambda41__gtk_notebook_page_added, self);
}


static void _main_window_documents_list_action_activate_gtk_action_activate (GtkAction* _sender, gpointer self) {
	main_window_documents_list_action_activate (self, _sender);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch38_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch38_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally38;
	__catch38_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally38:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void main_window_documents_update_documents_list (MainWindowDocuments* self) {
	GtkActionGroup* _tmp0_;
	DocumentsPanel* _tmp1_;
	guint _tmp2_;
	GtkActionGroup* _tmp5_;
	GList* _tmp6_ = NULL;
	DocumentsPanel* _tmp12_;
	gint _tmp13_ = 0;
	gint nb_docs;
	gint _tmp14_;
	GtkUIManager* _tmp15_;
	guint _tmp16_ = 0U;
	GSList* group;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_list_action_group;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->priv->_documents_panel;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = self->priv->_list_id;
	if (_tmp2_ != ((guint) 0)) {
		GtkUIManager* _tmp3_;
		guint _tmp4_;
		_tmp3_ = self->priv->_ui_manager;
		_tmp4_ = self->priv->_list_id;
		gtk_ui_manager_remove_ui (_tmp3_, _tmp4_);
	}
	_tmp5_ = self->priv->_list_action_group;
	_tmp6_ = gtk_action_group_list_actions (_tmp5_);
	{
		GList* action_collection = NULL;
		GList* action_it = NULL;
		action_collection = _tmp6_;
		for (action_it = action_collection; action_it != NULL; action_it = action_it->next) {
			GtkAction* _tmp7_;
			GtkAction* action = NULL;
			_tmp7_ = _g_object_ref0 ((GtkAction*) action_it->data);
			action = _tmp7_;
			{
				GtkAction* _tmp8_;
				guint _tmp9_ = 0U;
				GtkActionGroup* _tmp10_;
				GtkAction* _tmp11_;
				_tmp8_ = action;
				g_signal_parse_name ("activate", GTK_TYPE_ACTION, &_tmp9_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _main_window_documents_list_action_activate_gtk_action_activate, self);
				_tmp10_ = self->priv->_list_action_group;
				_tmp11_ = action;
				gtk_action_group_remove_action (_tmp10_, _tmp11_);
				_g_object_unref0 (action);
			}
		}
		_g_list_free0 (action_collection);
	}
	self->priv->_list_id = (guint) 0;
	_tmp12_ = self->priv->_documents_panel;
	_tmp13_ = gtk_notebook_get_n_pages ((GtkNotebook*) _tmp12_);
	nb_docs = _tmp13_;
	_tmp14_ = nb_docs;
	if (_tmp14_ == 0) {
		return;
	}
	_tmp15_ = self->priv->_ui_manager;
	_tmp16_ = gtk_ui_manager_new_merge_id (_tmp15_);
	self->priv->_list_id = _tmp16_;
	group = NULL;
	{
		gint doc_num;
		doc_num = 0;
		{
			gboolean _tmp17_;
			_tmp17_ = TRUE;
			while (TRUE) {
				gboolean _tmp18_;
				gint _tmp20_;
				gint _tmp21_;
				DocumentsPanel* _tmp22_;
				gint _tmp23_;
				GtkWidget* _tmp24_ = NULL;
				DocumentTab* _tmp25_;
				DocumentTab* tab;
				gint _tmp26_;
				gchar* _tmp27_ = NULL;
				gchar* action_name;
				DocumentTab* _tmp28_;
				gchar* _tmp29_ = NULL;
				gchar* _tmp30_;
				gchar* _tmp31_ = NULL;
				gchar* _tmp32_;
				gchar* name;
				DocumentTab* _tmp33_;
				gchar* _tmp34_ = NULL;
				gchar* tip;
				gchar* accel;
				gint _tmp35_;
				const gchar* _tmp38_;
				const gchar* _tmp39_;
				const gchar* _tmp40_;
				gint _tmp41_;
				GtkRadioAction* _tmp42_;
				GtkRadioAction* action;
				GSList* _tmp43_;
				GtkRadioAction* _tmp46_;
				GSList* _tmp47_ = NULL;
				GtkActionGroup* _tmp48_;
				GtkRadioAction* _tmp49_;
				const gchar* _tmp50_;
				GtkRadioAction* _tmp51_;
				GtkUIManager* _tmp52_;
				guint _tmp53_;
				const gchar* _tmp54_;
				const gchar* _tmp55_;
				DocumentTab* _tmp56_;
				MainWindow* _tmp57_;
				DocumentTab* _tmp58_;
				DocumentTab* _tmp59_;
				_tmp18_ = _tmp17_;
				if (!_tmp18_) {
					gint _tmp19_;
					_tmp19_ = doc_num;
					doc_num = _tmp19_ + 1;
				}
				_tmp17_ = FALSE;
				_tmp20_ = doc_num;
				_tmp21_ = nb_docs;
				if (!(_tmp20_ < _tmp21_)) {
					break;
				}
				_tmp22_ = self->priv->_documents_panel;
				_tmp23_ = doc_num;
				_tmp24_ = gtk_notebook_get_nth_page ((GtkNotebook*) _tmp22_, _tmp23_);
				_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, TYPE_DOCUMENT_TAB) ? ((DocumentTab*) _tmp24_) : NULL);
				tab = _tmp25_;
				_tmp26_ = doc_num;
				_tmp27_ = main_window_documents_get_list_action_name (self, (guint) _tmp26_);
				action_name = _tmp27_;
				_tmp28_ = tab;
				_tmp29_ = document_tab_get_name (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = string_replace (_tmp30_, "_", "__");
				_tmp32_ = _tmp31_;
				_g_free0 (_tmp30_);
				name = _tmp32_;
				_tmp33_ = tab;
				_tmp34_ = document_tab_get_menu_tip (_tmp33_);
				tip = _tmp34_;
				accel = NULL;
				_tmp35_ = doc_num;
				if (_tmp35_ < 10) {
					gint _tmp36_;
					gchar* _tmp37_ = NULL;
					_tmp36_ = doc_num;
					_tmp37_ = g_strdup_printf ("<alt>%d", (_tmp36_ + 1) % 10);
					_g_free0 (accel);
					accel = _tmp37_;
				}
				_tmp38_ = action_name;
				_tmp39_ = name;
				_tmp40_ = tip;
				_tmp41_ = doc_num;
				_tmp42_ = gtk_radio_action_new (_tmp38_, _tmp39_, _tmp40_, NULL, _tmp41_);
				action = _tmp42_;
				_tmp43_ = group;
				if (_tmp43_ != NULL) {
					GtkRadioAction* _tmp44_;
					GSList* _tmp45_;
					_tmp44_ = action;
					_tmp45_ = group;
					gtk_radio_action_set_group (_tmp44_, _tmp45_);
				}
				_tmp46_ = action;
				_tmp47_ = gtk_radio_action_get_group (_tmp46_);
				group = _tmp47_;
				_tmp48_ = self->priv->_list_action_group;
				_tmp49_ = action;
				_tmp50_ = accel;
				gtk_action_group_add_action_with_accel (_tmp48_, (GtkAction*) _tmp49_, _tmp50_);
				_tmp51_ = action;
				g_signal_connect ((GtkAction*) _tmp51_, "activate", (GCallback) _main_window_documents_list_action_activate_gtk_action_activate, self);
				_tmp52_ = self->priv->_ui_manager;
				_tmp53_ = self->priv->_list_id;
				_tmp54_ = action_name;
				_tmp55_ = action_name;
				gtk_ui_manager_add_ui (_tmp52_, _tmp53_, "/MainMenu/DocumentsMenu/DocumentsListPlaceholder", _tmp54_, _tmp55_, GTK_UI_MANAGER_MENUITEM, FALSE);
				_tmp56_ = tab;
				_tmp57_ = self->priv->_main_window;
				_tmp58_ = main_window_get_active_tab (_tmp57_);
				_tmp59_ = _tmp58_;
				if (_tmp56_ == _tmp59_) {
					GtkRadioAction* _tmp60_;
					_tmp60_ = action;
					gtk_toggle_action_set_active ((GtkToggleAction*) _tmp60_, TRUE);
				}
				_g_object_unref0 (action);
				_g_free0 (accel);
				_g_free0 (tip);
				_g_free0 (name);
				_g_free0 (action_name);
				_g_object_unref0 (tab);
			}
		}
	}
}


static void main_window_documents_set_active_document (MainWindowDocuments* self, guint doc_num) {
	guint _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* action_name;
	GtkActionGroup* _tmp2_;
	const gchar* _tmp3_;
	GtkAction* _tmp4_ = NULL;
	GtkRadioAction* _tmp5_;
	GtkRadioAction* action;
	GtkRadioAction* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = doc_num;
	_tmp1_ = main_window_documents_get_list_action_name (self, _tmp0_);
	action_name = _tmp1_;
	_tmp2_ = self->priv->_list_action_group;
	_tmp3_ = action_name;
	_tmp4_ = gtk_action_group_get_action (_tmp2_, _tmp3_);
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, GTK_TYPE_RADIO_ACTION) ? ((GtkRadioAction*) _tmp4_) : NULL);
	action = _tmp5_;
	_tmp6_ = action;
	if (_tmp6_ != NULL) {
		GtkRadioAction* _tmp7_;
		guint _tmp8_ = 0U;
		GtkRadioAction* _tmp9_;
		GtkRadioAction* _tmp10_;
		_tmp7_ = action;
		g_signal_parse_name ("activate", GTK_TYPE_ACTION, &_tmp8_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkAction*) _tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _main_window_documents_list_action_activate_gtk_action_activate, self);
		_tmp9_ = action;
		gtk_toggle_action_set_active ((GtkToggleAction*) _tmp9_, TRUE);
		_tmp10_ = action;
		g_signal_connect ((GtkAction*) _tmp10_, "activate", (GCallback) _main_window_documents_list_action_activate_gtk_action_activate, self);
	}
	_g_object_unref0 (action);
	_g_free0 (action_name);
}


void main_window_documents_update_document_name (MainWindowDocuments* self, DocumentTab* tab) {
	DocumentsPanel* _tmp0_;
	DocumentsPanel* _tmp1_;
	DocumentTab* _tmp2_;
	gint _tmp3_ = 0;
	gint doc_num;
	gchar* _tmp4_ = NULL;
	gchar* action_name;
	GtkActionGroup* _tmp5_;
	GtkAction* _tmp6_ = NULL;
	GtkAction* _tmp7_;
	GtkAction* action;
	DocumentTab* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	DocumentTab* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tab != NULL);
	_tmp0_ = self->priv->_documents_panel;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->priv->_documents_panel;
	_tmp2_ = tab;
	_tmp3_ = gtk_notebook_page_num ((GtkNotebook*) _tmp1_, (GtkWidget*) _tmp2_);
	doc_num = _tmp3_;
	_tmp4_ = main_window_documents_get_list_action_name (self, (guint) doc_num);
	action_name = _tmp4_;
	_tmp5_ = self->priv->_list_action_group;
	_tmp6_ = gtk_action_group_get_action (_tmp5_, action_name);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	action = _tmp7_;
	g_return_if_fail (action != NULL);
	_tmp8_ = tab;
	_tmp9_ = document_tab_get_name (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = string_replace (_tmp10_, "_", "__");
	_tmp12_ = _tmp11_;
	gtk_action_set_label (action, _tmp12_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = tab;
	_tmp14_ = document_tab_get_menu_tip (_tmp13_);
	_tmp15_ = _tmp14_;
	gtk_action_set_tooltip (action, _tmp15_);
	_g_free0 (_tmp15_);
	_g_object_unref0 (action);
	_g_free0 (action_name);
}


static void main_window_documents_list_action_activate (MainWindowDocuments* self, GtkAction* action) {
	DocumentsPanel* _tmp0_;
	GtkAction* _tmp1_;
	GtkRadioAction* _tmp2_;
	GtkRadioAction* radio_action;
	GtkRadioAction* _tmp3_;
	gboolean _tmp4_ = FALSE;
	DocumentsPanel* _tmp5_;
	GtkRadioAction* _tmp6_;
	gint _tmp7_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->_documents_panel;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = action;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, GTK_TYPE_RADIO_ACTION) ? ((GtkRadioAction*) _tmp1_) : NULL);
	radio_action = _tmp2_;
	_tmp3_ = radio_action;
	_tmp4_ = gtk_toggle_action_get_active ((GtkToggleAction*) _tmp3_);
	if (!_tmp4_) {
		_g_object_unref0 (radio_action);
		return;
	}
	_tmp5_ = self->priv->_documents_panel;
	_tmp6_ = radio_action;
	_tmp7_ = gtk_radio_action_get_current_value (_tmp6_);
	gtk_notebook_set_current_page ((GtkNotebook*) _tmp5_, _tmp7_);
	_g_object_unref0 (radio_action);
}


static gchar* main_window_documents_get_list_action_name (MainWindowDocuments* self, guint doc_num) {
	gchar* result = NULL;
	guint _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = doc_num;
	_tmp1_ = g_strdup_printf ("%u", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("Tab_", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}


static void main_window_documents_update_sensitivity (MainWindowDocuments* self) {
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	gboolean sensitive;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_ = NULL;
	gchar** action_names;
	gint action_names_length1;
	gint _action_names_size_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gboolean _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	sensitive = _tmp2_ != NULL;
	_tmp3_ = g_strdup ("DocumentsSaveAll");
	_tmp4_ = g_strdup ("DocumentsCloseAll");
	_tmp5_ = g_strdup ("DocumentsPrevious");
	_tmp6_ = g_strdup ("DocumentsNext");
	_tmp7_ = g_strdup ("DocumentsMoveToNewWindow");
	_tmp8_ = g_new0 (gchar*, 5 + 1);
	_tmp8_[0] = _tmp3_;
	_tmp8_[1] = _tmp4_;
	_tmp8_[2] = _tmp5_;
	_tmp8_[3] = _tmp6_;
	_tmp8_[4] = _tmp7_;
	action_names = _tmp8_;
	action_names_length1 = 5;
	_action_names_size_ = action_names_length1;
	_tmp9_ = action_names;
	_tmp9__length1 = action_names_length1;
	{
		gchar** action_name_collection = NULL;
		gint action_name_collection_length1 = 0;
		gint _action_name_collection_size_ = 0;
		gint action_name_it = 0;
		action_name_collection = _tmp9_;
		action_name_collection_length1 = _tmp9__length1;
		for (action_name_it = 0; action_name_it < _tmp9__length1; action_name_it = action_name_it + 1) {
			gchar* _tmp10_;
			gchar* action_name = NULL;
			_tmp10_ = g_strdup (action_name_collection[action_name_it]);
			action_name = _tmp10_;
			{
				GtkActionGroup* _tmp11_;
				const gchar* _tmp12_;
				GtkAction* _tmp13_ = NULL;
				GtkAction* _tmp14_;
				GtkAction* action;
				GtkAction* _tmp15_;
				gboolean _tmp16_;
				_tmp11_ = self->priv->_static_action_group;
				_tmp12_ = action_name;
				_tmp13_ = gtk_action_group_get_action (_tmp11_, _tmp12_);
				_tmp14_ = _g_object_ref0 (_tmp13_);
				action = _tmp14_;
				_tmp15_ = action;
				_tmp16_ = sensitive;
				gtk_action_set_sensitive (_tmp15_, _tmp16_);
				_g_object_unref0 (action);
				_g_free0 (action_name);
			}
		}
	}
	_tmp17_ = sensitive;
	if (_tmp17_) {
		main_window_documents_update_next_prev_doc_sensitivity (self);
	}
	action_names = (_vala_array_free (action_names, action_names_length1, (GDestroyNotify) g_free), NULL);
}


static void main_window_documents_update_next_prev_doc_sensitivity (MainWindowDocuments* self) {
	DocumentsPanel* _tmp0_;
	MainWindow* _tmp1_;
	DocumentTab* _tmp2_;
	DocumentTab* _tmp3_;
	GtkActionGroup* _tmp4_;
	GtkAction* _tmp5_ = NULL;
	GtkAction* _tmp6_;
	GtkAction* action_prev;
	GtkActionGroup* _tmp7_;
	GtkAction* _tmp8_ = NULL;
	GtkAction* _tmp9_;
	GtkAction* action_next;
	DocumentsPanel* _tmp10_;
	MainWindow* _tmp11_;
	DocumentTab* _tmp12_;
	DocumentTab* _tmp13_;
	gint _tmp14_ = 0;
	gint current_page;
	GtkAction* _tmp15_;
	gint _tmp16_;
	DocumentsPanel* _tmp17_;
	gint _tmp18_ = 0;
	gint nb_pages;
	GtkAction* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_documents_panel;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->priv->_main_window;
	_tmp2_ = main_window_get_active_tab (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		return;
	}
	_tmp4_ = self->priv->_static_action_group;
	_tmp5_ = gtk_action_group_get_action (_tmp4_, "DocumentsPrevious");
	_tmp6_ = _g_object_ref0 (_tmp5_);
	action_prev = _tmp6_;
	_tmp7_ = self->priv->_static_action_group;
	_tmp8_ = gtk_action_group_get_action (_tmp7_, "DocumentsNext");
	_tmp9_ = _g_object_ref0 (_tmp8_);
	action_next = _tmp9_;
	_tmp10_ = self->priv->_documents_panel;
	_tmp11_ = self->priv->_main_window;
	_tmp12_ = main_window_get_active_tab (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = gtk_notebook_page_num ((GtkNotebook*) _tmp10_, (GtkWidget*) _tmp13_);
	current_page = _tmp14_;
	_tmp15_ = action_prev;
	_tmp16_ = current_page;
	gtk_action_set_sensitive (_tmp15_, _tmp16_ > 0);
	_tmp17_ = self->priv->_documents_panel;
	_tmp18_ = gtk_notebook_get_n_pages ((GtkNotebook*) _tmp17_);
	nb_pages = _tmp18_;
	_tmp19_ = action_next;
	_tmp20_ = current_page;
	_tmp21_ = nb_pages;
	gtk_action_set_sensitive (_tmp19_, _tmp20_ < (_tmp21_ - 1));
	_g_object_unref0 (action_next);
	_g_object_unref0 (action_prev);
}


void main_window_documents_on_save_all (MainWindowDocuments* self) {
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	{
		MainWindow* _tmp3_;
		GeeList* _tmp4_ = NULL;
		GeeList* _doc_list;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _doc_size;
		gint _doc_index;
		_tmp3_ = self->priv->_main_window;
		_tmp4_ = main_window_get_unsaved_documents (_tmp3_);
		_doc_list = _tmp4_;
		_tmp5_ = _doc_list;
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_doc_size = _tmp7_;
		_doc_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			GeeList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_ = NULL;
			Document* doc;
			Document* _tmp14_;
			_tmp8_ = _doc_index;
			_doc_index = _tmp8_ + 1;
			_tmp9_ = _doc_index;
			_tmp10_ = _doc_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _doc_list;
			_tmp12_ = _doc_index;
			_tmp13_ = gee_list_get (_tmp11_, _tmp12_);
			doc = (Document*) _tmp13_;
			_tmp14_ = doc;
			document_save (_tmp14_, TRUE, FALSE);
			_g_object_unref0 (doc);
		}
		_g_object_unref0 (_doc_list);
	}
}


void main_window_documents_on_close_all (MainWindowDocuments* self) {
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	MainWindow* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->_main_window;
	main_window_close_all_documents (_tmp3_);
}


void main_window_documents_on_previous (MainWindowDocuments* self) {
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	DocumentsPanel* _tmp3_;
	DocumentsPanel* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->_documents_panel;
	g_return_if_fail (_tmp3_ != NULL);
	_tmp4_ = self->priv->_documents_panel;
	gtk_notebook_prev_page ((GtkNotebook*) _tmp4_);
}


void main_window_documents_on_next (MainWindowDocuments* self) {
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	DocumentsPanel* _tmp3_;
	DocumentsPanel* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->_documents_panel;
	g_return_if_fail (_tmp3_ != NULL);
	_tmp4_ = self->priv->_documents_panel;
	gtk_notebook_next_page ((GtkNotebook*) _tmp4_);
}


void main_window_documents_on_move_to_new_window (MainWindowDocuments* self) {
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	DocumentTab* _tmp3_;
	DocumentTab* tab;
	DocumentsPanel* _tmp4_;
	Latexila* _tmp5_ = NULL;
	Latexila* _tmp6_;
	MainWindow* _tmp7_ = NULL;
	MainWindow* _tmp8_;
	MainWindow* new_window;
	DocumentView* _tmp9_;
	DocumentView* _tmp10_;
	DocumentView* _tmp11_;
	DocumentView* view;
	DocumentsPanel* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	tab = _tmp3_;
	g_return_if_fail (tab != NULL);
	_tmp4_ = self->priv->_documents_panel;
	g_return_if_fail (_tmp4_ != NULL);
	_tmp5_ = latexila_get_instance ();
	_tmp6_ = _tmp5_;
	_tmp7_ = latexila_create_window (_tmp6_);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp6_);
	new_window = _tmp8_;
	_tmp9_ = document_tab_get_view (tab);
	_tmp10_ = _tmp9_;
	_tmp11_ = _g_object_ref0 (_tmp10_);
	view = _tmp11_;
	_tmp12_ = self->priv->_documents_panel;
	documents_panel_remove_tab (_tmp12_, tab);
	main_window_create_tab_with_view (new_window, view);
	_g_object_unref0 (view);
	_g_object_unref0 (new_window);
	_g_object_unref0 (tab);
}


static void value_main_window_documents_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_main_window_documents_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		main_window_documents_unref (value->data[0].v_pointer);
	}
}


static void value_main_window_documents_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = main_window_documents_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_main_window_documents_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_main_window_documents_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		MainWindowDocuments* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = main_window_documents_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_main_window_documents_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	MainWindowDocuments** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = main_window_documents_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_main_window_documents (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecMainWindowDocuments* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MAIN_WINDOW_DOCUMENTS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_main_window_documents (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_DOCUMENTS), NULL);
	return value->data[0].v_pointer;
}


void value_set_main_window_documents (GValue* value, gpointer v_object) {
	MainWindowDocuments* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_DOCUMENTS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAIN_WINDOW_DOCUMENTS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		main_window_documents_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		main_window_documents_unref (old);
	}
}


void value_take_main_window_documents (GValue* value, gpointer v_object) {
	MainWindowDocuments* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_DOCUMENTS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAIN_WINDOW_DOCUMENTS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		main_window_documents_unref (old);
	}
}


static void main_window_documents_class_init (MainWindowDocumentsClass * klass) {
	main_window_documents_parent_class = g_type_class_peek_parent (klass);
	MAIN_WINDOW_DOCUMENTS_CLASS (klass)->finalize = main_window_documents_finalize;
	g_type_class_add_private (klass, sizeof (MainWindowDocumentsPrivate));
}


static void main_window_documents_instance_init (MainWindowDocuments * self) {
	self->priv = MAIN_WINDOW_DOCUMENTS_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void main_window_documents_finalize (MainWindowDocuments* obj) {
	MainWindowDocuments * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAIN_WINDOW_DOCUMENTS, MainWindowDocuments);
	_g_object_unref0 (self->priv->_ui_manager);
	_g_object_unref0 (self->priv->_documents_panel);
	_g_object_unref0 (self->priv->_static_action_group);
	_g_object_unref0 (self->priv->_list_action_group);
}


GType main_window_documents_get_type (void) {
	static volatile gsize main_window_documents_type_id__volatile = 0;
	if (g_once_init_enter (&main_window_documents_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_main_window_documents_init, value_main_window_documents_free_value, value_main_window_documents_copy_value, value_main_window_documents_peek_pointer, "p", value_main_window_documents_collect_value, "p", value_main_window_documents_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (MainWindowDocumentsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_window_documents_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MainWindowDocuments), 0, (GInstanceInitFunc) main_window_documents_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType main_window_documents_type_id;
		main_window_documents_type_id = g_type_register_fundamental (g_type_fundamental_next (), "MainWindowDocuments", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&main_window_documents_type_id__volatile, main_window_documents_type_id);
	}
	return main_window_documents_type_id__volatile;
}


gpointer main_window_documents_ref (gpointer instance) {
	MainWindowDocuments* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void main_window_documents_unref (gpointer instance) {
	MainWindowDocuments* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		MAIN_WINDOW_DOCUMENTS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



