/* project_dialogs.c generated by valac 0.26.0.93-693b8, the Vala compiler
 * generated from project_dialogs.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gtksourceview/gtksource.h>
#include <latexila.h>
#include <gee.h>


#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _Block26Data Block26Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;

#define TYPE_PROJECTS (projects_get_type ())
#define PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECTS, Projects))
#define PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECTS, ProjectsClass))
#define IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECTS))
#define IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECTS))
#define PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECTS, ProjectsClass))

typedef struct _Projects Projects;
typedef struct _ProjectsClass ProjectsClass;
#define _projects_unref0(var) ((var == NULL) ? NULL : (var = (projects_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))

#define PROJECT_DIALOGS_TYPE_PROJECT_COLUMN (project_dialogs_project_column_get_type ())
typedef struct _Block27Data Block27Data;

struct _Block26Data {
	int _ref_count_;
	GtkFileChooserButton* directory_chooser;
	GtkFileChooserButton* main_file_chooser;
};

struct _Project {
	GFile* directory;
	GFile* main_file;
};

typedef enum  {
	PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY,
	PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE,
	PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS
} ProjectDialogsProjectColumn;

struct _Block27Data {
	int _ref_count_;
	GtkDialog* dialog;
	GtkListStore* store;
	GtkTreeView* treeview;
};



GType main_window_get_type (void) G_GNUC_CONST;
void project_dialogs_new_project (MainWindow* main_window);
static Block26Data* block26_data_ref (Block26Data* _data26_);
static void block26_data_unref (void * _userdata_);
GtkGrid* utils_get_dialog_component (const gchar* title, GtkWidget* widget);
static void __lambda100_ (Block26Data* _data26_);
static void ___lambda100__gtk_file_chooser_button_file_set (GtkFileChooserButton* _sender, gpointer self);
GType document_get_type (void) G_GNUC_CONST;
Document* main_window_get_active_document (MainWindow* self);
GFile* document_get_location (Document* self);
gboolean project_dialogs_main_file_is_in_directory (GtkWindow* window, GFile* main_file, GFile* directory);
GType project_get_type (void) G_GNUC_CONST;
Project* project_dup (const Project* self);
void project_free (Project* self);
void project_copy (const Project* self, Project* dest);
void project_destroy (Project* self);
gpointer projects_ref (gpointer instance);
void projects_unref (gpointer instance);
GParamSpec* param_spec_projects (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_projects (GValue* value, gpointer v_object);
void value_take_projects (GValue* value, gpointer v_object);
gpointer value_get_projects (const GValue* value);
GType projects_get_type (void) G_GNUC_CONST;
Projects* projects_get_default (void);
gboolean projects_add (Projects* self, Project* new_project, GFile** conflict_file);
gboolean project_dialogs_configure_project (GtkWindow* main_window, gint project_id);
Project* projects_get (Projects* self, gint id);
gboolean projects_change_main_file (Projects* self, gint num, GFile* new_main_file);
GType project_dialogs_project_column_get_type (void) G_GNUC_CONST;
void project_dialogs_manage_projects (MainWindow* main_window);
static Block27Data* block27_data_ref (Block27Data* _data27_);
static void block27_data_unref (void * _userdata_);
void project_dialogs_update_model (GtkListStore* model);
GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child);
static void __lambda101_ (Block27Data* _data27_);
gint utils_get_selected_row (GtkTreeView* view, GtkTreeIter* iter);
static void ___lambda101__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda102_ (Block27Data* _data27_);
void projects_delete (Projects* self, gint num);
static void ___lambda102__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda103_ (Block27Data* _data27_);
void projects_clear_all (Projects* self);
static void ___lambda103__gtk_button_clicked (GtkButton* _sender, gpointer self);
GeeIterator* projects_iterator (Projects* self);


static Block26Data* block26_data_ref (Block26Data* _data26_) {
	g_atomic_int_inc (&_data26_->_ref_count_);
	return _data26_;
}


static void block26_data_unref (void * _userdata_) {
	Block26Data* _data26_;
	_data26_ = (Block26Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data26_->_ref_count_)) {
		_g_object_unref0 (_data26_->main_file_chooser);
		_g_object_unref0 (_data26_->directory_chooser);
		g_slice_free (Block26Data, _data26_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda100_ (Block26Data* _data26_) {
	GFile* dir = NULL;
	GtkFileChooserButton* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = _data26_->directory_chooser;
	_tmp1_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp0_);
	dir = _tmp1_;
	{
		GtkFileChooserButton* _tmp2_ = NULL;
		_tmp2_ = _data26_->main_file_chooser;
		gtk_file_chooser_set_current_folder_file ((GtkFileChooser*) _tmp2_, dir, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch35_g_error;
		}
	}
	goto __finally35;
	__catch35_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally35:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (dir);
}


static void ___lambda100__gtk_file_chooser_button_file_set (GtkFileChooserButton* _sender, gpointer self) {
	__lambda100_ (self);
}


void project_dialogs_new_project (MainWindow* main_window) {
	Block26Data* _data26_;
	GtkDialog* dialog = NULL;
	const gchar* _tmp0_ = NULL;
	MainWindow* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkDialog* _tmp4_ = NULL;
	GtkBox* content_area = NULL;
	GtkDialog* _tmp5_ = NULL;
	GtkBox* _tmp6_ = NULL;
	GtkBox* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GtkFileChooserButton* _tmp9_ = NULL;
	GtkFileChooserButton* _tmp10_ = NULL;
	GtkFileChooserButton* _tmp11_ = NULL;
	GtkWidget* component = NULL;
	const gchar* _tmp12_ = NULL;
	GtkFileChooserButton* _tmp13_ = NULL;
	GtkGrid* _tmp14_ = NULL;
	GtkBox* _tmp15_ = NULL;
	GtkWidget* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	GtkFileChooserButton* _tmp18_ = NULL;
	GtkFileChooserButton* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	GtkFileChooserButton* _tmp21_ = NULL;
	GtkGrid* _tmp22_ = NULL;
	GtkBox* _tmp23_ = NULL;
	GtkWidget* _tmp24_ = NULL;
	GtkBox* _tmp25_ = NULL;
	GtkFileChooserButton* _tmp26_ = NULL;
	Document* doc = NULL;
	MainWindow* _tmp27_ = NULL;
	Document* _tmp28_ = NULL;
	Document* _tmp29_ = NULL;
	Document* _tmp30_ = NULL;
	gboolean _tmp31_ = FALSE;
	Document* _tmp32_ = NULL;
	GtkDialog* _tmp82_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (main_window != NULL);
	_data26_ = g_slice_new0 (Block26Data);
	_data26_->_ref_count_ = 1;
	_tmp0_ = _ ("New Project");
	_tmp1_ = main_window;
	_tmp2_ = _ ("_Cancel");
	_tmp3_ = _ ("_New");
	_tmp4_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp0_, (GtkWindow*) _tmp1_, GTK_DIALOG_DESTROY_WITH_PARENT, _tmp2_, GTK_RESPONSE_CANCEL, _tmp3_, GTK_RESPONSE_OK, NULL, NULL);
	g_object_ref_sink (_tmp4_);
	dialog = _tmp4_;
	_tmp5_ = dialog;
	_tmp6_ = (GtkBox*) gtk_dialog_get_content_area (_tmp5_);
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, gtk_box_get_type ()) ? ((GtkBox*) _tmp6_) : NULL);
	content_area = _tmp7_;
	_tmp8_ = _ ("Directory");
	_tmp9_ = (GtkFileChooserButton*) gtk_file_chooser_button_new (_tmp8_, GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER);
	g_object_ref_sink (_tmp9_);
	_data26_->directory_chooser = _tmp9_;
	_tmp10_ = _data26_->directory_chooser;
	gtk_widget_set_size_request ((GtkWidget*) _tmp10_, 250, -1);
	_tmp11_ = _data26_->directory_chooser;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp11_, TRUE);
	_tmp12_ = _ ("Directory");
	_tmp13_ = _data26_->directory_chooser;
	_tmp14_ = utils_get_dialog_component (_tmp12_, (GtkWidget*) _tmp13_);
	component = (GtkWidget*) _tmp14_;
	_tmp15_ = content_area;
	_tmp16_ = component;
	gtk_box_pack_start (_tmp15_, _tmp16_, FALSE, TRUE, (guint) 0);
	_tmp17_ = _ ("Main File");
	_tmp18_ = (GtkFileChooserButton*) gtk_file_chooser_button_new (_tmp17_, GTK_FILE_CHOOSER_ACTION_OPEN);
	g_object_ref_sink (_tmp18_);
	_data26_->main_file_chooser = _tmp18_;
	_tmp19_ = _data26_->main_file_chooser;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp19_, TRUE);
	_tmp20_ = _ ("Main File");
	_tmp21_ = _data26_->main_file_chooser;
	_tmp22_ = utils_get_dialog_component (_tmp20_, (GtkWidget*) _tmp21_);
	_g_object_unref0 (component);
	component = (GtkWidget*) _tmp22_;
	_tmp23_ = content_area;
	_tmp24_ = component;
	gtk_box_pack_start (_tmp23_, _tmp24_, FALSE, TRUE, (guint) 0);
	_tmp25_ = content_area;
	gtk_widget_show_all ((GtkWidget*) _tmp25_);
	_tmp26_ = _data26_->directory_chooser;
	g_signal_connect_data (_tmp26_, "file-set", (GCallback) ___lambda100__gtk_file_chooser_button_file_set, block26_data_ref (_data26_), (GClosureNotify) block26_data_unref, 0);
	_tmp27_ = main_window;
	_tmp28_ = main_window_get_active_document (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = _g_object_ref0 (_tmp29_);
	doc = _tmp30_;
	_tmp32_ = doc;
	if (_tmp32_ != NULL) {
		Document* _tmp33_ = NULL;
		GFile* _tmp34_ = NULL;
		GFile* _tmp35_ = NULL;
		_tmp33_ = doc;
		_tmp34_ = document_get_location (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp31_ = _tmp35_ != NULL;
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		{
			GtkFileChooserButton* _tmp36_ = NULL;
			Document* _tmp37_ = NULL;
			GFile* _tmp38_ = NULL;
			GFile* _tmp39_ = NULL;
			GFile* _tmp40_ = NULL;
			GFile* _tmp41_ = NULL;
			GtkFileChooserButton* _tmp42_ = NULL;
			Document* _tmp43_ = NULL;
			GFile* _tmp44_ = NULL;
			GFile* _tmp45_ = NULL;
			_tmp36_ = _data26_->directory_chooser;
			_tmp37_ = doc;
			_tmp38_ = document_get_location (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = g_file_get_parent (_tmp39_);
			_tmp41_ = _tmp40_;
			gtk_file_chooser_set_file ((GtkFileChooser*) _tmp36_, _tmp41_, &_inner_error_);
			_g_object_unref0 (_tmp41_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch36_g_error;
			}
			_tmp42_ = _data26_->main_file_chooser;
			_tmp43_ = doc;
			_tmp44_ = document_get_location (_tmp43_);
			_tmp45_ = _tmp44_;
			gtk_file_chooser_set_file ((GtkFileChooser*) _tmp42_, _tmp45_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch36_g_error;
			}
		}
		goto __finally36;
		__catch36_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally36:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (doc);
			_g_object_unref0 (component);
			_g_object_unref0 (content_area);
			_g_object_unref0 (dialog);
			block26_data_unref (_data26_);
			_data26_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	while (TRUE) {
		GtkDialog* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		GFile* directory = NULL;
		GtkFileChooserButton* _tmp48_ = NULL;
		GFile* _tmp49_ = NULL;
		GFile* main_file = NULL;
		GtkFileChooserButton* _tmp50_ = NULL;
		GFile* _tmp51_ = NULL;
		gboolean _tmp52_ = FALSE;
		GFile* _tmp53_ = NULL;
		GtkDialog* _tmp55_ = NULL;
		GFile* _tmp56_ = NULL;
		GFile* _tmp57_ = NULL;
		gboolean _tmp58_ = FALSE;
		Project project = {0};
		GFile* _tmp59_ = NULL;
		GFile* _tmp60_ = NULL;
		GFile* _tmp61_ = NULL;
		GFile* _tmp62_ = NULL;
		GFile* conflict = NULL;
		Projects* _tmp63_ = NULL;
		Projects* _tmp64_ = NULL;
		Project _tmp65_ = {0};
		GFile* _tmp66_ = NULL;
		gboolean _tmp67_ = FALSE;
		gboolean _tmp68_ = FALSE;
		GtkDialog* error_dialog = NULL;
		GtkDialog* _tmp69_ = NULL;
		const gchar* _tmp70_ = NULL;
		GFile* _tmp71_ = NULL;
		gchar* _tmp72_ = NULL;
		gchar* _tmp73_ = NULL;
		gchar* _tmp74_ = NULL;
		gchar* _tmp75_ = NULL;
		gchar* _tmp76_ = NULL;
		gchar* _tmp77_ = NULL;
		GtkMessageDialog* _tmp78_ = NULL;
		GtkDialog* _tmp79_ = NULL;
		GtkDialog* _tmp80_ = NULL;
		GtkDialog* _tmp81_ = NULL;
		_tmp46_ = dialog;
		_tmp47_ = gtk_dialog_run (_tmp46_);
		if (!(_tmp47_ == ((gint) GTK_RESPONSE_OK))) {
			break;
		}
		_tmp48_ = _data26_->directory_chooser;
		_tmp49_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp48_);
		directory = _tmp49_;
		_tmp50_ = _data26_->main_file_chooser;
		_tmp51_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp50_);
		main_file = _tmp51_;
		_tmp53_ = directory;
		if (_tmp53_ == NULL) {
			_tmp52_ = TRUE;
		} else {
			GFile* _tmp54_ = NULL;
			_tmp54_ = main_file;
			_tmp52_ = _tmp54_ == NULL;
		}
		if (_tmp52_) {
			_g_object_unref0 (main_file);
			_g_object_unref0 (directory);
			continue;
		}
		_tmp55_ = dialog;
		_tmp56_ = main_file;
		_tmp57_ = directory;
		_tmp58_ = project_dialogs_main_file_is_in_directory ((GtkWindow*) _tmp55_, _tmp56_, _tmp57_);
		if (!_tmp58_) {
			_g_object_unref0 (main_file);
			_g_object_unref0 (directory);
			continue;
		}
		memset (&project, 0, sizeof (Project));
		_tmp59_ = directory;
		_tmp60_ = _g_object_ref0 (_tmp59_);
		_g_object_unref0 (project.directory);
		project.directory = _tmp60_;
		_tmp61_ = main_file;
		_tmp62_ = _g_object_ref0 (_tmp61_);
		_g_object_unref0 (project.main_file);
		project.main_file = _tmp62_;
		_tmp63_ = projects_get_default ();
		_tmp64_ = _tmp63_;
		_tmp65_ = project;
		_tmp67_ = projects_add (_tmp64_, &_tmp65_, &_tmp66_);
		_g_object_unref0 (conflict);
		conflict = _tmp66_;
		_tmp68_ = _tmp67_;
		_projects_unref0 (_tmp64_);
		if (_tmp68_) {
			_g_object_unref0 (conflict);
			project_destroy (&project);
			_g_object_unref0 (main_file);
			_g_object_unref0 (directory);
			break;
		}
		_tmp69_ = dialog;
		_tmp70_ = _ ("There is a conflict with the project \"%s\".");
		_tmp71_ = conflict;
		_tmp72_ = g_file_get_parse_name (_tmp71_);
		_tmp73_ = _tmp72_;
		_tmp74_ = latexila_utils_replace_home_dir_with_tilde (_tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = g_strconcat (_tmp75_, "/", NULL);
		_tmp77_ = _tmp76_;
		_tmp78_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp69_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _tmp70_, _tmp77_);
		g_object_ref_sink (_tmp78_);
		_tmp79_ = (GtkDialog*) _tmp78_;
		_g_free0 (_tmp77_);
		_g_free0 (_tmp75_);
		_g_free0 (_tmp73_);
		error_dialog = _tmp79_;
		_tmp80_ = error_dialog;
		gtk_dialog_run (_tmp80_);
		_tmp81_ = error_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp81_);
		_g_object_unref0 (error_dialog);
		_g_object_unref0 (conflict);
		project_destroy (&project);
		_g_object_unref0 (main_file);
		_g_object_unref0 (directory);
	}
	_tmp82_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp82_);
	_g_object_unref0 (doc);
	_g_object_unref0 (component);
	_g_object_unref0 (content_area);
	_g_object_unref0 (dialog);
	block26_data_unref (_data26_);
	_data26_ = NULL;
}


gboolean project_dialogs_configure_project (GtkWindow* main_window, gint project_id) {
	gboolean result = FALSE;
	Project* project = NULL;
	Projects* _tmp0_ = NULL;
	Projects* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	Project* _tmp3_ = NULL;
	Project* _tmp4_ = NULL;
	Project* _tmp5_ = NULL;
	GtkDialog* dialog = NULL;
	const gchar* _tmp6_ = NULL;
	GtkWindow* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GtkDialog* _tmp10_ = NULL;
	GtkBox* content_area = NULL;
	GtkDialog* _tmp11_ = NULL;
	GtkBox* _tmp12_ = NULL;
	GtkBox* _tmp13_ = NULL;
	gchar* project_dir = NULL;
	Project* _tmp14_ = NULL;
	GFile* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	GtkLabel* location = NULL;
	const gchar* _tmp21_ = NULL;
	GtkLabel* _tmp22_ = NULL;
	GtkLabel* _tmp23_ = NULL;
	GtkLabel* _tmp24_ = NULL;
	GtkLabel* _tmp25_ = NULL;
	GtkWidget* component = NULL;
	const gchar* _tmp26_ = NULL;
	GtkLabel* _tmp27_ = NULL;
	GtkGrid* _tmp28_ = NULL;
	GtkBox* _tmp29_ = NULL;
	GtkWidget* _tmp30_ = NULL;
	GtkFileChooserButton* main_file_chooser = NULL;
	const gchar* _tmp31_ = NULL;
	GtkFileChooserButton* _tmp32_ = NULL;
	GtkFileChooserButton* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	GtkFileChooserButton* _tmp35_ = NULL;
	GtkGrid* _tmp36_ = NULL;
	GtkBox* _tmp37_ = NULL;
	GtkWidget* _tmp38_ = NULL;
	GtkBox* _tmp39_ = NULL;
	gboolean ret = FALSE;
	GtkDialog* _tmp58_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (main_window != NULL, FALSE);
	_tmp0_ = projects_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = project_id;
	_tmp3_ = projects_get (_tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	_projects_unref0 (_tmp1_);
	project = _tmp4_;
	_tmp5_ = project;
	g_return_val_if_fail (_tmp5_ != NULL, FALSE);
	_tmp6_ = _ ("Configure Project");
	_tmp7_ = main_window;
	_tmp8_ = _ ("_Cancel");
	_tmp9_ = _ ("_OK");
	_tmp10_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp6_, _tmp7_, GTK_DIALOG_DESTROY_WITH_PARENT, _tmp8_, GTK_RESPONSE_CANCEL, _tmp9_, GTK_RESPONSE_OK, NULL, NULL);
	g_object_ref_sink (_tmp10_);
	dialog = _tmp10_;
	_tmp11_ = dialog;
	_tmp12_ = (GtkBox*) gtk_dialog_get_content_area (_tmp11_);
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, gtk_box_get_type ()) ? ((GtkBox*) _tmp12_) : NULL);
	content_area = _tmp13_;
	_tmp14_ = project;
	_tmp15_ = (*_tmp14_).directory;
	_tmp16_ = g_file_get_parse_name (_tmp15_);
	project_dir = _tmp16_;
	_tmp17_ = project_dir;
	_tmp18_ = latexila_utils_replace_home_dir_with_tilde (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strconcat (_tmp19_, "/", NULL);
	_g_free0 (project_dir);
	project_dir = _tmp20_;
	_g_free0 (_tmp19_);
	_tmp21_ = project_dir;
	_tmp22_ = (GtkLabel*) gtk_label_new (_tmp21_);
	g_object_ref_sink (_tmp22_);
	location = _tmp22_;
	_tmp23_ = location;
	gtk_label_set_line_wrap (_tmp23_, TRUE);
	_tmp24_ = location;
	gtk_widget_set_halign ((GtkWidget*) _tmp24_, GTK_ALIGN_START);
	_tmp25_ = location;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp25_, TRUE);
	_tmp26_ = _ ("Location of the project");
	_tmp27_ = location;
	_tmp28_ = utils_get_dialog_component (_tmp26_, (GtkWidget*) _tmp27_);
	component = (GtkWidget*) _tmp28_;
	_tmp29_ = content_area;
	_tmp30_ = component;
	gtk_box_pack_start (_tmp29_, _tmp30_, FALSE, TRUE, (guint) 0);
	_tmp31_ = _ ("Main File");
	_tmp32_ = (GtkFileChooserButton*) gtk_file_chooser_button_new (_tmp31_, GTK_FILE_CHOOSER_ACTION_OPEN);
	g_object_ref_sink (_tmp32_);
	main_file_chooser = _tmp32_;
	_tmp33_ = main_file_chooser;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp33_, TRUE);
	_tmp34_ = _ ("Main File");
	_tmp35_ = main_file_chooser;
	_tmp36_ = utils_get_dialog_component (_tmp34_, (GtkWidget*) _tmp35_);
	_g_object_unref0 (component);
	component = (GtkWidget*) _tmp36_;
	_tmp37_ = content_area;
	_tmp38_ = component;
	gtk_box_pack_start (_tmp37_, _tmp38_, FALSE, TRUE, (guint) 0);
	_tmp39_ = content_area;
	gtk_widget_show_all ((GtkWidget*) _tmp39_);
	{
		GtkFileChooserButton* _tmp40_ = NULL;
		Project* _tmp41_ = NULL;
		GFile* _tmp42_ = NULL;
		_tmp40_ = main_file_chooser;
		_tmp41_ = project;
		_tmp42_ = (*_tmp41_).main_file;
		gtk_file_chooser_set_file ((GtkFileChooser*) _tmp40_, _tmp42_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch37_g_error;
		}
	}
	goto __finally37;
	__catch37_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally37:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (main_file_chooser);
		_g_object_unref0 (component);
		_g_object_unref0 (location);
		_g_free0 (project_dir);
		_g_object_unref0 (content_area);
		_g_object_unref0 (dialog);
		_project_free0 (project);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	ret = FALSE;
	while (TRUE) {
		GtkDialog* _tmp43_ = NULL;
		gint _tmp44_ = 0;
		GFile* main_file = NULL;
		GtkFileChooserButton* _tmp45_ = NULL;
		GFile* _tmp46_ = NULL;
		GFile* _tmp47_ = NULL;
		GtkDialog* _tmp48_ = NULL;
		GFile* _tmp49_ = NULL;
		Project* _tmp50_ = NULL;
		GFile* _tmp51_ = NULL;
		gboolean _tmp52_ = FALSE;
		Projects* _tmp53_ = NULL;
		Projects* _tmp54_ = NULL;
		gint _tmp55_ = 0;
		GFile* _tmp56_ = NULL;
		gboolean _tmp57_ = FALSE;
		_tmp43_ = dialog;
		_tmp44_ = gtk_dialog_run (_tmp43_);
		if (!(_tmp44_ == ((gint) GTK_RESPONSE_OK))) {
			break;
		}
		_tmp45_ = main_file_chooser;
		_tmp46_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp45_);
		main_file = _tmp46_;
		_tmp47_ = main_file;
		if (_tmp47_ == NULL) {
			_g_object_unref0 (main_file);
			continue;
		}
		_tmp48_ = dialog;
		_tmp49_ = main_file;
		_tmp50_ = project;
		_tmp51_ = (*_tmp50_).directory;
		_tmp52_ = project_dialogs_main_file_is_in_directory ((GtkWindow*) _tmp48_, _tmp49_, _tmp51_);
		if (!_tmp52_) {
			_g_object_unref0 (main_file);
			continue;
		}
		_tmp53_ = projects_get_default ();
		_tmp54_ = _tmp53_;
		_tmp55_ = project_id;
		_tmp56_ = main_file;
		_tmp57_ = projects_change_main_file (_tmp54_, _tmp55_, _tmp56_);
		ret = _tmp57_;
		_projects_unref0 (_tmp54_);
		_g_object_unref0 (main_file);
		break;
	}
	_tmp58_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp58_);
	result = ret;
	_g_object_unref0 (main_file_chooser);
	_g_object_unref0 (component);
	_g_object_unref0 (location);
	_g_free0 (project_dir);
	_g_object_unref0 (content_area);
	_g_object_unref0 (dialog);
	_project_free0 (project);
	return result;
}


GType project_dialogs_project_column_get_type (void) {
	static volatile gsize project_dialogs_project_column_type_id__volatile = 0;
	if (g_once_init_enter (&project_dialogs_project_column_type_id__volatile)) {
		static const GEnumValue values[] = {{PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, "PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY", "directory"}, {PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE, "PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE", "main-file"}, {PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS, "PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType project_dialogs_project_column_type_id;
		project_dialogs_project_column_type_id = g_enum_register_static ("ProjectDialogsProjectColumn", values);
		g_once_init_leave (&project_dialogs_project_column_type_id__volatile, project_dialogs_project_column_type_id);
	}
	return project_dialogs_project_column_type_id__volatile;
}


static Block27Data* block27_data_ref (Block27Data* _data27_) {
	g_atomic_int_inc (&_data27_->_ref_count_);
	return _data27_;
}


static void block27_data_unref (void * _userdata_) {
	Block27Data* _data27_;
	_data27_ = (Block27Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data27_->_ref_count_)) {
		_g_object_unref0 (_data27_->treeview);
		_g_object_unref0 (_data27_->store);
		_g_object_unref0 (_data27_->dialog);
		g_slice_free (Block27Data, _data27_);
	}
}


static void __lambda101_ (Block27Data* _data27_) {
	gint i = 0;
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_ = 0;
	_tmp0_ = utils_get_selected_row (_data27_->treeview, NULL);
	i = _tmp0_;
	_tmp2_ = i;
	if (_tmp2_ != (-1)) {
		gint _tmp3_ = 0;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = i;
		_tmp4_ = project_dialogs_configure_project ((GtkWindow*) _data27_->dialog, _tmp3_);
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		project_dialogs_update_model (_data27_->store);
	}
}


static void ___lambda101__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda101_ (self);
}


static void __lambda102_ (Block27Data* _data27_) {
	GtkTreeIter iter = {0};
	gint i = 0;
	GtkTreeIter _tmp0_ = {0};
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gchar* directory = NULL;
	GtkTreeModel* model = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	GtkDialog* delete_dialog = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkMessageDialog* _tmp8_ = NULL;
	GtkDialog* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GtkDialog* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	GtkDialog* _tmp18_ = NULL;
	_tmp1_ = utils_get_selected_row (_data27_->treeview, &_tmp0_);
	iter = _tmp0_;
	i = _tmp1_;
	_tmp2_ = i;
	if (_tmp2_ == (-1)) {
		return;
	}
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data27_->store, GTK_TYPE_TREE_MODEL, GtkTreeModel));
	model = _tmp3_;
	_tmp4_ = model;
	_tmp5_ = iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, &directory, -1, -1);
	_tmp6_ = _ ("Do you really want to delete the project \"%s\"?");
	_tmp7_ = directory;
	_tmp8_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _data27_->dialog, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _tmp6_, _tmp7_);
	g_object_ref_sink (_tmp8_);
	delete_dialog = (GtkDialog*) _tmp8_;
	_tmp9_ = delete_dialog;
	_tmp10_ = _ ("_Cancel");
	_tmp11_ = _ ("_Delete");
	gtk_dialog_add_buttons (_tmp9_, _tmp10_, GTK_RESPONSE_CANCEL, _tmp11_, GTK_RESPONSE_YES, NULL);
	_tmp12_ = delete_dialog;
	_tmp13_ = gtk_dialog_run (_tmp12_);
	if (_tmp13_ == ((gint) GTK_RESPONSE_YES)) {
		GtkTreeIter _tmp14_ = {0};
		Projects* _tmp15_ = NULL;
		Projects* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		_tmp14_ = iter;
		gtk_list_store_remove (_data27_->store, &_tmp14_);
		_tmp15_ = projects_get_default ();
		_tmp16_ = _tmp15_;
		_tmp17_ = i;
		projects_delete (_tmp16_, _tmp17_);
		_projects_unref0 (_tmp16_);
	}
	_tmp18_ = delete_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp18_);
	_g_object_unref0 (delete_dialog);
	_g_object_unref0 (model);
	_g_free0 (directory);
}


static void ___lambda102__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda102_ (self);
}


static void __lambda103_ (Block27Data* _data27_) {
	GtkDialog* clear_dialog = NULL;
	const gchar* _tmp0_ = NULL;
	GtkMessageDialog* _tmp1_ = NULL;
	GtkDialog* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkDialog* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GtkDialog* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	GtkDialog* _tmp10_ = NULL;
	_tmp0_ = _ ("Do you really want to clear all projects?");
	_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _data27_->dialog, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _tmp0_);
	g_object_ref_sink (_tmp1_);
	clear_dialog = (GtkDialog*) _tmp1_;
	_tmp2_ = clear_dialog;
	_tmp3_ = _ ("_Cancel");
	gtk_dialog_add_button (_tmp2_, _tmp3_, (gint) GTK_RESPONSE_CANCEL);
	_tmp4_ = clear_dialog;
	_tmp5_ = _ ("Clear _All");
	gtk_dialog_add_button (_tmp4_, _tmp5_, (gint) GTK_RESPONSE_YES);
	_tmp6_ = clear_dialog;
	_tmp7_ = gtk_dialog_run (_tmp6_);
	if (_tmp7_ == ((gint) GTK_RESPONSE_YES)) {
		Projects* _tmp8_ = NULL;
		Projects* _tmp9_ = NULL;
		_tmp8_ = projects_get_default ();
		_tmp9_ = _tmp8_;
		projects_clear_all (_tmp9_);
		_projects_unref0 (_tmp9_);
		gtk_list_store_clear (_data27_->store);
	}
	_tmp10_ = clear_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp10_);
	_g_object_unref0 (clear_dialog);
}


static void ___lambda103__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda103_ (self);
}


void project_dialogs_manage_projects (MainWindow* main_window) {
	Block27Data* _data27_;
	const gchar* _tmp0_ = NULL;
	MainWindow* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkDialog* _tmp3_ = NULL;
	GtkBox* content_area = NULL;
	GtkBox* _tmp4_ = NULL;
	GtkBox* _tmp5_ = NULL;
	GtkListStore* _tmp6_ = NULL;
	GtkTreeView* _tmp7_ = NULL;
	GtkTreeViewColumn* column = NULL;
	GtkTreeViewColumn* _tmp8_ = NULL;
	GtkTreeViewColumn* _tmp9_ = NULL;
	GtkTreeViewColumn* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GtkCellRendererPixbuf* pixbuf_renderer = NULL;
	GtkCellRendererPixbuf* _tmp12_ = NULL;
	GtkCellRendererPixbuf* _tmp13_ = NULL;
	GtkTreeViewColumn* _tmp14_ = NULL;
	GtkCellRendererPixbuf* _tmp15_ = NULL;
	GtkCellRendererText* text_renderer = NULL;
	GtkCellRendererText* _tmp16_ = NULL;
	GtkTreeViewColumn* _tmp17_ = NULL;
	GtkCellRendererText* _tmp18_ = NULL;
	GtkTreeViewColumn* _tmp19_ = NULL;
	GtkCellRendererText* _tmp20_ = NULL;
	GtkTreeViewColumn* _tmp21_ = NULL;
	GtkTreeViewColumn* _tmp22_ = NULL;
	GtkTreeViewColumn* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	GtkCellRendererPixbuf* _tmp25_ = NULL;
	GtkCellRendererPixbuf* _tmp26_ = NULL;
	GtkTreeViewColumn* _tmp27_ = NULL;
	GtkCellRendererPixbuf* _tmp28_ = NULL;
	GtkCellRendererText* _tmp29_ = NULL;
	GtkTreeViewColumn* _tmp30_ = NULL;
	GtkCellRendererText* _tmp31_ = NULL;
	GtkTreeViewColumn* _tmp32_ = NULL;
	GtkCellRendererText* _tmp33_ = NULL;
	GtkTreeSelection* select = NULL;
	GtkTreeSelection* _tmp34_ = NULL;
	GtkTreeSelection* _tmp35_ = NULL;
	GtkScrolledWindow* sw = NULL;
	GtkScrolledWindow* _tmp36_ = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp37_ = NULL;
	GtkButton* edit_button = NULL;
	const gchar* _tmp38_ = NULL;
	GtkButton* _tmp39_ = NULL;
	GtkButton* delete_button = NULL;
	const gchar* _tmp40_ = NULL;
	GtkButton* _tmp41_ = NULL;
	GtkButton* clear_all_button = NULL;
	const gchar* _tmp42_ = NULL;
	GtkButton* _tmp43_ = NULL;
	g_return_if_fail (main_window != NULL);
	_data27_ = g_slice_new0 (Block27Data);
	_data27_->_ref_count_ = 1;
	_tmp0_ = _ ("Manage Projects");
	_tmp1_ = main_window;
	_tmp2_ = _ ("_Close");
	_tmp3_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp0_, (GtkWindow*) _tmp1_, GTK_DIALOG_DESTROY_WITH_PARENT, _tmp2_, GTK_RESPONSE_OK, NULL, NULL);
	g_object_ref_sink (_tmp3_);
	_data27_->dialog = _tmp3_;
	_tmp4_ = (GtkBox*) gtk_dialog_get_content_area (_data27_->dialog);
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_box_get_type ()) ? ((GtkBox*) _tmp4_) : NULL);
	content_area = _tmp5_;
	gtk_widget_set_size_request ((GtkWidget*) content_area, 400, 250);
	_tmp6_ = gtk_list_store_new ((gint) PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, -1);
	_data27_->store = _tmp6_;
	project_dialogs_update_model (_data27_->store);
	_tmp7_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _data27_->store);
	g_object_ref_sink (_tmp7_);
	_data27_->treeview = _tmp7_;
	_tmp8_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp8_);
	column = _tmp8_;
	_tmp9_ = column;
	gtk_tree_view_append_column (_data27_->treeview, _tmp9_);
	_tmp10_ = column;
	_tmp11_ = _ ("Directory");
	gtk_tree_view_column_set_title (_tmp10_, _tmp11_);
	_tmp12_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp12_);
	pixbuf_renderer = _tmp12_;
	_tmp13_ = pixbuf_renderer;
	g_object_set (_tmp13_, "icon-name", "folder", NULL);
	_tmp14_ = column;
	_tmp15_ = pixbuf_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp14_, (GtkCellRenderer*) _tmp15_, FALSE);
	_tmp16_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp16_);
	text_renderer = _tmp16_;
	_tmp17_ = column;
	_tmp18_ = text_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp17_, (GtkCellRenderer*) _tmp18_, TRUE);
	_tmp19_ = column;
	_tmp20_ = text_renderer;
	gtk_tree_view_column_set_attributes (_tmp19_, (GtkCellRenderer*) _tmp20_, "text", PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, NULL, NULL);
	_tmp21_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (column);
	column = _tmp21_;
	_tmp22_ = column;
	gtk_tree_view_append_column (_data27_->treeview, _tmp22_);
	_tmp23_ = column;
	_tmp24_ = _ ("Main File");
	gtk_tree_view_column_set_title (_tmp23_, _tmp24_);
	_tmp25_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (pixbuf_renderer);
	pixbuf_renderer = _tmp25_;
	_tmp26_ = pixbuf_renderer;
	g_object_set (_tmp26_, "icon-name", "text-x-generic", NULL);
	_tmp27_ = column;
	_tmp28_ = pixbuf_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp27_, (GtkCellRenderer*) _tmp28_, FALSE);
	_tmp29_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (text_renderer);
	text_renderer = _tmp29_;
	_tmp30_ = column;
	_tmp31_ = text_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp30_, (GtkCellRenderer*) _tmp31_, TRUE);
	_tmp32_ = column;
	_tmp33_ = text_renderer;
	gtk_tree_view_column_set_attributes (_tmp32_, (GtkCellRenderer*) _tmp33_, "text", PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE, NULL, NULL);
	_tmp34_ = gtk_tree_view_get_selection (_data27_->treeview);
	_tmp35_ = _g_object_ref0 (_tmp34_);
	select = _tmp35_;
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	_tmp36_ = utils_add_scrollbar ((GtkWidget*) _data27_->treeview);
	sw = _tmp36_;
	gtk_box_pack_start (content_area, (GtkWidget*) sw, TRUE, TRUE, (guint) 0);
	_tmp37_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp37_);
	grid = _tmp37_;
	gtk_orientable_set_orientation ((GtkOrientable*) grid, GTK_ORIENTATION_HORIZONTAL);
	gtk_grid_set_column_spacing (grid, (guint) 5);
	gtk_box_pack_start (content_area, (GtkWidget*) grid, FALSE, FALSE, (guint) 5);
	_tmp38_ = _ ("_Properties");
	_tmp39_ = (GtkButton*) gtk_button_new_with_mnemonic (_tmp38_);
	g_object_ref_sink (_tmp39_);
	edit_button = _tmp39_;
	_tmp40_ = _ ("_Delete");
	_tmp41_ = (GtkButton*) gtk_button_new_with_mnemonic (_tmp40_);
	g_object_ref_sink (_tmp41_);
	delete_button = _tmp41_;
	_tmp42_ = _ ("_Clear All");
	_tmp43_ = (GtkButton*) gtk_button_new_with_mnemonic (_tmp42_);
	g_object_ref_sink (_tmp43_);
	clear_all_button = _tmp43_;
	gtk_container_add ((GtkContainer*) grid, (GtkWidget*) edit_button);
	gtk_container_add ((GtkContainer*) grid, (GtkWidget*) delete_button);
	gtk_container_add ((GtkContainer*) grid, (GtkWidget*) clear_all_button);
	gtk_widget_show_all ((GtkWidget*) content_area);
	g_signal_connect_data (edit_button, "clicked", (GCallback) ___lambda101__gtk_button_clicked, block27_data_ref (_data27_), (GClosureNotify) block27_data_unref, 0);
	g_signal_connect_data (delete_button, "clicked", (GCallback) ___lambda102__gtk_button_clicked, block27_data_ref (_data27_), (GClosureNotify) block27_data_unref, 0);
	g_signal_connect_data (clear_all_button, "clicked", (GCallback) ___lambda103__gtk_button_clicked, block27_data_ref (_data27_), (GClosureNotify) block27_data_unref, 0);
	gtk_dialog_run (_data27_->dialog);
	gtk_widget_destroy ((GtkWidget*) _data27_->dialog);
	_g_object_unref0 (clear_all_button);
	_g_object_unref0 (delete_button);
	_g_object_unref0 (edit_button);
	_g_object_unref0 (grid);
	_g_object_unref0 (sw);
	_g_object_unref0 (select);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
	_g_object_unref0 (column);
	_g_object_unref0 (content_area);
	block27_data_unref (_data27_);
	_data27_ = NULL;
}


gboolean project_dialogs_main_file_is_in_directory (GtkWindow* window, GFile* main_file, GFile* directory) {
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GtkDialog* error_dialog = NULL;
	GtkWindow* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GtkMessageDialog* _tmp5_ = NULL;
	GtkDialog* _tmp6_ = NULL;
	GtkDialog* _tmp7_ = NULL;
	g_return_val_if_fail (window != NULL, FALSE);
	g_return_val_if_fail (main_file != NULL, FALSE);
	g_return_val_if_fail (directory != NULL, FALSE);
	_tmp0_ = main_file;
	_tmp1_ = directory;
	_tmp2_ = g_file_has_prefix (_tmp0_, _tmp1_);
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	_tmp3_ = window;
	_tmp4_ = _ ("The Main File is not in the directory.");
	_tmp5_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp3_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "%s", _tmp4_);
	g_object_ref_sink (_tmp5_);
	error_dialog = (GtkDialog*) _tmp5_;
	_tmp6_ = error_dialog;
	gtk_dialog_run (_tmp6_);
	_tmp7_ = error_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp7_);
	result = FALSE;
	_g_object_unref0 (error_dialog);
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


void project_dialogs_update_model (GtkListStore* model) {
	GtkListStore* _tmp0_ = NULL;
	g_return_if_fail (model != NULL);
	_tmp0_ = model;
	gtk_list_store_clear (_tmp0_);
	{
		GeeIterator* _project_it = NULL;
		Projects* _tmp1_ = NULL;
		Projects* _tmp2_ = NULL;
		GeeIterator* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		_tmp1_ = projects_get_default ();
		_tmp2_ = _tmp1_;
		_tmp3_ = projects_iterator (_tmp2_);
		_tmp4_ = _tmp3_;
		_projects_unref0 (_tmp2_);
		_project_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
			Project project = {0};
			GeeIterator* _tmp7_ = NULL;
			gpointer _tmp8_ = NULL;
			Project* _tmp9_ = NULL;
			Project _tmp10_ = {0};
			Project _tmp11_ = {0};
			gchar* uri_directory = NULL;
			Project _tmp12_ = {0};
			GFile* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			gchar* uri_main_file = NULL;
			Project _tmp15_ = {0};
			GFile* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			gchar* dir = NULL;
			const gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			gchar* main_file = NULL;
			const gchar* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
			const gchar* _tmp27_ = NULL;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			gchar* _tmp30_ = NULL;
			GtkTreeIter iter = {0};
			GtkListStore* _tmp31_ = NULL;
			GtkTreeIter _tmp32_ = {0};
			GtkListStore* _tmp33_ = NULL;
			GtkTreeIter _tmp34_ = {0};
			const gchar* _tmp35_ = NULL;
			const gchar* _tmp36_ = NULL;
			_tmp5_ = _project_it;
			_tmp6_ = gee_iterator_next (_tmp5_);
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = _project_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			_tmp9_ = (Project*) _tmp8_;
			project_copy (_tmp9_, &_tmp10_);
			_tmp11_ = _tmp10_;
			_project_free0 (_tmp9_);
			project = _tmp11_;
			_tmp12_ = project;
			_tmp13_ = _tmp12_.directory;
			_tmp14_ = g_file_get_parse_name (_tmp13_);
			uri_directory = _tmp14_;
			_tmp15_ = project;
			_tmp16_ = _tmp15_.main_file;
			_tmp17_ = g_file_get_parse_name (_tmp16_);
			uri_main_file = _tmp17_;
			_tmp18_ = uri_directory;
			_tmp19_ = latexila_utils_replace_home_dir_with_tilde (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strconcat (_tmp20_, "/", NULL);
			_tmp22_ = _tmp21_;
			_g_free0 (_tmp20_);
			dir = _tmp22_;
			_tmp23_ = uri_main_file;
			_tmp24_ = uri_directory;
			_tmp25_ = strlen (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = uri_main_file;
			_tmp28_ = strlen (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = string_slice (_tmp23_, (glong) (_tmp26_ + 1), (glong) _tmp29_);
			main_file = _tmp30_;
			_tmp31_ = model;
			gtk_list_store_append (_tmp31_, &_tmp32_);
			iter = _tmp32_;
			_tmp33_ = model;
			_tmp34_ = iter;
			_tmp35_ = dir;
			_tmp36_ = main_file;
			gtk_list_store_set (_tmp33_, &_tmp34_, PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, _tmp35_, PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE, _tmp36_, -1, -1);
			_g_free0 (main_file);
			_g_free0 (dir);
			_g_free0 (uri_main_file);
			_g_free0 (uri_directory);
			project_destroy (&project);
		}
		_g_object_unref0 (_project_it);
	}
}



