/* search.c generated by valac 0.26.0.93-693b8, the Vala compiler
 * generated from search.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2012 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <gtksourceview/gtksource.h>
#include <float.h>
#include <math.h>


#define TYPE_GOTO_LINE (goto_line_get_type ())
#define GOTO_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GOTO_LINE, GotoLine))
#define GOTO_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GOTO_LINE, GotoLineClass))
#define IS_GOTO_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GOTO_LINE))
#define IS_GOTO_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GOTO_LINE))
#define GOTO_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GOTO_LINE, GotoLineClass))

typedef struct _GotoLine GotoLine;
typedef struct _GotoLineClass GotoLineClass;
typedef struct _GotoLinePrivate GotoLinePrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

#define TYPE_SEARCH_AND_REPLACE (search_and_replace_get_type ())
#define SEARCH_AND_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_AND_REPLACE, SearchAndReplace))
#define SEARCH_AND_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_AND_REPLACE, SearchAndReplaceClass))
#define IS_SEARCH_AND_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_AND_REPLACE))
#define IS_SEARCH_AND_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_AND_REPLACE))
#define SEARCH_AND_REPLACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_AND_REPLACE, SearchAndReplaceClass))

typedef struct _SearchAndReplace SearchAndReplace;
typedef struct _SearchAndReplaceClass SearchAndReplaceClass;
typedef struct _SearchAndReplacePrivate SearchAndReplacePrivate;

#define SEARCH_AND_REPLACE_TYPE_MODE (search_and_replace_mode_get_type ())
typedef struct _Block28Data Block28Data;
typedef struct _DocumentPrivate DocumentPrivate;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block29Data Block29Data;

#define TYPE_SELECTION_TYPE (selection_type_get_type ())

struct _GotoLine {
	GtkGrid parent_instance;
	GotoLinePrivate * priv;
};

struct _GotoLineClass {
	GtkGridClass parent_class;
};

struct _GotoLinePrivate {
	MainWindow* main_window;
	GtkEntry* entry;
};

struct _SearchAndReplace {
	GObject parent_instance;
	SearchAndReplacePrivate * priv;
};

struct _SearchAndReplaceClass {
	GObjectClass parent_class;
};

struct _SearchAndReplacePrivate {
	MainWindow* _main_window;
	GtkGrid* _main_grid;
	GtkGrid* _replace_grid;
	GtkArrow* _arrow;
	GtkSearchEntry* _entry_find;
	GtkSearchEntry* _entry_replace;
	GtkLabel* _info_label;
	GtkSourceSearchSettings* _search_settings;
	GtkSourceSearchContext* _search_context;
};

typedef enum  {
	SEARCH_AND_REPLACE_MODE_SEARCH,
	SEARCH_AND_REPLACE_MODE_SEARCH_AND_REPLACE
} SearchAndReplaceMode;

struct _Block28Data {
	int _ref_count_;
	SearchAndReplace* self;
	GtkButton* button_previous;
	GtkButton* button_next;
	GtkButton* button_replace;
	GtkButton* button_replace_all;
};

struct _Document {
	GtkSourceBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
	guint _unsaved_doc_num;
};

struct _DocumentClass {
	GtkSourceBufferClass parent_class;
};

struct _Block29Data {
	int _ref_count_;
	SearchAndReplace* self;
	GtkMenu* menu;
};

typedef enum  {
	SELECTION_TYPE_NO_SELECTION,
	SELECTION_TYPE_ONE_LINE,
	SELECTION_TYPE_MULTIPLE_LINES
} SelectionType;


static gpointer goto_line_parent_class = NULL;
static gpointer search_and_replace_parent_class = NULL;

GType goto_line_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
#define GOTO_LINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GOTO_LINE, GotoLinePrivate))
enum  {
	GOTO_LINE_DUMMY_PROPERTY
};
GotoLine* goto_line_new (MainWindow* main_window);
GotoLine* goto_line_construct (GType object_type, MainWindow* main_window);
static void __lambda85_ (GotoLine* self);
static void ___lambda85__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda86_ (GotoLine* self);
static void ___lambda86__gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void __lambda87_ (GotoLine* self);
static void ___lambda87__gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self);
static void goto_line_on_changed (GotoLine* self);
static void _goto_line_on_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self);
void goto_line_show (GotoLine* self);
void error_entry_remove_error (GtkWidget* widget);
void error_entry_add_error (GtkWidget* widget);
GType document_get_type (void) G_GNUC_CONST;
Document* main_window_get_active_document (MainWindow* self);
gboolean document_goto_line (Document* self, gint line);
GType document_view_get_type (void) G_GNUC_CONST;
DocumentView* main_window_get_active_view (MainWindow* self);
void document_view_scroll_to_cursor (DocumentView* self, gdouble margin);
static void goto_line_finalize (GObject* obj);
GType search_and_replace_get_type (void) G_GNUC_CONST;
#define SEARCH_AND_REPLACE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SEARCH_AND_REPLACE, SearchAndReplacePrivate))
enum  {
	SEARCH_AND_REPLACE_DUMMY_PROPERTY
};
static GType search_and_replace_mode_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SearchAndReplaceMode search_and_replace_get_mode (SearchAndReplace* self);
SearchAndReplace* search_and_replace_new (MainWindow* main_window);
SearchAndReplace* search_and_replace_construct (GType object_type, MainWindow* main_window);
static Block28Data* block28_data_ref (Block28Data* _data28_);
static void block28_data_unref (void * _userdata_);
static void search_and_replace_init_find_entry (SearchAndReplace* self);
static GtkButton* search_and_replace_get_button (SearchAndReplace* self, const gchar* icon_name);
static void __lambda89_ (SearchAndReplace* self);
static void ___lambda89__gtk_button_clicked (GtkButton* _sender, gpointer self);
void search_and_replace_hide (SearchAndReplace* self);
static void _search_and_replace_hide_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda91_ (SearchAndReplace* self);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentView* document_tab_get_view (DocumentTab* self);
static void ___lambda91__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void search_and_replace_search_forward (SearchAndReplace* self);
static void _search_and_replace_search_forward_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _search_and_replace_search_forward_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void __lambda92_ (Block28Data* _data28_);
static void ___lambda92__gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void search_and_replace_replace (SearchAndReplace* self);
static void _search_and_replace_replace_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _search_and_replace_replace_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void __lambda93_ (SearchAndReplace* self);
static void ___lambda93__gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean __lambda94_ (SearchAndReplace* self, GdkEventKey* event);
void search_and_replace_show_search_and_replace (SearchAndReplace* self);
static gboolean ___lambda94__gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static Block29Data* block29_data_ref (Block29Data* _data29_);
static void block29_data_unref (void * _userdata_);
static void __lambda88_ (Block29Data* _data29_, GtkEntryIconPosition icon_pos, GdkEvent* event);
static void ___lambda88__gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self);
GtkWidget* search_and_replace_get_widget (SearchAndReplace* self);
void search_and_replace_show_search (SearchAndReplace* self);
static void search_and_replace_show (SearchAndReplace* self);
DocumentTab* main_window_get_active_tab (MainWindow* self);
GType selection_type_get_type (void) G_GNUC_CONST;
SelectionType document_get_selection_type (Document* self);
static void search_and_replace_connect_active_document (SearchAndReplace* self);
static void _search_and_replace_connect_active_document_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void search_and_replace_destroy_search_context (SearchAndReplace* self);
static void search_and_replace_mark_set_cb (SearchAndReplace* self, GtkTextBuffer* buffer, GtkTextIter* location, GtkTextMark* mark);
static void _search_and_replace_mark_set_cb_gtk_text_buffer_mark_set (GtkTextBuffer* _sender, GtkTextIter* location, GtkTextMark* mark, gpointer self);
static void __lambda90_ (SearchAndReplace* self);
static void search_and_replace_update_info_label (SearchAndReplace* self);
static void ___lambda90__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
gboolean document_get_readonly (Document* self);
static void search_and_replace_finalize (GObject* obj);


static void __lambda85_ (GotoLine* self) {
	gtk_widget_hide ((GtkWidget*) self);
}


static void ___lambda85__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda85_ ((GotoLine*) self);
}


static void __lambda86_ (GotoLine* self) {
	gtk_widget_hide ((GtkWidget*) self);
}


static void ___lambda86__gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	__lambda86_ ((GotoLine*) self);
}


static void __lambda87_ (GotoLine* self) {
	gtk_widget_hide ((GtkWidget*) self);
}


static void ___lambda87__gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self) {
	__lambda87_ ((GotoLine*) self);
}


static void _goto_line_on_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	goto_line_on_changed ((GotoLine*) self);
}


GotoLine* goto_line_construct (GType object_type, MainWindow* main_window) {
	GotoLine * self = NULL;
	MainWindow* _tmp0_ = NULL;
	GtkButton* close_button = NULL;
	GtkButton* _tmp1_ = NULL;
	GtkImage* img = NULL;
	GtkImage* _tmp2_ = NULL;
	GtkLabel* label = NULL;
	const gchar* _tmp3_ = NULL;
	GtkLabel* _tmp4_ = NULL;
	GtkEntry* _tmp5_ = NULL;
	GtkEntry* _tmp6_ = NULL;
	GIcon* icon = NULL;
	GThemedIcon* _tmp7_ = NULL;
	GtkEntry* _tmp8_ = NULL;
	GtkEntry* _tmp9_ = NULL;
	GtkEntry* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GtkEntry* _tmp12_ = NULL;
	GtkEntry* _tmp13_ = NULL;
	GtkEntry* _tmp14_ = NULL;
	GtkEntry* _tmp15_ = NULL;
	g_return_val_if_fail (main_window != NULL, NULL);
	self = (GotoLine*) g_object_new (object_type, NULL);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_HORIZONTAL);
	gtk_grid_set_column_spacing ((GtkGrid*) self, (guint) 3);
	_tmp0_ = main_window;
	self->priv->main_window = _tmp0_;
	_tmp1_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp1_);
	close_button = _tmp1_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) close_button);
	gtk_button_set_relief (close_button, GTK_RELIEF_NONE);
	_tmp2_ = (GtkImage*) gtk_image_new_from_icon_name ("window-close", GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp2_);
	img = _tmp2_;
	gtk_container_add ((GtkContainer*) close_button, (GtkWidget*) img);
	g_signal_connect_object (close_button, "clicked", (GCallback) ___lambda85__gtk_button_clicked, self, 0);
	_tmp3_ = _ ("Go to Line:");
	_tmp4_ = (GtkLabel*) gtk_label_new (_tmp3_);
	g_object_ref_sink (_tmp4_);
	label = _tmp4_;
	gtk_widget_set_margin_start ((GtkWidget*) label, 2);
	gtk_widget_set_margin_end ((GtkWidget*) label, 2);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) label);
	_tmp5_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->entry);
	self->priv->entry = _tmp5_;
	_tmp6_ = self->priv->entry;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp6_);
	_tmp7_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks ("go-jump-symbolic");
	icon = (GIcon*) _tmp7_;
	_tmp8_ = self->priv->entry;
	gtk_entry_set_icon_from_gicon (_tmp8_, GTK_ENTRY_ICON_SECONDARY, icon);
	_tmp9_ = self->priv->entry;
	gtk_entry_set_icon_activatable (_tmp9_, GTK_ENTRY_ICON_SECONDARY, TRUE);
	_tmp10_ = self->priv->entry;
	_tmp11_ = _ ("Line you want to move the cursor to");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp10_, _tmp11_);
	_tmp12_ = self->priv->entry;
	gtk_widget_set_size_request ((GtkWidget*) _tmp12_, 100, -1);
	_tmp13_ = self->priv->entry;
	g_signal_connect_object (_tmp13_, "activate", (GCallback) ___lambda86__gtk_entry_activate, self, 0);
	_tmp14_ = self->priv->entry;
	g_signal_connect_object (_tmp14_, "icon-press", (GCallback) ___lambda87__gtk_entry_icon_press, self, 0);
	_tmp15_ = self->priv->entry;
	g_signal_connect_object ((GtkEditable*) _tmp15_, "changed", (GCallback) _goto_line_on_changed_gtk_editable_changed, self, 0);
	_g_object_unref0 (icon);
	_g_object_unref0 (label);
	_g_object_unref0 (img);
	_g_object_unref0 (close_button);
	return self;
}


GotoLine* goto_line_new (MainWindow* main_window) {
	return goto_line_construct (TYPE_GOTO_LINE, main_window);
}


void goto_line_show (GotoLine* self) {
	GtkEntry* _tmp0_ = NULL;
	GtkEntry* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->entry;
	gtk_entry_set_text (_tmp0_, "");
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp1_ = self->priv->entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void goto_line_on_changed (GotoLine* self) {
	GtkEntry* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	gchar* text = NULL;
	GtkEntry* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gint line = 0;
	const gchar* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	MainWindow* _tmp21_ = NULL;
	Document* _tmp22_ = NULL;
	Document* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gboolean _tmp25_ = FALSE;
	MainWindow* _tmp28_ = NULL;
	DocumentView* _tmp29_ = NULL;
	DocumentView* _tmp30_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->entry;
	_tmp1_ = gtk_entry_get_text_length (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == ((guint) 0)) {
		GtkEntry* _tmp3_ = NULL;
		_tmp3_ = self->priv->entry;
		error_entry_remove_error ((GtkWidget*) _tmp3_);
		return;
	}
	_tmp4_ = self->priv->entry;
	_tmp5_ = gtk_entry_get_text (_tmp4_);
	_tmp6_ = g_strdup (_tmp5_);
	text = _tmp6_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint _tmp9_ = 0;
				const gchar* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gunichar c = 0U;
				const gchar* _tmp13_ = NULL;
				gint _tmp14_ = 0;
				gchar _tmp15_ = '\0';
				gunichar _tmp16_ = 0U;
				gboolean _tmp17_ = FALSE;
				if (!_tmp7_) {
					gint _tmp8_ = 0;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = i;
				_tmp10_ = text;
				_tmp11_ = strlen (_tmp10_);
				_tmp12_ = _tmp11_;
				if (!(_tmp9_ < _tmp12_)) {
					break;
				}
				_tmp13_ = text;
				_tmp14_ = i;
				_tmp15_ = string_get (_tmp13_, (glong) _tmp14_);
				c = (gunichar) _tmp15_;
				_tmp16_ = c;
				_tmp17_ = g_unichar_isdigit (_tmp16_);
				if (!_tmp17_) {
					GtkEntry* _tmp18_ = NULL;
					_tmp18_ = self->priv->entry;
					error_entry_add_error ((GtkWidget*) _tmp18_);
					_g_free0 (text);
					return;
				}
			}
		}
	}
	_tmp19_ = text;
	_tmp20_ = atoi (_tmp19_);
	line = _tmp20_ - 1;
	_tmp21_ = self->priv->main_window;
	_tmp22_ = main_window_get_active_document (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = line;
	_tmp25_ = document_goto_line (_tmp23_, _tmp24_);
	if (_tmp25_) {
		GtkEntry* _tmp26_ = NULL;
		_tmp26_ = self->priv->entry;
		error_entry_remove_error ((GtkWidget*) _tmp26_);
	} else {
		GtkEntry* _tmp27_ = NULL;
		_tmp27_ = self->priv->entry;
		error_entry_add_error ((GtkWidget*) _tmp27_);
	}
	_tmp28_ = self->priv->main_window;
	_tmp29_ = main_window_get_active_view (_tmp28_);
	_tmp30_ = _tmp29_;
	document_view_scroll_to_cursor (_tmp30_, 0.25);
	_g_free0 (text);
}


static void goto_line_class_init (GotoLineClass * klass) {
	goto_line_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GotoLinePrivate));
	G_OBJECT_CLASS (klass)->finalize = goto_line_finalize;
}


static void goto_line_instance_init (GotoLine * self) {
	self->priv = GOTO_LINE_GET_PRIVATE (self);
}


static void goto_line_finalize (GObject* obj) {
	GotoLine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GOTO_LINE, GotoLine);
	_g_object_unref0 (self->priv->entry);
	G_OBJECT_CLASS (goto_line_parent_class)->finalize (obj);
}


GType goto_line_get_type (void) {
	static volatile gsize goto_line_type_id__volatile = 0;
	if (g_once_init_enter (&goto_line_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GotoLineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) goto_line_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GotoLine), 0, (GInstanceInitFunc) goto_line_instance_init, NULL };
		GType goto_line_type_id;
		goto_line_type_id = g_type_register_static (gtk_grid_get_type (), "GotoLine", &g_define_type_info, 0);
		g_once_init_leave (&goto_line_type_id__volatile, goto_line_type_id);
	}
	return goto_line_type_id__volatile;
}


static GType search_and_replace_mode_get_type (void) {
	static volatile gsize search_and_replace_mode_type_id__volatile = 0;
	if (g_once_init_enter (&search_and_replace_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{SEARCH_AND_REPLACE_MODE_SEARCH, "SEARCH_AND_REPLACE_MODE_SEARCH", "search"}, {SEARCH_AND_REPLACE_MODE_SEARCH_AND_REPLACE, "SEARCH_AND_REPLACE_MODE_SEARCH_AND_REPLACE", "search-and-replace"}, {0, NULL, NULL}};
		GType search_and_replace_mode_type_id;
		search_and_replace_mode_type_id = g_enum_register_static ("SearchAndReplaceMode", values);
		g_once_init_leave (&search_and_replace_mode_type_id__volatile, search_and_replace_mode_type_id);
	}
	return search_and_replace_mode_type_id__volatile;
}


static SearchAndReplaceMode search_and_replace_get_mode (SearchAndReplace* self) {
	SearchAndReplaceMode result = 0;
	SearchAndReplaceMode _tmp0_ = 0;
	GtkArrow* _tmp1_ = NULL;
	GtkArrowType _tmp2_ = 0;
	GtkArrowType _tmp3_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->_arrow;
	g_object_get (_tmp1_, "arrow-type", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == GTK_ARROW_UP) {
		_tmp0_ = SEARCH_AND_REPLACE_MODE_SEARCH_AND_REPLACE;
	} else {
		_tmp0_ = SEARCH_AND_REPLACE_MODE_SEARCH;
	}
	result = _tmp0_;
	return result;
}


static Block28Data* block28_data_ref (Block28Data* _data28_) {
	g_atomic_int_inc (&_data28_->_ref_count_);
	return _data28_;
}


static void block28_data_unref (void * _userdata_) {
	Block28Data* _data28_;
	_data28_ = (Block28Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data28_->_ref_count_)) {
		SearchAndReplace* self;
		self = _data28_->self;
		_g_object_unref0 (_data28_->button_replace_all);
		_g_object_unref0 (_data28_->button_replace);
		_g_object_unref0 (_data28_->button_next);
		_g_object_unref0 (_data28_->button_previous);
		_g_object_unref0 (self);
		g_slice_free (Block28Data, _data28_);
	}
}


static void __lambda89_ (SearchAndReplace* self) {
	SearchAndReplaceMode _tmp0_ = 0;
	_tmp0_ = search_and_replace_get_mode (self);
	if (_tmp0_ == SEARCH_AND_REPLACE_MODE_SEARCH_AND_REPLACE) {
		GtkArrow* _tmp1_ = NULL;
		GtkGrid* _tmp2_ = NULL;
		_tmp1_ = self->priv->_arrow;
		g_object_set (_tmp1_, "arrow-type", GTK_ARROW_DOWN, NULL);
		_tmp2_ = self->priv->_replace_grid;
		gtk_widget_hide ((GtkWidget*) _tmp2_);
	} else {
		GtkArrow* _tmp3_ = NULL;
		GtkGrid* _tmp4_ = NULL;
		_tmp3_ = self->priv->_arrow;
		g_object_set (_tmp3_, "arrow-type", GTK_ARROW_UP, NULL);
		_tmp4_ = self->priv->_replace_grid;
		gtk_widget_show ((GtkWidget*) _tmp4_);
	}
}


static void ___lambda89__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda89_ ((SearchAndReplace*) self);
}


static void _search_and_replace_hide_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	search_and_replace_hide ((SearchAndReplace*) self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda91_ (SearchAndReplace* self) {
	GtkSourceSearchContext* _tmp0_ = NULL;
	GtkTextIter iter = {0};
	GtkTextIter match_start = {0};
	GtkTextIter match_end = {0};
	Document* doc = NULL;
	GtkSourceSearchContext* _tmp1_ = NULL;
	GtkSourceBuffer* _tmp2_ = NULL;
	Document* _tmp3_ = NULL;
	Document* _tmp4_ = NULL;
	GtkTextIter _tmp5_ = {0};
	GtkSourceSearchContext* _tmp6_ = NULL;
	GtkTextIter _tmp7_ = {0};
	GtkTextIter _tmp8_ = {0};
	GtkTextIter _tmp9_ = {0};
	gboolean _tmp10_ = FALSE;
	_tmp0_ = self->priv->_search_context;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->_search_context;
	_tmp2_ = gtk_source_search_context_get_buffer (_tmp1_);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, TYPE_DOCUMENT) ? ((Document*) _tmp2_) : NULL);
	doc = _tmp3_;
	_tmp4_ = doc;
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) _tmp4_, &_tmp5_, NULL);
	iter = _tmp5_;
	_tmp6_ = self->priv->_search_context;
	_tmp7_ = iter;
	_tmp10_ = gtk_source_search_context_backward (_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_);
	match_start = _tmp8_;
	match_end = _tmp9_;
	if (_tmp10_) {
		Document* _tmp11_ = NULL;
		GtkTextIter _tmp12_ = {0};
		GtkTextIter _tmp13_ = {0};
		Document* _tmp14_ = NULL;
		DocumentTab* _tmp15_ = NULL;
		DocumentView* _tmp16_ = NULL;
		DocumentView* _tmp17_ = NULL;
		_tmp11_ = doc;
		_tmp12_ = match_start;
		_tmp13_ = match_end;
		gtk_text_buffer_select_range ((GtkTextBuffer*) _tmp11_, &_tmp12_, &_tmp13_);
		_tmp14_ = doc;
		_tmp15_ = _tmp14_->tab;
		_tmp16_ = document_tab_get_view (_tmp15_);
		_tmp17_ = _tmp16_;
		document_view_scroll_to_cursor (_tmp17_, 0.25);
	}
	_g_object_unref0 (doc);
}


static void ___lambda91__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda91_ ((SearchAndReplace*) self);
}


static void _search_and_replace_search_forward_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	search_and_replace_search_forward ((SearchAndReplace*) self);
}


static void _search_and_replace_search_forward_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	search_and_replace_search_forward ((SearchAndReplace*) self);
}


static void __lambda92_ (Block28Data* _data28_) {
	SearchAndReplace* self;
	gboolean sensitive = FALSE;
	GtkSearchEntry* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	self = _data28_->self;
	_tmp0_ = self->priv->_entry_find;
	_tmp1_ = gtk_entry_get_text_length ((GtkEntry*) _tmp0_);
	_tmp2_ = _tmp1_;
	sensitive = _tmp2_ > ((guint) 0);
	gtk_widget_set_sensitive ((GtkWidget*) _data28_->button_previous, sensitive);
	gtk_widget_set_sensitive ((GtkWidget*) _data28_->button_next, sensitive);
	gtk_widget_set_sensitive ((GtkWidget*) _data28_->button_replace, sensitive);
	gtk_widget_set_sensitive ((GtkWidget*) _data28_->button_replace_all, sensitive);
}


static void ___lambda92__gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	__lambda92_ (self);
}


static void _search_and_replace_replace_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	search_and_replace_replace ((SearchAndReplace*) self);
}


static void _search_and_replace_replace_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	search_and_replace_replace ((SearchAndReplace*) self);
}


static void __lambda93_ (SearchAndReplace* self) {
	GtkSourceSearchContext* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = self->priv->_search_context;
	if (_tmp0_ != NULL) {
		MainWindow* _tmp1_ = NULL;
		DocumentView* _tmp2_ = NULL;
		DocumentView* _tmp3_ = NULL;
		GtkSourceCompletion* _tmp4_ = NULL;
		GtkSourceCompletion* _tmp5_ = NULL;
		MainWindow* _tmp10_ = NULL;
		DocumentView* _tmp11_ = NULL;
		DocumentView* _tmp12_ = NULL;
		GtkSourceCompletion* _tmp13_ = NULL;
		GtkSourceCompletion* _tmp14_ = NULL;
		_tmp1_ = self->priv->_main_window;
		_tmp2_ = main_window_get_active_view (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = gtk_source_view_get_completion ((GtkSourceView*) _tmp3_);
		_tmp5_ = _tmp4_;
		gtk_source_completion_block_interactive (_tmp5_);
		{
			GtkSourceSearchContext* _tmp6_ = NULL;
			GtkSearchEntry* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			_tmp6_ = self->priv->_search_context;
			_tmp7_ = self->priv->_entry_replace;
			_tmp8_ = gtk_entry_get_text ((GtkEntry*) _tmp7_);
			_tmp9_ = _tmp8_;
			gtk_source_search_context_replace_all (_tmp6_, _tmp9_, -1, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch39_g_error;
			}
		}
		goto __finally39;
		__catch39_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally39:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp10_ = self->priv->_main_window;
		_tmp11_ = main_window_get_active_view (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = gtk_source_view_get_completion ((GtkSourceView*) _tmp12_);
		_tmp14_ = _tmp13_;
		gtk_source_completion_unblock_interactive (_tmp14_);
	}
}


static void ___lambda93__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda93_ ((SearchAndReplace*) self);
}


static gboolean __lambda94_ (SearchAndReplace* self, GdkEventKey* event) {
	gboolean result = FALSE;
	GdkEventKey* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->keyval;
	switch (_tmp1_) {
		case GDK_KEY_Tab:
		{
			GtkSearchEntry* _tmp2_ = NULL;
			search_and_replace_show_search_and_replace (self);
			_tmp2_ = self->priv->_entry_replace;
			gtk_widget_grab_focus ((GtkWidget*) _tmp2_);
			result = TRUE;
			return result;
		}
		case GDK_KEY_Escape:
		{
			search_and_replace_hide (self);
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


static gboolean ___lambda94__gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = __lambda94_ ((SearchAndReplace*) self, event);
	return result;
}


SearchAndReplace* search_and_replace_construct (GType object_type, MainWindow* main_window) {
	SearchAndReplace * self = NULL;
	Block28Data* _data28_;
	MainWindow* _tmp0_ = NULL;
	GtkSourceSearchSettings* _tmp1_ = NULL;
	GtkSourceSearchSettings* _tmp2_ = NULL;
	GtkGrid* _tmp3_ = NULL;
	GtkGrid* _tmp4_ = NULL;
	GtkGrid* _tmp5_ = NULL;
	GtkButton* button_arrow = NULL;
	GtkButton* _tmp6_ = NULL;
	GtkArrow* _tmp7_ = NULL;
	GtkArrow* _tmp8_ = NULL;
	GtkGrid* _tmp9_ = NULL;
	GtkGrid* find_grid = NULL;
	GtkGrid* _tmp10_ = NULL;
	GtkGrid* _tmp11_ = NULL;
	GtkSearchEntry* _tmp12_ = NULL;
	GtkButton* _tmp13_ = NULL;
	GtkButton* _tmp14_ = NULL;
	GtkButton* button_close = NULL;
	GtkButton* _tmp15_ = NULL;
	GtkLabel* _tmp16_ = NULL;
	GtkLabel* _tmp17_ = NULL;
	GtkLabel* _tmp18_ = NULL;
	GtkGrid* _tmp19_ = NULL;
	GtkGrid* _tmp20_ = NULL;
	GtkGrid* _tmp21_ = NULL;
	GtkGrid* _tmp22_ = NULL;
	GtkGrid* _tmp23_ = NULL;
	GtkSearchEntry* _tmp24_ = NULL;
	GtkSearchEntry* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	GtkSearchEntry* _tmp27_ = NULL;
	GtkSearchEntry* _tmp28_ = NULL;
	GtkSearchEntry* _tmp29_ = NULL;
	GtkGrid* _tmp30_ = NULL;
	GtkSearchEntry* _tmp31_ = NULL;
	GtkButton* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	GtkButton* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	GtkGrid* replace_all_grid = NULL;
	GtkGrid* _tmp36_ = NULL;
	GtkImage* image = NULL;
	GtkImage* _tmp37_ = NULL;
	GtkLabel* label = NULL;
	const gchar* _tmp38_ = NULL;
	GtkLabel* _tmp39_ = NULL;
	GtkGrid* _tmp40_ = NULL;
	GtkGrid* _tmp41_ = NULL;
	GtkSearchEntry* _tmp42_ = NULL;
	GtkSearchEntry* _tmp43_ = NULL;
	GtkSearchEntry* _tmp44_ = NULL;
	GtkSearchEntry* _tmp45_ = NULL;
	GtkGrid* _tmp46_ = NULL;
	g_return_val_if_fail (main_window != NULL, NULL);
	_data28_ = g_slice_new0 (Block28Data);
	_data28_->_ref_count_ = 1;
	self = (SearchAndReplace*) g_object_new (object_type, NULL);
	_data28_->self = g_object_ref (self);
	_tmp0_ = main_window;
	self->priv->_main_window = _tmp0_;
	_tmp1_ = gtk_source_search_settings_new ();
	_g_object_unref0 (self->priv->_search_settings);
	self->priv->_search_settings = _tmp1_;
	_tmp2_ = self->priv->_search_settings;
	gtk_source_search_settings_set_wrap_around (_tmp2_, TRUE);
	_tmp3_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->_main_grid);
	self->priv->_main_grid = _tmp3_;
	_tmp4_ = self->priv->_main_grid;
	gtk_grid_set_column_spacing (_tmp4_, (guint) 3);
	_tmp5_ = self->priv->_main_grid;
	gtk_grid_set_row_spacing (_tmp5_, (guint) 3);
	_tmp6_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp6_);
	button_arrow = _tmp6_;
	_tmp7_ = (GtkArrow*) gtk_arrow_new (GTK_ARROW_DOWN, GTK_SHADOW_OUT);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->_arrow);
	self->priv->_arrow = _tmp7_;
	_tmp8_ = self->priv->_arrow;
	gtk_container_add ((GtkContainer*) button_arrow, (GtkWidget*) _tmp8_);
	_tmp9_ = self->priv->_main_grid;
	gtk_grid_attach (_tmp9_, (GtkWidget*) button_arrow, 0, 0, 1, 1);
	_tmp10_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp10_);
	find_grid = _tmp10_;
	gtk_orientable_set_orientation ((GtkOrientable*) find_grid, GTK_ORIENTATION_HORIZONTAL);
	gtk_grid_set_column_spacing (find_grid, (guint) 2);
	_tmp11_ = self->priv->_main_grid;
	gtk_grid_attach (_tmp11_, (GtkWidget*) find_grid, 1, 0, 1, 1);
	search_and_replace_init_find_entry (self);
	_tmp12_ = self->priv->_entry_find;
	gtk_container_add ((GtkContainer*) find_grid, (GtkWidget*) _tmp12_);
	_tmp13_ = search_and_replace_get_button (self, "go-up");
	_data28_->button_previous = _tmp13_;
	_tmp14_ = search_and_replace_get_button (self, "go-down");
	_data28_->button_next = _tmp14_;
	_tmp15_ = search_and_replace_get_button (self, "window-close");
	button_close = _tmp15_;
	gtk_container_add ((GtkContainer*) find_grid, (GtkWidget*) _data28_->button_previous);
	gtk_container_add ((GtkContainer*) find_grid, (GtkWidget*) _data28_->button_next);
	gtk_container_add ((GtkContainer*) find_grid, (GtkWidget*) button_close);
	gtk_widget_set_sensitive ((GtkWidget*) _data28_->button_previous, FALSE);
	gtk_widget_set_sensitive ((GtkWidget*) _data28_->button_next, FALSE);
	_tmp16_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->_info_label);
	self->priv->_info_label = _tmp16_;
	_tmp17_ = self->priv->_info_label;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp17_, 12);
	_tmp18_ = self->priv->_info_label;
	gtk_container_add ((GtkContainer*) find_grid, (GtkWidget*) _tmp18_);
	_tmp19_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->_replace_grid);
	self->priv->_replace_grid = _tmp19_;
	_tmp20_ = self->priv->_replace_grid;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp20_, GTK_ORIENTATION_HORIZONTAL);
	_tmp21_ = self->priv->_replace_grid;
	gtk_grid_set_column_spacing (_tmp21_, (guint) 2);
	_tmp22_ = self->priv->_main_grid;
	_tmp23_ = self->priv->_replace_grid;
	gtk_grid_attach (_tmp22_, (GtkWidget*) _tmp23_, 1, 1, 1, 1);
	_tmp24_ = (GtkSearchEntry*) gtk_search_entry_new ();
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->_entry_replace);
	self->priv->_entry_replace = _tmp24_;
	_tmp25_ = self->priv->_entry_replace;
	_tmp26_ = _ ("Replace with");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp25_, _tmp26_);
	_tmp27_ = self->priv->_entry_replace;
	g_object_set ((GtkWidget*) _tmp27_, "can-focus", TRUE, NULL);
	_tmp28_ = self->priv->_entry_replace;
	gtk_entry_set_width_chars ((GtkEntry*) _tmp28_, 25);
	_tmp29_ = self->priv->_entry_replace;
	g_object_set ((GtkEntry*) _tmp29_, "primary-icon-gicon", NULL, NULL);
	_tmp30_ = self->priv->_replace_grid;
	_tmp31_ = self->priv->_entry_replace;
	gtk_container_add ((GtkContainer*) _tmp30_, (GtkWidget*) _tmp31_);
	_tmp32_ = search_and_replace_get_button (self, "edit-find-replace");
	_data28_->button_replace = _tmp32_;
	_tmp33_ = _ ("Replace");
	gtk_widget_set_tooltip_text ((GtkWidget*) _data28_->button_replace, _tmp33_);
	_tmp34_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp34_);
	_data28_->button_replace_all = _tmp34_;
	_tmp35_ = _ ("Replace All");
	gtk_widget_set_tooltip_text ((GtkWidget*) _data28_->button_replace_all, _tmp35_);
	gtk_button_set_relief (_data28_->button_replace_all, GTK_RELIEF_NONE);
	_tmp36_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp36_);
	replace_all_grid = _tmp36_;
	gtk_orientable_set_orientation ((GtkOrientable*) replace_all_grid, GTK_ORIENTATION_HORIZONTAL);
	gtk_grid_set_column_spacing (replace_all_grid, (guint) 8);
	_tmp37_ = (GtkImage*) gtk_image_new_from_icon_name ("edit-find-replace", GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp37_);
	image = _tmp37_;
	gtk_container_add ((GtkContainer*) replace_all_grid, (GtkWidget*) image);
	_tmp38_ = _ ("All");
	_tmp39_ = (GtkLabel*) gtk_label_new (_tmp38_);
	g_object_ref_sink (_tmp39_);
	label = _tmp39_;
	gtk_container_add ((GtkContainer*) replace_all_grid, (GtkWidget*) label);
	gtk_container_add ((GtkContainer*) _data28_->button_replace_all, (GtkWidget*) replace_all_grid);
	_tmp40_ = self->priv->_replace_grid;
	gtk_container_add ((GtkContainer*) _tmp40_, (GtkWidget*) _data28_->button_replace);
	_tmp41_ = self->priv->_replace_grid;
	gtk_container_add ((GtkContainer*) _tmp41_, (GtkWidget*) _data28_->button_replace_all);
	gtk_widget_set_sensitive ((GtkWidget*) _data28_->button_replace, FALSE);
	gtk_widget_set_sensitive ((GtkWidget*) _data28_->button_replace_all, FALSE);
	g_signal_connect_object (button_arrow, "clicked", (GCallback) ___lambda89__gtk_button_clicked, self, 0);
	g_signal_connect_object (button_close, "clicked", (GCallback) _search_and_replace_hide_gtk_button_clicked, self, 0);
	g_signal_connect_object (_data28_->button_previous, "clicked", (GCallback) ___lambda91__gtk_button_clicked, self, 0);
	g_signal_connect_object (_data28_->button_next, "clicked", (GCallback) _search_and_replace_search_forward_gtk_button_clicked, self, 0);
	_tmp42_ = self->priv->_entry_find;
	g_signal_connect_object ((GtkEntry*) _tmp42_, "activate", (GCallback) _search_and_replace_search_forward_gtk_entry_activate, self, 0);
	_tmp43_ = self->priv->_entry_find;
	g_signal_connect_data ((GtkEditable*) _tmp43_, "changed", (GCallback) ___lambda92__gtk_editable_changed, block28_data_ref (_data28_), (GClosureNotify) block28_data_unref, 0);
	g_signal_connect_object (_data28_->button_replace, "clicked", (GCallback) _search_and_replace_replace_gtk_button_clicked, self, 0);
	_tmp44_ = self->priv->_entry_replace;
	g_signal_connect_object ((GtkEntry*) _tmp44_, "activate", (GCallback) _search_and_replace_replace_gtk_entry_activate, self, 0);
	g_signal_connect_object (_data28_->button_replace_all, "clicked", (GCallback) ___lambda93__gtk_button_clicked, self, 0);
	_tmp45_ = self->priv->_entry_find;
	g_signal_connect_object ((GtkWidget*) _tmp45_, "key-press-event", (GCallback) ___lambda94__gtk_widget_key_press_event, self, 0);
	_tmp46_ = self->priv->_main_grid;
	gtk_widget_hide ((GtkWidget*) _tmp46_);
	_g_object_unref0 (label);
	_g_object_unref0 (image);
	_g_object_unref0 (replace_all_grid);
	_g_object_unref0 (button_close);
	_g_object_unref0 (find_grid);
	_g_object_unref0 (button_arrow);
	block28_data_unref (_data28_);
	_data28_ = NULL;
	return self;
}


SearchAndReplace* search_and_replace_new (MainWindow* main_window) {
	return search_and_replace_construct (TYPE_SEARCH_AND_REPLACE, main_window);
}


static Block29Data* block29_data_ref (Block29Data* _data29_) {
	g_atomic_int_inc (&_data29_->_ref_count_);
	return _data29_;
}


static void block29_data_unref (void * _userdata_) {
	Block29Data* _data29_;
	_data29_ = (Block29Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data29_->_ref_count_)) {
		SearchAndReplace* self;
		self = _data29_->self;
		_g_object_unref0 (_data29_->menu);
		_g_object_unref0 (self);
		g_slice_free (Block29Data, _data29_);
	}
}


static void __lambda88_ (Block29Data* _data29_, GtkEntryIconPosition icon_pos, GdkEvent* event) {
	SearchAndReplace* self;
	GtkEntryIconPosition _tmp0_ = 0;
	self = _data29_->self;
	g_return_if_fail (event != NULL);
	_tmp0_ = icon_pos;
	if (_tmp0_ == GTK_ENTRY_ICON_PRIMARY) {
		GdkEvent* _tmp1_ = NULL;
		GdkEventButton* _tmp2_ = NULL;
		GdkEventButton* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
		GdkEvent* _tmp5_ = NULL;
		GdkEventButton* _tmp6_ = NULL;
		GdkEventButton* _tmp7_ = NULL;
		guint32 _tmp8_ = 0U;
		_tmp1_ = event;
		_tmp2_ = (GdkEventButton *) (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_->button;
		_tmp5_ = event;
		_tmp6_ = (GdkEventButton *) (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_->time;
		gtk_menu_popup (_data29_->menu, NULL, NULL, NULL, NULL, _tmp4_, _tmp8_);
	}
}


static void ___lambda88__gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self) {
	__lambda88_ (self, p0, p1);
}


static void search_and_replace_init_find_entry (SearchAndReplace* self) {
	Block29Data* _data29_;
	GtkSearchEntry* _tmp0_ = NULL;
	GtkSearchEntry* _tmp1_ = NULL;
	GThemedIcon* _tmp2_ = NULL;
	GThemedIcon* _tmp3_ = NULL;
	GtkSearchEntry* _tmp4_ = NULL;
	GtkSearchEntry* _tmp5_ = NULL;
	GtkSearchEntry* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkSearchEntry* _tmp8_ = NULL;
	GtkSearchEntry* _tmp9_ = NULL;
	GtkSearchEntry* _tmp10_ = NULL;
	GtkSourceSearchSettings* _tmp11_ = NULL;
	GtkMenu* _tmp12_ = NULL;
	GtkCheckMenuItem* check_case_sensitive = NULL;
	const gchar* _tmp13_ = NULL;
	GtkCheckMenuItem* _tmp14_ = NULL;
	GtkCheckMenuItem* check_entire_word = NULL;
	const gchar* _tmp15_ = NULL;
	GtkCheckMenuItem* _tmp16_ = NULL;
	GtkSourceSearchSettings* _tmp17_ = NULL;
	GtkSourceSearchSettings* _tmp18_ = NULL;
	GtkSearchEntry* _tmp19_ = NULL;
	g_return_if_fail (self != NULL);
	_data29_ = g_slice_new0 (Block29Data);
	_data29_->_ref_count_ = 1;
	_data29_->self = g_object_ref (self);
	_tmp0_ = (GtkSearchEntry*) gtk_search_entry_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->_entry_find);
	self->priv->_entry_find = _tmp0_;
	_tmp1_ = self->priv->_entry_find;
	_tmp2_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks ("document-properties-symbolic");
	_tmp3_ = _tmp2_;
	g_object_set ((GtkEntry*) _tmp1_, "primary-icon-gicon", (GIcon*) _tmp3_, NULL);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->_entry_find;
	g_object_set ((GtkEntry*) _tmp4_, "primary-icon-activatable", TRUE, NULL);
	_tmp5_ = self->priv->_entry_find;
	g_object_set ((GtkEntry*) _tmp5_, "primary-icon-sensitive", TRUE, NULL);
	_tmp6_ = self->priv->_entry_find;
	_tmp7_ = _ ("Search for");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp6_, _tmp7_);
	_tmp8_ = self->priv->_entry_find;
	g_object_set ((GtkWidget*) _tmp8_, "can-focus", TRUE, NULL);
	_tmp9_ = self->priv->_entry_find;
	gtk_entry_set_width_chars ((GtkEntry*) _tmp9_, 25);
	_tmp10_ = self->priv->_entry_find;
	_tmp11_ = self->priv->_search_settings;
	g_object_bind_property_with_closures ((GObject*) _tmp10_, "text", (GObject*) _tmp11_, "search-text", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp12_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp12_);
	_data29_->menu = _tmp12_;
	_tmp13_ = _ ("Case sensitive");
	_tmp14_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_tmp13_);
	g_object_ref_sink (_tmp14_);
	check_case_sensitive = _tmp14_;
	_tmp15_ = _ ("Entire words only");
	_tmp16_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_tmp15_);
	g_object_ref_sink (_tmp16_);
	check_entire_word = _tmp16_;
	gtk_menu_shell_append ((GtkMenuShell*) _data29_->menu, (GtkWidget*) ((GtkMenuItem*) check_case_sensitive));
	gtk_menu_shell_append ((GtkMenuShell*) _data29_->menu, (GtkWidget*) ((GtkMenuItem*) check_entire_word));
	gtk_widget_show_all ((GtkWidget*) _data29_->menu);
	_tmp17_ = self->priv->_search_settings;
	g_object_bind_property_with_closures ((GObject*) check_case_sensitive, "active", (GObject*) _tmp17_, "case-sensitive", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp18_ = self->priv->_search_settings;
	g_object_bind_property_with_closures ((GObject*) check_entire_word, "active", (GObject*) _tmp18_, "at-word-boundaries", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp19_ = self->priv->_entry_find;
	g_signal_connect_data ((GtkEntry*) _tmp19_, "icon-press", (GCallback) ___lambda88__gtk_entry_icon_press, block29_data_ref (_data29_), (GClosureNotify) block29_data_unref, 0);
	_g_object_unref0 (check_entire_word);
	_g_object_unref0 (check_case_sensitive);
	block29_data_unref (_data29_);
	_data29_ = NULL;
}


static GtkButton* search_and_replace_get_button (SearchAndReplace* self, const gchar* icon_name) {
	GtkButton* result = NULL;
	GtkButton* button = NULL;
	GtkButton* _tmp0_ = NULL;
	GtkImage* image = NULL;
	const gchar* _tmp1_ = NULL;
	GtkImage* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	_tmp0_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp0_);
	button = _tmp0_;
	_tmp1_ = icon_name;
	_tmp2_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp1_, GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp2_);
	image = _tmp2_;
	gtk_container_add ((GtkContainer*) button, (GtkWidget*) image);
	gtk_button_set_relief (button, GTK_RELIEF_NONE);
	result = button;
	_g_object_unref0 (image);
	return result;
}


GtkWidget* search_and_replace_get_widget (SearchAndReplace* self) {
	GtkWidget* result = NULL;
	GtkGrid* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_main_grid;
	_tmp1_ = _g_object_ref0 ((GtkWidget*) _tmp0_);
	result = _tmp1_;
	return result;
}


void search_and_replace_show_search (SearchAndReplace* self) {
	GtkArrow* _tmp0_ = NULL;
	GtkGrid* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_arrow;
	g_object_set (_tmp0_, "arrow-type", GTK_ARROW_DOWN, NULL);
	search_and_replace_show (self);
	_tmp1_ = self->priv->_replace_grid;
	gtk_widget_hide ((GtkWidget*) _tmp1_);
}


void search_and_replace_show_search_and_replace (SearchAndReplace* self) {
	GtkArrow* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_arrow;
	g_object_set (_tmp0_, "arrow-type", GTK_ARROW_UP, NULL);
	search_and_replace_show (self);
}


static void _search_and_replace_connect_active_document_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	search_and_replace_connect_active_document ((SearchAndReplace*) self);
}


static void search_and_replace_show (SearchAndReplace* self) {
	MainWindow* _tmp0_ = NULL;
	DocumentTab* _tmp1_ = NULL;
	DocumentTab* _tmp2_ = NULL;
	GtkGrid* _tmp3_ = NULL;
	GtkSearchEntry* _tmp4_ = NULL;
	Document* doc = NULL;
	MainWindow* _tmp5_ = NULL;
	Document* _tmp6_ = NULL;
	Document* _tmp7_ = NULL;
	Document* _tmp8_ = NULL;
	Document* _tmp9_ = NULL;
	SelectionType _tmp10_ = 0;
	MainWindow* _tmp20_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->_main_grid;
	gtk_widget_show_all ((GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->_entry_find;
	gtk_widget_grab_focus ((GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->_main_window;
	_tmp6_ = main_window_get_active_document (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	doc = _tmp8_;
	_tmp9_ = doc;
	_tmp10_ = document_get_selection_type (_tmp9_);
	if (_tmp10_ == SELECTION_TYPE_ONE_LINE) {
		GtkTextIter start = {0};
		GtkTextIter end = {0};
		Document* _tmp11_ = NULL;
		GtkTextIter _tmp12_ = {0};
		GtkTextIter _tmp13_ = {0};
		GtkSearchEntry* _tmp14_ = NULL;
		Document* _tmp15_ = NULL;
		GtkTextIter _tmp16_ = {0};
		GtkTextIter _tmp17_ = {0};
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		_tmp11_ = doc;
		gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) _tmp11_, &_tmp12_, &_tmp13_);
		start = _tmp12_;
		end = _tmp13_;
		_tmp14_ = self->priv->_entry_find;
		_tmp15_ = doc;
		_tmp16_ = start;
		_tmp17_ = end;
		_tmp18_ = gtk_text_buffer_get_text ((GtkTextBuffer*) _tmp15_, &_tmp16_, &_tmp17_, FALSE);
		_tmp19_ = _tmp18_;
		gtk_entry_set_text ((GtkEntry*) _tmp14_, _tmp19_);
		_g_free0 (_tmp19_);
	}
	_tmp20_ = self->priv->_main_window;
	g_signal_connect_object ((GObject*) _tmp20_, "notify::active-document", (GCallback) _search_and_replace_connect_active_document_g_object_notify, self, 0);
	search_and_replace_connect_active_document (self);
	_g_object_unref0 (doc);
}


void search_and_replace_hide (SearchAndReplace* self) {
	MainWindow* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GQuark _tmp2_ = 0U;
	GtkGrid* _tmp3_ = NULL;
	MainWindow* _tmp4_ = NULL;
	DocumentView* _tmp5_ = NULL;
	DocumentView* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	g_signal_parse_name ("notify::active-document", G_TYPE_OBJECT, &_tmp1_, &_tmp2_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, _tmp2_, NULL, (GCallback) _search_and_replace_connect_active_document_g_object_notify, self);
	search_and_replace_destroy_search_context (self);
	_tmp3_ = self->priv->_main_grid;
	gtk_widget_hide ((GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->_main_window;
	_tmp5_ = main_window_get_active_view (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ != NULL) {
		MainWindow* _tmp7_ = NULL;
		DocumentView* _tmp8_ = NULL;
		DocumentView* _tmp9_ = NULL;
		_tmp7_ = self->priv->_main_window;
		_tmp8_ = main_window_get_active_view (_tmp7_);
		_tmp9_ = _tmp8_;
		gtk_widget_grab_focus ((GtkWidget*) _tmp9_);
	}
}


static void _search_and_replace_mark_set_cb_gtk_text_buffer_mark_set (GtkTextBuffer* _sender, GtkTextIter* location, GtkTextMark* mark, gpointer self) {
	search_and_replace_mark_set_cb ((SearchAndReplace*) self, _sender, location, mark);
}


static void search_and_replace_destroy_search_context (SearchAndReplace* self) {
	GtkSourceSearchContext* _tmp0_ = NULL;
	GtkSourceBuffer* buffer = NULL;
	GtkSourceSearchContext* _tmp1_ = NULL;
	GtkSourceBuffer* _tmp2_ = NULL;
	GtkSourceBuffer* _tmp3_ = NULL;
	GtkSourceBuffer* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_search_context;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->_search_context;
	_tmp2_ = gtk_source_search_context_get_buffer (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	buffer = _tmp3_;
	_tmp4_ = buffer;
	g_signal_parse_name ("mark-set", gtk_text_buffer_get_type (), &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkTextBuffer*) _tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _search_and_replace_mark_set_cb_gtk_text_buffer_mark_set, self);
	_g_object_unref0 (self->priv->_search_context);
	self->priv->_search_context = NULL;
	_g_object_unref0 (buffer);
}


static void __lambda90_ (SearchAndReplace* self) {
	gboolean _tmp0_ = FALSE;
	GtkSourceSearchContext* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	_tmp1_ = self->priv->_search_context;
	_tmp2_ = gtk_source_search_context_get_occurrences_count (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		GtkSourceSearchSettings* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		_tmp4_ = self->priv->_search_settings;
		_tmp5_ = gtk_source_search_settings_get_search_text (_tmp4_);
		_tmp0_ = _tmp5_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkSearchEntry* _tmp6_ = NULL;
		_tmp6_ = self->priv->_entry_find;
		error_entry_add_error ((GtkWidget*) _tmp6_);
	} else {
		GtkSourceSearchContext* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		_tmp7_ = self->priv->_search_context;
		_tmp8_ = gtk_source_search_context_get_occurrences_count (_tmp7_);
		_tmp9_ = _tmp8_;
		if (_tmp9_ >= 0) {
			GtkSearchEntry* _tmp10_ = NULL;
			_tmp10_ = self->priv->_entry_find;
			error_entry_remove_error ((GtkWidget*) _tmp10_);
		}
	}
	search_and_replace_update_info_label (self);
}


static void ___lambda90__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda90_ ((SearchAndReplace*) self);
}


static void search_and_replace_connect_active_document (SearchAndReplace* self) {
	Document* doc = NULL;
	MainWindow* _tmp0_ = NULL;
	Document* _tmp1_ = NULL;
	Document* _tmp2_ = NULL;
	Document* _tmp3_ = NULL;
	Document* _tmp4_ = NULL;
	Document* _tmp5_ = NULL;
	GtkSourceSearchSettings* _tmp6_ = NULL;
	GtkSourceSearchContext* _tmp7_ = NULL;
	GtkSourceSearchContext* _tmp8_ = NULL;
	gboolean readonly = FALSE;
	MainWindow* _tmp9_ = NULL;
	Document* _tmp10_ = NULL;
	Document* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	GtkGrid* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	Document* _tmp16_ = NULL;
	g_return_if_fail (self != NULL);
	search_and_replace_destroy_search_context (self);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_document (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	doc = _tmp3_;
	_tmp4_ = doc;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (doc);
		return;
	}
	_tmp5_ = doc;
	_tmp6_ = self->priv->_search_settings;
	_tmp7_ = gtk_source_search_context_new ((GtkSourceBuffer*) _tmp5_, _tmp6_);
	_g_object_unref0 (self->priv->_search_context);
	self->priv->_search_context = _tmp7_;
	_tmp8_ = self->priv->_search_context;
	g_signal_connect_object ((GObject*) _tmp8_, "notify::occurrences-count", (GCallback) ___lambda90__g_object_notify, self, 0);
	_tmp9_ = self->priv->_main_window;
	_tmp10_ = main_window_get_active_document (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = document_get_readonly (_tmp11_);
	_tmp13_ = _tmp12_;
	readonly = _tmp13_;
	_tmp14_ = self->priv->_replace_grid;
	_tmp15_ = readonly;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp14_, !_tmp15_);
	_tmp16_ = doc;
	g_signal_connect_object ((GtkTextBuffer*) _tmp16_, "mark-set", (GCallback) _search_and_replace_mark_set_cb_gtk_text_buffer_mark_set, self, 0);
	_g_object_unref0 (doc);
}


static void search_and_replace_mark_set_cb (SearchAndReplace* self, GtkTextBuffer* buffer, GtkTextIter* location, GtkTextMark* mark) {
	gboolean _tmp0_ = FALSE;
	GtkTextMark* _tmp1_ = NULL;
	GtkTextBuffer* _tmp2_ = NULL;
	GtkTextMark* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (buffer != NULL);
	g_return_if_fail (location != NULL);
	g_return_if_fail (mark != NULL);
	_tmp1_ = mark;
	_tmp2_ = buffer;
	_tmp3_ = gtk_text_buffer_get_insert (_tmp2_);
	if (_tmp1_ == _tmp3_) {
		_tmp0_ = TRUE;
	} else {
		GtkTextMark* _tmp4_ = NULL;
		GtkTextBuffer* _tmp5_ = NULL;
		GtkTextMark* _tmp6_ = NULL;
		_tmp4_ = mark;
		_tmp5_ = buffer;
		_tmp6_ = gtk_text_buffer_get_selection_bound (_tmp5_);
		_tmp0_ = _tmp4_ == _tmp6_;
	}
	if (_tmp0_) {
		search_and_replace_update_info_label (self);
	}
}


static void search_and_replace_update_info_label (SearchAndReplace* self) {
	gboolean _tmp0_ = FALSE;
	GtkSourceSearchContext* _tmp1_ = NULL;
	gint count = 0;
	GtkSourceSearchContext* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	GtkTextBuffer* buffer = NULL;
	GtkSourceSearchContext* _tmp12_ = NULL;
	GtkSourceBuffer* _tmp13_ = NULL;
	GtkTextBuffer* _tmp14_ = NULL;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextBuffer* _tmp15_ = NULL;
	GtkTextIter _tmp16_ = {0};
	GtkTextIter _tmp17_ = {0};
	gint pos = 0;
	GtkSourceSearchContext* _tmp18_ = NULL;
	GtkTextIter _tmp19_ = {0};
	GtkTextIter _tmp20_ = {0};
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_search_context;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GtkSourceSearchSettings* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		_tmp2_ = self->priv->_search_settings;
		_tmp3_ = gtk_source_search_settings_get_search_text (_tmp2_);
		_tmp0_ = _tmp3_ == NULL;
	}
	if (_tmp0_) {
		GtkLabel* _tmp4_ = NULL;
		_tmp4_ = self->priv->_info_label;
		gtk_label_set_text (_tmp4_, "");
		return;
	}
	_tmp5_ = self->priv->_search_context;
	_tmp6_ = gtk_source_search_context_get_occurrences_count (_tmp5_);
	_tmp7_ = _tmp6_;
	count = _tmp7_;
	_tmp8_ = count;
	if (_tmp8_ == (-1)) {
		return;
	}
	_tmp9_ = count;
	if (_tmp9_ == 0) {
		GtkLabel* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		_tmp10_ = self->priv->_info_label;
		_tmp11_ = _ ("Not found");
		gtk_label_set_text (_tmp10_, _tmp11_);
		return;
	}
	_tmp12_ = self->priv->_search_context;
	_tmp13_ = gtk_source_search_context_get_buffer (_tmp12_);
	_tmp14_ = _g_object_ref0 ((GtkTextBuffer*) _tmp13_);
	buffer = _tmp14_;
	_tmp15_ = buffer;
	gtk_text_buffer_get_selection_bounds (_tmp15_, &_tmp16_, &_tmp17_);
	start = _tmp16_;
	end = _tmp17_;
	_tmp18_ = self->priv->_search_context;
	_tmp19_ = start;
	_tmp20_ = end;
	_tmp21_ = gtk_source_search_context_get_occurrence_position (_tmp18_, &_tmp19_, &_tmp20_);
	pos = _tmp21_;
	_tmp22_ = pos;
	if (_tmp22_ > 0) {
		GtkLabel* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		gint _tmp25_ = 0;
		gint _tmp26_ = 0;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		_tmp23_ = self->priv->_info_label;
		_tmp24_ = _ ("Match %d of %d");
		_tmp25_ = pos;
		_tmp26_ = count;
		_tmp27_ = g_strdup_printf (_tmp24_, _tmp25_, _tmp26_);
		_tmp28_ = _tmp27_;
		gtk_label_set_text (_tmp23_, _tmp28_);
		_g_free0 (_tmp28_);
	} else {
		gchar* text = NULL;
		gint _tmp29_ = 0;
		const gchar* _tmp30_ = NULL;
		gint _tmp31_ = 0;
		gchar* _tmp32_ = NULL;
		GtkLabel* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		_tmp29_ = count;
		_tmp30_ = ngettext ("%d match", "%d matches", (gulong) _tmp29_);
		_tmp31_ = count;
		_tmp32_ = g_strdup_printf (_tmp30_, _tmp31_);
		text = _tmp32_;
		_tmp33_ = self->priv->_info_label;
		_tmp34_ = text;
		gtk_label_set_text (_tmp33_, _tmp34_);
		_g_free0 (text);
	}
	_g_object_unref0 (buffer);
}


static void search_and_replace_search_forward (SearchAndReplace* self) {
	GtkSourceSearchContext* _tmp0_ = NULL;
	GtkTextIter iter = {0};
	GtkTextIter match_start = {0};
	GtkTextIter match_end = {0};
	Document* doc = NULL;
	GtkSourceSearchContext* _tmp1_ = NULL;
	GtkSourceBuffer* _tmp2_ = NULL;
	Document* _tmp3_ = NULL;
	Document* _tmp4_ = NULL;
	GtkTextIter _tmp5_ = {0};
	GtkSourceSearchContext* _tmp6_ = NULL;
	GtkTextIter _tmp7_ = {0};
	GtkTextIter _tmp8_ = {0};
	GtkTextIter _tmp9_ = {0};
	gboolean _tmp10_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_search_context;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->_search_context;
	_tmp2_ = gtk_source_search_context_get_buffer (_tmp1_);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, TYPE_DOCUMENT) ? ((Document*) _tmp2_) : NULL);
	doc = _tmp3_;
	_tmp4_ = doc;
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) _tmp4_, NULL, &_tmp5_);
	iter = _tmp5_;
	_tmp6_ = self->priv->_search_context;
	_tmp7_ = iter;
	_tmp10_ = gtk_source_search_context_forward (_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_);
	match_start = _tmp8_;
	match_end = _tmp9_;
	if (_tmp10_) {
		Document* _tmp11_ = NULL;
		GtkTextIter _tmp12_ = {0};
		GtkTextIter _tmp13_ = {0};
		Document* _tmp14_ = NULL;
		DocumentTab* _tmp15_ = NULL;
		DocumentView* _tmp16_ = NULL;
		DocumentView* _tmp17_ = NULL;
		_tmp11_ = doc;
		_tmp12_ = match_start;
		_tmp13_ = match_end;
		gtk_text_buffer_select_range ((GtkTextBuffer*) _tmp11_, &_tmp12_, &_tmp13_);
		_tmp14_ = doc;
		_tmp15_ = _tmp14_->tab;
		_tmp16_ = document_tab_get_view (_tmp15_);
		_tmp17_ = _tmp16_;
		document_view_scroll_to_cursor (_tmp17_, 0.25);
	}
	_g_object_unref0 (doc);
}


static void search_and_replace_replace (SearchAndReplace* self) {
	GtkSourceSearchContext* _tmp0_ = NULL;
	GtkTextIter match_start = {0};
	GtkTextIter match_end = {0};
	GtkSourceBuffer* buffer = NULL;
	GtkSourceSearchContext* _tmp1_ = NULL;
	GtkSourceBuffer* _tmp2_ = NULL;
	GtkSourceBuffer* _tmp3_ = NULL;
	GtkSourceBuffer* _tmp4_ = NULL;
	GtkTextIter _tmp5_ = {0};
	GtkTextIter _tmp6_ = {0};
	MainWindow* _tmp7_ = NULL;
	DocumentView* _tmp8_ = NULL;
	DocumentView* _tmp9_ = NULL;
	GtkSourceCompletion* _tmp10_ = NULL;
	GtkSourceCompletion* _tmp11_ = NULL;
	MainWindow* _tmp20_ = NULL;
	DocumentView* _tmp21_ = NULL;
	DocumentView* _tmp22_ = NULL;
	GtkSourceCompletion* _tmp23_ = NULL;
	GtkSourceCompletion* _tmp24_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_search_context;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->_search_context;
	_tmp2_ = gtk_source_search_context_get_buffer (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	buffer = _tmp3_;
	_tmp4_ = buffer;
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) _tmp4_, &_tmp5_, &_tmp6_);
	match_start = _tmp5_;
	match_end = _tmp6_;
	_tmp7_ = self->priv->_main_window;
	_tmp8_ = main_window_get_active_view (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = gtk_source_view_get_completion ((GtkSourceView*) _tmp9_);
	_tmp11_ = _tmp10_;
	gtk_source_completion_block_interactive (_tmp11_);
	{
		gboolean _tmp12_ = FALSE;
		GtkSourceSearchContext* _tmp13_ = NULL;
		GtkTextIter _tmp14_ = {0};
		GtkTextIter _tmp15_ = {0};
		GtkSearchEntry* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		_tmp13_ = self->priv->_search_context;
		_tmp14_ = match_start;
		_tmp15_ = match_end;
		_tmp16_ = self->priv->_entry_replace;
		_tmp17_ = gtk_entry_get_text ((GtkEntry*) _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = gtk_source_search_context_replace (_tmp13_, &_tmp14_, &_tmp15_, _tmp18_, -1, &_inner_error_);
		_tmp12_ = _tmp19_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch40_g_error;
		}
		if (!_tmp12_) {
			search_and_replace_search_forward (self);
		}
	}
	goto __finally40;
	__catch40_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally40:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (buffer);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp20_ = self->priv->_main_window;
	_tmp21_ = main_window_get_active_view (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = gtk_source_view_get_completion ((GtkSourceView*) _tmp22_);
	_tmp24_ = _tmp23_;
	gtk_source_completion_unblock_interactive (_tmp24_);
	_g_object_unref0 (buffer);
}


static void search_and_replace_class_init (SearchAndReplaceClass * klass) {
	search_and_replace_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SearchAndReplacePrivate));
	G_OBJECT_CLASS (klass)->finalize = search_and_replace_finalize;
}


static void search_and_replace_instance_init (SearchAndReplace * self) {
	self->priv = SEARCH_AND_REPLACE_GET_PRIVATE (self);
	self->priv->_search_context = NULL;
}


static void search_and_replace_finalize (GObject* obj) {
	SearchAndReplace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_AND_REPLACE, SearchAndReplace);
	_g_object_unref0 (self->priv->_main_grid);
	_g_object_unref0 (self->priv->_replace_grid);
	_g_object_unref0 (self->priv->_arrow);
	_g_object_unref0 (self->priv->_entry_find);
	_g_object_unref0 (self->priv->_entry_replace);
	_g_object_unref0 (self->priv->_info_label);
	_g_object_unref0 (self->priv->_search_settings);
	_g_object_unref0 (self->priv->_search_context);
	G_OBJECT_CLASS (search_and_replace_parent_class)->finalize (obj);
}


GType search_and_replace_get_type (void) {
	static volatile gsize search_and_replace_type_id__volatile = 0;
	if (g_once_init_enter (&search_and_replace_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SearchAndReplaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_and_replace_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchAndReplace), 0, (GInstanceInitFunc) search_and_replace_instance_init, NULL };
		GType search_and_replace_type_id;
		search_and_replace_type_id = g_type_register_static (G_TYPE_OBJECT, "SearchAndReplace", &g_define_type_info, 0);
		g_once_init_leave (&search_and_replace_type_id__volatile, search_and_replace_type_id);
	}
	return search_and_replace_type_id__volatile;
}



