/* latexila_app.c generated by valac 0.30.0.35-2c9e8, the Vala compiler
 * generated from latexila_app.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2015 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "config.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <latexila.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gee.h>
#include <gtksourceview/gtksource.h>


#define TYPE_LATEXILA_APP (latexila_app_get_type ())
#define LATEXILA_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEXILA_APP, LatexilaApp))
#define LATEXILA_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEXILA_APP, LatexilaAppClass))
#define IS_LATEXILA_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEXILA_APP))
#define IS_LATEXILA_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEXILA_APP))
#define LATEXILA_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEXILA_APP, LatexilaAppClass))

typedef struct _LatexilaApp LatexilaApp;
typedef struct _LatexilaAppClass LatexilaAppClass;
typedef struct _LatexilaAppPrivate LatexilaAppPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block22Data Block22Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_APP_SETTINGS (app_settings_get_type ())
#define APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_SETTINGS, AppSettings))
#define APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_SETTINGS, AppSettingsClass))
#define IS_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_SETTINGS))
#define IS_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_SETTINGS))
#define APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_SETTINGS, AppSettingsClass))

typedef struct _AppSettings AppSettings;
typedef struct _AppSettingsClass AppSettingsClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PROJECTS (projects_get_type ())
#define PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECTS, Projects))
#define PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECTS, ProjectsClass))
#define IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECTS))
#define IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECTS))
#define PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECTS, ProjectsClass))

typedef struct _Projects Projects;
typedef struct _ProjectsClass ProjectsClass;
#define _projects_unref0(var) ((var == NULL) ? NULL : (var = (projects_unref (var), NULL)))

#define TYPE_MOST_USED_SYMBOLS (most_used_symbols_get_type ())
#define MOST_USED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOST_USED_SYMBOLS, MostUsedSymbols))
#define MOST_USED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsClass))
#define IS_MOST_USED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOST_USED_SYMBOLS))
#define IS_MOST_USED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOST_USED_SYMBOLS))
#define MOST_USED_SYMBOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsClass))

typedef struct _MostUsedSymbols MostUsedSymbols;
typedef struct _MostUsedSymbolsClass MostUsedSymbolsClass;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_BUILD_TOOLS_PREFERENCES (build_tools_preferences_get_type ())
#define BUILD_TOOLS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferences))
#define BUILD_TOOLS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferencesClass))
#define IS_BUILD_TOOLS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOLS_PREFERENCES))
#define IS_BUILD_TOOLS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOLS_PREFERENCES))
#define BUILD_TOOLS_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferencesClass))

typedef struct _BuildToolsPreferences BuildToolsPreferences;
typedef struct _BuildToolsPreferencesClass BuildToolsPreferencesClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

struct _LatexilaApp {
	GtkApplication parent_instance;
	LatexilaAppPrivate * priv;
};

struct _LatexilaAppClass {
	GtkApplicationClass parent_class;
};

struct _LatexilaAppPrivate {
	gboolean _activate_called;
};

struct _Block22Data {
	int _ref_count_;
	LatexilaApp* self;
	gboolean show_version;
	gboolean new_document;
	gboolean new_window;
};


static gpointer latexila_app_parent_class = NULL;
static GtkCssProvider* latexila_app__provider;
static GtkCssProvider* latexila_app__provider = NULL;

GType latexila_app_get_type (void) G_GNUC_CONST;
#define LATEXILA_APP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LATEXILA_APP, LatexilaAppPrivate))
enum  {
	LATEXILA_APP_DUMMY_PROPERTY
};
static void latexila_app_new_document_cb (LatexilaApp* self);
static void _latexila_app_new_document_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void latexila_app_new_window_cb (LatexilaApp* self);
static void _latexila_app_new_window_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void latexila_app_preferences_cb (LatexilaApp* self);
static void _latexila_app_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void latexila_app_manage_build_tools_cb (LatexilaApp* self);
static void _latexila_app_manage_build_tools_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void latexila_app_help_cb (LatexilaApp* self);
static void _latexila_app_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void latexila_app_about_cb (LatexilaApp* self);
static void _latexila_app_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void latexila_app_quit_cb (LatexilaApp* self);
static void _latexila_app_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
LatexilaApp* latexila_app_new (void);
LatexilaApp* latexila_app_construct (GType object_type);
static void latexila_app_setup_main_option_entries (LatexilaApp* self);
static void latexila_app_startup_cb (LatexilaApp* self);
static void _latexila_app_startup_cb_g_application_startup (GApplication* _sender, gpointer self);
static void latexila_app_activate_cb (LatexilaApp* self);
static void _latexila_app_activate_cb_g_application_activate (GApplication* _sender, gpointer self);
void latexila_app_open_documents (LatexilaApp* self, GFile** files, int files_length1);
static void _latexila_app_open_documents_g_application_open (GApplication* _sender, GFile** files, int n_files, const gchar* hint, gpointer self);
static void latexila_app_shutdown_cb (LatexilaApp* self);
static void _latexila_app_shutdown_cb_g_application_shutdown (GApplication* _sender, gpointer self);
LatexilaApp* latexila_app_get_instance (void);
GType main_window_get_type (void) G_GNUC_CONST;
MainWindow* latexila_app_get_active_main_window (LatexilaApp* self);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
static gint __lambda130_ (Block22Data* _data22_);
static gint ___lambda130__g_application_handle_local_options (GApplication* _sender, GVariantDict* options, gpointer self);
static void latexila_app_set_application_icons (LatexilaApp* self);
void stock_icons_register_stock_icons (void);
static void latexila_app_setup_theme_extensions (LatexilaApp* self);
GType app_settings_get_type (void) G_GNUC_CONST;
AppSettings* app_settings_get_default (void);
static void latexila_app_support_backward_search (LatexilaApp* self);
static gchar* latexila_app_get_accel_filename (LatexilaApp* self);
MainWindow* latexila_app_create_window (LatexilaApp* self);
static void latexila_app_reopen_files (LatexilaApp* self);
gpointer projects_ref (gpointer instance);
void projects_unref (gpointer instance);
GParamSpec* param_spec_projects (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_projects (GValue* value, gpointer v_object);
void value_take_projects (GValue* value, gpointer v_object);
gpointer value_get_projects (const GValue* value);
GType projects_get_type (void) G_GNUC_CONST;
Projects* projects_get_default (void);
void projects_save (Projects* self);
GType most_used_symbols_get_type (void) G_GNUC_CONST;
MostUsedSymbols* most_used_symbols_get_default (void);
void most_used_symbols_save (MostUsedSymbols* self);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentTab* main_window_create_tab (MainWindow* self, gboolean jump_to);
void preferences_dialog_show_me (GtkWindow* parent);
BuildToolsPreferences* build_tools_preferences_new (GtkWindow* parent_window);
BuildToolsPreferences* build_tools_preferences_construct (GType object_type, GtkWindow* parent_window);
GType build_tools_preferences_get_type (void) G_GNUC_CONST;
gboolean main_window_quit (MainWindow* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void latexila_app_update_theme (LatexilaApp* self);
static void _latexila_app_update_theme_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _vala_array_add5 (GFile*** array, int* length, int* size, GFile* value);
GType document_get_type (void) G_GNUC_CONST;
GeeList* latexila_app_get_documents (LatexilaApp* self);
GeeList* main_window_get_documents (MainWindow* self);
GType document_view_get_type (void) G_GNUC_CONST;
GeeList* latexila_app_get_views (LatexilaApp* self);
GeeList* main_window_get_views (MainWindow* self);
void main_window_save_state (MainWindow* self);
MainWindow* main_window_new (LatexilaApp* app);
MainWindow* main_window_construct (GType object_type, LatexilaApp* app);
DocumentTab* main_window_open_document (MainWindow* self, GFile* location, gboolean jump_to);
static void __lambda131_ (LatexilaApp* self, const gchar* tex_uri, gint line, guint timestamp);
void main_window_jump_to_file_position (MainWindow* self, GFile* file, gint start_line, gint end_line);
static void ___lambda131__latexila_synctex_backward_search (LatexilaSynctex* _sender, const gchar* tex_uri, gint line, guint timestamp, gpointer self);
static void latexila_app_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GActionEntry LATEXILA_APP__app_actions[7] = {{"new-document", _latexila_app_new_document_cb_gsimple_action_activate_callback}, {"new-window", _latexila_app_new_window_cb_gsimple_action_activate_callback}, {"preferences", _latexila_app_preferences_cb_gsimple_action_activate_callback}, {"manage-build-tools", _latexila_app_manage_build_tools_cb_gsimple_action_activate_callback}, {"help", _latexila_app_help_cb_gsimple_action_activate_callback}, {"about", _latexila_app_about_cb_gsimple_action_activate_callback}, {"quit", _latexila_app_quit_cb_gsimple_action_activate_callback}};

static void _latexila_app_new_document_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	latexila_app_new_document_cb ((LatexilaApp*) self);
}


static void _latexila_app_new_window_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	latexila_app_new_window_cb ((LatexilaApp*) self);
}


static void _latexila_app_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	latexila_app_preferences_cb ((LatexilaApp*) self);
}


static void _latexila_app_manage_build_tools_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	latexila_app_manage_build_tools_cb ((LatexilaApp*) self);
}


static void _latexila_app_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	latexila_app_help_cb ((LatexilaApp*) self);
}


static void _latexila_app_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	latexila_app_about_cb ((LatexilaApp*) self);
}


static void _latexila_app_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	latexila_app_quit_cb ((LatexilaApp*) self);
}


static void _latexila_app_startup_cb_g_application_startup (GApplication* _sender, gpointer self) {
	latexila_app_startup_cb ((LatexilaApp*) self);
}


static void _latexila_app_activate_cb_g_application_activate (GApplication* _sender, gpointer self) {
	latexila_app_activate_cb ((LatexilaApp*) self);
}


static void _latexila_app_open_documents_g_application_open (GApplication* _sender, GFile** files, int n_files, const gchar* hint, gpointer self) {
	latexila_app_open_documents ((LatexilaApp*) self, files, n_files);
}


static void _latexila_app_shutdown_cb_g_application_shutdown (GApplication* _sender, gpointer self) {
	latexila_app_shutdown_cb ((LatexilaApp*) self);
}


LatexilaApp* latexila_app_construct (GType object_type) {
	LatexilaApp * self = NULL;
	self = (LatexilaApp*) g_object_new (object_type, "application-id", "org.gnome.latexila", NULL);
	g_application_set_flags ((GApplication*) self, G_APPLICATION_HANDLES_OPEN);
	g_set_application_name (PACKAGE_NAME);
	latexila_app_setup_main_option_entries (self);
	g_signal_connect_object ((GApplication*) self, "startup", (GCallback) _latexila_app_startup_cb_g_application_startup, self, 0);
	g_signal_connect_object ((GApplication*) self, "activate", (GCallback) _latexila_app_activate_cb_g_application_activate, self, 0);
	g_signal_connect_object ((GApplication*) self, "open", (GCallback) _latexila_app_open_documents_g_application_open, self, 0);
	g_signal_connect_object ((GApplication*) self, "shutdown", (GCallback) _latexila_app_shutdown_cb_g_application_shutdown, self, 0);
	return self;
}


LatexilaApp* latexila_app_new (void) {
	return latexila_app_construct (TYPE_LATEXILA_APP);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


LatexilaApp* latexila_app_get_instance (void) {
	LatexilaApp* result = NULL;
	GApplication* _tmp0_ = NULL;
	LatexilaApp* _tmp1_ = NULL;
	_tmp0_ = g_application_get_default ();
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_LATEXILA_APP) ? ((LatexilaApp*) _tmp0_) : NULL);
	result = _tmp1_;
	return result;
}


MainWindow* latexila_app_get_active_main_window (LatexilaApp* self) {
	MainWindow* result = NULL;
	GList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp0_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			GtkWindow* _tmp1_ = NULL;
			GtkWindow* window = NULL;
			_tmp1_ = _g_object_ref0 ((GtkWindow*) window_it->data);
			window = _tmp1_;
			{
				GtkWindow* _tmp2_ = NULL;
				_tmp2_ = window;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, TYPE_MAIN_WINDOW)) {
					GtkWindow* _tmp3_ = NULL;
					MainWindow* _tmp4_ = NULL;
					_tmp3_ = window;
					_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_MAIN_WINDOW) ? ((MainWindow*) _tmp3_) : NULL);
					result = _tmp4_;
					_g_object_unref0 (window);
					return result;
				}
				_g_object_unref0 (window);
			}
		}
	}
	result = NULL;
	return result;
}


static Block22Data* block22_data_ref (Block22Data* _data22_) {
	g_atomic_int_inc (&_data22_->_ref_count_);
	return _data22_;
}


static void block22_data_unref (void * _userdata_) {
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
		LatexilaApp* self;
		self = _data22_->self;
		_g_object_unref0 (self);
		g_slice_free (Block22Data, _data22_);
	}
}


static gint __lambda130_ (Block22Data* _data22_) {
	LatexilaApp* self;
	gint result = 0;
	GError * _inner_error_ = NULL;
	self = _data22_->self;
	if (_data22_->show_version) {
		FILE* _tmp0_ = NULL;
		_tmp0_ = stdout;
		fprintf (_tmp0_, "%s %s\n", PACKAGE_NAME, PACKAGE_VERSION);
		result = 0;
		return result;
	}
	{
		g_application_register ((GApplication*) self, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch25_g_error;
		}
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp1_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e->message;
		g_error ("latexila_app.vala:103: Failed to register the application: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally25:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	if (_data22_->new_window) {
		g_action_group_activate_action ((GActionGroup*) self, "new-window", NULL);
	}
	if (_data22_->new_document) {
		g_action_group_activate_action ((GActionGroup*) self, "new-document", NULL);
	}
	result = -1;
	return result;
}


static gint ___lambda130__g_application_handle_local_options (GApplication* _sender, GVariantDict* options, gpointer self) {
	gint result;
	result = __lambda130_ (self);
	return result;
}


static void latexila_app_setup_main_option_entries (LatexilaApp* self) {
	Block22Data* _data22_;
	GOptionEntry* options = NULL;
	GOptionEntry* _tmp0_ = NULL;
	gint options_length1 = 0;
	gint _options_size_ = 0;
	GOptionEntry _tmp1_ = {0};
	GOptionEntry _tmp2_ = {0};
	GOptionEntry _tmp3_ = {0};
	GOptionEntry _tmp4_ = {0};
	GOptionEntry _tmp5_ = {0};
	GOptionEntry _tmp6_ = {0};
	GOptionEntry _tmp7_ = {0};
	GOptionEntry _tmp8_ = {0};
	g_return_if_fail (self != NULL);
	_data22_ = g_slice_new0 (Block22Data);
	_data22_->_ref_count_ = 1;
	_data22_->self = g_object_ref (self);
	_data22_->show_version = FALSE;
	_data22_->new_document = FALSE;
	_data22_->new_window = FALSE;
	_tmp0_ = g_new0 (GOptionEntry, 4);
	options = _tmp0_;
	options_length1 = 4;
	_options_size_ = options_length1;
	_tmp1_.long_name = "version";
	_tmp1_.short_name = 'V';
	_tmp1_.flags = 0;
	_tmp1_.arg = G_OPTION_ARG_NONE;
	_tmp1_.arg_data = &_data22_->show_version;
	_tmp1_.description = "Show the application's version";
	_tmp1_.arg_description = NULL;
	options[0] = _tmp1_;
	_tmp2_ = options[0];
	_tmp3_.long_name = "new-document";
	_tmp3_.short_name = 'n';
	_tmp3_.flags = 0;
	_tmp3_.arg = G_OPTION_ARG_NONE;
	_tmp3_.arg_data = &_data22_->new_document;
	_tmp3_.description = "Create new document";
	_tmp3_.arg_description = NULL;
	options[1] = _tmp3_;
	_tmp4_ = options[1];
	_tmp5_.long_name = "new-window";
	_tmp5_.short_name = (gchar) 0;
	_tmp5_.flags = 0;
	_tmp5_.arg = G_OPTION_ARG_NONE;
	_tmp5_.arg_data = &_data22_->new_window;
	_tmp5_.description = "Create a new top-level window in an existing instance of LaTeXila";
	_tmp5_.arg_description = NULL;
	options[2] = _tmp5_;
	_tmp6_ = options[2];
	_tmp7_.long_name = NULL;
	options[3] = _tmp7_;
	_tmp8_ = options[3];
	g_application_add_main_option_entries ((GApplication*) self, options);
	g_signal_connect_data ((GApplication*) self, "handle-local-options", (GCallback) ___lambda130__g_application_handle_local_options, block22_data_ref (_data22_), (GClosureNotify) block22_data_unref, 0);
	options = (g_free (options), NULL);
	block22_data_unref (_data22_);
	_data22_ = NULL;
}


static void latexila_app_startup_cb (LatexilaApp* self) {
	AppSettings* _tmp0_ = NULL;
	AppSettings* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_application_hold ((GApplication*) self);
	g_action_map_add_action_entries ((GActionMap*) self, LATEXILA_APP__app_actions, G_N_ELEMENTS (LATEXILA_APP__app_actions), self);
	latexila_app_set_application_icons (self);
	latexila_utils_register_icons ();
	stock_icons_register_stock_icons ();
	latexila_app_setup_theme_extensions (self);
	_tmp0_ = app_settings_get_default ();
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
	latexila_app_support_backward_search (self);
	_tmp2_ = latexila_app_get_accel_filename (self);
	_tmp3_ = _tmp2_;
	gtk_accel_map_load (_tmp3_);
	_g_free0 (_tmp3_);
	g_application_release ((GApplication*) self);
}


static void latexila_app_activate_cb (LatexilaApp* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_application_hold ((GApplication*) self);
	_tmp0_ = self->priv->_activate_called;
	if (!_tmp0_) {
		MainWindow* _tmp1_ = NULL;
		MainWindow* _tmp2_ = NULL;
		self->priv->_activate_called = TRUE;
		_tmp1_ = latexila_app_create_window (self);
		_tmp2_ = _tmp1_;
		_g_object_unref0 (_tmp2_);
		latexila_app_reopen_files (self);
	} else {
		GtkWindow* _tmp3_ = NULL;
		GtkWindow* _tmp4_ = NULL;
		_tmp3_ = gtk_application_get_active_window ((GtkApplication*) self);
		_tmp4_ = _tmp3_;
		gtk_window_present (_tmp4_);
	}
	g_application_release ((GApplication*) self);
}


static void latexila_app_shutdown_cb (LatexilaApp* self) {
	Projects* _tmp0_ = NULL;
	Projects* _tmp1_ = NULL;
	MostUsedSymbols* _tmp2_ = NULL;
	MostUsedSymbols* _tmp3_ = NULL;
	gchar* accel_filename = NULL;
	gchar* _tmp4_ = NULL;
	GFile* accel_file = NULL;
	GFile* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_application_hold ((GApplication*) self);
	_tmp0_ = projects_get_default ();
	_tmp1_ = _tmp0_;
	projects_save (_tmp1_);
	_projects_unref0 (_tmp1_);
	_tmp2_ = most_used_symbols_get_default ();
	_tmp3_ = _tmp2_;
	most_used_symbols_save (_tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = latexila_app_get_accel_filename (self);
	accel_filename = _tmp4_;
	_tmp5_ = g_file_new_for_path (accel_filename);
	accel_file = _tmp5_;
	{
		latexila_utils_create_parent_directories (accel_file, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch26_g_error;
		}
		gtk_accel_map_save (accel_filename);
	}
	goto __finally26;
	__catch26_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = _error_;
		_tmp7_ = _tmp6_->message;
		g_warning ("latexila_app.vala:163: Error when saving accel file: %s", _tmp7_);
		_g_error_free0 (_error_);
	}
	__finally26:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (accel_file);
		_g_free0 (accel_filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_application_release ((GApplication*) self);
	_g_object_unref0 (accel_file);
	_g_free0 (accel_filename);
}


static void latexila_app_new_document_cb (LatexilaApp* self) {
	gboolean _tmp0_ = FALSE;
	MainWindow* window = NULL;
	MainWindow* _tmp1_ = NULL;
	DocumentTab* _tmp2_ = NULL;
	DocumentTab* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_activate_called;
	if (!_tmp0_) {
		g_application_activate ((GApplication*) self);
	}
	_tmp1_ = latexila_app_get_active_main_window (self);
	window = _tmp1_;
	g_return_if_fail (window != NULL);
	_tmp2_ = main_window_create_tab (window, TRUE);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (window);
}


static void latexila_app_new_window_cb (LatexilaApp* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_activate_called;
	if (_tmp0_) {
		MainWindow* _tmp1_ = NULL;
		MainWindow* _tmp2_ = NULL;
		_tmp1_ = latexila_app_create_window (self);
		_tmp2_ = _tmp1_;
		_g_object_unref0 (_tmp2_);
	} else {
		g_application_activate ((GApplication*) self);
	}
}


static void latexila_app_preferences_cb (LatexilaApp* self) {
	MainWindow* _tmp0_ = NULL;
	MainWindow* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = latexila_app_get_active_main_window (self);
	_tmp1_ = _tmp0_;
	preferences_dialog_show_me ((GtkWindow*) _tmp1_);
	_g_object_unref0 (_tmp1_);
}


static void latexila_app_manage_build_tools_cb (LatexilaApp* self) {
	MainWindow* _tmp0_ = NULL;
	MainWindow* _tmp1_ = NULL;
	BuildToolsPreferences* _tmp2_ = NULL;
	BuildToolsPreferences* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = latexila_app_get_active_main_window (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = build_tools_preferences_new ((GtkWindow*) _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
}


static void latexila_app_help_cb (LatexilaApp* self) {
	GdkScreen* screen = NULL;
	MainWindow* window = NULL;
	MainWindow* _tmp0_ = NULL;
	MainWindow* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	screen = NULL;
	_tmp0_ = latexila_app_get_active_main_window (self);
	window = _tmp0_;
	_tmp1_ = window;
	if (_tmp1_ != NULL) {
		MainWindow* _tmp2_ = NULL;
		GdkScreen* _tmp3_ = NULL;
		GdkScreen* _tmp4_ = NULL;
		_tmp2_ = window;
		_tmp3_ = gtk_window_get_screen ((GtkWindow*) _tmp2_);
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_g_object_unref0 (screen);
		screen = _tmp4_;
	}
	{
		GdkScreen* _tmp5_ = NULL;
		_tmp5_ = screen;
		gtk_show_uri (_tmp5_, "help:latexila", (guint32) GDK_CURRENT_TIME, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch27_g_error;
		}
	}
	goto __finally27;
	__catch27_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("latexila_app.vala:210: Impossible to open the documentation: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally27:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (window);
		_g_object_unref0 (screen);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (window);
	_g_object_unref0 (screen);
}


static void latexila_app_about_cb (LatexilaApp* self) {
	gchar* comments = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* copyright = NULL;
	gchar* _tmp2_ = NULL;
	gchar* website = NULL;
	gchar* _tmp3_ = NULL;
	gchar** authors = NULL;
	gchar* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar** artists = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gint artists_length1 = 0;
	gint _artists_size_ = 0;
	GdkPixbuf* logo = NULL;
	MainWindow* _tmp17_ = NULL;
	MainWindow* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	GdkPixbuf* _tmp21_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("LaTeXila is an Integrated LaTeX Environment for the GNOME Desktop");
	_tmp1_ = g_strdup (_tmp0_);
	comments = _tmp1_;
	_tmp2_ = g_strdup ("Copyright 2009-2016 – Sébastien Wilmet");
	copyright = _tmp2_;
	_tmp3_ = g_strdup ("https://wiki.gnome.org/Apps/LaTeXila");
	website = _tmp3_;
	_tmp4_ = g_strdup ("Sébastien Wilmet <swilmet@gnome.org>");
	_tmp5_ = g_new0 (gchar*, 2 + 1);
	_tmp5_[0] = _tmp4_;
	_tmp5_[1] = NULL;
	authors = _tmp5_;
	authors_length1 = 2;
	_authors_size_ = authors_length1;
	_tmp6_ = g_strdup ("Eric Forgeot <e.forgeot@laposte.net>");
	_tmp7_ = g_strdup ("Sébastien Wilmet <swilmet@gnome.org>");
	_tmp8_ = g_strdup ("Alexander Wilms <f.alexander.wilms@gmail.com>");
	_tmp9_ = g_strdup ("The Kile Team http://kile.sourceforge.net/");
	_tmp10_ = g_strdup ("Gedit LaTeX Plugin https://wiki.gnome.org/Apps/Gedit/LaTeXPlugin");
	_tmp11_ = g_new0 (gchar*, 6 + 1);
	_tmp11_[0] = _tmp6_;
	_tmp11_[1] = _tmp7_;
	_tmp11_[2] = _tmp8_;
	_tmp11_[3] = _tmp9_;
	_tmp11_[4] = _tmp10_;
	_tmp11_[5] = NULL;
	artists = _tmp11_;
	artists_length1 = 6;
	_artists_size_ = artists_length1;
	logo = NULL;
	{
		GdkPixbuf* _tmp12_ = NULL;
		GdkPixbuf* _tmp13_ = NULL;
		GdkPixbuf* _tmp14_ = NULL;
		_tmp13_ = gdk_pixbuf_new_from_file (DATA_DIR "/images/app/logo.png", &_inner_error_);
		_tmp12_ = _tmp13_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch28_g_error;
		}
		_tmp14_ = _tmp12_;
		_tmp12_ = NULL;
		_g_object_unref0 (logo);
		logo = _tmp14_;
		_g_object_unref0 (_tmp12_);
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError* e = NULL;
		GError* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		g_warning ("latexila_app.vala:245: Logo: %s", _tmp16_);
		_g_error_free0 (e);
	}
	__finally28:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (logo);
		artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
		authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (website);
		_g_free0 (copyright);
		_g_free0 (comments);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp17_ = latexila_app_get_active_main_window (self);
	_tmp18_ = _tmp17_;
	_tmp19_ = _ ("About LaTeXila");
	_tmp20_ = _ ("translator-credits");
	_tmp21_ = logo;
	gtk_show_about_dialog ((GtkWindow*) _tmp18_, "program-name", "LaTeXila", "version", PACKAGE_VERSION, "authors", authors, "artists", artists, "comments", comments, "copyright", copyright, "license-type", GTK_LICENSE_GPL_3_0, "title", _tmp19_, "translator-credits", _tmp20_, "website", website, "logo", _tmp21_, NULL);
	_g_object_unref0 (_tmp18_);
	_g_object_unref0 (logo);
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (website);
	_g_free0 (copyright);
	_g_free0 (comments);
}


static void latexila_app_quit_cb (LatexilaApp* self) {
	gboolean cont = FALSE;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	g_application_hold ((GApplication*) self);
	cont = TRUE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		MainWindow* main_window = NULL;
		MainWindow* _tmp1_ = NULL;
		MainWindow* _tmp2_ = NULL;
		MainWindow* _tmp3_ = NULL;
		MainWindow* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		_tmp0_ = cont;
		if (!_tmp0_) {
			break;
		}
		_tmp1_ = latexila_app_get_active_main_window (self);
		main_window = _tmp1_;
		_tmp2_ = main_window;
		if (_tmp2_ == NULL) {
			_g_object_unref0 (main_window);
			break;
		}
		_tmp3_ = main_window;
		gtk_window_present ((GtkWindow*) _tmp3_);
		_tmp4_ = main_window;
		_tmp5_ = main_window_quit (_tmp4_);
		cont = _tmp5_;
		_g_object_unref0 (main_window);
	}
	_tmp6_ = cont;
	if (_tmp6_) {
		while (TRUE) {
			GtkWindow* _tmp7_ = NULL;
			GtkWindow* _tmp8_ = NULL;
			GtkWindow* _tmp9_ = NULL;
			GtkWindow* _tmp10_ = NULL;
			_tmp7_ = gtk_application_get_active_window ((GtkApplication*) self);
			_tmp8_ = _tmp7_;
			if (!(_tmp8_ != NULL)) {
				break;
			}
			_tmp9_ = gtk_application_get_active_window ((GtkApplication*) self);
			_tmp10_ = _tmp9_;
			gtk_widget_destroy ((GtkWidget*) _tmp10_);
		}
	}
	g_application_release ((GApplication*) self);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void latexila_app_set_application_icons (LatexilaApp* self) {
	gchar** sizes = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint sizes_length1 = 0;
	gint _sizes_size_ = 0;
	GList* list = NULL;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	GList* _tmp16_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("16x16");
	_tmp1_ = g_strdup ("22x22");
	_tmp2_ = g_strdup ("24x24");
	_tmp3_ = g_strdup ("32x32");
	_tmp4_ = g_strdup ("48x48");
	_tmp5_ = g_new0 (gchar*, 5 + 1);
	_tmp5_[0] = _tmp0_;
	_tmp5_[1] = _tmp1_;
	_tmp5_[2] = _tmp2_;
	_tmp5_[3] = _tmp3_;
	_tmp5_[4] = _tmp4_;
	sizes = _tmp5_;
	sizes_length1 = 5;
	_sizes_size_ = sizes_length1;
	list = NULL;
	_tmp6_ = sizes;
	_tmp6__length1 = sizes_length1;
	{
		gchar** size_collection = NULL;
		gint size_collection_length1 = 0;
		gint _size_collection_size_ = 0;
		gint size_it = 0;
		size_collection = _tmp6_;
		size_collection_length1 = _tmp6__length1;
		for (size_it = 0; size_it < _tmp6__length1; size_it = size_it + 1) {
			gchar* _tmp7_ = NULL;
			gchar* size = NULL;
			_tmp7_ = g_strdup (size_collection[size_it]);
			size = _tmp7_;
			{
				gchar* filename = NULL;
				const gchar* _tmp8_ = NULL;
				gchar* _tmp9_ = NULL;
				_tmp8_ = size;
				_tmp9_ = g_build_filename (ICONS_DIR, _tmp8_, "apps", "latexila.png", NULL);
				filename = _tmp9_;
				{
					GdkPixbuf* _tmp10_ = NULL;
					const gchar* _tmp11_ = NULL;
					GdkPixbuf* _tmp12_ = NULL;
					GdkPixbuf* _tmp13_ = NULL;
					_tmp11_ = filename;
					_tmp12_ = gdk_pixbuf_new_from_file (_tmp11_, &_inner_error_);
					_tmp10_ = _tmp12_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch29_g_error;
					}
					_tmp13_ = _tmp10_;
					_tmp10_ = NULL;
					list = g_list_append (list, _tmp13_);
					_g_object_unref0 (_tmp10_);
				}
				goto __finally29;
				__catch29_g_error:
				{
					GError* e = NULL;
					GError* _tmp14_ = NULL;
					const gchar* _tmp15_ = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp14_ = e;
					_tmp15_ = _tmp14_->message;
					g_warning ("latexila_app.vala:304: Application icon: %s", _tmp15_);
					_g_error_free0 (e);
				}
				__finally29:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_free0 (filename);
					_g_free0 (size);
					__g_list_free__g_object_unref0_0 (list);
					sizes = (_vala_array_free (sizes, sizes_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_g_free0 (filename);
				_g_free0 (size);
			}
		}
	}
	_tmp16_ = list;
	list = NULL;
	gtk_window_set_default_icon_list (_tmp16_);
	__g_list_free__g_object_unref0_0 (list);
	sizes = (_vala_array_free (sizes, sizes_length1, (GDestroyNotify) g_free), NULL);
}


static void _latexila_app_update_theme_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	latexila_app_update_theme ((LatexilaApp*) self);
}


static void latexila_app_setup_theme_extensions (LatexilaApp* self) {
	GtkSettings* settings = NULL;
	GtkSettings* _tmp0_ = NULL;
	GtkSettings* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_settings_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	settings = _tmp1_;
	g_signal_connect_object ((GObject*) settings, "notify::gtk-theme-name", (GCallback) _latexila_app_update_theme_g_object_notify, self, 0);
	latexila_app_update_theme (self);
	_g_object_unref0 (settings);
}


static void latexila_app_update_theme (LatexilaApp* self) {
	GtkSettings* settings = NULL;
	GtkSettings* _tmp0_ = NULL;
	GtkSettings* _tmp1_ = NULL;
	GdkScreen* screen = NULL;
	GdkScreen* _tmp2_ = NULL;
	GdkScreen* _tmp3_ = NULL;
	GtkSettings* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_settings_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	settings = _tmp1_;
	_tmp2_ = gdk_screen_get_default ();
	_tmp3_ = _g_object_ref0 (_tmp2_);
	screen = _tmp3_;
	_tmp4_ = settings;
	g_object_get (_tmp4_, "gtk-theme-name", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strcmp0 (_tmp7_, "Adwaita") == 0;
	_g_free0 (_tmp7_);
	if (_tmp8_) {
		GtkCssProvider* _tmp9_ = NULL;
		GdkScreen* _tmp16_ = NULL;
		GtkCssProvider* _tmp17_ = NULL;
		_tmp9_ = latexila_app__provider;
		if (_tmp9_ == NULL) {
			GtkCssProvider* _tmp10_ = NULL;
			GFile* file = NULL;
			GFile* _tmp11_ = NULL;
			_tmp10_ = gtk_css_provider_new ();
			_g_object_unref0 (latexila_app__provider);
			latexila_app__provider = _tmp10_;
			_tmp11_ = g_file_new_for_uri ("resource:///org/gnome/latexila/ui/latexila.adwaita.css");
			file = _tmp11_;
			{
				GtkCssProvider* _tmp12_ = NULL;
				GFile* _tmp13_ = NULL;
				_tmp12_ = latexila_app__provider;
				_tmp13_ = file;
				gtk_css_provider_load_from_file (_tmp12_, _tmp13_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch30_g_error;
				}
			}
			goto __finally30;
			__catch30_g_error:
			{
				GError* e = NULL;
				GError* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp14_ = e;
				_tmp15_ = _tmp14_->message;
				g_warning ("latexila_app.vala:335: Cannot load CSS: %s", _tmp15_);
				_g_error_free0 (e);
			}
			__finally30:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (file);
				_g_object_unref0 (screen);
				_g_object_unref0 (settings);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_g_object_unref0 (file);
		}
		_tmp16_ = screen;
		_tmp17_ = latexila_app__provider;
		gtk_style_context_add_provider_for_screen (_tmp16_, (GtkStyleProvider*) _tmp17_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	} else {
		GtkCssProvider* _tmp18_ = NULL;
		_tmp18_ = latexila_app__provider;
		if (_tmp18_ != NULL) {
			GdkScreen* _tmp19_ = NULL;
			GtkCssProvider* _tmp20_ = NULL;
			_tmp19_ = screen;
			_tmp20_ = latexila_app__provider;
			gtk_style_context_remove_provider_for_screen (_tmp19_, (GtkStyleProvider*) _tmp20_);
			_g_object_unref0 (latexila_app__provider);
			latexila_app__provider = NULL;
		}
	}
	_g_object_unref0 (screen);
	_g_object_unref0 (settings);
}


static void _vala_array_add5 (GFile*** array, int* length, int* size, GFile* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void latexila_app_reopen_files (LatexilaApp* self) {
	GSettings* editor_settings = NULL;
	GSettings* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.latexila.preferences.editor");
	editor_settings = _tmp0_;
	_tmp1_ = editor_settings;
	_tmp2_ = g_settings_get_boolean (_tmp1_, "reopen-files");
	if (_tmp2_) {
		GSettings* window_settings = NULL;
		GSettings* _tmp3_ = NULL;
		gchar** uris = NULL;
		GSettings* _tmp4_ = NULL;
		gchar** _tmp5_ = NULL;
		gchar** _tmp6_ = NULL;
		gint uris_length1 = 0;
		gint _uris_size_ = 0;
		GFile** files = NULL;
		GFile** _tmp7_ = NULL;
		gint files_length1 = 0;
		gint _files_size_ = 0;
		gchar** _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
		GFile** _tmp16_ = NULL;
		gint _tmp16__length1 = 0;
		_tmp3_ = g_settings_new ("org.gnome.latexila.state.window");
		window_settings = _tmp3_;
		_tmp4_ = window_settings;
		_tmp6_ = _tmp5_ = g_settings_get_strv (_tmp4_, "documents");
		uris = _tmp6_;
		uris_length1 = _vala_array_length (_tmp5_);
		_uris_size_ = uris_length1;
		_tmp7_ = g_new0 (GFile*, 0 + 1);
		files = _tmp7_;
		files_length1 = 0;
		_files_size_ = files_length1;
		_tmp8_ = uris;
		_tmp8__length1 = uris_length1;
		{
			gchar** uri_collection = NULL;
			gint uri_collection_length1 = 0;
			gint _uri_collection_size_ = 0;
			gint uri_it = 0;
			uri_collection = _tmp8_;
			uri_collection_length1 = _tmp8__length1;
			for (uri_it = 0; uri_it < _tmp8__length1; uri_it = uri_it + 1) {
				gchar* _tmp9_ = NULL;
				gchar* uri = NULL;
				_tmp9_ = g_strdup (uri_collection[uri_it]);
				uri = _tmp9_;
				{
					const gchar* _tmp10_ = NULL;
					gint _tmp11_ = 0;
					gint _tmp12_ = 0;
					_tmp10_ = uri;
					_tmp11_ = strlen (_tmp10_);
					_tmp12_ = _tmp11_;
					if (0 < _tmp12_) {
						GFile** _tmp13_ = NULL;
						gint _tmp13__length1 = 0;
						const gchar* _tmp14_ = NULL;
						GFile* _tmp15_ = NULL;
						_tmp13_ = files;
						_tmp13__length1 = files_length1;
						_tmp14_ = uri;
						_tmp15_ = g_file_new_for_uri (_tmp14_);
						_vala_array_add5 (&files, &files_length1, &_files_size_, _tmp15_);
					}
					_g_free0 (uri);
				}
			}
		}
		_tmp16_ = files;
		_tmp16__length1 = files_length1;
		latexila_app_open_documents (self, _tmp16_, _tmp16__length1);
		files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
		uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (window_settings);
	}
	_g_object_unref0 (editor_settings);
}


GeeList* latexila_app_get_documents (LatexilaApp* self) {
	GeeList* result = NULL;
	GeeList* all_documents = NULL;
	GeeLinkedList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_linked_list_new (TYPE_DOCUMENT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	all_documents = (GeeList*) _tmp0_;
	_tmp1_ = gtk_application_get_windows ((GtkApplication*) self);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp1_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			GtkWindow* _tmp2_ = NULL;
			GtkWindow* window = NULL;
			_tmp2_ = _g_object_ref0 ((GtkWindow*) window_it->data);
			window = _tmp2_;
			{
				GtkWindow* _tmp3_ = NULL;
				_tmp3_ = window;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_MAIN_WINDOW)) {
					MainWindow* main_window = NULL;
					GtkWindow* _tmp4_ = NULL;
					MainWindow* _tmp5_ = NULL;
					GeeList* _tmp6_ = NULL;
					MainWindow* _tmp7_ = NULL;
					GeeList* _tmp8_ = NULL;
					GeeList* _tmp9_ = NULL;
					_tmp4_ = window;
					_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, TYPE_MAIN_WINDOW) ? ((MainWindow*) _tmp4_) : NULL);
					main_window = _tmp5_;
					_tmp6_ = all_documents;
					_tmp7_ = main_window;
					_tmp8_ = main_window_get_documents (_tmp7_);
					_tmp9_ = _tmp8_;
					gee_collection_add_all ((GeeCollection*) _tmp6_, (GeeCollection*) _tmp9_);
					_g_object_unref0 (_tmp9_);
					_g_object_unref0 (main_window);
				}
				_g_object_unref0 (window);
			}
		}
	}
	result = all_documents;
	return result;
}


GeeList* latexila_app_get_views (LatexilaApp* self) {
	GeeList* result = NULL;
	GeeList* all_views = NULL;
	GeeLinkedList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_linked_list_new (TYPE_DOCUMENT_VIEW, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	all_views = (GeeList*) _tmp0_;
	_tmp1_ = gtk_application_get_windows ((GtkApplication*) self);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp1_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			GtkWindow* _tmp2_ = NULL;
			GtkWindow* window = NULL;
			_tmp2_ = _g_object_ref0 ((GtkWindow*) window_it->data);
			window = _tmp2_;
			{
				GtkWindow* _tmp3_ = NULL;
				_tmp3_ = window;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_MAIN_WINDOW)) {
					MainWindow* main_window = NULL;
					GtkWindow* _tmp4_ = NULL;
					MainWindow* _tmp5_ = NULL;
					GeeList* _tmp6_ = NULL;
					MainWindow* _tmp7_ = NULL;
					GeeList* _tmp8_ = NULL;
					GeeList* _tmp9_ = NULL;
					_tmp4_ = window;
					_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, TYPE_MAIN_WINDOW) ? ((MainWindow*) _tmp4_) : NULL);
					main_window = _tmp5_;
					_tmp6_ = all_views;
					_tmp7_ = main_window;
					_tmp8_ = main_window_get_views (_tmp7_);
					_tmp9_ = _tmp8_;
					gee_collection_add_all ((GeeCollection*) _tmp6_, (GeeCollection*) _tmp9_);
					_g_object_unref0 (_tmp9_);
					_g_object_unref0 (main_window);
				}
				_g_object_unref0 (window);
			}
		}
	}
	result = all_views;
	return result;
}


MainWindow* latexila_app_create_window (LatexilaApp* self) {
	MainWindow* result = NULL;
	MainWindow* main_window = NULL;
	MainWindow* _tmp0_ = NULL;
	MainWindow* _tmp1_ = NULL;
	MainWindow* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = latexila_app_get_active_main_window (self);
	main_window = _tmp0_;
	_tmp1_ = main_window;
	if (_tmp1_ != NULL) {
		MainWindow* _tmp2_ = NULL;
		_tmp2_ = main_window;
		main_window_save_state (_tmp2_);
	}
	_tmp3_ = main_window_new (self);
	g_object_ref_sink (_tmp3_);
	result = _tmp3_;
	_g_object_unref0 (main_window);
	return result;
}


void latexila_app_open_documents (LatexilaApp* self, GFile** files, int files_length1) {
	gboolean _tmp0_ = FALSE;
	MainWindow* main_window = NULL;
	MainWindow* _tmp1_ = NULL;
	MainWindow* _tmp2_ = NULL;
	gboolean jump_to = FALSE;
	GFile** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	MainWindow* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_activate_called;
	if (!_tmp0_) {
		g_application_activate ((GApplication*) self);
	}
	_tmp1_ = latexila_app_get_active_main_window (self);
	main_window = _tmp1_;
	_tmp2_ = main_window;
	g_return_if_fail (_tmp2_ != NULL);
	jump_to = TRUE;
	_tmp3_ = files;
	_tmp3__length1 = files_length1;
	{
		GFile** file_collection = NULL;
		gint file_collection_length1 = 0;
		gint _file_collection_size_ = 0;
		gint file_it = 0;
		file_collection = _tmp3_;
		file_collection_length1 = _tmp3__length1;
		for (file_it = 0; file_it < _tmp3__length1; file_it = file_it + 1) {
			GFile* _tmp4_ = NULL;
			GFile* file = NULL;
			_tmp4_ = _g_object_ref0 (file_collection[file_it]);
			file = _tmp4_;
			{
				MainWindow* _tmp5_ = NULL;
				GFile* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				DocumentTab* _tmp8_ = NULL;
				DocumentTab* _tmp9_ = NULL;
				_tmp5_ = main_window;
				_tmp6_ = file;
				_tmp7_ = jump_to;
				_tmp8_ = main_window_open_document (_tmp5_, _tmp6_, _tmp7_);
				_tmp9_ = _tmp8_;
				_g_object_unref0 (_tmp9_);
				jump_to = FALSE;
				_g_object_unref0 (file);
			}
		}
	}
	_tmp10_ = main_window;
	gtk_window_present ((GtkWindow*) _tmp10_);
	_g_object_unref0 (main_window);
}


static gchar* latexila_app_get_accel_filename (LatexilaApp* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "latexila", "accels", NULL);
	result = _tmp1_;
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void __lambda131_ (LatexilaApp* self, const gchar* tex_uri, gint line, guint timestamp) {
	GFile* tex_file = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	MainWindow* main_window = NULL;
	MainWindow* _tmp8_ = NULL;
	MainWindow* _tmp9_ = NULL;
	g_return_if_fail (tex_uri != NULL);
	_tmp0_ = tex_uri;
	_tmp1_ = g_file_new_for_uri (_tmp0_);
	tex_file = _tmp1_;
	_tmp2_ = tex_file;
	_tmp3_ = g_file_query_exists (_tmp2_, NULL);
	if (!_tmp3_) {
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		_tmp4_ = tex_uri;
		_tmp5_ = string_to_string (_tmp4_);
		_tmp6_ = g_strconcat ("Backward search: the file \"", _tmp5_, "\" doesn't exist.", NULL);
		_tmp7_ = _tmp6_;
		g_warning ("latexila_app.vala:445: %s", _tmp7_);
		_g_free0 (_tmp7_);
		_g_object_unref0 (tex_file);
		return;
	}
	_tmp8_ = latexila_app_get_active_main_window (self);
	main_window = _tmp8_;
	_tmp9_ = main_window;
	if (_tmp9_ != NULL) {
		MainWindow* _tmp10_ = NULL;
		GFile* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		MainWindow* _tmp14_ = NULL;
		guint _tmp15_ = 0U;
		_tmp10_ = main_window;
		_tmp11_ = tex_file;
		_tmp12_ = line;
		_tmp13_ = line;
		main_window_jump_to_file_position (_tmp10_, _tmp11_, _tmp12_, _tmp13_ + 1);
		_tmp14_ = main_window;
		_tmp15_ = timestamp;
		gtk_window_present_with_time ((GtkWindow*) _tmp14_, (guint32) _tmp15_);
	}
	_g_object_unref0 (main_window);
	_g_object_unref0 (tex_file);
}


static void ___lambda131__latexila_synctex_backward_search (LatexilaSynctex* _sender, const gchar* tex_uri, gint line, guint timestamp, gpointer self) {
	__lambda131_ ((LatexilaApp*) self, tex_uri, line, timestamp);
}


static void latexila_app_support_backward_search (LatexilaApp* self) {
	LatexilaSynctex* synctex = NULL;
	LatexilaSynctex* _tmp0_ = NULL;
	LatexilaSynctex* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = latexila_synctex_get_instance ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	synctex = _tmp1_;
	g_signal_connect_object (synctex, "backward-search", (GCallback) ___lambda131__latexila_synctex_backward_search, self, 0);
	_g_object_unref0 (synctex);
}


static void latexila_app_class_init (LatexilaAppClass * klass) {
	latexila_app_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (LatexilaAppPrivate));
	G_OBJECT_CLASS (klass)->finalize = latexila_app_finalize;
}


static void latexila_app_instance_init (LatexilaApp * self) {
	self->priv = LATEXILA_APP_GET_PRIVATE (self);
	self->priv->_activate_called = FALSE;
}


static void latexila_app_finalize (GObject* obj) {
	LatexilaApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LATEXILA_APP, LatexilaApp);
	G_OBJECT_CLASS (latexila_app_parent_class)->finalize (obj);
}


GType latexila_app_get_type (void) {
	static volatile gsize latexila_app_type_id__volatile = 0;
	if (g_once_init_enter (&latexila_app_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LatexilaAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) latexila_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LatexilaApp), 0, (GInstanceInitFunc) latexila_app_instance_init, NULL };
		GType latexila_app_type_id;
		latexila_app_type_id = g_type_register_static (gtk_application_get_type (), "LatexilaApp", &g_define_type_info, 0);
		g_once_init_leave (&latexila_app_type_id__volatile, latexila_app_type_id);
	}
	return latexila_app_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



